## Towards an Alphabet of Human Thought 
![image title](https://img.shields.io/badge/python-v3.6-green.svg) ![image title](https://img.shields.io/badge/ntlk-v3.2.5-yellow.svg) ![Image title](https://img.shields.io/badge/sklearn-0.19.1-orange.svg) ![Image title](https://img.shields.io/badge/matplotlib-v2.1.2-orange.svg)

<br>
<br>
<p align="center">
  <img src="images/leibniz.jpg" 
       width="200">
</p>
<br>

<p align="center">
  <a href="#d"> Definition </a> •
  <a href="#pm"> Personal Motivation </a>  •
  <a href="#nd"> Notebooks and descriptions </a> •
  <a href="#ci"> Contact Information </a> 
</p>

<a id = 'd'></a>
## Definition

The alphabet of human thought "is a concept originally proposed by Gottfried Leibniz that provides a universal way to represent and analyze ideas and relationships by breaking down their component pieces. All ideas are compounded from a very small number of simple ideas which can be represented by a unique character" (definition from [Ref.1](https://en.wikipedia.org/wiki/Alphabet_of_human_thought)).

Leibniz project included:

> - The identification of a system of primitives, organized in an alphabet of thought or in a general encyclopedia;
> - The elaboration of an ideal grammar, inspired probably by the simplifications proposed by Dalgarno, of which the simplified Latin is one example;
> The formulation of a series of rules governing the possible pronunciation of the characters;
> The elaboration of a lexicon of real characters upon which the speaker might perform calculations that would automatically lead to the formulation of true propositions.

<a id = 'pm'></a>
## Personal Motivation

I am fascinated by the idea of systematizing and analyzing massive stores of human knowledge to build a hierarchical classification. My interest in the topic is far from recent and started when I first came into contact with Aristotle's [Porphyrian tree](https://en.wikipedia.org/wiki/Porphyrian_tree) and Leibniz's writings on knowledge systematization and formalization (his *characteristica universalis*). I am fascinated by his idea of constructing an overarching architecture to make human knowledge computational. 

<p align="center">
<img src="https://github.com/marcotav/natural-language-processing/blob/master/images/linguistics-and-reality-640x300.png" width="350"/>   
</p>


<a id = 'nd'></a>
## Notebooks and descriptions


| Notebook | Brief Description |
|--------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [meaning-of-sentences](http://nbviewer.jupyter.org/github/marcotav/natural-language-processing/blob/master/alphabet-human-thought/meaning-NLU-logic/notebooks/meaning-of-sentences.ipynb) | In this notebook, it will be shown that using logic formalisms one can find more generic translation mechanisms (in progress)  |
| [sentence-structure](http://nbviewer.jupyter.org/github/marcotav/natural-language-processing/blob/master/alphabet-human-thought/sentence-structure/notebooks/sentence-structure.ipynb) | We will show how to develop formal models for patterns in sequence of words using grammars and parsers (in progress)|

<a id = 'ci'></a>
## Contact Information


Feel free to contact me:

* Email: [marcotav65@gmail.com](mailto:marcotav65@gmail.com)
* GitHub: [marcotav](https://github.com/marcotav)
* LinkedIn: [marco-tavora](https://www.linkedin.com/in/marco-tavora)
* Website: [marcotavora.me](http://www.marcotavora.me)


