# DallENet assembly

## DallENet namespace

| public type | description |
| --- | --- |
| class [DallEBuilder](./DallENet/DallEBuilder.md) |  |
| class [DallEOptions](./DallENet/DallEOptions.md) | Options class that provides settings for configuring DALL·E. |
| class [DallEOptionsBuilder](./DallENet/DallEOptionsBuilder.md) | Builder class to define settings for configuring DALL·E. |
| static class [DallEOptionsBuilderExtensions](./DallENet/DallEOptionsBuilderExtensions.md) | Provides extensions to configure settings for accessing DALL·E service. |
| static class [DallEServiceCollectionExtensions](./DallENet/DallEServiceCollectionExtensions.md) | Provides extension methods for adding DALL·E support in .NET applications. |
| interface [IDallEBuilder](./DallENet/IDallEBuilder.md) | Represents a builder for configuring DALL·E. |
| interface [IDallEClient](./DallENet/IDallEClient.md) | Provides methods to interact with DALL·E. |

## DallENet.Exceptions namespace

| public type | description |
| --- | --- |
| class [DallEException](./DallENet.Exceptions/DallEException.md) | Represents errors that occur during API invocation. |

## DallENet.Extensions namespace

| public type | description |
| --- | --- |
| static class [DallEImageGenerationResponseExtensions](./DallENet.Extensions/DallEImageGenerationResponseExtensions.md) | Provides extension methods for the [`DallEImageGenerationResponse`](./DallENet.Models/DallEImageGenerationResponse.md) class. |

## DallENet.Models namespace

| public type | description |
| --- | --- |
| class [DallEError](./DallENet.Models/DallEError.md) | Contains information about the error occurred while invoking the service. |
| class [DallEImage](./DallENet.Models/DallEImage.md) | Represents an image. |
| class [DallEImageGenerationResponse](./DallENet.Models/DallEImageGenerationResponse.md) | Represents an image generation respose. |
| static class [DallEImageQualities](./DallENet.Models/DallEImageQualities.md) | Contains all the image qualities supported by DALL·E. |
| static class [DallEImageResponseFormats](./DallENet.Models/DallEImageResponseFormats.md) | Contains all the image response formats supported by DALL·E. |
| static class [DallEImageSizes](./DallENet.Models/DallEImageSizes.md) | Contains all the image sizes supported by DALL·E. |
| static class [DallEImageStyles](./DallENet.Models/DallEImageStyles.md) | Contains all the image styles supported by DALL·E. |

## DallENet.ServiceConfigurations namespace

| public type | description |
| --- | --- |
| enum [AzureAuthenticationType](./DallENet.ServiceConfigurations/AzureAuthenticationType.md) | Enumerates the available Azure authentication types for OpenAI service. |

<!-- DO NOT EDIT: generated by xmldocmd for DallENet.dll -->
