# IDallEClient.GetImageStreamAsync method

Requests a new image generation and directly returns the Stream containing the image.

```csharp
public Task<Stream> GetImageStreamAsync(string prompt, string? size = null, string? quality = null, 
    string? style = null, string? model = null, CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| prompt | A text description of the desired image(s). The maximum length is 4000 characters. |
| size | The size of the generated image. If `null`, the size set in the [`DefaultSize`](../DallEOptions/DefaultSize.md) property will be used (default: [`_1024x1024`](../../DallENet.Models/DallEImageSizes/_1024x1024.md)). |
| quality | The quality of the generated image. If `null`, the quality set in the [`DefaultQuality`](../DallEOptions/DefaultQuality.md) property will be used (default: [`Standard`](../../DallENet.Models/DallEImageQualities/Standard.md)). |
| style | The style of the generated image. If `null`, the style set in the [`DefaultStyle`](../DallEOptions/DefaultStyle.md) property will be used (default: [`Vivid`](../../DallENet.Models/DallEImageStyles/Vivid.md)). |
| model | The image generation model to use. If `null`, the model specified in the [`DefaultModel`](../DallEOptions/DefaultModel.md) property will be used. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The Stream containing the image

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *prompt* is `null`. |
| [DallEException](../../DallENet.Exceptions/DallEException.md) | An error occurred while calling the API. |

## Remarks

If an error occurred, this method throws a [`DallEException`](../../DallENet.Exceptions/DallEException.md) no matter the value of the [`ThrowExceptionOnError`](../DallEOptions/ThrowExceptionOnError.md) property.

## See Also

* class [DallEOptions](../DallEOptions.md)
* class [DallEException](../../DallENet.Exceptions/DallEException.md)
* interface [IDallEClient](../IDallEClient.md)
* namespace [DallENet](../../DallENet.md)

<!-- DO NOT EDIT: generated by xmldocmd for DallENet.dll -->
