# IDallEClient.GenerateImagesAsync method

Requests a new images generation.

```csharp
public Task<DallEImageGenerationResponse> GenerateImagesAsync(string prompt, string? size = null, 
    string? quality = null, string? style = null, string? imageResponseFormat = null, 
    string? model = null, CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| prompt | A text description of the desired image. The maximum length is 4000 characters. |
| size | The size of the generated image. If `null`, the size set in the [`DefaultSize`](../DallEOptions/DefaultSize.md) property will be used (default: [`_1024x1024`](../../DallENet.Models/DallEImageSizes/_1024x1024.md)). |
| quality | The quality of the generated image. If `null`, the quality set in the [`DefaultQuality`](../DallEOptions/DefaultQuality.md) property will be used (default: [`Standard`](../../DallENet.Models/DallEImageQualities/Standard.md)). |
| style | The style of the generated image. If `null`, the style set in the [`DefaultStyle`](../DallEOptions/DefaultStyle.md) property will be used (default: [`Vivid`](../../DallENet.Models/DallEImageStyles/Vivid.md)). |
| imageResponseFormat | The format in which the generated images are returned. If `null`, the format set in the [`DefaultResponseFormat`](../DallEOptions/DefaultResponseFormat.md) property will be used (default: [`Url`](../../DallENet.Models/DallEImageResponseFormats/Url.md)). |
| model | The image generation model to use. If `null`, the model specified in the [`DefaultModel`](../DallEOptions/DefaultModel.md) property will be used. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The image generation response.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *prompt* is `null`. |
| [DallEException](../../DallENet.Exceptions/DallEException.md) | An error occurred while calling the API and the [`ThrowExceptionOnError`](../DallEOptions/ThrowExceptionOnError.md) is `true`. |

## See Also

* class [DallEImageGenerationResponse](../../DallENet.Models/DallEImageGenerationResponse.md)
* class [DallEOptions](../DallEOptions.md)
* class [DallEException](../../DallENet.Exceptions/DallEException.md)
* interface [IDallEClient](../IDallEClient.md)
* namespace [DallENet](../../DallENet.md)

<!-- DO NOT EDIT: generated by xmldocmd for DallENet.dll -->
