# DallEServiceCollectionExtensions.AddDallE method (1 of 3)

Registers a DallEClient instance with the specified options.

```csharp
public static IDallEBuilder AddDallE(this IServiceCollection services, 
    Action<DallEOptionsBuilder> builder)
```

| parameter | description |
| --- | --- |
| services | The IServiceCollection to add services to. |
| builder | The [`DallEOptionsBuilder`](../DallEOptionsBuilder.md) to configure options. |

## Return Value

A [`IDallEBuilder`](../IDallEBuilder.md) that can be used to further customize DALL·E.

## See Also

* class [DallEOptionsBuilder](../DallEOptionsBuilder.md)
* interface [IDallEBuilder](../IDallEBuilder.md)
* class [DallEServiceCollectionExtensions](../DallEServiceCollectionExtensions.md)
* namespace [DallENet](../../DallENet.md)

---

# DallEServiceCollectionExtensions.AddDallE method (2 of 3)

Registers a DallEClient instance using dynamic options.

```csharp
public static IDallEBuilder AddDallE(this IServiceCollection services, 
    Action<IServiceProvider, DallEOptionsBuilder> builder)
```

| parameter | description |
| --- | --- |
| services | The IServiceCollection to add services to. |
| builder | The [`DallEOptionsBuilder`](../DallEOptionsBuilder.md) to configure options. |

## Return Value

A [`IDallEBuilder`](../IDallEBuilder.md) that can be used to further customize DALL·E.

## Remarks

Use this this method if it is necessary to dynamically set options (for example, using other services via dependency injection).

## See Also

* class [DallEOptions](../DallEOptions.md)
* interface [IDallEBuilder](../IDallEBuilder.md)
* class [DallEOptionsBuilder](../DallEOptionsBuilder.md)
* class [DallEServiceCollectionExtensions](../DallEServiceCollectionExtensions.md)
* namespace [DallENet](../../DallENet.md)

---

# DallEServiceCollectionExtensions.AddDallE method (3 of 3)

Registers a DallEClient instance reading configuration from the specified IConfiguration source.

```csharp
public static IDallEBuilder AddDallE(this IServiceCollection services, 
    IConfiguration configuration, string sectionName = "DallE")
```

| parameter | description |
| --- | --- |
| services | The IServiceCollection to add services to. |
| configuration | The IConfiguration being bound. |
| sectionName | The name of the configuration section that holds DALL·E settings (default: DallE). |

## Return Value

A [`IDallEBuilder`](../IDallEBuilder.md) that can be used to further customize DALL·E.

## See Also

* class [DallEOptions](../DallEOptions.md)
* interface [IDallEBuilder](../IDallEBuilder.md)
* class [DallEServiceCollectionExtensions](../DallEServiceCollectionExtensions.md)
* namespace [DallENet](../../DallENet.md)

<!-- DO NOT EDIT: generated by xmldocmd for DallENet.dll -->
