# DallEOptionsBuilderExtensions.UseAzure method

Configures Azure OpenAI Service settings.

```csharp
public static DallEOptionsBuilder UseAzure(this DallEOptionsBuilder builder, string resourceName, 
    string apiKey, string apiVersion = "2023-12-01-preview", 
    AzureAuthenticationType authenticationType = AzureAuthenticationType.ApiKey)
```

| parameter | description |
| --- | --- |
| builder | The [`DallEOptionsBuilder`](../DallEOptionsBuilder.md) object to configure. |
| resourceName | The name of the Azure OpenAI Resource. |
| apiKey | The access key to access the service. |
| apiVersion | The API version of the Azure OpenAI service |
| authenticationType | Specify if *apiKey* is an actual API Key or an Azure Active Directory token. |

## Return Value

A reference to this instance after the operation has completed.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *resourceName* or *apiKey* are `null`. |

## Remarks

See [Azure OpenAI Service Authentication](https://learn.microsoft.com/azure/cognitive-services/openai/reference#authentication) and [Authenticating with Azure Active Directory](https://learn.microsoft.com/azure/cognitive-services/openai/how-to/managed-identity) for more information about authentication.

## See Also

* class [DallEOptionsBuilder](../DallEOptionsBuilder.md)
* enum [AzureAuthenticationType](../../DallENet.ServiceConfigurations/AzureAuthenticationType.md)
* class [DallEOptionsBuilderExtensions](../DallEOptionsBuilderExtensions.md)
* namespace [DallENet](../../DallENet.md)

<!-- DO NOT EDIT: generated by xmldocmd for DallENet.dll -->
