# DallEOptionsBuilder class

Builder class to define settings for configuring DALL·E.

```csharp
public class DallEOptionsBuilder
```

## Public Members

| name | description |
| --- | --- |
| [DallEOptionsBuilder](DallEOptionsBuilder/DallEOptionsBuilder.md)() | The default constructor. |
| [DefaultModel](DallEOptionsBuilder/DefaultModel.md) { get; set; } | Gets or sets the default model for image generation. |
| [DefaultQuality](DallEOptionsBuilder/DefaultQuality.md) { get; set; } | Gets or sets the default quality of generated images (default: [`Standard`](../DallENet.Models/DallEImageQualities/Standard.md). |
| [DefaultResponseFormat](DallEOptionsBuilder/DefaultResponseFormat.md) { get; set; } | Gets or sets the default format of generated images (default: [`Url`](../DallENet.Models/DallEImageResponseFormats/Url.md). |
| [DefaultSize](DallEOptionsBuilder/DefaultSize.md) { get; set; } | Gets or sets the default resolution for image generation (default: [`_1024x1024`](../DallENet.Models/DallEImageSizes/_1024x1024.md)). |
| [DefaultStyle](DallEOptionsBuilder/DefaultStyle.md) { get; set; } | Gets or sets the default style of generated images (default: [`Vivid`](../DallENet.Models/DallEImageStyles/Vivid.md). |
| [ThrowExceptionOnError](DallEOptionsBuilder/ThrowExceptionOnError.md) { get; set; } | Gets or sets a value that determines whether to throw a [`DallEException`](../DallENet.Exceptions/DallEException.md) when an error occurred (default: `true`). If this property is set to `false`, API errors are returned in the [`DallEImageGenerationResponse`](../DallENet.Models/DallEImageGenerationResponse.md) object. |
| [User](DallEOptionsBuilder/User.md) { get; set; } | Gets or sets the user identification for chat completion, which can help OpenAI to monitor and detect abuse. |

## See Also

* namespace [DallENet](../DallENet.md)
* [DallEOptionsBuilder.cs](https://github.com/marcominerva/DallENet/tree/master/src/DallENet/DallEOptionsBuilder.cs)

<!-- DO NOT EDIT: generated by xmldocmd for DallENet.dll -->
