
#include "othercmd.hpp"

WINERROR_ENTRY stWinErrorList[] =
	{
      {0, "The operation completed successfully.", "ERROR_SUCCESS" },
      {0x1, "Incorrect function.", "ERROR_INVALID_FUNCTION" },
      {0x2, "The system cannot find the file specified.", "ERROR_FILE_NOT_FOUND" },
      {0x3, "The system cannot find the path specified.", "ERROR_PATH_NOT_FOUND" },
      {0x4, "The system cannot open the file.", "ERROR_TOO_MANY_OPEN_FILES" },
      {0x5, "Access is denied.", "ERROR_ACCESS_DENIED" },
      {0x6, "The handle is invalid.", "ERROR_INVALID_HANDLE" },
      {0x7, "The storage control blocks were destroyed.", "ERROR_ARENA_TRASHED" },
      {0x8, "Not enough storage is available to process this command.", "ERROR_NOT_ENOUGH_MEMORY" },
      {0x9, "The storage control block address is invalid.", "ERROR_INVALID_BLOCK" },
      {0xA, "The environment is incorrect.", "ERROR_BAD_ENVIRONMENT" },
      {0xB, "An attempt was made to load a program with an incorrect format.", "ERROR_BAD_FORMAT" },
      {0xC, "The access code is invalid.", "ERROR_INVALID_ACCESS" },
      {0xD, "The data is invalid.", "ERROR_INVALID_DATA" },
      {0xE, "Not enough storage is available to complete this operation.", "ERROR_OUTOFMEMORY" },
      {0xF, "The system cannot find the drive specified.", "ERROR_INVALID_DRIVE" },
      {0x10, "The directory cannot be removed.", "ERROR_CURRENT_DIRECTORY" },
      {0x11, "The system cannot move the file to a different disk drive.", "ERROR_NOT_SAME_DEVICE" },
      {0x12, "There are no more files.", "ERROR_NO_MORE_FILES" },
      {0x13, "The media is write protected.", "ERROR_WRITE_PROTECT" },
      {0x14, "The system cannot find the device specified.", "ERROR_BAD_UNIT" },
      {0x15, "The device is not ready.", "ERROR_NOT_READY" },
      {0x16, "The device does not recognize the command.", "ERROR_BAD_COMMAND" },
      {0x17, "Data error (cyclic redundancy check).", "ERROR_CRC" },
      {0x18, "The program issued a command but the command length is incorrect.", "ERROR_BAD_LENGTH" },
      {0x19, "The drive cannot locate a specific area or track on the disk.", "ERROR_SEEK" },
      {0x1A, "The specified disk or diskette cannot be accessed.", "ERROR_NOT_DOS_DISK" },
      {0x1B, "The drive cannot find the sector requested.", "ERROR_SECTOR_NOT_FOUND" },
      {0x1C, "The printer is out of paper.", "ERROR_OUT_OF_PAPER" },
      {0x1D, "The system cannot write to the specified device.", "ERROR_WRITE_FAULT" },
      {0x1E, "The system cannot read from the specified device.", "ERROR_READ_FAULT" },
      {0x1F, "A device attached to the system is not functioning.", "ERROR_GEN_FAILURE" },
      {0x20, "The process cannot access the file because it is being used by another process.", "ERROR_SHARING_VIOLATION" },
      {0x21, "The process cannot access the file because another process has locked a portion of the file.", "ERROR_LOCK_VIOLATION" },
      {0x22, "The wrong diskette is in the drive. Insert %2 (Volume Serial Number: %3) into drive %1.", "ERROR_WRONG_DISK" },
      {0x24, "Too many files opened for sharing.", "ERROR_SHARING_BUFFER_EXCEEDED" },
      {0x26, "Reached the end of the file.", "ERROR_HANDLE_EOF" },
      {0x27, "The disk is full.", "ERROR_HANDLE_DISK_FULL" },
      {0x32, "The request is not supported.", "ERROR_NOT_SUPPORTED" },
      {0x33, "Windows cannot find the network path. Verify that the network path is correct and the destination computer is not busy or turned off. If Windows still cannot find the network path, contact your network administrator.", "ERROR_REM_NOT_LIST" },
      {0x34, "You were not connected because a duplicate name exists on the network. Go to System in the Control Panel to change the computer name and try again.", "ERROR_DUP_NAME" },
      {0x35, "The network path was not found.", "ERROR_BAD_NETPATH" },
      {0x36, "The network is busy.", "ERROR_NETWORK_BUSY" },
      {0x37, "The specified network resource or device is no longer available.", "ERROR_DEV_NOT_EXIST" },
      {0x38, "The network BIOS command limit has been reached.", "ERROR_TOO_MANY_CMDS" },
      {0x39, "A network adapter hardware error occurred.", "ERROR_ADAP_HDW_ERR" },
      {0x3A, "The specified server cannot perform the requested operation.", "ERROR_BAD_NET_RESP" },
      {0x3B, "An unexpected network error occurred.", "ERROR_UNEXP_NET_ERR" },
      {0x3C, "The remote adapter is not compatible.", "ERROR_BAD_REM_ADAP" },
      {0x3D, "The printer queue is full.", "ERROR_PRINTQ_FULL" },
      {0x3E, "Space to store the file waiting to be printed is not available on the server.", "ERROR_NO_SPOOL_SPACE" },
      {0x3F, "Your file waiting to be printed was deleted.", "ERROR_PRINT_CANCELLED" },
      {0x40, "The specified network name is no longer available.", "ERROR_NETNAME_DELETED" },
      {0x41, "Network access is denied.", "ERROR_NETWORK_ACCESS_DENIED" },
      {0x42, "The network resource type is not correct.", "ERROR_BAD_DEV_TYPE" },
      {0x43, "The network name cannot be found.", "ERROR_BAD_NET_NAME" },
      {0x44, "The name limit for the local computer network adapter card was exceeded.", "ERROR_TOO_MANY_NAMES" },
      {0x45, "The network BIOS session limit was exceeded.", "ERROR_TOO_MANY_SESS" },
      {0x46, "The remote server has been paused or is in the process of being started.", "ERROR_SHARING_PAUSED" },
      {0x47, "No more connections can be made to this remote computer at this time because there are already as many connections as the computer can accept.", "ERROR_REQ_NOT_ACCEP" },
      {0x48, "The specified printer or disk device has been paused.", "ERROR_REDIR_PAUSED" },
      {0x50, "The file exists.", "ERROR_FILE_EXISTS" },
      {0x52, "The directory or file cannot be created.", "ERROR_CANNOT_MAKE" },
      {0x53, "Fail on INT 24.", "ERROR_FAIL_I24" },
      {0x54, "Storage to process this request is not available.", "ERROR_OUT_OF_STRUCTURES" },
      {0x55, "The local device name is already in use.", "ERROR_ALREADY_ASSIGNED" },
      {0x56, "The specified network password is not correct.", "ERROR_INVALID_PASSWORD" },
      {0x57, "The parameter is incorrect.", "ERROR_INVALID_PARAMETER" },
      {0x58, "A write fault occurred on the network.", "ERROR_NET_WRITE_FAULT" },
      {0x59, "The system cannot start another process at this time.", "ERROR_NO_PROC_SLOTS" },
      {0x64, "Cannot create another system semaphore.", "ERROR_TOO_MANY_SEMAPHORES" },
      {0x65, "The exclusive semaphore is owned by another process.", "ERROR_EXCL_SEM_ALREADY_OWNED" },
      {0x66, "The semaphore is set and cannot be closed.", "ERROR_SEM_IS_SET" },
      {0x67, "The semaphore cannot be set again.", "ERROR_TOO_MANY_SEM_REQUESTS" },
      {0x68, "Cannot request exclusive semaphores at interrupt time.", "ERROR_INVALID_AT_INTERRUPT_TIME" },
      {0x69, "The previous ownership of this semaphore has ended.", "ERROR_SEM_OWNER_DIED" },
      {0x6A, "Insert the diskette for drive %1.", "ERROR_SEM_USER_LIMIT" },
      {0x6B, "The program stopped because an alternate diskette was not inserted.", "ERROR_DISK_CHANGE" },
      {0x6C, "The disk is in use or locked by another process.", "ERROR_DRIVE_LOCKED" },
      {0x6D, "The pipe has been ended.", "ERROR_BROKEN_PIPE" },
      {0x6E, "The system cannot open the device or file specified.", "ERROR_OPEN_FAILED" },
      {0x6F, "The file name is too long.", "ERROR_BUFFER_OVERFLOW" },
      {0x70, "There is not enough space on the disk.", "ERROR_DISK_FULL" },
      {0x71, "No more internal file identifiers available.", "ERROR_NO_MORE_SEARCH_HANDLES" },
      {0x72, "The target internal file identifier is incorrect.", "ERROR_INVALID_TARGET_HANDLE" },
      {0x75, "The IOCTL call made by the application program is not correct.", "ERROR_INVALID_CATEGORY" },
      {0x76, "The verify-on-write switch parameter value is not correct.", "ERROR_INVALID_VERIFY_SWITCH" },
      {0x77, "The system does not support the command requested.", "ERROR_BAD_DRIVER_LEVEL" },
      {0x78, "This function is not supported on this system.", "ERROR_CALL_NOT_IMPLEMENTED" },
      {0x79, "The semaphore timeout period has expired.", "ERROR_SEM_TIMEOUT" },
      {0x7A, "The data area passed to a system call is too small.", "ERROR_INSUFFICIENT_BUFFER" },
      {0x7B, "The filename, directory name, or volume label syntax is incorrect.", "ERROR_INVALID_NAME" },
      {0x7C, "The system call level is not correct.", "ERROR_INVALID_LEVEL" },
      {0x7D, "The disk has no volume label.", "ERROR_NO_VOLUME_LABEL" },
      {0x7E, "The specified module could not be found.", "ERROR_MOD_NOT_FOUND" },
      {0x7F, "The specified procedure could not be found.", "ERROR_PROC_NOT_FOUND" },
      {0x80, "There are no child processes to wait for.", "ERROR_WAIT_NO_CHILDREN" },
      {0x81, "The %1 application cannot be run in Win32 mode.", "ERROR_CHILD_NOT_COMPLETE" },
      {0x82, "Attempt to use a file handle to an open disk partition for an operation other than raw disk I/O.", "ERROR_DIRECT_ACCESS_HANDLE" },
      {0x83, "An attempt was made to move the file pointer before the beginning of the file.", "ERROR_NEGATIVE_SEEK" },
      {0x84, "The file pointer cannot be set on the specified device or file.", "ERROR_SEEK_ON_DEVICE" },
      {0x85, "A JOIN or SUBST command cannot be used for a drive that contains previously joined drives.", "ERROR_IS_JOIN_TARGET" },
      {0x86, "An attempt was made to use a JOIN or SUBST command on a drive that has already been joined.", "ERROR_IS_JOINED" },
      {0x87, "An attempt was made to use a JOIN or SUBST command on a drive that has already been substituted.", "ERROR_IS_SUBSTED" },
      {0x88, "The system tried to delete the JOIN of a drive that is not joined.", "ERROR_NOT_JOINED" },
      {0x89, "The system tried to delete the substitution of a drive that is not substituted.", "ERROR_NOT_SUBSTED" },
      {0x8A, "The system tried to join a drive to a directory on a joined drive.", "ERROR_JOIN_TO_JOIN" },
      {0x8B, "The system tried to substitute a drive to a directory on a substituted drive.", "ERROR_SUBST_TO_SUBST" },
      {0x8C, "The system tried to join a drive to a directory on a substituted drive.", "ERROR_JOIN_TO_SUBST" },
      {0x8D, "The system tried to SUBST a drive to a directory on a joined drive.", "ERROR_SUBST_TO_JOIN" },
      {0x8E, "The system cannot perform a JOIN or SUBST at this time.", "ERROR_BUSY_DRIVE" },
      {0x8F, "The system cannot join or substitute a drive to or for a directory on the same drive.", "ERROR_SAME_DRIVE" },
      {0x90, "The directory is not a subdirectory of the root directory.", "ERROR_DIR_NOT_ROOT" },
      {0x91, "The directory is not empty.", "ERROR_DIR_NOT_EMPTY" },
      {0x92, "The path specified is being used in a substitute.", "ERROR_IS_SUBST_PATH" },
      {0x93, "Not enough resources are available to process this command.", "ERROR_IS_JOIN_PATH" },
      {0x94, "The path specified cannot be used at this time.", "ERROR_PATH_BUSY" },
      {0x95, "An attempt was made to join or substitute a drive for which a directory on the drive is the target of a previous substitute.", "ERROR_IS_SUBST_TARGET" },
      {0x96, "System trace information was not specified in your CONFIG.SYS file, or tracing is disallowed.", "ERROR_SYSTEM_TRACE" },
      {0x97, "The number of specified semaphore events for DosMuxSemWait is not correct.", "ERROR_INVALID_EVENT_COUNT" },
      {0x98, "DosMuxSemWait did not execute; too many semaphores are already set.", "ERROR_TOO_MANY_MUXWAITERS" },
      {0x99, "The DosMuxSemWait list is not correct.", "ERROR_INVALID_LIST_FORMAT" },
      {0x9A, "The volume label you entered exceeds the label character limit of the target file system.", "ERROR_LABEL_TOO_LONG" },
      {0x9B, "Cannot create another thread.", "ERROR_TOO_MANY_TCBS" },
      {0x9C, "The recipient process has refused the signal.", "ERROR_SIGNAL_REFUSED" },
      {0x9D, "The segment is already discarded and cannot be locked.", "ERROR_DISCARDED" },
      {0x9E, "The segment is already unlocked.", "ERROR_NOT_LOCKED" },
      {0x9F, "The address for the thread ID is not correct.", "ERROR_BAD_THREADID_ADDR" },
      {0xA0, "The argument string passed to DosExecPgm is not correct.", "ERROR_BAD_ARGUMENTS" },
      {0xA1, "The specified path is invalid.", "ERROR_BAD_PATHNAME" },
      {0xA2, "A signal is already pending.", "ERROR_SIGNAL_PENDING" },
      {0xA4, "No more threads can be created in the system.", "ERROR_MAX_THRDS_REACHED" },
      {0xA7, "Unable to lock a region of a file.", "ERROR_LOCK_FAILED" },
      {0xAA, "The requested resource is in use.", "ERROR_BUSY" },
      {0xAD, "A lock request was not outstanding for the supplied cancel region.", "ERROR_CANCEL_VIOLATION" },
      {0xAE, "The file system does not support atomic changes to the lock type.", "ERROR_ATOMIC_LOCKS_NOT_SUPPORTED" },
      {0xB4, "The system detected a segment number that was not correct.", "ERROR_INVALID_SEGMENT_NUMBER" },
      {0xB6, "The operating system cannot run %1.", "ERROR_INVALID_ORDINAL" },
      {0xB7, "Cannot create a file when that file already exists.", "ERROR_ALREADY_EXISTS" },
      {0xBA, "The flag passed is not correct.", "ERROR_INVALID_FLAG_NUMBER" },
      {0xBB, "The specified system semaphore name was not found.", "ERROR_SEM_NOT_FOUND" },
      {0xBC, "The operating system cannot run %1.", "ERROR_INVALID_STARTING_CODESEG" },
      {0xBD, "The operating system cannot run %1.", "ERROR_INVALID_STACKSEG" },
      {0xBE, "The operating system cannot run %1.", "ERROR_INVALID_MODULETYPE" },
      {0xBF, "Cannot run %1 in Win32 mode.", "ERROR_INVALID_EXE_SIGNATURE" },
      {0xC0, "The operating system cannot run %1.", "ERROR_EXE_MARKED_INVALID" },
      {0xC1, "%1 is not a valid Win32 application.", "ERROR_BAD_EXE_FORMAT" },
      {0xC2, "The operating system cannot run %1.", "ERROR_ITERATED_DATA_EXCEEDS_64k" },
      {0xC3, "The operating system cannot run %1.", "ERROR_INVALID_MINALLOCSIZE" },
      {0xC4, "The operating system cannot run this application program.", "ERROR_DYNLINK_FROM_INVALID_RING" },
      {0xC5, "The operating system is not presently configured to run this application.", "ERROR_IOPL_NOT_ENABLED" },
      {0xC6, "The operating system cannot run %1.", "ERROR_INVALID_SEGDPL" },
      {0xC7, "The operating system cannot run this application program.", "ERROR_AUTODATASEG_EXCEEDS_64k" },
      {0xC8, "The code segment cannot be greater than or equal to 64K.", "ERROR_RING2SEG_MUST_BE_MOVABLE" },
      {0xC9, "The operating system cannot run %1.", "ERROR_RELOC_CHAIN_XEEDS_SEGLIM" },
      {0xCA, "The operating system cannot run %1.", "ERROR_INFLOOP_IN_RELOC_CHAIN" },
      {0xCB, "The system could not find the environment option that was entered.", "ERROR_ENVVAR_NOT_FOUND" },
      {0xCD, "No process in the command subtree has a signal handler.", "ERROR_NO_SIGNAL_SENT" },
      {0xCE, "The filename or extension is too long.", "ERROR_FILENAME_EXCED_RANGE" },
      {0xCF, "The ring 2 stack is in use.", "ERROR_RING2_STACK_IN_USE" },
      {0xD0, "The global filename characters, * or ?, are entered incorrectly or too many global filename characters are specified.", "ERROR_META_EXPANSION_TOO_LONG" },
      {0xD1, "The signal being posted is not correct.", "ERROR_INVALID_SIGNAL_NUMBER" },
      {0xD2, "The signal handler cannot be set.", "ERROR_THREAD_1_INACTIVE" },
      {0xD4, "The segment is locked and cannot be reallocated.", "ERROR_LOCKED" },
      {0xD6, "Too many dynamic-link modules are attached to this program or dynamic-link module.", "ERROR_TOO_MANY_MODULES" },
      {0xD7, "Cannot nest calls to LoadModule.", "ERROR_NESTING_NOT_ALLOWED" },
      {0xD8, "The image file %1 is valid, but is for a machine type other than the current machine.", "ERROR_EXE_MACHINE_TYPE_MISMATCH" },
      {0xD9, "The image file %1 is signed, unable to modify.", "ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY" },
      {0xDA, "The image file %1 is strong signed, unable to modify.", "ERRO_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY" },
      {0xE6, "The pipe state is invalid.", "ERROR_BAD_PIPE" },
      {0xE7, "All pipe instances are busy.", "ERROR_PIPE_BUSY" },
      {0xE8, "The pipe is being closed.", "ERROR_NO_DATA" },
      {0xE9, "No process is on the other end of the pipe.", "ERROR_PIPE_NOT_CONNECTED" },
      {0xEA, "More data is available.", "ERROR_MORE_DATA" },
      {0xF0, "The session was canceled.", "ERROR_VC_DISCONNECTED" },
      {0xFE, "The specified extended attribute name was invalid.", "ERROR_INVALID_EA_NAME" },
      {0xFF, "The extended attributes are inconsistent.", "ERROR_EA_LIST_INCONSISTENT" },
      {0x102, "The wait operation timed out.", "WAIT_TIMEOUT" },
      {0x103, "No more data is available.", "ERROR_NO_MORE_ITEMS" },
      {0x10A, "The copy functions cannot be used.", "ERROR_CANNOT_COPY" },
      {0x10B, "The directory name is invalid.", "ERROR_DIRECTORY" },
      {0x113, "The extended attributes did not fit in the buffer.", "ERROR_EAS_DIDNT_FIT" },
      {0x114, "The extended attribute file on the mounted file system is corrupt.", "ERROR_EA_FILE_CORRUPT" },
      {0x115, "The extended attribute table file is full.", "ERROR_EA_TABLE_FULL" },
      {0x116, "The specified extended attribute handle is invalid.", "ERROR_INVALID_EA_HANDLE" },
      {0x11A, "The mounted file system does not support extended attributes.", "ERROR_EAS_NOT_SUPPORTED" },
      {0x120, "Attempt to release mutex not owned by caller.", "ERROR_NOT_OWNER" },
      {0x12A, "Too many posts were made to a semaphore.", "ERROR_TOO_MANY_POSTS" },
      {0x12B, "Only part of a ReadProcessMemory or WriteProcessMemory request was completed.", "ERROR_PARTIAL_COPY" },
      {0x12C, "The oplock request is denied.", "ERROR_OPLOCK_NOT_GRANTED" },
      {0x12D, "An invalid oplock acknowledgment was received by the system.", "ERROR_INVALID_OPLOCK_PROTOCOL" },
      {0x12E, "The volume is too fragmented to complete this operation.", "ERROR_DISK_TOO_FRAGMENTED" },
      {0x12F, "The file cannot be opened because it is in the process of being deleted.", "ERROR_DELETE_PENDING" },
      {0x13D, "The system cannot find message text for message number 0x%1 in the message file for %2.", "ERROR_MR_MID_NOT_FOUND" },
      {0x13E, "The scope specified was not found.", "ERROR_SCOPE_NOT_FOUND" },
      {0x1E7, "Attempt to access invalid address.", "ERROR_INVALID_ADDRESS" },
      {0x216, "Arithmetic result exceeded 32 bits.", "ERROR_ARITHMETIC_OVERFLOW" },
      {0x217, "There is a process on other end of the pipe.", "ERROR_PIPE_CONNECTED" },
      {0x218, "Waiting for a process to open the other end of the pipe.", "ERROR_PIPE_LISTENING" },
      {0x219, "An error occurred in the ACPI subsystem.", "ERROR_ACPI_ERROR" },
      {0x21A, "An error occurred in the ABIOS subsystem", "ERROR_ABIOS_ERROR" },
      {0x21B, "A warning occurred in the WX86 subsystem.", "ERROR_WX86_WARNING" },
      {0x21C, "An error occurred in the WX86 subsystem.", "ERROR_WX86_ERROR" },
      {0x21D, "An attempt was made to cancel or set a timer that has an associated APC and the subject thread is not the thread that originally set the timer with an associated APC routine.", "ERROR_TIMER_NOT_CANCELED" },
      {0x21E, "Unwind exception code.", "ERROR_UNWIND" },
      {0x21F, "An invalid or unaligned stack was encountered during an unwind operation.", "ERROR_BAD_STACK" },
      {0x220, "An invalid unwind target was encountered during an unwind operation.", "ERROR_INVALID_UNWIND_TARGET" },
      {0x221, "Invalid Object Attributes specified to NtCreatePort or invalid Port Attributes specified to NtConnectPort", "ERROR_INVALID_PORT_ATTRIBUTES" },
      {0x222, "Length of message passed to NtRequestPort or NtRequestWaitReplyPort was longer than the maximum message allowed by the port.", "ERROR_PORT_MESSAGE_TOO_LONG" },
      {0x223, "An attempt was made to lower a quota limit below the current usage.", "ERROR_INVALID_QUOTA_LOWER" },
      {0x224, "An attempt was made to attach to a device that was already attached to another device.", "ERROR_DEVICE_ALREADY_ATTACHED" },
      {0x225, "An attempt was made to execute an instruction at an unaligned address and the host system does not support unaligned instruction references.", "ERROR_INSTRUCTION_MISALIGNMENT" },
      {0x226, "Profiling not started.", "ERROR_PROFILING_NOT_STARTED" },
      {0x227, "Profiling not stopped.", "ERROR_PROFILING_NOT_STOPPED" },
      {0x228, "The passed ACL did not contain the minimum required information.", "ERROR_COULD_NOT_INTERPRET" },
      {0x229, "The number of active profiling objects is at the maximum and no more may be started.", "ERROR_PROFILING_AT_LIMIT" },
      {0x22A, "Used to indicate that an operation cannot continue without blocking for I/O.", "ERROR_CANT_WAIT" },
      {0x22B, "Indicates that a thread attempted to terminate itself by default (called NtTerminateThread with NULL) and it was the last thread in the current process.", "ERROR_CANT_TERMINATE_SELF" },
      {0x22C, "If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception. ", "ERROR_UNEXPECTED_MM_CREATE_ERR" },
      {0x22D, "If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception. ", "ERROR_UNEXPECTED_MM_MAP_ERROR" },
      {0x22E, "If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception. ", "ERROR_UNEXPECTED_MM_EXTEND_ERR" },
      {0x22F, "A malformed function table was encountered during an unwind operation.", "ERROR_BAD_FUNCTION_TABLE" },
      {0x230, "Indicates that an attempt was made to assign protection to a file system file or directory and one of the SIDs in the security descriptor could not be translated into a GUID that could be stored by the file system. This causes the protection attempt to fail, which may cause a file creation attempt to fail. ", "ERROR_NO_GUID_TRANSLATION" },
      {0x231, "Indicates that an attempt was made to grow an LDT by setting its size, or that the size was not an even number of selectors.", "ERROR_INVALID_LDT_SIZE" },
      {0x233, "Indicates that the starting value for the LDT information was not an integral multiple of the selector size.", "ERROR_INVALID_LDT_OFFSET" },
      {0x234, "Indicates that the user supplied an invalid descriptor when trying to set up Ldt descriptors.", "ERROR_INVALID_LDT_DESCRIPTOR" },
      {0x235, "Indicates a process has too many threads to perform the requested action. For example, assignment of a primary token may only be performed when a process has zero or one threads.", "ERROR_TOO_MANY_THREADS" },
      {0x236, "An attempt was made to operate on a thread within a specific process, but the thread specified is not in the process specified.", "ERROR_THREAD_NOT_IN_PROCESS" },
      {0x237, "Page file quota was exceeded.", "ERROR_PAGEFILE_QUOTA_EXCEEDED" },
      {0x238, "The Netlogon service cannot start because another Netlogon service running in the domain conflicts with the specified role.", "ERROR_LOGON_SERVER_CONFLICT" },
      {0x239, "The SAM database on a Windows Server is significantly out of synchronization with the copy on the Domain Controller. A complete synchronization is required.", "ERROR_SYNCHRONIZATION_REQUIRED" },
      {0x23A, "The NtCreateFile API failed. This error should never be returned to an application, it is a place holder for the Windows Lan Manager Redirector to use in its internal error mapping routines.", "ERROR_NET_OPEN_FAILED" },
      {0x23B, "The I/O permissions for the process could not be changed.", "ERROR_IO_PRIVILEGE_FAILED" },
      {0x23C, "The application terminated as a result of a CTRL+C.", "ERROR_CONTROL_C_EXIT" },
      {0x23D, "The required system file %hs is bad or missing.", "ERROR_MISSING_SYSTEMFILE" },
      {0x23E, "The exception %s (0x%08lx) occurred in the application at location 0x%08lx.", "ERROR_UNHANDLED_EXCEPTION" },
      {0x23F, "The application failed to initialize properly (0x%lx). Click on OK to terminate the application.", "ERROR_APP_INIT_FAILURE" },
      {0x240, "The creation of the paging file %hs failed (%lx). The requested size was %ld.", "ERROR_PAGEFILE_CREATE_FAILED" },
      {0x242, "No paging file was specified in the system configuration.", "ERROR_NO_PAGEFILE" },
      {0x243, "A real-mode application issued a floating-point instruction and floating-point hardware is not present.", "ERROR_ILLEGAL_FLOAT_CONTEXT" },
      {0x244, "An event pair synchronization operation was performed using the thread specific client/server event pair object, but no event pair object was associated with the thread.", "ERROR_NO_EVENT_PAIR" },
      {0x245, "A Windows Server has an incorrect configuration.", "ERROR_DOMAIN_CTRLR_CONFIG_ERROR" },
      {0x246, "An illegal character was encountered. For a multi-byte character set this includes a lead byte without a succeeding trail byte. For the Unicode character set this includes the characters 0xFFFF and 0xFFFE.", "ERROR_ILLEGAL_CHARACTER" },
      {0x247, "The Unicode character is not defined in the Unicode character set installed on the system.", "ERROR_UNDEFINED_CHARACTER" },
      {0x248, "The paging file cannot be created on a floppy diskette.", "ERROR_FLOPPY_VOLUME" },
      {0x249, "The system bios failed to connect a system interrupt to the device or bus for which the device is connected. ", "ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT" },
      {0x24A, "This operation is only allowed for the Primary Domain Controller of the domain.", "ERROR_BACKUP_CONTROLLER" },
      {0x24B, "An attempt was made to acquire a mutant such that its maximum count would have been exceeded.", "ERROR_MUTANT_LIMIT_EXCEEDED" },
      {0x24C, "A volume has been accessed for which a file system driver is required that has not yet been loaded.", "ERROR_FS_DRIVER_REQUIRED" },
      {0x24D, "The registry cannot load the hive (file): %hs or its log or alternate. It is corrupt, absent, or not writable.", "ERROR_CANNOT_LOAD_REGISTRY_FILE" },
      {0x24E, "An unexpected failure occurred while processing a DebugActiveProcess API request. You may choose OK to terminate the process, or Cancel to ignore the error.", "ERROR_DEBUG_ATTACH_FAILED" },
      {0x24F, "The %hs system process terminated unexpectedly with a status of 0x%08x (0x%08x 0x%08x). The system has been shut down. ", "ERROR_SYSTEM_PROCESS_TERMINATED" },
      {0x250, "The TDI client could not handle the data received during an indication.", "ERROR_DATA_NOT_ACCEPTED" },
      {0x251, "NTVDM encountered a hard error.", "ERROR_VDM_HARD_ERROR" },
      {0x252, "The driver %hs failed to complete a cancelled I/O request in the allotted time.", "ERROR_DRIVER_CANCEL_TIMEOUT" },
      {0x253, "An attempt was made to reply to an LPC message, but the thread specified by the client ID in the message was not waiting on that message.", "ERROR_REPLY_MESSAGE_MISMATCH" },
      {0x254, "Windows was unable to save all the data for the file %hs. The data has been lost. This error may be caused by a failure of your computer hardware or network connection. Please try to save this file elsewhere. ", "ERROR_LOST_WRITEBEHIND_DATA" },
      {0x255, "The parameter(s) passed to the server in the client/server shared memory window were invalid. Too much data may have been put in the shared memory window.", "ERROR_CLIENT_SERVER_PARAMETERS_INVALID" },
      {0x256, "The stream is not a tiny stream.", "ERROR_NOT_TINY_STREAM" },
      {0x257, "The request must be handled by the stack overflow code.", "ERROR_STACK_OVERFLOW_READ" },
      {0x258, "Internal OFS status codes indicating how an allocation operation is handled. Either it is retried after the containing onode is moved or the extent stream is converted to a large stream.", "ERROR_CONVERT_TO_LARGE" },
      {0x259, "The attempt to find the object found an object matching by ID on the volume but it is out of the scope of the handle used for the operation.", "ERROR_FOUND_OUT_OF_SCOPE" },
      {0x25A, "The bucket array must be grown. Retry transaction after doing so.", "ERROR_ALLOCATE_BUCKET" },
      {0x25B, "The user/kernel marshalling buffer has overflowed.", "ERROR_MARSHALL_OVERFLOW" },
      {0x25C, "The supplied variant structure contains invalid data.", "ERROR_INVALID_VARIANT" },
      {0x25D, "The specified buffer contains ill-formed data.", "ERROR_BAD_COMPRESSION_BUFFER" },
      {0x25E, "An attempt to generate a security audit failed.", "ERROR_AUDIT_FAILED" },
      {0x25F, "The timer resolution was not previously set by the current process.", "ERROR_TIMER_RESOLUTION_NOT_SET" },
      {0x260, "There is insufficient account information to log you on.", "ERROR_INSUFFICIENT_LOGON_INFO" },
      {0x261, "The dynamic link library %hs is not written correctly. The stack pointer has been left in an inconsistent state. The entrypoint should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue execution. Selecting NO may cause the application to operate incorrectly. ", "ERROR_BAD_DLL_ENTRYPOINT" },
      {0x262, "The %hs service is not written correctly. The stack pointer has been left in an inconsistent state. The callback entrypoint should be declared as WINAPI or STDCALL. Selecting OK will cause the service to continue operation. However, the service process may operate incorrectly. ", "ERROR_BAD_SERVICE_ENTRYPOINT" },
      {0x263, "There is an IP address conflict with another system on the network", "ERROR_IP_ADDRESS_CONFLICT1" },
      {0x264, "There is an IP address conflict with another system on the network", "ERROR_IP_ADDRESS_CONFLICT2" },
      {0x265, "The system has reached the maximum size allowed for the system part of the registry. Additional storage requests will be ignored.", "ERROR_REGISTRY_QUOTA_LIMIT" },
      {0x266, "A callback return system service cannot be executed when no callback is active.", "ERROR_NO_CALLBACK_ACTIVE" },
      {0x267, "The password provided is too short to meet the policy of your user account. Please choose a longer password. ", "ERROR_PWD_TOO_SHORT" },
      {0x268, "The policy of your user account does not allow you to change passwords too frequently. This is done to prevent users from changing back to a familiar, but potentially discovered, password. If you feel your password has been compromised then please contact your administrator immediately to have a new one assigned. ", "ERROR_PWD_TOO_RECENT" },
      {0x269, "You have attempted to change your password to one that you have used in the past. The policy of your user account does not allow this. Please select a password that you have not previously used. ", "ERROR_PWD_HISTORY_CONFLICT" },
      {0x26A, "The specified compression format is unsupported.", "ERROR_UNSUPPORTED_COMPRESSION" },
      {0x26B, "The specified hardware profile configuration is invalid.", "ERROR_INVALID_HW_PROFILE" },
      {0x26C, "The specified Plug and Play registry device path is invalid.", "ERROR_INVALID_PLUGPLAY_DEVICE_PATH" },
      {0x26D, "The specified quota list is internally inconsistent with its descriptor.", "ERROR_QUOTA_LIST_INCONSISTENT" },
      {0x26E, "The evaluation period for this installation of Windows has expired. This system will shutdown in 1 hour. To restore access to this installation of Windows, please upgrade this installation using a licensed distribution of this product.", "ERROR_EVALUATION_EXPIRATION" },
      {0x26F, "The system DLL %hs was relocated in memory. The application will not run properly. The relocation occurred because the DLL %hs occupied an address range reserved for Windows system DLLs. The vendor supplying the DLL should be contacted for a new DLL. ", "ERROR_ILLEGAL_DLL_RELOCATION" },
      {0x270, "The application failed to initialize because the window station is shutting down.", "ERROR_DLL_INIT_FAILED_LOGOFF" },
      {0x271, "The validation process needs to continue on to the next step.", "ERROR_VALIDATE_CONTINUE" },
      {0x272, "There are no more matches for the current index enumeration.", "ERROR_NO_MORE_MATCHES" },
      {0x273, "The range could not be added to the range list because of a conflict.", "ERROR_RANGE_LIST_CONFLICT" },
      {0x274, "The server process is running under a SID different than that required by client.", "ERROR_SERVER_SID_MISMATCH" },
      {0x275, "A group marked use for deny only cannot be enabled.", "ERROR_CANT_ENABLE_DENY_ONLY" },
      {0x276, "Multiple floating point faults.", "ERROR_FLOAT_MULTIPLE_FAULTS" },
      {0x277, "Multiple floating point traps.", "ERROR_FLOAT_MULTIPLE_TRAPS" },
      {0x278, "The requested interface is not supported.", "ERROR_NOINTERFACE" },
      {0x279, "The driver %hs does not support standby mode. Updating this driver may allow the system to go to standby mode.", "ERROR_DRIVER_FAILED_SLEEP" },
      {0x27A, "The system file %1 has become corrupt and has been replaced.", "ERROR_CORRUPT_SYSTEM_FILE" },
      {0x27B, "Your system is low on virtual memory. Windows is increasing the size of your virtual memory paging file. During this process, memory requests for some applications may be denied. For more information, see Help. ", "ERROR_COMMITMENT_MINIMUM" },
      {0x27C, "A device was removed so enumeration must be restarted.", "ERROR_PNP_RESTART_ENUMERATION" },
      {0x27D, "The system image %s is not properly signed. The file has been replaced with the signed file. The system has been shut down.", "ERROR_SYSTEM_IMAGE_BAD_SIGNATURE" },
      {0x27E, "Device will not start without a reboot.", "ERROR_PNP_REBOOT_REQUIRED" },
      {0x27F, "There is not enough power to complete the requested operation.", "ERROR_INSUFFICIENT_POWER" },
      {0x281, "The system is in the process of shutting down.", "ERROR_SYSTEM_SHUTDOWN" },
      {0x282, "An attempt to remove a processes DebugPort was made, but a port was not already associated with the process.", "ERROR_PORT_NOT_SET" },
      {0x283, "This version of Windows is not compatible with the behavior version of directory forest, domain or domain controller.", "ERROR_DS_VERSION_CHECK_FAILURE" },
      {0x284, "The specified range could not be found in the range list.", "ERROR_RANGE_NOT_FOUND" },
      {0x286, "The driver was not loaded because the system is booting into safe mode.", "ERROR_NOT_SAFE_MODE_DRIVER" },
      {0x287, "The driver was not loaded because it failed it's initialization call.", "ERROR_FAILED_DRIVER_ENTRY" },
      {0x288, "The \"%hs\" encountered an error while applying power or reading the device configuration. This may be caused by a failure of your hardware or by a poor connection. ", "ERROR_DEVICE_ENUMERATION_ERROR" },
      {0x289, "The create operation failed because the name contained at least one mount point which resolves to a volume to which the specified device object is not attached.", "ERROR_MOUNT_POINT_NOT_RESOLVED" },
      {0x28A, "The device object parameter is either not a valid device object or is not attached to the volume specified by the file name.", "ERROR_INVALID_DEVICE_OBJECT_PARAMETER" },
      {0x28B, "A Machine Check Error has occurred. Please check the system eventlog for additional information.", "ERROR_MCA_OCCURED" },
      {0x28C, "There was error [%2] processing the driver database.", "ERROR_DRIVER_DATABASE_ERROR" },
      {0x28D, "System hive size has exceeded its limit.", "ERROR_SYSTEM_HIVE_TOO_LARGE" },
      {0x28E, "The driver could not be loaded because a previous version of the driver is still in memory.", "ERROR_DRIVER_FAILED_PRIOR_UNLOAD" },
      {0x28F, "Please wait while the Volume Shadow Copy Service prepares volume %hs for hibernation.", "ERROR_VOLSNAP_PREPARE_HIBERNATE" },
      {0x290, "The system has failed to hibernate (The error code is %hs). Hibernation will be disabled until the system is restarted.", "ERROR_HIBERNATION_FAILURE" },
      {0x291, "The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the machine a dialog will be displayed giving you a chance to report this failure to Microsoft. ", "ERROR_HUNG_DISPLAY_DRIVER_THREAD" },
      {0x299, "The requested operation could not be completed due to a file system limitation.", "ERROR_FILE_SYSTEM_LIMITATION" },
      {0x29C, "An assertion failure has occurred.", "ERROR_ASSERTION_FAILURE" },
      {0x29D, "Application verifier has found an error in the current process.", "ERROR_VERIFIER_STOP" },
      {0x29E, "WOW Assertion Error.", "ERROR_WOW_ASSERTION" },
      {0x29F, "A device is missing in the system BIOS MPS table. This device will not be used. Please contact your system vendor for system BIOS update. ", "ERROR_PNP_BAD_MPS_TABLE" },
      {0x2A0, "A translator failed to translate resources.", "ERROR_PNP_TRANSLATION_FAILED" },
      {0x2A1, "A IRQ translator failed to translate resources.", "ERROR_PNP_IRQ_TRANSLATION_FAILED" },
      {0x2A2, "Driver %2 returned invalid ID for a child device (%3).", "ERROR_PNP_INVALID_ID" },
      {0x2A3, "The system debugger was awakened by an interrupt.", "ERROR_WAKE_SYSTEM_DEBUGGER" },
      {0x2A4, "Handles to objects have been automatically closed as a result of the requested operation.", "ERROR_HANDLES_CLOSED" },
      {0x2A5, "he specified access control list (ACL) contained more information than was expected.", "ERROR_EXTRANEOUS_INFORMATION" },
      {0x2A6, "This warning level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has NOT been completed, but has not been rolled back either (so it may still be committed if desired). ", "ERROR_RXACT_COMMIT_NECESSARY" },
      {0x2A7, "The media may have changed.", "ERROR_MEDIA_CHECK" },
      {0x2A8, "During the translation of a global identifier (GUID) to a Windows security ID (SID), no administratively-defined GUID prefix was found. A substitute prefix was used, which will not compromise system security. However, this may provide a more restrictive access than intended. ", "ERROR_GUID_SUBSTITUTION_MADE" },
      {0x2A9, "The create operation stopped after reaching a symbolic link.", "ERROR_STOPPED_ON_SYMLINK" },
      {0x2AA, "A long jump has been executed.", "ERROR_LONGJUMP" },
      {0x2AB, "The Plug and Play query operation was not successful.", "ERROR_PLUGPLAY_QUERY_VETOED" },
      {0x2AC, "A frame consolidation has been executed.", "ERROR_UNWIND_CONSOLIDATE" },
      {0x2AD, "Registry hive (file): %hs was corrupted and it has been recovered. Some data might have been lost. ", "ERROR_REGISTRY_HIVE_RECOVERED" },
      {0x2AE, "The application is attempting to run executable code from the module %hs. This may be insecure. An alternative, %hs, is available. Should the application use the secure module %hs?", "ERROR_DLL_MIGHT_BE_INSECURE" },
      {0x2AF, "The application is loading executable code from the module %hs. This is secure, but may be incompatible with previous releases of the operating system. An alternative, %hs, is available. Should the application use the secure module %hs?", "ERROR_DLL_MIGHT_BE_INCOMPATIBLE" },
      {0x2B0, "Debugger did not handle the exception.", "ERROR_DBG_EXCEPTION_NOT_HANDLED" },
      {0x2B1, "Debugger will reply later.", "ERROR_DBG_REPLY_LATER" },
      {0x2B2, "Debugger can not provide handle.", "ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE" },
      {0x2B3, "Debugger terminated thread.", "ERROR_DBG_TERMINATE_THREAD" },
      {0x2B4, "Debugger terminated process.", "ERROR_DBG_TERMINATE_PROCESS" },
      {0x2B5, "Debugger got control C.", "ERROR_DBG_CONTROL_C" },
      {0x2B6, "Debugger printed exception on control C.", "ERROR_DBG_PRINTEXCEPTION_C" },
      {0x2B7, "Debugger received RIP exception.", "ERROR_DBG_RIPEXCEPTION" },
      {0x2B8, "Debugger received control break.", "ERROR_DBG_CONTROL_BREAK" },
      {0x2B9, "Debugger command communication exception.", "ERROR_DBG_COMMAND_EXCEPTION" },
      {0x2BA, "An attempt was made to create an object and the object name already existed.", "ERROR_OBJECT_NAME_EXISTS" },
      {0x2BB, "A thread termination occurred while the thread was suspended. The thread was resumed, and termination proceeded.", "ERROR_THREAD_WAS_SUSPENDED" },
      {0x2BC, "An image file could not be mapped at the address specified in the image file. Local fixups must be performed on this image.", "ERROR_IMAGE_NOT_AT_BASE" },
      {0x2BD, "This informational level status indicates that a specified registry sub-tree transaction state did not yet exist and had to be created.", "ERROR_RXACT_STATE_CREATED" },
      {0x2BE, "A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS or Win16 program segment image. An exception is raised so a debugger can load, unload or track symbols and breakpoints within these 16-bit segments. ", "ERROR_SEGMENT_NOTIFICATION" },
      {0x2BF, "The process cannot switch to the startup current directory %hs. Select OK to set current directory to %hs, or select CANCEL to exit. ", "ERROR_BAD_CURRENT_DIRECTORY" },
      {0x2C0, "To satisfy a read request, the NT fault-tolerant file system successfully read the requested data from a redundant copy. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was unable to reassign the failing area of the device. ", "ERROR_FT_READ_RECOVERY_FROM_BACKUP" },
      {0x2C1, "To satisfy a write request, the NT fault-tolerant file system successfully wrote a redundant copy of the information. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was not able to reassign the failing area of the device. ", "ERROR_FT_WRITE_RECOVERY" },
      {0x2C2, "The image file %hs is valid, but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load.", "ERROR_IMAGE_MACHINE_TYPE_MISMATCH" },
      {0x2C3, "The network transport returned partial data to its client. The remaining data will be sent later.", "ERROR_RECEIVE_PARTIAL" },
      {0x2C4, "The network transport returned data to its client that was marked as expedited by the remote system.", "ERROR_RECEIVE_EXPEDITED" },
      {0x2C5, "The network transport returned partial data to its client and this data was marked as expedited by the remote system. The remaining data will be sent later.", "ERROR_RECEIVE_PARTIAL_EXPEDITED" },
      {0x2C6, "The TDI indication has completed successfully.", "ERROR_EVENT_DONE" },
      {0x2C7, "The TDI indication has entered the pending state.", "ERROR_EVENT_PENDING" },
      {0x2C8, "Checking file system on %wZ.", "ERROR_CHECKING_FILE_SYSTEM" },
      {0x2CA, "The specified registry key is referenced by a predefined handle.", "ERROR_PREDEFINED_HANDLE" },
      {0x2CB, "The page protection of a locked page was changed to 'No Access' and the page was unlocked from memory and from the process.", "ERROR_WAS_UNLOCKED" },
      {0x2CD, "One of the pages to lock was already locked.", "ERROR_WAS_LOCKED" },
      {0x2D0, "The image file %hs is valid, but is for a machine type other than the current machine.", "ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE" },
      {0x2D1, "A yield execution was performed and no thread was available to run.", "ERROR_NO_YIELD_PERFORMED" },
      {0x2D2, "The resumable flag to a timer API was ignored.", "ERROR_TIMER_RESUME_IGNORED" },
      {0x2D3, "The arbiter has deferred arbitration of these resources to its parent.", "ERROR_ARBITRATION_UNHANDLED" },
      {0x2D4, "The device \"%hs\" has detected a CardBus card in its slot, but the firmware on this system is not configured to allow the CardBus controller to be run in CardBus mode. The operating system will currently accept only 16-bit (R2) pc-cards on this controller. ", "ERROR_CARDBUS_NOT_SUPPORTED" },
      {0x2D5, "The CPUs in this multiprocessor system are not all the same revision level. To use all processors the operating system restricts itself to the features of the least capable processor in the system. Should problems occur with this system, contact the CPU manufacturer to see if this mix of processors is supported. ", "ERROR_MP_PROCESSOR_MISMATCH" },
      {0x2D6, "The system was put into hibernation.", "ERROR_HIBERNATED" },
      {0x2D7, "The system was resumed from hibernation.", "ERROR_RESUME_HIBERNATION" },
      {0x2D8, "Windows has detected that the system firmware (BIOS) was updated [previous firmware date = %2, current firmware date %3].", "ERROR_FIRMWARE_UPDATED" },
      {0x2D9, "A device driver is leaking locked I/O pages causing system degradation. The system has automatically enabled tracking code in order to try and catch the culprit.", "ERROR_DRIVERS_LEAKING_LOCKED_PAGES" },
      {0x2DA, "The system has awoken", "ERROR_WAKE_SYSTEM" },
      {0x2E5, "A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.", "ERROR_REPARSE" },
      {0x2E6, "An open/create operation completed while an oplock break is underway.", "ERROR_OPLOCK_BREAK_IN_PROGRESS" },
      {0x2E7, "A new volume has been mounted by a file system.", "ERROR_VOLUME_MOUNTED" },
      {0x2E8, "This success level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has now been completed.", "ERROR_RXACT_COMMITTED" },
      {0x2E9, "This indicates that a notify change request has been completed due to closing the handle which made the notify change request.", "ERROR_NOTIFY_CLEANUP" },
      {0x2EA, "An attempt was made to connect to the remote server %hs on the primary transport, but the connection failed. The computer WAS able to connect on a secondary transport. ", "ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED" },
      {0x2EB, "Page fault was a transition fault.", "ERROR_PAGE_FAULT_TRANSITION" },
      {0x2EC, "Page fault was a demand zero fault.", "ERROR_PAGE_FAULT_DEMAND_ZERO" },
      {0x2ED, "Page fault was a demand zero fault.", "ERROR_PAGE_FAULT_COPY_ON_WRITE" },
      {0x2EE, "Page fault was a demand zero fault.", "ERROR_PAGE_FAULT_GUARD_PAGE" },
      {0x2EF, "Page fault was satisfied by reading from a secondary storage device.", "ERROR_PAGE_FAULT_PAGING_FILE" },
      {0x2F0, "Cached page was locked during operation.", "ERROR_CACHE_PAGE_LOCKED" },
      {0x2F1, "Crash dump exists in paging file.", "ERROR_CRASH_DUMP" },
      {0x2F2, "Specified buffer contains all zeros.", "ERROR_BUFFER_ALL_ZEROS" },
      {0x2F3, "A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.", "ERROR_REPARSE_OBJECT" },
      {0x2F4, "The device has succeeded a query-stop and its resource requirements have changed.", "ERROR_RESOURCE_REQUIREMENTS_CHANGED" },
      {0x2F5, "The translator has translated these resources into the global space and no further translations should be performed.", "ERROR_TRANSLATION_COMPLETE" },
      {0x2F6, "A process being terminated has no threads to terminate.", "ERROR_NOTHING_TO_TERMINATE" },
      {0x2F7, "The specified process is not part of a job.", "ERROR_PROCESS_NOT_IN_JOB" },
      {0x2F8, "The specified process is part of a job.", "ERROR_PROCESS_IN_JOB" },
      {0x2F9, "The system is now ready for hibernation.", "ERROR_VOLSNAP_HIBERNATE_READY" },
      {0x2FA, "A file system or file system filter driver has successfully completed an FsFilter operation.", "ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY" },
      {0x2FB, "The specified interrupt vector was already connected.", "ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED" },
      {0x2FC, "The specified interrupt vector is still connected.", "ERROR_INTERRUPT_STILL_CONNECTED" },
      {0x2FD, "An operation is blocked waiting for an oplock.", "ERROR_WAIT_FOR_OPLOCK" },
      {0x2FE, "Debugger handled exception.", "ERROR_DBG_EXCEPTION_HANDLED" },
      {0x2FF, "Debugger continued", "ERROR_DBG_CONTINUE" },
      {0x300, "An exception occurred in a user mode callback and the kernel callback frame should be removed.", "ERROR_CALLBACK_POP_STACK" },
      {0x301, "Compression is disabled for this volume.", "ERROR_COMPRESSION_DISABLED" },
      {0x302, "The data provider cannot fetch backwards through a result set.", "ERROR_CANTFETCHBACKWARDS" },
      {0x303, "The data provider cannot scroll backwards through a result set.", "ERROR_CANTSCROLLBACKWARDS" },
      {0x304, "The data provider requires that previously fetched data is released before asking for more data.", "ERROR_ROWSNOTRELEASED" },
      {0x305, "The data provider was not able to interpret the flags set for a column binding in an accessor.", "ERROR_BAD_ACCESSOR_FLAGS" },
      {0x306, "One or more errors occurred while processing the request.", "ERROR_ERRORS_ENCOUNTERED" },
      {0x307, "The implementation is not capable of performing the request.", "ERROR_NOT_CAPABLE" },
      {0x308, "The client of a component requested an operation which is not valid given the state of the component instance.", "ERROR_REQUEST_OUT_OF_SEQUENCE" },
      {0x309, "A version number could not be parsed.", "ERROR_VERSION_PARSE_ERROR" },
      {0x30A, "The iterator's start position is invalid.", "ERROR_BADSTARTPOSITION" },
      {0x3E2, "Access to the extended attribute was denied.", "ERROR_EA_ACCESS_DENIED" },
      {0x3E3, "The I/O operation has been aborted because of either a thread exit or an application request.", "ERROR_OPERATION_ABORTED" },
      {0x3E4, "Overlapped I/O event is not in a signaled state.", "ERROR_IO_INCOMPLETE" },
      {0x3E5, "Overlapped I/O operation is in progress.", "ERROR_IO_PENDING" },
      {0x3E6, "Invalid access to memory location.", "ERROR_NOACCESS" },
      {0x3E7, "Error performing inpage operation.", "ERROR_SWAPERROR" },
      {0x3E9, "Recursion too deep; the stack overflowed.", "ERROR_STACK_OVERFLOW" },
      {0x3EA, "The window cannot act on the sent message.", "ERROR_INVALID_MESSAGE" },
      {0x3EB, "Cannot complete this function.", "ERROR_CAN_NOT_COMPLETE" },
      {0x3EC, "Invalid flags.", "ERROR_INVALID_FLAGS" },
      {0x3ED, "The volume does not contain a recognized file system. Please make sure that all required file system drivers are loaded and that the volume is not corrupted.", "ERROR_UNRECOGNIZED_VOLUME" },
      {0x3EE, "The volume for a file has been externally altered so that the opened file is no longer valid.", "ERROR_FILE_INVALID" },
      {0x3EF, "The requested operation cannot be performed in full-screen mode.", "ERROR_FULLSCREEN_MODE" },
      {0x3F0, "An attempt was made to reference a token that does not exist.", "ERROR_NO_TOKEN" },
      {0x3F1, "The configuration registry database is corrupt.", "ERROR_BADDB" },
      {0x3F2, "The configuration registry key is invalid.", "ERROR_BADKEY" },
      {0x3F3, "The configuration registry key could not be opened.", "ERROR_CANTOPEN" },
      {0x3F4, "The configuration registry key could not be read.", "ERROR_CANTREAD" },
      {0x3F5, "The configuration registry key could not be written.", "ERROR_CANTWRITE" },
      {0x3F6, "One of the files in the registry database had to be recovered by use of a log or alternate copy. The recovery was successful.", "ERROR_REGISTRY_RECOVERED" },
      {0x3F7, "The registry is corrupted. The structure of one of the files containing registry data is corrupted, or the system's memory image of the file is corrupted, or the file could not be recovered because the alternate copy or log was absent or corrupted.", "ERROR_REGISTRY_CORRUPT" },
      {0x3F8, "An I/O operation initiated by the registry failed unrecoverably. The registry could not read in, or write out, or flush, one of the files that contain the system's image of the registry.", "ERROR_REGISTRY_IO_FAILED" },
      {0x3F9, "The system has attempted to load or restore a file into the registry, but the specified file is not in a registry file format.", "ERROR_NOT_REGISTRY_FILE" },
      {0x3FA, "Illegal operation attempted on a registry key that has been marked for deletion.", "ERROR_KEY_DELETED" },
      {0x3FB, "System could not allocate the required space in a registry log.", "ERROR_NO_LOG_SPACE" },
      {0x3FC, "Cannot create a symbolic link in a registry key that already has subkeys or values.", "ERROR_KEY_HAS_CHILDREN" },
      {0x3FD, "Cannot create a stable subkey under a volatile parent key.", "ERROR_CHILD_MUST_BE_VOLATILE" },
      {0x3FE, "A notify change request is being completed and the information is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes.", "ERROR_NOTIFY_ENUM_DIR" },
      {0x41B, "A stop control has been sent to a service that other running services are dependent on.", "ERROR_DEPENDENT_SERVICES_RUNNING" },
      {0x41C, "The requested control is not valid for this service.", "ERROR_INVALID_SERVICE_CONTROL" },
      {0x41D, "The service did not respond to the start or control request in a timely fashion.", "ERROR_SERVICE_REQUEST_TIMEOUT" },
      {0x41E, "A thread could not be created for the service.", "ERROR_SERVICE_NO_THREAD" },
      {0x41F, "The service database is locked.", "ERROR_SERVICE_DATABASE_LOCKED" },
      {0x420, "An instance of the service is already running.", "ERROR_SERVICE_ALREADY_RUNNING" },
      {0x421, "The account name is invalid or does not exist, or the password is invalid for the account name specified.", "ERROR_INVALID_SERVICE_ACCOUNT" },
      {0x422, "The service cannot be started, either because it is disabled or because it has no enabled devices associated with it.", "ERROR_SERVICE_DISABLED" },
      {0x423, "Circular service dependency was specified.", "ERROR_CIRCULAR_DEPENDENCY" },
      {0x424, "The specified service does not exist as an installed service.", "ERROR_SERVICE_DOES_NOT_EXIST" },
      {0x425, "The service cannot accept control messages at this time.", "ERROR_SERVICE_CANNOT_ACCEPT_CTRL" },
      {0x426, "The service has not been started.", "ERROR_SERVICE_NOT_ACTIVE" },
      {0x427, "The service process could not connect to the service controller.", "ERROR_FAILED_SERVICE_CONTROLLER_CONNECT" },
      {0x428, "An exception occurred in the service when handling the control request.", "ERROR_EXCEPTION_IN_SERVICE" },
      {0x429, "The database specified does not exist.", "ERROR_DATABASE_DOES_NOT_EXIST" },
      {0x42A, "The service has returned a service-specific error code.", "ERROR_SERVICE_SPECIFIC_ERROR" },
      {0x42B, "The process terminated unexpectedly.", "ERROR_PROCESS_ABORTED" },
      {0x42C, "The dependency service or group failed to start.", "ERROR_SERVICE_DEPENDENCY_FAIL" },
      {0x42D, "The service did not start due to a logon failure.", "ERROR_SERVICE_LOGON_FAILED" },
      {0x42E, "After starting, the service hung in a start-pending state.", "ERROR_SERVICE_START_HANG" },
      {0x42F, "The specified service database lock is invalid.", "ERROR_INVALID_SERVICE_LOCK" },
      {0x430, "The specified service has been marked for deletion.", "ERROR_SERVICE_MARKED_FOR_DELETE" },
      {0x431, "The specified service already exists.", "ERROR_SERVICE_EXISTS" },
      {0x432, "The system is currently running with the last-known-good configuration.", "ERROR_ALREADY_RUNNING_LKG" },
      {0x433, "The dependency service does not exist or has been marked for deletion.", "ERROR_SERVICE_DEPENDENCY_DELETED" },
      {0x434, "The current boot has already been accepted for use as the last-known-good control set.", "ERROR_BOOT_ALREADY_ACCEPTED" },
      {0x435, "No attempts to start the service have been made since the last boot.", "ERROR_SERVICE_NEVER_STARTED" },
      {0x436, "The name is already in use as either a service name or a service display name.", "ERROR_DUPLICATE_SERVICE_NAME" },
      {0x437, "The account specified for this service is different from the account specified for other services running in the same process.", "ERROR_DIFFERENT_SERVICE_ACCOUNT" },
      {0x438, "Failure actions can only be set for Win32 services, not for drivers.", "ERROR_CANNOT_DETECT_DRIVER_FAILURE" },
      {0x439, "This service runs in the same process as the service control manager. Therefore, the service control manager cannot take action if this service's process terminates unexpectedly.", "ERROR_CANNOT_DETECT_PROCESS_ABORT" },
      {0x43A, "No recovery program has been configured for this service.", "ERROR_NO_RECOVERY_PROGRAM" },
      {0x43B, "The executable program that this service is configured to run in does not implement the service.", "ERROR_SERVICE_NOT_IN_EXE" },
      {0x43C, "This service cannot be started in Safe Mode.", "ERROR_NOT_SAFEBOOT_SERVICE" },
      {0x44C, "The physical end of the tape has been reached.", "ERROR_END_OF_MEDIA" },
      {0x44D, "A tape access reached a filemark.", "ERROR_FILEMARK_DETECTED" },
      {0x44E, "The beginning of the tape or a partition was encountered.", "ERROR_BEGINNING_OF_MEDIA" },
      {0x44F, "A tape access reached the end of a set of files.", "ERROR_SETMARK_DETECTED" },
      {0x450, "No more data is on the tape.", "ERROR_NO_DATA_DETECTED" },
      {0x451, "Tape could not be partitioned.", "ERROR_PARTITION_FAILURE" },
      {0x452, "When accessing a new tape of a multivolume partition, the current block size is incorrect.", "ERROR_INVALID_BLOCK_LENGTH" },
      {0x453, "Tape partition information could not be found when loading a tape.", "ERROR_DEVICE_NOT_PARTITIONED" },
      {0x454, "Unable to lock the media eject mechanism.", "ERROR_UNABLE_TO_LOCK_MEDIA" },
      {0x455, "Unable to unload the media.", "ERROR_UNABLE_TO_UNLOAD_MEDIA" },
      {0x456, "The media in the drive may have changed.", "ERROR_MEDIA_CHANGED" },
      {0x457, "The I/O bus was reset.", "ERROR_BUS_RESET" },
      {0x458, "No media in drive.", "ERROR_NO_MEDIA_IN_DRIVE" },
      {0x459, "No mapping for the Unicode character exists in the target multi-byte code page.", "ERROR_NO_UNICODE_TRANSLATION" },
      {0x45A, "A dynamic link library (DLL) initialization routine failed.", "ERROR_DLL_INIT_FAILED" },
      {0x45B, "A system shutdown is in progress.", "ERROR_SHUTDOWN_IN_PROGRESS" },
      {0x45C, "Unable to abort the system shutdown because no shutdown was in progress.", "ERROR_NO_SHUTDOWN_IN_PROGRESS" },
      {0x45D, "The request could not be performed because of an I/O device error.", "ERROR_IO_DEVICE" },
      {0x45E, "No serial device was successfully initialized. The serial driver will unload.", "ERROR_SERIAL_NO_DEVICE" },
      {0x45F, "Unable to open a device that was sharing an interrupt request (IRQ) with other devices. At least one other device that uses that IRQ was already opened.", "ERROR_IRQ_BUSY" },
      {0x460, "A serial I/O operation was completed by another write to the serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)", "ERROR_MORE_WRITES" },
      {0x461, "A serial I/O operation completed because the timeout period expired. (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.)", "ERROR_COUNTER_TIMEOUT" },
      {0x462, "No ID address mark was found on the floppy disk.", "ERROR_FLOPPY_ID_MARK_NOT_FOUND" },
      {0x463, "Mismatch between the floppy disk sector ID field and the floppy disk controller track address.", "ERROR_FLOPPY_WRONG_CYLINDER" },
      {0x464, "The floppy disk controller reported an error that is not recognized by the floppy disk driver.", "ERROR_FLOPPY_UNKNOWN_ERROR" },
      {0x465, "The floppy disk controller returned inconsistent results in its registers.", "ERROR_FLOPPY_BAD_REGISTERS" },
      {0x466, "While accessing the hard disk, a recalibrate operation failed, even after retries.", "ERROR_DISK_RECALIBRATE_FAILED" },
      {0x467, "While accessing the hard disk, a disk operation failed even after retries.", "ERROR_DISK_OPERATION_FAILED" },
      {0x468, "While accessing the hard disk, a disk controller reset was needed, but even that failed.", "ERROR_DISK_RESET_FAILED" },
      {0x469, "Physical end of tape encountered.", "ERROR_EOM_OVERFLOW" },
      {0x46A, "Not enough server storage is available to process this command.", "ERROR_NOT_ENOUGH_SERVER_MEMORY" },
      {0x46B, "A potential deadlock condition has been detected.", "ERROR_POSSIBLE_DEADLOCK" },
      {0x46C, "The base address or the file offset specified does not have the proper alignment.", "ERROR_MAPPED_ALIGNMENT" },
      {0x474, "An attempt to change the system power state was vetoed by another application or driver.", "ERROR_SET_POWER_STATE_VETOED" },
      {0x475, "The system BIOS failed an attempt to change the system power state.", "ERROR_SET_POWER_STATE_FAILED" },
      {0x476, "An attempt was made to create more links on a file than the file system supports.", "ERROR_TOO_MANY_LINKS" },
      {0x47E, "The specified program requires a newer version of Windows.", "ERROR_OLD_WIN_VERSION" },
      {0x47F, "The specified program is not a Windows or MS-DOS program.", "ERROR_APP_WRONG_OS" },
      {0x480, "Cannot start more than one instance of the specified program.", "ERROR_SINGLE_INSTANCE_APP" },
      {0x481, "The specified program was written for an earlier version of Windows.", "ERROR_RMODE_APP" },
      {0x482, "One of the library files needed to run this application is damaged.", "ERROR_INVALID_DLL" },
      {0x483, "No application is associated with the specified file for this operation.", "ERROR_NO_ASSOCIATION" },
      {0x484, "An error occurred in sending the command to the application.", "ERROR_DDE_FAIL" },
      {0x485, "One of the library files needed to run this application cannot be found.", "ERROR_DLL_NOT_FOUND" },
      {0x486, "The current process has used all of its system allowance of handles for Window Manager objects.", "ERROR_NO_MORE_USER_HANDLES" },
      {0x487, "The message can be used only with synchronous operations.", "ERROR_MESSAGE_SYNC_ONLY" },
      {0x488, "The indicated source element has no media.", "ERROR_SOURCE_ELEMENT_EMPTY" },
      {0x489, "The indicated destination element already contains media.", "ERROR_DESTINATION_ELEMENT_FULL" },
      {0x48A, "The indicated element does not exist.", "ERROR_ILLEGAL_ELEMENT_ADDRESS" },
      {0x48B, "The indicated element is part of a magazine that is not present.", "ERROR_MAGAZINE_NOT_PRESENT" },
      {0x48C, "The indicated device requires reinitialization due to hardware errors.", "ERROR_DEVICE_REINITIALIZATION_NEEDED" },
      {0x48D, "The device has indicated that cleaning is required before further operations are attempted.", "ERROR_DEVICE_REQUIRES_CLEANING" },
      {0x48E, "The device has indicated that its door is open.", "ERROR_DEVICE_DOOR_OPEN" },
      {0x48F, "The device is not connected.", "ERROR_DEVICE_NOT_CONNECTED" },
      {0x490, "Element not found.", "ERROR_NOT_FOUND" },
      {0x491, "There was no match for the specified key in the index.", "ERROR_NO_MATCH" },
      {0x492, "The property set specified does not exist on the object.", "ERROR_SET_NOT_FOUND" },
      {0x493, "The point passed to GetMouseMovePointsEx is not in the buffer.", "ERROR_POINT_NOT_FOUND" },
      {0x494, "The tracking (workstation) service is not running.", "ERROR_NO_TRACKING_SERVICE" },
      {0x495, "The Volume ID could not be found.", "ERROR_NO_VOLUME_ID" },
      {0x497, "Unable to remove the file to be replaced.", "ERROR_UNABLE_TO_REMOVE_REPLACED" },
      {0x498, "Unable to move the replacement file to the file to be replaced. The file to be replaced has retained its original name.", "ERROR_UNABLE_TO_MOVE_REPLACEMENT" },
      {0x499, "Unable to move the replacement file to the file to be replaced. The file to be replaced has been renamed using the backup name.", "ERROR_UNABLE_TO_MOVE_REPLACEMENT_2" },
      {0x49A, "The volume change journal is being deleted.", "ERROR_JOURNAL_DELETE_IN_PROGRESS" },
      {0x49B, "The volume change journal is not active.", "ERROR_JOURNAL_NOT_ACTIVE" },
      {0x49C, "A file was found, but it may not be the correct file.", "ERROR_POTENTIAL_FILE_FOUND" },
      {0x49D, "The journal entry has been deleted from the journal.", "ERROR_JOURNAL_ENTRY_DELETED" },
      {0x4B0, "The specified device name is invalid.", "ERROR_BAD_DEVICE" },
      {0x4B1, "The device is not currently connected but it is a remembered connection.", "ERROR_CONNECTION_UNAVAIL" },
      {0x4B2, "The local device name has a remembered connection to another network resource.", "ERROR_DEVICE_ALREADY_REMEMBERED" },
      {0x4B3, "The network path was either typed incorrectly, does not exist, or the network provider is not currently available. Please try retyping the path or contact your network administrator.", "ERROR_NO_NET_OR_BAD_PATH" },
      {0x4B4, "The specified network provider name is invalid.", "ERROR_BAD_PROVIDER" },
      {0x4B5, "Unable to open the network connection profile.", "ERROR_CANNOT_OPEN_PROFILE" },
      {0x4B6, "The network connection profile is corrupted.", "ERROR_BAD_PROFILE" },
      {0x4B7, "Cannot enumerate a noncontainer.", "ERROR_NOT_CONTAINER" },
      {0x4B8, "An extended error has occurred.", "ERROR_EXTENDED_ERROR" },
      {0x4B9, "The format of the specified group name is invalid.", "ERROR_INVALID_GROUPNAME" },
      {0x4BA, "The format of the specified computer name is invalid.", "ERROR_INVALID_COMPUTERNAME" },
      {0x4BB, "The format of the specified event name is invalid.", "ERROR_INVALID_EVENTNAME" },
      {0x4BC, "The format of the specified domain name is invalid.", "ERROR_INVALID_DOMAINNAME" },
      {0x4BD, "The format of the specified service name is invalid.", "ERROR_INVALID_SERVICENAME" },
      {0x4BE, "The format of the specified network name is invalid.", "ERROR_INVALID_NETNAME" },
      {0x4BF, "The format of the specified share name is invalid.", "ERROR_INVALID_SHARENAME" },
      {0x4C0, "The format of the specified password is invalid.", "ERROR_INVALID_PASSWORDNAME" },
      {0x4C1, "The format of the specified message name is invalid.", "ERROR_INVALID_MESSAGENAME" },
      {0x4C2, "The format of the specified message destination is invalid.", "ERROR_INVALID_MESSAGEDEST" },
      {0x4C3, "Multiple connections to a server or shared resource by the same user, using more than one user name, are not allowed. Disconnect all previous connections to the server or shared resource and try again.", "ERROR_SESSION_CREDENTIAL_CONFLICT" },
      {0x4C4, "An attempt was made to establish a session to a network server, but there are already too many sessions established to that server.", "ERROR_REMOTE_SESSION_LIMIT_EXCEEDED" },
      {0x4C5, "The workgroup or domain name is already in use by another computer on the network.", "ERROR_DUP_DOMAINNAME" },
      {0x4C6, "The network is not present or not started.", "ERROR_NO_NETWORK" },
      {0x4C7, "The operation was canceled by the user.", "ERROR_CANCELLED" },
      {0x4C8, "The requested operation cannot be performed on a file with a user-mapped section open.", "ERROR_USER_MAPPED_FILE" },
      {0x4C9, "The remote system refused the network connection.", "ERROR_CONNECTION_REFUSED" },
      {0x4CA, "The network connection was gracefully closed.", "ERROR_GRACEFUL_DISCONNECT" },
      {0x4CB, "The network transport endpoint already has an address associated with it.", "ERROR_ADDRESS_ALREADY_ASSOCIATED" },
      {0x4CC, "An address has not yet been associated with the network endpoint.", "ERROR_ADDRESS_NOT_ASSOCIATED" },
      {0x4CD, "An operation was attempted on a nonexistent network connection.", "ERROR_CONNECTION_INVALID" },
      {0x4CE, "An invalid operation was attempted on an active network connection.", "ERROR_CONNECTION_ACTIVE" },
      {0x4CF, "The network location cannot be reached. For information about network troubleshooting, see Windows Help.", "ERROR_NETWORK_UNREACHABLE" },
      {0x4D0, "The network location cannot be reached. For information about network troubleshooting, see Windows Help.", "ERROR_HOST_UNREACHABLE" },
      {0x4D1, "The network location cannot be reached. For information about network troubleshooting, see Windows Help.", "ERROR_PROTOCOL_UNREACHABLE" },
      {0x4D2, "No service is operating at the destination network endpoint on the remote system.", "ERROR_PORT_UNREACHABLE" },
      {0x4D3, "The request was aborted.", "ERROR_REQUEST_ABORTED" },
      {0x4D4, "The network connection was aborted by the local system.", "ERROR_CONNECTION_ABORTED" },
      {0x4D5, "The operation could not be completed. A retry should be performed.", "ERROR_RETRY" },
      {0x4D6, "A connection to the server could not be made because the limit on the number of concurrent connections for this account has been reached.", "ERROR_CONNECTION_COUNT_LIMIT" },
      {0x4D7, "Attempting to log in during an unauthorized time of day for this account.", "ERROR_LOGIN_TIME_RESTRICTION" },
      {0x4D8, "The account is not authorized to log in from this station.", "ERROR_LOGIN_WKSTA_RESTRICTION" },
      {0x4D9, "The network address could not be used for the operation requested.", "ERROR_INCORRECT_ADDRESS" },
      {0x4DA, "The service is already registered.", "ERROR_ALREADY_REGISTERED" },
      {0x4DB, "The specified service does not exist.", "ERROR_SERVICE_NOT_FOUND" },
      {0x4DC, "The operation being requested was not performed because the user has not been authenticated.", "ERROR_NOT_AUTHENTICATED" },
      {0x4DD, "The operation being requested was not performed because the user has not logged on to the network. The specified service does not exist.", "ERROR_NOT_LOGGED_ON" },
      {0x4DE, "Continue with work in progress.", "ERROR_CONTINUE" },
      {0x4DF, "An attempt was made to perform an initialization operation when initialization has already been completed.", "ERROR_ALREADY_INITIALIZED" },
      {0x4E0, "No more local devices.", "ERROR_NO_MORE_DEVICES" },
      {0x4E1, "The specified site does not exist.", "ERROR_NO_SUCH_SITE" },
      {0x4E2, "A domain controller with the specified name already exists.", "ERROR_DOMAIN_CONTROLLER_EXISTS" },
      {0x4E3, "This operation is supported only when you are connected to the server.", "ERROR_ONLY_IF_CONNECTED" },
      {0x4E4, "The group policy framework should call the extension even if there are no changes.", "ERROR_OVERRIDE_NOCHANGES" },
      {0x4E5, "The specified user does not have a valid profile.", "ERROR_BAD_USER_PROFILE" },
      {0x4E6, "This operation is not supported on a computer running Windows Server 2003 for Small Business Server.", "ERROR_NOT_SUPPORTED_ON_SBS" },
      {0x4E7, "The server machine is shutting down.", "ERROR_SERVER_SHUTDOWN_IN_PROGRESS" },
      {0x4E8, "The remote system is not available. For information about network troubleshooting, see Windows Help.", "ERROR_HOST_DOWN" },
      {0x4E9, "The security identifier provided is not from an account domain.", "ERROR_NON_ACCOUNT_SID" },
      {0x4EA, "The security identifier provided does not have a domain component.", "ERROR_NON_DOMAIN_SID" },
      {0x4EB, "AppHelp dialog canceled thus preventing the application from starting.", "ERROR_APPHELP_BLOCK" },
      {0x4EC, "Windows cannot open this program because it has been prevented by a software restriction policy. For more information, open Event Viewer or contact your system administrator.", "ERROR_ACCESS_DISABLED_BY_POLICY" },
      {0x4ED, "A program attempt to use an invalid register value. Normally caused by an uninitialized register. This error is Itanium specific.", "ERROR_REG_NAT_CONSUMPTION" },
      {0x4EE, "The share is currently offline or does not exist.", "ERROR_CSCSHARE_OFFLINE" },
      {0x4EF, "The kerberos protocol encountered an error while validating the KDC certificate during smartcard logon.", "ERROR_PKINIT_FAILURE" },
      {0x4F0, "The kerberos protocol encountered an error while attempting to utilize the smartcard subsystem.", "ERROR_SMARTCARD_SUBSYSTEM_FAILURE" },
      {0x4F1, "The system detected a possible attempt to compromise security. Please ensure that you can contact the server that authenticated you.", "ERROR_DOWNGRADE_DETECTED" },
      {0x4F2, "The smartcard certificate used for authentication has been revoked. Please contact your system administrator. There may be additional information in the event log.", "SEC_E_SMARTCARD_CERT_REVOKED" },
      {0x4F3, "An untrusted certificate authority was detected while processing the smartcard certificate used for authentication. Please contact your system administrator.", "SEC_E_ISSUING_CA_UNTRUSTED" },
      {0x4F4, "The revocation status of the smartcard certificate used for authentication could not be determined. Please contact your system administrator.", "SEC_E_REVOCATION_OFFLINE_C" },
      {0x4F5, "The smartcard certificate used for authentication was not trusted. Please contact your system administrator.", "SEC_E_PKINIT_CLIENT_FAILUR" },
      {0x4F6, "The smartcard certificate used for authentication has expired. Please contact your system administrator.", "SEC_E_SMARTCARD_CERT_EXPIRED" },
      {0x4F7, "The machine is locked and cannot be shut down without the force option.", "ERROR_MACHINE_LOCKED" },
      {0x4F9, "An application-defined callback gave invalid data when called.", "ERROR_CALLBACK_SUPPLIED_INVALID_DATA" },
      {0x4FA, "The group policy framework should call the extension in the synchronous foreground policy refresh.", "ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED" },
      {0x4FB, "This driver has been blocked from loading.", "ERROR_DRIVER_BLOCKED" },
      {0x4FC, "A dynamic link library (DLL) referenced a module that was neither a DLL nor the process's executable image.", "ERROR_INVALID_IMPORT_OF_NON_DLL" },
      {0x4FD, "Windows cannot open this program since it has been disabled.", "ERROR_ACCESS_DISABLED_WEBBLADE" },
      {0x4FE, "Windows cannot open this program because the license enforcement system has been tampered with or become corrupted.", "ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER" },
      {0x4FF, "A transaction recovery failed.", "ERROR_RECOVERY_FAILURE" },
      {0x500, "The current thread has already been converted to a fiber.", "ERROR_ALREADY_FIBER" },
      {0x501, "The current thread has already been converted from a fiber.", "ERROR_ALREADY_THREAD" },
      {0x502, "The system detected an overrun of a stack-based buffer in this application. This overrun could potentially allow a malicious user to gain control of this application.", "ERROR_STACK_BUFFER_OVERRUN" },
      {0x503, "Data present in one of the parameters is more than the function can operate on.", "ERROR_PARAMETER_QUOTA_EXCEEDED" },
      {0x504, "An attempt to do an operation on a debug object failed because the object is in the process of being deleted.", "ERROR_DEBUGGER_INACTIVE" },
      {0x505, "An attempt to delay-load a .dll or get a function address in a delay-loaded .dll failed.", "ERROR_DELAY_LOAD_FAILED" },
      {0x506, "%1 is a 16-bit application. You do not have permissions to execute 16-bit applications. Check your permissions with your system administrator.", "ERROR_VDM_DISALLOWED" },
      {0x507, "Insufficient information exists to identify the cause of failure.", "ERROR_UNIDENTIFIED_ERROR" },
      {0x508, "An invalid budget or period parameter was specified.", "ERROR_INVALID_BANDWIDTH_PARAMETERS" },
      {0x509, "An attempt was made to join a thread to a reserve whose affinity did not intersect the reserve affinity or an attempt was made to associate a process with a reserve whose affinity did not intersect the reserve affinity.", "ERROR_AFFINITY_NOT_COMPATIBLE" },
      {0x50A, "An attempt was made to join a thread to a reserve which was already joined to another reserve.", "ERROR_THREAD_ALREADY_IN_RESERVE" },
      {0x50B, "An attempt was made to disjoin a thread from a reserve, but the thread was not joined to the reserve.", "ERROR_THREAD_NOT_IN_RESERVE" },
      {0x50C, "An attempt was made to disjoin a thread from a reserve whose process is associated with a reserve.", "ERROR_THREAD_PROCESS_IN_RESERVE" },
      {0x50D, "An attempt was made to associate a process with a reserve that was already associated with a reserve.", "ERROR_PROCESS_ALREADY_IN_RESERVE" },
      {0x50E, "An attempt was made to disassociate a process from a reserve, but the process did not have an associated reserve.", "ERROR_PROCESS_NOT_IN_RESERVE" },
      {0x50F, "An attempt was made to associate a process with a reserve, but the process contained thread joined to a reserve.", "ERROR_PROCESS_THREADS_IN_RESERVE" },
      {0x510, "An attempt was made to set the affinity of a thread or a process, but the thread or process was joined or associated with a reserve.", "ERROR_AFFINITY_NOT_SET_IN_RESERVE" },
      {0x511, "An operation attempted to exceed an implementation-defined limit.", "ERROR_IMPLEMENTATION_LIMIT" },
      {0x512, "The requested object is for internal DS operations only.", "ERROR_DS_CACHE_ONLY" },
      {0x514, "Not all privileges referenced are assigned to the caller.", "ERROR_NOT_ALL_ASSIGNED" },
      {0x515, "Some mapping between account names and security IDs was not done.", "ERROR_SOME_NOT_MAPPED" },
      {0x516, "No system quota limits are specifically set for this account.", "ERROR_NO_QUOTAS_FOR_ACCOUNT" },
      {0x517, "No encryption key is available. A well-known encryption key was returned.", "ERROR_LOCAL_USER_SESSION_KEY" },
      {0x518, "The password is too complex to be converted to a LAN Manager password. The LAN Manager password returned is a NULL string.", "ERROR_NULL_LM_PASSWORD" },
      {0x519, "The revision level is unknown.", "ERROR_UNKNOWN_REVISION" },
      {0x51A, "Indicates two revision levels are incompatible.", "ERROR_REVISION_MISMATCH" },
      {0x51B, "This security ID may not be assigned as the owner of this object.", "ERROR_INVALID_OWNER" },
      {0x51C, "This security ID may not be assigned as the primary group of an object.", "ERROR_INVALID_PRIMARY_GROUP" },
      {0x51D, "An attempt has been made to operate on an impersonation token by a thread that is not currently impersonating a client.", "ERROR_NO_IMPERSONATION_TOKEN" },
      {0x51E, "The group may not be disabled.", "ERROR_CANT_DISABLE_MANDATORY" },
      {0x51F, "There are currently no logon servers available to service the logon request.", "ERROR_NO_LOGON_SERVERS" },
      {0x520, "A specified logon session does not exist. It may already have been terminated.", "ERROR_NO_SUCH_LOGON_SESSION" },
      {0x521, "A specified privilege does not exist.", "ERROR_NO_SUCH_PRIVILEGE" },
      {0x522, "A required privilege is not held by the client.", "ERROR_PRIVILEGE_NOT_HELD" },
      {0x523, "The name provided is not a properly formed account name.", "ERROR_INVALID_ACCOUNT_NAME" },
      {0x524, "The specified user already exists.", "ERROR_USER_EXISTS" },
      {0x525, "The specified user does not exist.", "ERROR_NO_SUCH_USER" },
      {0x526, "The specified group already exists.", "ERROR_GROUP_EXISTS" },
      {0x527, "The specified group does not exist.", "ERROR_NO_SUCH_GROUP" },
      {0x528, "Either the specified user account is already a member of the specified group, or the specified group cannot be deleted because it contains a member.", "ERROR_MEMBER_IN_GROUP" },
      {0x529, "The specified user account is not a member of the specified group account.", "ERROR_MEMBER_NOT_IN_GROUP" },
      {0x52A, "The last remaining administration account cannot be disabled or deleted.", "ERROR_LAST_ADMIN" },
      {0x52B, "Unable to update the password. The value provided as the current password is incorrect.", "ERROR_WRONG_PASSWORD" },
      {0x52C, "Unable to update the password. The value provided for the new password contains values that are not allowed in passwords.", "ERROR_ILL_FORMED_PASSWORD" },
      {0x52D, "Unable to update the password. The value provided for the new password does not meet the length, complexity, or history requirement of the domain.", "ERROR_PASSWORD_RESTRICTION" },
      {0x52E, "Logon failure: unknown user name or bad password.", "ERROR_LOGON_FAILURE" },
      {0x52F, "Logon failure: user account restriction. Possible reasons are blank passwords not allowed, logon hour restrictions, or a policy restriction has been enforced.", "ERROR_ACCOUNT_RESTRICTION" },
      {0x530, "Logon failure: account logon time restriction violation.", "ERROR_INVALID_LOGON_HOURS" },
      {0x531, "Logon failure: user not allowed to log on to this computer.", "ERROR_INVALID_WORKSTATION" },
      {0x532, "Logon failure: the specified account password has expired.", "ERROR_PASSWORD_EXPIRED" },
      {0x533, "Logon failure: account currently disabled.", "ERROR_ACCOUNT_DISABLED" },
      {0x534, "No mapping between account names and security IDs was done.", "ERROR_NONE_MAPPED" },
      {0x535, "Too many local user identifiers (LUIDs) were requested at one time.", "ERROR_TOO_MANY_LUIDS_REQUESTED" },
      {0x536, "No more local user identifiers (LUIDs) are available.", "ERROR_LUIDS_EXHAUSTED" },
      {0x537, "The subauthority part of a security ID is invalid for this particular use.", "ERROR_INVALID_SUB_AUTHORITY" },
      {0x538, "The access control list (ACL) structure is invalid.", "ERROR_INVALID_ACL" },
      {0x539, "The security ID structure is invalid.", "ERROR_INVALID_SID" },
      {0x53A, "The security descriptor structure is invalid.", "ERROR_INVALID_SECURITY_DESCR" },
      {0x53C, "The inherited access control list (ACL) or access control entry (ACE) could not be built.", "ERROR_BAD_INHERITANCE_ACL" },
      {0x53D, "The server is currently disabled.", "ERROR_SERVER_DISABLED" },
      {0x53E, "The server is currently enabled.", "ERROR_SERVER_NOT_DISABLED" },
      {0x53F, "The value provided was an invalid value for an identifier authority.", "ERROR_INVALID_ID_AUTHORITY" },
      {0x540, "No more memory is available for security information updates.", "ERROR_ALLOTTED_SPACE_EXCEEDED" },
      {0x541, "The specified attributes are invalid, or incompatible with the attributes for the group as a whole.", "ERROR_INVALID_GROUP_ATTRIBUTES" },
      {0x542, "Either a required impersonation level was not provided, or the provided impersonation level is invalid.", "ERROR_BAD_IMPERSONATION_LEVEL" },
      {0x543, "Cannot open an anonymous level security token.", "ERROR_CANT_OPEN_ANONYMOUS" },
      {0x544, "The validation information class requested was invalid.", "ERROR_BAD_VALIDATION_CLASS" },
      {0x545, "The type of the token is inappropriate for its attempted use.", "ERROR_BAD_TOKEN_TYPE" },
      {0x546, "Unable to perform a security operation on an object that has no associated security.", "ERROR_NO_SECURITY_ON_OBJECT" },
      {0x547, "Configuration information could not be read from the domain controller, either because the machine is unavailable, or access has been denied.", "ERROR_CANT_ACCESS_DOMAIN_INFO" },
      {0x548, "The security account manager (SAM) or local security authority (LSA) server was in the wrong state to perform the security operation.", "ERROR_INVALID_SERVER_STATE" },
      {0x549, "The domain was in the wrong state to perform the security operation.", "ERROR_INVALID_DOMAIN_STATE" },
      {0x54A, "This operation is only allowed for the Primary Domain Controller of the domain.", "ERROR_INVALID_DOMAIN_ROLE" },
      {0x54B, "The specified domain either does not exist or could not be contacted.", "ERROR_NO_SUCH_DOMAIN" },
      {0x54C, "The specified domain already exists.", "ERROR_DOMAIN_EXISTS" },
      {0x54D, "An attempt was made to exceed the limit on the number of domains per server.", "ERROR_DOMAIN_LIMIT_EXCEEDED" },
      {0x54E, "Unable to complete the requested operation because of either a catastrophic media failure or a data structure corruption on the disk.", "ERROR_INTERNAL_DB_CORRUPTION" },
      {0x54F, "An internal error occurred.", "ERROR_INTERNAL_ERROR" },
      {0x550, "Generic access types were contained in an access mask which should already be mapped to nongeneric types.", "ERROR_GENERIC_NOT_MAPPED" },
      {0x551, "A security descriptor is not in the right format (absolute or self-relative).", "ERROR_BAD_DESCRIPTOR_FORMAT" },
      {0x552, "The requested action is restricted for use by logon processes only. The calling process has not registered as a logon process.", "ERROR_NOT_LOGON_PROCESS" },
      {0x553, "Cannot start a new logon session with an ID that is already in use.", "ERROR_LOGON_SESSION_EXISTS" },
      {0x554, "A specified authentication package is unknown.", "ERROR_NO_SUCH_PACKAGE" },
      {0x555, "The logon session is not in a state that is consistent with the requested operation.", "ERROR_BAD_LOGON_SESSION_STATE" },
      {0x556, "The logon session ID is already in use.", "ERROR_LOGON_SESSION_COLLISION" },
      {0x557, "A logon request contained an invalid logon type value.", "ERROR_INVALID_LOGON_TYPE" },
      {0x558, "Unable to impersonate using a named pipe until data has been read from that pipe.", "ERROR_CANNOT_IMPERSONATE" },
      {0x559, "The transaction state of a registry subtree is incompatible with the requested operation.", "ERROR_RXACT_INVALID_STATE" },
      {0x55A, "An internal security database corruption has been encountered.", "ERROR_RXACT_COMMIT_FAILURE" },
      {0x55B, "Cannot perform this operation on built-in accounts.", "ERROR_SPECIAL_ACCOUNT" },
      {0x55C, "Cannot perform this operation on this built-in special group.", "ERROR_SPECIAL_GROUP" },
      {0x55D, "Cannot perform this operation on this built-in special user.", "ERROR_SPECIAL_USER" },
      {0x55E, "The user cannot be removed from a group because the group is currently the user's primary group.", "ERROR_MEMBERS_PRIMARY_GROUP" },
      {0x55F, "The token is already in use as a primary token.", "ERROR_TOKEN_ALREADY_IN_USE" },
      {0x560, "The specified local group does not exist.", "ERROR_NO_SUCH_ALIAS" },
      {0x561, "The specified account name is not a member of the local group.", "ERROR_MEMBER_NOT_IN_ALIAS" },
      {0x562, "The specified account name is already a member of the local group.", "ERROR_MEMBER_IN_ALIAS" },
      {0x563, "The specified local group already exists.", "ERROR_ALIAS_EXISTS" },
      {0x564, "Logon failure: the user has not been granted the requested logon type at this computer.", "ERROR_LOGON_NOT_GRANTED" },
      {0x565, "The maximum number of secrets that may be stored in a single system has been exceeded.", "ERROR_TOO_MANY_SECRETS" },
      {0x566, "The length of a secret exceeds the maximum length allowed.", "ERROR_SECRET_TOO_LONG" },
      {0x567, "The local security authority database contains an internal inconsistency.", "ERROR_INTERNAL_DB_ERROR" },
      {0x568, "During a logon attempt, the user's security context accumulated too many security IDs.", "ERROR_TOO_MANY_CONTEXT_IDS" },
      {0x569, "Logon failure: the user has not been granted the requested logon type at this computer.", "ERROR_LOGON_TYPE_NOT_GRANTED" },
      {0x56A, "A cross-encrypted password is necessary to change a user password.", "ERROR_NT_CROSS_ENCRYPTION_REQUIRED" },
      {0x56B, "A new member could not be added to or removed from the local group because the member does not exist.", "ERROR_NO_SUCH_MEMBER" },
      {0x56C, "A new member could not be added to a local group because the member has the wrong account type.", "ERROR_INVALID_MEMBER" },
      {0x56D, "Too many security IDs have been specified.", "ERROR_TOO_MANY_SIDS" },
      {0x56E, "A cross-encrypted password is necessary to change this user password.", "ERROR_LM_CROSS_ENCRYPTION_REQUIRED" },
      {0x56F, "Indicates an ACL contains no inheritable components.", "ERROR_NO_INHERITANCE" },
      {0x570, "The file or directory is corrupted and unreadable.", "ERROR_FILE_CORRUPT" },
      {0x571, "The disk structure is corrupted and unreadable.", "ERROR_DISK_CORRUPT" },
      {0x572, "There is no user session key for the specified logon session.", "ERROR_NO_USER_SESSION_KEY" },
      {0x573, "The service being accessed is licensed for a particular number of connections. No more connections can be made to the service at this time because there are already as many connections as the service can accept.", "ERROR_LICENSE_QUOTA_EXCEEDED" },
      {0x574, "Logon Failure: The target account name is incorrect.", "ERROR_WRONG_TARGET_NAME" },
      {0x575, "Mutual Authentication failed. The server's password is out of date at the domain controller.", "ERROR_MUTUAL_AUTH_FAILED" },
      {0x576, "There is a time and/or date difference between the client and server.", "ERROR_TIME_SKEW" },
      {0x577, "This operation cannot be performed on the current domain.", "ERROR_CURRENT_DOMAIN_NOT_ALLOWED" },
      {0x578, "Invalid window handle.", "ERROR_INVALID_WINDOW_HANDLE" },
      {0x579, "Invalid menu handle.", "ERROR_INVALID_MENU_HANDLE" },
      {0x57A, "Invalid cursor handle.", "ERROR_INVALID_CURSOR_HANDLE" },
      {0x57B, "Invalid accelerator table handle.", "ERROR_INVALID_ACCEL_HANDLE" },
      {0x57C, "Invalid hook handle.", "ERROR_INVALID_HOOK_HANDLE" },
      {0x57D, "Invalid handle to a multiple-window position structure.", "ERROR_INVALID_DWP_HANDLE" },
      {0x57E, "Cannot create a top-level child window.", "ERROR_TLW_WITH_WSCHILD" },
      {0x57F, "Cannot find window class.", "ERROR_CANNOT_FIND_WND_CLASS" },
      {0x580, "Invalid window; it belongs to other thread.", "ERROR_WINDOW_OF_OTHER_THREAD" },
      {0x581, "Hot key is already registered.", "ERROR_HOTKEY_ALREADY_REGISTERED" },
      {0x582, "Class already exists.", "ERROR_CLASS_ALREADY_EXISTS" },
      {0x583, "Class does not exist.", "ERROR_CLASS_DOES_NOT_EXIST" },
      {0x584, "Class still has open windows.", "ERROR_CLASS_HAS_WINDOWS" },
      {0x585, "Invalid index.", "ERROR_INVALID_INDEX" },
      {0x586, "Invalid icon handle.", "ERROR_INVALID_ICON_HANDLE" },
      {0x587, "Using private DIALOG window words.", "ERROR_PRIVATE_DIALOG_INDEX" },
      {0x588, "The list box identifier was not found.", "ERROR_LISTBOX_ID_NOT_FOUND" },
      {0x589, "No wildcards were found.", "ERROR_NO_WILDCARD_CHARACTERS" },
      {0x58A, "Thread does not have a clipboard open.", "ERROR_CLIPBOARD_NOT_OPEN" },
      {0x58B, "Hot key is not registered.", "ERROR_HOTKEY_NOT_REGISTERED" },
      {0x58C, "The window is not a valid dialog window.", "ERROR_WINDOW_NOT_DIALOG" },
      {0x58D, "Control ID not found.", "ERROR_CONTROL_ID_NOT_FOUND" },
      {0x58E, "Invalid message for a combo box because it does not have an edit control.", "ERROR_INVALID_COMBOBOX_MESSAGE" },
      {0x58F, "The window is not a combo box.", "ERROR_WINDOW_NOT_COMBOBOX" },
      {0x590, "Height must be less than 256.", "ERROR_INVALID_EDIT_HEIGHT" },
      {0x591, "Invalid device context (DC) handle.", "ERROR_DC_NOT_FOUND" },
      {0x592, "Invalid hook procedure type.", "ERROR_INVALID_HOOK_FILTER" },
      {0x593, "Invalid hook procedure.", "ERROR_INVALID_FILTER_PROC" },
      {0x594, "Cannot set nonlocal hook without a module handle.", "ERROR_HOOK_NEEDS_HMOD" },
      {0x595, "This hook procedure can only be set globally.", "ERROR_GLOBAL_ONLY_HOOK" },
      {0x596, "The journal hook procedure is already installed.", "ERROR_JOURNAL_HOOK_SET" },
      {0x597, "The hook procedure is not installed.", "ERROR_HOOK_NOT_INSTALLED" },
      {0x598, "Invalid message for single-selection list box.", "ERROR_INVALID_LB_MESSAGE" },
      {0x599, "LB_SETCOUNT sent to non-lazy list box.", "ERROR_SETCOUNT_ON_BAD_LB" },
      {0x59A, "This list box does not support tab stops.", "ERROR_LB_WITHOUT_TABSTOPS" },
      {0x59B, "Cannot destroy object created by another thread.", "ERROR_DESTROY_OBJECT_OF_OTHER_THREAD" },
      {0x59C, "Child windows cannot have menus.", "ERROR_CHILD_WINDOW_MENU" },
      {0x59D, "The window does not have a system menu.", "ERROR_NO_SYSTEM_MENU" },
      {0x59E, "Invalid message box style.", "ERROR_INVALID_MSGBOX_STYLE" },
      {0x59F, "Invalid system-wide (SPI_*) parameter.", "ERROR_INVALID_SPI_VALUE" },
      {0x5A0, "Screen already locked.", "ERROR_SCREEN_ALREADY_LOCKED" },
      {0x5A1, "All handles to windows in a multiple-window position structure must have the same parent.", "ERROR_HWNDS_HAVE_DIFF_PARENT" },
      {0x5A2, "The window is not a child window.", "ERROR_NOT_CHILD_WINDOW" },
      {0x5A3, "Invalid GW_* command.", "ERROR_INVALID_GW_COMMAND" },
      {0x5A4, "Invalid thread identifier.", "ERROR_INVALID_THREAD_ID" },
      {0x5A5, "Cannot process a message from a window that is not a multiple document interface (MDI) window.", "ERROR_NON_MDICHILD_WINDOW" },
      {0x5A6, "Popup menu already active.", "ERROR_POPUP_ALREADY_ACTIVE" },
      {0x5A7, "The window does not have scroll bars.", "ERROR_NO_SCROLLBARS" },
      {0x5A8, "Scroll bar range cannot be greater than MAXLONG.", "ERROR_INVALID_SCROLLBAR_RANGE" },
      {0x5A9, "Cannot show or remove the window in the way specified.", "ERROR_INVALID_SHOWWIN_COMMAND" },
      {0x5AA, "Insufficient system resources exist to complete the requested service.", "ERROR_NO_SYSTEM_RESOURCES" },
      {0x5AB, "Insufficient system resources exist to complete the requested service.", "ERROR_NONPAGED_SYSTEM_RESOURCES" },
      {0x5AC, "Insufficient system resources exist to complete the requested service.", "ERROR_PAGED_SYSTEM_RESOURCES" },
      {0x5AD, "Insufficient quota to complete the requested service.", "ERROR_WORKING_SET_QUOTA" },
      {0x5AE, "Insufficient quota to complete the requested service.", "ERROR_PAGEFILE_QUOTA" },
      {0x5AF, "The paging file is too small for this operation to complete.", "ERROR_COMMITMENT_LIMIT" },
      {0x5B0, "A menu item was not found.", "ERROR_MENU_ITEM_NOT_FOUND" },
      {0x5B1, "Invalid keyboard layout handle.", "ERROR_INVALID_KEYBOARD_HANDLE" },
      {0x5B2, "Hook type not allowed.", "ERROR_HOOK_TYPE_NOT_ALLOWED" },
      {0x5B3, "This operation requires an interactive window station.", "ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION" },
      {0x5B4, "This operation returned because the timeout period expired.", "ERROR_TIMEOUT" },
      {0x5B5, "Invalid monitor handle.", "ERROR_INVALID_MONITOR_HANDLE" },
      {0x5DC, "The event log file is corrupted.", "ERROR_EVENTLOG_FILE_CORRUPT" },
      {0x5DD, "No event log file could be opened, so the event logging service did not start.", "ERROR_EVENTLOG_CANT_START" },
      {0x5DE, "The event log file is full.", "ERROR_LOG_FILE_FULL" },
      {0x5DF, "The event log file has changed between read operations.", "ERROR_EVENTLOG_FILE_CHANGED" },
      {0x641, "The Windows Installer service could not be accessed. This can occur if you are running Windows in safe mode, or if the Windows Installer is not correctly installed. Contact your support personnel for assistance.", "ERROR_INSTALL_SERVICE_FAILURE" },
      {0x642, "User cancelled installation.", "ERROR_INSTALL_USEREXIT" },
      {0x643, "Fatal error during installation.", "ERROR_INSTALL_FAILURE" },
      {0x644, "Installation suspended, incomplete.", "ERROR_INSTALL_SUSPEND" },
      {0x645, "This action is only valid for products that are currently installed.", "ERROR_UNKNOWN_PRODUCT" },
      {0x646, "Feature ID not registered.", "ERROR_UNKNOWN_FEATURE" },
      {0x647, "Component ID not registered.", "ERROR_UNKNOWN_COMPONENT" },
      {0x648, "Unknown property.", "ERROR_UNKNOWN_PROPERTY" },
      {0x649, "Handle is in an invalid state.", "ERROR_INVALID_HANDLE_STATE" },
      {0x64A, "The configuration data for this product is corrupt. Contact your support personnel.", "ERROR_BAD_CONFIGURATION" },
      {0x64B, "Component qualifier not present.", "ERROR_INDEX_ABSENT" },
      {0x64C, "The installation source for this product is not available. Verify that the source exists and that you can access it.", "ERROR_INSTALL_SOURCE_ABSENT" },
      {0x64D, "This installation package cannot be installed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.", "ERROR_INSTALL_PACKAGE_VERSION" },
      {0x64E, "Product is uninstalled.", "ERROR_PRODUCT_UNINSTALLED" },
      {0x64F, "SQL query syntax invalid or unsupported.", "ERROR_BAD_QUERY_SYNTAX" },
      {0x650, "Record field does not exist.", "ERROR_INVALID_FIELD" },
      {0x651, "The device has been removed.", "ERROR_DEVICE_REMOVED" },
      {0x652, "Another installation is already in progress. Complete that installation before proceeding with this install.", "ERROR_INSTALL_ALREADY_RUNNING" },
      {0x653, "This installation package could not be opened. Verify that the package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer package.", "ERROR_INSTALL_PACKAGE_OPEN_FAILED" },
      {0x654, "This installation package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer package.", "ERROR_INSTALL_PACKAGE_INVALID" },
      {0x655, "There was an error starting the Windows Installer service user interface. Contact your support personnel.", "ERROR_INSTALL_UI_FAILURE" },
      {0x656, "Error opening installation log file. Verify that the specified log file location exists and that you can write to it.", "ERROR_INSTALL_LOG_FAILURE" },
      {0x657, "The language of this installation package is not supported by your system.", "ERROR_INSTALL_LANGUAGE_UNSUPPORTED" },
      {0x658, "Error applying transforms. Verify that the specified transform paths are valid.", "ERROR_INSTALL_TRANSFORM_FAILURE" },
      {0x659, "This installation is forbidden by system policy. Contact your system administrator.", "ERROR_INSTALL_PACKAGE_REJECTED" },
      {0x65A, "Function could not be executed.", "ERROR_FUNCTION_NOT_CALLED" },
      {0x65B, "Function failed during execution.", "ERROR_FUNCTION_FAILED" },
      {0x65C, "Invalid or unknown table specified.", "ERROR_INVALID_TABLE" },
      {0x65D, "Data supplied is of wrong type.", "ERROR_DATATYPE_MISMATCH" },
      {0x65E, "Data of this type is not supported.", "ERROR_UNSUPPORTED_TYPE" },
      {0x65F, "The Windows Installer service failed to start. Contact your support personnel.", "ERROR_CREATE_FAILED" },
      {0x660, "The Temp folder is on a drive that is full or inaccessible. Free up space on the drive or verify that you have write permission on the Temp folder.", "ERROR_INSTALL_TEMP_UNWRITABLE" },
      {0x661, "This installation package is not supported by this processor type. Contact your product vendor.", "ERROR_INSTALL_PLATFORM_UNSUPPORTED" },
      {0x662, "Component not used on this computer.", "ERROR_INSTALL_NOTUSED" },
      {0x663, "This patch package could not be opened. Verify that the patch package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer patch package.", "ERROR_PATCH_PACKAGE_OPEN_FAILED" },
      {0x664, "This patch package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer patch package.", "ERROR_PATCH_PACKAGE_INVALID" },
      {0x665, "This patch package cannot be processed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.", "ERROR_PATCH_PACKAGE_UNSUPPORTED" },
      {0x666, "Another version of this product is already installed. Installation of this version cannot continue. To configure or remove the existing version of this product, use Add/Remove Programs on the Control Panel.", "ERROR_PRODUCT_VERSION" },
      {0x667, "Invalid command line argument. Consult the Windows Installer SDK for detailed command line help.", "ERROR_INVALID_COMMAND_LINE" },
      {0x668, "Only administrators have permission to add, remove, or configure server software during a Terminal Services remote session. If you want to install or configure software on the server, contact your network administrator.", "ERROR_INSTALL_REMOTE_DISALLOWED" },
      {0x669, "The requested operation completed successfully. The system will be restarted so the changes can take effect.", "ERROR_SUCCESS_REBOOT_INITIATED" },
      {0x66A, "The upgrade patch cannot be installed by the Windows Installer service because the program to be upgraded may be missing, or the upgrade patch may update a different version of the program. Verify that the program to be upgraded exists on your computer and that you have the correct upgrade patch.", "ERROR_PATCH_TARGET_NOT_FOUND" },
      {0x66B, "The patch package is not permitted by software restriction policy.", "ERROR_PATCH_PACKAGE_REJECTED" },
      {0x66C, "One or more customizations are not permitted by software restriction policy.", "ERROR_INSTALL_TRANSFORM_REJECTED" },
      {0x66D, "The Windows Installer does not permit installation from a Remote Desktop Connection.", "ERROR_INSTALL_REMOTE_PROHIBITED" },
      {0x6A4, "The string binding is invalid.", "RPC_S_INVALID_STRING_BINDING" },
      {0x6A5, "The binding handle is not the correct type.", "RPC_S_WRONG_KIND_OF_BINDING" },
      {0x6A6, "The binding handle is invalid.", "RPC_S_INVALID_BINDING" },
      {0x6A7, "The RPC protocol sequence is not supported.", "RPC_S_PROTSEQ_NOT_SUPPORTED" },
      {0x6A8, "The RPC protocol sequence is invalid.", "RPC_S_INVALID_RPC_PROTSEQ" },
      {0x6A9, "The string universal unique identifier (UUID) is invalid.", "RPC_S_INVALID_STRING_UUID" },
      {0x6AA, "The endpoint format is invalid.", "RPC_S_INVALID_ENDPOINT_FORMAT" },
      {0x6AB, "The network address is invalid.", "RPC_S_INVALID_NET_ADDR" },
      {0x6AC, "No endpoint was found.", "RPC_S_NO_ENDPOINT_FOUND" },
      {0x6AD, "The timeout value is invalid.", "RPC_S_INVALID_TIMEOUT" },
      {0x6AE, "The object universal unique identifier (UUID) was not found.", "RPC_S_OBJECT_NOT_FOUND" },
      {0x6AF, "The object universal unique identifier (UUID) has already been registered.", "RPC_S_ALREADY_REGISTERED" },
      {0x6B0, "The type universal unique identifier (UUID) has already been registered.", "RPC_S_TYPE_ALREADY_REGISTERED" },
      {0x6B1, "The RPC server is already listening.", "RPC_S_ALREADY_LISTENING" },
      {0x6B2, "No protocol sequences have been registered.", "RPC_S_NO_PROTSEQS_REGISTERED" },
      {0x6B3, "The RPC server is not listening.", "RPC_S_NOT_LISTENING" },
      {0x6B4, "The manager type is unknown.", "RPC_S_UNKNOWN_MGR_TYPE" },
      {0x6B5, "The interface is unknown.", "RPC_S_UNKNOWN_IF" },
      {0x6B6, "There are no bindings.", "RPC_S_NO_BINDINGS" },
      {0x6B7, "There are no protocol sequences.", "RPC_S_NO_PROTSEQS" },
      {0x6B8, "The endpoint cannot be created.", "RPC_S_CANT_CREATE_ENDPOINT" },
      {0x6B9, "Not enough resources are available to complete this operation.", "RPC_S_OUT_OF_RESOURCES" },
      {0x6BA, "The RPC server is unavailable.", "RPC_S_SERVER_UNAVAILABLE" },
      {0x6BB, "The RPC server is too busy to complete this operation.", "RPC_S_SERVER_TOO_BUSY" },
      {0x6BC, "The network options are invalid.", "RPC_S_INVALID_NETWORK_OPTIONS" },
      {0x6BD, "There are no remote procedure calls active on this thread.", "RPC_S_NO_CALL_ACTIVE" },
      {0x6BE, "The remote procedure call failed.", "RPC_S_CALL_FAILED" },
      {0x6BF, "The remote procedure call failed and did not execute.", "RPC_S_CALL_FAILED_DNE" },
      {0x6C0, "A remote procedure call (RPC) protocol error occurred.", "RPC_S_PROTOCOL_ERROR" },
      {0x6C2, "The transfer syntax is not supported by the RPC server.", "RPC_S_UNSUPPORTED_TRANS_SYN" },
      {0x6C4, "The universal unique identifier (UUID) type is not supported.", "RPC_S_UNSUPPORTED_TYPE" },
      {0x6C5, "The tag is invalid.", "RPC_S_INVALID_TAG" },
      {0x6C6, "The array bounds are invalid.", "RPC_S_INVALID_BOUND" },
      {0x6C7, "The binding does not contain an entry name.", "RPC_S_NO_ENTRY_NAME" },
      {0x6C8, "The name syntax is invalid.", "RPC_S_INVALID_NAME_SYNTAX" },
      {0x6C9, "The name syntax is not supported.", "RPC_S_UNSUPPORTED_NAME_SYNTAX" },
      {0x6CB, "No network address is available to use to construct a universal unique identifier (UUID).", "RPC_S_UUID_NO_ADDRESS" },
      {0x6CC, "The endpoint is a duplicate.", "RPC_S_DUPLICATE_ENDPOINT" },
      {0x6CD, "The authentication type is unknown.", "RPC_S_UNKNOWN_AUTHN_TYPE" },
      {0x6CE, "The maximum number of calls is too small.", "RPC_S_MAX_CALLS_TOO_SMALL" },
      {0x6CF, "The string is too long.", "RPC_S_STRING_TOO_LONG" },
      {0x6D0, "The RPC protocol sequence was not found.", "RPC_S_PROTSEQ_NOT_FOUND" },
      {0x6D1, "The procedure number is out of range.", "RPC_S_PROCNUM_OUT_OF_RANGE" },
      {0x6D2, "The binding does not contain any authentication information.", "RPC_S_BINDING_HAS_NO_AUTH" },
      {0x6D3, "The authentication service is unknown.", "RPC_S_UNKNOWN_AUTHN_SERVICE" },
      {0x6D4, "The authentication level is unknown.", "RPC_S_UNKNOWN_AUTHN_LEVEL" },
      {0x6D5, "The security context is invalid.", "RPC_S_INVALID_AUTH_IDENTITY" },
      {0x6D6, "The authorization service is unknown.", "RPC_S_UNKNOWN_AUTHZ_SERVICE" },
      {0x6D7, "The entry is invalid.", "EPT_S_INVALID_ENTRY" },
      {0x6D8, "The server endpoint cannot perform the operation.", "EPT_S_CANT_PERFORM_OP" },
      {0x6D9, "There are no more endpoints available from the endpoint mapper.", "EPT_S_NOT_REGISTERED" },
      {0x6DA, "No interfaces have been exported.", "RPC_S_NOTHING_TO_EXPORT" },
      {0x6DB, "The entry name is incomplete.", "RPC_S_INCOMPLETE_NAME" },
      {0x6DC, "The version option is invalid.", "RPC_S_INVALID_VERS_OPTION" },
      {0x6DD, "There are no more members.", "RPC_S_NO_MORE_MEMBERS" },
      {0x6DE, "There is nothing to unexport.", "RPC_S_NOT_ALL_OBJS_UNEXPORTED" },
      {0x6DF, "The interface was not found.", "RPC_S_INTERFACE_NOT_FOUND" },
      {0x6E0, "The entry already exists.", "RPC_S_ENTRY_ALREADY_EXISTS" },
      {0x6E1, "The entry is not found.", "RPC_S_ENTRY_NOT_FOUND" },
      {0x6E2, "The name service is unavailable.", "RPC_S_NAME_SERVICE_UNAVAILABLE" },
      {0x6E3, "The network address family is invalid.", "RPC_S_INVALID_NAF_ID" },
      {0x6E4, "The requested operation is not supported.", "RPC_S_CANNOT_SUPPORT" },
      {0x6E5, "No security context is available to allow impersonation.", "RPC_S_NO_CONTEXT_AVAILABLE" },
      {0x6E6, "An internal error occurred in a remote procedure call (RPC).", "RPC_S_INTERNAL_ERROR" },
      {0x6E7, "The RPC server attempted an integer division by zero.", "RPC_S_ZERO_DIVIDE" },
      {0x6E8, "An addressing error occurred in the RPC server.", "RPC_S_ADDRESS_ERROR" },
      {0x6E9, "A floating-point operation at the RPC server caused a division by zero.", "RPC_S_FP_DIV_ZERO" },
      {0x6EA, "A floating-point underflow occurred at the RPC server.", "RPC_S_FP_UNDERFLOW" },
      {0x6EB, "A floating-point overflow occurred at the RPC server.", "RPC_S_FP_OVERFLOW" },
      {0x6EC, "The list of RPC servers available for the binding of auto handles has been exhausted.", "RPC_X_NO_MORE_ENTRIES" },
      {0x6ED, "Unable to open the character translation table file.", "RPC_X_SS_CHAR_TRANS_OPEN_FAIL" },
      {0x6EE, "The file containing the character translation table has fewer than 512 bytes.", "RPC_X_SS_CHAR_TRANS_SHORT_FILE" },
      {0x6EF, "A null context handle was passed from the client to the host during a remote procedure call.", "RPC_X_SS_IN_NULL_CONTEXT" },
      {0x6F1, "The context handle changed during a remote procedure call.", "RPC_X_SS_CONTEXT_DAMAGED" },
      {0x6F2, "The binding handles passed to a remote procedure call do not match.", "RPC_X_SS_HANDLES_MISMATCH" },
      {0x6F3, "The stub is unable to get the remote procedure call handle.", "RPC_X_SS_CANNOT_GET_CALL_HANDLE" },
      {0x6F4, "A null reference pointer was passed to the stub.", "RPC_X_NULL_REF_POINTER" },
      {0x6F5, "The enumeration value is out of range.", "RPC_X_ENUM_VALUE_OUT_OF_RANGE" },
      {0x6F6, "The byte count is too small.", "RPC_X_BYTE_COUNT_TOO_SMALL" },
      {0x6F7, "The stub received bad data.", "RPC_X_BAD_STUB_DATA" },
      {0x6F8, "The supplied user buffer is not valid for the requested operation.", "ERROR_INVALID_USER_BUFFER" },
      {0x6F9, "The disk media is not recognized. It may not be formatted.", "ERROR_UNRECOGNIZED_MEDIA" },
      {0x6FA, "The workstation does not have a trust secret.", "ERROR_NO_TRUST_LSA_SECRET" },
      {0x6FB, "The security database on the server does not have a computer account for this workstation trust relationship.", "ERROR_NO_TRUST_SAM_ACCOUNT" },
      {0x6FC, "The trust relationship between the primary domain and the trusted domain failed.", "ERROR_TRUSTED_DOMAIN_FAILURE" },
      {0x6FD, "The trust relationship between this workstation and the primary domain failed.", "ERROR_TRUSTED_RELATIONSHIP_FAILURE" },
      {0x6FE, "The network logon failed.", "ERROR_TRUST_FAILURE" },
      {0x6FF, "A remote procedure call is already in progress for this thread.", "RPC_S_CALL_IN_PROGRESS" },
      {0x700, "An attempt was made to logon, but the network logon service was not started.", "ERROR_NETLOGON_NOT_STARTED" },
      {0x701, "The user's account has expired.", "ERROR_ACCOUNT_EXPIRED" },
      {0x702, "The redirector is in use and cannot be unloaded.", "ERROR_REDIRECTOR_HAS_OPEN_HANDLES" },
      {0x703, "The specified printer driver is already installed.", "ERROR_PRINTER_DRIVER_ALREADY_INSTALLED" },
      {0x704, "The specified port is unknown.", "ERROR_UNKNOWN_PORT" },
      {0x705, "The printer driver is unknown.", "ERROR_UNKNOWN_PRINTER_DRIVER" },
      {0x706, "The print processor is unknown.", "ERROR_UNKNOWN_PRINTPROCESSOR" },
      {0x707, "The specified separator file is invalid.", "ERROR_INVALID_SEPARATOR_FILE" },
      {0x708, "The specified priority is invalid.", "ERROR_INVALID_PRIORITY" },
      {0x709, "The printer name is invalid.", "ERROR_INVALID_PRINTER_NAME" },
      {0x70A, "The printer already exists.", "ERROR_PRINTER_ALREADY_EXISTS" },
      {0x70B, "The printer command is invalid.", "ERROR_INVALID_PRINTER_COMMAND" },
      {0x70C, "The specified datatype is invalid.", "ERROR_INVALID_DATATYPE" },
      {0x70D, "The environment specified is invalid.", "ERROR_INVALID_ENVIRONMENT" },
      {0x70E, "There are no more bindings.", "RPC_S_NO_MORE_BINDINGS" },
      {0x70F, "The account used is an interdomain trust account. Use your global user account or local user account to access this server.", "ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT" },
      {0x710, "The account used is a computer account. Use your global user account or local user account to access this server.", "ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT" },
      {0x711, "The account used is a server trust account. Use your global user account or local user account to access this server.", "ERROR_NOLOGON_SERVER_TRUST_ACCOUNT" },
      {0x712, "The name or security ID (SID) of the domain specified is inconsistent with the trust information for that domain.", "ERROR_DOMAIN_TRUST_INCONSISTENT" },
      {0x713, "The server is in use and cannot be unloaded.", "ERROR_SERVER_HAS_OPEN_HANDLES" },
      {0x714, "The specified image file did not contain a resource section.", "ERROR_RESOURCE_DATA_NOT_FOUND" },
      {0x715, "The specified resource type cannot be found in the image file.", "ERROR_RESOURCE_TYPE_NOT_FOUND" },
      {0x716, "The specified resource name cannot be found in the image file.", "ERROR_RESOURCE_NAME_NOT_FOUND" },
      {0x717, "The specified resource language ID cannot be found in the image file.", "ERROR_RESOURCE_LANG_NOT_FOUND" },
      {0x718, "Not enough quota is available to process this command.", "ERROR_NOT_ENOUGH_QUOTA" },
      {0x719, "No interfaces have been registered.", "RPC_S_NO_INTERFACES" },
      {0x71A, "The remote procedure call was cancelled.", "RPC_S_CALL_CANCELLED" },
      {0x71B, "The binding handle does not contain all required information.", "RPC_S_BINDING_INCOMPLETE" },
      {0x71C, "A communications failure occurred during a remote procedure call.", "RPC_S_COMM_FAILURE" },
      {0x71D, "The requested authentication level is not supported.", "RPC_S_UNSUPPORTED_AUTHN_LEVEL" },
      {0x71E, "No principal name registered.", "RPC_S_NO_PRINC_NAME" },
      {0x71F, "The error specified is not a valid Windows RPC error code.", "RPC_S_NOT_RPC_ERROR" },
      {0x720, "A UUID that is valid only on this computer has been allocated.", "RPC_S_UUID_LOCAL_ONLY" },
      {0x721, "A security package specific error occurred.", "RPC_S_SEC_PKG_ERROR" },
      {0x722, "Thread is not canceled.", "RPC_S_NOT_CANCELLED" },
      {0x723, "Invalid operation on the encoding/decoding handle.", "RPC_X_INVALID_ES_ACTION" },
      {0x724, "Incompatible version of the serializing package.", "RPC_X_WRONG_ES_VERSION" },
      {0x725, "Incompatible version of the RPC stub.", "RPC_X_WRONG_STUB_VERSION" },
      {0x726, "The RPC pipe object is invalid or corrupted.", "RPC_X_INVALID_PIPE_OBJECT" },
      {0x727, "An invalid operation was attempted on an RPC pipe object.", "RPC_X_WRONG_PIPE_ORDER" },
      {0x728, "Unsupported RPC pipe version.", "RPC_X_WRONG_PIPE_VERSION" },
      {0x76A, "The group member was not found.", "RPC_S_GROUP_MEMBER_NOT_FOUND" },
      {0x76B, "The endpoint mapper database entry could not be created.", "EPT_S_CANT_CREATE" },
      {0x76C, "The object universal unique identifier (UUID) is the nil UUID.", "RPC_S_INVALID_OBJECT" },
      {0x76D, "The specified time is invalid.", "ERROR_INVALID_TIME" },
      {0x76E, "The specified form name is invalid.", "ERROR_INVALID_FORM_NAME" },
      {0x76F, "The specified form size is invalid.", "ERROR_INVALID_FORM_SIZE" },
      {0x770, "The specified printer handle is already being waited on", "ERROR_ALREADY_WAITING" },
      {0x771, "The specified printer has been deleted.", "ERROR_PRINTER_DELETED" },
      {0x772, "The state of the printer is invalid.", "ERROR_INVALID_PRINTER_STATE" },
      {0x773, "The user's password must be changed before logging on the first time.", "ERROR_PASSWORD_MUST_CHANGE" },
      {0x774, "Could not find the domain controller for this domain.", "ERROR_DOMAIN_CONTROLLER_NOT_FOUND" },
      {0x775, "The referenced account is currently locked out and may not be used to log on.", "ERROR_ACCOUNT_LOCKED_OUT" },
      {0x776, "The object exporter specified was not found.", "OR_INVALID_OXID" },
      {0x777, "The object specified was not found.", "OR_INVALID_OID" },
      {0x778, "The object resolver set specified was not found.", "OR_INVALID_SET" },
      {0x779, "Some data remains to be sent in the request buffer.", "RPC_S_SEND_INCOMPLETE" },
      {0x77A, "Invalid asynchronous remote procedure call handle.", "RPC_S_INVALID_ASYNC_HANDLE" },
      {0x77B, "Invalid asynchronous RPC call handle for this operation.", "RPC_S_INVALID_ASYNC_CALL" },
      {0x77C, "The RPC pipe object has already been closed.", "RPC_X_PIPE_CLOSED" },
      {0x77D, "The RPC call completed before all pipes were processed.", "RPC_X_PIPE_DISCIPLINE_ERROR" },
      {0x77E, "No more data is available from the RPC pipe.", "RPC_X_PIPE_EMPTY" },
      {0x77F, "No site name is available for this machine.", "ERROR_NO_SITENAME" },
      {0x780, "The file cannot be accessed by the system.", "ERROR_CANT_ACCESS_FILE" },
      {0x781, "The name of the file cannot be resolved by the system.", "ERROR_CANT_RESOLVE_FILENAME" },
      {0x782, "The entry is not of the expected type.", "RPC_S_ENTRY_TYPE_MISMATCH" },
      {0x783, "Not all object UUIDs could be exported to the specified entry.", "RPC_S_NOT_ALL_OBJS_EXPORTED" },
      {0x784, "Interface could not be exported to the specified entry.", "RPC_S_INTERFACE_NOT_EXPORTED" },
      {0x785, "The specified profile entry could not be added.", "RPC_S_PROFILE_NOT_ADDED" },
      {0x786, "The specified profile element could not be added.", "RPC_S_PRF_ELT_NOT_ADDED" },
      {0x787, "The specified profile element could not be removed.", "RPC_S_PRF_ELT_NOT_REMOVED" },
      {0x788, "The group element could not be added.", "RPC_S_GRP_ELT_NOT_ADDED" },
      {0x789, "The group element could not be removed.", "RPC_S_GRP_ELT_NOT_REMOVED" },
      {0x78A, "The printer driver is not compatible with a policy enabled on your computer that blocks NT 4.0 drivers.", "ERROR_KM_DRIVER_BLOCKED" },
      {0x78B, "The context has expired and can no longer be used.", "ERROR_CONTEXT_EXPIRED" },
      {0x78C, "The current user's delegated trust creation quota has been exceeded.", "ERROR_PER_USER_TRUST_QUOTA_EXCEEDED" },
      {0x78D, "The total delegated trust creation quota has been exceeded.", "ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED" },
      {0x78E, "The current user's delegated trust deletion quota has been exceeded.", "ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED" },
      {0x7D0, "The pixel format is invalid.", "ERROR_INVALID_PIXEL_FORMAT" },
      {0x7D1, "The specified driver is invalid.", "ERROR_BAD_DRIVER" },
      {0x7D2, "The window style or class attribute is invalid for this operation.", "ERROR_INVALID_WINDOW_STYLE" },
      {0x7D3, "The requested metafile operation is not supported.", "ERROR_METAFILE_NOT_SUPPORTED" },
      {0x7D4, "The requested transformation operation is not supported.", "ERROR_TRANSFORM_NOT_SUPPORTED" },
      {0x7D5, "The requested clipping operation is not supported.", "ERROR_CLIPPING_NOT_SUPPORTED" },
      {0x7DA, "The specified color management module is invalid.", "ERROR_INVALID_CMM" },
      {0x7DB, "The specified color profile is invalid.", "ERROR_INVALID_PROFILE" },
      {0x7DC, "The specified tag was not found.", "ERROR_TAG_NOT_FOUND" },
      {0x7DD, "A required tag is not present.", "ERROR_TAG_NOT_PRESENT" },
      {0x7DE, "The specified tag is already present.", "ERROR_DUPLICATE_TAG" },
      {0x7DF, "The specified color profile is not associated with any device.", "ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE" },
      {0x7E0, "The specified color profile was not found.", "ERROR_PROFILE_NOT_FOUND" },
      {0x7E1, "The specified color space is invalid.", "ERROR_INVALID_COLORSPACE" },
      {0x7E2, "Image Color Management is not enabled.", "ERROR_ICM_NOT_ENABLED" },
      {0x7E3, "There was an error while deleting the color transform.", "ERROR_DELETING_ICM_XFORM" },
      {0x7E4, "The specified color transform is invalid.", "ERROR_INVALID_TRANSFORM" },
      {0x7E5, "The specified transform does not match the bitmap's color space.", "ERROR_COLORSPACE_MISMATCH" },
      {0x7E6, "The specified named color index is not present in the profile.", "ERROR_INVALID_COLORINDEX" },
      {0x83C, "The network connection was made successfully, but the user had to be prompted for a password other than the one originally specified.", "ERROR_CONNECTED_OTHER_PASSWORD" },
      {0x83D, "The network connection was made successfully using default credentials.", "ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT" },
      {0x89A, "The specified username is invalid.", "ERROR_BAD_USERNAME" },
      {0x8CA, "This network connection does not exist.", "ERROR_NOT_CONNECTED" },
      {0x961, "This network connection has files open or requests pending.", "ERROR_OPEN_FILES" },
      {0x962, "Active connections still exist.", "ERROR_ACTIVE_CONNECTIONS" },
      {0x964, "The device is in use by an active process and cannot be disconnected.", "ERROR_DEVICE_IN_USE" },
      {0xBB8, "The specified print monitor is unknown.", "ERROR_UNKNOWN_PRINT_MONITOR" },
      {0xBB9, "The specified printer driver is currently in use.", "ERROR_PRINTER_DRIVER_IN_USE" },
      {0xBBA, "The spool file was not found.", "ERROR_SPOOL_FILE_NOT_FOUND" },
      {0xBBB, "A StartDocPrinter call was not issued.", "ERROR_SPL_NO_STARTDOC" },
      {0xBBC, "An AddJob call was not issued.", "ERROR_SPL_NO_ADDJOB" },
      {0xBBD, "The specified print processor has already been installed.", "ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED" },
      {0xBBE, "The specified print monitor has already been installed.", "ERROR_PRINT_MONITOR_ALREADY_INSTALLED" },
      {0xBBF, "The specified print monitor does not have the required functions.", "ERROR_INVALID_PRINT_MONITOR" },
      {0xBC0, "The specified print monitor is currently in use.", "ERROR_PRINT_MONITOR_IN_USE" },
      {0xBC1, "The requested operation is not allowed when there are jobs queued to the printer.", "ERROR_PRINTER_HAS_JOBS_QUEUED" },
      {0xBC2, "The requested operation is successful. Changes will not be effective until the system is rebooted.", "ERROR_SUCCESS_REBOOT_REQUIRED" },
      {0xBC3, "The requested operation is successful. Changes will not be effective until the service is restarted.", "ERROR_SUCCESS_RESTART_REQUIRED" },
      {0xBC4, "No printers were found.", "ERROR_PRINTER_NOT_FOUND" },
      {0xBC5, "The printer driver is known to be unreliable.", "ERROR_PRINTER_DRIVER_WARNED" },
      {0xBC6, "The printer driver is known to harm the system.", "ERROR_PRINTER_DRIVER_BLOCKED" },
      {0xC1C, "The XML contains an entity reference to an undefined entity.", "ERROR_XML_UNDEFINED_ENTITY" },
      {0xC1D, "The XML contains a malformed entity reference.", "ERROR_XML_MALFORMED_ENTITY" },
      {0xC1E, "The XML contains a character which is not permitted in XML.", "ERROR_XML_CHAR_NOT_IN_RANGE" },
      {0xC80, "The manifest contained a duplicate definition for external proxy stub %1 at (%1:%2,%3)", "ERROR_PCM_COMPILER_DUPLICATE_EXTERNAL_PROXY" },
      {0xC81, "The manifest already contains a reference to %4 - a second reference was found at (%1:%2,%3)", "ERROR_PCM_COMPILER_DUPLICATE_ASSEMBLY_REFERENCE" },
      {0xC82, "The assembly reference at (%1:%2,%3) is invalid.", "ERROR_PCM_COMPILER_INVALID_ASSEMBLY_REFERENCE" },
      {0xC83, "The assembly definition at (%1:%2,%3) is invalid.", "ERROR_PCM_COMPILER_INVALID_ASSEMBLY_DEFINITION" },
      {0xC84, "The manifest already contained the window class %4, found a second declaration at (%1:%2,%3)", "ERROR_PCM_COMPILER_DUPLICATE_WINDOW_CLASS" },
      {0xC85, "The manifest already declared the progId %4, found a second declaration at (%1:%2,%3)", "ERROR_PCM_COMPILER_DUPLICATE_PROGID" },
      {0xC86, "Only one noInherit tag may be present in a manifest, found a second tag at (%1:%2,%3)", "ERROR_PCM_COMPILER_DUPLICATE_NOINHERIT" },
      {0xC87, "Only one noInheritable tag may be present in a manifest, found a second tag at (%1:%2,%3)", "ERROR_PCM_COMPILER_DUPLICATE_NOINHERITABLE" },
      {0xC88, "The manifest contained a duplicate declaration of COM class %4 at (%1:%2,%3)", "ERROR_PCM_COMPILER_DUPLICATE_COM_CLASS" },
      {0xC89, "The manifest already declared the file %4, a second definition was found at (%1:%2,%3)", "ERROR_PCM_COMPILER_DUPLICATE_FILE_NAME" },
      {0xC8A, "CLR surrogate %1 was already defined, second definition at (%1:%2,%3) is invalid.", "ERROR_PCM_COMPILER_DUPLICATE_CLR_SURROGATE" },
      {0xC8B, "Type library %1 was already defined, second definition at (%1:%2,%3) is invalid.", "ERROR_PCM_COMPILER_DUPLICATE_TYPE_LIBRARY" },
      {0xC8C, "Proxy stub definition %1 was already defined, second definition at (%1:%2,%3) is invalid.", "ERROR_PCM_COMPILER_DUPLICATE_PROXY_STUB" },
      {0xC8D, "Category friendly name %4 was already used, second definition was found at (%1:%2,%3) is invalid.", "ERROR_PCM_COMPILER_DUPLICATE_CATEGORY_NAME" },
      {0xC8E, "Only one top-level assemblyIdentity tag may be present in a manifest. A second tag with identity %4 was found at (%1:%2,%3)", "ERROR_PCM_COMPILER_DUPLICATE_TOP_LEVEL_IDENTITY_FOUND" },
      {0xC8F, "The root element for a manifest found at (%1:%2,%3) was not expected or was of the wrong version.", "ERROR_PCM_COMPILER_UNKNOWN_ROOT_ELEMENT" },
      {0xC90, "The element found at (%1:%2,%3) was not expected according to the manifest schema.", "ERROR_PCM_COMPILER_INVALID_ELEMENT" },
      {0xC91, "The element found at (%1:%2,%3) was missing the required attribute '%4'. See the manifest schema for more information", "ERROR_PCM_COMPILER_MISSING_REQUIRED_ATTRIBUTE" },
      {0xC92, "The attribute value %4 at (%1:%2,%3) was invalid according to the schema.", "ERROR_PCM_COMPILER_INVALID_ATTRIBUTE_VALUE" },
      {0xC93, "PCDATA or CDATA found at (%1:%2,%3) in the source document was not expected in the parent element %4.", "ERROR_PCM_COMPILER_UNEXPECTED_PCDATA" },
      {0xC94, "The string table entry with culture %4, name %5, and value '%6' at (%1:%2,%3) duplicated a previous entry.", "ERROR_PCM_DUPLICATE_STRING_TABLE_ENTRY" },
      {0xFA0, "WINS encountered an error while processing the command.", "ERROR_WINS_INTERNAL" },
      {0xFA1, "The local WINS cannot be deleted.", "ERROR_CAN_NOT_DEL_LOCAL_WINS" },
      {0xFA2, "The importation from the file failed.", "ERROR_STATIC_INIT" },
      {0xFA3, "The backup failed. Was a full backup done before?", "ERROR_INC_BACKUP" },
      {0xFA4, "The backup failed. Check the directory to which you are backing the database.", "ERROR_FULL_BACKUP" },
      {0xFA5, "The name does not exist in the WINS database.", "ERROR_REC_NON_EXISTENT" },
      {0xFA6, "Replication with a nonconfigured partner is not allowed.", "ERROR_RPL_NOT_ALLOWED" },
      {0x1004, "The DHCP client has obtained an IP address that is already in use on the network. The local interface will be disabled until the DHCP client can obtain a new address.", "ERROR_DHCP_ADDRESS_CONFLICT" },
      {0x1068, "The GUID passed was not recognized as valid by a WMI data provider.", "ERROR_WMI_GUID_NOT_FOUND" },
      {0x1069, "The instance name passed was not recognized as valid by a WMI data provider.", "ERROR_WMI_INSTANCE_NOT_FOUND" },
      {0x106A, "The data item ID passed was not recognized as valid by a WMI data provider.", "ERROR_WMI_ITEMID_NOT_FOUND" },
      {0x106B, "The WMI request could not be completed and should be retried.", "ERROR_WMI_TRY_AGAIN" },
      {0x106C, "The WMI data provider could not be located.", "ERROR_WMI_DP_NOT_FOUND" },
      {0x106D, "The WMI data provider references an instance set that has not been registered.", "ERROR_WMI_UNRESOLVED_INSTANCE_REF" },
      {0x106E, "The WMI data block or event notification has already been enabled.", "ERROR_WMI_ALREADY_ENABLED" },
      {0x106F, "The WMI data block is no longer available.", "ERROR_WMI_GUID_DISCONNECTED" },
      {0x1070, "The WMI data service is not available.", "ERROR_WMI_SERVER_UNAVAILABLE" },
      {0x1071, "The WMI data provider failed to carry out the request.", "ERROR_WMI_DP_FAILED" },
      {0x1072, "The WMI MOF information is not valid.", "ERROR_WMI_INVALID_MOF" },
      {0x1073, "The WMI registration information is not valid.", "ERROR_WMI_INVALID_REGINFO" },
      {0x1074, "The WMI data block or event notification has already been disabled.", "ERROR_WMI_ALREADY_DISABLED" },
      {0x1075, "The WMI data item or data block is read only.", "ERROR_WMI_READ_ONLY" },
      {0x1076, "The WMI data item or data block could not be changed.", "ERROR_WMI_SET_FAILURE" },
      {0x10CC, "The media identifier does not represent a valid medium.", "ERROR_INVALID_MEDIA" },
      {0x10CD, "The library identifier does not represent a valid library.", "ERROR_INVALID_LIBRARY" },
      {0x10CE, "The media pool identifier does not represent a valid media pool.", "ERROR_INVALID_MEDIA_POOL" },
      {0x10CF, "The drive and medium are not compatible or exist in different libraries.", "ERROR_DRIVE_MEDIA_MISMATCH" },
      {0x10D0, "The medium currently exists in an offline library and must be online to perform this operation.", "ERROR_MEDIA_OFFLINE" },
      {0x10D1, "The operation cannot be performed on an offline library.", "ERROR_LIBRARY_OFFLINE" },
      {0x10D2, "The library, drive, or media pool is empty.", "ERROR_EMPTY" },
      {0x10D3, "The library, drive, or media pool must be empty to perform this operation.", "ERROR_NOT_EMPTY" },
      {0x10D4, "No media is currently available in this media pool or library.", "ERROR_MEDIA_UNAVAILABLE" },
      {0x10D5, "A resource required for this operation is disabled.", "ERROR_RESOURCE_DISABLED" },
      {0x10D6, "The media identifier does not represent a valid cleaner.", "ERROR_INVALID_CLEANER" },
      {0x10D7, "The drive cannot be cleaned or does not support cleaning.", "ERROR_UNABLE_TO_CLEAN" },
      {0x10D8, "The object identifier does not represent a valid object.", "ERROR_OBJECT_NOT_FOUND" },
      {0x10D9, "Unable to read from or write to the database.", "ERROR_DATABASE_FAILURE" },
      {0x10DA, "The database is full.", "ERROR_DATABASE_FULL" },
      {0x10DB, "The medium is not compatible with the device or media pool.", "ERROR_MEDIA_INCOMPATIBLE" },
      {0x10DC, "The resource required for this operation does not exist.", "ERROR_RESOURCE_NOT_PRESENT" },
      {0x10DD, "The operation identifier is not valid.", "ERROR_INVALID_OPERATION" },
      {0x10DE, "The media is not mounted or ready for use.", "ERROR_MEDIA_NOT_AVAILABLE" },
      {0x10DF, "The device is not ready for use.", "ERROR_DEVICE_NOT_AVAILABLE" },
      {0x10E0, "The operator or administrator has refused the request.", "ERROR_REQUEST_REFUSED" },
      {0x10E1, "The drive identifier does not represent a valid drive.", "ERROR_INVALID_DRIVE_OBJECT" },
      {0x10E2, "Library is full. No slot is available for use.", "ERROR_LIBRARY_FULL" },
      {0x10E3, "The transport cannot access the medium.", "ERROR_MEDIUM_NOT_ACCESSIBLE" },
      {0x10E4, "Unable to load the medium into the drive.", "ERROR_UNABLE_TO_LOAD_MEDIUM" },
      {0x10E5, "Unable to retrieve status about the drive.", "ERROR_UNABLE_TO_INVENTORY_DRIVE" },
      {0x10E6, "Unable to retrieve status about the slot.", "ERROR_UNABLE_TO_INVENTORY_SLOT" },
      {0x10E7, "Unable to retrieve status about the transport.", "ERROR_UNABLE_TO_INVENTORY_TRANSPORT" },
      {0x10E8, "Cannot use the transport because it is already in use.", "ERROR_TRANSPORT_FULL" },
      {0x10E9, "Unable to open or close the inject/eject port.", "ERROR_CONTROLLING_IEPORT" },
      {0x10EA, "Unable to eject the media because it is in a drive.", "ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA" },
      {0x10EB, "A cleaner slot is already reserved.", "ERROR_CLEANER_SLOT_SET" },
      {0x10EC, "A cleaner slot is not reserved.", "ERROR_CLEANER_SLOT_NOT_SET" },
      {0x10ED, "The cleaner cartridge has performed the maximum number of drive cleanings.", "ERROR_CLEANER_CARTRIDGE_SPENT" },
      {0x10EE, "Unexpected on-medium identifier.", "ERROR_UNEXPECTED_OMID" },
      {0x10EF, "The last remaining item in this group or resource cannot be deleted.", "ERROR_CANT_DELETE_LAST_ITEM" },
      {0x10F0, "The message provided exceeds the maximum size allowed for this parameter.", "ERROR_MESSAGE_EXCEEDS_MAX_SIZE" },
      {0x10F1, "The volume contains system or paging files.", "ERROR_VOLUME_CONTAINS_SYS_FILES" },
      {0x10F2, "The media type cannot be removed from this library since at least one drive in the library reports it can support this media type.", "ERROR_INDIGENOUS_TYPE" },
      {0x10F3, "This offline media cannot be mounted on this system since no enabled drives are present which can be used.", "ERROR_NO_SUPPORTING_DRIVES" },
      {0x10F4, "A cleaner cartridge is present in the tape library.", "ERROR_CLEANER_CARTRIDGE_INSTALLED" },
      {0x10FE, "The remote storage service was not able to recall the file.", "ERROR_FILE_OFFLINE" },
      {0x10FF, "The remote storage service is not operational at this time.", "ERROR_REMOTE_STORAGE_NOT_ACTIVE" },
      {0x1100, "The remote storage service encountered a media error.", "ERROR_REMOTE_STORAGE_MEDIA_ERROR" },
      {0x1126, "The file or directory is not a reparse point.", "ERROR_NOT_A_REPARSE_POINT" },
      {0x1127, "The reparse point attribute cannot be set because it conflicts with an existing attribute.", "ERROR_REPARSE_ATTRIBUTE_CONFLICT" },
      {0x1128, "The data present in the reparse point buffer is invalid.", "ERROR_INVALID_REPARSE_DATA" },
      {0x1129, "The tag present in the reparse point buffer is invalid.", "ERROR_REPARSE_TAG_INVALID" },
      {0x112A, "There is a mismatch between the tag specified in the request and the tag present in the reparse point.", "ERROR_REPARSE_TAG_MISMATCH" },
      {0x1194, "Single Instance Storage is not available on this volume.", "ERROR_VOLUME_NOT_SIS_ENABLED" },
      {0x1389, "The cluster resource cannot be moved to another group because other resources are dependent on it.", "ERROR_DEPENDENT_RESOURCE_EXISTS" },
      {0x138A, "The cluster resource dependency cannot be found.", "ERROR_DEPENDENCY_NOT_FOUND" },
      {0x138B, "The cluster resource cannot be made dependent on the specified resource because it is already dependent.", "ERROR_DEPENDENCY_ALREADY_EXISTS" },
      {0x138C, "The cluster resource is not online.", "ERROR_RESOURCE_NOT_ONLINE" },
      {0x138D, "A cluster node is not available for this operation.", "ERROR_HOST_NODE_NOT_AVAILABLE" },
      {0x138E, "The cluster resource is not available.", "ERROR_RESOURCE_NOT_AVAILABLE" },
      {0x138F, "The cluster resource could not be found.", "ERROR_RESOURCE_NOT_FOUND" },
      {0x1390, "The cluster is being shut down.", "ERROR_SHUTDOWN_CLUSTER" },
      {0x1391, "A cluster node cannot be evicted from the cluster unless the node is down.", "ERROR_CANT_EVICT_ACTIVE_NODE" },
      {0x1392, "The object already exists.", "ERROR_OBJECT_ALREADY_EXISTS" },
      {0x1393, "The object is already in the list.", "ERROR_OBJECT_IN_LIST" },
      {0x1394, "The cluster group is not available for any new requests.", "ERROR_GROUP_NOT_AVAILABLE" },
      {0x1395, "The cluster group could not be found.", "ERROR_GROUP_NOT_FOUND" },
      {0x1396, "The operation could not be completed because the cluster group is not online.", "ERROR_GROUP_NOT_ONLINE" },
      {0x1397, "The cluster node is not the owner of the resource.", "ERROR_HOST_NODE_NOT_RESOURCE_OWNER" },
      {0x1398, "The cluster node is not the owner of the group.", "ERROR_HOST_NODE_NOT_GROUP_OWNER" },
      {0x1399, "The cluster resource could not be created in the specified resource monitor.", "ERROR_RESMON_CREATE_FAILED" },
      {0x139A, "The cluster resource could not be brought online by the resource monitor.", "ERROR_RESMON_ONLINE_FAILED" },
      {0x139B, "The operation could not be completed because the cluster resource is online.", "ERROR_RESOURCE_ONLINE" },
      {0x139C, "The cluster resource could not be deleted or brought offline because it is the quorum resource.", "ERROR_QUORUM_RESOURCE" },
      {0x139D, "The cluster could not make the specified resource a quorum resource because it is not capable of being a quorum resource.", "ERROR_NOT_QUORUM_CAPABLE" },
      {0x139E, "The cluster software is shutting down.", "ERROR_CLUSTER_SHUTTING_DOWN" },
      {0x139F, "The group or resource is not in the correct state to perform the requested operation.", "ERROR_INVALID_STATE" },
      {0x13A0, "The properties were stored but not all changes will take effect until the next time the resource is brought online.", "ERROR_RESOURCE_PROPERTIES_STORED" },
      {0x13A1, "The cluster could not make the specified resource a quorum resource because it does not belong to a shared storage class.", "ERROR_NOT_QUORUM_CLASS" },
      {0x13A2, "The cluster resource could not be deleted since it is a core resource.", "ERROR_CORE_RESOURCE" },
      {0x13A3, "The quorum resource failed to come online.", "ERROR_QUORUM_RESOURCE_ONLINE_FAILED" },
      {0x13A4, "The quorum log could not be created or mounted successfully.", "ERROR_QUORUMLOG_OPEN_FAILED" },
      {0x13A5, "The cluster log is corrupt.", "ERROR_CLUSTERLOG_CORRUPT" },
      {0x13A6, "The record could not be written to the cluster log since it exceeds the maximum size.", "ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE" },
      {0x13A7, "The cluster log exceeds its maximum size.", "ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE" },
      {0x13A8, "No checkpoint record was found in the cluster log.", "ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND" },
      {0x13A9, "The minimum required disk space needed for logging is not available.", "ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE" },
      {0x13AA, "The cluster node failed to take control of the quorum resource because the resource is owned by another active node.", "ERROR_QUORUM_OWNER_ALIVE" },
      {0x13AB, "A cluster network is not available for this operation.", "ERROR_NETWORK_NOT_AVAILABLE" },
      {0x13AC, "A cluster node is not available for this operation.", "ERROR_NODE_NOT_AVAILABLE" },
      {0x13AD, "All cluster nodes must be running to perform this operation.", "ERROR_ALL_NODES_NOT_AVAILABLE" },
      {0x13AE, "A cluster resource failed.", "ERROR_RESOURCE_FAILED" },
      {0x13AF, "The cluster node is not valid.", "ERROR_CLUSTER_INVALID_NODE" },
      {0x13B0, "The cluster node already exists.", "ERROR_CLUSTER_NODE_EXISTS" },
      {0x13B1, "A node is in the process of joining the cluster.", "ERROR_CLUSTER_JOIN_IN_PROGRESS" },
      {0x13B2, "The cluster node was not found.", "ERROR_CLUSTER_NODE_NOT_FOUND" },
      {0x13B3, "The cluster local node information was not found.", "ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND" },
      {0x13B4, "The cluster network already exists.", "ERROR_CLUSTER_NETWORK_EXISTS" },
      {0x13B5, "The cluster network was not found.", "ERROR_CLUSTER_NETWORK_NOT_FOUND" },
      {0x13B6, "The cluster network interface already exists.", "ERROR_CLUSTER_NETINTERFACE_EXISTS" },
      {0x13B7, "The cluster network interface was not found.", "ERROR_CLUSTER_NETINTERFACE_NOT_FOUND" },
      {0x13B8, "The cluster request is not valid for this object.", "ERROR_CLUSTER_INVALID_REQUEST" },
      {0x13B9, "The cluster network provider is not valid.", "ERROR_CLUSTER_INVALID_NETWORK_PROVIDER" },
      {0x13BA, "The cluster node is down.", "ERROR_CLUSTER_NODE_DOWN" },
      {0x13BB, "The cluster node is not reachable.", "ERROR_CLUSTER_NODE_UNREACHABLE" },
      {0x13BC, "The cluster node is not a member of the cluster.", "ERROR_CLUSTER_NODE_NOT_MEMBER" },
      {0x13BD, "A cluster join operation is not in progress.", "ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS" },
      {0x13BE, "The cluster network is not valid.", "ERROR_CLUSTER_INVALID_NETWORK" },
      {0x13C0, "The cluster node is up.", "ERROR_CLUSTER_NODE_UP" },
      {0x13C1, "The cluster IP address is already in use.", "ERROR_CLUSTER_IPADDR_IN_USE" },
      {0x13C2, "The cluster node is not paused.", "ERROR_CLUSTER_NODE_NOT_PAUSED" },
      {0x13C3, "No cluster security context is available.", "ERROR_CLUSTER_NO_SECURITY_CONTEXT" },
      {0x13C4, "The cluster network is not configured for internal cluster communication.", "ERROR_CLUSTER_NETWORK_NOT_INTERNAL" },
      {0x13C5, "The cluster node is already up.", "ERROR_CLUSTER_NODE_ALREADY_UP" },
      {0x13C6, "The cluster node is already down.", "ERROR_CLUSTER_NODE_ALREADY_DOWN" },
      {0x13C7, "The cluster network is already online.", "ERROR_CLUSTER_NETWORK_ALREADY_ONLINE" },
      {0x13C8, "The cluster network is already offline.", "ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE" },
      {0x13C9, "The cluster node is already a member of the cluster.", "ERROR_CLUSTER_NODE_ALREADY_MEMBER" },
      {0x13CA, "The cluster network is the only one configured for internal cluster communication between two or more active cluster nodes. The internal communication capability cannot be removed from the network.", "ERROR_CLUSTER_LAST_INTERNAL_NETWORK" },
      {0x13CB, "One or more cluster resources depend on the network to provide service to clients. The client access capability cannot be removed from the network.", "ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS" },
      {0x13CC, "This operation cannot be performed on the cluster resource as it the quorum resource. You may not bring the quorum resource offline or modify its possible owners list.", "ERROR_INVALID_OPERATION_ON_QUORUM" },
      {0x13CD, "The cluster quorum resource is not allowed to have any dependencies.", "ERROR_DEPENDENCY_NOT_ALLOWED" },
      {0x13CE, "The cluster node is paused.", "ERROR_CLUSTER_NODE_PAUSED" },
      {0x13CF, "The cluster resource cannot be brought online. The owner node cannot run this resource.", "ERROR_NODE_CANT_HOST_RESOURCE" },
      {0x13D0, "The cluster node is not ready to perform the requested operation.", "ERROR_CLUSTER_NODE_NOT_READY" },
      {0x13D1, "The cluster node is shutting down.", "ERROR_CLUSTER_NODE_SHUTTING_DOWN" },
      {0x13D2, "The cluster join operation was aborted.", "ERROR_CLUSTER_JOIN_ABORTED" },
      {0x13D3, "The cluster join operation failed due to incompatible software versions between the joining node and its sponsor.", "ERROR_CLUSTER_INCOMPATIBLE_VERSIONS" },
      {0x13D4, "This resource cannot be created because the cluster has reached the limit on the number of resources it can monitor.", "ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED" },
      {0x13D5, "The system configuration changed during the cluster join or form operation. The join or form operation was aborted.", "ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED" },
      {0x13D6, "The specified resource type was not found.", "ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND" },
      {0x13D7, "The specified node does not support a resource of this type. This may be due to version inconsistencies or due to the absence of the resource DLL on this node.", "ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED" },
      {0x13D8, "The specified resource name is supported by this resource DLL. This may be due to a bad (or changed) name supplied to the resource DLL.", "ERROR_CLUSTER_RESNAME_NOT_FOUND" },
      {0x13D9, "No authentication package could be registered with the RPC server.", "ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED" },
      {0x13DA, "You cannot bring the group online because the owner of the group is not in the preferred list for the group. To change the owner node for the group, move the group.", "ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST" },
      {0x13DB, "The join operation failed because the cluster database sequence number has changed or is incompatible with the locker node. This may happen during a join operation if the cluster database was changing during the join.", "ERROR_CLUSTER_DATABASE_SEQMISMATCH" },
      {0x13DC, "The resource monitor will not allow the fail operation to be performed while the resource is in its current state. This may happen if the resource is in a pending state.", "ERROR_RESMON_INVALID_STATE" },
      {0x13DD, "A non locker code got a request to reserve the lock for making global updates.", "ERROR_CLUSTER_GUM_NOT_LOCKER" },
      {0x13DE, "The quorum disk could not be located by the cluster service.", "ERROR_QUORUM_DISK_NOT_FOUND" },
      {0x13DF, "The backup up cluster database is possibly corrupt.", "ERROR_DATABASE_BACKUP_CORRUPT" },
      {0x13E0, "A DFS root already exists in this cluster node.", "ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT" },
      {0x13E1, "An attempt to modify a resource property failed because it conflicts with another existing property.", "ERROR_RESOURCE_PROPERTY_UNCHANGEABLE" },
      {0x1702, "An operation was attempted that is incompatible with the current membership state of the node.", "ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE" },
      {0x1703, "The quorum resource does not contain the quorum log.", "ERROR_CLUSTER_QUORUMLOG_NOT_FOUND" },
      {0x1704, "The membership engine requested shutdown of the cluster service on this node.", "ERROR_CLUSTER_MEMBERSHIP_HALT" },
      {0x1705, "The join operation failed because the cluster instance ID of the joining node does not match the cluster instance ID of the sponsor node.", "ERROR_CLUSTER_INSTANCE_ID_MISMATCH" },
      {0x1706, "A matching network for the specified IP address could not be found. Please also specify a subnet mask and a cluster network.", "ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP" },
      {0x1707, "The actual data type of the property did not match the expected data type of the property.", "ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH" },
      {0x1708, "The cluster node was evicted from the cluster successfully, but the node was not cleaned up. Extended status information explaining why the node was not cleaned up is available.", "ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP" },
      {0x1709, "Two or more parameter values specified for a resource's properties are in conflict.", "ERROR_CLUSTER_PARAMETER_MISMATCH" },
      {0x170A, "This computer cannot be made a member of a cluster.", "ERROR_NODE_CANNOT_BE_CLUSTERED" },
      {0x170B, "This computer cannot be made a member of a cluster because it does not have the correct version of Windows installed.", "ERROR_CLUSTER_WRONG_OS_VERSION" },
      {0x170C, "A cluster cannot be created with the specified cluster name because that cluster name is already in use. Specify a different name for the cluster.", "ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME" },
      {0x170D, "The cluster configuration action has already been committed.", "ERROR_CLUSCFG_ALREADY_COMMITTED" },
      {0x170E, "The cluster configuration action could not be rolled back.", "ERROR_CLUSCFG_ROLLBACK_FAILED" },
      {0x170F, "The drive letter assigned to a system disk on one node conflicted with the driver letter assigned to a disk on another node.", "ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT" },
      {0x1710, "One or more nodes in the cluster are running a version of Windows that does not support this operation.", "ERROR_CLUSTER_OLD_VERSION" },
      {0x1711, "The name of the corresponding computer account doesn't match the Network Name for this resource.", "ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME" },
      {0x1712, "No network adapters are available.", "ERROR_CLUSTER_NO_NET_ADAPTERS" },
      {0x1713, "The cluster node has been poisoned.", "ERROR_CLUSTER_POISONED" },
      {0x1770, "The specified file could not be encrypted.", "ERROR_ENCRYPTION_FAILED" },
      {0x1771, "The specified file could not be decrypted.", "ERROR_DECRYPTION_FAILED" },
      {0x1772, "The specified file is encrypted and the user does not have the ability to decrypt it.", "ERROR_FILE_ENCRYPTED" },
      {0x1773, "There is no valid encryption recovery policy configured for this system.", "ERROR_NO_RECOVERY_POLICY" },
      {0x1774, "The required encryption driver is not loaded for this system.", "ERROR_NO_EFS" },
      {0x1775, "The file was encrypted with a different encryption driver than is currently loaded.", "ERROR_WRONG_EFS" },
      {0x1776, "There are no EFS keys defined for the user.", "ERROR_NO_USER_KEYS" },
      {0x1777, "The specified file is not encrypted.", "ERROR_FILE_NOT_ENCRYPTED" },
      {0x1778, "The specified file is not in the defined EFS export format.", "ERROR_NOT_EXPORT_FORMAT" },
      {0x1779, "The specified file is read only.", "ERROR_FILE_READ_ONLY" },
      {0x177A, "The directory has been disabled for encryption.", "ERROR_DIR_EFS_DISALLOWED" },
      {0x177B, "The server is not trusted for remote encryption operation.", "ERROR_EFS_SERVER_NOT_TRUSTED" },
      {0x177C, "Recovery policy configured for this system contains invalid recovery certificate.", "ERROR_BAD_RECOVERY_POLICY" },
      {0x177D, "The encryption algorithm used on the source file needs a bigger key buffer than the one on the destination file.", "ERROR_EFS_ALG_BLOB_TOO_BIG" },
      {0x177E, "The disk partition does not support file encryption.", "ERROR_VOLUME_NOT_SUPPORT_EFS" },
      {0x177F, "This machine is disabled for file encryption.", "ERROR_EFS_DISABLED" },
      {0x1780, "A newer system is required to decrypt this encrypted file.", "ERROR_EFS_VERSION_NOT_SUPPORT" },
      {0x17E6, "The list of servers for this workgroup is not currently available.", "ERROR_NO_BROWSER_SERVERS_FOUND" },
      {0x1838, "The Task Scheduler service must be configured to run in the System account to function properly. Individual tasks may be configured to run in other accounts.", "SCHED_E_SERVICE_NOT_LOCALSYSTEM" },
      {0x1B59, "The specified session name is invalid.", "ERROR_CTX_WINSTATION_NAME_INVALID" },
      {0x1B5A, "The specified protocol driver is invalid.", "ERROR_CTX_INVALID_PD" },
      {0x1B5B, "The specified protocol driver was not found in the system path.", "ERROR_CTX_PD_NOT_FOUND" },
      {0x1B5C, "The specified terminal connection driver was not found in the system path.", "ERROR_CTX_WD_NOT_FOUND" },
      {0x1B5D, "A registry key for event logging could not be created for this session.", "ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY" },
      {0x1B5E, "A service with the same name already exists on the system.", "ERROR_CTX_SERVICE_NAME_COLLISION" },
      {0x1B5F, "A close operation is pending on the session.", "ERROR_CTX_CLOSE_PENDING" },
      {0x1B60, "There are no free output buffers available.", "ERROR_CTX_NO_OUTBUF" },
      {0x1B61, "The MODEM.INF file was not found.", "ERROR_CTX_MODEM_INF_NOT_FOUND" },
      {0x1B62, "The modem name was not found in MODEM.INF.", "ERROR_CTX_INVALID_MODEMNAME" },
      {0x1B63, "The modem did not accept the command sent to it. Verify that the configured modem name matches the attached modem.", "ERROR_CTX_MODEM_RESPONSE_ERROR" },
      {0x1B64, "The modem did not respond to the command sent to it. Verify that the modem is properly cabled and powered on.", "ERROR_CTX_MODEM_RESPONSE_TIMEOUT" },
      {0x1B65, "Carrier detect has failed or carrier has been dropped due to disconnect.", "ERROR_CTX_MODEM_RESPONSE_NO_CARRIER" },
      {0x1B66, "Dial tone not detected within the required time. Verify that the phone cable is properly attached and functional.", "ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE" },
      {0x1B67, "Busy signal detected at remote site on callback.", "ERROR_CTX_MODEM_RESPONSE_BUSY" },
      {0x1B68, "Voice detected at remote site on callback.", "ERROR_CTX_MODEM_RESPONSE_VOICE" },
      {0x1B69, "Transport driver error", "ERROR_CTX_TD_ERROR" },
      {0x1B6E, "The specified session cannot be found.", "ERROR_CTX_WINSTATION_NOT_FOUND" },
      {0x1B6F, "The specified session name is already in use.", "ERROR_CTX_WINSTATION_ALREADY_EXISTS" },
      {0x1B70, "The requested operation cannot be completed because the terminal connection is currently busy processing a connect, disconnect, reset, or delete operation.", "ERROR_CTX_WINSTATION_BUSY" },
      {0x1B71, "An attempt has been made to connect to a session whose video mode is not supported by the current client.", "ERROR_CTX_BAD_VIDEO_MODE" },
      {0x1B7B, "The application attempted to enable DOS graphics mode. DOS graphics mode is not supported.", "ERROR_CTX_GRAPHICS_INVALID" },
      {0x1B7D, "Your interactive logon privilege has been disabled. Please contact your administrator.", "ERROR_CTX_LOGON_DISABLED" },
      {0x1B7E, "The requested operation can be performed only on the system console. This is most often the result of a driver or system DLL requiring direct console access.", "ERROR_CTX_NOT_CONSOLE" },
      {0x1B80, "The client failed to respond to the server connect message.", "ERROR_CTX_CLIENT_QUERY_TIMEOUT" },
      {0x1B81, "Disconnecting the console session is not supported.", "ERROR_CTX_CONSOLE_DISCONNECT" },
      {0x1B82, "Reconnecting a disconnected session to the console is not supported.", "ERROR_CTX_CONSOLE_CONNECT" },
      {0x1B84, "The request to control another session remotely was denied.", "ERROR_CTX_SHADOW_DENIED" },
      {0x1B85, "The requested session access is denied.", "ERROR_CTX_WINSTATION_ACCESS_DENIED" },
      {0x1B89, "The specified terminal connection driver is invalid.", "ERROR_CTX_INVALID_WD" },
      {0x1B8A, "The requested session cannot be controlled remotely. This may be because the session is disconnected or does not currently have a user logged on.", "ERROR_CTX_SHADOW_INVALID" },
      {0x1B8B, "The requested session is not configured to allow remote control.", "ERROR_CTX_SHADOW_DISABLED" },
      {0x1B8C, "Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number is currently being used by another user. Please call your system administrator to obtain a unique license number.", "ERROR_CTX_CLIENT_LICENSE_IN_USE" },
      {0x1B8D, "Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number has not been entered for this copy of the Terminal Server client. Please contact your system administrator.", "ERROR_CTX_CLIENT_LICENSE_NOT_SET" },
      {0x1B8E, "The system has reached its licensed logon limit. Please try again later.", "ERROR_CTX_LICENSE_NOT_AVAILABLE" },
      {0x1B8F, "The client you are using is not licensed to use this system. Your logon request is denied.", "ERROR_CTX_LICENSE_CLIENT_INVALID" },
      {0x1B90, "The system license has expired. Your logon request is denied.", "ERROR_CTX_LICENSE_EXPIRED" },
      {0x1B91, "Remote control could not be terminated because the specified session is not currently being remotely controlled.", "ERROR_CTX_SHADOW_NOT_RUNNING" },
      {0x1B92, "The remote control of the console was terminated because the display mode was changed. Changing the display mode in a remote control session is not supported.", "ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE" },
      {0x1B93, "Activation has already been reset the maximum number of times for this installation. Your activation timer will not be cleared.", "ERROR_ACTIVATION_COUNT_EXCEEDED" },
      {0x1B94, "Remote logins are currently disabled.", "ERROR_CTX_WINSTATIONS_DISABLED" },
      {0x1B95, "You do not have the proper encryption level to access this Session.", "ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED" },
      {0x1B96, "The user %s\\%s is currently logged on to this computer. Only the current user or an administrator can log on to this computer.", "ERROR_CTX_SESSION_IN_USE" },
      {0x1B97, "The user %s\\%s is already logged on to the console of this computer. You do not have permission to log in at this time. To resolve this issue, contact %s\\%s and have them log off.", "ERROR_CTX_NO_FORCE_LOGOFF" },
      {0x1B98, "Unable to log you on because of an account restriction.", "ERROR_CTX_ACCOUNT_RESTRICTION" },
      {0x1B99, "The RDP protocol component %2 detected an error in the protocol stream and has disconnected the client.", "ERROR_RDP_PROTOCOL_ERROR" },
      {0x1B9A, "The Client Drive Mapping Service Has Connected on Terminal Connection.", "ERROR_CTX_CDM_CONNECT" },
      {0x1B9B, "The Client Drive Mapping Service Has Disconnected on Terminal Connection.", "ERROR_CTX_CDM_DISCONNECT" },
      {0x1F41, "The file replication service API was called incorrectly.", "FRS_ERR_INVALID_API_SEQUENCE" },
      {0x1F42, "The file replication service cannot be started.", "FRS_ERR_STARTING_SERVICE" },
      {0x1F43, "The file replication service cannot be stopped.", "FRS_ERR_STOPPING_SERVICE" },
      {0x1F44, "The file replication service API terminated the request. The event log may have more information.", "FRS_ERR_INTERNAL_API" },
      {0x1F45, "The file replication service terminated the request. The event log may have more information.", "FRS_ERR_INTERNAL" },
      {0x1F46, "The file replication service cannot be contacted. The event log may have more information.", "FRS_ERR_SERVICE_COMM" },
      {0x1F47, "The file replication service cannot satisfy the request because the user has insufficient privileges. The event log may have more information.", "FRS_ERR_INSUFFICIENT_PRIV" },
      {0x1F48, "The file replication service cannot satisfy the request because authenticated RPC is not available. The event log may have more information.", "FRS_ERR_AUTHENTICATION" },
      {0x1F49, "The file replication service cannot satisfy the request because the user has insufficient privileges on the domain controller. The event log may have more information.", "FRS_ERR_PARENT_INSUFFICIENT_PRIV" },
      {0x1F4A, "The file replication service cannot satisfy the request because authenticated RPC is not available on the domain controller. The event log may have more information.", "FRS_ERR_PARENT_AUTHENTICATION" },
      {0x1F4B, "The file replication service cannot communicate with the file replication service on the domain controller. The event log may have more information.", "FRS_ERR_CHILD_TO_PARENT_COMM" },
      {0x1F4C, "The file replication service on the domain controller cannot communicate with the file replication service on this computer. The event log may have more information.", "FRS_ERR_PARENT_TO_CHILD_COMM" },
      {0x1F4D, "The file replication service cannot populate the system volume because of an internal error. The event log may have more information.", "FRS_ERR_SYSVOL_POPULATE" },
      {0x1F4E, "The file replication service cannot populate the system volume because of an internal timeout. The event log may have more information.", "FRS_ERR_SYSVOL_POPULATE_TIMEOUT" },
      {0x1F4F, "The file replication service cannot process the request. The system volume is busy with a previous request.", "FRS_ERR_SYSVOL_IS_BUSY" },
      {0x1F50, "The file replication service cannot stop replicating the system volume because of an internal error. The event log may have more information.", "FRS_ERR_SYSVOL_DEMOTE" },
      {0x1F51, "The file replication service detected an invalid parameter.", "FRS_ERR_INVALID_SERVICE_PARAMETER" },
      {0x2008, "An error occurred while installing the directory service. For more information, see the event log.", "ERROR_DS_NOT_INSTALLED" },
      {0x2009, "The directory service evaluated group memberships locally.", "ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY" },
      {0x200A, "The specified directory service attribute or value does not exist.", "ERROR_DS_NO_ATTRIBUTE_OR_VALUE" },
      {0x200B, "The attribute syntax specified to the directory service is invalid.", "ERROR_DS_INVALID_ATTRIBUTE_SYNTAX" },
      {0x200C, "The attribute type specified to the directory service is not defined.", "ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED" },
      {0x200D, "The specified directory service attribute or value already exists.", "ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS" },
      {0x200E, "The directory service is busy.", "ERROR_DS_BUSY" },
      {0x200F, "The directory service is unavailable.", "ERROR_DS_UNAVAILABLE" },
      {0x2010, "The directory service was unable to allocate a relative identifier.", "ERROR_DS_NO_RIDS_ALLOCATED" },
      {0x2011, "The directory service has exhausted the pool of relative identifiers.", "ERROR_DS_NO_MORE_RIDS" },
      {0x2012, "The requested operation could not be performed because the directory service is not the master for that type of operation.", "ERROR_DS_INCORRECT_ROLE_OWNER" },
      {0x2013, "The directory service was unable to initialize the subsystem that allocates relative identifiers.", "ERROR_DS_RIDMGR_INIT_ERROR" },
      {0x2014, "The requested operation did not satisfy one or more constraints associated with the class of the object.", "ERROR_DS_OBJ_CLASS_VIOLATION" },
      {0x2015, "The directory service can perform the requested operation only on a leaf object.", "ERROR_DS_CANT_ON_NON_LEAF" },
      {0x2016, "The directory service cannot perform the requested operation on the RDN attribute of an object.", "ERROR_DS_CANT_ON_RDN" },
      {0x2017, "The directory service detected an attempt to modify the object class of an object.", "ERROR_DS_CANT_MOD_OBJ_CLASS" },
      {0x2018, "The requested cross-domain move operation could not be performed.", "ERROR_DS_CROSS_DOM_MOVE_ERROR" },
      {0x2019, "Unable to contact the global catalog server.", "ERROR_DS_GC_NOT_AVAILABLE" },
      {0x201A, "The policy object is shared and can only be modified at the root.", "ERROR_SHARED_POLICY" },
      {0x201B, "The policy object does not exist.", "ERROR_POLICY_OBJECT_NOT_FOUND" },
      {0x201C, "The requested policy information is only in the directory service.", "ERROR_POLICY_ONLY_IN_DS" },
      {0x201D, "A domain controller promotion is currently active.", "ERROR_PROMOTION_ACTIVE" },
      {0x201E, "A domain controller promotion is not currently active", "ERROR_NO_PROMOTION_ACTIVE" },
      {0x2020, "An operations error occurred.", "ERROR_DS_OPERATIONS_ERROR" },
      {0x2021, "A protocol error occurred.", "ERROR_DS_PROTOCOL_ERROR" },
      {0x2022, "The time limit for this request was exceeded.", "ERROR_DS_TIMELIMIT_EXCEEDED" },
      {0x2023, "The size limit for this request was exceeded.", "ERROR_DS_SIZELIMIT_EXCEEDED" },
      {0x2024, "The administrative limit for this request was exceeded.", "ERROR_DS_ADMIN_LIMIT_EXCEEDED" },
      {0x2025, "The compare response was false.", "ERROR_DS_COMPARE_FALSE" },
      {0x2026, "The compare response was true.", "ERROR_DS_COMPARE_TRUE" },
      {0x2027, "The requested authentication method is not supported by the server.", "ERROR_DS_AUTH_METHOD_NOT_SUPPORTED" },
      {0x2028, "A more secure authentication method is required for this server.", "ERROR_DS_STRONG_AUTH_REQUIRED" },
      {0x2029, "Inappropriate authentication.", "ERROR_DS_INAPPROPRIATE_AUTH" },
      {0x202A, "The authentication mechanism is unknown.", "ERROR_DS_AUTH_UNKNOWN" },
      {0x202B, "A referral was returned from the server.", "ERROR_DS_REFERRAL" },
      {0x202C, "The server does not support the requested critical extension.", "ERROR_DS_UNAVAILABLE_CRIT_EXTENSION" },
      {0x202D, "This request requires a secure connection.", "ERROR_DS_CONFIDENTIALITY_REQUIRED" },
      {0x202E, "Inappropriate matching.", "ERROR_DS_INAPPROPRIATE_MATCHING" },
      {0x202F, "A constraint violation occurred.", "ERROR_DS_CONSTRAINT_VIOLATION" },
      {0x2030, "There is no such object on the server.", "ERROR_DS_NO_SUCH_OBJECT" },
      {0x2031, "There is an alias problem.", "ERROR_DS_ALIAS_PROBLEM" },
      {0x2032, "An invalid dn syntax has been specified.", "ERROR_DS_INVALID_DN_SYNTAX" },
      {0x2033, "The object is a leaf object.", "ERROR_DS_IS_LEAF" },
      {0x2034, "There is an alias dereferencing problem.", "ERROR_DS_ALIAS_DEREF_PROBLEM" },
      {0x2035, "The server is unwilling to process the request.", "ERROR_DS_UNWILLING_TO_PERFORM" },
      {0x2036, "A loop has been detected.", "ERROR_DS_LOOP_DETECT" },
      {0x2037, "There is a naming violation.", "ERROR_DS_NAMING_VIOLATION" },
      {0x2038, "The result set is too large.", "ERROR_DS_OBJECT_RESULTS_TOO_LARGE" },
      {0x2039, "The operation affects multiple DSAs", "ERROR_DS_AFFECTS_MULTIPLE_DSAS" },
      {0x203A, "The server is not operational.", "ERROR_DS_SERVER_DOWN" },
      {0x203B, "A local error has occurred.", "ERROR_DS_LOCAL_ERROR" },
      {0x203C, "An encoding error has occurred.", "ERROR_DS_ENCODING_ERROR" },
      {0x203D, "A decoding error has occurred.", "ERROR_DS_DECODING_ERROR" },
      {0x203E, "The search filter cannot be recognized.", "ERROR_DS_FILTER_UNKNOWN" },
      {0x203F, "One or more parameters are illegal.", "ERROR_DS_PARAM_ERROR" },
      {0x2040, "The specified method is not supported.", "ERROR_DS_NOT_SUPPORTED" },
      {0x2041, "No results were returned.", "ERROR_DS_NO_RESULTS_RETURNED" },
      {0x2042, "The specified control is not supported by the server.", "ERROR_DS_CONTROL_NOT_FOUND" },
      {0x2043, "A referral loop was detected by the client.", "ERROR_DS_CLIENT_LOOP" },
      {0x2044, "The preset referral limit was exceeded.", "ERROR_DS_REFERRAL_LIMIT_EXCEEDED" },
      {0x2045, "The search requires a SORT control.", "ERROR_DS_SORT_CONTROL_MISSING" },
      {0x2046, "The search results exceed the offset range specified.", "ERROR_DS_OFFSET_RANGE_ERROR" },
      {0x206D, "The root object must be the head of a naming context. The root object cannot have an instantiated parent.", "ERROR_DS_ROOT_MUST_BE_NC" },
      {0x206E, "The add replica operation cannot be performed. The naming context must be writeable in order to create the replica.", "ERROR_DS_ADD_REPLICA_INHIBITED" },
      {0x206F, "A reference to an attribute that is not defined in the schema occurred.", "ERROR_DS_ATT_NOT_DEF_IN_SCHEMA" },
      {0x2070, "The maximum size of an object has been exceeded.", "ERROR_DS_MAX_OBJ_SIZE_EXCEEDED" },
      {0x2071, "An attempt was made to add an object to the directory with a name that is already in use.", "ERROR_DS_OBJ_STRING_NAME_EXISTS" },
      {0x2072, "An attempt was made to add an object of a class that does not have an RDN defined in the schema.", "ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA" },
      {0x2073, "An attempt was made to add an object using an RDN that is not the RDN defined in the schema.", "ERROR_DS_RDN_DOESNT_MATCH_SCHEMA" },
      {0x2074, "None of the requested attributes were found on the objects.", "ERROR_DS_NO_REQUESTED_ATTS_FOUND" },
      {0x2075, "The user buffer is too small.", "ERROR_DS_USER_BUFFER_TO_SMALL" },
      {0x2076, "The attribute specified in the operation is not present on the object.", "ERROR_DS_ATT_IS_NOT_ON_OBJ" },
      {0x2077, "Illegal modify operation. Some aspect of the modification is not permitted.", "ERROR_DS_ILLEGAL_MOD_OPERATION" },
      {0x2078, "The specified object is too large.", "ERROR_DS_OBJ_TOO_LARGE" },
      {0x2079, "The specified instance type is not valid.", "ERROR_DS_BAD_INSTANCE_TYPE" },
      {0x207A, "The operation must be performed at a master DSA.", "ERROR_DS_MASTERDSA_REQUIRED" },
      {0x207B, "The object class attribute must be specified.", "ERROR_DS_OBJECT_CLASS_REQUIRED" },
      {0x207C, "A required attribute is missing.", "ERROR_DS_MISSING_REQUIRED_ATT" },
      {0x207D, "An attempt was made to modify an object to include an attribute that is not legal for its class", "ERROR_DS_ATT_NOT_DEF_FOR_CLASS" },
      {0x207E, "The specified attribute is already present on the object.", "ERROR_DS_ATT_ALREADY_EXISTS" },
      {0x2080, "The specified attribute is not present, or has no values.", "ERROR_DS_CANT_ADD_ATT_VALUES" },
      {0x2081, "Multiple values were specified for an attribute that can have only one value.", "ERROR_DS_SINGLE_VALUE_CONSTRAINT" },
      {0x2082, "A value for the attribute was not in the acceptable range of values.", "ERROR_DS_RANGE_CONSTRAINT" },
      {0x2083, "The specified value already exists.", "ERROR_DS_ATT_VAL_ALREADY_EXISTS" },
      {0x2084, "The attribute cannot be removed because it is not present on the object.", "ERROR_DS_CANT_REM_MISSING_ATT" },
      {0x2085, "The attribute value cannot be removed because it is not present on the object.", "ERROR_DS_CANT_REM_MISSING_ATT_VAL" },
      {0x2086, "The specified root object cannot be a subref.", "ERROR_DS_ROOT_CANT_BE_SUBREF" },
      {0x2087, "Chaining is not permitted.", "ERROR_DS_NO_CHAINING" },
      {0x2088, "Chained evaluation is not permitted.", "ERROR_DS_NO_CHAINED_EVAL" },
      {0x2089, "The operation could not be performed because the object's parent is either uninstantiated or deleted.", "ERROR_DS_NO_PARENT_OBJECT" },
      {0x208A, "Having a parent that is an alias is not permitted. Aliases are leaf objects.", "ERROR_DS_PARENT_IS_AN_ALIAS" },
      {0x208B, "The object and parent must be of the same type, either both masters or both replicas.", "ERROR_DS_CANT_MIX_MASTER_AND_REPS" },
      {0x208C, "The operation cannot be performed because child objects exist. This operation can only be performed on a leaf object.", "ERROR_DS_CHILDREN_EXIST" },
      {0x208D, "Directory object not found.", "ERROR_DS_OBJ_NOT_FOUND" },
      {0x208E, "The aliased object is missing.", "ERROR_DS_ALIASED_OBJ_MISSING" },
      {0x208F, "The object name has bad syntax.", "ERROR_DS_BAD_NAME_SYNTAX" },
      {0x2090, "It is not permitted for an alias to refer to another alias.", "ERROR_DS_ALIAS_POINTS_TO_ALIAS" },
      {0x2091, "The alias cannot be dereferenced.", "ERROR_DS_CANT_DEREF_ALIAS" },
      {0x2092, "The operation is out of scope.", "ERROR_DS_OUT_OF_SCOPE" },
      {0x2093, "The operation cannot continue because the object is in the process of being removed.", "ERROR_DS_OBJECT_BEING_REMOVED" },
      {0x2094, "The DSA object cannot be deleted.", "ERROR_DS_CANT_DELETE_DSA_OBJ" },
      {0x2095, "A directory service error has occurred.", "ERROR_DS_GENERIC_ERROR" },
      {0x2096, "The operation can only be performed on an internal master DSA object.", "ERROR_DS_DSA_MUST_BE_INT_MASTER" },
      {0x2097, "The object must be of class DSA.", "ERROR_DS_CLASS_NOT_DSA" },
      {0x2098, "Insufficient access rights to perform the operation.", "ERROR_DS_INSUFF_ACCESS_RIGHTS" },
      {0x2099, "The object cannot be added because the parent is not on the list of possible superiors.", "ERROR_DS_ILLEGAL_SUPERIOR" },
      {0x209A, "Access to the attribute is not permitted because the attribute is owned by the Security Accounts Manager (SAM).", "ERROR_DS_ATTRIBUTE_OWNED_BY_SAM" },
      {0x209B, "The name has too many parts.", "ERROR_DS_NAME_TOO_MANY_PARTS" },
      {0x209C, "The name is too long.", "ERROR_DS_NAME_TOO_LONG" },
      {0x209D, "The name value is too long.", "ERROR_DS_NAME_VALUE_TOO_LONG" },
      {0x209E, "The directory service encountered an error parsing a name.", "ERROR_DS_NAME_UNPARSEABLE" },
      {0x209F, "The directory service cannot get the attribute type for a name.", "ERROR_DS_NAME_TYPE_UNKNOWN" },
      {0x20A0, "The name does not identify an object; the name identifies a phantom.", "ERROR_DS_NOT_AN_OBJECT" },
      {0x20A1, "The security descriptor is too short.", "ERROR_DS_SEC_DESC_TOO_SHORT" },
      {0x20A2, "The security descriptor is invalid.", "ERROR_DS_SEC_DESC_INVALID" },
      {0x20A3, "Failed to create name for deleted object.", "ERROR_DS_NO_DELETED_NAME" },
      {0x20A4, "The parent of a new subref must exist.", "ERROR_DS_SUBREF_MUST_HAVE_PARENT" },
      {0x20A5, "The object must be a naming context.", "ERROR_DS_NCNAME_MUST_BE_NC" },
      {0x20A6, "It is not permitted to add an attribute which is owned by the system.", "ERROR_DS_CANT_ADD_SYSTEM_ONLY" },
      {0x20A7, "The class of the object must be structural; you cannot instantiate an abstract class.", "ERROR_DS_CLASS_MUST_BE_CONCRETE" },
      {0x20A8, "The schema object could not be found.", "ERROR_DS_INVALID_DMD" },
      {0x20A9, "A local object with this GUID (dead or alive) already exists.", "ERROR_DS_OBJ_GUID_EXISTS" },
      {0x20AA, "The operation cannot be performed on a back link.", "ERROR_DS_NOT_ON_BACKLINK" },
      {0x20AB, "The cross reference for the specified naming context could not be found.", "ERROR_DS_NO_CROSSREF_FOR_NC" },
      {0x20AC, "The operation could not be performed because the directory service is shutting down.", "ERROR_DS_SHUTTING_DOWN" },
      {0x20AD, "The directory service request is invalid.", "ERROR_DS_UNKNOWN_OPERATION" },
      {0x20AE, "The role owner attribute could not be read.", "ERROR_DS_INVALID_ROLE_OWNER" },
      {0x20AF, "The requested FSMO operation failed. The current FSMO holder could not be reached.", "ERROR_DS_COULDNT_CONTACT_FSMO" },
      {0x20B0, "Modification of a DN across a naming context is not permitted.", "ERROR_DS_CROSS_NC_DN_RENAME" },
      {0x20B1, "The attribute cannot be modified because it is owned by the system.", "ERROR_DS_CANT_MOD_SYSTEM_ONLY" },
      {0x20B2, "Only the replicator can perform this function.", "ERROR_DS_REPLICATOR_ONLY" },
      {0x20B3, "The specified class is not defined.", "ERROR_DS_OBJ_CLASS_NOT_DEFINED" },
      {0x20B4, "The specified class is not a subclass.", "ERROR_DS_OBJ_CLASS_NOT_SUBCLASS" },
      {0x20B5, "The name reference is invalid.", "ERROR_DS_NAME_REFERENCE_INVALID" },
      {0x20B6, "A cross reference already exists.", "ERROR_DS_CROSS_REF_EXISTS" },
      {0x20B7, "It is not permitted to delete a master cross reference.", "ERROR_DS_CANT_DEL_MASTER_CROSSREF" },
      {0x20B8, "Subtree notifications are only supported on NC heads.", "ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD" },
      {0x20B9, "Notification filter is too complex.", "ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX" },
      {0x20BA, "Schema update failed: duplicate RDN.", "ERROR_DS_DUP_RDN" },
      {0x20BB, "Schema update failed: duplicate OID", "ERROR_DS_DUP_OID" },
      {0x20BC, "Schema update failed: duplicate MAPI identifier.", "ERROR_DS_DUP_MAPI_ID" },
      {0x20BD, "Schema update failed: duplicate schema-id GUID.", "ERROR_DS_DUP_SCHEMA_ID_GUID" },
      {0x20BE, "Schema update failed: duplicate LDAP display name.", "ERROR_DS_DUP_LDAP_DISPLAY_NAME" },
      {0x20BF, "Schema update failed: range-lower less than range upper", "ERROR_DS_SEMANTIC_ATT_TEST" },
      {0x20C0, "Schema update failed: syntax mismatch", "ERROR_DS_SYNTAX_MISMATCH" },
      {0x20C1, "Schema deletion failed: attribute is used in must-contain", "ERROR_DS_EXISTS_IN_MUST_HAVE" },
      {0x20C2, "Schema deletion failed: attribute is used in may-contain", "ERROR_DS_EXISTS_IN_MAY_HAVE" },
      {0x20C3, "Schema update failed: attribute in may-contain does not exist", "ERROR_DS_NONEXISTENT_MAY_HAVE" },
      {0x20C4, "Schema update failed: attribute in must-contain does not exist", "ERROR_DS_NONEXISTENT_MUST_HAVE" },
      {0x20C5, "Schema update failed: class in aux-class list does not exist or is not an auxiliary class", "ERROR_DS_AUX_CLS_TEST_FAIL" },
      {0x20C6, "Schema update failed: class in poss-superiors does not exist", "ERROR_DS_NONEXISTENT_POSS_SUP" },
      {0x20C7, "Schema update failed: class in subclassof list does not exist or does not satisfy hierarchy rules", "ERROR_DS_SUB_CLS_TEST_FAIL" },
      {0x20C8, "Schema update failed: Rdn-Att-Id has wrong syntax", "ERROR_DS_BAD_RDN_ATT_ID_SYNTAX" },
      {0x20C9, "Schema deletion failed: class is used as auxiliary class", "ERROR_DS_EXISTS_IN_AUX_CLS" },
      {0x20CA, "Schema deletion failed: class is used as sub class", "ERROR_DS_EXISTS_IN_SUB_CLS" },
      {0x20CB, "Schema deletion failed: class is used as poss superior", "ERROR_DS_EXISTS_IN_POSS_SUP" },
      {0x20CC, "Schema update failed in recalculating validation cache.", "ERROR_DS_RECALCSCHEMA_FAILED" },
      {0x20CD, "The tree deletion is not finished.", "ERROR_DS_TREE_DELETE_NOT_FINISHED" },
      {0x20CE, "The requested delete operation could not be performed.", "ERROR_DS_CANT_DELETE" },
      {0x20CF, "Cannot read the governs class identifier for the schema record.", "ERROR_DS_ATT_SCHEMA_REQ_ID" },
      {0x20D0, "The attribute schema has bad syntax.", "ERROR_DS_BAD_ATT_SCHEMA_SYNTAX" },
      {0x20D1, "The attribute could not be cached.", "ERROR_DS_CANT_CACHE_ATT" },
      {0x20D2, "The class could not be cached.", "ERROR_DS_CANT_CACHE_CLASS" },
      {0x20D3, "The attribute could not be removed from the cache.", "ERROR_DS_CANT_REMOVE_ATT_CACHE" },
      {0x20D4, "The class could not be removed from the cache.", "ERROR_DS_CANT_REMOVE_CLASS_CACHE" },
      {0x20D5, "The distinguished name attribute could not be read.", "ERROR_DS_CANT_RETRIEVE_DN" },
      {0x20D6, "No superior reference has been configured for the directory service. The directory service is therefore unable to issue referrals to objects outside this forest.", "ERROR_DS_MISSING_SUPREF" },
      {0x20D7, "The instance type attribute could not be retrieved.", "ERROR_DS_CANT_RETRIEVE_INSTANCE" },
      {0x20D8, "An internal error has occurred.", "ERROR_DS_CODE_INCONSISTENCY" },
      {0x20D9, "A database error has occurred.", "ERROR_DS_DATABASE_ERROR" },
      {0x20DA, "The attribute GOVERNSID is missing.", "ERROR_DS_GOVERNSID_MISSING" },
      {0x20DB, "An expected attribute is missing.", "ERROR_DS_MISSING_EXPECTED_ATT" },
      {0x20DC, "The specified naming context is missing a cross reference.", "ERROR_DS_NCNAME_MISSING_CR_REF" },
      {0x20DD, "A security checking error has occurred.", "ERROR_DS_SECURITY_CHECKING_ERROR" },
      {0x20DE, "The schema is not loaded.", "ERROR_DS_SCHEMA_NOT_LOADED" },
      {0x20DF, "Schema allocation failed. Please check if the machine is running low on memory.", "ERROR_DS_SCHEMA_ALLOC_FAILED" },
      {0x20E0, "Failed to obtain the required syntax for the attribute schema.", "ERROR_DS_ATT_SCHEMA_REQ_SYNTAX" },
      {0x20E1, "The global catalog verification failed. The global catalog is not available or does not support the operation. Some part of the directory is currently not available.", "ERROR_DS_GCVERIFY_ERROR" },
      {0x20E2, "The replication operation failed because of a schema mismatch between the servers involved.", "ERROR_DS_DRA_SCHEMA_MISMATCH" },
      {0x20E3, "The DSA object could not be found.", "ERROR_DS_CANT_FIND_DSA_OBJ" },
      {0x20E4, "The naming context could not be found.", "ERROR_DS_CANT_FIND_EXPECTED_NC" },
      {0x20E5, "The naming context could not be found in the cache.", "ERROR_DS_CANT_FIND_NC_IN_CACHE" },
      {0x20E6, "The child object could not be retrieved.", "ERROR_DS_CANT_RETRIEVE_CHILD" },
      {0x20E7, "The modification was not permitted for security reasons.", "ERROR_DS_SECURITY_ILLEGAL_MODIFY" },
      {0x20E8, "The operation cannot replace the hidden record.", "ERROR_DS_CANT_REPLACE_HIDDEN_REC" },
      {0x20E9, "The hierarchy file is invalid.", "ERROR_DS_BAD_HIERARCHY_FILE" },
      {0x20EA, "The attempt to build the hierarchy table failed.", "ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED" },
      {0x20EB, "The directory configuration parameter is missing from the registry.", "ERROR_DS_CONFIG_PARAM_MISSING" },
      {0x20EC, "The attempt to count the address book indices failed.", "ERROR_DS_COUNTING_AB_INDICES_FAILED" },
      {0x20ED, "The allocation of the hierarchy table failed.", "ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED" },
      {0x20EE, "The directory service encountered an internal failure.", "ERROR_DS_INTERNAL_FAILURE" },
      {0x20EF, "The directory service encountered an unknown failure.", "ERROR_DS_UNKNOWN_ERROR" },
      {0x20F0, "A root object requires a class of 'top'.", "ERROR_DS_ROOT_REQUIRES_CLASS_TOP" },
      {0x20F1, "This directory server is shutting down, and cannot take ownership of new floating single-master operation roles.", "ERROR_DS_REFUSING_FSMO_ROLES" },
      {0x20F2, "The directory service is missing mandatory configuration information, and is unable to determine the ownership of floating single-master operation roles.", "ERROR_DS_MISSING_FSMO_SETTINGS" },
      {0x20F3, "The directory service was unable to transfer ownership of one or more floating single-master operation roles to other servers.", "ERROR_DS_UNABLE_TO_SURRENDER_ROLES" },
      {0x20F4, "The replication operation failed.", "ERROR_DS_DRA_GENERIC" },
      {0x20F5, "An invalid parameter was specified for this replication operation.", "ERROR_DS_DRA_INVALID_PARAMETER" },
      {0x20F6, "The directory service is too busy to complete the replication operation at this time.", "ERROR_DS_DRA_BUSY" },
      {0x20F7, "The distinguished name specified for this replication operation is invalid.", "ERROR_DS_DRA_BAD_DN" },
      {0x20F8, "The naming context specified for this replication operation is invalid.", "ERROR_DS_DRA_BAD_NC" },
      {0x20F9, "The distinguished name specified for this replication operation already exists.", "ERROR_DS_DRA_DN_EXISTS" },
      {0x20FA, "The replication system encountered an internal error.", "ERROR_DS_DRA_INTERNAL_ERROR" },
      {0x20FB, "The replication operation encountered a database inconsistency.", "ERROR_DS_DRA_INCONSISTENT_DIT" },
      {0x20FC, "The server specified for this replication operation could not be contacted.", "ERROR_DS_DRA_CONNECTION_FAILED" },
      {0x20FD, "The replication operation encountered an object with an invalid instance type.", "ERROR_DS_DRA_BAD_INSTANCE_TYPE" },
      {0x20FE, "The replication operation failed to allocate memory.", "ERROR_DS_DRA_OUT_OF_MEM" },
      {0x20FF, "The replication operation encountered an error with the mail system.", "ERROR_DS_DRA_MAIL_PROBLEM" },
      {0x2100, "The replication reference information for the target server already exists.", "ERROR_DS_DRA_REF_ALREADY_EXISTS" },
      {0x2101, "The replication reference information for the target server does not exist.", "ERROR_DS_DRA_REF_NOT_FOUND" },
      {0x2102, "The naming context cannot be removed because it is replicated to another server.", "ERROR_DS_DRA_OBJ_IS_REP_SOURCE" },
      {0x2103, "The replication operation encountered a database error.", "ERROR_DS_DRA_DB_ERROR" },
      {0x2104, "The naming context is in the process of being removed or is not replicated from the specified server.", "ERROR_DS_DRA_NO_REPLICA" },
      {0x2105, "Replication access was denied.", "ERROR_DS_DRA_ACCESS_DENIED" },
      {0x2106, "The requested operation is not supported by this version of the directory service.", "ERROR_DS_DRA_NOT_SUPPORTED" },
      {0x2107, "The replication remote procedure call was cancelled.", "ERROR_DS_DRA_RPC_CANCELLED" },
      {0x2108, "The source server is currently rejecting replication requests.", "ERROR_DS_DRA_SOURCE_DISABLED" },
      {0x2109, "The destination server is currently rejecting replication requests.", "ERROR_DS_DRA_SINK_DISABLED" },
      {0x210A, "The replication operation failed due to a collision of object names.", "ERROR_DS_DRA_NAME_COLLISION" },
      {0x210B, "The replication source has been reinstalled.", "ERROR_DS_DRA_SOURCE_REINSTALLED" },
      {0x210C, "The replication operation failed because a required parent object is missing.", "ERROR_DS_DRA_MISSING_PARENT" },
      {0x210D, "The replication operation was preempted.", "ERROR_DS_DRA_PREEMPTED" },
      {0x210E, "The replication synchronization attempt was abandoned because of a lack of updates.", "ERROR_DS_DRA_ABANDON_SYNC" },
      {0x210F, "The replication operation was terminated because the system is shutting down.", "ERROR_DS_DRA_SHUTDOWN" },
      {0x2110, "Synchronization attempt failed because the destination DC is currently waiting to synchronize new partial attributes from source. This condition is normal if a recent schema change modified the partial attribute set. The destination partial attribute set is not a subset of the source partial attribute set.", "ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET" },
      {0x2111, "The replication synchronization attempt failed because a master replica attempted to sync from a partial replica.", "ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA" },
      {0x2112, "The server specified for this replication operation was contacted, but that server was unable to contact an additional server needed to complete the operation.", "ERROR_DS_DRA_EXTN_CONNECTION_FAILED" },
      {0x2113, "The version of the Active Directory schema of the source forest is not compatible with the version of Active Directory on this computer.", "ERROR_DS_INSTALL_SCHEMA_MISMATCH" },
      {0x2114, "Schema update failed: An attribute with the same link identifier already exists.", "ERROR_DS_DUP_LINK_ID" },
      {0x2115, "Name translation: Generic processing error.", "ERROR_DS_NAME_ERROR_RESOLVING" },
      {0x2116, "Name translation: Could not find the name or insufficient right to see name.", "ERROR_DS_NAME_ERROR_NOT_FOUND" },
      {0x2117, "Name translation: Input name mapped to more than one output name.", "ERROR_DS_NAME_ERROR_NOT_UNIQUE" },
      {0x2118, "Name translation: Input name found, but not the associated output format.", "ERROR_DS_NAME_ERROR_NO_MAPPING" },
      {0x2119, "Name translation: Unable to resolve completely, only the domain was found.", "ERROR_DS_NAME_ERROR_DOMAIN_ONLY" },
      {0x211A, "Name translation: Unable to perform purely syntactical mapping at the client without going out to the wire.", "ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING" },
      {0x211B, "Modification of a constructed attribute is not allowed.", "ERROR_DS_CONSTRUCTED_ATT_MOD" },
      {0x211C, "The OM-Object-Class specified is incorrect for an attribute with the specified syntax.", "ERROR_DS_WRONG_OM_OBJ_CLASS" },
      {0x211D, "The replication request has been posted; waiting for reply.", "ERROR_DS_DRA_REPL_PENDING" },
      {0x211E, "The requested operation requires a directory service, and none was available.", "ERROR_DS_DS_REQUIRED" },
      {0x211F, "The LDAP display name of the class or attribute contains non-ASCII characters.", "ERROR_DS_INVALID_LDAP_DISPLAY_NAME" },
      {0x2120, "The requested search operation is only supported for base searches.", "ERROR_DS_NON_BASE_SEARCH" },
      {0x2121, "The search failed to retrieve attributes from the database.", "ERROR_DS_CANT_RETRIEVE_ATTS" },
      {0x2122, "The schema update operation tried to add a backward link attribute that has no corresponding forward link.", "ERROR_DS_BACKLINK_WITHOUT_LINK" },
      {0x2123, "Source and destination of a cross domain move do not agree on the object's epoch number. Either source or destination does not have the latest version of the object.", "ERROR_DS_EPOCH_MISMATCH" },
      {0x2124, "Source and destination of a cross domain move do not agree on the object's current name. Either source or destination does not have the latest version of the object.", "ERROR_DS_SRC_NAME_MISMATCH" },
      {0x2125, "Source and destination of a cross domain move operation are identical. Caller should use local move operation instead of cross domain move operation.", "ERROR_DS_SRC_AND_DST_NC_IDENTICAL" },
      {0x2126, "Source and destination for a cross domain move are not in agreement on the naming contexts in the forest. Either source or destination does not have the latest version of the Partitions container.", "ERROR_DS_DST_NC_MISMATCH" },
      {0x2127, "Destination of a cross domain move is not authoritative for the destination naming context.", "ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC" },
      {0x2128, "Source and destination of a cross domain move do not agree on the identity of the source object. Either source or destination does not have the latest version of the source object.", "ERROR_DS_SRC_GUID_MISMATCH" },
      {0x2129, "Object being moved across domains is already known to be deleted by the destination server. The source server does not have the latest version of the source object.", "ERROR_DS_CANT_MOVE_DELETED_OBJECT" },
      {0x212A, "Another operation, which requires exclusive access to the PDC PSMO, is already in progress.", "ERROR_DS_PDC_OPERATION_IN_PROGRESS" },
      {0x212B, "A cross domain move operation failed such that the two versions of the moved object exist - one each in the source and destination domains. The destination object needs to be removed to restore the system to a consistent state.", "ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD" },
      {0x212C, "This object may not be moved across domain boundaries either because cross domain moves for this class are disallowed, or the object has some special characteristics, e.g.: trust account or restricted RID, which prevent its move.", "ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION" },
      {0x212D, "Can't move objects with memberships across domain boundaries as once moved, this would violate the membership conditions of the account group. Remove the object from any account group memberships and retry.", "ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS" },
      {0x212E, "A naming context head must be the immediate child of another naming context head, not of an interior node.", "ERROR_DS_NC_MUST_HAVE_NC_PARENT" },
      {0x212F, "The directory cannot validate the proposed naming context name because it does not hold a replica of the naming context above the proposed naming context. Please ensure that the domain naming master role is held by a server that is configured as a global catalog server, and that the server is up to date with its replication partners. (Applies only to Windows 2000 Domain Naming masters)", "ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE" },
      {0x2130, "Destination domain must be in native mode.", "ERROR_DS_DST_DOMAIN_NOT_NATIVE" },
      {0x2131, "The operation cannot be performed because the server does not have an infrastructure container in the domain of interest.", "ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER" },
      {0x2132, "Cross-domain move of non-empty account groups is not allowed.", "ERROR_DS_CANT_MOVE_ACCOUNT_GROUP" },
      {0x2133, "Cross-domain move of non-empty resource groups is not allowed.", "ERROR_DS_CANT_MOVE_RESOURCE_GROUP" },
      {0x2134, "The search flags for the attribute are invalid. The ANR bit is valid only on attributes of Unicode or Teletex strings.", "ERROR_DS_INVALID_SEARCH_FLAG" },
      {0x2135, "Tree deletions starting at an object which has an NC head as a descendant are not allowed.", "ERROR_DS_NO_TREE_DELETE_ABOVE_NC" },
      {0x2136, "The directory service failed to lock a tree in preparation for a tree deletion because the tree was in use.", "ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE" },
      {0x2137, "The directory service failed to identify the list of objects to delete while attempting a tree deletion.", "ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE" },
      {0x2138, "Security Accounts Manager initialization failed because of the following error: %1. Error Status: 0x%2. Click OK to shut down the system and reboot into Directory Services Restore Mode. Check the event log for detailed information.", "ERROR_DS_SAM_INIT_FAILURE" },
      {0x2139, "Only an administrator can modify the membership list of an administrative group.", "ERROR_DS_SENSITIVE_GROUP_VIOLATION" },
      {0x213A, "Cannot change the primary group ID of a domain controller account.", "ERROR_DS_CANT_MOD_PRIMARYGROUPID" },
      {0x213B, "An attempt is made to modify the base schema.", "ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD" },
      {0x213C, "Adding a new mandatory attribute to an existing class, deleting a mandatory attribute from an existing class, or adding an optional attribute to the special class Top that is not a backlink attribute (directly or through inheritance, for example, by adding or deleting an auxiliary class) is not allowed.", "ERROR_DS_NONSAFE_SCHEMA_CHANGE" },
      {0x213D, "Schema update is not allowed on this DC because the DC is not the schema FSMO Role Owner.", "ERROR_DS_SCHEMA_UPDATE_DISALLOWED" },
      {0x213E, "An object of this class cannot be created under the schema container. You can only create attribute-schema and class-schema objects under the schema container.", "ERROR_DS_CANT_CREATE_UNDER_SCHEMA" },
      {0x213F, "The replica/child install failed to get the objectVersion attribute on the schema container on the source DC. Either the attribute is missing on the schema container or the credentials supplied do not have permission to read it.", "ERROR_DS_INSTALL_NO_SRC_SCH_VERSION" },
      {0x2140, "The replica/child install failed to read the objectVersion attribute in the SCHEMA section of the file schema.ini in the system32 directory.", "ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE" },
      {0x2141, "The specified group type is invalid.", "ERROR_DS_INVALID_GROUP_TYPE" },
      {0x2142, "Cannot nest global groups in a mixed domain if the group is security-enabled.", "ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN" },
      {0x2143, "Cannot nest local groups in a mixed domain if the group is security-enabled.", "ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN" },
      {0x2144, "A global group cannot have a local group as a member.", "ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER" },
      {0x2145, "A global group cannot have a universal group as a member.", "ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER" },
      {0x2146, "A universal group cannot have a local group as a member.", "ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER" },
      {0x2147, "A global group cannot have a cross-domain member.", "ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER" },
      {0x2148, "A local group cannot have another cross-domain local group as a member.", "ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER" },
      {0x2149, "A group with primary members cannot change to a security-disabled group.", "ERROR_DS_HAVE_PRIMARY_MEMBERS" },
      {0x214A, "The schema cache load failed to convert the string default SD on a class-schema object.", "ERROR_DS_STRING_SD_CONVERSION_FAILED" },
      {0x214B, "Only DSAs configured to be Global Catalog servers should be allowed to hold the Domain Naming Master FSMO role. (Applies only to Windows 2000 servers)", "ERROR_DS_NAMING_MASTER_GC" },
      {0x214C, "The DSA operation is unable to proceed because of a DNS lookup failure.", "ERROR_DS_LOOKUP_FAILURE" },
      {0x214D, "While processing a change to the DNS Host Name for an object, the Service Principal Name values could not be kept in sync.", "ERROR_DS_COULDNT_UPDATE_SPNS" },
      {0x214E, "The Security Descriptor attribute could not be read.", "ERROR_DS_CANT_RETRIEVE_SD" },
      {0x214F, "The object requested was not found, but an object with that key was found.", "ERROR_DS_KEY_NOT_UNIQUE" },
      {0x2150, "The syntax of the linked attributed being added is incorrect. Forward links can only have syntax 2.5.5.1, 2.5.5.7, and 2.5.5.14, and backlinks can only have syntax 2.5.5.1.", "ERROR_DS_WRONG_LINKED_ATT_SYNTAX" },
      {0x2151, "Security Account Manager needs to get the boot password.", "ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD" },
      {0x2152, "Security Account Manager needs to get the boot key from floppy disk.", "ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY" },
      {0x2153, "Directory Service cannot start.", "ERROR_DS_CANT_START" },
      {0x2154, "Directory Services could not start.", "ERROR_DS_INIT_FAILURE" },
      {0x2155, "The connection between client and server requires packet privacy or better.", "ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION" },
      {0x2156, "The source domain may not be in the same forest as destination.", "ERROR_DS_SOURCE_DOMAIN_IN_FOREST" },
      {0x2157, "The destination domain must be in the forest.", "ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST" },
      {0x2158, "The operation requires that destination domain auditing be enabled.", "ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED" },
      {0x2159, "The operation couldn't locate a DC for the source domain.", "ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN" },
      {0x215A, "The source object must be a group or user.", "ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER" },
      {0x215B, "The source object's SID already exists in destination forest.", "ERROR_DS_SRC_SID_EXISTS_IN_FOREST" },
      {0x215C, "The source and destination object must be of the same type.", "ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH" },
      {0x215D, "Security Accounts Manager initialization failed because of the following error: %1. Error Status: 0x%2. Click OK to shut down the system and reboot into Safe Mode. Check the event log for detailed information.", "ERROR_SAM_INIT_FAILURE" },
      {0x215E, "Schema information could not be included in the replication request.", "ERROR_DS_DRA_SCHEMA_INFO_SHIP" },
      {0x215F, "The replication operation could not be completed due to a schema incompatibility.", "ERROR_DS_DRA_SCHEMA_CONFLICT" },
      {0x2160, "The replication operation could not be completed due to a previous schema incompatibility.", "ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT" },
      {0x2161, "The replication update could not be applied because either the source or the destination has not yet received information regarding a recent cross-domain move operation.", "ERROR_DS_DRA_OBJ_NC_MISMATCH" },
      {0x2162, "The requested domain could not be deleted because there exist domain controllers that still host this domain.", "ERROR_DS_NC_STILL_HAS_DSAS" },
      {0x2163, "The requested operation can be performed only on a global catalog server.", "ERROR_DS_GC_REQUIRED" },
      {0x2164, "A local group can only be a member of other local groups in the same domain.", "ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY" },
      {0x2165, "Foreign security principals cannot be members of universal groups.", "ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS" },
      {0x2166, "The attribute is not allowed to be replicated to the GC because of security reasons.", "ERROR_DS_CANT_ADD_TO_GC" },
      {0x2167, "The checkpoint with the PDC could not be taken because there are too many modifications being processed currently.", "ERROR_DS_NO_CHECKPOINT_WITH_PDC" },
      {0x2168, "The operation requires that source domain auditing be enabled.", "ERROR_DS_SOURCE_AUDITING_NOT_ENABLED" },
      {0x2169, "Security principal objects can only be created inside domain naming contexts.", "ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC" },
      {0x216A, "A Service Principal Name (SPN) could not be constructed because the provided hostname is not in the necessary format.", "ERROR_DS_INVALID_NAME_FOR_SPN" },
      {0x216B, "A Filter was passed that uses constructed attributes.", "ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS" },
      {0x216C, "The unicodePwd attribute value must be enclosed in double quotes.", "ERROR_DS_UNICODEPWD_NOT_IN_QUOTES" },
      {0x216D, "Your computer could not be joined to the domain. You have exceeded the maximum number of computer accounts you are allowed to create in this domain. Contact your system administrator to have this limit reset or increased.", "ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED" },
      {0x216E, "For security reasons, the operation must be run on the destination DC.", "ERROR_DS_MUST_BE_RUN_ON_DST_DC" },
      {0x216F, "For security reasons, the source DC must be NT4SP4 or greater.", "ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER" },
      {0x2170, "Critical Directory Service System objects cannot be deleted during tree delete operations. The tree delete may have been partially performed.", "ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ" },
      {0x2171, "Directory Services could not start because of the following error: %1. Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.", "ERROR_DS_INIT_FAILURE_CONSOLE" },
      {0x2172, "Security Accounts Manager initialization failed because of the following error: %1. Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.", "ERROR_DS_SAM_INIT_FAILURE_CONSOLE" },
      {0x2173, "The version of the operating system installed is incompatible with the current forest functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this forest.", "ERROR_DS_FOREST_VERSION_TOO_HIGH" },
      {0x2174, "The version of the operating system installed is incompatible with the current domain functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this domain.", "ERROR_DS_DOMAIN_VERSION_TOO_HIGH" },
      {0x2175, "This version of the operating system installed on this server no longer supports the current forest functional level. You must raise the forest functional level before this server can become a domain controller in this forest.", "ERROR_DS_FOREST_VERSION_TOO_LOW" },
      {0x2176, "This version of the operating system installed on this server no longer supports the current domain functional level. You must raise the domain functional level before this server can become a domain controller in this domain.", "ERROR_DS_DOMAIN_VERSION_TOO_LOW" },
      {0x2177, "The version of the operating system installed on this server is incompatible with the functional level of the domain or forest.", "ERROR_DS_INCOMPATIBLE_VERSION" },
      {0x2178, "The functional level of the domain (or forest) cannot be raised to the requested value, because there exist one or more domain controllers in the domain (or forest) that are at a lower incompatible functional level.", "ERROR_DS_LOW_DSA_VERSION" },
      {0x2179, "The forest functional level cannot be raised to the requested level since one or more domains are still in mixed domain mode. All domains in the forest must be in native mode before you can raise the forest functional level.", "ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN" },
      {0x217A, "The sort order requested is not supported.", "ERROR_DS_NOT_SUPPORTED_SORT_ORDER" },
      {0x217B, "The requested name already exists as a unique identifier.", "ERROR_DS_NAME_NOT_UNIQUE" },
      {0x217C, "The machine account was created pre-NT4. The account needs to be recreated.", "ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4" },
      {0x217D, "The database is out of version store.", "ERROR_DS_OUT_OF_VERSION_STORE" },
      {0x217E, "Unable to continue operation because multiple conflicting controls were used.", "ERROR_DS_INCOMPATIBLE_CONTROLS_USED" },
      {0x217F, "Unable to find a valid security descriptor reference domain for this partition.", "ERROR_DS_NO_REF_DOMAIN" },
      {0x2180, "Schema update failed: The link identifier is reserved.", "ERROR_DS_RESERVED_LINK_ID" },
      {0x2181, "Schema update failed: There are no link identifiers available.", "ERROR_DS_LINK_ID_NOT_AVAILABLE" },
      {0x2182, "An account group cannot have a universal group as a member.", "ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER" },
      {0x2183, "Rename or move operations on naming context heads or read-only objects are not allowed.", "ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE" },
      {0x2184, "Move operations on objects in the schema naming context are not allowed.", "ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC" },
      {0x2185, "A system flag has been set on the object and does not allow the object to be moved or renamed.", "ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG" },
      {0x2186, "This object is not allowed to change its grandparent container. Moves are not forbidden on this object, but are restricted to sibling containers.", "ERROR_DS_MODIFYDN_WRONG_GRANDPARENT" },
      {0x2187, "Unable to resolve completely, a referral to another forest is generated.", "ERROR_DS_NAME_ERROR_TRUST_REFERRAL" },
      {0x2188, "The requested action is not supported on standard server.", "ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER" },
      {0x2189, "Could not access a partition of the Active Directory located on a remote server. Make sure at least one server is running for the partition in question.", "ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD" },
      {0x218A, "The directory cannot validate the proposed naming context (or partition) name because it does not hold a replica nor can it contact a replica of the naming context above the proposed naming context. Please ensure that the parent naming context is properly registered in DNS, and at least one replica of this naming context is reachable by the Domain Naming master.", "ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2" },
      {0x218B, "The thread limit for this request was exceeded.", "ERROR_DS_THREAD_LIMIT_EXCEEDED" },
      {0x218C, "The Global catalog server is not in the closet site.", "ERROR_DS_NOT_CLOSEST" },
      {0x218D, "The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the corresponding server object in the local DS database has no serverReference attribute.", "ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF" },
      {0x218E, "The Directory Service failed to enter single user mode.", "ERROR_DS_SINGLE_USER_MODE_FAILED" },
      {0x218F, "The Directory Service cannot parse the script because of a syntax error.", "ERROR_DS_NTDSCRIPT_SYNTAX_ERROR" },
      {0x2190, "The Directory Service cannot process the script because of an error.", "ERROR_DS_NTDSCRIPT_PROCESS_ERROR" },
      {0x2191, "The directory service cannot perform the requested operation because the servers involved are of different replication epochs (which is usually related to a domain rename that is in progress).", "ERROR_DS_DIFFERENT_REPL_EPOCHS" },
      {0x2192, "The directory service binding must be renegotiated due to a change in the server extensions information.", "ERROR_DS_DRS_EXTENSIONS_CHANGED" },
      {0x2193, "Operation not allowed on a disabled cross ref.", "ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR" },
      {0x2194, "Schema update failed: No values for msDS-IntId are available.", "ERROR_DS_NO_MSDS_INTID" },
      {0x2195, "Schema update failed: Duplicate msDS-IntId. Retry the operation.", "ERROR_DS_DUP_MSDS_INTID" },
      {0x2196, "Schema deletion failed: attribute is used in rDNAttID.", "ERROR_DS_EXISTS_IN_RDNATTID" },
      {0x2197, "The directory service failed to authorize the request.", "ERROR_DS_AUTHORIZATION_FAILED" },
      {0x2198, "The Directory Service cannot process the script because it is invalid.", "ERROR_DS_INVALID_SCRIPT" },
      {0x2199, "The remote create cross reference operation failed on the Domain Naming Master FSMO. The operation's error is in the extended data.", "ERROR_DS_REMOTE_CROSSREF_OP_FAILED" },
      {0x219A, "A cross reference is in use locally with the same name.", "ERROR_DS_CROSS_REF_BUSY" },
      {0x219B, "The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the server's domain has been deleted from the forest.", "ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN" },
      {0x219C, "Writeable NCs prevent this DC from demoting.", "ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC" },
      {0x219D, "The requested object has a non-unique identifier and cannot be retrieved.", "ERROR_DS_DUPLICATE_ID_FOUND" },
      {0x219E, "Insufficient attributes were given to create an object. This object may not exist because it may have been deleted and already garbage collected.", "ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT" },
      {0x219F, "The group cannot be converted due to attribute restrictions on the requested group type.", "ERROR_DS_GROUP_CONVERSION_ERROR" },
      {0x21A0, "Cross-domain move of non-empty basic application groups is not allowed.", "ERROR_DS_CANT_MOVE_APP_BASIC_GROUP" },
      {0x21A1, "Cross-domain move on non-empty query based application groups is not allowed.", "ERROR_DS_CANT_MOVE_APP_QUERY_GROUP" },
      {0x21A2, "The role owner could not be verified because replication of its partition has not occurred recently.", "ERROR_DS_ROLE_NOT_VERIFIED" },
      {0x21A3, "The target container for a redirection of a well-known object container cannot already be a special container.", "ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL" },
      {0x21A4, "The Directory Service cannot perform the requested operation because a domain rename operation is in progress.", "ERROR_DS_DOMAIN_RENAME_IN_PROGRESS" },
      {0x21A5, "The Active Directory detected an Active Directory child partition below the requested new partition name. The Active Directory's partition hierarchy must be created in a top-down method.", "ERROR_DS_EXISTING_AD_CHILD_NC" },
      {0x21A6, "The Active Directory cannot replicate with this server because the time since the last replication with this server has exceeded the tombstone lifetime.", "ERROR_DS_REPL_LIFETIME_EXCEEDED" },
      {0x21A7, "The requested operation is not allowed on an object under the system container.", "ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER" },
      {0x21A8, "The LDAP servers network send queue has filled up because the client is not processing the results of it's requests fast enough. No more requests will be processed until the client catches up. If the client does not catch up then it will be disconnected.", "ERROR_DS_LDAP_SEND_QUEUE_FULL" },
      {0x21A9, "The scheduled replication did not take place because the system was too busy to execute the request within the schedule window. The replication queue is overloaded. Consider reducing the number of partners or decreasing the scheduled replication frequency.", "ERROR_DS_DRA_OUT_SCHEDULE_WINDOW" },
      {0x2329, "DNS server unable to interpret format.", "DNS_ERROR_RCODE_FORMAT_ERROR" },
      {0x232A, "DNS server failure.", "DNS_ERROR_RCODE_SERVER_FAILURE" },
      {0x232B, "DNS name does not exist.", "DNS_ERROR_RCODE_NAME_ERROR" },
      {0x232C, "DNS request not supported by name server.", "DNS_ERROR_RCODE_NOT_IMPLEMENTED" },
      {0x232D, "DNS operation refused.", "DNS_ERROR_RCODE_REFUSED" },
      {0x232E, "DNS name that ought not exist, does exist.", "DNS_ERROR_RCODE_YXDOMAIN" },
      {0x232F, "DNS RR set that ought not exist, does exist.", "DNS_ERROR_RCODE_YXRRSET" },
      {0x2330, "DNS RR set that ought to exist, does not exist.", "DNS_ERROR_RCODE_NXRRSET" },
      {0x2331, "DNS server not authoritative for zone.", "DNS_ERROR_RCODE_NOTAUTH" },
      {0x2332, "DNS name in update or prereq is not in zone.", "DNS_ERROR_RCODE_NOTZONE" },
      {0x2338, "DNS signature failed to verify.", "DNS_ERROR_RCODE_BADSIG" },
      {0x2339, "DNS bad key.", "DNS_ERROR_RCODE_BADKEY" },
      {0x233A, "DNS signature validity expired.", "DNS_ERROR_RCODE_BADTIME" },
      {0x251D, "No records found for given DNS query.", "DNS_INFO_NO_RECORDS" },
      {0x251E, "Bad DNS packet.", "DNS_ERROR_BAD_PACKET" },
      {0x251F, "No DNS packet.", "DNS_ERROR_NO_PACKET" },
      {0x2520, "DNS error, check rcode.", "DNS_ERROR_RCODE" },
      {0x2521, "Unsecured DNS packet.", "DNS_ERROR_UNSECURE_PACKET" },
      {0x254F, "Invalid DNS type.", "DNS_ERROR_INVALID_TYPE" },
      {0x2550, "Invalid IP address.", "DNS_ERROR_INVALID_IP_ADDRESS" },
      {0x2551, "Invalid property.", "DNS_ERROR_INVALID_PROPERTY" },
      {0x2552, "Try DNS operation again later.", "DNS_ERROR_TRY_AGAIN_LATER" },
      {0x2553, "Record for given name and type is not unique.", "DNS_ERROR_NOT_UNIQUE" },
      {0x2554, "DNS name does not comply with RFC specifications.", "DNS_ERROR_NON_RFC_NAME" },
      {0x2555, "DNS name is a fully-qualified DNS name.", "DNS_STATUS_FQDN" },
      {0x2556, "DNS name is dotted (multi-label).", "DNS_STATUS_DOTTED_NAME" },
      {0x2557, "DNS name is a single-part name.", "DNS_STATUS_SINGLE_PART_NAME" },
      {0x2558, "DSN name contains an invalid character.", "DNS_ERROR_INVALID_NAME_CHAR" },
      {0x2559, "DNS name is entirely numeric.", "DNS_ERROR_NUMERIC_NAME" },
      {0x255A, "The operation requested is not permitted on a DNS root server.", "DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER" },
      {0x255B, "The record could not be created because this part of the DNS namespace has been delegated to another server.", "DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION" },
      {0x255C, "The DNS server could not find a set of root hints.", "DNS_ERROR_CANNOT_FIND_ROOT_HINTS" },
      {0x255D, "The DNS server found root hints but they were not consistent across all adapters.", "DNS_ERROR_INCONSISTENT_ROOT_HINTS" },
      {0x2581, "DNS zone does not exist.", "DNS_ERROR_ZONE_DOES_NOT_EXIST" },
      {0x2582, "DNS zone information not available.", "DNS_ERROR_NO_ZONE_INFO" },
      {0x2583, "Invalid operation for DNS zone.", "DNS_ERROR_INVALID_ZONE_OPERATION" },
      {0x2584, "Invalid DNS zone configuration.", "DNS_ERROR_ZONE_CONFIGURATION_ERROR" },
      {0x2585, "DNS zone has no start of authority (SOA) record.", "DNS_ERROR_ZONE_HAS_NO_SOA_RECORD" },
      {0x2586, "DNS zone has no name server (NS) record.", "DNS_ERROR_ZONE_HAS_NO_NS_RECORDS" },
      {0x2587, "DNS zone is locked.", "DNS_ERROR_ZONE_LOCKED" },
      {0x2588, "DNS zone creation failed.", "DNS_ERROR_ZONE_CREATION_FAILED" },
      {0x2589, "DNS zone already exists.", "DNS_ERROR_ZONE_ALREADY_EXISTS" },
      {0x258A, "DNS automatic zone already exists.", "DNS_ERROR_AUTOZONE_ALREADY_EXISTS" },
      {0x258B, "Invalid DNS zone type.", "DNS_ERROR_INVALID_ZONE_TYPE" },
      {0x258C, "Secondary DNS zone requires master IP address.", "DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP" },
      {0x258D, "DNS zone not secondary.", "DNS_ERROR_ZONE_NOT_SECONDARY" },
      {0x258E, "Need secondary IP address.", "DNS_ERROR_NEED_SECONDARY_ADDRESSES" },
      {0x258F, "WINS initialization failed.", "DNS_ERROR_WINS_INIT_FAILED" },
      {0x2590, "Need WINS servers.", "DNS_ERROR_NEED_WINS_SERVERS" },
      {0x2591, "NBTSTAT initialization call failed.", "DNS_ERROR_NBSTAT_INIT_FAILED" },
      {0x2592, "Invalid delete of start of authority (SOA)", "DNS_ERROR_SOA_DELETE_INVALID" },
      {0x2593, "A conditional forwarding zone already exists for that name.", "DNS_ERROR_FORWARDER_ALREADY_EXISTS" },
      {0x2594, "This zone must be configured with one or more master DNS server IP addresses.", "DNS_ERROR_ZONE_REQUIRES_MASTER_IP" },
      {0x2595, "The operation cannot be performed because this zone is shutdown.", "DNS_ERROR_ZONE_IS_SHUTDOWN" },
      {0x25B3, "Primary DNS zone requires datafile.", "DNS_ERROR_PRIMARY_REQUIRES_DATAFILE" },
      {0x25B4, "Invalid datafile name for DNS zone.", "DNS_ERROR_INVALID_DATAFILE_NAME" },
      {0x25B5, "Failed to open datafile for DNS zone.", "DNS_ERROR_DATAFILE_OPEN_FAILURE" },
      {0x25B6, "Failed to write datafile for DNS zone.", "DNS_ERROR_FILE_WRITEBACK_FAILED" },
      {0x25B7, "Failure while reading datafile for DNS zone.", "DNS_ERROR_DATAFILE_PARSING" },
      {0x25E5, "DNS record does not exist.", "DNS_ERROR_RECORD_DOES_NOT_EXIST" },
      {0x25E6, "DNS record format error.", "DNS_ERROR_RECORD_FORMAT" },
      {0x25E7, "Node creation failure in DNS.", "DNS_ERROR_NODE_CREATION_FAILED" },
      {0x25E8, "Unknown DNS record type.", "DNS_ERROR_UNKNOWN_RECORD_TYPE" },
      {0x25E9, "DNS record timed out.", "DNS_ERROR_RECORD_TIMED_OUT" },
      {0x25EA, "Name not in DNS zone.", "DNS_ERROR_NAME_NOT_IN_ZONE" },
      {0x25EB, "CNAME loop detected.", "DNS_ERROR_CNAME_LOOP" },
      {0x25EC, "Node is a CNAME DNS record.", "DNS_ERROR_NODE_IS_CNAME" },
      {0x25ED, "A CNAME record already exists for given name.", "DNS_ERROR_CNAME_COLLISION" },
      {0x25EE, "Record only at DNS zone root.", "DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT" },
      {0x25EF, "DNS record already exists.", "DNS_ERROR_RECORD_ALREADY_EXISTS" },
      {0x25F0, "Secondary DNS zone data error.", "DNS_ERROR_SECONDARY_DATA" },
      {0x25F1, "Could not create DNS cache data.", "DNS_ERROR_NO_CREATE_CACHE_DATA" },
      {0x25F2, "DNS name does not exist.", "DNS_ERROR_NAME_DOES_NOT_EXIST" },
      {0x25F3, "Could not create pointer (PTR) record.", "DNS_WARNING_PTR_CREATE_FAILED" },
      {0x25F4, "DNS domain was undeleted.", "DNS_WARNING_DOMAIN_UNDELETED" },
      {0x25F5, "The directory service is unavailable.", "DNS_ERROR_DS_UNAVAILABLE" },
      {0x25F6, "DNS zone already exists in the directory service.", "DNS_ERROR_DS_ZONE_ALREADY_EXISTS" },
      {0x25F7, "DNS server not creating or reading the boot file for the directory service integrated DNS zone.", "DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE" },
      {0x2617, "DNS AXFR (zone transfer) complete.", "DNS_INFO_AXFR_COMPLETE" },
      {0x2618, "DNS zone transfer failed.", "DNS_ERROR_AXFR" },
      {0x2619, "Added local WINS server.", "DNS_INFO_ADDED_LOCAL_WINS" },
      {0x2649, "Secure update call needs to continue update request.", "DNS_STATUS_CONTINUE_NEEDED" },
      {0x267B, "TCP/IP network protocol not installed.", "DNS_ERROR_NO_TCPIP" },
      {0x267C, "No DNS servers configured for local system.", "DNS_ERROR_NO_DNS_SERVERS" },
      {0x26AD, "The specified directory partition does not exist.", "DNS_ERROR_DP_DOES_NOT_EXIST" },
      {0x26AE, "The specified directory partition already exists.", "DNS_ERROR_DP_ALREADY_EXISTS" },
      {0x26AF, "The DNS server is not enlisted in the specified directory partition.", "DNS_ERROR_DP_NOT_ENLISTED" },
      {0x26B0, "The DNS server is already enlisted in the specified directory partition.", "DNS_ERROR_DP_ALREADY_ENLISTED" },
      {0x26B1, "The directory partition is not available at this time. Please wait a few minutes and try again.", "DNS_ERROR_DP_NOT_AVAILABLE" },
      {0x26B2, "The application directory partition operation failed. The domain controller holding the domain naming master role is down or unable to service the request or is not running Windows Server 2003.", "DNS_ERROR_DP_FSMO_ERROR" },
      {0x2714, "A blocking operation was interrupted by a call to WSACancelBlockingCall.", "WSAEINTR" },
      {0x2719, "The file handle supplied is not valid.", "WSAEBADF" },
      {0x271D, "An attempt was made to access a socket in a way forbidden by its access permissions.", "WSAEACCES" },
      {0x271E, "The system detected an invalid pointer address in attempting to use a pointer argument in a call.", "WSAEFAULT" },
      {0x2726, "An invalid argument was supplied.", "WSAEINVAL" },
      {0x2728, "Too many open sockets.", "WSAEMFILE" },
      {0x2733, "A non-blocking socket operation could not be completed immediately.", "WSAEWOULDBLOCK" },
      {0x2734, "A blocking operation is currently executing.", "WSAEINPROGRESS" },
      {0x2735, "An operation was attempted on a non-blocking socket that already had an operation in progress.", "WSAEALREADY" },
      {0x2736, "An operation was attempted on something that is not a socket.", "WSAENOTSOCK" },
      {0x2737, "A required address was omitted from an operation on a socket.", "WSAEDESTADDRREQ" },
      {0x2738, "A message sent on a datagram socket was larger than the internal message buffer or some other network limit, or the buffer used to receive a datagram into was smaller than the datagram itself.", "WSAEMSGSIZE" },
      {0x2739, "A protocol was specified in the socket function call that does not support the semantics of the socket type requested.", "WSAEPROTOTYPE" },
      {0x273A, "An unknown, invalid, or unsupported option or level was specified in a getsockopt or setsockopt call.", "WSAENOPROTOOPT" },
      {0x273B, "The requested protocol has not been configured into the system, or no implementation for it exists.", "WSAEPROTONOSUPPORT" },
      {0x273C, "The support for the specified socket type does not exist in this address family.", "WSAESOCKTNOSUPPORT" },
      {0x273D, "The attempted operation is not supported for the type of object referenced.", "WSAEOPNOTSUPP" },
      {0x273E, "The protocol family has not been configured into the system or no implementation for it exists.", "WSAEPFNOSUPPORT" },
      {0x273F, "An address incompatible with the requested protocol was used.", "WSAEAFNOSUPPORT" },
      {0x2740, "Only one usage of each socket address (protocol/network address/port) is normally permitted.", "WSAEADDRINUSE" },
      {0x2741, "The requested address is not valid in its context.", "WSAEADDRNOTAVAIL" },
      {0x2742, "A socket operation encountered a dead network.", "WSAENETDOWN" },
      {0x2743, "A socket operation was attempted to an unreachable network.", "WSAENETUNREACH" },
      {0x2744, "The connection has been broken due to keep-alive activity detecting a failure while the operation was in progress.", "WSAENETRESET" },
      {0x2745, "An established connection was aborted by the software in your host machine.", "WSAECONNABORTED" },
      {0x2746, "An existing connection was forcibly closed by the remote host.", "WSAECONNRESET" },
      {0x2747, "An operation on a socket could not be performed because the system lacked sufficient buffer space or because a queue was full.", "WSAENOBUFS" },
      {0x2748, "A connect request was made on an already connected socket.", "WSAEISCONN" },
      {0x2749, "A request to send or receive data was disallowed because the socket is not connected and (when sending on a datagram socket using a sendto call) no address was supplied.", "WSAENOTCONN" },
      {0x274A, "A request to send or receive data was disallowed because the socket had already been shut down in that direction with a previous shutdown call.", "WSAESHUTDOWN" },
      {0x274B, "Too many references to some kernel object.", "WSAETOOMANYREFS" },
      {0x274C, "A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.", "WSAETIMEDOUT" },
      {0x274D, "No connection could be made because the target machine actively refused it.", "WSAECONNREFUSED" },
      {0x274E, "Cannot translate name.", "WSAELOOP" },
      {0x274F, "Name component or name was too long.", "WSAENAMETOOLONG" },
      {0x2750, "A socket operation failed because the destination host was down.", "WSAEHOSTDOWN" },
      {0x2751, "A socket operation was attempted to an unreachable host.", "WSAEHOSTUNREACH" },
      {0x2752, "Cannot remove a directory that is not empty.", "WSAENOTEMPTY" },
      {0x2753, "A Windows Sockets implementation may have a limit on the number of applications that may use it simultaneously.", "WSAEPROCLIM" },
      {0x2754, "Ran out of quota.", "WSAEUSERS" },
      {0x2755, "Ran out of disk quota.", "WSAEDQUOT" },
      {0x2756, "File handle reference is no longer available.", "WSAESTALE" },
      {0x2757, "Item is not available locally.", "WSAEREMOTE" },
      {0x276B, "WSAStartup cannot function at this time because the underlying system it uses to provide network services is currently unavailable.", "WSASYSNOTREADY" },
      {0x276C, "The Windows Sockets version requested is not supported.", "WSAVERNOTSUPPORTED" },
      {0x276D, "Either the application has not called WSAStartup, or WSAStartup failed.", "WSANOTINITIALISED" },
      {0x2775, "Returned by WSARecv or WSARecvFrom to indicate the remote party has initiated a graceful shutdown sequence.", "WSAEDISCON" },
      {0x2776, "No more results can be returned by WSALookupServiceNext.", "WSAENOMORE" },
      {0x2777, "A call to WSALookupServiceEnd was made while this call was still processing. The call has been canceled.", "WSAECANCELLED" },
      {0x2778, "The procedure call table is invalid.", "WSAEINVALIDPROCTABLE" },
      {0x2779, "The requested service provider is invalid.", "WSAEINVALIDPROVIDER" },
      {0x277A, "The requested service provider could not be loaded or initialized.", "WSAEPROVIDERFAILEDINIT" },
      {0x277B, "A system call that should never fail has failed.", "WSASYSCALLFAILURE" },
      {0x277C, "No such service is known. The service cannot be found in the specified name space.", "WSASERVICE_NOT_FOUND" },
      {0x277D, "The specified class was not found.", "WSATYPE_NOT_FOUND" },
      {0x277E, "No more results can be returned by WSALookupServiceNext.", "WSA_E_NO_MORE" },
      {0x277F, "A call to WSALookupServiceEnd was made while this call was still processing. The call has been canceled.", "WSA_E_CANCELLED" },
      {0x2780, "A database query failed because it was actively refused.", "WSAEREFUSED" },
      {0x2AF9, "No such host is known.", "WSAHOST_NOT_FOUND" },
      {0x2AFA, "This is usually a temporary error during hostname resolution and means that the local server did not receive a response from an authoritative server.", "WSATRY_AGAIN" },
      {0x2AFB, "A non-recoverable error occurred during a database lookup.", "WSANO_RECOVERY" },
      {0x2AFC, "The requested name is valid, but no data of the requested type was found.", "WSANO_DATA" },
      {0x2AFD, "At least one reserve has arrived.", "WSA_QOS_RECEIVERS" },
      {0x2AFE, "At least one path has arrived.", "WSA_QOS_SENDERS" },
      {0x2AFF, "There are no senders.", "WSA_QOS_NO_SENDERS" },
      {0x2B00, "There are no receivers.", "WSA_QOS_NO_RECEIVERS" },
      {0x2B01, "Reserve has been confirmed.", "WSA_QOS_REQUEST_CONFIRMED" },
      {0x2B02, "Error due to lack of resources.", "WSA_QOS_ADMISSION_FAILURE" },
      {0x2B03, "Rejected for administrative reasons - bad credentials.", "WSA_QOS_POLICY_FAILURE" },
      {0x2B04, "Unknown or conflicting style.", "WSA_QOS_BAD_STYLE" },
      {0x2B05, "Problem with some part of the filterspec or providerspecific buffer in general.", "WSA_QOS_BAD_OBJECT" },
      {0x2B06, "Problem with some part of the flowspec.", "WSA_QOS_TRAFFIC_CTRL_ERROR" },
      {0x2B07, "General QOS error.", "WSA_QOS_GENERIC_ERROR" },
      {0x2B08, "An invalid or unrecognized service type was found in the flowspec.", "WSA_QOS_ESERVICETYPE" },
      {0x2B09, "An invalid or inconsistent flowspec was found in the QOS structure.", "WSA_QOS_EFLOWSPEC" },
      {0x2B0A, "Invalid QOS provider-specific buffer.", "WSA_QOS_EPROVSPECBUF" },
      {0x2B0B, "An invalid QOS filter style was used.", "WSA_QOS_EFILTERSTYLE" },
      {0x2B0C, "An invalid QOS filter type was used.", "WSA_QOS_EFILTERTYPE" },
      {0x2B0D, "An incorrect number of QOS FILTERSPECs were specified in the FLOWDESCRIPTOR.", "WSA_QOS_EFILTERCOUNT" },
      {0x2B0E, "An object with an invalid ObjectLength field was specified in the QOS provider-specific buffer.", "WSA_QOS_EOBJLENGTH" },
      {0x2B0F, "An incorrect number of flow descriptors was specified in the QOS structure.", "WSA_QOS_EFLOWCOUNT" },
      {0x2B10, "An unrecognized object was found in the QOS provider-specific buffer.", "WSA_QOS_EUNKNOWNPSOBJ" },
      {0x2B11, "An invalid policy object was found in the QOS provider-specific buffer.", "WSA_QOS_EPOLICYOBJ" },
      {0x2B12, "An invalid QOS flow descriptor was found in the flow descriptor list.", "WSA_QOS_EFLOWDESC" },
      {0x2B13, "An invalid or inconsistent flowspec was found in the QOS provider-specific buffer.", "WSA_QOS_EPSFLOWSPEC" },
      {0x2B14, "An invalid FILTERSPEC was found in the QOS provider-specific buffer.", "WSA_QOS_EPSFILTERSPEC" },
      {0x2B15, "An invalid shape discard mode object was found in the QOS provider-specific buffer.", "WSA_QOS_ESDMODEOBJ" },
      {0x2B16, "An invalid shaping rate object was found in the QOS provider-specific buffer.", "WSA_QOS_ESHAPERATEOBJ" },
      {0x2B17, "A reserved policy element was found in the QOS provider-specific buffer.", "WSA_QOS_RESERVED_PETYPE" },
      {0x2EE0, "The IO was completed by a filter.", "ERROR_FLT_IO_COMPLETE" },
      {0x2EE1, "The buffer is too small to contain the entry. No information has been written to the buffer.", "ERROR_FLT_BUFFER_TOO_SMALL" },
      {0x2EE2, "A handler was not defined by the filter for this operation.", "ERROR_FLT_NO_HANDLER_DEFINED" },
      {0x2EE3, "A context is already defined for this object.", "ERROR_FLT_CONTEXT_ALREADY_DEFINED" },
      {0x2EE4, "Asynchronous requests are not valid for this operation.", "ERROR_FLT_INVALID_ASYNCHRONOUS_REQUEST" },
      {0x2EE5, "Disallow the Fast IO path for this operation.", "ERROR_FLT_DISALLOW_FAST_IO" },
      {0x2EE6, "An invalid name request was made. The name requested cannot be retrieved at this time.", "ERROR_FLT_INVALID_NAME_REQUEST" },
      {0x2EE7, "Posting this operation to a worker thread for further processing is not safe at this time because it could lead to a system deadlock. ", "ERROR_FLT_NOT_SAFE_TO_POST_OPERATION" },
      {0x2EE8, "The Filter Manager was not initialized when a filter tried to register. Make sure that the Filter Manager is getting loaded as a driver. ", "ERROR_FLT_NOT_INITIALIZED" },
      {0x2EE9, "The filter is not ready for attachment to volumes because it has not finished initializing (FltStartFiltering has not been called). ", "ERROR_FLT_FILTER_NOT_READY" },
      {0x2EEA, "The filter must cleanup any operation specific context at this time because it is being removed from the system before the operation is completed by the lower drivers. ", "ERROR_FLT_POST_OPERATION_CLEANUP" },
      {0x2EEB, "The Filter Manager had an internal error from which it cannot recover, therefore the operation has been failed. This is usually the result of a filter returning an invalid value from a pre-operation callback.", "ERROR_FLT_INTERNAL_ERROR" },
      {0x2EEC, "The object specified for this action is in the process of being deleted, therefore the action requested cannot be completed at this time.", "ERROR_FLT_DELETING_OBJECT" },
      {0x2EED, "Non-paged pool must be used for this type of context.", "ERROR_FLT_MUST_BE_NONPAGED_POOL" },
      {0x2EEE, "A duplicate handler definition has been provided for an operation.", "ERROR_FLT_DUPLICATE_ENTRY" },
      {0x2EEF, "The callback data queue has been disabled.", "ERROR_FLT_CBDQ_DISABLED" },
      {0x2EF0, "Do not attach the filter to the volume at this time.", "ERROR_FLT_DO_NOT_ATTACH" },
      {0x2EF1, "Do not detach the filter from the volume at this time.", "ERROR_FLT_DO_NOT_DETACH" },
      {0x2EF2, "An instance already exists at this altitude on the volume specified.", "ERROR_FLT_INSTANCE_ALTITUDE_COLLISION" },
      {0x2EF3, "An instance already exists with this name on the volume specified.", "ERROR_FLT_INSTANCE_NAME_COLLISION" },
      {0x2EF4, "The system could not find the filter specified.", "ERROR_FLT_FILTER_NOT_FOUND" },
      {0x2EF5, "The system could not find the volume specified.", "ERROR_FLT_VOLUME_NOT_FOUND" },
      {0x2EF6, "The system could not find the instance specified.", "ERROR_FLT_INSTANCE_NOT_FOUND" },
      {0x2EF7, "No registered context allocation definition was found for the given request.", "ERROR_FLT_CONTEXT_ALLOCATION_NOT_FOUND" },
      {0x2EF8, "An invalid parameter was specified during context registration.", "ERROR_FLT_INVALID_CONTEXT_REGISTRATION" },
      {0x2EF9, "The name requested was not found in Filter Manager's name cache and could not be retrieved from the file system.", "ERROR_FLT_NAME_CACHE_MISS" },
      {0x2EFA, "The requested device object does not exist for the given volume.", "ERROR_FLT_NO_DEVICE_OBJECT" },
      {0x2EFB, "The specified volume is already mounted.", "ERROR_FLT_VOLUME_ALREADY_MOUNTED" },
      {0x2EFC, "No waiter is present for the filter's reply to this message.", "ERROR_FLT_NO_WAITER_FOR_REPLY" },
      {0x32C8, "The specified quick mode policy already exists.", "ERROR_IPSEC_QM_POLICY_EXISTS" },
      {0x32C9, "The specified quick mode policy was not found.", "ERROR_IPSEC_QM_POLICY_NOT_FOUND" },
      {0x32CA, "The specified quick mode policy is being used.", "ERROR_IPSEC_QM_POLICY_IN_USE" },
      {0x32CB, "The specified main mode policy already exists.", "ERROR_IPSEC_MM_POLICY_EXISTS" },
      {0x32CC, "The specified main mode policy was not found.", "ERROR_IPSEC_MM_POLICY_NOT_FOUND" },
      {0x32CD, "The specified main mode policy is being used.", "ERROR_IPSEC_MM_POLICY_IN_USE" },
      {0x32CE, "The specified main mode filter already exists.", "ERROR_IPSEC_MM_FILTER_EXISTS" },
      {0x32CF, "The specified main mode filter was not found.", "ERROR_IPSEC_MM_FILTER_NOT_FOUND" },
      {0x32D0, "The specified transport mode filter already exists.", "ERROR_IPSEC_TRANSPORT_FILTER_EXISTS" },
      {0x32D1, "The specified transport mode filter does not exist.", "ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND" },
      {0x32D2, "The specified main mode authentication list exists.", "ERROR_IPSEC_MM_AUTH_EXISTS" },
      {0x32D3, "The specified main mode authentication list was not found.", "ERROR_IPSEC_MM_AUTH_NOT_FOUND" },
      {0x32D4, "The specified quick mode policy is being used.", "ERROR_IPSEC_MM_AUTH_IN_USE" },
      {0x32D5, "The specified main mode policy was not found.", "ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND" },
      {0x32D6, "The specified quick mode policy was not found.", "ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND" },
      {0x32D7, "The manifest file contains one or more syntax errors.", "ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND" },
      {0x32D8, "The application attempted to activate a disabled activation context.", "ERROR_IPSEC_TUNNEL_FILTER_EXISTS" },
      {0x32D9, "The requested lookup key was not found in any active activation context.", "ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND" },
      {0x32DA, "The Main Mode filter is pending deletion.", "ERROR_IPSEC_MM_FILTER_PENDING_DELETION" },
      {0x32DB, "The transport filter is pending deletion.", "ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION" },
      {0x32DC, "The tunnel filter is pending deletion.", "ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION" },
      {0x32DD, "The Main Mode policy is pending deletion.", "ERROR_IPSEC_MM_POLICY_PENDING_DELETION" },
      {0x32DE, "The Main Mode authentication bundle is pending deletion.", "ERROR_IPSEC_MM_AUTH_PENDING_DELETION" },
      {0x32DF, "The Quick Mode policy is pending deletion.", "ERROR_IPSEC_QM_POLICY_PENDING_DELETION" },
      {0x32E0, "The Main Mode policy was successfully added, but some of the requested offers are not supported.", "WARNING_IPSEC_MM_POLICY_PRUNED" },
      {0x32E1, "The Quick Mode policy was successfully added, but some of the requested offers are not supported.", "WARNING_IPSEC_QM_POLICY_PRUNED" },
      {0x35E9, "IKE authentication credentials are unacceptable.", "ERROR_IPSEC_IKE_AUTH_FAIL" },
      {0x35EA, "IKE security attributes are unacceptable.", "ERROR_IPSEC_IKE_ATTRIB_FAIL" },
      {0x35EB, "IKE Negotiation in progress.", "ERROR_IPSEC_IKE_NEGOTIATION_PENDING" },
      {0x35EC, "General processing error.", "ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR" },
      {0x35ED, "Negotiation timed out.", "ERROR_IPSEC_IKE_TIMED_OUT" },
      {0x35EE, "IKE failed to find valid machine certificate.", "ERROR_IPSEC_IKE_NO_CERT" },
      {0x35EF, "IKE SA deleted by peer before establishment completed.", "ERROR_IPSEC_IKE_SA_DELETED" },
      {0x35F0, "IKE SA deleted before establishment completed.", "ERROR_IPSEC_IKE_SA_REAPED" },
      {0x35F1, "Negotiation request sat in Queue too long.", "ERROR_IPSEC_IKE_MM_ACQUIRE_DROP" },
      {0x35F2, "Negotiation request sat in Queue too long.", "ERROR_IPSEC_IKE_QM_ACQUIRE_DROP" },
      {0x35F3, "Negotiation request sat in Queue too long.", "ERROR_IPSEC_IKE_QUEUE_DROP_MM" },
      {0x35F4, "Negotiation request sat in Queue too long.", "ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM" },
      {0x35F5, "No response from peer.", "ERROR_IPSEC_IKE_DROP_NO_RESPONSE" },
      {0x35F6, "Negotiation took too long.", "ERROR_IPSEC_IKE_MM_DELAY_DROP" },
      {0x35F7, "Negotiation took too long.", "ERROR_IPSEC_IKE_QM_DELAY_DROP" },
      {0x35F8, "Unknown error occurred.", "ERROR_IPSEC_IKE_ERROR" },
      {0x35F9, "Certificate Revocation Check failed.", "ERROR_IPSEC_IKE_CRL_FAILED" },
      {0x35FA, "Invalid certificate key usage.", "ERROR_IPSEC_IKE_INVALID_KEY_USAGE" },
      {0x35FB, "Invalid certificate type.", "ERROR_IPSEC_IKE_INVALID_CERT_TYPE" },
      {0x35FC, "No private key associated with machine certificate.", "ERROR_IPSEC_IKE_NO_PRIVATE_KEY" },
      {0x35FE, "Failure in Diffie-Hellman computation.", "ERROR_IPSEC_IKE_DH_FAIL" },
      {0x3600, "Invalid header.", "ERROR_IPSEC_IKE_INVALID_HEADER" },
      {0x3601, "No policy configured.", "ERROR_IPSEC_IKE_NO_POLICY" },
      {0x3602, "Failed to verify signature.", "ERROR_IPSEC_IKE_INVALID_SIGNATURE" },
      {0x3603, "Failed to authenticate using Kerberos.", "ERROR_IPSEC_IKE_KERBEROS_ERROR" },
      {0x3604, "Peer's certificate did not have a public key.", "ERROR_IPSEC_IKE_NO_PUBLIC_KEY" },
      {0x3605, "Error processing error payload.", "ERROR_IPSEC_IKE_PROCESS_ERR" },
      {0x3606, "Error processing SA payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_SA" },
      {0x3607, "Error processing Proposal payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_PROP" },
      {0x3608, "Error processing Transform payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_TRANS" },
      {0x3609, "Error processing KE payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_KE" },
      {0x360A, "Error processing ID payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_ID" },
      {0x360B, "Error processing Cert payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_CERT" },
      {0x360C, "Error processing Certificate Request payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ" },
      {0x360D, "Error processing Hash payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_HASH" },
      {0x360E, "Error processing Signature payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_SIG" },
      {0x360F, "Error processing Nonce payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_NONCE" },
      {0x3610, "Error processing Notify payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY" },
      {0x3611, "Error processing Delete Payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_DELETE" },
      {0x3612, "Error processing VendorId payload.", "ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR" },
      {0x3613, "Invalid payload received.", "ERROR_IPSEC_IKE_INVALID_PAYLOAD" },
      {0x3614, "Soft SA loaded.", "ERROR_IPSEC_IKE_LOAD_SOFT_SA" },
      {0x3615, "Soft SA torn down.", "ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN" },
      {0x3616, "Invalid cookie received..", "ERROR_IPSEC_IKE_INVALID_COOKIE" },
      {0x3617, "Peer failed to send valid machine certificate.", "ERROR_IPSEC_IKE_NO_PEER_CERT" },
      {0x3618, "Certification Revocation check of peer's certificate failed.", "ERROR_IPSEC_IKE_PEER_CRL_FAILED" },
      {0x3619, "New policy invalidated SAs formed with old policy.", "ERROR_IPSEC_IKE_POLICY_CHANGE" },
      {0x361A, "There is no available Main Mode IKE policy.", "ERROR_IPSEC_IKE_NO_MM_POLICY" },
      {0x361B, "Failed to enabled TCB privilege.", "ERROR_IPSEC_IKE_NOTCBPRIV" },
      {0x361C, "Failed to load SECURITY.DLL.", "ERROR_IPSEC_IKE_SECLOADFAIL" },
      {0x361D, "Failed to obtain security function table dispatch address from SSPI.", "ERROR_IPSEC_IKE_FAILSSPINIT" },
      {0x361E, "Failed to query Kerberos package to obtain max token size.", "ERROR_IPSEC_IKE_FAILQUERYSSP" },
      {0x361F, "Failed to obtain Kerberos server credentials for ISAKMP/ERROR_IPSEC_IKE service. Kerberos authentication will not function. The most likely reason for this is lack of domain membership. This is normal if your computer is a member of a workgroup.", "ERROR_IPSEC_IKE_SRVACQFAIL" },
      {0x3620, "Failed to determine SSPI principal name for ISAKMP/ERROR_IPSEC_IKE service (QueryCredentialsAttributes).", "ERROR_IPSEC_IKE_SRVQUERYCRED" },
      {0x3621, "Failed to obtain new SPI for the inbound SA from IPSec driver. The most common cause for this is that the driver does not have the correct filter. Check your policy to verify the filters.", "ERROR_IPSEC_IKE_GETSPIFAIL" },
      {0x3622, "Given filter is invalid.", "ERROR_IPSEC_IKE_INVALID_FILTER" },
      {0x3623, "Memory allocation failed.", "ERROR_IPSEC_IKE_OUT_OF_MEMORY" },
      {0x3624, "Failed to add Security Association to IPSec Driver. The most common cause for this is if the IKE negotiation took too long to complete. If the problem persists, reduce the load on the faulting machine.", "ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED" },
      {0x3625, "Invalid policy.", "ERROR_IPSEC_IKE_INVALID_POLICY" },
      {0x3626, "Invalid DOI.", "ERROR_IPSEC_IKE_UNKNOWN_DOI" },
      {0x3627, "Invalid situation.", "ERROR_IPSEC_IKE_INVALID_SITUATION" },
      {0x3628, "Diffie-Hellman failure.", "ERROR_IPSEC_IKE_DH_FAILURE" },
      {0x3629, "Invalid Diffie-Hellman group.", "ERROR_IPSEC_IKE_INVALID_GROUP" },
      {0x362A, "Error encrypting payload.", "ERROR_IPSEC_IKE_ENCRYPT" },
      {0x362B, "Error decrypting payload.", "ERROR_IPSEC_IKE_DECRYPT" },
      {0x362C, "Policy match error.", "ERROR_IPSEC_IKE_POLICY_MATCH" },
      {0x362D, "Unsupported ID.", "ERROR_IPSEC_IKE_UNSUPPORTED_ID" },
      {0x362E, "Hash verification failed.", "ERROR_IPSEC_IKE_INVALID_HASH" },
      {0x362F, "Invalid hash algorithm.", "ERROR_IPSEC_IKE_INVALID_HASH_ALG" },
      {0x3630, "Invalid hash size.", "ERROR_IPSEC_IKE_INVALID_HASH_SIZE" },
      {0x3631, "Invalid encryption algorithm.", "ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG" },
      {0x3632, "Invalid authentication algorithm.", "ERROR_IPSEC_IKE_INVALID_AUTH_ALG" },
      {0x3633, "Invalid certificate signature.", "ERROR_IPSEC_IKE_INVALID_SIG" },
      {0x3634, "Load failed.", "ERROR_IPSEC_IKE_LOAD_FAILED" },
      {0x3635, "Deleted via RPC call.", "ERROR_IPSEC_IKE_RPC_DELETE" },
      {0x3636, "Temporary state created to perform reinit. This is not a real failure.", "ERROR_IPSEC_IKE_BENIGN_REINIT" },
      {0x3637, "The lifetime value received in the Responder Lifetime Notify is below the Windows 2000 configured minimum value. Please fix the policy on the peer machine.", "ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY" },
      {0x3639, "Key length in certificate is too small for configured security requirements.", "ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN" },
      {0x363A, "Max number of established MM SAs to peer exceeded.", "ERROR_IPSEC_IKE_MM_LIMIT" },
      {0x363B, "IKE received a policy that disables negotiation.", "ERROR_IPSEC_IKE_NEGOTIATION_DISABLED" },
      {0x363C, "ERROR_IPSEC_IKE_NEG_STATUS_END", "ERROR_IPSEC_IKE_NEG_STATUS_END" },
      {0x36B0, "The requested section was not present in the activation context.", "ERROR_SXS_SECTION_NOT_FOUND" },
      {0x36B1, "This application has failed to start because the application configuration is incorrect. Reinstalling the application may fix this problem.", "ERROR_SXS_CANT_GEN_ACTCTX" },
      {0x36B2, "The application binding data format is invalid.", "ERROR_SXS_INVALID_ACTCTXDATA_FORMAT" },
      {0x36B3, "The referenced assembly is not installed on your system.", "ERROR_SXS_ASSEMBLY_NOT_FOUND" },
      {0x36B4, "The manifest file does not begin with the required tag and format information.", "ERROR_SXS_MANIFEST_FORMAT_ERROR" },
      {0x36B5, "The manifest file contains one or more syntax errors.", "ERROR_SXS_MANIFEST_PARSE_ERROR" },
      {0x36B6, "The application attempted to activate a disabled activation context.", "ERROR_SXS_ACTIVATION_CONTEXT_DISABLED" },
      {0x36B7, "The requested lookup key was not found in any active activation context.", "ERROR_SXS_KEY_NOT_FOUND" },
      {0x36B8, "A component version required by the application conflicts with another component version already active.", "ERROR_SXS_VERSION_CONFLICT" },
      {0x36B9, "The type requested activation context section does not match the query API used.", "ERROR_SXS_WRONG_SECTION_TYPE" },
      {0x36BA, "Lack of system resources has required isolated activation to be disabled for the current thread of execution.", "ERROR_SXS_THREAD_QUERIES_DISABLED" },
      {0x36BB, "An attempt to set the process default activation context failed because the process default activation context was already set.", "ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET" },
      {0x36BC, "The encoding group identifier specified is not recognized.", "ERROR_SXS_UNKNOWN_ENCODING_GROUP" },
      {0x36BD, "The encoding requested is not recognized.", "ERROR_SXS_UNKNOWN_ENCODING" },
      {0x36BE, "The manifest contains a reference to an invalid URI.", "ERROR_SXS_INVALID_XML_NAMESPACE_URI" },
      {0x36BF, "The application manifest contains a reference to a dependent assembly which is not installed.", "ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED" },
      {0x36C0, "The manifest for an assembly used by the application has a reference to a dependent assembly which is not installed.", "ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED" },
      {0x36C1, "The manifest contains an attribute for the assembly identity which is not valid.", "ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE" },
      {0x36C2, "The manifest is missing the required default namespace specification on the assembly element.", "ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE" },
      {0x36C3, "The manifest has a default namespace specified on the assembly element but its value is not \"urn:schemas-microsoft-com:asm.v1\".", "ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE" },
      {0x36C4, "The private manifest probe has crossed the reparse-point-associated path.", "ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT" },
      {0x36C5, "Two or more components referenced directly or indirectly by the application manifest have files by the same name.", "ERROR_SXS_DUPLICATE_DLL_NAME" },
      {0x36C6, "Two or more components referenced directly or indirectly by the application manifest have window classes with the same name.", "ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME" },
      {0x36C7, "Two or more components referenced directly or indirectly by the application manifest have the same COM server CLSIDs.", "ERROR_SXS_DUPLICATE_CLSID" },
      {0x36C8, "Two or more components referenced directly or indirectly by the application manifest have proxies for the same COM interface IIDs.", "ERROR_SXS_DUPLICATE_IID" },
      {0x36C9, "Two or more components referenced directly or indirectly by the application manifest have the same COM type library TLBIDs.", "ERROR_SXS_DUPLICATE_TLBID" },
      {0x36CA, "Two or more components referenced directly or indirectly by the application manifest have the same COM ProgIDs.", "ERROR_SXS_DUPLICATE_PROGID" },
      {0x36CB, "Two or more components referenced directly or indirectly by the application manifest are different versions of the same component which is not permitted.", "ERROR_SXS_DUPLICATE_ASSEMBLY_NAME" },
      {0x36CC, "A component's file does not match the verification information present in the component manifest.", "ERROR_SXS_FILE_HASH_MISMATCH" },
      {0x36CD, "The policy manifest contains one or more syntax errors.", "ERROR_SXS_POLICY_PARSE_ERROR" },
      {0x36CE, "Manifest Parse Error : A string literal was expected, but no opening quote character was found.", "ERROR_SXS_XML_E_MISSINGQUOTE" },
      {0x36CF, "Manifest Parse Error : Incorrect syntax was used in a comment.", "ERROR_SXS_XML_E_COMMENTSYNTAX" },
      {0x36D0, "Manifest Parse Error : A name was started with an invalid character.", "ERROR_SXS_XML_E_BADSTARTNAMECHAR" },
      {0x36D1, "Manifest Parse Error : A name contained an invalid character.", "ERROR_SXS_XML_E_BADNAMECHAR" },
      {0x36D2, "Manifest Parse Error : A string literal contained an invalid character.", "ERROR_SXS_XML_E_BADCHARINSTRING" },
      {0x36D3, "Manifest Parse Error : Invalid syntax for an XML declaration.", "ERROR_SXS_XML_E_XMLDECLSYNTAX" },
      {0x36D4, "Manifest Parse Error : An invalid character was found in text content.", "ERROR_SXS_XML_E_BADCHARDATA" },
      {0x36D5, "Manifest Parse Error : Required white space was missing.", "ERROR_SXS_XML_E_MISSINGWHITESPACE" },
      {0x36D6, "Manifest Parse Error : The character '>' was expected.", "ERROR_SXS_XML_E_EXPECTINGTAGEND" },
      {0x36D7, "Manifest Parse Error : A semi colon character was expected.", "ERROR_SXS_XML_E_MISSINGSEMICOLON" },
      {0x36D8, "Manifest Parse Error : Unbalanced parentheses.", "ERROR_SXS_XML_E_UNBALANCEDPAREN" },
      {0x36D9, "Manifest Parse Error : Internal error.", "ERROR_SXS_XML_E_INTERNALERROR" },
      {0x36DA, "Manifest Parse Error : White space is not allowed at this location.", "ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE" },
      {0x36DB, "Manifest Parse Error : End of file reached in invalid state for current encoding.", "ERROR_SXS_XML_E_INCOMPLETE_ENCODING" },
      {0x36DC, "Manifest Parse Error : Missing parenthesis.", "ERROR_SXS_XML_E_MISSING_PAREN" },
      {0x36DD, "Manifest Parse Error : A single or double closing quote character (\' or \") is missing.", "ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE" },
      {0x36DE, "Manifest Parse Error : Multiple colons are not allowed in a name.", "ERROR_SXS_XML_E_MULTIPLE_COLONS" },
      {0x36DF, "Manifest Parse Error : Invalid character for decimal digit.", "ERROR_SXS_XML_E_INVALID_DECIMAL" },
      {0x36E0, "Manifest Parse Error : Invalid character for hexadecimal digit.", "ERROR_SXS_XML_E_INVALID_HEXIDECIMAL" },
      {0x36E1, "Manifest Parse Error : Invalid Unicode character value for this platform.", "ERROR_SXS_XML_E_INVALID_UNICODE" },
      {0x36E2, "Manifest Parse Error : Expecting white space or '?'.", "ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK" },
      {0x36E3, "Manifest Parse Error : End tag was not expected at this location.", "ERROR_SXS_XML_E_UNEXPECTEDENDTAG" },
      {0x36E4, "Manifest Parse Error : The following tags were not closed: %1.", "ERROR_SXS_XML_E_UNCLOSEDTAG" },
      {0x36E5, "Manifest Parse Error : Duplicate attribute.", "ERROR_SXS_XML_E_DUPLICATEATTRIBUTE" },
      {0x36E6, "Manifest Parse Error : Only one top level element is allowed in an XML document.", "ERROR_SXS_XML_E_MULTIPLEROOTS" },
      {0x36E7, "Manifest Parse Error : Invalid at the top level of the document.", "ERROR_SXS_XML_E_INVALIDATROOTLEVEL" },
      {0x36E8, "Manifest Parse Error : Invalid XML declaration.", "ERROR_SXS_XML_E_BADXMLDECL" },
      {0x36E9, "Manifest Parse Error : XML document must have a top level element.", "ERROR_SXS_XML_E_MISSINGROOT" },
      {0x36EA, "Manifest Parse Error : Unexpected end of file.", "ERROR_SXS_XML_E_UNEXPECTEDEOF" },
      {0x36EB, "Manifest Parse Error : Parameter entities cannot be used inside markup declarations in an internal subset.", "ERROR_SXS_XML_E_BADPEREFINSUBSET" },
      {0x36EC, "Manifest Parse Error : Element was not closed.", "ERROR_SXS_XML_E_UNCLOSEDSTARTTAG" },
      {0x36ED, "Manifest Parse Error : End element was missing the character '>'.", "ERROR_SXS_XML_E_UNCLOSEDENDTAG" },
      {0x36EE, "Manifest Parse Error : A string literal was not closed.", "ERROR_SXS_XML_E_UNCLOSEDSTRING" },
      {0x36EF, "Manifest Parse Error : A comment was not closed.", "ERROR_SXS_XML_E_UNCLOSEDCOMMENT" },
      {0x36F0, "Manifest Parse Error : A declaration was not closed.", "ERROR_SXS_XML_E_UNCLOSEDDECL" },
      {0x36F1, "Manifest Parse Error : A CDATA section was not closed.", "ERROR_SXS_XML_E_UNCLOSEDCDATA" },
      {0x36F2, "Manifest Parse Error : The namespace prefix is not allowed to start with the reserved string \"xml\".", "ERROR_SXS_XML_E_RESERVEDNAMESPACE" },
      {0x36F3, "Manifest Parse Error : System does not support the specified encoding.", "ERROR_SXS_XML_E_INVALIDENCODING" },
      {0x36F4, "Manifest Parse Error : Switch from current encoding to specified encoding not supported.", "ERROR_SXS_XML_E_INVALIDSWITCH" },
      {0x36F5, "Manifest Parse Error : The name 'xml' is reserved and must be lower case.", "ERROR_SXS_XML_E_BADXMLCASE" },
      {0x36F6, "Manifest Parse Error : The standalone attribute must have the value 'yes' or 'no'.", "ERROR_SXS_XML_E_INVALID_STANDALONE" },
      {0x36F7, "Manifest Parse Error : The standalone attribute cannot be used in external entities.", "ERROR_SXS_XML_E_UNEXPECTED_STANDALONE" },
      {0x36F8, "Manifest Parse Error : Invalid version number.", "ERROR_SXS_XML_E_INVALID_VERSION" },
      {0x36F9, "Manifest Parse Error : Missing equals sign between attribute and attribute value.", "ERROR_SXS_XML_E_MISSINGEQUALS" },
      {0x36FA, "Assembly Protection Error: Unable to recover the specified assembly.", "ERROR_SXS_PROTECTION_RECOVERY_FAILED" },
      {0x36FB, "Assembly Protection Error: The public key for an assembly was too short to be allowed.", "ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT" },
      {0x36FC, "Assembly Protection Error: The catalog for an assembly is not valid, or does not match the assembly's manifest.", "ERROR_SXS_PROTECTION_CATALOG_NOT_VALID" },
      {0x36FD, "An HRESULT could not be translated to a corresponding Win32 error code.", "ERROR_SXS_UNTRANSLATABLE_HRESULT" },
      {0x36FE, "Assembly Protection Error: The catalog for an assembly is missing.", "ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING" },
      {0x36FF, "The supplied assembly identity is missing one or more attributes which must be present in this context.", "ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE" },
      {0x3700, "The supplied assembly identity has one or more attribute names that contain characters not permitted in XML names.", "ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME" },
      {0x3701, "The referenced assembly could not be found.", "ERROR_SXS_ASSEMBLY_MISSING" },
      {0x3702, "The activation context activation stack for the running thread of execution is corrupt.", "ERROR_SXS_CORRUPT_ACTIVATION_STACK" },
      {0x3703, "The application isolation metadata for this process or thread has become corrupt.", "ERROR_SXS_CORRUPTION" },
      {0x3704, "The activation context being deactivated is not the most recently activated one.", "ERROR_SXS_EARLY_DEACTIVATION" },
      {0x3705, "The activation context being deactivated is not active for the current thread of execution.", "ERROR_SXS_INVALID_DEACTIVATION" },
      {0x3706, "The activation context being deactivated has already been deactivated.", "ERROR_SXS_MULTIPLE_DEACTIVATION" },
      {0x3707, "A component used by the isolation facility has requested to terminate the process.", "ERROR_SXS_PROCESS_TERMINATION_REQUESTED" },
      {0x3708, "A kernel mode component is releasing a reference on an activation context.", "ERROR_SXS_RELEASE_ACTIVATION_CONTEXT" },
      {0x3709, "The activation context of system default assembly could not be generated.", "ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY" },
      {0x370A, "The value of an attribute in an identity is not within the legal range.", "ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE" },
      {0x370B, "The name of an attribute in an identity is not within the legal range.", "ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME" },
      {0x370C, "An identity contains two definitions for the same attribute.", "ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE" },
      {0x370D, "The identity string is malformed. This may be due to a trailing comma, more than two unnamed attributes, missing attribute name or missing attribute value.", "ERROR_SXS_IDENTITY_PARSE_ERROR" },
      {0x3A98, "The specified channel path is invalid. See extended error info for more details.", "ERROR_EVT_INVALID_CHANNEL_PATH" },
      {0x3A99, "The specified query is invalid. See extended error info for more details.", "ERROR_EVT_INVALID_QUERY" },
      {0x3A9A, "The publisher did indicate they have a manifest/resource but a manifest/resource could not be found.", "ERROR_EVT_PUBLISHER_MANIFEST_NOT_FOUND" },
      {0x3A9B, "The publisher does not have a manifest and is performing an operation which requires they have a manifest.", "ERROR_EVT_PUBLISHER_MANIFEST_NOT_SPECIFIED" },
      {0x3A9C, "There is no registered template for specified event id.", "ERROR_EVT_NO_REGISTERED_TEMPLATE" },
      {0x3A9D, "The specified event was declared in the manifest to go a different channel than the one this publisher handle is bound to.", "ERROR_EVT_EVENT_CHANNEL_MISMATCH" },
      {0x3A9E, "The type of a specified substitution value does not match the type expected from the template definition. ", "ERROR_EVT_UNEXPECTED_VALUE_TYPE" },
      {0x3A9F, "The number of specified substitution values does not match the number expected from the template definition.", "ERROR_EVT_UNEXPECTED_NUM_VALUES" },
      {0x3AA0, "The specified channel could not be found. Check channel configuration.", "ERROR_EVT_CHANNEL_NOT_FOUND" },
      {0x3AA1, "The specified xml text was not well-formed. See Extended Error for more details.", "ERROR_EVT_MALFORMED_XML_TEXT" },
      {0x3AA2, "The specified channel path selects more than one instance of a channel. The operation requires that only one channel be selected. It may be necessary to scope channel path to version / publicKeyToken to select only one instance. ", "ERROR_EVT_CHANNEL_PATH_TOO_GENERAL" },
      {0x3AA3, "The query specified in channel configuration is not allowed to select any channel other than the one the config is associated with. ", "ERROR_EVT_CONFIG_QUERY_NOT_SCOPED_TO_CHANNEL" },
	{0, NULL, NULL},
	};
