
#include "../Wisp/wispbase.hpp"
#include "SyserRing3.hpp"
#include "idtwnd.hpp"
#include "syserconfig.hpp"

	static const WCHAR *DescType[] = 
		{
			WSTR("Reserved"),//0
			WSTR("TSS16   "),//1
			WSTR("LDT     "),//2
			WSTR("TSS32   "),//3
			WSTR("CallG16 "),//4
			WSTR("TaskG   "),//5
			WSTR("IntG16  "),//6
			WSTR("TrapG16 "),//7
			WSTR("Reserved"),//8
			WSTR("TSS32   "),//9
			WSTR("Reserved"),//A
			WSTR("TSS32   "),//B
			WSTR("CallG32 "),//C
			WSTR("Reserved"),//D
			WSTR("IntG32  "),//E-
			WSTR("TrapG32 "),//F
		};

struct _X86_GATE_DECR
{
	unsigned short OffsetLow;
	unsigned short Selector;

	unsigned char DCount :5;
	unsigned char Reserved :3;

	unsigned char Type :4;	//0x8E 1.00.0.1110(0xE,0,0,1), 0xEE 1.11.0.1110(0xE,0,3,1) 0x85 1.00.0.0101(0x5,0,0,1)
	unsigned char DT :1;
	unsigned char DPL :2;
	unsigned char P :1;

	unsigned short OffsetHigh;
};
	_X86_GATE_DECR idtdata[] =
		{
			{0xBC22, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0x3F69, 0x08, 0,0, 0xE,0,3,1, 0xF194},
			{0x3F78, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0x3F87, 0x08, 0,0, 0xE,0,3,1, 0xF194},
			{0xC1E5, 0x08, 0,0, 0xE,0,3,1, 0x804D},
			{0xC326, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0x3F96, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0xCA57, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0x1178, 0x50, 0,0, 0x5,0,0,1, 0},
			{0xCE71, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xCF74, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0x3FA5, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0x3FB4, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0x3FC3, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0x3FD2, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xE04F, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xE16A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0xA0, 0,0, 0x5,0,0,1, 0x804D},
			{0xE2B6, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{     0, 0x08, 0,0,   0,0,0,0, 0},
			{0xB4F6, 0x08, 0,0, 0xE,0,3,1, 0x804D},
			{0xB5E1, 0x08, 0,0, 0xE,0,3,1, 0x804D},
			{0xB744, 0x08, 0,0, 0xE,0,3,1, 0x804D},
			{0x3FF0, 0x08, 0,0, 0xE,0,3,1, 0xF194},
			{0x3FFF, 0x08, 0,0, 0xE,0,3,1, 0xF194},
			{0xDF4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xE4C0, 0x08, 0,0, 0xE,0,0,1, 0x806C},
			{0x400E, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0xA784, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0x401D, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0x402C, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0xF0FC, 0x08, 0,0, 0xE,0,0,1, 0x818E},
			{0xA7AC, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0x404A, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0x8E80, 0x08, 0,0, 0xE,0,0,1, 0x806C},
			{0xC4C4, 0x08, 0,0, 0xE,0,0,1, 0x81B7},
			{0x54CC, 0x08, 0,0, 0xE,0,0,1, 0x81A1},
			{0xE604, 0x08, 0,0, 0xE,0,0,1, 0x818F},
			{0x403B, 0x08, 0,0, 0xE,0,0,1, 0xF194},
			{0xA7F2, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xF6E4, 0x08, 0,0, 0xE,0,0,1, 0x81BC},
			{0xBAA4, 0x08, 0,0, 0xE,0,0,1, 0x81B5},
			{0xA810, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0x3FE1, 0x08, 0,0, 0xE,0,3,1, 0xF194},
			{0xA824, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA82E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA838, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA842, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA84C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA856, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA860, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA86A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA874, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA87E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA888, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA892, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA89C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA8A6, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA8B0, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA8BA, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA8C4, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA8CE, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA8D8, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA8E2, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA8EC, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA8F6, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA900, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA90A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA914, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA91E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA928, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA932, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA93C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA946, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA950, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA95A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA964, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA96E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA978, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA982, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA98C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA996, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9A0, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9AA, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9B4, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9BE, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9C8, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9D2, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9DC, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9E6, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9F0, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xA9FA, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA04, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA0E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA18, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA22, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA2C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA36, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA40, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA4A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA54, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA5E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA68, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA72, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA7C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA86, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA90, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAA9A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAAA4, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAAAE, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAAB8, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAAC2, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAACC, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAAD6, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAAE0, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAAEA, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAAF4, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAAFE, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB08, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB12, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB1C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB26, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB30, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB3A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB44, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB4E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB58, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB62, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB6C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB76, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB80, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB8A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB94, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAB9E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xABA8, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xABB2, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xABBC, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xABC6, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xABD0, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xABDA, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xABE4, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xABEE, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xABF8, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC02, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC0C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC16, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC20, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC2A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC34, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC3E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC48, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC52, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC5C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC66, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC70, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC7A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC84, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC8E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAC98, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACA2, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACAC, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACB6, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACC0, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACCA, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACD4, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACDE, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACE8, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACF2, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xACFC, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD06, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD10, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD1A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD24, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD2E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD38, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD42, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD4C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD56, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD60, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD6A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD74, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD7E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD88, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD92, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAD9C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xADA6, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xADB0, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xADBA, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xADC4, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xADCE, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xADD8, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xADE2, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xADEC, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xADF6, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE00, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE0A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE14, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE1E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE28, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE32, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE3C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE46, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE50, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE5A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE64, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE6E, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE78, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE82, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE8C, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAE96, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEA0, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEAA, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEB4, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEBE, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEC8, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAED2, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAED9, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEE0, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEE7, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEEE, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEF5, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAEFC, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF03, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF0A, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF11, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF18, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF1F, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF26, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF2D, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF34, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF3B, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF42, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF49, 0x08, 0,0, 0xE,0,0,1, 0x804D},
			{0xAF50, 0x08, 0,0, 0xE,0,0,1, 0x804D},
		};

        WISP_MSG_MAP_BEGIN(CIDTWnd)
                WISP_MSG_MAP(WISP_WM_CREATE, OnCreate)
                WISP_MSG_MAP(WISP_WM_CLOSE, OnClose)
        WISP_MSG_MAP_END(CWispList)

	CIDTWnd::CIDTWnd()
	{
		m_dwBeginIndex = 0;
	#if 0
		//m_pIDTAddress = GetIDTBase(&m_dwIDTSize);
	#else
		m_pIDTAddress = idtdata;
		m_dwIDTSize = sizeof(idtdata)-1;//2047; //256
	#endif
	}
	CIDTWnd::~CIDTWnd()
	{
	}

        bool CIDTWnd::OnCreate(WISP_MSG *pMsg)
	{
		m_ItemColor = gSyserColors.Color[1];
		m_crBGColor = gSyserColors.Color[0];
		m_bBGColor = 1;

		InsertColumn(WSTR("Int"), 40, 0, 0, -1);
		InsertColumn(WSTR("Type"), 80, 0, 0, -1);
		InsertColumn(WSTR("Sel:Offset"), 90, 0, 0, -1);
		InsertColumn(WSTR("Attributes"), 100, 0, 0, -1);
		InsertColumn(WSTR("Symbol/Owner"), 90, 0, 0, -1);

		SetWindowText(WSTR("IDT TABLE"));
		InitContext();
		return true;
	}
        bool CIDTWnd::OnClose(WISP_MSG *pMsg)
	{
		gpSyser->m_MainFrame.FocusActive();
		return true;
	}

	bool CIDTWnd::InsertIDT()
	{
		void *dwIDTBase = m_pIDTAddress;
		unsigned long dwIDTSize = (m_dwIDTSize+1)/8;

		WCHAR display[64];

		_X86_GATE_DECR *pGateDesc = (_X86_GATE_DECR *)dwIDTBase;

		for (unsigned long i = 0; i < dwIDTSize; ++i)
		{
			unsigned long dwSelector = pGateDesc->Selector;
			TSPrintf(display, WSTR("%02X"), i);
			CListStringItem *pItem = InsertItem(display, 0, 0, 0, -1);
			SetItemText(pItem, 1, DescType[pGateDesc->Type]);
			unsigned long dwOffset = (pGateDesc->OffsetHigh << 16) | pGateDesc->OffsetLow;

		#ifdef _RING_0_
			if (gOldInterruptProcAddress[i])
			{
				if (dwOffset > gpSyser->m_pDriverObject->DriverStart &&
				    dwOffset < gpSyser->m_pDriverObject->DriverStart+gpSyser->m_pDriverObject->DriverSize)
					dwOffset = gOldInterruptProcAddress[i];
			}
		#endif

			SetItemText(pItem, 2, DescType[pGateDesc->Type]);
			TSPrintf(display, WSTR("%04X:%08X"), dwSelector, dwOffset);
			SetItemText(pItem, 2, display);

			TSPrintf(display, WSTR("DPL=%d %s"), pGateDesc->DPL, pGateDesc->P ? WSTR("P"):WSTR("NP"));
			SetItemText(pItem, 3, display);
			++pGateDesc;
		}

		return true;
	}

	void CIDTWnd::InitContext()
	{
		DeleteAllChildrenItems(0);
		InsertIDT();
	}

	void CIDTWnd::Create()
	{
		if (IsWindow())
		{
			Destroy();
		} else
		{
			WISP_RECT Rect;
			Rect.x = 0;
			Rect.y = 0;
			Rect.cx = 540;
			Rect.cy = 350;
			CreateWnd(WSTR("IDT"), Rect, 0, 0, 0x100BB, WISP_SH_MINSIZE);
			Center(0);
		}
	}
