
#include "../Wisp/wispbase.hpp"
#include "SyserRing3.hpp"
#include "gdtwnd.hpp"
#include "syserconfig.hpp"

	static const WCHAR *DescType[] =
	        {
	                WSTR("Reserved"),//0
	                WSTR("TSS16   "),//1
	                WSTR("LDT     "),//2
	                WSTR("TSS32   "),//3
	                WSTR("CallG16 "),//4
	                WSTR("TaskG   "),//5
	                WSTR("IntG16  "),//6
	                WSTR("TrapG16 "),//7
	                WSTR("Reserved"),//8
	                WSTR("TSS32   "),//9
	                WSTR("Reserved"),//A
	                WSTR("TSS32   "),//B
	                WSTR("CallG32 "),//C
	                WSTR("Reserved"),//D
	                WSTR("IntG32  "),//E-
	                WSTR("TrapG32 "),//F
	        };

struct _X86_SEGMENT_DESCRIPTOR
{
	unsigned long limit_L0 :8;
	unsigned long limit_L1 :8;
	unsigned long base_L0 :8;
	unsigned long base_L1 :8;

	unsigned long base_H0 :8;	/* 0 */

	unsigned long TYPE :4;		/* 8 */
	unsigned long DT :1;		/* 12 */
	unsigned long DPL :2;		/* 13 */
	unsigned long P :1;		/* 15 */

	unsigned long limit_H :4;	/* 16 */
	unsigned long AVL :1;		/* 20 */
	unsigned long reseved :1;	/* 21 */
	unsigned long D :1;		/* 22 */
	unsigned long G :1;		/* 23 */

	unsigned long base_H1 :8;	/* 24 */

};

	_X86_SEGMENT_DESCRIPTOR gdtdata[] =
		{
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xff,0xff,0x00,0x00,0x00,  0x0b,0x01,0x00,0x01,  0x0f,0x00,0x00,0x01,0x01,  0x00},
      {0xff,0xff,0x00,0x00,0x00,  0x03,0x01,0x00,0x01,  0x0f,0x00,0x00,0x01,0x01,  0x00},
      {0xff,0xff,0x00,0x00,0x00,  0x0b,0x01,0x03,0x01,  0x0f,0x00,0x00,0x01,0x01,  0x00},
      {0xff,0xff,0x00,0x00,0x00,  0x03,0x01,0x03,0x01,  0x0f,0x00,0x00,0x01,0x01,  0x00},
      {0xab,0x20,0x00,0x20,0x04,  0x0b,0x00,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x80},
      {0x01,0x00,0x00,0xf0,0xdf,  0x03,0x01,0x00,0x01,  0x00,0x00,0x00,0x01,0x01,  0xff},
      {0xff,0x0f,0x00,0x00,0x00,  0x03,0x01,0x03,0x01,  0x00,0x00,0x00,0x01,0x00,  0x00},
      {0xff,0xff,0x00,0x04,0x00,  0x02,0x01,0x03,0x01,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x68,0x00,0x00,0x32,0x54,  0x09,0x00,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x80},
      {0x68,0x00,0x68,0x32,0x54,  0x09,0x00,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x80},
      {0xff,0xff,0x20,0x2f,0x02,  0x03,0x01,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xff,0x3f,0x00,0x80,0x0b,  0x02,0x01,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xff,0x03,0x00,0x70,0xff,  0x02,0x01,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0xff},
      {0xff,0xff,0x00,0x00,0x40,  0x0a,0x01,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x80},
      {0xff,0xff,0x00,0x00,0x40,  0x02,0x01,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x80},
      {0x00,0x00,0x00,0x00,0x00,  0x02,0x01,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x68,0x00,0xb8,0xeb,0xbd,  0x09,0x00,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x81},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xff,0xff,0x00,0x20,0xa9,  0x0f,0x01,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0xf9},
      {0xff,0xff,0x00,0x00,0x00,  0x02,0x01,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xce,0x25,0xd0,0x31,0x50,  0x08,0x01,0x00,0x01,  0x0f,0x00,0x00,0x00,0x00,  0x80},
      {0xff,0xff,0x00,0x00,0x00,  0x02,0x01,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xff,0xff,0x00,0x20,0xaa,  0x03,0x01,0x00,0x01,  0x00,0x00,0x00,0x01,0x00,  0xf9},
      {0xff,0xff,0x00,0x20,0xaa,  0x03,0x01,0x00,0x01,  0x00,0x00,0x00,0x01,0x00,  0xf9},
      {0xff,0xff,0x00,0x20,0xaa,  0x03,0x01,0x00,0x01,  0x00,0x00,0x00,0x01,0x00,  0xf9},
      {0x20,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x28,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x30,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x38,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x40,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x48,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x50,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x58,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x60,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x68,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x70,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x78,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x80,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x88,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x90,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x98,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xa0,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xa8,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xb0,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xb8,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xc0,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xc8,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xd0,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xd8,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xe0,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xe8,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xf0,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xf8,0xf1,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x08,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x10,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x18,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x20,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x28,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x30,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x38,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x40,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x48,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x50,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x58,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x60,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x68,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x70,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x78,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x80,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x88,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x90,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x98,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xa0,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xa8,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xb0,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xb8,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xc0,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xc8,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xd0,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xd8,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xe0,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xe8,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xf0,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xf8,0xf2,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x08,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x10,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x18,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x20,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x28,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x30,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x38,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x40,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x48,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x50,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x58,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x60,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x68,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x70,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x78,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x80,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x88,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x90,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x98,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xa0,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xa8,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xb0,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xb8,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xc0,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xc8,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xd0,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xd8,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xe0,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xe8,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xf0,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xf8,0xf3,0x03,0x80,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x22,0xbc,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x69,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x03,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x78,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x87,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x03,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0xe5,0xc1,0x08,0x00,0x00,  0x0e,0x00,0x03,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x26,0xc3,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x96,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x57,0xca,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x78,0x11,0x50,0x00,0x00,  0x05,0x00,0x00,0x01,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x71,0xce,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x74,0xcf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xa5,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0xb4,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0xc3,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0xd2,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4f,0xe0,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x6a,0xe1,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0xa0,0x00,0x00,  0x05,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xb6,0xe2,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0x00,0x00,0x08,0x00,0x00,  0x00,0x00,0x00,0x00,  0x00,0x00,0x00,0x00,0x00,  0x00},
      {0xf6,0xb4,0x08,0x00,0x00,  0x0e,0x00,0x03,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xe1,0xb5,0x08,0x00,0x00,  0x0e,0x00,0x03,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x44,0xb7,0x08,0x00,0x00,  0x0e,0x00,0x03,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xf0,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x03,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0xff,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x03,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x4c,0xdf,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xc0,0xe4,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0c,0x00,0x01,0x01,0x00,  0x80},
      {0x0e,0xb0,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x84,0xa7,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x1d,0xb0,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x2c,0xb0,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x9c,0x15,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x02,0x00,0x01,0x00,0x01,  0x81},
      {0xac,0xa7,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4a,0xb0,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x80,0x8e,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0c,0x00,0x01,0x01,0x00,  0x80},
      {0x6c,0x52,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0c,0x01,0x01,0x00,0x01,  0x81},
      {0xd4,0xed,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x00,0x00,0x01,  0x81},
      {0xf4,0xf2,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0e,0x01,0x00,0x00,0x01,  0x81},
      {0x3b,0xb0,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0xf2,0xa7,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xe4,0x66,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0b,0x01,0x01,0x00,0x01,  0x81},
      {0x2c,0x1b,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x07,0x01,0x01,0x00,0x01,  0x81},
      {0x10,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xe1,0xaf,0x08,0x00,0x00,  0x0e,0x00,0x03,0x01,  0x00,0x01,0x01,0x01,0x01,  0xf1},
      {0x24,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x2e,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x38,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x42,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4c,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x56,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x60,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x6a,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x74,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x7e,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x88,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x92,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x9c,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xa6,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xb0,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xba,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xc4,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xce,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xd8,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xe2,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xec,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xf6,0xa8,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x00,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x0a,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x14,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x1e,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x28,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x32,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x3c,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x46,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x50,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x5a,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x64,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x6e,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x78,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x82,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x8c,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x96,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xa0,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xaa,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xb4,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xbe,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xc8,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xd2,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xdc,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xe6,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xf0,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0xfa,0xa9,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x04,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x0e,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x18,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x22,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x2c,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x36,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x40,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x4a,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x54,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x5e,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x68,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x72,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x7c,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
      {0x86,0xaa,0x08,0x00,0x00,  0x0e,0x00,0x00,0x01,  0x0d,0x00,0x00,0x01,0x00,  0x80},
		};

        WISP_MSG_MAP_BEGIN(CGDTWnd)
                WISP_MSG_MAP(WISP_WM_CREATE, OnCreate)
                WISP_MSG_MAP(WISP_WM_CLOSE, OnClose)
        WISP_MSG_MAP_END(CWispList)

	CGDTWnd::CGDTWnd()
	{
		m_dwBeginIndex = 0;
	#if 0
		//m_pGDTAddress = GetGDTBase(&m_dwGDTSize);
	#else
		m_pGDTAddress = gdtdata;
		m_dwGDTSize = sizeof(gdtdata)-1;//2047; //256		
	#endif
	}
	CGDTWnd::~CGDTWnd()
	{
	}

        bool CGDTWnd::OnCreate(WISP_MSG *pMsg)
	{
		m_ItemColor = gSyserColors.Color[1];
		m_crBGColor = gSyserColors.Color[0];
		m_bBGColor = 1;

		InsertColumn(WSTR("Selector"), 40, 0, 0, -1);
		InsertColumn(WSTR("Type"), 80, 0, 0, -1);
		InsertColumn(WSTR("Base"), 90, 0, 0, -1);
		InsertColumn(WSTR("Limit"), 100, 0, 0, -1);
		InsertColumn(WSTR("DPL"), 90, 0, 0, -1);
		InsertColumn(WSTR("Attributes"), 90, 0, 0, -1);

		SetWindowText(WSTR("GDT TABLE"));
		InitContext();
		return true;
	}
        bool CGDTWnd::OnClose(WISP_MSG *pMsg)
	{
		gpSyser->m_MainFrame.FocusActive();
		return true;
	}

	bool CGDTWnd::InsertGDT()
	{
		void *dwGDTBase = m_pGDTAddress;
		unsigned long dwGDTSize = (m_dwGDTSize+1)/8;

		WCHAR display[64];

		_X86_SEGMENT_DESCRIPTOR *pSegDesc = (_X86_SEGMENT_DESCRIPTOR *)dwGDTBase;
		unsigned long dwShowSelector = (unsigned long)pSegDesc;

		for (unsigned long i = 0; i < dwGDTSize; ++i)
		{
			unsigned long dwSegmentBase = (pSegDesc->base_H1<<24) | (pSegDesc->base_H0<<16) | (pSegDesc->base_L1<<8) | (pSegDesc->base_L0);
			unsigned long dwSegmentLimit = (pSegDesc->limit_H<<16) | (pSegDesc->limit_L1<<8) | (pSegDesc->limit_L0);

			unsigned long dwSelector = (unsigned long)pSegDesc;
			dwSelector = (dwSelector-dwShowSelector) | pSegDesc->DPL;

			if (pSegDesc->P)
			{
				if (pSegDesc->DT)
				{
					if (pSegDesc->G)
						dwSegmentLimit = (dwSegmentLimit<<12) | 0xFFFF;


					TSPrintf(display, WSTR("%04X"), dwSelector);

					CListStringItem *pItem = InsertItem(display, 0, 0, 0, -1);
					unsigned long CD = pSegDesc->TYPE;
					if (CD&0x8)
						SetItemText(pItem, 1, pSegDesc->D?WSTR("Code32  "):WSTR("Code16  "));
					else	SetItemText(pItem, 1, pSegDesc->D?WSTR("Data32  "):WSTR("Data16  "));

					TSPrintf(display, WSTR("%08X"), dwSegmentBase);
					SetItemText(pItem, 2, display);

					TSPrintf(display, WSTR("%08X"), dwSegmentLimit);
					SetItemText(pItem, 3, display);

					TSPrintf(display, WSTR("%d"), pSegDesc->DPL);
					SetItemText(pItem, 4, display);

					unsigned long TYPE = pSegDesc->TYPE;
					if (TYPE&0x8)
						TSPrintf(display, WSTR("P  %s %s"), (TYPE&2)?WSTR("RE"):WSTR("EO"), (TYPE&4)?WSTR("C "):WSTR(" "));
					else	TSPrintf(display, WSTR("P  %s %s"), (TYPE&2)?WSTR("RW"):WSTR("RO"), (TYPE&4)?WSTR("ED"):WSTR(" "));
					SetItemText(pItem, 5, display);
				}
			} else
			{
				TSPrintf(display, WSTR("%04X"), dwSelector);
				CListStringItem *pItem = InsertItem(display, 0, 0, 0, -1);
				SetItemText(pItem, 1, DescType[pSegDesc->TYPE]);
				TSPrintf(display, WSTR("%08X"), dwSegmentBase);
				SetItemText(pItem, 2, display);
				TSPrintf(display, WSTR("%08X"), dwSegmentLimit);
				SetItemText(pItem, 3, display);
				TSPrintf(display, WSTR("%d"), pSegDesc->DPL);
				SetItemText(pItem, 4, display);
				SetItemText(pItem, 5, WSTR("NP      "));
			}
			++pSegDesc;
		}

		return true;
	}

	void CGDTWnd::InitContext()
	{
		DeleteAllChildrenItems(0);
		InsertGDT();
	}

	void CGDTWnd::Create()
	{
		if (IsWindow())
		{
			Destroy();
		} else
		{
			WISP_RECT Rect;
			Rect.x = 0;
			Rect.y = 0;
			Rect.cx = 540;
			Rect.cy = 350;
			CreateWnd(WSTR("GDT"), Rect, 0, 0, 0x100BB, WISP_SH_MINSIZE);
			Center(0);
		}
	}
