/**
 * vis.js
 * https://github.com/almende/vis
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 4.20.1
 * @date    2017-07-02
 *
 * @license
 * Copyright (C) 2011-2017 Almende B.V, http://almende.com
 *
 * Vis.js is dual licensed under both
 *
 * * The Apache 2.0 License
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * and
 *
 * * The MIT License
 *   http://opensource.org/licenses/MIT
 *
 * Vis.js may be distributed under either license.
 */
"use strict";!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.vis=t():e.vis=t()}(this,function(){return function(e){function t(o){if(i[o])return i[o].exports;var n=i[o]={exports:{},id:o,loaded:!1};return e[o].call(n.exports,n,n.exports,t),n.loaded=!0,n.exports}var i={};return t.m=e,t.c=i,t.p="",t(0)}([function(e,t,i){t.util=i(1),t.DOMutil=i(87),t.DataSet=i(88),t.DataView=i(92),t.Queue=i(91),t.Network=i(93),t.network={Images:i(104),dotparser:i(96),gephiParser:i(97),allOptions:i(179)},t.network.convertDot=function(e){return t.network.dotparser.DOTToGraph(e)},t.network.convertGephi=function(e,i){return t.network.gephiParser.parseGephi(e,i)},t.moment=i(82),t.Hammer=i(100),t.keycharm=i(99)},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}var n=i(2),s=o(n),r=i(55),a=o(r),d=i(58),h=o(d),l=i(62),u=o(l),c=i(82),f=i(86);t.isNumber=function(e){return e instanceof Number||"number"==typeof e},t.recursiveDOMDelete=function(e){if(e)for(;e.hasChildNodes()===!0;)t.recursiveDOMDelete(e.firstChild),e.removeChild(e.firstChild)},t.giveRange=function(e,t,i,o){if(t==e)return.5;var n=1/(t-e);return Math.max(0,(o-e)*n)},t.isString=function(e){return e instanceof String||"string"==typeof e},t.isDate=function(e){if(e instanceof Date)return!0;if(t.isString(e)){var i=p.exec(e);if(i)return!0;if(!isNaN(Date.parse(e)))return!0}return!1},t.randomUUID=function(){return f.v4()},t.assignAllKeys=function(e,t){for(var i in e)e.hasOwnProperty(i)&&"object"!==(0,u.default)(e[i])&&(e[i]=t)},t.fillIfDefined=function(e,i){var o=arguments.length>2&&void 0!==arguments[2]&&arguments[2];for(var n in e)void 0!==i[n]&&("object"!==(0,u.default)(i[n])?void 0!==i[n]&&null!==i[n]||void 0===e[n]||o!==!0?e[n]=i[n]:delete e[n]:"object"===(0,u.default)(e[n])&&t.fillIfDefined(e[n],i[n],o))},t.protoExtend=function(e,t){for(var i=1;i<arguments.length;i++){var o=arguments[i];for(var n in o)e[n]=o[n]}return e},t.extend=function(e,t){for(var i=1;i<arguments.length;i++){var o=arguments[i];for(var n in o)o.hasOwnProperty(n)&&(e[n]=o[n])}return e},t.selectiveExtend=function(e,t,i){if(!Array.isArray(e))throw new Error("Array with property names expected as first argument");for(var o=2;o<arguments.length;o++)for(var n=arguments[o],s=0;s<e.length;s++){var r=e[s];n&&n.hasOwnProperty(r)&&(t[r]=n[r])}return t},t.selectiveDeepExtend=function(e,i,o){var n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Array.isArray(o))throw new TypeError("Arrays are not supported by deepExtend");for(var s=2;s<arguments.length;s++)for(var r=arguments[s],a=0;a<e.length;a++){var d=e[a];if(r.hasOwnProperty(d))if(o[d]&&o[d].constructor===Object)void 0===i[d]&&(i[d]={}),i[d].constructor===Object?t.deepExtend(i[d],o[d],!1,n):null===o[d]&&void 0!==i[d]&&n===!0?delete i[d]:i[d]=o[d];else{if(Array.isArray(o[d]))throw new TypeError("Arrays are not supported by deepExtend");null===o[d]&&void 0!==i[d]&&n===!0?delete i[d]:i[d]=o[d]}}return i},t.selectiveNotDeepExtend=function(e,i,o){var n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Array.isArray(o))throw new TypeError("Arrays are not supported by deepExtend");for(var s in o)if(o.hasOwnProperty(s)&&e.indexOf(s)==-1)if(o[s]&&o[s].constructor===Object)void 0===i[s]&&(i[s]={}),i[s].constructor===Object?t.deepExtend(i[s],o[s]):null===o[s]&&void 0!==i[s]&&n===!0?delete i[s]:i[s]=o[s];else if(Array.isArray(o[s])){i[s]=[];for(var r=0;r<o[s].length;r++)i[s].push(o[s][r])}else null===o[s]&&void 0!==i[s]&&n===!0?delete i[s]:i[s]=o[s];return i},t.deepExtend=function(e,i,o,n){for(var s in i)if(i.hasOwnProperty(s)||o===!0)if(i[s]&&i[s].constructor===Object)void 0===e[s]&&(e[s]={}),e[s].constructor===Object?t.deepExtend(e[s],i[s],o):null===i[s]&&void 0!==e[s]&&n===!0?delete e[s]:e[s]=i[s];else if(Array.isArray(i[s])){e[s]=[];for(var r=0;r<i[s].length;r++)e[s].push(i[s][r])}else null===i[s]&&void 0!==e[s]&&n===!0?delete e[s]:e[s]=i[s];return e},t.equalArray=function(e,t){if(e.length!=t.length)return!1;for(var i=0,o=e.length;i<o;i++)if(e[i]!=t[i])return!1;return!0},t.convert=function(e,i){var o;if(void 0!==e){if(null===e)return null;if(!i)return e;if("string"!=typeof i&&!(i instanceof String))throw new Error("Type must be a string");switch(i){case"boolean":case"Boolean":return Boolean(e);case"number":case"Number":return t.isString(e)&&!isNaN(Date.parse(e))?c(e).valueOf():Number(e.valueOf());case"string":case"String":return String(e);case"Date":if(t.isNumber(e))return new Date(e);if(e instanceof Date)return new Date(e.valueOf());if(c.isMoment(e))return new Date(e.valueOf());if(t.isString(e))return o=p.exec(e),o?new Date(Number(o[1])):c(new Date(e)).toDate();throw new Error("Cannot convert object of type "+t.getType(e)+" to type Date");case"Moment":if(t.isNumber(e))return c(e);if(e instanceof Date)return c(e.valueOf());if(c.isMoment(e))return c(e);if(t.isString(e))return o=p.exec(e),c(o?Number(o[1]):e);throw new Error("Cannot convert object of type "+t.getType(e)+" to type Date");case"ISODate":if(t.isNumber(e))return new Date(e);if(e instanceof Date)return e.toISOString();if(c.isMoment(e))return e.toDate().toISOString();if(t.isString(e))return o=p.exec(e),o?new Date(Number(o[1])).toISOString():c(e).format();throw new Error("Cannot convert object of type "+t.getType(e)+" to type ISODate");case"ASPDate":if(t.isNumber(e))return"/Date("+e+")/";if(e instanceof Date)return"/Date("+e.valueOf()+")/";if(t.isString(e)){o=p.exec(e);var n;return n=o?new Date(Number(o[1])).valueOf():new Date(e).valueOf(),"/Date("+n+")/"}throw new Error("Cannot convert object of type "+t.getType(e)+" to type ASPDate");default:throw new Error('Unknown type "'+i+'"')}}};var p=/^\/?Date\((\-?\d+)/i;t.getType=function(e){var t="undefined"==typeof e?"undefined":(0,u.default)(e);return"object"==t?null===e?"null":e instanceof Boolean?"Boolean":e instanceof Number?"Number":e instanceof String?"String":Array.isArray(e)?"Array":e instanceof Date?"Date":"Object":"number"==t?"Number":"boolean"==t?"Boolean":"string"==t?"String":void 0===t?"undefined":t},t.copyAndExtendArray=function(e,t){for(var i=[],o=0;o<e.length;o++)i.push(e[o]);return i.push(t),i},t.copyArray=function(e){for(var t=[],i=0;i<e.length;i++)t.push(e[i]);return t},t.getAbsoluteLeft=function(e){return e.getBoundingClientRect().left},t.getAbsoluteRight=function(e){return e.getBoundingClientRect().right},t.getAbsoluteTop=function(e){return e.getBoundingClientRect().top},t.addClassName=function(e,t){var i=e.className.split(" "),o=t.split(" ");i=i.concat(o.filter(function(e){return i.indexOf(e)<0})),e.className=i.join(" ")},t.removeClassName=function(e,t){var i=e.className.split(" "),o=t.split(" ");i=i.filter(function(e){return o.indexOf(e)<0}),e.className=i.join(" ")},t.forEach=function(e,t){var i,o;if(Array.isArray(e))for(i=0,o=e.length;i<o;i++)t(e[i],i,e);else for(i in e)e.hasOwnProperty(i)&&t(e[i],i,e)},t.toArray=function(e){var t=[];for(var i in e)e.hasOwnProperty(i)&&t.push(e[i]);return t},t.updateProperty=function(e,t,i){return e[t]!==i&&(e[t]=i,!0)},t.throttle=function(e){var t=!1;return function(){t||(t=!0,requestAnimationFrame(function(){t=!1,e()}))}},t.addEventListener=function(e,t,i,o){e.addEventListener?(void 0===o&&(o=!1),"mousewheel"===t&&navigator.userAgent.indexOf("Firefox")>=0&&(t="DOMMouseScroll"),e.addEventListener(t,i,o)):e.attachEvent("on"+t,i)},t.removeEventListener=function(e,t,i,o){e.removeEventListener?(void 0===o&&(o=!1),"mousewheel"===t&&navigator.userAgent.indexOf("Firefox")>=0&&(t="DOMMouseScroll"),e.removeEventListener(t,i,o)):e.detachEvent("on"+t,i)},t.preventDefault=function(e){e||(e=window.event),e.preventDefault?e.preventDefault():e.returnValue=!1},t.getTarget=function(e){e||(e=window.event);var t;return e.target?t=e.target:e.srcElement&&(t=e.srcElement),void 0!=t.nodeType&&3==t.nodeType&&(t=t.parentNode),t},t.hasParent=function(e,t){for(var i=e;i;){if(i===t)return!0;i=i.parentNode}return!1},t.option={},t.option.asBoolean=function(e,t){return"function"==typeof e&&(e=e()),null!=e?0!=e:t||null},t.option.asNumber=function(e,t){return"function"==typeof e&&(e=e()),null!=e?Number(e)||t||null:t||null},t.option.asString=function(e,t){return"function"==typeof e&&(e=e()),null!=e?String(e):t||null},t.option.asSize=function(e,i){return"function"==typeof e&&(e=e()),t.isString(e)?e:t.isNumber(e)?e+"px":i||null},t.option.asElement=function(e,t){return"function"==typeof e&&(e=e()),e||t||null},t.hexToRGB=function(e){var t=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;e=e.replace(t,function(e,t,i,o){return t+t+i+i+o+o});var i=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(e);return i?{r:parseInt(i[1],16),g:parseInt(i[2],16),b:parseInt(i[3],16)}:null},t.overrideOpacity=function(e,i){if(e.indexOf("rgba")!=-1)return e;if(e.indexOf("rgb")!=-1){var o=e.substr(e.indexOf("(")+1).replace(")","").split(",");return"rgba("+o[0]+","+o[1]+","+o[2]+","+i+")"}var o=t.hexToRGB(e);return null==o?e:"rgba("+o.r+","+o.g+","+o.b+","+i+")"},t.RGBToHex=function(e,t,i){return"#"+((1<<24)+(e<<16)+(t<<8)+i).toString(16).slice(1)},t.parseColor=function(e){var i;if(t.isString(e)===!0){if(t.isValidRGB(e)===!0){var o=e.substr(4).substr(0,e.length-5).split(",").map(function(e){return parseInt(e)});e=t.RGBToHex(o[0],o[1],o[2])}if(t.isValidHex(e)===!0){var n=t.hexToHSV(e),s={h:n.h,s:.8*n.s,v:Math.min(1,1.02*n.v)},r={h:n.h,s:Math.min(1,1.25*n.s),v:.8*n.v},a=t.HSVToHex(r.h,r.s,r.v),d=t.HSVToHex(s.h,s.s,s.v);i={background:e,border:a,highlight:{background:d,border:a},hover:{background:d,border:a}}}else i={background:e,border:e,highlight:{background:e,border:e},hover:{background:e,border:e}}}else i={},i.background=e.background||void 0,i.border=e.border||void 0,t.isString(e.highlight)?i.highlight={border:e.highlight,background:e.highlight}:(i.highlight={},i.highlight.background=e.highlight&&e.highlight.background||void 0,i.highlight.border=e.highlight&&e.highlight.border||void 0),t.isString(e.hover)?i.hover={border:e.hover,background:e.hover}:(i.hover={},i.hover.background=e.hover&&e.hover.background||void 0,i.hover.border=e.hover&&e.hover.border||void 0);return i},t.RGBToHSV=function(e,t,i){e/=255,t/=255,i/=255;var o=Math.min(e,Math.min(t,i)),n=Math.max(e,Math.max(t,i));if(o==n)return{h:0,s:0,v:o};var s=e==o?t-i:i==o?e-t:i-e,r=e==o?3:i==o?1:5,a=60*(r-s/(n-o))/360,d=(n-o)/n,h=n;return{h:a,s:d,v:h}};var v={split:function(e){var t={};return e.split(";").forEach(function(e){if(""!=e.trim()){var i=e.split(":"),o=i[0].trim(),n=i[1].trim();t[o]=n}}),t},join:function(e){return(0,h.default)(e).map(function(t){return t+": "+e[t]}).join("; ")}};t.addCssText=function(e,i){var o=v.split(e.style.cssText),n=v.split(i),s=t.extend(o,n);e.style.cssText=v.join(s)},t.removeCssText=function(e,t){var i=v.split(e.style.cssText),o=v.split(t);for(var n in o)o.hasOwnProperty(n)&&delete i[n];e.style.cssText=v.join(i)},t.HSVToRGB=function(e,t,i){var o,n,s,r=Math.floor(6*e),a=6*e-r,d=i*(1-t),h=i*(1-a*t),l=i*(1-(1-a)*t);switch(r%6){case 0:o=i,n=l,s=d;break;case 1:o=h,n=i,s=d;break;case 2:o=d,n=i,s=l;break;case 3:o=d,n=h,s=i;break;case 4:o=l,n=d,s=i;break;case 5:o=i,n=d,s=h}return{r:Math.floor(255*o),g:Math.floor(255*n),b:Math.floor(255*s)}},t.HSVToHex=function(e,i,o){var n=t.HSVToRGB(e,i,o);return t.RGBToHex(n.r,n.g,n.b)},t.hexToHSV=function(e){var i=t.hexToRGB(e);return t.RGBToHSV(i.r,i.g,i.b)},t.isValidHex=function(e){var t=/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(e);return t},t.isValidRGB=function(e){e=e.replace(" ","");var t=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/i.test(e);return t},t.isValidRGBA=function(e){e=e.replace(" ","");var t=/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),(.{1,3})\)/i.test(e);return t},t.selectiveBridgeObject=function(e,i){if("object"==("undefined"==typeof i?"undefined":(0,u.default)(i))){for(var o=(0,a.default)(i),n=0;n<e.length;n++)i.hasOwnProperty(e[n])&&"object"==(0,u.default)(i[e[n]])&&(o[e[n]]=t.bridgeObject(i[e[n]]));return o}return null},t.bridgeObject=function(e){if("object"==("undefined"==typeof e?"undefined":(0,u.default)(e))){var i=(0,a.default)(e);for(var o in e)e.hasOwnProperty(o)&&"object"==(0,u.default)(e[o])&&(i[o]=t.bridgeObject(e[o]));return i}return null},t.insertSort=function(e,t){for(var i=0;i<e.length;i++){for(var o=e[i],n=i;n>0&&t(o,e[n-1])<0;n--)e[n]=e[n-1];e[n]=o}return e},t.mergeOptions=function(e,t,i){var o=(arguments.length>3&&void 0!==arguments[3]&&arguments[3],arguments.length>4&&void 0!==arguments[4]?arguments[4]:{});if(null===t[i])e[i]=(0,a.default)(o[i]);else if(void 0!==t[i])if("boolean"==typeof t[i])e[i].enabled=t[i];else{void 0===t[i].enabled&&(e[i].enabled=!0);for(var n in t[i])t[i].hasOwnProperty(n)&&(e[i][n]=t[i][n])}},t.binarySearchCustom=function(e,t,i,o){for(var n=1e4,s=0,r=0,a=e.length-1;r<=a&&s<n;){var d=Math.floor((r+a)/2),h=e[d],l=void 0===o?h[i]:h[i][o],u=t(l);if(0==u)return d;u==-1?r=d+1:a=d-1,s++}return-1},t.binarySearchValue=function(e,t,i,o,n){for(var s,r,a,d,h=1e4,l=0,u=0,c=e.length-1,n=void 0!=n?n:function(e,t){return e==t?0:e<t?-1:1};u<=c&&l<h;){if(d=Math.floor(.5*(c+u)),s=e[Math.max(0,d-1)][i],r=e[d][i],a=e[Math.min(e.length-1,d+1)][i],0==n(r,t))return d;if(n(s,t)<0&&n(r,t)>0)return"before"==o?Math.max(0,d-1):d;if(n(r,t)<0&&n(a,t)>0)return"before"==o?d:Math.min(e.length-1,d+1);n(r,t)<0?u=d+1:c=d-1,l++}return-1},t.easingFunctions={linear:function(e){return e},easeInQuad:function(e){return e*e},easeOutQuad:function(e){return e*(2-e)},easeInOutQuad:function(e){return e<.5?2*e*e:-1+(4-2*e)*e},easeInCubic:function(e){return e*e*e},easeOutCubic:function(e){return--e*e*e+1},easeInOutCubic:function(e){return e<.5?4*e*e*e:(e-1)*(2*e-2)*(2*e-2)+1},easeInQuart:function(e){return e*e*e*e},easeOutQuart:function(e){return 1- --e*e*e*e},easeInOutQuart:function(e){return e<.5?8*e*e*e*e:1-8*--e*e*e*e},easeInQuint:function(e){return e*e*e*e*e},easeOutQuint:function(e){return 1+--e*e*e*e*e},easeInOutQuint:function(e){return e<.5?16*e*e*e*e*e:1+16*--e*e*e*e*e}},t.getScrollBarWidth=function(){var e=document.createElement("p");e.style.width="100%",e.style.height="200px";var t=document.createElement("div");t.style.position="absolute",t.style.top="0px",t.style.left="0px",t.style.visibility="hidden",t.style.width="200px",t.style.height="150px",t.style.overflow="hidden",t.appendChild(e),document.body.appendChild(t);var i=e.offsetWidth;t.style.overflow="scroll";var o=e.offsetWidth;return i==o&&(o=t.clientWidth),document.body.removeChild(t),i-o},t.topMost=function(e,t){var i=void 0;Array.isArray(t)||(t=[t]);var o=!0,n=!1,r=void 0;try{for(var a,d=(0,s.default)(e);!(o=(a=d.next()).done);o=!0){var h=a.value;if(h){i=h[t[0]];for(var l=1;l<t.length;l++)i&&(i=i[t[l]]);if("undefined"!=typeof i)break}}}catch(e){n=!0,r=e}finally{try{!o&&d.return&&d.return()}finally{if(n)throw r}}return i}},function(e,t,i){e.exports={default:i(3),__esModule:!0}},function(e,t,i){i(4),i(50),e.exports=i(52)},function(e,t,i){i(5);for(var o=i(16),n=i(20),s=i(8),r=i(47)("toStringTag"),a=["NodeList","DOMTokenList","MediaList","StyleSheetList","CSSRuleList"],d=0;d<5;d++){var h=a[d],l=o[h],u=l&&l.prototype;u&&!u[r]&&n(u,r,h),s[h]=s.Array}},function(e,t,i){var o=i(6),n=i(7),s=i(8),r=i(9);e.exports=i(13)(Array,"Array",function(e,t){this._t=r(e),this._i=0,this._k=t},function(){var e=this._t,t=this._k,i=this._i++;return!e||i>=e.length?(this._t=void 0,n(1)):"keys"==t?n(0,i):"values"==t?n(0,e[i]):n(0,[i,e[i]])},"values"),s.Arguments=s.Array,o("keys"),o("values"),o("entries")},function(e,t){e.exports=function(){}},function(e,t){e.exports=function(e,t){return{value:t,done:!!e}}},function(e,t){e.exports={}},function(e,t,i){var o=i(10),n=i(12);e.exports=function(e){return o(n(e))}},function(e,t,i){var o=i(11);e.exports=Object("z").propertyIsEnumerable(0)?Object:function(e){return"String"==o(e)?e.split(""):Object(e)}},function(e,t){var i={}.toString;e.exports=function(e){return i.call(e).slice(8,-1)}},function(e,t){e.exports=function(e){if(void 0==e)throw TypeError("Can't call method on  "+e);return e}},function(e,t,i){var o=i(14),n=i(15),s=i(30),r=i(20),a=i(31),d=i(8),h=i(32),l=i(46),u=i(48),c=i(47)("iterator"),f=!([].keys&&"next"in[].keys()),p="@@iterator",v="keys",g="values",y=function(){return this};e.exports=function(e,t,i,m,b,_,w){h(i,t,m);var k,x,O,M=function(e){if(!f&&e in C)return C[e];switch(e){case v:return function(){return new i(this,e)};case g:return function(){return new i(this,e)}}return function(){return new i(this,e)}},E=t+" Iterator",S=b==g,D=!1,C=e.prototype,T=C[c]||C[p]||b&&C[b],P=T||M(b),F=b?S?M("entries"):P:void 0,I="Array"==t?C.entries||T:T;if(I&&(O=u(I.call(new e)),O!==Object.prototype&&(l(O,E,!0),o||a(O,c)||r(O,c,y))),S&&T&&T.name!==g&&(D=!0,P=function(){return T.call(this)}),o&&!w||!f&&!D&&C[c]||r(C,c,P),d[t]=P,d[E]=y,b)if(k={values:S?P:M(g),keys:_?P:M(v),entries:F},w)for(x in k)x in C||s(C,x,k[x]);else n(n.P+n.F*(f||D),t,k);return k}},function(e,t){e.exports=!0},function(e,t,i){var o=i(16),n=i(17),s=i(18),r=i(20),a="prototype",d=function(e,t,i){var h,l,u,c=e&d.F,f=e&d.G,p=e&d.S,v=e&d.P,g=e&d.B,y=e&d.W,m=f?n:n[t]||(n[t]={}),b=m[a],_=f?o:p?o[t]:(o[t]||{})[a];f&&(i=t);for(h in i)l=!c&&_&&void 0!==_[h],l&&h in m||(u=l?_[h]:i[h],m[h]=f&&"function"!=typeof _[h]?i[h]:g&&l?s(u,o):y&&_[h]==u?function(e){var t=function(t,i,o){if(this instanceof e){switch(arguments.length){case 0:return new e;case 1:return new e(t);case 2:return new e(t,i)}return new e(t,i,o)}return e.apply(this,arguments)};return t[a]=e[a],t}(u):v&&"function"==typeof u?s(Function.call,u):u,v&&((m.virtual||(m.virtual={}))[h]=u,e&d.R&&b&&!b[h]&&r(b,h,u)))};d.F=1,d.G=2,d.S=4,d.P=8,d.B=16,d.W=32,d.U=64,d.R=128,e.exports=d},function(e,t){var i=e.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=i)},function(e,t){var i=e.exports={version:"2.4.0"};"number"==typeof __e&&(__e=i)},function(e,t,i){var o=i(19);e.exports=function(e,t,i){if(o(e),void 0===t)return e;switch(i){case 1:return function(i){return e.call(t,i)};case 2:return function(i,o){return e.call(t,i,o)};case 3:return function(i,o,n){return e.call(t,i,o,n)}}return function(){return e.apply(t,arguments)}}},function(e,t){e.exports=function(e){if("function"!=typeof e)throw TypeError(e+" is not a function!");return e}},function(e,t,i){var o=i(21),n=i(29);e.exports=i(25)?function(e,t,i){return o.f(e,t,n(1,i))}:function(e,t,i){return e[t]=i,e}},function(e,t,i){var o=i(22),n=i(24),s=i(28),r=Object.defineProperty;t.f=i(25)?Object.defineProperty:function(e,t,i){if(o(e),t=s(t,!0),o(i),n)try{return r(e,t,i)}catch(e){}if("get"in i||"set"in i)throw TypeError("Accessors not supported!");return"value"in i&&(e[t]=i.value),e}},function(e,t,i){var o=i(23);e.exports=function(e){if(!o(e))throw TypeError(e+" is not an object!");return e}},function(e,t){e.exports=function(e){return"object"==typeof e?null!==e:"function"==typeof e}},function(e,t,i){e.exports=!i(25)&&!i(26)(function(){return 7!=Object.defineProperty(i(27)("div"),"a",{get:function(){return 7}}).a})},function(e,t,i){e.exports=!i(26)(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a})},function(e,t){e.exports=function(e){try{return!!e()}catch(e){return!0}}},function(e,t,i){var o=i(23),n=i(16).document,s=o(n)&&o(n.createElement);e.exports=function(e){return s?n.createElement(e):{}}},function(e,t,i){var o=i(23);e.exports=function(e,t){if(!o(e))return e;var i,n;if(t&&"function"==typeof(i=e.toString)&&!o(n=i.call(e)))return n;if("function"==typeof(i=e.valueOf)&&!o(n=i.call(e)))return n;if(!t&&"function"==typeof(i=e.toString)&&!o(n=i.call(e)))return n;throw TypeError("Can't convert object to primitive value")}},function(e,t){e.exports=function(e,t){return{enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}}},function(e,t,i){e.exports=i(20)},function(e,t){var i={}.hasOwnProperty;e.exports=function(e,t){return i.call(e,t)}},function(e,t,i){var o=i(33),n=i(29),s=i(46),r={};i(20)(r,i(47)("iterator"),function(){return this}),e.exports=function(e,t,i){e.prototype=o(r,{next:n(1,i)}),s(e,t+" Iterator")}},function(e,t,i){var o=i(22),n=i(34),s=i(44),r=i(41)("IE_PROTO"),a=function(){},d="prototype",h=function(){var e,t=i(27)("iframe"),o=s.length,n="<",r=">";for(t.style.display="none",i(45).appendChild(t),t.src="javascript:",e=t.contentWindow.document,e.open(),e.write(n+"script"+r+"document.F=Object"+n+"/script"+r),e.close(),h=e.F;o--;)delete h[d][s[o]];return h()};e.exports=Object.create||function(e,t){var i;return null!==e?(a[d]=o(e),i=new a,a[d]=null,i[r]=e):i=h(),void 0===t?i:n(i,t)}},function(e,t,i){var o=i(21),n=i(22),s=i(35);e.exports=i(25)?Object.defineProperties:function(e,t){n(e);for(var i,r=s(t),a=r.length,d=0;a>d;)o.f(e,i=r[d++],t[i]);return e}},function(e,t,i){var o=i(36),n=i(44);e.exports=Object.keys||function(e){return o(e,n)}},function(e,t,i){var o=i(31),n=i(9),s=i(37)(!1),r=i(41)("IE_PROTO");e.exports=function(e,t){var i,a=n(e),d=0,h=[];for(i in a)i!=r&&o(a,i)&&h.push(i);for(;t.length>d;)o(a,i=t[d++])&&(~s(h,i)||h.push(i));return h}},function(e,t,i){var o=i(9),n=i(38),s=i(40);e.exports=function(e){return function(t,i,r){var a,d=o(t),h=n(d.length),l=s(r,h);if(e&&i!=i){for(;h>l;)if(a=d[l++],a!=a)return!0}else for(;h>l;l++)if((e||l in d)&&d[l]===i)return e||l||0;return!e&&-1}}},function(e,t,i){var o=i(39),n=Math.min;e.exports=function(e){return e>0?n(o(e),9007199254740991):0}},function(e,t){var i=Math.ceil,o=Math.floor;e.exports=function(e){return isNaN(e=+e)?0:(e>0?o:i)(e)}},function(e,t,i){var o=i(39),n=Math.max,s=Math.min;e.exports=function(e,t){return e=o(e),e<0?n(e+t,0):s(e,t)}},function(e,t,i){var o=i(42)("keys"),n=i(43);e.exports=function(e){return o[e]||(o[e]=n(e))}},function(e,t,i){var o=i(16),n="__core-js_shared__",s=o[n]||(o[n]={});e.exports=function(e){return s[e]||(s[e]={})}},function(e,t){var i=0,o=Math.random();e.exports=function(e){return"Symbol(".concat(void 0===e?"":e,")_",(++i+o).toString(36))}},function(e,t){e.exports="constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",")},function(e,t,i){e.exports=i(16).document&&document.documentElement},function(e,t,i){var o=i(21).f,n=i(31),s=i(47)("toStringTag");e.exports=function(e,t,i){e&&!n(e=i?e:e.prototype,s)&&o(e,s,{configurable:!0,value:t})}},function(e,t,i){var o=i(42)("wks"),n=i(43),s=i(16).Symbol,r="function"==typeof s,a=e.exports=function(e){return o[e]||(o[e]=r&&s[e]||(r?s:n)("Symbol."+e))};a.store=o},function(e,t,i){var o=i(31),n=i(49),s=i(41)("IE_PROTO"),r=Object.prototype;e.exports=Object.getPrototypeOf||function(e){return e=n(e),o(e,s)?e[s]:"function"==typeof e.constructor&&e instanceof e.constructor?e.constructor.prototype:e instanceof Object?r:null}},function(e,t,i){var o=i(12);e.exports=function(e){return Object(o(e))}},function(e,t,i){var o=i(51)(!0);i(13)(String,"String",function(e){this._t=String(e),this._i=0},function(){var e,t=this._t,i=this._i;return i>=t.length?{value:void 0,done:!0}:(e=o(t,i),this._i+=e.length,{value:e,done:!1})})},function(e,t,i){var o=i(39),n=i(12);e.exports=function(e){return function(t,i){var s,r,a=String(n(t)),d=o(i),h=a.length;return d<0||d>=h?e?"":void 0:(s=a.charCodeAt(d),s<55296||s>56319||d+1===h||(r=a.charCodeAt(d+1))<56320||r>57343?e?a.charAt(d):s:e?a.slice(d,d+2):(s-55296<<10)+(r-56320)+65536)}}},function(e,t,i){var o=i(22),n=i(53);e.exports=i(17).getIterator=function(e){var t=n(e);if("function"!=typeof t)throw TypeError(e+" is not iterable!");return o(t.call(e))}},function(e,t,i){var o=i(54),n=i(47)("iterator"),s=i(8);e.exports=i(17).getIteratorMethod=function(e){if(void 0!=e)return e[n]||e["@@iterator"]||s[o(e)]}},function(e,t,i){var o=i(11),n=i(47)("toStringTag"),s="Arguments"==o(function(){return arguments}()),r=function(e,t){try{return e[t]}catch(e){}};e.exports=function(e){var t,i,a;return void 0===e?"Undefined":null===e?"Null":"string"==typeof(i=r(t=Object(e),n))?i:s?o(t):"Object"==(a=o(t))&&"function"==typeof t.callee?"Arguments":a}},function(e,t,i){e.exports={default:i(56),__esModule:!0}},function(e,t,i){i(57);var o=i(17).Object;e.exports=function(e,t){return o.create(e,t)}},function(e,t,i){var o=i(15);o(o.S,"Object",{create:i(33)})},function(e,t,i){e.exports={default:i(59),__esModule:!0}},function(e,t,i){i(60),e.exports=i(17).Object.keys},function(e,t,i){var o=i(49),n=i(35);i(61)("keys",function(){return function(e){return n(o(e))}})},function(e,t,i){var o=i(15),n=i(17),s=i(26);e.exports=function(e,t){var i=(n.Object||{})[e]||Object[e],r={};r[e]=t(i),o(o.S+o.F*s(function(){i(1)}),"Object",r)}},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}t.__esModule=!0;var n=i(63),s=o(n),r=i(66),a=o(r),d="function"==typeof a.default&&"symbol"==typeof s.default?function(e){return typeof e}:function(e){return e&&"function"==typeof a.default&&e.constructor===a.default&&e!==a.default.prototype?"symbol":typeof e};t.default="function"==typeof a.default&&"symbol"===d(s.default)?function(e){return"undefined"==typeof e?"undefined":d(e)}:function(e){return e&&"function"==typeof a.default&&e.constructor===a.default&&e!==a.default.prototype?"symbol":"undefined"==typeof e?"undefined":d(e)}},function(e,t,i){e.exports={default:i(64),__esModule:!0}},function(e,t,i){i(50),i(4),e.exports=i(65).f("iterator")},function(e,t,i){t.f=i(47)},function(e,t,i){e.exports={default:i(67),__esModule:!0}},function(e,t,i){i(68),i(79),i(80),i(81),e.exports=i(17).Symbol},function(e,t,i){var o=i(16),n=i(31),s=i(25),r=i(15),a=i(30),d=i(69).KEY,h=i(26),l=i(42),u=i(46),c=i(43),f=i(47),p=i(65),v=i(70),g=i(71),y=i(72),m=i(75),b=i(22),_=i(9),w=i(28),k=i(29),x=i(33),O=i(76),M=i(78),E=i(21),S=i(35),D=M.f,C=E.f,T=O.f,P=o.Symbol,F=o.JSON,I=F&&F.stringify,N="prototype",B=f("_hidden"),z=f("toPrimitive"),A={}.propertyIsEnumerable,R=l("symbol-registry"),j=l("symbols"),H=l("op-symbols"),L=Object[N],W="function"==typeof P,Y=o.QObject,V=!Y||!Y[N]||!Y[N].findChild,U=s&&h(function(){return 7!=x(C({},"a",{get:function(){return C(this,"a",{value:7}).a}})).a})?function(e,t,i){var o=D(L,t);o&&delete L[t],C(e,t,i),o&&e!==L&&C(L,t,o)}:C,q=function(e){var t=j[e]=x(P[N]);return t._k=e,t},G=W&&"symbol"==typeof P.iterator?function(e){return"symbol"==typeof e}:function(e){return e instanceof P},X=function(e,t,i){return e===L&&X(H,t,i),b(e),t=w(t,!0),b(i),n(j,t)?(i.enumerable?(n(e,B)&&e[B][t]&&(e[B][t]=!1),i=x(i,{enumerable:k(0,!1)})):(n(e,B)||C(e,B,k(1,{})),e[B][t]=!0),U(e,t,i)):C(e,t,i)},K=function(e,t){b(e);for(var i,o=y(t=_(t)),n=0,s=o.length;s>n;)X(e,i=o[n++],t[i]);return e},Z=function(e,t){return void 0===t?x(e):K(x(e),t)},Q=function(e){var t=A.call(this,e=w(e,!0));return!(this===L&&n(j,e)&&!n(H,e))&&(!(t||!n(this,e)||!n(j,e)||n(this,B)&&this[B][e])||t)},$=function(e,t){if(e=_(e),t=w(t,!0),e!==L||!n(j,t)||n(H,t)){var i=D(e,t);return!i||!n(j,t)||n(e,B)&&e[B][t]||(i.enumerable=!0),i}},J=function(e){for(var t,i=T(_(e)),o=[],s=0;i.length>s;)n(j,t=i[s++])||t==B||t==d||o.push(t);return o},ee=function(e){for(var t,i=e===L,o=T(i?H:_(e)),s=[],r=0;o.length>r;)!n(j,t=o[r++])||i&&!n(L,t)||s.push(j[t]);return s};W||(P=function(){if(this instanceof P)throw TypeError("Symbol is not a constructor!");var e=c(arguments.length>0?arguments[0]:void 0),t=function(i){this===L&&t.call(H,i),n(this,B)&&n(this[B],e)&&(this[B][e]=!1),U(this,e,k(1,i))};return s&&V&&U(L,e,{configurable:!0,set:t}),q(e)},a(P[N],"toString",function(){return this._k}),M.f=$,E.f=X,i(77).f=O.f=J,i(74).f=Q,i(73).f=ee,s&&!i(14)&&a(L,"propertyIsEnumerable",Q,!0),p.f=function(e){return q(f(e))}),r(r.G+r.W+r.F*!W,{Symbol:P});for(var te="hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables".split(","),ie=0;te.length>ie;)f(te[ie++]);for(var te=S(f.store),ie=0;te.length>ie;)v(te[ie++]);r(r.S+r.F*!W,"Symbol",{for:function(e){return n(R,e+="")?R[e]:R[e]=P(e)},keyFor:function(e){if(G(e))return g(R,e);throw TypeError(e+" is not a symbol!")},useSetter:function(){V=!0},useSimple:function(){V=!1}}),r(r.S+r.F*!W,"Object",{create:Z,defineProperty:X,defineProperties:K,getOwnPropertyDescriptor:$,getOwnPropertyNames:J,getOwnPropertySymbols:ee}),F&&r(r.S+r.F*(!W||h(function(){var e=P();return"[null]"!=I([e])||"{}"!=I({a:e})||"{}"!=I(Object(e))})),"JSON",{stringify:function(e){if(void 0!==e&&!G(e)){for(var t,i,o=[e],n=1;arguments.length>n;)o.push(arguments[n++]);return t=o[1],"function"==typeof t&&(i=t),!i&&m(t)||(t=function(e,t){if(i&&(t=i.call(this,e,t)),!G(t))return t}),o[1]=t,I.apply(F,o)}}}),P[N][z]||i(20)(P[N],z,P[N].valueOf),u(P,"Symbol"),u(Math,"Math",!0),u(o.JSON,"JSON",!0)},function(e,t,i){var o=i(43)("meta"),n=i(23),s=i(31),r=i(21).f,a=0,d=Object.isExtensible||function(){return!0},h=!i(26)(function(){return d(Object.preventExtensions({}))}),l=function(e){r(e,o,{value:{i:"O"+ ++a,w:{}}})},u=function(e,t){if(!n(e))return"symbol"==typeof e?e:("string"==typeof e?"S":"P")+e;if(!s(e,o)){if(!d(e))return"F";if(!t)return"E";l(e)}return e[o].i},c=function(e,t){if(!s(e,o)){if(!d(e))return!0;if(!t)return!1;l(e)}return e[o].w},f=function(e){return h&&p.NEED&&d(e)&&!s(e,o)&&l(e),e},p=e.exports={KEY:o,NEED:!1,fastKey:u,getWeak:c,onFreeze:f}},function(e,t,i){var o=i(16),n=i(17),s=i(14),r=i(65),a=i(21).f;e.exports=function(e){var t=n.Symbol||(n.Symbol=s?{}:o.Symbol||{});"_"==e.charAt(0)||e in t||a(t,e,{value:r.f(e)})}},function(e,t,i){var o=i(35),n=i(9);e.exports=function(e,t){for(var i,s=n(e),r=o(s),a=r.length,d=0;a>d;)if(s[i=r[d++]]===t)return i}},function(e,t,i){var o=i(35),n=i(73),s=i(74);e.exports=function(e){var t=o(e),i=n.f;if(i)for(var r,a=i(e),d=s.f,h=0;a.length>h;)d.call(e,r=a[h++])&&t.push(r);return t}},function(e,t){t.f=Object.getOwnPropertySymbols},function(e,t){t.f={}.propertyIsEnumerable},function(e,t,i){var o=i(11);e.exports=Array.isArray||function(e){return"Array"==o(e)}},function(e,t,i){var o=i(9),n=i(77).f,s={}.toString,r="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[],a=function(e){try{return n(e)}catch(e){return r.slice()}};e.exports.f=function(e){return r&&"[object Window]"==s.call(e)?a(e):n(o(e))}},function(e,t,i){var o=i(36),n=i(44).concat("length","prototype");t.f=Object.getOwnPropertyNames||function(e){return o(e,n)}},function(e,t,i){var o=i(74),n=i(29),s=i(9),r=i(28),a=i(31),d=i(24),h=Object.getOwnPropertyDescriptor;t.f=i(25)?h:function(e,t){if(e=s(e),t=r(t,!0),d)try{return h(e,t)}catch(e){}if(a(e,t))return n(!o.f.call(e,t),e[t])}},function(e,t){},function(e,t,i){i(70)("asyncIterator")},function(e,t,i){i(70)("observable")},function(e,t,i){e.exports="undefined"!=typeof window&&window.moment||i(83)},function(e,t,i){(function(e){!function(t,i){e.exports=i()}(this,function(){function t(){return _o.apply(null,arguments)}function i(e){_o=e}function o(e){return e instanceof Array||"[object Array]"===Object.prototype.toString.call(e)}function n(e){return null!=e&&"[object Object]"===Object.prototype.toString.call(e)}function s(e){var t;for(t in e)return!1;return!0}function r(e){return void 0===e}function a(e){return"number"==typeof e||"[object Number]"===Object.prototype.toString.call(e)}function d(e){return e instanceof Date||"[object Date]"===Object.prototype.toString.call(e)}function h(e,t){var i,o=[];for(i=0;i<e.length;++i)o.push(t(e[i],i));return o}function l(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function u(e,t){for(var i in t)l(t,i)&&(e[i]=t[i]);return l(t,"toString")&&(e.toString=t.toString),l(t,"valueOf")&&(e.valueOf=t.valueOf),e}function c(e,t,i,o){return bt(e,t,i,o,!0).utc()}function f(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null,rfc2822:!1,weekdayMismatch:!1}}function p(e){return null==e._pf&&(e._pf=f()),e._pf}function v(e){if(null==e._isValid){var t=p(e),i=ko.call(t.parsedDateParts,function(e){return null!=e}),o=!isNaN(e._d.getTime())&&t.overflow<0&&!t.empty&&!t.invalidMonth&&!t.invalidWeekday&&!t.nullInput&&!t.invalidFormat&&!t.userInvalidated&&(!t.meridiem||t.meridiem&&i);if(e._strict&&(o=o&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour),
null!=Object.isFrozen&&Object.isFrozen(e))return o;e._isValid=o}return e._isValid}function g(e){var t=c(NaN);return null!=e?u(p(t),e):p(t).userInvalidated=!0,t}function y(e,t){var i,o,n;if(r(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),r(t._i)||(e._i=t._i),r(t._f)||(e._f=t._f),r(t._l)||(e._l=t._l),r(t._strict)||(e._strict=t._strict),r(t._tzm)||(e._tzm=t._tzm),r(t._isUTC)||(e._isUTC=t._isUTC),r(t._offset)||(e._offset=t._offset),r(t._pf)||(e._pf=p(t)),r(t._locale)||(e._locale=t._locale),xo.length>0)for(i=0;i<xo.length;i++)o=xo[i],n=t[o],r(n)||(e[o]=n);return e}function m(e){y(this,e),this._d=new Date(null!=e._d?e._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),Oo===!1&&(Oo=!0,t.updateOffset(this),Oo=!1)}function b(e){return e instanceof m||null!=e&&null!=e._isAMomentObject}function _(e){return e<0?Math.ceil(e)||0:Math.floor(e)}function w(e){var t=+e,i=0;return 0!==t&&isFinite(t)&&(i=_(t)),i}function k(e,t,i){var o,n=Math.min(e.length,t.length),s=Math.abs(e.length-t.length),r=0;for(o=0;o<n;o++)(i&&e[o]!==t[o]||!i&&w(e[o])!==w(t[o]))&&r++;return r+s}function x(e){t.suppressDeprecationWarnings===!1&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+e)}function O(e,i){var o=!0;return u(function(){if(null!=t.deprecationHandler&&t.deprecationHandler(null,e),o){for(var n,s=[],r=0;r<arguments.length;r++){if(n="","object"==typeof arguments[r]){n+="\n["+r+"] ";for(var a in arguments[0])n+=a+": "+arguments[0][a]+", ";n=n.slice(0,-2)}else n=arguments[r];s.push(n)}x(e+"\nArguments: "+Array.prototype.slice.call(s).join("")+"\n"+(new Error).stack),o=!1}return i.apply(this,arguments)},i)}function M(e,i){null!=t.deprecationHandler&&t.deprecationHandler(e,i),Mo[e]||(x(i),Mo[e]=!0)}function E(e){return e instanceof Function||"[object Function]"===Object.prototype.toString.call(e)}function S(e){var t,i;for(i in e)t=e[i],E(t)?this[i]=t:this["_"+i]=t;this._config=e,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)}function D(e,t){var i,o=u({},e);for(i in t)l(t,i)&&(n(e[i])&&n(t[i])?(o[i]={},u(o[i],e[i]),u(o[i],t[i])):null!=t[i]?o[i]=t[i]:delete o[i]);for(i in e)l(e,i)&&!l(t,i)&&n(e[i])&&(o[i]=u({},o[i]));return o}function C(e){null!=e&&this.set(e)}function T(e,t,i){var o=this._calendar[e]||this._calendar.sameElse;return E(o)?o.call(t,i):o}function P(e){var t=this._longDateFormat[e],i=this._longDateFormat[e.toUpperCase()];return t||!i?t:(this._longDateFormat[e]=i.replace(/MMMM|MM|DD|dddd/g,function(e){return e.slice(1)}),this._longDateFormat[e])}function F(){return this._invalidDate}function I(e){return this._ordinal.replace("%d",e)}function N(e,t,i,o){var n=this._relativeTime[i];return E(n)?n(e,t,i,o):n.replace(/%d/i,e)}function B(e,t){var i=this._relativeTime[e>0?"future":"past"];return E(i)?i(t):i.replace(/%s/i,t)}function z(e,t){var i=e.toLowerCase();Bo[i]=Bo[i+"s"]=Bo[t]=e}function A(e){return"string"==typeof e?Bo[e]||Bo[e.toLowerCase()]:void 0}function R(e){var t,i,o={};for(i in e)l(e,i)&&(t=A(i),t&&(o[t]=e[i]));return o}function j(e,t){zo[e]=t}function H(e){var t=[];for(var i in e)t.push({unit:i,priority:zo[i]});return t.sort(function(e,t){return e.priority-t.priority}),t}function L(e,i){return function(o){return null!=o?(Y(this,e,o),t.updateOffset(this,i),this):W(this,e)}}function W(e,t){return e.isValid()?e._d["get"+(e._isUTC?"UTC":"")+t]():NaN}function Y(e,t,i){e.isValid()&&e._d["set"+(e._isUTC?"UTC":"")+t](i)}function V(e){return e=A(e),E(this[e])?this[e]():this}function U(e,t){if("object"==typeof e){e=R(e);for(var i=H(e),o=0;o<i.length;o++)this[i[o].unit](e[i[o].unit])}else if(e=A(e),E(this[e]))return this[e](t);return this}function q(e,t,i){var o=""+Math.abs(e),n=t-o.length,s=e>=0;return(s?i?"+":"":"-")+Math.pow(10,Math.max(0,n)).toString().substr(1)+o}function G(e,t,i,o){var n=o;"string"==typeof o&&(n=function(){return this[o]()}),e&&(Ho[e]=n),t&&(Ho[t[0]]=function(){return q(n.apply(this,arguments),t[1],t[2])}),i&&(Ho[i]=function(){return this.localeData().ordinal(n.apply(this,arguments),e)})}function X(e){return e.match(/\[[\s\S]/)?e.replace(/^\[|\]$/g,""):e.replace(/\\/g,"")}function K(e){var t,i,o=e.match(Ao);for(t=0,i=o.length;t<i;t++)Ho[o[t]]?o[t]=Ho[o[t]]:o[t]=X(o[t]);return function(t){var n,s="";for(n=0;n<i;n++)s+=E(o[n])?o[n].call(t,e):o[n];return s}}function Z(e,t){return e.isValid()?(t=Q(t,e.localeData()),jo[t]=jo[t]||K(t),jo[t](e)):e.localeData().invalidDate()}function Q(e,t){function i(e){return t.longDateFormat(e)||e}var o=5;for(Ro.lastIndex=0;o>=0&&Ro.test(e);)e=e.replace(Ro,i),Ro.lastIndex=0,o-=1;return e}function $(e,t,i){sn[e]=E(t)?t:function(e,o){return e&&i?i:t}}function J(e,t){return l(sn,e)?sn[e](t._strict,t._locale):new RegExp(ee(e))}function ee(e){return te(e.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(e,t,i,o,n){return t||i||o||n}))}function te(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function ie(e,t){var i,o=t;for("string"==typeof e&&(e=[e]),a(t)&&(o=function(e,i){i[t]=w(e)}),i=0;i<e.length;i++)rn[e[i]]=o}function oe(e,t){ie(e,function(e,i,o,n){o._w=o._w||{},t(e,o._w,o,n)})}function ne(e,t,i){null!=t&&l(rn,e)&&rn[e](t,i._a,i,e)}function se(e,t){return new Date(Date.UTC(e,t+1,0)).getUTCDate()}function re(e,t){return e?o(this._months)?this._months[e.month()]:this._months[(this._months.isFormat||yn).test(t)?"format":"standalone"][e.month()]:o(this._months)?this._months:this._months.standalone}function ae(e,t){return e?o(this._monthsShort)?this._monthsShort[e.month()]:this._monthsShort[yn.test(t)?"format":"standalone"][e.month()]:o(this._monthsShort)?this._monthsShort:this._monthsShort.standalone}function de(e,t,i){var o,n,s,r=e.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],o=0;o<12;++o)s=c([2e3,o]),this._shortMonthsParse[o]=this.monthsShort(s,"").toLocaleLowerCase(),this._longMonthsParse[o]=this.months(s,"").toLocaleLowerCase();return i?"MMM"===t?(n=gn.call(this._shortMonthsParse,r),n!==-1?n:null):(n=gn.call(this._longMonthsParse,r),n!==-1?n:null):"MMM"===t?(n=gn.call(this._shortMonthsParse,r),n!==-1?n:(n=gn.call(this._longMonthsParse,r),n!==-1?n:null)):(n=gn.call(this._longMonthsParse,r),n!==-1?n:(n=gn.call(this._shortMonthsParse,r),n!==-1?n:null))}function he(e,t,i){var o,n,s;if(this._monthsParseExact)return de.call(this,e,t,i);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),o=0;o<12;o++){if(n=c([2e3,o]),i&&!this._longMonthsParse[o]&&(this._longMonthsParse[o]=new RegExp("^"+this.months(n,"").replace(".","")+"$","i"),this._shortMonthsParse[o]=new RegExp("^"+this.monthsShort(n,"").replace(".","")+"$","i")),i||this._monthsParse[o]||(s="^"+this.months(n,"")+"|^"+this.monthsShort(n,""),this._monthsParse[o]=new RegExp(s.replace(".",""),"i")),i&&"MMMM"===t&&this._longMonthsParse[o].test(e))return o;if(i&&"MMM"===t&&this._shortMonthsParse[o].test(e))return o;if(!i&&this._monthsParse[o].test(e))return o}}function le(e,t){var i;if(!e.isValid())return e;if("string"==typeof t)if(/^\d+$/.test(t))t=w(t);else if(t=e.localeData().monthsParse(t),!a(t))return e;return i=Math.min(e.date(),se(e.year(),t)),e._d["set"+(e._isUTC?"UTC":"")+"Month"](t,i),e}function ue(e){return null!=e?(le(this,e),t.updateOffset(this,!0),this):W(this,"Month")}function ce(){return se(this.year(),this.month())}function fe(e){return this._monthsParseExact?(l(this,"_monthsRegex")||ve.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):(l(this,"_monthsShortRegex")||(this._monthsShortRegex=_n),this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex)}function pe(e){return this._monthsParseExact?(l(this,"_monthsRegex")||ve.call(this),e?this._monthsStrictRegex:this._monthsRegex):(l(this,"_monthsRegex")||(this._monthsRegex=wn),this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex)}function ve(){function e(e,t){return t.length-e.length}var t,i,o=[],n=[],s=[];for(t=0;t<12;t++)i=c([2e3,t]),o.push(this.monthsShort(i,"")),n.push(this.months(i,"")),s.push(this.months(i,"")),s.push(this.monthsShort(i,""));for(o.sort(e),n.sort(e),s.sort(e),t=0;t<12;t++)o[t]=te(o[t]),n[t]=te(n[t]);for(t=0;t<24;t++)s[t]=te(s[t]);this._monthsRegex=new RegExp("^("+s.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+n.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+o.join("|")+")","i")}function ge(e){return ye(e)?366:365}function ye(e){return e%4===0&&e%100!==0||e%400===0}function me(){return ye(this.year())}function be(e,t,i,o,n,s,r){var a=new Date(e,t,i,o,n,s,r);return e<100&&e>=0&&isFinite(a.getFullYear())&&a.setFullYear(e),a}function _e(e){var t=new Date(Date.UTC.apply(null,arguments));return e<100&&e>=0&&isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e),t}function we(e,t,i){var o=7+t-i,n=(7+_e(e,0,o).getUTCDay()-t)%7;return-n+o-1}function ke(e,t,i,o,n){var s,r,a=(7+i-o)%7,d=we(e,o,n),h=1+7*(t-1)+a+d;return h<=0?(s=e-1,r=ge(s)+h):h>ge(e)?(s=e+1,r=h-ge(e)):(s=e,r=h),{year:s,dayOfYear:r}}function xe(e,t,i){var o,n,s=we(e.year(),t,i),r=Math.floor((e.dayOfYear()-s-1)/7)+1;return r<1?(n=e.year()-1,o=r+Oe(n,t,i)):r>Oe(e.year(),t,i)?(o=r-Oe(e.year(),t,i),n=e.year()+1):(n=e.year(),o=r),{week:o,year:n}}function Oe(e,t,i){var o=we(e,t,i),n=we(e+1,t,i);return(ge(e)-o+n)/7}function Me(e){return xe(e,this._week.dow,this._week.doy).week}function Ee(){return this._week.dow}function Se(){return this._week.doy}function De(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),"d")}function Ce(e){var t=xe(this,1,4).week;return null==e?t:this.add(7*(e-t),"d")}function Te(e,t){return"string"!=typeof e?e:isNaN(e)?(e=t.weekdaysParse(e),"number"==typeof e?e:null):parseInt(e,10)}function Pe(e,t){return"string"==typeof e?t.weekdaysParse(e)%7||7:isNaN(e)?null:e}function Fe(e,t){return e?o(this._weekdays)?this._weekdays[e.day()]:this._weekdays[this._weekdays.isFormat.test(t)?"format":"standalone"][e.day()]:o(this._weekdays)?this._weekdays:this._weekdays.standalone}function Ie(e){return e?this._weekdaysShort[e.day()]:this._weekdaysShort}function Ne(e){return e?this._weekdaysMin[e.day()]:this._weekdaysMin}function Be(e,t,i){var o,n,s,r=e.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],o=0;o<7;++o)s=c([2e3,1]).day(o),this._minWeekdaysParse[o]=this.weekdaysMin(s,"").toLocaleLowerCase(),this._shortWeekdaysParse[o]=this.weekdaysShort(s,"").toLocaleLowerCase(),this._weekdaysParse[o]=this.weekdays(s,"").toLocaleLowerCase();return i?"dddd"===t?(n=gn.call(this._weekdaysParse,r),n!==-1?n:null):"ddd"===t?(n=gn.call(this._shortWeekdaysParse,r),n!==-1?n:null):(n=gn.call(this._minWeekdaysParse,r),n!==-1?n:null):"dddd"===t?(n=gn.call(this._weekdaysParse,r),n!==-1?n:(n=gn.call(this._shortWeekdaysParse,r),n!==-1?n:(n=gn.call(this._minWeekdaysParse,r),n!==-1?n:null))):"ddd"===t?(n=gn.call(this._shortWeekdaysParse,r),n!==-1?n:(n=gn.call(this._weekdaysParse,r),n!==-1?n:(n=gn.call(this._minWeekdaysParse,r),n!==-1?n:null))):(n=gn.call(this._minWeekdaysParse,r),n!==-1?n:(n=gn.call(this._weekdaysParse,r),n!==-1?n:(n=gn.call(this._shortWeekdaysParse,r),n!==-1?n:null)))}function ze(e,t,i){var o,n,s;if(this._weekdaysParseExact)return Be.call(this,e,t,i);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),o=0;o<7;o++){if(n=c([2e3,1]).day(o),i&&!this._fullWeekdaysParse[o]&&(this._fullWeekdaysParse[o]=new RegExp("^"+this.weekdays(n,"").replace(".",".?")+"$","i"),this._shortWeekdaysParse[o]=new RegExp("^"+this.weekdaysShort(n,"").replace(".",".?")+"$","i"),this._minWeekdaysParse[o]=new RegExp("^"+this.weekdaysMin(n,"").replace(".",".?")+"$","i")),this._weekdaysParse[o]||(s="^"+this.weekdays(n,"")+"|^"+this.weekdaysShort(n,"")+"|^"+this.weekdaysMin(n,""),this._weekdaysParse[o]=new RegExp(s.replace(".",""),"i")),i&&"dddd"===t&&this._fullWeekdaysParse[o].test(e))return o;if(i&&"ddd"===t&&this._shortWeekdaysParse[o].test(e))return o;if(i&&"dd"===t&&this._minWeekdaysParse[o].test(e))return o;if(!i&&this._weekdaysParse[o].test(e))return o}}function Ae(e){if(!this.isValid())return null!=e?this:NaN;var t=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=e?(e=Te(e,this.localeData()),this.add(e-t,"d")):t}function Re(e){if(!this.isValid())return null!=e?this:NaN;var t=(this.day()+7-this.localeData()._week.dow)%7;return null==e?t:this.add(e-t,"d")}function je(e){if(!this.isValid())return null!=e?this:NaN;if(null!=e){var t=Pe(e,this.localeData());return this.day(this.day()%7?t:t-7)}return this.day()||7}function He(e){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||Ye.call(this),e?this._weekdaysStrictRegex:this._weekdaysRegex):(l(this,"_weekdaysRegex")||(this._weekdaysRegex=Sn),this._weekdaysStrictRegex&&e?this._weekdaysStrictRegex:this._weekdaysRegex)}function Le(e){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||Ye.call(this),e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(l(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=Dn),this._weekdaysShortStrictRegex&&e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function We(e){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||Ye.call(this),e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(l(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=Cn),this._weekdaysMinStrictRegex&&e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Ye(){function e(e,t){return t.length-e.length}var t,i,o,n,s,r=[],a=[],d=[],h=[];for(t=0;t<7;t++)i=c([2e3,1]).day(t),o=this.weekdaysMin(i,""),n=this.weekdaysShort(i,""),s=this.weekdays(i,""),r.push(o),a.push(n),d.push(s),h.push(o),h.push(n),h.push(s);for(r.sort(e),a.sort(e),d.sort(e),h.sort(e),t=0;t<7;t++)a[t]=te(a[t]),d[t]=te(d[t]),h[t]=te(h[t]);this._weekdaysRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+d.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+r.join("|")+")","i")}function Ve(){return this.hours()%12||12}function Ue(){return this.hours()||24}function qe(e,t){G(e,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)})}function Ge(e,t){return t._meridiemParse}function Xe(e){return"p"===(e+"").toLowerCase().charAt(0)}function Ke(e,t,i){return e>11?i?"pm":"PM":i?"am":"AM"}function Ze(e){return e?e.toLowerCase().replace("_","-"):e}function Qe(e){for(var t,i,o,n,s=0;s<e.length;){for(n=Ze(e[s]).split("-"),t=n.length,i=Ze(e[s+1]),i=i?i.split("-"):null;t>0;){if(o=$e(n.slice(0,t).join("-")))return o;if(i&&i.length>=t&&k(n,i,!0)>=t-1)break;t--}s++}return null}function $e(t){var i=null;if(!Nn[t]&&"undefined"!=typeof e&&e&&e.exports)try{i=Tn._abbr,!function(){var e=new Error('Cannot find module "./locale"');throw e.code="MODULE_NOT_FOUND",e}(),Je(i)}catch(e){}return Nn[t]}function Je(e,t){var i;return e&&(i=r(t)?it(e):et(e,t),i&&(Tn=i)),Tn._abbr}function et(e,t){if(null!==t){var i=In;if(t.abbr=e,null!=Nn[e])M("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),i=Nn[e]._config;else if(null!=t.parentLocale){if(null==Nn[t.parentLocale])return Bn[t.parentLocale]||(Bn[t.parentLocale]=[]),Bn[t.parentLocale].push({name:e,config:t}),null;i=Nn[t.parentLocale]._config}return Nn[e]=new C(D(i,t)),Bn[e]&&Bn[e].forEach(function(e){et(e.name,e.config)}),Je(e),Nn[e]}return delete Nn[e],null}function tt(e,t){if(null!=t){var i,o=In;null!=Nn[e]&&(o=Nn[e]._config),t=D(o,t),i=new C(t),i.parentLocale=Nn[e],Nn[e]=i,Je(e)}else null!=Nn[e]&&(null!=Nn[e].parentLocale?Nn[e]=Nn[e].parentLocale:null!=Nn[e]&&delete Nn[e]);return Nn[e]}function it(e){var t;if(e&&e._locale&&e._locale._abbr&&(e=e._locale._abbr),!e)return Tn;if(!o(e)){if(t=$e(e))return t;e=[e]}return Qe(e)}function ot(){return Do(Nn)}function nt(e){var t,i=e._a;return i&&p(e).overflow===-2&&(t=i[dn]<0||i[dn]>11?dn:i[hn]<1||i[hn]>se(i[an],i[dn])?hn:i[ln]<0||i[ln]>24||24===i[ln]&&(0!==i[un]||0!==i[cn]||0!==i[fn])?ln:i[un]<0||i[un]>59?un:i[cn]<0||i[cn]>59?cn:i[fn]<0||i[fn]>999?fn:-1,p(e)._overflowDayOfYear&&(t<an||t>hn)&&(t=hn),p(e)._overflowWeeks&&t===-1&&(t=pn),p(e)._overflowWeekday&&t===-1&&(t=vn),p(e).overflow=t),e}function st(e){var t,i,o,n,s,r,a=e._i,d=zn.exec(a)||An.exec(a);if(d){for(p(e).iso=!0,t=0,i=jn.length;t<i;t++)if(jn[t][1].exec(d[1])){n=jn[t][0],o=jn[t][2]!==!1;break}if(null==n)return void(e._isValid=!1);if(d[3]){for(t=0,i=Hn.length;t<i;t++)if(Hn[t][1].exec(d[3])){s=(d[2]||" ")+Hn[t][0];break}if(null==s)return void(e._isValid=!1)}if(!o&&null!=s)return void(e._isValid=!1);if(d[4]){if(!Rn.exec(d[4]))return void(e._isValid=!1);r="Z"}e._f=n+(s||"")+(r||""),ct(e)}else e._isValid=!1}function rt(e){var t,i,o,n,s,r,a,d,h={" GMT":" +0000"," EDT":" -0400"," EST":" -0500"," CDT":" -0500"," CST":" -0600"," MDT":" -0600"," MST":" -0700"," PDT":" -0700"," PST":" -0800"},l="YXWVUTSRQPONZABCDEFGHIKLM";if(t=e._i.replace(/\([^\)]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s|\s$/g,""),i=Wn.exec(t)){if(o=i[1]?"ddd"+(5===i[1].length?", ":" "):"",n="D MMM "+(i[2].length>10?"YYYY ":"YY "),s="HH:mm"+(i[4]?":ss":""),i[1]){var u=new Date(i[2]),c=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"][u.getDay()];if(i[1].substr(0,3)!==c)return p(e).weekdayMismatch=!0,void(e._isValid=!1)}switch(i[5].length){case 2:0===d?a=" +0000":(d=l.indexOf(i[5][1].toUpperCase())-12,a=(d<0?" -":" +")+(""+d).replace(/^-?/,"0").match(/..$/)[0]+"00");break;case 4:a=h[i[5]];break;default:a=h[" GMT"]}i[5]=a,e._i=i.splice(1).join(""),r=" ZZ",e._f=o+n+s+r,ct(e),p(e).rfc2822=!0}else e._isValid=!1}function at(e){var i=Ln.exec(e._i);return null!==i?void(e._d=new Date(+i[1])):(st(e),void(e._isValid===!1&&(delete e._isValid,rt(e),e._isValid===!1&&(delete e._isValid,t.createFromInputFallback(e)))))}function dt(e,t,i){return null!=e?e:null!=t?t:i}function ht(e){var i=new Date(t.now());return e._useUTC?[i.getUTCFullYear(),i.getUTCMonth(),i.getUTCDate()]:[i.getFullYear(),i.getMonth(),i.getDate()]}function lt(e){var t,i,o,n,s=[];if(!e._d){for(o=ht(e),e._w&&null==e._a[hn]&&null==e._a[dn]&&ut(e),null!=e._dayOfYear&&(n=dt(e._a[an],o[an]),(e._dayOfYear>ge(n)||0===e._dayOfYear)&&(p(e)._overflowDayOfYear=!0),i=_e(n,0,e._dayOfYear),e._a[dn]=i.getUTCMonth(),e._a[hn]=i.getUTCDate()),t=0;t<3&&null==e._a[t];++t)e._a[t]=s[t]=o[t];for(;t<7;t++)e._a[t]=s[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[ln]&&0===e._a[un]&&0===e._a[cn]&&0===e._a[fn]&&(e._nextDay=!0,e._a[ln]=0),e._d=(e._useUTC?_e:be).apply(null,s),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[ln]=24)}}function ut(e){var t,i,o,n,s,r,a,d;if(t=e._w,null!=t.GG||null!=t.W||null!=t.E)s=1,r=4,i=dt(t.GG,e._a[an],xe(_t(),1,4).year),o=dt(t.W,1),n=dt(t.E,1),(n<1||n>7)&&(d=!0);else{s=e._locale._week.dow,r=e._locale._week.doy;var h=xe(_t(),s,r);i=dt(t.gg,e._a[an],h.year),o=dt(t.w,h.week),null!=t.d?(n=t.d,(n<0||n>6)&&(d=!0)):null!=t.e?(n=t.e+s,(t.e<0||t.e>6)&&(d=!0)):n=s}o<1||o>Oe(i,s,r)?p(e)._overflowWeeks=!0:null!=d?p(e)._overflowWeekday=!0:(a=ke(i,o,n,s,r),e._a[an]=a.year,e._dayOfYear=a.dayOfYear)}function ct(e){if(e._f===t.ISO_8601)return void st(e);if(e._f===t.RFC_2822)return void rt(e);e._a=[],p(e).empty=!0;var i,o,n,s,r,a=""+e._i,d=a.length,h=0;for(n=Q(e._f,e._locale).match(Ao)||[],i=0;i<n.length;i++)s=n[i],o=(a.match(J(s,e))||[])[0],o&&(r=a.substr(0,a.indexOf(o)),r.length>0&&p(e).unusedInput.push(r),a=a.slice(a.indexOf(o)+o.length),h+=o.length),Ho[s]?(o?p(e).empty=!1:p(e).unusedTokens.push(s),ne(s,o,e)):e._strict&&!o&&p(e).unusedTokens.push(s);p(e).charsLeftOver=d-h,a.length>0&&p(e).unusedInput.push(a),e._a[ln]<=12&&p(e).bigHour===!0&&e._a[ln]>0&&(p(e).bigHour=void 0),p(e).parsedDateParts=e._a.slice(0),p(e).meridiem=e._meridiem,e._a[ln]=ft(e._locale,e._a[ln],e._meridiem),lt(e),nt(e)}function ft(e,t,i){var o;return null==i?t:null!=e.meridiemHour?e.meridiemHour(t,i):null!=e.isPM?(o=e.isPM(i),o&&t<12&&(t+=12),o||12!==t||(t=0),t):t}function pt(e){var t,i,o,n,s;if(0===e._f.length)return p(e).invalidFormat=!0,void(e._d=new Date(NaN));for(n=0;n<e._f.length;n++)s=0,t=y({},e),null!=e._useUTC&&(t._useUTC=e._useUTC),t._f=e._f[n],ct(t),v(t)&&(s+=p(t).charsLeftOver,s+=10*p(t).unusedTokens.length,p(t).score=s,(null==o||s<o)&&(o=s,i=t));u(e,i||t)}function vt(e){if(!e._d){var t=R(e._i);e._a=h([t.year,t.month,t.day||t.date,t.hour,t.minute,t.second,t.millisecond],function(e){return e&&parseInt(e,10)}),lt(e)}}function gt(e){var t=new m(nt(yt(e)));return t._nextDay&&(t.add(1,"d"),t._nextDay=void 0),t}function yt(e){var t=e._i,i=e._f;return e._locale=e._locale||it(e._l),null===t||void 0===i&&""===t?g({nullInput:!0}):("string"==typeof t&&(e._i=t=e._locale.preparse(t)),b(t)?new m(nt(t)):(d(t)?e._d=t:o(i)?pt(e):i?ct(e):mt(e),v(e)||(e._d=null),e))}function mt(e){var i=e._i;r(i)?e._d=new Date(t.now()):d(i)?e._d=new Date(i.valueOf()):"string"==typeof i?at(e):o(i)?(e._a=h(i.slice(0),function(e){return parseInt(e,10)}),lt(e)):n(i)?vt(e):a(i)?e._d=new Date(i):t.createFromInputFallback(e)}function bt(e,t,i,r,a){var d={};return i!==!0&&i!==!1||(r=i,i=void 0),(n(e)&&s(e)||o(e)&&0===e.length)&&(e=void 0),d._isAMomentObject=!0,d._useUTC=d._isUTC=a,d._l=i,d._i=e,d._f=t,d._strict=r,gt(d)}function _t(e,t,i,o){return bt(e,t,i,o,!1)}function wt(e,t){var i,n;if(1===t.length&&o(t[0])&&(t=t[0]),!t.length)return _t();for(i=t[0],n=1;n<t.length;++n)t[n].isValid()&&!t[n][e](i)||(i=t[n]);return i}function kt(){var e=[].slice.call(arguments,0);return wt("isBefore",e)}function xt(){var e=[].slice.call(arguments,0);return wt("isAfter",e)}function Ot(e){for(var t in e)if(qn.indexOf(t)===-1||null!=e[t]&&isNaN(e[t]))return!1;for(var i=!1,o=0;o<qn.length;++o)if(e[qn[o]]){if(i)return!1;parseFloat(e[qn[o]])!==w(e[qn[o]])&&(i=!0)}return!0}function Mt(){return this._isValid}function Et(){return Ut(NaN)}function St(e){var t=R(e),i=t.year||0,o=t.quarter||0,n=t.month||0,s=t.week||0,r=t.day||0,a=t.hour||0,d=t.minute||0,h=t.second||0,l=t.millisecond||0;this._isValid=Ot(t),this._milliseconds=+l+1e3*h+6e4*d+1e3*a*60*60,this._days=+r+7*s,this._months=+n+3*o+12*i,this._data={},this._locale=it(),this._bubble()}function Dt(e){return e instanceof St}function Ct(e){return e<0?Math.round(-1*e)*-1:Math.round(e)}function Tt(e,t){G(e,0,0,function(){var e=this.utcOffset(),i="+";return e<0&&(e=-e,i="-"),i+q(~~(e/60),2)+t+q(~~e%60,2)})}function Pt(e,t){var i=(t||"").match(e);if(null===i)return null;var o=i[i.length-1]||[],n=(o+"").match(Gn)||["-",0,0],s=+(60*n[1])+w(n[2]);return 0===s?0:"+"===n[0]?s:-s}function Ft(e,i){var o,n;return i._isUTC?(o=i.clone(),n=(b(e)||d(e)?e.valueOf():_t(e).valueOf())-o.valueOf(),o._d.setTime(o._d.valueOf()+n),t.updateOffset(o,!1),o):_t(e).local()}function It(e){return 15*-Math.round(e._d.getTimezoneOffset()/15)}function Nt(e,i,o){var n,s=this._offset||0;if(!this.isValid())return null!=e?this:NaN;if(null!=e){if("string"==typeof e){if(e=Pt(tn,e),null===e)return this}else Math.abs(e)<16&&!o&&(e*=60);return!this._isUTC&&i&&(n=It(this)),this._offset=e,this._isUTC=!0,null!=n&&this.add(n,"m"),s!==e&&(!i||this._changeInProgress?Zt(this,Ut(e-s,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,t.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?s:It(this)}function Bt(e,t){return null!=e?("string"!=typeof e&&(e=-e),this.utcOffset(e,t),this):-this.utcOffset()}function zt(e){return this.utcOffset(0,e)}function At(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e&&this.subtract(It(this),"m")),this}function Rt(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if("string"==typeof this._i){var e=Pt(en,this._i);null!=e?this.utcOffset(e):this.utcOffset(0,!0)}return this}function jt(e){return!!this.isValid()&&(e=e?_t(e).utcOffset():0,(this.utcOffset()-e)%60===0)}function Ht(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Lt(){if(!r(this._isDSTShifted))return this._isDSTShifted;var e={};if(y(e,this),e=yt(e),e._a){var t=e._isUTC?c(e._a):_t(e._a);this._isDSTShifted=this.isValid()&&k(e._a,t.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function Wt(){return!!this.isValid()&&!this._isUTC}function Yt(){return!!this.isValid()&&this._isUTC}function Vt(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}function Ut(e,t){var i,o,n,s=e,r=null;return Dt(e)?s={ms:e._milliseconds,d:e._days,M:e._months}:a(e)?(s={},t?s[t]=e:s.milliseconds=e):(r=Xn.exec(e))?(i="-"===r[1]?-1:1,s={y:0,d:w(r[hn])*i,h:w(r[ln])*i,m:w(r[un])*i,s:w(r[cn])*i,ms:w(Ct(1e3*r[fn]))*i}):(r=Kn.exec(e))?(i="-"===r[1]?-1:1,s={y:qt(r[2],i),M:qt(r[3],i),w:qt(r[4],i),d:qt(r[5],i),h:qt(r[6],i),m:qt(r[7],i),s:qt(r[8],i)}):null==s?s={}:"object"==typeof s&&("from"in s||"to"in s)&&(n=Xt(_t(s.from),_t(s.to)),s={},s.ms=n.milliseconds,s.M=n.months),o=new St(s),Dt(e)&&l(e,"_locale")&&(o._locale=e._locale),o}function qt(e,t){var i=e&&parseFloat(e.replace(",","."));return(isNaN(i)?0:i)*t}function Gt(e,t){var i={milliseconds:0,months:0};return i.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(i.months,"M").isAfter(t)&&--i.months,i.milliseconds=+t-+e.clone().add(i.months,"M"),i}function Xt(e,t){var i;return e.isValid()&&t.isValid()?(t=Ft(t,e),e.isBefore(t)?i=Gt(e,t):(i=Gt(t,e),i.milliseconds=-i.milliseconds,i.months=-i.months),i):{milliseconds:0,months:0}}function Kt(e,t){return function(i,o){var n,s;return null===o||isNaN(+o)||(M(t,"moment()."+t+"(period, number) is deprecated. Please use moment()."+t+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),s=i,i=o,o=s),i="string"==typeof i?+i:i,n=Ut(i,o),Zt(this,n,e),this}}function Zt(e,i,o,n){var s=i._milliseconds,r=Ct(i._days),a=Ct(i._months);e.isValid()&&(n=null==n||n,s&&e._d.setTime(e._d.valueOf()+s*o),r&&Y(e,"Date",W(e,"Date")+r*o),a&&le(e,W(e,"Month")+a*o),n&&t.updateOffset(e,r||a))}function Qt(e,t){var i=e.diff(t,"days",!0);return i<-6?"sameElse":i<-1?"lastWeek":i<0?"lastDay":i<1?"sameDay":i<2?"nextDay":i<7?"nextWeek":"sameElse"}function $t(e,i){var o=e||_t(),n=Ft(o,this).startOf("day"),s=t.calendarFormat(this,n)||"sameElse",r=i&&(E(i[s])?i[s].call(this,o):i[s]);return this.format(r||this.localeData().calendar(s,this,_t(o)))}function Jt(){return new m(this)}function ei(e,t){var i=b(e)?e:_t(e);return!(!this.isValid()||!i.isValid())&&(t=A(r(t)?"millisecond":t),"millisecond"===t?this.valueOf()>i.valueOf():i.valueOf()<this.clone().startOf(t).valueOf())}function ti(e,t){var i=b(e)?e:_t(e);return!(!this.isValid()||!i.isValid())&&(t=A(r(t)?"millisecond":t),"millisecond"===t?this.valueOf()<i.valueOf():this.clone().endOf(t).valueOf()<i.valueOf())}function ii(e,t,i,o){return o=o||"()",("("===o[0]?this.isAfter(e,i):!this.isBefore(e,i))&&(")"===o[1]?this.isBefore(t,i):!this.isAfter(t,i))}function oi(e,t){var i,o=b(e)?e:_t(e);return!(!this.isValid()||!o.isValid())&&(t=A(t||"millisecond"),"millisecond"===t?this.valueOf()===o.valueOf():(i=o.valueOf(),this.clone().startOf(t).valueOf()<=i&&i<=this.clone().endOf(t).valueOf()))}function ni(e,t){return this.isSame(e,t)||this.isAfter(e,t)}function si(e,t){return this.isSame(e,t)||this.isBefore(e,t)}function ri(e,t,i){var o,n,s,r;return this.isValid()?(o=Ft(e,this),o.isValid()?(n=6e4*(o.utcOffset()-this.utcOffset()),t=A(t),"year"===t||"month"===t||"quarter"===t?(r=ai(this,o),"quarter"===t?r/=3:"year"===t&&(r/=12)):(s=this-o,r="second"===t?s/1e3:"minute"===t?s/6e4:"hour"===t?s/36e5:"day"===t?(s-n)/864e5:"week"===t?(s-n)/6048e5:s),i?r:_(r)):NaN):NaN}function ai(e,t){var i,o,n=12*(t.year()-e.year())+(t.month()-e.month()),s=e.clone().add(n,"months");return t-s<0?(i=e.clone().add(n-1,"months"),o=(t-s)/(s-i)):(i=e.clone().add(n+1,"months"),o=(t-s)/(i-s)),-(n+o)||0}function di(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function hi(){if(!this.isValid())return null;var e=this.clone().utc();return e.year()<0||e.year()>9999?Z(e,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]"):E(Date.prototype.toISOString)?this.toDate().toISOString():Z(e,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]")}function li(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var e="moment",t="";this.isLocal()||(e=0===this.utcOffset()?"moment.utc":"moment.parseZone",t="Z");var i="["+e+'("]',o=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",n="-MM-DD[T]HH:mm:ss.SSS",s=t+'[")]';return this.format(i+o+n+s)}function ui(e){e||(e=this.isUtc()?t.defaultFormatUtc:t.defaultFormat);var i=Z(this,e);return this.localeData().postformat(i)}function ci(e,t){return this.isValid()&&(b(e)&&e.isValid()||_t(e).isValid())?Ut({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function fi(e){return this.from(_t(),e)}function pi(e,t){return this.isValid()&&(b(e)&&e.isValid()||_t(e).isValid())?Ut({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function vi(e){return this.to(_t(),e)}function gi(e){var t;return void 0===e?this._locale._abbr:(t=it(e),null!=t&&(this._locale=t),this)}function yi(){return this._locale}function mi(e){switch(e=A(e)){case"year":this.month(0);case"quarter":case"month":this.date(1);case"week":case"isoWeek":case"day":case"date":this.hours(0);case"hour":this.minutes(0);case"minute":this.seconds(0);case"second":this.milliseconds(0)}return"week"===e&&this.weekday(0),"isoWeek"===e&&this.isoWeekday(1),"quarter"===e&&this.month(3*Math.floor(this.month()/3)),this}function bi(e){return e=A(e),void 0===e||"millisecond"===e?this:("date"===e&&(e="day"),this.startOf(e).add(1,"isoWeek"===e?"week":e).subtract(1,"ms"))}function _i(){return this._d.valueOf()-6e4*(this._offset||0)}function wi(){return Math.floor(this.valueOf()/1e3)}function ki(){return new Date(this.valueOf())}function xi(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]}function Oi(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}}function Mi(){return this.isValid()?this.toISOString():null}function Ei(){return v(this)}function Si(){return u({},p(this))}function Di(){return p(this).overflow}function Ci(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function Ti(e,t){G(0,[e,e.length],0,t)}function Pi(e){return Bi.call(this,e,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function Fi(e){return Bi.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)}function Ii(){return Oe(this.year(),1,4)}function Ni(){var e=this.localeData()._week;return Oe(this.year(),e.dow,e.doy)}function Bi(e,t,i,o,n){var s;return null==e?xe(this,o,n).year:(s=Oe(e,o,n),t>s&&(t=s),zi.call(this,e,t,i,o,n))}function zi(e,t,i,o,n){var s=ke(e,t,i,o,n),r=_e(s.year,0,s.dayOfYear);return this.year(r.getUTCFullYear()),this.month(r.getUTCMonth()),this.date(r.getUTCDate()),this}function Ai(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)}function Ri(e){var t=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==e?t:this.add(e-t,"d")}function ji(e,t){t[fn]=w(1e3*("0."+e))}function Hi(){return this._isUTC?"UTC":""}function Li(){return this._isUTC?"Coordinated Universal Time":""}function Wi(e){return _t(1e3*e)}function Yi(){return _t.apply(null,arguments).parseZone()}function Vi(e){return e}function Ui(e,t,i,o){var n=it(),s=c().set(o,t);return n[i](s,e)}function qi(e,t,i){if(a(e)&&(t=e,e=void 0),e=e||"",null!=t)return Ui(e,t,i,"month");var o,n=[];for(o=0;o<12;o++)n[o]=Ui(e,o,i,"month");return n}function Gi(e,t,i,o){"boolean"==typeof e?(a(t)&&(i=t,t=void 0),t=t||""):(t=e,i=t,
e=!1,a(t)&&(i=t,t=void 0),t=t||"");var n=it(),s=e?n._week.dow:0;if(null!=i)return Ui(t,(i+s)%7,o,"day");var r,d=[];for(r=0;r<7;r++)d[r]=Ui(t,(r+s)%7,o,"day");return d}function Xi(e,t){return qi(e,t,"months")}function Ki(e,t){return qi(e,t,"monthsShort")}function Zi(e,t,i){return Gi(e,t,i,"weekdays")}function Qi(e,t,i){return Gi(e,t,i,"weekdaysShort")}function $i(e,t,i){return Gi(e,t,i,"weekdaysMin")}function Ji(){var e=this._data;return this._milliseconds=rs(this._milliseconds),this._days=rs(this._days),this._months=rs(this._months),e.milliseconds=rs(e.milliseconds),e.seconds=rs(e.seconds),e.minutes=rs(e.minutes),e.hours=rs(e.hours),e.months=rs(e.months),e.years=rs(e.years),this}function eo(e,t,i,o){var n=Ut(t,i);return e._milliseconds+=o*n._milliseconds,e._days+=o*n._days,e._months+=o*n._months,e._bubble()}function to(e,t){return eo(this,e,t,1)}function io(e,t){return eo(this,e,t,-1)}function oo(e){return e<0?Math.floor(e):Math.ceil(e)}function no(){var e,t,i,o,n,s=this._milliseconds,r=this._days,a=this._months,d=this._data;return s>=0&&r>=0&&a>=0||s<=0&&r<=0&&a<=0||(s+=864e5*oo(ro(a)+r),r=0,a=0),d.milliseconds=s%1e3,e=_(s/1e3),d.seconds=e%60,t=_(e/60),d.minutes=t%60,i=_(t/60),d.hours=i%24,r+=_(i/24),n=_(so(r)),a+=n,r-=oo(ro(n)),o=_(a/12),a%=12,d.days=r,d.months=a,d.years=o,this}function so(e){return 4800*e/146097}function ro(e){return 146097*e/4800}function ao(e){if(!this.isValid())return NaN;var t,i,o=this._milliseconds;if(e=A(e),"month"===e||"year"===e)return t=this._days+o/864e5,i=this._months+so(t),"month"===e?i:i/12;switch(t=this._days+Math.round(ro(this._months)),e){case"week":return t/7+o/6048e5;case"day":return t+o/864e5;case"hour":return 24*t+o/36e5;case"minute":return 1440*t+o/6e4;case"second":return 86400*t+o/1e3;case"millisecond":return Math.floor(864e5*t)+o;default:throw new Error("Unknown unit "+e)}}function ho(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*w(this._months/12):NaN}function lo(e){return function(){return this.as(e)}}function uo(e){return e=A(e),this.isValid()?this[e+"s"]():NaN}function co(e){return function(){return this.isValid()?this._data[e]:NaN}}function fo(){return _(this.days()/7)}function po(e,t,i,o,n){return n.relativeTime(t||1,!!i,e,o)}function vo(e,t,i){var o=Ut(e).abs(),n=ks(o.as("s")),s=ks(o.as("m")),r=ks(o.as("h")),a=ks(o.as("d")),d=ks(o.as("M")),h=ks(o.as("y")),l=n<=xs.ss&&["s",n]||n<xs.s&&["ss",n]||s<=1&&["m"]||s<xs.m&&["mm",s]||r<=1&&["h"]||r<xs.h&&["hh",r]||a<=1&&["d"]||a<xs.d&&["dd",a]||d<=1&&["M"]||d<xs.M&&["MM",d]||h<=1&&["y"]||["yy",h];return l[2]=t,l[3]=+e>0,l[4]=i,po.apply(null,l)}function go(e){return void 0===e?ks:"function"==typeof e&&(ks=e,!0)}function yo(e,t){return void 0!==xs[e]&&(void 0===t?xs[e]:(xs[e]=t,"s"===e&&(xs.ss=t-1),!0))}function mo(e){if(!this.isValid())return this.localeData().invalidDate();var t=this.localeData(),i=vo(this,!e,t);return e&&(i=t.pastFuture(+this,i)),t.postformat(i)}function bo(){if(!this.isValid())return this.localeData().invalidDate();var e,t,i,o=Os(this._milliseconds)/1e3,n=Os(this._days),s=Os(this._months);e=_(o/60),t=_(e/60),o%=60,e%=60,i=_(s/12),s%=12;var r=i,a=s,d=n,h=t,l=e,u=o,c=this.asSeconds();return c?(c<0?"-":"")+"P"+(r?r+"Y":"")+(a?a+"M":"")+(d?d+"D":"")+(h||l||u?"T":"")+(h?h+"H":"")+(l?l+"M":"")+(u?u+"S":""):"P0D"}var _o,wo;wo=Array.prototype.some?Array.prototype.some:function(e){for(var t=Object(this),i=t.length>>>0,o=0;o<i;o++)if(o in t&&e.call(this,t[o],o,t))return!0;return!1};var ko=wo,xo=t.momentProperties=[],Oo=!1,Mo={};t.suppressDeprecationWarnings=!1,t.deprecationHandler=null;var Eo;Eo=Object.keys?Object.keys:function(e){var t,i=[];for(t in e)l(e,t)&&i.push(t);return i};var So,Do=Eo,Co={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},To={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},Po="Invalid date",Fo="%d",Io=/\d{1,2}/,No={future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},Bo={},zo={},Ao=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,Ro=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,jo={},Ho={},Lo=/\d/,Wo=/\d\d/,Yo=/\d{3}/,Vo=/\d{4}/,Uo=/[+-]?\d{6}/,qo=/\d\d?/,Go=/\d\d\d\d?/,Xo=/\d\d\d\d\d\d?/,Ko=/\d{1,3}/,Zo=/\d{1,4}/,Qo=/[+-]?\d{1,6}/,$o=/\d+/,Jo=/[+-]?\d+/,en=/Z|[+-]\d\d:?\d\d/gi,tn=/Z|[+-]\d\d(?::?\d\d)?/gi,on=/[+-]?\d+(\.\d{1,3})?/,nn=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,sn={},rn={},an=0,dn=1,hn=2,ln=3,un=4,cn=5,fn=6,pn=7,vn=8;So=Array.prototype.indexOf?Array.prototype.indexOf:function(e){var t;for(t=0;t<this.length;++t)if(this[t]===e)return t;return-1};var gn=So;G("M",["MM",2],"Mo",function(){return this.month()+1}),G("MMM",0,0,function(e){return this.localeData().monthsShort(this,e)}),G("MMMM",0,0,function(e){return this.localeData().months(this,e)}),z("month","M"),j("month",8),$("M",qo),$("MM",qo,Wo),$("MMM",function(e,t){return t.monthsShortRegex(e)}),$("MMMM",function(e,t){return t.monthsRegex(e)}),ie(["M","MM"],function(e,t){t[dn]=w(e)-1}),ie(["MMM","MMMM"],function(e,t,i,o){var n=i._locale.monthsParse(e,o,i._strict);null!=n?t[dn]=n:p(i).invalidMonth=e});var yn=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,mn="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),bn="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),_n=nn,wn=nn;G("Y",0,0,function(){var e=this.year();return e<=9999?""+e:"+"+e}),G(0,["YY",2],0,function(){return this.year()%100}),G(0,["YYYY",4],0,"year"),G(0,["YYYYY",5],0,"year"),G(0,["YYYYYY",6,!0],0,"year"),z("year","y"),j("year",1),$("Y",Jo),$("YY",qo,Wo),$("YYYY",Zo,Vo),$("YYYYY",Qo,Uo),$("YYYYYY",Qo,Uo),ie(["YYYYY","YYYYYY"],an),ie("YYYY",function(e,i){i[an]=2===e.length?t.parseTwoDigitYear(e):w(e)}),ie("YY",function(e,i){i[an]=t.parseTwoDigitYear(e)}),ie("Y",function(e,t){t[an]=parseInt(e,10)}),t.parseTwoDigitYear=function(e){return w(e)+(w(e)>68?1900:2e3)};var kn=L("FullYear",!0);G("w",["ww",2],"wo","week"),G("W",["WW",2],"Wo","isoWeek"),z("week","w"),z("isoWeek","W"),j("week",5),j("isoWeek",5),$("w",qo),$("ww",qo,Wo),$("W",qo),$("WW",qo,Wo),oe(["w","ww","W","WW"],function(e,t,i,o){t[o.substr(0,1)]=w(e)});var xn={dow:0,doy:6};G("d",0,"do","day"),G("dd",0,0,function(e){return this.localeData().weekdaysMin(this,e)}),G("ddd",0,0,function(e){return this.localeData().weekdaysShort(this,e)}),G("dddd",0,0,function(e){return this.localeData().weekdays(this,e)}),G("e",0,0,"weekday"),G("E",0,0,"isoWeekday"),z("day","d"),z("weekday","e"),z("isoWeekday","E"),j("day",11),j("weekday",11),j("isoWeekday",11),$("d",qo),$("e",qo),$("E",qo),$("dd",function(e,t){return t.weekdaysMinRegex(e)}),$("ddd",function(e,t){return t.weekdaysShortRegex(e)}),$("dddd",function(e,t){return t.weekdaysRegex(e)}),oe(["dd","ddd","dddd"],function(e,t,i,o){var n=i._locale.weekdaysParse(e,o,i._strict);null!=n?t.d=n:p(i).invalidWeekday=e}),oe(["d","e","E"],function(e,t,i,o){t[o]=w(e)});var On="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),Mn="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),En="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),Sn=nn,Dn=nn,Cn=nn;G("H",["HH",2],0,"hour"),G("h",["hh",2],0,Ve),G("k",["kk",2],0,Ue),G("hmm",0,0,function(){return""+Ve.apply(this)+q(this.minutes(),2)}),G("hmmss",0,0,function(){return""+Ve.apply(this)+q(this.minutes(),2)+q(this.seconds(),2)}),G("Hmm",0,0,function(){return""+this.hours()+q(this.minutes(),2)}),G("Hmmss",0,0,function(){return""+this.hours()+q(this.minutes(),2)+q(this.seconds(),2)}),qe("a",!0),qe("A",!1),z("hour","h"),j("hour",13),$("a",Ge),$("A",Ge),$("H",qo),$("h",qo),$("k",qo),$("HH",qo,Wo),$("hh",qo,Wo),$("kk",qo,Wo),$("hmm",Go),$("hmmss",Xo),$("Hmm",Go),$("Hmmss",Xo),ie(["H","HH"],ln),ie(["k","kk"],function(e,t,i){var o=w(e);t[ln]=24===o?0:o}),ie(["a","A"],function(e,t,i){i._isPm=i._locale.isPM(e),i._meridiem=e}),ie(["h","hh"],function(e,t,i){t[ln]=w(e),p(i).bigHour=!0}),ie("hmm",function(e,t,i){var o=e.length-2;t[ln]=w(e.substr(0,o)),t[un]=w(e.substr(o)),p(i).bigHour=!0}),ie("hmmss",function(e,t,i){var o=e.length-4,n=e.length-2;t[ln]=w(e.substr(0,o)),t[un]=w(e.substr(o,2)),t[cn]=w(e.substr(n)),p(i).bigHour=!0}),ie("Hmm",function(e,t,i){var o=e.length-2;t[ln]=w(e.substr(0,o)),t[un]=w(e.substr(o))}),ie("Hmmss",function(e,t,i){var o=e.length-4,n=e.length-2;t[ln]=w(e.substr(0,o)),t[un]=w(e.substr(o,2)),t[cn]=w(e.substr(n))});var Tn,Pn=/[ap]\.?m?\.?/i,Fn=L("Hours",!0),In={calendar:Co,longDateFormat:To,invalidDate:Po,ordinal:Fo,dayOfMonthOrdinalParse:Io,relativeTime:No,months:mn,monthsShort:bn,week:xn,weekdays:On,weekdaysMin:En,weekdaysShort:Mn,meridiemParse:Pn},Nn={},Bn={},zn=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,An=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Rn=/Z|[+-]\d\d(?::?\d\d)?/,jn=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],Hn=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Ln=/^\/?Date\((\-?\d+)/i,Wn=/^((?:Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d?\d\s(?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(?:\d\d)?\d\d\s)(\d\d:\d\d)(\:\d\d)?(\s(?:UT|GMT|[ECMP][SD]T|[A-IK-Za-ik-z]|[+-]\d{4}))$/;t.createFromInputFallback=O("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(e){e._d=new Date(e._i+(e._useUTC?" UTC":""))}),t.ISO_8601=function(){},t.RFC_2822=function(){};var Yn=O("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var e=_t.apply(null,arguments);return this.isValid()&&e.isValid()?e<this?this:e:g()}),Vn=O("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var e=_t.apply(null,arguments);return this.isValid()&&e.isValid()?e>this?this:e:g()}),Un=function(){return Date.now?Date.now():+new Date},qn=["year","quarter","month","week","day","hour","minute","second","millisecond"];Tt("Z",":"),Tt("ZZ",""),$("Z",tn),$("ZZ",tn),ie(["Z","ZZ"],function(e,t,i){i._useUTC=!0,i._tzm=Pt(tn,e)});var Gn=/([\+\-]|\d\d)/gi;t.updateOffset=function(){};var Xn=/^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/,Kn=/^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;Ut.fn=St.prototype,Ut.invalid=Et;var Zn=Kt(1,"add"),Qn=Kt(-1,"subtract");t.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",t.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var $n=O("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(e){return void 0===e?this.localeData():this.locale(e)});G(0,["gg",2],0,function(){return this.weekYear()%100}),G(0,["GG",2],0,function(){return this.isoWeekYear()%100}),Ti("gggg","weekYear"),Ti("ggggg","weekYear"),Ti("GGGG","isoWeekYear"),Ti("GGGGG","isoWeekYear"),z("weekYear","gg"),z("isoWeekYear","GG"),j("weekYear",1),j("isoWeekYear",1),$("G",Jo),$("g",Jo),$("GG",qo,Wo),$("gg",qo,Wo),$("GGGG",Zo,Vo),$("gggg",Zo,Vo),$("GGGGG",Qo,Uo),$("ggggg",Qo,Uo),oe(["gggg","ggggg","GGGG","GGGGG"],function(e,t,i,o){t[o.substr(0,2)]=w(e)}),oe(["gg","GG"],function(e,i,o,n){i[n]=t.parseTwoDigitYear(e)}),G("Q",0,"Qo","quarter"),z("quarter","Q"),j("quarter",7),$("Q",Lo),ie("Q",function(e,t){t[dn]=3*(w(e)-1)}),G("D",["DD",2],"Do","date"),z("date","D"),j("date",9),$("D",qo),$("DD",qo,Wo),$("Do",function(e,t){return e?t._dayOfMonthOrdinalParse||t._ordinalParse:t._dayOfMonthOrdinalParseLenient}),ie(["D","DD"],hn),ie("Do",function(e,t){t[hn]=w(e.match(qo)[0],10)});var Jn=L("Date",!0);G("DDD",["DDDD",3],"DDDo","dayOfYear"),z("dayOfYear","DDD"),j("dayOfYear",4),$("DDD",Ko),$("DDDD",Yo),ie(["DDD","DDDD"],function(e,t,i){i._dayOfYear=w(e)}),G("m",["mm",2],0,"minute"),z("minute","m"),j("minute",14),$("m",qo),$("mm",qo,Wo),ie(["m","mm"],un);var es=L("Minutes",!1);G("s",["ss",2],0,"second"),z("second","s"),j("second",15),$("s",qo),$("ss",qo,Wo),ie(["s","ss"],cn);var ts=L("Seconds",!1);G("S",0,0,function(){return~~(this.millisecond()/100)}),G(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),G(0,["SSS",3],0,"millisecond"),G(0,["SSSS",4],0,function(){return 10*this.millisecond()}),G(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),G(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),G(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),G(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),G(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),z("millisecond","ms"),j("millisecond",16),$("S",Ko,Lo),$("SS",Ko,Wo),$("SSS",Ko,Yo);var is;for(is="SSSS";is.length<=9;is+="S")$(is,$o);for(is="S";is.length<=9;is+="S")ie(is,ji);var os=L("Milliseconds",!1);G("z",0,0,"zoneAbbr"),G("zz",0,0,"zoneName");var ns=m.prototype;ns.add=Zn,ns.calendar=$t,ns.clone=Jt,ns.diff=ri,ns.endOf=bi,ns.format=ui,ns.from=ci,ns.fromNow=fi,ns.to=pi,ns.toNow=vi,ns.get=V,ns.invalidAt=Di,ns.isAfter=ei,ns.isBefore=ti,ns.isBetween=ii,ns.isSame=oi,ns.isSameOrAfter=ni,ns.isSameOrBefore=si,ns.isValid=Ei,ns.lang=$n,ns.locale=gi,ns.localeData=yi,ns.max=Vn,ns.min=Yn,ns.parsingFlags=Si,ns.set=U,ns.startOf=mi,ns.subtract=Qn,ns.toArray=xi,ns.toObject=Oi,ns.toDate=ki,ns.toISOString=hi,ns.inspect=li,ns.toJSON=Mi,ns.toString=di,ns.unix=wi,ns.valueOf=_i,ns.creationData=Ci,ns.year=kn,ns.isLeapYear=me,ns.weekYear=Pi,ns.isoWeekYear=Fi,ns.quarter=ns.quarters=Ai,ns.month=ue,ns.daysInMonth=ce,ns.week=ns.weeks=De,ns.isoWeek=ns.isoWeeks=Ce,ns.weeksInYear=Ni,ns.isoWeeksInYear=Ii,ns.date=Jn,ns.day=ns.days=Ae,ns.weekday=Re,ns.isoWeekday=je,ns.dayOfYear=Ri,ns.hour=ns.hours=Fn,ns.minute=ns.minutes=es,ns.second=ns.seconds=ts,ns.millisecond=ns.milliseconds=os,ns.utcOffset=Nt,ns.utc=zt,ns.local=At,ns.parseZone=Rt,ns.hasAlignedHourOffset=jt,ns.isDST=Ht,ns.isLocal=Wt,ns.isUtcOffset=Yt,ns.isUtc=Vt,ns.isUTC=Vt,ns.zoneAbbr=Hi,ns.zoneName=Li,ns.dates=O("dates accessor is deprecated. Use date instead.",Jn),ns.months=O("months accessor is deprecated. Use month instead",ue),ns.years=O("years accessor is deprecated. Use year instead",kn),ns.zone=O("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",Bt),ns.isDSTShifted=O("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",Lt);var ss=C.prototype;ss.calendar=T,ss.longDateFormat=P,ss.invalidDate=F,ss.ordinal=I,ss.preparse=Vi,ss.postformat=Vi,ss.relativeTime=N,ss.pastFuture=B,ss.set=S,ss.months=re,ss.monthsShort=ae,ss.monthsParse=he,ss.monthsRegex=pe,ss.monthsShortRegex=fe,ss.week=Me,ss.firstDayOfYear=Se,ss.firstDayOfWeek=Ee,ss.weekdays=Fe,ss.weekdaysMin=Ne,ss.weekdaysShort=Ie,ss.weekdaysParse=ze,ss.weekdaysRegex=He,ss.weekdaysShortRegex=Le,ss.weekdaysMinRegex=We,ss.isPM=Xe,ss.meridiem=Ke,Je("en",{dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10,i=1===w(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th";return e+i}}),t.lang=O("moment.lang is deprecated. Use moment.locale instead.",Je),t.langData=O("moment.langData is deprecated. Use moment.localeData instead.",it);var rs=Math.abs,as=lo("ms"),ds=lo("s"),hs=lo("m"),ls=lo("h"),us=lo("d"),cs=lo("w"),fs=lo("M"),ps=lo("y"),vs=co("milliseconds"),gs=co("seconds"),ys=co("minutes"),ms=co("hours"),bs=co("days"),_s=co("months"),ws=co("years"),ks=Math.round,xs={ss:44,s:45,m:45,h:22,d:26,M:11},Os=Math.abs,Ms=St.prototype;return Ms.isValid=Mt,Ms.abs=Ji,Ms.add=to,Ms.subtract=io,Ms.as=ao,Ms.asMilliseconds=as,Ms.asSeconds=ds,Ms.asMinutes=hs,Ms.asHours=ls,Ms.asDays=us,Ms.asWeeks=cs,Ms.asMonths=fs,Ms.asYears=ps,Ms.valueOf=ho,Ms._bubble=no,Ms.get=uo,Ms.milliseconds=vs,Ms.seconds=gs,Ms.minutes=ys,Ms.hours=ms,Ms.days=bs,Ms.weeks=fo,Ms.months=_s,Ms.years=ws,Ms.humanize=mo,Ms.toISOString=bo,Ms.toString=bo,Ms.toJSON=bo,Ms.locale=gi,Ms.localeData=yi,Ms.toIsoString=O("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",bo),Ms.lang=$n,G("X",0,0,"unix"),G("x",0,0,"valueOf"),$("x",Jo),$("X",on),ie("X",function(e,t,i){i._d=new Date(1e3*parseFloat(e,10))}),ie("x",function(e,t,i){i._d=new Date(w(e))}),t.version="2.18.1",i(_t),t.fn=ns,t.min=kt,t.max=xt,t.now=Un,t.utc=c,t.unix=Wi,t.months=Xi,t.isDate=d,t.locale=Je,t.invalid=g,t.duration=Ut,t.isMoment=b,t.weekdays=Zi,t.parseZone=Yi,t.localeData=it,t.isDuration=Dt,t.monthsShort=Ki,t.weekdaysMin=$i,t.defineLocale=et,t.updateLocale=tt,t.locales=ot,t.weekdaysShort=Qi,t.normalizeUnits=A,t.relativeTimeRounding=go,t.relativeTimeThreshold=yo,t.calendarFormat=Qt,t.prototype=ns,t})}).call(t,i(84)(e))},function(e,t){e.exports=function(e){return e.webpackPolyfill||(e.deprecate=function(){},e.paths=[],e.children=[],e.webpackPolyfill=1),e}},function(e,t){function i(e){throw new Error("Cannot find module '"+e+"'.")}i.keys=function(){return[]},i.resolve=i,e.exports=i,i.id=85},function(e,t){(function(t){function i(e,t,i){var o=t&&i||0,n=0;for(t=t||[],e.toLowerCase().replace(/[0-9a-f]{2}/g,function(e){n<16&&(t[o+n++]=u[e])});n<16;)t[o+n++]=0;return t}function o(e,t){var i=t||0,o=l;return o[e[i++]]+o[e[i++]]+o[e[i++]]+o[e[i++]]+"-"+o[e[i++]]+o[e[i++]]+"-"+o[e[i++]]+o[e[i++]]+"-"+o[e[i++]]+o[e[i++]]+"-"+o[e[i++]]+o[e[i++]]+o[e[i++]]+o[e[i++]]+o[e[i++]]+o[e[i++]]}function n(e,t,i){var n=t&&i||0,s=t||[];e=e||{};var r=void 0!==e.clockseq?e.clockseq:v,a=void 0!==e.msecs?e.msecs:(new Date).getTime(),d=void 0!==e.nsecs?e.nsecs:y+1,h=a-g+(d-y)/1e4;if(h<0&&void 0===e.clockseq&&(r=r+1&16383),(h<0||a>g)&&void 0===e.nsecs&&(d=0),d>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");g=a,y=d,v=r,a+=122192928e5;var l=(1e4*(268435455&a)+d)%4294967296;s[n++]=l>>>24&255,s[n++]=l>>>16&255,s[n++]=l>>>8&255,s[n++]=255&l;var u=a/4294967296*1e4&268435455;s[n++]=u>>>8&255,s[n++]=255&u,s[n++]=u>>>24&15|16,s[n++]=u>>>16&255,s[n++]=r>>>8|128,s[n++]=255&r;for(var c=e.node||p,f=0;f<6;f++)s[n+f]=c[f];return t?t:o(s)}function s(e,t,i){var n=t&&i||0;"string"==typeof e&&(t="binary"==e?new Array(16):null,e=null),e=e||{};var s=e.random||(e.rng||r)();if(s[6]=15&s[6]|64,s[8]=63&s[8]|128,t)for(var a=0;a<16;a++)t[n+a]=s[a];return t||o(s)}var r,a="undefined"!=typeof window?window:"undefined"!=typeof t?t:null;if(a&&a.crypto&&crypto.getRandomValues){var d=new Uint8Array(16);r=function(){return crypto.getRandomValues(d),d}}if(!r){var h=new Array(16);r=function(){for(var e,t=0;t<16;t++)0===(3&t)&&(e=4294967296*Math.random()),h[t]=e>>>((3&t)<<3)&255;return h}}for(var l=[],u={},c=0;c<256;c++)l[c]=(c+256).toString(16).substr(1),u[l[c]]=c;var f=r(),p=[1|f[0],f[1],f[2],f[3],f[4],f[5]],v=16383&(f[6]<<8|f[7]),g=0,y=0,m=s;m.v1=n,m.v4=s,m.parse=i,m.unparse=o,e.exports=m}).call(t,function(){return this}())},function(e,t){t.prepareElements=function(e){for(var t in e)e.hasOwnProperty(t)&&(e[t].redundant=e[t].used,e[t].used=[])},t.cleanupElements=function(e){for(var t in e)if(e.hasOwnProperty(t)&&e[t].redundant){for(var i=0;i<e[t].redundant.length;i++)e[t].redundant[i].parentNode.removeChild(e[t].redundant[i]);e[t].redundant=[]}},t.resetElements=function(e){t.prepareElements(e),t.cleanupElements(e),t.prepareElements(e)},t.getSVGElement=function(e,t,i){var o;return t.hasOwnProperty(e)?t[e].redundant.length>0?(o=t[e].redundant[0],t[e].redundant.shift()):(o=document.createElementNS("http://www.w3.org/2000/svg",e),i.appendChild(o)):(o=document.createElementNS("http://www.w3.org/2000/svg",e),t[e]={used:[],redundant:[]},i.appendChild(o)),t[e].used.push(o),o},t.getDOMElement=function(e,t,i,o){var n;return t.hasOwnProperty(e)?t[e].redundant.length>0?(n=t[e].redundant[0],t[e].redundant.shift()):(n=document.createElement(e),void 0!==o?i.insertBefore(n,o):i.appendChild(n)):(n=document.createElement(e),t[e]={used:[],redundant:[]},void 0!==o?i.insertBefore(n,o):i.appendChild(n)),t[e].used.push(n),n},t.drawPoint=function(e,i,o,n,s,r){var a;if("circle"==o.style?(a=t.getSVGElement("circle",n,s),a.setAttributeNS(null,"cx",e),a.setAttributeNS(null,"cy",i),a.setAttributeNS(null,"r",.5*o.size)):(a=t.getSVGElement("rect",n,s),a.setAttributeNS(null,"x",e-.5*o.size),a.setAttributeNS(null,"y",i-.5*o.size),a.setAttributeNS(null,"width",o.size),a.setAttributeNS(null,"height",o.size)),void 0!==o.styles&&a.setAttributeNS(null,"style",o.styles),a.setAttributeNS(null,"class",o.className+" vis-point"),r){var d=t.getSVGElement("text",n,s);r.xOffset&&(e+=r.xOffset),r.yOffset&&(i+=r.yOffset),r.content&&(d.textContent=r.content),r.className&&d.setAttributeNS(null,"class",r.className+" vis-label"),d.setAttributeNS(null,"x",e),d.setAttributeNS(null,"y",i)}return a},t.drawBar=function(e,i,o,n,s,r,a,d){if(0!=n){n<0&&(n*=-1,i-=n);var h=t.getSVGElement("rect",r,a);h.setAttributeNS(null,"x",e-.5*o),h.setAttributeNS(null,"y",i),h.setAttributeNS(null,"width",o),h.setAttributeNS(null,"height",n),h.setAttributeNS(null,"class",s),d&&h.setAttributeNS(null,"style",d)}}},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}function n(e,t){if(e&&!Array.isArray(e)&&(t=e,e=null),this._options=t||{},this._data={},this.length=0,this._fieldId=this._options.fieldId||"id",this._type={},this._options.type)for(var i=(0,l.default)(this._options.type),o=0,n=i.length;o<n;o++){var s=i[o],r=this._options.type[s];"Date"==r||"ISODate"==r||"ASPDate"==r?this._type[s]="Date":this._type[s]=r}if(this._options.convert)throw new Error('Option "convert" is deprecated. Use "type" instead.');this._subscribers={},e&&this.add(e),this.setOptions(t)}var s=i(89),r=o(s),a=i(62),d=o(a),h=i(58),l=o(h),u=i(1),c=i(91);n.prototype.setOptions=function(e){e&&void 0!==e.queue&&(e.queue===!1?this._queue&&(this._queue.destroy(),delete this._queue):(this._queue||(this._queue=c.extend(this,{replace:["add","update","remove"]})),"object"===(0,d.default)(e.queue)&&this._queue.setOptions(e.queue)))},n.prototype.on=function(e,t){var i=this._subscribers[e];i||(i=[],this._subscribers[e]=i),i.push({callback:t})},n.prototype.subscribe=function(){throw new Error("DataSet.subscribe is deprecated. Use DataSet.on instead.")},n.prototype.off=function(e,t){var i=this._subscribers[e];i&&(this._subscribers[e]=i.filter(function(e){return e.callback!=t}))},n.prototype.unsubscribe=function(){throw new Error("DataSet.unsubscribe is deprecated. Use DataSet.off instead.")},n.prototype._trigger=function(e,t,i){if("*"==e)throw new Error("Cannot trigger event *");var o=[];e in this._subscribers&&(o=o.concat(this._subscribers[e])),"*"in this._subscribers&&(o=o.concat(this._subscribers["*"]));for(var n=0,s=o.length;n<s;n++){var r=o[n];r.callback&&r.callback(e,t,i||null)}},n.prototype.add=function(e,t){var i,o=[],n=this;if(Array.isArray(e))for(var s=0,r=e.length;s<r;s++)i=n._addItem(e[s]),o.push(i);else{if(!e||"object"!==("undefined"==typeof e?"undefined":(0,d.default)(e)))throw new Error("Unknown dataType");i=n._addItem(e),o.push(i)}return o.length&&this._trigger("add",{items:o},t),o},n.prototype.update=function(e,t){var i=[],o=[],n=[],s=[],r=this,a=r._fieldId,h=function(e){var t=e[a];if(r._data[t]){var d=u.extend({},r._data[t]);t=r._updateItem(e),o.push(t),s.push(e),n.push(d)}else t=r._addItem(e),i.push(t)};if(Array.isArray(e))for(var l=0,c=e.length;l<c;l++)e[l]&&"object"===(0,d.default)(e[l])?h(e[l]):console.warn("Ignoring input item, which is not an object at index "+l);else{if(!e||"object"!==("undefined"==typeof e?"undefined":(0,d.default)(e)))throw new Error("Unknown dataType");h(e)}if(i.length&&this._trigger("add",{items:i},t),o.length){var f={items:o,oldData:n,data:s};this._trigger("update",f,t)}return i.concat(o)},n.prototype.get=function(e){var t,i,o,n=this,s=u.getType(arguments[0]);"String"==s||"Number"==s?(t=arguments[0],o=arguments[1]):"Array"==s?(i=arguments[0],o=arguments[1]):o=arguments[0];var r;if(o&&o.returnType){var a=["Array","Object"];r=a.indexOf(o.returnType)==-1?"Array":o.returnType}else r="Array";var d,h,c,f,p,v=o&&o.type||this._options.type,g=o&&o.filter,y=[];if(void 0!=t)d=n._getItem(t,v),d&&g&&!g(d)&&(d=null);else if(void 0!=i)for(f=0,p=i.length;f<p;f++)d=n._getItem(i[f],v),g&&!g(d)||y.push(d);else for(h=(0,l.default)(this._data),f=0,p=h.length;f<p;f++)c=h[f],d=n._getItem(c,v),g&&!g(d)||y.push(d);if(o&&o.order&&void 0==t&&this._sort(y,o.order),o&&o.fields){var m=o.fields;if(void 0!=t)d=this._filterFields(d,m);else for(f=0,p=y.length;f<p;f++)y[f]=this._filterFields(y[f],m)}if("Object"==r){var b,_={};for(f=0,p=y.length;f<p;f++)b=y[f],_[b.id]=b;return _}return void 0!=t?d:y},n.prototype.getIds=function(e){var t,i,o,n,s,r=this._data,a=e&&e.filter,d=e&&e.order,h=e&&e.type||this._options.type,u=(0,l.default)(r),c=[];if(a)if(d){for(s=[],t=0,i=u.length;t<i;t++)o=u[t],n=this._getItem(o,h),a(n)&&s.push(n);for(this._sort(s,d),t=0,i=s.length;t<i;t++)c.push(s[t][this._fieldId])}else for(t=0,i=u.length;t<i;t++)o=u[t],n=this._getItem(o,h),a(n)&&c.push(n[this._fieldId]);else if(d){for(s=[],t=0,i=u.length;t<i;t++)o=u[t],s.push(r[o]);for(this._sort(s,d),t=0,i=s.length;t<i;t++)c.push(s[t][this._fieldId])}else for(t=0,i=u.length;t<i;t++)o=u[t],n=r[o],c.push(n[this._fieldId]);return c},n.prototype.getDataSet=function(){return this},n.prototype.forEach=function(e,t){var i,o,n,s,r=t&&t.filter,a=t&&t.type||this._options.type,d=this._data,h=(0,l.default)(d);if(t&&t.order){var u=this.get(t);for(i=0,o=u.length;i<o;i++)n=u[i],s=n[this._fieldId],e(n,s)}else for(i=0,o=h.length;i<o;i++)s=h[i],n=this._getItem(s,a),r&&!r(n)||e(n,s)},n.prototype.map=function(e,t){var i,o,n,s,r=t&&t.filter,a=t&&t.type||this._options.type,d=[],h=this._data,u=(0,l.default)(h);for(i=0,o=u.length;i<o;i++)n=u[i],s=this._getItem(n,a),r&&!r(s)||d.push(e(s,n));return t&&t.order&&this._sort(d,t.order),d},n.prototype._filterFields=function(e,t){if(!e)return e;var i,o,n={},s=(0,l.default)(e),r=s.length;if(Array.isArray(t))for(i=0;i<r;i++)o=s[i],t.indexOf(o)!=-1&&(n[o]=e[o]);else for(i=0;i<r;i++)o=s[i],t.hasOwnProperty(o)&&(n[t[o]]=e[o]);return n},n.prototype._sort=function(e,t){if(u.isString(t)){var i=t;e.sort(function(e,t){var o=e[i],n=t[i];return o>n?1:o<n?-1:0})}else{if("function"!=typeof t)throw new TypeError("Order must be a function or a string");e.sort(t)}},n.prototype.remove=function(e,t){var i,o,n,s,r=[],a=[],d=[];for(d=Array.isArray(e)?e:[e],i=0,o=d.length;i<o;i++)s=this._remove(d[i]),s&&(n=s[this._fieldId],void 0!=n&&(r.push(n),a.push(s)));return r.length&&this._trigger("remove",{items:r,oldData:a},t),r},n.prototype._remove=function(e){var t,i;return u.isNumber(e)||u.isString(e)?i=e:e&&"object"===("undefined"==typeof e?"undefined":(0,d.default)(e))&&(i=e[this._fieldId]),void 0!==i&&this._data[i]?(t=this._data[i],delete this._data[i],this.length--,t):null},n.prototype.clear=function(e){var t,i,o=(0,l.default)(this._data),n=[];for(t=0,i=o.length;t<i;t++)n.push(this._data[o[t]]);return this._data={},this.length=0,this._trigger("remove",{items:o,oldData:n},e),o},n.prototype.max=function(e){var t,i,o=this._data,n=(0,l.default)(o),s=null,r=null;for(t=0,i=n.length;t<i;t++){var a=n[t],d=o[a],h=d[e];null!=h&&(!s||h>r)&&(s=d,r=h)}return s},n.prototype.min=function(e){var t,i,o=this._data,n=(0,l.default)(o),s=null,r=null;for(t=0,i=n.length;t<i;t++){var a=n[t],d=o[a],h=d[e];null!=h&&(!s||h<r)&&(s=d,r=h)}return s},n.prototype.distinct=function(e){var t,i,o,n=this._data,s=(0,l.default)(n),r=[],a=this._options.type&&this._options.type[e]||null,d=0;for(t=0,o=s.length;t<o;t++){var h=s[t],c=n[h],f=c[e],p=!1;for(i=0;i<d;i++)if(r[i]==f){p=!0;break}p||void 0===f||(r[d]=f,d++)}if(a)for(t=0,o=r.length;t<o;t++)r[t]=u.convert(r[t],a);return r},n.prototype._addItem=function(e){var t=e[this._fieldId];if(void 0!=t){if(this._data[t])throw new Error("Cannot add item: item with id "+t+" already exists")}else t=u.randomUUID(),e[this._fieldId]=t;var i,o,n={},s=(0,l.default)(e);for(i=0,o=s.length;i<o;i++){var r=s[i],a=this._type[r];n[r]=u.convert(e[r],a)}return this._data[t]=n,this.length++,t},n.prototype._getItem=function(e,t){var i,o,n,s,r=this._data[e];if(!r)return null;var a={},d=(0,l.default)(r);if(t)for(n=0,s=d.length;n<s;n++)i=d[n],o=r[i],a[i]=u.convert(o,t[i]);else for(n=0,s=d.length;n<s;n++)i=d[n],o=r[i],a[i]=o;return a[this._fieldId]||(a[this._fieldId]=r.id),a},n.prototype._updateItem=function(e){var t=e[this._fieldId];if(void 0==t)throw new Error("Cannot update item: item has no id (item: "+(0,r.default)(e)+")");var i=this._data[t];if(!i)throw new Error("Cannot update item: no item with id "+t+" found");for(var o=(0,l.default)(e),n=0,s=o.length;n<s;n++){var a=o[n],d=this._type[a];i[a]=u.convert(e[a],d)}return t},e.exports=n},function(e,t,i){e.exports={default:i(90),__esModule:!0}},function(e,t,i){var o=i(17),n=o.JSON||(o.JSON={stringify:JSON.stringify});e.exports=function(e){return n.stringify.apply(n,arguments)}},function(e,t){function i(e){this.delay=null,this.max=1/0,this._queue=[],this._timeout=null,this._extended=null,this.setOptions(e)}i.prototype.setOptions=function(e){e&&"undefined"!=typeof e.delay&&(this.delay=e.delay),e&&"undefined"!=typeof e.max&&(this.max=e.max),this._flushIfNeeded()},i.extend=function(e,t){var o=new i(t);if(void 0!==e.flush)throw new Error("Target object already has a property flush");e.flush=function(){o.flush()};var n=[{name:"flush",original:void 0}];if(t&&t.replace)for(var s=0;s<t.replace.length;s++){var r=t.replace[s];n.push({name:r,original:e[r]}),o.replace(e,r)}return o._extended={object:e,methods:n},o},i.prototype.destroy=function(){if(this.flush(),this._extended){for(var e=this._extended.object,t=this._extended.methods,i=0;i<t.length;i++){var o=t[i];o.original?e[o.name]=o.original:delete e[o.name]}this._extended=null}},i.prototype.replace=function(e,t){var i=this,o=e[t];if(!o)throw new Error("Method "+t+" undefined");e[t]=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];i.queue({args:e,fn:o,context:this})}},i.prototype.queue=function(e){"function"==typeof e?this._queue.push({fn:e}):this._queue.push(e),this._flushIfNeeded()},i.prototype._flushIfNeeded=function(){if(this._queue.length>this.max&&this.flush(),clearTimeout(this._timeout),this.queue.length>0&&"number"==typeof this.delay){var e=this;this._timeout=setTimeout(function(){e.flush()},this.delay)}},i.prototype.flush=function(){for(;this._queue.length>0;){var e=this._queue.shift();e.fn.apply(e.context||e.fn,e.args||[])}},e.exports=i},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}function n(e,t){this._data=null,this._ids={},this.length=0,this._options=t||{},this._fieldId="id",this._subscribers={};var i=this;this.listener=function(){i._onEvent.apply(i,arguments)},this.setData(e)}var s=i(58),r=o(s),a=i(1),d=i(88);n.prototype.setData=function(e){var t,i,o,n,s;if(this._data){for(this._data.off&&this._data.off("*",this.listener),t=this._data.getIds({filter:this._options&&this._options.filter}),s=[],o=0,n=t.length;o<n;o++)s.push(this._data._data[t[o]]);this._ids={},this.length=0,this._trigger("remove",{items:t,oldData:s})}if(this._data=e,this._data){
for(this._fieldId=this._options.fieldId||this._data&&this._data.options&&this._data.options.fieldId||"id",t=this._data.getIds({filter:this._options&&this._options.filter}),o=0,n=t.length;o<n;o++)i=t[o],this._ids[i]=!0;this.length=t.length,this._trigger("add",{items:t}),this._data.on&&this._data.on("*",this.listener)}},n.prototype.refresh=function(){var e,t,i,o=this._data.getIds({filter:this._options&&this._options.filter}),n=(0,r.default)(this._ids),s={},a=[],d=[],h=[];for(t=0,i=o.length;t<i;t++)e=o[t],s[e]=!0,this._ids[e]||(a.push(e),this._ids[e]=!0);for(t=0,i=n.length;t<i;t++)e=n[t],s[e]||(d.push(e),h.push(this._data._data[e]),delete this._ids[e]);this.length+=a.length-d.length,a.length&&this._trigger("add",{items:a}),d.length&&this._trigger("remove",{items:d,oldData:h})},n.prototype.get=function(e){var t,i,o,n=this,s=a.getType(arguments[0]);"String"==s||"Number"==s||"Array"==s?(t=arguments[0],i=arguments[1],o=arguments[2]):(i=arguments[0],o=arguments[1]);var r=a.extend({},this._options,i);this._options.filter&&i&&i.filter&&(r.filter=function(e){return n._options.filter(e)&&i.filter(e)});var d=[];return void 0!=t&&d.push(t),d.push(r),d.push(o),this._data&&this._data.get.apply(this._data,d)},n.prototype.getIds=function(e){var t;if(this._data){var i,o=this._options.filter;i=e&&e.filter?o?function(t){return o(t)&&e.filter(t)}:e.filter:o,t=this._data.getIds({filter:i,order:e&&e.order})}else t=[];return t},n.prototype.map=function(e,t){var i=[];if(this._data){var o,n=this._options.filter;o=t&&t.filter?n?function(e){return n(e)&&t.filter(e)}:t.filter:n,i=this._data.map(e,{filter:o,order:t&&t.order})}else i=[];return i},n.prototype.getDataSet=function(){for(var e=this;e instanceof n;)e=e._data;return e||null},n.prototype._onEvent=function(e,t,i){var o,n,s,r,a=t&&t.items,d=[],h=[],l=[],u=[],c=[],f=[];if(a&&this._data){switch(e){case"add":for(o=0,n=a.length;o<n;o++)s=a[o],r=this.get(s),r&&(this._ids[s]=!0,d.push(s));break;case"update":for(o=0,n=a.length;o<n;o++)s=a[o],r=this.get(s),r?this._ids[s]?(h.push(s),c.push(t.data[o]),u.push(t.oldData[o])):(this._ids[s]=!0,d.push(s)):this._ids[s]&&(delete this._ids[s],l.push(s),f.push(t.oldData[o]));break;case"remove":for(o=0,n=a.length;o<n;o++)s=a[o],this._ids[s]&&(delete this._ids[s],l.push(s),f.push(t.oldData[o]))}this.length+=d.length-l.length,d.length&&this._trigger("add",{items:d},i),h.length&&this._trigger("update",{items:h,oldData:u,data:c},i),l.length&&this._trigger("remove",{items:l,oldData:f},i)}},n.prototype.on=d.prototype.on,n.prototype.off=d.prototype.off,n.prototype._trigger=d.prototype._trigger,n.prototype.subscribe=n.prototype.on,n.prototype.unsubscribe=n.prototype.off,e.exports=n},function(e,t,i){function o(e,t,i){var n=this;if(!(this instanceof o))throw new SyntaxError("Constructor must be called with the new operator");this.options={},this.defaultOptions={locale:"en",locales:h,clickToUse:!1},s.extend(this.options,this.defaultOptions),this.body={container:e,nodes:{},nodeIndices:[],edges:{},edgeIndices:[],emitter:{on:this.on.bind(this),off:this.off.bind(this),emit:this.emit.bind(this),once:this.once.bind(this)},eventListeners:{onTap:function(){},onTouch:function(){},onDoubleTap:function(){},onHold:function(){},onDragStart:function(){},onDrag:function(){},onDragEnd:function(){},onMouseWheel:function(){},onPinch:function(){},onMouseMove:function(){},onRelease:function(){},onContext:function(){}},data:{nodes:null,edges:null},functions:{createNode:function(){},createEdge:function(){},getPointer:function(){}},modules:{},view:{scale:1,translation:{x:0,y:0}}},this.bindEventListeners(),this.images=new l(function(){return n.body.emitter.emit("_requestRedraw")}),this.groups=new u,this.canvas=new y(this.body),this.selectionHandler=new _(this.body,this.canvas),this.interactionHandler=new b(this.body,this.canvas,this.selectionHandler),this.view=new m(this.body,this.canvas),this.renderer=new g(this.body,this.canvas),this.physics=new p(this.body),this.layoutEngine=new w(this.body),this.clustering=new v(this.body),this.manipulation=new k(this.body,this.canvas,this.selectionHandler),this.nodesHandler=new c(this.body,this.images,this.groups,this.layoutEngine),this.edgesHandler=new f(this.body,this.images,this.groups),this.body.modules.kamadaKawai=new T(this.body,150,.05),this.body.modules.clustering=this.clustering,this.canvas._create(),this.setOptions(i),this.setData(t)}i(94);var n=i(95),s=i(1),r=(i(88),i(92),i(96)),a=i(97),d=i(98),h=i(103),l=i(104).default,u=i(111).default,c=i(112).default,f=i(146).default,p=i(157).default,v=i(166).default,g=i(168).default,y=i(169).default,m=i(171).default,b=i(172).default,_=i(175).default,w=i(155).default,k=i(176).default,x=i(177).default,O=i(145).default,M=i(145),E=M.printStyle,S=i(179),D=S.allOptions,C=S.configureOptions,T=i(180).default;n(o.prototype),o.prototype.setOptions=function(e){var t=this;if(void 0!==e){var i=O.validate(e,D);i===!0&&console.log("%cErrors have been found in the supplied options object.",E);var o=["locale","locales","clickToUse"];if(s.selectiveDeepExtend(o,this.options,e),e=this.layoutEngine.setOptions(e.layout,e),this.canvas.setOptions(e),this.groups.setOptions(e.groups),this.nodesHandler.setOptions(e.nodes),this.edgesHandler.setOptions(e.edges),this.physics.setOptions(e.physics),this.manipulation.setOptions(e.manipulation,e,this.options),this.interactionHandler.setOptions(e.interaction),this.renderer.setOptions(e.interaction),this.selectionHandler.setOptions(e.interaction),void 0!==e.groups&&this.body.emitter.emit("refreshNodes"),"configure"in e&&(this.configurator||(this.configurator=new x(this,this.body.container,C,this.canvas.pixelRatio)),this.configurator.setOptions(e.configure)),this.configurator&&this.configurator.options.enabled===!0){var n={nodes:{},edges:{},layout:{},interaction:{},manipulation:{},physics:{},global:{}};s.deepExtend(n.nodes,this.nodesHandler.options),s.deepExtend(n.edges,this.edgesHandler.options),s.deepExtend(n.layout,this.layoutEngine.options),s.deepExtend(n.interaction,this.selectionHandler.options),s.deepExtend(n.interaction,this.renderer.options),s.deepExtend(n.interaction,this.interactionHandler.options),s.deepExtend(n.manipulation,this.manipulation.options),s.deepExtend(n.physics,this.physics.options),s.deepExtend(n.global,this.canvas.options),s.deepExtend(n.global,this.options),this.configurator.setModuleOptions(n)}void 0!==e.clickToUse?e.clickToUse===!0?void 0===this.activator&&(this.activator=new d(this.canvas.frame),this.activator.on("change",function(){t.body.emitter.emit("activate")})):(void 0!==this.activator&&(this.activator.destroy(),delete this.activator),this.body.emitter.emit("activate")):this.body.emitter.emit("activate"),this.canvas.setSize(),this.body.emitter.emit("startSimulation")}},o.prototype._updateVisibleIndices=function(){var e=this.body.nodes,t=this.body.edges;this.body.nodeIndices=[],this.body.edgeIndices=[];for(var i in e)e.hasOwnProperty(i)&&e[i].options.hidden===!1&&this.body.nodeIndices.push(e[i].id);for(var o in t)t.hasOwnProperty(o)&&t[o].options.hidden===!1&&this.body.edgeIndices.push(t[o].id)},o.prototype.bindEventListeners=function(){var e=this;this.body.emitter.on("_dataChanged",function(){e._updateVisibleIndices(),e.body.emitter.emit("_requestRedraw"),e.body.emitter.emit("_dataUpdated")}),this.body.emitter.on("_dataUpdated",function(){e._updateValueRange(e.body.nodes),e._updateValueRange(e.body.edges),e.body.emitter.emit("startSimulation"),e.body.emitter.emit("_requestRedraw")})},o.prototype.setData=function(e){if(this.body.emitter.emit("resetPhysics"),this.body.emitter.emit("_resetData"),this.selectionHandler.unselectAll(),e&&e.dot&&(e.nodes||e.edges))throw new SyntaxError('Data must contain either parameter "dot" or  parameter pair "nodes" and "edges", but not both.');if(this.setOptions(e&&e.options),e&&e.dot){console.log("The dot property has been deprecated. Please use the static convertDot method to convert DOT into vis.network format and use the normal data format with nodes and edges. This converter is used like this: var data = vis.network.convertDot(dotString);");var t=r.DOTToGraph(e.dot);return void this.setData(t)}if(e&&e.gephi){console.log("The gephi property has been deprecated. Please use the static convertGephi method to convert gephi into vis.network format and use the normal data format with nodes and edges. This converter is used like this: var data = vis.network.convertGephi(gephiJson);");var i=a.parseGephi(e.gephi);return void this.setData(i)}this.nodesHandler.setData(e&&e.nodes,!0),this.edgesHandler.setData(e&&e.edges,!0),this.body.emitter.emit("_dataChanged"),this.body.emitter.emit("_dataLoaded"),this.body.emitter.emit("initPhysics")},o.prototype.destroy=function(){this.body.emitter.emit("destroy"),this.body.emitter.off(),this.off(),delete this.groups,delete this.canvas,delete this.selectionHandler,delete this.interactionHandler,delete this.view,delete this.renderer,delete this.physics,delete this.layoutEngine,delete this.clustering,delete this.manipulation,delete this.nodesHandler,delete this.edgesHandler,delete this.configurator,delete this.images;for(var e in this.body.nodes)delete this.body.nodes[e];for(var t in this.body.edges)delete this.body.edges[t];s.recursiveDOMDelete(this.body.container)},o.prototype._updateValueRange=function(e){var t,i=void 0,o=void 0,n=0;for(t in e)if(e.hasOwnProperty(t)){var s=e[t].getValue();void 0!==s&&(i=void 0===i?s:Math.min(s,i),o=void 0===o?s:Math.max(s,o),n+=s)}if(void 0!==i&&void 0!==o)for(t in e)e.hasOwnProperty(t)&&e[t].setValueRange(i,o,n)},o.prototype.isActive=function(){return!this.activator||this.activator.active},o.prototype.setSize=function(){return this.canvas.setSize.apply(this.canvas,arguments)},o.prototype.canvasToDOM=function(){return this.canvas.canvasToDOM.apply(this.canvas,arguments)},o.prototype.DOMtoCanvas=function(){return this.canvas.DOMtoCanvas.apply(this.canvas,arguments)},o.prototype.findNode=function(){return this.clustering.findNode.apply(this.clustering,arguments)},o.prototype.isCluster=function(){return this.clustering.isCluster.apply(this.clustering,arguments)},o.prototype.openCluster=function(){return this.clustering.openCluster.apply(this.clustering,arguments)},o.prototype.cluster=function(){return this.clustering.cluster.apply(this.clustering,arguments)},o.prototype.getNodesInCluster=function(){return this.clustering.getNodesInCluster.apply(this.clustering,arguments)},o.prototype.clusterByConnection=function(){return this.clustering.clusterByConnection.apply(this.clustering,arguments)},o.prototype.clusterByHubsize=function(){return this.clustering.clusterByHubsize.apply(this.clustering,arguments)},o.prototype.clusterOutliers=function(){return this.clustering.clusterOutliers.apply(this.clustering,arguments)},o.prototype.getSeed=function(){return this.layoutEngine.getSeed.apply(this.layoutEngine,arguments)},o.prototype.enableEditMode=function(){return this.manipulation.enableEditMode.apply(this.manipulation,arguments)},o.prototype.disableEditMode=function(){return this.manipulation.disableEditMode.apply(this.manipulation,arguments)},o.prototype.addNodeMode=function(){return this.manipulation.addNodeMode.apply(this.manipulation,arguments)},o.prototype.editNode=function(){return this.manipulation.editNode.apply(this.manipulation,arguments)},o.prototype.editNodeMode=function(){return console.log("Deprecated: Please use editNode instead of editNodeMode."),this.manipulation.editNode.apply(this.manipulation,arguments)},o.prototype.addEdgeMode=function(){return this.manipulation.addEdgeMode.apply(this.manipulation,arguments)},o.prototype.editEdgeMode=function(){return this.manipulation.editEdgeMode.apply(this.manipulation,arguments)},o.prototype.deleteSelected=function(){return this.manipulation.deleteSelected.apply(this.manipulation,arguments)},o.prototype.getPositions=function(){return this.nodesHandler.getPositions.apply(this.nodesHandler,arguments)},o.prototype.storePositions=function(){return this.nodesHandler.storePositions.apply(this.nodesHandler,arguments)},o.prototype.moveNode=function(){return this.nodesHandler.moveNode.apply(this.nodesHandler,arguments)},o.prototype.getBoundingBox=function(){return this.nodesHandler.getBoundingBox.apply(this.nodesHandler,arguments)},o.prototype.getConnectedNodes=function(e){return void 0!==this.body.nodes[e]?this.nodesHandler.getConnectedNodes.apply(this.nodesHandler,arguments):this.edgesHandler.getConnectedNodes.apply(this.edgesHandler,arguments)},o.prototype.getConnectedEdges=function(){return this.nodesHandler.getConnectedEdges.apply(this.nodesHandler,arguments)},o.prototype.startSimulation=function(){return this.physics.startSimulation.apply(this.physics,arguments)},o.prototype.stopSimulation=function(){return this.physics.stopSimulation.apply(this.physics,arguments)},o.prototype.stabilize=function(){return this.physics.stabilize.apply(this.physics,arguments)},o.prototype.getSelection=function(){return this.selectionHandler.getSelection.apply(this.selectionHandler,arguments)},o.prototype.setSelection=function(){return this.selectionHandler.setSelection.apply(this.selectionHandler,arguments)},o.prototype.getSelectedNodes=function(){return this.selectionHandler.getSelectedNodes.apply(this.selectionHandler,arguments)},o.prototype.getSelectedEdges=function(){return this.selectionHandler.getSelectedEdges.apply(this.selectionHandler,arguments)},o.prototype.getNodeAt=function(){var e=this.selectionHandler.getNodeAt.apply(this.selectionHandler,arguments);return void 0!==e&&void 0!==e.id?e.id:e},o.prototype.getEdgeAt=function(){var e=this.selectionHandler.getEdgeAt.apply(this.selectionHandler,arguments);return void 0!==e&&void 0!==e.id?e.id:e},o.prototype.selectNodes=function(){return this.selectionHandler.selectNodes.apply(this.selectionHandler,arguments)},o.prototype.selectEdges=function(){return this.selectionHandler.selectEdges.apply(this.selectionHandler,arguments)},o.prototype.unselectAll=function(){this.selectionHandler.unselectAll.apply(this.selectionHandler,arguments),this.redraw()},o.prototype.redraw=function(){return this.renderer.redraw.apply(this.renderer,arguments)},o.prototype.getScale=function(){return this.view.getScale.apply(this.view,arguments)},o.prototype.getViewPosition=function(){return this.view.getViewPosition.apply(this.view,arguments)},o.prototype.fit=function(){return this.view.fit.apply(this.view,arguments)},o.prototype.moveTo=function(){return this.view.moveTo.apply(this.view,arguments)},o.prototype.focus=function(){return this.view.focus.apply(this.view,arguments)},o.prototype.releaseNode=function(){return this.view.releaseNode.apply(this.view,arguments)},o.prototype.getOptionsFromConfigurator=function(){var e={};return this.configurator&&(e=this.configurator.getOptions.apply(this.configurator)),e},e.exports=o},function(e,t){"undefined"!=typeof CanvasRenderingContext2D&&(CanvasRenderingContext2D.prototype.circle=function(e,t,i){this.beginPath(),this.arc(e,t,i,0,2*Math.PI,!1),this.closePath()},CanvasRenderingContext2D.prototype.square=function(e,t,i){this.beginPath(),this.rect(e-i,t-i,2*i,2*i),this.closePath()},CanvasRenderingContext2D.prototype.triangle=function(e,t,i){this.beginPath(),i*=1.15,t+=.275*i;var o=2*i,n=o/2,s=Math.sqrt(3)/6*o,r=Math.sqrt(o*o-n*n);this.moveTo(e,t-(r-s)),this.lineTo(e+n,t+s),this.lineTo(e-n,t+s),this.lineTo(e,t-(r-s)),this.closePath()},CanvasRenderingContext2D.prototype.triangleDown=function(e,t,i){this.beginPath(),i*=1.15,t-=.275*i;var o=2*i,n=o/2,s=Math.sqrt(3)/6*o,r=Math.sqrt(o*o-n*n);this.moveTo(e,t+(r-s)),this.lineTo(e+n,t-s),this.lineTo(e-n,t-s),this.lineTo(e,t+(r-s)),this.closePath()},CanvasRenderingContext2D.prototype.star=function(e,t,i){this.beginPath(),i*=.82,t+=.1*i;for(var o=0;o<10;o++){var n=o%2===0?1.3*i:.5*i;this.lineTo(e+n*Math.sin(2*o*Math.PI/10),t-n*Math.cos(2*o*Math.PI/10))}this.closePath()},CanvasRenderingContext2D.prototype.diamond=function(e,t,i){this.beginPath(),this.lineTo(e,t+i),this.lineTo(e+i,t),this.lineTo(e,t-i),this.lineTo(e-i,t),this.closePath()},CanvasRenderingContext2D.prototype.roundRect=function(e,t,i,o,n){var s=Math.PI/180;i-2*n<0&&(n=i/2),o-2*n<0&&(n=o/2),this.beginPath(),this.moveTo(e+n,t),this.lineTo(e+i-n,t),this.arc(e+i-n,t+n,n,270*s,360*s,!1),this.lineTo(e+i,t+o-n),this.arc(e+i-n,t+o-n,n,0,90*s,!1),this.lineTo(e+n,t+o),this.arc(e+n,t+o-n,n,90*s,180*s,!1),this.lineTo(e,t+n),this.arc(e+n,t+n,n,180*s,270*s,!1),this.closePath()},CanvasRenderingContext2D.prototype.ellipse_vis=function(e,t,i,o){var n=.5522848,s=i/2*n,r=o/2*n,a=e+i,d=t+o,h=e+i/2,l=t+o/2;this.beginPath(),this.moveTo(e,l),this.bezierCurveTo(e,l-r,h-s,t,h,t),this.bezierCurveTo(h+s,t,a,l-r,a,l),this.bezierCurveTo(a,l+r,h+s,d,h,d),this.bezierCurveTo(h-s,d,e,l+r,e,l),this.closePath()},CanvasRenderingContext2D.prototype.database=function(e,t,i,o){var n=1/3,s=i,r=o*n,a=.5522848,d=s/2*a,h=r/2*a,l=e+s,u=t+r,c=e+s/2,f=t+r/2,p=t+(o-r/2),v=t+o;this.beginPath(),this.moveTo(l,f),this.bezierCurveTo(l,f+h,c+d,u,c,u),this.bezierCurveTo(c-d,u,e,f+h,e,f),this.bezierCurveTo(e,f-h,c-d,t,c,t),this.bezierCurveTo(c+d,t,l,f-h,l,f),this.lineTo(l,p),this.bezierCurveTo(l,p+h,c+d,v,c,v),this.bezierCurveTo(c-d,v,e,p+h,e,p),this.lineTo(e,f)},CanvasRenderingContext2D.prototype.arrowEndpoint=function(e,t,i,o){var n=e-o*Math.cos(i),s=t-o*Math.sin(i),r=e-.9*o*Math.cos(i),a=t-.9*o*Math.sin(i),d=n+o/3*Math.cos(i+.5*Math.PI),h=s+o/3*Math.sin(i+.5*Math.PI),l=n+o/3*Math.cos(i-.5*Math.PI),u=s+o/3*Math.sin(i-.5*Math.PI);this.beginPath(),this.moveTo(e,t),this.lineTo(d,h),this.lineTo(r,a),this.lineTo(l,u),this.closePath()},CanvasRenderingContext2D.prototype.circleEndpoint=function(e,t,i,o){var n=.4*o,s=e-n*Math.cos(i),r=t-n*Math.sin(i);this.circle(s,r,n)},CanvasRenderingContext2D.prototype.dashedLine=function(e,t,i,o,n){this.beginPath(),this.moveTo(e,t);for(var s=n.length,r=i-e,a=o-t,d=a/r,h=Math.sqrt(r*r+a*a),l=0,u=!0,c=0,f=n[0];h>=.1;)f=n[l++%s],f>h&&(f=h),c=Math.sqrt(f*f/(1+d*d)),c=r<0?-c:c,e+=c,t+=d*c,u===!0?this.lineTo(e,t):this.moveTo(e,t),h-=f,u=!u})},function(e,t){function i(e){if(e)return o(e)}function o(e){for(var t in i.prototype)e[t]=i.prototype[t];return e}e.exports=i,i.prototype.on=i.prototype.addEventListener=function(e,t){return this._callbacks=this._callbacks||{},(this._callbacks[e]=this._callbacks[e]||[]).push(t),this},i.prototype.once=function(e,t){function i(){o.off(e,i),t.apply(this,arguments)}var o=this;return this._callbacks=this._callbacks||{},i.fn=t,this.on(e,i),this},i.prototype.off=i.prototype.removeListener=i.prototype.removeAllListeners=i.prototype.removeEventListener=function(e,t){if(this._callbacks=this._callbacks||{},0==arguments.length)return this._callbacks={},this;var i=this._callbacks[e];if(!i)return this;if(1==arguments.length)return delete this._callbacks[e],this;for(var o,n=0;n<i.length;n++)if(o=i[n],o===t||o.fn===t){i.splice(n,1);break}return this},i.prototype.emit=function(e){this._callbacks=this._callbacks||{};var t=[].slice.call(arguments,1),i=this._callbacks[e];if(i){i=i.slice(0);for(var o=0,n=i.length;o<n;++o)i[o].apply(this,t)}return this},i.prototype.listeners=function(e){return this._callbacks=this._callbacks||{},this._callbacks[e]||[]},i.prototype.hasListeners=function(e){return!!this.listeners(e).length}},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}function n(e){return B=e,v()}function s(){z=0,A=B.charAt(0)}function r(){z++,A=B.charAt(z)}function a(){return B.charAt(z+1)}function d(e){return H.test(e)}function h(e,t){if(e||(e={}),t)for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e}function l(e,t,i){for(var o=t.split("."),n=e;o.length;){var s=o.shift();o.length?(n[s]||(n[s]={}),n=n[s]):n[s]=i}}function u(e,t){for(var i,o,n=null,s=[e],r=e;r.parent;)s.push(r.parent),r=r.parent;if(r.nodes)for(i=0,o=r.nodes.length;i<o;i++)if(t.id===r.nodes[i].id){n=r.nodes[i];break}for(n||(n={id:t.id},e.node&&(n.attr=h(n.attr,e.node))),i=s.length-1;i>=0;i--){var a=s[i];a.nodes||(a.nodes=[]),a.nodes.indexOf(n)===-1&&a.nodes.push(n)}t.attr&&(n.attr=h(n.attr,t.attr))}function c(e,t){if(e.edges||(e.edges=[]),e.edges.push(t),e.edge){var i=h({},e.edge);t.attr=h(i,t.attr)}}function f(e,t,i,o,n){var s={from:t,to:i,type:o};return e.edge&&(s.attr=h({},e.edge)),s.attr=h(s.attr||{},n),s}function p(){for(j=I.NULL,R="";" "===A||"\t"===A||"\n"===A||"\r"===A;)r();do{var e=!1;if("#"===A){for(var t=z-1;" "===B.charAt(t)||"\t"===B.charAt(t);)t--;if("\n"===B.charAt(t)||""===B.charAt(t)){for(;""!=A&&"\n"!=A;)r();e=!0}}if("/"===A&&"/"===a()){for(;""!=A&&"\n"!=A;)r();e=!0}if("/"===A&&"*"===a()){for(;""!=A;){if("*"===A&&"/"===a()){r(),r();break}r()}e=!0}for(;" "===A||"\t"===A||"\n"===A||"\r"===A;)r()}while(e);if(""===A)return void(j=I.DELIMITER);var i=A+a();if(N[i])return j=I.DELIMITER,R=i,r(),void r();if(N[A])return j=I.DELIMITER,R=A,void r();if(d(A)||"-"===A){for(R+=A,r();d(A);)R+=A,r();return"false"===R?R=!1:"true"===R?R=!0:isNaN(Number(R))||(R=Number(R)),void(j=I.IDENTIFIER)}if('"'===A){for(r();""!=A&&('"'!=A||'"'===A&&'"'===a());)'"'===A?(R+=A,r()):"\\"===A&&"n"===a()?(R+="\n",r()):R+=A,r();if('"'!=A)throw x('End of string " expected');return r(),void(j=I.IDENTIFIER)}for(j=I.UNKNOWN;""!=A;)R+=A,r();throw new SyntaxError('Syntax error in part "'+O(R,30)+'"')}function v(){var e={};if(s(),p(),"strict"===R&&(e.strict=!0,p()),"graph"!==R&&"digraph"!==R||(e.type=R,p()),j===I.IDENTIFIER&&(e.id=R,p()),"{"!=R)throw x("Angle bracket { expected");if(p(),g(e),"}"!=R)throw x("Angle bracket } expected");if(p(),""!==R)throw x("End of file expected");return p(),delete e.node,delete e.edge,delete e.graph,e}function g(e){for(;""!==R&&"}"!=R;)y(e),";"===R&&p()}function y(e){var t=m(e);if(t)return void w(e,t);var i=b(e);if(!i){if(j!=I.IDENTIFIER)throw x("Identifier expected");var o=R;if(p(),"="===R){if(p(),j!=I.IDENTIFIER)throw x("Identifier expected");e[o]=R,p()}else _(e,o)}}function m(e){var t=null;if("subgraph"===R&&(t={},t.type="subgraph",p(),j===I.IDENTIFIER&&(t.id=R,p())),"{"===R){if(p(),t||(t={}),t.parent=e,t.node=e.node,t.edge=e.edge,t.graph=e.graph,g(t),"}"!=R)throw x("Angle bracket } expected");p(),delete t.node,delete t.edge,delete t.graph,delete t.parent,e.subgraphs||(e.subgraphs=[]),e.subgraphs.push(t)}return t}function b(e){return"node"===R?(p(),e.node=k(),"node"):"edge"===R?(p(),e.edge=k(),"edge"):"graph"===R?(p(),e.graph=k(),"graph"):null}function _(e,t){var i={id:t},o=k();o&&(i.attr=o),u(e,i),w(e,t)}function w(e,t){for(;"->"===R||"--"===R;){var i,o=R;p();var n=m(e);if(n)i=n;else{if(j!=I.IDENTIFIER)throw x("Identifier or subgraph expected");i=R,u(e,{id:i}),p()}var s=k(),r=f(e,t,i,o,s);c(e,r),t=i}}function k(){for(var e=null;"["===R;){for(p(),e={};""!==R&&"]"!=R;){if(j!=I.IDENTIFIER)throw x("Attribute name expected");var t=R;if(p(),"="!=R)throw x("Equal sign = expected");if(p(),j!=I.IDENTIFIER)throw x("Attribute value expected");var i=R;l(e,t,i),p(),","==R&&p()}if("]"!=R)throw x("Bracket ] expected");p()}return e}function x(e){return new SyntaxError(e+', got "'+O(R,30)+'" (char '+z+")")}function O(e,t){return e.length<=t?e:e.substr(0,27)+"..."}function M(e,t,i){Array.isArray(e)?e.forEach(function(e){Array.isArray(t)?t.forEach(function(t){i(e,t)}):i(e,t)}):Array.isArray(t)?t.forEach(function(t){i(e,t)}):i(e,t)}function E(e,t,i){for(var o=t.split("."),n=o.pop(),s=e,r=0;r<o.length;r++){var a=o[r];a in s||(s[a]={}),s=s[a]}return s[n]=i,e}function S(e,t){var i={};for(var o in e)if(e.hasOwnProperty(o)){var n=t[o];Array.isArray(n)?n.forEach(function(t){E(i,t,e[o])}):"string"==typeof n?E(i,n,e[o]):E(i,o,e[o])}return i}function D(e){var t=n(e),i={nodes:[],edges:[],options:{}};if(t.nodes&&t.nodes.forEach(function(e){var t={id:e.id,label:String(e.label||e.id)};h(t,S(e.attr,P)),t.image&&(t.shape="image"),i.nodes.push(t)}),t.edges){var o=function(e){var t={from:e.from,to:e.to};return h(t,S(e.attr,F)),t.arrows="->"===e.type?"to":void 0,t};t.edges.forEach(function(e){var t,n;t=e.from instanceof Object?e.from.nodes:{id:e.from},n=e.to instanceof Object?e.to.nodes:{id:e.to},e.from instanceof Object&&e.from.edges&&e.from.edges.forEach(function(e){var t=o(e);i.edges.push(t)}),M(t,n,function(t,n){var s=f(i,t.id,n.id,e.type,e.attr),r=o(s);i.edges.push(r)}),e.to instanceof Object&&e.to.edges&&e.to.edges.forEach(function(e){var t=o(e);i.edges.push(t)})})}return t.attr&&(i.options=t.attr),i}var C=i(55),T=o(C),P={fontsize:"font.size",fontcolor:"font.color",labelfontcolor:"font.color",fontname:"font.face",color:["color.border","color.background"],fillcolor:"color.background",tooltip:"title",labeltooltip:"title"},F=(0,T.default)(P);F.color="color.color";var I={NULL:0,DELIMITER:1,IDENTIFIER:2,UNKNOWN:3},N={"{":!0,"}":!0,"[":!0,"]":!0,";":!0,"=":!0,",":!0,"->":!0,"--":!0},B="",z=0,A="",R="",j=I.NULL,H=/[a-zA-Z_0-9.:#]/;t.parseDOT=n,t.DOTToGraph=D},function(e,t){function i(e,t){var i=[],o=[],n={edges:{inheritColor:!1},nodes:{fixed:!1,parseColor:!1}};void 0!==t&&(void 0!==t.fixed&&(n.nodes.fixed=t.fixed),void 0!==t.parseColor&&(n.nodes.parseColor=t.parseColor),void 0!==t.inheritColor&&(n.edges.inheritColor=t.inheritColor));for(var s=e.edges,r=e.nodes,a=0;a<s.length;a++){var d={},h=s[a];d.id=h.id,d.from=h.source,d.to=h.target,d.attributes=h.attributes,d.label=h.label,d.title=void 0!==h.attributes?h.attributes.title:void 0,"Directed"===h.type&&(d.arrows="to"),h.color&&n.inheritColor===!1&&(d.color=h.color),i.push(d)}for(var a=0;a<r.length;a++){var l={},u=r[a];l.id=u.id,l.attributes=u.attributes,l.x=u.x,l.y=u.y,l.label=u.label,l.title=void 0!==u.attributes?u.attributes.title:u.title,n.nodes.parseColor===!0?l.color=u.color:l.color=void 0!==u.color?{background:u.color,border:u.color,highlight:{background:u.color,border:u.color},hover:{background:u.color,border:u.color}}:void 0,l.size=u.size,l.fixed=n.nodes.fixed&&void 0!==u.x&&void 0!==u.y,o.push(l)}return{nodes:o,edges:i}}t.parseGephi=i},function(e,t,i){function o(e){this.active=!1,this.dom={container:e},this.dom.overlay=document.createElement("div"),this.dom.overlay.className="vis-overlay",this.dom.container.appendChild(this.dom.overlay),this.hammer=a(this.dom.overlay),this.hammer.on("tap",this._onTapOverlay.bind(this));var t=this,i=["tap","doubletap","press","pinch","pan","panstart","panmove","panend"];i.forEach(function(e){t.hammer.on(e,function(e){e.stopPropagation()})}),document&&document.body&&(this.onClick=function(i){n(i.target,e)||t.deactivate()},document.body.addEventListener("click",this.onClick)),void 0!==this.keycharm&&this.keycharm.destroy(),this.keycharm=s(),this.escListener=this.deactivate.bind(this)}function n(e,t){for(;e;){if(e===t)return!0;e=e.parentNode}return!1}var s=i(99),r=i(95),a=i(100),d=i(1);r(o.prototype),o.current=null,o.prototype.destroy=function(){this.deactivate(),this.dom.overlay.parentNode.removeChild(this.dom.overlay),this.onClick&&document.body.removeEventListener("click",this.onClick),this.hammer.destroy(),this.hammer=null},o.prototype.activate=function(){o.current&&o.current.deactivate(),o.current=this,this.active=!0,this.dom.overlay.style.display="none",d.addClassName(this.dom.container,"vis-active"),this.emit("change"),this.emit("activate"),this.keycharm.bind("esc",this.escListener)},o.prototype.deactivate=function(){this.active=!1,this.dom.overlay.style.display="",d.removeClassName(this.dom.container,"vis-active"),this.keycharm.unbind("esc",this.escListener),this.emit("change"),this.emit("deactivate")},o.prototype._onTapOverlay=function(e){this.activate(),e.stopPropagation()},e.exports=o},function(e,t,i){var o,n,s;!function(i,r){n=[],o=r,s="function"==typeof o?o.apply(t,n):o,!(void 0!==s&&(e.exports=s))}(this,function(){function e(e){var t,i=e&&e.preventDefault||!1,o=e&&e.container||window,n={},s={keydown:{},keyup:{}},r={};for(t=97;t<=122;t++)r[String.fromCharCode(t)]={code:65+(t-97),shift:!1};for(t=65;t<=90;t++)r[String.fromCharCode(t)]={code:t,shift:!0};for(t=0;t<=9;t++)r[""+t]={code:48+t,shift:!1};for(t=1;t<=12;t++)r["F"+t]={code:111+t,shift:!1};for(t=0;t<=9;t++)r["num"+t]={code:96+t,shift:!1};r["num*"]={code:106,shift:!1},r["num+"]={code:107,shift:!1},r["num-"]={code:109,shift:!1},r["num/"]={code:111,shift:!1},r["num."]={code:110,shift:!1},r.left={code:37,shift:!1},r.up={code:38,shift:!1},r.right={code:39,shift:!1},r.down={code:40,shift:!1},r.space={code:32,shift:!1},r.enter={code:13,shift:!1},r.shift={code:16,shift:void 0},r.esc={code:27,shift:!1},r.backspace={code:8,shift:!1},r.tab={code:9,shift:!1},r.ctrl={code:17,shift:!1},r.alt={code:18,shift:!1},r.delete={code:46,shift:!1},r.pageup={code:33,shift:!1},r.pagedown={code:34,shift:!1},r["="]={code:187,shift:!1},r["-"]={code:189,shift:!1},r["]"]={code:221,shift:!1},r["["]={code:219,shift:!1};var a=function(e){h(e,"keydown")},d=function(e){h(e,"keyup")},h=function(e,t){if(void 0!==s[t][e.keyCode]){for(var o=s[t][e.keyCode],n=0;n<o.length;n++)void 0===o[n].shift?o[n].fn(e):1==o[n].shift&&1==e.shiftKey?o[n].fn(e):0==o[n].shift&&0==e.shiftKey&&o[n].fn(e);1==i&&e.preventDefault()}};return n.bind=function(e,t,i){if(void 0===i&&(i="keydown"),void 0===r[e])throw new Error("unsupported key: "+e);void 0===s[i][r[e].code]&&(s[i][r[e].code]=[]),s[i][r[e].code].push({fn:t,shift:r[e].shift})},n.bindAll=function(e,t){void 0===t&&(t="keydown");for(var i in r)r.hasOwnProperty(i)&&n.bind(i,e,t)},n.getKey=function(e){for(var t in r)if(r.hasOwnProperty(t)){if(1==e.shiftKey&&1==r[t].shift&&e.keyCode==r[t].code)return t;if(0==e.shiftKey&&0==r[t].shift&&e.keyCode==r[t].code)return t;if(e.keyCode==r[t].code&&"shift"==t)return t}return"unknown key, currently not supported"},n.unbind=function(e,t,i){if(void 0===i&&(i="keydown"),void 0===r[e])throw new Error("unsupported key: "+e);if(void 0!==t){var o=[],n=s[i][r[e].code];if(void 0!==n)for(var a=0;a<n.length;a++)n[a].fn==t&&n[a].shift==r[e].shift||o.push(s[i][r[e].code][a]);s[i][r[e].code]=o}else s[i][r[e].code]=[]},n.reset=function(){s={keydown:{},keyup:{}}},n.destroy=function(){s={keydown:{},keyup:{}},o.removeEventListener("keydown",a,!0),o.removeEventListener("keyup",d,!0)},o.addEventListener("keydown",a,!0),o.addEventListener("keyup",d,!0),n}return e})},function(e,t,i){if("undefined"!=typeof window){var o=i(101),n=window.Hammer||i(102);e.exports=o(n,{preventDefault:"mouse"})}else e.exports=function(){throw Error("hammer.js is only available in a browser, not in node.js.")}},function(e,t,i){var o,n,s;!function(i){n=[],o=i,s="function"==typeof o?o.apply(t,n):o,!(void 0!==s&&(e.exports=s))}(function(){var e=null;return function t(i,o){function n(e){return e.match(/[^ ]+/g)}function s(t){if("hammer.input"!==t.type){if(t.srcEvent._handled||(t.srcEvent._handled={}),t.srcEvent._handled[t.type])return;t.srcEvent._handled[t.type]=!0}var i=!1;t.stopPropagation=function(){i=!0};var o=t.srcEvent.stopPropagation.bind(t.srcEvent);"function"==typeof o&&(t.srcEvent.stopPropagation=function(){o(),t.stopPropagation()}),t.firstTarget=e;for(var n=e;n&&!i;){var s=n.hammer;if(s)for(var r,a=0;a<s.length;a++)if(r=s[a]._handlers[t.type])for(var d=0;d<r.length&&!i;d++)r[d](t);n=n.parentNode}}var r=o||{preventDefault:!1};if(i.Manager){var a=i,d=function(e,i){var o=Object.create(r);return i&&a.assign(o,i),t(new a(e,o),o)};return a.assign(d,a),d.Manager=function(e,i){var o=Object.create(r);return i&&a.assign(o,i),t(new a.Manager(e,o),o)},d}var h=Object.create(i),l=i.element;return l.hammer||(l.hammer=[]),l.hammer.push(h),i.on("hammer.input",function(t){r.preventDefault!==!0&&r.preventDefault!==t.pointerType||t.preventDefault(),t.isFirst&&(e=t.target)}),h._handlers={},h.on=function(e,t){return n(e).forEach(function(e){var o=h._handlers[e];o||(h._handlers[e]=o=[],i.on(e,s)),o.push(t)}),h},h.off=function(e,t){return n(e).forEach(function(e){var o=h._handlers[e];o&&(o=t?o.filter(function(e){return e!==t}):[],o.length>0?h._handlers[e]=o:(i.off(e,s),delete h._handlers[e]))}),h},h.emit=function(t,o){e=o.target,i.emit(t,o)},h.destroy=function(){var e=i.element.hammer,t=e.indexOf(h);t!==-1&&e.splice(t,1),e.length||delete i.element.hammer,h._handlers={},i.destroy()},h}})},function(e,t,i){var o;/*! Hammer.JS - v2.0.7 - 2016-04-22
   * http://hammerjs.github.io/
   *
   * Copyright (c) 2016 Jorik Tangelder;
   * Licensed under the MIT license */
!function(n,s,r,a){function d(e,t,i){return setTimeout(f(e,i),t)}function h(e,t,i){return!!Array.isArray(e)&&(l(e,i[t],i),!0)}function l(e,t,i){var o;if(e)if(e.forEach)e.forEach(t,i);else if(e.length!==a)for(o=0;o<e.length;)t.call(i,e[o],o,e),o++;else for(o in e)e.hasOwnProperty(o)&&t.call(i,e[o],o,e)}function u(e,t,i){var o="DEPRECATED METHOD: "+t+"\n"+i+" AT \n";return function(){var t=new Error("get-stack-trace"),i=t&&t.stack?t.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=n.console&&(n.console.warn||n.console.log);return s&&s.call(n.console,o,i),e.apply(this,arguments)}}function c(e,t,i){var o,n=t.prototype;o=e.prototype=Object.create(n),o.constructor=e,o._super=n,i&&ve(o,i)}function f(e,t){return function(){return e.apply(t,arguments)}}function p(e,t){return typeof e==me?e.apply(t?t[0]||a:a,t):e}function v(e,t){return e===a?t:e}function g(e,t,i){l(_(t),function(t){e.addEventListener(t,i,!1)})}function y(e,t,i){l(_(t),function(t){e.removeEventListener(t,i,!1)})}function m(e,t){for(;e;){if(e==t)return!0;e=e.parentNode}return!1}function b(e,t){return e.indexOf(t)>-1}function _(e){return e.trim().split(/\s+/g)}function w(e,t,i){if(e.indexOf&&!i)return e.indexOf(t);for(var o=0;o<e.length;){if(i&&e[o][i]==t||!i&&e[o]===t)return o;o++}return-1}function k(e){return Array.prototype.slice.call(e,0)}function x(e,t,i){for(var o=[],n=[],s=0;s<e.length;){var r=t?e[s][t]:e[s];w(n,r)<0&&o.push(e[s]),n[s]=r,s++}return i&&(o=t?o.sort(function(e,i){return e[t]>i[t]}):o.sort()),o}function O(e,t){for(var i,o,n=t[0].toUpperCase()+t.slice(1),s=0;s<ge.length;){if(i=ge[s],o=i?i+n:t,o in e)return o;s++}return a}function M(){return Oe++}function E(e){var t=e.ownerDocument||e;return t.defaultView||t.parentWindow||n}function S(e,t){var i=this;this.manager=e,this.callback=t,this.element=e.element,this.target=e.options.inputTarget,this.domHandler=function(t){p(e.options.enable,[e])&&i.handler(t)},this.init()}function D(e){var t,i=e.options.inputClass;return new(t=i?i:Se?W:De?U:Ee?G:L)(e,C)}function C(e,t,i){var o=i.pointers.length,n=i.changedPointers.length,s=t&Ne&&o-n===0,r=t&(ze|Ae)&&o-n===0;i.isFirst=!!s,i.isFinal=!!r,s&&(e.session={}),i.eventType=t,T(e,i),e.emit("hammer.input",i),e.recognize(i),e.session.prevInput=i}function T(e,t){var i=e.session,o=t.pointers,n=o.length;i.firstInput||(i.firstInput=I(t)),n>1&&!i.firstMultiple?i.firstMultiple=I(t):1===n&&(i.firstMultiple=!1);var s=i.firstInput,r=i.firstMultiple,a=r?r.center:s.center,d=t.center=N(o);t.timeStamp=we(),t.deltaTime=t.timeStamp-s.timeStamp,t.angle=R(a,d),t.distance=A(a,d),P(i,t),t.offsetDirection=z(t.deltaX,t.deltaY);var h=B(t.deltaTime,t.deltaX,t.deltaY);t.overallVelocityX=h.x,t.overallVelocityY=h.y,t.overallVelocity=_e(h.x)>_e(h.y)?h.x:h.y,t.scale=r?H(r.pointers,o):1,t.rotation=r?j(r.pointers,o):0,t.maxPointers=i.prevInput?t.pointers.length>i.prevInput.maxPointers?t.pointers.length:i.prevInput.maxPointers:t.pointers.length,F(i,t);var l=e.element;m(t.srcEvent.target,l)&&(l=t.srcEvent.target),t.target=l}function P(e,t){var i=t.center,o=e.offsetDelta||{},n=e.prevDelta||{},s=e.prevInput||{};t.eventType!==Ne&&s.eventType!==ze||(n=e.prevDelta={x:s.deltaX||0,y:s.deltaY||0},o=e.offsetDelta={x:i.x,y:i.y}),t.deltaX=n.x+(i.x-o.x),t.deltaY=n.y+(i.y-o.y)}function F(e,t){var i,o,n,s,r=e.lastInterval||t,d=t.timeStamp-r.timeStamp;if(t.eventType!=Ae&&(d>Ie||r.velocity===a)){var h=t.deltaX-r.deltaX,l=t.deltaY-r.deltaY,u=B(d,h,l);o=u.x,n=u.y,i=_e(u.x)>_e(u.y)?u.x:u.y,s=z(h,l),e.lastInterval=t}else i=r.velocity,o=r.velocityX,n=r.velocityY,s=r.direction;t.velocity=i,t.velocityX=o,t.velocityY=n,t.direction=s}function I(e){for(var t=[],i=0;i<e.pointers.length;)t[i]={clientX:be(e.pointers[i].clientX),clientY:be(e.pointers[i].clientY)},i++;return{timeStamp:we(),pointers:t,center:N(t),deltaX:e.deltaX,deltaY:e.deltaY}}function N(e){var t=e.length;if(1===t)return{x:be(e[0].clientX),y:be(e[0].clientY)};for(var i=0,o=0,n=0;n<t;)i+=e[n].clientX,o+=e[n].clientY,n++;return{x:be(i/t),y:be(o/t)}}function B(e,t,i){return{x:t/e||0,y:i/e||0}}function z(e,t){return e===t?Re:_e(e)>=_e(t)?e<0?je:He:t<0?Le:We}function A(e,t,i){i||(i=qe);var o=t[i[0]]-e[i[0]],n=t[i[1]]-e[i[1]];return Math.sqrt(o*o+n*n)}function R(e,t,i){i||(i=qe);var o=t[i[0]]-e[i[0]],n=t[i[1]]-e[i[1]];return 180*Math.atan2(n,o)/Math.PI}function j(e,t){return R(t[1],t[0],Ge)+R(e[1],e[0],Ge)}function H(e,t){return A(t[0],t[1],Ge)/A(e[0],e[1],Ge)}function L(){this.evEl=Ke,this.evWin=Ze,this.pressed=!1,S.apply(this,arguments)}function W(){this.evEl=Je,this.evWin=et,S.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}function Y(){this.evTarget=it,this.evWin=ot,this.started=!1,S.apply(this,arguments)}function V(e,t){var i=k(e.touches),o=k(e.changedTouches);return t&(ze|Ae)&&(i=x(i.concat(o),"identifier",!0)),[i,o]}function U(){this.evTarget=st,this.targetIds={},S.apply(this,arguments)}function q(e,t){var i=k(e.touches),o=this.targetIds;if(t&(Ne|Be)&&1===i.length)return o[i[0].identifier]=!0,[i,i];var n,s,r=k(e.changedTouches),a=[],d=this.target;if(s=i.filter(function(e){return m(e.target,d)}),t===Ne)for(n=0;n<s.length;)o[s[n].identifier]=!0,n++;for(n=0;n<r.length;)o[r[n].identifier]&&a.push(r[n]),t&(ze|Ae)&&delete o[r[n].identifier],n++;return a.length?[x(s.concat(a),"identifier",!0),a]:void 0}function G(){S.apply(this,arguments);var e=f(this.handler,this);this.touch=new U(this.manager,e),this.mouse=new L(this.manager,e),this.primaryTouch=null,this.lastTouches=[]}function X(e,t){e&Ne?(this.primaryTouch=t.changedPointers[0].identifier,K.call(this,t)):e&(ze|Ae)&&K.call(this,t)}function K(e){var t=e.changedPointers[0];if(t.identifier===this.primaryTouch){var i={x:t.clientX,y:t.clientY};this.lastTouches.push(i);var o=this.lastTouches,n=function(){var e=o.indexOf(i);e>-1&&o.splice(e,1)};setTimeout(n,rt)}}function Z(e){for(var t=e.srcEvent.clientX,i=e.srcEvent.clientY,o=0;o<this.lastTouches.length;o++){var n=this.lastTouches[o],s=Math.abs(t-n.x),r=Math.abs(i-n.y);if(s<=at&&r<=at)return!0}return!1}function Q(e,t){this.manager=e,this.set(t)}function $(e){if(b(e,ft))return ft;var t=b(e,pt),i=b(e,vt);return t&&i?ft:t||i?t?pt:vt:b(e,ct)?ct:ut}function J(){if(!ht)return!1;var e={},t=n.CSS&&n.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach(function(i){e[i]=!t||n.CSS.supports("touch-action",i)}),e}function ee(e){this.options=ve({},this.defaults,e||{}),this.id=M(),this.manager=null,this.options.enable=v(this.options.enable,!0),this.state=yt,this.simultaneous={},this.requireFail=[]}function te(e){return e&kt?"cancel":e&_t?"end":e&bt?"move":e&mt?"start":""}function ie(e){return e==We?"down":e==Le?"up":e==je?"left":e==He?"right":""}function oe(e,t){var i=t.manager;return i?i.get(e):e}function ne(){ee.apply(this,arguments)}function se(){ne.apply(this,arguments),this.pX=null,this.pY=null}function re(){ne.apply(this,arguments)}function ae(){ee.apply(this,arguments),this._timer=null,this._input=null}function de(){ne.apply(this,arguments)}function he(){ne.apply(this,arguments)}function le(){ee.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function ue(e,t){return t=t||{},t.recognizers=v(t.recognizers,ue.defaults.preset),new ce(e,t)}function ce(e,t){this.options=ve({},ue.defaults,t||{}),this.options.inputTarget=this.options.inputTarget||e,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=e,this.input=D(this),this.touchAction=new Q(this,this.options.touchAction),fe(this,!0),l(this.options.recognizers,function(e){var t=this.add(new e[0](e[1]));e[2]&&t.recognizeWith(e[2]),e[3]&&t.requireFailure(e[3])},this)}function fe(e,t){var i=e.element;if(i.style){var o;l(e.options.cssProps,function(n,s){o=O(i.style,s),t?(e.oldCssProps[o]=i.style[o],i.style[o]=n):i.style[o]=e.oldCssProps[o]||""}),t||(e.oldCssProps={})}}function pe(e,t){var i=s.createEvent("Event");i.initEvent(e,!0,!0),i.gesture=t,t.target.dispatchEvent(i)}var ve,ge=["","webkit","Moz","MS","ms","o"],ye=s.createElement("div"),me="function",be=Math.round,_e=Math.abs,we=Date.now;ve="function"!=typeof Object.assign?function(e){if(e===a||null===e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),i=1;i<arguments.length;i++){var o=arguments[i];if(o!==a&&null!==o)for(var n in o)o.hasOwnProperty(n)&&(t[n]=o[n])}return t}:Object.assign;var ke=u(function(e,t,i){for(var o=Object.keys(t),n=0;n<o.length;)(!i||i&&e[o[n]]===a)&&(e[o[n]]=t[o[n]]),n++;return e},"extend","Use `assign`."),xe=u(function(e,t){return ke(e,t,!0)},"merge","Use `assign`."),Oe=1,Me=/mobile|tablet|ip(ad|hone|od)|android/i,Ee="ontouchstart"in n,Se=O(n,"PointerEvent")!==a,De=Ee&&Me.test(navigator.userAgent),Ce="touch",Te="pen",Pe="mouse",Fe="kinect",Ie=25,Ne=1,Be=2,ze=4,Ae=8,Re=1,je=2,He=4,Le=8,We=16,Ye=je|He,Ve=Le|We,Ue=Ye|Ve,qe=["x","y"],Ge=["clientX","clientY"];S.prototype={handler:function(){},init:function(){this.evEl&&g(this.element,this.evEl,this.domHandler),this.evTarget&&g(this.target,this.evTarget,this.domHandler),this.evWin&&g(E(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&y(this.element,this.evEl,this.domHandler),this.evTarget&&y(this.target,this.evTarget,this.domHandler),this.evWin&&y(E(this.element),this.evWin,this.domHandler)}};var Xe={mousedown:Ne,mousemove:Be,mouseup:ze},Ke="mousedown",Ze="mousemove mouseup";c(L,S,{handler:function(e){var t=Xe[e.type];t&Ne&&0===e.button&&(this.pressed=!0),t&Be&&1!==e.which&&(t=ze),this.pressed&&(t&ze&&(this.pressed=!1),this.callback(this.manager,t,{pointers:[e],changedPointers:[e],pointerType:Pe,srcEvent:e}))}});var Qe={pointerdown:Ne,pointermove:Be,pointerup:ze,pointercancel:Ae,pointerout:Ae},$e={2:Ce,3:Te,4:Pe,5:Fe},Je="pointerdown",et="pointermove pointerup pointercancel";n.MSPointerEvent&&!n.PointerEvent&&(Je="MSPointerDown",et="MSPointerMove MSPointerUp MSPointerCancel"),c(W,S,{handler:function(e){var t=this.store,i=!1,o=e.type.toLowerCase().replace("ms",""),n=Qe[o],s=$e[e.pointerType]||e.pointerType,r=s==Ce,a=w(t,e.pointerId,"pointerId");n&Ne&&(0===e.button||r)?a<0&&(t.push(e),a=t.length-1):n&(ze|Ae)&&(i=!0),a<0||(t[a]=e,this.callback(this.manager,n,{pointers:t,changedPointers:[e],pointerType:s,srcEvent:e}),i&&t.splice(a,1))}});var tt={touchstart:Ne,touchmove:Be,touchend:ze,touchcancel:Ae},it="touchstart",ot="touchstart touchmove touchend touchcancel";c(Y,S,{handler:function(e){var t=tt[e.type];if(t===Ne&&(this.started=!0),this.started){var i=V.call(this,e,t);t&(ze|Ae)&&i[0].length-i[1].length===0&&(this.started=!1),this.callback(this.manager,t,{pointers:i[0],changedPointers:i[1],pointerType:Ce,srcEvent:e})}}});var nt={touchstart:Ne,touchmove:Be,touchend:ze,touchcancel:Ae},st="touchstart touchmove touchend touchcancel";c(U,S,{handler:function(e){var t=nt[e.type],i=q.call(this,e,t);i&&this.callback(this.manager,t,{pointers:i[0],changedPointers:i[1],pointerType:Ce,srcEvent:e})}});var rt=2500,at=25;c(G,S,{handler:function(e,t,i){var o=i.pointerType==Ce,n=i.pointerType==Pe;if(!(n&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(o)X.call(this,t,i);else if(n&&Z.call(this,i))return;this.callback(e,t,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var dt=O(ye.style,"touchAction"),ht=dt!==a,lt="compute",ut="auto",ct="manipulation",ft="none",pt="pan-x",vt="pan-y",gt=J();Q.prototype={set:function(e){e==lt&&(e=this.compute()),ht&&this.manager.element.style&&gt[e]&&(this.manager.element.style[dt]=e),this.actions=e.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var e=[];return l(this.manager.recognizers,function(t){p(t.options.enable,[t])&&(e=e.concat(t.getTouchAction()))}),$(e.join(" "))},preventDefaults:function(e){var t=e.srcEvent,i=e.offsetDirection;if(this.manager.session.prevented)return void t.preventDefault();var o=this.actions,n=b(o,ft)&&!gt[ft],s=b(o,vt)&&!gt[vt],r=b(o,pt)&&!gt[pt];if(n){var a=1===e.pointers.length,d=e.distance<2,h=e.deltaTime<250;if(a&&d&&h)return}return r&&s?void 0:n||s&&i&Ye||r&&i&Ve?this.preventSrc(t):void 0},preventSrc:function(e){this.manager.session.prevented=!0,e.preventDefault()}};var yt=1,mt=2,bt=4,_t=8,wt=_t,kt=16,xt=32;ee.prototype={defaults:{},set:function(e){return ve(this.options,e),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(e){if(h(e,"recognizeWith",this))return this;var t=this.simultaneous;return e=oe(e,this),t[e.id]||(t[e.id]=e,e.recognizeWith(this)),this},dropRecognizeWith:function(e){return h(e,"dropRecognizeWith",this)?this:(e=oe(e,this),delete this.simultaneous[e.id],this)},requireFailure:function(e){if(h(e,"requireFailure",this))return this;var t=this.requireFail;return e=oe(e,this),w(t,e)===-1&&(t.push(e),e.requireFailure(this)),this},dropRequireFailure:function(e){if(h(e,"dropRequireFailure",this))return this;e=oe(e,this);var t=w(this.requireFail,e);return t>-1&&this.requireFail.splice(t,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(e){return!!this.simultaneous[e.id]},emit:function(e){function t(t){i.manager.emit(t,e)}var i=this,o=this.state;o<_t&&t(i.options.event+te(o)),t(i.options.event),e.additionalEvent&&t(e.additionalEvent),o>=_t&&t(i.options.event+te(o))},tryEmit:function(e){return this.canEmit()?this.emit(e):void(this.state=xt)},canEmit:function(){for(var e=0;e<this.requireFail.length;){if(!(this.requireFail[e].state&(xt|yt)))return!1;e++}return!0},recognize:function(e){var t=ve({},e);return p(this.options.enable,[this,t])?(this.state&(wt|kt|xt)&&(this.state=yt),this.state=this.process(t),void(this.state&(mt|bt|_t|kt)&&this.tryEmit(t))):(this.reset(),void(this.state=xt))},process:function(e){},getTouchAction:function(){},reset:function(){}},c(ne,ee,{defaults:{pointers:1},attrTest:function(e){var t=this.options.pointers;return 0===t||e.pointers.length===t},process:function(e){var t=this.state,i=e.eventType,o=t&(mt|bt),n=this.attrTest(e);return o&&(i&Ae||!n)?t|kt:o||n?i&ze?t|_t:t&mt?t|bt:mt:xt}}),c(se,ne,{defaults:{event:"pan",threshold:10,pointers:1,direction:Ue},getTouchAction:function(){var e=this.options.direction,t=[];return e&Ye&&t.push(vt),e&Ve&&t.push(pt),t},directionTest:function(e){var t=this.options,i=!0,o=e.distance,n=e.direction,s=e.deltaX,r=e.deltaY;return n&t.direction||(t.direction&Ye?(n=0===s?Re:s<0?je:He,i=s!=this.pX,o=Math.abs(e.deltaX)):(n=0===r?Re:r<0?Le:We,i=r!=this.pY,o=Math.abs(e.deltaY))),e.direction=n,i&&o>t.threshold&&n&t.direction},attrTest:function(e){return ne.prototype.attrTest.call(this,e)&&(this.state&mt||!(this.state&mt)&&this.directionTest(e))},emit:function(e){this.pX=e.deltaX,this.pY=e.deltaY;var t=ie(e.direction);t&&(e.additionalEvent=this.options.event+t),this._super.emit.call(this,e)}}),c(re,ne,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[ft]},attrTest:function(e){return this._super.attrTest.call(this,e)&&(Math.abs(e.scale-1)>this.options.threshold||this.state&mt)},emit:function(e){if(1!==e.scale){var t=e.scale<1?"in":"out";e.additionalEvent=this.options.event+t}this._super.emit.call(this,e)}}),c(ae,ee,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[ut]},process:function(e){var t=this.options,i=e.pointers.length===t.pointers,o=e.distance<t.threshold,n=e.deltaTime>t.time;if(this._input=e,!o||!i||e.eventType&(ze|Ae)&&!n)this.reset();else if(e.eventType&Ne)this.reset(),this._timer=d(function(){this.state=wt,this.tryEmit()},t.time,this);else if(e.eventType&ze)return wt;return xt},reset:function(){clearTimeout(this._timer)},emit:function(e){this.state===wt&&(e&&e.eventType&ze?this.manager.emit(this.options.event+"up",e):(this._input.timeStamp=we(),this.manager.emit(this.options.event,this._input)))}}),c(de,ne,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[ft]},attrTest:function(e){return this._super.attrTest.call(this,e)&&(Math.abs(e.rotation)>this.options.threshold||this.state&mt)}}),c(he,ne,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:Ye|Ve,pointers:1},getTouchAction:function(){return se.prototype.getTouchAction.call(this)},attrTest:function(e){var t,i=this.options.direction;return i&(Ye|Ve)?t=e.overallVelocity:i&Ye?t=e.overallVelocityX:i&Ve&&(t=e.overallVelocityY),this._super.attrTest.call(this,e)&&i&e.offsetDirection&&e.distance>this.options.threshold&&e.maxPointers==this.options.pointers&&_e(t)>this.options.velocity&&e.eventType&ze},emit:function(e){var t=ie(e.offsetDirection);t&&this.manager.emit(this.options.event+t,e),this.manager.emit(this.options.event,e)}}),c(le,ee,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[ct]},process:function(e){var t=this.options,i=e.pointers.length===t.pointers,o=e.distance<t.threshold,n=e.deltaTime<t.time;if(this.reset(),e.eventType&Ne&&0===this.count)return this.failTimeout();if(o&&n&&i){if(e.eventType!=ze)return this.failTimeout();var s=!this.pTime||e.timeStamp-this.pTime<t.interval,r=!this.pCenter||A(this.pCenter,e.center)<t.posThreshold;this.pTime=e.timeStamp,this.pCenter=e.center,r&&s?this.count+=1:this.count=1,this._input=e;var a=this.count%t.taps;if(0===a)return this.hasRequireFailures()?(this._timer=d(function(){this.state=wt,this.tryEmit()},t.interval,this),mt):wt}return xt},failTimeout:function(){return this._timer=d(function(){this.state=xt},this.options.interval,this),xt},reset:function(){clearTimeout(this._timer)},emit:function(){this.state==wt&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),ue.VERSION="2.0.7",ue.defaults={domEvents:!1,touchAction:lt,enable:!0,inputTarget:null,inputClass:null,preset:[[de,{enable:!1}],[re,{enable:!1},["rotate"]],[he,{direction:Ye}],[se,{direction:Ye},["swipe"]],[le],[le,{event:"doubletap",taps:2},["tap"]],[ae]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};var Ot=1,Mt=2;ce.prototype={set:function(e){return ve(this.options,e),e.touchAction&&this.touchAction.update(),e.inputTarget&&(this.input.destroy(),this.input.target=e.inputTarget,this.input.init()),this},stop:function(e){this.session.stopped=e?Mt:Ot},recognize:function(e){var t=this.session;if(!t.stopped){this.touchAction.preventDefaults(e);var i,o=this.recognizers,n=t.curRecognizer;(!n||n&&n.state&wt)&&(n=t.curRecognizer=null);for(var s=0;s<o.length;)i=o[s],t.stopped===Mt||n&&i!=n&&!i.canRecognizeWith(n)?i.reset():i.recognize(e),!n&&i.state&(mt|bt|_t)&&(n=t.curRecognizer=i),s++}},get:function(e){if(e instanceof ee)return e;for(var t=this.recognizers,i=0;i<t.length;i++)if(t[i].options.event==e)return t[i];return null},add:function(e){if(h(e,"add",this))return this;var t=this.get(e.options.event);return t&&this.remove(t),this.recognizers.push(e),e.manager=this,this.touchAction.update(),e},remove:function(e){if(h(e,"remove",this))return this;if(e=this.get(e)){var t=this.recognizers,i=w(t,e);i!==-1&&(t.splice(i,1),this.touchAction.update())}return this},on:function(e,t){if(e!==a&&t!==a){var i=this.handlers;return l(_(e),function(e){i[e]=i[e]||[],i[e].push(t)}),this}},off:function(e,t){if(e!==a){var i=this.handlers;return l(_(e),function(e){t?i[e]&&i[e].splice(w(i[e],t),1):delete i[e]}),this}},emit:function(e,t){this.options.domEvents&&pe(e,t);var i=this.handlers[e]&&this.handlers[e].slice();if(i&&i.length){t.type=e,t.preventDefault=function(){t.srcEvent.preventDefault()};for(var o=0;o<i.length;)i[o](t),o++}},destroy:function(){this.element&&fe(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},ve(ue,{INPUT_START:Ne,INPUT_MOVE:Be,INPUT_END:ze,INPUT_CANCEL:Ae,STATE_POSSIBLE:yt,STATE_BEGAN:mt,STATE_CHANGED:bt,STATE_ENDED:_t,STATE_RECOGNIZED:wt,STATE_CANCELLED:kt,STATE_FAILED:xt,DIRECTION_NONE:Re,DIRECTION_LEFT:je,DIRECTION_RIGHT:He,DIRECTION_UP:Le,DIRECTION_DOWN:We,DIRECTION_HORIZONTAL:Ye,DIRECTION_VERTICAL:Ve,DIRECTION_ALL:Ue,Manager:ce,Input:S,TouchAction:Q,TouchInput:U,MouseInput:L,PointerEventInput:W,TouchMouseInput:G,SingleTouchInput:Y,Recognizer:ee,AttrRecognizer:ne,Tap:le,Pan:se,Swipe:he,Pinch:re,Rotate:de,Press:ae,on:g,off:y,each:l,merge:xe,extend:ke,assign:ve,inherit:c,bindFn:f,prefixed:O});var Et="undefined"!=typeof n?n:"undefined"!=typeof self?self:{};Et.Hammer=ue,o=function(){return ue}.call(t,i,t,e),!(o!==a&&(e.exports=o))}(window,document,"Hammer")},function(e,t){t.en={edit:"Edit",del:"Delete selected",back:"Back",addNode:"Add Node",addEdge:"Add Edge",editNode:"Edit Node",editEdge:"Edit Edge",addDescription:"Click in an empty space to place a new node.",edgeDescription:"Click on a node and drag the edge to another node to connect them.",editEdgeDescription:"Click on the control points and drag them to a node to connect to it.",createEdgeError:"Cannot link edges to a cluster.",deleteClusterError:"Clusters cannot be deleted.",editClusterError:"Clusters cannot be edited."},t.en_EN=t.en,t.en_US=t.en,t.de={edit:"Editieren",del:"Lösche Auswahl",back:"Zurück",addNode:"Knoten hinzufügen",addEdge:"Kante hinzufügen",editNode:"Knoten editieren",editEdge:"Kante editieren",addDescription:"Klicke auf eine freie Stelle, um einen neuen Knoten zu plazieren.",edgeDescription:"Klicke auf einen Knoten und ziehe die Kante zu einem anderen Knoten, um diese zu verbinden.",editEdgeDescription:"Klicke auf die Verbindungspunkte und ziehe diese auf einen Knoten, um sie zu verbinden.",createEdgeError:"Es ist nicht möglich, Kanten mit Clustern zu verbinden.",deleteClusterError:"Cluster können nicht gelöscht werden.",editClusterError:"Cluster können nicht editiert werden."},t.de_DE=t.de,t.es={edit:"Editar",del:"Eliminar selección",back:"Átras",addNode:"Añadir nodo",addEdge:"Añadir arista",editNode:"Editar nodo",editEdge:"Editar arista",addDescription:"Haga clic en un lugar vacío para colocar un nuevo nodo.",edgeDescription:"Haga clic en un nodo y arrastre la arista hacia otro nodo para conectarlos.",editEdgeDescription:"Haga clic en un punto de control y arrastrelo a un nodo para conectarlo.",createEdgeError:"No se puede conectar una arista a un grupo.",deleteClusterError:"No es posible eliminar grupos.",editClusterError:"No es posible editar grupos."},t.es_ES=t.es,t.it={edit:"Modifica",del:"Cancella la selezione",back:"Indietro",addNode:"Aggiungi un nodo",addEdge:"Aggiungi un vertice",editNode:"Modifica il nodo",editEdge:"Modifica il vertice",addDescription:"Clicca per aggiungere un nuovo nodo",edgeDescription:"Clicca su un nodo e trascinalo ad un altro nodo per connetterli.",editEdgeDescription:"Clicca sui Punti di controllo e trascinali ad un nodo per connetterli.",createEdgeError:"Non si possono collegare vertici ad un cluster",deleteClusterError:"I cluster non possono essere cancellati",editClusterError:"I clusters non possono essere modificati."},t.it_IT=t.it,t.nl={edit:"Wijzigen",del:"Selectie verwijderen",back:"Terug",addNode:"Node toevoegen",addEdge:"Link toevoegen",editNode:"Node wijzigen",editEdge:"Link wijzigen",addDescription:"Klik op een leeg gebied om een nieuwe node te maken.",edgeDescription:"Klik op een node en sleep de link naar een andere node om ze te verbinden.",editEdgeDescription:"Klik op de verbindingspunten en sleep ze naar een node om daarmee te verbinden.",createEdgeError:"Kan geen link maken naar een cluster.",deleteClusterError:"Clusters kunnen niet worden verwijderd.",editClusterError:"Clusters kunnen niet worden aangepast."},t.nl_NL=t.nl,t.nl_BE=t.nl,t["pt-br"]={edit:"Editar",del:"Remover selecionado",back:"Voltar",addNode:"Adicionar nó",addEdge:"Adicionar aresta",editNode:"Editar nó",editEdge:"Editar aresta",addDescription:"Clique em um espaço em branco para adicionar um novo nó",edgeDescription:"Clique em um nó e arraste a aresta até outro nó para conectá-los",editEdgeDescription:"Clique nos pontos de controle e os arraste para um nó para conectá-los",createEdgeError:"Não foi possível linkar arestas a um cluster.",deleteClusterError:"Clusters não puderam ser removidos.",editClusterError:"Clusters não puderam ser editados."},t["pt-BR"]=t["pt-br"],t.pt_BR=t["pt-br"],t.pt_br=t["pt-br"],t.ru={edit:"Редактировать",del:"Удалить выбранное",back:"Назад",addNode:"Добавить узел",addEdge:"Добавить ребро",editNode:"Редактировать узел",editEdge:"Редактировать ребро",addDescription:"Кликните в свободное место, чтобы добавить новый узел.",edgeDescription:"Кликните на узел и протяните ребро к другому узлу, чтобы соединить их.",editEdgeDescription:"Кликните на контрольные точки и перетащите их в узел, чтобы подключиться к нему.",createEdgeError:"Невозможно соединить ребра в кластер.",deleteClusterError:"Кластеры не могут быть удалены",editClusterError:"Кластеры недоступны для редактирования."},t.ru_RU=t.ru},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=i(110),h=o(d),l=function(){function e(t){(0,s.default)(this,e),this.images={},this.imageBroken={},this.callback=t}return(0,a.default)(e,[{key:"_tryloadBrokenUrl",value:function(e,t,i){if(void 0!==e&&void 0!==i){if(void 0===t)return void console.warn("No broken url image defined");i.onerror=function(){console.error("Could not load brokenImage:",t)},i.image.src=t}}},{key:"_redrawWithImage",value:function(e){this.callback&&this.callback(e)}},{key:"load",value:function(e,t,i){var o=this,n=this.images[e];if(n)return n;var s=new h.default;return this.images[e]=s,s.image.onload=function(){o._fixImageCoordinates(s.image),s.init(),o._redrawWithImage(s)},s.image.onerror=function(){console.error("Could not load image:",e),o._tryloadBrokenUrl(e,t,s)},s.image.src=e,s}},{key:"_fixImageCoordinates",value:function(e){0===e.width&&(document.body.appendChild(e),e.width=e.offsetWidth,e.height=e.offsetHeight,document.body.removeChild(e))}}]),e}();t.default=l},function(e,t){t.__esModule=!0,t.default=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}t.__esModule=!0;var n=i(107),s=o(n);t.default=function(){function e(e,t){for(var i=0;i<t.length;i++){var o=t[i];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),(0,s.default)(e,o.key,o)}}return function(t,i,o){return i&&e(t.prototype,i),o&&e(t,o),t}}()},function(e,t,i){e.exports={default:i(108),__esModule:!0}},function(e,t,i){i(109);var o=i(17).Object;e.exports=function(e,t,i){return o.defineProperty(e,t,i)}},function(e,t,i){var o=i(15);o(o.S+o.F*!i(25),"Object",{defineProperty:i(21).f})},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=function(){function e(t){(0,s.default)(this,e),this.NUM_ITERATIONS=4,this.image=new Image,this.canvas=document.createElement("canvas")}return(0,a.default)(e,[{key:"init",value:function(){if(!this.initialized()){this.src=this.image.src;var e=this.image.width,t=this.image.height;this.width=e,this.height=t,this.canvas.width=3*e/4,this.canvas.height=t/2,this.coordinates=[[0,0,e/2,t/2],[e/2,0,e/4,t/4],[e/2,t/4,e/8,t/8],[5*e/8,t/4,e/16,t/16]],this._fillMipMap()}}},{key:"initialized",value:function(){return void 0!==this.coordinates}},{key:"_fillMipMap",value:function(){var e=this.canvas.getContext("2d"),t=this.coordinates[0];e.drawImage(this.image,t[0],t[1],t[2],t[3]);for(var i=1;i<this.NUM_ITERATIONS;i++){var o=this.coordinates[i-1],n=this.coordinates[i];e.drawImage(this.canvas,o[0],o[1],o[2],o[3],n[0],n[1],n[2],n[3])}}},{key:"drawImageAtPosition",value:function(e,t,i,o,n,s){if(t>2&&this.initialized()){t*=.5;for(var r=0;t>2&&r<this.NUM_ITERATIONS;)t*=.5,r+=1;r>=this.NUM_ITERATIONS&&(r=this.NUM_ITERATIONS-1);var a=this.coordinates[r];e.drawImage(this.canvas,a[0],a[1],a[2],a[3],i,o,n,s)}else this._isImageOk()&&e.drawImage(this.image,i,o,n,s)}},{key:"_isImageOk",value:function(e){var e=this.image;return!!e.complete&&("undefined"==typeof e.naturalWidth||0!==e.naturalWidth)}}]),e}();t.default=d},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=i(1),h=function(){function e(){(0,s.default)(this,e),this.clear(),this.defaultIndex=0,this.groupsArray=[],this.groupIndex=0,this.defaultGroups=[{border:"#2B7CE9",background:"#97C2FC",highlight:{border:"#2B7CE9",background:"#D2E5FF"},hover:{border:"#2B7CE9",background:"#D2E5FF"}},{border:"#FFA500",background:"#FFFF00",highlight:{border:"#FFA500",background:"#FFFFA3"},hover:{border:"#FFA500",background:"#FFFFA3"}},{border:"#FA0A10",background:"#FB7E81",highlight:{border:"#FA0A10",background:"#FFAFB1"},hover:{border:"#FA0A10",background:"#FFAFB1"}},{border:"#41A906",background:"#7BE141",highlight:{border:"#41A906",background:"#A1EC76"},hover:{border:"#41A906",background:"#A1EC76"}},{border:"#E129F0",background:"#EB7DF4",highlight:{border:"#E129F0",background:"#F0B3F5"},hover:{border:"#E129F0",background:"#F0B3F5"}},{border:"#7C29F0",background:"#AD85E4",highlight:{border:"#7C29F0",background:"#D3BDF0"},hover:{border:"#7C29F0",background:"#D3BDF0"}},{border:"#C37F00",background:"#FFA807",highlight:{border:"#C37F00",background:"#FFCA66"},hover:{border:"#C37F00",background:"#FFCA66"}},{border:"#4220FB",background:"#6E6EFD",highlight:{border:"#4220FB",background:"#9B9BFD"},hover:{border:"#4220FB",background:"#9B9BFD"}},{border:"#FD5A77",background:"#FFC0CB",highlight:{border:"#FD5A77",background:"#FFD1D9"},hover:{border:"#FD5A77",background:"#FFD1D9"}},{border:"#4AD63A",background:"#C2FABC",highlight:{border:"#4AD63A",background:"#E6FFE3"},hover:{border:"#4AD63A",background:"#E6FFE3"}},{border:"#990000",background:"#EE0000",highlight:{border:"#BB0000",background:"#FF3333"},hover:{border:"#BB0000",background:"#FF3333"}},{border:"#FF6000",background:"#FF6000",highlight:{border:"#FF6000",background:"#FF6000"},hover:{border:"#FF6000",background:"#FF6000"}},{border:"#97C2FC",background:"#2B7CE9",highlight:{border:"#D2E5FF",background:"#2B7CE9"},hover:{border:"#D2E5FF",background:"#2B7CE9"}},{border:"#399605",background:"#255C03",highlight:{border:"#399605",background:"#255C03"},hover:{border:"#399605",background:"#255C03"}},{border:"#B70054",background:"#FF007E",highlight:{border:"#B70054",background:"#FF007E"},hover:{border:"#B70054",background:"#FF007E"}},{border:"#AD85E4",background:"#7C29F0",highlight:{border:"#D3BDF0",background:"#7C29F0"},hover:{border:"#D3BDF0",background:"#7C29F0"}},{border:"#4557FA",background:"#000EA1",highlight:{border:"#6E6EFD",background:"#000EA1"},hover:{border:"#6E6EFD",background:"#000EA1"}},{border:"#FFC0CB",background:"#FD5A77",highlight:{border:"#FFD1D9",background:"#FD5A77"},hover:{border:"#FFD1D9",background:"#FD5A77"}},{border:"#C2FABC",background:"#74D66A",highlight:{border:"#E6FFE3",background:"#74D66A"},hover:{border:"#E6FFE3",background:"#74D66A"}},{border:"#EE0000",background:"#990000",highlight:{border:"#FF3333",background:"#BB0000"},hover:{border:"#FF3333",background:"#BB0000"}}],this.options={},this.defaultOptions={useDefaultGroups:!0},d.extend(this.options,this.defaultOptions)}return(0,a.default)(e,[{key:"setOptions",value:function(e){var t=["useDefaultGroups"];if(void 0!==e)for(var i in e)if(e.hasOwnProperty(i)&&t.indexOf(i)===-1){var o=e[i];this.add(i,o)}}},{key:"clear",value:function(){this.groups={},this.groupsArray=[]}},{key:"get",value:function(e){var t=this.groups[e];if(void 0===t)if(this.options.useDefaultGroups===!1&&this.groupsArray.length>0){var i=this.groupIndex%this.groupsArray.length;this.groupIndex++,t={},t.color=this.groups[this.groupsArray[i]],this.groups[e]=t}else{var o=this.defaultIndex%this.defaultGroups.length;this.defaultIndex++,t={},t.color=this.defaultGroups[o],this.groups[e]=t}return t}},{key:"add",value:function(e,t){return this.groups[e]=t,this.groupsArray.push(e),t}}]),e}();t.default=h;
},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=i(1),h=i(88),l=i(92),u=i(113).default,c=i(114).default,f=function(){function e(t,i,o,n){var r=this;if((0,s.default)(this,e),this.body=t,this.images=i,this.groups=o,this.layoutEngine=n,this.body.functions.createNode=this.create.bind(this),this.nodesListeners={add:function(e,t){r.add(t.items)},update:function(e,t){r.update(t.items,t.data)},remove:function(e,t){r.remove(t.items)}},this.options={},this.defaultOptions={borderWidth:1,borderWidthSelected:2,brokenImage:void 0,color:{border:"#2B7CE9",background:"#97C2FC",highlight:{border:"#2B7CE9",background:"#D2E5FF"},hover:{border:"#2B7CE9",background:"#D2E5FF"}},fixed:{x:!1,y:!1},font:{color:"#343434",size:14,face:"arial",background:"none",strokeWidth:0,strokeColor:"#ffffff",align:"center",vadjust:0,multi:!1,bold:{mod:"bold"},boldital:{mod:"bold italic"},ital:{mod:"italic"},mono:{mod:"",size:15,face:"monospace",vadjust:2}},group:void 0,hidden:!1,icon:{face:"FontAwesome",code:void 0,size:50,color:"#2B7CE9"},image:void 0,label:void 0,labelHighlightBold:!0,level:void 0,margin:{top:5,right:5,bottom:5,left:5},mass:1,physics:!0,scaling:{min:10,max:30,label:{enabled:!1,min:14,max:30,maxVisible:30,drawThreshold:5},customScalingFunction:function(e,t,i,o){if(t===e)return.5;var n=1/(t-e);return Math.max(0,(o-e)*n)}},shadow:{enabled:!1,color:"rgba(0,0,0,0.5)",size:10,x:5,y:5},shape:"ellipse",shapeProperties:{borderDashes:!1,borderRadius:6,interpolation:!0,useImageSize:!1,useBorderWithImage:!1},size:25,title:void 0,value:void 0,x:void 0,y:void 0},this.defaultOptions.mass<=0)throw"Internal error: mass in defaultOptions of NodesHandler may not be zero or negative";d.extend(this.options,this.defaultOptions),this.bindEventListeners()}return(0,a.default)(e,[{key:"bindEventListeners",value:function(){var e=this;this.body.emitter.on("refreshNodes",this.refresh.bind(this)),this.body.emitter.on("refresh",this.refresh.bind(this)),this.body.emitter.on("destroy",function(){d.forEach(e.nodesListeners,function(t,i){e.body.data.nodes&&e.body.data.nodes.off(i,t)}),delete e.body.functions.createNode,delete e.nodesListeners.add,delete e.nodesListeners.update,delete e.nodesListeners.remove,delete e.nodesListeners})}},{key:"setOptions",value:function(e){if(this.nodeOptions=e,void 0!==e){if(u.parseOptions(this.options,e),void 0!==e.shape)for(var t in this.body.nodes)this.body.nodes.hasOwnProperty(t)&&this.body.nodes[t].updateShape();if(void 0!==e.font){c.parseOptions(this.options.font,e);for(var i in this.body.nodes)this.body.nodes.hasOwnProperty(i)&&(this.body.nodes[i].updateLabelModule(),this.body.nodes[i].needsRefresh())}if(void 0!==e.size)for(var o in this.body.nodes)this.body.nodes.hasOwnProperty(o)&&this.body.nodes[o].needsRefresh();void 0===e.hidden&&void 0===e.physics||this.body.emitter.emit("_dataChanged")}}},{key:"setData",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],i=this.body.data.nodes;if(e instanceof h||e instanceof l)this.body.data.nodes=e;else if(Array.isArray(e))this.body.data.nodes=new h,this.body.data.nodes.add(e);else{if(e)throw new TypeError("Array or DataSet expected");this.body.data.nodes=new h}if(i&&d.forEach(this.nodesListeners,function(e,t){i.off(t,e)}),this.body.nodes={},this.body.data.nodes){var o=this;d.forEach(this.nodesListeners,function(e,t){o.body.data.nodes.on(t,e)});var n=this.body.data.nodes.getIds();this.add(n,!0)}t===!1&&this.body.emitter.emit("_dataChanged")}},{key:"add",value:function(e){for(var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],i=void 0,o=[],n=0;n<e.length;n++){i=e[n];var s=this.body.data.nodes.get(i),r=this.create(s);o.push(r),this.body.nodes[i]=r}this.layoutEngine.positionInitially(o),t===!1&&this.body.emitter.emit("_dataChanged")}},{key:"update",value:function(e,t){for(var i=this.body.nodes,o=!1,n=0;n<e.length;n++){var s=e[n],r=i[s],a=t[n];void 0!==r?o=r.setOptions(a):(o=!0,r=this.create(a),i[s]=r)}o===!0?this.body.emitter.emit("_dataChanged"):this.body.emitter.emit("_dataUpdated")}},{key:"remove",value:function(e){for(var t=this.body.nodes,i=0;i<e.length;i++){var o=e[i];delete t[o]}this.body.emitter.emit("_dataChanged")}},{key:"create",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:u;return new t(e,this.body,this.images,this.groups,this.options,this.defaultOptions,this.nodeOptions)}},{key:"refresh",value:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=this.body.nodes;for(var i in t){var o=void 0;t.hasOwnProperty(i)&&(o=t[i]);var n=this.body.data.nodes.get(i);void 0!==o&&void 0!==n&&(e===!0&&o.setOptions({x:null,y:null}),o.setOptions({fixed:!1}),o.setOptions(n))}}},{key:"getPositions",value:function(e){var t={};if(void 0!==e){if(Array.isArray(e)===!0){for(var i=0;i<e.length;i++)if(void 0!==this.body.nodes[e[i]]){var o=this.body.nodes[e[i]];t[e[i]]={x:Math.round(o.x),y:Math.round(o.y)}}}else if(void 0!==this.body.nodes[e]){var n=this.body.nodes[e];t[e]={x:Math.round(n.x),y:Math.round(n.y)}}}else for(var s=0;s<this.body.nodeIndices.length;s++){var r=this.body.nodes[this.body.nodeIndices[s]];t[this.body.nodeIndices[s]]={x:Math.round(r.x),y:Math.round(r.y)}}return t}},{key:"storePositions",value:function(){var e=[],t=this.body.data.nodes.getDataSet();for(var i in t._data)if(t._data.hasOwnProperty(i)){var o=this.body.nodes[i];t._data[i].x==Math.round(o.x)&&t._data[i].y==Math.round(o.y)||e.push({id:o.id,x:Math.round(o.x),y:Math.round(o.y)})}t.update(e)}},{key:"getBoundingBox",value:function(e){if(void 0!==this.body.nodes[e])return this.body.nodes[e].shape.boundingBox}},{key:"getConnectedNodes",value:function(e,t){var i=[];if(void 0!==this.body.nodes[e])for(var o=this.body.nodes[e],n={},s=0;s<o.edges.length;s++){var r=o.edges[s];"to"!==t&&r.toId==o.id?void 0===n[r.fromId]&&(i.push(r.fromId),n[r.fromId]=!0):"from"!==t&&r.fromId==o.id&&void 0===n[r.toId]&&(i.push(r.toId),n[r.toId]=!0)}return i}},{key:"getConnectedEdges",value:function(e){var t=[];if(void 0!==this.body.nodes[e])for(var i=this.body.nodes[e],o=0;o<i.edges.length;o++)t.push(i.edges[o].id);else console.log("NodeId provided for getConnectedEdges does not exist. Provided: ",e);return t}},{key:"moveNode",value:function(e,t,i){var o=this;void 0!==this.body.nodes[e]?(this.body.nodes[e].x=Number(t),this.body.nodes[e].y=Number(i),setTimeout(function(){o.body.emitter.emit("startSimulation")},0)):console.log("Node id supplied to moveNode does not exist. Provided: ",e)}}]),e}();t.default=f},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(62),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(1),u=i(114).default,c=i(119).default,f=i(130).default,p=i(132).default,v=i(133).default,g=i(134).default,y=i(136).default,m=i(137).default,b=i(138).default,_=i(139).default,w=i(140).default,k=i(141).default,x=i(142).default,O=i(143).default,M=i(144).default,E=(i(145).default,i(145)),S=E.printStyle,D=function(){function e(t,i,o,n,s,r,d){(0,a.default)(this,e),this.options=l.bridgeObject(s),this.globalOptions=s,this.defaultOptions=r,this.nodeOptions=d,this.body=i,this.edges=[],this.id=void 0,this.imagelist=o,this.grouplist=n,this.x=void 0,this.y=void 0,this.baseSize=this.options.size,this.baseFontSize=this.options.font.size,this.predefinedPosition=!1,this.selected=!1,this.hover=!1,this.labelModule=new u(this.body,this.options,!1),this.setOptions(t)}return(0,h.default)(e,[{key:"attachEdge",value:function(e){this.edges.indexOf(e)===-1&&this.edges.push(e)}},{key:"detachEdge",value:function(e){var t=this.edges.indexOf(e);t!=-1&&this.edges.splice(t,1)}},{key:"setOptions",value:function(t){var i=this.options.shape;if(t){if(void 0!==t.id&&(this.id=t.id),void 0===this.id)throw"Node must have an id";if(e.checkMass(t,this.id),void 0!==t.x&&(null===t.x?(this.x=void 0,this.predefinedPosition=!1):(this.x=parseInt(t.x),this.predefinedPosition=!0)),void 0!==t.y&&(null===t.y?(this.y=void 0,this.predefinedPosition=!1):(this.y=parseInt(t.y),this.predefinedPosition=!0)),void 0!==t.size&&(this.baseSize=t.size),void 0!==t.value&&(t.value=parseFloat(t.value)),"number"==typeof t.group||"string"==typeof t.group&&""!=t.group){var o=this.grouplist.get(t.group);l.deepExtend(this.options,o),this.options.color=l.parseColor(this.options.color)}return e.parseOptions(this.options,t,!0,this.globalOptions),this.choosify(t),this._load_images(),this.updateLabelModule(t),this.updateShape(i),this.labelModule.propagateFonts(this.nodeOptions,t,this.defaultOptions),void 0!==t.hidden||void 0!==t.physics}}},{key:"_load_images",value:function(){if("circularImage"===this.options.shape||"image"===this.options.shape){if(void 0===this.options.image)throw"Option image must be defined for node type '"+this.options.shape+"'";if(void 0===this.imagelist)throw"Internal Error: No images provided";if("string"==typeof this.options.image)this.imageObj=this.imagelist.load(this.options.image,this.options.brokenImage,this.id);else{if(void 0===this.options.image.unselected)throw"No unselected image provided";this.imageObj=this.imagelist.load(this.options.image.unselected,this.options.brokenImage,this.id),void 0!==this.options.image.selected?this.imageObjAlt=this.imagelist.load(this.options.image.selected,this.options.brokenImage,this.id):this.imageObjAlt=void 0}}}},{key:"choosify",value:function(e){this.chooser=!0;var t=[e,this.options,this.defaultOptions],i=l.topMost(t,"chosen");if("boolean"==typeof i)this.chooser=i;else if("object"===("undefined"==typeof i?"undefined":(0,s.default)(i))){var o=l.topMost(t,["chosen","node"]);"boolean"!=typeof o&&"function"!=typeof o||(this.chooser=o)}}},{key:"getFormattingValues",value:function(){var e={color:this.options.color.background,borderWidth:this.options.borderWidth,borderColor:this.options.color.border,size:this.options.size,borderDashes:this.options.shapeProperties.borderDashes,borderRadius:this.options.shapeProperties.borderRadius,shadow:this.options.shadow.enabled,shadowColor:this.options.shadow.color,shadowSize:this.options.shadow.size,shadowX:this.options.shadow.x,shadowY:this.options.shadow.y};return this.selected||this.hover?this.chooser===!0?this.selected?(e.borderWidth*=2,e.color=this.options.color.highlight.background,e.borderColor=this.options.color.highlight.border,e.shadow=this.options.shadow.enabled):this.hover&&(e.color=this.options.color.hover.background,e.borderColor=this.options.color.hover.border,e.shadow=this.options.shadow.enabled):"function"==typeof this.chooser&&(this.chooser(e,this.options.id,this.selected,this.hover),e.shadow===!1&&(e.shadowColor===this.options.shadow.color&&e.shadowSize===this.options.shadow.size&&e.shadowX===this.options.shadow.x&&e.shadowY===this.options.shadow.y||(e.shadow=!0))):e.shadow=this.options.shadow.enabled,e}},{key:"updateLabelModule",value:function(e){void 0!==this.options.label&&null!==this.options.label||(this.options.label=""),this.labelModule.setOptions(this.options,!0),void 0!==this.labelModule.baseSize&&(this.baseFontSize=this.labelModule.baseSize),this.labelModule.constrain(this.nodeOptions,e,this.defaultOptions),this.labelModule.choosify(this.nodeOptions,e,this.defaultOptions)}},{key:"updateShape",value:function(e){if(e===this.options.shape&&this.shape)this.shape.setOptions(this.options,this.imageObj,this.imageObjAlt);else switch(this.options.shape){case"box":this.shape=new c(this.options,this.body,this.labelModule);break;case"circle":this.shape=new f(this.options,this.body,this.labelModule);break;case"circularImage":this.shape=new p(this.options,this.body,this.labelModule,this.imageObj,this.imageObjAlt);break;case"database":this.shape=new v(this.options,this.body,this.labelModule);break;case"diamond":this.shape=new g(this.options,this.body,this.labelModule);break;case"dot":this.shape=new y(this.options,this.body,this.labelModule);break;case"ellipse":this.shape=new m(this.options,this.body,this.labelModule);break;case"icon":this.shape=new b(this.options,this.body,this.labelModule);break;case"image":this.shape=new _(this.options,this.body,this.labelModule,this.imageObj,this.imageObjAlt);break;case"square":this.shape=new w(this.options,this.body,this.labelModule);break;case"star":this.shape=new k(this.options,this.body,this.labelModule);break;case"text":this.shape=new x(this.options,this.body,this.labelModule);break;case"triangle":this.shape=new O(this.options,this.body,this.labelModule);break;case"triangleDown":this.shape=new M(this.options,this.body,this.labelModule);break;default:this.shape=new m(this.options,this.body,this.labelModule)}this.needsRefresh()}},{key:"select",value:function(){this.selected=!0,this.needsRefresh()}},{key:"unselect",value:function(){this.selected=!1,this.needsRefresh()}},{key:"needsRefresh",value:function(){this.shape.refreshNeeded=!0}},{key:"getTitle",value:function(){return this.options.title}},{key:"distanceToBorder",value:function(e,t){return this.shape.distanceToBorder(e,t)}},{key:"isFixed",value:function(){return this.options.fixed.x&&this.options.fixed.y}},{key:"isSelected",value:function(){return this.selected}},{key:"getValue",value:function(){return this.options.value}},{key:"setValueRange",value:function(e,t,i){if(void 0!==this.options.value){var o=this.options.scaling.customScalingFunction(e,t,i,this.options.value),n=this.options.scaling.max-this.options.scaling.min;if(this.options.scaling.label.enabled===!0){var s=this.options.scaling.label.max-this.options.scaling.label.min;this.options.font.size=this.options.scaling.label.min+o*s}this.options.size=this.options.scaling.min+o*n}else this.options.size=this.baseSize,this.options.font.size=this.baseFontSize;this.updateLabelModule()}},{key:"draw",value:function(e){var t=this.getFormattingValues();this.shape.draw(e,this.x,this.y,this.selected,this.hover,t)}},{key:"updateBoundingBox",value:function(e){this.shape.updateBoundingBox(this.x,this.y,e)}},{key:"resize",value:function(e){var t=this.getFormattingValues();this.shape.resize(e,this.selected,this.hover,t)}},{key:"isOverlappingWith",value:function(e){return this.shape.left<e.right&&this.shape.left+this.shape.width>e.left&&this.shape.top<e.bottom&&this.shape.top+this.shape.height>e.top}},{key:"isBoundingBoxOverlappingWith",value:function(e){return this.shape.boundingBox.left<e.right&&this.shape.boundingBox.right>e.left&&this.shape.boundingBox.top<e.bottom&&this.shape.boundingBox.bottom>e.top}}],[{key:"parseOptions",value:function(t,i){var o=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},s=["color","font","fixed","shadow"];if(l.selectiveNotDeepExtend(s,t,i,o),e.checkMass(i),l.mergeOptions(t,i,"shadow",o,n),void 0!==i.color&&null!==i.color){var r=l.parseColor(i.color);l.fillIfDefined(t.color,r)}else o===!0&&null===i.color&&(t.color=l.bridgeObject(n.color));void 0!==i.fixed&&null!==i.fixed&&("boolean"==typeof i.fixed?(t.fixed.x=i.fixed,t.fixed.y=i.fixed):(void 0!==i.fixed.x&&"boolean"==typeof i.fixed.x&&(t.fixed.x=i.fixed.x),void 0!==i.fixed.y&&"boolean"==typeof i.fixed.y&&(t.fixed.y=i.fixed.y))),void 0!==i.font&&null!==i.font?u.parseOptions(t.font,i):o===!0&&null===i.font&&(t.font=l.bridgeObject(n.font)),void 0!==i.scaling&&l.mergeOptions(t.scaling,i.scaling,"label",o,n.scaling)}},{key:"checkMass",value:function(e,t){if(void 0!==e.mass&&e.mass<=0){var i="";void 0!==t&&(i=" in node id: "+t),console.log("%cNegative or zero mass disallowed"+i+", setting mass to 1.",S),e.mass=1}}}]),e}();t.default=D},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(115),s=o(n),r=i(2),a=o(r),d=i(62),h=o(d),l=i(105),u=o(l),c=i(106),f=o(c),p=i(1),v=function(){function e(t,i){var o=arguments.length>2&&void 0!==arguments[2]&&arguments[2];(0,u.default)(this,e),this.body=t,this.pointToSelf=!1,this.baseSize=void 0,this.fontOptions={},this.setOptions(i),this.size={top:0,left:0,width:0,height:0,yLine:0},this.isEdgeLabel=o}return(0,f.default)(e,[{key:"setOptions",value:function(t){var i=arguments.length>1&&void 0!==arguments[1]&&arguments[1];this.elementOptions=t,this.fontOptions=p.deepExtend({},t.font,!0),void 0!==t.label&&(this.labelDirty=!0),void 0!==t.font&&(e.parseOptions(this.fontOptions,t,i),"string"==typeof t.font?this.baseSize=this.fontOptions.size:"object"===(0,h.default)(t.font)&&void 0!==t.font.size&&(this.baseSize=t.font.size))}},{key:"constrain",value:function(e,t,i){this.fontOptions.constrainWidth=!1,this.fontOptions.maxWdt=-1,this.fontOptions.minWdt=-1;var o=[t,e,i],n=p.topMost(o,"widthConstraint");if("number"==typeof n)this.fontOptions.maxWdt=Number(n),this.fontOptions.minWdt=Number(n);else if("object"===("undefined"==typeof n?"undefined":(0,h.default)(n))){var s=p.topMost(o,["widthConstraint","maximum"]);"number"==typeof s&&(this.fontOptions.maxWdt=Number(s));var r=p.topMost(o,["widthConstraint","minimum"]);"number"==typeof r&&(this.fontOptions.minWdt=Number(r))}this.fontOptions.constrainHeight=!1,this.fontOptions.minHgt=-1,this.fontOptions.valign="middle";var a=p.topMost(o,"heightConstraint");if("number"==typeof a)this.fontOptions.minHgt=Number(a);else if("object"===("undefined"==typeof a?"undefined":(0,h.default)(a))){var d=p.topMost(o,["heightConstraint","minimum"]);"number"==typeof d&&(this.fontOptions.minHgt=Number(d));var l=p.topMost(o,["heightConstraint","valign"]);"string"==typeof l&&("top"!==l&&"bottom"!==l||(this.fontOptions.valign=l))}}},{key:"choosify",value:function(e,t,i){this.fontOptions.chooser=!0;var o=[t,e,i],n=p.topMost(o,"chosen");if("boolean"==typeof n)this.fontOptions.chooser=n;else if("object"===("undefined"==typeof n?"undefined":(0,h.default)(n))){var s=p.topMost(o,["chosen","label"]);"boolean"!=typeof s&&"function"!=typeof s||(this.fontOptions.chooser=s)}}},{key:"adjustSizes",value:function(e){var t=e?e.right+e.left:0;this.fontOptions.constrainWidth&&(this.fontOptions.maxWdt-=t,this.fontOptions.minWdt-=t);var i=e?e.top+e.bottom:0;this.fontOptions.constrainHeight&&(this.fontOptions.minHgt-=i)}},{key:"propagateFonts",value:function(t,i,o){if(this.fontOptions.multi){var n=function(e,t){if(!e||!e.font)return null;var i=e.font;if(t){if(!i[t])return null;i=i[t]}return i},s=function(e,t,i){var o=n(e,t);return o&&o.hasOwnProperty(i)?o[i]:null},r=["bold","ital","boldital","mono"],d=!0,h=!1,l=void 0;try{for(var u,c=(0,a.default)(r);!(d=(u=c.next()).done);d=!0){var f=u.value,p=this.fontOptions[f],v=o.font[f];if(e.parseFontString(p,n(t,f)))p.vadjust=this.fontOptions.vadjust,p.mod=v.mod;else{p.face=s(t,f,"face")||s(i,f,"face")||("mono"===f?v.face:null)||s(i,null,"face")||this.fontOptions.face,p.color=s(t,f,"color")||s(i,f,"color")||s(i,null,"color")||this.fontOptions.color,p.mod=s(t,f,"mod")||s(i,f,"mod")||s(i,null,"mod")||v.mod;var g=void 0;p.face===v.face&&this.fontOptions.face===o.font.face&&(g=this.fontOptions.size/Number(o.font.size)),p.size=s(t,f,"size")||s(i,f,"size")||(g?v.size*g:null)||s(i,null,"size")||this.fontOptions.size,p.vadjust=s(t,f,"vadjust")||s(i,f,"vadjust")||(g?v.vadjust*Math.round(g):null)||this.fontOptions.vadjust}p.size=Number(p.size),p.vadjust=Number(p.vadjust)}}catch(e){h=!0,l=e}finally{try{!d&&c.return&&c.return()}finally{if(h)throw l}}}}},{key:"draw",value:function(e,t,i,o,n){var s=arguments.length>5&&void 0!==arguments[5]?arguments[5]:"middle";if(void 0!==this.elementOptions.label){var r=this.fontOptions.size*this.body.view.scale;this.elementOptions.label&&r<this.elementOptions.scaling.label.drawThreshold-1||(this.calculateLabelSize(e,o,n,t,i,s),this._drawBackground(e),this._drawText(e,o,n,t,i,s))}}},{key:"_drawBackground",value:function(e){if(void 0!==this.fontOptions.background&&"none"!==this.fontOptions.background){e.fillStyle=this.fontOptions.background;var t=2;if(this.isEdgeLabel)switch(this.fontOptions.align){case"middle":e.fillRect(.5*-this.size.width,.5*-this.size.height,this.size.width,this.size.height);break;case"top":e.fillRect(.5*-this.size.width,-(this.size.height+t),this.size.width,this.size.height);break;case"bottom":e.fillRect(.5*-this.size.width,t,this.size.width,this.size.height);break;default:e.fillRect(this.size.left,this.size.top-.5*t,this.size.width,this.size.height)}else e.fillRect(this.size.left,this.size.top-.5*t,this.size.width,this.size.height)}}},{key:"_drawText",value:function(e,t,i,o,n){var r=arguments.length>5&&void 0!==arguments[5]?arguments[5]:"middle",a=this.fontOptions.size,d=a*this.body.view.scale;d>=this.elementOptions.scaling.label.maxVisible&&(a=Number(this.elementOptions.scaling.label.maxVisible)/this.body.view.scale);var h=this.size.yLine,l=this._setAlignment(e,o,h,r),u=(0,s.default)(l,2);o=u[0],h=u[1],e.textAlign="left",o-=this.size.width/2,this.fontOptions.valign&&this.size.height>this.size.labelHeight&&("top"===this.fontOptions.valign&&(h-=(this.size.height-this.size.labelHeight)/2),"bottom"===this.fontOptions.valign&&(h+=(this.size.height-this.size.labelHeight)/2));for(var c=0;c<this.lineCount;c++)if(this.lines[c]&&this.lines[c].blocks){var f=0;this.isEdgeLabel||"center"===this.fontOptions.align?f+=(this.size.width-this.lines[c].width)/2:"right"===this.fontOptions.align&&(f+=this.size.width-this.lines[c].width);for(var p=0;p<this.lines[c].blocks.length;p++){var v=this.lines[c].blocks[p];e.font=v.font;var g=this._getColor(v.color,d,v.strokeColor),y=(0,s.default)(g,2),m=y[0],b=y[1];v.strokeWidth>0&&(e.lineWidth=v.strokeWidth,e.strokeStyle=b,e.lineJoin="round"),e.fillStyle=m,v.strokeWidth>0&&e.strokeText(v.text,o+f,h+v.vadjust),e.fillText(v.text,o+f,h+v.vadjust),f+=v.width}h+=this.lines[c].height}}},{key:"_setAlignment",value:function(e,t,i,o){if(this.isEdgeLabel&&"horizontal"!==this.fontOptions.align&&this.pointToSelf===!1){t=0,i=0;var n=2;"top"===this.fontOptions.align?(e.textBaseline="alphabetic",i-=2*n):"bottom"===this.fontOptions.align?(e.textBaseline="hanging",i+=2*n):e.textBaseline="middle"}else e.textBaseline=o;return[t,i]}},{key:"_getColor",value:function(e,t,i){var o=e||"#000000",n=i||"#ffffff";if(t<=this.elementOptions.scaling.label.drawThreshold){var s=Math.max(0,Math.min(1,1-(this.elementOptions.scaling.label.drawThreshold-t)));o=p.overrideOpacity(o,s),n=p.overrideOpacity(n,s)}return[o,n]}},{key:"getTextSize",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],i=arguments.length>2&&void 0!==arguments[2]&&arguments[2];return this._processLabel(e,t,i),{width:this.size.width,height:this.size.height,lineCount:this.lineCount}}},{key:"calculateLabelSize",value:function(e,t,i){var o=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,n=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0,s=arguments.length>5&&void 0!==arguments[5]?arguments[5]:"middle";this.labelDirty===!0&&this._processLabel(e,t,i),this.size.left=o-.5*this.size.width,this.size.top=n-.5*this.size.height,this.size.yLine=n+.5*(1-this.lineCount)*this.fontOptions.size,"hanging"===s&&(this.size.top+=.5*this.fontOptions.size,this.size.top+=4,this.size.yLine+=4),this.labelDirty=!1}},{key:"decodeMarkupSystem",value:function(e){var t="none";return"markdown"===e||"md"===e?t="markdown":e!==!0&&"html"!==e||(t="html"),t}},{key:"splitBlocks",value:function(e,t){var i=this.decodeMarkupSystem(t);return"none"===i?[{text:e,mod:"normal"}]:"markdown"===i?this.splitMarkdownBlocks(e):"html"===i?this.splitHtmlBlocks(e):void 0}},{key:"splitMarkdownBlocks",value:function(e){var t=[],i={bold:!1,ital:!1,mono:!1,beginable:!0,spacing:!1,position:0,buffer:"",modStack:[]};for(i.mod=function(){return 0===this.modStack.length?"normal":this.modStack[0]},i.modName=function(){return 0===this.modStack.length?"normal":"mono"===this.modStack[0]?"mono":i.bold&&i.ital?"boldital":i.bold?"bold":i.ital?"ital":void 0},i.emitBlock=function(){arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.spacing&&(this.add(" "),this.spacing=!1),this.buffer.length>0&&(t.push({text:this.buffer,mod:this.modName()}),this.buffer="")},i.add=function(e){" "===e&&(i.spacing=!0),i.spacing&&(this.buffer+=" ",this.spacing=!1)," "!=e&&(this.buffer+=e)};i.position<e.length;){var o=e.charAt(i.position);/[ \t]/.test(o)?(i.mono?i.add(o):i.spacing=!0,i.beginable=!0):/\\/.test(o)?i.position<e.length+1&&(i.position++,o=e.charAt(i.position),/ \t/.test(o)?i.spacing=!0:(i.add(o),i.beginable=!1)):i.mono||i.bold||!i.beginable&&!i.spacing||!/\*/.test(o)?i.mono||i.ital||!i.beginable&&!i.spacing||!/\_/.test(o)?!i.mono&&(i.beginable||i.spacing)&&/`/.test(o)?(i.emitBlock(),i.mono=!0,i.modStack.unshift("mono")):!i.mono&&"bold"===i.mod()&&/\*/.test(o)?i.position===e.length-1||/[.,_` \t\n]/.test(e.charAt(i.position+1))?(i.emitBlock(),i.bold=!1,i.modStack.shift()):i.add(o):!i.mono&&"ital"===i.mod()&&/\_/.test(o)?i.position===e.length-1||/[.,*` \t\n]/.test(e.charAt(i.position+1))?(i.emitBlock(),i.ital=!1,i.modStack.shift()):i.add(o):i.mono&&"mono"===i.mod()&&/`/.test(o)?i.position===e.length-1||/[.,*_ \t\n]/.test(e.charAt(i.position+1))?(i.emitBlock(),i.mono=!1,i.modStack.shift()):i.add(o):(i.add(o),i.beginable=!1):(i.emitBlock(),i.ital=!0,i.modStack.unshift("ital")):(i.emitBlock(),i.bold=!0,i.modStack.unshift("bold")),i.position++}return i.emitBlock(),t}},{key:"splitHtmlBlocks",value:function(e){var t=[],i={bold:!1,ital:!1,mono:!1,spacing:!1,position:0,buffer:"",modStack:[]};for(i.mod=function(){return 0===this.modStack.length?"normal":this.modStack[0]},i.modName=function(){return 0===this.modStack.length?"normal":"mono"===this.modStack[0]?"mono":i.bold&&i.ital?"boldital":i.bold?"bold":i.ital?"ital":void 0},i.emitBlock=function(){arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.spacing&&(this.add(" "),this.spacing=!1),this.buffer.length>0&&(t.push({text:this.buffer,mod:this.modName()}),this.buffer="")},i.add=function(e){" "===e&&(i.spacing=!0),i.spacing&&(this.buffer+=" ",this.spacing=!1)," "!=e&&(this.buffer+=e)};i.position<e.length;){var o=e.charAt(i.position);/[ \t]/.test(o)?i.mono?i.add(o):i.spacing=!0:/</.test(o)?i.mono||i.bold||!/<b>/.test(e.substr(i.position,3))?i.mono||i.ital||!/<i>/.test(e.substr(i.position,3))?!i.mono&&/<code>/.test(e.substr(i.position,6))?(i.emitBlock(),i.mono=!0,i.modStack.unshift("mono"),i.position+=5):!i.mono&&"bold"===i.mod()&&/<\/b>/.test(e.substr(i.position,4))?(i.emitBlock(),i.bold=!1,i.modStack.shift(),i.position+=3):!i.mono&&"ital"===i.mod()&&/<\/i>/.test(e.substr(i.position,4))?(i.emitBlock(),i.ital=!1,i.modStack.shift(),i.position+=3):"mono"===i.mod()&&/<\/code>/.test(e.substr(i.position,7))?(i.emitBlock(),i.mono=!1,i.modStack.shift(),i.position+=6):i.add(o):(i.emitBlock(),i.ital=!0,i.modStack.unshift("ital"),i.position+=2):(i.emitBlock(),i.bold=!0,i.modStack.unshift("bold"),i.position+=2):/&/.test(o)?/&lt;/.test(e.substr(i.position,4))?(i.add("<"),i.position+=3):/&amp;/.test(e.substr(i.position,5))?(i.add("&"),i.position+=4):i.add("&"):i.add(o),i.position++}return i.emitBlock(),t}},{key:"getFormattingValues",value:function(e,t,i,o){var n=function(e,t,i){return"normal"===t?"mod"===i?"":e[i]:e[t][i]?e[t][i]:e[i]},s={color:n(this.fontOptions,o,"color"),size:n(this.fontOptions,o,"size"),face:n(this.fontOptions,o,"face"),mod:n(this.fontOptions,o,"mod"),vadjust:n(this.fontOptions,o,"vadjust"),strokeWidth:this.fontOptions.strokeWidth,strokeColor:this.fontOptions.strokeColor};return(t||i)&&("normal"===o&&this.fontOptions.chooser===!0&&this.elementOptions.labelHighlightBold?s.mod="bold":"function"==typeof this.fontOptions.chooser&&this.fontOptions.chooser(s,this.elementOptions.id,t,i)),e.font=(s.mod+" "+s.size+"px "+s.face).replace(/"/g,""),s.font=e.font,s.height=s.size,s}},{key:"differentState",value:function(e,t){return e!==this.fontOptions.selectedState&&t!==this.fontOptions.hoverState}},{key:"_processLabel",value:function(e,t,i){var o=0,n=0,s=[],r=0;if(s.add=function(e,t,i,o,n,s,r,a,d,h){this.length==e&&(this[e]={width:0,height:0,blocks:[]}),this[e].blocks.push({text:t,font:i,color:o,width:n,height:s,vadjust:r,mod:a,strokeWidth:d,strokeColor:h})},s.accumulate=function(e,t,i){this[e].width+=t,this[e].height=i>this[e].height?i:this[e].height},s.addAndAccumulate=function(e,t,i,o,n,s,r,a,d,h){this.add(e,t,i,o,n,s,r,a,d,h),this.accumulate(e,n,s)},void 0!==this.elementOptions.label){var a=String(this.elementOptions.label).split("\n"),d=a.length;if(this.elementOptions.font.multi)for(var h=0;h<d;h++){var l=this.splitBlocks(a[h],this.elementOptions.font.multi),u=0,c=0;if(l){if(0==l.length){var f=this.getFormattingValues(e,t,i,"normal");s.addAndAccumulate(r,"",f.font,f.color,0,f.size,f.vadjust,"normal",f.strokeWidth,f.strokeColor),n+=s[r].height,r++;continue}for(var p=0;p<l.length;p++)if(this.fontOptions.maxWdt>0)for(var v=this.getFormattingValues(e,t,i,l[p].mod),g=l[p].text.split(" "),y=!0,m="",b={width:0},_=void 0,w=0;w<g.length;){var k=y?"":" ";_=b,b=e.measureText(m+k+g[w]),u+b.width>this.fontOptions.maxWdt&&0!=_.width?(c=v.height>c?v.height:c,s.add(r,m,v.font,v.color,_.width,v.height,v.vadjust,l[p].mod,v.strokeWidth,v.strokeColor),s.accumulate(r,_.width,c),m="",y=!0,u=0,o=s[r].width>o?s[r].width:o,n+=s[r].height,r++):(m=m+k+g[w],w===g.length-1&&(c=v.height>c?v.height:c,u+=b.width,s.add(r,m,v.font,v.color,b.width,v.height,v.vadjust,l[p].mod,v.strokeWidth,v.strokeColor),s.accumulate(r,b.width,c),p===l.length-1&&(o=s[r].width>o?s[r].width:o,n+=s[r].height,r++)),w++,y=!1)}else{var x=this.getFormattingValues(e,t,i,l[p].mod),O=e.measureText(l[p].text);s.addAndAccumulate(r,l[p].text,x.font,x.color,O.width,x.height,x.vadjust,l[p].mod,x.strokeWidth,x.strokeColor),o=s[r].width>o?s[r].width:o,l.length-1===p&&(n+=s[r].height,r++)}}}else for(var M=0;M<d;M++){var E=this.getFormattingValues(e,t,i,"normal");if(this.fontOptions.maxWdt>0)for(var S=a[M].split(" "),D="",C={width:0},T=void 0,P=0;P<S.length;){var F=""===D?"":" ";T=C,C=e.measureText(D+F+S[P]),C.width>this.fontOptions.maxWdt&&0!=T.width?(s.addAndAccumulate(r,D,E.font,E.color,T.width,E.size,E.vadjust,"normal",E.strokeWidth,E.strokeColor),o=s[r].width>o?s[r].width:o,n+=s[r].height,D="",r++):(D=D+F+S[P],P===S.length-1&&(s.addAndAccumulate(r,D,E.font,E.color,C.width,E.size,E.vadjust,"normal",E.strokeWidth,E.strokeColor),o=s[r].width>o?s[r].width:o,n+=s[r].height,r++),P++)}else{var I=a[M],N=e.measureText(I);s.addAndAccumulate(r,I,E.font,E.color,N.width,E.size,E.vadjust,"normal",E.strokeWidth,E.strokeColor),o=s[r].width>o?s[r].width:o,n+=s[r].height,r++}}}this.fontOptions.minWdt>0&&o<this.fontOptions.minWdt&&(o=this.fontOptions.minWdt),this.size.labelHeight=n,this.fontOptions.minHgt>0&&n<this.fontOptions.minHgt&&(n=this.fontOptions.minHgt),this.lines=s,this.lineCount=s.length,this.size.width=o,this.size.height=n,this.selectedState=t,this.hoverState=i}}],[{key:"parseOptions",value:function(t,i){var o=arguments.length>2&&void 0!==arguments[2]&&arguments[2];e.parseFontString(t,i.font)?t.vadjust=0:"object"===(0,h.default)(i.font)&&p.fillIfDefined(t,i.font,o),t.size=Number(t.size),t.vadjust=Number(t.vadjust)}},{key:"parseFontString",value:function(e,t){if(!t||"string"!=typeof t)return!1;var i=t.split(" ");return e.size=i[0].replace("px",""),e.face=i[1],e.color=i[2],!0}}]),e}();t.default=v},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}t.__esModule=!0;var n=i(116),s=o(n),r=i(2),a=o(r);t.default=function(){function e(e,t){var i=[],o=!0,n=!1,s=void 0;try{for(var r,d=(0,a.default)(e);!(o=(r=d.next()).done)&&(i.push(r.value),!t||i.length!==t);o=!0);}catch(e){n=!0,s=e}finally{try{!o&&d.return&&d.return()}finally{if(n)throw s}}return i}return function(t,i){if(Array.isArray(t))return t;if((0,s.default)(Object(t)))return e(t,i);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()},function(e,t,i){e.exports={default:i(117),__esModule:!0}},function(e,t,i){i(4),i(50),e.exports=i(118)},function(e,t,i){var o=i(54),n=i(47)("iterator"),s=i(8);e.exports=i(17).isIterable=function(e){var t=Object(e);return void 0!==t[n]||"@@iterator"in t||s.hasOwnProperty(o(t))}},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{
value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(129),v=o(p),g=function(e){function t(e,i,o){(0,a.default)(this,t);var n=(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o));return n._setMargins(o),n}return(0,f.default)(t,e),(0,h.default)(t,[{key:"resize",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.selected,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this.hover;this.needsRefresh(t,i)&&(this.textSize=this.labelModule.getTextSize(e,t,i),this.width=this.textSize.width+this.margin.right+this.margin.left,this.height=this.textSize.height+this.margin.top+this.margin.bottom,this.radius=this.width/2)}},{key:"draw",value:function(e,t,i,o,n,s){this.resize(e,o,n),this.left=t-this.width/2,this.top=i-this.height/2,this.initContextForDraw(e,s),e.roundRect(this.left,this.top,this.width,this.height,s.borderRadius),this.performFill(e,s),this.updateBoundingBox(t,i,e,o,n),this.labelModule.draw(e,this.left+this.textSize.width/2+this.margin.left,this.top+this.textSize.height/2+this.margin.top,o,n)}},{key:"updateBoundingBox",value:function(e,t,i,o,n){this._updateBoundingBox(e,t,i,o,n);var s=this.options.shapeProperties.borderRadius;this._addBoundingBoxMargin(s)}},{key:"distanceToBorder",value:function(e,t){this.resize(e);var i=this.options.borderWidth;return Math.min(Math.abs(this.width/2/Math.cos(t)),Math.abs(this.height/2/Math.sin(t)))+i}}]),t}(v.default);t.default=g},function(e,t,i){e.exports={default:i(121),__esModule:!0}},function(e,t,i){i(122),e.exports=i(17).Object.getPrototypeOf},function(e,t,i){var o=i(49),n=i(48);i(61)("getPrototypeOf",function(){return function(e){return n(o(e))}})},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}t.__esModule=!0;var n=i(62),s=o(n);t.default=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!==("undefined"==typeof t?"undefined":(0,s.default)(t))&&"function"!=typeof t?e:t}},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}t.__esModule=!0;var n=i(125),s=o(n),r=i(55),a=o(r),d=i(62),h=o(d);t.default=function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+("undefined"==typeof t?"undefined":(0,h.default)(t)));e.prototype=(0,a.default)(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(s.default?(0,s.default)(e,t):e.__proto__=t)}},function(e,t,i){e.exports={default:i(126),__esModule:!0}},function(e,t,i){i(127),e.exports=i(17).Object.setPrototypeOf},function(e,t,i){var o=i(15);o(o.S,"Object",{setPrototypeOf:i(128).set})},function(e,t,i){var o=i(23),n=i(22),s=function(e,t){if(n(e),!o(t)&&null!==t)throw TypeError(t+": can't set as prototype!")};e.exports={set:Object.setPrototypeOf||("__proto__"in{}?function(e,t,o){try{o=i(18)(Function.call,i(78).f(Object.prototype,"__proto__").set,2),o(e,[]),t=!(e instanceof Array)}catch(e){t=!0}return function(e,i){return s(e,i),t?e.__proto__=i:o(e,i),e}}({},!1):void 0),check:s}},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(62),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=function(){function e(t,i,o){(0,a.default)(this,e),this.body=i,this.labelModule=o,this.setOptions(t),this.top=void 0,this.left=void 0,this.height=void 0,this.width=void 0,this.radius=void 0,this.margin=void 0,this.refreshNeeded=!0,this.boundingBox={top:0,left:0,right:0,bottom:0}}return(0,h.default)(e,[{key:"setOptions",value:function(e){this.options=e}},{key:"_setMargins",value:function(e){this.margin={},this.options.margin&&("object"==(0,s.default)(this.options.margin)?(this.margin.top=this.options.margin.top,this.margin.right=this.options.margin.right,this.margin.bottom=this.options.margin.bottom,this.margin.left=this.options.margin.left):(this.margin.top=this.options.margin,this.margin.right=this.options.margin,this.margin.bottom=this.options.margin,this.margin.left=this.options.margin)),e.adjustSizes(this.margin)}},{key:"_distanceToBorder",value:function(e,t){var i=this.options.borderWidth;return this.resize(e),Math.min(Math.abs(this.width/2/Math.cos(t)),Math.abs(this.height/2/Math.sin(t)))+i}},{key:"enableShadow",value:function(e,t){t.shadow&&(e.shadowColor=t.shadowColor,e.shadowBlur=t.shadowSize,e.shadowOffsetX=t.shadowX,e.shadowOffsetY=t.shadowY)}},{key:"disableShadow",value:function(e,t){t.shadow&&(e.shadowColor="rgba(0,0,0,0)",e.shadowBlur=0,e.shadowOffsetX=0,e.shadowOffsetY=0)}},{key:"enableBorderDashes",value:function(e,t){if(t.borderDashes!==!1)if(void 0!==e.setLineDash){var i=t.borderDashes;i===!0&&(i=[5,15]),e.setLineDash(i)}else console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used."),this.options.shapeProperties.borderDashes=!1,t.borderDashes=!1}},{key:"disableBorderDashes",value:function(e,t){t.borderDashes!==!1&&(void 0!==e.setLineDash?e.setLineDash([0]):(console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used."),this.options.shapeProperties.borderDashes=!1,t.borderDashes=!1))}},{key:"needsRefresh",value:function(e,t){return this.refreshNeeded===!0?(this.refreshNeeded=!1,!0):void 0===this.width||this.labelModule.differentState(e,t)}},{key:"initContextForDraw",value:function(e,t){var i=t.borderWidth/this.body.view.scale;e.lineWidth=Math.min(this.width,i),e.strokeStyle=t.borderColor,e.fillStyle=t.color}},{key:"performStroke",value:function(e,t){var i=t.borderWidth/this.body.view.scale;e.save(),i>0&&(this.enableBorderDashes(e,t),e.stroke(),this.disableBorderDashes(e,t)),e.restore()}},{key:"performFill",value:function(e,t){this.enableShadow(e,t),e.fill(),this.disableShadow(e,t),this.performStroke(e,t)}},{key:"_addBoundingBoxMargin",value:function(e){this.boundingBox.left-=e,this.boundingBox.top-=e,this.boundingBox.bottom+=e,this.boundingBox.right+=e}},{key:"_updateBoundingBox",value:function(e,t,i,o,n){void 0!==i&&this.resize(i,o,n),this.left=e-this.width/2,this.top=t-this.height/2,this.boundingBox.left=this.left,this.boundingBox.top=this.top,this.boundingBox.bottom=this.top+this.height,this.boundingBox.right=this.left+this.width}},{key:"updateBoundingBox",value:function(e,t,i,o,n){this._updateBoundingBox(e,t,i,o,n)}}]),e}();t.default=l},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(131),v=o(p),g=function(e){function t(e,i,o){(0,a.default)(this,t);var n=(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o));return n._setMargins(o),n}return(0,f.default)(t,e),(0,h.default)(t,[{key:"resize",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.selected,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this.hover;if(this.needsRefresh(t,i)){this.textSize=this.labelModule.getTextSize(e,t,i);var o=Math.max(this.textSize.width+this.margin.right+this.margin.left,this.textSize.height+this.margin.top+this.margin.bottom);this.options.size=o/2,this.width=o,this.height=o,this.radius=this.width/2}}},{key:"draw",value:function(e,t,i,o,n,s){this.resize(e,o,n),this.left=t-this.width/2,this.top=i-this.height/2,this._drawRawCircle(e,t,i,s),this.updateBoundingBox(t,i),this.labelModule.draw(e,this.left+this.textSize.width/2+this.margin.left,i,o,n)}},{key:"updateBoundingBox",value:function(e,t){this.boundingBox.top=t-this.options.size,this.boundingBox.left=e-this.options.size,this.boundingBox.right=e+this.options.size,this.boundingBox.bottom=t+this.options.size}},{key:"distanceToBorder",value:function(e,t){return this.resize(e),.5*this.width}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(129),v=o(p),g=i(110),y=(o(g),function(e){function t(e,i,o){(0,a.default)(this,t);var n=(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o));return n.labelOffset=0,n.selected=!1,n}return(0,f.default)(t,e),(0,h.default)(t,[{key:"setOptions",value:function(e,t,i){this.options=e,void 0===t&&void 0===i||this.setImages(t,i)}},{key:"setImages",value:function(e,t){t&&this.selected?(this.imageObj=t,this.imageObjAlt=e):(this.imageObj=e,this.imageObjAlt=t)}},{key:"switchImages",value:function(e){var t=e&&!this.selected||!e&&this.selected;if(this.selected=e,void 0!==this.imageObjAlt&&t){var i=this.imageObj;this.imageObj=this.imageObjAlt,this.imageObjAlt=i}}},{key:"_resizeImage",value:function(){var e,t;if(this.options.shapeProperties.useImageSize===!1){var i=1,o=1;this.imageObj.width&&this.imageObj.height&&(this.imageObj.width>this.imageObj.height?i=this.imageObj.width/this.imageObj.height:o=this.imageObj.height/this.imageObj.width),e=2*this.options.size*i,t=2*this.options.size*o}else e=this.imageObj.width,t=this.imageObj.height;this.width=e,this.height=t,this.radius=.5*this.width}},{key:"_drawRawCircle",value:function(e,t,i,o){this.initContextForDraw(e,o),e.circle(t,i,o.size),this.performFill(e,o)}},{key:"_drawImageAtPosition",value:function(e,t){if(0!=this.imageObj.width){e.globalAlpha=1,this.enableShadow(e,t);var i=1;this.options.shapeProperties.interpolation===!0&&(i=this.imageObj.width/this.width/this.body.view.scale),this.imageObj.drawImageAtPosition(e,i,this.left,this.top,this.width,this.height),this.disableShadow(e,t)}}},{key:"_drawImageLabel",value:function(e,t,i,o,n){var s,r=0;if(void 0!==this.height){r=.5*this.height;var a=this.labelModule.getTextSize(e,o,n);a.lineCount>=1&&(r+=a.height/2)}s=i+r,this.options.label&&(this.labelOffset=r),this.labelModule.draw(e,t,s,o,n,"hanging")}}]),t}(v.default));t.default=y},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(131),v=o(p),g=function(e){function t(e,i,o,n,r){(0,a.default)(this,t);var d=(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o));return d.setImages(n,r),d}return(0,f.default)(t,e),(0,h.default)(t,[{key:"resize",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.selected,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this.hover,o=void 0===this.imageObj.src||void 0===this.imageObj.width||void 0===this.imageObj.height;if(o){var n=2*this.options.size;return this.width=n,this.height=n,void(this.radius=.5*this.width)}this.needsRefresh(t,i)&&this._resizeImage()}},{key:"draw",value:function(e,t,i,o,n,s){this.switchImages(o),this.resize(),this.left=t-this.width/2,this.top=i-this.height/2,this._drawRawCircle(e,t,i,s),e.save(),e.clip(),this._drawImageAtPosition(e,s),e.restore(),this._drawImageLabel(e,t,i,o,n),this.updateBoundingBox(t,i)}},{key:"updateBoundingBox",value:function(e,t){this.boundingBox.top=t-this.options.size,this.boundingBox.left=e-this.options.size,this.boundingBox.right=e+this.options.size,this.boundingBox.bottom=t+this.options.size,this.boundingBox.left=Math.min(this.boundingBox.left,this.labelModule.size.left),this.boundingBox.right=Math.max(this.boundingBox.right,this.labelModule.size.left+this.labelModule.size.width),this.boundingBox.bottom=Math.max(this.boundingBox.bottom,this.boundingBox.bottom+this.labelOffset)}},{key:"distanceToBorder",value:function(e,t){return this.resize(e),.5*this.width}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(129),v=o(p),g=function(e){function t(e,i,o){(0,a.default)(this,t);var n=(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o));return n._setMargins(o),n}return(0,f.default)(t,e),(0,h.default)(t,[{key:"resize",value:function(e,t,i){if(this.needsRefresh(t,i)){this.textSize=this.labelModule.getTextSize(e,t,i);var o=this.textSize.width+this.margin.right+this.margin.left;this.width=o,this.height=o,this.radius=this.width/2}}},{key:"draw",value:function(e,t,i,o,n,s){this.resize(e,o,n),this.left=t-this.width/2,this.top=i-this.height/2,this.initContextForDraw(e,s),e.database(t-this.width/2,i-this.height/2,this.width,this.height),this.performFill(e,s),this.updateBoundingBox(t,i,e,o,n),this.labelModule.draw(e,this.left+this.textSize.width/2+this.margin.left,this.top+this.textSize.height/2+this.margin.top,o,n)}},{key:"distanceToBorder",value:function(e,t){return this._distanceToBorder(e,t)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(135),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"draw",value:function(e,t,i,o,n,s){this._drawShape(e,"diamond",4,t,i,o,n,s)}},{key:"distanceToBorder",value:function(e,t){return this._distanceToBorder(e,t)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(129),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"resize",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.selected,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this.hover,o=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{size:this.options.size};if(this.needsRefresh(t,i)){this.labelModule.getTextSize(e,t,i);var n=2*o.size;this.width=n,this.height=n,this.radius=.5*this.width}}},{key:"_drawShape",value:function(e,t,i,o,n,s,r,a){if(this.resize(e,s,r,a),this.left=o-this.width/2,this.top=n-this.height/2,this.initContextForDraw(e,a),e[t](o,n,a.size),this.performFill(e,a),void 0!==this.options.label){this.labelModule.calculateLabelSize(e,s,r,o,n,"hanging");var d=n+.5*this.height+.5*this.labelModule.size.height;this.labelModule.draw(e,o,d,s,r,"hanging")}this.updateBoundingBox(o,n)}},{key:"updateBoundingBox",value:function(e,t){this.boundingBox.top=t-this.options.size,this.boundingBox.left=e-this.options.size,this.boundingBox.right=e+this.options.size,this.boundingBox.bottom=t+this.options.size,void 0!==this.options.label&&this.labelModule.size.width>0&&(this.boundingBox.left=Math.min(this.boundingBox.left,this.labelModule.size.left),this.boundingBox.right=Math.max(this.boundingBox.right,this.labelModule.size.left+this.labelModule.size.width),this.boundingBox.bottom=Math.max(this.boundingBox.bottom,this.boundingBox.bottom+this.labelModule.size.height))}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(135),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"draw",value:function(e,t,i,o,n,s){this._drawShape(e,"circle",2,t,i,o,n,s)}},{key:"distanceToBorder",value:function(e,t){return this.resize(e),this.options.size}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(129),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"resize",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.selected,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this.hover;if(this.needsRefresh(t,i)){var o=this.labelModule.getTextSize(e,t,i);this.height=2*o.height,this.width=o.width+this.height,this.radius=.5*this.width}}},{key:"draw",value:function(e,t,i,o,n,s){this.resize(e,o,n),this.left=t-.5*this.width,this.top=i-.5*this.height,this.initContextForDraw(e,s),e.ellipse_vis(this.left,this.top,this.width,this.height),this.performFill(e,s),this.updateBoundingBox(t,i,e,o,n),this.labelModule.draw(e,t,i,o,n)}},{key:"distanceToBorder",value:function(e,t){this.resize(e);var i=.5*this.width,o=.5*this.height,n=Math.sin(t)*i,s=Math.cos(t)*o;return i*o/Math.sqrt(n*n+s*s)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(129),v=o(p),g=function(e){function t(e,i,o){(0,a.default)(this,t);var n=(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o));return n._setMargins(o),n}return(0,f.default)(t,e),(0,h.default)(t,[{key:"resize",value:function(e,t,i){this.needsRefresh(t,i)&&(this.iconSize={width:Number(this.options.icon.size),height:Number(this.options.icon.size)},this.width=this.iconSize.width+this.margin.right+this.margin.left,this.height=this.iconSize.height+this.margin.top+this.margin.bottom,this.radius=.5*this.width)}},{key:"draw",value:function(e,t,i,o,n,s){if(this.resize(e,o,n),this.options.icon.size=this.options.icon.size||50,this.left=t-this.width/2,this.top=i-this.height/2,this._icon(e,t,i,o,n,s),void 0!==this.options.label){var r=5;this.labelModule.draw(e,this.left+this.iconSize.width/2+this.margin.left,i+this.height/2+r,o)}this.updateBoundingBox(t,i)}},{key:"updateBoundingBox",value:function(e,t){if(this.boundingBox.top=t-.5*this.options.icon.size,this.boundingBox.left=e-.5*this.options.icon.size,this.boundingBox.right=e+.5*this.options.icon.size,this.boundingBox.bottom=t+.5*this.options.icon.size,void 0!==this.options.label&&this.labelModule.size.width>0){var i=5;this.boundingBox.left=Math.min(this.boundingBox.left,this.labelModule.size.left),this.boundingBox.right=Math.max(this.boundingBox.right,this.labelModule.size.left+this.labelModule.size.width),this.boundingBox.bottom=Math.max(this.boundingBox.bottom,this.boundingBox.bottom+this.labelModule.size.height+i)}}},{key:"_icon",value:function(e,t,i,o,n,s){var r=Number(this.options.icon.size);void 0!==this.options.icon.code?(e.font=(o?"bold ":"")+r+"px "+this.options.icon.face,e.fillStyle=this.options.icon.color||"black",e.textAlign="center",e.textBaseline="middle",this.enableShadow(e,s),e.fillText(this.options.icon.code,t,i),this.disableShadow(e,s)):console.error("When using the icon shape, you need to define the code in the icon options object. This can be done per node or globally.")}},{key:"distanceToBorder",value:function(e,t){return this._distanceToBorder(e,t)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(131),v=o(p),g=function(e){function t(e,i,o,n,r){(0,a.default)(this,t);var d=(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o));return d.setImages(n,r),d}return(0,f.default)(t,e),(0,h.default)(t,[{key:"resize",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.selected,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this.hover,o=void 0===this.imageObj.src||void 0===this.imageObj.width||void 0===this.imageObj.height;if(o){var n=2*this.options.size;return this.width=n,void(this.height=n)}this.needsRefresh(t,i)&&this._resizeImage()}},{key:"draw",value:function(e,t,i,o,n,s){if(this.switchImages(o),this.resize(),this.left=t-this.width/2,this.top=i-this.height/2,this.options.shapeProperties.useBorderWithImage===!0){var r=this.options.borderWidth,a=this.options.borderWidthSelected||2*this.options.borderWidth,d=(o?a:r)/this.body.view.scale;e.lineWidth=Math.min(this.width,d),e.beginPath(),e.strokeStyle=o?this.options.color.highlight.border:n?this.options.color.hover.border:this.options.color.border,e.fillStyle=o?this.options.color.highlight.background:n?this.options.color.hover.background:this.options.color.background,e.rect(this.left-.5*e.lineWidth,this.top-.5*e.lineWidth,this.width+e.lineWidth,this.height+e.lineWidth),e.fill(),this.performStroke(e,s),e.closePath()}this._drawImageAtPosition(e,s),this._drawImageLabel(e,t,i,o,n),this.updateBoundingBox(t,i)}},{key:"updateBoundingBox",value:function(e,t){this.resize(),this._updateBoundingBox(e,t),void 0!==this.options.label&&this.labelModule.size.width>0&&(this.boundingBox.left=Math.min(this.boundingBox.left,this.labelModule.size.left),this.boundingBox.right=Math.max(this.boundingBox.right,this.labelModule.size.left+this.labelModule.size.width),this.boundingBox.bottom=Math.max(this.boundingBox.bottom,this.boundingBox.bottom+this.labelOffset))}},{key:"distanceToBorder",value:function(e,t){return this._distanceToBorder(e,t)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(135),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"draw",value:function(e,t,i,o,n,s){this._drawShape(e,"square",2,t,i,o,n,s)}},{key:"distanceToBorder",value:function(e,t){return this._distanceToBorder(e,t)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(135),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"draw",value:function(e,t,i,o,n,s){this._drawShape(e,"star",4,t,i,o,n,s)}},{key:"distanceToBorder",value:function(e,t){return this._distanceToBorder(e,t)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(129),v=o(p),g=function(e){function t(e,i,o){(0,a.default)(this,t);var n=(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o));return n._setMargins(o),n}return(0,f.default)(t,e),(0,h.default)(t,[{key:"resize",value:function(e,t,i){this.needsRefresh(t,i)&&(this.textSize=this.labelModule.getTextSize(e,t,i),this.width=this.textSize.width+this.margin.right+this.margin.left,this.height=this.textSize.height+this.margin.top+this.margin.bottom,this.radius=.5*this.width)}},{key:"draw",value:function(e,t,i,o,n,s){this.resize(e,o,n),this.left=t-this.width/2,this.top=i-this.height/2,this.enableShadow(e,s),this.labelModule.draw(e,this.left+this.textSize.width/2+this.margin.left,this.top+this.textSize.height/2+this.margin.top,o,n),this.disableShadow(e,s),this.updateBoundingBox(t,i,e,o,n)}},{key:"distanceToBorder",value:function(e,t){return this._distanceToBorder(e,t)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(135),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"draw",value:function(e,t,i,o,n,s){this._drawShape(e,"triangle",3,t,i,o,n,s)}},{key:"distanceToBorder",value:function(e,t){return this._distanceToBorder(e,t)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(135),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"draw",value:function(e,t,i,o,n,s){this._drawShape(e,"triangleDown",3,t,i,o,n,s)}},{key:"distanceToBorder",value:function(e,t){return this._distanceToBorder(e,t)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0}),t.printStyle=void 0;var n=i(89),s=o(n),r=i(62),a=o(r),d=i(58),h=o(d),l=i(105),u=o(l),c=i(106),f=o(c),p=i(1),v=!1,g=void 0,y="background: #FFeeee; color: #dd0000",m=function(){function e(){(0,u.default)(this,e)}return(0,f.default)(e,null,[{key:"validate",value:function(t,i,o){v=!1,g=i;var n=i;return void 0!==o&&(n=i[o]),e.parse(t,n,[]),v}},{key:"parse",value:function(t,i,o){for(var n in t)t.hasOwnProperty(n)&&e.check(n,t,i,o)}},{key:"check",value:function(t,i,o,n){void 0===o[t]&&void 0===o.__any__?e.getSuggestion(t,o,n):void 0===o[t]&&void 0!==o.__any__?"object"===e.getType(i[t])&&void 0!==o.__any__.__type__?e.checkFields(t,i,o,"__any__",o.__any__.__type__,n):e.checkFields(t,i,o,"__any__",o.__any__,n):void 0!==o[t].__type__?e.checkFields(t,i,o,t,o[t].__type__,n):e.checkFields(t,i,o,t,o[t],n)}},{key:"checkFields",value:function(t,i,o,n,s,r){var a=e.getType(i[t]),d=s[a];void 0!==d?"array"===e.getType(d)&&d.indexOf(i[t])===-1?(console.log('%cInvalid option detected in "'+t+'". Allowed values are:'+e.print(d)+' not "'+i[t]+'". '+e.printLocation(r,t),y),v=!0):"object"===a&&"__any__"!==n&&(r=p.copyAndExtendArray(r,t),e.parse(i[t],o[n],r)):void 0===s.any&&(console.log('%cInvalid type received for "'+t+'". Expected: '+e.print((0,h.default)(s))+". Received ["+a+'] "'+i[t]+'"'+e.printLocation(r,t),y),v=!0)}},{key:"getType",value:function(e){var t="undefined"==typeof e?"undefined":(0,a.default)(e);return"object"===t?null===e?"null":e instanceof Boolean?"boolean":e instanceof Number?"number":e instanceof String?"string":Array.isArray(e)?"array":e instanceof Date?"date":void 0!==e.nodeType?"dom":e._isAMomentObject===!0?"moment":"object":"number"===t?"number":"boolean"===t?"boolean":"string"===t?"string":void 0===t?"undefined":t}},{key:"getSuggestion",value:function(t,i,o){var n=e.findInOptions(t,i,o,!1),s=e.findInOptions(t,g,[],!0),r=8,a=4;void 0!==n.indexMatch?console.log('%cUnknown option detected: "'+t+'" in '+e.printLocation(n.path,t,"")+'Perhaps it was incomplete? Did you mean: "'+n.indexMatch+'"?\n\n',y):s.distance<=a&&n.distance>s.distance?console.log('%cUnknown option detected: "'+t+'" in '+e.printLocation(n.path,t,"")+"Perhaps it was misplaced? Matching option found at: "+e.printLocation(s.path,s.closestMatch,""),y):n.distance<=r?console.log('%cUnknown option detected: "'+t+'". Did you mean "'+n.closestMatch+'"?'+e.printLocation(n.path,t),y):console.log('%cUnknown option detected: "'+t+'". Did you mean one of these: '+e.print((0,h.default)(i))+e.printLocation(o,t),y),v=!0}},{key:"findInOptions",value:function(t,i,o){var n=arguments.length>3&&void 0!==arguments[3]&&arguments[3],s=1e9,r="",a=[],d=t.toLowerCase(),h=void 0;for(var l in i){var u=void 0;if(void 0!==i[l].__type__&&n===!0){var c=e.findInOptions(t,i[l],p.copyAndExtendArray(o,l));s>c.distance&&(r=c.closestMatch,a=c.path,s=c.distance,h=c.indexMatch)}else l.toLowerCase().indexOf(d)!==-1&&(h=l),u=e.levenshteinDistance(t,l),s>u&&(r=l,a=p.copyArray(o),s=u)}return{closestMatch:r,path:a,distance:s,indexMatch:h}}},{key:"printLocation",value:function(e,t){for(var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"Problem value found at: \n",o="\n\n"+i+"options = {\n",n=0;n<e.length;n++){for(var s=0;s<n+1;s++)o+="  ";o+=e[n]+": {\n"}for(var r=0;r<e.length+1;r++)o+="  ";o+=t+"\n";for(var a=0;a<e.length+1;a++){for(var d=0;d<e.length-a;d++)o+="  ";o+="}\n"}return o+"\n\n"}},{key:"print",value:function(e){return(0,s.default)(e).replace(/(\")|(\[)|(\])|(,"__type__")/g,"").replace(/(\,)/g,", ")}},{key:"levenshteinDistance",value:function(e,t){if(0===e.length)return t.length;if(0===t.length)return e.length;var i,o=[];for(i=0;i<=t.length;i++)o[i]=[i];var n;for(n=0;n<=e.length;n++)o[0][n]=n;for(i=1;i<=t.length;i++)for(n=1;n<=e.length;n++)t.charAt(i-1)==e.charAt(n-1)?o[i][n]=o[i-1][n-1]:o[i][n]=Math.min(o[i-1][n-1]+1,Math.min(o[i][n-1]+1,o[i-1][n]+1));return o[t.length][e.length]}}]),e}();t.default=m,t.printStyle=y},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=i(1),h=i(88),l=i(92),u=i(147).default,c=i(114).default,f=(i(155).default,function(){function e(t,i,o){var n=this;(0,s.default)(this,e),this.body=t,this.images=i,this.groups=o,this.body.functions.createEdge=this.create.bind(this),this.edgesListeners={add:function(e,t){n.add(t.items)},update:function(e,t){n.update(t.items)},remove:function(e,t){n.remove(t.items)}},this.options={},this.defaultOptions={arrows:{to:{enabled:!1,scaleFactor:1,type:"arrow"},middle:{enabled:!1,scaleFactor:1,type:"arrow"},from:{enabled:!1,scaleFactor:1,type:"arrow"}},arrowStrikethrough:!0,color:{color:"#848484",highlight:"#848484",hover:"#848484",inherit:"from",opacity:1},dashes:!1,font:{color:"#343434",size:14,face:"arial",background:"none",strokeWidth:2,strokeColor:"#ffffff",align:"horizontal",multi:!1,vadjust:0,bold:{mod:"bold"},boldital:{mod:"bold italic"},ital:{mod:"italic"},mono:{mod:"",size:15,face:"courier new",vadjust:2}},hidden:!1,hoverWidth:1.5,label:void 0,labelHighlightBold:!0,length:void 0,physics:!0,scaling:{min:1,max:15,label:{enabled:!0,min:14,max:30,maxVisible:30,drawThreshold:5},customScalingFunction:function(e,t,i,o){if(t===e)return.5;var n=1/(t-e);return Math.max(0,(o-e)*n)}},selectionWidth:1.5,selfReferenceSize:20,shadow:{enabled:!1,color:"rgba(0,0,0,0.5)",size:10,x:5,y:5},smooth:{enabled:!0,type:"dynamic",forceDirection:"none",roundness:.5},title:void 0,width:1,value:void 0},d.extend(this.options,this.defaultOptions),this.bindEventListeners()}return(0,a.default)(e,[{key:"bindEventListeners",value:function(){var e=this;this.body.emitter.on("_forceDisableDynamicCurves",function(t){var i=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];"dynamic"===t&&(t="continuous");var o=!1;for(var n in e.body.edges)if(e.body.edges.hasOwnProperty(n)){var s=e.body.edges[n],r=e.body.data.edges._data[n];if(void 0!==r){var a=r.smooth;void 0!==a&&a.enabled===!0&&"dynamic"===a.type&&(void 0===t?s.setOptions({smooth:!1}):s.setOptions({smooth:{type:t}}),o=!0)}}i===!0&&o===!0&&e.body.emitter.emit("_dataChanged")}),this.body.emitter.on("_dataUpdated",function(){e.reconnectEdges()}),this.body.emitter.on("refreshEdges",this.refresh.bind(this)),this.body.emitter.on("refresh",this.refresh.bind(this)),this.body.emitter.on("destroy",function(){d.forEach(e.edgesListeners,function(t,i){e.body.data.edges&&e.body.data.edges.off(i,t)}),delete e.body.functions.createEdge,delete e.edgesListeners.add,delete e.edgesListeners.update,delete e.edgesListeners.remove,delete e.edgesListeners})}},{key:"setOptions",value:function(e){if(this.edgeOptions=e,void 0!==e){u.parseOptions(this.options,e);var t=!1;if(void 0!==e.smooth)for(var i in this.body.edges)this.body.edges.hasOwnProperty(i)&&(t=this.body.edges[i].updateEdgeType()||t);if(void 0!==e.font){c.parseOptions(this.options.font,e);for(var o in this.body.edges)this.body.edges.hasOwnProperty(o)&&this.body.edges[o].updateLabelModule()}void 0===e.hidden&&void 0===e.physics&&t!==!0||this.body.emitter.emit("_dataChanged")}}},{key:"setData",value:function(e){
var t=this,i=arguments.length>1&&void 0!==arguments[1]&&arguments[1],o=this.body.data.edges;if(e instanceof h||e instanceof l)this.body.data.edges=e;else if(Array.isArray(e))this.body.data.edges=new h,this.body.data.edges.add(e);else{if(e)throw new TypeError("Array or DataSet expected");this.body.data.edges=new h}if(o&&d.forEach(this.edgesListeners,function(e,t){o.off(t,e)}),this.body.edges={},this.body.data.edges){d.forEach(this.edgesListeners,function(e,i){t.body.data.edges.on(i,e)});var n=this.body.data.edges.getIds();this.add(n,!0)}this.body.emitter.emit("_adjustEdgesForHierarchicalLayout"),i===!1&&this.body.emitter.emit("_dataChanged")}},{key:"add",value:function(e){for(var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],i=this.body.edges,o=this.body.data.edges,n=0;n<e.length;n++){var s=e[n],r=i[s];r&&r.disconnect();var a=o.get(s,{showInternalIds:!0});i[s]=this.create(a)}this.body.emitter.emit("_adjustEdgesForHierarchicalLayout"),t===!1&&this.body.emitter.emit("_dataChanged")}},{key:"update",value:function(e){for(var t=this.body.edges,i=this.body.data.edges,o=!1,n=0;n<e.length;n++){var s=e[n],r=i.get(s),a=t[s];void 0!==a?(a.disconnect(),o=a.setOptions(r)||o,a.connect()):(this.body.edges[s]=this.create(r),o=!0)}o===!0?(this.body.emitter.emit("_adjustEdgesForHierarchicalLayout"),this.body.emitter.emit("_dataChanged")):this.body.emitter.emit("_dataUpdated")}},{key:"remove",value:function(e){for(var t=this.body.edges,i=0;i<e.length;i++){var o=e[i],n=t[o];void 0!==n&&(n.cleanup(),n.disconnect(),delete t[o])}this.body.emitter.emit("_dataChanged")}},{key:"refresh",value:function(){var e=this.body.edges;for(var t in e){var i=void 0;e.hasOwnProperty(t)&&(i=e[t]);var o=this.body.data.edges._data[t];void 0!==i&&void 0!==o&&i.setOptions(o)}}},{key:"create",value:function(e){return new u(e,this.body,this.options,this.defaultOptions,this.edgeOptions)}},{key:"reconnectEdges",value:function(){var e,t=this.body.nodes,i=this.body.edges;for(e in t)t.hasOwnProperty(e)&&(t[e].edges=[]);for(e in i)if(i.hasOwnProperty(e)){var o=i[e];o.from=null,o.to=null,o.connect()}}},{key:"getConnectedNodes",value:function(e){var t=[];if(void 0!==this.body.edges[e]){var i=this.body.edges[e];void 0!==i.fromId&&t.push(i.fromId),void 0!==i.toId&&t.push(i.toId)}return t}}]),e}());t.default=f},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(89),s=o(n),r=i(55),a=o(r),d=i(62),h=o(d),l=i(105),u=o(l),c=i(106),f=o(c),p=i(1),v=i(114).default,g=i(148).default,y=i(152).default,m=i(153).default,b=i(154).default,_=function(){function e(t,i,o,n,s){if((0,u.default)(this,e),void 0===i)throw"No body provided";this.options=p.bridgeObject(o),this.globalOptions=o,this.defaultOptions=n,this.edgeOptions=s,this.body=i,this.id=void 0,this.fromId=void 0,this.toId=void 0,this.selected=!1,this.hover=!1,this.labelDirty=!0,this.baseWidth=this.options.width,this.baseFontSize=this.options.font.size,this.from=void 0,this.to=void 0,this.edgeType=void 0,this.connected=!1,this.labelModule=new v(this.body,this.options,!0),this.setOptions(t)}return(0,f.default)(e,[{key:"setOptions",value:function(t){if(t){e.parseOptions(this.options,t,!0,this.globalOptions),void 0!==t.id&&(this.id=t.id),void 0!==t.from&&(this.fromId=t.from),void 0!==t.to&&(this.toId=t.to),void 0!==t.title&&(this.title=t.title),void 0!==t.value&&(t.value=parseFloat(t.value)),this.choosify(t),this.updateLabelModule(t),this.labelModule.propagateFonts(this.edgeOptions,t,this.defaultOptions);var i=this.updateEdgeType();return this._setInteractionWidths(),this.connect(),void 0===t.hidden&&void 0===t.physics||(i=!0),i}}},{key:"choosify",value:function(e){this.chooser=!0;var t=[e,this.options,this.edgeOptions,this.defaultOptions],i=p.topMost(t,"chosen");if("boolean"==typeof i)this.chooser=i;else if("object"===("undefined"==typeof i?"undefined":(0,h.default)(i))){var o=p.topMost(t,["chosen","edge"]);"boolean"!=typeof o&&"function"!=typeof o||(this.chooser=o)}}},{key:"getFormattingValues",value:function(){var e=this.options.arrows.to===!0||this.options.arrows.to.enabled===!0,t=this.options.arrows.from===!0||this.options.arrows.from.enabled===!0,i=this.options.arrows.middle===!0||this.options.arrows.middle.enabled===!0,o=this.options.color.inherit,n={toArrow:e,toArrowScale:this.options.arrows.to.scaleFactor,toArrowType:this.options.arrows.to.type,middleArrow:i,middleArrowScale:this.options.arrows.middle.scaleFactor,middleArrowType:this.options.arrows.middle.type,fromArrow:t,fromArrowScale:this.options.arrows.from.scaleFactor,fromArrowType:this.options.arrows.from.type,arrowStrikethrough:this.options.arrowStrikethrough,color:o?void 0:this.options.color.color,inheritsColor:o,opacity:this.options.color.opacity,hidden:this.options.hidden,length:this.options.length,shadow:this.options.shadow.enabled,shadowColor:this.options.shadow.color,shadowSize:this.options.shadow.size,shadowX:this.options.shadow.x,shadowY:this.options.shadow.y,dashes:this.options.dashes,width:this.options.width};if(this.selected||this.hover)if(this.chooser===!0){if(this.selected){var s=this.options.selectionWidth;"function"==typeof s?n.width=s(n.width):"number"==typeof s&&(n.width+=s),n.width=Math.max(n.width,.3/this.body.view.scale),n.color=this.options.color.highlight,n.shadow=this.options.shadow.enabled}else if(this.hover){var r=this.options.hoverWidth;"function"==typeof r?n.width=r(n.width):"number"==typeof r&&(n.width+=r),n.width=Math.max(n.width,.3/this.body.view.scale),n.color=this.options.color.hover,n.shadow=this.options.shadow.enabled}}else"function"==typeof this.chooser&&(this.chooser(n,this.options.id,this.selected,this.hover),void 0!==n.color&&(n.inheritsColor=!1),n.shadow===!1&&(n.shadowColor===this.options.shadow.color&&n.shadowSize===this.options.shadow.size&&n.shadowX===this.options.shadow.x&&n.shadowY===this.options.shadow.y||(n.shadow=!0)));else n.shadow=this.options.shadow.enabled,n.width=Math.max(n.width,.3/this.body.view.scale);return n}},{key:"updateLabelModule",value:function(e){this.labelModule.setOptions(this.options,!0),void 0!==this.labelModule.baseSize&&(this.baseFontSize=this.labelModule.baseSize),this.labelModule.constrain(this.edgeOptions,e,this.defaultOptions),this.labelModule.choosify(this.edgeOptions,e,this.defaultOptions)}},{key:"updateEdgeType",value:function(){var e=this.options.smooth,t=!1,i=!0;return void 0!==this.edgeType&&((this.edgeType instanceof y&&e.enabled===!0&&"dynamic"===e.type||this.edgeType instanceof g&&e.enabled===!0&&"cubicBezier"===e.type||this.edgeType instanceof m&&e.enabled===!0&&"dynamic"!==e.type&&"cubicBezier"!==e.type||this.edgeType instanceof b&&e.type.enabled===!1)&&(i=!1),i===!0&&(t=this.cleanup())),i===!0?e.enabled===!0?"dynamic"===e.type?(t=!0,this.edgeType=new y(this.options,this.body,this.labelModule)):"cubicBezier"===e.type?this.edgeType=new g(this.options,this.body,this.labelModule):this.edgeType=new m(this.options,this.body,this.labelModule):this.edgeType=new b(this.options,this.body,this.labelModule):this.edgeType.setOptions(this.options),t}},{key:"connect",value:function(){this.disconnect(),this.from=this.body.nodes[this.fromId]||void 0,this.to=this.body.nodes[this.toId]||void 0,this.connected=void 0!==this.from&&void 0!==this.to,this.connected===!0?(this.from.attachEdge(this),this.to.attachEdge(this)):(this.from&&this.from.detachEdge(this),this.to&&this.to.detachEdge(this)),this.edgeType.connect()}},{key:"disconnect",value:function(){this.from&&(this.from.detachEdge(this),this.from=void 0),this.to&&(this.to.detachEdge(this),this.to=void 0),this.connected=!1}},{key:"getTitle",value:function(){return this.title}},{key:"isSelected",value:function(){return this.selected}},{key:"getValue",value:function(){return this.options.value}},{key:"setValueRange",value:function(e,t,i){if(void 0!==this.options.value){var o=this.options.scaling.customScalingFunction(e,t,i,this.options.value),n=this.options.scaling.max-this.options.scaling.min;if(this.options.scaling.label.enabled===!0){var s=this.options.scaling.label.max-this.options.scaling.label.min;this.options.font.size=this.options.scaling.label.min+o*s}this.options.width=this.options.scaling.min+o*n}else this.options.width=this.baseWidth,this.options.font.size=this.baseFontSize;this._setInteractionWidths(),this.updateLabelModule()}},{key:"_setInteractionWidths",value:function(){"function"==typeof this.options.hoverWidth?this.edgeType.hoverWidth=this.options.hoverWidth(this.options.width):this.edgeType.hoverWidth=this.options.hoverWidth+this.options.width,"function"==typeof this.options.selectionWidth?this.edgeType.selectionWidth=this.options.selectionWidth(this.options.width):this.edgeType.selectionWidth=this.options.selectionWidth+this.options.width}},{key:"draw",value:function(e){var t=this.getFormattingValues();if(!t.hidden){var i=this.edgeType.getViaNode(),o={};this.edgeType.fromPoint=this.edgeType.from,this.edgeType.toPoint=this.edgeType.to,t.fromArrow&&(o.from=this.edgeType.getArrowData(e,"from",i,this.selected,this.hover,t),t.arrowStrikethrough===!1&&(this.edgeType.fromPoint=o.from.core)),t.toArrow&&(o.to=this.edgeType.getArrowData(e,"to",i,this.selected,this.hover,t),t.arrowStrikethrough===!1&&(this.edgeType.toPoint=o.to.core)),t.middleArrow&&(o.middle=this.edgeType.getArrowData(e,"middle",i,this.selected,this.hover,t)),this.edgeType.drawLine(e,t,this.selected,this.hover,i),this.drawArrows(e,o,t),this.drawLabel(e,i)}}},{key:"drawArrows",value:function(e,t,i){i.fromArrow&&this.edgeType.drawArrowHead(e,i,this.selected,this.hover,t.from),i.middleArrow&&this.edgeType.drawArrowHead(e,i,this.selected,this.hover,t.middle),i.toArrow&&this.edgeType.drawArrowHead(e,i,this.selected,this.hover,t.to)}},{key:"drawLabel",value:function(e,t){if(void 0!==this.options.label){var i=this.from,o=this.to;if(this.labelModule.differentState(this.selected,this.hover)&&this.labelModule.getTextSize(e,this.selected,this.hover),i.id!=o.id){this.labelModule.pointToSelf=!1;var n=this.edgeType.getPoint(.5,t);e.save(),"horizontal"!==this.options.font.align&&(this.labelModule.calculateLabelSize(e,this.selected,this.hover,n.x,n.y),e.translate(n.x,this.labelModule.size.yLine),this._rotateForLabelAlignment(e)),this.labelModule.draw(e,n.x,n.y,this.selected,this.hover),e.restore()}else{this.labelModule.pointToSelf=!0;var s,r,a=this.options.selfReferenceSize;i.shape.width>i.shape.height?(s=i.x+.5*i.shape.width,r=i.y-a):(s=i.x+a,r=i.y-.5*i.shape.height),n=this._pointOnCircle(s,r,a,.125),this.labelModule.draw(e,n.x,n.y,this.selected,this.hover)}}}},{key:"isOverlappingWith",value:function(e){if(this.connected){var t=10,i=this.from.x,o=this.from.y,n=this.to.x,s=this.to.y,r=e.left,a=e.top,d=this.edgeType.getDistanceToEdge(i,o,n,s,r,a);return d<t}return!1}},{key:"_rotateForLabelAlignment",value:function(e){var t=this.from.y-this.to.y,i=this.from.x-this.to.x,o=Math.atan2(t,i);(o<-1&&i<0||o>0&&i<0)&&(o+=Math.PI),e.rotate(o)}},{key:"_pointOnCircle",value:function(e,t,i,o){var n=2*o*Math.PI;return{x:e+i*Math.cos(n),y:t-i*Math.sin(n)}}},{key:"select",value:function(){this.selected=!0}},{key:"unselect",value:function(){this.selected=!1}},{key:"cleanup",value:function(){return this.edgeType.cleanup()}}],[{key:"parseOptions",value:function(e,t){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],o=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},n=["arrowStrikethrough","id","from","hidden","hoverWidth","label","labelHighlightBold","length","line","opacity","physics","scaling","selectionWidth","selfReferenceSize","to","title","value","width"];if(p.selectiveDeepExtend(n,e,t,i),p.mergeOptions(e,t,"smooth",i,o),p.mergeOptions(e,t,"shadow",i,o),void 0!==t.dashes&&null!==t.dashes?e.dashes=t.dashes:i===!0&&null===t.dashes&&(e.dashes=(0,a.default)(o.dashes)),void 0!==t.scaling&&null!==t.scaling?(void 0!==t.scaling.min&&(e.scaling.min=t.scaling.min),void 0!==t.scaling.max&&(e.scaling.max=t.scaling.max),p.mergeOptions(e.scaling,t.scaling,"label",i,o.scaling)):i===!0&&null===t.scaling&&(e.scaling=(0,a.default)(o.scaling)),void 0!==t.arrows&&null!==t.arrows)if("string"==typeof t.arrows){var r=t.arrows.toLowerCase();e.arrows.to.enabled=r.indexOf("to")!=-1,e.arrows.middle.enabled=r.indexOf("middle")!=-1,e.arrows.from.enabled=r.indexOf("from")!=-1}else{if("object"!==(0,h.default)(t.arrows))throw new Error("The arrow newOptions can only be an object or a string. Refer to the documentation. You used:"+(0,s.default)(t.arrows));p.mergeOptions(e.arrows,t.arrows,"to",i,o.arrows),p.mergeOptions(e.arrows,t.arrows,"middle",i,o.arrows),p.mergeOptions(e.arrows,t.arrows,"from",i,o.arrows)}else i===!0&&null===t.arrows&&(e.arrows=(0,a.default)(o.arrows));if(void 0!==t.color&&null!==t.color)if(e.color=p.deepExtend({},e.color,!0),p.isString(t.color))e.color.color=t.color,e.color.highlight=t.color,e.color.hover=t.color,e.color.inherit=!1;else{var d=!1;void 0!==t.color.color&&(e.color.color=t.color.color,d=!0),void 0!==t.color.highlight&&(e.color.highlight=t.color.highlight,d=!0),void 0!==t.color.hover&&(e.color.hover=t.color.hover,d=!0),void 0!==t.color.inherit&&(e.color.inherit=t.color.inherit),void 0!==t.color.opacity&&(e.color.opacity=Math.min(1,Math.max(0,t.color.opacity))),void 0===t.color.inherit&&d===!0&&(e.color.inherit=!1)}else i===!0&&null===t.color&&(e.color=p.bridgeObject(o.color));void 0!==t.font&&null!==t.font?v.parseOptions(e.font,t):i===!0&&null===t.font&&(e.font=p.bridgeObject(o.font))}}]),e}();t.default=_},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(115),s=o(n),r=i(120),a=o(r),d=i(105),h=o(d),l=i(106),u=o(l),c=i(123),f=o(c),p=i(124),v=o(p),g=i(149),y=o(g),m=function(e){function t(e,i,o){return(0,h.default)(this,t),(0,f.default)(this,(t.__proto__||(0,a.default)(t)).call(this,e,i,o))}return(0,v.default)(t,e),(0,u.default)(t,[{key:"_line",value:function(e,t,i){var o=i[0],n=i[1];this._bezierCurve(e,t,o,n)}},{key:"_getViaCoordinates",value:function(){var e=this.from.x-this.to.x,t=this.from.y-this.to.y,i=void 0,o=void 0,n=void 0,s=void 0,r=this.options.smooth.roundness;return(Math.abs(e)>Math.abs(t)||this.options.smooth.forceDirection===!0||"horizontal"===this.options.smooth.forceDirection)&&"vertical"!==this.options.smooth.forceDirection?(o=this.from.y,s=this.to.y,i=this.from.x-r*e,n=this.to.x+r*e):(o=this.from.y-r*t,s=this.to.y+r*t,i=this.from.x,n=this.to.x),[{x:i,y:o},{x:n,y:s}]}},{key:"getViaNode",value:function(){return this._getViaCoordinates()}},{key:"_findBorderPosition",value:function(e,t){return this._findBorderPositionBezier(e,t)}},{key:"_getDistanceToEdge",value:function(e,t,i,o,n,r){var a=arguments.length>6&&void 0!==arguments[6]?arguments[6]:this._getViaCoordinates(),d=(0,s.default)(a,2),h=d[0],l=d[1];return this._getDistanceToBezierEdge(e,t,i,o,n,r,h,l)}},{key:"getPoint",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this._getViaCoordinates(),i=(0,s.default)(t,2),o=i[0],n=i[1],r=e,a=[];a[0]=Math.pow(1-r,3),a[1]=3*r*Math.pow(1-r,2),a[2]=3*Math.pow(r,2)*(1-r),a[3]=Math.pow(r,3);var d=a[0]*this.fromPoint.x+a[1]*o.x+a[2]*n.x+a[3]*this.toPoint.x,h=a[0]*this.fromPoint.y+a[1]*o.y+a[2]*n.y+a[3]*this.toPoint.y;return{x:d,y:h}}}]),t}(y.default);t.default=m},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(150),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"_getDistanceToBezierEdge",value:function(e,t,i,o,n,s,r,a){var d=1e9,h=void 0,l=void 0,u=void 0,c=void 0,f=void 0,p=e,v=t,g=[0,0,0,0];for(l=1;l<10;l++)u=.1*l,g[0]=Math.pow(1-u,3),g[1]=3*u*Math.pow(1-u,2),g[2]=3*Math.pow(u,2)*(1-u),g[3]=Math.pow(u,3),c=g[0]*e+g[1]*r.x+g[2]*a.x+g[3]*i,f=g[0]*t+g[1]*r.y+g[2]*a.y+g[3]*o,l>0&&(h=this._getDistanceToLine(p,v,c,f,n,s),d=h<d?h:d),p=c,v=f;return d}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(151),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"_findBorderPositionBezier",value:function(e,t){var i,o,n,s,r,a=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this._getViaCoordinates(),d=10,h=0,l=0,u=1,c=.2,f=this.to,p=!1;for(e.id===this.from.id&&(f=this.from,p=!0);l<=u&&h<d;){var v=.5*(l+u);if(i=this.getPoint(v,a),o=Math.atan2(f.y-i.y,f.x-i.x),n=f.distanceToBorder(t,o),s=Math.sqrt(Math.pow(i.x-f.x,2)+Math.pow(i.y-f.y,2)),r=n-s,Math.abs(r)<c)break;r<0?p===!1?l=v:u=v:p===!1?u=v:l=v,h++}return i.t=v,i}},{key:"_getDistanceToBezierEdge",value:function(e,t,i,o,n,s,r){var a=1e9,d=void 0,h=void 0,l=void 0,u=void 0,c=void 0,f=e,p=t;for(h=1;h<10;h++)l=.1*h,u=Math.pow(1-l,2)*e+2*l*(1-l)*r.x+Math.pow(l,2)*i,c=Math.pow(1-l,2)*t+2*l*(1-l)*r.y+Math.pow(l,2)*o,h>0&&(d=this._getDistanceToLine(f,p,u,c,n,s),a=d<a?d:a),f=u,p=c;return a}},{key:"_bezierCurve",value:function(e,t,i,o){var n=void 0!==i&&void 0!==i.x,s=void 0!==o&&void 0!==o.x;e.beginPath(),e.moveTo(this.fromPoint.x,this.fromPoint.y),n&&s?e.bezierCurveTo(i.x,i.y,o.x,o.y,this.toPoint.x,this.toPoint.y):n?e.quadraticCurveTo(i.x,i.y,this.toPoint.x,this.toPoint.y):e.lineTo(this.toPoint.x,this.toPoint.y),this.enableShadow(e,t),e.stroke(),this.disableShadow(e,t)}},{key:"getViaNode",value:function(){return this._getViaCoordinates()}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(115),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(1),u=function(){function e(t,i,o){(0,a.default)(this,e),this.body=i,this.labelModule=o,this.options={},this.setOptions(t),this.colorDirty=!0,this.color={},this.selectionWidth=2,this.hoverWidth=1.5,this.fromPoint=this.from,this.toPoint=this.to}return(0,h.default)(e,[{key:"connect",value:function(){this.from=this.body.nodes[this.options.from],this.to=this.body.nodes[this.options.to]}},{key:"cleanup",value:function(){return!1}},{key:"setOptions",value:function(e){this.options=e,this.from=this.body.nodes[this.options.from],this.to=this.body.nodes[this.options.to],this.id=this.options.id}},{key:"drawLine",value:function(e,t,i,o,n){e.strokeStyle=this.getColor(e,t,i,o),e.lineWidth=t.width,t.dashes!==!1?this._drawDashedLine(e,t,n):this._drawLine(e,t,n)}},{key:"_drawLine",value:function(e,t,i,o,n){if(this.from!=this.to)this._line(e,t,i,o,n);else{var r=this._getCircleData(e),a=(0,s.default)(r,3),d=a[0],h=a[1],l=a[2];this._circle(e,t,d,h,l)}}},{key:"_drawDashedLine",value:function(e,t,i,o,n){e.lineCap="round";var r=[5,5];if(Array.isArray(t.dashes)===!0&&(r=t.dashes),void 0!==e.setLineDash){if(e.save(),e.setLineDash(r),e.lineDashOffset=0,this.from!=this.to)this._line(e,t,i);else{var a=this._getCircleData(e),d=(0,s.default)(a,3),h=d[0],l=d[1],u=d[2];this._circle(e,t,h,l,u)}e.setLineDash([0]),e.lineDashOffset=0,e.restore()}else{if(this.from!=this.to)e.dashedLine(this.from.x,this.from.y,this.to.x,this.to.y,r);else{var c=this._getCircleData(e),f=(0,s.default)(c,3),p=f[0],v=f[1],g=f[2];this._circle(e,t,p,v,g)}this.enableShadow(e,t),e.stroke(),this.disableShadow(e,t)}}},{key:"findBorderPosition",value:function(e,t,i){return this.from!=this.to?this._findBorderPosition(e,t,i):this._findBorderPositionCircle(e,t,i)}},{key:"findBorderPositions",value:function(e){var t={},i={};if(this.from!=this.to)t=this._findBorderPosition(this.from,e),i=this._findBorderPosition(this.to,e);else{var o=this._getCircleData(e),n=(0,s.default)(o,3),r=n[0],a=n[1];n[2];t=this._findBorderPositionCircle(this.from,e,{x:r,y:a,low:.25,high:.6,direction:-1}),i=this._findBorderPositionCircle(this.from,e,{x:r,y:a,low:.6,high:.8,direction:1})}return{from:t,to:i}}},{key:"_getCircleData",value:function(e){var t=void 0,i=void 0,o=this.from,n=this.options.selfReferenceSize;return void 0!==e&&void 0===o.shape.width&&o.shape.resize(e),o.shape.width>o.shape.height?(t=o.x+.5*o.shape.width,i=o.y-n):(t=o.x+n,i=o.y-.5*o.shape.height),[t,i,n]}},{key:"_pointOnCircle",value:function(e,t,i,o){var n=2*o*Math.PI;return{x:e+i*Math.cos(n),y:t-i*Math.sin(n)}}},{key:"_findBorderPositionCircle",value:function(e,t,i){for(var o=i.x,n=i.y,s=i.low,r=i.high,a=i.direction,d=10,h=0,l=this.options.selfReferenceSize,u=void 0,c=void 0,f=void 0,p=void 0,v=void 0,g=.05,y=.5*(s+r);s<=r&&h<d&&(y=.5*(s+r),u=this._pointOnCircle(o,n,l,y),c=Math.atan2(e.y-u.y,e.x-u.x),f=e.distanceToBorder(t,c),p=Math.sqrt(Math.pow(u.x-e.x,2)+Math.pow(u.y-e.y,2)),v=f-p,!(Math.abs(v)<g));)v>0?a>0?s=y:r=y:a>0?r=y:s=y,h++;return u.t=y,u}},{key:"getLineWidth",value:function(e,t){return e===!0?Math.max(this.selectionWidth,.3/this.body.view.scale):t===!0?Math.max(this.hoverWidth,.3/this.body.view.scale):Math.max(this.options.width,.3/this.body.view.scale)}},{key:"getColor",value:function(e,t,i,o){if(t.inheritsColor!==!1){if("both"===t.inheritsColor&&this.from.id!==this.to.id){var n=e.createLinearGradient(this.from.x,this.from.y,this.to.x,this.to.y),s=void 0,r=void 0;return s=this.from.options.color.highlight.border,r=this.to.options.color.highlight.border,this.from.selected===!1&&this.to.selected===!1?(s=l.overrideOpacity(this.from.options.color.border,t.opacity),r=l.overrideOpacity(this.to.options.color.border,t.opacity)):this.from.selected===!0&&this.to.selected===!1?r=this.to.options.color.border:this.from.selected===!1&&this.to.selected===!0&&(s=this.from.options.color.border),n.addColorStop(0,s),n.addColorStop(1,r),n}return"to"===t.inheritsColor?l.overrideOpacity(this.to.options.color.border,t.opacity):l.overrideOpacity(this.from.options.color.border,t.opacity)}return l.overrideOpacity(t.color,t.opacity)}},{key:"_circle",value:function(e,t,i,o,n){this.enableShadow(e,t),e.beginPath(),e.arc(i,o,n,0,2*Math.PI,!1),e.stroke(),this.disableShadow(e,t)}},{key:"getDistanceToEdge",value:function(e,t,i,o,n,r,a,d){var h=0;if(this.from!=this.to)h=this._getDistanceToEdge(e,t,i,o,n,r,a);else{var l=this._getCircleData(void 0),u=(0,s.default)(l,3),c=u[0],f=u[1],p=u[2],v=c-n,g=f-r;h=Math.abs(Math.sqrt(v*v+g*g)-p)}return this.labelModule.size.left<n&&this.labelModule.size.left+this.labelModule.size.width>n&&this.labelModule.size.top<r&&this.labelModule.size.top+this.labelModule.size.height>r?0:h}},{key:"_getDistanceToLine",value:function(e,t,i,o,n,s){var r=i-e,a=o-t,d=r*r+a*a,h=((n-e)*r+(s-t)*a)/d;h>1?h=1:h<0&&(h=0);var l=e+h*r,u=t+h*a,c=l-n,f=u-s;return Math.sqrt(c*c+f*f)}},{key:"getArrowData",value:function(e,t,i,o,n,r){var a=void 0,d=void 0,h=void 0,l=void 0,u=void 0,c=void 0,f=void 0,p=r.width;if("from"===t?(h=this.from,l=this.to,u=.1,c=r.fromArrowScale,f=r.fromArrowType):"to"===t?(h=this.to,l=this.from,u=-.1,c=r.toArrowScale,f=r.toArrowType):(h=this.to,l=this.from,c=r.middleArrowScale,f=r.middleArrowType),h!=l)if("middle"!==t)if(this.options.smooth.enabled===!0){d=this.findBorderPosition(h,e,{via:i});var v=this.getPoint(Math.max(0,Math.min(1,d.t+u)),i);a=Math.atan2(d.y-v.y,d.x-v.x)}else a=Math.atan2(h.y-l.y,h.x-l.x),d=this.findBorderPosition(h,e);else a=Math.atan2(h.y-l.y,h.x-l.x),d=this.getPoint(.5,i);else{var g=this._getCircleData(e),y=(0,s.default)(g,3),m=y[0],b=y[1],_=y[2];"from"===t?(d=this.findBorderPosition(this.from,e,{x:m,y:b,low:.25,high:.6,direction:-1}),a=d.t*-2*Math.PI+1.5*Math.PI+.1*Math.PI):"to"===t?(d=this.findBorderPosition(this.from,e,{x:m,y:b,low:.6,high:1,direction:1}),a=d.t*-2*Math.PI+1.5*Math.PI-1.1*Math.PI):(d=this._pointOnCircle(m,b,_,.175),a=3.9269908169872414)}var w=15*c+3*p,k=d.x-.9*w*Math.cos(a),x=d.y-.9*w*Math.sin(a),O={x:k,y:x};return{point:d,core:O,angle:a,length:w,type:f}}},{key:"drawArrowHead",value:function(e,t,i,o,n){e.strokeStyle=this.getColor(e,t,i,o),e.fillStyle=e.strokeStyle,e.lineWidth=t.width,n.type&&"circle"===n.type.toLowerCase()?e.circleEndpoint(n.point.x,n.point.y,n.angle,n.length):e.arrowEndpoint(n.point.x,n.point.y,n.angle,n.length),this.enableShadow(e,t),e.fill(),this.disableShadow(e,t)}},{key:"enableShadow",value:function(e,t){t.shadow===!0&&(e.shadowColor=t.shadowColor,e.shadowBlur=t.shadowSize,e.shadowOffsetX=t.shadowX,e.shadowOffsetY=t.shadowY)}},{key:"disableShadow",value:function(e,t){t.shadow===!0&&(e.shadowColor="rgba(0,0,0,0)",e.shadowBlur=0,e.shadowOffsetX=0,e.shadowOffsetY=0)}}]),e}();t.default=u},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(115),s=o(n),r=i(120),a=o(r),d=i(105),h=o(d),l=i(106),u=o(l),c=i(123),f=o(c),p=i(124),v=o(p),g=i(150),y=o(g),m=function(e){function t(e,i,o){(0,h.default)(this,t);var n=(0,f.default)(this,(t.__proto__||(0,a.default)(t)).call(this,e,i,o));return n._boundFunction=function(){n.positionBezierNode()},n.body.emitter.on("_repositionBezierNodes",n._boundFunction),n}return(0,v.default)(t,e),(0,u.default)(t,[{key:"setOptions",value:function(e){var t=!1;this.options.physics!==e.physics&&(t=!0),this.options=e,this.id=this.options.id,this.from=this.body.nodes[this.options.from],this.to=this.body.nodes[this.options.to],this.setupSupportNode(),this.connect(),t===!0&&(this.via.setOptions({physics:this.options.physics}),this.positionBezierNode())}},{key:"connect",value:function(){this.from=this.body.nodes[this.options.from],this.to=this.body.nodes[this.options.to],void 0===this.from||void 0===this.to||this.options.physics===!1?this.via.setOptions({physics:!1}):this.from.id===this.to.id?this.via.setOptions({physics:!1}):this.via.setOptions({physics:!0})}},{key:"cleanup",value:function(){return this.body.emitter.off("_repositionBezierNodes",this._boundFunction),void 0!==this.via&&(delete this.body.nodes[this.via.id],this.via=void 0,!0)}},{key:"setupSupportNode",value:function(){if(void 0===this.via){var e="edgeId:"+this.id,t=this.body.functions.createNode({id:e,shape:"circle",physics:!0,hidden:!0});this.body.nodes[e]=t,this.via=t,this.via.parentEdgeId=this.id,this.positionBezierNode()}}},{key:"positionBezierNode",value:function(){void 0!==this.via&&void 0!==this.from&&void 0!==this.to?(this.via.x=.5*(this.from.x+this.to.x),this.via.y=.5*(this.from.y+this.to.y)):void 0!==this.via&&(this.via.x=0,this.via.y=0)}},{key:"_line",value:function(e,t,i){this._bezierCurve(e,t,i)}},{key:"getViaNode",value:function(){return this.via}},{key:"getPoint",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.via,i=e,o=void 0,n=void 0;if(this.from===this.to){var r=this._getCircleData(this.from),a=(0,s.default)(r,3),d=a[0],h=a[1],l=a[2],u=2*Math.PI*(1-i);o=d+l*Math.sin(u),n=h+l-l*(1-Math.cos(u))}else o=Math.pow(1-i,2)*this.fromPoint.x+2*i*(1-i)*t.x+Math.pow(i,2)*this.toPoint.x,n=Math.pow(1-i,2)*this.fromPoint.y+2*i*(1-i)*t.y+Math.pow(i,2)*this.toPoint.y;return{x:o,y:n}}},{key:"_findBorderPosition",value:function(e,t){return this._findBorderPositionBezier(e,t,this.via)}},{key:"_getDistanceToEdge",value:function(e,t,i,o,n,s){return this._getDistanceToBezierEdge(e,t,i,o,n,s,this.via)}}]),t}(y.default);t.default=m},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(150),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"_line",value:function(e,t,i){this._bezierCurve(e,t,i)}},{key:"getViaNode",value:function(){return this._getViaCoordinates()}},{key:"_getViaCoordinates",value:function(){var e=void 0,t=void 0,i=this.options.smooth.roundness,o=this.options.smooth.type,n=Math.abs(this.from.x-this.to.x),s=Math.abs(this.from.y-this.to.y);if("discrete"===o||"diagonalCross"===o){var r=void 0,a=void 0;r=a=n<=s?i*s:i*n,this.from.x>this.to.x&&(r=-r),this.from.y>=this.to.y&&(a=-a),e=this.from.x+r,t=this.from.y+a,"discrete"===o&&(n<=s?e=n<i*s?this.from.x:e:t=s<i*n?this.from.y:t)}else if("straightCross"===o){var d=(1-i)*n,h=(1-i)*s;n<=s?(d=0,this.from.y<this.to.y&&(h=-h)):(this.from.x<this.to.x&&(d=-d),h=0),e=this.to.x+d,t=this.to.y+h}else if("horizontal"===o){var l=(1-i)*n;this.from.x<this.to.x&&(l=-l),e=this.to.x+l,t=this.from.y}else if("vertical"===o){var u=(1-i)*s;this.from.y<this.to.y&&(u=-u),e=this.from.x,t=this.to.y+u}else if("curvedCW"===o){n=this.to.x-this.from.x,s=this.from.y-this.to.y;var c=Math.sqrt(n*n+s*s),f=Math.PI,p=Math.atan2(s,n),v=(p+(.5*i+.5)*f)%(2*f);e=this.from.x+(.5*i+.5)*c*Math.sin(v),t=this.from.y+(.5*i+.5)*c*Math.cos(v)}else if("curvedCCW"===o){n=this.to.x-this.from.x,s=this.from.y-this.to.y;var g=Math.sqrt(n*n+s*s),y=Math.PI,m=Math.atan2(s,n),b=(m+(.5*-i+.5)*y)%(2*y);e=this.from.x+(.5*i+.5)*g*Math.sin(b),t=this.from.y+(.5*i+.5)*g*Math.cos(b)}else{var _=void 0,w=void 0;_=w=n<=s?i*s:i*n,this.from.x>this.to.x&&(_=-_),this.from.y>=this.to.y&&(w=-w),e=this.from.x+_,t=this.from.y+w,n<=s?e=this.from.x<=this.to.x?this.to.x<e?this.to.x:e:this.to.x>e?this.to.x:e:t=this.from.y>=this.to.y?this.to.y>t?this.to.y:t:this.to.y<t?this.to.y:t}return{x:e,y:t}}},{key:"_findBorderPosition",value:function(e,t){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};return this._findBorderPositionBezier(e,t,i.via)}},{key:"_getDistanceToEdge",value:function(e,t,i,o,n,s){var r=arguments.length>6&&void 0!==arguments[6]?arguments[6]:this._getViaCoordinates();return this._getDistanceToBezierEdge(e,t,i,o,n,s,r)}},{key:"getPoint",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this._getViaCoordinates(),i=e,o=Math.pow(1-i,2)*this.fromPoint.x+2*i*(1-i)*t.x+Math.pow(i,2)*this.toPoint.x,n=Math.pow(1-i,2)*this.fromPoint.y+2*i*(1-i)*t.y+Math.pow(i,2)*this.toPoint.y;return{x:o,y:n}}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(151),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"_line",value:function(e,t){e.beginPath(),e.moveTo(this.fromPoint.x,this.fromPoint.y),e.lineTo(this.toPoint.x,this.toPoint.y),this.enableShadow(e,t),e.stroke(),this.disableShadow(e,t)}},{key:"getViaNode",value:function(){}},{key:"getPoint",value:function(e){return{x:(1-e)*this.fromPoint.x+e*this.toPoint.x,y:(1-e)*this.fromPoint.y+e*this.toPoint.y}}},{key:"_findBorderPosition",value:function(e,t){var i=this.to,o=this.from;e.id===this.from.id&&(i=this.from,o=this.to);var n=Math.atan2(i.y-o.y,i.x-o.x),s=i.x-o.x,r=i.y-o.y,a=Math.sqrt(s*s+r*r),d=e.distanceToBorder(t,n),h=(a-d)/a,l={};return l.x=(1-h)*o.x+h*i.x,l.y=(1-h)*o.y+h*i.y,l}},{key:"_getDistanceToEdge",value:function(e,t,i,o,n,s){return this._getDistanceToLine(e,t,i,o,n,s)}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(58),s=o(n),r=i(115),a=o(r),d=i(62),h=o(d),l=i(105),u=o(l),c=i(106),f=o(c),p=i(1),v=i(156).default,g=function(){function e(){(0,u.default)(this,e),this.childrenReference={},this.parentReference={},this.levels={},this.trees={},this.isTree=!1}return(0,f.default)(e,[{key:"addRelation",value:function(e,t){void 0===this.childrenReference[e]&&(this.childrenReference[e]=[]),this.childrenReference[e].push(t),void 0===this.parentReference[t]&&(this.parentReference[t]=[]),this.parentReference[t].push(e)}},{key:"checkIfTree",value:function(){for(var e in this.parentReference)if(this.parentReference[e].length>1)return void(this.isTree=!1);this.isTree=!0}},{key:"ensureLevel",value:function(e){void 0===this.levels[e]&&(this.levels[e]=0);
}},{key:"getMaxLevel",value:function(e){var t=this,i={},o=function e(o){if(void 0!==i[o])return i[o];var n=t.levels[o];if(t.childrenReference[o]){var s=t.childrenReference[o];if(s.length>0)for(var r=0;r<s.length;r++)n=Math.max(n,e(s[r]))}return i[o]=n,n};return o(e)}},{key:"levelDownstream",value:function(e,t){void 0===this.levels[t.id]&&(void 0===this.levels[e.id]&&(this.levels[e.id]=0),this.levels[t.id]=this.levels[e.id]+1)}},{key:"setMinLevelToZero",value:function(e){var t=1e9;for(var i in e)e.hasOwnProperty(i)&&void 0!==this.levels[i]&&(t=Math.min(this.levels[i],t));for(var o in e)e.hasOwnProperty(o)&&void 0!==this.levels[o]&&(this.levels[o]-=t)}},{key:"getTreeSize",value:function(e,t){var i=1e9,o=-1e9,n=1e9,s=-1e9;for(var r in this.trees)if(this.trees.hasOwnProperty(r)&&this.trees[r]===t){var a=e[r];i=Math.min(a.x,i),o=Math.max(a.x,o),n=Math.min(a.y,n),s=Math.max(a.y,s)}return{min_x:i,max_x:o,min_y:n,max_y:s}}}]),e}(),y=function(){function e(t){(0,u.default)(this,e),this.body=t,this.initialRandomSeed=Math.round(1e6*Math.random()),this.randomSeed=this.initialRandomSeed,this.setPhysics=!1,this.options={},this.optionsBackup={physics:{}},this.defaultOptions={randomSeed:void 0,improvedLayout:!0,hierarchical:{enabled:!1,levelSeparation:150,nodeSpacing:100,treeSpacing:200,blockShifting:!0,edgeMinimization:!0,parentCentralization:!0,direction:"UD",sortMethod:"hubsize"}},p.extend(this.options,this.defaultOptions),this.bindEventListeners()}return(0,f.default)(e,[{key:"bindEventListeners",value:function(){var e=this;this.body.emitter.on("_dataChanged",function(){e.setupHierarchicalLayout()}),this.body.emitter.on("_dataLoaded",function(){e.layoutNetwork()}),this.body.emitter.on("_resetHierarchicalLayout",function(){e.setupHierarchicalLayout()}),this.body.emitter.on("_adjustEdgesForHierarchicalLayout",function(){if(e.options.hierarchical.enabled===!0){var t=e.getStaticType();e.body.emitter.emit("_forceDisableDynamicCurves",t,!1)}})}},{key:"setOptions",value:function(e,t){if(void 0!==e){var i=this.options.hierarchical,o=i.enabled;if(p.selectiveDeepExtend(["randomSeed","improvedLayout"],this.options,e),p.mergeOptions(this.options,e,"hierarchical"),void 0!==e.randomSeed&&(this.initialRandomSeed=e.randomSeed),i.enabled===!0)return o===!0&&this.body.emitter.emit("refresh",!0),"RL"===i.direction||"DU"===i.direction?i.levelSeparation>0&&(i.levelSeparation*=-1):i.levelSeparation<0&&(i.levelSeparation*=-1),this.body.emitter.emit("_resetHierarchicalLayout"),this.adaptAllOptionsForHierarchicalLayout(t);if(o===!0)return this.body.emitter.emit("refresh"),p.deepExtend(t,this.optionsBackup)}return t}},{key:"adaptAllOptionsForHierarchicalLayout",value:function(e){if(this.options.hierarchical.enabled===!0){var t=this.optionsBackup.physics;void 0===e.physics||e.physics===!0?(e.physics={enabled:void 0===t.enabled||t.enabled,solver:"hierarchicalRepulsion"},t.enabled=void 0===t.enabled||t.enabled,t.solver=t.solver||"barnesHut"):"object"===(0,h.default)(e.physics)?(t.enabled=void 0===e.physics.enabled||e.physics.enabled,t.solver=e.physics.solver||"barnesHut",e.physics.solver="hierarchicalRepulsion"):e.physics!==!1&&(t.solver="barnesHut",e.physics={solver:"hierarchicalRepulsion"});var i=this.getStaticType();if(void 0===e.edges)this.optionsBackup.edges={smooth:{enabled:!0,type:"dynamic"}},e.edges={smooth:!1};else if(void 0===e.edges.smooth)this.optionsBackup.edges={smooth:{enabled:!0,type:"dynamic"}},e.edges.smooth=!1;else if("boolean"==typeof e.edges.smooth)this.optionsBackup.edges={smooth:e.edges.smooth},e.edges.smooth={enabled:e.edges.smooth,type:i};else{var o=e.edges.smooth;void 0!==o.type&&"dynamic"!==o.type&&(i=o.type),this.optionsBackup.edges={smooth:void 0===o.enabled||o.enabled,type:void 0===o.type?"dynamic":o.type,roundness:void 0===o.roundness?.5:o.roundness,forceDirection:void 0!==o.forceDirection&&o.forceDirection},e.edges.smooth={enabled:void 0===o.enabled||o.enabled,type:i,roundness:void 0===o.roundness?.5:o.roundness,forceDirection:void 0!==o.forceDirection&&o.forceDirection}}this.body.emitter.emit("_forceDisableDynamicCurves",i)}return e}},{key:"seededRandom",value:function(){var e=1e4*Math.sin(this.randomSeed++);return e-Math.floor(e)}},{key:"positionInitially",value:function(e){if(this.options.hierarchical.enabled!==!0){this.randomSeed=this.initialRandomSeed;for(var t=e.length+50,i=0;i<e.length;i++){var o=e[i],n=2*Math.PI*this.seededRandom();void 0===o.x&&(o.x=t*Math.cos(n)),void 0===o.y&&(o.y=t*Math.sin(n))}}}},{key:"layoutNetwork",value:function(){if(this.options.hierarchical.enabled!==!0&&this.options.improvedLayout===!0){for(var e=this.body.nodeIndices,t=0,i=0;i<e.length;i++){var o=this.body.nodes[e[i]];o.predefinedPosition===!0&&(t+=1)}if(t<.5*e.length){var n=10,s=0,r=150,a={clusterEdgeProperties:{smooth:{enabled:!1}}};if(e.length>r){for(var d=e.length;e.length>r&&s<=n;){s+=1;var h=e.length;s%3===0?this.body.modules.clustering.clusterBridges(a):this.body.modules.clustering.clusterOutliers(a);var l=e.length;if(h==l&&s%3!==0)return this._declusterAll(),this.body.emitter.emit("_layoutFailed"),void console.info("This network could not be positioned by this version of the improved layout algorithm. Please disable improvedLayout for better performance.")}this.body.modules.kamadaKawai.setOptions({springLength:Math.max(150,2*d)})}s>n&&console.info("The clustering didn't succeed within the amount of interations allowed, progressing with partial result."),this.body.modules.kamadaKawai.solve(e,this.body.edgeIndices,!0),this._shiftToCenter();for(var u=70,c=0;c<e.length;c++){var f=this.body.nodes[e[c]];f.predefinedPosition===!1&&(f.x+=(.5-this.seededRandom())*u,f.y+=(.5-this.seededRandom())*u)}this._declusterAll(),this.body.emitter.emit("_repositionBezierNodes")}}}},{key:"_shiftToCenter",value:function(){for(var e=v.getRangeCore(this.body.nodes,this.body.nodeIndices),t=v.findCenter(e),i=0;i<this.body.nodeIndices.length;i++){var o=this.body.nodes[this.body.nodeIndices[i]];o.x-=t.x,o.y-=t.y}}},{key:"_declusterAll",value:function(){for(var e=!0;e===!0;){e=!1;for(var t=0;t<this.body.nodeIndices.length;t++)this.body.nodes[this.body.nodeIndices[t]].isCluster===!0&&(e=!0,this.body.modules.clustering.openCluster(this.body.nodeIndices[t],{},!1));e===!0&&this.body.emitter.emit("_dataChanged")}}},{key:"getSeed",value:function(){return this.initialRandomSeed}},{key:"setupHierarchicalLayout",value:function(){if(this.options.hierarchical.enabled===!0&&this.body.nodeIndices.length>0){var e=void 0,t=void 0,i=!1,o=!0,n=!1;this.lastNodeOnLevel={},this.hierarchical=new g,this.treeIndex=-1,this.distributionOrdering={},this.distributionIndex={},this.distributionOrderingPresence={};for(t in this.body.nodes)this.body.nodes.hasOwnProperty(t)&&(e=this.body.nodes[t],void 0===e.options.x&&void 0===e.options.y&&(o=!1),void 0!==e.options.level?(i=!0,this.hierarchical.levels[t]=e.options.level):n=!0);if(n===!0&&i===!0)throw new Error("To use the hierarchical layout, nodes require either no predefined levels or levels have to be defined for all nodes.");if(n===!0){var s=this.options.hierarchical.sortMethod;"hubsize"===s?this._determineLevelsByHubsize():"directed"===s?this._determineLevelsDirected():"custom"===s&&this._determineLevelsCustomCallback()}for(var r in this.body.nodes)this.body.nodes.hasOwnProperty(r)&&this.hierarchical.ensureLevel(r);var a=this._getDistribution();this._generateMap(),this._placeNodesByHierarchy(a),this._condenseHierarchy(),this._shiftToCenter()}}},{key:"_condenseHierarchy",value:function(){var e=this,t=!1,i={},o=function(){for(var t=d(),i=0,o=0;o<t.length-1;o++){var s=t[o].max-t[o+1].min;i+=s+e.options.hierarchical.treeSpacing,n(o+1,i)}},n=function(t,i){for(var o in e.hierarchical.trees)if(e.hierarchical.trees.hasOwnProperty(o)&&e.hierarchical.trees[o]===t){var n=e.body.nodes[o],s=e._getPositionForHierarchy(n);e._setPositionForHierarchy(n,s+i,void 0,!0)}},r=function(t){var i=e.hierarchical.getTreeSize(e.body.nodes,t);return e._isVertical()?{min:i.min_x,max:i.max_x}:{min:i.min_y,max:i.max_y}},d=function(){for(var t=[],i=0;i<=e.treeIndex;i++)t.push(r(i));return t},h=function t(i,o){if(!o[i.id]&&(o[i.id]=!0,e.hierarchical.childrenReference[i.id])){var n=e.hierarchical.childrenReference[i.id];if(n.length>0)for(var s=0;s<n.length;s++)t(e.body.nodes[n[s]],o)}},l=function(t){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1e9,o=1e9,n=1e9,s=1e9,r=-1e9;for(var d in t)if(t.hasOwnProperty(d)){var h=e.body.nodes[d],l=e.hierarchical.levels[h.id],u=e._getPositionForHierarchy(h),c=e._getSpaceAroundNode(h,t),f=(0,a.default)(c,2),p=f[0],v=f[1];o=Math.min(p,o),n=Math.min(v,n),l<=i&&(s=Math.min(u,s),r=Math.max(u,r))}return[s,r,o,n]},u=function(t,i){var o=e.hierarchical.getMaxLevel(t.id),n=e.hierarchical.getMaxLevel(i.id);return Math.min(o,n)},c=function(t,i){var o=e.hierarchical.parentReference[t.id],n=e.hierarchical.parentReference[i.id];if(void 0===o||void 0===n)return!1;for(var s=0;s<o.length;s++)for(var r=0;r<n.length;r++)if(o[s]==n[r])return!0;return!1},f=function(t,i,o){for(var n=0;n<i.length;n++){var s=i[n],r=e.distributionOrdering[s];if(r.length>1)for(var a=0;a<r.length-1;a++)c(r[a],r[a+1])===!0&&e.hierarchical.trees[r[a].id]===e.hierarchical.trees[r[a+1].id]&&t(r[a],r[a+1],o)}},p=function(i,o){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],s=e._getPositionForHierarchy(i),r=e._getPositionForHierarchy(o),d=Math.abs(r-s),c=e.options.hierarchical.nodeSpacing;if(d>c){var f={},p={};h(i,f),h(o,p);var v=u(i,o),g=l(f,v),y=(0,a.default)(g,4),m=(y[0],y[1]),b=(y[2],y[3],l(p,v)),_=(0,a.default)(b,4),w=_[0],k=(_[1],_[2]),x=(_[3],Math.abs(m-w));if(x>c){var O=m-w+c;O<-k+c&&(O=-k+c),O<0&&(e._shiftBlock(o.id,O),t=!0,n===!0&&e._centerParent(o))}}},v=function(o,n){for(var s=n.id,r=n.edges,d=e.hierarchical.levels[n.id],u=e.options.hierarchical.levelSeparation*e.options.hierarchical.levelSeparation,c={},f=[],p=0;p<r.length;p++){var v=r[p];if(v.toId!=v.fromId){var g=v.toId==s?v.from:v.to;c[r[p].id]=g,e.hierarchical.levels[g.id]<d&&f.push(v)}}var y=function(t,i){for(var o=0,n=0;n<i.length;n++)if(void 0!==c[i[n].id]){var s=e._getPositionForHierarchy(c[i[n].id])-t;o+=s/Math.sqrt(s*s+u)}return o},m=function(t,i){for(var o=0,n=0;n<i.length;n++)if(void 0!==c[i[n].id]){var s=e._getPositionForHierarchy(c[i[n].id])-t;o-=u*Math.pow(s*s+u,-1.5)}return o},b=function(t,i){for(var o=e._getPositionForHierarchy(n),s={},r=0;r<t;r++){var a=y(o,i),d=m(o,i),h=40,l=Math.max(-h,Math.min(h,Math.round(a/d)));if(o-=l,void 0!==s[o])break;s[o]=r}return o},_=function(o){var s=e._getPositionForHierarchy(n);if(void 0===i[n.id]){var r={};h(n,r),i[n.id]=r}var d=l(i[n.id]),u=(0,a.default)(d,4),c=(u[0],u[1],u[2]),f=u[3],p=o-s,v=0;p>0?v=Math.min(p,f-e.options.hierarchical.nodeSpacing):p<0&&(v=-Math.min(-p,c-e.options.hierarchical.nodeSpacing)),0!=v&&(e._shiftBlock(n.id,v),t=!0)},w=function(i){var o=e._getPositionForHierarchy(n),s=e._getSpaceAroundNode(n),r=(0,a.default)(s,2),d=r[0],h=r[1],l=i-o,u=o;l>0?u=Math.min(o+(h-e.options.hierarchical.nodeSpacing),i):l<0&&(u=Math.max(o-(d-e.options.hierarchical.nodeSpacing),i)),u!==o&&(e._setPositionForHierarchy(n,u,void 0,!0),t=!0)},k=b(o,f);_(k),k=b(o,r),w(k)},g=function(i){var o=(0,s.default)(e.distributionOrdering);o=o.reverse();for(var n=0;n<i;n++){t=!1;for(var r=0;r<o.length;r++)for(var a=o[r],d=e.distributionOrdering[a],h=0;h<d.length;h++)v(1e3,d[h]);if(t!==!0)break}},y=function(i){var o=(0,s.default)(e.distributionOrdering);o=o.reverse();for(var n=0;n<i&&(t=!1,f(p,o,!0),t===!0);n++);},m=function(){for(var t in e.body.nodes)e.body.nodes.hasOwnProperty(t)&&e._centerParent(e.body.nodes[t])},b=function(){var t=(0,s.default)(e.distributionOrdering);t=t.reverse();for(var i=0;i<t.length;i++)for(var o=t[i],n=e.distributionOrdering[o],r=0;r<n.length;r++)e._centerParent(n[r])};this.options.hierarchical.blockShifting===!0&&(y(5),m()),this.options.hierarchical.edgeMinimization===!0&&g(20),this.options.hierarchical.parentCentralization===!0&&b(),o()}},{key:"_getSpaceAroundNode",value:function(e,t){var i=!0;void 0===t&&(i=!1);var o=this.hierarchical.levels[e.id];if(void 0!==o){var n=this.distributionIndex[e.id],s=this._getPositionForHierarchy(e),r=this.distributionOrdering[o],a=1e9,d=1e9;if(0!==n){var h=r[n-1];if(i===!0&&void 0===t[h.id]||i===!1){var l=this._getPositionForHierarchy(h);a=s-l}}if(n!=r.length-1){var u=r[n+1];if(i===!0&&void 0===t[u.id]||i===!1){var c=this._getPositionForHierarchy(u);d=Math.min(d,c-s)}}return[a,d]}return[0,0]}},{key:"_centerParent",value:function(e){if(this.hierarchical.parentReference[e.id])for(var t=this.hierarchical.parentReference[e.id],i=0;i<t.length;i++){var o=t[i],n=this.body.nodes[o],s=this.hierarchical.childrenReference[o];if(void 0!==s){var r=this._getCenterPosition(s),d=this._getPositionForHierarchy(n),h=this._getSpaceAroundNode(n),l=(0,a.default)(h,2),u=l[0],c=l[1],f=d-r;(f<0&&Math.abs(f)<c-this.options.hierarchical.nodeSpacing||f>0&&Math.abs(f)<u-this.options.hierarchical.nodeSpacing)&&this._setPositionForHierarchy(n,r,void 0,!0)}}}},{key:"_placeNodesByHierarchy",value:function(e){this.positionedNodes={};for(var t in e)if(e.hasOwnProperty(t)){var i=(0,s.default)(e[t]);i=this._indexArrayToNodes(i),this._sortNodeArray(i);for(var o=0,n=0;n<i.length;n++){var r=i[n];if(void 0===this.positionedNodes[r.id]){var a=this.options.hierarchical.nodeSpacing,d=a*o;o>0&&(d=this._getPositionForHierarchy(i[n-1])+a),this._setPositionForHierarchy(r,d,t),this._validatePositionAndContinue(r,t,d),o++}}}}},{key:"_placeBranchNodes",value:function(e,t){var i=this.hierarchical.childrenReference[e];if(void 0!==i){for(var o=[],n=0;n<i.length;n++)o.push(this.body.nodes[i[n]]);this._sortNodeArray(o);for(var s=0;s<o.length;s++){var r=o[s],a=this.hierarchical.levels[r.id];if(!(a>t&&void 0===this.positionedNodes[r.id]))return;var d=this.options.hierarchical.nodeSpacing,h=void 0;h=0===s?this._getPositionForHierarchy(this.body.nodes[e]):this._getPositionForHierarchy(o[s-1])+d,this._setPositionForHierarchy(r,h,a),this._validatePositionAndContinue(r,a,h)}var l=this._getCenterPosition(o);this._setPositionForHierarchy(this.body.nodes[e],l,t)}}},{key:"_validatePositionAndContinue",value:function(e,t,i){if(this.hierarchical.isTree){if(void 0!==this.lastNodeOnLevel[t]){var o=this._getPositionForHierarchy(this.body.nodes[this.lastNodeOnLevel[t]]);if(i-o<this.options.hierarchical.nodeSpacing){var n=o+this.options.hierarchical.nodeSpacing-i,s=this._findCommonParent(this.lastNodeOnLevel[t],e.id);this._shiftBlock(s.withChild,n)}}this.lastNodeOnLevel[t]=e.id,this.positionedNodes[e.id]=!0,this._placeBranchNodes(e.id,t)}}},{key:"_indexArrayToNodes",value:function(e){for(var t=[],i=0;i<e.length;i++)t.push(this.body.nodes[e[i]]);return t}},{key:"_getDistribution",value:function(){var e={},t=void 0,i=void 0;for(t in this.body.nodes)if(this.body.nodes.hasOwnProperty(t)){i=this.body.nodes[t];var o=void 0===this.hierarchical.levels[t]?0:this.hierarchical.levels[t];this._isVertical()?(i.y=this.options.hierarchical.levelSeparation*o,i.options.fixed.y=!0):(i.x=this.options.hierarchical.levelSeparation*o,i.options.fixed.x=!0),void 0===e[o]&&(e[o]={}),e[o][t]=i}return e}},{key:"_getActiveEdges",value:function(e){var t=[];for(var i in e.edges){var o=e.edges[i];this.body.edgeIndices.indexOf(o.id)!==-1&&t.push(o)}return t}},{key:"_getHubSizes",value:function(){var e={},t=this.body.nodeIndices;for(var i in t){var o=t[i],n=this.body.nodes[o],s=this._getActiveEdges(n).length;e[s]=!0}var r=[];for(var a in e)r.push(Number(a));return r.sort(function(e,t){return t-e}),r}},{key:"_determineLevelsByHubsize",value:function(){for(var e=this,t=function(t,i){e.hierarchical.levelDownstream(t,i)},i=this._getHubSizes(),o=0;o<i.length;++o){var n=i[o];if(0===n)break;var s=this.body.nodeIndices;for(var r in s){var a=s[r],d=this.body.nodes[a];n===this._getActiveEdges(d).length&&this._crawlNetwork(t,a)}}}},{key:"_determineLevelsCustomCallback",value:function(){var e=this,t=1e5,i=function(e,t,i){},o=function(o,n,s){var r=e.hierarchical.levels[o.id];void 0===r&&(r=e.hierarchical.levels[o.id]=t);var a=i(v.cloneOptions(o,"node"),v.cloneOptions(n,"node"),v.cloneOptions(s,"edge"));e.hierarchical.levels[n.id]=r+a};this._crawlNetwork(o),this.hierarchical.setMinLevelToZero(this.body.nodes)}},{key:"_determineLevelsDirected",value:function(){var e=this,t=1e4,i=function(i,o,n){var s=e.hierarchical.levels[i.id];void 0===s&&(s=e.hierarchical.levels[i.id]=t),n.toId==o.id?e.hierarchical.levels[o.id]=s+1:e.hierarchical.levels[o.id]=s-1};this._crawlNetwork(i),this.hierarchical.setMinLevelToZero(this.body.nodes)}},{key:"_generateMap",value:function(){var e=this,t=function(t,i){e.hierarchical.levels[i.id]>e.hierarchical.levels[t.id]&&e.hierarchical.addRelation(t.id,i.id)};this._crawlNetwork(t),this.hierarchical.checkIfTree()}},{key:"_crawlNetwork",value:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:function(){},i=arguments[1],o={},n=0,s=function i(n,s){if(void 0===o[n.id]){void 0===e.hierarchical.trees[n.id]&&(e.hierarchical.trees[n.id]=s,e.treeIndex=Math.max(s,e.treeIndex)),o[n.id]=!0;for(var r=void 0,a=e._getActiveEdges(n),d=0;d<a.length;d++){var h=a[d];h.connected===!0&&(r=h.toId==n.id?h.from:h.to,n.id!=r.id&&(t(n,r,h),i(r,s)))}}};if(void 0===i)for(var r=0;r<this.body.nodeIndices.length;r++){var a=this.body.nodes[this.body.nodeIndices[r]];void 0===o[a.id]&&(s(a,n),n+=1)}else{var d=this.body.nodes[i];if(void 0===d)return void console.error("Node not found:",i);s(d)}}},{key:"_shiftBlock",value:function(e,t){var i=this,o={},n=function e(n){if(!o[n]){o[n]=!0,i._isVertical()?i.body.nodes[n].x+=t:i.body.nodes[n].y+=t;var s=i.hierarchical.childrenReference[n];if(void 0!==s)for(var r=0;r<s.length;r++)e(s[r])}};n(e)}},{key:"_findCommonParent",value:function(e,t){var i=this,o={},n=function e(t,o){var n=i.hierarchical.parentReference[o];if(void 0!==n)for(var s=0;s<n.length;s++){var r=n[s];t[r]=!0,e(t,r)}},s=function e(t,o){var n=i.hierarchical.parentReference[o];if(void 0!==n)for(var s=0;s<n.length;s++){var r=n[s];if(void 0!==t[r])return{foundParent:r,withChild:o};var a=e(t,r);if(null!==a.foundParent)return a}return{foundParent:null,withChild:o}};return n(o,e),s(o,t)}},{key:"_setPositionForHierarchy",value:function(e,t,i){var o=arguments.length>3&&void 0!==arguments[3]&&arguments[3];o!==!0&&(void 0===this.distributionOrdering[i]&&(this.distributionOrdering[i]=[],this.distributionOrderingPresence[i]={}),void 0===this.distributionOrderingPresence[i][e.id]&&(this.distributionOrdering[i].push(e),this.distributionIndex[e.id]=this.distributionOrdering[i].length-1),this.distributionOrderingPresence[i][e.id]=!0),this._isVertical()?e.x=t:e.y=t}},{key:"_isVertical",value:function(){return"UD"===this.options.hierarchical.direction||"DU"===this.options.hierarchical.direction}},{key:"_getPositionForHierarchy",value:function(e){return this._isVertical()?e.x:e.y}},{key:"_sortNodeArray",value:function(e){e.length>1&&(this._isVertical()?e.sort(function(e,t){return e.x-t.x}):e.sort(function(e,t){return e.y-t.y}))}},{key:"getStaticType",value:function(){var e="horizontal";return this._isVertical()||(e="vertical"),e}},{key:"_getCenterPosition",value:function(e){for(var t=1e9,i=-1e9,o=0;o<e.length;o++){var n=void 0;if(void 0!==e[o].id)n=e[o];else{var s=e[o];n=this.body.nodes[s]}var r=this._getPositionForHierarchy(n);t=Math.min(t,r),i=Math.max(i,r)}return.5*(t+i)}}]),e}();t.default=y},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=i(1),h=function(){function e(){(0,s.default)(this,e)}return(0,a.default)(e,null,[{key:"getRange",value:function(e){var t,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],o=1e9,n=-1e9,s=1e9,r=-1e9;if(i.length>0)for(var a=0;a<i.length;a++)t=e[i[a]],s>t.shape.boundingBox.left&&(s=t.shape.boundingBox.left),r<t.shape.boundingBox.right&&(r=t.shape.boundingBox.right),o>t.shape.boundingBox.top&&(o=t.shape.boundingBox.top),n<t.shape.boundingBox.bottom&&(n=t.shape.boundingBox.bottom);return 1e9===s&&r===-1e9&&1e9===o&&n===-1e9&&(o=0,n=0,s=0,r=0),{minX:s,maxX:r,minY:o,maxY:n}}},{key:"getRangeCore",value:function(e){var t,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],o=1e9,n=-1e9,s=1e9,r=-1e9;if(i.length>0)for(var a=0;a<i.length;a++)t=e[i[a]],s>t.x&&(s=t.x),r<t.x&&(r=t.x),o>t.y&&(o=t.y),n<t.y&&(n=t.y);return 1e9===s&&r===-1e9&&1e9===o&&n===-1e9&&(o=0,n=0,s=0,r=0),{minX:s,maxX:r,minY:o,maxY:n}}},{key:"findCenter",value:function(e){return{x:.5*(e.maxX+e.minX),y:.5*(e.maxY+e.minY)}}},{key:"cloneOptions",value:function(e,t){var i={};return void 0===t||"node"===t?(d.deepExtend(i,e.options,!0),i.x=e.x,i.y=e.y,i.amountOfConnections=e.edges.length):d.deepExtend(i,e.options,!0),i}}]),e}();t.default=h},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(58),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(158).default,u=i(159).default,c=i(160).default,f=i(161).default,p=i(162).default,v=i(163).default,g=i(164).default,y=i(165).default,m=i(1),b=function(){function e(t){(0,a.default)(this,e),this.body=t,this.physicsBody={physicsNodeIndices:[],physicsEdgeIndices:[],forces:{},velocities:{}},this.physicsEnabled=!0,this.simulationInterval=1e3/60,this.requiresTimeout=!0,this.previousStates={},this.referenceState={},this.freezeCache={},this.renderTimer=void 0,this.adaptiveTimestep=!1,this.adaptiveTimestepEnabled=!1,this.adaptiveCounter=0,this.adaptiveInterval=3,this.stabilized=!1,this.startedStabilization=!1,this.stabilizationIterations=0,this.ready=!1,this.options={},this.defaultOptions={enabled:!0,barnesHut:{theta:.5,gravitationalConstant:-2e3,centralGravity:.3,springLength:95,springConstant:.04,damping:.09,avoidOverlap:0},forceAtlas2Based:{theta:.5,gravitationalConstant:-50,centralGravity:.01,springConstant:.08,springLength:100,damping:.4,avoidOverlap:0},repulsion:{centralGravity:.2,springLength:200,springConstant:.05,nodeDistance:100,damping:.09,avoidOverlap:0},hierarchicalRepulsion:{centralGravity:0,springLength:100,springConstant:.01,nodeDistance:120,damping:.09},maxVelocity:50,minVelocity:.75,solver:"barnesHut",stabilization:{enabled:!0,iterations:1e3,updateInterval:50,onlyDynamicEdges:!1,fit:!0},timestep:.5,adaptiveTimestep:!0},m.extend(this.options,this.defaultOptions),this.timestep=.5,this.layoutFailed=!1,this.bindEventListeners()}return(0,h.default)(e,[{key:"bindEventListeners",value:function(){var e=this;this.body.emitter.on("initPhysics",function(){e.initPhysics()}),this.body.emitter.on("_layoutFailed",function(){e.layoutFailed=!0}),this.body.emitter.on("resetPhysics",function(){e.stopSimulation(),e.ready=!1}),this.body.emitter.on("disablePhysics",function(){e.physicsEnabled=!1,e.stopSimulation()}),this.body.emitter.on("restorePhysics",function(){e.setOptions(e.options),e.ready===!0&&e.startSimulation()}),this.body.emitter.on("startSimulation",function(){e.ready===!0&&e.startSimulation()}),this.body.emitter.on("stopSimulation",function(){e.stopSimulation()}),this.body.emitter.on("destroy",function(){e.stopSimulation(!1),e.body.emitter.off()}),this.body.emitter.on("_dataChanged",function(){e.updatePhysicsData()})}},{key:"setOptions",value:function(e){void 0!==e&&(e===!1?(this.options.enabled=!1,this.physicsEnabled=!1,this.stopSimulation()):(this.physicsEnabled=!0,m.selectiveNotDeepExtend(["stabilization"],this.options,e),m.mergeOptions(this.options,e,"stabilization"),void 0===e.enabled&&(this.options.enabled=!0),this.options.enabled===!1&&(this.physicsEnabled=!1,this.stopSimulation()),this.timestep=this.options.timestep)),this.init()}},{key:"init",value:function(){var e;"forceAtlas2Based"===this.options.solver?(e=this.options.forceAtlas2Based,this.nodesSolver=new g(this.body,this.physicsBody,e),this.edgesSolver=new f(this.body,this.physicsBody,e),this.gravitySolver=new y(this.body,this.physicsBody,e)):"repulsion"===this.options.solver?(e=this.options.repulsion,this.nodesSolver=new u(this.body,this.physicsBody,e),this.edgesSolver=new f(this.body,this.physicsBody,e),this.gravitySolver=new v(this.body,this.physicsBody,e)):"hierarchicalRepulsion"===this.options.solver?(e=this.options.hierarchicalRepulsion,this.nodesSolver=new c(this.body,this.physicsBody,e),this.edgesSolver=new p(this.body,this.physicsBody,e),this.gravitySolver=new v(this.body,this.physicsBody,e)):(e=this.options.barnesHut,this.nodesSolver=new l(this.body,this.physicsBody,e),this.edgesSolver=new f(this.body,this.physicsBody,e),this.gravitySolver=new v(this.body,this.physicsBody,e)),this.modelOptions=e}},{key:"initPhysics",value:function(){this.physicsEnabled===!0&&this.options.enabled===!0?this.options.stabilization.enabled===!0?this.stabilize():(this.stabilized=!1,this.ready=!0,this.body.emitter.emit("fit",{},this.layoutFailed),this.startSimulation()):(this.ready=!0,this.body.emitter.emit("fit"))}},{key:"startSimulation",value:function(){this.physicsEnabled===!0&&this.options.enabled===!0?(this.stabilized=!1,this.adaptiveTimestep=!1,this.body.emitter.emit("_resizeNodes"),void 0===this.viewFunction&&(this.viewFunction=this.simulationStep.bind(this),this.body.emitter.on("initRedraw",this.viewFunction),this.body.emitter.emit("_startRendering"))):this.body.emitter.emit("_redraw")}},{key:"stopSimulation",value:function(){var e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];this.stabilized=!0,e===!0&&this._emitStabilized(),void 0!==this.viewFunction&&(this.body.emitter.off("initRedraw",this.viewFunction),this.viewFunction=void 0,e===!0&&this.body.emitter.emit("_stopRendering"))}},{key:"simulationStep",value:function(){var e=Date.now();this.physicsTick();var t=Date.now()-e;(t<.4*this.simulationInterval||this.runDoubleSpeed===!0)&&this.stabilized===!1&&(this.physicsTick(),this.runDoubleSpeed=!0),this.stabilized===!0&&this.stopSimulation()}},{key:"_emitStabilized",value:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.stabilizationIterations;(this.stabilizationIterations>1||this.startedStabilization===!0)&&setTimeout(function(){e.body.emitter.emit("stabilized",{iterations:t}),e.startedStabilization=!1,e.stabilizationIterations=0},0)}},{key:"physicsTick",value:function(){if(this.startedStabilization===!1&&(this.body.emitter.emit("startStabilizing"),this.startedStabilization=!0),this.stabilized===!1){if(this.adaptiveTimestep===!0&&this.adaptiveTimestepEnabled===!0){var e=1.2;this.adaptiveCounter%this.adaptiveInterval===0?(this.timestep=2*this.timestep,this.calculateForces(),this.moveNodes(),this.revert(),this.timestep=.5*this.timestep,this.calculateForces(),this.moveNodes(),this.calculateForces(),this.moveNodes(),this._evaluateStepQuality()===!0?this.timestep=e*this.timestep:this.timestep/e<this.options.timestep?this.timestep=this.options.timestep:(this.adaptiveCounter=-1,this.timestep=Math.max(this.options.timestep,this.timestep/e))):(this.calculateForces(),this.moveNodes()),this.adaptiveCounter+=1}else this.timestep=this.options.timestep,this.calculateForces(),this.moveNodes();this.stabilized===!0&&this.revert(),this.stabilizationIterations++}}},{key:"updatePhysicsData",value:function(){this.physicsBody.forces={},this.physicsBody.physicsNodeIndices=[],this.physicsBody.physicsEdgeIndices=[];var e=this.body.nodes,t=this.body.edges;for(var i in e)e.hasOwnProperty(i)&&e[i].options.physics===!0&&this.physicsBody.physicsNodeIndices.push(e[i].id);for(var o in t)t.hasOwnProperty(o)&&t[o].options.physics===!0&&this.physicsBody.physicsEdgeIndices.push(t[o].id);for(var n=0;n<this.physicsBody.physicsNodeIndices.length;n++){var s=this.physicsBody.physicsNodeIndices[n];this.physicsBody.forces[s]={x:0,y:0},void 0===this.physicsBody.velocities[s]&&(this.physicsBody.velocities[s]={x:0,y:0})}for(var r in this.physicsBody.velocities)void 0===e[r]&&delete this.physicsBody.velocities[r]}},{key:"revert",value:function(){var e=(0,s.default)(this.previousStates),t=this.body.nodes,i=this.physicsBody.velocities;this.referenceState={};for(var o=0;o<e.length;o++){var n=e[o];void 0!==t[n]?t[n].options.physics===!0&&(this.referenceState[n]={positions:{x:t[n].x,y:t[n].y}},i[n].x=this.previousStates[n].vx,i[n].y=this.previousStates[n].vy,t[n].x=this.previousStates[n].x,t[n].y=this.previousStates[n].y):delete this.previousStates[n]}}},{key:"_evaluateStepQuality",value:function(){var e=void 0,t=void 0,i=void 0,o=this.body.nodes,n=this.referenceState,s=.3;for(var r in this.referenceState)if(this.referenceState.hasOwnProperty(r)&&void 0!==o[r]&&(e=o[r].x-n[r].positions.x,t=o[r].y-n[r].positions.y,i=Math.sqrt(Math.pow(e,2)+Math.pow(t,2)),i>s))return!1;return!0}},{key:"moveNodes",value:function(){for(var e=this.physicsBody.physicsNodeIndices,t=this.options.maxVelocity?this.options.maxVelocity:1e9,i=0,o=0,n=5,s=0;s<e.length;s++){var r=e[s],a=this._performStep(r,t);i=Math.max(i,a),o+=a}this.adaptiveTimestepEnabled=o/e.length<n,this.stabilized=i<this.options.minVelocity}},{key:"_performStep",value:function(e,t){var i=this.body.nodes[e],o=this.timestep,n=this.physicsBody.forces,s=this.physicsBody.velocities;if(this.previousStates[e]={x:i.x,y:i.y,vx:s[e].x,vy:s[e].y},i.options.fixed.x===!1){var r=this.modelOptions.damping*s[e].x,a=(n[e].x-r)/i.options.mass;s[e].x+=a*o,s[e].x=Math.abs(s[e].x)>t?s[e].x>0?t:-t:s[e].x,i.x+=s[e].x*o}else n[e].x=0,s[e].x=0;if(i.options.fixed.y===!1){var d=this.modelOptions.damping*s[e].y,h=(n[e].y-d)/i.options.mass;s[e].y+=h*o,s[e].y=Math.abs(s[e].y)>t?s[e].y>0?t:-t:s[e].y,i.y+=s[e].y*o}else n[e].y=0,s[e].y=0;var l=Math.sqrt(Math.pow(s[e].x,2)+Math.pow(s[e].y,2));return l}},{key:"calculateForces",value:function(){this.gravitySolver.solve(),this.nodesSolver.solve(),this.edgesSolver.solve()}},{key:"_freezeNodes",value:function(){var e=this.body.nodes;for(var t in e)e.hasOwnProperty(t)&&e[t].x&&e[t].y&&(this.freezeCache[t]={x:e[t].options.fixed.x,y:e[t].options.fixed.y},e[t].options.fixed.x=!0,e[t].options.fixed.y=!0)}},{key:"_restoreFrozenNodes",value:function(){var e=this.body.nodes;for(var t in e)e.hasOwnProperty(t)&&void 0!==this.freezeCache[t]&&(e[t].options.fixed.x=this.freezeCache[t].x,e[t].options.fixed.y=this.freezeCache[t].y);this.freezeCache={}}},{key:"stabilize",value:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.options.stabilization.iterations;return"number"!=typeof t&&(console.log("The stabilize method needs a numeric amount of iterations. Switching to default: ",this.options.stabilization.iterations),t=this.options.stabilization.iterations),0===this.physicsBody.physicsNodeIndices.length?void(this.ready=!0):(this.adaptiveTimestep=this.options.adaptiveTimestep,this.body.emitter.emit("_resizeNodes"),this.stopSimulation(),this.stabilized=!1,this.body.emitter.emit("_blockRedraw"),this.targetIterations=t,this.options.stabilization.onlyDynamicEdges===!0&&this._freezeNodes(),this.stabilizationIterations=0,void setTimeout(function(){return e._stabilizationBatch()},0))}},{key:"_stabilizationBatch",value:function(){var e=this,t=function(){return e.stabilized===!1&&e.stabilizationIterations<e.targetIterations},i=function(){e.body.emitter.emit("stabilizationProgress",{iterations:e.stabilizationIterations,total:e.targetIterations})};this.startedStabilization===!1&&(this.body.emitter.emit("startStabilizing"),this.startedStabilization=!0,i());for(var o=0;t()&&o<this.options.stabilization.updateInterval;)this.physicsTick(),o++;i(),t()?setTimeout(this._stabilizationBatch.bind(this),0):this._finalizeStabilization()}},{key:"_finalizeStabilization",value:function(){this.body.emitter.emit("_allowRedraw"),this.options.stabilization.fit===!0&&this.body.emitter.emit("fit"),this.options.stabilization.onlyDynamicEdges===!0&&this._restoreFrozenNodes(),this.body.emitter.emit("stabilizationIterationsDone"),this.body.emitter.emit("_requestRedraw"),this.stabilized===!0?this._emitStabilized():this.startSimulation(),this.ready=!0}},{key:"_drawForces",value:function(e){for(var t=0;t<this.physicsBody.physicsNodeIndices.length;t++){var i=this.body.nodes[this.physicsBody.physicsNodeIndices[t]],o=this.physicsBody.forces[this.physicsBody.physicsNodeIndices[t]],n=20,s=.03,r=Math.sqrt(Math.pow(o.x,2)+Math.pow(o.x,2)),a=Math.min(Math.max(5,r),15),d=3*a,h=m.HSVToHex((180-180*Math.min(1,Math.max(0,s*r)))/360,1,1);
e.lineWidth=a,e.strokeStyle=h,e.beginPath(),e.moveTo(i.x,i.y),e.lineTo(i.x+n*o.x,i.y+n*o.y),e.stroke();var l=Math.atan2(o.y,o.x);e.fillStyle=h,e.arrowEndpoint(i.x+n*o.x+Math.cos(l)*d,i.y+n*o.y+Math.sin(l)*d,l,d),e.fill()}}}]),e}();t.default=b},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=function(){function e(t,i,o){(0,s.default)(this,e),this.body=t,this.physicsBody=i,this.barnesHutTree,this.setOptions(o),this.randomSeed=5}return(0,a.default)(e,[{key:"setOptions",value:function(e){this.options=e,this.thetaInversed=1/this.options.theta,this.overlapAvoidanceFactor=1-Math.max(0,Math.min(1,this.options.avoidOverlap))}},{key:"seededRandom",value:function(){var e=1e4*Math.sin(this.randomSeed++);return e-Math.floor(e)}},{key:"solve",value:function(){if(0!==this.options.gravitationalConstant&&this.physicsBody.physicsNodeIndices.length>0){var e=void 0,t=this.body.nodes,i=this.physicsBody.physicsNodeIndices,o=i.length,n=this._formBarnesHutTree(t,i);this.barnesHutTree=n;for(var s=0;s<o;s++)e=t[i[s]],e.options.mass>0&&(this._getForceContribution(n.root.children.NW,e),this._getForceContribution(n.root.children.NE,e),this._getForceContribution(n.root.children.SW,e),this._getForceContribution(n.root.children.SE,e))}}},{key:"_getForceContribution",value:function(e,t){if(e.childrenCount>0){var i=void 0,o=void 0,n=void 0;i=e.centerOfMass.x-t.x,o=e.centerOfMass.y-t.y,n=Math.sqrt(i*i+o*o),n*e.calcSize>this.thetaInversed?this._calculateForces(n,i,o,t,e):4===e.childrenCount?(this._getForceContribution(e.children.NW,t),this._getForceContribution(e.children.NE,t),this._getForceContribution(e.children.SW,t),this._getForceContribution(e.children.SE,t)):e.children.data.id!=t.id&&this._calculateForces(n,i,o,t,e)}}},{key:"_calculateForces",value:function(e,t,i,o,n){0===e&&(e=.1,t=e),this.overlapAvoidanceFactor<1&&o.shape.radius&&(e=Math.max(.1+this.overlapAvoidanceFactor*o.shape.radius,e-o.shape.radius));var s=this.options.gravitationalConstant*n.mass*o.options.mass/Math.pow(e,3),r=t*s,a=i*s;this.physicsBody.forces[o.id].x+=r,this.physicsBody.forces[o.id].y+=a}},{key:"_formBarnesHutTree",value:function(e,t){for(var i=void 0,o=t.length,n=e[t[0]].x,s=e[t[0]].y,r=e[t[0]].x,a=e[t[0]].y,d=1;d<o;d++){var h=e[t[d]].x,l=e[t[d]].y;e[t[d]].options.mass>0&&(h<n&&(n=h),h>r&&(r=h),l<s&&(s=l),l>a&&(a=l))}var u=Math.abs(r-n)-Math.abs(a-s);u>0?(s-=.5*u,a+=.5*u):(n+=.5*u,r-=.5*u);var c=1e-5,f=Math.max(c,Math.abs(r-n)),p=.5*f,v=.5*(n+r),g=.5*(s+a),y={root:{centerOfMass:{x:0,y:0},mass:0,range:{minX:v-p,maxX:v+p,minY:g-p,maxY:g+p},size:f,calcSize:1/f,children:{data:null},maxWidth:0,level:0,childrenCount:4}};this._splitBranch(y.root);for(var m=0;m<o;m++)i=e[t[m]],i.options.mass>0&&this._placeInTree(y.root,i);return y}},{key:"_updateBranchMass",value:function(e,t){var i=e.mass+t.options.mass,o=1/i;e.centerOfMass.x=e.centerOfMass.x*e.mass+t.x*t.options.mass,e.centerOfMass.x*=o,e.centerOfMass.y=e.centerOfMass.y*e.mass+t.y*t.options.mass,e.centerOfMass.y*=o,e.mass=i;var n=Math.max(Math.max(t.height,t.radius),t.width);e.maxWidth=e.maxWidth<n?n:e.maxWidth}},{key:"_placeInTree",value:function(e,t,i){1==i&&void 0!==i||this._updateBranchMass(e,t),e.children.NW.range.maxX>t.x?e.children.NW.range.maxY>t.y?this._placeInRegion(e,t,"NW"):this._placeInRegion(e,t,"SW"):e.children.NW.range.maxY>t.y?this._placeInRegion(e,t,"NE"):this._placeInRegion(e,t,"SE")}},{key:"_placeInRegion",value:function(e,t,i){switch(e.children[i].childrenCount){case 0:e.children[i].children.data=t,e.children[i].childrenCount=1,this._updateBranchMass(e.children[i],t);break;case 1:e.children[i].children.data.x===t.x&&e.children[i].children.data.y===t.y?(t.x+=this.seededRandom(),t.y+=this.seededRandom()):(this._splitBranch(e.children[i]),this._placeInTree(e.children[i],t));break;case 4:this._placeInTree(e.children[i],t)}}},{key:"_splitBranch",value:function(e){var t=null;1===e.childrenCount&&(t=e.children.data,e.mass=0,e.centerOfMass.x=0,e.centerOfMass.y=0),e.childrenCount=4,e.children.data=null,this._insertRegion(e,"NW"),this._insertRegion(e,"NE"),this._insertRegion(e,"SW"),this._insertRegion(e,"SE"),null!=t&&this._placeInTree(e,t)}},{key:"_insertRegion",value:function(e,t){var i=void 0,o=void 0,n=void 0,s=void 0,r=.5*e.size;switch(t){case"NW":i=e.range.minX,o=e.range.minX+r,n=e.range.minY,s=e.range.minY+r;break;case"NE":i=e.range.minX+r,o=e.range.maxX,n=e.range.minY,s=e.range.minY+r;break;case"SW":i=e.range.minX,o=e.range.minX+r,n=e.range.minY+r,s=e.range.maxY;break;case"SE":i=e.range.minX+r,o=e.range.maxX,n=e.range.minY+r,s=e.range.maxY}e.children[t]={centerOfMass:{x:0,y:0},mass:0,range:{minX:i,maxX:o,minY:n,maxY:s},size:.5*e.size,calcSize:2*e.calcSize,children:{data:null},maxWidth:0,level:e.level+1,childrenCount:0}}},{key:"_debug",value:function(e,t){void 0!==this.barnesHutTree&&(e.lineWidth=1,this._drawBranch(this.barnesHutTree.root,e,t))}},{key:"_drawBranch",value:function(e,t,i){void 0===i&&(i="#FF0000"),4===e.childrenCount&&(this._drawBranch(e.children.NW,t),this._drawBranch(e.children.NE,t),this._drawBranch(e.children.SE,t),this._drawBranch(e.children.SW,t)),t.strokeStyle=i,t.beginPath(),t.moveTo(e.range.minX,e.range.minY),t.lineTo(e.range.maxX,e.range.minY),t.stroke(),t.beginPath(),t.moveTo(e.range.maxX,e.range.minY),t.lineTo(e.range.maxX,e.range.maxY),t.stroke(),t.beginPath(),t.moveTo(e.range.maxX,e.range.maxY),t.lineTo(e.range.minX,e.range.maxY),t.stroke(),t.beginPath(),t.moveTo(e.range.minX,e.range.maxY),t.lineTo(e.range.minX,e.range.minY),t.stroke()}}]),e}();t.default=d},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=function(){function e(t,i,o){(0,s.default)(this,e),this.body=t,this.physicsBody=i,this.setOptions(o)}return(0,a.default)(e,[{key:"setOptions",value:function(e){this.options=e}},{key:"solve",value:function(){for(var e,t,i,o,n,s,r,a,d=this.body.nodes,h=this.physicsBody.physicsNodeIndices,l=this.physicsBody.forces,u=this.options.nodeDistance,c=-2/3/u,f=4/3,p=0;p<h.length-1;p++){r=d[h[p]];for(var v=p+1;v<h.length;v++)a=d[h[v]],e=a.x-r.x,t=a.y-r.y,i=Math.sqrt(e*e+t*t),0===i&&(i=.1*Math.random(),e=i),i<2*u&&(s=i<.5*u?1:c*i+f,s/=i,o=e*s,n=t*s,l[r.id].x-=o,l[r.id].y-=n,l[a.id].x+=o,l[a.id].y+=n)}}}]),e}();t.default=d},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=function(){function e(t,i,o){(0,s.default)(this,e),this.body=t,this.physicsBody=i,this.setOptions(o)}return(0,a.default)(e,[{key:"setOptions",value:function(e){this.options=e}},{key:"solve",value:function(){var e,t,i,o,n,s,r,a,d,h,l=this.body.nodes,u=this.physicsBody.physicsNodeIndices,c=this.physicsBody.forces,f=this.options.nodeDistance;for(d=0;d<u.length-1;d++)for(r=l[u[d]],h=d+1;h<u.length;h++)if(a=l[u[h]],r.level===a.level){e=a.x-r.x,t=a.y-r.y,i=Math.sqrt(e*e+t*t);var p=.05;s=i<f?-Math.pow(p*i,2)+Math.pow(p*f,2):0,0===i?i=.01:s/=i,o=e*s,n=t*s,c[r.id].x-=o,c[r.id].y-=n,c[a.id].x+=o,c[a.id].y+=n}}}]),e}();t.default=d},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=function(){function e(t,i,o){(0,s.default)(this,e),this.body=t,this.physicsBody=i,this.setOptions(o)}return(0,a.default)(e,[{key:"setOptions",value:function(e){this.options=e}},{key:"solve",value:function(){for(var e=void 0,t=void 0,i=this.physicsBody.physicsEdgeIndices,o=this.body.edges,n=void 0,s=void 0,r=void 0,a=0;a<i.length;a++)t=o[i[a]],t.connected===!0&&t.toId!==t.fromId&&void 0!==this.body.nodes[t.toId]&&void 0!==this.body.nodes[t.fromId]&&(void 0!==t.edgeType.via?(e=void 0===t.options.length?this.options.springLength:t.options.length,n=t.to,s=t.edgeType.via,r=t.from,this._calculateSpringForce(n,s,.5*e),this._calculateSpringForce(s,r,.5*e)):(e=void 0===t.options.length?1.5*this.options.springLength:t.options.length,this._calculateSpringForce(t.from,t.to,e)))}},{key:"_calculateSpringForce",value:function(e,t,i){var o=e.x-t.x,n=e.y-t.y,s=Math.max(Math.sqrt(o*o+n*n),.01),r=this.options.springConstant*(i-s)/s,a=o*r,d=n*r;void 0!==this.physicsBody.forces[e.id]&&(this.physicsBody.forces[e.id].x+=a,this.physicsBody.forces[e.id].y+=d),void 0!==this.physicsBody.forces[t.id]&&(this.physicsBody.forces[t.id].x-=a,this.physicsBody.forces[t.id].y-=d)}}]),e}();t.default=d},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=function(){function e(t,i,o){(0,s.default)(this,e),this.body=t,this.physicsBody=i,this.setOptions(o)}return(0,a.default)(e,[{key:"setOptions",value:function(e){this.options=e}},{key:"solve",value:function(){for(var e,t,i,o,n,s,r,a,d=this.body.edges,h=.5,l=this.physicsBody.physicsEdgeIndices,u=this.physicsBody.physicsNodeIndices,c=this.physicsBody.forces,f=0;f<u.length;f++){var p=u[f];c[p].springFx=0,c[p].springFy=0}for(var v=0;v<l.length;v++)t=d[l[v]],t.connected===!0&&(e=void 0===t.options.length?this.options.springLength:t.options.length,i=t.from.x-t.to.x,o=t.from.y-t.to.y,a=Math.sqrt(i*i+o*o),a=0===a?.01:a,r=this.options.springConstant*(e-a)/a,n=i*r,s=o*r,t.to.level!=t.from.level?(void 0!==c[t.toId]&&(c[t.toId].springFx-=n,c[t.toId].springFy-=s),void 0!==c[t.fromId]&&(c[t.fromId].springFx+=n,c[t.fromId].springFy+=s)):(void 0!==c[t.toId]&&(c[t.toId].x-=h*n,c[t.toId].y-=h*s),void 0!==c[t.fromId]&&(c[t.fromId].x+=h*n,c[t.fromId].y+=h*s)));for(var g,y,r=1,m=0;m<u.length;m++){var b=u[m];g=Math.min(r,Math.max(-r,c[b].springFx)),y=Math.min(r,Math.max(-r,c[b].springFy)),c[b].x+=g,c[b].y+=y}for(var _=0,w=0,k=0;k<u.length;k++){var x=u[k];_+=c[x].x,w+=c[x].y}for(var O=_/u.length,M=w/u.length,E=0;E<u.length;E++){var S=u[E];c[S].x-=O,c[S].y-=M}}}]),e}();t.default=d},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=function(){function e(t,i,o){(0,s.default)(this,e),this.body=t,this.physicsBody=i,this.setOptions(o)}return(0,a.default)(e,[{key:"setOptions",value:function(e){this.options=e}},{key:"solve",value:function(){for(var e=void 0,t=void 0,i=void 0,o=void 0,n=this.body.nodes,s=this.physicsBody.physicsNodeIndices,r=this.physicsBody.forces,a=0;a<s.length;a++){var d=s[a];o=n[d],e=-o.x,t=-o.y,i=Math.sqrt(e*e+t*t),this._calculateForces(i,e,t,r,o)}}},{key:"_calculateForces",value:function(e,t,i,o,n){var s=0===e?0:this.options.centralGravity/e;o[n.id].x=t*s,o[n.id].y=i*s}}]),e}();t.default=d},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(158),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"_calculateForces",value:function(e,t,i,o,n){0===e&&(e=.1*Math.random(),t=e),this.overlapAvoidanceFactor<1&&o.shape.radius&&(e=Math.max(.1+this.overlapAvoidanceFactor*o.shape.radius,e-o.shape.radius));var s=o.edges.length+1,r=this.options.gravitationalConstant*n.mass*o.options.mass*s/Math.pow(e,2),a=t*r,d=i*r;this.physicsBody.forces[o.id].x+=a,this.physicsBody.forces[o.id].y+=d}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(123),u=o(l),c=i(124),f=o(c),p=i(163),v=o(p),g=function(e){function t(e,i,o){return(0,a.default)(this,t),(0,u.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o))}return(0,f.default)(t,e),(0,h.default)(t,[{key:"_calculateForces",value:function(e,t,i,o,n){if(e>0){var s=n.edges.length+1,r=this.options.centralGravity*s*n.options.mass;o[n.id].x=t*r,o[n.id].y=i*r}}}]),t}(v.default);t.default=g},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(58),s=o(n),r=i(62),a=o(r),d=i(105),h=o(d),l=i(106),u=o(l),c=i(1),f=i(156).default,p=i(167).default,v=function(){function e(t){var i=this;(0,h.default)(this,e),this.body=t,this.clusteredNodes={},this.clusteredEdges={},this.options={},this.defaultOptions={},c.extend(this.options,this.defaultOptions),this.body.emitter.on("_resetData",function(){i.clusteredNodes={},i.clusteredEdges={}})}return(0,u.default)(e,[{key:"clusterByHubsize",value:function(e,t){void 0===e?e=this._getHubSize():"object"===("undefined"==typeof e?"undefined":(0,a.default)(e))&&(t=this._checkOptions(e),e=this._getHubSize());for(var i=[],o=0;o<this.body.nodeIndices.length;o++){var n=this.body.nodes[this.body.nodeIndices[o]];n.edges.length>=e&&i.push(n.id)}for(var s=0;s<i.length;s++)this.clusterByConnection(i[s],t,!0);this.body.emitter.emit("_dataChanged")}},{key:"cluster",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(void 0===e.joinCondition)throw new Error("Cannot call clusterByNodeData without a joinCondition function in the options.");e=this._checkOptions(e);for(var i={},o={},n=0;n<this.body.nodeIndices.length;n++){var s=this.body.nodeIndices[n],r=this.body.nodes[s],a=f.cloneOptions(r);if(e.joinCondition(a)===!0){i[s]=this.body.nodes[s];for(var d=0;d<r.edges.length;d++){var h=r.edges[d];void 0===this.clusteredEdges[h.id]&&(o[h.id]=h)}}}this._cluster(i,o,e,t)}},{key:"clusterByEdgeCount",value:function(e,t){var i=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];t=this._checkOptions(t);for(var o=[],n={},r=void 0,a=void 0,d=void 0,h=void 0,l=void 0,u=0;u<this.body.nodeIndices.length;u++){var c={},p={};if(h=this.body.nodeIndices[u],void 0===n[h]){l=0,d=this.body.nodes[h],a=[];for(var v=0;v<d.edges.length;v++)r=d.edges[v],void 0===this.clusteredEdges[r.id]&&(r.toId!==r.fromId&&l++,a.push(r));if(l===e){for(var g=!0,y=0;y<a.length;y++){r=a[y];var m=this._getConnectedId(r,h);if(void 0===t.joinCondition)p[r.id]=r,c[h]=this.body.nodes[h],c[m]=this.body.nodes[m],n[h]=!0;else{var b=f.cloneOptions(this.body.nodes[h]);if(t.joinCondition(b)!==!0){g=!1;break}p[r.id]=r,c[h]=this.body.nodes[h],n[h]=!0}}(0,s.default)(c).length>0&&(0,s.default)(p).length>0&&g===!0&&o.push({nodes:c,edges:p})}}}for(var _=0;_<o.length;_++)this._cluster(o[_].nodes,o[_].edges,t,!1);i===!0&&this.body.emitter.emit("_dataChanged")}},{key:"clusterOutliers",value:function(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];this.clusterByEdgeCount(1,e,t)}},{key:"clusterBridges",value:function(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];this.clusterByEdgeCount(2,e,t)}},{key:"clusterByConnection",value:function(e,t){var i=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];if(void 0===e)throw new Error("No nodeId supplied to clusterByConnection!");if(void 0===this.body.nodes[e])throw new Error("The nodeId given to clusterByConnection does not exist!");var o=this.body.nodes[e];t=this._checkOptions(t,o),void 0===t.clusterNodeProperties.x&&(t.clusterNodeProperties.x=o.x),void 0===t.clusterNodeProperties.y&&(t.clusterNodeProperties.y=o.y),void 0===t.clusterNodeProperties.fixed&&(t.clusterNodeProperties.fixed={},t.clusterNodeProperties.fixed.x=o.options.fixed.x,t.clusterNodeProperties.fixed.y=o.options.fixed.y);var n={},r={},a=o.id,d=f.cloneOptions(o);n[a]=o;for(var h=0;h<o.edges.length;h++){var l=o.edges[h];if(void 0===this.clusteredEdges[l.id]){var u=this._getConnectedId(l,a);if(void 0===this.clusteredNodes[u])if(u!==a)if(void 0===t.joinCondition)r[l.id]=l,n[u]=this.body.nodes[u];else{var c=f.cloneOptions(this.body.nodes[u]);t.joinCondition(d,c)===!0&&(r[l.id]=l,n[u]=this.body.nodes[u])}else r[l.id]=l}}var p=(0,s.default)(n).map(function(e){return n[e].id});for(v in n)for(var v=n[v],g=0;g<v.edges.length;g++){var y=v.edges[g];p.indexOf(this._getConnectedId(y,v.id))>-1&&(r[y.id]=y)}this._cluster(n,r,t,i)}},{key:"_createClusterEdges",value:function(e,t,i,o){for(var n=void 0,r=void 0,a=void 0,d=void 0,h=void 0,l=void 0,u=(0,s.default)(e),p=[],v=0;v<u.length;v++){r=u[v],a=e[r];for(var g=0;g<a.edges.length;g++)n=a.edges[g],void 0===this.clusteredEdges[n.id]&&(n.toId==n.fromId?t[n.id]=n:n.toId==r?(d=i.id,h=n.fromId,l=h):(d=n.toId,h=i.id,l=d),void 0===e[l]&&p.push({edge:n,fromId:h,toId:d}))}for(var y=0;y<p.length;y++){var m=p[y].edge,b=f.cloneOptions(m,"edge");c.deepExtend(b,o),b.from=p[y].fromId,b.to=p[y].toId,b.id="clusterEdge:"+c.randomUUID();var _=this.body.functions.createEdge(b);_.clusteringEdgeReplacingId=m.id,this.body.edges[m.id].edgeReplacedById=_.id,this.body.edges[_.id]=_,_.connect(),this._backupEdgeOptions(m),m.setOptions({physics:!1,hidden:!0})}}},{key:"_checkOptions",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return void 0===e.clusterEdgeProperties&&(e.clusterEdgeProperties={}),void 0===e.clusterNodeProperties&&(e.clusterNodeProperties={}),e}},{key:"_cluster",value:function(e,t,i){var o=!(arguments.length>3&&void 0!==arguments[3])||arguments[3];if(0!=(0,s.default)(e).length&&(1!=(0,s.default)(e).length||1==i.clusterNodeProperties.allowSingleNodeCluster)){for(var n in e)if(e.hasOwnProperty(n)&&void 0!==this.clusteredNodes[n])return;var r=c.deepExtend({},i.clusterNodeProperties);if(void 0!==i.processProperties){var a=[];for(var d in e)if(e.hasOwnProperty(d)){var h=f.cloneOptions(e[d]);a.push(h)}var l=[];for(var u in t)if(t.hasOwnProperty(u)&&"clusterEdge:"!==u.substr(0,12)){var v=f.cloneOptions(t[u],"edge");l.push(v)}if(r=i.processProperties(r,a,l),!r)throw new Error("The processProperties function does not return properties!")}void 0===r.id&&(r.id="cluster:"+c.randomUUID());var g=r.id;void 0===r.label&&(r.label="cluster");var y=void 0;void 0===r.x&&(y=this._getClusterPosition(e),r.x=y.x),void 0===r.y&&(void 0===y&&(y=this._getClusterPosition(e)),r.y=y.y),r.id=g;var m=this.body.functions.createNode(r,p);m.isCluster=!0,m.containedNodes=e,m.containedEdges=t,m.clusterEdgeProperties=i.clusterEdgeProperties,this.body.nodes[r.id]=m,this._createClusterEdges(e,t,r,i.clusterEdgeProperties);for(var b in t)if(t.hasOwnProperty(b)&&void 0!==this.body.edges[b]){var _=this.body.edges[b];this._backupEdgeOptions(_),_.setOptions({physics:!1,hidden:!0})}for(var w in e)e.hasOwnProperty(w)&&(this.clusteredNodes[w]={clusterId:r.id,node:this.body.nodes[w]},this.body.nodes[w].setOptions({hidden:!0,physics:!1}));r.id=void 0,o===!0&&this.body.emitter.emit("_dataChanged")}}},{key:"_backupEdgeOptions",value:function(e){void 0===this.clusteredEdges[e.id]&&(this.clusteredEdges[e.id]={physics:e.options.physics,hidden:e.options.hidden})}},{key:"_restoreEdge",value:function(e){var t=this.clusteredEdges[e.id];void 0!==t&&(e.setOptions({physics:t.physics,hidden:t.hidden}),delete this.clusteredEdges[e.id])}},{key:"isCluster",value:function(e){return void 0!==this.body.nodes[e]?this.body.nodes[e].isCluster===!0:(console.log("Node does not exist."),!1)}},{key:"_getClusterPosition",value:function(e){for(var t=(0,s.default)(e),i=e[t[0]].x,o=e[t[0]].x,n=e[t[0]].y,r=e[t[0]].y,a=void 0,d=1;d<t.length;d++)a=e[t[d]],i=a.x<i?a.x:i,o=a.x>o?a.x:o,n=a.y<n?a.y:n,r=a.y>r?a.y:r;return{x:.5*(i+o),y:.5*(n+r)}}},{key:"openCluster",value:function(e,t){var i=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];if(void 0===e)throw new Error("No clusterNodeId supplied to openCluster.");if(void 0===this.body.nodes[e])throw new Error("The clusterNodeId supplied to openCluster does not exist.");if(void 0===this.body.nodes[e].containedNodes)return void console.log("The node:"+e+" is not a cluster.");var o=this.body.nodes[e],n=o.containedNodes,s=o.containedEdges;if(void 0!==t&&void 0!==t.releaseFunction&&"function"==typeof t.releaseFunction){var r={},a={x:o.x,y:o.y};for(var d in n)if(n.hasOwnProperty(d)){var h=this.body.nodes[d];r[d]={x:h.x,y:h.y}}var l=t.releaseFunction(a,r);for(var u in n)if(n.hasOwnProperty(u)){var p=this.body.nodes[u];void 0!==l[u]&&(p.x=void 0===l[u].x?o.x:l[u].x,p.y=void 0===l[u].y?o.y:l[u].y)}}else for(var v in n)if(n.hasOwnProperty(v)){var g=this.body.nodes[v];g=n[v],g.options.fixed.x===!1&&(g.x=o.x),g.options.fixed.y===!1&&(g.y=o.y)}for(var y in n)if(n.hasOwnProperty(y)){var m=this.body.nodes[y];m.vx=o.vx,m.vy=o.vy,m.setOptions({hidden:!1,physics:!0}),delete this.clusteredNodes[y]}for(var b=[],_=0;_<o.edges.length;_++)b.push(o.edges[_]);for(var w=0;w<b.length;w++){var k=b[w],x=this._getConnectedId(k,e);if(void 0!==this.clusteredNodes[x]){var O=this.body.nodes[this.clusteredNodes[x].clusterId],M=this.body.edges[k.clusteringEdgeReplacingId];if(void 0!==M){O.containedEdges[M.id]=M,delete s[M.id];var E=M.fromId,S=M.toId;M.toId==x?S=this.clusteredNodes[x].clusterId:E=this.clusteredNodes[x].clusterId;var D=f.cloneOptions(M,"edge");c.deepExtend(D,O.clusterEdgeProperties);var C="clusterEdge:"+c.randomUUID();c.deepExtend(D,{from:E,to:S,hidden:!1,physics:!0,id:C});var T=this.body.functions.createEdge(D);T.clusteringEdgeReplacingId=M.id,this.body.edges[C]=T,this.body.edges[C].connect()}}else{var P=this.body.edges[k.clusteringEdgeReplacingId];void 0!==P&&this._restoreEdge(P)}k.cleanup(),k.disconnect(),delete this.body.edges[k.id]}for(var F in s)s.hasOwnProperty(F)&&this._restoreEdge(s[F]);delete this.body.nodes[e],i===!0&&this.body.emitter.emit("_dataChanged")}},{key:"getNodesInCluster",value:function(e){var t=[];if(this.isCluster(e)===!0){var i=this.body.nodes[e].containedNodes;for(var o in i)i.hasOwnProperty(o)&&t.push(this.body.nodes[o].id)}return t}},{key:"findNode",value:function(e){for(var t=[],i=100,o=0,n=void 0;void 0!==this.clusteredNodes[e]&&o<i;){if(n=this.body.nodes[e],void 0===n)return[];t.push(n.id),e=this.clusteredNodes[e].clusterId,o++}return n=this.body.nodes[e],void 0===n?[]:(t.push(n.id),t.reverse(),t)}},{key:"updateClusteredNode",value:function(e,t){if(void 0===e)throw new Error("No clusteredNodeId supplied to updateClusteredNode.");if(void 0===t)throw new Error("No newOptions supplied to updateClusteredNode.");if(void 0===this.body.nodes[e])throw new Error("The clusteredNodeId supplied to updateClusteredNode does not exist.");this.body.nodes[e].setOptions(t),this.body.emitter.emit("_dataChanged")}},{key:"updateEdge",value:function(e,t){if(void 0===e)throw new Error("No startEdgeId supplied to updateEdge.");if(void 0===t)throw new Error("No newOptions supplied to updateEdge.");if(void 0===this.body.edges[e])throw new Error("The startEdgeId supplied to updateEdge does not exist.");for(var i=this.getClusteredEdges(e),o=0;o<i.length;o++){var n=this.body.edges[i[o]];n.setOptions(t)}this.body.emitter.emit("_dataChanged")}},{key:"getClusteredEdges",value:function(e){for(var t=[],i=100,o=0;void 0!==e&&void 0!==this.body.edges[e]&&o<i;)t.push(this.body.edges[e].id),e=this.body.edges[e].edgeReplacedById,o++;return t.reverse(),t}},{key:"getBaseEdge",value:function(e){for(var t=e,i=100,o=0;void 0!==e&&void 0!==this.body.edges[e]&&o<i;)e=this.body.edges[e].clusteringEdgeReplacingId,o++,void 0!==e&&(t=e);return t}},{key:"_getConnectedId",value:function(e,t){return e.toId!=t?e.toId:e.fromId!=t?e.fromId:e.fromId}},{key:"_getHubSize",value:function(){for(var e=0,t=0,i=0,o=0,n=0;n<this.body.nodeIndices.length;n++){var s=this.body.nodes[this.body.nodeIndices[n]];s.edges.length>o&&(o=s.edges.length),e+=s.edges.length,t+=Math.pow(s.edges.length,2),i+=1}e/=i,t/=i;var r=t-Math.pow(e,2),a=Math.sqrt(r),d=Math.floor(e+2*a);return d>o&&(d=o),d}}]),e}();t.default=v},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(120),s=o(n),r=i(105),a=o(r),d=i(123),h=o(d),l=i(124),u=o(l),c=i(113),f=o(c),p=function(e){function t(e,i,o,n,r){(0,a.default)(this,t);var d=(0,h.default)(this,(t.__proto__||(0,s.default)(t)).call(this,e,i,o,n,r));return d.isCluster=!0,d.containedNodes={},d.containedEdges={},d}return(0,u.default)(t,e),t}(f.default);t.default=p},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r);"undefined"!=typeof window&&(window.requestAnimationFrame=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame);var d=i(1),h=function(){function e(t,i){(0,s.default)(this,e),this.body=t,this.canvas=i,this.redrawRequested=!1,this.renderTimer=void 0,this.requiresTimeout=!0,this.renderingActive=!1,this.renderRequests=0,this.allowRedraw=!0,this.dragging=!1,this.options={},this.defaultOptions={hideEdgesOnDrag:!1,hideNodesOnDrag:!1},d.extend(this.options,this.defaultOptions),this._determineBrowserMethod(),this.bindEventListeners()}return(0,a.default)(e,[{key:"bindEventListeners",value:function(){var e=this;this.body.emitter.on("dragStart",function(){e.dragging=!0}),this.body.emitter.on("dragEnd",function(){e.dragging=!1}),this.body.emitter.on("_resizeNodes",function(){e._resizeNodes()}),this.body.emitter.on("_redraw",function(){e.renderingActive===!1&&e._redraw()}),this.body.emitter.on("_blockRedraw",function(){e.allowRedraw=!1}),this.body.emitter.on("_allowRedraw",function(){e.allowRedraw=!0,e.redrawRequested=!1}),this.body.emitter.on("_requestRedraw",this._requestRedraw.bind(this)),this.body.emitter.on("_startRendering",function(){e.renderRequests+=1,e.renderingActive=!0,e._startRendering()}),this.body.emitter.on("_stopRendering",function(){e.renderRequests-=1,e.renderingActive=e.renderRequests>0,e.renderTimer=void 0}),this.body.emitter.on("destroy",function(){e.renderRequests=0,e.allowRedraw=!1,e.renderingActive=!1,e.requiresTimeout===!0?clearTimeout(e.renderTimer):window.cancelAnimationFrame(e.renderTimer),e.body.emitter.off()})}},{key:"setOptions",value:function(e){if(void 0!==e){var t=["hideEdgesOnDrag","hideNodesOnDrag"];d.selectiveDeepExtend(t,this.options,e)}}},{key:"_startRendering",value:function(){this.renderingActive===!0&&void 0===this.renderTimer&&(this.requiresTimeout===!0?this.renderTimer=window.setTimeout(this._renderStep.bind(this),this.simulationInterval):this.renderTimer=window.requestAnimationFrame(this._renderStep.bind(this)))}},{key:"_renderStep",value:function(){this.renderingActive===!0&&(this.renderTimer=void 0,this.requiresTimeout===!0&&this._startRendering(),this._redraw(),this.requiresTimeout===!1&&this._startRendering())}},{key:"redraw",value:function(){this.body.emitter.emit("setSize"),this._redraw()}},{key:"_requestRedraw",value:function(){var e=this;this.redrawRequested!==!0&&this.renderingActive===!1&&this.allowRedraw===!0&&(this.redrawRequested=!0,this.requiresTimeout===!0?window.setTimeout(function(){e._redraw(!1)},0):window.requestAnimationFrame(function(){e._redraw(!1)}))}},{key:"_redraw",value:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(this.allowRedraw===!0){this.body.emitter.emit("initRedraw"),this.redrawRequested=!1,0!==this.canvas.frame.canvas.width&&0!==this.canvas.frame.canvas.height||this.canvas.setSize(),this.canvas.setTransform();var t=this.canvas.getContext(),i=this.canvas.frame.canvas.clientWidth,o=this.canvas.frame.canvas.clientHeight;if(t.clearRect(0,0,i,o),0===this.canvas.frame.clientWidth)return;t.save(),t.translate(this.body.view.translation.x,this.body.view.translation.y),t.scale(this.body.view.scale,this.body.view.scale),t.beginPath(),this.body.emitter.emit("beforeDrawing",t),t.closePath(),e===!1&&(this.dragging===!1||this.dragging===!0&&this.options.hideEdgesOnDrag===!1)&&this._drawEdges(t),(this.dragging===!1||this.dragging===!0&&this.options.hideNodesOnDrag===!1)&&this._drawNodes(t,e),t.beginPath(),this.body.emitter.emit("afterDrawing",t),t.closePath(),t.restore(),e===!0&&t.clearRect(0,0,i,o)}}},{key:"_resizeNodes",value:function(){this.canvas.setTransform();var e=this.canvas.getContext();e.save(),e.translate(this.body.view.translation.x,this.body.view.translation.y),e.scale(this.body.view.scale,this.body.view.scale);var t=this.body.nodes,i=void 0;for(var o in t)t.hasOwnProperty(o)&&(i=t[o],i.resize(e),i.updateBoundingBox(e,i.selected));e.restore()}},{key:"_drawNodes",value:function(e){for(var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],i=this.body.nodes,o=this.body.nodeIndices,n=void 0,s=[],r=20,a=this.canvas.DOMtoCanvas({x:-r,y:-r}),d=this.canvas.DOMtoCanvas({x:this.canvas.frame.canvas.clientWidth+r,y:this.canvas.frame.canvas.clientHeight+r}),h={top:a.y,left:a.x,bottom:d.y,right:d.x},l=0;l<o.length;l++)n=i[o[l]],n.isSelected()?s.push(o[l]):t===!0?n.draw(e):n.isBoundingBoxOverlappingWith(h)===!0?n.draw(e):n.updateBoundingBox(e,n.selected);for(var u=0;u<s.length;u++)n=i[s[u]],n.draw(e)}},{key:"_drawEdges",value:function(e){for(var t=this.body.edges,i=this.body.edgeIndices,o=void 0,n=0;n<i.length;n++)o=t[i[n]],o.connected===!0&&o.draw(e)}},{key:"_determineBrowserMethod",value:function(){if("undefined"!=typeof window){var e=navigator.userAgent.toLowerCase();this.requiresTimeout=!1,e.indexOf("msie 9.0")!=-1?this.requiresTimeout=!0:e.indexOf("safari")!=-1&&e.indexOf("chrome")<=-1&&(this.requiresTimeout=!0)}else this.requiresTimeout=!0}}]),e}();t.default=h},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=i(100),h=i(170),l=i(1),u=function(){function e(t){(0,s.default)(this,e),this.body=t,this.pixelRatio=1,this.resizeTimer=void 0,this.resizeFunction=this._onResize.bind(this),this.cameraState={},this.initialized=!1,this.canvasViewCenter={},this.options={},this.defaultOptions={autoResize:!0,height:"100%",width:"100%"},l.extend(this.options,this.defaultOptions),this.bindEventListeners()}return(0,a.default)(e,[{key:"bindEventListeners",value:function(){var e=this;this.body.emitter.once("resize",function(t){0!==t.width&&(e.body.view.translation.x=.5*t.width),0!==t.height&&(e.body.view.translation.y=.5*t.height)}),this.body.emitter.on("setSize",this.setSize.bind(this)),this.body.emitter.on("destroy",function(){e.hammerFrame.destroy(),e.hammer.destroy(),e._cleanUp()})}},{key:"setOptions",value:function(e){var t=this;if(void 0!==e){var i=["width","height","autoResize"];l.selectiveDeepExtend(i,this.options,e)}this.options.autoResize===!0&&(this._cleanUp(),this.resizeTimer=setInterval(function(){var e=t.setSize();e===!0&&t.body.emitter.emit("_requestRedraw")},1e3),this.resizeFunction=this._onResize.bind(this),l.addEventListener(window,"resize",this.resizeFunction))}},{key:"_cleanUp",value:function(){void 0!==this.resizeTimer&&clearInterval(this.resizeTimer),l.removeEventListener(window,"resize",this.resizeFunction),this.resizeFunction=void 0}},{key:"_onResize",value:function(){this.setSize(),this.body.emitter.emit("_redraw")}},{key:"_getCameraState",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.pixelRatio;this.initialized===!0&&(this.cameraState.previousWidth=this.frame.canvas.width/e,this.cameraState.previousHeight=this.frame.canvas.height/e,this.cameraState.scale=this.body.view.scale,this.cameraState.position=this.DOMtoCanvas({x:.5*this.frame.canvas.width/e,y:.5*this.frame.canvas.height/e}))}},{key:"_setCameraState",value:function(){if(void 0!==this.cameraState.scale&&0!==this.frame.canvas.clientWidth&&0!==this.frame.canvas.clientHeight&&0!==this.pixelRatio&&this.cameraState.previousWidth>0){var e=this.frame.canvas.width/this.pixelRatio/this.cameraState.previousWidth,t=this.frame.canvas.height/this.pixelRatio/this.cameraState.previousHeight,i=this.cameraState.scale;1!=e&&1!=t?i=.5*this.cameraState.scale*(e+t):1!=e?i=this.cameraState.scale*e:1!=t&&(i=this.cameraState.scale*t),this.body.view.scale=i;var o=this.DOMtoCanvas({x:.5*this.frame.canvas.clientWidth,y:.5*this.frame.canvas.clientHeight}),n={x:o.x-this.cameraState.position.x,y:o.y-this.cameraState.position.y};this.body.view.translation.x+=n.x*this.body.view.scale,this.body.view.translation.y+=n.y*this.body.view.scale;
}}},{key:"_prepareValue",value:function(e){if("number"==typeof e)return e+"px";if("string"==typeof e){if(e.indexOf("%")!==-1||e.indexOf("px")!==-1)return e;if(e.indexOf("%")===-1)return e+"px"}throw new Error("Could not use the value supplied for width or height:"+e)}},{key:"_create",value:function(){for(;this.body.container.hasChildNodes();)this.body.container.removeChild(this.body.container.firstChild);if(this.frame=document.createElement("div"),this.frame.className="vis-network",this.frame.style.position="relative",this.frame.style.overflow="hidden",this.frame.tabIndex=900,this.frame.canvas=document.createElement("canvas"),this.frame.canvas.style.position="relative",this.frame.appendChild(this.frame.canvas),this.frame.canvas.getContext)this._setPixelRatio(),this.setTransform();else{var e=document.createElement("DIV");e.style.color="red",e.style.fontWeight="bold",e.style.padding="10px",e.innerHTML="Error: your browser does not support HTML canvas",this.frame.canvas.appendChild(e)}this.body.container.appendChild(this.frame),this.body.view.scale=1,this.body.view.translation={x:.5*this.frame.canvas.clientWidth,y:.5*this.frame.canvas.clientHeight},this._bindHammer()}},{key:"_bindHammer",value:function(){var e=this;void 0!==this.hammer&&this.hammer.destroy(),this.drag={},this.pinch={},this.hammer=new d(this.frame.canvas),this.hammer.get("pinch").set({enable:!0}),this.hammer.get("pan").set({threshold:5,direction:d.DIRECTION_ALL}),h.onTouch(this.hammer,function(t){e.body.eventListeners.onTouch(t)}),this.hammer.on("tap",function(t){e.body.eventListeners.onTap(t)}),this.hammer.on("doubletap",function(t){e.body.eventListeners.onDoubleTap(t)}),this.hammer.on("press",function(t){e.body.eventListeners.onHold(t)}),this.hammer.on("panstart",function(t){e.body.eventListeners.onDragStart(t)}),this.hammer.on("panmove",function(t){e.body.eventListeners.onDrag(t)}),this.hammer.on("panend",function(t){e.body.eventListeners.onDragEnd(t)}),this.hammer.on("pinch",function(t){e.body.eventListeners.onPinch(t)}),this.frame.canvas.addEventListener("mousewheel",function(t){e.body.eventListeners.onMouseWheel(t)}),this.frame.canvas.addEventListener("DOMMouseScroll",function(t){e.body.eventListeners.onMouseWheel(t)}),this.frame.canvas.addEventListener("mousemove",function(t){e.body.eventListeners.onMouseMove(t)}),this.frame.canvas.addEventListener("contextmenu",function(t){e.body.eventListeners.onContext(t)}),this.hammerFrame=new d(this.frame),h.onRelease(this.hammerFrame,function(t){e.body.eventListeners.onRelease(t)})}},{key:"setSize",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.options.width,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.options.height;e=this._prepareValue(e),t=this._prepareValue(t);var i=!1,o=this.frame.canvas.width,n=this.frame.canvas.height,s=this.pixelRatio;if(this._setPixelRatio(),e!=this.options.width||t!=this.options.height||this.frame.style.width!=e||this.frame.style.height!=t)this._getCameraState(s),this.frame.style.width=e,this.frame.style.height=t,this.frame.canvas.style.width="100%",this.frame.canvas.style.height="100%",this.frame.canvas.width=Math.round(this.frame.canvas.clientWidth*this.pixelRatio),this.frame.canvas.height=Math.round(this.frame.canvas.clientHeight*this.pixelRatio),this.options.width=e,this.options.height=t,this.canvasViewCenter={x:.5*this.frame.clientWidth,y:.5*this.frame.clientHeight},i=!0;else{var r=Math.round(this.frame.canvas.clientWidth*this.pixelRatio),a=Math.round(this.frame.canvas.clientHeight*this.pixelRatio);this.frame.canvas.width===r&&this.frame.canvas.height===a||this._getCameraState(s),this.frame.canvas.width!==r&&(this.frame.canvas.width=r,i=!0),this.frame.canvas.height!==a&&(this.frame.canvas.height=a,i=!0)}return i===!0&&(this.body.emitter.emit("resize",{width:Math.round(this.frame.canvas.width/this.pixelRatio),height:Math.round(this.frame.canvas.height/this.pixelRatio),oldWidth:Math.round(o/this.pixelRatio),oldHeight:Math.round(n/this.pixelRatio)}),this._setCameraState()),this.initialized=!0,i}},{key:"getContext",value:function(){return this.frame.canvas.getContext("2d")}},{key:"_determinePixelRatio",value:function(){var e=this.getContext();if(void 0===e)throw"Could not get canvax context";return(window.devicePixelRatio||1)/(e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.msBackingStorePixelRatio||e.oBackingStorePixelRatio||e.backingStorePixelRatio||1)}},{key:"_setPixelRatio",value:function(){this.pixelRatio=this._determinePixelRatio()}},{key:"setTransform",value:function(){var e=this.getContext();if(void 0===e)throw"Could not get canvax context";e.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0)}},{key:"_XconvertDOMtoCanvas",value:function(e){return(e-this.body.view.translation.x)/this.body.view.scale}},{key:"_XconvertCanvasToDOM",value:function(e){return e*this.body.view.scale+this.body.view.translation.x}},{key:"_YconvertDOMtoCanvas",value:function(e){return(e-this.body.view.translation.y)/this.body.view.scale}},{key:"_YconvertCanvasToDOM",value:function(e){return e*this.body.view.scale+this.body.view.translation.y}},{key:"canvasToDOM",value:function(e){return{x:this._XconvertCanvasToDOM(e.x),y:this._YconvertCanvasToDOM(e.y)}}},{key:"DOMtoCanvas",value:function(e){return{x:this._XconvertDOMtoCanvas(e.x),y:this._YconvertDOMtoCanvas(e.y)}}}]),e}();t.default=u},function(e,t,i){i(100);t.onTouch=function(e,t){t.inputHandler=function(e){e.isFirst&&t(e)},e.on("hammer.input",t.inputHandler)},t.onRelease=function(e,t){return t.inputHandler=function(e){e.isFinal&&t(e)},e.on("hammer.input",t.inputHandler)},t.offTouch=function(e,t){e.off("hammer.input",t.inputHandler)},t.offRelease=t.offTouch,t.disablePreventDefaultVertically=function(e){var t="pan-y";return e.getTouchAction=function(){return[t]},e}},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=i(1),h=i(156).default,l=function(){function e(t,i){var o=this;(0,s.default)(this,e),this.body=t,this.canvas=i,this.animationSpeed=1/this.renderRefreshRate,this.animationEasingFunction="easeInOutQuint",this.easingTime=0,this.sourceScale=0,this.targetScale=0,this.sourceTranslation=0,this.targetTranslation=0,this.lockedOnNodeId=void 0,this.lockedOnNodeOffset=void 0,this.touchTime=0,this.viewFunction=void 0,this.body.emitter.on("fit",this.fit.bind(this)),this.body.emitter.on("animationFinished",function(){o.body.emitter.emit("_stopRendering")}),this.body.emitter.on("unlockNode",this.releaseNode.bind(this))}return(0,a.default)(e,[{key:"setOptions",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.options=e}},{key:"fit",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{nodes:[]},t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],i=void 0,o=void 0;if(void 0!==e.nodes&&0!==e.nodes.length||(e.nodes=this.body.nodeIndices),t===!0){var n=0;for(var s in this.body.nodes)if(this.body.nodes.hasOwnProperty(s)){var r=this.body.nodes[s];r.predefinedPosition===!0&&(n+=1)}if(n>.5*this.body.nodeIndices.length)return void this.fit(e,!1);i=h.getRange(this.body.nodes,e.nodes);var a=this.body.nodeIndices.length;o=12.662/(a+7.4147)+.0964822;var d=Math.min(this.canvas.frame.canvas.clientWidth/600,this.canvas.frame.canvas.clientHeight/600);o*=d}else{this.body.emitter.emit("_resizeNodes"),i=h.getRange(this.body.nodes,e.nodes);var l=1.1*Math.abs(i.maxX-i.minX),u=1.1*Math.abs(i.maxY-i.minY),c=this.canvas.frame.canvas.clientWidth/l,f=this.canvas.frame.canvas.clientHeight/u;o=c<=f?c:f}o>1?o=1:0===o&&(o=1);var p=h.findCenter(i),v={position:p,scale:o,animation:e.animation};this.moveTo(v)}},{key:"focus",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(void 0!==this.body.nodes[e]){var i={x:this.body.nodes[e].x,y:this.body.nodes[e].y};t.position=i,t.lockedOnNode=e,this.moveTo(t)}else console.log("Node: "+e+" cannot be found.")}},{key:"moveTo",value:function(e){return void 0===e?void(e={}):(void 0===e.offset&&(e.offset={x:0,y:0}),void 0===e.offset.x&&(e.offset.x=0),void 0===e.offset.y&&(e.offset.y=0),void 0===e.scale&&(e.scale=this.body.view.scale),void 0===e.position&&(e.position=this.getViewPosition()),void 0===e.animation&&(e.animation={duration:0}),e.animation===!1&&(e.animation={duration:0}),e.animation===!0&&(e.animation={}),void 0===e.animation.duration&&(e.animation.duration=1e3),void 0===e.animation.easingFunction&&(e.animation.easingFunction="easeInOutQuad"),void this.animateView(e))}},{key:"animateView",value:function(e){if(void 0!==e){this.animationEasingFunction=e.animation.easingFunction,this.releaseNode(),e.locked===!0&&(this.lockedOnNodeId=e.lockedOnNode,this.lockedOnNodeOffset=e.offset),0!=this.easingTime&&this._transitionRedraw(!0),this.sourceScale=this.body.view.scale,this.sourceTranslation=this.body.view.translation,this.targetScale=e.scale,this.body.view.scale=this.targetScale;var t=this.canvas.DOMtoCanvas({x:.5*this.canvas.frame.canvas.clientWidth,y:.5*this.canvas.frame.canvas.clientHeight}),i={x:t.x-e.position.x,y:t.y-e.position.y};this.targetTranslation={x:this.sourceTranslation.x+i.x*this.targetScale+e.offset.x,y:this.sourceTranslation.y+i.y*this.targetScale+e.offset.y},0===e.animation.duration?void 0!=this.lockedOnNodeId?(this.viewFunction=this._lockedRedraw.bind(this),this.body.emitter.on("initRedraw",this.viewFunction)):(this.body.view.scale=this.targetScale,this.body.view.translation=this.targetTranslation,this.body.emitter.emit("_requestRedraw")):(this.animationSpeed=1/(60*e.animation.duration*.001)||1/60,this.animationEasingFunction=e.animation.easingFunction,this.viewFunction=this._transitionRedraw.bind(this),this.body.emitter.on("initRedraw",this.viewFunction),this.body.emitter.emit("_startRendering"))}}},{key:"_lockedRedraw",value:function(){var e={x:this.body.nodes[this.lockedOnNodeId].x,y:this.body.nodes[this.lockedOnNodeId].y},t=this.canvas.DOMtoCanvas({x:.5*this.canvas.frame.canvas.clientWidth,y:.5*this.canvas.frame.canvas.clientHeight}),i={x:t.x-e.x,y:t.y-e.y},o=this.body.view.translation,n={x:o.x+i.x*this.body.view.scale+this.lockedOnNodeOffset.x,y:o.y+i.y*this.body.view.scale+this.lockedOnNodeOffset.y};this.body.view.translation=n}},{key:"releaseNode",value:function(){void 0!==this.lockedOnNodeId&&void 0!==this.viewFunction&&(this.body.emitter.off("initRedraw",this.viewFunction),this.lockedOnNodeId=void 0,this.lockedOnNodeOffset=void 0)}},{key:"_transitionRedraw",value:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.easingTime+=this.animationSpeed,this.easingTime=e===!0?1:this.easingTime;var t=d.easingFunctions[this.animationEasingFunction](this.easingTime);this.body.view.scale=this.sourceScale+(this.targetScale-this.sourceScale)*t,this.body.view.translation={x:this.sourceTranslation.x+(this.targetTranslation.x-this.sourceTranslation.x)*t,y:this.sourceTranslation.y+(this.targetTranslation.y-this.sourceTranslation.y)*t},this.easingTime>=1&&(this.body.emitter.off("initRedraw",this.viewFunction),this.easingTime=0,void 0!=this.lockedOnNodeId&&(this.viewFunction=this._lockedRedraw.bind(this),this.body.emitter.on("initRedraw",this.viewFunction)),this.body.emitter.emit("animationFinished"))}},{key:"getScale",value:function(){return this.body.view.scale}},{key:"getViewPosition",value:function(){return this.canvas.DOMtoCanvas({x:.5*this.canvas.frame.canvas.clientWidth,y:.5*this.canvas.frame.canvas.clientHeight})}}]),e}();t.default=l},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=i(1),h=i(173).default,l=i(174).default,u=function(){function e(t,i,o){(0,s.default)(this,e),this.body=t,this.canvas=i,this.selectionHandler=o,this.navigationHandler=new h(t,i),this.body.eventListeners.onTap=this.onTap.bind(this),this.body.eventListeners.onTouch=this.onTouch.bind(this),this.body.eventListeners.onDoubleTap=this.onDoubleTap.bind(this),this.body.eventListeners.onHold=this.onHold.bind(this),this.body.eventListeners.onDragStart=this.onDragStart.bind(this),this.body.eventListeners.onDrag=this.onDrag.bind(this),this.body.eventListeners.onDragEnd=this.onDragEnd.bind(this),this.body.eventListeners.onMouseWheel=this.onMouseWheel.bind(this),this.body.eventListeners.onPinch=this.onPinch.bind(this),this.body.eventListeners.onMouseMove=this.onMouseMove.bind(this),this.body.eventListeners.onRelease=this.onRelease.bind(this),this.body.eventListeners.onContext=this.onContext.bind(this),this.touchTime=0,this.drag={},this.pinch={},this.popup=void 0,this.popupObj=void 0,this.popupTimer=void 0,this.body.functions.getPointer=this.getPointer.bind(this),this.options={},this.defaultOptions={dragNodes:!0,dragView:!0,hover:!1,keyboard:{enabled:!1,speed:{x:10,y:10,zoom:.02},bindToWindow:!0},navigationButtons:!1,tooltipDelay:300,zoomView:!0},d.extend(this.options,this.defaultOptions),this.bindEventListeners()}return(0,a.default)(e,[{key:"bindEventListeners",value:function(){var e=this;this.body.emitter.on("destroy",function(){clearTimeout(e.popupTimer),delete e.body.functions.getPointer})}},{key:"setOptions",value:function(e){if(void 0!==e){var t=["hideEdgesOnDrag","hideNodesOnDrag","keyboard","multiselect","selectable","selectConnectedEdges"];d.selectiveNotDeepExtend(t,this.options,e),d.mergeOptions(this.options,e,"keyboard"),e.tooltip&&(d.extend(this.options.tooltip,e.tooltip),e.tooltip.color&&(this.options.tooltip.color=d.parseColor(e.tooltip.color)))}this.navigationHandler.setOptions(this.options)}},{key:"getPointer",value:function(e){return{x:e.x-d.getAbsoluteLeft(this.canvas.frame.canvas),y:e.y-d.getAbsoluteTop(this.canvas.frame.canvas)}}},{key:"onTouch",value:function(e){(new Date).valueOf()-this.touchTime>50&&(this.drag.pointer=this.getPointer(e.center),this.drag.pinched=!1,this.pinch.scale=this.body.view.scale,this.touchTime=(new Date).valueOf())}},{key:"onTap",value:function(e){var t=this.getPointer(e.center),i=this.selectionHandler.options.multiselect&&(e.changedPointers[0].ctrlKey||e.changedPointers[0].metaKey);this.checkSelectionChanges(t,e,i),this.selectionHandler._generateClickEvent("click",e,t)}},{key:"onDoubleTap",value:function(e){var t=this.getPointer(e.center);this.selectionHandler._generateClickEvent("doubleClick",e,t)}},{key:"onHold",value:function(e){var t=this.getPointer(e.center),i=this.selectionHandler.options.multiselect;this.checkSelectionChanges(t,e,i),this.selectionHandler._generateClickEvent("click",e,t),this.selectionHandler._generateClickEvent("hold",e,t)}},{key:"onRelease",value:function(e){if((new Date).valueOf()-this.touchTime>10){var t=this.getPointer(e.center);this.selectionHandler._generateClickEvent("release",e,t),this.touchTime=(new Date).valueOf()}}},{key:"onContext",value:function(e){var t=this.getPointer({x:e.clientX,y:e.clientY});this.selectionHandler._generateClickEvent("oncontext",e,t)}},{key:"checkSelectionChanges",value:function(e,t){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],o=this.selectionHandler.getSelection(),n=!1;n=i===!0?this.selectionHandler.selectAdditionalOnPoint(e):this.selectionHandler.selectOnPoint(e);var s=this.selectionHandler.getSelection(),r=this._determineDifference(o,s),a=this._determineDifference(s,o);r.edges.length>0&&(this.selectionHandler._generateClickEvent("deselectEdge",t,e,o),n=!0),r.nodes.length>0&&(this.selectionHandler._generateClickEvent("deselectNode",t,e,o),n=!0),a.nodes.length>0&&(this.selectionHandler._generateClickEvent("selectNode",t,e),n=!0),a.edges.length>0&&(this.selectionHandler._generateClickEvent("selectEdge",t,e),n=!0),n===!0&&this.selectionHandler._generateClickEvent("select",t,e)}},{key:"_determineDifference",value:function(e,t){var i=function(e,t){for(var i=[],o=0;o<e.length;o++){var n=e[o];t.indexOf(n)===-1&&i.push(n)}return i};return{nodes:i(e.nodes,t.nodes),edges:i(e.edges,t.edges)}}},{key:"onDragStart",value:function(e){void 0===this.drag.pointer&&this.onTouch(e);var t=this.selectionHandler.getNodeAt(this.drag.pointer);if(this.drag.dragging=!0,this.drag.selection=[],this.drag.translation=d.extend({},this.body.view.translation),this.drag.nodeId=void 0,void 0!==t&&this.options.dragNodes===!0){this.drag.nodeId=t.id,t.isSelected()===!1&&(this.selectionHandler.unselectAll(),this.selectionHandler.selectObject(t)),this.selectionHandler._generateClickEvent("dragStart",e,this.drag.pointer);var i=this.selectionHandler.selectionObj.nodes;for(var o in i)if(i.hasOwnProperty(o)){var n=i[o],s={id:n.id,node:n,x:n.x,y:n.y,xFixed:n.options.fixed.x,yFixed:n.options.fixed.y};n.options.fixed.x=!0,n.options.fixed.y=!0,this.drag.selection.push(s)}}else this.selectionHandler._generateClickEvent("dragStart",e,this.drag.pointer,void 0,!0)}},{key:"onDrag",value:function(e){var t=this;if(this.drag.pinched!==!0){this.body.emitter.emit("unlockNode");var i=this.getPointer(e.center),o=this.drag.selection;if(o&&o.length&&this.options.dragNodes===!0){this.selectionHandler._generateClickEvent("dragging",e,i);var n=i.x-this.drag.pointer.x,s=i.y-this.drag.pointer.y;o.forEach(function(e){var i=e.node;e.xFixed===!1&&(i.x=t.canvas._XconvertDOMtoCanvas(t.canvas._XconvertCanvasToDOM(e.x)+n)),e.yFixed===!1&&(i.y=t.canvas._YconvertDOMtoCanvas(t.canvas._YconvertCanvasToDOM(e.y)+s))}),this.body.emitter.emit("startSimulation")}else if(this.options.dragView===!0){if(this.selectionHandler._generateClickEvent("dragging",e,i,void 0,!0),void 0===this.drag.pointer)return void this.onDragStart(e);var r=i.x-this.drag.pointer.x,a=i.y-this.drag.pointer.y;this.body.view.translation={x:this.drag.translation.x+r,y:this.drag.translation.y+a},this.body.emitter.emit("_redraw")}}}},{key:"onDragEnd",value:function(e){this.drag.dragging=!1;var t=this.drag.selection;t&&t.length?(t.forEach(function(e){e.node.options.fixed.x=e.xFixed,e.node.options.fixed.y=e.yFixed}),this.selectionHandler._generateClickEvent("dragEnd",e,this.getPointer(e.center)),this.body.emitter.emit("startSimulation")):(this.selectionHandler._generateClickEvent("dragEnd",e,this.getPointer(e.center),void 0,!0),this.body.emitter.emit("_requestRedraw"))}},{key:"onPinch",value:function(e){var t=this.getPointer(e.center);this.drag.pinched=!0,void 0===this.pinch.scale&&(this.pinch.scale=1);var i=this.pinch.scale*e.scale;this.zoom(i,t)}},{key:"zoom",value:function(e,t){if(this.options.zoomView===!0){var i=this.body.view.scale;e<1e-5&&(e=1e-5),e>10&&(e=10);var o=void 0;void 0!==this.drag&&this.drag.dragging===!0&&(o=this.canvas.DOMtoCanvas(this.drag.pointer));var n=this.body.view.translation,s=e/i,r=(1-s)*t.x+n.x*s,a=(1-s)*t.y+n.y*s;if(this.body.view.scale=e,this.body.view.translation={x:r,y:a},void 0!=o){var d=this.canvas.canvasToDOM(o);this.drag.pointer.x=d.x,this.drag.pointer.y=d.y}this.body.emitter.emit("_requestRedraw"),i<e?this.body.emitter.emit("zoom",{direction:"+",scale:this.body.view.scale,pointer:t}):this.body.emitter.emit("zoom",{direction:"-",scale:this.body.view.scale,pointer:t})}}},{key:"onMouseWheel",value:function(e){if(this.options.zoomView===!0){var t=0;if(e.wheelDelta?t=e.wheelDelta/120:e.detail&&(t=-e.detail/3),0!==t){var i=this.body.view.scale,o=t/10;t<0&&(o/=1-o),i*=1+o;var n=this.getPointer({x:e.clientX,y:e.clientY});this.zoom(i,n)}e.preventDefault()}}},{key:"onMouseMove",value:function(e){var t=this,i=this.getPointer({x:e.clientX,y:e.clientY}),o=!1;if(void 0!==this.popup&&(this.popup.hidden===!1&&this._checkHidePopup(i),this.popup.hidden===!1&&(o=!0,this.popup.setPosition(i.x+3,i.y-5),this.popup.show())),this.options.keyboard.bindToWindow===!1&&this.options.keyboard.enabled===!0&&this.canvas.frame.focus(),o===!1&&(void 0!==this.popupTimer&&(clearInterval(this.popupTimer),this.popupTimer=void 0),this.drag.dragging||(this.popupTimer=setTimeout(function(){return t._checkShowPopup(i)},this.options.tooltipDelay))),this.options.hover===!0){var n=this.selectionHandler.getNodeAt(i);void 0===n&&(n=this.selectionHandler.getEdgeAt(i)),this.selectionHandler.hoverObject(n)}}},{key:"_checkShowPopup",value:function(e){var t=this.canvas._XconvertDOMtoCanvas(e.x),i=this.canvas._YconvertDOMtoCanvas(e.y),o={left:t,top:i,right:t,bottom:i},n=void 0===this.popupObj?void 0:this.popupObj.id,s=!1,r="node";if(void 0===this.popupObj){for(var a=this.body.nodeIndices,d=this.body.nodes,h=void 0,u=[],c=0;c<a.length;c++)h=d[a[c]],h.isOverlappingWith(o)===!0&&void 0!==h.getTitle()&&u.push(a[c]);u.length>0&&(this.popupObj=d[u[u.length-1]],s=!0)}if(void 0===this.popupObj&&s===!1){for(var f=this.body.edgeIndices,p=this.body.edges,v=void 0,g=[],y=0;y<f.length;y++)v=p[f[y]],v.isOverlappingWith(o)===!0&&v.connected===!0&&void 0!==v.getTitle()&&g.push(f[y]);g.length>0&&(this.popupObj=p[g[g.length-1]],r="edge")}void 0!==this.popupObj?this.popupObj.id!==n&&(void 0===this.popup&&(this.popup=new l(this.canvas.frame)),this.popup.popupTargetType=r,this.popup.popupTargetId=this.popupObj.id,this.popup.setPosition(e.x+3,e.y-5),this.popup.setText(this.popupObj.getTitle()),this.popup.show(),this.body.emitter.emit("showPopup",this.popupObj.id)):void 0!==this.popup&&(this.popup.hide(),this.body.emitter.emit("hidePopup"))}},{key:"_checkHidePopup",value:function(e){var t=this.selectionHandler._pointerToPositionObject(e),i=!1;if("node"===this.popup.popupTargetType){if(void 0!==this.body.nodes[this.popup.popupTargetId]&&(i=this.body.nodes[this.popup.popupTargetId].isOverlappingWith(t),i===!0)){var o=this.selectionHandler.getNodeAt(e);i=void 0!==o&&o.id===this.popup.popupTargetId}}else void 0===this.selectionHandler.getNodeAt(e)&&void 0!==this.body.edges[this.popup.popupTargetId]&&(i=this.body.edges[this.popup.popupTargetId].isOverlappingWith(t));i===!1&&(this.popupObj=void 0,this.popup.hide(),this.body.emitter.emit("hidePopup"))}}]),e}();t.default=u},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=(i(1),i(100)),h=i(170),l=i(99),u=function(){function e(t,i){var o=this;(0,s.default)(this,e),this.body=t,this.canvas=i,this.iconsCreated=!1,this.navigationHammers=[],this.boundFunctions={},this.touchTime=0,this.activated=!1,this.body.emitter.on("activate",function(){o.activated=!0,o.configureKeyboardBindings()}),this.body.emitter.on("deactivate",function(){o.activated=!1,o.configureKeyboardBindings()}),this.body.emitter.on("destroy",function(){void 0!==o.keycharm&&o.keycharm.destroy()}),this.options={}}return(0,a.default)(e,[{key:"setOptions",value:function(e){void 0!==e&&(this.options=e,this.create())}},{key:"create",value:function(){this.options.navigationButtons===!0?this.iconsCreated===!1&&this.loadNavigationElements():this.iconsCreated===!0&&this.cleanNavigation(),this.configureKeyboardBindings()}},{key:"cleanNavigation",value:function(){if(0!=this.navigationHammers.length){for(var e=0;e<this.navigationHammers.length;e++)this.navigationHammers[e].destroy();this.navigationHammers=[]}this.navigationDOM&&this.navigationDOM.wrapper&&this.navigationDOM.wrapper.parentNode&&this.navigationDOM.wrapper.parentNode.removeChild(this.navigationDOM.wrapper),this.iconsCreated=!1}},{key:"loadNavigationElements",value:function(){var e=this;this.cleanNavigation(),this.navigationDOM={};var t=["up","down","left","right","zoomIn","zoomOut","zoomExtends"],i=["_moveUp","_moveDown","_moveLeft","_moveRight","_zoomIn","_zoomOut","_fit"];this.navigationDOM.wrapper=document.createElement("div"),this.navigationDOM.wrapper.className="vis-navigation",this.canvas.frame.appendChild(this.navigationDOM.wrapper);for(var o=0;o<t.length;o++){this.navigationDOM[t[o]]=document.createElement("div"),this.navigationDOM[t[o]].className="vis-button vis-"+t[o],this.navigationDOM.wrapper.appendChild(this.navigationDOM[t[o]]);var n=new d(this.navigationDOM[t[o]]);"_fit"===i[o]?h.onTouch(n,this._fit.bind(this)):h.onTouch(n,this.bindToRedraw.bind(this,i[o])),this.navigationHammers.push(n)}var s=new d(this.canvas.frame);h.onRelease(s,function(){e._stopMovement()}),this.navigationHammers.push(s),this.iconsCreated=!0}},{key:"bindToRedraw",value:function(e){void 0===this.boundFunctions[e]&&(this.boundFunctions[e]=this[e].bind(this),this.body.emitter.on("initRedraw",this.boundFunctions[e]),this.body.emitter.emit("_startRendering"))}},{key:"unbindFromRedraw",value:function(e){void 0!==this.boundFunctions[e]&&(this.body.emitter.off("initRedraw",this.boundFunctions[e]),this.body.emitter.emit("_stopRendering"),delete this.boundFunctions[e])}},{key:"_fit",value:function(){(new Date).valueOf()-this.touchTime>700&&(this.body.emitter.emit("fit",{duration:700}),this.touchTime=(new Date).valueOf())}},{key:"_stopMovement",value:function(){for(var e in this.boundFunctions)this.boundFunctions.hasOwnProperty(e)&&(this.body.emitter.off("initRedraw",this.boundFunctions[e]),this.body.emitter.emit("_stopRendering"));this.boundFunctions={}}},{key:"_moveUp",value:function(){this.body.view.translation.y+=this.options.keyboard.speed.y}},{key:"_moveDown",value:function(){this.body.view.translation.y-=this.options.keyboard.speed.y}},{key:"_moveLeft",value:function(){this.body.view.translation.x+=this.options.keyboard.speed.x}},{key:"_moveRight",value:function(){this.body.view.translation.x-=this.options.keyboard.speed.x}},{key:"_zoomIn",value:function(){var e=this.body.view.scale,t=this.body.view.scale*(1+this.options.keyboard.speed.zoom),i=this.body.view.translation,o=t/e,n=(1-o)*this.canvas.canvasViewCenter.x+i.x*o,s=(1-o)*this.canvas.canvasViewCenter.y+i.y*o;this.body.view.scale=t,this.body.view.translation={x:n,y:s},this.body.emitter.emit("zoom",{direction:"+",scale:this.body.view.scale,pointer:null})}},{key:"_zoomOut",value:function(){var e=this.body.view.scale,t=this.body.view.scale/(1+this.options.keyboard.speed.zoom),i=this.body.view.translation,o=t/e,n=(1-o)*this.canvas.canvasViewCenter.x+i.x*o,s=(1-o)*this.canvas.canvasViewCenter.y+i.y*o;this.body.view.scale=t,this.body.view.translation={x:n,y:s},this.body.emitter.emit("zoom",{direction:"-",scale:this.body.view.scale,pointer:null})}},{key:"configureKeyboardBindings",value:function(){var e=this;void 0!==this.keycharm&&this.keycharm.destroy(),this.options.keyboard.enabled===!0&&(this.options.keyboard.bindToWindow===!0?this.keycharm=l({container:window,preventDefault:!0}):this.keycharm=l({container:this.canvas.frame,preventDefault:!0}),this.keycharm.reset(),this.activated===!0&&(this.keycharm.bind("up",function(){e.bindToRedraw("_moveUp")},"keydown"),this.keycharm.bind("down",function(){e.bindToRedraw("_moveDown")},"keydown"),this.keycharm.bind("left",function(){e.bindToRedraw("_moveLeft")},"keydown"),this.keycharm.bind("right",function(){e.bindToRedraw("_moveRight")},"keydown"),this.keycharm.bind("=",function(){e.bindToRedraw("_zoomIn")},"keydown"),this.keycharm.bind("num+",function(){e.bindToRedraw("_zoomIn")},"keydown"),this.keycharm.bind("num-",function(){e.bindToRedraw("_zoomOut")},"keydown"),this.keycharm.bind("-",function(){e.bindToRedraw("_zoomOut")},"keydown"),this.keycharm.bind("[",function(){e.bindToRedraw("_zoomOut")},"keydown"),this.keycharm.bind("]",function(){e.bindToRedraw("_zoomIn")},"keydown"),this.keycharm.bind("pageup",function(){e.bindToRedraw("_zoomIn")},"keydown"),this.keycharm.bind("pagedown",function(){e.bindToRedraw("_zoomOut")},"keydown"),this.keycharm.bind("up",function(){e.unbindFromRedraw("_moveUp")},"keyup"),this.keycharm.bind("down",function(){e.unbindFromRedraw("_moveDown")},"keyup"),this.keycharm.bind("left",function(){e.unbindFromRedraw("_moveLeft")},"keyup"),this.keycharm.bind("right",function(){e.unbindFromRedraw("_moveRight")},"keyup"),this.keycharm.bind("=",function(){e.unbindFromRedraw("_zoomIn")},"keyup"),this.keycharm.bind("num+",function(){e.unbindFromRedraw("_zoomIn")},"keyup"),this.keycharm.bind("num-",function(){e.unbindFromRedraw("_zoomOut")},"keyup"),this.keycharm.bind("-",function(){e.unbindFromRedraw("_zoomOut")},"keyup"),this.keycharm.bind("[",function(){e.unbindFromRedraw("_zoomOut")},"keyup"),this.keycharm.bind("]",function(){e.unbindFromRedraw("_zoomIn")},"keyup"),this.keycharm.bind("pageup",function(){e.unbindFromRedraw("_zoomIn")},"keyup"),this.keycharm.bind("pagedown",function(){e.unbindFromRedraw("_zoomOut")},"keyup")))}}]),e}();t.default=u},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=function(){function e(t,i){(0,s.default)(this,e),this.container=t,this.overflowMethod=i||"cap",this.x=0,this.y=0,this.padding=5,this.hidden=!1,this.frame=document.createElement("div"),this.frame.className="vis-tooltip",this.container.appendChild(this.frame)}return(0,a.default)(e,[{key:"setPosition",value:function(e,t){this.x=parseInt(e),this.y=parseInt(t)}},{key:"setText",value:function(e){e instanceof Element?(this.frame.innerHTML="",this.frame.appendChild(e)):this.frame.innerHTML=e}},{key:"show",value:function(e){if(void 0===e&&(e=!0),e===!0){var t=this.frame.clientHeight,i=this.frame.clientWidth,o=this.frame.parentNode.clientHeight,n=this.frame.parentNode.clientWidth,s=0,r=0;if("flip"==this.overflowMethod){var a=!1,d=!0;this.y-t<this.padding&&(d=!1),this.x+i>n-this.padding&&(a=!0),s=a?this.x-i:this.x,r=d?this.y-t:this.y}else r=this.y-t,r+t+this.padding>o&&(r=o-t-this.padding),r<this.padding&&(r=this.padding),s=this.x,s+i+this.padding>n&&(s=n-i-this.padding),s<this.padding&&(s=this.padding);this.frame.style.left=s+"px",this.frame.style.top=r+"px",this.frame.style.visibility="visible",this.hidden=!1}else this.hide()}},{key:"hide",value:function(){this.hidden=!0,this.frame.style.visibility="hidden"}},{key:"destroy",value:function(){this.frame.parentNode.removeChild(this.frame)}}]),e}();t.default=d},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=i(113).default,h=i(147).default,l=i(1),u=function(){function e(t,i){var o=this;(0,s.default)(this,e),this.body=t,this.canvas=i,this.selectionObj={nodes:[],edges:[]},this.hoverObj={nodes:{},edges:{}},this.options={},this.defaultOptions={multiselect:!1,selectable:!0,selectConnectedEdges:!0,hoverConnectedEdges:!0},l.extend(this.options,this.defaultOptions),this.body.emitter.on("_dataChanged",function(){o.updateSelection()})}return(0,a.default)(e,[{key:"setOptions",value:function(e){if(void 0!==e){var t=["multiselect","hoverConnectedEdges","selectable","selectConnectedEdges"];l.selectiveDeepExtend(t,this.options,e)}}},{key:"selectOnPoint",value:function(e){var t=!1;if(this.options.selectable===!0){var i=this.getNodeAt(e)||this.getEdgeAt(e);this.unselectAll(),void 0!==i&&(t=this.selectObject(i)),this.body.emitter.emit("_requestRedraw")}return t}},{key:"selectAdditionalOnPoint",value:function(e){var t=!1;if(this.options.selectable===!0){var i=this.getNodeAt(e)||this.getEdgeAt(e);void 0!==i&&(t=!0,i.isSelected()===!0?this.deselectObject(i):this.selectObject(i),this.body.emitter.emit("_requestRedraw"))}return t}},{key:"_generateClickEvent",value:function(e,t,i,o){var n=arguments.length>4&&void 0!==arguments[4]&&arguments[4],s=void 0;s=n===!0?{nodes:[],edges:[]}:this.getSelection(),s.pointer={DOM:{x:i.x,y:i.y},canvas:this.canvas.DOMtoCanvas(i)},s.event=t,void 0!==o&&(s.previousSelection=o),this.body.emitter.emit(e,s)}},{key:"selectObject",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.options.selectConnectedEdges;return void 0!==e&&(e instanceof d&&t===!0&&this._selectConnectedEdges(e),e.select(),this._addToSelection(e),!0)}},{key:"deselectObject",value:function(e){e.isSelected()===!0&&(e.selected=!1,this._removeFromSelection(e))}},{key:"_getAllNodesOverlappingWith",value:function(e){for(var t=[],i=this.body.nodes,o=0;o<this.body.nodeIndices.length;o++){var n=this.body.nodeIndices[o];i[n].isOverlappingWith(e)&&t.push(n)}return t}},{key:"_pointerToPositionObject",value:function(e){var t=this.canvas.DOMtoCanvas(e);return{left:t.x-1,top:t.y+1,right:t.x+1,bottom:t.y-1
}}},{key:"getNodeAt",value:function(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],i=this._pointerToPositionObject(e),o=this._getAllNodesOverlappingWith(i);return o.length>0?t===!0?this.body.nodes[o[o.length-1]]:o[o.length-1]:void 0}},{key:"_getEdgesOverlappingWith",value:function(e,t){for(var i=this.body.edges,o=0;o<this.body.edgeIndices.length;o++){var n=this.body.edgeIndices[o];i[n].isOverlappingWith(e)&&t.push(n)}}},{key:"_getAllEdgesOverlappingWith",value:function(e){var t=[];return this._getEdgesOverlappingWith(e,t),t}},{key:"getEdgeAt",value:function(e){for(var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],i=this.canvas.DOMtoCanvas(e),o=10,n=null,s=this.body.edges,r=0;r<this.body.edgeIndices.length;r++){var a=this.body.edgeIndices[r],d=s[a];if(d.connected){var h=d.from.x,l=d.from.y,u=d.to.x,c=d.to.y,f=d.edgeType.getDistanceToEdge(h,l,u,c,i.x,i.y);f<o&&(n=a,o=f)}}return null!==n?t===!0?this.body.edges[n]:n:void 0}},{key:"_addToSelection",value:function(e){e instanceof d?this.selectionObj.nodes[e.id]=e:this.selectionObj.edges[e.id]=e}},{key:"_addToHover",value:function(e){e instanceof d?this.hoverObj.nodes[e.id]=e:this.hoverObj.edges[e.id]=e}},{key:"_removeFromSelection",value:function(e){e instanceof d?(delete this.selectionObj.nodes[e.id],this._unselectConnectedEdges(e)):delete this.selectionObj.edges[e.id]}},{key:"unselectAll",value:function(){for(var e in this.selectionObj.nodes)this.selectionObj.nodes.hasOwnProperty(e)&&this.selectionObj.nodes[e].unselect();for(var t in this.selectionObj.edges)this.selectionObj.edges.hasOwnProperty(t)&&this.selectionObj.edges[t].unselect();this.selectionObj={nodes:{},edges:{}}}},{key:"_getSelectedNodeCount",value:function(){var e=0;for(var t in this.selectionObj.nodes)this.selectionObj.nodes.hasOwnProperty(t)&&(e+=1);return e}},{key:"_getSelectedNode",value:function(){for(var e in this.selectionObj.nodes)if(this.selectionObj.nodes.hasOwnProperty(e))return this.selectionObj.nodes[e]}},{key:"_getSelectedEdge",value:function(){for(var e in this.selectionObj.edges)if(this.selectionObj.edges.hasOwnProperty(e))return this.selectionObj.edges[e]}},{key:"_getSelectedEdgeCount",value:function(){var e=0;for(var t in this.selectionObj.edges)this.selectionObj.edges.hasOwnProperty(t)&&(e+=1);return e}},{key:"_getSelectedObjectCount",value:function(){var e=0;for(var t in this.selectionObj.nodes)this.selectionObj.nodes.hasOwnProperty(t)&&(e+=1);for(var i in this.selectionObj.edges)this.selectionObj.edges.hasOwnProperty(i)&&(e+=1);return e}},{key:"_selectionIsEmpty",value:function(){for(var e in this.selectionObj.nodes)if(this.selectionObj.nodes.hasOwnProperty(e))return!1;for(var t in this.selectionObj.edges)if(this.selectionObj.edges.hasOwnProperty(t))return!1;return!0}},{key:"_clusterInSelection",value:function(){for(var e in this.selectionObj.nodes)if(this.selectionObj.nodes.hasOwnProperty(e)&&this.selectionObj.nodes[e].clusterSize>1)return!0;return!1}},{key:"_selectConnectedEdges",value:function(e){for(var t=0;t<e.edges.length;t++){var i=e.edges[t];i.select(),this._addToSelection(i)}}},{key:"_hoverConnectedEdges",value:function(e){for(var t=0;t<e.edges.length;t++){var i=e.edges[t];i.hover=!0,this._addToHover(i)}}},{key:"_unselectConnectedEdges",value:function(e){for(var t=0;t<e.edges.length;t++){var i=e.edges[t];i.unselect(),this._removeFromSelection(i)}}},{key:"blurObject",value:function(e){e.hover===!0&&(e.hover=!1,e instanceof d?this.body.emitter.emit("blurNode",{node:e.id}):this.body.emitter.emit("blurEdge",{edge:e.id}))}},{key:"hoverObject",value:function(e){var t=!1;for(var i in this.hoverObj.nodes)this.hoverObj.nodes.hasOwnProperty(i)&&(void 0===e||e instanceof d&&e.id!=i||e instanceof h)&&(this.blurObject(this.hoverObj.nodes[i]),delete this.hoverObj.nodes[i],t=!0);for(var o in this.hoverObj.edges)this.hoverObj.edges.hasOwnProperty(o)&&(t===!0?(this.hoverObj.edges[o].hover=!1,delete this.hoverObj.edges[o]):(void 0===e||e instanceof h&&e.id!=o||e instanceof d&&!e.hover)&&(this.blurObject(this.hoverObj.edges[o]),delete this.hoverObj.edges[o],t=!0));void 0!==e&&(e.hover===!1&&(e.hover=!0,this._addToHover(e),t=!0,e instanceof d?this.body.emitter.emit("hoverNode",{node:e.id}):this.body.emitter.emit("hoverEdge",{edge:e.id})),e instanceof d&&this.options.hoverConnectedEdges===!0&&this._hoverConnectedEdges(e)),t===!0&&this.body.emitter.emit("_requestRedraw")}},{key:"getSelection",value:function(){var e=this.getSelectedNodes(),t=this.getSelectedEdges();return{nodes:e,edges:t}}},{key:"getSelectedNodes",value:function(){var e=[];if(this.options.selectable===!0)for(var t in this.selectionObj.nodes)this.selectionObj.nodes.hasOwnProperty(t)&&e.push(this.selectionObj.nodes[t].id);return e}},{key:"getSelectedEdges",value:function(){var e=[];if(this.options.selectable===!0)for(var t in this.selectionObj.edges)this.selectionObj.edges.hasOwnProperty(t)&&e.push(this.selectionObj.edges[t].id);return e}},{key:"setSelection",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},i=void 0,o=void 0;if(!e||!e.nodes&&!e.edges)throw"Selection must be an object with nodes and/or edges properties";if((t.unselectAll||void 0===t.unselectAll)&&this.unselectAll(),e.nodes)for(i=0;i<e.nodes.length;i++){o=e.nodes[i];var n=this.body.nodes[o];if(!n)throw new RangeError('Node with id "'+o+'" not found');this.selectObject(n,t.highlightEdges)}if(e.edges)for(i=0;i<e.edges.length;i++){o=e.edges[i];var s=this.body.edges[o];if(!s)throw new RangeError('Edge with id "'+o+'" not found');this.selectObject(s)}this.body.emitter.emit("_requestRedraw")}},{key:"selectNodes",value:function(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(!e||void 0===e.length)throw"Selection must be an array with ids";this.setSelection({nodes:e},{highlightEdges:t})}},{key:"selectEdges",value:function(e){if(!e||void 0===e.length)throw"Selection must be an array with ids";this.setSelection({edges:e})}},{key:"updateSelection",value:function(){for(var e in this.selectionObj.nodes)this.selectionObj.nodes.hasOwnProperty(e)&&(this.body.nodes.hasOwnProperty(e)||delete this.selectionObj.nodes[e]);for(var t in this.selectionObj.edges)this.selectionObj.edges.hasOwnProperty(t)&&(this.body.edges.hasOwnProperty(t)||delete this.selectionObj.edges[t])}}]),e}();t.default=u},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(58),s=o(n),r=i(89),a=o(r),d=i(62),h=o(d),l=i(105),u=o(l),c=i(106),f=o(c),p=i(1),v=i(100),g=i(170),y=function(){function e(t,i,o){var n=this;(0,u.default)(this,e),this.body=t,this.canvas=i,this.selectionHandler=o,this.editMode=!1,this.manipulationDiv=void 0,this.editModeDiv=void 0,this.closeDiv=void 0,this.manipulationHammers=[],this.temporaryUIFunctions={},this.temporaryEventFunctions=[],this.touchTime=0,this.temporaryIds={nodes:[],edges:[]},this.guiEnabled=!1,this.inMode=!1,this.selectedControlNode=void 0,this.options={},this.defaultOptions={enabled:!1,initiallyActive:!1,addNode:!0,addEdge:!0,editNode:void 0,editEdge:!0,deleteNode:!0,deleteEdge:!0,controlNodeStyle:{shape:"dot",size:6,color:{background:"#ff0000",border:"#3c3c3c",highlight:{background:"#07f968",border:"#3c3c3c"}},borderWidth:2,borderWidthSelected:2}},p.extend(this.options,this.defaultOptions),this.body.emitter.on("destroy",function(){n._clean()}),this.body.emitter.on("_dataChanged",this._restore.bind(this)),this.body.emitter.on("_resetData",this._restore.bind(this))}return(0,f.default)(e,[{key:"_restore",value:function(){this.inMode!==!1&&(this.options.initiallyActive===!0?this.enableEditMode():this.disableEditMode())}},{key:"setOptions",value:function(e,t,i){void 0!==t&&(void 0!==t.locale?this.options.locale=t.locale:this.options.locale=i.locale,void 0!==t.locales?this.options.locales=t.locales:this.options.locales=i.locales),void 0!==e&&("boolean"==typeof e?this.options.enabled=e:(this.options.enabled=!0,p.deepExtend(this.options,e)),this.options.initiallyActive===!0&&(this.editMode=!0),this._setup())}},{key:"toggleEditMode",value:function(){this.editMode===!0?this.disableEditMode():this.enableEditMode()}},{key:"enableEditMode",value:function(){this.editMode=!0,this._clean(),this.guiEnabled===!0&&(this.manipulationDiv.style.display="block",this.closeDiv.style.display="block",this.editModeDiv.style.display="none",this.showManipulatorToolbar())}},{key:"disableEditMode",value:function(){this.editMode=!1,this._clean(),this.guiEnabled===!0&&(this.manipulationDiv.style.display="none",this.closeDiv.style.display="none",this.editModeDiv.style.display="block",this._createEditButton())}},{key:"showManipulatorToolbar",value:function(){if(this._clean(),this.manipulationDOM={},this.guiEnabled===!0){this.editMode=!0,this.manipulationDiv.style.display="block",this.closeDiv.style.display="block";var e=this.selectionHandler._getSelectedNodeCount(),t=this.selectionHandler._getSelectedEdgeCount(),i=e+t,o=this.options.locales[this.options.locale],n=!1;this.options.addNode!==!1&&(this._createAddNodeButton(o),n=!0),this.options.addEdge!==!1&&(n===!0?this._createSeperator(1):n=!0,this._createAddEdgeButton(o)),1===e&&"function"==typeof this.options.editNode?(n===!0?this._createSeperator(2):n=!0,this._createEditNodeButton(o)):1===t&&0===e&&this.options.editEdge!==!1&&(n===!0?this._createSeperator(3):n=!0,this._createEditEdgeButton(o)),0!==i&&(e>0&&this.options.deleteNode!==!1?(n===!0&&this._createSeperator(4),this._createDeleteButton(o)):0===e&&this.options.deleteEdge!==!1&&(n===!0&&this._createSeperator(4),this._createDeleteButton(o))),this._bindHammerToDiv(this.closeDiv,this.toggleEditMode.bind(this)),this._temporaryBindEvent("select",this.showManipulatorToolbar.bind(this))}this.body.emitter.emit("_redraw")}},{key:"addNodeMode",value:function(){if(this.editMode!==!0&&this.enableEditMode(),this._clean(),this.inMode="addNode",this.guiEnabled===!0){var e=this.options.locales[this.options.locale];this.manipulationDOM={},this._createBackButton(e),this._createSeperator(),this._createDescription(e.addDescription||this.options.locales.en.addDescription),this._bindHammerToDiv(this.closeDiv,this.toggleEditMode.bind(this))}this._temporaryBindEvent("click",this._performAddNode.bind(this))}},{key:"editNode",value:function(){var e=this;this.editMode!==!0&&this.enableEditMode(),this._clean();var t=this.selectionHandler._getSelectedNode();if(void 0!==t){if(this.inMode="editNode","function"!=typeof this.options.editNode)throw new Error("No function has been configured to handle the editing of nodes.");if(t.isCluster!==!0){var i=p.deepExtend({},t.options,!1);if(i.x=t.x,i.y=t.y,2!==this.options.editNode.length)throw new Error("The function for edit does not support two arguments (data, callback)");this.options.editNode(i,function(t){null!==t&&void 0!==t&&"editNode"===e.inMode&&e.body.data.nodes.getDataSet().update(t),e.showManipulatorToolbar()})}else alert(this.options.locales[this.options.locale].editClusterError||this.options.locales.en.editClusterError)}else this.showManipulatorToolbar()}},{key:"addEdgeMode",value:function(){if(this.editMode!==!0&&this.enableEditMode(),this._clean(),this.inMode="addEdge",this.guiEnabled===!0){var e=this.options.locales[this.options.locale];this.manipulationDOM={},this._createBackButton(e),this._createSeperator(),this._createDescription(e.edgeDescription||this.options.locales.en.edgeDescription),this._bindHammerToDiv(this.closeDiv,this.toggleEditMode.bind(this))}this._temporaryBindUI("onTouch",this._handleConnect.bind(this)),this._temporaryBindUI("onDragEnd",this._finishConnect.bind(this)),this._temporaryBindUI("onDrag",this._dragControlNode.bind(this)),this._temporaryBindUI("onRelease",this._finishConnect.bind(this)),this._temporaryBindUI("onDragStart",function(){}),this._temporaryBindUI("onHold",function(){})}},{key:"editEdgeMode",value:function(){if(this.editMode!==!0&&this.enableEditMode(),this._clean(),this.inMode="editEdge","object"===(0,h.default)(this.options.editEdge)&&"function"==typeof this.options.editEdge.editWithoutDrag&&(this.edgeBeingEditedId=this.selectionHandler.getSelectedEdges()[0],void 0!==this.edgeBeingEditedId)){var e=this.body.edges[this.edgeBeingEditedId];return void this._performEditEdge(e.from,e.to)}if(this.guiEnabled===!0){var t=this.options.locales[this.options.locale];this.manipulationDOM={},this._createBackButton(t),this._createSeperator(),this._createDescription(t.editEdgeDescription||this.options.locales.en.editEdgeDescription),this._bindHammerToDiv(this.closeDiv,this.toggleEditMode.bind(this))}if(this.edgeBeingEditedId=this.selectionHandler.getSelectedEdges()[0],void 0!==this.edgeBeingEditedId){var i=this.body.edges[this.edgeBeingEditedId],o=this._getNewTargetNode(i.from.x,i.from.y),n=this._getNewTargetNode(i.to.x,i.to.y);this.temporaryIds.nodes.push(o.id),this.temporaryIds.nodes.push(n.id),this.body.nodes[o.id]=o,this.body.nodeIndices.push(o.id),this.body.nodes[n.id]=n,this.body.nodeIndices.push(n.id),this._temporaryBindUI("onTouch",this._controlNodeTouch.bind(this)),this._temporaryBindUI("onTap",function(){}),this._temporaryBindUI("onHold",function(){}),this._temporaryBindUI("onDragStart",this._controlNodeDragStart.bind(this)),this._temporaryBindUI("onDrag",this._controlNodeDrag.bind(this)),this._temporaryBindUI("onDragEnd",this._controlNodeDragEnd.bind(this)),this._temporaryBindUI("onMouseMove",function(){}),this._temporaryBindEvent("beforeDrawing",function(e){var t=i.edgeType.findBorderPositions(e);o.selected===!1&&(o.x=t.from.x,o.y=t.from.y),n.selected===!1&&(n.x=t.to.x,n.y=t.to.y)}),this.body.emitter.emit("_redraw")}else this.showManipulatorToolbar()}},{key:"deleteSelected",value:function(){var e=this;this.editMode!==!0&&this.enableEditMode(),this._clean(),this.inMode="delete";var t=this.selectionHandler.getSelectedNodes(),i=this.selectionHandler.getSelectedEdges(),o=void 0;if(t.length>0){for(var n=0;n<t.length;n++)if(this.body.nodes[t[n]].isCluster===!0)return void alert(this.options.locales[this.options.locale].deleteClusterError||this.options.locales.en.deleteClusterError);"function"==typeof this.options.deleteNode&&(o=this.options.deleteNode)}else i.length>0&&"function"==typeof this.options.deleteEdge&&(o=this.options.deleteEdge);if("function"==typeof o){var s={nodes:t,edges:i};if(2!==o.length)throw new Error("The function for delete does not support two arguments (data, callback)");o(s,function(t){null!==t&&void 0!==t&&"delete"===e.inMode?(e.body.data.edges.getDataSet().remove(t.edges),e.body.data.nodes.getDataSet().remove(t.nodes),e.body.emitter.emit("startSimulation"),e.showManipulatorToolbar()):(e.body.emitter.emit("startSimulation"),e.showManipulatorToolbar())})}else this.body.data.edges.getDataSet().remove(i),this.body.data.nodes.getDataSet().remove(t),this.body.emitter.emit("startSimulation"),this.showManipulatorToolbar()}},{key:"_setup",value:function(){this.options.enabled===!0?(this.guiEnabled=!0,this._createWrappers(),this.editMode===!1?this._createEditButton():this.showManipulatorToolbar()):(this._removeManipulationDOM(),this.guiEnabled=!1)}},{key:"_createWrappers",value:function(){void 0===this.manipulationDiv&&(this.manipulationDiv=document.createElement("div"),this.manipulationDiv.className="vis-manipulation",this.editMode===!0?this.manipulationDiv.style.display="block":this.manipulationDiv.style.display="none",this.canvas.frame.appendChild(this.manipulationDiv)),void 0===this.editModeDiv&&(this.editModeDiv=document.createElement("div"),this.editModeDiv.className="vis-edit-mode",this.editMode===!0?this.editModeDiv.style.display="none":this.editModeDiv.style.display="block",this.canvas.frame.appendChild(this.editModeDiv)),void 0===this.closeDiv&&(this.closeDiv=document.createElement("div"),this.closeDiv.className="vis-close",this.closeDiv.style.display=this.manipulationDiv.style.display,this.canvas.frame.appendChild(this.closeDiv))}},{key:"_getNewTargetNode",value:function(e,t){var i=p.deepExtend({},this.options.controlNodeStyle);i.id="targetNode"+p.randomUUID(),i.hidden=!1,i.physics=!1,i.x=e,i.y=t;var o=this.body.functions.createNode(i);return o.shape.boundingBox={left:e,right:e,top:t,bottom:t},o}},{key:"_createEditButton",value:function(){this._clean(),this.manipulationDOM={},p.recursiveDOMDelete(this.editModeDiv);var e=this.options.locales[this.options.locale],t=this._createButton("editMode","vis-button vis-edit vis-edit-mode",e.edit||this.options.locales.en.edit);this.editModeDiv.appendChild(t),this._bindHammerToDiv(t,this.toggleEditMode.bind(this))}},{key:"_clean",value:function(){this.inMode=!1,this.guiEnabled===!0&&(p.recursiveDOMDelete(this.editModeDiv),p.recursiveDOMDelete(this.manipulationDiv),this._cleanManipulatorHammers()),this._cleanupTemporaryNodesAndEdges(),this._unbindTemporaryUIs(),this._unbindTemporaryEvents(),this.body.emitter.emit("restorePhysics")}},{key:"_cleanManipulatorHammers",value:function(){if(0!=this.manipulationHammers.length){for(var e=0;e<this.manipulationHammers.length;e++)this.manipulationHammers[e].destroy();this.manipulationHammers=[]}}},{key:"_removeManipulationDOM",value:function(){this._clean(),p.recursiveDOMDelete(this.manipulationDiv),p.recursiveDOMDelete(this.editModeDiv),p.recursiveDOMDelete(this.closeDiv),this.manipulationDiv&&this.canvas.frame.removeChild(this.manipulationDiv),this.editModeDiv&&this.canvas.frame.removeChild(this.editModeDiv),this.closeDiv&&this.canvas.frame.removeChild(this.closeDiv),this.manipulationDiv=void 0,this.editModeDiv=void 0,this.closeDiv=void 0}},{key:"_createSeperator",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;this.manipulationDOM["seperatorLineDiv"+e]=document.createElement("div"),this.manipulationDOM["seperatorLineDiv"+e].className="vis-separator-line",this.manipulationDiv.appendChild(this.manipulationDOM["seperatorLineDiv"+e])}},{key:"_createAddNodeButton",value:function(e){var t=this._createButton("addNode","vis-button vis-add",e.addNode||this.options.locales.en.addNode);this.manipulationDiv.appendChild(t),this._bindHammerToDiv(t,this.addNodeMode.bind(this))}},{key:"_createAddEdgeButton",value:function(e){var t=this._createButton("addEdge","vis-button vis-connect",e.addEdge||this.options.locales.en.addEdge);this.manipulationDiv.appendChild(t),this._bindHammerToDiv(t,this.addEdgeMode.bind(this))}},{key:"_createEditNodeButton",value:function(e){var t=this._createButton("editNode","vis-button vis-edit",e.editNode||this.options.locales.en.editNode);this.manipulationDiv.appendChild(t),this._bindHammerToDiv(t,this.editNode.bind(this))}},{key:"_createEditEdgeButton",value:function(e){var t=this._createButton("editEdge","vis-button vis-edit",e.editEdge||this.options.locales.en.editEdge);this.manipulationDiv.appendChild(t),this._bindHammerToDiv(t,this.editEdgeMode.bind(this))}},{key:"_createDeleteButton",value:function(e){if(this.options.rtl)var t="vis-button vis-delete-rtl";else var t="vis-button vis-delete";var i=this._createButton("delete",t,e.del||this.options.locales.en.del);this.manipulationDiv.appendChild(i),this._bindHammerToDiv(i,this.deleteSelected.bind(this))}},{key:"_createBackButton",value:function(e){var t=this._createButton("back","vis-button vis-back",e.back||this.options.locales.en.back);this.manipulationDiv.appendChild(t),this._bindHammerToDiv(t,this.showManipulatorToolbar.bind(this))}},{key:"_createButton",value:function(e,t,i){var o=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"vis-label";return this.manipulationDOM[e+"Div"]=document.createElement("div"),this.manipulationDOM[e+"Div"].className=t,this.manipulationDOM[e+"Label"]=document.createElement("div"),this.manipulationDOM[e+"Label"].className=o,this.manipulationDOM[e+"Label"].innerHTML=i,this.manipulationDOM[e+"Div"].appendChild(this.manipulationDOM[e+"Label"]),this.manipulationDOM[e+"Div"]}},{key:"_createDescription",value:function(e){this.manipulationDiv.appendChild(this._createButton("description","vis-button vis-none",e))}},{key:"_temporaryBindEvent",value:function(e,t){this.temporaryEventFunctions.push({event:e,boundFunction:t}),this.body.emitter.on(e,t)}},{key:"_temporaryBindUI",value:function(e,t){if(void 0===this.body.eventListeners[e])throw new Error("This UI function does not exist. Typo? You tried: "+e+" possible are: "+(0,a.default)((0,s.default)(this.body.eventListeners)));this.temporaryUIFunctions[e]=this.body.eventListeners[e],this.body.eventListeners[e]=t}},{key:"_unbindTemporaryUIs",value:function(){for(var e in this.temporaryUIFunctions)this.temporaryUIFunctions.hasOwnProperty(e)&&(this.body.eventListeners[e]=this.temporaryUIFunctions[e],delete this.temporaryUIFunctions[e]);this.temporaryUIFunctions={}}},{key:"_unbindTemporaryEvents",value:function(){for(var e=0;e<this.temporaryEventFunctions.length;e++){var t=this.temporaryEventFunctions[e].event,i=this.temporaryEventFunctions[e].boundFunction;this.body.emitter.off(t,i)}this.temporaryEventFunctions=[]}},{key:"_bindHammerToDiv",value:function(e,t){var i=new v(e,{});g.onTouch(i,t),this.manipulationHammers.push(i)}},{key:"_cleanupTemporaryNodesAndEdges",value:function(){for(var e=0;e<this.temporaryIds.edges.length;e++){this.body.edges[this.temporaryIds.edges[e]].disconnect(),delete this.body.edges[this.temporaryIds.edges[e]];var t=this.body.edgeIndices.indexOf(this.temporaryIds.edges[e]);t!==-1&&this.body.edgeIndices.splice(t,1)}for(var i=0;i<this.temporaryIds.nodes.length;i++){delete this.body.nodes[this.temporaryIds.nodes[i]];var o=this.body.nodeIndices.indexOf(this.temporaryIds.nodes[i]);o!==-1&&this.body.nodeIndices.splice(o,1)}this.temporaryIds={nodes:[],edges:[]}}},{key:"_controlNodeTouch",value:function(e){this.selectionHandler.unselectAll(),this.lastTouch=this.body.functions.getPointer(e.center),this.lastTouch.translation=p.extend({},this.body.view.translation)}},{key:"_controlNodeDragStart",value:function(e){var t=this.lastTouch,i=this.selectionHandler._pointerToPositionObject(t),o=this.body.nodes[this.temporaryIds.nodes[0]],n=this.body.nodes[this.temporaryIds.nodes[1]],s=this.body.edges[this.edgeBeingEditedId];this.selectedControlNode=void 0;var r=o.isOverlappingWith(i),a=n.isOverlappingWith(i);r===!0?(this.selectedControlNode=o,s.edgeType.from=o):a===!0&&(this.selectedControlNode=n,s.edgeType.to=n),void 0!==this.selectedControlNode&&this.selectionHandler.selectObject(this.selectedControlNode),this.body.emitter.emit("_redraw")}},{key:"_controlNodeDrag",value:function(e){this.body.emitter.emit("disablePhysics");var t=this.body.functions.getPointer(e.center),i=this.canvas.DOMtoCanvas(t);if(void 0!==this.selectedControlNode)this.selectedControlNode.x=i.x,this.selectedControlNode.y=i.y;else{var o=t.x-this.lastTouch.x,n=t.y-this.lastTouch.y;this.body.view.translation={x:this.lastTouch.translation.x+o,y:this.lastTouch.translation.y+n}}this.body.emitter.emit("_redraw")}},{key:"_controlNodeDragEnd",value:function(e){var t=this.body.functions.getPointer(e.center),i=this.selectionHandler._pointerToPositionObject(t),o=this.body.edges[this.edgeBeingEditedId];if(void 0!==this.selectedControlNode){this.selectionHandler.unselectAll();for(var n=this.selectionHandler._getAllNodesOverlappingWith(i),s=void 0,r=n.length-1;r>=0;r--)if(n[r]!==this.selectedControlNode.id){s=this.body.nodes[n[r]];break}if(void 0!==s&&void 0!==this.selectedControlNode)if(s.isCluster===!0)alert(this.options.locales[this.options.locale].createEdgeError||this.options.locales.en.createEdgeError);else{var a=this.body.nodes[this.temporaryIds.nodes[0]];this.selectedControlNode.id===a.id?this._performEditEdge(s.id,o.to.id):this._performEditEdge(o.from.id,s.id)}else o.updateEdgeType(),this.body.emitter.emit("restorePhysics");this.body.emitter.emit("_redraw")}}},{key:"_handleConnect",value:function(e){if((new Date).valueOf()-this.touchTime>100){this.lastTouch=this.body.functions.getPointer(e.center),this.lastTouch.translation=p.extend({},this.body.view.translation);var t=this.lastTouch,i=this.selectionHandler.getNodeAt(t);if(void 0!==i)if(i.isCluster===!0)alert(this.options.locales[this.options.locale].createEdgeError||this.options.locales.en.createEdgeError);else{var o=this._getNewTargetNode(i.x,i.y);this.body.nodes[o.id]=o,this.body.nodeIndices.push(o.id);var n=this.body.functions.createEdge({id:"connectionEdge"+p.randomUUID(),from:i.id,to:o.id,physics:!1,smooth:{enabled:!0,type:"continuous",roundness:.5}});this.body.edges[n.id]=n,this.body.edgeIndices.push(n.id),this.temporaryIds.nodes.push(o.id),this.temporaryIds.edges.push(n.id)}this.touchTime=(new Date).valueOf()}}},{key:"_dragControlNode",value:function(e){var t=this.body.functions.getPointer(e.center);if(void 0!==this.temporaryIds.nodes[0]){var i=this.body.nodes[this.temporaryIds.nodes[0]];i.x=this.canvas._XconvertDOMtoCanvas(t.x),i.y=this.canvas._YconvertDOMtoCanvas(t.y),this.body.emitter.emit("_redraw")}else{var o=t.x-this.lastTouch.x,n=t.y-this.lastTouch.y;this.body.view.translation={x:this.lastTouch.translation.x+o,y:this.lastTouch.translation.y+n}}}},{key:"_finishConnect",value:function(e){var t=this.body.functions.getPointer(e.center),i=this.selectionHandler._pointerToPositionObject(t),o=void 0;void 0!==this.temporaryIds.edges[0]&&(o=this.body.edges[this.temporaryIds.edges[0]].fromId);for(var n=this.selectionHandler._getAllNodesOverlappingWith(i),s=void 0,r=n.length-1;r>=0;r--)if(this.temporaryIds.nodes.indexOf(n[r])===-1){s=this.body.nodes[n[r]];break}this._cleanupTemporaryNodesAndEdges(),void 0!==s&&(s.isCluster===!0?alert(this.options.locales[this.options.locale].createEdgeError||this.options.locales.en.createEdgeError):void 0!==this.body.nodes[o]&&void 0!==this.body.nodes[s.id]&&this._performAddEdge(o,s.id)),this.body.emitter.emit("_redraw")}},{key:"_performAddNode",value:function(e){var t=this,i={id:p.randomUUID(),x:e.pointer.canvas.x,y:e.pointer.canvas.y,label:"new"};if("function"==typeof this.options.addNode){if(2!==this.options.addNode.length)throw new Error("The function for add does not support two arguments (data,callback)");this.options.addNode(i,function(e){null!==e&&void 0!==e&&"addNode"===t.inMode&&(t.body.data.nodes.getDataSet().add(e),t.showManipulatorToolbar())})}else this.body.data.nodes.getDataSet().add(i),this.showManipulatorToolbar()}},{key:"_performAddEdge",value:function(e,t){var i=this,o={from:e,to:t};if("function"==typeof this.options.addEdge){if(2!==this.options.addEdge.length)throw new Error("The function for connect does not support two arguments (data,callback)");this.options.addEdge(o,function(e){null!==e&&void 0!==e&&"addEdge"===i.inMode&&(i.body.data.edges.getDataSet().add(e),i.selectionHandler.unselectAll(),i.showManipulatorToolbar())})}else this.body.data.edges.getDataSet().add(o),this.selectionHandler.unselectAll(),this.showManipulatorToolbar()}},{key:"_performEditEdge",value:function(e,t){var i=this,o={id:this.edgeBeingEditedId,from:e,to:t,label:this.body.data.edges._data[this.edgeBeingEditedId].label},n=this.options.editEdge;if("object"===("undefined"==typeof n?"undefined":(0,h.default)(n))&&(n=n.editWithoutDrag),"function"==typeof n){if(2!==n.length)throw new Error("The function for edit does not support two arguments (data, callback)");n(o,function(e){null===e||void 0===e||"editEdge"!==i.inMode?(i.body.edges[o.id].updateEdgeType(),i.body.emitter.emit("_redraw"),i.showManipulatorToolbar()):(i.body.data.edges.getDataSet().update(e),i.selectionHandler.unselectAll(),i.showManipulatorToolbar())})}else this.body.data.edges.getDataSet().update(o),this.selectionHandler.unselectAll(),this.showManipulatorToolbar()}}]),e}();t.default=y},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(89),s=o(n),r=i(62),a=o(r),d=i(105),h=o(d),l=i(106),u=o(l),c=i(1),f=i(178).default,p=function(){function e(t,i,o){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:1;(0,h.default)(this,e),this.parent=t,this.changedOptions=[],this.container=i,this.allowCreation=!1,this.options={},this.initialized=!1,this.popupCounter=0,this.defaultOptions={enabled:!1,filter:!0,container:void 0,showButton:!0},c.extend(this.options,this.defaultOptions),this.configureOptions=o,this.moduleOptions={},this.domElements=[],this.popupDiv={},this.popupLimit=5,this.popupHistory={},this.colorPicker=new f(n),this.wrapper=void 0}return(0,u.default)(e,[{key:"setOptions",value:function(e){if(void 0!==e){this.popupHistory={},this._removePopup();var t=!0;"string"==typeof e?this.options.filter=e:e instanceof Array?this.options.filter=e.join():"object"===("undefined"==typeof e?"undefined":(0,a.default)(e))?(void 0!==e.container&&(this.options.container=e.container),void 0!==e.filter&&(this.options.filter=e.filter),void 0!==e.showButton&&(this.options.showButton=e.showButton),void 0!==e.enabled&&(t=e.enabled)):"boolean"==typeof e?(this.options.filter=!0,t=e):"function"==typeof e&&(this.options.filter=e,t=!0),this.options.filter===!1&&(t=!1),this.options.enabled=t}this._clean()}},{key:"setModuleOptions",value:function(e){this.moduleOptions=e,this.options.enabled===!0&&(this._clean(),void 0!==this.options.container&&(this.container=this.options.container),this._create())}},{key:"_create",value:function(){var e=this;this._clean(),this.changedOptions=[];var t=this.options.filter,i=0,o=!1;for(var n in this.configureOptions)this.configureOptions.hasOwnProperty(n)&&(this.allowCreation=!1,o=!1,"function"==typeof t?(o=t(n,[]),o=o||this._handleObject(this.configureOptions[n],[n],!0)):t!==!0&&t.indexOf(n)===-1||(o=!0),o!==!1&&(this.allowCreation=!0,i>0&&this._makeItem([]),this._makeHeader(n),this._handleObject(this.configureOptions[n],[n])),i++);if(this.options.showButton===!0){var s=document.createElement("div");s.className="vis-configuration vis-config-button",s.innerHTML="generate options",s.onclick=function(){e._printOptions()},s.onmouseover=function(){s.className="vis-configuration vis-config-button hover"},s.onmouseout=function(){s.className="vis-configuration vis-config-button"},this.optionsContainer=document.createElement("div"),this.optionsContainer.className="vis-configuration vis-config-option-container",this.domElements.push(this.optionsContainer),this.domElements.push(s)}this._push()}},{key:"_push",value:function(){this.wrapper=document.createElement("div"),this.wrapper.className="vis-configuration-wrapper",this.container.appendChild(this.wrapper);for(var e=0;e<this.domElements.length;e++)this.wrapper.appendChild(this.domElements[e]);this._showPopupIfNeeded()}},{key:"_clean",value:function(){for(var e=0;e<this.domElements.length;e++)this.wrapper.removeChild(this.domElements[e]);void 0!==this.wrapper&&(this.container.removeChild(this.wrapper),this.wrapper=void 0),this.domElements=[],this._removePopup()}},{key:"_getValue",value:function(e){for(var t=this.moduleOptions,i=0;i<e.length;i++){if(void 0===t[e[i]]){t=void 0;break}t=t[e[i]]}return t}},{key:"_makeItem",value:function(e){if(this.allowCreation===!0){var t=document.createElement("div");t.className="vis-configuration vis-config-item vis-config-s"+e.length;for(var i=arguments.length,o=Array(i>1?i-1:0),n=1;n<i;n++)o[n-1]=arguments[n];return o.forEach(function(e){t.appendChild(e)}),this.domElements.push(t),this.domElements.length}return 0}},{key:"_makeHeader",value:function(e){var t=document.createElement("div");t.className="vis-configuration vis-config-header",t.innerHTML=e,this._makeItem([],t)}},{key:"_makeLabel",value:function(e,t){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],o=document.createElement("div");return o.className="vis-configuration vis-config-label vis-config-s"+t.length,i===!0?o.innerHTML="<i><b>"+e+":</b></i>":o.innerHTML=e+":",o}},{key:"_makeDropdown",value:function(e,t,i){var o=document.createElement("select");o.className="vis-configuration vis-config-select";var n=0;void 0!==t&&e.indexOf(t)!==-1&&(n=e.indexOf(t));for(var s=0;s<e.length;s++){var r=document.createElement("option");r.value=e[s],s===n&&(r.selected="selected"),r.innerHTML=e[s],o.appendChild(r)}var a=this;o.onchange=function(){a._update(this.value,i)};var d=this._makeLabel(i[i.length-1],i);
this._makeItem(i,d,o)}},{key:"_makeRange",value:function(e,t,i){var o=e[0],n=e[1],s=e[2],r=e[3],a=document.createElement("input");a.className="vis-configuration vis-config-range";try{a.type="range",a.min=n,a.max=s}catch(e){}a.step=r;var d="",h=0;if(void 0!==t){var l=1.2;t<0&&t*l<n?(a.min=Math.ceil(t*l),h=a.min,d="range increased"):t/l<n&&(a.min=Math.ceil(t/l),h=a.min,d="range increased"),t*l>s&&1!==s&&(a.max=Math.ceil(t*l),h=a.max,d="range increased"),a.value=t}else a.value=o;var u=document.createElement("input");u.className="vis-configuration vis-config-rangeinput",u.value=a.value;var c=this;a.onchange=function(){u.value=this.value,c._update(Number(this.value),i)},a.oninput=function(){u.value=this.value};var f=this._makeLabel(i[i.length-1],i),p=this._makeItem(i,f,a,u);""!==d&&this.popupHistory[p]!==h&&(this.popupHistory[p]=h,this._setupPopup(d,p))}},{key:"_setupPopup",value:function(e,t){var i=this;if(this.initialized===!0&&this.allowCreation===!0&&this.popupCounter<this.popupLimit){var o=document.createElement("div");o.id="vis-configuration-popup",o.className="vis-configuration-popup",o.innerHTML=e,o.onclick=function(){i._removePopup()},this.popupCounter+=1,this.popupDiv={html:o,index:t}}}},{key:"_removePopup",value:function(){void 0!==this.popupDiv.html&&(this.popupDiv.html.parentNode.removeChild(this.popupDiv.html),clearTimeout(this.popupDiv.hideTimeout),clearTimeout(this.popupDiv.deleteTimeout),this.popupDiv={})}},{key:"_showPopupIfNeeded",value:function(){var e=this;if(void 0!==this.popupDiv.html){var t=this.domElements[this.popupDiv.index],i=t.getBoundingClientRect();this.popupDiv.html.style.left=i.left+"px",this.popupDiv.html.style.top=i.top-30+"px",document.body.appendChild(this.popupDiv.html),this.popupDiv.hideTimeout=setTimeout(function(){e.popupDiv.html.style.opacity=0},1500),this.popupDiv.deleteTimeout=setTimeout(function(){e._removePopup()},1800)}}},{key:"_makeCheckbox",value:function(e,t,i){var o=document.createElement("input");o.type="checkbox",o.className="vis-configuration vis-config-checkbox",o.checked=e,void 0!==t&&(o.checked=t,t!==e&&("object"===("undefined"==typeof e?"undefined":(0,a.default)(e))?t!==e.enabled&&this.changedOptions.push({path:i,value:t}):this.changedOptions.push({path:i,value:t})));var n=this;o.onchange=function(){n._update(this.checked,i)};var s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,o)}},{key:"_makeTextInput",value:function(e,t,i){var o=document.createElement("input");o.type="text",o.className="vis-configuration vis-config-text",o.value=t,t!==e&&this.changedOptions.push({path:i,value:t});var n=this;o.onchange=function(){n._update(this.value,i)};var s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,o)}},{key:"_makeColorField",value:function(e,t,i){var o=this,n=e[1],s=document.createElement("div");t=void 0===t?n:t,"none"!==t?(s.className="vis-configuration vis-config-colorBlock",s.style.backgroundColor=t):s.className="vis-configuration vis-config-colorBlock none",t=void 0===t?n:t,s.onclick=function(){o._showColorPicker(t,s,i)};var r=this._makeLabel(i[i.length-1],i);this._makeItem(i,r,s)}},{key:"_showColorPicker",value:function(e,t,i){var o=this;t.onclick=function(){},this.colorPicker.insertTo(t),this.colorPicker.show(),this.colorPicker.setColor(e),this.colorPicker.setUpdateCallback(function(e){var n="rgba("+e.r+","+e.g+","+e.b+","+e.a+")";t.style.backgroundColor=n,o._update(n,i)}),this.colorPicker.setCloseCallback(function(){t.onclick=function(){o._showColorPicker(e,t,i)}})}},{key:"_handleObject",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],o=!1,n=this.options.filter,s=!1;for(var r in e)if(e.hasOwnProperty(r)){o=!0;var a=e[r],d=c.copyAndExtendArray(t,r);if("function"==typeof n&&(o=n(r,t),o===!1&&!(a instanceof Array)&&"string"!=typeof a&&"boolean"!=typeof a&&a instanceof Object&&(this.allowCreation=!1,o=this._handleObject(a,d,!0),this.allowCreation=i===!1)),o!==!1){s=!0;var h=this._getValue(d);if(a instanceof Array)this._handleArray(a,h,d);else if("string"==typeof a)this._makeTextInput(a,h,d);else if("boolean"==typeof a)this._makeCheckbox(a,h,d);else if(a instanceof Object){var l=!0;if(t.indexOf("physics")!==-1&&this.moduleOptions.physics.solver!==r&&(l=!1),l===!0)if(void 0!==a.enabled){var u=c.copyAndExtendArray(d,"enabled"),f=this._getValue(u);if(f===!0){var p=this._makeLabel(r,d,!0);this._makeItem(d,p),s=this._handleObject(a,d)||s}else this._makeCheckbox(a,f,d)}else{var v=this._makeLabel(r,d,!0);this._makeItem(d,v),s=this._handleObject(a,d)||s}}else console.error("dont know how to handle",a,r,d)}}return s}},{key:"_handleArray",value:function(e,t,i){"string"==typeof e[0]&&"color"===e[0]?(this._makeColorField(e,t,i),e[1]!==t&&this.changedOptions.push({path:i,value:t})):"string"==typeof e[0]?(this._makeDropdown(e,t,i),e[0]!==t&&this.changedOptions.push({path:i,value:t})):"number"==typeof e[0]&&(this._makeRange(e,t,i),e[0]!==t&&this.changedOptions.push({path:i,value:Number(t)}))}},{key:"_update",value:function(e,t){var i=this._constructOptions(e,t);this.parent.body&&this.parent.body.emitter&&this.parent.body.emitter.emit&&this.parent.body.emitter.emit("configChange",i),this.initialized=!0,this.parent.setOptions(i)}},{key:"_constructOptions",value:function(e,t){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=i;e="true"===e||e,e="false"!==e&&e;for(var n=0;n<t.length;n++)"global"!==t[n]&&(void 0===o[t[n]]&&(o[t[n]]={}),n!==t.length-1?o=o[t[n]]:o[t[n]]=e);return i}},{key:"_printOptions",value:function(){var e=this.getOptions();this.optionsContainer.innerHTML="<pre>var options = "+(0,s.default)(e,null,2)+"</pre>"}},{key:"getOptions",value:function(){for(var e={},t=0;t<this.changedOptions.length;t++)this._constructOptions(this.changedOptions[t].value,this.changedOptions[t].path,e);return e}}]),e}();t.default=p},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(89),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(100),u=i(170),c=i(1),f=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;(0,a.default)(this,e),this.pixelRatio=t,this.generated=!1,this.centerCoordinates={x:144.5,y:144.5},this.r=289*.49,this.color={r:255,g:255,b:255,a:1},this.hueCircle=void 0,this.initialColor={r:255,g:255,b:255,a:1},this.previousColor=void 0,this.applied=!1,this.updateCallback=function(){},this.closeCallback=function(){},this._create()}return(0,h.default)(e,[{key:"insertTo",value:function(e){void 0!==this.hammer&&(this.hammer.destroy(),this.hammer=void 0),this.container=e,this.container.appendChild(this.frame),this._bindHammer(),this._setSize()}},{key:"setUpdateCallback",value:function(e){if("function"!=typeof e)throw new Error("Function attempted to set as colorPicker update callback is not a function.");this.updateCallback=e}},{key:"setCloseCallback",value:function(e){if("function"!=typeof e)throw new Error("Function attempted to set as colorPicker closing callback is not a function.");this.closeCallback=e}},{key:"_isColorString",value:function(e){var t={black:"#000000",navy:"#000080",darkblue:"#00008B",mediumblue:"#0000CD",blue:"#0000FF",darkgreen:"#006400",green:"#008000",teal:"#008080",darkcyan:"#008B8B",deepskyblue:"#00BFFF",darkturquoise:"#00CED1",mediumspringgreen:"#00FA9A",lime:"#00FF00",springgreen:"#00FF7F",aqua:"#00FFFF",cyan:"#00FFFF",midnightblue:"#191970",dodgerblue:"#1E90FF",lightseagreen:"#20B2AA",forestgreen:"#228B22",seagreen:"#2E8B57",darkslategray:"#2F4F4F",limegreen:"#32CD32",mediumseagreen:"#3CB371",turquoise:"#40E0D0",royalblue:"#4169E1",steelblue:"#4682B4",darkslateblue:"#483D8B",mediumturquoise:"#48D1CC",indigo:"#4B0082",darkolivegreen:"#556B2F",cadetblue:"#5F9EA0",cornflowerblue:"#6495ED",mediumaquamarine:"#66CDAA",dimgray:"#696969",slateblue:"#6A5ACD",olivedrab:"#6B8E23",slategray:"#708090",lightslategray:"#778899",mediumslateblue:"#7B68EE",lawngreen:"#7CFC00",chartreuse:"#7FFF00",aquamarine:"#7FFFD4",maroon:"#800000",purple:"#800080",olive:"#808000",gray:"#808080",skyblue:"#87CEEB",lightskyblue:"#87CEFA",blueviolet:"#8A2BE2",darkred:"#8B0000",darkmagenta:"#8B008B",saddlebrown:"#8B4513",darkseagreen:"#8FBC8F",lightgreen:"#90EE90",mediumpurple:"#9370D8",darkviolet:"#9400D3",palegreen:"#98FB98",darkorchid:"#9932CC",yellowgreen:"#9ACD32",sienna:"#A0522D",brown:"#A52A2A",darkgray:"#A9A9A9",lightblue:"#ADD8E6",greenyellow:"#ADFF2F",paleturquoise:"#AFEEEE",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",firebrick:"#B22222",darkgoldenrod:"#B8860B",mediumorchid:"#BA55D3",rosybrown:"#BC8F8F",darkkhaki:"#BDB76B",silver:"#C0C0C0",mediumvioletred:"#C71585",indianred:"#CD5C5C",peru:"#CD853F",chocolate:"#D2691E",tan:"#D2B48C",lightgrey:"#D3D3D3",palevioletred:"#D87093",thistle:"#D8BFD8",orchid:"#DA70D6",goldenrod:"#DAA520",crimson:"#DC143C",gainsboro:"#DCDCDC",plum:"#DDA0DD",burlywood:"#DEB887",lightcyan:"#E0FFFF",lavender:"#E6E6FA",darksalmon:"#E9967A",violet:"#EE82EE",palegoldenrod:"#EEE8AA",lightcoral:"#F08080",khaki:"#F0E68C",aliceblue:"#F0F8FF",honeydew:"#F0FFF0",azure:"#F0FFFF",sandybrown:"#F4A460",wheat:"#F5DEB3",beige:"#F5F5DC",whitesmoke:"#F5F5F5",mintcream:"#F5FFFA",ghostwhite:"#F8F8FF",salmon:"#FA8072",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lightgoldenrodyellow:"#FAFAD2",oldlace:"#FDF5E6",red:"#FF0000",fuchsia:"#FF00FF",magenta:"#FF00FF",deeppink:"#FF1493",orangered:"#FF4500",tomato:"#FF6347",hotpink:"#FF69B4",coral:"#FF7F50",darkorange:"#FF8C00",lightsalmon:"#FFA07A",orange:"#FFA500",lightpink:"#FFB6C1",pink:"#FFC0CB",gold:"#FFD700",peachpuff:"#FFDAB9",navajowhite:"#FFDEAD",moccasin:"#FFE4B5",bisque:"#FFE4C4",mistyrose:"#FFE4E1",blanchedalmond:"#FFEBCD",papayawhip:"#FFEFD5",lavenderblush:"#FFF0F5",seashell:"#FFF5EE",cornsilk:"#FFF8DC",lemonchiffon:"#FFFACD",floralwhite:"#FFFAF0",snow:"#FFFAFA",yellow:"#FFFF00",lightyellow:"#FFFFE0",ivory:"#FFFFF0",white:"#FFFFFF"};if("string"==typeof e)return t[e]}},{key:"setColor",value:function(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if("none"!==e){var i=void 0,o=this._isColorString(e);if(void 0!==o&&(e=o),c.isString(e)===!0){if(c.isValidRGB(e)===!0){var n=e.substr(4).substr(0,e.length-5).split(",");i={r:n[0],g:n[1],b:n[2],a:1}}else if(c.isValidRGBA(e)===!0){var r=e.substr(5).substr(0,e.length-6).split(",");i={r:r[0],g:r[1],b:r[2],a:r[3]}}else if(c.isValidHex(e)===!0){var a=c.hexToRGB(e);i={r:a.r,g:a.g,b:a.b,a:1}}}else if(e instanceof Object&&void 0!==e.r&&void 0!==e.g&&void 0!==e.b){var d=void 0!==e.a?e.a:"1.0";i={r:e.r,g:e.g,b:e.b,a:d}}if(void 0===i)throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: "+(0,s.default)(e));this._setColor(i,t)}}},{key:"show",value:function(){void 0!==this.closeCallback&&(this.closeCallback(),this.closeCallback=void 0),this.applied=!1,this.frame.style.display="block",this._generateHueCircle()}},{key:"_hide",value:function(){var e=this,t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];t===!0&&(this.previousColor=c.extend({},this.color)),this.applied===!0&&this.updateCallback(this.initialColor),this.frame.style.display="none",setTimeout(function(){void 0!==e.closeCallback&&(e.closeCallback(),e.closeCallback=void 0)},0)}},{key:"_save",value:function(){this.updateCallback(this.color),this.applied=!1,this._hide()}},{key:"_apply",value:function(){this.applied=!0,this.updateCallback(this.color),this._updatePicker(this.color)}},{key:"_loadLast",value:function(){void 0!==this.previousColor?this.setColor(this.previousColor,!1):alert("There is no last color to load...")}},{key:"_setColor",value:function(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];t===!0&&(this.initialColor=c.extend({},e)),this.color=e;var i=c.RGBToHSV(e.r,e.g,e.b),o=2*Math.PI,n=this.r*i.s,s=this.centerCoordinates.x+n*Math.sin(o*i.h),r=this.centerCoordinates.y+n*Math.cos(o*i.h);this.colorPickerSelector.style.left=s-.5*this.colorPickerSelector.clientWidth+"px",this.colorPickerSelector.style.top=r-.5*this.colorPickerSelector.clientHeight+"px",this._updatePicker(e)}},{key:"_setOpacity",value:function(e){this.color.a=e/100,this._updatePicker(this.color)}},{key:"_setBrightness",value:function(e){var t=c.RGBToHSV(this.color.r,this.color.g,this.color.b);t.v=e/100;var i=c.HSVToRGB(t.h,t.s,t.v);i.a=this.color.a,this.color=i,this._updatePicker()}},{key:"_updatePicker",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.color,t=c.RGBToHSV(e.r,e.g,e.b),i=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(i.webkitBackingStorePixelRatio||i.mozBackingStorePixelRatio||i.msBackingStorePixelRatio||i.oBackingStorePixelRatio||i.backingStorePixelRatio||1)),i.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);var o=this.colorPickerCanvas.clientWidth,n=this.colorPickerCanvas.clientHeight;i.clearRect(0,0,o,n),i.putImageData(this.hueCircle,0,0),i.fillStyle="rgba(0,0,0,"+(1-t.v)+")",i.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),i.fill(),this.brightnessRange.value=100*t.v,this.opacityRange.value=100*e.a,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}},{key:"_setSize",value:function(){this.colorPickerCanvas.style.width="100%",this.colorPickerCanvas.style.height="100%",this.colorPickerCanvas.width=289*this.pixelRatio,this.colorPickerCanvas.height=289*this.pixelRatio}},{key:"_create",value:function(){if(this.frame=document.createElement("div"),this.frame.className="vis-color-picker",this.colorPickerDiv=document.createElement("div"),this.colorPickerSelector=document.createElement("div"),this.colorPickerSelector.className="vis-selector",this.colorPickerDiv.appendChild(this.colorPickerSelector),this.colorPickerCanvas=document.createElement("canvas"),this.colorPickerDiv.appendChild(this.colorPickerCanvas),this.colorPickerCanvas.getContext){var e=this.colorPickerCanvas.getContext("2d");this.pixelRatio=(window.devicePixelRatio||1)/(e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.msBackingStorePixelRatio||e.oBackingStorePixelRatio||e.backingStorePixelRatio||1),this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0)}else{var t=document.createElement("DIV");t.style.color="red",t.style.fontWeight="bold",t.style.padding="10px",t.innerHTML="Error: your browser does not support HTML canvas",this.colorPickerCanvas.appendChild(t)}this.colorPickerDiv.className="vis-color",this.opacityDiv=document.createElement("div"),this.opacityDiv.className="vis-opacity",this.brightnessDiv=document.createElement("div"),this.brightnessDiv.className="vis-brightness",this.arrowDiv=document.createElement("div"),this.arrowDiv.className="vis-arrow",this.opacityRange=document.createElement("input");try{this.opacityRange.type="range",this.opacityRange.min="0",this.opacityRange.max="100"}catch(e){}this.opacityRange.value="100",this.opacityRange.className="vis-range",this.brightnessRange=document.createElement("input");try{this.brightnessRange.type="range",this.brightnessRange.min="0",this.brightnessRange.max="100"}catch(e){}this.brightnessRange.value="100",this.brightnessRange.className="vis-range",this.opacityDiv.appendChild(this.opacityRange),this.brightnessDiv.appendChild(this.brightnessRange);var i=this;this.opacityRange.onchange=function(){i._setOpacity(this.value)},this.opacityRange.oninput=function(){i._setOpacity(this.value)},this.brightnessRange.onchange=function(){i._setBrightness(this.value)},this.brightnessRange.oninput=function(){i._setBrightness(this.value)},this.brightnessLabel=document.createElement("div"),this.brightnessLabel.className="vis-label vis-brightness",this.brightnessLabel.innerHTML="brightness:",this.opacityLabel=document.createElement("div"),this.opacityLabel.className="vis-label vis-opacity",this.opacityLabel.innerHTML="opacity:",this.newColorDiv=document.createElement("div"),this.newColorDiv.className="vis-new-color",this.newColorDiv.innerHTML="new",this.initialColorDiv=document.createElement("div"),this.initialColorDiv.className="vis-initial-color",this.initialColorDiv.innerHTML="initial",this.cancelButton=document.createElement("div"),this.cancelButton.className="vis-button vis-cancel",this.cancelButton.innerHTML="cancel",this.cancelButton.onclick=this._hide.bind(this,!1),this.applyButton=document.createElement("div"),this.applyButton.className="vis-button vis-apply",this.applyButton.innerHTML="apply",this.applyButton.onclick=this._apply.bind(this),this.saveButton=document.createElement("div"),this.saveButton.className="vis-button vis-save",this.saveButton.innerHTML="save",this.saveButton.onclick=this._save.bind(this),this.loadButton=document.createElement("div"),this.loadButton.className="vis-button vis-load",this.loadButton.innerHTML="load last",this.loadButton.onclick=this._loadLast.bind(this),this.frame.appendChild(this.colorPickerDiv),this.frame.appendChild(this.arrowDiv),this.frame.appendChild(this.brightnessLabel),this.frame.appendChild(this.brightnessDiv),this.frame.appendChild(this.opacityLabel),this.frame.appendChild(this.opacityDiv),this.frame.appendChild(this.newColorDiv),this.frame.appendChild(this.initialColorDiv),this.frame.appendChild(this.cancelButton),this.frame.appendChild(this.applyButton),this.frame.appendChild(this.saveButton),this.frame.appendChild(this.loadButton)}},{key:"_bindHammer",value:function(){var e=this;this.drag={},this.pinch={},this.hammer=new l(this.colorPickerCanvas),this.hammer.get("pinch").set({enable:!0}),u.onTouch(this.hammer,function(t){e._moveSelector(t)}),this.hammer.on("tap",function(t){e._moveSelector(t)}),this.hammer.on("panstart",function(t){e._moveSelector(t)}),this.hammer.on("panmove",function(t){e._moveSelector(t)}),this.hammer.on("panend",function(t){e._moveSelector(t)})}},{key:"_generateHueCircle",value:function(){if(this.generated===!1){var e=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.msBackingStorePixelRatio||e.oBackingStorePixelRatio||e.backingStorePixelRatio||1)),e.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);var t=this.colorPickerCanvas.clientWidth,i=this.colorPickerCanvas.clientHeight;e.clearRect(0,0,t,i);var o=void 0,n=void 0,s=void 0,r=void 0;this.centerCoordinates={x:.5*t,y:.5*i},this.r=.49*t;var a=2*Math.PI/360,d=1/360,h=1/this.r,l=void 0;for(s=0;s<360;s++)for(r=0;r<this.r;r++)o=this.centerCoordinates.x+r*Math.sin(a*s),n=this.centerCoordinates.y+r*Math.cos(a*s),l=c.HSVToRGB(s*d,r*h,1),e.fillStyle="rgb("+l.r+","+l.g+","+l.b+")",e.fillRect(o-.5,n-.5,2,2);e.strokeStyle="rgba(0,0,0,1)",e.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),e.stroke(),this.hueCircle=e.getImageData(0,0,t,i)}this.generated=!0}},{key:"_moveSelector",value:function(e){var t=this.colorPickerDiv.getBoundingClientRect(),i=e.center.x-t.left,o=e.center.y-t.top,n=.5*this.colorPickerDiv.clientHeight,s=.5*this.colorPickerDiv.clientWidth,r=i-s,a=o-n,d=Math.atan2(r,a),h=.98*Math.min(Math.sqrt(r*r+a*a),s),l=Math.cos(d)*h+n,u=Math.sin(d)*h+s;this.colorPickerSelector.style.top=l-.5*this.colorPickerSelector.clientHeight+"px",this.colorPickerSelector.style.left=u-.5*this.colorPickerSelector.clientWidth+"px";var f=d/(2*Math.PI);f=f<0?f+1:f;var p=h/this.r,v=c.RGBToHSV(this.color.r,this.color.g,this.color.b);v.h=f,v.s=p;var g=c.HSVToRGB(v.h,v.s,v.v);g.a=this.color.a,this.color=g,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}}]),e}();t.default=f},function(e,t){Object.defineProperty(t,"__esModule",{value:!0});var i="string",o="boolean",n="number",s="array",r="object",a="dom",d="any",h={configure:{enabled:{boolean:o},filter:{boolean:o,string:i,array:s,function:"function"},container:{dom:a},showButton:{boolean:o},__type__:{object:r,boolean:o,string:i,array:s,function:"function"}},edges:{arrows:{to:{enabled:{boolean:o},scaleFactor:{number:n},type:{string:["arrow","circle"]},__type__:{object:r,boolean:o}},middle:{enabled:{boolean:o},scaleFactor:{number:n},type:{string:["arrow","circle"]},__type__:{object:r,boolean:o}},from:{enabled:{boolean:o},scaleFactor:{number:n},type:{string:["arrow","circle"]},__type__:{object:r,boolean:o}},__type__:{string:["from","to","middle"],object:r}},arrowStrikethrough:{boolean:o},chosen:{label:{boolean:o,function:"function"},edge:{boolean:o,function:"function"},__type__:{object:r,boolean:o}},color:{color:{string:i},highlight:{string:i},hover:{string:i},inherit:{string:["from","to","both"],boolean:o},opacity:{number:n},__type__:{object:r,string:i}},dashes:{boolean:o,array:s},font:{color:{string:i},size:{number:n},face:{string:i},background:{string:i},strokeWidth:{number:n},strokeColor:{string:i},align:{string:["horizontal","top","middle","bottom"]},vadjust:{number:n},multi:{boolean:o,string:i},bold:{color:{string:i},size:{number:n},face:{string:i},mod:{string:i},vadjust:{number:n},__type__:{object:r,string:i}},boldital:{color:{string:i},size:{number:n},face:{string:i},mod:{string:i},vadjust:{number:n},__type__:{object:r,string:i}},ital:{color:{string:i},size:{number:n},face:{string:i},mod:{string:i},vadjust:{number:n},__type__:{object:r,string:i}},mono:{color:{string:i},size:{number:n},face:{string:i},mod:{string:i},vadjust:{number:n},__type__:{object:r,string:i}},__type__:{object:r,string:i}},hidden:{boolean:o},hoverWidth:{function:"function",number:n},label:{string:i,undefined:"undefined"},labelHighlightBold:{boolean:o},length:{number:n,undefined:"undefined"},physics:{boolean:o},scaling:{min:{number:n},max:{number:n},label:{enabled:{boolean:o},min:{number:n},max:{number:n},maxVisible:{number:n},drawThreshold:{number:n},__type__:{object:r,boolean:o}},customScalingFunction:{function:"function"},__type__:{object:r}},selectionWidth:{function:"function",number:n},selfReferenceSize:{number:n},shadow:{enabled:{boolean:o},color:{string:i},size:{number:n},x:{number:n},y:{number:n},__type__:{object:r,boolean:o}},smooth:{enabled:{boolean:o},type:{string:["dynamic","continuous","discrete","diagonalCross","straightCross","horizontal","vertical","curvedCW","curvedCCW","cubicBezier"]},roundness:{number:n},forceDirection:{string:["horizontal","vertical","none"],boolean:o},__type__:{object:r,boolean:o}},title:{string:i,undefined:"undefined"},width:{number:n},widthConstraint:{maximum:{number:n},__type__:{object:r,boolean:o,number:n}},value:{number:n,undefined:"undefined"},__type__:{object:r}},groups:{useDefaultGroups:{boolean:o},__any__:"get from nodes, will be overwritten below",__type__:{object:r}},interaction:{dragNodes:{boolean:o},dragView:{boolean:o},hideEdgesOnDrag:{boolean:o},hideNodesOnDrag:{boolean:o},hover:{boolean:o},keyboard:{enabled:{boolean:o},speed:{x:{number:n},y:{number:n},zoom:{number:n},__type__:{object:r}},bindToWindow:{boolean:o},__type__:{object:r,boolean:o}},multiselect:{boolean:o},navigationButtons:{boolean:o},selectable:{boolean:o},selectConnectedEdges:{boolean:o},hoverConnectedEdges:{boolean:o},tooltipDelay:{number:n},zoomView:{boolean:o},__type__:{object:r}},layout:{randomSeed:{undefined:"undefined",number:n},improvedLayout:{boolean:o},hierarchical:{enabled:{boolean:o},levelSeparation:{number:n},nodeSpacing:{number:n},treeSpacing:{number:n},blockShifting:{boolean:o},edgeMinimization:{boolean:o},parentCentralization:{boolean:o},direction:{string:["UD","DU","LR","RL"]},sortMethod:{string:["hubsize","directed"]},__type__:{object:r,boolean:o}},__type__:{object:r}},manipulation:{enabled:{boolean:o},initiallyActive:{boolean:o},addNode:{boolean:o,function:"function"},addEdge:{boolean:o,function:"function"},editNode:{function:"function"},editEdge:{editWithoutDrag:{function:"function"},__type__:{object:r,boolean:o,function:"function"}},deleteNode:{boolean:o,function:"function"},deleteEdge:{boolean:o,function:"function"},controlNodeStyle:"get from nodes, will be overwritten below",__type__:{object:r,boolean:o}},nodes:{borderWidth:{number:n},borderWidthSelected:{number:n,undefined:"undefined"},brokenImage:{string:i,undefined:"undefined"},chosen:{label:{boolean:o,function:"function"},node:{boolean:o,function:"function"},__type__:{object:r,boolean:o}},color:{border:{string:i},background:{string:i},highlight:{border:{string:i},background:{string:i},__type__:{object:r,string:i}},hover:{border:{string:i},background:{string:i},__type__:{object:r,string:i}},__type__:{object:r,string:i}},fixed:{x:{boolean:o},y:{boolean:o},__type__:{object:r,boolean:o}},font:{align:{string:i},color:{string:i},size:{number:n},face:{string:i},background:{string:i},strokeWidth:{number:n},strokeColor:{string:i},vadjust:{number:n},multi:{boolean:o,string:i},bold:{color:{string:i},size:{number:n},face:{string:i},mod:{string:i},vadjust:{number:n},__type__:{object:r,string:i}},boldital:{color:{string:i},size:{number:n},face:{string:i},mod:{string:i},vadjust:{number:n},__type__:{object:r,string:i}},ital:{color:{string:i},size:{number:n},face:{string:i},mod:{string:i},vadjust:{number:n},__type__:{object:r,string:i}},mono:{color:{string:i},size:{number:n},face:{string:i},mod:{string:i},vadjust:{number:n},__type__:{object:r,string:i}},__type__:{object:r,string:i}},group:{string:i,number:n,undefined:"undefined"},heightConstraint:{minimum:{number:n},valign:{string:i},__type__:{object:r,boolean:o,number:n}},hidden:{boolean:o},icon:{face:{string:i},code:{string:i},size:{number:n},color:{string:i},__type__:{object:r}},id:{string:i,number:n},image:{selected:{string:i,undefined:"undefined"},unselected:{string:i,undefined:"undefined"},__type__:{object:r,string:i}},label:{string:i,undefined:"undefined"},labelHighlightBold:{boolean:o},level:{number:n,undefined:"undefined"},margin:{top:{number:n},right:{number:n},bottom:{number:n},left:{number:n},__type__:{object:r,number:n}},mass:{number:n},physics:{boolean:o},scaling:{min:{number:n},max:{number:n},label:{enabled:{boolean:o},min:{number:n},max:{number:n},maxVisible:{number:n},drawThreshold:{number:n},__type__:{object:r,boolean:o}},customScalingFunction:{function:"function"},__type__:{object:r}},shadow:{enabled:{boolean:o},color:{string:i},size:{number:n},x:{number:n},y:{number:n},__type__:{object:r,boolean:o}},shape:{string:["ellipse","circle","database","box","text","image","circularImage","diamond","dot","star","triangle","triangleDown","square","icon"]},shapeProperties:{borderDashes:{boolean:o,array:s},borderRadius:{number:n},interpolation:{boolean:o},useImageSize:{boolean:o},useBorderWithImage:{boolean:o},__type__:{object:r}},size:{number:n},title:{string:i,undefined:"undefined"},value:{number:n,undefined:"undefined"},widthConstraint:{minimum:{number:n},maximum:{number:n},__type__:{object:r,boolean:o,number:n}},x:{number:n},y:{number:n},__type__:{object:r}},physics:{enabled:{boolean:o},barnesHut:{gravitationalConstant:{number:n},centralGravity:{number:n},springLength:{number:n},springConstant:{number:n},damping:{number:n},avoidOverlap:{number:n},__type__:{object:r}},forceAtlas2Based:{gravitationalConstant:{number:n},centralGravity:{number:n},springLength:{number:n},springConstant:{number:n},damping:{number:n},avoidOverlap:{number:n},__type__:{object:r}},repulsion:{centralGravity:{number:n},springLength:{number:n},springConstant:{number:n},nodeDistance:{number:n},damping:{number:n},__type__:{object:r}},hierarchicalRepulsion:{centralGravity:{number:n},springLength:{number:n},springConstant:{number:n},nodeDistance:{number:n},damping:{number:n},__type__:{object:r}},maxVelocity:{number:n},minVelocity:{number:n},solver:{string:["barnesHut","repulsion","hierarchicalRepulsion","forceAtlas2Based"]},stabilization:{enabled:{boolean:o},iterations:{number:n},updateInterval:{number:n},onlyDynamicEdges:{boolean:o},fit:{boolean:o},__type__:{object:r,boolean:o}},timestep:{number:n},adaptiveTimestep:{boolean:o},__type__:{object:r,boolean:o}},autoResize:{boolean:o},clickToUse:{boolean:o},locale:{string:i},locales:{__any__:{any:d},__type__:{object:r}},height:{string:i},width:{string:i},__type__:{object:r}};h.groups.__any__=h.nodes,h.manipulation.controlNodeStyle=h.nodes;var l={nodes:{borderWidth:[1,0,10,1],borderWidthSelected:[2,0,10,1],color:{border:["color","#2B7CE9"],background:["color","#97C2FC"],highlight:{border:["color","#2B7CE9"],background:["color","#D2E5FF"]},hover:{border:["color","#2B7CE9"],background:["color","#D2E5FF"]}},fixed:{x:!1,y:!1},font:{color:["color","#343434"],size:[14,0,100,1],face:["arial","verdana","tahoma"],background:["color","none"],strokeWidth:[0,0,50,1],strokeColor:["color","#ffffff"]},hidden:!1,labelHighlightBold:!0,physics:!0,scaling:{min:[10,0,200,1],max:[30,0,200,1],label:{enabled:!1,min:[14,0,200,1],max:[30,0,200,1],maxVisible:[30,0,200,1],drawThreshold:[5,0,20,1]}},shadow:{enabled:!1,color:"rgba(0,0,0,0.5)",size:[10,0,20,1],x:[5,-30,30,1],y:[5,-30,30,1]},shape:["ellipse","box","circle","database","diamond","dot","square","star","text","triangle","triangleDown"],shapeProperties:{borderDashes:!1,borderRadius:[6,0,20,1],interpolation:!0,useImageSize:!1},size:[25,0,200,1]},edges:{arrows:{to:{enabled:!1,scaleFactor:[1,0,3,.05],type:"arrow"},middle:{enabled:!1,scaleFactor:[1,0,3,.05],type:"arrow"},from:{enabled:!1,scaleFactor:[1,0,3,.05],type:"arrow"}},arrowStrikethrough:!0,color:{color:["color","#848484"],highlight:["color","#848484"],hover:["color","#848484"],inherit:["from","to","both",!0,!1],opacity:[1,0,1,.05]},dashes:!1,font:{color:["color","#343434"],size:[14,0,100,1],face:["arial","verdana","tahoma"],background:["color","none"],strokeWidth:[2,0,50,1],strokeColor:["color","#ffffff"],align:["horizontal","top","middle","bottom"]},hidden:!1,hoverWidth:[1.5,0,5,.1],labelHighlightBold:!0,physics:!0,scaling:{min:[1,0,100,1],max:[15,0,100,1],label:{enabled:!0,min:[14,0,200,1],max:[30,0,200,1],maxVisible:[30,0,200,1],drawThreshold:[5,0,20,1]}},selectionWidth:[1.5,0,5,.1],selfReferenceSize:[20,0,200,1],shadow:{enabled:!1,color:"rgba(0,0,0,0.5)",size:[10,0,20,1],x:[5,-30,30,1],y:[5,-30,30,1]},smooth:{enabled:!0,type:["dynamic","continuous","discrete","diagonalCross","straightCross","horizontal","vertical","curvedCW","curvedCCW","cubicBezier"],forceDirection:["horizontal","vertical","none"],roundness:[.5,0,1,.05]},width:[1,0,30,1]},layout:{hierarchical:{enabled:!1,levelSeparation:[150,20,500,5],nodeSpacing:[100,20,500,5],treeSpacing:[200,20,500,5],blockShifting:!0,edgeMinimization:!0,parentCentralization:!0,direction:["UD","DU","LR","RL"],sortMethod:["hubsize","directed"]}},interaction:{dragNodes:!0,dragView:!0,hideEdgesOnDrag:!1,hideNodesOnDrag:!1,hover:!1,keyboard:{enabled:!1,speed:{x:[10,0,40,1],y:[10,0,40,1],zoom:[.02,0,.1,.005]},bindToWindow:!0},multiselect:!1,navigationButtons:!1,selectable:!0,selectConnectedEdges:!0,hoverConnectedEdges:!0,tooltipDelay:[300,0,1e3,25],zoomView:!0},manipulation:{enabled:!1,initiallyActive:!1},physics:{enabled:!0,barnesHut:{gravitationalConstant:[-2e3,-3e4,0,50],centralGravity:[.3,0,10,.05],springLength:[95,0,500,5],springConstant:[.04,0,1.2,.005],damping:[.09,0,1,.01],avoidOverlap:[0,0,1,.01]},forceAtlas2Based:{gravitationalConstant:[-50,-500,0,1],centralGravity:[.01,0,1,.005],springLength:[95,0,500,5],springConstant:[.08,0,1.2,.005],damping:[.4,0,1,.01],avoidOverlap:[0,0,1,.01]},repulsion:{centralGravity:[.2,0,10,.05],springLength:[200,0,500,5],springConstant:[.05,0,1.2,.005],nodeDistance:[100,0,500,5],damping:[.09,0,1,.01]},hierarchicalRepulsion:{centralGravity:[.2,0,10,.05],springLength:[100,0,500,5],springConstant:[.01,0,1.2,.005],nodeDistance:[120,0,500,5],damping:[.09,0,1,.01]},maxVelocity:[50,0,150,1],minVelocity:[.1,.01,.5,.01],solver:["barnesHut","forceAtlas2Based","repulsion","hierarchicalRepulsion"],
timestep:[.5,.01,1,.01]}};t.allOptions=h,t.configureOptions=l},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(115),s=o(n),r=i(105),a=o(r),d=i(106),h=o(d),l=i(181),u=o(l),c=function(){function e(t,i,o){(0,a.default)(this,e),this.body=t,this.springLength=i,this.springConstant=o,this.distanceSolver=new u.default}return(0,h.default)(e,[{key:"setOptions",value:function(e){e&&(e.springLength&&(this.springLength=e.springLength),e.springConstant&&(this.springConstant=e.springConstant))}},{key:"solve",value:function(e,t){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],o=this.distanceSolver.getDistances(this.body,e,t);this._createL_matrix(o),this._createK_matrix(o),this._createE_matrix();for(var n=.01,r=1,a=0,d=Math.max(1e3,Math.min(10*this.body.nodeIndices.length,6e3)),h=5,l=1e9,u=0,c=0,f=0,p=0,v=0;l>n&&a<d;){a+=1;var g=this._getHighestEnergyNode(i),y=(0,s.default)(g,4);for(u=y[0],l=y[1],c=y[2],f=y[3],p=l,v=0;p>r&&v<h;){v+=1,this._moveNode(u,c,f);var m=this._getEnergy(u),b=(0,s.default)(m,3);p=b[0],c=b[1],f=b[2]}}}},{key:"_getHighestEnergyNode",value:function(e){for(var t=this.body.nodeIndices,i=this.body.nodes,o=0,n=t[0],r=0,a=0,d=0;d<t.length;d++){var h=t[d];if(i[h].predefinedPosition===!1||i[h].isCluster===!0&&e===!0||i[h].options.fixed.x===!0||i[h].options.fixed.y===!0){var l=this._getEnergy(h),u=(0,s.default)(l,3),c=u[0],f=u[1],p=u[2];o<c&&(o=c,n=h,r=f,a=p)}}return[n,o,r,a]}},{key:"_getEnergy",value:function(e){var t=(0,s.default)(this.E_sums[e],2),i=t[0],o=t[1],n=Math.sqrt(Math.pow(i,2)+Math.pow(o,2));return[n,i,o]}},{key:"_moveNode",value:function(e,t,i){for(var o=this.body.nodeIndices,n=this.body.nodes,s=0,r=0,a=0,d=n[e].x,h=n[e].y,l=this.K_matrix[e],u=this.L_matrix[e],c=0;c<o.length;c++){var f=o[c];if(f!==e){var p=n[f].x,v=n[f].y,g=l[f],y=u[f],m=1/Math.pow(Math.pow(d-p,2)+Math.pow(h-v,2),1.5);s+=g*(1-y*Math.pow(h-v,2)*m),r+=g*(y*(d-p)*(h-v)*m),a+=g*(1-y*Math.pow(d-p,2)*m)}}var b=s,_=r,w=t,k=a,x=i,O=(w/b+x/_)/(_/b-k/_),M=-(_*O+w)/b;n[e].x+=M,n[e].y+=O,this._updateE_matrix(e)}},{key:"_createL_matrix",value:function(e){var t=this.body.nodeIndices,i=this.springLength;this.L_matrix=[];for(var o=0;o<t.length;o++){this.L_matrix[t[o]]={};for(var n=0;n<t.length;n++)this.L_matrix[t[o]][t[n]]=i*e[t[o]][t[n]]}}},{key:"_createK_matrix",value:function(e){var t=this.body.nodeIndices,i=this.springConstant;this.K_matrix=[];for(var o=0;o<t.length;o++){this.K_matrix[t[o]]={};for(var n=0;n<t.length;n++)this.K_matrix[t[o]][t[n]]=i*Math.pow(e[t[o]][t[n]],-2)}}},{key:"_createE_matrix",value:function(){var e=this.body.nodeIndices,t=this.body.nodes;this.E_matrix={},this.E_sums={};for(var i=0;i<e.length;i++)this.E_matrix[e[i]]=[];for(var o=0;o<e.length;o++){for(var n=e[o],s=t[n].x,r=t[n].y,a=0,d=0,h=o;h<e.length;h++){var l=e[h];if(l!==n){var u=t[l].x,c=t[l].y,f=1/Math.sqrt(Math.pow(s-u,2)+Math.pow(r-c,2));this.E_matrix[n][h]=[this.K_matrix[n][l]*(s-u-this.L_matrix[n][l]*(s-u)*f),this.K_matrix[n][l]*(r-c-this.L_matrix[n][l]*(r-c)*f)],this.E_matrix[l][o]=this.E_matrix[n][h],a+=this.E_matrix[n][h][0],d+=this.E_matrix[n][h][1]}}this.E_sums[n]=[a,d]}}},{key:"_updateE_matrix",value:function(e){for(var t=this.body.nodeIndices,i=this.body.nodes,o=this.E_matrix[e],n=this.K_matrix[e],s=this.L_matrix[e],r=i[e].x,a=i[e].y,d=0,h=0,l=0;l<t.length;l++){var u=t[l];if(u!==e){var c=o[l],f=c[0],p=c[1],v=i[u].x,g=i[u].y,y=1/Math.sqrt(Math.pow(r-v,2)+Math.pow(a-g,2)),m=n[u]*(r-v-s[u]*(r-v)*y),b=n[u]*(a-g-s[u]*(a-g)*y);o[l]=[m,b],d+=m,h+=b;var _=this.E_sums[u];_[0]+=m-f,_[1]+=b-p}}this.E_sums[e]=[d,h]}}]),e}();t.default=c},function(e,t,i){function o(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var n=i(105),s=o(n),r=i(106),a=o(r),d=function(){function e(){(0,s.default)(this,e)}return(0,a.default)(e,[{key:"getDistances",value:function(e,t,i){for(var o={},n=e.edges,s=0;s<t.length;s++){var r=t[s],a={};o[r]=a;for(var d=0;d<t.length;d++)a[t[d]]=s==d?0:1e9}for(var h=0;h<i.length;h++){var l=n[i[h]];l.connected===!0&&void 0!==o[l.fromId]&&void 0!==o[l.toId]&&(o[l.fromId][l.toId]=1,o[l.toId][l.fromId]=1)}for(var u=t.length,c=0;c<u;c++)for(var f=t[c],p=o[f],v=0;v<u-1;v++)for(var g=t[v],y=o[g],m=v+1;m<u;m++){var b=t[m],_=o[b],w=Math.min(y[b],y[f]+p[b]);y[b]=w,_[g]=w}return o}}]),e}();t.default=d}])});