---
title: Collective digest — 2021
date: 2021-12-28T04:59:01Z
author: "[J. Ryan Stinnett](https://convolv.es)"
authorAvatar: jryans
tags:
  - Digest
categories:
featured_image:
description:
summary:
  "2021 is drawing to close... I think many of us were hoping it would be a
  better year than 2020, but sadly it did not play out that way as the
  pandemic continues to rage. As with last year, let's jump into this 2021
  digest of collective activity and try to forget the general madness of the
  world for at least a few moments."
---

2021 is drawing to close... I think many of us were hoping it would be a better
year than 2020, but sadly it did not play out that way as the pandemic continues
to rage. As with last year, let's jump into this 2021 digest of collective
activity and try to forget the general madness of the world for at least a few
moments.

## Catalog

In 2021, we added 6 more works to our [catalog][catalog], bringing the total to
25 items. There are 42 further suggestions [waiting for
curation][curation-queue]. The queue does seem to be growing faster than the
actual catalog, so perhaps some workflow improvements could make catalog
curation as easy as opening an issue.

The new additions to the catalog include:

* [Convivial Design Heuristics for Software Systems][convivialdesign] (Stephen
  Kell)
* [A World Without Apps][worldwithoutapps] (Michel Beaudouin-Lafon)
* [The future of software, the end of apps, and why UX designers should care
  about type theory][softwareappstypetheory] (Paul Chiusano)
* [An app can be a home-cooked meal][homecookedmeal] (Robin Sloan)
* [Armories for tool-maker/tool-user collaborations][armories] (Andy Matuschak)

## Contributors

This year, quite a few people have contributed their time and effort to help out
with various tasks around the community, and we needed a good way to recognise
their efforts. A [contributors section][contributors] has been added to the home
page which attempts to highlight various different kinds of contribution in our
community.

Thanks to everyone involved for their contributions! 🎉

## Matrix

Our [Matrix room][matrix] has continued to be the most active communication
medium used by the community.

Here's a "sampling" (actually quite a long list 😅) of interesting conversation
topics from our room in 2021:

* [Computational notebooks, software preservation](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$IW1pPEw-6qtZnSPTgMsXQYhkPaNZJCNG2PT-1wRy0-E)
* [Web platform, documents vs. applications](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$Zk9yMPdDHbLyPEMSu0WBDPh_zZXVI__l33lNHr9R30M)
* [Common Lisp, its object system (CLOS)](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$_Fl7lxD57fLcQwseKrLyfY_F1ZChGMAIB-NPFdpIXoQ)
* [Comparing Smalltalk and Lisp](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$Jnw_REjFpCuwlN5KOA-a75LFMFCIGHWIQoaMAsnoUzE)
* [App UI expressed as a DOM-like element tree](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$5qAOPiD42SDAlWhiyOIpS8sUnvBn3beYk13DO8N1Qxg)
* [Distributed systems](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$8PJvy54h5OfoeceRY5HsCB7HjZlZwHLUKG8bde-D3vg)
* [Home automation](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$RI1eqqCvERaQR2gG4XznGFc2X3Xpv8T2xJ98n6E5tUM)
* [Data layer for collaboration](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$bvt7WF4s9-nqAGbCTk6Unzn85KDIv8L5cbbw7d3bNuQ)
* [Big tech languages, small projects](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$yAD80jlMMf1cvRMHwX920tkW9H9rltQxjvHZVkF6lzs)
* [Memory management, garbage collection](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$zaEUxP-Hn-5TfY6QrGu-foRFr2vsHbRzCdq0VcighkQ)
* [Software components, integration domain](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$ELd1z_wD_7QFt9pa-4dJxf6sE1_e4waLAbARN-ql6OY)
* [Storing programs as databases / ASTs](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$mO_t0eRkPGbu-jHeqw4dT0gAk31IKNrEO7qRUTe_adA)
* [Plan 9, plumbing, filesystems, windows](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$2x6beM56-0pCOd0BOjvHI85B3LznIlJsts0mW626Zl0)
* [Dynamic languages, compilation approaches](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$PULYt40FmmQ5pbkaFEcpKI3rDmqDCJIv9RzZxtvTzBE)
* [Communicating advantages of malleable systems](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$Q220QXB-XRKcvjpLBOlyRONN-XMtrxoVVE21DpWBdQc)
* [Software fragility](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$dBizTCzeTSkeL5REYe1cLBGsMv6Il3pLtJsV-4_QZVM)
* [Allowing extensions while protecting the host program](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$8zhO4bdNdSMzma4ZL1wXDY2lZw6i-sd6rMijjGzeNyo)
* [Linking to text fragments](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$2ibLK626uHtf3RGZNFsrjzkCx6uTG03qvoudsWD6h5g)
* [Data flow programming environments](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$F-uKDR1nw4u3bH_R9n23GmGQcTe4Us35v9jE5OwGXeQ)
* [Understandable and modifiable, Kartik Agaram's Mu](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$FMqpg0kfH_wS0Ahh4u9FdjXdwdVYdfw6ZexUFtKQ51M)
* [Different languages have different goals](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$ISYedMf2jSVa6U2GkRKJf_QTjcggxsx1vilcGG1jimU)
* [User control instead of backwards compatibility](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$rzO0XxZViKNnRdMZ2EqSd-DE3xCNX-lmGfqljg9X4-s)
* [Allen Wirfs-Brock's Personal Digital Habitat, distributing computation across
  devices](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$w9HVzLEi-upmPD9Oyf2UGkuK7mPYLGSdck0-QvEO-gE)
* [Current type systems are not enough for computational science](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$4BD_YBaCx-ag61hNVKI4DQbDA2ifNSRptrOrm_0KRFo)
* [Magrathea](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$UOiRShjQNFGsofhIFmElf21rQ5zAsvToh9mvgSEVSBk)
* [Constraints of Common Lisp, Smalltalk](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$PKDLt3oNztgd-5MvI-BrLdLR1ONoIMxaj8-vB0Wbtp0)
* [Academic conference recommendations](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$ogV5XjgHx6TD9yrTaIjn47ncPY0AszuxmYHI2zwsQ6k)
* [Visual programming, structural editing](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$PcRj039b7cZAQaFt0PwbZmJpf846LVnRpD4YaUb0vac)
* [Clojure, optional typing](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$Vj69FHYfDyU44pBab7N08Y--gsaxLj18MKrmt1qjvVw)
* [Language interoperability](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$zmEwuToiNwH_f7zkScpwtNF6qkSRU41IdHhnX0uDzQ4)
* [Preference overload in non-malleable systems](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$DdcvEA7lqT8K0Jypv7xSqor2cUqdS2BJEzUIku373gs)
* [Julia, metaprogramming, connection to Lisp](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$WOVaXq94cTprk2CIDUz2OShZ9CyDEzmqOa4fZViZhqU)
* [Emacs, Smalltalk, Glamorous Toolkit, live programming](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$ecpSfK9zdhTUOfcSJFd8rDX-3mGsxP9Z8PACyyQuDpQ)
* [Racket, Scheme, challenges of debugging](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$froZ4MdMUeYR-A1LHqwEAXhjV8OetQqnoQma2BvoTxc)
* [Guix, Nix, reproducible package management](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$SD6MaC-GCbEMZhD1C-hfIFr5KW2x30pf_e54ssap8rM)
* [Common Lisp, Julia, Factor](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$tVEXKnLM0DlamKDVyE1FXIrGgjJFkPFEa2lT8eox7Rw)
* [Producer-consumer distinction, free software vs. open source](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$bsvG7wuwKgh5S09iUzHMDgel8sYxjdQVpG9ZssvNfn8)
* [Alexander Obenauer's lab notes](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$QxTM7ct_rWhvfTTYoyrheINCL_WFDeaw-KC2WLxqp7I)
* [Tax software, formal languages](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$R2Nnfz80DYsTU8rqhT2TlYvFN4FcQVRmvIZxuxMaPxg)
* [Web platform increasingly hostile to malleability, Tomas Petricek's Pop-up
  from
  Hell](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$rZ-Qh-fiN-hj5BGJOxiL6aGC4XIwwj0ocozJ7q-RiK0)
* [HyperCard](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$iIbUnkP4II9AeUIt1Lqa3qCY4srpUbpqR-iMpR-Wlfg)
* [Reviving view source, packaging apps with tools to edit them](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$761K33vmtdlgQeYFj063d3w73bIwf879i_3pC-95cKc)
* [Bank Python, alternate universes](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$lSSH7sXwi8haASEEioPDz3yllc5LDmc5dYEuZYWQINQ)
* [Companies incentivised against malleability](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$Eo5xaQHKnzCuDBbUoWlZcP0ZfMKGqB4FG7iOrg7wgTI)
* [Kartik Agaram's Teliva, Luapower](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$3IEP_PaTqfIAXyClGSq41HARR8kNaia86zvC_df4Kto)
* [Arcan, future desktop computing](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$67GDuWSln6rcp6nohSNUgjZ2fN5jWLyqwdqbQyWnppo)
* [Tomas Petricek's Pop-up
  from
  Hell, web platform as substrate for more
  languages](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$xGoAn4poNEJxp4HtJIeIrZ7sIsPFeDNPz6y-xua78ZU)
* [Better developer tools for web languages](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$Tss6OYx8sBGSnjVpQERSnwNPPga5DBRDhmGbomk2irU)
* [Kartik Agaram's Teliva, sandboxing](https://matrix.to/#/!bQveTkYXFyxLJQwcLG:matrix.org/$_VCA3YQsjhENdzcXuDlwzbpUesEiXAL7ERqvo4lsT4g)

There was some interest in potentially adding a long form communication medium
(such as a Discourse forum). If you have any thoughts on this, feel free to
comment / react on the
[issue](https://github.com/malleable-systems/malleable.systems/issues/66)
tracking this suggestion.

## Related podcasts

A recurring topic throughout the year was all the various podcasts which overlap
in one way or another with our goals. If you enjoy podcasts, please do check
them out.

* [Metamuse](https://museapp.com/podcast/)
* [Hest](https://ivanish.ca/hest-podcast/)
* [Future of Coding](https://futureofcoding.org/episodes/)
* [FOSS and Crafts](https://fossandcrafts.org)

## Looking ahead

As we all tumble into another uncertain year, we hope that despite the general
chaos of life lately, there will still be room for malleable experiments that
push the boundaries of what's possible and open new doors.

Stay safe out there, and as always, please do [contact us][feedback] if there's
something you'd like to share with the collective.

[catalog]: {{< relref "/catalog/_index.md" >}}
[feedback]: mailto:hello@malleable.systems
[matrix]: https://matrix.to/#/#malleable-systems:matrix.org
[curation-queue]: https://github.com/malleable-systems/malleable.systems/issues?q=is%3Aissue+is%3Aopen+label%3Acatalog
[contributors]: {{< relref "/_index.md#contributors" >}}

[convivialdesign]: {{< relref "/catalog/_index.md#convivialdesign" >}}
[worldwithoutapps]: {{< relref "/catalog/_index.md#worldwithoutapps" >}}
[softwareappstypetheory]: {{< relref "/catalog/_index.md#softwareappstypetheory" >}}
[homecookedmeal]: {{< relref "/catalog/_index.md#homecookedmeal" >}}
[armories]: {{< relref "/catalog/_index.md#armories" >}}
