---
recent_copy: Recent Posts
all_copy: See all posts
---

> The user wants open software, software that can be modified, and that can
> participate in a progressive improvement process.
> <p><cite>— J.C.R. Licklider, <a href="https://youtu.be/SN--t9jXQc0?t=2100">Some Reflections on Early History</a> (1986)</cite></p>

Modern computing is far too rigid. Applications can only function in preset ways
determined by some far away team. Software is trapped in hermetically sealed
silos and is rewritten many times over rather than recomposed.

This community [catalogs][catalog] and experiments with **malleable software and
systems** that reset the balance of power via several essential principles:

1. Software must be as [**easy to change**][mission-1] as it is to use it
2. All layers, from the user interface through functionality to the data within,
   must support [**arbitrary recombination and reuse**][mission-2] in new
   environments
3. Tools should strive to be easy to begin working with but still have lots of
   [**open-ended potential**][mission-3]
4. People of all experience levels must be able to [**retain ownership and
   control**][mission-4]
5. Recombined workflows and experiences must be [**freely sharable**][mission-5]
   with others
6. Modifying a system should happen [**in the context of use**][mission-6],
   rather than through some separate development toolchain and skill set
7. Computing should be a [**thoughtfully crafted**][mission-7], fun, and
   empowering experience

Most contemporary applications fail to meet all of these, leaving us with no
pathway towards improvement. The only option is to plead with the app developer
and hope they will deign to grant your request. As the importance of computing
in everyday life grows with each passing year, we must fight for these values to
ensure the power of computing is evenly distributed.

We hope you agree this is a revolution worth fighting for. We welcome your
[feedback][feedback] and [contributions][contribute] of related projects and
experiments from yourself and others. You can follow the community on
[Mastodon][mastodon], [Twitter][twitter], our [forum][forum], [Matrix][matrix],
and our [blog][blog]. The blog content is also available via our
[newsletter][newsletter]. The [forum][forum] and [Matrix room][matrix] currently
have the most activity, so we encourage you to give them a try.

[catalog]: {{< relref "/catalog/_index.md" >}}
[contribute]: https://github.com/malleable-systems/malleable.systems/blob/main/CONTRIBUTING.md
[feedback]: mailto:hello@malleable.systems
[mastodon]: https://hachyderm.io/@malleablesys
[twitter]: https://twitter.com/malleablesys
[forum]: https://forum.malleable.systems
[matrix]: https://matrix.to/#/#malleable-systems:matrix.org
[blog]: {{< relref "/blog/_index.md" >}}
[newsletter]: https://buttondown.email/malleable-systems

[mission-1]: {{< relref "/pages/mission.md#1-easy-to-change" >}}
[mission-2]: {{< relref "/pages/mission.md#2-arbitrary-recombination-and-reuse" >}}
[mission-3]: {{< relref "/pages/mission.md#3-open-ended-potential" >}}
[mission-4]: {{< relref "/pages/mission.md#4-retain-ownership-and-control" >}}
[mission-5]: {{< relref "/pages/mission.md#5-freely-sharable" >}}
[mission-6]: {{< relref "/pages/mission.md#6-modifying-in-the-context-of-use" >}}
[mission-7]: {{< relref "/pages/mission.md#7-thoughtfully-crafted" >}}
