## Contribution guide

We hope the collective's [mission][mission] has inspired you to follow the
community's work, post your thoughts, and share your experiments. There are many
ways to get involved and contribute to this movement.

### Blog

We'd like to host several kinds of posts from different voices in the community.
If you'd like to write something, please [open an issue][issue] or [get in touch][mail].

Some of the types of content we have in mind include:

* Summaries of papers and projects in the community
* Reports of experiments in progress
* Essays on what malleable software should be and how we can get there

### Catalog

Along with the blog, we've also started a [catalog][catalog] of projects,
people, discussions, and other efforts in this field. We hope it can grow to
become a comprehensive list of resources for the community.

If you know of people, projects, threads, or anything else that should be added
to [the catalog][catalog], please feel free to [edit the wiki][catalog-wiki]. If
you're not sure what should be added, but you'd like to help with the curation
effort, there's a [queue of items waiting to be added][catalog-issues], and we'd
be happy to have your help curating them. If curation sounds like too much work,
please at least [open an issue][issue] so it can eventually be added when
someone has time to do so.

The [about page][catalog-wiki-about] for the catalog wiki describes the
forum-focused process in a bit more detail, and hopefully it given enough
guidance to start making a contribution. Once you have edited the forum-based
wiki, a site admin will merge the wiki changes into this repo.

### Contributors

At the collective, we believe it's important to recognise all forms of
contribution, so we're doing our best to record everyone involved in the process
so we can [feature][contributors] them on the site. If you have made some kind
of contribution, feel free to add yourself to the [contributors
list][contributors-data]. A site admin may also do this for you.

### Preview

If you would like to preview any changes made to the site, you should be able to
do so locally:

1. Install [Hugo][hugo]
2. Clone this repo
3. Fetch submodules as well: `git submodule update --init`
3. Run `hugo server` at root level of the repo

Our CI system will also deploy a preview site once you open your PR,
so it's easy for everyone to check over your contribution.

If you made it this far, thanks so much for your help! 😄

### Feedback

At the end of the day, we want this to be a space for anyone working to advance
the goals of malleable software. If you have thoughts or feedback on how best to
achieve that, please [open an issue][issue] or [send us a note][mail].

[mission]: https://malleable.systems/mission/
[catalog]: https://malleable.systems/catalog/
[issue]: https://github.com/malleable-systems/malleable.systems/issues/new
[mail]: mailto:hello@malleable.systems
[catalog-wiki]: https://forum.malleable.systems/c/catalog/7
[catalog-wiki-about]: https://forum.malleable.systems/t/about-the-catalog-category/14
[catalog-issues]: https://github.com/malleable-systems/malleable.systems/issues?q=is%3Aissue+is%3Aopen+label%3Acatalog
[contributors]: https://malleable.systems/#contributors
[contributors-data]: data/contributors.yaml
[avatars]: static/avatars/
[hugo]: https://gohugo.io/
