package mage.game.permanent.token;

import mage.MageInt;
import mage.constants.CardType;
import mage.constants.SubType;

/**
 * @author Quercitron
 */
public final class CitizenToken extends TokenImpl {

    public CitizenToken() {
        super("Citizen Token", "1/1 white Citizen creature token");
        cardType.add(CardType.CREATURE);
        color.setWhite(true);

        subtype.add(SubType.CITIZEN);
        power = new MageInt(1);
        toughness = new MageInt(1);
    }

    private CitizenToken(final CitizenToken token) {
        super(token);
    }

    public CitizenToken copy() {
        return new CitizenToken(this);
    }
}
