package mage.abilities.mana.conditional;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.VariableManaCost;
import mage.game.Game;

import java.util.UUID;

/**
 * @author TheElk801
 */
public class XCostManaCondition extends ManaCondition {

    /*
    A “cost that contains {X}” may be a spell’s total cost, an activated ability’s cost, a suspend cost, or a cost you’re
    asked to pay as part of the resolution of a spell or ability (such as Condescend). A spell’s total cost includes either
    its mana cost (printed in the upper right corner) or its alternative cost (such as flashback), as well as any additional
    costs (such as kicker). If it’s something you can spend mana on, it’s a cost. If that cost includes the {X} symbol in it,
    you can spend mana generated by Rosheen on that cost. (2017-11-17)
     */
    @Override
    public boolean apply(Game game, Ability source, UUID originalId, Cost costToPay) {
        boolean result;
        if (costToPay instanceof ManaCosts) {
            result = !((ManaCosts<?>) costToPay).getVariableCosts().isEmpty();
        } else {
            result = costToPay instanceof VariableManaCost;
        }
        if (!result && game != null && game.inCheckPlayableState()) {
            return true; // TODO: Check the card if there are related abilities with {X} costs.
        }
        return result;
    }
}
