package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

/**
 * @author North
 */
public class DrawCardControllerTriggeredAbility extends TriggeredAbilityImpl {

    public DrawCardControllerTriggeredAbility(Effect effect, boolean optional) {
        this(Zone.BATTLEFIELD, effect, optional);
    }

    public DrawCardControllerTriggeredAbility(Zone zone, Effect effect, boolean optional) {
        super(zone, effect, optional);
        setTriggerPhrase(getWhen() + "you draw a card, ");
    }

    protected DrawCardControllerTriggeredAbility(final DrawCardControllerTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getPlayerId().equals(controllerId);
    }

    @Override
    public DrawCardControllerTriggeredAbility copy() {
        return new DrawCardControllerTriggeredAbility(this);
    }
}
