package org.mage.test.cards.mana;

import mage.constants.PhaseStep;
import mage.constants.Zone;
import org.junit.Test;
import org.mage.test.serverside.base.CardTestPlayerBase;

/**
 * @author JayDi85
 */
public class RosheenMeandererManaXTest extends CardTestPlayerBase {

    // https://github.com/magefree/mage/issues/3538

    // Rosheen Meanderer {3}{R/G}
    // {T}: Add {C}{C}{C}{C}. Spend this mana only on costs that contain {X}.

    // Verdeloth the Ancient {4}{G}{G}
    // Kicker {X} (You may pay an additional {X} as you cast this spell.)
    // Saproling creatures and other Treefolk creatures get +1/+1.
    // When Verdeloth the Ancient enters the battlefield, if it was kicked, create X 1/1 green Saproling creature tokens.

    @Test
    public void test_SimpleKicker() {
        addCard(Zone.BATTLEFIELD, playerA, "Forest", 6 + 2);
        addCard(Zone.HAND, playerA, "Verdeloth the Ancient");

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Verdeloth the Ancient");
        setChoice(playerA, true); // use kicker
        setChoice(playerA, "X=2");

        checkPermanentCount("after", 1, PhaseStep.END_TURN, playerA, "Verdeloth the Ancient", 1);
        checkPermanentCount("after", 1, PhaseStep.END_TURN, playerA, "Saproling Token", 2);

        setStopAt(1, PhaseStep.END_TURN);
        setStrictChooseMode(true);
        execute();
    }

    @Test
    public void test_KickerWithXMana() {
        addCard(Zone.BATTLEFIELD, playerA, "Forest", 6);
        addCard(Zone.HAND, playerA, "Verdeloth the Ancient");
        //
        addCard(Zone.BATTLEFIELD, playerA, "Rosheen Meanderer");

        // make 4 mana for X pay
        activateAbility(1, PhaseStep.PRECOMBAT_MAIN, playerA, "{T}: Add {C}");
        checkManaPool("mana", 1, PhaseStep.PRECOMBAT_MAIN, playerA, "C", 4);

        // cast kicker X and use extra 4 mana
        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Verdeloth the Ancient");
        setChoice(playerA, true); // use kicker
        setChoice(playerA, "X=2");

        checkPermanentCount("after", 1, PhaseStep.END_TURN, playerA, "Verdeloth the Ancient", 1);
        checkPermanentCount("after", 1, PhaseStep.END_TURN, playerA, "Saproling Token", 2);

        setStopAt(1, PhaseStep.END_TURN);
        setStrictChooseMode(true);
        execute();
    }

    @Test
    public void test_KickerWithXZero() {

        // You can spend mana generated by Rosheen on a cost that includes {X} even if you’ve chosen an X of 0,
        // or if the card specifies that you can spend only colored mana on X. (You’ll have to spend Rosheen’s mana on
        // a different part of that cost, of course.) (2017-11-17)

        addCard(Zone.BATTLEFIELD, playerA, "Forest", 6 - 4);
        addCard(Zone.HAND, playerA, "Verdeloth the Ancient");
        //
        addCard(Zone.BATTLEFIELD, playerA, "Rosheen Meanderer");

        // make 4 mana for X pay
        activateAbility(1, PhaseStep.PRECOMBAT_MAIN, playerA, "{T}: Add {C}");
        checkManaPool("mana", 1, PhaseStep.PRECOMBAT_MAIN, playerA, "C", 4);

        // cast kicker X and use extra 4 mana
        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Verdeloth the Ancient");
        setChoice(playerA, true); // use kicker
        setChoice(playerA, "X=0");

        checkPermanentCount("after", 1, PhaseStep.END_TURN, playerA, "Verdeloth the Ancient", 1);
        checkPermanentCount("after", 1, PhaseStep.END_TURN, playerA, "Saproling Token", 0);

        setStopAt(1, PhaseStep.END_TURN);
        setStrictChooseMode(true);
        execute();
    }

    // https://github.com/magefree/mage/issues/5206

    // Flameblast Dragon {4}{R}{R}
    // 5/5
    // Flying
    // Whenever Flameblast Dragon attacks, you may pay {X}{R}. If you do, Flameblast Dragon deals X damage to any target.

    @Test
    public void test_SimpleDragon() {
        addCard(Zone.BATTLEFIELD, playerA, "Mountain", 4);
        addCard(Zone.BATTLEFIELD, playerA, "Flameblast Dragon");

        // attack (-5)
        attack(1, playerA, "Flameblast Dragon", playerB);

        // with extra damage (-3)
        setChoice(playerA, true);
        setChoice(playerA, "X=3");
        addTarget(playerA, playerB);

        checkLife("after", 1, PhaseStep.POSTCOMBAT_MAIN, playerB, 20 - 5 - 3);

        setStopAt(1, PhaseStep.END_TURN);
        setStrictChooseMode(true);
        execute();
    }

    @Test
    public void test_PayXForDragonAbility() {
        addCard(Zone.BATTLEFIELD, playerA, "Flameblast Dragon");
        addCard(Zone.BATTLEFIELD, playerA, "Rosheen Meanderer");
        addCard(Zone.BATTLEFIELD, playerA, "Mountain", 1);

        // make 4 mana for X pay
        activateAbility(1, PhaseStep.DECLARE_ATTACKERS, playerA, "{T}: Add {C}");
        checkManaPool("mana", 1, PhaseStep.DECLARE_ATTACKERS, playerA, "C", 4);

        // attack (-5)
        attack(1, playerA, "Flameblast Dragon", playerB);

        // with extra damage (-3)
        setChoice(playerA, true);
        setChoice(playerA, "X=3"); // need to pay {3}{R}
        addTarget(playerA, playerB);

        checkLife("after", 1, PhaseStep.POSTCOMBAT_MAIN, playerB, 20 - 5 - 3);

        setStopAt(1, PhaseStep.END_TURN);
        setStrictChooseMode(true);
        execute();
    }

    // Condescend {X}{U}
    // Counter target spell unless its controller pays {X}. Scry 2.

    @Test
    public void test_PayXForCondescendPrevent() {
        addCard(Zone.HAND, playerB, "Condescend");
        addCard(Zone.BATTLEFIELD, playerB, "Island", 3);
        //
        addCard(Zone.BATTLEFIELD, playerA, "Rosheen Meanderer");
        //
        addCard(Zone.HAND, playerA, "Lightning Bolt");
        addCard(Zone.BATTLEFIELD, playerA, "Mountain", 1);

        // init the top of library for the scry 2
        skipInitShuffling();
        addCard(Zone.LIBRARY, playerB, "Grizzly Bears");
        addCard(Zone.LIBRARY, playerB, "Abandon Hope");

        // cast bolt
        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Lightning Bolt", playerB);
        // counter with condescend
        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerB, "Condescend");
        setChoice(playerB, "X=2");
        addTarget(playerB, "Lightning Bolt");
        // make 4 mana for X pay
        activateAbility(1, PhaseStep.PRECOMBAT_MAIN, playerA, "{T}: Add {C}");
        checkManaPool("mana", 1, PhaseStep.PRECOMBAT_MAIN, playerA, "C", 4);
        // pay to prevent
        setChoice(playerA, true); // pay 2 to prevent counter
        addTarget(playerB, "Abandon Hope"); // scry 2: choosing to bottom Abandon Hope.

        checkLife("after", 1, PhaseStep.POSTCOMBAT_MAIN, playerB, 20 - 3);
        checkHandCardCount("after", 1, PhaseStep.POSTCOMBAT_MAIN, playerA, "Lightning Bolt", 0);
        checkHandCardCount("after", 1, PhaseStep.POSTCOMBAT_MAIN, playerB, "Condescend", 0);

        setStopAt(1, PhaseStep.END_TURN);
        setStrictChooseMode(true);
        execute();
    }
}
