
package org.mage.test.cards.abilities.keywords;

import mage.constants.PhaseStep;
import mage.constants.Zone;
import org.junit.Test;
import org.mage.test.serverside.base.CardTestPlayerBase;

/**
 * 702.109. Exploit
 *
 * 702.109a Exploit is a triggered ability. “Exploit” means “When this creature enters the battlefield, you may sacrifice a creature.”
 *
 * 702.109b A creature with exploit “exploits a creature” when the controller of the exploit ability sacrifices a creature as that ability resolves.
 *
 * You choose whether to sacrifice a creature and which creature to sacrifice as the exploit ability resolves.
 * You can sacrifice the creature with exploit if it's still on the battlefield. This will cause its other ability to trigger.
 * You can't sacrifice more than one creature to any one exploit ability.
 *
 * @author LevelX2
 */
public class ExploitTest extends CardTestPlayerBase {

    @Test
    public void testNormalUse() {
        addCard(Zone.BATTLEFIELD, playerA, "Swamp", 5);
        // Exploit (When this creature enters the battlefield, you may sacrifice a creature.)
        // When Silumgar Butcher exploits a creature, target creature gets -3/-3 until end of turn.
        addCard(Zone.HAND, playerA, "Silumgar Butcher");
        addCard(Zone.BATTLEFIELD, playerA, "Silvercoat Lion");

        addCard(Zone.BATTLEFIELD, playerB, "Thundering Giant"); // 4/3

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Silumgar Butcher");
        setChoice(playerA, true);
        setChoice(playerA, "Silvercoat Lion"); // sacrifice to Exploit
        addTarget(playerA, "Thundering Giant"); // Target for the -3/-3

        setStopAt(1, PhaseStep.BEGIN_COMBAT);
        execute();

        assertPermanentCount(playerA, "Silumgar Butcher", 1);
        assertGraveyardCount(playerA, "Silvercoat Lion", 1);
        assertGraveyardCount(playerB, "Thundering Giant", 1);
    }

    /**
     * Test that the Exploit ability won't trigger if the creature with
     * exploit left the battlefiled before the Enters the battlefield
     * triggered ability resolves.
     */
    @Test
    public void testExploitTriggerWontGo() {
        addCard(Zone.BATTLEFIELD, playerA, "Swamp", 5);
        // Exploit (When this creature enters the battlefield, you may sacrifice a creature.)
        // When Silumgar Butcher exploits a creature, target creature gets -3/-3 until end of turn.
        addCard(Zone.HAND, playerA, "Silumgar Butcher");
        addCard(Zone.BATTLEFIELD, playerA, "Silvercoat Lion");

        addCard(Zone.BATTLEFIELD, playerB, "Mountain", 1);
        addCard(Zone.HAND, playerB, "Lightning Bolt", 1);
        addCard(Zone.BATTLEFIELD, playerB, "Thundering Giant"); // 4/3

        setStrictChooseMode(true);

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Silumgar Butcher");
        waitStackResolved(1, PhaseStep.PRECOMBAT_MAIN, 1);
        setChoice(playerA, true); // Choose to exploit
        setChoice(playerA, "Silvercoat Lion"); // sacrifice to Exploit

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerB, "Lightning Bolt", "Silumgar Butcher");

        setStopAt(1, PhaseStep.BEGIN_COMBAT);
        execute();

        assertGraveyardCount(playerB, "Lightning Bolt", 1);
        assertGraveyardCount(playerA, "Silumgar Butcher", 1);
        assertGraveyardCount(playerA, "Silvercoat Lion", 1);

        assertPermanentCount(playerB, "Thundering Giant", 1);
    }

    /**
     * Test that the Exploit ability won't trigger if the creature with
     * exploit left the battlefiled before the Enters the battlefield
     * triggered ability resolves.
     */
    @Test
    public void testSacrificeCreatureWithExploit() {
        addCard(Zone.BATTLEFIELD, playerA, "Swamp", 2);
        // Exploit (When this creature enters the battlefield, you may sacrifice a creature.)
        // When Qarsi Sadist exploits a creature, target opponent loses 2 life and you gain 2 life.
        addCard(Zone.HAND, playerA, "Qarsi Sadist");

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Qarsi Sadist");
        setChoice(playerA, true);
        setChoice(playerA, "Qarsi Sadist"); // sacrifice to Exploit
        // Player B is auto-chosen to lose two life since only option

        setStopAt(1, PhaseStep.BEGIN_COMBAT);
        execute();

        assertGraveyardCount(playerA, "Qarsi Sadist", 1);

        assertLife(playerA, 22);
        assertLife(playerB, 18);
    }
}
