package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * https://scryfall.com/sets/pwar
 */
public class WarOfTheSparkPromos extends ExpansionSet {

    private static final WarOfTheSparkPromos instance = new WarOfTheSparkPromos();

    public static WarOfTheSparkPromos getInstance() {
        return instance;
    }

    private WarOfTheSparkPromos() {
        super("War of the Spark Promos", "PWAR", ExpansionSet.buildDate(2019, 5, 4), SetType.PROMOTIONAL);
        this.hasBoosters = false;
        this.hasBasicLands = false;

        cards.add(new SetCardInfo("Ajani, the Greathearted", "184p", Rarity.RARE, mage.cards.a.AjaniTheGreathearted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ajani, the Greathearted", "184s", Rarity.RARE, mage.cards.a.AjaniTheGreathearted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ajani, the Greathearted", "184s*", Rarity.RARE, mage.cards.a.AjaniTheGreathearted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angrath, Captain of Chaos", "227s", Rarity.UNCOMMON, mage.cards.a.AngrathCaptainOfChaos.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angrath, Captain of Chaos", "227s*", Rarity.UNCOMMON, mage.cards.a.AngrathCaptainOfChaos.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arlinn, Voice of the Pack", "150s", Rarity.UNCOMMON, mage.cards.a.ArlinnVoiceOfThePack.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arlinn, Voice of the Pack", "150s*", Rarity.UNCOMMON, mage.cards.a.ArlinnVoiceOfThePack.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashiok, Dream Render", "228s", Rarity.UNCOMMON, mage.cards.a.AshiokDreamRender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashiok, Dream Render", "228s*", Rarity.UNCOMMON, mage.cards.a.AshiokDreamRender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Augur of Bolas", 41, Rarity.UNCOMMON, mage.cards.a.AugurOfBolas.class));
        cards.add(new SetCardInfo("Awakening of Vitu-Ghazi", "152s", Rarity.RARE, mage.cards.a.AwakeningOfVituGhazi.class));
        cards.add(new SetCardInfo("Bioessence Hydra", "186s", Rarity.RARE, mage.cards.b.BioessenceHydra.class));
        cards.add(new SetCardInfo("Blast Zone", "244p", Rarity.RARE, mage.cards.b.BlastZone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blast Zone", "244s", Rarity.RARE, mage.cards.b.BlastZone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bolas's Citadel", "79p", Rarity.RARE, mage.cards.b.BolassCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bolas's Citadel", "79s", Rarity.RARE, mage.cards.b.BolassCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bolas's Citadel", 79, Rarity.RARE, mage.cards.b.BolassCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Casualties of War", "187s", Rarity.RARE, mage.cards.c.CasualtiesOfWar.class));
        cards.add(new SetCardInfo("Chandra, Fire Artisan", "119p", Rarity.RARE, mage.cards.c.ChandraFireArtisan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra, Fire Artisan", "119s", Rarity.RARE, mage.cards.c.ChandraFireArtisan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra, Fire Artisan", "119s*", Rarity.RARE, mage.cards.c.ChandraFireArtisan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command the Dreadhorde", "82s", Rarity.RARE, mage.cards.c.CommandTheDreadhorde.class));
        cards.add(new SetCardInfo("Commence the Endgame", "45p", Rarity.RARE, mage.cards.c.CommenceTheEndgame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commence the Endgame", "45s", Rarity.RARE, mage.cards.c.CommenceTheEndgame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Davriel, Rogue Shadowmage", "83s", Rarity.UNCOMMON, mage.cards.d.DavrielRogueShadowmage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Davriel, Rogue Shadowmage", "83s*", Rarity.UNCOMMON, mage.cards.d.DavrielRogueShadowmage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deliver Unto Evil", "85s", Rarity.RARE, mage.cards.d.DeliverUntoEvil.class));
        cards.add(new SetCardInfo("Domri, Anarch of Bolas", "191p", Rarity.RARE, mage.cards.d.DomriAnarchOfBolas.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Domri, Anarch of Bolas", "191s", Rarity.RARE, mage.cards.d.DomriAnarchOfBolas.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Domri, Anarch of Bolas", "191s*", Rarity.RARE, mage.cards.d.DomriAnarchOfBolas.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dovin's Veto", 193, Rarity.UNCOMMON, mage.cards.d.DovinsVeto.class));
        cards.add(new SetCardInfo("Dovin, Hand of Control", "229s", Rarity.UNCOMMON, mage.cards.d.DovinHandOfControl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dovin, Hand of Control", "229s*", Rarity.UNCOMMON, mage.cards.d.DovinHandOfControl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadhorde Arcanist", "125p", Rarity.RARE, mage.cards.d.DreadhordeArcanist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadhorde Arcanist", "125s", Rarity.RARE, mage.cards.d.DreadhordeArcanist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadhorde Butcher", "194p", Rarity.RARE, mage.cards.d.DreadhordeButcher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadhorde Butcher", "194s", Rarity.RARE, mage.cards.d.DreadhordeButcher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadhorde Invasion", "86p", Rarity.RARE, mage.cards.d.DreadhordeInvasion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadhorde Invasion", "86s", Rarity.RARE, mage.cards.d.DreadhordeInvasion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Enter the God-Eternals", "196p", Rarity.RARE, mage.cards.e.EnterTheGodEternals.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Enter the God-Eternals", "196s", Rarity.RARE, mage.cards.e.EnterTheGodEternals.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fblthp, the Lost", "50p", Rarity.RARE, mage.cards.f.FblthpTheLost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fblthp, the Lost", "50s", Rarity.RARE, mage.cards.f.FblthpTheLost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feather, the Redeemed", "197p", Rarity.RARE, mage.cards.f.FeatherTheRedeemed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feather, the Redeemed", "197s", Rarity.RARE, mage.cards.f.FeatherTheRedeemed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Finale of Devastation", "160p", Rarity.MYTHIC, mage.cards.f.FinaleOfDevastation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Finale of Devastation", "160s", Rarity.MYTHIC, mage.cards.f.FinaleOfDevastation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Finale of Eternity", "91p", Rarity.MYTHIC, mage.cards.f.FinaleOfEternity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Finale of Eternity", "91s", Rarity.MYTHIC, mage.cards.f.FinaleOfEternity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Finale of Glory", "12s", Rarity.MYTHIC, mage.cards.f.FinaleOfGlory.class));
        cards.add(new SetCardInfo("Finale of Promise", "127s", Rarity.MYTHIC, mage.cards.f.FinaleOfPromise.class));
        cards.add(new SetCardInfo("Finale of Revelation", "51p", Rarity.MYTHIC, mage.cards.f.FinaleOfRevelation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Finale of Revelation", "51s", Rarity.MYTHIC, mage.cards.f.FinaleOfRevelation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gideon Blackblade", "13p", Rarity.MYTHIC, mage.cards.g.GideonBlackblade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gideon Blackblade", "13s", Rarity.MYTHIC, mage.cards.g.GideonBlackblade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gideon Blackblade", "13s*", Rarity.MYTHIC, mage.cards.g.GideonBlackblade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("God-Eternal Bontu", "92s", Rarity.MYTHIC, mage.cards.g.GodEternalBontu.class));
        cards.add(new SetCardInfo("God-Eternal Kefnet", "53s", Rarity.MYTHIC, mage.cards.g.GodEternalKefnet.class));
        cards.add(new SetCardInfo("God-Eternal Oketra", "16s", Rarity.MYTHIC, mage.cards.g.GodEternalOketra.class));
        cards.add(new SetCardInfo("God-Eternal Rhonas", "163s", Rarity.MYTHIC, mage.cards.g.GodEternalRhonas.class));
        cards.add(new SetCardInfo("Huatli, the Sun's Heart", "230s", Rarity.UNCOMMON, mage.cards.h.HuatliTheSunsHeart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Huatli, the Sun's Heart", "230s*", Rarity.UNCOMMON, mage.cards.h.HuatliTheSunsHeart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ignite the Beacon", "18s", Rarity.RARE, mage.cards.i.IgniteTheBeacon.class));
        cards.add(new SetCardInfo("Ilharg, the Raze-Boar", "133s", Rarity.MYTHIC, mage.cards.i.IlhargTheRazeBoar.class));
        cards.add(new SetCardInfo("Jace, Wielder of Mysteries", "54p", Rarity.RARE, mage.cards.j.JaceWielderOfMysteries.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace, Wielder of Mysteries", "54s", Rarity.RARE, mage.cards.j.JaceWielderOfMysteries.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace, Wielder of Mysteries", "54s*", Rarity.RARE, mage.cards.j.JaceWielderOfMysteries.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jaya, Venerated Firemage", "135s", Rarity.UNCOMMON, mage.cards.j.JayaVeneratedFiremage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jaya, Venerated Firemage", "135s*", Rarity.UNCOMMON, mage.cards.j.JayaVeneratedFiremage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jiang Yanggu, Wildcrafter", "164s", Rarity.UNCOMMON, mage.cards.j.JiangYangguWildcrafter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jiang Yanggu, Wildcrafter", "164s*", Rarity.UNCOMMON, mage.cards.j.JiangYangguWildcrafter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn's Bastion", "248p", Rarity.RARE, mage.cards.k.KarnsBastion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn's Bastion", "248s", Rarity.RARE, mage.cards.k.KarnsBastion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn's Bastion", 248, Rarity.RARE, mage.cards.k.KarnsBastion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, the Great Creator", "1p", Rarity.RARE, mage.cards.k.KarnTheGreatCreator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, the Great Creator", "1s", Rarity.RARE, mage.cards.k.KarnTheGreatCreator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, the Great Creator", "1s*", Rarity.RARE, mage.cards.k.KarnTheGreatCreator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kasmina, Enigmatic Mentor", "56s", Rarity.UNCOMMON, mage.cards.k.KasminaEnigmaticMentor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kasmina, Enigmatic Mentor", "56s*", Rarity.UNCOMMON, mage.cards.k.KasminaEnigmaticMentor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kaya, Bane of the Dead", "231s", Rarity.UNCOMMON, mage.cards.k.KayaBaneOfTheDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kaya, Bane of the Dead", "231s*", Rarity.UNCOMMON, mage.cards.k.KayaBaneOfTheDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kiora, Behemoth Beckoner", "232s", Rarity.UNCOMMON, mage.cards.k.KioraBehemothBeckoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kiora, Behemoth Beckoner", "232s*", Rarity.UNCOMMON, mage.cards.k.KioraBehemothBeckoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krenko, Tin Street Kingpin", "137p", Rarity.RARE, mage.cards.k.KrenkoTinStreetKingpin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krenko, Tin Street Kingpin", "137s", Rarity.RARE, mage.cards.k.KrenkoTinStreetKingpin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana's Triumph", 98, Rarity.UNCOMMON, mage.cards.l.LilianasTriumph.class));
        cards.add(new SetCardInfo("Liliana, Dreadhorde General", "97p", Rarity.MYTHIC, mage.cards.l.LilianaDreadhordeGeneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana, Dreadhorde General", "97s", Rarity.MYTHIC, mage.cards.l.LilianaDreadhordeGeneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana, Dreadhorde General", "97s*", Rarity.MYTHIC, mage.cards.l.LilianaDreadhordeGeneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Living Twister", "203p", Rarity.RARE, mage.cards.l.LivingTwister.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Living Twister", "203s", Rarity.RARE, mage.cards.l.LivingTwister.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Massacre Girl", "99s", Rarity.RARE, mage.cards.m.MassacreGirl.class));
        cards.add(new SetCardInfo("Mizzium Tank", "138p", Rarity.RARE, mage.cards.m.MizziumTank.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mizzium Tank", "138s", Rarity.RARE, mage.cards.m.MizziumTank.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mobilized District", "249p", Rarity.RARE, mage.cards.m.MobilizedDistrict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mobilized District", "249s", Rarity.RARE, mage.cards.m.MobilizedDistrict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, Storm of Stone", "233s", Rarity.UNCOMMON, mage.cards.n.NahiriStormOfStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, Storm of Stone", "233s*", Rarity.UNCOMMON, mage.cards.n.NahiriStormOfStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset's Reversal", "62p", Rarity.RARE, mage.cards.n.NarsetsReversal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset's Reversal", "62s", Rarity.RARE, mage.cards.n.NarsetsReversal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset, Parter of Veils", "61s", Rarity.UNCOMMON, mage.cards.n.NarsetParterOfVeils.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset, Parter of Veils", "61s*", Rarity.UNCOMMON, mage.cards.n.NarsetParterOfVeils.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Neheb, Dreadhorde Champion", "140s", Rarity.RARE, mage.cards.n.NehebDreadhordeChampion.class));
        cards.add(new SetCardInfo("Nicol Bolas, Dragon-God", "207p", Rarity.MYTHIC, mage.cards.n.NicolBolasDragonGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nicol Bolas, Dragon-God", "207s", Rarity.MYTHIC, mage.cards.n.NicolBolasDragonGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nicol Bolas, Dragon-God", "207s*", Rarity.MYTHIC, mage.cards.n.NicolBolasDragonGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nissa, Who Shakes the World", "169p", Rarity.RARE, mage.cards.n.NissaWhoShakesTheWorld.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nissa, Who Shakes the World", "169s", Rarity.RARE, mage.cards.n.NissaWhoShakesTheWorld.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nissa, Who Shakes the World", "169s*", Rarity.RARE, mage.cards.n.NissaWhoShakesTheWorld.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet Reborn", "208s", Rarity.MYTHIC, mage.cards.n.NivMizzetReborn.class));
        cards.add(new SetCardInfo("Oath of Kaya", "209p", Rarity.RARE, mage.cards.o.OathOfKaya.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oath of Kaya", "209s", Rarity.RARE, mage.cards.o.OathOfKaya.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, the Hate-Twisted", "100s", Rarity.UNCOMMON, mage.cards.o.ObNixilisTheHateTwisted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, the Hate-Twisted", "100s*", Rarity.UNCOMMON, mage.cards.o.ObNixilisTheHateTwisted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Paradise Druid", 171, Rarity.UNCOMMON, mage.cards.p.ParadiseDruid.class));
        cards.add(new SetCardInfo("Parhelion II", "24s", Rarity.RARE, mage.cards.p.ParhelionII.class));
        cards.add(new SetCardInfo("Planewide Celebration", "172s", Rarity.RARE, mage.cards.p.PlanewideCelebration.class));
        cards.add(new SetCardInfo("Ral, Storm Conduit", "211p", Rarity.RARE, mage.cards.r.RalStormConduit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ral, Storm Conduit", "211s", Rarity.RARE, mage.cards.r.RalStormConduit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ral, Storm Conduit", "211s*", Rarity.RARE, mage.cards.r.RalStormConduit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ravnica at War", "28s", Rarity.RARE, mage.cards.r.RavnicaAtWar.class));
        cards.add(new SetCardInfo("Roalesk, Apex Hybrid", "213s", Rarity.MYTHIC, mage.cards.r.RoaleskApexHybrid.class));
        cards.add(new SetCardInfo("Role Reversal", "214s", Rarity.RARE, mage.cards.r.RoleReversal.class));
        cards.add(new SetCardInfo("Saheeli, Sublime Artificer", "234s", Rarity.UNCOMMON, mage.cards.s.SaheeliSublimeArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saheeli, Sublime Artificer", "234s*", Rarity.UNCOMMON, mage.cards.s.SaheeliSublimeArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samut, Tyrant Smasher", "235s", Rarity.UNCOMMON, mage.cards.s.SamutTyrantSmasher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samut, Tyrant Smasher", "235s*", Rarity.UNCOMMON, mage.cards.s.SamutTyrantSmasher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sarkhan the Masterless", "143s", Rarity.RARE, mage.cards.s.SarkhanTheMasterless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sarkhan the Masterless", "143s*", Rarity.RARE, mage.cards.s.SarkhanTheMasterless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Silent Submersible", "66s", Rarity.RARE, mage.cards.s.SilentSubmersible.class));
        cards.add(new SetCardInfo("Single Combat", "30s", Rarity.RARE, mage.cards.s.SingleCombat.class));
        cards.add(new SetCardInfo("Solar Blaze", "216p", Rarity.RARE, mage.cards.s.SolarBlaze.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Solar Blaze", "216s", Rarity.RARE, mage.cards.s.SolarBlaze.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sorin, Vengeful Bloodlord", "217p", Rarity.RARE, mage.cards.s.SorinVengefulBloodlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sorin, Vengeful Bloodlord", "217s", Rarity.RARE, mage.cards.s.SorinVengefulBloodlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sorin, Vengeful Bloodlord", "217s*", Rarity.RARE, mage.cards.s.SorinVengefulBloodlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul Diviner", "218p", Rarity.RARE, mage.cards.s.SoulDiviner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul Diviner", "218s", Rarity.RARE, mage.cards.s.SoulDiviner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Double", "68p", Rarity.RARE, mage.cards.s.SparkDouble.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Double", "68s", Rarity.RARE, mage.cards.s.SparkDouble.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Storrev, Devkarin Lich", "219p", Rarity.RARE, mage.cards.s.StorrevDevkarinLich.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Storrev, Devkarin Lich", "219s", Rarity.RARE, mage.cards.s.StorrevDevkarinLich.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tamiyo, Collector of Tales", "220p", Rarity.RARE, mage.cards.t.TamiyoCollectorOfTales.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tamiyo, Collector of Tales", "220s", Rarity.RARE, mage.cards.t.TamiyoCollectorOfTales.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tamiyo, Collector of Tales", "220s*", Rarity.RARE, mage.cards.t.TamiyoCollectorOfTales.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi, Time Raveler", "221p", Rarity.RARE, mage.cards.t.TeferiTimeRaveler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi, Time Raveler", "221s", Rarity.RARE, mage.cards.t.TeferiTimeRaveler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi, Time Raveler", "221s*", Rarity.RARE, mage.cards.t.TeferiTimeRaveler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teyo, the Shieldmage", "32s", Rarity.UNCOMMON, mage.cards.t.TeyoTheShieldmage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teyo, the Shieldmage", "32s*", Rarity.UNCOMMON, mage.cards.t.TeyoTheShieldmage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Elderspell", "89p", Rarity.RARE, mage.cards.t.TheElderspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Elderspell", "89s", Rarity.RARE, mage.cards.t.TheElderspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Wanderer", "37s", Rarity.UNCOMMON, mage.cards.t.TheWanderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Wanderer", "37s*", Rarity.UNCOMMON, mage.cards.t.TheWanderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tibalt, Rakish Instigator", "146s", Rarity.UNCOMMON, mage.cards.t.TibaltRakishInstigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tibalt, Rakish Instigator", "146s*", Rarity.UNCOMMON, mage.cards.t.TibaltRakishInstigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Wipe", "223p", Rarity.RARE, mage.cards.t.TimeWipe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Wipe", "223s", Rarity.RARE, mage.cards.t.TimeWipe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Wipe", 223, Rarity.RARE, mage.cards.t.TimeWipe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tolsimir, Friend to Wolves", "224p", Rarity.RARE, mage.cards.t.TolsimirFriendToWolves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tolsimir, Friend to Wolves", "224s", Rarity.RARE, mage.cards.t.TolsimirFriendToWolves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tomik, Distinguished Advokist", "34p", Rarity.RARE, mage.cards.t.TomikDistinguishedAdvokist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tomik, Distinguished Advokist", "34s", Rarity.RARE, mage.cards.t.TomikDistinguishedAdvokist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ugin, the Ineffable", "2p", Rarity.RARE, mage.cards.u.UginTheIneffable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ugin, the Ineffable", "2s", Rarity.RARE, mage.cards.u.UginTheIneffable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ugin, the Ineffable", "2s*", Rarity.RARE, mage.cards.u.UginTheIneffable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vivien's Arkbow", "181s", Rarity.RARE, mage.cards.v.ViviensArkbow.class));
        cards.add(new SetCardInfo("Vivien, Champion of the Wilds", "180p", Rarity.RARE, mage.cards.v.VivienChampionOfTheWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vivien, Champion of the Wilds", "180s", Rarity.RARE, mage.cards.v.VivienChampionOfTheWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vivien, Champion of the Wilds", "180s*", Rarity.RARE, mage.cards.v.VivienChampionOfTheWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vraska, Swarm's Eminence", "236s", Rarity.UNCOMMON, mage.cards.v.VraskaSwarmsEminence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vraska, Swarm's Eminence", "236s*", Rarity.UNCOMMON, mage.cards.v.VraskaSwarmsEminence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Widespread Brutality", "226p", Rarity.RARE, mage.cards.w.WidespreadBrutality.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Widespread Brutality", "226s", Rarity.RARE, mage.cards.w.WidespreadBrutality.class, NON_FULL_USE_VARIOUS));
    }
}
