package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * https://mtg.gamepedia.com/Treasure_Chests
 * https://scryfall.com/sets/pz2
 */
public class TreasureChest extends ExpansionSet {

    private static final TreasureChest instance = new TreasureChest();

    public static TreasureChest getInstance() {
        return instance;
    }

    private TreasureChest() {
        super("Treasure Chest", "PZ2", ExpansionSet.buildDate(2018, 12, 6), SetType.MAGIC_ONLINE);
        this.hasBoosters = false;
        this.hasBasicLands = true;

        cards.add(new SetCardInfo("Adriana, Captain of the Guard", 45, Rarity.RARE, mage.cards.a.AdrianaCaptainOfTheGuard.class));
        cards.add(new SetCardInfo("Aggressive Instinct", 70855, Rarity.COMMON, mage.cards.a.AggressiveInstinct.class));
        cards.add(new SetCardInfo("Akiri, Line-Slinger", 48, Rarity.RARE, mage.cards.a.AkiriLineSlinger.class));
        cards.add(new SetCardInfo("Alms Collector", 65677, Rarity.RARE, mage.cards.a.AlmsCollector.class));
        cards.add(new SetCardInfo("Aminatou's Augury", 70745, Rarity.RARE, mage.cards.a.AminatousAugury.class));
        cards.add(new SetCardInfo("Aminatou, the Fateshifter", 70763, Rarity.MYTHIC, mage.cards.a.AminatouTheFateshifter.class));
        cards.add(new SetCardInfo("Ancestor Dragon", 70829, Rarity.RARE, mage.cards.a.AncestorDragon.class));
        cards.add(new SetCardInfo("Ancient Excavation", 38, Rarity.UNCOMMON, mage.cards.a.AncientExcavation.class));
        cards.add(new SetCardInfo("Ancient Stone Idol", 70755, Rarity.RARE, mage.cards.a.AncientStoneIdol.class));
        cards.add(new SetCardInfo("Angelic Guardian", 70767, Rarity.RARE, mage.cards.a.AngelicGuardian.class));
        cards.add(new SetCardInfo("Angler Turtle", 70769, Rarity.RARE, mage.cards.a.AnglerTurtle.class));
        cards.add(new SetCardInfo("Aquitect's Will", 65865, Rarity.COMMON, mage.cards.a.AquitectsWill.class));
        cards.add(new SetCardInfo("Arahbo, Roar of the World", 65735, Rarity.MYTHIC, mage.cards.a.ArahboRoarOfTheWorld.class));
        cards.add(new SetCardInfo("Arixmethes, Slumbering Isle", 70715, Rarity.RARE, mage.cards.a.ArixmethesSlumberingIsle.class));
        cards.add(new SetCardInfo("Armored Whirl Turtle", 70809, Rarity.COMMON, mage.cards.a.ArmoredWhirlTurtle.class));
        cards.add(new SetCardInfo("Armory Automaton", 68, Rarity.RARE, mage.cards.a.ArmoryAutomaton.class));
        cards.add(new SetCardInfo("Ash Barrens", 72, Rarity.COMMON, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Aspect of Wolf", 65819, Rarity.RARE, mage.cards.a.AspectOfWolf.class));
        cards.add(new SetCardInfo("Atraxa, Praetors' Voice", 62, Rarity.MYTHIC, mage.cards.a.AtraxaPraetorsVoice.class));
        cards.add(new SetCardInfo("Avatar of Growth", 70785, Rarity.MYTHIC, mage.cards.a.AvatarOfGrowth.class));
        cards.add(new SetCardInfo("Balan, Wandering Knight", 65757, Rarity.RARE, mage.cards.b.BalanWanderingKnight.class));
        cards.add(new SetCardInfo("Benefactor's Draught", 36, Rarity.RARE, mage.cards.b.BenefactorsDraught.class));
        cards.add(new SetCardInfo("Bloodforged Battle-Axe", 65713, Rarity.RARE, mage.cards.b.BloodforgedBattleAxe.class));
        cards.add(new SetCardInfo("Bloodline Necromancer", 65753, Rarity.UNCOMMON, mage.cards.b.BloodlineNecromancer.class));
        cards.add(new SetCardInfo("Bloodsworn Steward", 65699, Rarity.RARE, mage.cards.b.BloodswornSteward.class));
        cards.add(new SetCardInfo("Bloodtracker", 70689, Rarity.RARE, mage.cards.b.Bloodtracker.class));
        cards.add(new SetCardInfo("Boneyard Scourge", 65687, Rarity.RARE, mage.cards.b.BoneyardScourge.class));
        cards.add(new SetCardInfo("Boompile", 70, Rarity.RARE, mage.cards.b.Boompile.class));
        cards.add(new SetCardInfo("Borderland Explorer", 65775, Rarity.COMMON, mage.cards.b.BorderlandExplorer.class));
        cards.add(new SetCardInfo("Boreas Charger", 70717, Rarity.RARE, mage.cards.b.BoreasCharger.class));
        cards.add(new SetCardInfo("Brainwash", 65795, Rarity.COMMON, mage.cards.b.Brainwash.class));
        cards.add(new SetCardInfo("Breath of Fire", 70859, Rarity.COMMON, mage.cards.b.BreathOfFire.class));
        cards.add(new SetCardInfo("Breya, Etherium Shaper", 65, Rarity.MYTHIC, mage.cards.b.BreyaEtheriumShaper.class));
        cards.add(new SetCardInfo("Brilliant Plan", 70833, Rarity.UNCOMMON, mage.cards.b.BrilliantPlan.class));
        cards.add(new SetCardInfo("Brudiclad, Telchor Engineer", 70709, Rarity.MYTHIC, mage.cards.b.BrudicladTelchorEngineer.class));
        cards.add(new SetCardInfo("Bruse Tarl, Boorish Herder", 56, Rarity.MYTHIC, mage.cards.b.BruseTarlBoorishHerder.class));
        cards.add(new SetCardInfo("Burnt Offering", 65833, Rarity.COMMON, mage.cards.b.BurntOffering.class));
        cards.add(new SetCardInfo("Cao Ren, Wei Commander", 65817, Rarity.RARE, mage.cards.c.CaoRenWeiCommander.class));
        cards.add(new SetCardInfo("Cemetery Gate", 65835, Rarity.COMMON, mage.cards.c.CemeteryGate.class));
        cards.add(new SetCardInfo("Charging Cinderhorn", 26, Rarity.RARE, mage.cards.c.ChargingCinderhorn.class));
        cards.add(new SetCardInfo("Cleansing Screech", 70865, Rarity.COMMON, mage.cards.c.CleansingScreech.class));
        cards.add(new SetCardInfo("Cloak of Mists", 70835, Rarity.COMMON, mage.cards.c.CloakOfMists.class));
        cards.add(new SetCardInfo("Colorful Feiyi Sparrow", 70811, Rarity.COMMON, mage.cards.c.ColorfulFeiyiSparrow.class));
        cards.add(new SetCardInfo("Confidence from Strength", 70857, Rarity.COMMON, mage.cards.c.ConfidenceFromStrength.class));
        cards.add(new SetCardInfo("Conqueror's Flail", 65791, Rarity.RARE, mage.cards.c.ConquerorsFlail.class));
        cards.add(new SetCardInfo("Coveted Jewel", 70673, Rarity.RARE, mage.cards.c.CovetedJewel.class));
        cards.add(new SetCardInfo("Crash of Rhino Beetles", 70693, Rarity.RARE, mage.cards.c.CrashOfRhinoBeetles.class));
        cards.add(new SetCardInfo("Crimson Honor Guard", 65697, Rarity.RARE, mage.cards.c.CrimsonHonorGuard.class));
        cards.add(new SetCardInfo("Cruel Tutor", 65797, Rarity.RARE, mage.cards.c.CruelTutor.class));
        cards.add(new SetCardInfo("Crystalline Crawler", 69, Rarity.RARE, mage.cards.c.CrystallineCrawler.class));
        cards.add(new SetCardInfo("Curse of Bounty", 65747, Rarity.UNCOMMON, mage.cards.c.CurseOfBounty.class));
        cards.add(new SetCardInfo("Curse of Disturbance", 65743, Rarity.UNCOMMON, mage.cards.c.CurseOfDisturbance.class));
        cards.add(new SetCardInfo("Curse of Opulence", 65745, Rarity.UNCOMMON, mage.cards.c.CurseOfOpulence.class));
        cards.add(new SetCardInfo("Curse of Vengeance", 23, Rarity.RARE, mage.cards.c.CurseOfVengeance.class));
        cards.add(new SetCardInfo("Curse of Verbosity", 65767, Rarity.UNCOMMON, mage.cards.c.CurseOfVerbosity.class));
        cards.add(new SetCardInfo("Curse of Vitality", 65765, Rarity.UNCOMMON, mage.cards.c.CurseOfVitality.class));
        cards.add(new SetCardInfo("Custodi Lich", 22, Rarity.RARE, mage.cards.c.CustodiLich.class));
        cards.add(new SetCardInfo("Custodi Soulbinders", 6, Rarity.RARE, mage.cards.c.CustodiSoulbinders.class));
        cards.add(new SetCardInfo("Custodi Squire", 65781, Rarity.COMMON, mage.cards.c.CustodiSquire.class));
        cards.add(new SetCardInfo("Daretti, Ingenious Iconoclast", 66, Rarity.MYTHIC, mage.cards.d.DarettiIngeniousIconoclast.class));
        cards.add(new SetCardInfo("Deepglow Skate", 16, Rarity.RARE, mage.cards.d.DeepglowSkate.class));
        cards.add(new SetCardInfo("Desperate Ritual", 65851, Rarity.UNCOMMON, mage.cards.d.DesperateRitual.class));
        cards.add(new SetCardInfo("Disrupt Decorum", 65695, Rarity.RARE, mage.cards.d.DisruptDecorum.class));
        cards.add(new SetCardInfo("Domesticated Hydra", 31, Rarity.UNCOMMON, mage.cards.d.DomesticatedHydra.class));
        cards.add(new SetCardInfo("Drafna's Restoration", 65827, Rarity.COMMON, mage.cards.d.DrafnasRestoration.class));
        cards.add(new SetCardInfo("Dragon's Presence", 70831, Rarity.COMMON, mage.cards.d.DragonsPresence.class));
        cards.add(new SetCardInfo("Drown in Shapelessness", 70837, Rarity.COMMON, mage.cards.d.DrownInShapelessness.class));
        cards.add(new SetCardInfo("Duelist's Heritage", 9, Rarity.RARE, mage.cards.d.DuelistsHeritage.class));
        cards.add(new SetCardInfo("Earth-Origin Yak", 70821, Rarity.COMMON, mage.cards.e.EarthOriginYak.class));
        cards.add(new SetCardInfo("Earthshaking Si", 70853, Rarity.COMMON, mage.cards.e.EarthshakingSi.class));
        cards.add(new SetCardInfo("Echo Storm", 70695, Rarity.RARE, mage.cards.e.EchoStorm.class));
        cards.add(new SetCardInfo("Edgar Markov", 65693, Rarity.MYTHIC, mage.cards.e.EdgarMarkov.class));
        cards.add(new SetCardInfo("Emissary of Grudges", 70761, Rarity.RARE, mage.cards.e.EmissaryOfGrudges.class));
        cards.add(new SetCardInfo("Empyrial Storm", 70701, Rarity.RARE, mage.cards.e.EmpyrialStorm.class));
        cards.add(new SetCardInfo("Enchanter's Bane", 70703, Rarity.RARE, mage.cards.e.EnchantersBane.class));
        cards.add(new SetCardInfo("Endless Atlas", 70683, Rarity.RARE, mage.cards.e.EndlessAtlas.class));
        cards.add(new SetCardInfo("Energy Tap", 65837, Rarity.COMMON, mage.cards.e.EnergyTap.class));
        cards.add(new SetCardInfo("Entourage of Trest", 65783, Rarity.COMMON, mage.cards.e.EntourageOfTrest.class));
        cards.add(new SetCardInfo("Entrapment Maneuver", 10, Rarity.RARE, mage.cards.e.EntrapmentManeuver.class));
        cards.add(new SetCardInfo("Entreat the Dead", 70743, Rarity.RARE, mage.cards.e.EntreatTheDead.class));
        cards.add(new SetCardInfo("Estrid's Invocation", 70765, Rarity.RARE, mage.cards.e.EstridsInvocation.class));
        cards.add(new SetCardInfo("Estrid, the Masked", 70739, Rarity.MYTHIC, mage.cards.e.EstridTheMasked.class));
        cards.add(new SetCardInfo("Ever-Watching Threshold", 70665, Rarity.RARE, mage.cards.e.EverWatchingThreshold.class));
        cards.add(new SetCardInfo("Evolutionary Escalation", 32, Rarity.UNCOMMON, mage.cards.e.EvolutionaryEscalation.class));
        cards.add(new SetCardInfo("Expropriate", 65785, Rarity.MYTHIC, mage.cards.e.Expropriate.class));
        cards.add(new SetCardInfo("Faerie Artisans", 14, Rarity.RARE, mage.cards.f.FaerieArtisans.class));
        cards.add(new SetCardInfo("Feiyi Snake", 70791, Rarity.COMMON, mage.cards.f.FeiyiSnake.class));
        cards.add(new SetCardInfo("Ferocious Zheng", 70847, Rarity.COMMON, mage.cards.f.FerociousZheng.class));
        cards.add(new SetCardInfo("Field of Dreams", 65831, Rarity.RARE, mage.cards.f.FieldOfDreams.class));
        cards.add(new SetCardInfo("Fire-Omen Crane", 70851, Rarity.UNCOMMON, mage.cards.f.FireOmenCrane.class));
        cards.add(new SetCardInfo("Firesong and Sunspeaker", 68076, Rarity.RARE, mage.cards.f.FiresongAndSunspeaker.class));
        cards.add(new SetCardInfo("Flood", 65829, Rarity.COMMON, mage.cards.f.Flood.class));
        cards.add(new SetCardInfo("Forest", 70807, Rarity.LAND, mage.cards.basiclands.Forest.class));
        cards.add(new SetCardInfo("Forge of Heroes", 70679, Rarity.COMMON, mage.cards.f.ForgeOfHeroes.class));
        cards.add(new SetCardInfo("Fortunate Few", 65673, Rarity.RARE, mage.cards.f.FortunateFew.class));
        cards.add(new SetCardInfo("Fractured Identity", 65681, Rarity.RARE, mage.cards.f.FracturedIdentity.class));
        cards.add(new SetCardInfo("Frenzied Fugue", 24, Rarity.UNCOMMON, mage.cards.f.FrenziedFugue.class));
        cards.add(new SetCardInfo("Fury Storm", 70751, Rarity.RARE, mage.cards.f.FuryStorm.class));
        cards.add(new SetCardInfo("Galecaster Colossus", 65755, Rarity.RARE, mage.cards.g.GalecasterColossus.class));
        cards.add(new SetCardInfo("Game of Chaos", 65821, Rarity.RARE, mage.cards.g.GameOfChaos.class));
        cards.add(new SetCardInfo("Garrulous Sycophant", 17, Rarity.COMMON, mage.cards.g.GarrulousSycophant.class));
        cards.add(new SetCardInfo("Gempalm Incinerator", 65855, Rarity.UNCOMMON, mage.cards.g.GempalmIncinerator.class));
        cards.add(new SetCardInfo("Genesis Storm", 70681, Rarity.RARE, mage.cards.g.GenesisStorm.class));
        cards.add(new SetCardInfo("Geode Golem", 70727, Rarity.UNCOMMON, mage.cards.g.GeodeGolem.class));
        cards.add(new SetCardInfo("Giant Spider", 70849, Rarity.COMMON, mage.cards.g.GiantSpider.class));
        cards.add(new SetCardInfo("Goblin Goliath", 70783, Rarity.MYTHIC, mage.cards.g.GoblinGoliath.class));
        cards.add(new SetCardInfo("Goblin Goon", 65857, Rarity.RARE, mage.cards.g.GoblinGoon.class));
        cards.add(new SetCardInfo("Goblin Spymaster", 25, Rarity.RARE, mage.cards.g.GoblinSpymaster.class));
        cards.add(new SetCardInfo("Grave Upheaval", 41, Rarity.UNCOMMON, mage.cards.g.GraveUpheaval.class));
        cards.add(new SetCardInfo("Grenzo, Havoc Raiser", 29, Rarity.RARE, mage.cards.g.GrenzoHavocRaiser.class));
        cards.add(new SetCardInfo("Grip of Phyresis", 12, Rarity.UNCOMMON, mage.cards.g.GripOfPhyresis.class));
        cards.add(new SetCardInfo("Guttural Response", 65845, Rarity.UNCOMMON, mage.cards.g.GutturalResponse.class));
        cards.add(new SetCardInfo("Gyrus, Waker of Corpses", 70661, Rarity.MYTHIC, mage.cards.g.GyrusWakerOfCorpses.class));
        cards.add(new SetCardInfo("Hammer of Nazahn", 65669, Rarity.RARE, mage.cards.h.HammerOfNazahn.class));
        cards.add(new SetCardInfo("Hardened-Scale Armor", 70787, Rarity.COMMON, mage.cards.h.HardenedScaleArmor.class));
        cards.add(new SetCardInfo("Heavenly Blademaster", 70705, Rarity.RARE, mage.cards.h.HeavenlyBlademaster.class));
        cards.add(new SetCardInfo("Heavenly Qilin", 70827, Rarity.COMMON, mage.cards.h.HeavenlyQilin.class));
        cards.add(new SetCardInfo("Heirloom Blade", 65683, Rarity.UNCOMMON, mage.cards.h.HeirloomBlade.class));
        cards.add(new SetCardInfo("Herald's Horn", 65731, Rarity.UNCOMMON, mage.cards.h.HeraldsHorn.class));
        cards.add(new SetCardInfo("Huang Zhong, Shu General", 65801, Rarity.RARE, mage.cards.h.HuangZhongShuGeneral.class));
        cards.add(new SetCardInfo("Hungry Lynx", 65711, Rarity.RARE, mage.cards.h.HungryLynx.class));
        cards.add(new SetCardInfo("Ikra Shidiqi, the Usurper", 58, Rarity.MYTHIC, mage.cards.i.IkraShidiqiTheUsurper.class));
        cards.add(new SetCardInfo("Immortal Phoenix", 70773, Rarity.RARE, mage.cards.i.ImmortalPhoenix.class));
        cards.add(new SetCardInfo("Inalla, Archmage Ritualist", 65737, Rarity.MYTHIC, mage.cards.i.InallaArchmageRitualist.class));
        cards.add(new SetCardInfo("Inspired Sphinx", 70779, Rarity.MYTHIC, mage.cards.i.InspiredSphinx.class));
        cards.add(new SetCardInfo("Ishai, Ojutai Dragonspeaker", 57, Rarity.MYTHIC, mage.cards.i.IshaiOjutaiDragonspeaker.class));
        cards.add(new SetCardInfo("Island", 70803, Rarity.LAND, mage.cards.basiclands.Island.class));
        cards.add(new SetCardInfo("Isolated Watchtower", 70707, Rarity.RARE, mage.cards.i.IsolatedWatchtower.class));
        cards.add(new SetCardInfo("Izzet Chemister", 65741, Rarity.RARE, mage.cards.i.IzzetChemister.class));
        cards.add(new SetCardInfo("Jhoira of the Ghitu", 65847, Rarity.MYTHIC, mage.cards.j.JhoiraOfTheGhitu.class));
        cards.add(new SetCardInfo("Jiang Yanggu", 70793, Rarity.MYTHIC, mage.cards.j.JiangYanggu.class));
        cards.add(new SetCardInfo("Journey for the Elixir", 70861, Rarity.RARE, mage.cards.j.JourneyForTheElixir.class));
        cards.add(new SetCardInfo("Kaya, Ghost Assassin", 67, Rarity.MYTHIC, mage.cards.k.KayaGhostAssassin.class));
        cards.add(new SetCardInfo("Keeper of Keys", 15, Rarity.RARE, mage.cards.k.KeeperOfKeys.class));
        cards.add(new SetCardInfo("Kess, Dissident Mage", 65763, Rarity.MYTHIC, mage.cards.k.KessDissidentMage.class));
        cards.add(new SetCardInfo("Kestia, the Cultivator", 70699, Rarity.MYTHIC, mage.cards.k.KestiaTheCultivator.class));
        cards.add(new SetCardInfo("Kheru Mind-Eater", 65761, Rarity.RARE, mage.cards.k.KheruMindEater.class));
        cards.add(new SetCardInfo("Kindred Boon", 65717, Rarity.RARE, mage.cards.k.KindredBoon.class));
        cards.add(new SetCardInfo("Kindred Charge", 65721, Rarity.RARE, mage.cards.k.KindredCharge.class));
        cards.add(new SetCardInfo("Kindred Discovery", 65725, Rarity.RARE, mage.cards.k.KindredDiscovery.class));
        cards.add(new SetCardInfo("Kindred Dominance", 65723, Rarity.RARE, mage.cards.k.KindredDominance.class));
        cards.add(new SetCardInfo("Kindred Summons", 65719, Rarity.RARE, mage.cards.k.KindredSummons.class));
        cards.add(new SetCardInfo("Kraum, Ludevic's Opus", 46, Rarity.RARE, mage.cards.k.KraumLudevicsOpus.class));
        cards.add(new SetCardInfo("Kydele, Chosen of Kruphix", 53, Rarity.MYTHIC, mage.cards.k.KydeleChosenOfKruphix.class));
        cards.add(new SetCardInfo("Kynaios and Tiro of Meletis", 63, Rarity.MYTHIC, mage.cards.k.KynaiosAndTiroOfMeletis.class));
        cards.add(new SetCardInfo("Lady Sun", 65803, Rarity.RARE, mage.cards.l.LadySun.class));
        cards.add(new SetCardInfo("Lady Zhurong, Warrior Queen", 65811, Rarity.RARE, mage.cards.l.LadyZhurongWarriorQueen.class));
        cards.add(new SetCardInfo("Leopard-Spotted Jiao", 70789, Rarity.COMMON, mage.cards.l.LeopardSpottedJiao.class));
        cards.add(new SetCardInfo("Leovold, Emissary of Trest", 60, Rarity.MYTHIC, mage.cards.l.LeovoldEmissaryOfTrest.class));
        cards.add(new SetCardInfo("Licia, Sanguine Tribune", 65729, Rarity.MYTHIC, mage.cards.l.LiciaSanguineTribune.class));
        cards.add(new SetCardInfo("Lonely Sandbar", 65863, Rarity.COMMON, mage.cards.l.LonelySandbar.class));
        cards.add(new SetCardInfo("Lord Windgrace", 70667, Rarity.MYTHIC, mage.cards.l.LordWindgrace.class));
        cards.add(new SetCardInfo("Lovisa Coldeyes", 65849, Rarity.MYTHIC, mage.cards.l.LovisaColdeyes.class));
        cards.add(new SetCardInfo("Loyal Apprentice", 70753, Rarity.UNCOMMON, mage.cards.l.LoyalApprentice.class));
        cards.add(new SetCardInfo("Loyal Drake", 70757, Rarity.UNCOMMON, mage.cards.l.LoyalDrake.class));
        cards.add(new SetCardInfo("Loyal Guardian", 70721, Rarity.UNCOMMON, mage.cards.l.LoyalGuardian.class));
        cards.add(new SetCardInfo("Loyal Subordinate", 70735, Rarity.UNCOMMON, mage.cards.l.LoyalSubordinate.class));
        cards.add(new SetCardInfo("Loyal Unicorn", 70729, Rarity.UNCOMMON, mage.cards.l.LoyalUnicorn.class));
        cards.add(new SetCardInfo("Lu Su, Wu Advisor", 65809, Rarity.RARE, mage.cards.l.LuSuWuAdvisor.class));
        cards.add(new SetCardInfo("Ludevic, Necro-Alchemist", 52, Rarity.MYTHIC, mage.cards.l.LudevicNecroAlchemist.class));
        cards.add(new SetCardInfo("Ma Chao, Western Warrior", 65807, Rarity.RARE, mage.cards.m.MaChaoWesternWarrior.class));
        cards.add(new SetCardInfo("Magus of the Balance", 70677, Rarity.RARE, mage.cards.m.MagusOfTheBalance.class));
        cards.add(new SetCardInfo("Magus of the Mind", 65685, Rarity.RARE, mage.cards.m.MagusOfTheMind.class));
        cards.add(new SetCardInfo("Magus of the Will", 21, Rarity.RARE, mage.cards.m.MagusOfTheWill.class));
        cards.add(new SetCardInfo("Marchesa's Decree", 20, Rarity.UNCOMMON, mage.cards.m.MarchesasDecree.class));
        cards.add(new SetCardInfo("Master of Waves", 65859, Rarity.MYTHIC, mage.cards.m.MasterOfWaves.class));
        cards.add(new SetCardInfo("Mathas, Fiend Seeker", 65759, Rarity.MYTHIC, mage.cards.m.MathasFiendSeeker.class));
        cards.add(new SetCardInfo("Meandering River", 70799, Rarity.COMMON, mage.cards.m.MeanderingRiver.class));
        cards.add(new SetCardInfo("Metamorphosis", 65839, Rarity.COMMON, mage.cards.m.Metamorphosis.class));
        cards.add(new SetCardInfo("Migratory Route", 40, Rarity.UNCOMMON, mage.cards.m.MigratoryRoute.class));
        cards.add(new SetCardInfo("Militant Angel", 70777, Rarity.MYTHIC, mage.cards.m.MilitantAngel.class));
        cards.add(new SetCardInfo("Mirri, Weatherlight Duelist", 65707, Rarity.MYTHIC, mage.cards.m.MirriWeatherlightDuelist.class));
        cards.add(new SetCardInfo("Mirror of the Forebears", 65751, Rarity.UNCOMMON, mage.cards.m.MirrorOfTheForebears.class));
        cards.add(new SetCardInfo("Moon-Eating Dog", 70823, Rarity.UNCOMMON, mage.cards.m.MoonEatingDog.class));
        cards.add(new SetCardInfo("Mountain", 70805, Rarity.LAND, mage.cards.basiclands.Mountain.class));
        cards.add(new SetCardInfo("Mu Yanling", 70795, Rarity.MYTHIC, mage.cards.m.MuYanling.class));
        cards.add(new SetCardInfo("Myth Unbound", 70663, Rarity.RARE, mage.cards.m.MythUnbound.class));
        cards.add(new SetCardInfo("Nazahn, Revered Bladesmith", 65771, Rarity.MYTHIC, mage.cards.n.NazahnReveredBladesmith.class));
        cards.add(new SetCardInfo("Nesting Dragon", 70649, Rarity.RARE, mage.cards.n.NestingDragon.class));
        cards.add(new SetCardInfo("Night Incarnate", 70749, Rarity.RARE, mage.cards.n.NightIncarnate.class));
        cards.add(new SetCardInfo("Nine-Tail White Fox", 70819, Rarity.COMMON, mage.cards.n.NineTailWhiteFox.class));
        cards.add(new SetCardInfo("Nylea's Colossus", 70655, Rarity.RARE, mage.cards.n.NyleasColossus.class));
        cards.add(new SetCardInfo("O-Kagachi, Vengeful Kami", 65733, Rarity.MYTHIC, mage.cards.o.OKagachiVengefulKami.class));
        cards.add(new SetCardInfo("Octopus Umbra", 70725, Rarity.RARE, mage.cards.o.OctopusUmbra.class));
        cards.add(new SetCardInfo("Orzhov Advokist", 3, Rarity.UNCOMMON, mage.cards.o.OrzhovAdvokist.class));
        cards.add(new SetCardInfo("Palace Jailer", 4, Rarity.UNCOMMON, mage.cards.p.PalaceJailer.class));
        cards.add(new SetCardInfo("Palace Sentinels", 2, Rarity.COMMON, mage.cards.p.PalaceSentinels.class));
        cards.add(new SetCardInfo("Pang Tong, \"Young Phoenix\"", 65813, Rarity.RARE, mage.cards.p.PangTongYoungPhoenix.class));
        cards.add(new SetCardInfo("Parting Thoughts", 19, Rarity.UNCOMMON, mage.cards.p.PartingThoughts.class));
        cards.add(new SetCardInfo("Path of Ancestry", 65679, Rarity.COMMON, mage.cards.p.PathOfAncestry.class));
        cards.add(new SetCardInfo("Patron of the Vein", 65727, Rarity.RARE, mage.cards.p.PatronOfTheVein.class));
        cards.add(new SetCardInfo("Pit Scorpion", 65823, Rarity.COMMON, mage.cards.p.PitScorpion.class));
        cards.add(new SetCardInfo("Plains", 70801, Rarity.LAND, mage.cards.basiclands.Plains.class));
        cards.add(new SetCardInfo("Plant Elemental", 65825, Rarity.UNCOMMON, mage.cards.p.PlantElemental.class));
        cards.add(new SetCardInfo("Primeval Protector", 33, Rarity.RARE, mage.cards.p.PrimevalProtector.class));
        cards.add(new SetCardInfo("Primordial Mist", 70733, Rarity.RARE, mage.cards.p.PrimordialMist.class));
        cards.add(new SetCardInfo("Prismatic Geoscope", 71, Rarity.RARE, mage.cards.p.PrismaticGeoscope.class));
        cards.add(new SetCardInfo("Protector of the Crown", 8, Rarity.RARE, mage.cards.p.ProtectorOfTheCrown.class));
        cards.add(new SetCardInfo("Purple-Crystal Crab", 70813, Rarity.COMMON, mage.cards.p.PurpleCrystalCrab.class));
        cards.add(new SetCardInfo("Qasali Slingers", 65709, Rarity.RARE, mage.cards.q.QasaliSlingers.class));
        cards.add(new SetCardInfo("Qilin's Blessing", 70841, Rarity.COMMON, mage.cards.q.QilinsBlessing.class));
        cards.add(new SetCardInfo("Queen Marchesa", 50, Rarity.MYTHIC, mage.cards.q.QueenMarchesa.class));
        cards.add(new SetCardInfo("Ramos, Dragon Engine", 65749, Rarity.MYTHIC, mage.cards.r.RamosDragonEngine.class));
        cards.add(new SetCardInfo("Rampaging Brontodon", 70775, Rarity.RARE, mage.cards.r.RampagingBrontodon.class));
        cards.add(new SetCardInfo("Ravenous Slime", 70737, Rarity.RARE, mage.cards.r.RavenousSlime.class));
        cards.add(new SetCardInfo("Ravos, Soultender", 59, Rarity.MYTHIC, mage.cards.r.RavosSoultender.class));
        cards.add(new SetCardInfo("Reality Scramble", 70723, Rarity.RARE, mage.cards.r.RealityScramble.class));
        cards.add(new SetCardInfo("Reckless Pangolin", 70845, Rarity.COMMON, mage.cards.r.RecklessPangolin.class));
        cards.add(new SetCardInfo("Recruiter of the Guard", 5, Rarity.RARE, mage.cards.r.RecruiterOfTheGuard.class));
        cards.add(new SetCardInfo("Retrofitter Foundry", 70697, Rarity.RARE, mage.cards.r.RetrofitterFoundry.class));
        cards.add(new SetCardInfo("Reyhan, Last of the Abzan", 43, Rarity.RARE, mage.cards.r.ReyhanLastOfTheAbzan.class));
        cards.add(new SetCardInfo("Rhythmic Water Vortex", 70839, Rarity.RARE, mage.cards.r.RhythmicWaterVortex.class));
        cards.add(new SetCardInfo("Rot Hulk", 70781, Rarity.MYTHIC, mage.cards.r.RotHulk.class));
        cards.add(new SetCardInfo("Runehorn Hellkite", 27, Rarity.RARE, mage.cards.r.RunehornHellkite.class));
        cards.add(new SetCardInfo("Sacred White Deer", 70843, Rarity.UNCOMMON, mage.cards.s.SacredWhiteDeer.class));
        cards.add(new SetCardInfo("Saheeli's Directive", 70675, Rarity.RARE, mage.cards.s.SaheelisDirective.class));
        cards.add(new SetCardInfo("Saheeli, the Gifted", 70685, Rarity.MYTHIC, mage.cards.s.SaheeliTheGifted.class));
        cards.add(new SetCardInfo("Salvage", 65789, Rarity.COMMON, mage.cards.s.Salvage.class));
        cards.add(new SetCardInfo("Sanctum Prelate", 11, Rarity.MYTHIC, mage.cards.s.SanctumPrelate.class));
        cards.add(new SetCardInfo("Saskia the Unyielding", 61, Rarity.MYTHIC, mage.cards.s.SaskiaTheUnyielding.class));
        cards.add(new SetCardInfo("Scalelord Reckoner", 65689, Rarity.RARE, mage.cards.s.ScalelordReckoner.class));
        cards.add(new SetCardInfo("Screeching Phoenix", 70863, Rarity.RARE, mage.cards.s.ScreechingPhoenix.class));
        cards.add(new SetCardInfo("Selfless Squire", 7, Rarity.RARE, mage.cards.s.SelflessSquire.class));
        cards.add(new SetCardInfo("Selvala's Stampede", 65787, Rarity.RARE, mage.cards.s.SelvalasStampede.class));
        cards.add(new SetCardInfo("Selvala, Heart of the Wilds", 37, Rarity.MYTHIC, mage.cards.s.SelvalaHeartOfTheWilds.class));
        cards.add(new SetCardInfo("Shifting Shadow", 65703, Rarity.RARE, mage.cards.s.ShiftingShadow.class));
        cards.add(new SetCardInfo("Sidar Kondo of Jamuraa", 54, Rarity.MYTHIC, mage.cards.s.SidarKondoOfJamuraa.class));
        cards.add(new SetCardInfo("Silas Renn, Seeker Adept", 51, Rarity.MYTHIC, mage.cards.s.SilasRennSeekerAdept.class));
        cards.add(new SetCardInfo("Sima Yi, Wei Field Marshal", 65815, Rarity.RARE, mage.cards.s.SimaYiWeiFieldMarshal.class));
        cards.add(new SetCardInfo("Sinuous Vermin", 65773, Rarity.COMMON, mage.cards.s.SinuousVermin.class));
        cards.add(new SetCardInfo("Skittering Crustacean", 65777, Rarity.COMMON, mage.cards.s.SkitteringCrustacean.class));
        cards.add(new SetCardInfo("Skull Storm", 70713, Rarity.RARE, mage.cards.s.SkullStorm.class));
        cards.add(new SetCardInfo("Skyline Despot", 28, Rarity.RARE, mage.cards.s.SkylineDespot.class));
        cards.add(new SetCardInfo("Sower of Discord", 70659, Rarity.RARE, mage.cards.s.SowerOfDiscord.class));
        cards.add(new SetCardInfo("Splitting Slime", 34, Rarity.RARE, mage.cards.s.SplittingSlime.class));
        cards.add(new SetCardInfo("Stalking Leonin", 65769, Rarity.RARE, mage.cards.s.StalkingLeonin.class));
        cards.add(new SetCardInfo("Stonehoof Chieftain", 35, Rarity.RARE, mage.cards.s.StonehoofChieftain.class));
        cards.add(new SetCardInfo("Stormcloud Spirit", 70825, Rarity.UNCOMMON, mage.cards.s.StormcloudSpirit.class));
        cards.add(new SetCardInfo("Stream of Acid", 65793, Rarity.UNCOMMON, mage.cards.s.StreamOfAcid.class));
        cards.add(new SetCardInfo("Stunt Double", 13, Rarity.RARE, mage.cards.s.StuntDouble.class));
        cards.add(new SetCardInfo("Subterranean Tremors", 30, Rarity.MYTHIC, mage.cards.s.SubterraneanTremors.class));
        cards.add(new SetCardInfo("Sylvan Reclamation", 39, Rarity.UNCOMMON, mage.cards.s.SylvanReclamation.class));
        cards.add(new SetCardInfo("Taigam, Ojutai Master", 65739, Rarity.RARE, mage.cards.t.TaigamOjutaiMaster.class));
        cards.add(new SetCardInfo("Taigam, Sidisi's Hand", 65715, Rarity.RARE, mage.cards.t.TaigamSidisisHand.class));
        cards.add(new SetCardInfo("Tana, the Bloodsower", 55, Rarity.MYTHIC, mage.cards.t.TanaTheBloodsower.class));
        cards.add(new SetCardInfo("Tawnos, Urza's Apprentice", 70687, Rarity.MYTHIC, mage.cards.t.TawnosUrzasApprentice.class));
        cards.add(new SetCardInfo("Teferi's Protection", 65701, Rarity.RARE, mage.cards.t.TeferisProtection.class));
        cards.add(new SetCardInfo("Territorial Hellkite", 65691, Rarity.RARE, mage.cards.t.TerritorialHellkite.class));
        cards.add(new SetCardInfo("Thantis, the Warweaver", 70671, Rarity.MYTHIC, mage.cards.t.ThantisTheWarweaver.class));
        cards.add(new SetCardInfo("The Unspeakable", 65841, Rarity.RARE, mage.cards.t.TheUnspeakable.class));
        cards.add(new SetCardInfo("The Ur-Dragon", 65675, Rarity.MYTHIC, mage.cards.t.TheUrDragon.class));
        cards.add(new SetCardInfo("Thorn of the Black Rose", 18, Rarity.COMMON, mage.cards.t.ThornOfTheBlackRose.class));
        cards.add(new SetCardInfo("Thrasios, Triton Hero", 47, Rarity.RARE, mage.cards.t.ThrasiosTritonHero.class));
        cards.add(new SetCardInfo("Throne Warden", 1, Rarity.COMMON, mage.cards.t.ThroneWarden.class));
        cards.add(new SetCardInfo("Throne of the High City", 73, Rarity.RARE, mage.cards.t.ThroneOfTheHighCity.class));
        cards.add(new SetCardInfo("Tidal Courier", 65861, Rarity.UNCOMMON, mage.cards.t.TidalCourier.class));
        cards.add(new SetCardInfo("Timber Gorge", 70797, Rarity.COMMON, mage.cards.t.TimberGorge.class));
        cards.add(new SetCardInfo("Traverse the Outlands", 65671, Rarity.RARE, mage.cards.t.TraverseTheOutlands.class));
        cards.add(new SetCardInfo("Treacherous Terrain", 42, Rarity.UNCOMMON, mage.cards.t.TreacherousTerrain.class));
        cards.add(new SetCardInfo("Treasonous Ogre", 65779, Rarity.UNCOMMON, mage.cards.t.TreasonousOgre.class));
        cards.add(new SetCardInfo("Treasure Nabber", 70653, Rarity.RARE, mage.cards.t.TreasureNabber.class));
        cards.add(new SetCardInfo("Turntimber Sower", 70711, Rarity.RARE, mage.cards.t.TurntimberSower.class));
        cards.add(new SetCardInfo("Tuvasa the Sunlit", 70691, Rarity.MYTHIC, mage.cards.t.TuvasaTheSunlit.class));
        cards.add(new SetCardInfo("Tymna the Weaver", 44, Rarity.RARE, mage.cards.t.TymnaTheWeaver.class));
        cards.add(new SetCardInfo("Varchild, Betrayer of Kjeldor", 70759, Rarity.RARE, mage.cards.v.VarchildBetrayerOfKjeldor.class));
        cards.add(new SetCardInfo("Varina, Lich Queen", 70741, Rarity.MYTHIC, mage.cards.v.VarinaLichQueen.class));
        cards.add(new SetCardInfo("Vedalken Humiliator", 70731, Rarity.RARE, mage.cards.v.VedalkenHumiliator.class));
        cards.add(new SetCardInfo("Vengeant Vampire", 70771, Rarity.RARE, mage.cards.v.VengeantVampire.class));
        cards.add(new SetCardInfo("Vial Smasher the Fierce", 49, Rarity.MYTHIC, mage.cards.v.VialSmasherTheFierce.class));
        cards.add(new SetCardInfo("Vivid Flying Fish", 70817, Rarity.COMMON, mage.cards.v.VividFlyingFish.class));
        cards.add(new SetCardInfo("Warren Instigator", 65853, Rarity.MYTHIC, mage.cards.w.WarrenInstigator.class));
        cards.add(new SetCardInfo("Wasitora, Nekoru Queen", 65705, Rarity.RARE, mage.cards.w.WasitoraNekoruQueen.class));
        cards.add(new SetCardInfo("Welkin Tern", 70815, Rarity.COMMON, mage.cards.w.WelkinTern.class));
        cards.add(new SetCardInfo("Whiptongue Hydra", 70657, Rarity.RARE, mage.cards.w.WhiptongueHydra.class));
        cards.add(new SetCardInfo("Windgrace's Judgment", 70669, Rarity.RARE, mage.cards.w.WindgracesJudgment.class));
        cards.add(new SetCardInfo("Xantcha, Sleeper Agent", 70719, Rarity.RARE, mage.cards.x.XantchaSleeperAgent.class));
        cards.add(new SetCardInfo("Xun Yu, Wei Advisor", 65799, Rarity.RARE, mage.cards.x.XunYuWeiAdvisor.class));
        cards.add(new SetCardInfo("Yennett, Cryptic Sovereign", 70747, Rarity.MYTHIC, mage.cards.y.YennettCrypticSovereign.class));
        cards.add(new SetCardInfo("Yidris, Maelstrom Wielder", 64, Rarity.MYTHIC, mage.cards.y.YidrisMaelstromWielder.class));
        cards.add(new SetCardInfo("Yuriko, the Tiger's Shadow", 70651, Rarity.RARE, mage.cards.y.YurikoTheTigersShadow.class));
        cards.add(new SetCardInfo("Zo-Zu the Punisher", 65843, Rarity.RARE, mage.cards.z.ZoZuThePunisher.class));
        cards.add(new SetCardInfo("Zuo Ci, the Mocking Sage", 65805, Rarity.RARE, mage.cards.z.ZuoCiTheMockingSage.class));
     }
}
