package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * https://scryfall.com/sets/30a
 *
 * @author JayDi85
 */
public class ThirtiethAnniversaryEdition extends ExpansionSet {

    private static final ThirtiethAnniversaryEdition instance = new ThirtiethAnniversaryEdition();

    public static ThirtiethAnniversaryEdition getInstance() {
        return instance;
    }

    private ThirtiethAnniversaryEdition() {
        super("Thirtieth Anniversary Edition", "30A", ExpansionSet.buildDate(2022, 11, 28), SetType.PROMOTIONAL);
        this.hasBasicLands = true;
        this.numBoosterLands = 3;
        this.numBoosterCommon = 7;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.numBoosterSpecial = 1;
        this.ratioBoosterMythic = 8;

        cards.add(new SetCardInfo("Air Elemental", 343, Rarity.UNCOMMON, mage.cards.a.AirElemental.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Air Elemental", 46, Rarity.UNCOMMON, mage.cards.a.AirElemental.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ancestral Recall", 344, Rarity.RARE, mage.cards.a.AncestralRecall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ancestral Recall", 47, Rarity.RARE, mage.cards.a.AncestralRecall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animate Artifact", 345, Rarity.UNCOMMON, mage.cards.a.AnimateArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animate Artifact", 48, Rarity.UNCOMMON, mage.cards.a.AnimateArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animate Dead", 389, Rarity.UNCOMMON, mage.cards.a.AnimateDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animate Dead", 92, Rarity.UNCOMMON, mage.cards.a.AnimateDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animate Wall", 1, Rarity.RARE, mage.cards.a.AnimateWall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animate Wall", 298, Rarity.RARE, mage.cards.a.AnimateWall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ankh of Mishra", 226, Rarity.RARE, mage.cards.a.AnkhOfMishra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ankh of Mishra", 523, Rarity.RARE, mage.cards.a.AnkhOfMishra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armageddon", 2, Rarity.RARE, mage.cards.a.Armageddon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armageddon", 299, Rarity.RARE, mage.cards.a.Armageddon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aspect of Wolf", 180, Rarity.RARE, mage.cards.a.AspectOfWolf.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aspect of Wolf", 477, Rarity.RARE, mage.cards.a.AspectOfWolf.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bad Moon", 390, Rarity.RARE, mage.cards.b.BadMoon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bad Moon", 93, Rarity.RARE, mage.cards.b.BadMoon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Badlands", 273, Rarity.RARE, mage.cards.b.Badlands.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Badlands", 570, Rarity.RARE, mage.cards.b.Badlands.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balance", 3, Rarity.RARE, mage.cards.b.Balance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balance", 300, Rarity.RARE, mage.cards.b.Balance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Basalt Monolith", 227, Rarity.UNCOMMON, mage.cards.b.BasaltMonolith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Basalt Monolith", 524, Rarity.UNCOMMON, mage.cards.b.BasaltMonolith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bayou", 274, Rarity.RARE, mage.cards.b.Bayou.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bayou", 571, Rarity.RARE, mage.cards.b.Bayou.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Benalish Hero", 301, Rarity.COMMON, mage.cards.b.BenalishHero.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Benalish Hero", 4, Rarity.COMMON, mage.cards.b.BenalishHero.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Berserk", 181, Rarity.UNCOMMON, mage.cards.b.Berserk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Berserk", 478, Rarity.UNCOMMON, mage.cards.b.Berserk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birds of Paradise", 182, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birds of Paradise", 479, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Knight", 391, Rarity.UNCOMMON, mage.cards.b.BlackKnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Knight", 94, Rarity.UNCOMMON, mage.cards.b.BlackKnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Lotus", 228, Rarity.RARE, mage.cards.b.BlackLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Lotus", 525, Rarity.RARE, mage.cards.b.BlackLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Vise", 229, Rarity.UNCOMMON, mage.cards.b.BlackVise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Vise", 526, Rarity.UNCOMMON, mage.cards.b.BlackVise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Ward", 302, Rarity.UNCOMMON, mage.cards.b.BlackWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Ward", 5, Rarity.UNCOMMON, mage.cards.b.BlackWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blaze of Glory", 303, Rarity.RARE, mage.cards.b.BlazeOfGlory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blaze of Glory", 6, Rarity.RARE, mage.cards.b.BlazeOfGlory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blessing", 304, Rarity.RARE, mage.cards.b.Blessing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blessing", 7, Rarity.RARE, mage.cards.b.Blessing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blue Elemental Blast", 346, Rarity.COMMON, mage.cards.b.BlueElementalBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blue Elemental Blast", 49, Rarity.COMMON, mage.cards.b.BlueElementalBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blue Ward", 305, Rarity.UNCOMMON, mage.cards.b.BlueWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blue Ward", 8, Rarity.UNCOMMON, mage.cards.b.BlueWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bog Wraith", 392, Rarity.UNCOMMON, mage.cards.b.BogWraith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bog Wraith", 95, Rarity.UNCOMMON, mage.cards.b.BogWraith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Braingeyser", 347, Rarity.RARE, mage.cards.b.Braingeyser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Braingeyser", 50, Rarity.RARE, mage.cards.b.Braingeyser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Burrowing", 135, Rarity.UNCOMMON, mage.cards.b.Burrowing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Burrowing", 432, Rarity.UNCOMMON, mage.cards.b.Burrowing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Camouflage", 183, Rarity.UNCOMMON, mage.cards.c.Camouflage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Camouflage", 480, Rarity.UNCOMMON, mage.cards.c.Camouflage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Castle", 306, Rarity.UNCOMMON, mage.cards.c.Castle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Castle", 9, Rarity.UNCOMMON, mage.cards.c.Castle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Celestial Prism", 230, Rarity.UNCOMMON, mage.cards.c.CelestialPrism.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Celestial Prism", 527, Rarity.UNCOMMON, mage.cards.c.CelestialPrism.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Channel", 184, Rarity.UNCOMMON, mage.cards.c.Channel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Channel", 481, Rarity.UNCOMMON, mage.cards.c.Channel.class, NON_FULL_USE_VARIOUS));
        //cards.add(new SetCardInfo("Chaos Orb", 231, Rarity.RARE, mage.cards.c.ChaosOrb.class, NON_FULL_USE_VARIOUS));
        //cards.add(new SetCardInfo("Chaos Orb", 528, Rarity.RARE, mage.cards.c.ChaosOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chaoslace", 136, Rarity.RARE, mage.cards.c.Chaoslace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chaoslace", 433, Rarity.RARE, mage.cards.c.Chaoslace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Black", 10, Rarity.COMMON, mage.cards.c.CircleOfProtectionBlack.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Black", 307, Rarity.COMMON, mage.cards.c.CircleOfProtectionBlack.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Blue", 11, Rarity.COMMON, mage.cards.c.CircleOfProtectionBlue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Blue", 308, Rarity.COMMON, mage.cards.c.CircleOfProtectionBlue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Green", 12, Rarity.COMMON, mage.cards.c.CircleOfProtectionGreen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Green", 309, Rarity.COMMON, mage.cards.c.CircleOfProtectionGreen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Red", 13, Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Red", 310, Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: White", 14, Rarity.COMMON, mage.cards.c.CircleOfProtectionWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: White", 311, Rarity.COMMON, mage.cards.c.CircleOfProtectionWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Clockwork Beast", 232, Rarity.RARE, mage.cards.c.ClockworkBeast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Clockwork Beast", 529, Rarity.RARE, mage.cards.c.ClockworkBeast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Clone", 348, Rarity.UNCOMMON, mage.cards.c.Clone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Clone", 51, Rarity.UNCOMMON, mage.cards.c.Clone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cockatrice", 185, Rarity.RARE, mage.cards.c.Cockatrice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cockatrice", 482, Rarity.RARE, mage.cards.c.Cockatrice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Consecrate Land", 15, Rarity.UNCOMMON, mage.cards.c.ConsecrateLand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Consecrate Land", 312, Rarity.UNCOMMON, mage.cards.c.ConsecrateLand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Conservator", 233, Rarity.UNCOMMON, mage.cards.c.Conservator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Conservator", 530, Rarity.UNCOMMON, mage.cards.c.Conservator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Control Magic", 349, Rarity.UNCOMMON, mage.cards.c.ControlMagic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Control Magic", 52, Rarity.UNCOMMON, mage.cards.c.ControlMagic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Conversion", 16, Rarity.UNCOMMON, mage.cards.c.Conversion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Conversion", 313, Rarity.UNCOMMON, mage.cards.c.Conversion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Copper Tablet", 234, Rarity.UNCOMMON, mage.cards.c.CopperTablet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Copper Tablet", 531, Rarity.UNCOMMON, mage.cards.c.CopperTablet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Copy Artifact", 350, Rarity.RARE, mage.cards.c.CopyArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Copy Artifact", 53, Rarity.RARE, mage.cards.c.CopyArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Counterspell", 351, Rarity.UNCOMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Counterspell", 54, Rarity.UNCOMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Craw Wurm", 186, Rarity.COMMON, mage.cards.c.CrawWurm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Craw Wurm", 483, Rarity.COMMON, mage.cards.c.CrawWurm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Creature Bond", 352, Rarity.COMMON, mage.cards.c.CreatureBond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Creature Bond", 55, Rarity.COMMON, mage.cards.c.CreatureBond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crystal Rod", 235, Rarity.UNCOMMON, mage.cards.c.CrystalRod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crystal Rod", 532, Rarity.UNCOMMON, mage.cards.c.CrystalRod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cursed Land", 393, Rarity.UNCOMMON, mage.cards.c.CursedLand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cursed Land", 96, Rarity.UNCOMMON, mage.cards.c.CursedLand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cyclopean Tomb", 236, Rarity.RARE, mage.cards.c.CyclopeanTomb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cyclopean Tomb", 533, Rarity.RARE, mage.cards.c.CyclopeanTomb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dark Ritual", 394, Rarity.COMMON, mage.cards.d.DarkRitual.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dark Ritual", 97, Rarity.COMMON, mage.cards.d.DarkRitual.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Death Ward", 17, Rarity.COMMON, mage.cards.d.DeathWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Death Ward", 314, Rarity.COMMON, mage.cards.d.DeathWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deathgrip", 395, Rarity.UNCOMMON, mage.cards.d.Deathgrip.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deathgrip", 98, Rarity.UNCOMMON, mage.cards.d.Deathgrip.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deathlace", 396, Rarity.RARE, mage.cards.d.Deathlace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deathlace", 99, Rarity.RARE, mage.cards.d.Deathlace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demonic Hordes", 100, Rarity.RARE, mage.cards.d.DemonicHordes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demonic Hordes", 397, Rarity.RARE, mage.cards.d.DemonicHordes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demonic Tutor", 101, Rarity.UNCOMMON, mage.cards.d.DemonicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demonic Tutor", 398, Rarity.UNCOMMON, mage.cards.d.DemonicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dingus Egg", 237, Rarity.RARE, mage.cards.d.DingusEgg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dingus Egg", 534, Rarity.RARE, mage.cards.d.DingusEgg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disenchant", 18, Rarity.COMMON, mage.cards.d.Disenchant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disenchant", 315, Rarity.COMMON, mage.cards.d.Disenchant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disintegrate", 137, Rarity.COMMON, mage.cards.d.Disintegrate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disintegrate", 434, Rarity.COMMON, mage.cards.d.Disintegrate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disrupting Scepter", 238, Rarity.RARE, mage.cards.d.DisruptingScepter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disrupting Scepter", 535, Rarity.RARE, mage.cards.d.DisruptingScepter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragon Whelp", 138, Rarity.UNCOMMON, mage.cards.d.DragonWhelp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragon Whelp", 435, Rarity.UNCOMMON, mage.cards.d.DragonWhelp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drain Life", 102, Rarity.COMMON, mage.cards.d.DrainLife.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drain Life", 399, Rarity.COMMON, mage.cards.d.DrainLife.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drain Power", 353, Rarity.RARE, mage.cards.d.DrainPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drain Power", 56, Rarity.RARE, mage.cards.d.DrainPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drudge Skeletons", 103, Rarity.COMMON, mage.cards.d.DrudgeSkeletons.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drudge Skeletons", 400, Rarity.COMMON, mage.cards.d.DrudgeSkeletons.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dwarven Demolition Team", 139, Rarity.UNCOMMON, mage.cards.d.DwarvenDemolitionTeam.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dwarven Demolition Team", 436, Rarity.UNCOMMON, mage.cards.d.DwarvenDemolitionTeam.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dwarven Warriors", 140, Rarity.COMMON, mage.cards.d.DwarvenWarriors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dwarven Warriors", 437, Rarity.COMMON, mage.cards.d.DwarvenWarriors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Earth Elemental", 141, Rarity.UNCOMMON, mage.cards.e.EarthElemental.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Earth Elemental", 438, Rarity.UNCOMMON, mage.cards.e.EarthElemental.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Earthquake", 142, Rarity.RARE, mage.cards.e.Earthquake.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Earthquake", 439, Rarity.RARE, mage.cards.e.Earthquake.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elvish Archers", 187, Rarity.RARE, mage.cards.e.ElvishArchers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elvish Archers", 484, Rarity.RARE, mage.cards.e.ElvishArchers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evil Presence", 104, Rarity.UNCOMMON, mage.cards.e.EvilPresence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evil Presence", 401, Rarity.UNCOMMON, mage.cards.e.EvilPresence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("False Orders", 143, Rarity.COMMON, mage.cards.f.FalseOrders.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("False Orders", 440, Rarity.COMMON, mage.cards.f.FalseOrders.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Farmstead", 19, Rarity.RARE, mage.cards.f.Farmstead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Farmstead", 316, Rarity.RARE, mage.cards.f.Farmstead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fastbond", 188, Rarity.RARE, mage.cards.f.Fastbond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fastbond", 485, Rarity.RARE, mage.cards.f.Fastbond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fear", 105, Rarity.COMMON, mage.cards.f.Fear.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fear", 402, Rarity.COMMON, mage.cards.f.Fear.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feedback", 354, Rarity.UNCOMMON, mage.cards.f.Feedback.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feedback", 57, Rarity.UNCOMMON, mage.cards.f.Feedback.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fire Elemental", 144, Rarity.UNCOMMON, mage.cards.f.FireElemental.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fire Elemental", 441, Rarity.UNCOMMON, mage.cards.f.FireElemental.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fireball", 145, Rarity.COMMON, mage.cards.f.Fireball.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fireball", 442, Rarity.COMMON, mage.cards.f.Fireball.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firebreathing", 146, Rarity.COMMON, mage.cards.f.Firebreathing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firebreathing", 443, Rarity.COMMON, mage.cards.f.Firebreathing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flashfires", 147, Rarity.UNCOMMON, mage.cards.f.Flashfires.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flashfires", 444, Rarity.UNCOMMON, mage.cards.f.Flashfires.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flight", 355, Rarity.COMMON, mage.cards.f.Flight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flight", 58, Rarity.COMMON, mage.cards.f.Flight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fog", 189, Rarity.COMMON, mage.cards.f.Fog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fog", 486, Rarity.COMMON, mage.cards.f.Fog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Force of Nature", 190, Rarity.RARE, mage.cards.f.ForceOfNature.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Force of Nature", 487, Rarity.RARE, mage.cards.f.ForceOfNature.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forcefield", 239, Rarity.RARE, mage.cards.f.Forcefield.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forcefield", 536, Rarity.RARE, mage.cards.f.Forcefield.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 295, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 296, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 297, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 592, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 593, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 594, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fork", 148, Rarity.RARE, mage.cards.f.Fork.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fork", 445, Rarity.RARE, mage.cards.f.Fork.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frozen Shade", 106, Rarity.COMMON, mage.cards.f.FrozenShade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frozen Shade", 403, Rarity.COMMON, mage.cards.f.FrozenShade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fungusaur", 191, Rarity.RARE, mage.cards.f.Fungusaur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fungusaur", 488, Rarity.RARE, mage.cards.f.Fungusaur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gaea's Liege", 192, Rarity.RARE, mage.cards.g.GaeasLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gaea's Liege", 489, Rarity.RARE, mage.cards.g.GaeasLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gauntlet of Might", 240, Rarity.RARE, mage.cards.g.GauntletOfMight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gauntlet of Might", 537, Rarity.RARE, mage.cards.g.GauntletOfMight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giant Growth", 193, Rarity.COMMON, mage.cards.g.GiantGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giant Growth", 490, Rarity.COMMON, mage.cards.g.GiantGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giant Spider", 194, Rarity.COMMON, mage.cards.g.GiantSpider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giant Spider", 491, Rarity.COMMON, mage.cards.g.GiantSpider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glasses of Urza", 241, Rarity.UNCOMMON, mage.cards.g.GlassesOfUrza.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glasses of Urza", 538, Rarity.UNCOMMON, mage.cards.g.GlassesOfUrza.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gloom", 107, Rarity.UNCOMMON, mage.cards.g.Gloom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gloom", 404, Rarity.UNCOMMON, mage.cards.g.Gloom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Balloon Brigade", 149, Rarity.UNCOMMON, mage.cards.g.GoblinBalloonBrigade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Balloon Brigade", 446, Rarity.UNCOMMON, mage.cards.g.GoblinBalloonBrigade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin King", 150, Rarity.RARE, mage.cards.g.GoblinKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin King", 447, Rarity.RARE, mage.cards.g.GoblinKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Granite Gargoyle", 151, Rarity.RARE, mage.cards.g.GraniteGargoyle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Granite Gargoyle", 448, Rarity.RARE, mage.cards.g.GraniteGargoyle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gray Ogre", 152, Rarity.COMMON, mage.cards.g.GrayOgre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gray Ogre", 449, Rarity.COMMON, mage.cards.g.GrayOgre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Green Ward", 20, Rarity.UNCOMMON, mage.cards.g.GreenWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Green Ward", 317, Rarity.UNCOMMON, mage.cards.g.GreenWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grizzly Bears", 195, Rarity.COMMON, mage.cards.g.GrizzlyBears.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grizzly Bears", 492, Rarity.COMMON, mage.cards.g.GrizzlyBears.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guardian Angel", 21, Rarity.COMMON, mage.cards.g.GuardianAngel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guardian Angel", 318, Rarity.COMMON, mage.cards.g.GuardianAngel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Healing Salve", 22, Rarity.COMMON, mage.cards.h.HealingSalve.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Healing Salve", 319, Rarity.COMMON, mage.cards.h.HealingSalve.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Helm of Chatzuk", 242, Rarity.RARE, mage.cards.h.HelmOfChatzuk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Helm of Chatzuk", 539, Rarity.RARE, mage.cards.h.HelmOfChatzuk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hill Giant", 153, Rarity.COMMON, mage.cards.h.HillGiant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hill Giant", 450, Rarity.COMMON, mage.cards.h.HillGiant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Holy Armor", 23, Rarity.COMMON, mage.cards.h.HolyArmor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Holy Armor", 320, Rarity.COMMON, mage.cards.h.HolyArmor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Holy Strength", 24, Rarity.COMMON, mage.cards.h.HolyStrength.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Holy Strength", 321, Rarity.COMMON, mage.cards.h.HolyStrength.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Howl from Beyond", 108, Rarity.COMMON, mage.cards.h.HowlFromBeyond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Howl from Beyond", 405, Rarity.COMMON, mage.cards.h.HowlFromBeyond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Howling Mine", 244, Rarity.RARE, mage.cards.h.HowlingMine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Howling Mine", 541, Rarity.RARE, mage.cards.h.HowlingMine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hurloon Minotaur", 154, Rarity.COMMON, mage.cards.h.HurloonMinotaur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hurloon Minotaur", 451, Rarity.COMMON, mage.cards.h.HurloonMinotaur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hurricane", 196, Rarity.UNCOMMON, mage.cards.h.Hurricane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hurricane", 493, Rarity.UNCOMMON, mage.cards.h.Hurricane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hypnotic Specter", 109, Rarity.UNCOMMON, mage.cards.h.HypnoticSpecter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hypnotic Specter", 406, Rarity.UNCOMMON, mage.cards.h.HypnoticSpecter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ice Storm", 197, Rarity.UNCOMMON, mage.cards.i.IceStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ice Storm", 494, Rarity.UNCOMMON, mage.cards.i.IceStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icy Manipulator", 245, Rarity.UNCOMMON, mage.cards.i.IcyManipulator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icy Manipulator", 542, Rarity.UNCOMMON, mage.cards.i.IcyManipulator.class, NON_FULL_USE_VARIOUS));
        //cards.add(new SetCardInfo("Illusionary Mask", 246, Rarity.RARE, mage.cards.i.IllusionaryMask.class, NON_FULL_USE_VARIOUS));
        //cards.add(new SetCardInfo("Illusionary Mask", 543, Rarity.RARE, mage.cards.i.IllusionaryMask.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Instill Energy", 198, Rarity.UNCOMMON, mage.cards.i.InstillEnergy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Instill Energy", 495, Rarity.UNCOMMON, mage.cards.i.InstillEnergy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Invisibility", 356, Rarity.COMMON, mage.cards.i.Invisibility.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Invisibility", 59, Rarity.COMMON, mage.cards.i.Invisibility.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Iron Star", 247, Rarity.UNCOMMON, mage.cards.i.IronStar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Iron Star", 544, Rarity.UNCOMMON, mage.cards.i.IronStar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ironclaw Orcs", 155, Rarity.COMMON, mage.cards.i.IronclawOrcs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ironclaw Orcs", 452, Rarity.COMMON, mage.cards.i.IronclawOrcs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ironroot Treefolk", 199, Rarity.COMMON, mage.cards.i.IronrootTreefolk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ironroot Treefolk", 496, Rarity.COMMON, mage.cards.i.IronrootTreefolk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island Sanctuary", 25, Rarity.RARE, mage.cards.i.IslandSanctuary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island Sanctuary", 322, Rarity.RARE, mage.cards.i.IslandSanctuary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 286, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 287, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 288, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 583, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 584, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 585, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivory Cup", 248, Rarity.UNCOMMON, mage.cards.i.IvoryCup.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivory Cup", 545, Rarity.UNCOMMON, mage.cards.i.IvoryCup.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jade Monolith", 249, Rarity.RARE, mage.cards.j.JadeMonolith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jade Monolith", 546, Rarity.RARE, mage.cards.j.JadeMonolith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jade Statue", 250, Rarity.UNCOMMON, mage.cards.j.JadeStatue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jade Statue", 547, Rarity.UNCOMMON, mage.cards.j.JadeStatue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jayemdae Tome", 251, Rarity.RARE, mage.cards.j.JayemdaeTome.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jayemdae Tome", 548, Rarity.RARE, mage.cards.j.JayemdaeTome.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Juggernaut", 252, Rarity.UNCOMMON, mage.cards.j.Juggernaut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Juggernaut", 549, Rarity.UNCOMMON, mage.cards.j.Juggernaut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jump", 357, Rarity.COMMON, mage.cards.j.Jump.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jump", 60, Rarity.COMMON, mage.cards.j.Jump.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karma", 26, Rarity.UNCOMMON, mage.cards.k.Karma.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karma", 323, Rarity.UNCOMMON, mage.cards.k.Karma.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keldon Warlord", 156, Rarity.UNCOMMON, mage.cards.k.KeldonWarlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keldon Warlord", 453, Rarity.UNCOMMON, mage.cards.k.KeldonWarlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kormus Bell", 253, Rarity.RARE, mage.cards.k.KormusBell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kormus Bell", 550, Rarity.RARE, mage.cards.k.KormusBell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kudzu", 200, Rarity.RARE, mage.cards.k.Kudzu.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kudzu", 497, Rarity.RARE, mage.cards.k.Kudzu.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lance", 27, Rarity.UNCOMMON, mage.cards.l.Lance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lance", 324, Rarity.UNCOMMON, mage.cards.l.Lance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ley Druid", 201, Rarity.UNCOMMON, mage.cards.l.LeyDruid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ley Druid", 498, Rarity.UNCOMMON, mage.cards.l.LeyDruid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Library of Leng", 254, Rarity.UNCOMMON, mage.cards.l.LibraryOfLeng.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Library of Leng", 551, Rarity.UNCOMMON, mage.cards.l.LibraryOfLeng.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lich", 110, Rarity.RARE, mage.cards.l.Lich.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lich", 407, Rarity.RARE, mage.cards.l.Lich.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lifeforce", 202, Rarity.UNCOMMON, mage.cards.l.Lifeforce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lifeforce", 499, Rarity.UNCOMMON, mage.cards.l.Lifeforce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lifelace", 203, Rarity.RARE, mage.cards.l.Lifelace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lifelace", 500, Rarity.RARE, mage.cards.l.Lifelace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lifetap", 358, Rarity.UNCOMMON, mage.cards.l.Lifetap.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lifetap", 61, Rarity.UNCOMMON, mage.cards.l.Lifetap.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 157, Rarity.COMMON, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 454, Rarity.COMMON, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Living Artifact", 204, Rarity.RARE, mage.cards.l.LivingArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Living Artifact", 501, Rarity.RARE, mage.cards.l.LivingArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Living Lands", 205, Rarity.RARE, mage.cards.l.LivingLands.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Living Lands", 502, Rarity.RARE, mage.cards.l.LivingLands.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Living Wall", 255, Rarity.UNCOMMON, mage.cards.l.LivingWall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Living Wall", 552, Rarity.UNCOMMON, mage.cards.l.LivingWall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Llanowar Elves", 206, Rarity.COMMON, mage.cards.l.LlanowarElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Llanowar Elves", 503, Rarity.COMMON, mage.cards.l.LlanowarElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of Atlantis", 359, Rarity.RARE, mage.cards.l.LordOfAtlantis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of Atlantis", 62, Rarity.RARE, mage.cards.l.LordOfAtlantis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of the Pit", 111, Rarity.RARE, mage.cards.l.LordOfThePit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of the Pit", 408, Rarity.RARE, mage.cards.l.LordOfThePit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lure", 207, Rarity.UNCOMMON, mage.cards.l.Lure.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lure", 504, Rarity.UNCOMMON, mage.cards.l.Lure.class, NON_FULL_USE_VARIOUS));
        //cards.add(new SetCardInfo("Magical Hack", 360, Rarity.RARE, mage.cards.m.MagicalHack.class, NON_FULL_USE_VARIOUS));
        //cards.add(new SetCardInfo("Magical Hack", 63, Rarity.RARE, mage.cards.m.MagicalHack.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mahamoti Djinn", 361, Rarity.RARE, mage.cards.m.MahamotiDjinn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mahamoti Djinn", 64, Rarity.RARE, mage.cards.m.MahamotiDjinn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Flare", 158, Rarity.RARE, mage.cards.m.ManaFlare.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Flare", 455, Rarity.RARE, mage.cards.m.ManaFlare.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Short", 362, Rarity.RARE, mage.cards.m.ManaShort.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Short", 65, Rarity.RARE, mage.cards.m.ManaShort.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Vault", 256, Rarity.RARE, mage.cards.m.ManaVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Vault", 553, Rarity.RARE, mage.cards.m.ManaVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Manabarbs", 159, Rarity.RARE, mage.cards.m.Manabarbs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Manabarbs", 456, Rarity.RARE, mage.cards.m.Manabarbs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meekstone", 257, Rarity.RARE, mage.cards.m.Meekstone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meekstone", 554, Rarity.RARE, mage.cards.m.Meekstone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Merfolk of the Pearl Trident", 363, Rarity.COMMON, mage.cards.m.MerfolkOfThePearlTrident.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Merfolk of the Pearl Trident", 66, Rarity.COMMON, mage.cards.m.MerfolkOfThePearlTrident.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mesa Pegasus", 28, Rarity.COMMON, mage.cards.m.MesaPegasus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mesa Pegasus", 325, Rarity.COMMON, mage.cards.m.MesaPegasus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mind Twist", 112, Rarity.RARE, mage.cards.m.MindTwist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mind Twist", 409, Rarity.RARE, mage.cards.m.MindTwist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mons's Goblin Raiders", 160, Rarity.COMMON, mage.cards.m.MonssGoblinRaiders.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mons's Goblin Raiders", 457, Rarity.COMMON, mage.cards.m.MonssGoblinRaiders.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 292, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 293, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 294, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 589, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 590, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 591, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Emerald", 258, Rarity.RARE, mage.cards.m.MoxEmerald.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Emerald", 555, Rarity.RARE, mage.cards.m.MoxEmerald.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Jet", 259, Rarity.RARE, mage.cards.m.MoxJet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Jet", 556, Rarity.RARE, mage.cards.m.MoxJet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Pearl", 260, Rarity.RARE, mage.cards.m.MoxPearl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Pearl", 557, Rarity.RARE, mage.cards.m.MoxPearl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Ruby", 261, Rarity.RARE, mage.cards.m.MoxRuby.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Ruby", 558, Rarity.RARE, mage.cards.m.MoxRuby.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Sapphire", 262, Rarity.RARE, mage.cards.m.MoxSapphire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Sapphire", 559, Rarity.RARE, mage.cards.m.MoxSapphire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Natural Selection", 208, Rarity.RARE, mage.cards.n.NaturalSelection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Natural Selection", 505, Rarity.RARE, mage.cards.n.NaturalSelection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nether Shadow", 113, Rarity.RARE, mage.cards.n.NetherShadow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nether Shadow", 410, Rarity.RARE, mage.cards.n.NetherShadow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nettling Imp", 114, Rarity.UNCOMMON, mage.cards.n.NettlingImp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nettling Imp", 411, Rarity.UNCOMMON, mage.cards.n.NettlingImp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral's Disk", 263, Rarity.RARE, mage.cards.n.NevinyrralsDisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral's Disk", 560, Rarity.RARE, mage.cards.n.NevinyrralsDisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nightmare", 115, Rarity.RARE, mage.cards.n.Nightmare.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nightmare", 412, Rarity.RARE, mage.cards.n.Nightmare.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Northern Paladin", 29, Rarity.RARE, mage.cards.n.NorthernPaladin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Northern Paladin", 326, Rarity.RARE, mage.cards.n.NorthernPaladin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obsianus Golem", 264, Rarity.UNCOMMON, mage.cards.o.ObsianusGolem.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obsianus Golem", 561, Rarity.UNCOMMON, mage.cards.o.ObsianusGolem.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orcish Artillery", 161, Rarity.UNCOMMON, mage.cards.o.OrcishArtillery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orcish Artillery", 458, Rarity.UNCOMMON, mage.cards.o.OrcishArtillery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orcish Oriflamme", 162, Rarity.UNCOMMON, mage.cards.o.OrcishOriflamme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orcish Oriflamme", 459, Rarity.UNCOMMON, mage.cards.o.OrcishOriflamme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Paralyze", 116, Rarity.COMMON, mage.cards.p.Paralyze.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Paralyze", 413, Rarity.COMMON, mage.cards.p.Paralyze.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pearled Unicorn", 30, Rarity.COMMON, mage.cards.p.PearledUnicorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pearled Unicorn", 327, Rarity.COMMON, mage.cards.p.PearledUnicorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Personal Incarnation", 31, Rarity.RARE, mage.cards.p.PersonalIncarnation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Personal Incarnation", 328, Rarity.RARE, mage.cards.p.PersonalIncarnation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pestilence", 117, Rarity.COMMON, mage.cards.p.Pestilence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pestilence", 414, Rarity.COMMON, mage.cards.p.Pestilence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phantasmal Forces", 364, Rarity.UNCOMMON, mage.cards.p.PhantasmalForces.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phantasmal Forces", 67, Rarity.UNCOMMON, mage.cards.p.PhantasmalForces.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phantasmal Terrain", 365, Rarity.COMMON, mage.cards.p.PhantasmalTerrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phantasmal Terrain", 68, Rarity.COMMON, mage.cards.p.PhantasmalTerrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phantom Monster", 366, Rarity.UNCOMMON, mage.cards.p.PhantomMonster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phantom Monster", 69, Rarity.UNCOMMON, mage.cards.p.PhantomMonster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pirate Ship", 367, Rarity.RARE, mage.cards.p.PirateShip.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pirate Ship", 70, Rarity.RARE, mage.cards.p.PirateShip.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plague Rats", 118, Rarity.COMMON, mage.cards.p.PlagueRats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plague Rats", 415, Rarity.COMMON, mage.cards.p.PlagueRats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 283, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 284, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 285, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 580, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 581, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 582, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plateau", 275, Rarity.RARE, mage.cards.p.Plateau.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plateau", 572, Rarity.RARE, mage.cards.p.Plateau.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Power Leak", 368, Rarity.COMMON, mage.cards.p.PowerLeak.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Power Leak", 71, Rarity.COMMON, mage.cards.p.PowerLeak.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Power Sink", 369, Rarity.COMMON, mage.cards.p.PowerSink.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Power Sink", 72, Rarity.COMMON, mage.cards.p.PowerSink.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Power Surge", 163, Rarity.RARE, mage.cards.p.PowerSurge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Power Surge", 460, Rarity.RARE, mage.cards.p.PowerSurge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prodigal Sorcerer", 370, Rarity.COMMON, mage.cards.p.ProdigalSorcerer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prodigal Sorcerer", 73, Rarity.COMMON, mage.cards.p.ProdigalSorcerer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Psionic Blast", 371, Rarity.UNCOMMON, mage.cards.p.PsionicBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Psionic Blast", 74, Rarity.UNCOMMON, mage.cards.p.PsionicBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Psychic Venom", 372, Rarity.COMMON, mage.cards.p.PsychicVenom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Psychic Venom", 75, Rarity.COMMON, mage.cards.p.PsychicVenom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Purelace", 32, Rarity.RARE, mage.cards.p.Purelace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Purelace", 329, Rarity.RARE, mage.cards.p.Purelace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raging River", 164, Rarity.RARE, mage.cards.r.RagingRiver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raging River", 461, Rarity.RARE, mage.cards.r.RagingRiver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raise Dead", 119, Rarity.COMMON, mage.cards.r.RaiseDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raise Dead", 416, Rarity.COMMON, mage.cards.r.RaiseDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Red Elemental Blast", 165, Rarity.COMMON, mage.cards.r.RedElementalBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Red Elemental Blast", 462, Rarity.COMMON, mage.cards.r.RedElementalBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Red Ward", 33, Rarity.UNCOMMON, mage.cards.r.RedWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Red Ward", 330, Rarity.UNCOMMON, mage.cards.r.RedWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regeneration", 209, Rarity.COMMON, mage.cards.r.Regeneration.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regeneration", 506, Rarity.COMMON, mage.cards.r.Regeneration.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regrowth", 210, Rarity.UNCOMMON, mage.cards.r.Regrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regrowth", 507, Rarity.UNCOMMON, mage.cards.r.Regrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Resurrection", 331, Rarity.UNCOMMON, mage.cards.r.Resurrection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Resurrection", 34, Rarity.UNCOMMON, mage.cards.r.Resurrection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reverse Damage", 332, Rarity.RARE, mage.cards.r.ReverseDamage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reverse Damage", 35, Rarity.RARE, mage.cards.r.ReverseDamage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Righteousness", 333, Rarity.RARE, mage.cards.r.Righteousness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Righteousness", 36, Rarity.RARE, mage.cards.r.Righteousness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Roc of Kher Ridges", 166, Rarity.RARE, mage.cards.r.RocOfKherRidges.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Roc of Kher Ridges", 463, Rarity.RARE, mage.cards.r.RocOfKherRidges.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rock Hydra", 167, Rarity.RARE, mage.cards.r.RockHydra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rock Hydra", 464, Rarity.RARE, mage.cards.r.RockHydra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rod of Ruin", 265, Rarity.UNCOMMON, mage.cards.r.RodOfRuin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rod of Ruin", 562, Rarity.UNCOMMON, mage.cards.r.RodOfRuin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Royal Assassin", 120, Rarity.RARE, mage.cards.r.RoyalAssassin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Royal Assassin", 417, Rarity.RARE, mage.cards.r.RoyalAssassin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sacrifice", 121, Rarity.UNCOMMON, mage.cards.s.Sacrifice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sacrifice", 418, Rarity.UNCOMMON, mage.cards.s.Sacrifice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samite Healer", 334, Rarity.COMMON, mage.cards.s.SamiteHealer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samite Healer", 37, Rarity.COMMON, mage.cards.s.SamiteHealer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savannah Lions", 335, Rarity.RARE, mage.cards.s.SavannahLions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savannah Lions", 38, Rarity.RARE, mage.cards.s.SavannahLions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savannah", 276, Rarity.RARE, mage.cards.s.Savannah.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savannah", 573, Rarity.RARE, mage.cards.s.Savannah.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scathe Zombies", 122, Rarity.COMMON, mage.cards.s.ScatheZombies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scathe Zombies", 419, Rarity.COMMON, mage.cards.s.ScatheZombies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scavenging Ghoul", 123, Rarity.UNCOMMON, mage.cards.s.ScavengingGhoul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scavenging Ghoul", 420, Rarity.UNCOMMON, mage.cards.s.ScavengingGhoul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scrubland", 277, Rarity.RARE, mage.cards.s.Scrubland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scrubland", 574, Rarity.RARE, mage.cards.s.Scrubland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scryb Sprites", 211, Rarity.COMMON, mage.cards.s.ScrybSprites.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scryb Sprites", 508, Rarity.COMMON, mage.cards.s.ScrybSprites.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sea Serpent", 373, Rarity.COMMON, mage.cards.s.SeaSerpent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sea Serpent", 76, Rarity.COMMON, mage.cards.s.SeaSerpent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sedge Troll", 168, Rarity.RARE, mage.cards.s.SedgeTroll.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sedge Troll", 465, Rarity.RARE, mage.cards.s.SedgeTroll.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sengir Vampire", 124, Rarity.UNCOMMON, mage.cards.s.SengirVampire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sengir Vampire", 421, Rarity.UNCOMMON, mage.cards.s.SengirVampire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serra Angel", 336, Rarity.UNCOMMON, mage.cards.s.SerraAngel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serra Angel", 39, Rarity.UNCOMMON, mage.cards.s.SerraAngel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shanodin Dryads", 212, Rarity.COMMON, mage.cards.s.ShanodinDryads.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shanodin Dryads", 509, Rarity.COMMON, mage.cards.s.ShanodinDryads.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shatter", 169, Rarity.COMMON, mage.cards.s.Shatter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shatter", 466, Rarity.COMMON, mage.cards.s.Shatter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shivan Dragon", 170, Rarity.RARE, mage.cards.s.ShivanDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shivan Dragon", 467, Rarity.RARE, mage.cards.s.ShivanDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simulacrum", 125, Rarity.UNCOMMON, mage.cards.s.Simulacrum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simulacrum", 422, Rarity.UNCOMMON, mage.cards.s.Simulacrum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sinkhole", 126, Rarity.COMMON, mage.cards.s.Sinkhole.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sinkhole", 423, Rarity.COMMON, mage.cards.s.Sinkhole.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Siren's Call", 374, Rarity.UNCOMMON, mage.cards.s.SirensCall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Siren's Call", 77, Rarity.UNCOMMON, mage.cards.s.SirensCall.class, NON_FULL_USE_VARIOUS));
        //cards.add(new SetCardInfo("Sleight of Mind", 375, Rarity.RARE, mage.cards.s.SleightOfMind.class, NON_FULL_USE_VARIOUS));
        //cards.add(new SetCardInfo("Sleight of Mind", 78, Rarity.RARE, mage.cards.s.SleightOfMind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smoke", 171, Rarity.RARE, mage.cards.s.Smoke.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smoke", 468, Rarity.RARE, mage.cards.s.Smoke.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 131, Rarity.COMMON, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 266, Rarity.UNCOMMON, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 428, Rarity.COMMON, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 563, Rarity.UNCOMMON, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul Net", 267, Rarity.UNCOMMON, mage.cards.s.SoulNet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul Net", 564, Rarity.UNCOMMON, mage.cards.s.SoulNet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spell Blast", 376, Rarity.COMMON, mage.cards.s.SpellBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spell Blast", 79, Rarity.COMMON, mage.cards.s.SpellBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stasis", 377, Rarity.RARE, mage.cards.s.Stasis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stasis", 80, Rarity.RARE, mage.cards.s.Stasis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steal Artifact", 378, Rarity.UNCOMMON, mage.cards.s.StealArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steal Artifact", 81, Rarity.UNCOMMON, mage.cards.s.StealArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stone Giant", 172, Rarity.UNCOMMON, mage.cards.s.StoneGiant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stone Giant", 469, Rarity.UNCOMMON, mage.cards.s.StoneGiant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stone Rain", 173, Rarity.COMMON, mage.cards.s.StoneRain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stone Rain", 470, Rarity.COMMON, mage.cards.s.StoneRain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stream of Life", 213, Rarity.COMMON, mage.cards.s.StreamOfLife.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stream of Life", 510, Rarity.COMMON, mage.cards.s.StreamOfLife.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sunglasses of Urza", 268, Rarity.RARE, mage.cards.s.SunglassesOfUrza.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sunglasses of Urza", 565, Rarity.RARE, mage.cards.s.SunglassesOfUrza.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 289, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 290, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 291, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 586, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 587, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 588, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 337, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 40, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Taiga", 278, Rarity.RARE, mage.cards.t.Taiga.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Taiga", 575, Rarity.RARE, mage.cards.t.Taiga.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terror", 127, Rarity.COMMON, mage.cards.t.Terror.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terror", 424, Rarity.COMMON, mage.cards.t.Terror.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Hive", 243, Rarity.RARE, mage.cards.t.TheHive.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Hive", 540, Rarity.RARE, mage.cards.t.TheHive.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thicket Basilisk", 214, Rarity.UNCOMMON, mage.cards.t.ThicketBasilisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thicket Basilisk", 511, Rarity.UNCOMMON, mage.cards.t.ThicketBasilisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thoughtlace", 379, Rarity.RARE, mage.cards.t.Thoughtlace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thoughtlace", 82, Rarity.RARE, mage.cards.t.Thoughtlace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Throne of Bone", 269, Rarity.UNCOMMON, mage.cards.t.ThroneOfBone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Throne of Bone", 566, Rarity.UNCOMMON, mage.cards.t.ThroneOfBone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Timber Wolves", 215, Rarity.RARE, mage.cards.t.TimberWolves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Timber Wolves", 512, Rarity.RARE, mage.cards.t.TimberWolves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Vault", 270, Rarity.RARE, mage.cards.t.TimeVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Vault", 567, Rarity.RARE, mage.cards.t.TimeVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Walk", 380, Rarity.RARE, mage.cards.t.TimeWalk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Walk", 83, Rarity.RARE, mage.cards.t.TimeWalk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Timetwister", 381, Rarity.RARE, mage.cards.t.Timetwister.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Timetwister", 84, Rarity.RARE, mage.cards.t.Timetwister.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tranquility", 216, Rarity.COMMON, mage.cards.t.Tranquility.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tranquility", 513, Rarity.COMMON, mage.cards.t.Tranquility.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tropical Island", 279, Rarity.RARE, mage.cards.t.TropicalIsland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tropical Island", 576, Rarity.RARE, mage.cards.t.TropicalIsland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tsunami", 217, Rarity.UNCOMMON, mage.cards.t.Tsunami.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tsunami", 514, Rarity.UNCOMMON, mage.cards.t.Tsunami.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tundra", 280, Rarity.RARE, mage.cards.t.Tundra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tundra", 577, Rarity.RARE, mage.cards.t.Tundra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tunnel", 174, Rarity.UNCOMMON, mage.cards.t.Tunnel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tunnel", 471, Rarity.UNCOMMON, mage.cards.t.Tunnel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Twiddle", 382, Rarity.COMMON, mage.cards.t.Twiddle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Twiddle", 85, Rarity.COMMON, mage.cards.t.Twiddle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Two-Headed Giant of Foriys", 175, Rarity.RARE, mage.cards.t.TwoHeadedGiantOfForiys.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Two-Headed Giant of Foriys", 472, Rarity.RARE, mage.cards.t.TwoHeadedGiantOfForiys.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Underground Sea", 281, Rarity.RARE, mage.cards.u.UndergroundSea.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Underground Sea", 578, Rarity.RARE, mage.cards.u.UndergroundSea.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unholy Strength", 128, Rarity.COMMON, mage.cards.u.UnholyStrength.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unholy Strength", 425, Rarity.COMMON, mage.cards.u.UnholyStrength.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unsummon", 383, Rarity.COMMON, mage.cards.u.Unsummon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unsummon", 86, Rarity.COMMON, mage.cards.u.Unsummon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Uthden Troll", 176, Rarity.UNCOMMON, mage.cards.u.UthdenTroll.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Uthden Troll", 473, Rarity.UNCOMMON, mage.cards.u.UthdenTroll.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Verduran Enchantress", 218, Rarity.RARE, mage.cards.v.VerduranEnchantress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Verduran Enchantress", 515, Rarity.RARE, mage.cards.v.VerduranEnchantress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vesuvan Doppelganger", 384, Rarity.RARE, mage.cards.v.VesuvanDoppelganger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vesuvan Doppelganger", 87, Rarity.RARE, mage.cards.v.VesuvanDoppelganger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Veteran Bodyguard", 338, Rarity.RARE, mage.cards.v.VeteranBodyguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Veteran Bodyguard", 41, Rarity.RARE, mage.cards.v.VeteranBodyguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Volcanic Eruption", 385, Rarity.RARE, mage.cards.v.VolcanicEruption.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Volcanic Eruption", 88, Rarity.RARE, mage.cards.v.VolcanicEruption.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Volcanic Island", 282, Rarity.RARE, mage.cards.v.VolcanicIsland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Volcanic Island", 579, Rarity.RARE, mage.cards.v.VolcanicIsland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Air", 386, Rarity.UNCOMMON, mage.cards.w.WallOfAir.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Air", 89, Rarity.UNCOMMON, mage.cards.w.WallOfAir.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Bone", 129, Rarity.UNCOMMON, mage.cards.w.WallOfBone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Bone", 426, Rarity.UNCOMMON, mage.cards.w.WallOfBone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Brambles", 219, Rarity.UNCOMMON, mage.cards.w.WallOfBrambles.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Brambles", 516, Rarity.UNCOMMON, mage.cards.w.WallOfBrambles.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Fire", 177, Rarity.UNCOMMON, mage.cards.w.WallOfFire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Fire", 474, Rarity.UNCOMMON, mage.cards.w.WallOfFire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Ice", 220, Rarity.UNCOMMON, mage.cards.w.WallOfIce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Ice", 517, Rarity.UNCOMMON, mage.cards.w.WallOfIce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Stone", 178, Rarity.UNCOMMON, mage.cards.w.WallOfStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Stone", 475, Rarity.UNCOMMON, mage.cards.w.WallOfStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Swords", 339, Rarity.UNCOMMON, mage.cards.w.WallOfSwords.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Swords", 42, Rarity.UNCOMMON, mage.cards.w.WallOfSwords.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Water", 387, Rarity.UNCOMMON, mage.cards.w.WallOfWater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Water", 90, Rarity.UNCOMMON, mage.cards.w.WallOfWater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Wood", 221, Rarity.COMMON, mage.cards.w.WallOfWood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Wood", 518, Rarity.COMMON, mage.cards.w.WallOfWood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wanderlust", 222, Rarity.UNCOMMON, mage.cards.w.Wanderlust.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wanderlust", 519, Rarity.UNCOMMON, mage.cards.w.Wanderlust.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("War Mammoth", 223, Rarity.COMMON, mage.cards.w.WarMammoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("War Mammoth", 520, Rarity.COMMON, mage.cards.w.WarMammoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warp Artifact", 130, Rarity.RARE, mage.cards.w.WarpArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warp Artifact", 427, Rarity.RARE, mage.cards.w.WarpArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Water Elemental", 388, Rarity.UNCOMMON, mage.cards.w.WaterElemental.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Water Elemental", 91, Rarity.UNCOMMON, mage.cards.w.WaterElemental.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Web", 224, Rarity.RARE, mage.cards.w.Web.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Web", 521, Rarity.RARE, mage.cards.w.Web.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wheel of Fortune", 179, Rarity.RARE, mage.cards.w.WheelOfFortune.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wheel of Fortune", 476, Rarity.RARE, mage.cards.w.WheelOfFortune.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("White Knight", 340, Rarity.UNCOMMON, mage.cards.w.WhiteKnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("White Knight", 43, Rarity.UNCOMMON, mage.cards.w.WhiteKnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("White Ward", 341, Rarity.UNCOMMON, mage.cards.w.WhiteWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("White Ward", 44, Rarity.UNCOMMON, mage.cards.w.WhiteWard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wild Growth", 225, Rarity.COMMON, mage.cards.w.WildGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wild Growth", 522, Rarity.COMMON, mage.cards.w.WildGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Will-o'-the-Wisp", 132, Rarity.RARE, mage.cards.w.WillOTheWisp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Will-o'-the-Wisp", 429, Rarity.RARE, mage.cards.w.WillOTheWisp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Winter Orb", 271, Rarity.RARE, mage.cards.w.WinterOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Winter Orb", 568, Rarity.RARE, mage.cards.w.WinterOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wooden Sphere", 272, Rarity.UNCOMMON, mage.cards.w.WoodenSphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wooden Sphere", 569, Rarity.UNCOMMON, mage.cards.w.WoodenSphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Word of Command", 133, Rarity.RARE, mage.cards.w.WordOfCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Word of Command", 430, Rarity.RARE, mage.cards.w.WordOfCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrath of God", 342, Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrath of God", 45, Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zombie Master", 134, Rarity.RARE, mage.cards.z.ZombieMaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zombie Master", 431, Rarity.RARE, mage.cards.z.ZombieMaster.class, NON_FULL_USE_VARIOUS));
    }
}
