package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

public final class TheLordOfTheRingsTalesOfMiddleEarth extends ExpansionSet {

    private static final TheLordOfTheRingsTalesOfMiddleEarth instance = new TheLordOfTheRingsTalesOfMiddleEarth();

    public static TheLordOfTheRingsTalesOfMiddleEarth getInstance() {
        return instance;
    }

    private TheLordOfTheRingsTalesOfMiddleEarth() {
        super("The Lord of the Rings: Tales of Middle-earth", "LTR", ExpansionSet.buildDate(2023, 6, 23), SetType.SUPPLEMENTAL_MODERN_LEGAL);
        this.blockName = "The Lord of the Rings: Tales of Middle-earth";
        this.hasBoosters = true;
        this.hasBasicLands = true;
        this.numBoosterLands = 1;
        this.numBoosterCommon = 10;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 7;
        this.maxCardNumberInBooster = 281;

        cards.add(new SetCardInfo("Anduril, Flame of the West", 236, Rarity.MYTHIC, mage.cards.a.AndurilFlameOfTheWest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anduril, Flame of the West", 375, Rarity.MYTHIC, mage.cards.a.AndurilFlameOfTheWest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anduril, Flame of the West", 687, Rarity.MYTHIC, mage.cards.a.AndurilFlameOfTheWest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anduril, Flame of the West", 746, Rarity.MYTHIC, mage.cards.a.AndurilFlameOfTheWest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anduril, Flame of the West", 786, Rarity.MYTHIC, mage.cards.a.AndurilFlameOfTheWest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn and Arwen, Wed", 287, Rarity.MYTHIC, mage.cards.a.AragornAndArwenWed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn and Arwen, Wed", 394, Rarity.MYTHIC, mage.cards.a.AragornAndArwenWed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, Company Leader", 191, Rarity.RARE, mage.cards.a.AragornCompanyLeader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, Company Leader", 316, Rarity.RARE, mage.cards.a.AragornCompanyLeader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, Company Leader", 410, Rarity.RARE, mage.cards.a.AragornCompanyLeader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, Company Leader", 642, Rarity.RARE, mage.cards.a.AragornCompanyLeader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, Company Leader", 808, Rarity.RARE, mage.cards.a.AragornCompanyLeader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, the Uniter", 192, Rarity.MYTHIC, mage.cards.a.AragornTheUniter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, the Uniter", 317, Rarity.MYTHIC, mage.cards.a.AragornTheUniter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, the Uniter", 434, Rarity.MYTHIC, mage.cards.a.AragornTheUniter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, the Uniter", 643, Rarity.MYTHIC, mage.cards.a.AragornTheUniter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, the Uniter", 741, Rarity.MYTHIC, mage.cards.a.AragornTheUniter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aragorn, the Uniter", 809, Rarity.MYTHIC, mage.cards.a.AragornTheUniter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arwen Undomiel", 194, Rarity.UNCOMMON, mage.cards.a.ArwenUndomiel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arwen Undomiel", 645, Rarity.UNCOMMON, mage.cards.a.ArwenUndomiel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arwen's Gift", 39, Rarity.COMMON, mage.cards.a.ArwensGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arwen's Gift", 490, Rarity.COMMON, mage.cards.a.ArwensGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arwen, Mortal Queen", 193, Rarity.MYTHIC, mage.cards.a.ArwenMortalQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arwen, Mortal Queen", 367, Rarity.MYTHIC, mage.cards.a.ArwenMortalQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arwen, Mortal Queen", 644, Rarity.MYTHIC, mage.cards.a.ArwenMortalQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arwen, Mortal Queen", 742, Rarity.MYTHIC, mage.cards.a.ArwenMortalQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arwen, Mortal Queen", 778, Rarity.MYTHIC, mage.cards.a.ArwenMortalQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Assault on Osgiliath", 285, Rarity.RARE, mage.cards.a.AssaultOnOsgiliath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Assault on Osgiliath", 386, Rarity.RARE, mage.cards.a.AssaultOnOsgiliath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bag End Porter", 153, Rarity.COMMON, mage.cards.b.BagEndPorter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bag End Porter", 604, Rarity.COMMON, mage.cards.b.BagEndPorter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Banish from Edoras", 1, Rarity.COMMON, mage.cards.b.BanishFromEdoras.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Banish from Edoras", 452, Rarity.COMMON, mage.cards.b.BanishFromEdoras.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Barad-dur", 253, Rarity.RARE, mage.cards.b.BaradDur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Barad-dur", 340, Rarity.RARE, mage.cards.b.BaradDur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Barad-dur", 425, Rarity.RARE, mage.cards.b.BaradDur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Barad-dur", 704, Rarity.RARE, mage.cards.b.BaradDur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Barad-dur", 751, Rarity.RARE, mage.cards.b.BaradDur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Barrow-Blade", 237, Rarity.UNCOMMON, mage.cards.b.BarrowBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Barrow-Blade", 688, Rarity.UNCOMMON, mage.cards.b.BarrowBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Battle-Scarred Goblin", 115, Rarity.COMMON, mage.cards.b.BattleScarredGoblin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Battle-Scarred Goblin", 566, Rarity.COMMON, mage.cards.b.BattleScarredGoblin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bewitching Leechcraft", 41, Rarity.COMMON, mage.cards.b.BewitchingLeechcraft.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bewitching Leechcraft", 492, Rarity.COMMON, mage.cards.b.BewitchingLeechcraft.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bilbo's Ring", 298, Rarity.RARE, mage.cards.b.BilbosRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bilbo's Ring", 397, Rarity.RARE, mage.cards.b.BilbosRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bilbo, Retired Burglar", 196, Rarity.UNCOMMON, mage.cards.b.BilboRetiredBurglar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bilbo, Retired Burglar", 403, Rarity.UNCOMMON, mage.cards.b.BilboRetiredBurglar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bilbo, Retired Burglar", 647, Rarity.UNCOMMON, mage.cards.b.BilboRetiredBurglar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bill Ferny, Bree Swindler", 42, Rarity.UNCOMMON, mage.cards.b.BillFernyBreeSwindler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bill Ferny, Bree Swindler", 493, Rarity.UNCOMMON, mage.cards.b.BillFernyBreeSwindler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bill the Pony", 3, Rarity.UNCOMMON, mage.cards.b.BillThePony.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bill the Pony", 454, Rarity.UNCOMMON, mage.cards.b.BillThePony.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birthday Escape", 43, Rarity.COMMON, mage.cards.b.BirthdayEscape.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birthday Escape", 494, Rarity.COMMON, mage.cards.b.BirthdayEscape.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bitter Downfall", 528, Rarity.UNCOMMON, mage.cards.b.BitterDownfall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bitter Downfall", 77, Rarity.UNCOMMON, mage.cards.b.BitterDownfall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bombadil's Song", 154, Rarity.COMMON, mage.cards.b.BombadilsSong.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bombadil's Song", 605, Rarity.COMMON, mage.cards.b.BombadilsSong.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Book of Mazarbul", 116, Rarity.UNCOMMON, mage.cards.b.BookOfMazarbul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Book of Mazarbul", 567, Rarity.UNCOMMON, mage.cards.b.BookOfMazarbul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Borne Upon a Wind", 350, Rarity.RARE, mage.cards.b.BorneUponAWind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Borne Upon a Wind", 44, Rarity.RARE, mage.cards.b.BorneUponAWind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Borne Upon a Wind", 495, Rarity.RARE, mage.cards.b.BorneUponAWind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Borne Upon a Wind", 761, Rarity.RARE, mage.cards.b.BorneUponAWind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boromir, Warden of the Tower", 302, Rarity.RARE, mage.cards.b.BoromirWardenOfTheTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boromir, Warden of the Tower", 4, Rarity.RARE, mage.cards.b.BoromirWardenOfTheTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boromir, Warden of the Tower", 407, Rarity.RARE, mage.cards.b.BoromirWardenOfTheTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boromir, Warden of the Tower", 455, Rarity.RARE, mage.cards.b.BoromirWardenOfTheTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boromir, Warden of the Tower", 794, Rarity.RARE, mage.cards.b.BoromirWardenOfTheTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brandywine Farmer", 155, Rarity.COMMON, mage.cards.b.BrandywineFarmer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brandywine Farmer", 606, Rarity.COMMON, mage.cards.b.BrandywineFarmer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Breaking of the Fellowship", 117, Rarity.COMMON, mage.cards.b.BreakingOfTheFellowship.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Breaking of the Fellowship", 568, Rarity.COMMON, mage.cards.b.BreakingOfTheFellowship.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Butterbur, Bree Innkeeper", 197, Rarity.UNCOMMON, mage.cards.b.ButterburBreeInnkeeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Butterbur, Bree Innkeeper", 648, Rarity.UNCOMMON, mage.cards.b.ButterburBreeInnkeeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Call of the Ring", 355, Rarity.RARE, mage.cards.c.CallOfTheRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Call of the Ring", 530, Rarity.RARE, mage.cards.c.CallOfTheRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Call of the Ring", 766, Rarity.RARE, mage.cards.c.CallOfTheRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Call of the Ring", 79, Rarity.RARE, mage.cards.c.CallOfTheRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Captain of Umbar", 45, Rarity.COMMON, mage.cards.c.CaptainOfUmbar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Captain of Umbar", 496, Rarity.COMMON, mage.cards.c.CaptainOfUmbar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cast into the Fire", 118, Rarity.COMMON, mage.cards.c.CastIntoTheFire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cast into the Fire", 569, Rarity.COMMON, mage.cards.c.CastIntoTheFire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Celeborn the Wise", 156, Rarity.UNCOMMON, mage.cards.c.CelebornTheWise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Celeborn the Wise", 607, Rarity.UNCOMMON, mage.cards.c.CelebornTheWise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chance-Met Elves", 157, Rarity.COMMON, mage.cards.c.ChanceMetElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chance-Met Elves", 608, Rarity.COMMON, mage.cards.c.ChanceMetElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cirith Ungol Patrol", 531, Rarity.COMMON, mage.cards.c.CirithUngolPatrol.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cirith Ungol Patrol", 80, Rarity.COMMON, mage.cards.c.CirithUngolPatrol.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Claim the Precious", 532, Rarity.COMMON, mage.cards.c.ClaimThePrecious.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Claim the Precious", 81, Rarity.COMMON, mage.cards.c.ClaimThePrecious.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Council's Deliberation", 46, Rarity.UNCOMMON, mage.cards.c.CouncilsDeliberation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Council's Deliberation", 497, Rarity.UNCOMMON, mage.cards.c.CouncilsDeliberation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dawn of a New Age", 347, Rarity.MYTHIC, mage.cards.d.DawnOfANewAge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dawn of a New Age", 456, Rarity.MYTHIC, mage.cards.d.DawnOfANewAge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dawn of a New Age", 5, Rarity.MYTHIC, mage.cards.d.DawnOfANewAge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dawn of a New Age", 731, Rarity.MYTHIC, mage.cards.d.DawnOfANewAge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dawn of a New Age", 758, Rarity.MYTHIC, mage.cards.d.DawnOfANewAge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deceive the Messenger", 47, Rarity.COMMON, mage.cards.d.DeceiveTheMessenger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deceive the Messenger", 498, Rarity.COMMON, mage.cards.d.DeceiveTheMessenger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Delighted Halfling", 158, Rarity.RARE, mage.cards.d.DelightedHalfling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Delighted Halfling", 363, Rarity.RARE, mage.cards.d.DelightedHalfling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Delighted Halfling", 402, Rarity.RARE, mage.cards.d.DelightedHalfling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Delighted Halfling", 609, Rarity.RARE, mage.cards.d.DelightedHalfling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Delighted Halfling", 774, Rarity.RARE, mage.cards.d.DelightedHalfling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Denethor, Ruling Steward", 198, Rarity.UNCOMMON, mage.cards.d.DenethorRulingSteward.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Denethor, Ruling Steward", 649, Rarity.UNCOMMON, mage.cards.d.DenethorRulingSteward.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Display of Power", 119, Rarity.RARE, mage.cards.d.DisplayOfPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Display of Power", 358, Rarity.RARE, mage.cards.d.DisplayOfPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Display of Power", 570, Rarity.RARE, mage.cards.d.DisplayOfPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Display of Power", 769, Rarity.RARE, mage.cards.d.DisplayOfPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doors of Durin", 199, Rarity.RARE, mage.cards.d.DoorsOfDurin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doors of Durin", 368, Rarity.RARE, mage.cards.d.DoorsOfDurin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doors of Durin", 650, Rarity.RARE, mage.cards.d.DoorsOfDurin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doors of Durin", 779, Rarity.RARE, mage.cards.d.DoorsOfDurin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadful as the Storm", 48, Rarity.COMMON, mage.cards.d.DreadfulAsTheStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadful as the Storm", 499, Rarity.COMMON, mage.cards.d.DreadfulAsTheStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dunedain Blade", 457, Rarity.COMMON, mage.cards.d.DunedainBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dunedain Blade", 6, Rarity.COMMON, mage.cards.d.DunedainBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dunedain Rangers", 159, Rarity.UNCOMMON, mage.cards.d.DunedainRangers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dunedain Rangers", 610, Rarity.UNCOMMON, mage.cards.d.DunedainRangers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dunland Crebain", 411, Rarity.COMMON, mage.cards.d.DunlandCrebain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dunland Crebain", 533, Rarity.COMMON, mage.cards.d.DunlandCrebain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dunland Crebain", 82, Rarity.COMMON, mage.cards.d.DunlandCrebain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eagle of Deliverance", 824, Rarity.RARE, mage.cards.e.EagleOfDeliverance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eagle of Deliverance", 829, Rarity.RARE, mage.cards.e.EagleOfDeliverance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eagles of the North", 458, Rarity.COMMON, mage.cards.e.EaglesOfTheNorth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eagles of the North", 7, Rarity.COMMON, mage.cards.e.EaglesOfTheNorth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("East-Mark Cavalier", 460, Rarity.COMMON, mage.cards.e.EastMarkCavalier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("East-Mark Cavalier", 9, Rarity.COMMON, mage.cards.e.EastMarkCavalier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Easterling Vanguard", 534, Rarity.COMMON, mage.cards.e.EasterlingVanguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Easterling Vanguard", 83, Rarity.COMMON, mage.cards.e.EasterlingVanguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eastfarthing Farmer", 459, Rarity.COMMON, mage.cards.e.EastfarthingFarmer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eastfarthing Farmer", 8, Rarity.COMMON, mage.cards.e.EastfarthingFarmer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elanor Gardner", 286, Rarity.RARE, mage.cards.e.ElanorGardner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elanor Gardner", 387, Rarity.RARE, mage.cards.e.ElanorGardner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elrond, Lord of Rivendell", 307, Rarity.UNCOMMON, mage.cards.e.ElrondLordOfRivendell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elrond, Lord of Rivendell", 49, Rarity.UNCOMMON, mage.cards.e.ElrondLordOfRivendell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elrond, Lord of Rivendell", 500, Rarity.UNCOMMON, mage.cards.e.ElrondLordOfRivendell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elrond, Lord of Rivendell", 799, Rarity.UNCOMMON, mage.cards.e.ElrondLordOfRivendell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elrond, Master of Healing", 200, Rarity.RARE, mage.cards.e.ElrondMasterOfHealing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elrond, Master of Healing", 318, Rarity.RARE, mage.cards.e.ElrondMasterOfHealing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elrond, Master of Healing", 447, Rarity.RARE, mage.cards.e.ElrondMasterOfHealing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elrond, Master of Healing", 651, Rarity.RARE, mage.cards.e.ElrondMasterOfHealing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elrond, Master of Healing", 810, Rarity.RARE, mage.cards.e.ElrondMasterOfHealing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elven Chorus", 160, Rarity.RARE, mage.cards.e.ElvenChorus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elven Chorus", 364, Rarity.RARE, mage.cards.e.ElvenChorus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elven Chorus", 611, Rarity.RARE, mage.cards.e.ElvenChorus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elven Chorus", 775, Rarity.RARE, mage.cards.e.ElvenChorus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elven Farsight", 161, Rarity.COMMON, mage.cards.e.ElvenFarsight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elven Farsight", 612, Rarity.COMMON, mage.cards.e.ElvenFarsight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elvish Mariner", 283, Rarity.RARE, mage.cards.e.ElvishMariner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elvish Mariner", 384, Rarity.RARE, mage.cards.e.ElvishMariner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Enraged Huorn", 162, Rarity.COMMON, mage.cards.e.EnragedHuorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Enraged Huorn", 613, Rarity.COMMON, mage.cards.e.EnragedHuorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ent's Fury", 164, Rarity.COMMON, mage.cards.e.EntsFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ent's Fury", 615, Rarity.COMMON, mage.cards.e.EntsFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ent-Draught Basin", 238, Rarity.UNCOMMON, mage.cards.e.EntDraughtBasin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ent-Draught Basin", 689, Rarity.UNCOMMON, mage.cards.e.EntDraughtBasin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Entish Restoration", 163, Rarity.UNCOMMON, mage.cards.e.EntishRestoration.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Entish Restoration", 614, Rarity.UNCOMMON, mage.cards.e.EntishRestoration.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eomer of the Riddermark", 121, Rarity.UNCOMMON, mage.cards.e.EomerOfTheRiddermark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eomer of the Riddermark", 572, Rarity.UNCOMMON, mage.cards.e.EomerOfTheRiddermark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eomer, Marshal of Rohan", 120, Rarity.RARE, mage.cards.e.EomerMarshalOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eomer, Marshal of Rohan", 428, Rarity.RARE, mage.cards.e.EomerMarshalOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eomer, Marshal of Rohan", 571, Rarity.RARE, mage.cards.e.EomerMarshalOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eowyn, Fearless Knight", 201, Rarity.RARE, mage.cards.e.EowynFearlessKnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eowyn, Fearless Knight", 430, Rarity.RARE, mage.cards.e.EowynFearlessKnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eowyn, Fearless Knight", 652, Rarity.RARE, mage.cards.e.EowynFearlessKnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eowyn, Lady of Rohan", 10, Rarity.UNCOMMON, mage.cards.e.EowynLadyOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eowyn, Lady of Rohan", 461, Rarity.UNCOMMON, mage.cards.e.EowynLadyOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Erebor Flamesmith", 122, Rarity.COMMON, mage.cards.e.EreborFlamesmith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Erebor Flamesmith", 573, Rarity.COMMON, mage.cards.e.EreborFlamesmith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Erkenbrand, Lord of Westfold", 123, Rarity.UNCOMMON, mage.cards.e.ErkenbrandLordOfWestfold.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Erkenbrand, Lord of Westfold", 574, Rarity.UNCOMMON, mage.cards.e.ErkenbrandLordOfWestfold.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Errand-Rider of Gondor", 11, Rarity.COMMON, mage.cards.e.ErrandRiderOfGondor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Errand-Rider of Gondor", 462, Rarity.COMMON, mage.cards.e.ErrandRiderOfGondor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Escape from Orthanc", 12, Rarity.COMMON, mage.cards.e.EscapeFromOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Escape from Orthanc", 463, Rarity.COMMON, mage.cards.e.EscapeFromOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Esquire of the King", 13, Rarity.COMMON, mage.cards.e.EsquireOfTheKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Esquire of the King", 464, Rarity.COMMON, mage.cards.e.EsquireOfTheKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fall of Cair Andros", 124, Rarity.RARE, mage.cards.f.FallOfCairAndros.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fall of Cair Andros", 359, Rarity.RARE, mage.cards.f.FallOfCairAndros.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fall of Cair Andros", 575, Rarity.RARE, mage.cards.f.FallOfCairAndros.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fall of Cair Andros", 770, Rarity.RARE, mage.cards.f.FallOfCairAndros.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fall of Gil-galad", 165, Rarity.RARE, mage.cards.f.FallOfGilGalad.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fall of Gil-galad", 616, Rarity.RARE, mage.cards.f.FallOfGilGalad.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fangorn, Tree Shepherd", 166, Rarity.RARE, mage.cards.f.FangornTreeShepherd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fangorn, Tree Shepherd", 415, Rarity.RARE, mage.cards.f.FangornTreeShepherd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fangorn, Tree Shepherd", 617, Rarity.RARE, mage.cards.f.FangornTreeShepherd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faramir, Field Commander", 14, Rarity.UNCOMMON, mage.cards.f.FaramirFieldCommander.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faramir, Field Commander", 303, Rarity.UNCOMMON, mage.cards.f.FaramirFieldCommander.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faramir, Field Commander", 465, Rarity.UNCOMMON, mage.cards.f.FaramirFieldCommander.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faramir, Field Commander", 795, Rarity.UNCOMMON, mage.cards.f.FaramirFieldCommander.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faramir, Prince of Ithilien", 202, Rarity.RARE, mage.cards.f.FaramirPrinceOfIthilien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faramir, Prince of Ithilien", 319, Rarity.RARE, mage.cards.f.FaramirPrinceOfIthilien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faramir, Prince of Ithilien", 653, Rarity.RARE, mage.cards.f.FaramirPrinceOfIthilien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faramir, Prince of Ithilien", 811, Rarity.RARE, mage.cards.f.FaramirPrinceOfIthilien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fear, Fire, Foes!", 125, Rarity.UNCOMMON, mage.cards.f.FearFireFoes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fear, Fire, Foes!", 576, Rarity.UNCOMMON, mage.cards.f.FearFireFoes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Inscription", 126, Rarity.UNCOMMON, mage.cards.f.FieryInscription.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Inscription", 577, Rarity.UNCOMMON, mage.cards.f.FieryInscription.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fire of Orthanc", 127, Rarity.COMMON, mage.cards.f.FireOfOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fire of Orthanc", 578, Rarity.COMMON, mage.cards.f.FireOfOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fires of Mount Doom", 294, Rarity.RARE, mage.cards.f.FiresOfMountDoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fires of Mount Doom", 392, Rarity.RARE, mage.cards.f.FiresOfMountDoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flame of Anor", 203, Rarity.RARE, mage.cards.f.FlameOfAnor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flame of Anor", 406, Rarity.RARE, mage.cards.f.FlameOfAnor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flame of Anor", 654, Rarity.RARE, mage.cards.f.FlameOfAnor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flowering of the White Tree", 15, Rarity.RARE, mage.cards.f.FloweringOfTheWhiteTree.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flowering of the White Tree", 348, Rarity.RARE, mage.cards.f.FloweringOfTheWhiteTree.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flowering of the White Tree", 466, Rarity.RARE, mage.cards.f.FloweringOfTheWhiteTree.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flowering of the White Tree", 759, Rarity.RARE, mage.cards.f.FloweringOfTheWhiteTree.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fog on the Barrow-Downs", 16, Rarity.COMMON, mage.cards.f.FogOnTheBarrowDowns.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fog on the Barrow-Downs", 467, Rarity.COMMON, mage.cards.f.FogOnTheBarrowDowns.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Foray of Orcs", 128, Rarity.UNCOMMON, mage.cards.f.ForayOfOrcs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Foray of Orcs", 417, Rarity.UNCOMMON, mage.cards.f.ForayOfOrcs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Foray of Orcs", 579, Rarity.UNCOMMON, mage.cards.f.ForayOfOrcs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 270, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 271, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 280, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 281, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 721, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 722, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forge Anew", 17, Rarity.RARE, mage.cards.f.ForgeAnew.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forge Anew", 349, Rarity.RARE, mage.cards.f.ForgeAnew.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forge Anew", 468, Rarity.RARE, mage.cards.f.ForgeAnew.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forge Anew", 760, Rarity.RARE, mage.cards.f.ForgeAnew.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Friendly Rivalry", 204, Rarity.UNCOMMON, mage.cards.f.FriendlyRivalry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Friendly Rivalry", 655, Rarity.UNCOMMON, mage.cards.f.FriendlyRivalry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo Baggins", 205, Rarity.UNCOMMON, mage.cards.f.FrodoBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo Baggins", 320, Rarity.UNCOMMON, mage.cards.f.FrodoBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo Baggins", 404, Rarity.UNCOMMON, mage.cards.f.FrodoBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo Baggins", 656, Rarity.UNCOMMON, mage.cards.f.FrodoBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo Baggins", 812, Rarity.UNCOMMON, mage.cards.f.FrodoBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo, Determined Hero", 289, Rarity.RARE, mage.cards.f.FrodoDeterminedHero.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo, Determined Hero", 388, Rarity.RARE, mage.cards.f.FrodoDeterminedHero.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo, Sauron's Bane", 18, Rarity.RARE, mage.cards.f.FrodoSauronsBane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo, Sauron's Bane", 304, Rarity.RARE, mage.cards.f.FrodoSauronsBane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo, Sauron's Bane", 448, Rarity.RARE, mage.cards.f.FrodoSauronsBane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo, Sauron's Bane", 469, Rarity.RARE, mage.cards.f.FrodoSauronsBane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frodo, Sauron's Bane", 796, Rarity.RARE, mage.cards.f.FrodoSauronsBane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadhrim Bow", 167, Rarity.COMMON, mage.cards.g.GaladhrimBow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadhrim Bow", 618, Rarity.COMMON, mage.cards.g.GaladhrimBow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadhrim Guide", 168, Rarity.COMMON, mage.cards.g.GaladhrimGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadhrim Guide", 619, Rarity.COMMON, mage.cards.g.GaladhrimGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadriel of Lothlorien", 206, Rarity.RARE, mage.cards.g.GaladrielOfLothlorien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadriel of Lothlorien", 321, Rarity.RARE, mage.cards.g.GaladrielOfLothlorien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadriel of Lothlorien", 446, Rarity.RARE, mage.cards.g.GaladrielOfLothlorien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadriel of Lothlorien", 657, Rarity.RARE, mage.cards.g.GaladrielOfLothlorien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadriel of Lothlorien", 813, Rarity.RARE, mage.cards.g.GaladrielOfLothlorien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadriel, Gift-Giver", 296, Rarity.RARE, mage.cards.g.GaladrielGiftGiver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galadriel, Gift-Giver", 393, Rarity.RARE, mage.cards.g.GaladrielGiftGiver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the Grey", 207, Rarity.RARE, mage.cards.g.GandalfTheGrey.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the Grey", 322, Rarity.RARE, mage.cards.g.GandalfTheGrey.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the Grey", 658, Rarity.RARE, mage.cards.g.GandalfTheGrey.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the Grey", 814, Rarity.RARE, mage.cards.g.GandalfTheGrey.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the White", 19, Rarity.MYTHIC, mage.cards.g.GandalfTheWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the White", 299, Rarity.MYTHIC, mage.cards.g.GandalfTheWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the White", 305, Rarity.MYTHIC, mage.cards.g.GandalfTheWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the White", 442, Rarity.MYTHIC, mage.cards.g.GandalfTheWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the White", 470, Rarity.MYTHIC, mage.cards.g.GandalfTheWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the White", 732, Rarity.MYTHIC, mage.cards.g.GandalfTheWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf the White", 797, Rarity.MYTHIC, mage.cards.g.GandalfTheWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf's Sanction", 208, Rarity.UNCOMMON, mage.cards.g.GandalfsSanction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf's Sanction", 659, Rarity.UNCOMMON, mage.cards.g.GandalfsSanction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf, Friend of the Shire", 308, Rarity.UNCOMMON, mage.cards.g.GandalfFriendOfTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf, Friend of the Shire", 401, Rarity.UNCOMMON, mage.cards.g.GandalfFriendOfTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf, Friend of the Shire", 50, Rarity.UNCOMMON, mage.cards.g.GandalfFriendOfTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf, Friend of the Shire", 501, Rarity.UNCOMMON, mage.cards.g.GandalfFriendOfTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf, Friend of the Shire", 800, Rarity.UNCOMMON, mage.cards.g.GandalfFriendOfTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf, White Rider", 290, Rarity.RARE, mage.cards.g.GandalfWhiteRider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gandalf, White Rider", 389, Rarity.RARE, mage.cards.g.GandalfWhiteRider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Generous Ent", 169, Rarity.COMMON, mage.cards.g.GenerousEnt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Generous Ent", 620, Rarity.COMMON, mage.cards.g.GenerousEnt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gift of Strands", 170, Rarity.UNCOMMON, mage.cards.g.GiftOfStrands.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gift of Strands", 621, Rarity.UNCOMMON, mage.cards.g.GiftOfStrands.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli's Axe", 130, Rarity.COMMON, mage.cards.g.GimlisAxe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli's Axe", 581, Rarity.COMMON, mage.cards.g.GimlisAxe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli's Fury", 131, Rarity.COMMON, mage.cards.g.GimlisFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli's Fury", 582, Rarity.COMMON, mage.cards.g.GimlisFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli, Counter of Kills", 129, Rarity.UNCOMMON, mage.cards.g.GimliCounterOfKills.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli, Counter of Kills", 312, Rarity.UNCOMMON, mage.cards.g.GimliCounterOfKills.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli, Counter of Kills", 580, Rarity.UNCOMMON, mage.cards.g.GimliCounterOfKills.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli, Counter of Kills", 804, Rarity.UNCOMMON, mage.cards.g.GimliCounterOfKills.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli, Mournful Avenger", 209, Rarity.RARE, mage.cards.g.GimliMournfulAvenger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli, Mournful Avenger", 323, Rarity.RARE, mage.cards.g.GimliMournfulAvenger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli, Mournful Avenger", 436, Rarity.RARE, mage.cards.g.GimliMournfulAvenger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli, Mournful Avenger", 660, Rarity.RARE, mage.cards.g.GimliMournfulAvenger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gimli, Mournful Avenger", 815, Rarity.RARE, mage.cards.g.GimliMournfulAvenger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glamdring", 239, Rarity.MYTHIC, mage.cards.g.Glamdring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glamdring", 376, Rarity.MYTHIC, mage.cards.g.Glamdring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glamdring", 690, Rarity.MYTHIC, mage.cards.g.Glamdring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glamdring", 747, Rarity.MYTHIC, mage.cards.g.Glamdring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glamdring", 787, Rarity.MYTHIC, mage.cards.g.Glamdring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gloin, Dwarf Emissary", 132, Rarity.RARE, mage.cards.g.GloinDwarfEmissary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gloin, Dwarf Emissary", 360, Rarity.RARE, mage.cards.g.GloinDwarfEmissary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gloin, Dwarf Emissary", 583, Rarity.RARE, mage.cards.g.GloinDwarfEmissary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gloin, Dwarf Emissary", 771, Rarity.RARE, mage.cards.g.GloinDwarfEmissary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glorfindel, Dauntless Rescuer", 171, Rarity.UNCOMMON, mage.cards.g.GlorfindelDauntlessRescuer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glorfindel, Dauntless Rescuer", 622, Rarity.UNCOMMON, mage.cards.g.GlorfindelDauntlessRescuer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glorious Gale", 502, Rarity.COMMON, mage.cards.g.GloriousGale.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glorious Gale", 51, Rarity.COMMON, mage.cards.g.GloriousGale.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Assailant", 295, Rarity.COMMON, mage.cards.g.GoblinAssailant.class));
        cards.add(new SetCardInfo("Goblin Fireleaper", 133, Rarity.UNCOMMON, mage.cards.g.GoblinFireleaper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Fireleaper", 584, Rarity.UNCOMMON, mage.cards.g.GoblinFireleaper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goldberry, River-Daughter", 351, Rarity.RARE, mage.cards.g.GoldberryRiverDaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goldberry, River-Daughter", 503, Rarity.RARE, mage.cards.g.GoldberryRiverDaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goldberry, River-Daughter", 52, Rarity.RARE, mage.cards.g.GoldberryRiverDaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goldberry, River-Daughter", 762, Rarity.RARE, mage.cards.g.GoldberryRiverDaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gollum's Bite", 536, Rarity.UNCOMMON, mage.cards.g.GollumsBite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gollum's Bite", 85, Rarity.UNCOMMON, mage.cards.g.GollumsBite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gollum, Patient Plotter", 309, Rarity.UNCOMMON, mage.cards.g.GollumPatientPlotter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gollum, Patient Plotter", 450, Rarity.UNCOMMON, mage.cards.g.GollumPatientPlotter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gollum, Patient Plotter", 535, Rarity.UNCOMMON, mage.cards.g.GollumPatientPlotter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gollum, Patient Plotter", 801, Rarity.UNCOMMON, mage.cards.g.GollumPatientPlotter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gollum, Patient Plotter", 84, Rarity.UNCOMMON, mage.cards.g.GollumPatientPlotter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gollum, Scheming Guide", 292, Rarity.RARE, mage.cards.g.GollumSchemingGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gollum, Scheming Guide", 390, Rarity.RARE, mage.cards.g.GollumSchemingGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gorbag of Minas Morgul", 537, Rarity.UNCOMMON, mage.cards.g.GorbagOfMinasMorgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gorbag of Minas Morgul", 86, Rarity.UNCOMMON, mage.cards.g.GorbagOfMinasMorgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gothmog, Morgul Lieutenant", 429, Rarity.UNCOMMON, mage.cards.g.GothmogMorgulLieutenant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gothmog, Morgul Lieutenant", 538, Rarity.UNCOMMON, mage.cards.g.GothmogMorgulLieutenant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gothmog, Morgul Lieutenant", 87, Rarity.UNCOMMON, mage.cards.g.GothmogMorgulLieutenant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Great Hall of the Citadel", 254, Rarity.COMMON, mage.cards.g.GreatHallOfTheCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Great Hall of the Citadel", 705, Rarity.COMMON, mage.cards.g.GreatHallOfTheCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grey Havens Navigator", 504, Rarity.COMMON, mage.cards.g.GreyHavensNavigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grey Havens Navigator", 53, Rarity.COMMON, mage.cards.g.GreyHavensNavigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grima Wormtongue", 539, Rarity.UNCOMMON, mage.cards.g.GrimaWormtongue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grima Wormtongue", 88, Rarity.UNCOMMON, mage.cards.g.GrimaWormtongue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grishnakh, Brash Instigator", 134, Rarity.UNCOMMON, mage.cards.g.GrishnakhBrashInstigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grishnakh, Brash Instigator", 585, Rarity.UNCOMMON, mage.cards.g.GrishnakhBrashInstigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grond, the Gatebreaker", 540, Rarity.UNCOMMON, mage.cards.g.GrondTheGatebreaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grond, the Gatebreaker", 89, Rarity.UNCOMMON, mage.cards.g.GrondTheGatebreaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gwaihir the Windlord", 210, Rarity.UNCOMMON, mage.cards.g.GwaihirTheWindlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gwaihir the Windlord", 661, Rarity.UNCOMMON, mage.cards.g.GwaihirTheWindlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Haradrim Spearmaster", 135, Rarity.COMMON, mage.cards.h.HaradrimSpearmaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Haradrim Spearmaster", 586, Rarity.COMMON, mage.cards.h.HaradrimSpearmaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Haunt of the Dead Marshes", 541, Rarity.COMMON, mage.cards.h.HauntOfTheDeadMarshes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Haunt of the Dead Marshes", 90, Rarity.COMMON, mage.cards.h.HauntOfTheDeadMarshes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hew the Entwood", 136, Rarity.MYTHIC, mage.cards.h.HewTheEntwood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hew the Entwood", 361, Rarity.MYTHIC, mage.cards.h.HewTheEntwood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hew the Entwood", 587, Rarity.MYTHIC, mage.cards.h.HewTheEntwood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hew the Entwood", 737, Rarity.MYTHIC, mage.cards.h.HewTheEntwood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hew the Entwood", 772, Rarity.MYTHIC, mage.cards.h.HewTheEntwood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hithlain Knots", 505, Rarity.COMMON, mage.cards.h.HithlainKnots.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hithlain Knots", 54, Rarity.COMMON, mage.cards.h.HithlainKnots.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hobbit's Sting", 20, Rarity.COMMON, mage.cards.h.HobbitsSting.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hobbit's Sting", 471, Rarity.COMMON, mage.cards.h.HobbitsSting.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horn of Gondor", 240, Rarity.RARE, mage.cards.h.HornOfGondor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horn of Gondor", 377, Rarity.RARE, mage.cards.h.HornOfGondor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horn of Gondor", 691, Rarity.RARE, mage.cards.h.HornOfGondor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horn of Gondor", 788, Rarity.RARE, mage.cards.h.HornOfGondor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horn of the Mark", 241, Rarity.RARE, mage.cards.h.HornOfTheMark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horn of the Mark", 378, Rarity.RARE, mage.cards.h.HornOfTheMark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horn of the Mark", 692, Rarity.RARE, mage.cards.h.HornOfTheMark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horn of the Mark", 789, Rarity.RARE, mage.cards.h.HornOfTheMark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horses of the Bruinen", 506, Rarity.UNCOMMON, mage.cards.h.HorsesOfTheBruinen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horses of the Bruinen", 55, Rarity.UNCOMMON, mage.cards.h.HorsesOfTheBruinen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Improvised Club", 137, Rarity.COMMON, mage.cards.i.ImprovisedClub.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Improvised Club", 588, Rarity.COMMON, mage.cards.i.ImprovisedClub.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inherited Envelope", 242, Rarity.COMMON, mage.cards.i.InheritedEnvelope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inherited Envelope", 693, Rarity.COMMON, mage.cards.i.InheritedEnvelope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ioreth of the Healing House", 507, Rarity.UNCOMMON, mage.cards.i.IorethOfTheHealingHouse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ioreth of the Healing House", 56, Rarity.UNCOMMON, mage.cards.i.IorethOfTheHealingHouse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Isildur's Fateful Strike", 356, Rarity.RARE, mage.cards.i.IsildursFatefulStrike.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Isildur's Fateful Strike", 542, Rarity.RARE, mage.cards.i.IsildursFatefulStrike.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Isildur's Fateful Strike", 767, Rarity.RARE, mage.cards.i.IsildursFatefulStrike.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Isildur's Fateful Strike", 91, Rarity.RARE, mage.cards.i.IsildursFatefulStrike.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 264, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 265, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 274, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 275, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 715, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 716, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Isolation at Orthanc", 508, Rarity.COMMON, mage.cards.i.IsolationAtOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Isolation at Orthanc", 57, Rarity.COMMON, mage.cards.i.IsolationAtOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ithilien Kingfisher", 509, Rarity.COMMON, mage.cards.i.IthilienKingfisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ithilien Kingfisher", 58, Rarity.COMMON, mage.cards.i.IthilienKingfisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("King of the Oathbreakers", 211, Rarity.RARE, mage.cards.k.KingOfTheOathbreakers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("King of the Oathbreakers", 369, Rarity.RARE, mage.cards.k.KingOfTheOathbreakers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("King of the Oathbreakers", 662, Rarity.RARE, mage.cards.k.KingOfTheOathbreakers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("King of the Oathbreakers", 780, Rarity.RARE, mage.cards.k.KingOfTheOathbreakers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Knight of the Keep", 291, Rarity.COMMON, mage.cards.k.KnightOfTheKeep.class));
        cards.add(new SetCardInfo("Knights of Dol Amroth", 432, Rarity.COMMON, mage.cards.k.KnightsOfDolAmroth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Knights of Dol Amroth", 510, Rarity.COMMON, mage.cards.k.KnightsOfDolAmroth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Knights of Dol Amroth", 59, Rarity.COMMON, mage.cards.k.KnightsOfDolAmroth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Landroval, Horizon Witness", 21, Rarity.UNCOMMON, mage.cards.l.LandrovalHorizonWitness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Landroval, Horizon Witness", 472, Rarity.UNCOMMON, mage.cards.l.LandrovalHorizonWitness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lash of the Balrog", 408, Rarity.COMMON, mage.cards.l.LashOfTheBalrog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lash of the Balrog", 543, Rarity.COMMON, mage.cards.l.LashOfTheBalrog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lash of the Balrog", 92, Rarity.COMMON, mage.cards.l.LashOfTheBalrog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Last March of the Ents", 172, Rarity.MYTHIC, mage.cards.l.LastMarchOfTheEnts.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Last March of the Ents", 418, Rarity.MYTHIC, mage.cards.l.LastMarchOfTheEnts.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Last March of the Ents", 623, Rarity.MYTHIC, mage.cards.l.LastMarchOfTheEnts.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Last March of the Ents", 739, Rarity.MYTHIC, mage.cards.l.LastMarchOfTheEnts.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legolas, Counter of Kills", 212, Rarity.UNCOMMON, mage.cards.l.LegolasCounterOfKills.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legolas, Counter of Kills", 324, Rarity.UNCOMMON, mage.cards.l.LegolasCounterOfKills.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legolas, Counter of Kills", 663, Rarity.UNCOMMON, mage.cards.l.LegolasCounterOfKills.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legolas, Counter of Kills", 816, Rarity.UNCOMMON, mage.cards.l.LegolasCounterOfKills.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legolas, Master Archer", 173, Rarity.RARE, mage.cards.l.LegolasMasterArcher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legolas, Master Archer", 313, Rarity.RARE, mage.cards.l.LegolasMasterArcher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legolas, Master Archer", 435, Rarity.RARE, mage.cards.l.LegolasMasterArcher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legolas, Master Archer", 624, Rarity.RARE, mage.cards.l.LegolasMasterArcher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legolas, Master Archer", 805, Rarity.RARE, mage.cards.l.LegolasMasterArcher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lembas", 243, Rarity.COMMON, mage.cards.l.Lembas.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lembas", 694, Rarity.COMMON, mage.cards.l.Lembas.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lobelia Sackville-Baggins", 357, Rarity.RARE, mage.cards.l.LobeliaSackvilleBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lobelia Sackville-Baggins", 399, Rarity.RARE, mage.cards.l.LobeliaSackvilleBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lobelia Sackville-Baggins", 544, Rarity.RARE, mage.cards.l.LobeliaSackvilleBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lobelia Sackville-Baggins", 768, Rarity.RARE, mage.cards.l.LobeliaSackvilleBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lobelia Sackville-Baggins", 93, Rarity.RARE, mage.cards.l.LobeliaSackvilleBaggins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Long List of the Ents", 174, Rarity.UNCOMMON, mage.cards.l.LongListOfTheEnts.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Long List of the Ents", 625, Rarity.UNCOMMON, mage.cards.l.LongListOfTheEnts.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lorien Revealed", 511, Rarity.COMMON, mage.cards.l.LorienRevealed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lorien Revealed", 60, Rarity.COMMON, mage.cards.l.LorienRevealed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lost Isle Calling", 444, Rarity.RARE, mage.cards.l.LostIsleCalling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lost Isle Calling", 512, Rarity.RARE, mage.cards.l.LostIsleCalling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lost Isle Calling", 61, Rarity.RARE, mage.cards.l.LostIsleCalling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lost to Legend", 22, Rarity.UNCOMMON, mage.cards.l.LostToLegend.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lost to Legend", 473, Rarity.UNCOMMON, mage.cards.l.LostToLegend.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lothlorien Lookout", 175, Rarity.COMMON, mage.cards.l.LothlorienLookout.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lothlorien Lookout", 626, Rarity.COMMON, mage.cards.l.LothlorienLookout.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lotho, Corrupt Shirriff", 213, Rarity.RARE, mage.cards.l.LothoCorruptShirriff.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lotho, Corrupt Shirriff", 370, Rarity.RARE, mage.cards.l.LothoCorruptShirriff.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lotho, Corrupt Shirriff", 664, Rarity.RARE, mage.cards.l.LothoCorruptShirriff.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lotho, Corrupt Shirriff", 781, Rarity.RARE, mage.cards.l.LothoCorruptShirriff.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Many Partings", 176, Rarity.COMMON, mage.cards.m.ManyPartings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Many Partings", 445, Rarity.COMMON, mage.cards.m.ManyPartings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Many Partings", 627, Rarity.COMMON, mage.cards.m.ManyPartings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("March from the Black Gate", 545, Rarity.UNCOMMON, mage.cards.m.MarchFromTheBlackGate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("March from the Black Gate", 94, Rarity.UNCOMMON, mage.cards.m.MarchFromTheBlackGate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mauhur, Uruk-hai Captain", 214, Rarity.UNCOMMON, mage.cards.m.MauhurUrukHaiCaptain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mauhur, Uruk-hai Captain", 665, Rarity.UNCOMMON, mage.cards.m.MauhurUrukHaiCaptain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meneldor, Swift Savior", 513, Rarity.UNCOMMON, mage.cards.m.MeneldorSwiftSavior.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meneldor, Swift Savior", 62, Rarity.UNCOMMON, mage.cards.m.MeneldorSwiftSavior.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meriadoc Brandybuck", 177, Rarity.UNCOMMON, mage.cards.m.MeriadocBrandybuck.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meriadoc Brandybuck", 314, Rarity.UNCOMMON, mage.cards.m.MeriadocBrandybuck.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meriadoc Brandybuck", 628, Rarity.UNCOMMON, mage.cards.m.MeriadocBrandybuck.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meriadoc Brandybuck", 806, Rarity.UNCOMMON, mage.cards.m.MeriadocBrandybuck.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Merry, Esquire of Rohan", 215, Rarity.RARE, mage.cards.m.MerryEsquireOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Merry, Esquire of Rohan", 325, Rarity.RARE, mage.cards.m.MerryEsquireOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Merry, Esquire of Rohan", 437, Rarity.RARE, mage.cards.m.MerryEsquireOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Merry, Esquire of Rohan", 666, Rarity.RARE, mage.cards.m.MerryEsquireOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Merry, Esquire of Rohan", 817, Rarity.RARE, mage.cards.m.MerryEsquireOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Minas Tirith Garrison", 825, Rarity.RARE, mage.cards.m.MinasTirithGarrison.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Minas Tirith Garrison", 830, Rarity.RARE, mage.cards.m.MinasTirithGarrison.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Minas Tirith", 256, Rarity.RARE, mage.cards.m.MinasTirith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Minas Tirith", 341, Rarity.RARE, mage.cards.m.MinasTirith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Minas Tirith", 420, Rarity.RARE, mage.cards.m.MinasTirith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Minas Tirith", 707, Rarity.RARE, mage.cards.m.MinasTirith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Minas Tirith", 752, Rarity.RARE, mage.cards.m.MinasTirith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mines of Moria", 257, Rarity.RARE, mage.cards.m.MinesOfMoria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mines of Moria", 342, Rarity.RARE, mage.cards.m.MinesOfMoria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mines of Moria", 708, Rarity.RARE, mage.cards.m.MinesOfMoria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mines of Moria", 753, Rarity.RARE, mage.cards.m.MinesOfMoria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirkwood Bats", 421, Rarity.COMMON, mage.cards.m.MirkwoodBats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirkwood Bats", 546, Rarity.COMMON, mage.cards.m.MirkwoodBats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirkwood Bats", 95, Rarity.COMMON, mage.cards.m.MirkwoodBats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirkwood Channeler", 828, Rarity.RARE, mage.cards.m.MirkwoodChanneler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirkwood Channeler", 833, Rarity.RARE, mage.cards.m.MirkwoodChanneler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirkwood Spider", 178, Rarity.COMMON, mage.cards.m.MirkwoodSpider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirkwood Spider", 629, Rarity.COMMON, mage.cards.m.MirkwoodSpider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirror of Galadriel", 244, Rarity.UNCOMMON, mage.cards.m.MirrorOfGaladriel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirror of Galadriel", 695, Rarity.UNCOMMON, mage.cards.m.MirrorOfGaladriel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirrormere Guardian", 179, Rarity.COMMON, mage.cards.m.MirrormereGuardian.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirrormere Guardian", 630, Rarity.COMMON, mage.cards.m.MirrormereGuardian.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mithril Coat", 245, Rarity.RARE, mage.cards.m.MithrilCoat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mithril Coat", 379, Rarity.RARE, mage.cards.m.MithrilCoat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mithril Coat", 696, Rarity.RARE, mage.cards.m.MithrilCoat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mithril Coat", 790, Rarity.RARE, mage.cards.m.MithrilCoat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mordor Muster", 547, Rarity.COMMON, mage.cards.m.MordorMuster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mordor Muster", 96, Rarity.COMMON, mage.cards.m.MordorMuster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mordor Trebuchet", 548, Rarity.COMMON, mage.cards.m.MordorTrebuchet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mordor Trebuchet", 97, Rarity.COMMON, mage.cards.m.MordorTrebuchet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Morgul-Knife Wound", 549, Rarity.COMMON, mage.cards.m.MorgulKnifeWound.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Morgul-Knife Wound", 98, Rarity.COMMON, mage.cards.m.MorgulKnifeWound.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Moria Marauder", 138, Rarity.RARE, mage.cards.m.MoriaMarauder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Moria Marauder", 362, Rarity.RARE, mage.cards.m.MoriaMarauder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Moria Marauder", 589, Rarity.RARE, mage.cards.m.MoriaMarauder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Moria Marauder", 773, Rarity.RARE, mage.cards.m.MoriaMarauder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mount Doom", 258, Rarity.MYTHIC, mage.cards.m.MountDoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mount Doom", 343, Rarity.MYTHIC, mage.cards.m.MountDoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mount Doom", 709, Rarity.MYTHIC, mage.cards.m.MountDoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mount Doom", 750, Rarity.MYTHIC, mage.cards.m.MountDoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mount Doom", 754, Rarity.MYTHIC, mage.cards.m.MountDoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 268, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 269, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 278, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 279, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 719, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 720, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mushroom Watchdogs", 180, Rarity.COMMON, mage.cards.m.MushroomWatchdogs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mushroom Watchdogs", 631, Rarity.COMMON, mage.cards.m.MushroomWatchdogs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nasty End", 416, Rarity.COMMON, mage.cards.n.NastyEnd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nasty End", 550, Rarity.COMMON, mage.cards.n.NastyEnd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nasty End", 99, Rarity.COMMON, mage.cards.n.NastyEnd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 100, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 332, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 333, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 334, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 335, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 336, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 337, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 338, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 339, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 551, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 723, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 724, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 725, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 726, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 727, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 728, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 729, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nazgul", 730, Rarity.UNCOMMON, mage.cards.n.Nazgul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nimble Hobbit", 23, Rarity.COMMON, mage.cards.n.NimbleHobbit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nimble Hobbit", 474, Rarity.COMMON, mage.cards.n.NimbleHobbit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nimrodel Watcher", 514, Rarity.COMMON, mage.cards.n.NimrodelWatcher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nimrodel Watcher", 63, Rarity.COMMON, mage.cards.n.NimrodelWatcher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Now for Wrath, Now for Ruin!", 24, Rarity.COMMON, mage.cards.n.NowForWrathNowForRuin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Now for Wrath, Now for Ruin!", 475, Rarity.COMMON, mage.cards.n.NowForWrathNowForRuin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oath of the Grey Host", 101, Rarity.UNCOMMON, mage.cards.o.OathOfTheGreyHost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oath of the Grey Host", 552, Rarity.UNCOMMON, mage.cards.o.OathOfTheGreyHost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Old Man Willow", 217, Rarity.UNCOMMON, mage.cards.o.OldManWillow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Old Man Willow", 668, Rarity.UNCOMMON, mage.cards.o.OldManWillow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oliphaunt", 139, Rarity.COMMON, mage.cards.o.Oliphaunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oliphaunt", 426, Rarity.COMMON, mage.cards.o.Oliphaunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oliphaunt", 590, Rarity.COMMON, mage.cards.o.Oliphaunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Olog-hai Crusher", 140, Rarity.COMMON, mage.cards.o.OlogHaiCrusher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Olog-hai Crusher", 591, Rarity.COMMON, mage.cards.o.OlogHaiCrusher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("One Ring to Rule Them All", 102, Rarity.RARE, mage.cards.o.OneRingToRuleThemAll.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("One Ring to Rule Them All", 553, Rarity.RARE, mage.cards.o.OneRingToRuleThemAll.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orcish Bowmasters", 103, Rarity.RARE, mage.cards.o.OrcishBowmasters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orcish Bowmasters", 433, Rarity.RARE, mage.cards.o.OrcishBowmasters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orcish Bowmasters", 554, Rarity.RARE, mage.cards.o.OrcishBowmasters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orcish Medicine", 104, Rarity.COMMON, mage.cards.o.OrcishMedicine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orcish Medicine", 555, Rarity.COMMON, mage.cards.o.OrcishMedicine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Palantir of Orthanc", 247, Rarity.MYTHIC, mage.cards.p.PalantirOfOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Palantir of Orthanc", 381, Rarity.MYTHIC, mage.cards.p.PalantirOfOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Palantir of Orthanc", 698, Rarity.MYTHIC, mage.cards.p.PalantirOfOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Palantir of Orthanc", 749, Rarity.MYTHIC, mage.cards.p.PalantirOfOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Palantir of Orthanc", 792, Rarity.MYTHIC, mage.cards.p.PalantirOfOrthanc.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pelargir Survivor", 515, Rarity.COMMON, mage.cards.p.PelargirSurvivor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pelargir Survivor", 64, Rarity.COMMON, mage.cards.p.PelargirSurvivor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Peregrin Took", 181, Rarity.UNCOMMON, mage.cards.p.PeregrinTook.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Peregrin Took", 315, Rarity.UNCOMMON, mage.cards.p.PeregrinTook.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Peregrin Took", 632, Rarity.UNCOMMON, mage.cards.p.PeregrinTook.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Peregrin Took", 807, Rarity.UNCOMMON, mage.cards.p.PeregrinTook.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phial of Galadriel", 248, Rarity.RARE, mage.cards.p.PhialOfGaladriel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phial of Galadriel", 382, Rarity.RARE, mage.cards.p.PhialOfGaladriel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phial of Galadriel", 699, Rarity.RARE, mage.cards.p.PhialOfGaladriel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phial of Galadriel", 793, Rarity.RARE, mage.cards.p.PhialOfGaladriel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pippin's Bravery", 182, Rarity.COMMON, mage.cards.p.PippinsBravery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pippin's Bravery", 414, Rarity.COMMON, mage.cards.p.PippinsBravery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pippin's Bravery", 633, Rarity.COMMON, mage.cards.p.PippinsBravery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pippin, Guard of the Citadel", 218, Rarity.RARE, mage.cards.p.PippinGuardOfTheCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pippin, Guard of the Citadel", 326, Rarity.RARE, mage.cards.p.PippinGuardOfTheCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pippin, Guard of the Citadel", 438, Rarity.RARE, mage.cards.p.PippinGuardOfTheCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pippin, Guard of the Citadel", 669, Rarity.RARE, mage.cards.p.PippinGuardOfTheCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pippin, Guard of the Citadel", 818, Rarity.RARE, mage.cards.p.PippinGuardOfTheCitadel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 262, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 263, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 272, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Plains", 273, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Plains", 713, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Plains", 714, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Press the Enemy", 352, Rarity.RARE, mage.cards.p.PressTheEnemy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Press the Enemy", 516, Rarity.RARE, mage.cards.p.PressTheEnemy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Press the Enemy", 65, Rarity.RARE, mage.cards.p.PressTheEnemy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Press the Enemy", 763, Rarity.RARE, mage.cards.p.PressTheEnemy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prince Imrahil the Fair", 219, Rarity.UNCOMMON, mage.cards.p.PrinceImrahilTheFair.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prince Imrahil the Fair", 431, Rarity.UNCOMMON, mage.cards.p.PrinceImrahilTheFair.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prince Imrahil the Fair", 670, Rarity.UNCOMMON, mage.cards.p.PrinceImrahilTheFair.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Protector of Gondor", 25, Rarity.COMMON, mage.cards.p.ProtectorOfGondor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Protector of Gondor", 476, Rarity.COMMON, mage.cards.p.ProtectorOfGondor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quarrel's End", 141, Rarity.COMMON, mage.cards.q.QuarrelsEnd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quarrel's End", 592, Rarity.COMMON, mage.cards.q.QuarrelsEnd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quickbeam, Upstart Ent", 183, Rarity.UNCOMMON, mage.cards.q.QuickbeamUpstartEnt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quickbeam, Upstart Ent", 419, Rarity.UNCOMMON, mage.cards.q.QuickbeamUpstartEnt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quickbeam, Upstart Ent", 634, Rarity.UNCOMMON, mage.cards.q.QuickbeamUpstartEnt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radagast the Brown", 184, Rarity.MYTHIC, mage.cards.r.RadagastTheBrown.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radagast the Brown", 365, Rarity.MYTHIC, mage.cards.r.RadagastTheBrown.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radagast the Brown", 635, Rarity.MYTHIC, mage.cards.r.RadagastTheBrown.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radagast the Brown", 740, Rarity.MYTHIC, mage.cards.r.RadagastTheBrown.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radagast the Brown", 776, Rarity.MYTHIC, mage.cards.r.RadagastTheBrown.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rally at the Hornburg", 142, Rarity.COMMON, mage.cards.r.RallyAtTheHornburg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rally at the Hornburg", 593, Rarity.COMMON, mage.cards.r.RallyAtTheHornburg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ranger's Firebrand", 143, Rarity.UNCOMMON, mage.cards.r.RangersFirebrand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ranger's Firebrand", 594, Rarity.UNCOMMON, mage.cards.r.RangersFirebrand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rangers of Ithilien", 353, Rarity.RARE, mage.cards.r.RangersOfIthilien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rangers of Ithilien", 517, Rarity.RARE, mage.cards.r.RangersOfIthilien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rangers of Ithilien", 66, Rarity.RARE, mage.cards.r.RangersOfIthilien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rangers of Ithilien", 764, Rarity.RARE, mage.cards.r.RangersOfIthilien.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Relentless Rohirrim", 144, Rarity.COMMON, mage.cards.r.RelentlessRohirrim.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Relentless Rohirrim", 595, Rarity.COMMON, mage.cards.r.RelentlessRohirrim.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reprieve", 26, Rarity.UNCOMMON, mage.cards.r.Reprieve.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reprieve", 477, Rarity.UNCOMMON, mage.cards.r.Reprieve.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Revive the Shire", 185, Rarity.COMMON, mage.cards.r.ReviveTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Revive the Shire", 636, Rarity.COMMON, mage.cards.r.ReviveTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riders of the Mark", 827, Rarity.RARE, mage.cards.r.RidersOfTheMark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riders of the Mark", 832, Rarity.RARE, mage.cards.r.RidersOfTheMark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ringsight", 220, Rarity.UNCOMMON, mage.cards.r.Ringsight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ringsight", 671, Rarity.UNCOMMON, mage.cards.r.Ringsight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ringwraiths", 284, Rarity.RARE, mage.cards.r.Ringwraiths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ringwraiths", 385, Rarity.RARE, mage.cards.r.Ringwraiths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rise of the Witch-king", 221, Rarity.UNCOMMON, mage.cards.r.RiseOfTheWitchKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rise of the Witch-king", 672, Rarity.UNCOMMON, mage.cards.r.RiseOfTheWitchKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rising of the Day", 145, Rarity.UNCOMMON, mage.cards.r.RisingOfTheDay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rising of the Day", 427, Rarity.UNCOMMON, mage.cards.r.RisingOfTheDay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rising of the Day", 596, Rarity.UNCOMMON, mage.cards.r.RisingOfTheDay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rivendell", 259, Rarity.RARE, mage.cards.r.Rivendell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rivendell", 344, Rarity.RARE, mage.cards.r.Rivendell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rivendell", 710, Rarity.RARE, mage.cards.r.Rivendell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rivendell", 755, Rarity.RARE, mage.cards.r.Rivendell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rohirrim Lancer", 146, Rarity.COMMON, mage.cards.r.RohirrimLancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rohirrim Lancer", 597, Rarity.COMMON, mage.cards.r.RohirrimLancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rosie Cotton of South Lane", 27, Rarity.UNCOMMON, mage.cards.r.RosieCottonOfSouthLane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rosie Cotton of South Lane", 440, Rarity.UNCOMMON, mage.cards.r.RosieCottonOfSouthLane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rosie Cotton of South Lane", 478, Rarity.UNCOMMON, mage.cards.r.RosieCottonOfSouthLane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rush the Room", 147, Rarity.COMMON, mage.cards.r.RushTheRoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rush the Room", 598, Rarity.COMMON, mage.cards.r.RushTheRoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sam's Desperate Rescue", 105, Rarity.COMMON, mage.cards.s.SamsDesperateRescue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sam's Desperate Rescue", 556, Rarity.COMMON, mage.cards.s.SamsDesperateRescue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samwise Gamgee", 222, Rarity.RARE, mage.cards.s.SamwiseGamgee.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samwise Gamgee", 327, Rarity.RARE, mage.cards.s.SamwiseGamgee.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samwise Gamgee", 673, Rarity.RARE, mage.cards.s.SamwiseGamgee.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samwise Gamgee", 819, Rarity.RARE, mage.cards.s.SamwiseGamgee.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samwise the Stouthearted", 28, Rarity.UNCOMMON, mage.cards.s.SamwiseTheStouthearted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samwise the Stouthearted", 306, Rarity.UNCOMMON, mage.cards.s.SamwiseTheStouthearted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samwise the Stouthearted", 449, Rarity.UNCOMMON, mage.cards.s.SamwiseTheStouthearted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samwise the Stouthearted", 479, Rarity.UNCOMMON, mage.cards.s.SamwiseTheStouthearted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samwise the Stouthearted", 798, Rarity.UNCOMMON, mage.cards.s.SamwiseTheStouthearted.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saradoc, Master of Buckland", 282, Rarity.RARE, mage.cards.s.SaradocMasterOfBuckland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saradoc, Master of Buckland", 383, Rarity.RARE, mage.cards.s.SaradocMasterOfBuckland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman of Many Colors", 223, Rarity.MYTHIC, mage.cards.s.SarumanOfManyColors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman of Many Colors", 300, Rarity.MYTHIC, mage.cards.s.SarumanOfManyColors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman of Many Colors", 328, Rarity.MYTHIC, mage.cards.s.SarumanOfManyColors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman of Many Colors", 412, Rarity.MYTHIC, mage.cards.s.SarumanOfManyColors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman of Many Colors", 674, Rarity.MYTHIC, mage.cards.s.SarumanOfManyColors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman of Many Colors", 743, Rarity.MYTHIC, mage.cards.s.SarumanOfManyColors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman of Many Colors", 820, Rarity.MYTHIC, mage.cards.s.SarumanOfManyColors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman the White", 518, Rarity.UNCOMMON, mage.cards.s.SarumanTheWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman the White", 67, Rarity.UNCOMMON, mage.cards.s.SarumanTheWhite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman's Trickery", 519, Rarity.UNCOMMON, mage.cards.s.SarumansTrickery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saruman's Trickery", 68, Rarity.UNCOMMON, mage.cards.s.SarumansTrickery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron's Ransom", 225, Rarity.RARE, mage.cards.s.SauronsRansom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron's Ransom", 371, Rarity.RARE, mage.cards.s.SauronsRansom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron's Ransom", 676, Rarity.RARE, mage.cards.s.SauronsRansom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron's Ransom", 782, Rarity.RARE, mage.cards.s.SauronsRansom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Dark Lord", 224, Rarity.MYTHIC, mage.cards.s.SauronTheDarkLord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Dark Lord", 301, Rarity.MYTHIC, mage.cards.s.SauronTheDarkLord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Dark Lord", 329, Rarity.MYTHIC, mage.cards.s.SauronTheDarkLord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Dark Lord", 675, Rarity.MYTHIC, mage.cards.s.SauronTheDarkLord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Dark Lord", 744, Rarity.MYTHIC, mage.cards.s.SauronTheDarkLord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Dark Lord", 821, Rarity.MYTHIC, mage.cards.s.SauronTheDarkLord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Lidless Eye", 288, Rarity.MYTHIC, mage.cards.s.SauronTheLidlessEye.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Lidless Eye", 396, Rarity.MYTHIC, mage.cards.s.SauronTheLidlessEye.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Necromancer", 106, Rarity.RARE, mage.cards.s.SauronTheNecromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Necromancer", 310, Rarity.RARE, mage.cards.s.SauronTheNecromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Necromancer", 557, Rarity.RARE, mage.cards.s.SauronTheNecromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sauron, the Necromancer", 802, Rarity.RARE, mage.cards.s.SauronTheNecromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scroll of Isildur", 520, Rarity.RARE, mage.cards.s.ScrollOfIsildur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scroll of Isildur", 69, Rarity.RARE, mage.cards.s.ScrollOfIsildur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Second Breakfast", 29, Rarity.COMMON, mage.cards.s.SecondBreakfast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Second Breakfast", 480, Rarity.COMMON, mage.cards.s.SecondBreakfast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadow Summoning", 226, Rarity.UNCOMMON, mage.cards.s.ShadowSummoning.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadow Summoning", 677, Rarity.UNCOMMON, mage.cards.s.ShadowSummoning.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadow of the Enemy", 107, Rarity.MYTHIC, mage.cards.s.ShadowOfTheEnemy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadow of the Enemy", 424, Rarity.MYTHIC, mage.cards.s.ShadowOfTheEnemy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadow of the Enemy", 558, Rarity.MYTHIC, mage.cards.s.ShadowOfTheEnemy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadow of the Enemy", 735, Rarity.MYTHIC, mage.cards.s.ShadowOfTheEnemy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowfax, Lord of Horses", 227, Rarity.UNCOMMON, mage.cards.s.ShadowfaxLordOfHorses.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowfax, Lord of Horses", 678, Rarity.UNCOMMON, mage.cards.s.ShadowfaxLordOfHorses.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shagrat, Loot Bearer", 228, Rarity.RARE, mage.cards.s.ShagratLootBearer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shagrat, Loot Bearer", 372, Rarity.RARE, mage.cards.s.ShagratLootBearer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shagrat, Loot Bearer", 679, Rarity.RARE, mage.cards.s.ShagratLootBearer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shagrat, Loot Bearer", 783, Rarity.RARE, mage.cards.s.ShagratLootBearer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sharkey, Tyrant of the Shire", 229, Rarity.RARE, mage.cards.s.SharkeyTyrantOfTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sharkey, Tyrant of the Shire", 373, Rarity.RARE, mage.cards.s.SharkeyTyrantOfTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sharkey, Tyrant of the Shire", 680, Rarity.RARE, mage.cards.s.SharkeyTyrantOfTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sharkey, Tyrant of the Shire", 784, Rarity.RARE, mage.cards.s.SharkeyTyrantOfTheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shelob's Ambush", 108, Rarity.COMMON, mage.cards.s.ShelobsAmbush.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shelob's Ambush", 559, Rarity.COMMON, mage.cards.s.ShelobsAmbush.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shelob, Child of Ungoliant", 230, Rarity.RARE, mage.cards.s.ShelobChildOfUngoliant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shelob, Child of Ungoliant", 374, Rarity.RARE, mage.cards.s.ShelobChildOfUngoliant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shelob, Child of Ungoliant", 681, Rarity.RARE, mage.cards.s.ShelobChildOfUngoliant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shelob, Child of Ungoliant", 785, Rarity.RARE, mage.cards.s.ShelobChildOfUngoliant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shire Scarecrow", 249, Rarity.COMMON, mage.cards.s.ShireScarecrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shire Scarecrow", 700, Rarity.COMMON, mage.cards.s.ShireScarecrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shire Shirriff", 30, Rarity.UNCOMMON, mage.cards.s.ShireShirriff.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shire Shirriff", 441, Rarity.UNCOMMON, mage.cards.s.ShireShirriff.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shire Shirriff", 481, Rarity.UNCOMMON, mage.cards.s.ShireShirriff.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shire Terrace", 261, Rarity.COMMON, mage.cards.s.ShireTerrace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shire Terrace", 712, Rarity.COMMON, mage.cards.s.ShireTerrace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shortcut to Mushrooms", 187, Rarity.UNCOMMON, mage.cards.s.ShortcutToMushrooms.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shortcut to Mushrooms", 638, Rarity.UNCOMMON, mage.cards.s.ShortcutToMushrooms.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shower of Arrows", 188, Rarity.COMMON, mage.cards.s.ShowerOfArrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shower of Arrows", 639, Rarity.COMMON, mage.cards.s.ShowerOfArrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Slip On the Ring", 31, Rarity.COMMON, mage.cards.s.SlipOnTheRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Slip On the Ring", 482, Rarity.COMMON, mage.cards.s.SlipOnTheRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smeagol, Helpful Guide", 231, Rarity.RARE, mage.cards.s.SmeagolHelpfulGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smeagol, Helpful Guide", 330, Rarity.RARE, mage.cards.s.SmeagolHelpfulGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smeagol, Helpful Guide", 682, Rarity.RARE, mage.cards.s.SmeagolHelpfulGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smeagol, Helpful Guide", 822, Rarity.RARE, mage.cards.s.SmeagolHelpfulGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smite the Deathless", 148, Rarity.COMMON, mage.cards.s.SmiteTheDeathless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smite the Deathless", 599, Rarity.COMMON, mage.cards.s.SmiteTheDeathless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snarling Warg", 109, Rarity.COMMON, mage.cards.s.SnarlingWarg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snarling Warg", 560, Rarity.COMMON, mage.cards.s.SnarlingWarg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soldier of the Grey Host", 32, Rarity.COMMON, mage.cards.s.SoldierOfTheGreyHost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soldier of the Grey Host", 483, Rarity.COMMON, mage.cards.s.SoldierOfTheGreyHost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soothing of Smeagol", 521, Rarity.COMMON, mage.cards.s.SoothingOfSmeagol.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soothing of Smeagol", 70, Rarity.COMMON, mage.cards.s.SoothingOfSmeagol.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spiteful Banditry", 149, Rarity.MYTHIC, mage.cards.s.SpitefulBanditry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spiteful Banditry", 439, Rarity.MYTHIC, mage.cards.s.SpitefulBanditry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spiteful Banditry", 600, Rarity.MYTHIC, mage.cards.s.SpitefulBanditry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spiteful Banditry", 738, Rarity.MYTHIC, mage.cards.s.SpitefulBanditry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stalwarts of Osgiliath", 33, Rarity.COMMON, mage.cards.s.StalwartsOfOsgiliath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stalwarts of Osgiliath", 484, Rarity.COMMON, mage.cards.s.StalwartsOfOsgiliath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stern Scolding", 522, Rarity.UNCOMMON, mage.cards.s.SternScolding.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stern Scolding", 71, Rarity.UNCOMMON, mage.cards.s.SternScolding.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stew the Coneys", 189, Rarity.UNCOMMON, mage.cards.s.StewTheConeys.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stew the Coneys", 640, Rarity.UNCOMMON, mage.cards.s.StewTheConeys.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sting, the Glinting Dagger", 250, Rarity.RARE, mage.cards.s.StingTheGlintingDagger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sting, the Glinting Dagger", 409, Rarity.RARE, mage.cards.s.StingTheGlintingDagger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sting, the Glinting Dagger", 701, Rarity.RARE, mage.cards.s.StingTheGlintingDagger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stone of Erech", 251, Rarity.UNCOMMON, mage.cards.s.StoneOfErech.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stone of Erech", 702, Rarity.UNCOMMON, mage.cards.s.StoneOfErech.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Storm of Saruman", 413, Rarity.MYTHIC, mage.cards.s.StormOfSaruman.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Storm of Saruman", 523, Rarity.MYTHIC, mage.cards.s.StormOfSaruman.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Storm of Saruman", 72, Rarity.MYTHIC, mage.cards.s.StormOfSaruman.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Storm of Saruman", 733, Rarity.MYTHIC, mage.cards.s.StormOfSaruman.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Strider, Ranger of the North", 232, Rarity.UNCOMMON, mage.cards.s.StriderRangerOfTheNorth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Strider, Ranger of the North", 683, Rarity.UNCOMMON, mage.cards.s.StriderRangerOfTheNorth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Surrounded by Orcs", 524, Rarity.COMMON, mage.cards.s.SurroundedByOrcs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Surrounded by Orcs", 73, Rarity.COMMON, mage.cards.s.SurroundedByOrcs.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 266, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 267, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 276, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 277, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 717, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 718, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swarming of Moria", 150, Rarity.COMMON, mage.cards.s.SwarmingOfMoria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swarming of Moria", 601, Rarity.COMMON, mage.cards.s.SwarmingOfMoria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tale of Tinuviel", 34, Rarity.UNCOMMON, mage.cards.t.TaleOfTinuviel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tale of Tinuviel", 485, Rarity.UNCOMMON, mage.cards.t.TaleOfTinuviel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Balrog, Durin's Bane", 195, Rarity.RARE, mage.cards.t.TheBalrogDurinsBane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Balrog, Durin's Bane", 405, Rarity.RARE, mage.cards.t.TheBalrogDurinsBane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Balrog, Durin's Bane", 646, Rarity.RARE, mage.cards.t.TheBalrogDurinsBane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Balrog, Flame of Udun", 297, Rarity.RARE, mage.cards.t.TheBalrogFlameOfUdun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Balrog, Flame of Udun", 395, Rarity.RARE, mage.cards.t.TheBalrogFlameOfUdun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Bath Song", 40, Rarity.UNCOMMON, mage.cards.t.TheBathSong.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Bath Song", 491, Rarity.UNCOMMON, mage.cards.t.TheBathSong.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Battle of Bywater", 2, Rarity.RARE, mage.cards.t.TheBattleOfBywater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Battle of Bywater", 346, Rarity.RARE, mage.cards.t.TheBattleOfBywater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Battle of Bywater", 453, Rarity.RARE, mage.cards.t.TheBattleOfBywater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Battle of Bywater", 757, Rarity.RARE, mage.cards.t.TheBattleOfBywater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Black Breath", 529, Rarity.COMMON, mage.cards.t.TheBlackBreath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Black Breath", 78, Rarity.COMMON, mage.cards.t.TheBlackBreath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Grey Havens", 255, Rarity.UNCOMMON, mage.cards.t.TheGreyHavens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Grey Havens", 443, Rarity.UNCOMMON, mage.cards.t.TheGreyHavens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Grey Havens", 706, Rarity.UNCOMMON, mage.cards.t.TheGreyHavens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Mouth of Sauron", 216, Rarity.UNCOMMON, mage.cards.t.TheMouthOfSauron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Mouth of Sauron", 667, Rarity.UNCOMMON, mage.cards.t.TheMouthOfSauron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The One Ring", "001", Rarity.MYTHIC, mage.cards.t.TheOneRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The One Ring", 246, Rarity.MYTHIC, mage.cards.t.TheOneRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The One Ring", 380, Rarity.MYTHIC, mage.cards.t.TheOneRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The One Ring", 451, Rarity.MYTHIC, mage.cards.t.TheOneRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The One Ring", 697, Rarity.MYTHIC, mage.cards.t.TheOneRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The One Ring", 748, Rarity.MYTHIC, mage.cards.t.TheOneRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The One Ring", 791, Rarity.MYTHIC, mage.cards.t.TheOneRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ring Goes South", 186, Rarity.RARE, mage.cards.t.TheRingGoesSouth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ring Goes South", 366, Rarity.RARE, mage.cards.t.TheRingGoesSouth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ring Goes South", 637, Rarity.RARE, mage.cards.t.TheRingGoesSouth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ring Goes South", 777, Rarity.RARE, mage.cards.t.TheRingGoesSouth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Shire", 260, Rarity.RARE, mage.cards.t.TheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Shire", 345, Rarity.RARE, mage.cards.t.TheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Shire", 711, Rarity.RARE, mage.cards.t.TheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Shire", 756, Rarity.RARE, mage.cards.t.TheShire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Torment of Gollum", 110, Rarity.COMMON, mage.cards.t.TheTormentOfGollum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Torment of Gollum", 561, Rarity.COMMON, mage.cards.t.TheTormentOfGollum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Watcher in the Water", 354, Rarity.MYTHIC, mage.cards.t.TheWatcherInTheWater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Watcher in the Water", 526, Rarity.MYTHIC, mage.cards.t.TheWatcherInTheWater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Watcher in the Water", 734, Rarity.MYTHIC, mage.cards.t.TheWatcherInTheWater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Watcher in the Water", 75, Rarity.MYTHIC, mage.cards.t.TheWatcherInTheWater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Watcher in the Water", 765, Rarity.MYTHIC, mage.cards.t.TheWatcherInTheWater.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Theoden, King of Rohan", 233, Rarity.UNCOMMON, mage.cards.t.TheodenKingOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Theoden, King of Rohan", 684, Rarity.UNCOMMON, mage.cards.t.TheodenKingOfRohan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("There and Back Again", 151, Rarity.RARE, mage.cards.t.ThereAndBackAgain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("There and Back Again", 602, Rarity.RARE, mage.cards.t.ThereAndBackAgain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tom Bombadil", 234, Rarity.MYTHIC, mage.cards.t.TomBombadil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tom Bombadil", 331, Rarity.MYTHIC, mage.cards.t.TomBombadil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tom Bombadil", 685, Rarity.MYTHIC, mage.cards.t.TomBombadil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tom Bombadil", 745, Rarity.MYTHIC, mage.cards.t.TomBombadil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tom Bombadil", 823, Rarity.MYTHIC, mage.cards.t.TomBombadil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Took Reaper", 35, Rarity.COMMON, mage.cards.t.TookReaper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Took Reaper", 486, Rarity.COMMON, mage.cards.t.TookReaper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trailblazer's Boots", 398, Rarity.RARE, mage.cards.t.TrailblazersBoots.class));
        cards.add(new SetCardInfo("Treason of Isengard", 525, Rarity.COMMON, mage.cards.t.TreasonOfIsengard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Treason of Isengard", 74, Rarity.COMMON, mage.cards.t.TreasonOfIsengard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Troll of Khazad-dum", 111, Rarity.COMMON, mage.cards.t.TrollOfKhazadDum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Troll of Khazad-dum", 562, Rarity.COMMON, mage.cards.t.TrollOfKhazadDum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ugluk of the White Hand", 235, Rarity.UNCOMMON, mage.cards.u.UglukOfTheWhiteHand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ugluk of the White Hand", 686, Rarity.UNCOMMON, mage.cards.u.UglukOfTheWhiteHand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Uruk-hai Berserker", 112, Rarity.COMMON, mage.cards.u.UrukHaiBerserker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Uruk-hai Berserker", 563, Rarity.COMMON, mage.cards.u.UrukHaiBerserker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voracious Fell Beast", 113, Rarity.UNCOMMON, mage.cards.v.VoraciousFellBeast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voracious Fell Beast", 422, Rarity.UNCOMMON, mage.cards.v.VoraciousFellBeast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voracious Fell Beast", 564, Rarity.UNCOMMON, mage.cards.v.VoraciousFellBeast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("War of the Last Alliance", 36, Rarity.RARE, mage.cards.w.WarOfTheLastAlliance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("War of the Last Alliance", 487, Rarity.RARE, mage.cards.w.WarOfTheLastAlliance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warbeast of Gorgoroth", 152, Rarity.COMMON, mage.cards.w.WarbeastOfGorgoroth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warbeast of Gorgoroth", 603, Rarity.COMMON, mage.cards.w.WarbeastOfGorgoroth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warg Rider", 826, Rarity.RARE, mage.cards.w.WargRider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warg Rider", 831, Rarity.RARE, mage.cards.w.WargRider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Westfold Rider", 37, Rarity.COMMON, mage.cards.w.WestfoldRider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Westfold Rider", 488, Rarity.COMMON, mage.cards.w.WestfoldRider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Willow-Wind", 527, Rarity.COMMON, mage.cards.w.WillowWind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Willow-Wind", 76, Rarity.COMMON, mage.cards.w.WillowWind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witch-king of Angmar", 114, Rarity.MYTHIC, mage.cards.w.WitchKingOfAngmar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witch-king of Angmar", 311, Rarity.MYTHIC, mage.cards.w.WitchKingOfAngmar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witch-king of Angmar", 423, Rarity.MYTHIC, mage.cards.w.WitchKingOfAngmar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witch-king of Angmar", 565, Rarity.MYTHIC, mage.cards.w.WitchKingOfAngmar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witch-king of Angmar", 736, Rarity.MYTHIC, mage.cards.w.WitchKingOfAngmar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witch-king of Angmar", 803, Rarity.MYTHIC, mage.cards.w.WitchKingOfAngmar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witch-king, Bringer of Ruin", 293, Rarity.RARE, mage.cards.w.WitchKingBringerOfRuin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witch-king, Bringer of Ruin", 391, Rarity.RARE, mage.cards.w.WitchKingBringerOfRuin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wizard's Rockets", 252, Rarity.COMMON, mage.cards.w.WizardsRockets.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wizard's Rockets", 400, Rarity.COMMON, mage.cards.w.WizardsRockets.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wizard's Rockets", 703, Rarity.COMMON, mage.cards.w.WizardsRockets.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wose Pathfinder", 190, Rarity.COMMON, mage.cards.w.WosePathfinder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wose Pathfinder", 641, Rarity.COMMON, mage.cards.w.WosePathfinder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("You Cannot Pass!", 38, Rarity.UNCOMMON, mage.cards.y.YouCannotPass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("You Cannot Pass!", 489, Rarity.UNCOMMON, mage.cards.y.YouCannotPass.class, NON_FULL_USE_VARIOUS));
    }
}
