package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class TheBrothersWarCommander extends ExpansionSet {

    private static final TheBrothersWarCommander instance = new TheBrothersWarCommander();

    public static TheBrothersWarCommander getInstance() {
        return instance;
    }

    private TheBrothersWarCommander() {
        super("The Brothers' War Commander", "BRC", ExpansionSet.buildDate(2022, 11, 18), SetType.SUPPLEMENTAL);

        cards.add(new SetCardInfo("Abrade", 111, Rarity.UNCOMMON, mage.cards.a.Abrade.class));
        cards.add(new SetCardInfo("Alela, Artful Provocateur", 119, Rarity.MYTHIC, mage.cards.a.AlelaArtfulProvocateur.class));
        cards.add(new SetCardInfo("Ancient Den", 172, Rarity.COMMON, mage.cards.a.AncientDen.class));
        cards.add(new SetCardInfo("Angel of the Ruins", 68, Rarity.RARE, mage.cards.a.AngelOfTheRuins.class));
        cards.add(new SetCardInfo("Arcane Sanctum", 173, Rarity.UNCOMMON, mage.cards.a.ArcaneSanctum.class));
        cards.add(new SetCardInfo("Arcane Signet", 132, Rarity.COMMON, mage.cards.a.ArcaneSignet.class));
        cards.add(new SetCardInfo("Armix, Filigree Thrasher", 103, Rarity.UNCOMMON, mage.cards.a.ArmixFiligreeThrasher.class));
        cards.add(new SetCardInfo("Ash Barrens", 174, Rarity.COMMON, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Ashnod the Uncaring", 4, Rarity.MYTHIC, mage.cards.a.AshnodTheUncaring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashnod the Uncaring", 47, Rarity.MYTHIC, mage.cards.a.AshnodTheUncaring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Audacious Reshapers", 112, Rarity.RARE, mage.cards.a.AudaciousReshapers.class));
        cards.add(new SetCardInfo("Austere Command", 69, Rarity.RARE, mage.cards.a.AustereCommand.class));
        cards.add(new SetCardInfo("Azorius Chancery", 175, Rarity.UNCOMMON, mage.cards.a.AzoriusChancery.class));
        cards.add(new SetCardInfo("Azorius Signet", 133, Rarity.COMMON, mage.cards.a.AzoriusSignet.class));
        cards.add(new SetCardInfo("Baleful Strix", 120, Rarity.RARE, mage.cards.b.BalefulStrix.class));
        cards.add(new SetCardInfo("Bedevil", 121, Rarity.RARE, mage.cards.b.Bedevil.class));
        cards.add(new SetCardInfo("Bident of Thassa", 80, Rarity.RARE, mage.cards.b.BidentOfThassa.class));
        cards.add(new SetCardInfo("Blasphemous Act", 113, Rarity.RARE, mage.cards.b.BlasphemousAct.class));
        cards.add(new SetCardInfo("Blast-Furnace Hellkite", 12, Rarity.RARE, mage.cards.b.BlastFurnaceHellkite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blast-Furnace Hellkite", 59, Rarity.RARE, mage.cards.b.BlastFurnaceHellkite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bojuka Bog", 176, Rarity.COMMON, mage.cards.b.BojukaBog.class));
        cards.add(new SetCardInfo("Bronze Guardian", 70, Rarity.RARE, mage.cards.b.BronzeGuardian.class));
        cards.add(new SetCardInfo("Brudiclad, Telchor Engineer", 122, Rarity.RARE, mage.cards.b.BrudicladTelchorEngineer.class));
        cards.add(new SetCardInfo("Buried Ruin", 177, Rarity.UNCOMMON, mage.cards.b.BuriedRuin.class));
        cards.add(new SetCardInfo("Chaos Warp", 114, Rarity.RARE, mage.cards.c.ChaosWarp.class));
        cards.add(new SetCardInfo("Chief of the Foundry", 134, Rarity.UNCOMMON, mage.cards.c.ChiefOfTheFoundry.class));
        cards.add(new SetCardInfo("Chrome Courier", 123, Rarity.COMMON, mage.cards.c.ChromeCourier.class));
        cards.add(new SetCardInfo("Command Tower", 178, Rarity.COMMON, mage.cards.c.CommandTower.class));
        cards.add(new SetCardInfo("Commander's Sphere", 135, Rarity.COMMON, mage.cards.c.CommandersSphere.class));
        cards.add(new SetCardInfo("Cranial Plating", 136, Rarity.UNCOMMON, mage.cards.c.CranialPlating.class));
        cards.add(new SetCardInfo("Crumbling Necropolis", 179, Rarity.UNCOMMON, mage.cards.c.CrumblingNecropolis.class));
        cards.add(new SetCardInfo("Cursed Mirror", 115, Rarity.RARE, mage.cards.c.CursedMirror.class));
        cards.add(new SetCardInfo("Darksteel Citadel", 180, Rarity.UNCOMMON, mage.cards.d.DarksteelCitadel.class));
        cards.add(new SetCardInfo("Darksteel Juggernaut", 137, Rarity.RARE, mage.cards.d.DarksteelJuggernaut.class));
        cards.add(new SetCardInfo("Darkwater Catacombs", 181, Rarity.RARE, mage.cards.d.DarkwaterCatacombs.class));
        cards.add(new SetCardInfo("Despark", 124, Rarity.UNCOMMON, mage.cards.d.Despark.class));
        cards.add(new SetCardInfo("Digsite Engineer", 71, Rarity.RARE, mage.cards.d.DigsiteEngineer.class));
        cards.add(new SetCardInfo("Dimir Aqueduct", 182, Rarity.UNCOMMON, mage.cards.d.DimirAqueduct.class));
        cards.add(new SetCardInfo("Dimir Signet", 138, Rarity.COMMON, mage.cards.d.DimirSignet.class));
        cards.add(new SetCardInfo("Disciple of Caelus Nin", 21, Rarity.RARE, mage.cards.d.DiscipleOfCaelusNin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disciple of Caelus Nin", 41, Rarity.RARE, mage.cards.d.DiscipleOfCaelusNin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreamstone Hedron", 139, Rarity.UNCOMMON, mage.cards.d.DreamstoneHedron.class));
        cards.add(new SetCardInfo("Drossforge Bridge", 183, Rarity.COMMON, mage.cards.d.DrossforgeBridge.class));
        cards.add(new SetCardInfo("Emry, Lurker of the Loch", 81, Rarity.RARE, mage.cards.e.EmryLurkerOfTheLoch.class));
        cards.add(new SetCardInfo("Etched Champion", 140, Rarity.RARE, mage.cards.e.EtchedChampion.class));
        cards.add(new SetCardInfo("Etherium Sculptor", 82, Rarity.COMMON, mage.cards.e.EtheriumSculptor.class));
        cards.add(new SetCardInfo("Ethersworn Adjudicator", 83, Rarity.MYTHIC, mage.cards.e.EtherswornAdjudicator.class));
        cards.add(new SetCardInfo("Evolving Wilds", 184, Rarity.COMMON, mage.cards.e.EvolvingWilds.class));
        cards.add(new SetCardInfo("Executioner's Capsule", 104, Rarity.COMMON, mage.cards.e.ExecutionersCapsule.class));
        cards.add(new SetCardInfo("Exotic Orchard", 185, Rarity.RARE, mage.cards.e.ExoticOrchard.class));
        cards.add(new SetCardInfo("Expressive Iteration", 125, Rarity.UNCOMMON, mage.cards.e.ExpressiveIteration.class));
        cards.add(new SetCardInfo("Fact or Fiction", 84, Rarity.UNCOMMON, mage.cards.f.FactOrFiction.class));
        cards.add(new SetCardInfo("Fain, the Broker", 105, Rarity.RARE, mage.cards.f.FainTheBroker.class));
        cards.add(new SetCardInfo("Faithless Looting", 116, Rarity.COMMON, mage.cards.f.FaithlessLooting.class));
        cards.add(new SetCardInfo("Farid, Enterprising Salvager", 13, Rarity.RARE, mage.cards.f.FaridEnterprisingSalvager.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Farid, Enterprising Salvager", 60, Rarity.RARE, mage.cards.f.FaridEnterprisingSalvager.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feed the Swarm", 106, Rarity.COMMON, mage.cards.f.FeedTheSwarm.class));
        cards.add(new SetCardInfo("Fellwar Stone", 141, Rarity.UNCOMMON, mage.cards.f.FellwarStone.class));
        cards.add(new SetCardInfo("Filigree Attendant", 85, Rarity.UNCOMMON, mage.cards.f.FiligreeAttendant.class));
        cards.add(new SetCardInfo("Geth, Lord of the Vault", 107, Rarity.MYTHIC, mage.cards.g.GethLordOfTheVault.class));
        cards.add(new SetCardInfo("Glint Raker", 54, Rarity.RARE, mage.cards.g.GlintRaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glint Raker", 7, Rarity.RARE, mage.cards.g.GlintRaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goldmire Bridge", 186, Rarity.COMMON, mage.cards.g.GoldmireBridge.class));
        cards.add(new SetCardInfo("Great Furnace", 187, Rarity.COMMON, mage.cards.g.GreatFurnace.class));
        cards.add(new SetCardInfo("Hedron Archive", 142, Rarity.UNCOMMON, mage.cards.h.HedronArchive.class));
        cards.add(new SetCardInfo("Hellkite Igniter", 117, Rarity.RARE, mage.cards.h.HellkiteIgniter.class));
        cards.add(new SetCardInfo("Herald of Anguish", 108, Rarity.MYTHIC, mage.cards.h.HeraldOfAnguish.class));
        cards.add(new SetCardInfo("Hexavus", 14, Rarity.RARE, mage.cards.h.Hexavus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hexavus", 61, Rarity.RARE, mage.cards.h.Hexavus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ichor Wellspring", 143, Rarity.UNCOMMON, mage.cards.i.IchorWellspring.class));
        cards.add(new SetCardInfo("Idol of Oblivion", 144, Rarity.RARE, mage.cards.i.IdolOfOblivion.class));
        cards.add(new SetCardInfo("Indomitable Archangel", 72, Rarity.MYTHIC, mage.cards.i.IndomitableArchangel.class));
        cards.add(new SetCardInfo("Island", 31, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 32, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Boilerworks", 188, Rarity.UNCOMMON, mage.cards.i.IzzetBoilerworks.class));
        cards.add(new SetCardInfo("Jhoira, Weatherlight Captain", 126, Rarity.MYTHIC, mage.cards.j.JhoiraWeatherlightCaptain.class));
        cards.add(new SetCardInfo("Kayla's Music Box", 15, Rarity.RARE, mage.cards.k.KaylasMusicBox.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kayla's Music Box", 62, Rarity.RARE, mage.cards.k.KaylasMusicBox.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liquimetal Torque", 145, Rarity.UNCOMMON, mage.cards.l.LiquimetalTorque.class));
        cards.add(new SetCardInfo("Lithoform Engine", 146, Rarity.MYTHIC, mage.cards.l.LithoformEngine.class));
        cards.add(new SetCardInfo("Losheel, Clockwork Scholar", 73, Rarity.RARE, mage.cards.l.LosheelClockworkScholar.class));
        cards.add(new SetCardInfo("Machine God's Effigy", 16, Rarity.RARE, mage.cards.m.MachineGodsEffigy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Machine God's Effigy", 63, Rarity.RARE, mage.cards.m.MachineGodsEffigy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("March of Progress", 55, Rarity.RARE, mage.cards.m.MarchOfProgress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("March of Progress", 8, Rarity.RARE, mage.cards.m.MarchOfProgress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Marionette Master", 109, Rarity.RARE, mage.cards.m.MarionetteMaster.class));
        cards.add(new SetCardInfo("Master Transmuter", 87, Rarity.RARE, mage.cards.m.MasterTransmuter.class));
        cards.add(new SetCardInfo("Master of Etherium", 86, Rarity.RARE, mage.cards.m.MasterOfEtherium.class));
        cards.add(new SetCardInfo("Metalwork Colossus", 147, Rarity.RARE, mage.cards.m.MetalworkColossus.class));
        cards.add(new SetCardInfo("Mind Stone", 148, Rarity.UNCOMMON, mage.cards.m.MindStone.class));
        cards.add(new SetCardInfo("Mirrorworks", 149, Rarity.RARE, mage.cards.m.Mirrorworks.class));
        cards.add(new SetCardInfo("Mishra, Eminent One", 1, Rarity.MYTHIC, mage.cards.m.MishraEminentOne.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra, Eminent One", 39, Rarity.MYTHIC, mage.cards.m.MishraEminentOne.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra, Eminent One", 48, Rarity.MYTHIC, mage.cards.m.MishraEminentOne.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mistvault Bridge", 189, Rarity.COMMON, mage.cards.m.MistvaultBridge.class));
        cards.add(new SetCardInfo("Mnemonic Sphere", 88, Rarity.COMMON, mage.cards.m.MnemonicSphere.class));
        cards.add(new SetCardInfo("Mountain", 35, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 36, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Muzzio, Visionary Architect", 89, Rarity.MYTHIC, mage.cards.m.MuzzioVisionaryArchitect.class));
        cards.add(new SetCardInfo("Mycosynth Wellspring", 150, Rarity.COMMON, mage.cards.m.MycosynthWellspring.class));
        cards.add(new SetCardInfo("Myr Battlesphere", 151, Rarity.RARE, mage.cards.m.MyrBattlesphere.class));
        cards.add(new SetCardInfo("Myriad Landscape", 190, Rarity.UNCOMMON, mage.cards.m.MyriadLandscape.class));
        cards.add(new SetCardInfo("Nihil Spellbomb", 152, Rarity.COMMON, mage.cards.n.NihilSpellbomb.class));
        cards.add(new SetCardInfo("Noxious Gearhulk", 110, Rarity.MYTHIC, mage.cards.n.NoxiousGearhulk.class));
        cards.add(new SetCardInfo("Oblivion Stone", 153, Rarity.RARE, mage.cards.o.OblivionStone.class));
        cards.add(new SetCardInfo("One with the Machine", 90, Rarity.RARE, mage.cards.o.OneWithTheMachine.class));
        cards.add(new SetCardInfo("Oni-Cult Anvil", 127, Rarity.UNCOMMON, mage.cards.o.OniCultAnvil.class));
        cards.add(new SetCardInfo("Orzhov Basilica", 191, Rarity.UNCOMMON, mage.cards.o.OrzhovBasilica.class));
        cards.add(new SetCardInfo("Orzhov Signet", 154, Rarity.COMMON, mage.cards.o.OrzhovSignet.class));
        cards.add(new SetCardInfo("Padeem, Consul of Innovation", 91, Rarity.RARE, mage.cards.p.PadeemConsulOfInnovation.class));
        cards.add(new SetCardInfo("Path of Ancestry", 192, Rarity.COMMON, mage.cards.p.PathOfAncestry.class));
        cards.add(new SetCardInfo("Phyrexian Rebirth", 74, Rarity.RARE, mage.cards.p.PhyrexianRebirth.class));
        cards.add(new SetCardInfo("Plains", 29, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 30, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prairie Stream", 193, Rarity.RARE, mage.cards.p.PrairieStream.class));
        cards.add(new SetCardInfo("Preordain", 92, Rarity.COMMON, mage.cards.p.Preordain.class));
        cards.add(new SetCardInfo("Prophetic Prism", 155, Rarity.COMMON, mage.cards.p.PropheticPrism.class));
        cards.add(new SetCardInfo("Rakdos Carnarium", 194, Rarity.UNCOMMON, mage.cards.r.RakdosCarnarium.class));
        cards.add(new SetCardInfo("Rakdos Signet", 156, Rarity.COMMON, mage.cards.r.RakdosSignet.class));
        cards.add(new SetCardInfo("Razortide Bridge", 195, Rarity.COMMON, mage.cards.r.RazortideBridge.class));
        cards.add(new SetCardInfo("Relic of Progenitus", 157, Rarity.UNCOMMON, mage.cards.r.RelicOfProgenitus.class));
        cards.add(new SetCardInfo("Reliquary Tower", 196, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class));
        cards.add(new SetCardInfo("River of Tears", 197, Rarity.RARE, mage.cards.r.RiverOfTears.class));
        cards.add(new SetCardInfo("Rootpath Purifier", 24, Rarity.MYTHIC, mage.cards.r.RootpathPurifier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rootpath Purifier", 44, Rarity.MYTHIC, mage.cards.r.RootpathPurifier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sai, Master Thopterist", 93, Rarity.RARE, mage.cards.s.SaiMasterThopterist.class));
        cards.add(new SetCardInfo("Sanwell, Avenger Ace", 5, Rarity.RARE, mage.cards.s.SanwellAvengerAce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sanwell, Avenger Ace", 52, Rarity.RARE, mage.cards.s.SanwellAvengerAce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sardian Avenger", 23, Rarity.RARE, mage.cards.s.SardianAvenger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sardian Avenger", 43, Rarity.RARE, mage.cards.s.SardianAvenger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scavenged Brawler", 17, Rarity.RARE, mage.cards.s.ScavengedBrawler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scavenged Brawler", 64, Rarity.RARE, mage.cards.s.ScavengedBrawler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scholar of New Horizons", 53, Rarity.RARE, mage.cards.s.ScholarOfNewHorizons.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scholar of New Horizons", 6, Rarity.RARE, mage.cards.s.ScholarOfNewHorizons.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seat of the Synod", 198, Rarity.COMMON, mage.cards.s.SeatOfTheSynod.class));
        cards.add(new SetCardInfo("Servo Schematic", 158, Rarity.UNCOMMON, mage.cards.s.ServoSchematic.class));
        cards.add(new SetCardInfo("Shadowblood Ridge", 199, Rarity.RARE, mage.cards.s.ShadowbloodRidge.class));
        cards.add(new SetCardInfo("Sharding Sphinx", 94, Rarity.RARE, mage.cards.s.ShardingSphinx.class));
        cards.add(new SetCardInfo("Sharuum the Hegemon", 128, Rarity.RARE, mage.cards.s.SharuumTheHegemon.class));
        cards.add(new SetCardInfo("Shimmer Dragon", 95, Rarity.RARE, mage.cards.s.ShimmerDragon.class));
        cards.add(new SetCardInfo("Silas Renn, Seeker Adept", 129, Rarity.MYTHIC, mage.cards.s.SilasRennSeekerAdept.class));
        cards.add(new SetCardInfo("Silverbluff Bridge", 200, Rarity.COMMON, mage.cards.s.SilverbluffBridge.class));
        cards.add(new SetCardInfo("Skullclamp", 159, Rarity.UNCOMMON, mage.cards.s.Skullclamp.class));
        cards.add(new SetCardInfo("Skycloud Expanse", 201, Rarity.RARE, mage.cards.s.SkycloudExpanse.class));
        cards.add(new SetCardInfo("Slobad, Goblin Tinkerer", 118, Rarity.RARE, mage.cards.s.SlobadGoblinTinkerer.class));
        cards.add(new SetCardInfo("Smelting Vat", 18, Rarity.RARE, mage.cards.s.SmeltingVat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smelting Vat", 65, Rarity.RARE, mage.cards.s.SmeltingVat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smoldering Marsh", 202, Rarity.RARE, mage.cards.s.SmolderingMarsh.class));
        cards.add(new SetCardInfo("Sol Ring", 160, Rarity.UNCOMMON, mage.cards.s.SolRing.class));
        cards.add(new SetCardInfo("Solemn Simulacrum", 161, Rarity.RARE, mage.cards.s.SolemnSimulacrum.class));
        cards.add(new SetCardInfo("Sphinx's Revelation", 130, Rarity.MYTHIC, mage.cards.s.SphinxsRevelation.class));
        cards.add(new SetCardInfo("Spine of Ish Sah", 162, Rarity.RARE, mage.cards.s.SpineOfIshSah.class));
        cards.add(new SetCardInfo("Spire of Industry", 203, Rarity.RARE, mage.cards.s.SpireOfIndustry.class));
        cards.add(new SetCardInfo("Staff of Titania", 27, Rarity.RARE, mage.cards.s.StaffOfTitania.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Staff of Titania", 50, Rarity.RARE, mage.cards.s.StaffOfTitania.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steel Hellkite", 163, Rarity.RARE, mage.cards.s.SteelHellkite.class));
        cards.add(new SetCardInfo("Steel Overseer", 164, Rarity.RARE, mage.cards.s.SteelOverseer.class));
        cards.add(new SetCardInfo("Strionic Resonator", 165, Rarity.RARE, mage.cards.s.StrionicResonator.class));
        cards.add(new SetCardInfo("Sunken Hollow", 204, Rarity.RARE, mage.cards.s.SunkenHollow.class));
        cards.add(new SetCardInfo("Swamp", 33, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 34, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swiftfoot Boots", 166, Rarity.UNCOMMON, mage.cards.s.SwiftfootBoots.class));
        cards.add(new SetCardInfo("Swords to Plowshares", 75, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class));
        cards.add(new SetCardInfo("Tawnos, Solemn Survivor", 3, Rarity.MYTHIC, mage.cards.t.TawnosSolemnSurvivor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tawnos, Solemn Survivor", 42, Rarity.MYTHIC, mage.cards.t.TawnosSolemnSurvivor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tempered Steel", 76, Rarity.RARE, mage.cards.t.TemperedSteel.class));
        cards.add(new SetCardInfo("Temple of Deceit", 205, Rarity.RARE, mage.cards.t.TempleOfDeceit.class));
        cards.add(new SetCardInfo("Temple of Enlightenment", 206, Rarity.RARE, mage.cards.t.TempleOfEnlightenment.class));
        cards.add(new SetCardInfo("Temple of Epiphany", 207, Rarity.RARE, mage.cards.t.TempleOfEpiphany.class));
        cards.add(new SetCardInfo("Temple of Malice", 208, Rarity.RARE, mage.cards.t.TempleOfMalice.class));
        cards.add(new SetCardInfo("Temple of Silence", 209, Rarity.RARE, mage.cards.t.TempleOfSilence.class));
        cards.add(new SetCardInfo("Terisiare's Devastation", 56, Rarity.RARE, mage.cards.t.TerisiaresDevastation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terisiare's Devastation", 9, Rarity.RARE, mage.cards.t.TerisiaresDevastation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terramorphic Expanse", 210, Rarity.COMMON, mage.cards.t.TerramorphicExpanse.class));
        cards.add(new SetCardInfo("Teshar, Ancestor's Apostle", 77, Rarity.RARE, mage.cards.t.TesharAncestorsApostle.class));
        cards.add(new SetCardInfo("The Archimandrite", 26, Rarity.RARE, mage.cards.t.TheArchimandrite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Archimandrite", 46, Rarity.RARE, mage.cards.t.TheArchimandrite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Brothers' War", 22, Rarity.RARE, mage.cards.t.TheBrothersWar.class));
        cards.add(new SetCardInfo("Thirst for Knowledge", 96, Rarity.UNCOMMON, mage.cards.t.ThirstForKnowledge.class));
        cards.add(new SetCardInfo("Thopter Shop", 19, Rarity.RARE, mage.cards.t.ThopterShop.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thopter Shop", 66, Rarity.RARE, mage.cards.t.ThopterShop.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thopter Spy Network", 97, Rarity.RARE, mage.cards.t.ThopterSpyNetwork.class));
        cards.add(new SetCardInfo("Thought Monitor", 98, Rarity.RARE, mage.cards.t.ThoughtMonitor.class));
        cards.add(new SetCardInfo("Thought Vessel", 167, Rarity.UNCOMMON, mage.cards.t.ThoughtVessel.class));
        cards.add(new SetCardInfo("Thoughtcast", 99, Rarity.COMMON, mage.cards.t.Thoughtcast.class));
        cards.add(new SetCardInfo("Thran Dynamo", 168, Rarity.UNCOMMON, mage.cards.t.ThranDynamo.class));
        cards.add(new SetCardInfo("Titania, Nature's Force", 25, Rarity.MYTHIC, mage.cards.t.TitaniaNaturesForce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Titania, Nature's Force", 45, Rarity.MYTHIC, mage.cards.t.TitaniaNaturesForce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trading Post", 169, Rarity.RARE, mage.cards.t.TradingPost.class));
        cards.add(new SetCardInfo("Traxos, Scourge of Kroog", 170, Rarity.RARE, mage.cards.t.TraxosScourgeOfKroog.class));
        cards.add(new SetCardInfo("Unbreakable Formation", 78, Rarity.RARE, mage.cards.u.UnbreakableFormation.class));
        cards.add(new SetCardInfo("Urza's Ruinous Blast", 79, Rarity.RARE, mage.cards.u.UrzasRuinousBlast.class));
        cards.add(new SetCardInfo("Urza's Workshop", 28, Rarity.RARE, mage.cards.u.UrzasWorkshop.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urza's Workshop", 51, Rarity.RARE, mage.cards.u.UrzasWorkshop.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urza, Chief Artificer", 2, Rarity.MYTHIC, mage.cards.u.UrzaChiefArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urza, Chief Artificer", 40, Rarity.MYTHIC, mage.cards.u.UrzaChiefArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urza, Chief Artificer", 49, Rarity.MYTHIC, mage.cards.u.UrzaChiefArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vault of Whispers", 211, Rarity.COMMON, mage.cards.v.VaultOfWhispers.class));
        cards.add(new SetCardInfo("Vedalken Humiliator", 100, Rarity.RARE, mage.cards.v.VedalkenHumiliator.class));
        cards.add(new SetCardInfo("Vindicate", 131, Rarity.RARE, mage.cards.v.Vindicate.class));
        cards.add(new SetCardInfo("Wayfarer's Bauble", 171, Rarity.COMMON, mage.cards.w.WayfarersBauble.class));
        cards.add(new SetCardInfo("Whirler Rogue", 101, Rarity.UNCOMMON, mage.cards.w.WhirlerRogue.class));
        cards.add(new SetCardInfo("Wire Surgeons", 10, Rarity.RARE, mage.cards.w.WireSurgeons.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wire Surgeons", 57, Rarity.RARE, mage.cards.w.WireSurgeons.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wondrous Crucible", 20, Rarity.RARE, mage.cards.w.WondrousCrucible.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wondrous Crucible", 67, Rarity.RARE, mage.cards.w.WondrousCrucible.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Workshop Elders", 102, Rarity.RARE, mage.cards.w.WorkshopElders.class));
        cards.add(new SetCardInfo("Wreck Hunter", 11, Rarity.RARE, mage.cards.w.WreckHunter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wreck Hunter", 58, Rarity.RARE, mage.cards.w.WreckHunter.class, NON_FULL_USE_VARIOUS));
    }
}
