package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class TheBigScore extends ExpansionSet {

    private static final TheBigScore instance = new TheBigScore();

    public static TheBigScore getInstance() {
        return instance;
    }

    private TheBigScore() {
        super("The Big Score", "BIG", ExpansionSet.buildDate(2024, 4, 19), SetType.SUPPLEMENTAL_STANDARD_LEGAL);
        this.blockName = "Outlaws of Thunder Junction";
        this.hasBasicLands = false;
        this.hasBoosters = false;

        cards.add(new SetCardInfo("Ancient Cornucopia", 16, Rarity.MYTHIC, mage.cards.a.AncientCornucopia.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ancient Cornucopia", 46, Rarity.MYTHIC, mage.cards.a.AncientCornucopia.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ancient Cornucopia", 81, Rarity.MYTHIC, mage.cards.a.AncientCornucopia.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bristlebud Farmer", 17, Rarity.MYTHIC, mage.cards.b.BristlebudFarmer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bristlebud Farmer", 47, Rarity.MYTHIC, mage.cards.b.BristlebudFarmer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bristlebud Farmer", 82, Rarity.MYTHIC, mage.cards.b.BristlebudFarmer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Collector's Cage", 1, Rarity.MYTHIC, mage.cards.c.CollectorsCage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Collector's Cage", 31, Rarity.MYTHIC, mage.cards.c.CollectorsCage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Collector's Cage", 66, Rarity.MYTHIC, mage.cards.c.CollectorsCage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Esoteric Duplicator", 35, Rarity.MYTHIC, mage.cards.e.EsotericDuplicator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Esoteric Duplicator", 5, Rarity.MYTHIC, mage.cards.e.EsotericDuplicator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Esoteric Duplicator", 70, Rarity.MYTHIC, mage.cards.e.EsotericDuplicator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fomori Vault", 29, Rarity.MYTHIC, mage.cards.f.FomoriVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fomori Vault", 59, Rarity.MYTHIC, mage.cards.f.FomoriVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fomori Vault", 94, Rarity.MYTHIC, mage.cards.f.FomoriVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Generous Plunderer", 11, Rarity.MYTHIC, mage.cards.g.GenerousPlunderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Generous Plunderer", 41, Rarity.MYTHIC, mage.cards.g.GenerousPlunderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Generous Plunderer", 76, Rarity.MYTHIC, mage.cards.g.GenerousPlunderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Abolisher", 2, Rarity.MYTHIC, mage.cards.g.GrandAbolisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Abolisher", 32, Rarity.MYTHIC, mage.cards.g.GrandAbolisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Abolisher", 67, Rarity.MYTHIC, mage.cards.g.GrandAbolisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Greed's Gambit", 38, Rarity.MYTHIC, mage.cards.g.GreedsGambit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Greed's Gambit", 73, Rarity.MYTHIC, mage.cards.g.GreedsGambit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Greed's Gambit", 8, Rarity.MYTHIC, mage.cards.g.GreedsGambit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harvester of Misery", 39, Rarity.MYTHIC, mage.cards.h.HarvesterOfMisery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harvester of Misery", 74, Rarity.MYTHIC, mage.cards.h.HarvesterOfMisery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harvester of Misery", 9, Rarity.MYTHIC, mage.cards.h.HarvesterOfMisery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hostile Investigator", 10, Rarity.MYTHIC, mage.cards.h.HostileInvestigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hostile Investigator", 40, Rarity.MYTHIC, mage.cards.h.HostileInvestigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hostile Investigator", 75, Rarity.MYTHIC, mage.cards.h.HostileInvestigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legion Extruder", 12, Rarity.MYTHIC, mage.cards.l.LegionExtruder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legion Extruder", 42, Rarity.MYTHIC, mage.cards.l.LegionExtruder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legion Extruder", 77, Rarity.MYTHIC, mage.cards.l.LegionExtruder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Loot, the Key to Everything", 21, Rarity.MYTHIC, mage.cards.l.LootTheKeyToEverything.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Loot, the Key to Everything", 51, Rarity.MYTHIC, mage.cards.l.LootTheKeyToEverything.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Loot, the Key to Everything", 62, Rarity.MYTHIC, mage.cards.l.LootTheKeyToEverything.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Loot, the Key to Everything", 86, Rarity.MYTHIC, mage.cards.l.LootTheKeyToEverything.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lost Jitte", 23, Rarity.MYTHIC, mage.cards.l.LostJitte.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lost Jitte", 53, Rarity.MYTHIC, mage.cards.l.LostJitte.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lost Jitte", 88, Rarity.MYTHIC, mage.cards.l.LostJitte.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lotus Ring", 24, Rarity.MYTHIC, mage.cards.l.LotusRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lotus Ring", 54, Rarity.MYTHIC, mage.cards.l.LotusRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lotus Ring", 63, Rarity.MYTHIC, mage.cards.l.LotusRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lotus Ring", 89, Rarity.MYTHIC, mage.cards.l.LotusRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Memory Vessel", 13, Rarity.MYTHIC, mage.cards.m.MemoryVessel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Memory Vessel", 43, Rarity.MYTHIC, mage.cards.m.MemoryVessel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Memory Vessel", 78, Rarity.MYTHIC, mage.cards.m.MemoryVessel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Molten Duplication", 14, Rarity.MYTHIC, mage.cards.m.MoltenDuplication.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Molten Duplication", 44, Rarity.MYTHIC, mage.cards.m.MoltenDuplication.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Molten Duplication", 79, Rarity.MYTHIC, mage.cards.m.MoltenDuplication.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nexus of Becoming", 25, Rarity.MYTHIC, mage.cards.n.NexusOfBecoming.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nexus of Becoming", 55, Rarity.MYTHIC, mage.cards.n.NexusOfBecoming.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nexus of Becoming", 90, Rarity.MYTHIC, mage.cards.n.NexusOfBecoming.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oltec Matterweaver", 3, Rarity.MYTHIC, mage.cards.o.OltecMatterweaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oltec Matterweaver", 33, Rarity.MYTHIC, mage.cards.o.OltecMatterweaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oltec Matterweaver", 68, Rarity.MYTHIC, mage.cards.o.OltecMatterweaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Omenpath Journey", 18, Rarity.MYTHIC, mage.cards.o.OmenpathJourney.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Omenpath Journey", 48, Rarity.MYTHIC, mage.cards.o.OmenpathJourney.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Omenpath Journey", 83, Rarity.MYTHIC, mage.cards.o.OmenpathJourney.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pest Control", 22, Rarity.MYTHIC, mage.cards.p.PestControl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pest Control", 52, Rarity.MYTHIC, mage.cards.p.PestControl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pest Control", 87, Rarity.MYTHIC, mage.cards.p.PestControl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rest in Peace", 34, Rarity.MYTHIC, mage.cards.r.RestInPeace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rest in Peace", 4, Rarity.MYTHIC, mage.cards.r.RestInPeace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rest in Peace", 69, Rarity.MYTHIC, mage.cards.r.RestInPeace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sandstorm Salvager", 19, Rarity.MYTHIC, mage.cards.s.SandstormSalvager.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sandstorm Salvager", 49, Rarity.MYTHIC, mage.cards.s.SandstormSalvager.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sandstorm Salvager", 84, Rarity.MYTHIC, mage.cards.s.SandstormSalvager.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simulacrum Synthesizer", 36, Rarity.MYTHIC, mage.cards.s.SimulacrumSynthesizer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simulacrum Synthesizer", 6, Rarity.MYTHIC, mage.cards.s.SimulacrumSynthesizer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simulacrum Synthesizer", 71, Rarity.MYTHIC, mage.cards.s.SimulacrumSynthesizer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of Wealth and Power", 26, Rarity.MYTHIC, mage.cards.s.SwordOfWealthAndPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of Wealth and Power", 56, Rarity.MYTHIC, mage.cards.s.SwordOfWealthAndPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of Wealth and Power", 64, Rarity.MYTHIC, mage.cards.s.SwordOfWealthAndPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of Wealth and Power", 91, Rarity.MYTHIC, mage.cards.s.SwordOfWealthAndPower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tarnation Vista", 30, Rarity.MYTHIC, mage.cards.t.TarnationVista.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tarnation Vista", 60, Rarity.MYTHIC, mage.cards.t.TarnationVista.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tarnation Vista", 65, Rarity.MYTHIC, mage.cards.t.TarnationVista.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tarnation Vista", 95, Rarity.MYTHIC, mage.cards.t.TarnationVista.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Territory Forge", 15, Rarity.MYTHIC, mage.cards.t.TerritoryForge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Territory Forge", 45, Rarity.MYTHIC, mage.cards.t.TerritoryForge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Territory Forge", 80, Rarity.MYTHIC, mage.cards.t.TerritoryForge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Torpor Orb", 27, Rarity.MYTHIC, mage.cards.t.TorporOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Torpor Orb", 57, Rarity.MYTHIC, mage.cards.t.TorporOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Torpor Orb", 92, Rarity.MYTHIC, mage.cards.t.TorporOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Transmutation Font", 28, Rarity.MYTHIC, mage.cards.t.TransmutationFont.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Transmutation Font", 58, Rarity.MYTHIC, mage.cards.t.TransmutationFont.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Transmutation Font", 93, Rarity.MYTHIC, mage.cards.t.TransmutationFont.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vaultborn Tyrant", 20, Rarity.MYTHIC, mage.cards.v.VaultbornTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vaultborn Tyrant", 50, Rarity.MYTHIC, mage.cards.v.VaultbornTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vaultborn Tyrant", 61, Rarity.MYTHIC, mage.cards.v.VaultbornTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vaultborn Tyrant", 85, Rarity.MYTHIC, mage.cards.v.VaultbornTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Worldwalker Helm", 37, Rarity.MYTHIC, mage.cards.w.WorldwalkerHelm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Worldwalker Helm", 7, Rarity.MYTHIC, mage.cards.w.WorldwalkerHelm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Worldwalker Helm", 72, Rarity.MYTHIC, mage.cards.w.WorldwalkerHelm.class, NON_FULL_USE_VARIOUS));
    }
}
