package mage.sets;

import mage.cards.ExpansionSet;
import mage.collation.BoosterCollator;
import mage.collation.BoosterStructure;
import mage.collation.CardRun;
import mage.collation.RarityConfiguration;
import mage.constants.Rarity;
import mage.constants.SetType;

import java.util.ArrayList;
import java.util.List;

/**
 * @author TheElk801
 */
public final class StreetsOfNewCapenna extends ExpansionSet {

    private static final StreetsOfNewCapenna instance = new StreetsOfNewCapenna();

    public static StreetsOfNewCapenna getInstance() {
        return instance;
    }

    private StreetsOfNewCapenna() {
        super("Streets of New Capenna", "SNC", ExpansionSet.buildDate(2022, 4, 29), SetType.EXPANSION);
        this.blockName = "Streets of New Capenna";
        this.hasBoosters = true;
        this.hasBasicLands = true;
        this.numBoosterLands = 1;
        this.numBoosterCommon = 10;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 7;
        this.maxCardNumberInBooster = 281;

        cards.add(new SetCardInfo("A Little Chat", 47, Rarity.UNCOMMON, mage.cards.a.ALittleChat.class));
        cards.add(new SetCardInfo("All-Seeing Arbiter", 286, Rarity.MYTHIC, mage.cards.a.AllSeeingArbiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("All-Seeing Arbiter", 34, Rarity.MYTHIC, mage.cards.a.AllSeeingArbiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("An Offer You Can't Refuse", 464, Rarity.UNCOMMON, mage.cards.a.AnOfferYouCantRefuse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("An Offer You Can't Refuse", 51, Rarity.UNCOMMON, mage.cards.a.AnOfferYouCantRefuse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angel of Suffering", 416, Rarity.MYTHIC, mage.cards.a.AngelOfSuffering.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angel of Suffering", 67, Rarity.MYTHIC, mage.cards.a.AngelOfSuffering.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angelic Observer", 1, Rarity.UNCOMMON, mage.cards.a.AngelicObserver.class));
        cards.add(new SetCardInfo("Antagonize", 100, Rarity.COMMON, mage.cards.a.Antagonize.class));
        cards.add(new SetCardInfo("Arc Spitter", 233, Rarity.UNCOMMON, mage.cards.a.ArcSpitter.class));
        cards.add(new SetCardInfo("Arcane Bombardment", 101, Rarity.MYTHIC, mage.cards.a.ArcaneBombardment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Bombardment", 422, Rarity.MYTHIC, mage.cards.a.ArcaneBombardment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Attended Socialite", 133, Rarity.COMMON, mage.cards.a.AttendedSocialite.class));
        cards.add(new SetCardInfo("Aven Heartstabber", 166, Rarity.RARE, mage.cards.a.AvenHeartstabber.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aven Heartstabber", 433, Rarity.RARE, mage.cards.a.AvenHeartstabber.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Backstreet Bruiser", 35, Rarity.COMMON, mage.cards.b.BackstreetBruiser.class));
        cards.add(new SetCardInfo("Backup Agent", 2, Rarity.COMMON, mage.cards.b.BackupAgent.class));
        cards.add(new SetCardInfo("Ballroom Brawlers", 3, Rarity.UNCOMMON, mage.cards.b.BallroomBrawlers.class));
        cards.add(new SetCardInfo("Big Score", 102, Rarity.COMMON, mage.cards.b.BigScore.class));
        cards.add(new SetCardInfo("Black Market Tycoon", 167, Rarity.RARE, mage.cards.b.BlackMarketTycoon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Market Tycoon", 434, Rarity.RARE, mage.cards.b.BlackMarketTycoon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Body Dropper", 168, Rarity.COMMON, mage.cards.b.BodyDropper.class));
        cards.add(new SetCardInfo("Body Launderer", 417, Rarity.MYTHIC, mage.cards.b.BodyLaunderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Body Launderer", 68, Rarity.MYTHIC, mage.cards.b.BodyLaunderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boon of Safety", 4, Rarity.COMMON, mage.cards.b.BoonOfSafety.class));
        cards.add(new SetCardInfo("Bootleggers' Stash", 134, Rarity.MYTHIC, mage.cards.b.BootleggersStash.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bootleggers' Stash", 288, Rarity.MYTHIC, mage.cards.b.BootleggersStash.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Botanical Plaza", 247, Rarity.COMMON, mage.cards.b.BotanicalPlaza.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Botanical Plaza", 350, Rarity.COMMON, mage.cards.b.BotanicalPlaza.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bouncer's Beatdown", 135, Rarity.UNCOMMON, mage.cards.b.BouncersBeatdown.class));
        cards.add(new SetCardInfo("Brass Knuckles", 234, Rarity.UNCOMMON, mage.cards.b.BrassKnuckles.class));
        cards.add(new SetCardInfo("Brazen Upstart", 169, Rarity.UNCOMMON, mage.cards.b.BrazenUpstart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brazen Upstart", 296, Rarity.UNCOMMON, mage.cards.b.BrazenUpstart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brazen Upstart", 361, Rarity.UNCOMMON, mage.cards.b.BrazenUpstart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Broken Wings", 136, Rarity.COMMON, mage.cards.b.BrokenWings.class));
        cards.add(new SetCardInfo("Brokers Ascendancy", 170, Rarity.RARE, mage.cards.b.BrokersAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brokers Ascendancy", 297, Rarity.RARE, mage.cards.b.BrokersAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brokers Ascendancy", 362, Rarity.RARE, mage.cards.b.BrokersAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brokers Charm", 171, Rarity.UNCOMMON, mage.cards.b.BrokersCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brokers Charm", 298, Rarity.UNCOMMON, mage.cards.b.BrokersCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brokers Charm", 363, Rarity.UNCOMMON, mage.cards.b.BrokersCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brokers Hideout", 248, Rarity.COMMON, mage.cards.b.BrokersHideout.class));
        cards.add(new SetCardInfo("Brokers Initiate", 5, Rarity.COMMON, mage.cards.b.BrokersInitiate.class));
        cards.add(new SetCardInfo("Brokers Veteran", 36, Rarity.COMMON, mage.cards.b.BrokersVeteran.class));
        cards.add(new SetCardInfo("Buy Your Silence", 6, Rarity.COMMON, mage.cards.b.BuyYourSilence.class));
        cards.add(new SetCardInfo("Cabaretti Ascendancy", 172, Rarity.RARE, mage.cards.c.CabarettiAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cabaretti Ascendancy", 299, Rarity.RARE, mage.cards.c.CabarettiAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cabaretti Ascendancy", 364, Rarity.RARE, mage.cards.c.CabarettiAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cabaretti Charm", 173, Rarity.UNCOMMON, mage.cards.c.CabarettiCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cabaretti Charm", 300, Rarity.UNCOMMON, mage.cards.c.CabarettiCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cabaretti Charm", 365, Rarity.UNCOMMON, mage.cards.c.CabarettiCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cabaretti Courtyard", 249, Rarity.COMMON, mage.cards.c.CabarettiCourtyard.class));
        cards.add(new SetCardInfo("Cabaretti Initiate", 137, Rarity.COMMON, mage.cards.c.CabarettiInitiate.class));
        cards.add(new SetCardInfo("Caldaia Strongarm", 138, Rarity.COMMON, mage.cards.c.CaldaiaStrongarm.class));
        cards.add(new SetCardInfo("Call In a Professional", 103, Rarity.UNCOMMON, mage.cards.c.CallInAProfessional.class));
        cards.add(new SetCardInfo("Capenna Express", 139, Rarity.COMMON, mage.cards.c.CapennaExpress.class));
        cards.add(new SetCardInfo("Case the Joint", 37, Rarity.COMMON, mage.cards.c.CaseTheJoint.class));
        cards.add(new SetCardInfo("Celebrity Fencer", 7, Rarity.COMMON, mage.cards.c.CelebrityFencer.class));
        cards.add(new SetCardInfo("Celestial Regulator", 174, Rarity.COMMON, mage.cards.c.CelestialRegulator.class));
        cards.add(new SetCardInfo("Cement Shoes", 235, Rarity.UNCOMMON, mage.cards.c.CementShoes.class));
        cards.add(new SetCardInfo("Cemetery Tampering", 418, Rarity.RARE, mage.cards.c.CemeteryTampering.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cemetery Tampering", 69, Rarity.RARE, mage.cards.c.CemeteryTampering.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ceremonial Groundbreaker", 175, Rarity.UNCOMMON, mage.cards.c.CeremonialGroundbreaker.class));
        cards.add(new SetCardInfo("Chrome Cat", 236, Rarity.COMMON, mage.cards.c.ChromeCat.class));
        cards.add(new SetCardInfo("Citizen's Crowbar", 8, Rarity.UNCOMMON, mage.cards.c.CitizensCrowbar.class));
        cards.add(new SetCardInfo("Civic Gardener", 140, Rarity.COMMON, mage.cards.c.CivicGardener.class));
        cards.add(new SetCardInfo("Civil Servant", 176, Rarity.COMMON, mage.cards.c.CivilServant.class));
        cards.add(new SetCardInfo("Cleanup Crew", 141, Rarity.UNCOMMON, mage.cards.c.CleanupCrew.class));
        cards.add(new SetCardInfo("Cormela, Glamour Thief", 177, Rarity.UNCOMMON, mage.cards.c.CormelaGlamourThief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cormela, Glamour Thief", 301, Rarity.UNCOMMON, mage.cards.c.CormelaGlamourThief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cormela, Glamour Thief", 366, Rarity.UNCOMMON, mage.cards.c.CormelaGlamourThief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Corpse Appraiser", 178, Rarity.UNCOMMON, mage.cards.c.CorpseAppraiser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Corpse Appraiser", 302, Rarity.UNCOMMON, mage.cards.c.CorpseAppraiser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Corpse Appraiser", 367, Rarity.UNCOMMON, mage.cards.c.CorpseAppraiser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Corpse Explosion", 179, Rarity.RARE, mage.cards.c.CorpseExplosion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Corpse Explosion", 435, Rarity.RARE, mage.cards.c.CorpseExplosion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Corrupt Court Official", 70, Rarity.COMMON, mage.cards.c.CorruptCourtOfficial.class));
        cards.add(new SetCardInfo("Courier's Briefcase", 142, Rarity.UNCOMMON, mage.cards.c.CouriersBriefcase.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Courier's Briefcase", 467, Rarity.UNCOMMON, mage.cards.c.CouriersBriefcase.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crew Captain", 180, Rarity.UNCOMMON, mage.cards.c.CrewCaptain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crew Captain", 303, Rarity.UNCOMMON, mage.cards.c.CrewCaptain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crew Captain", 368, Rarity.UNCOMMON, mage.cards.c.CrewCaptain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crooked Custodian", 71, Rarity.COMMON, mage.cards.c.CrookedCustodian.class));
        cards.add(new SetCardInfo("Cut Your Losses", 38, Rarity.RARE, mage.cards.c.CutYourLosses.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cut Your Losses", 410, Rarity.RARE, mage.cards.c.CutYourLosses.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cut of the Profits", 419, Rarity.RARE, mage.cards.c.CutOfTheProfits.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cut of the Profits", 72, Rarity.RARE, mage.cards.c.CutOfTheProfits.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cutthroat Contender", 73, Rarity.COMMON, mage.cards.c.CutthroatContender.class));
        cards.add(new SetCardInfo("Dapper Shieldmate", 9, Rarity.COMMON, mage.cards.d.DapperShieldmate.class));
        cards.add(new SetCardInfo("Daring Escape", 104, Rarity.COMMON, mage.cards.d.DaringEscape.class));
        cards.add(new SetCardInfo("Darling of the Masses", 181, Rarity.UNCOMMON, mage.cards.d.DarlingOfTheMasses.class));
        cards.add(new SetCardInfo("Deal Gone Bad", 74, Rarity.COMMON, mage.cards.d.DealGoneBad.class));
        cards.add(new SetCardInfo("Demon's Due", 75, Rarity.COMMON, mage.cards.d.DemonsDue.class));
        cards.add(new SetCardInfo("Depopulate", 10, Rarity.RARE, mage.cards.d.Depopulate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Depopulate", 406, Rarity.RARE, mage.cards.d.Depopulate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Devilish Valet", 105, Rarity.RARE, mage.cards.d.DevilishValet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Devilish Valet", 423, Rarity.RARE, mage.cards.d.DevilishValet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dig Up the Body", 76, Rarity.COMMON, mage.cards.d.DigUpTheBody.class));
        cards.add(new SetCardInfo("Disciplined Duelist", 182, Rarity.UNCOMMON, mage.cards.d.DisciplinedDuelist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disciplined Duelist", 304, Rarity.UNCOMMON, mage.cards.d.DisciplinedDuelist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disciplined Duelist", 369, Rarity.UNCOMMON, mage.cards.d.DisciplinedDuelist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disdainful Stroke", 39, Rarity.COMMON, mage.cards.d.DisdainfulStroke.class));
        cards.add(new SetCardInfo("Dusk Mangler", 77, Rarity.UNCOMMON, mage.cards.d.DuskMangler.class));
        cards.add(new SetCardInfo("Echo Inspector", 40, Rarity.COMMON, mage.cards.e.EchoInspector.class));
        cards.add(new SetCardInfo("Elegant Entourage", 143, Rarity.UNCOMMON, mage.cards.e.ElegantEntourage.class));
        cards.add(new SetCardInfo("Elspeth Resplendent", 11, Rarity.MYTHIC, mage.cards.e.ElspethResplendent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elspeth Resplendent", 282, Rarity.MYTHIC, mage.cards.e.ElspethResplendent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elspeth Resplendent", 341, Rarity.MYTHIC, mage.cards.e.ElspethResplendent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elspeth Resplendent", 441, Rarity.MYTHIC, mage.cards.e.ElspethResplendent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Endless Detour", 183, Rarity.RARE, mage.cards.e.EndlessDetour.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Endless Detour", 305, Rarity.RARE, mage.cards.e.EndlessDetour.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Endless Detour", 370, Rarity.RARE, mage.cards.e.EndlessDetour.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Errant, Street Artist", 344, Rarity.RARE, mage.cards.e.ErrantStreetArtist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Errant, Street Artist", 41, Rarity.RARE, mage.cards.e.ErrantStreetArtist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Errant, Street Artist", 444, Rarity.RARE, mage.cards.e.ErrantStreetArtist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evelyn, the Covetous", 184, Rarity.RARE, mage.cards.e.EvelynTheCovetous.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evelyn, the Covetous", 306, Rarity.RARE, mage.cards.e.EvelynTheCovetous.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evelyn, the Covetous", 371, Rarity.RARE, mage.cards.e.EvelynTheCovetous.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Even the Score", 411, Rarity.MYTHIC, mage.cards.e.EvenTheScore.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Even the Score", 42, Rarity.MYTHIC, mage.cards.e.EvenTheScore.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evolving Door", 144, Rarity.RARE, mage.cards.e.EvolvingDoor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evolving Door", 429, Rarity.RARE, mage.cards.e.EvolvingDoor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Exhibition Magician", 106, Rarity.COMMON, mage.cards.e.ExhibitionMagician.class));
        cards.add(new SetCardInfo("Exotic Pets", 185, Rarity.UNCOMMON, mage.cards.e.ExoticPets.class));
        cards.add(new SetCardInfo("Expendable Lackey", 43, Rarity.COMMON, mage.cards.e.ExpendableLackey.class));
        cards.add(new SetCardInfo("Extract the Truth", 78, Rarity.COMMON, mage.cards.e.ExtractTheTruth.class));
        cards.add(new SetCardInfo("Extraction Specialist", 12, Rarity.RARE, mage.cards.e.ExtractionSpecialist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Extraction Specialist", 407, Rarity.RARE, mage.cards.e.ExtractionSpecialist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faerie Vandal", 44, Rarity.UNCOMMON, mage.cards.f.FaerieVandal.class));
        cards.add(new SetCardInfo("Fake Your Own Death", 79, Rarity.COMMON, mage.cards.f.FakeYourOwnDeath.class));
        cards.add(new SetCardInfo("Falco Spara, Pactweaver", 186, Rarity.MYTHIC, mage.cards.f.FalcoSparaPactweaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Falco Spara, Pactweaver", 307, Rarity.MYTHIC, mage.cards.f.FalcoSparaPactweaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Falco Spara, Pactweaver", 372, Rarity.MYTHIC, mage.cards.f.FalcoSparaPactweaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fatal Grudge", 187, Rarity.UNCOMMON, mage.cards.f.FatalGrudge.class));
        cards.add(new SetCardInfo("Fight Rigging", 145, Rarity.RARE, mage.cards.f.FightRigging.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fight Rigging", 430, Rarity.RARE, mage.cards.f.FightRigging.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fleetfoot Dancer", 188, Rarity.RARE, mage.cards.f.FleetfootDancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fleetfoot Dancer", 308, Rarity.RARE, mage.cards.f.FleetfootDancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fleetfoot Dancer", 373, Rarity.RARE, mage.cards.f.FleetfootDancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("For the Family", 146, Rarity.COMMON, mage.cards.f.ForTheFamily.class));
        cards.add(new SetCardInfo("Forest", 270, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 271, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 280, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 281, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forge Boss", 189, Rarity.UNCOMMON, mage.cards.f.ForgeBoss.class));
        cards.add(new SetCardInfo("Freelance Muscle", 147, Rarity.UNCOMMON, mage.cards.f.FreelanceMuscle.class));
        cards.add(new SetCardInfo("Gala Greeters", 148, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 431, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 450, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 451, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 452, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 453, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 454, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 455, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 456, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 457, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 458, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 459, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gala Greeters", 460, Rarity.RARE, mage.cards.g.GalaGreeters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gathering Throng", 13, Rarity.COMMON, mage.cards.g.GatheringThrong.class));
        cards.add(new SetCardInfo("Getaway Car", 237, Rarity.RARE, mage.cards.g.GetawayCar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Getaway Car", 438, Rarity.RARE, mage.cards.g.GetawayCar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giada, Font of Hope", 14, Rarity.RARE, mage.cards.g.GiadaFontOfHope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giada, Font of Hope", 342, Rarity.RARE, mage.cards.g.GiadaFontOfHope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giada, Font of Hope", 442, Rarity.RARE, mage.cards.g.GiadaFontOfHope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gilded Pinions", 238, Rarity.COMMON, mage.cards.g.GildedPinions.class));
        cards.add(new SetCardInfo("Girder Goons", 80, Rarity.COMMON, mage.cards.g.GirderGoons.class));
        cards.add(new SetCardInfo("Glamorous Outlaw", 190, Rarity.COMMON, mage.cards.g.GlamorousOutlaw.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glamorous Outlaw", 309, Rarity.COMMON, mage.cards.g.GlamorousOutlaw.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glamorous Outlaw", 374, Rarity.COMMON, mage.cards.g.GlamorousOutlaw.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glittering Stockpile", 107, Rarity.UNCOMMON, mage.cards.g.GlitteringStockpile.class));
        cards.add(new SetCardInfo("Glittermonger", 149, Rarity.COMMON, mage.cards.g.Glittermonger.class));
        cards.add(new SetCardInfo("Goldhound", 108, Rarity.COMMON, mage.cards.g.Goldhound.class));
        cards.add(new SetCardInfo("Graveyard Shift", 81, Rarity.UNCOMMON, mage.cards.g.GraveyardShift.class));
        cards.add(new SetCardInfo("Grisly Sigil", 82, Rarity.UNCOMMON, mage.cards.g.GrislySigil.class));
        cards.add(new SetCardInfo("Halo Fountain", 15, Rarity.MYTHIC, mage.cards.h.HaloFountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Halo Fountain", 285, Rarity.MYTHIC, mage.cards.h.HaloFountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Halo Scarab", 239, Rarity.COMMON, mage.cards.h.HaloScarab.class));
        cards.add(new SetCardInfo("High-Rise Sawjack", 150, Rarity.COMMON, mage.cards.h.HighRiseSawjack.class));
        cards.add(new SetCardInfo("Hoard Hauler", 109, Rarity.RARE, mage.cards.h.HoardHauler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hoard Hauler", 424, Rarity.RARE, mage.cards.h.HoardHauler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hold for Ransom", 16, Rarity.COMMON, mage.cards.h.HoldForRansom.class));
        cards.add(new SetCardInfo("Hostile Takeover", 191, Rarity.RARE, mage.cards.h.HostileTakeover.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hostile Takeover", 310, Rarity.RARE, mage.cards.h.HostileTakeover.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hostile Takeover", 375, Rarity.RARE, mage.cards.h.HostileTakeover.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hypnotic Grifter", 45, Rarity.UNCOMMON, mage.cards.h.HypnoticGrifter.class));
        cards.add(new SetCardInfo("Illicit Shipment", 83, Rarity.UNCOMMON, mage.cards.i.IllicitShipment.class));
        cards.add(new SetCardInfo("Illuminator Virtuoso", 17, Rarity.UNCOMMON, mage.cards.i.IlluminatorVirtuoso.class));
        cards.add(new SetCardInfo("Incandescent Aria", 192, Rarity.RARE, mage.cards.i.IncandescentAria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Incandescent Aria", 311, Rarity.RARE, mage.cards.i.IncandescentAria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Incandescent Aria", 376, Rarity.RARE, mage.cards.i.IncandescentAria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Incriminate", 465, Rarity.COMMON, mage.cards.i.Incriminate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Incriminate", 84, Rarity.COMMON, mage.cards.i.Incriminate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inspiring Overseer", 18, Rarity.COMMON, mage.cards.i.InspiringOverseer.class));
        cards.add(new SetCardInfo("Involuntary Employment", 110, Rarity.UNCOMMON, mage.cards.i.InvoluntaryEmployment.class));
        cards.add(new SetCardInfo("Island", 264, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 265, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 274, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 275, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Jackhammer", 111, Rarity.COMMON, mage.cards.j.Jackhammer.class));
        cards.add(new SetCardInfo("Jaxis, the Troublemaker", 112, Rarity.RARE, mage.cards.j.JaxisTheTroublemaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jaxis, the Troublemaker", 425, Rarity.RARE, mage.cards.j.JaxisTheTroublemaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jaxis, the Troublemaker", 461, Rarity.RARE, mage.cards.j.JaxisTheTroublemaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir's Fixer", 194, Rarity.COMMON, mage.cards.j.JetmirsFixer.class));
        cards.add(new SetCardInfo("Jetmir's Garden", 250, Rarity.RARE, mage.cards.j.JetmirsGarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir's Garden", 291, Rarity.RARE, mage.cards.j.JetmirsGarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir's Garden", 351, Rarity.RARE, mage.cards.j.JetmirsGarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir, Nexus of Revels", 193, Rarity.MYTHIC, mage.cards.j.JetmirNexusOfRevels.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir, Nexus of Revels", 312, Rarity.MYTHIC, mage.cards.j.JetmirNexusOfRevels.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir, Nexus of Revels", 377, Rarity.MYTHIC, mage.cards.j.JetmirNexusOfRevels.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jewel Thief", 151, Rarity.COMMON, mage.cards.j.JewelThief.class));
        cards.add(new SetCardInfo("Jinnie Fay, Jetmir's Second", 195, Rarity.RARE, mage.cards.j.JinnieFayJetmirsSecond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jinnie Fay, Jetmir's Second", 313, Rarity.RARE, mage.cards.j.JinnieFayJetmirsSecond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jinnie Fay, Jetmir's Second", 378, Rarity.RARE, mage.cards.j.JinnieFayJetmirsSecond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Join the Maestros", 85, Rarity.COMMON, mage.cards.j.JoinTheMaestros.class));
        cards.add(new SetCardInfo("Kill Shot", 19, Rarity.COMMON, mage.cards.k.KillShot.class));
        cards.add(new SetCardInfo("Knockout Blow", 20, Rarity.UNCOMMON, mage.cards.k.KnockoutBlow.class));
        cards.add(new SetCardInfo("Lagrella, the Magpie", 196, Rarity.UNCOMMON, mage.cards.l.LagrellaTheMagpie.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lagrella, the Magpie", 314, Rarity.UNCOMMON, mage.cards.l.LagrellaTheMagpie.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lagrella, the Magpie", 379, Rarity.UNCOMMON, mage.cards.l.LagrellaTheMagpie.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ledger Shredder", 412, Rarity.RARE, mage.cards.l.LedgerShredder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ledger Shredder", 46, Rarity.RARE, mage.cards.l.LedgerShredder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Light 'Em Up", 113, Rarity.COMMON, mage.cards.l.LightEmUp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Light 'Em Up", 466, Rarity.COMMON, mage.cards.l.LightEmUp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord Xander, the Collector", 197, Rarity.MYTHIC, mage.cards.l.LordXanderTheCollector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord Xander, the Collector", 315, Rarity.MYTHIC, mage.cards.l.LordXanderTheCollector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord Xander, the Collector", 380, Rarity.MYTHIC, mage.cards.l.LordXanderTheCollector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Luxior, Giada's Gift", 240, Rarity.MYTHIC, mage.cards.l.LuxiorGiadasGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Luxior, Giada's Gift", 439, Rarity.MYTHIC, mage.cards.l.LuxiorGiadasGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Luxurious Libation", 152, Rarity.UNCOMMON, mage.cards.l.LuxuriousLibation.class));
        cards.add(new SetCardInfo("Maestros Ascendancy", 198, Rarity.RARE, mage.cards.m.MaestrosAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Ascendancy", 316, Rarity.RARE, mage.cards.m.MaestrosAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Ascendancy", 381, Rarity.RARE, mage.cards.m.MaestrosAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Charm", 199, Rarity.UNCOMMON, mage.cards.m.MaestrosCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Charm", 317, Rarity.UNCOMMON, mage.cards.m.MaestrosCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Charm", 382, Rarity.UNCOMMON, mage.cards.m.MaestrosCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Diabolist", 200, Rarity.RARE, mage.cards.m.MaestrosDiabolist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Diabolist", 318, Rarity.RARE, mage.cards.m.MaestrosDiabolist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Diabolist", 383, Rarity.RARE, mage.cards.m.MaestrosDiabolist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Initiate", 86, Rarity.COMMON, mage.cards.m.MaestrosInitiate.class));
        cards.add(new SetCardInfo("Maestros Theater", 251, Rarity.COMMON, mage.cards.m.MaestrosTheater.class));
        cards.add(new SetCardInfo("Mage's Attendant", 21, Rarity.UNCOMMON, mage.cards.m.MagesAttendant.class));
        cards.add(new SetCardInfo("Majestic Metamorphosis", 48, Rarity.COMMON, mage.cards.m.MajesticMetamorphosis.class));
        cards.add(new SetCardInfo("Make Disappear", 49, Rarity.COMMON, mage.cards.m.MakeDisappear.class));
        cards.add(new SetCardInfo("Masked Bandits", 201, Rarity.COMMON, mage.cards.m.MaskedBandits.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Masked Bandits", 319, Rarity.COMMON, mage.cards.m.MaskedBandits.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Masked Bandits", 384, Rarity.COMMON, mage.cards.m.MaskedBandits.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mayhem Patrol", 114, Rarity.COMMON, mage.cards.m.MayhemPatrol.class));
        cards.add(new SetCardInfo("Meeting of the Five", 202, Rarity.MYTHIC, mage.cards.m.MeetingOfTheFive.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meeting of the Five", 436, Rarity.MYTHIC, mage.cards.m.MeetingOfTheFive.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Metropolis Angel", 203, Rarity.UNCOMMON, mage.cards.m.MetropolisAngel.class));
        cards.add(new SetCardInfo("Midnight Assassin", 87, Rarity.COMMON, mage.cards.m.MidnightAssassin.class));
        cards.add(new SetCardInfo("Most Wanted", 153, Rarity.COMMON, mage.cards.m.MostWanted.class));
        cards.add(new SetCardInfo("Mountain", 268, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 269, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 278, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 279, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mr. Orfeo, the Boulder", 204, Rarity.UNCOMMON, mage.cards.m.MrOrfeoTheBoulder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mr. Orfeo, the Boulder", 320, Rarity.UNCOMMON, mage.cards.m.MrOrfeoTheBoulder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mr. Orfeo, the Boulder", 385, Rarity.UNCOMMON, mage.cards.m.MrOrfeoTheBoulder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Murder", 88, Rarity.COMMON, mage.cards.m.Murder.class));
        cards.add(new SetCardInfo("Mysterious Limousine", 22, Rarity.RARE, mage.cards.m.MysteriousLimousine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mysterious Limousine", 408, Rarity.RARE, mage.cards.m.MysteriousLimousine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mysterious Limousine", 462, Rarity.RARE, mage.cards.m.MysteriousLimousine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Night Clubber", 89, Rarity.UNCOMMON, mage.cards.n.NightClubber.class));
        cards.add(new SetCardInfo("Nimble Larcenist", 205, Rarity.UNCOMMON, mage.cards.n.NimbleLarcenist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nimble Larcenist", 321, Rarity.UNCOMMON, mage.cards.n.NimbleLarcenist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nimble Larcenist", 386, Rarity.UNCOMMON, mage.cards.n.NimbleLarcenist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, the Adversary", 206, Rarity.MYTHIC, mage.cards.o.ObNixilisTheAdversary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, the Adversary", 284, Rarity.MYTHIC, mage.cards.o.ObNixilisTheAdversary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, the Adversary", 348, Rarity.MYTHIC, mage.cards.o.ObNixilisTheAdversary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, the Adversary", 448, Rarity.MYTHIC, mage.cards.o.ObNixilisTheAdversary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Ascendancy", 207, Rarity.RARE, mage.cards.o.ObscuraAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Ascendancy", 322, Rarity.RARE, mage.cards.o.ObscuraAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Ascendancy", 387, Rarity.RARE, mage.cards.o.ObscuraAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Charm", 208, Rarity.UNCOMMON, mage.cards.o.ObscuraCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Charm", 323, Rarity.UNCOMMON, mage.cards.o.ObscuraCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Charm", 388, Rarity.UNCOMMON, mage.cards.o.ObscuraCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Initiate", 50, Rarity.COMMON, mage.cards.o.ObscuraInitiate.class));
        cards.add(new SetCardInfo("Obscura Interceptor", 209, Rarity.RARE, mage.cards.o.ObscuraInterceptor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Interceptor", 324, Rarity.RARE, mage.cards.o.ObscuraInterceptor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Interceptor", 389, Rarity.RARE, mage.cards.o.ObscuraInterceptor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Storefront", 252, Rarity.COMMON, mage.cards.o.ObscuraStorefront.class));
        cards.add(new SetCardInfo("Ognis, the Dragon's Lash", 210, Rarity.RARE, mage.cards.o.OgnisTheDragonsLash.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ognis, the Dragon's Lash", 325, Rarity.RARE, mage.cards.o.OgnisTheDragonsLash.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ognis, the Dragon's Lash", 390, Rarity.RARE, mage.cards.o.OgnisTheDragonsLash.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ominous Parcel", 241, Rarity.COMMON, mage.cards.o.OminousParcel.class));
        cards.add(new SetCardInfo("Out of the Way", 52, Rarity.UNCOMMON, mage.cards.o.OutOfTheWay.class));
        cards.add(new SetCardInfo("Paragon of Modernity", 242, Rarity.COMMON, mage.cards.p.ParagonOfModernity.class));
        cards.add(new SetCardInfo("Park Heights Pegasus", 211, Rarity.RARE, mage.cards.p.ParkHeightsPegasus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Park Heights Pegasus", 437, Rarity.RARE, mage.cards.p.ParkHeightsPegasus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Patch Up", 23, Rarity.UNCOMMON, mage.cards.p.PatchUp.class));
        cards.add(new SetCardInfo("Plains", 262, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 263, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 272, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Plains", 273, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Plasma Jockey", 115, Rarity.COMMON, mage.cards.p.PlasmaJockey.class));
        cards.add(new SetCardInfo("Prizefight", 154, Rarity.COMMON, mage.cards.p.Prizefight.class));
        cards.add(new SetCardInfo("Professional Face-Breaker", 116, Rarity.RARE, mage.cards.p.ProfessionalFaceBreaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Professional Face-Breaker", 426, Rarity.RARE, mage.cards.p.ProfessionalFaceBreaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Psionic Snoop", 53, Rarity.COMMON, mage.cards.p.PsionicSnoop.class));
        cards.add(new SetCardInfo("Psychic Pickpocket", 54, Rarity.UNCOMMON, mage.cards.p.PsychicPickpocket.class));
        cards.add(new SetCardInfo("Public Enemy", 55, Rarity.UNCOMMON, mage.cards.p.PublicEnemy.class));
        cards.add(new SetCardInfo("Pugnacious Pugilist", 117, Rarity.UNCOMMON, mage.cards.p.PugnaciousPugilist.class));
        cards.add(new SetCardInfo("Pyre-Sledge Arsonist", 118, Rarity.UNCOMMON, mage.cards.p.PyreSledgeArsonist.class));
        cards.add(new SetCardInfo("Queza, Augur of Agonies", 212, Rarity.UNCOMMON, mage.cards.q.QuezaAugurOfAgonies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Queza, Augur of Agonies", 326, Rarity.UNCOMMON, mage.cards.q.QuezaAugurOfAgonies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Queza, Augur of Agonies", 391, Rarity.UNCOMMON, mage.cards.q.QuezaAugurOfAgonies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quick-Draw Dagger", 243, Rarity.COMMON, mage.cards.q.QuickDrawDagger.class));
        cards.add(new SetCardInfo("Rabble Rousing", 24, Rarity.RARE, mage.cards.r.RabbleRousing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rabble Rousing", 409, Rarity.RARE, mage.cards.r.RabbleRousing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Racers' Ring", 253, Rarity.COMMON, mage.cards.r.RacersRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Racers' Ring", 352, Rarity.COMMON, mage.cards.r.RacersRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raffine's Guidance", 25, Rarity.COMMON, mage.cards.r.RaffinesGuidance.class));
        cards.add(new SetCardInfo("Raffine's Informant", 26, Rarity.COMMON, mage.cards.r.RaffinesInformant.class));
        cards.add(new SetCardInfo("Raffine's Silencer", 90, Rarity.UNCOMMON, mage.cards.r.RaffinesSilencer.class));
        cards.add(new SetCardInfo("Raffine's Tower", 254, Rarity.RARE, mage.cards.r.RaffinesTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raffine's Tower", 292, Rarity.RARE, mage.cards.r.RaffinesTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raffine's Tower", 353, Rarity.RARE, mage.cards.r.RaffinesTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raffine, Scheming Seer", 213, Rarity.MYTHIC, mage.cards.r.RaffineSchemingSeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raffine, Scheming Seer", 327, Rarity.MYTHIC, mage.cards.r.RaffineSchemingSeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raffine, Scheming Seer", 392, Rarity.MYTHIC, mage.cards.r.RaffineSchemingSeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakish Revelers", 214, Rarity.COMMON, mage.cards.r.RakishRevelers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakish Revelers", 328, Rarity.COMMON, mage.cards.r.RakishRevelers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakish Revelers", 393, Rarity.COMMON, mage.cards.r.RakishRevelers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ready to Rumble", 119, Rarity.COMMON, mage.cards.r.ReadyToRumble.class));
        cards.add(new SetCardInfo("Refuse to Yield", 27, Rarity.UNCOMMON, mage.cards.r.RefuseToYield.class));
        cards.add(new SetCardInfo("Reservoir Kraken", 413, Rarity.RARE, mage.cards.r.ReservoirKraken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reservoir Kraken", 56, Rarity.RARE, mage.cards.r.ReservoirKraken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Revel Ruiner", 91, Rarity.COMMON, mage.cards.r.RevelRuiner.class));
        cards.add(new SetCardInfo("Revelation of Power", 28, Rarity.COMMON, mage.cards.r.RevelationOfPower.class));
        cards.add(new SetCardInfo("Rhox Pummeler", 155, Rarity.COMMON, mage.cards.r.RhoxPummeler.class));
        cards.add(new SetCardInfo("Rigo, Streetwise Mentor", 215, Rarity.RARE, mage.cards.r.RigoStreetwiseMentor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rigo, Streetwise Mentor", 329, Rarity.RARE, mage.cards.r.RigoStreetwiseMentor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rigo, Streetwise Mentor", 394, Rarity.RARE, mage.cards.r.RigoStreetwiseMentor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riveteers Ascendancy", 216, Rarity.RARE, mage.cards.r.RiveteersAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riveteers Ascendancy", 330, Rarity.RARE, mage.cards.r.RiveteersAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riveteers Ascendancy", 395, Rarity.RARE, mage.cards.r.RiveteersAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riveteers Charm", 217, Rarity.UNCOMMON, mage.cards.r.RiveteersCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riveteers Charm", 331, Rarity.UNCOMMON, mage.cards.r.RiveteersCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riveteers Charm", 396, Rarity.UNCOMMON, mage.cards.r.RiveteersCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riveteers Decoy", 156, Rarity.UNCOMMON, mage.cards.r.RiveteersDecoy.class));
        cards.add(new SetCardInfo("Riveteers Initiate", 120, Rarity.COMMON, mage.cards.r.RiveteersInitiate.class));
        cards.add(new SetCardInfo("Riveteers Overlook", 255, Rarity.COMMON, mage.cards.r.RiveteersOverlook.class));
        cards.add(new SetCardInfo("Riveteers Requisitioner", 121, Rarity.UNCOMMON, mage.cards.r.RiveteersRequisitioner.class));
        cards.add(new SetCardInfo("Rob the Archives", 122, Rarity.UNCOMMON, mage.cards.r.RobTheArchives.class));
        cards.add(new SetCardInfo("Rocco, Cabaretti Caterer", 218, Rarity.UNCOMMON, mage.cards.r.RoccoCabarettiCaterer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rocco, Cabaretti Caterer", 332, Rarity.UNCOMMON, mage.cards.r.RoccoCabarettiCaterer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rocco, Cabaretti Caterer", 397, Rarity.UNCOMMON, mage.cards.r.RoccoCabarettiCaterer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rogues' Gallery", 92, Rarity.UNCOMMON, mage.cards.r.RoguesGallery.class));
        cards.add(new SetCardInfo("Rooftop Nuisance", 57, Rarity.COMMON, mage.cards.r.RooftopNuisance.class));
        cards.add(new SetCardInfo("Rumor Gatherer", 29, Rarity.UNCOMMON, mage.cards.r.RumorGatherer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rumor Gatherer", 463, Rarity.UNCOMMON, mage.cards.r.RumorGatherer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Run Out of Town", 58, Rarity.COMMON, mage.cards.r.RunOutOfTown.class));
        cards.add(new SetCardInfo("Sanctuary Warden", 30, Rarity.MYTHIC, mage.cards.s.SanctuaryWarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sanctuary Warden", 343, Rarity.MYTHIC, mage.cards.s.SanctuaryWarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sanctuary Warden", 443, Rarity.MYTHIC, mage.cards.s.SanctuaryWarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sanguine Spy", 420, Rarity.RARE, mage.cards.s.SanguineSpy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sanguine Spy", 93, Rarity.RARE, mage.cards.s.SanguineSpy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scheming Fence", 219, Rarity.RARE, mage.cards.s.SchemingFence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scheming Fence", 349, Rarity.RARE, mage.cards.s.SchemingFence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scheming Fence", 449, Rarity.RARE, mage.cards.s.SchemingFence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scuttling Butler", 244, Rarity.UNCOMMON, mage.cards.s.ScuttlingButler.class));
        cards.add(new SetCardInfo("Security Bypass", 59, Rarity.COMMON, mage.cards.s.SecurityBypass.class));
        cards.add(new SetCardInfo("Security Rhox", 220, Rarity.UNCOMMON, mage.cards.s.SecurityRhox.class));
        cards.add(new SetCardInfo("Sewer Crocodile", 60, Rarity.COMMON, mage.cards.s.SewerCrocodile.class));
        cards.add(new SetCardInfo("Shadow of Mortality", 287, Rarity.RARE, mage.cards.s.ShadowOfMortality.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadow of Mortality", 94, Rarity.RARE, mage.cards.s.ShadowOfMortality.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shakedown Heavy", 421, Rarity.RARE, mage.cards.s.ShakedownHeavy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shakedown Heavy", 95, Rarity.RARE, mage.cards.s.ShakedownHeavy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shattered Seraph", 221, Rarity.COMMON, mage.cards.s.ShatteredSeraph.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shattered Seraph", 333, Rarity.COMMON, mage.cards.s.ShatteredSeraph.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shattered Seraph", 398, Rarity.COMMON, mage.cards.s.ShatteredSeraph.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sizzling Soloist", 123, Rarity.UNCOMMON, mage.cards.s.SizzlingSoloist.class));
        cards.add(new SetCardInfo("Sky Crier", 31, Rarity.COMMON, mage.cards.s.SkyCrier.class));
        cards.add(new SetCardInfo("Skybridge Towers", 256, Rarity.COMMON, mage.cards.s.SkybridgeTowers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skybridge Towers", 354, Rarity.COMMON, mage.cards.s.SkybridgeTowers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sleep with the Fishes", 61, Rarity.UNCOMMON, mage.cards.s.SleepWithTheFishes.class));
        cards.add(new SetCardInfo("Slip Out the Back", 62, Rarity.UNCOMMON, mage.cards.s.SlipOutTheBack.class));
        cards.add(new SetCardInfo("Snooping Newsie", 222, Rarity.COMMON, mage.cards.s.SnoopingNewsie.class));
        cards.add(new SetCardInfo("Social Climber", 157, Rarity.COMMON, mage.cards.s.SocialClimber.class));
        cards.add(new SetCardInfo("Soul of Emancipation", 223, Rarity.RARE, mage.cards.s.SoulOfEmancipation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul of Emancipation", 334, Rarity.RARE, mage.cards.s.SoulOfEmancipation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul of Emancipation", 399, Rarity.RARE, mage.cards.s.SoulOfEmancipation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spara's Adjudicators", 224, Rarity.COMMON, mage.cards.s.SparasAdjudicators.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spara's Adjudicators", 335, Rarity.COMMON, mage.cards.s.SparasAdjudicators.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spara's Adjudicators", 400, Rarity.COMMON, mage.cards.s.SparasAdjudicators.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spara's Headquarters", 257, Rarity.RARE, mage.cards.s.SparasHeadquarters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spara's Headquarters", 293, Rarity.RARE, mage.cards.s.SparasHeadquarters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spara's Headquarters", 355, Rarity.RARE, mage.cards.s.SparasHeadquarters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Speakeasy Server", 32, Rarity.COMMON, mage.cards.s.SpeakeasyServer.class));
        cards.add(new SetCardInfo("Sticky Fingers", 124, Rarity.COMMON, mage.cards.s.StickyFingers.class));
        cards.add(new SetCardInfo("Stimulus Package", 225, Rarity.UNCOMMON, mage.cards.s.StimulusPackage.class));
        cards.add(new SetCardInfo("Strangle", 125, Rarity.COMMON, mage.cards.s.Strangle.class));
        cards.add(new SetCardInfo("Structural Assault", 126, Rarity.RARE, mage.cards.s.StructuralAssault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Structural Assault", 427, Rarity.RARE, mage.cards.s.StructuralAssault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Suspicious Bookcase", 245, Rarity.UNCOMMON, mage.cards.s.SuspiciousBookcase.class));
        cards.add(new SetCardInfo("Swamp", 266, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 267, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 276, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 277, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swooping Protector", 33, Rarity.UNCOMMON, mage.cards.s.SwoopingProtector.class));
        cards.add(new SetCardInfo("Syndicate Infiltrator", 226, Rarity.UNCOMMON, mage.cards.s.SyndicateInfiltrator.class));
        cards.add(new SetCardInfo("Tainted Indulgence", 227, Rarity.UNCOMMON, mage.cards.t.TaintedIndulgence.class));
        cards.add(new SetCardInfo("Take to the Streets", 158, Rarity.UNCOMMON, mage.cards.t.TakeToTheStreets.class));
        cards.add(new SetCardInfo("Tavern Swindler", 96, Rarity.UNCOMMON, mage.cards.t.TavernSwindler.class));
        cards.add(new SetCardInfo("Tenacious Underdog", 345, Rarity.RARE, mage.cards.t.TenaciousUnderdog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tenacious Underdog", 445, Rarity.RARE, mage.cards.t.TenaciousUnderdog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tenacious Underdog", 97, Rarity.RARE, mage.cards.t.TenaciousUnderdog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Titan of Industry", 159, Rarity.MYTHIC, mage.cards.t.TitanOfIndustry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Titan of Industry", 289, Rarity.MYTHIC, mage.cards.t.TitanOfIndustry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Toluz, Clever Conductor", 228, Rarity.RARE, mage.cards.t.ToluzCleverConductor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Toluz, Clever Conductor", 336, Rarity.RARE, mage.cards.t.ToluzCleverConductor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Toluz, Clever Conductor", 401, Rarity.RARE, mage.cards.t.ToluzCleverConductor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Topiary Stomper", 160, Rarity.RARE, mage.cards.t.TopiaryStomper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Topiary Stomper", 290, Rarity.RARE, mage.cards.t.TopiaryStomper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Torch Breath", 127, Rarity.UNCOMMON, mage.cards.t.TorchBreath.class));
        cards.add(new SetCardInfo("Tramway Station", 258, Rarity.COMMON, mage.cards.t.TramwayStation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tramway Station", 356, Rarity.COMMON, mage.cards.t.TramwayStation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undercover Operative", 414, Rarity.RARE, mage.cards.u.UndercoverOperative.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undercover Operative", 63, Rarity.RARE, mage.cards.u.UndercoverOperative.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unleash the Inferno", 229, Rarity.RARE, mage.cards.u.UnleashTheInferno.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unleash the Inferno", 337, Rarity.RARE, mage.cards.u.UnleashTheInferno.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unleash the Inferno", 402, Rarity.RARE, mage.cards.u.UnleashTheInferno.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unlicensed Hearse", 246, Rarity.RARE, mage.cards.u.UnlicensedHearse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unlicensed Hearse", 440, Rarity.RARE, mage.cards.u.UnlicensedHearse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unlucky Witness", 128, Rarity.UNCOMMON, mage.cards.u.UnluckyWitness.class));
        cards.add(new SetCardInfo("Urabrask, Heretic Praetor", 129, Rarity.MYTHIC, mage.cards.u.UrabraskHereticPraetor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urabrask, Heretic Praetor", 346, Rarity.MYTHIC, mage.cards.u.UrabraskHereticPraetor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urabrask, Heretic Praetor", 360, Rarity.MYTHIC, mage.cards.u.UrabraskHereticPraetor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urabrask, Heretic Praetor", 446, Rarity.MYTHIC, mage.cards.u.UrabraskHereticPraetor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vampire Scrivener", 98, Rarity.UNCOMMON, mage.cards.v.VampireScrivener.class));
        cards.add(new SetCardInfo("Venom Connoisseur", 161, Rarity.UNCOMMON, mage.cards.v.VenomConnoisseur.class));
        cards.add(new SetCardInfo("Vivien on the Hunt", 162, Rarity.MYTHIC, mage.cards.v.VivienOnTheHunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vivien on the Hunt", 283, Rarity.MYTHIC, mage.cards.v.VivienOnTheHunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vivien on the Hunt", 347, Rarity.MYTHIC, mage.cards.v.VivienOnTheHunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vivien on the Hunt", 447, Rarity.MYTHIC, mage.cards.v.VivienOnTheHunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voice of the Vermin", 163, Rarity.UNCOMMON, mage.cards.v.VoiceOfTheVermin.class));
        cards.add(new SetCardInfo("Void Rend", 230, Rarity.RARE, mage.cards.v.VoidRend.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Void Rend", 338, Rarity.RARE, mage.cards.v.VoidRend.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Void Rend", 403, Rarity.RARE, mage.cards.v.VoidRend.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warm Welcome", 164, Rarity.COMMON, mage.cards.w.WarmWelcome.class));
        cards.add(new SetCardInfo("Waterfront District", 259, Rarity.COMMON, mage.cards.w.WaterfrontDistrict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Waterfront District", 357, Rarity.COMMON, mage.cards.w.WaterfrontDistrict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Whack", 99, Rarity.UNCOMMON, mage.cards.w.Whack.class));
        cards.add(new SetCardInfo("Widespread Thieving", 130, Rarity.RARE, mage.cards.w.WidespreadThieving.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Widespread Thieving", 428, Rarity.RARE, mage.cards.w.WidespreadThieving.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wingshield Agent", 64, Rarity.UNCOMMON, mage.cards.w.WingshieldAgent.class));
        cards.add(new SetCardInfo("Wiretapping", 415, Rarity.RARE, mage.cards.w.Wiretapping.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wiretapping", 65, Rarity.RARE, mage.cards.w.Wiretapping.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witness Protection", 66, Rarity.COMMON, mage.cards.w.WitnessProtection.class));
        cards.add(new SetCardInfo("Witty Roastmaster", 131, Rarity.COMMON, mage.cards.w.WittyRoastmaster.class));
        cards.add(new SetCardInfo("Workshop Warchief", 165, Rarity.RARE, mage.cards.w.WorkshopWarchief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Workshop Warchief", 432, Rarity.RARE, mage.cards.w.WorkshopWarchief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrecking Crew", 132, Rarity.COMMON, mage.cards.w.WreckingCrew.class));
        cards.add(new SetCardInfo("Xander's Lounge", 260, Rarity.RARE, mage.cards.x.XandersLounge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Xander's Lounge", 294, Rarity.RARE, mage.cards.x.XandersLounge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Xander's Lounge", 358, Rarity.RARE, mage.cards.x.XandersLounge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ziatora's Envoy", 232, Rarity.RARE, mage.cards.z.ZiatorasEnvoy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ziatora's Envoy", 340, Rarity.RARE, mage.cards.z.ZiatorasEnvoy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ziatora's Envoy", 405, Rarity.RARE, mage.cards.z.ZiatorasEnvoy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ziatora's Proving Ground", 261, Rarity.RARE, mage.cards.z.ZiatorasProvingGround.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ziatora's Proving Ground", 295, Rarity.RARE, mage.cards.z.ZiatorasProvingGround.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ziatora's Proving Ground", 359, Rarity.RARE, mage.cards.z.ZiatorasProvingGround.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ziatora, the Incinerator", 231, Rarity.MYTHIC, mage.cards.z.ZiatoraTheIncinerator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ziatora, the Incinerator", 339, Rarity.MYTHIC, mage.cards.z.ZiatoraTheIncinerator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ziatora, the Incinerator", 404, Rarity.MYTHIC, mage.cards.z.ZiatoraTheIncinerator.class, NON_FULL_USE_VARIOUS));
    }

    @Override
    public BoosterCollator createCollator() {
        return new StreetsOfNewCapennaCollator();
    }
}

// Booster collation info from https://www.lethe.xyz/mtg/collation/snc.html
// Using USA collation for common/uncommon, rare collation inferred from other sets
class StreetsOfNewCapennaCollator implements BoosterCollator {
    private final CardRun commonA = new CardRun(true, "131", "164", "76", "49", "2", "132", "149", "74", "66", "7", "106", "154", "78", "53", "16", "108", "153", "75", "43", "4", "100", "157", "85", "48", "13", "120", "155", "88", "50", "6", "111", "150", "84", "60", "19", "119", "136", "70", "58", "28", "102", "139", "91", "39", "9", "113", "138", "71", "37", "32", "115", "133", "79", "35", "25", "131", "140", "86", "49", "26", "124", "149", "76", "36", "7", "132", "164", "78", "53", "2", "106", "153", "74", "66", "16", "100", "154", "75", "43", "4", "108", "157", "88", "48", "13", "120", "150", "85", "50", "6", "111", "155", "84", "58", "9", "119", "136", "70", "60", "19", "113", "138", "91", "35", "28", "115", "139", "71", "37", "32", "102", "133", "79", "39", "25", "124", "140", "86", "36", "26", "236");
    private final CardRun commonB = new CardRun(true, "151", "87", "222", "168", "256", "224", "18", "239", "249", "80", "251", "5", "40", "255", "243", "125", "328", "247", "174", "31", "137", "57", "352", "59", "190", "242", "248", "221", "73", "259", "114", "146", "104", "176", "238", "356", "194", "241", "222", "151", "252", "87", "201", "224", "354", "168", "5", "249", "40", "251", "239", "18", "255", "80", "243", "214", "125", "137", "31", "174", "247", "57", "59", "242", "190", "248", "73", "253", "221", "114", "241", "357", "194", "146", "104", "176", "238", "252", "87", "319", "258", "151", "222", "236", "168", "256", "249", "18", "239", "40", "335", "251", "5", "80", "214", "255", "125", "243", "174", "350", "57", "137", "31", "242", "309", "253", "59", "333", "248", "114", "73", "194", "259", "146", "104", "176", "238", "258", "201", "241", "252");
    private final CardRun uncommonA = new CardRun(true, "296", "55", "173", "89", "127", "1", "161", "52", "235", "205", "99", "227", "156", "203", "234", "177", "20", "44", "196", "128", "185", "135", "103", "29", "187", "92", "225", "47", "23", "212", "147", "77", "118", "61", "8", "218", "110", "142", "180", "82", "169", "89", "173", "55", "1", "161", "127", "52", "321", "235", "227", "156", "99", "203", "234", "20", "301", "196", "128", "44", "135", "185", "103", "187", "92", "225", "29", "47", "212", "23", "77", "147", "61", "118", "142", "8", "332", "110", "169", "82", "303", "55", "89", "300", "1", "161", "127", "52", "205", "156", "99", "227", "235", "203", "20", "177", "234", "185", "44", "314", "128", "187", "135", "103", "29", "92", "225", "47", "147", "118", "23", "326", "61", "77", "8", "142", "218", "82", "110", "180");
    private final CardRun uncommonB = new CardRun(true, "244", "51", "317", "54", "121", "90", "33", "143", "175", "107", "98", "331", "117", "81", "181", "152", "220", "64", "83", "163", "182", "96", "298", "245", "141", "17", "178", "122", "226", "3", "233", "189", "158", "62", "21", "204", "45", "27", "323", "123", "54", "244", "199", "51", "121", "143", "33", "175", "90", "117", "217", "81", "107", "98", "220", "152", "181", "83", "64", "304", "163", "171", "96", "141", "178", "245", "17", "122", "3", "226", "62", "189", "233", "158", "204", "45", "21", "123", "208", "27", "244", "54", "199", "51", "121", "143", "90", "107", "33", "175", "117", "98", "217", "152", "81", "220", "64", "163", "181", "83", "182", "96", "141", "245", "171", "17", "226", "233", "3", "302", "122", "21", "62", "158", "189", "27", "320", "45", "123", "208");
    private final CardRun rare = new CardRun(false, "10", "12", "14", "22", "24", "38", "41", "46", "56", "63", "65", "69", "72", "93", "94", "95", "97", "105", "109", "112", "116", "126", "130", "144", "145", "148", "160", "165", "166", "167", "170", "172", "179", "183", "184", "188", "191", "192", "195", "198", "200", "207", "209", "210", "211", "215", "216", "219", "223", "228", "229", "230", "232", "237", "246", "250", "254", "257", "260", "261", "10", "12", "14", "22", "24", "38", "41", "46", "56", "63", "65", "69", "72", "93", "94", "95", "97", "105", "109", "112", "116", "126", "130", "144", "145", "148", "160", "165", "166", "167", "170", "172", "179", "183", "184", "188", "191", "192", "195", "198", "200", "207", "209", "210", "211", "215", "216", "219", "223", "228", "229", "230", "232", "237", "246", "250", "254", "257", "260", "261", "11", "15", "30", "34", "42", "67", "68", "101", "129", "134", "159", "162", "186", "193", "197", "202", "206", "213", "231", "240");
    private final CardRun land = new CardRun(false, "262", "263", "264", "265", "266", "267", "268", "269", "270", "271", "272", "273", "274", "275", "276", "277", "278", "279", "280", "281");

    private final BoosterStructure AAAAAABBBB = new BoosterStructure(
            commonA, commonA, commonA, commonA, commonA, commonA,
            commonB, commonB, commonB, commonB
    );
    private final BoosterStructure AAA = new BoosterStructure(uncommonA, uncommonA, uncommonA);
    private final BoosterStructure BBB = new BoosterStructure(uncommonB, uncommonB, uncommonB);
    private final BoosterStructure R1 = new BoosterStructure(rare);
    private final BoosterStructure L1 = new BoosterStructure(land);

    private final RarityConfiguration commonRuns = new RarityConfiguration(AAAAAABBBB);
    private final RarityConfiguration uncommonRuns = new RarityConfiguration(AAA, BBB);
    private final RarityConfiguration rareRuns = new RarityConfiguration(R1);
    private final RarityConfiguration landRuns = new RarityConfiguration(L1);

    @Override
    public List<String> makeBooster() {
        List<String> booster = new ArrayList<>();
        booster.addAll(commonRuns.getNext().makeRun());
        booster.addAll(uncommonRuns.getNext().makeRun());
        booster.addAll(rareRuns.getNext().makeRun());
        booster.addAll(landRuns.getNext().makeRun());
        return booster;
    }
}
