package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * https://scryfall.com/sets/scd
 */
public class StarterCommanderDecks extends ExpansionSet {

    private static final StarterCommanderDecks instance = new StarterCommanderDecks();

    public static StarterCommanderDecks getInstance() {
        return instance;
    }

    private StarterCommanderDecks() {
        super("Starter Commander Decks", "SCD", ExpansionSet.buildDate(2022, 12, 2), SetType.SUPPLEMENTAL);
        this.hasBoosters = false;
        this.hasBasicLands = true;

        cards.add(new SetCardInfo("Abrade", 122, Rarity.UNCOMMON, mage.cards.a.Abrade.class));
        cards.add(new SetCardInfo("Absorb", 216, Rarity.RARE, mage.cards.a.Absorb.class));
        cards.add(new SetCardInfo("Aetherize", 42, Rarity.UNCOMMON, mage.cards.a.Aetherize.class));
        cards.add(new SetCardInfo("Ajani, Caller of the Pride", 6, Rarity.MYTHIC, mage.cards.a.AjaniCallerOfThePride.class));
        cards.add(new SetCardInfo("Akoum Hellkite", 123, Rarity.RARE, mage.cards.a.AkoumHellkite.class));
        cards.add(new SetCardInfo("Akoum Refuge", 289, Rarity.UNCOMMON, mage.cards.a.AkoumRefuge.class));
        cards.add(new SetCardInfo("Ambition's Cost", 66, Rarity.UNCOMMON, mage.cards.a.AmbitionsCost.class));
        cards.add(new SetCardInfo("Angler Turtle", 43, Rarity.RARE, mage.cards.a.AnglerTurtle.class));
        cards.add(new SetCardInfo("Arcane Signet", 257, Rarity.COMMON, mage.cards.a.ArcaneSignet.class));
        cards.add(new SetCardInfo("Archfiend of Depravity", 67, Rarity.RARE, mage.cards.a.ArchfiendOfDepravity.class));
        cards.add(new SetCardInfo("Archon of Redemption", 7, Rarity.RARE, mage.cards.a.ArchonOfRedemption.class));
        cards.add(new SetCardInfo("Army of the Damned", 68, Rarity.MYTHIC, mage.cards.a.ArmyOfTheDamned.class));
        cards.add(new SetCardInfo("Atarka Monument", 258, Rarity.UNCOMMON, mage.cards.a.AtarkaMonument.class));
        cards.add(new SetCardInfo("Atarka, World Render", 1, Rarity.MYTHIC, mage.cards.a.AtarkaWorldRender.class));
        cards.add(new SetCardInfo("Aura Mutation", 217, Rarity.RARE, mage.cards.a.AuraMutation.class));
        cards.add(new SetCardInfo("Avacyn's Pilgrim", 171, Rarity.COMMON, mage.cards.a.AvacynsPilgrim.class));
        cards.add(new SetCardInfo("Aven Gagglemaster", 8, Rarity.UNCOMMON, mage.cards.a.AvenGagglemaster.class));
        cards.add(new SetCardInfo("Azorius Signet", 259, Rarity.UNCOMMON, mage.cards.a.AzoriusSignet.class));
        cards.add(new SetCardInfo("Banishing Light", 9, Rarity.UNCOMMON, mage.cards.b.BanishingLight.class));
        cards.add(new SetCardInfo("Beast Within", 172, Rarity.UNCOMMON, mage.cards.b.BeastWithin.class));
        cards.add(new SetCardInfo("Bident of Thassa", 44, Rarity.RARE, mage.cards.b.BidentOfThassa.class));
        cards.add(new SetCardInfo("Blasphemous Act", 124, Rarity.RARE, mage.cards.b.BlasphemousAct.class));
        cards.add(new SetCardInfo("Bloodfell Caves", 290, Rarity.COMMON, mage.cards.b.BloodfellCaves.class));
        cards.add(new SetCardInfo("Bloodgift Demon", 69, Rarity.RARE, mage.cards.b.BloodgiftDemon.class));
        cards.add(new SetCardInfo("Blossoming Defense", 173, Rarity.UNCOMMON, mage.cards.b.BlossomingDefense.class));
        cards.add(new SetCardInfo("Blossoming Sands", 291, Rarity.COMMON, mage.cards.b.BlossomingSands.class));
        cards.add(new SetCardInfo("Brash Taunter", 125, Rarity.RARE, mage.cards.b.BrashTaunter.class));
        cards.add(new SetCardInfo("Breath of Malfegor", 218, Rarity.COMMON, mage.cards.b.BreathOfMalfegor.class));
        cards.add(new SetCardInfo("Burnished Hart", 260, Rarity.UNCOMMON, mage.cards.b.BurnishedHart.class));
        cards.add(new SetCardInfo("Camaraderie", 219, Rarity.RARE, mage.cards.c.Camaraderie.class));
        cards.add(new SetCardInfo("Canopy Vista", 292, Rarity.RARE, mage.cards.c.CanopyVista.class));
        cards.add(new SetCardInfo("Cartographer's Hawk", 10, Rarity.RARE, mage.cards.c.CartographersHawk.class));
        cards.add(new SetCardInfo("Cemetery Reaper", 70, Rarity.RARE, mage.cards.c.CemeteryReaper.class));
        cards.add(new SetCardInfo("Chain Reaction", 126, Rarity.RARE, mage.cards.c.ChainReaction.class));
        cards.add(new SetCardInfo("Champion of Lambholt", 174, Rarity.RARE, mage.cards.c.ChampionOfLambholt.class));
        cards.add(new SetCardInfo("Champion of the Perished", 71, Rarity.RARE, mage.cards.c.ChampionOfThePerished.class));
        cards.add(new SetCardInfo("Chaos Warp", 127, Rarity.RARE, mage.cards.c.ChaosWarp.class));
        cards.add(new SetCardInfo("Choked Estuary", 293, Rarity.RARE, mage.cards.c.ChokedEstuary.class));
        cards.add(new SetCardInfo("Cinder Barrens", 294, Rarity.UNCOMMON, mage.cards.c.CinderBarrens.class));
        cards.add(new SetCardInfo("Cinder Glade", 295, Rarity.RARE, mage.cards.c.CinderGlade.class));
        cards.add(new SetCardInfo("Citanul Hierophants", 175, Rarity.RARE, mage.cards.c.CitanulHierophants.class));
        cards.add(new SetCardInfo("Citywide Bust", 11, Rarity.RARE, mage.cards.c.CitywideBust.class));
        cards.add(new SetCardInfo("Clan Defiance", 220, Rarity.RARE, mage.cards.c.ClanDefiance.class));
        cards.add(new SetCardInfo("Cleansing Nova", 12, Rarity.RARE, mage.cards.c.CleansingNova.class));
        cards.add(new SetCardInfo("Cloudblazer", 221, Rarity.UNCOMMON, mage.cards.c.Cloudblazer.class));
        cards.add(new SetCardInfo("Coastal Tower", 296, Rarity.UNCOMMON, mage.cards.c.CoastalTower.class));
        cards.add(new SetCardInfo("Collective Blessing", 222, Rarity.RARE, mage.cards.c.CollectiveBlessing.class));
        cards.add(new SetCardInfo("Collective Unconscious", 176, Rarity.RARE, mage.cards.c.CollectiveUnconscious.class));
        cards.add(new SetCardInfo("Combustible Gearhulk", 128, Rarity.MYTHIC, mage.cards.c.CombustibleGearhulk.class));
        cards.add(new SetCardInfo("Commander's Insignia", 13, Rarity.RARE, mage.cards.c.CommandersInsignia.class));
        cards.add(new SetCardInfo("Commander's Sphere", 261, Rarity.COMMON, mage.cards.c.CommandersSphere.class));
        cards.add(new SetCardInfo("Command Tower", 297, Rarity.COMMON, mage.cards.c.CommandTower.class));
        cards.add(new SetCardInfo("Conclave Tribunal", 14, Rarity.UNCOMMON, mage.cards.c.ConclaveTribunal.class));
        cards.add(new SetCardInfo("Condemn", 15, Rarity.UNCOMMON, mage.cards.c.Condemn.class));
        cards.add(new SetCardInfo("Counterspell", 45, Rarity.COMMON, mage.cards.c.Counterspell.class));
        cards.add(new SetCardInfo("Coveted Jewel", 262, Rarity.RARE, mage.cards.c.CovetedJewel.class));
        cards.add(new SetCardInfo("Crippling Fear", 72, Rarity.RARE, mage.cards.c.CripplingFear.class));
        cards.add(new SetCardInfo("Crucible of Fire", 129, Rarity.RARE, mage.cards.c.CrucibleOfFire.class));
        cards.add(new SetCardInfo("Cruel Revival", 73, Rarity.UNCOMMON, mage.cards.c.CruelRevival.class));
        cards.add(new SetCardInfo("Crush Contraband", 16, Rarity.UNCOMMON, mage.cards.c.CrushContraband.class));
        cards.add(new SetCardInfo("Cultivate", 177, Rarity.UNCOMMON, mage.cards.c.Cultivate.class));
        cards.add(new SetCardInfo("Curse of Bounty", 178, Rarity.UNCOMMON, mage.cards.c.CurseOfBounty.class));
        cards.add(new SetCardInfo("Curse of Disturbance", 74, Rarity.UNCOMMON, mage.cards.c.CurseOfDisturbance.class));
        cards.add(new SetCardInfo("Dauntless Escort", 223, Rarity.RARE, mage.cards.d.DauntlessEscort.class));
        cards.add(new SetCardInfo("Dawn of Hope", 17, Rarity.RARE, mage.cards.d.DawnOfHope.class));
        cards.add(new SetCardInfo("Deadly Tempest", 75, Rarity.RARE, mage.cards.d.DeadlyTempest.class));
        cards.add(new SetCardInfo("Deep Analysis", 46, Rarity.COMMON, mage.cards.d.DeepAnalysis.class));
        cards.add(new SetCardInfo("Demanding Dragon", 130, Rarity.RARE, mage.cards.d.DemandingDragon.class));
        cards.add(new SetCardInfo("Devouring Light", 18, Rarity.UNCOMMON, mage.cards.d.DevouringLight.class));
        cards.add(new SetCardInfo("Dictate of Heliod", 19, Rarity.RARE, mage.cards.d.DictateOfHeliod.class));
        cards.add(new SetCardInfo("Dictate of the Twin Gods", 131, Rarity.RARE, mage.cards.d.DictateOfTheTwinGods.class));
        cards.add(new SetCardInfo("Diluvian Primordial", 47, Rarity.RARE, mage.cards.d.DiluvianPrimordial.class));
        cards.add(new SetCardInfo("Dimir Signet", 263, Rarity.UNCOMMON, mage.cards.d.DimirSignet.class));
        cards.add(new SetCardInfo("Diregraf Captain", 224, Rarity.UNCOMMON, mage.cards.d.DiregrafCaptain.class));
        cards.add(new SetCardInfo("Disenchant", 20, Rarity.COMMON, mage.cards.d.Disenchant.class));
        cards.add(new SetCardInfo("Dismal Backwater", 298, Rarity.COMMON, mage.cards.d.DismalBackwater.class));
        cards.add(new SetCardInfo("Distant Melody", 48, Rarity.COMMON, mage.cards.d.DistantMelody.class));
        cards.add(new SetCardInfo("Draconic Disciple", 225, Rarity.UNCOMMON, mage.cards.d.DraconicDisciple.class));
        cards.add(new SetCardInfo("Dragonkin Berserker", 134, Rarity.RARE, mage.cards.d.DragonkinBerserker.class));
        cards.add(new SetCardInfo("Dragonlord's Servant", 135, Rarity.UNCOMMON, mage.cards.d.DragonlordsServant.class));
        cards.add(new SetCardInfo("Dragon Mage", 132, Rarity.UNCOMMON, mage.cards.d.DragonMage.class));
        cards.add(new SetCardInfo("Dragonmaster Outcast", 136, Rarity.MYTHIC, mage.cards.d.DragonmasterOutcast.class));
        cards.add(new SetCardInfo("Dragon's Hoard", 264, Rarity.RARE, mage.cards.d.DragonsHoard.class));
        cards.add(new SetCardInfo("Dragonspeaker Shaman", 137, Rarity.UNCOMMON, mage.cards.d.DragonspeakerShaman.class));
        cards.add(new SetCardInfo("Dragon Tempest", 133, Rarity.UNCOMMON, mage.cards.d.DragonTempest.class));
        cards.add(new SetCardInfo("Drakuseth, Maw of Flames", 138, Rarity.RARE, mage.cards.d.DrakusethMawOfFlames.class));
        cards.add(new SetCardInfo("Dream Pillager", 139, Rarity.RARE, mage.cards.d.DreamPillager.class));
        cards.add(new SetCardInfo("Dredge the Mire", 76, Rarity.RARE, mage.cards.d.DredgeTheMire.class));
        cards.add(new SetCardInfo("Drumhunter", 179, Rarity.UNCOMMON, mage.cards.d.Drumhunter.class));
        cards.add(new SetCardInfo("Elemental Bond", 180, Rarity.UNCOMMON, mage.cards.e.ElementalBond.class));
        cards.add(new SetCardInfo("Elfhame Palace", 299, Rarity.UNCOMMON, mage.cards.e.ElfhamePalace.class));
        cards.add(new SetCardInfo("Emeria Angel", 21, Rarity.RARE, mage.cards.e.EmeriaAngel.class));
        cards.add(new SetCardInfo("Emmara, Soul of the Accord", 2, Rarity.MYTHIC, mage.cards.e.EmmaraSoulOfTheAccord.class));
        cards.add(new SetCardInfo("Empyrean Eagle", 226, Rarity.UNCOMMON, mage.cards.e.EmpyreanEagle.class));
        cards.add(new SetCardInfo("Enter the God-Eternals", 227, Rarity.RARE, mage.cards.e.EnterTheGodEternals.class));
        cards.add(new SetCardInfo("Eternal Skylord", 49, Rarity.UNCOMMON, mage.cards.e.EternalSkylord.class));
        cards.add(new SetCardInfo("Eternal Witness", 181, Rarity.UNCOMMON, mage.cards.e.EternalWitness.class));
        cards.add(new SetCardInfo("Ever-Watching Threshold", 50, Rarity.RARE, mage.cards.e.EverWatchingThreshold.class));
        cards.add(new SetCardInfo("Explosion of Riches", 140, Rarity.UNCOMMON, mage.cards.e.ExplosionOfRiches.class));
        cards.add(new SetCardInfo("Faerie Formation", 51, Rarity.RARE, mage.cards.f.FaerieFormation.class));
        cards.add(new SetCardInfo("Farhaven Elf", 182, Rarity.COMMON, mage.cards.f.FarhavenElf.class));
        cards.add(new SetCardInfo("Favorable Winds", 52, Rarity.UNCOMMON, mage.cards.f.FavorableWinds.class));
        cards.add(new SetCardInfo("Feed the Swarm", 77, Rarity.COMMON, mage.cards.f.FeedTheSwarm.class));
        cards.add(new SetCardInfo("Felidar Retreat", 22, Rarity.RARE, mage.cards.f.FelidarRetreat.class));
        cards.add(new SetCardInfo("Fiery Confluence", 141, Rarity.RARE, mage.cards.f.FieryConfluence.class));
        cards.add(new SetCardInfo("Fires of Yavimaya", 228, Rarity.UNCOMMON, mage.cards.f.FiresOfYavimaya.class));
        cards.add(new SetCardInfo("Flameblast Dragon", 142, Rarity.RARE, mage.cards.f.FlameblastDragon.class));
        cards.add(new SetCardInfo("Fleshbag Marauder", 78, Rarity.COMMON, mage.cards.f.FleshbagMarauder.class));
        cards.add(new SetCardInfo("Foe-Razer Regent", 183, Rarity.RARE, mage.cards.f.FoeRazerRegent.class));
        cards.add(new SetCardInfo("Foreboding Ruins", 300, Rarity.RARE, mage.cards.f.ForebodingRuins.class));
        cards.add(new SetCardInfo("Forest", 349, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 350, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 351, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 352, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fortified Village", 301, Rarity.RARE, mage.cards.f.FortifiedVillage.class));
        cards.add(new SetCardInfo("Frontier Siege", 184, Rarity.RARE, mage.cards.f.FrontierSiege.class));
        cards.add(new SetCardInfo("Furnace Whelp", 143, Rarity.UNCOMMON, mage.cards.f.FurnaceWhelp.class));
        cards.add(new SetCardInfo("Game Trail", 302, Rarity.RARE, mage.cards.g.GameTrail.class));
        cards.add(new SetCardInfo("Garruk's Uprising", 185, Rarity.UNCOMMON, mage.cards.g.GarruksUprising.class));
        cards.add(new SetCardInfo("Generous Gift", 23, Rarity.UNCOMMON, mage.cards.g.GenerousGift.class));
        cards.add(new SetCardInfo("Geode Rager", 144, Rarity.RARE, mage.cards.g.GeodeRager.class));
        cards.add(new SetCardInfo("Geralf's Mindcrusher", 53, Rarity.RARE, mage.cards.g.GeralfsMindcrusher.class));
        cards.add(new SetCardInfo("Gideon Jura", 24, Rarity.MYTHIC, mage.cards.g.GideonJura.class));
        cards.add(new SetCardInfo("Gisa and Geralf", 3, Rarity.MYTHIC, mage.cards.g.GisaAndGeralf.class));
        cards.add(new SetCardInfo("Gleaming Overseer", 229, Rarity.UNCOMMON, mage.cards.g.GleamingOverseer.class));
        cards.add(new SetCardInfo("Gravespawn Sovereign", 79, Rarity.RARE, mage.cards.g.GravespawnSovereign.class));
        cards.add(new SetCardInfo("Gravitational Shift", 54, Rarity.RARE, mage.cards.g.GravitationalShift.class));
        cards.add(new SetCardInfo("Gray Merchant of Asphodel", 80, Rarity.UNCOMMON, mage.cards.g.GrayMerchantOfAsphodel.class));
        cards.add(new SetCardInfo("Graypelt Refuge", 303, Rarity.UNCOMMON, mage.cards.g.GraypeltRefuge.class));
        cards.add(new SetCardInfo("Great Oak Guardian", 186, Rarity.UNCOMMON, mage.cards.g.GreatOakGuardian.class));
        cards.add(new SetCardInfo("Grimoire of the Dead", 265, Rarity.MYTHIC, mage.cards.g.GrimoireOfTheDead.class));
        cards.add(new SetCardInfo("Guttersnipe", 145, Rarity.UNCOMMON, mage.cards.g.Guttersnipe.class));
        cards.add(new SetCardInfo("Hanged Executioner", 25, Rarity.RARE, mage.cards.h.HangedExecutioner.class));
        cards.add(new SetCardInfo("Harbinger of the Hunt", 230, Rarity.RARE, mage.cards.h.HarbingerOfTheHunt.class));
        cards.add(new SetCardInfo("Harmonize", 187, Rarity.UNCOMMON, mage.cards.h.Harmonize.class));
        cards.add(new SetCardInfo("Harvest Season", 188, Rarity.RARE, mage.cards.h.HarvestSeason.class));
        cards.add(new SetCardInfo("Hate Mirage", 146, Rarity.UNCOMMON, mage.cards.h.HateMirage.class));
        cards.add(new SetCardInfo("Havengul Lich", 231, Rarity.MYTHIC, mage.cards.h.HavengulLich.class));
        cards.add(new SetCardInfo("Haven of the Spirit Dragon", 304, Rarity.RARE, mage.cards.h.HavenOfTheSpiritDragon.class));
        cards.add(new SetCardInfo("Hedron Archive", 266, Rarity.UNCOMMON, mage.cards.h.HedronArchive.class));
        cards.add(new SetCardInfo("Heraldic Banner", 267, Rarity.UNCOMMON, mage.cards.h.HeraldicBanner.class));
        cards.add(new SetCardInfo("Hoard-Smelter Dragon", 147, Rarity.RARE, mage.cards.h.HoardSmelterDragon.class));
        cards.add(new SetCardInfo("Holdout Settlement", 305, Rarity.COMMON, mage.cards.h.HoldoutSettlement.class));
        cards.add(new SetCardInfo("Hornet Nest", 189, Rarity.RARE, mage.cards.h.HornetNest.class));
        cards.add(new SetCardInfo("Hornet Queen", 190, Rarity.RARE, mage.cards.h.HornetQueen.class));
        cards.add(new SetCardInfo("Hour of Reckoning", 26, Rarity.RARE, mage.cards.h.HourOfReckoning.class));
        cards.add(new SetCardInfo("Hunter's Insight", 191, Rarity.UNCOMMON, mage.cards.h.HuntersInsight.class));
        cards.add(new SetCardInfo("Hunter's Prowess", 192, Rarity.RARE, mage.cards.h.HuntersProwess.class));
        cards.add(new SetCardInfo("Idol of Oblivion", 268, Rarity.RARE, mage.cards.i.IdolOfOblivion.class));
        cards.add(new SetCardInfo("Indulgent Tormentor", 81, Rarity.UNCOMMON, mage.cards.i.IndulgentTormentor.class));
        cards.add(new SetCardInfo("Inspired Sphinx", 55, Rarity.MYTHIC, mage.cards.i.InspiredSphinx.class));
        cards.add(new SetCardInfo("Island", 337, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 338, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 339, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 340, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Isperia, Supreme Judge", 4, Rarity.MYTHIC, mage.cards.i.IsperiaSupremeJudge.class));
        cards.add(new SetCardInfo("Jade Mage", 193, Rarity.UNCOMMON, mage.cards.j.JadeMage.class));
        cards.add(new SetCardInfo("Jaspera Sentinel", 194, Rarity.COMMON, mage.cards.j.JasperaSentinel.class));
        cards.add(new SetCardInfo("Josu Vess, Lich Knight", 82, Rarity.RARE, mage.cards.j.JosuVessLichKnight.class));
        cards.add(new SetCardInfo("Jubilant Skybonder", 232, Rarity.UNCOMMON, mage.cards.j.JubilantSkybonder.class));
        cards.add(new SetCardInfo("Jwar Isle Refuge", 306, Rarity.UNCOMMON, mage.cards.j.JwarIsleRefuge.class));
        cards.add(new SetCardInfo("Kaervek the Merciless", 233, Rarity.RARE, mage.cards.k.KaervekTheMerciless.class));
        cards.add(new SetCardInfo("Kangee, Sky Warden", 234, Rarity.UNCOMMON, mage.cards.k.KangeeSkyWarden.class));
        cards.add(new SetCardInfo("Kangee's Lieutenant", 27, Rarity.UNCOMMON, mage.cards.k.KangeesLieutenant.class));
        cards.add(new SetCardInfo("Karametra's Favor", 195, Rarity.UNCOMMON, mage.cards.k.KarametrasFavor.class));
        cards.add(new SetCardInfo("Kardur, Doomscourge", 5, Rarity.MYTHIC, mage.cards.k.KardurDoomscourge.class));
        cards.add(new SetCardInfo("Kazandu Refuge", 307, Rarity.UNCOMMON, mage.cards.k.KazanduRefuge.class));
        cards.add(new SetCardInfo("Kazuul, Tyrant of the Cliffs", 148, Rarity.RARE, mage.cards.k.KazuulTyrantOfTheCliffs.class));
        cards.add(new SetCardInfo("Laboratory Drudge", 56, Rarity.RARE, mage.cards.l.LaboratoryDrudge.class));
        cards.add(new SetCardInfo("Lazotep Plating", 57, Rarity.UNCOMMON, mage.cards.l.LazotepPlating.class));
        cards.add(new SetCardInfo("Lazotep Reaver", 83, Rarity.COMMON, mage.cards.l.LazotepReaver.class));
        cards.add(new SetCardInfo("Leafkin Druid", 196, Rarity.COMMON, mage.cards.l.LeafkinDruid.class));
        cards.add(new SetCardInfo("Lightning Greaves", 269, Rarity.UNCOMMON, mage.cards.l.LightningGreaves.class));
        cards.add(new SetCardInfo("Liliana's Devotee", 85, Rarity.UNCOMMON, mage.cards.l.LilianasDevotee.class));
        cards.add(new SetCardInfo("Liliana's Mastery", 86, Rarity.RARE, mage.cards.l.LilianasMastery.class));
        cards.add(new SetCardInfo("Liliana's Standard Bearer", 87, Rarity.RARE, mage.cards.l.LilianasStandardBearer.class));
        cards.add(new SetCardInfo("Liliana, Untouched by Death", 84, Rarity.MYTHIC, mage.cards.l.LilianaUntouchedByDeath.class));
        cards.add(new SetCardInfo("Loaming Shaman", 197, Rarity.UNCOMMON, mage.cards.l.LoamingShaman.class));
        cards.add(new SetCardInfo("Lord of the Accursed", 88, Rarity.UNCOMMON, mage.cards.l.LordOfTheAccursed.class));
        cards.add(new SetCardInfo("Lotleth Giant", 89, Rarity.UNCOMMON, mage.cards.l.LotlethGiant.class));
        cards.add(new SetCardInfo("Loyal Guardian", 198, Rarity.UNCOMMON, mage.cards.l.LoyalGuardian.class));
        cards.add(new SetCardInfo("Loyal Subordinate", 90, Rarity.UNCOMMON, mage.cards.l.LoyalSubordinate.class));
        cards.add(new SetCardInfo("Magmaquake", 149, Rarity.RARE, mage.cards.m.Magmaquake.class));
        cards.add(new SetCardInfo("Magmatic Force", 150, Rarity.RARE, mage.cards.m.MagmaticForce.class));
        cards.add(new SetCardInfo("Maja, Bretagard Protector", 235, Rarity.UNCOMMON, mage.cards.m.MajaBretagardProtector.class));
        cards.add(new SetCardInfo("Mana Geyser", 151, Rarity.COMMON, mage.cards.m.ManaGeyser.class));
        cards.add(new SetCardInfo("March of the Multitudes", 236, Rarity.MYTHIC, mage.cards.m.MarchOfTheMultitudes.class));
        cards.add(new SetCardInfo("Meandering River", 308, Rarity.UNCOMMON, mage.cards.m.MeanderingRiver.class));
        cards.add(new SetCardInfo("Mentor of the Meek", 28, Rarity.RARE, mage.cards.m.MentorOfTheMeek.class));
        cards.add(new SetCardInfo("Midnight Reaper", 91, Rarity.RARE, mage.cards.m.MidnightReaper.class));
        cards.add(new SetCardInfo("Migratory Route", 237, Rarity.UNCOMMON, mage.cards.m.MigratoryRoute.class));
        cards.add(new SetCardInfo("Mire Triton", 92, Rarity.UNCOMMON, mage.cards.m.MireTriton.class));
        cards.add(new SetCardInfo("Molten Slagheap", 309, Rarity.UNCOMMON, mage.cards.m.MoltenSlagheap.class));
        cards.add(new SetCardInfo("Moorland Haunt", 310, Rarity.RARE, mage.cards.m.MoorlandHaunt.class));
        cards.add(new SetCardInfo("Mordant Dragon", 152, Rarity.RARE, mage.cards.m.MordantDragon.class));
        cards.add(new SetCardInfo("Mountain", 345, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 346, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 347, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 348, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Murder", 93, Rarity.COMMON, mage.cards.m.Murder.class));
        cards.add(new SetCardInfo("Myriad Landscape", 311, Rarity.UNCOMMON, mage.cards.m.MyriadLandscape.class));
        cards.add(new SetCardInfo("Necromantic Selection", 94, Rarity.RARE, mage.cards.n.NecromanticSelection.class));
        cards.add(new SetCardInfo("Necrotic Hex", 95, Rarity.RARE, mage.cards.n.NecroticHex.class));
        cards.add(new SetCardInfo("Negate", 58, Rarity.COMMON, mage.cards.n.Negate.class));
        cards.add(new SetCardInfo("Nihil Spellbomb", 270, Rarity.COMMON, mage.cards.n.NihilSpellbomb.class));
        cards.add(new SetCardInfo("Nissa's Expedition", 199, Rarity.UNCOMMON, mage.cards.n.NissasExpedition.class));
        cards.add(new SetCardInfo("Nullmage Shepherd", 200, Rarity.UNCOMMON, mage.cards.n.NullmageShepherd.class));
        cards.add(new SetCardInfo("Ob Nixilis Reignited", 96, Rarity.MYTHIC, mage.cards.o.ObNixilisReignited.class));
        cards.add(new SetCardInfo("Open the Graves", 97, Rarity.RARE, mage.cards.o.OpenTheGraves.class));
        cards.add(new SetCardInfo("Overrun", 201, Rarity.UNCOMMON, mage.cards.o.Overrun.class));
        cards.add(new SetCardInfo("Overseer of the Damned", 98, Rarity.RARE, mage.cards.o.OverseerOfTheDamned.class));
        cards.add(new SetCardInfo("Overwhelming Instinct", 202, Rarity.UNCOMMON, mage.cards.o.OverwhelmingInstinct.class));
        cards.add(new SetCardInfo("Path of Ancestry", 312, Rarity.COMMON, mage.cards.p.PathOfAncestry.class));
        cards.add(new SetCardInfo("Path to Exile", 29, Rarity.UNCOMMON, mage.cards.p.PathToExile.class));
        cards.add(new SetCardInfo("Pilfered Plans", 238, Rarity.COMMON, mage.cards.p.PilferedPlans.class));
        cards.add(new SetCardInfo("Pilgrim's Eye", 271, Rarity.COMMON, mage.cards.p.PilgrimsEye.class));
        cards.add(new SetCardInfo("Plains", 333, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 334, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 335, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 336, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Port Town", 313, Rarity.RARE, mage.cards.p.PortTown.class));
        cards.add(new SetCardInfo("Prairie Stream", 314, Rarity.RARE, mage.cards.p.PrairieStream.class));
        cards.add(new SetCardInfo("Presence of Gond", 203, Rarity.COMMON, mage.cards.p.PresenceOfGond.class));
        cards.add(new SetCardInfo("Primal Might", 204, Rarity.RARE, mage.cards.p.PrimalMight.class));
        cards.add(new SetCardInfo("Profane Command", 99, Rarity.RARE, mage.cards.p.ProfaneCommand.class));
        cards.add(new SetCardInfo("Provoke the Trolls", 153, Rarity.UNCOMMON, mage.cards.p.ProvokeTheTrolls.class));
        cards.add(new SetCardInfo("Rakdos Charm", 239, Rarity.UNCOMMON, mage.cards.r.RakdosCharm.class));
        cards.add(new SetCardInfo("Rakdos Signet", 272, Rarity.UNCOMMON, mage.cards.r.RakdosSignet.class));
        cards.add(new SetCardInfo("Rakshasa Debaser", 100, Rarity.RARE, mage.cards.r.RakshasaDebaser.class));
        cards.add(new SetCardInfo("Rally of Wings", 30, Rarity.UNCOMMON, mage.cards.r.RallyOfWings.class));
        cards.add(new SetCardInfo("Rapacious Dragon", 154, Rarity.COMMON, mage.cards.r.RapaciousDragon.class));
        cards.add(new SetCardInfo("Read the Bones", 101, Rarity.COMMON, mage.cards.r.ReadTheBones.class));
        cards.add(new SetCardInfo("Reclamation Sage", 205, Rarity.UNCOMMON, mage.cards.r.ReclamationSage.class));
        cards.add(new SetCardInfo("Reign of the Pit", 102, Rarity.RARE, mage.cards.r.ReignOfThePit.class));
        cards.add(new SetCardInfo("Remorseful Cleric", 31, Rarity.RARE, mage.cards.r.RemorsefulCleric.class));
        cards.add(new SetCardInfo("Return to Nature", 206, Rarity.COMMON, mage.cards.r.ReturnToNature.class));
        cards.add(new SetCardInfo("Rishkar, Peema Renegade", 207, Rarity.RARE, mage.cards.r.RishkarPeemaRenegade.class));
        cards.add(new SetCardInfo("Rootborn Defenses", 32, Rarity.COMMON, mage.cards.r.RootbornDefenses.class));
        cards.add(new SetCardInfo("Rugged Highlands", 315, Rarity.COMMON, mage.cards.r.RuggedHighlands.class));
        cards.add(new SetCardInfo("Runehorn Hellkite", 155, Rarity.RARE, mage.cards.r.RunehornHellkite.class));
        cards.add(new SetCardInfo("Sakura-Tribe Elder", 208, Rarity.COMMON, mage.cards.s.SakuraTribeElder.class));
        cards.add(new SetCardInfo("Salt Marsh", 316, Rarity.UNCOMMON, mage.cards.s.SaltMarsh.class));
        cards.add(new SetCardInfo("Sangromancer", 103, Rarity.RARE, mage.cards.s.Sangromancer.class));
        cards.add(new SetCardInfo("Sarkhan, the Dragonspeaker", 156, Rarity.MYTHIC, mage.cards.s.SarkhanTheDragonspeaker.class));
        cards.add(new SetCardInfo("Savage Ventmaw", 240, Rarity.UNCOMMON, mage.cards.s.SavageVentmaw.class));
        cards.add(new SetCardInfo("Scatter the Seeds", 209, Rarity.COMMON, mage.cards.s.ScatterTheSeeds.class));
        cards.add(new SetCardInfo("Scavenging Ooze", 210, Rarity.RARE, mage.cards.s.ScavengingOoze.class));
        cards.add(new SetCardInfo("Scourge of Nel Toth", 104, Rarity.RARE, mage.cards.s.ScourgeOfNelToth.class));
        cards.add(new SetCardInfo("Scourge of Valkas", 157, Rarity.MYTHIC, mage.cards.s.ScourgeOfValkas.class));
        cards.add(new SetCardInfo("Scythe Specter", 105, Rarity.RARE, mage.cards.s.ScytheSpecter.class));
        cards.add(new SetCardInfo("Sejiri Refuge", 317, Rarity.UNCOMMON, mage.cards.s.SejiriRefuge.class));
        cards.add(new SetCardInfo("Selesnya Evangel", 241, Rarity.COMMON, mage.cards.s.SelesnyaEvangel.class));
        cards.add(new SetCardInfo("Selesnya Guildmage", 242, Rarity.UNCOMMON, mage.cards.s.SelesnyaGuildmage.class));
        cards.add(new SetCardInfo("Sephara, Sky's Blade", 33, Rarity.RARE, mage.cards.s.SepharaSkysBlade.class));
        cards.add(new SetCardInfo("Sepulchral Primordial", 106, Rarity.RARE, mage.cards.s.SepulchralPrimordial.class));
        cards.add(new SetCardInfo("Shamanic Revelation", 211, Rarity.RARE, mage.cards.s.ShamanicRevelation.class));
        cards.add(new SetCardInfo("Sharding Sphinx", 59, Rarity.RARE, mage.cards.s.ShardingSphinx.class));
        cards.add(new SetCardInfo("Shivan Oasis", 318, Rarity.UNCOMMON, mage.cards.s.ShivanOasis.class));
        cards.add(new SetCardInfo("Sign in Blood", 107, Rarity.COMMON, mage.cards.s.SignInBlood.class));
        cards.add(new SetCardInfo("Sinister Sabotage", 60, Rarity.UNCOMMON, mage.cards.s.SinisterSabotage.class));
        cards.add(new SetCardInfo("Skycat Sovereign", 243, Rarity.RARE, mage.cards.s.SkycatSovereign.class));
        cards.add(new SetCardInfo("Sky Diamond", 273, Rarity.COMMON, mage.cards.s.SkyDiamond.class));
        cards.add(new SetCardInfo("Skyscanner", 274, Rarity.COMMON, mage.cards.s.Skyscanner.class));
        cards.add(new SetCardInfo("Slate of Ancestry", 275, Rarity.RARE, mage.cards.s.SlateOfAncestry.class));
        cards.add(new SetCardInfo("Smoldering Marsh", 319, Rarity.RARE, mage.cards.s.SmolderingMarsh.class));
        cards.add(new SetCardInfo("Solemn Simulacrum", 277, Rarity.RARE, mage.cards.s.SolemnSimulacrum.class));
        cards.add(new SetCardInfo("Sol Ring", 276, Rarity.UNCOMMON, mage.cards.s.SolRing.class));
        cards.add(new SetCardInfo("Soul Shatter", 108, Rarity.RARE, mage.cards.s.SoulShatter.class));
        cards.add(new SetCardInfo("Soul Snare", 34, Rarity.UNCOMMON, mage.cards.s.SoulSnare.class));
        cards.add(new SetCardInfo("Spark Reaper", 109, Rarity.COMMON, mage.cards.s.SparkReaper.class));
        cards.add(new SetCardInfo("Sphinx of Enlightenment", 61, Rarity.MYTHIC, mage.cards.s.SphinxOfEnlightenment.class));
        cards.add(new SetCardInfo("Sphinx's Revelation", 244, Rarity.MYTHIC, mage.cards.s.SphinxsRevelation.class));
        cards.add(new SetCardInfo("Spiteful Visions", 245, Rarity.RARE, mage.cards.s.SpitefulVisions.class));
        cards.add(new SetCardInfo("Spit Flame", 158, Rarity.RARE, mage.cards.s.SpitFlame.class));
        cards.add(new SetCardInfo("Sporemound", 212, Rarity.COMMON, mage.cards.s.Sporemound.class));
        cards.add(new SetCardInfo("Staggering Insight", 246, Rarity.UNCOMMON, mage.cards.s.StaggeringInsight.class));
        cards.add(new SetCardInfo("Steel Hellkite", 278, Rarity.RARE, mage.cards.s.SteelHellkite.class));
        cards.add(new SetCardInfo("Steel-Plume Marshal", 35, Rarity.RARE, mage.cards.s.SteelPlumeMarshal.class));
        cards.add(new SetCardInfo("Stensia Bloodhall", 320, Rarity.RARE, mage.cards.s.StensiaBloodhall.class));
        cards.add(new SetCardInfo("Stormfist Crusader", 247, Rarity.RARE, mage.cards.s.StormfistCrusader.class));
        cards.add(new SetCardInfo("Storm Herd", 36, Rarity.RARE, mage.cards.s.StormHerd.class));
        cards.add(new SetCardInfo("Submerged Boneyard", 321, Rarity.UNCOMMON, mage.cards.s.SubmergedBoneyard.class));
        cards.add(new SetCardInfo("Sunbird's Invocation", 159, Rarity.RARE, mage.cards.s.SunbirdsInvocation.class));
        cards.add(new SetCardInfo("Sunken Hollow", 322, Rarity.RARE, mage.cards.s.SunkenHollow.class));
        cards.add(new SetCardInfo("Swamp", 341, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 342, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 343, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 344, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sweltering Suns", 160, Rarity.RARE, mage.cards.s.SwelteringSuns.class));
        cards.add(new SetCardInfo("Swiftfoot Boots", 279, Rarity.UNCOMMON, mage.cards.s.SwiftfootBoots.class));
        cards.add(new SetCardInfo("Swords to Plowshares", 37, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class));
        cards.add(new SetCardInfo("Sylvan Reclamation", 248, Rarity.UNCOMMON, mage.cards.s.SylvanReclamation.class));
        cards.add(new SetCardInfo("Syphon Flesh", 110, Rarity.UNCOMMON, mage.cards.s.SyphonFlesh.class));
        cards.add(new SetCardInfo("Syphon Mind", 111, Rarity.COMMON, mage.cards.s.SyphonMind.class));
        cards.add(new SetCardInfo("Talisman of Dominance", 280, Rarity.UNCOMMON, mage.cards.t.TalismanOfDominance.class));
        cards.add(new SetCardInfo("Talisman of Impulse", 281, Rarity.UNCOMMON, mage.cards.t.TalismanOfImpulse.class));
        cards.add(new SetCardInfo("Talisman of Indulgence", 282, Rarity.UNCOMMON, mage.cards.t.TalismanOfIndulgence.class));
        cards.add(new SetCardInfo("Talisman of Progress", 283, Rarity.UNCOMMON, mage.cards.t.TalismanOfProgress.class));
        cards.add(new SetCardInfo("Talisman of Unity", 284, Rarity.UNCOMMON, mage.cards.t.TalismanOfUnity.class));
        cards.add(new SetCardInfo("Tectonic Giant", 161, Rarity.RARE, mage.cards.t.TectonicGiant.class));
        cards.add(new SetCardInfo("Temple of Abandon", 323, Rarity.RARE, mage.cards.t.TempleOfAbandon.class));
        cards.add(new SetCardInfo("Temple of Deceit", 324, Rarity.RARE, mage.cards.t.TempleOfDeceit.class));
        cards.add(new SetCardInfo("Temple of Enlightenment", 325, Rarity.RARE, mage.cards.t.TempleOfEnlightenment.class));
        cards.add(new SetCardInfo("Temple of Malice", 326, Rarity.RARE, mage.cards.t.TempleOfMalice.class));
        cards.add(new SetCardInfo("Temple of Plenty", 327, Rarity.RARE, mage.cards.t.TempleOfPlenty.class));
        cards.add(new SetCardInfo("Terminate", 249, Rarity.UNCOMMON, mage.cards.t.Terminate.class));
        cards.add(new SetCardInfo("Theater of Horrors", 250, Rarity.RARE, mage.cards.t.TheaterOfHorrors.class));
        cards.add(new SetCardInfo("Thermo-Alchemist", 162, Rarity.COMMON, mage.cards.t.ThermoAlchemist.class));
        cards.add(new SetCardInfo("Thought Vessel", 285, Rarity.UNCOMMON, mage.cards.t.ThoughtVessel.class));
        cards.add(new SetCardInfo("Thunderbreak Regent", 163, Rarity.RARE, mage.cards.t.ThunderbreakRegent.class));
        cards.add(new SetCardInfo("Thunderclap Wyvern", 251, Rarity.UNCOMMON, mage.cards.t.ThunderclapWyvern.class));
        cards.add(new SetCardInfo("Thunderfoot Baloth", 213, Rarity.RARE, mage.cards.t.ThunderfootBaloth.class));
        cards.add(new SetCardInfo("Thundermaw Hellkite", 164, Rarity.MYTHIC, mage.cards.t.ThundermawHellkite.class));
        cards.add(new SetCardInfo("Tide Skimmer", 62, Rarity.UNCOMMON, mage.cards.t.TideSkimmer.class));
        cards.add(new SetCardInfo("Timber Gorge", 328, Rarity.UNCOMMON, mage.cards.t.TimberGorge.class));
        cards.add(new SetCardInfo("Time Wipe", 252, Rarity.RARE, mage.cards.t.TimeWipe.class));
        cards.add(new SetCardInfo("Titan Hunter", 112, Rarity.RARE, mage.cards.t.TitanHunter.class));
        cards.add(new SetCardInfo("Tranquil Cove", 329, Rarity.COMMON, mage.cards.t.TranquilCove.class));
        cards.add(new SetCardInfo("Tranquil Expanse", 330, Rarity.UNCOMMON, mage.cards.t.TranquilExpanse.class));
        cards.add(new SetCardInfo("Trostani Discordant", 253, Rarity.MYTHIC, mage.cards.t.TrostaniDiscordant.class));
        cards.add(new SetCardInfo("True Conviction", 38, Rarity.RARE, mage.cards.t.TrueConviction.class));
        cards.add(new SetCardInfo("Tyrant's Familiar", 165, Rarity.RARE, mage.cards.t.TyrantsFamiliar.class));
        cards.add(new SetCardInfo("Unbreathing Horde", 113, Rarity.RARE, mage.cards.u.UnbreathingHorde.class));
        cards.add(new SetCardInfo("Undead Augur", 114, Rarity.UNCOMMON, mage.cards.u.UndeadAugur.class));
        cards.add(new SetCardInfo("Undermine", 254, Rarity.RARE, mage.cards.u.Undermine.class));
        cards.add(new SetCardInfo("Unleash Fury", 166, Rarity.UNCOMMON, mage.cards.u.UnleashFury.class));
        cards.add(new SetCardInfo("Unlicensed Disintegration", 255, Rarity.UNCOMMON, mage.cards.u.UnlicensedDisintegration.class));
        cards.add(new SetCardInfo("Unstable Obelisk", 286, Rarity.UNCOMMON, mage.cards.u.UnstableObelisk.class));
        cards.add(new SetCardInfo("Urborg Volcano", 331, Rarity.UNCOMMON, mage.cards.u.UrborgVolcano.class));
        cards.add(new SetCardInfo("Valor in Akros", 39, Rarity.UNCOMMON, mage.cards.v.ValorInAkros.class));
        cards.add(new SetCardInfo("Vampire Nighthawk", 115, Rarity.UNCOMMON, mage.cards.v.VampireNighthawk.class));
        cards.add(new SetCardInfo("Vampiric Rites", 116, Rarity.UNCOMMON, mage.cards.v.VampiricRites.class));
        cards.add(new SetCardInfo("Vandalblast", 167, Rarity.UNCOMMON, mage.cards.v.Vandalblast.class));
        cards.add(new SetCardInfo("Vela the Night-Clad", 256, Rarity.MYTHIC, mage.cards.v.VelaTheNightClad.class));
        cards.add(new SetCardInfo("Vengeful Dead", 117, Rarity.COMMON, mage.cards.v.VengefulDead.class));
        cards.add(new SetCardInfo("Verdant Force", 214, Rarity.RARE, mage.cards.v.VerdantForce.class));
        cards.add(new SetCardInfo("Verix Bladewing", 168, Rarity.MYTHIC, mage.cards.v.VerixBladewing.class));
        cards.add(new SetCardInfo("Victimize", 118, Rarity.UNCOMMON, mage.cards.v.Victimize.class));
        cards.add(new SetCardInfo("Vitu-Ghazi, the City-Tree", 332, Rarity.UNCOMMON, mage.cards.v.VituGhaziTheCityTree.class));
        cards.add(new SetCardInfo("Vizier of the Scorpion", 119, Rarity.UNCOMMON, mage.cards.v.VizierOfTheScorpion.class));
        cards.add(new SetCardInfo("Voice of Many", 215, Rarity.UNCOMMON, mage.cards.v.VoiceOfMany.class));
        cards.add(new SetCardInfo("Vow of Duty", 40, Rarity.UNCOMMON, mage.cards.v.VowOfDuty.class));
        cards.add(new SetCardInfo("Warden of Evos Isle", 63, Rarity.UNCOMMON, mage.cards.w.WardenOfEvosIsle.class));
        cards.add(new SetCardInfo("Wayfarer's Bauble", 287, Rarity.COMMON, mage.cards.w.WayfarersBauble.class));
        cards.add(new SetCardInfo("White Sun's Zenith", 41, Rarity.RARE, mage.cards.w.WhiteSunsZenith.class));
        cards.add(new SetCardInfo("Wildfire Devils", 170, Rarity.RARE, mage.cards.w.WildfireDevils.class));
        cards.add(new SetCardInfo("Wild Ricochet", 169, Rarity.RARE, mage.cards.w.WildRicochet.class));
        cards.add(new SetCardInfo("Windreader Sphinx", 64, Rarity.RARE, mage.cards.w.WindreaderSphinx.class));
        cards.add(new SetCardInfo("Winged Words", 65, Rarity.COMMON, mage.cards.w.WingedWords.class));
        cards.add(new SetCardInfo("Withered Wretch", 120, Rarity.UNCOMMON, mage.cards.w.WitheredWretch.class));
        cards.add(new SetCardInfo("Worn Powerstone", 288, Rarity.UNCOMMON, mage.cards.w.WornPowerstone.class));
        cards.add(new SetCardInfo("Zombie Apocalypse", 121, Rarity.RARE, mage.cards.z.ZombieApocalypse.class));
    }
}
