package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * https://scryfall.com/sets/sld
 */
public class SecretLairDrop extends ExpansionSet {

    private static final SecretLairDrop instance = new SecretLairDrop();

    public static SecretLairDrop getInstance() {
        return instance;
    }

    private SecretLairDrop() {
        super("Secret Lair Drop", "SLD", ExpansionSet.buildDate(2020, 3, 12), SetType.PROMOTIONAL);
        this.hasBoosters = false;
        this.hasBasicLands = true;

        // warning
        // set uses faked double faced cards (example: Zndrsplt, Eye of Wisdom),
        // so it must be split to two different cards (one card for one side, another card for another side),
        // also must add second side to directDownloadLinks in scryfall

        cards.add(new SetCardInfo("Counterspell", "99999SCTLR", Rarity.RARE, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Viscera Seer", "99999VS", Rarity.COMMON, mage.cards.v.VisceraSeer.class)); // workaround until "VS" supported as card number
        cards.add(new SetCardInfo("Snow-Covered Plains", 1, Rarity.LAND, mage.cards.s.SnowCoveredPlains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Island", 2, Rarity.LAND, mage.cards.s.SnowCoveredIsland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Swamp", 3, Rarity.LAND, mage.cards.s.SnowCoveredSwamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Mountain", 4, Rarity.LAND, mage.cards.s.SnowCoveredMountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Forest", 5, Rarity.LAND, mage.cards.s.SnowCoveredForest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodghast", 6, Rarity.RARE, mage.cards.b.Bloodghast.class));
        cards.add(new SetCardInfo("Golgari Thug", 7, Rarity.RARE, mage.cards.g.GolgariThug.class));
        cards.add(new SetCardInfo("Life from the Loam", 8, Rarity.RARE, mage.cards.l.LifeFromTheLoam.class));
        cards.add(new SetCardInfo("Reaper King", 9, Rarity.MYTHIC, mage.cards.r.ReaperKing.class));
        cards.add(new SetCardInfo("Sliver Overlord", 10, Rarity.MYTHIC, mage.cards.s.SliverOverlord.class));
        cards.add(new SetCardInfo("The Ur-Dragon", 11, Rarity.MYTHIC, mage.cards.t.TheUrDragon.class));
        cards.add(new SetCardInfo("Bitterblossom", 12, Rarity.MYTHIC, mage.cards.b.Bitterblossom.class));
        cards.add(new SetCardInfo("Goblin Bushwhacker", 17, Rarity.RARE, mage.cards.g.GoblinBushwhacker.class));
        cards.add(new SetCardInfo("Goblin Sharpshooter", 18, Rarity.RARE, mage.cards.g.GoblinSharpshooter.class));
        cards.add(new SetCardInfo("Goblin King", 19, Rarity.RARE, mage.cards.g.GoblinKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Lackey", 20, Rarity.RARE, mage.cards.g.GoblinLackey.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Piledriver", 21, Rarity.RARE, mage.cards.g.GoblinPiledriver.class));
        cards.add(new SetCardInfo("Leonin Warleader", 22, Rarity.RARE, mage.cards.l.LeoninWarleader.class));
        cards.add(new SetCardInfo("Regal Caracal", 23, Rarity.RARE, mage.cards.r.RegalCaracal.class));
        cards.add(new SetCardInfo("Qasali Slingers", 24, Rarity.RARE, mage.cards.q.QasaliSlingers.class));
        cards.add(new SetCardInfo("Arahbo, Roar of the World", 25, Rarity.MYTHIC, mage.cards.a.ArahboRoarOfTheWorld.class));
        cards.add(new SetCardInfo("Mirri, Weatherlight Duelist", 26, Rarity.MYTHIC, mage.cards.m.MirriWeatherlightDuelist.class));
        cards.add(new SetCardInfo("Serum Visions", 29, Rarity.RARE, mage.cards.s.SerumVisions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serum Visions", 30, Rarity.RARE, mage.cards.s.SerumVisions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serum Visions", 31, Rarity.RARE, mage.cards.s.SerumVisions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serum Visions", 32, Rarity.RARE, mage.cards.s.SerumVisions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ink-Eyes, Servant of Oni", 33, Rarity.RARE, mage.cards.i.InkEyesServantOfOni.class));
        cards.add(new SetCardInfo("Marrow-Gnawer", 34, Rarity.RARE, mage.cards.m.MarrowGnawer.class));
        cards.add(new SetCardInfo("Pack Rat", 35, Rarity.RARE, mage.cards.p.PackRat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rat Colony", 36, Rarity.RARE, mage.cards.r.RatColony.class));
        cards.add(new SetCardInfo("Thalia, Guardian of Thraben", 37, Rarity.RARE, mage.cards.t.ThaliaGuardianOfThraben.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thalia, Guardian of Thraben", 38, Rarity.RARE, mage.cards.t.ThaliaGuardianOfThraben.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thalia, Guardian of Thraben", 39, Rarity.RARE, mage.cards.t.ThaliaGuardianOfThraben.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thalia, Guardian of Thraben", 40, Rarity.RARE, mage.cards.t.ThaliaGuardianOfThraben.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spell Pierce", 41, Rarity.RARE, mage.cards.s.SpellPierce.class));
        cards.add(new SetCardInfo("Blood Artist", 42, Rarity.RARE, mage.cards.b.BloodArtist.class));
        cards.add(new SetCardInfo("Eternal Witness", 43, Rarity.RARE, mage.cards.e.EternalWitness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pithing Needle", 44, Rarity.RARE, mage.cards.p.PithingNeedle.class));
        cards.add(new SetCardInfo("Inkmoth Nexus", 45, Rarity.RARE, mage.cards.i.InkmothNexus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 46, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 47, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 48, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 49, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 50, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Captain Sisay", 51, Rarity.MYTHIC, mage.cards.c.CaptainSisay.class));
        cards.add(new SetCardInfo("Meren of Clan Nel Toth", 52, Rarity.MYTHIC, mage.cards.m.MerenOfClanNelToth.class));
        cards.add(new SetCardInfo("Narset, Enlightened Master", 53, Rarity.MYTHIC, mage.cards.n.NarsetEnlightenedMaster.class));
        cards.add(new SetCardInfo("Oona, Queen of the Fae", 54, Rarity.MYTHIC, mage.cards.o.OonaQueenOfTheFae.class));
        cards.add(new SetCardInfo("Saskia the Unyielding", 55, Rarity.MYTHIC, mage.cards.s.SaskiaTheUnyielding.class));
        cards.add(new SetCardInfo("Arcbound Ravager", 56, Rarity.RARE, mage.cards.a.ArcboundRavager.class));
        cards.add(new SetCardInfo("Darksteel Colossus", 57, Rarity.MYTHIC, mage.cards.d.DarksteelColossus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Walking Ballista", 58, Rarity.RARE, mage.cards.w.WalkingBallista.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Squire", 59, Rarity.RARE, mage.cards.s.Squire.class));
        cards.add(new SetCardInfo("Storm Crow", 60, Rarity.RARE, mage.cards.s.StormCrow.class));
        cards.add(new SetCardInfo("Goblin Snowman", 61, Rarity.RARE, mage.cards.g.GoblinSnowman.class));
        cards.add(new SetCardInfo("Mudhole", 62, Rarity.RARE, mage.cards.m.Mudhole.class));
        cards.add(new SetCardInfo("Plains", 63, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 64, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 65, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 66, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 67, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Heliod, God of the Sun", 68, Rarity.MYTHIC, mage.cards.h.HeliodGodOfTheSun.class));
        cards.add(new SetCardInfo("Karametra, God of Harvests", 69, Rarity.MYTHIC, mage.cards.k.KarametraGodOfHarvests.class));
        cards.add(new SetCardInfo("Iroas, God of Victory", 70, Rarity.MYTHIC, mage.cards.i.IroasGodOfVictory.class));
        cards.add(new SetCardInfo("Thassa, God of the Sea", 71, Rarity.MYTHIC, mage.cards.t.ThassaGodOfTheSea.class));
        cards.add(new SetCardInfo("Ephara, God of the Polis", 72, Rarity.MYTHIC, mage.cards.e.EpharaGodOfThePolis.class));
        cards.add(new SetCardInfo("Kruphix, God of Horizons", 73, Rarity.MYTHIC, mage.cards.k.KruphixGodOfHorizons.class));
        cards.add(new SetCardInfo("Erebos, God of the Dead", 74, Rarity.MYTHIC, mage.cards.e.ErebosGodOfTheDead.class));
        cards.add(new SetCardInfo("Phenax, God of Deception", 75, Rarity.MYTHIC, mage.cards.p.PhenaxGodOfDeception.class));
        cards.add(new SetCardInfo("Athreos, God of Passage", 76, Rarity.MYTHIC, mage.cards.a.AthreosGodOfPassage.class));
        cards.add(new SetCardInfo("Purphoros, God of the Forge", 77, Rarity.MYTHIC, mage.cards.p.PurphorosGodOfTheForge.class));
        cards.add(new SetCardInfo("Mogis, God of Slaughter", 78, Rarity.MYTHIC, mage.cards.m.MogisGodOfSlaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keranos, God of Storms", 79, Rarity.MYTHIC, mage.cards.k.KeranosGodOfStorms.class));
        cards.add(new SetCardInfo("Nylea, God of the Hunt", 80, Rarity.MYTHIC, mage.cards.n.NyleaGodOfTheHunt.class));
        cards.add(new SetCardInfo("Xenagos, God of Revels", 81, Rarity.MYTHIC, mage.cards.x.XenagosGodOfRevels.class));
        cards.add(new SetCardInfo("Pharika, God of Affliction", 82, Rarity.MYTHIC, mage.cards.p.PharikaGodOfAffliction.class));
        cards.add(new SetCardInfo("Lightning Bolt", 83, Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 84, Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 85, Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 86, Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ajani Steadfast", 87, Rarity.MYTHIC, mage.cards.a.AjaniSteadfast.class));
        cards.add(new SetCardInfo("Domri Rade", 88, Rarity.MYTHIC, mage.cards.d.DomriRade.class));
        cards.add(new SetCardInfo("Tamiyo, Field Researcher", 89, Rarity.MYTHIC, mage.cards.t.TamiyoFieldResearcher.class));
        cards.add(new SetCardInfo("Vraska, Golgari Queen", 90, Rarity.MYTHIC, mage.cards.v.VraskaGolgariQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swan Song", 91, Rarity.RARE, mage.cards.s.SwanSong.class));
        cards.add(new SetCardInfo("Birds of Paradise", 92, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gilded Goose", 93, Rarity.RARE, mage.cards.g.GildedGoose.class));
        cards.add(new SetCardInfo("Baleful Strix", 94, Rarity.RARE, mage.cards.b.BalefulStrix.class));
        cards.add(new SetCardInfo("Dovescape", 95, Rarity.RARE, mage.cards.d.Dovescape.class));
        cards.add(new SetCardInfo("Rest in Peace", 96, Rarity.RARE, mage.cards.r.RestInPeace.class));
        cards.add(new SetCardInfo("Dig Through Time", 97, Rarity.RARE, mage.cards.d.DigThroughTime.class));
        cards.add(new SetCardInfo("Ancient Grudge", 98, Rarity.RARE, mage.cards.a.AncientGrudge.class));
        cards.add(new SetCardInfo("Lightning Greaves", 99, Rarity.RARE, mage.cards.l.LightningGreaves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 100, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 101, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 102, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 103, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 104, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 105, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 106, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 107, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 108, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 109, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 110, Rarity.RARE, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Opt", 111, Rarity.RARE, mage.cards.o.Opt.class));
        cards.add(new SetCardInfo("Fatal Push", 112, Rarity.RARE, mage.cards.f.FatalPush.class));
        cards.add(new SetCardInfo("Anger of the Gods", 113, Rarity.RARE, mage.cards.a.AngerOfTheGods.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Explore", 114, Rarity.RARE, mage.cards.e.Explore.class));
        cards.add(new SetCardInfo("Glen Elendra Archmage", 115, Rarity.RARE, mage.cards.g.GlenElendraArchmage.class));
        cards.add(new SetCardInfo("Mistbind Clique", 116, Rarity.RARE, mage.cards.m.MistbindClique.class));
        cards.add(new SetCardInfo("Spellstutter Sprite", 117, Rarity.RARE, mage.cards.s.SpellstutterSprite.class));
        cards.add(new SetCardInfo("Vendilion Clique", 118, Rarity.MYTHIC, mage.cards.v.VendilionClique.class));
        cards.add(new SetCardInfo("Swamp", 119, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Sower of Temptation", 120, Rarity.RARE, mage.cards.s.SowerOfTemptation.class));
        cards.add(new SetCardInfo("Damnation", 121, Rarity.RARE, mage.cards.d.Damnation.class));
        cards.add(new SetCardInfo("Enchanted Evening", 122, Rarity.RARE, mage.cards.e.EnchantedEvening.class));
        cards.add(new SetCardInfo("Hallowed Fountain", 123, Rarity.RARE, mage.cards.h.HallowedFountain.class));
        cards.add(new SetCardInfo("Watery Grave", 124, Rarity.RARE, mage.cards.w.WateryGrave.class));
        cards.add(new SetCardInfo("Blood Crypt", 125, Rarity.RARE, mage.cards.b.BloodCrypt.class));
        cards.add(new SetCardInfo("Stomping Ground", 126, Rarity.RARE, mage.cards.s.StompingGround.class));
        cards.add(new SetCardInfo("Temple Garden", 127, Rarity.RARE, mage.cards.t.TempleGarden.class));
        cards.add(new SetCardInfo("Godless Shrine", 128, Rarity.RARE, mage.cards.g.GodlessShrine.class));
        cards.add(new SetCardInfo("Steam Vents", 129, Rarity.RARE, mage.cards.s.SteamVents.class));
        cards.add(new SetCardInfo("Overgrown Tomb", 130, Rarity.RARE, mage.cards.o.OvergrownTomb.class));
        cards.add(new SetCardInfo("Sacred Foundry", 131, Rarity.RARE, mage.cards.s.SacredFoundry.class));
        cards.add(new SetCardInfo("Breeding Pool", 132, Rarity.RARE, mage.cards.b.BreedingPool.class));
        cards.add(new SetCardInfo("Necrotic Ooze", 133, Rarity.RARE, mage.cards.n.NecroticOoze.class));
        cards.add(new SetCardInfo("Acidic Slime", 134, Rarity.RARE, mage.cards.a.AcidicSlime.class));
        cards.add(new SetCardInfo("Scavenging Ooze", 135, Rarity.RARE, mage.cards.s.ScavengingOoze.class));
        cards.add(new SetCardInfo("The Mimeoplasm", 136, Rarity.MYTHIC, mage.cards.t.TheMimeoplasm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voidslime", 137, Rarity.RARE, mage.cards.v.Voidslime.class));
        cards.add(new SetCardInfo("Anguished Unmaking", 138, Rarity.RARE, mage.cards.a.AnguishedUnmaking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Assassin's Trophy", 139, Rarity.RARE, mage.cards.a.AssassinsTrophy.class));
        cards.add(new SetCardInfo("Decimate", 140, Rarity.RARE, mage.cards.d.Decimate.class));
        cards.add(new SetCardInfo("Dreadbore", 141, Rarity.RARE, mage.cards.d.Dreadbore.class));
        cards.add(new SetCardInfo("Thraximundar", 142, Rarity.MYTHIC, mage.cards.t.Thraximundar.class));
        cards.add(new SetCardInfo("Greymond, Avacyn's Stalwart", 143, Rarity.MYTHIC, mage.cards.g.GreymondAvacynsStalwart.class));
        cards.add(new SetCardInfo("Hansk, Slayer Zealot", 144, Rarity.MYTHIC, mage.cards.h.HanskSlayerZealot.class));
        cards.add(new SetCardInfo("Gregor, Shrewd Magistrate", 145, Rarity.MYTHIC, mage.cards.g.GregorShrewdMagistrate.class));
        cards.add(new SetCardInfo("Enkira, Hostile Scavenger", 146, Rarity.MYTHIC, mage.cards.e.EnkiraHostileScavenger.class));
        cards.add(new SetCardInfo("Malik, Grim Manipulator", 147, Rarity.MYTHIC, mage.cards.m.MalikGrimManipulator.class));
        cards.add(new SetCardInfo("Admonition Angel", 154, Rarity.MYTHIC, mage.cards.a.AdmonitionAngel.class));
        cards.add(new SetCardInfo("Roil Elemental", 155, Rarity.RARE, mage.cards.r.RoilElemental.class));
        cards.add(new SetCardInfo("Zulaport Cutthroat", 156, Rarity.RARE, mage.cards.z.ZulaportCutthroat.class));
        cards.add(new SetCardInfo("Warren Instigator", 157, Rarity.MYTHIC, mage.cards.w.WarrenInstigator.class));
        cards.add(new SetCardInfo("Avenger of Zendikar", 158, Rarity.MYTHIC, mage.cards.a.AvengerOfZendikar.class));
        cards.add(new SetCardInfo("Demonlord Belzenlok", 159, Rarity.MYTHIC, mage.cards.d.DemonlordBelzenlok.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demonlord Belzenlok", "159*", Rarity.MYTHIC, mage.cards.d.DemonlordBelzenlok.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Griselbrand", 160, Rarity.MYTHIC, mage.cards.g.Griselbrand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Griselbrand", "160*", Rarity.MYTHIC, mage.cards.g.Griselbrand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana's Contract", 161, Rarity.RARE, mage.cards.l.LilianasContract.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana's Contract", "161*", Rarity.RARE, mage.cards.l.LilianasContract.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kothophed, Soul Hoarder", 162, Rarity.RARE, mage.cards.k.KothophedSoulHoarder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kothophed, Soul Hoarder", "162*", Rarity.RARE, mage.cards.k.KothophedSoulHoarder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Razaketh, the Foulblooded", 163, Rarity.MYTHIC, mage.cards.r.RazakethTheFoulblooded.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Razaketh, the Foulblooded", "163*", Rarity.MYTHIC, mage.cards.r.RazakethTheFoulblooded.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi's Protection", 164, Rarity.RARE, mage.cards.t.TeferisProtection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Consecrated Sphinx", 165, Rarity.MYTHIC, mage.cards.c.ConsecratedSphinx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Collected Company", 166, Rarity.RARE, mage.cards.c.CollectedCompany.class));
        cards.add(new SetCardInfo("Amulet of Vigor", 167, Rarity.RARE, mage.cards.a.AmuletOfVigor.class));
        cards.add(new SetCardInfo("Balance", 173, Rarity.MYTHIC, mage.cards.b.Balance.class));
        cards.add(new SetCardInfo("Brainstorm", 174, Rarity.RARE, mage.cards.b.Brainstorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Counterspell", 175, Rarity.RARE, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birds of Paradise", 176, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Howling Mine", 177, Rarity.RARE, mage.cards.h.HowlingMine.class));
        cards.add(new SetCardInfo("Wasteland", 178, Rarity.RARE, mage.cards.w.Wasteland.class));
        cards.add(new SetCardInfo("Wrath of God", 185, Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Preordain", 186, Rarity.RARE, mage.cards.p.Preordain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Decree of Pain", 187, Rarity.RARE, mage.cards.d.DecreeOfPain.class));
        cards.add(new SetCardInfo("Gamble", 188, Rarity.RARE, mage.cards.g.Gamble.class));
        cards.add(new SetCardInfo("Nature's Lore", 189, Rarity.RARE, mage.cards.n.NaturesLore.class));
        cards.add(new SetCardInfo("Soul-Scar Mage", 190, Rarity.RARE, mage.cards.s.SoulScarMage.class));
        cards.add(new SetCardInfo("Dryad of the Ilysian Grove", 191, Rarity.RARE, mage.cards.d.DryadOfTheIlysianGrove.class));
        cards.add(new SetCardInfo("Sakura-Tribe Elder", 192, Rarity.RARE, mage.cards.s.SakuraTribeElder.class));
        cards.add(new SetCardInfo("Spell Queller", 193, Rarity.RARE, mage.cards.s.SpellQueller.class));
        cards.add(new SetCardInfo("Metallic Mimic", 194, Rarity.RARE, mage.cards.m.MetallicMimic.class));
        cards.add(new SetCardInfo("Chatter of the Squirrel", 195, Rarity.RARE, mage.cards.c.ChatterOfTheSquirrel.class));
        cards.add(new SetCardInfo("Krosan Beast", 196, Rarity.RARE, mage.cards.k.KrosanBeast.class));
        cards.add(new SetCardInfo("Squirrel Mob", 197, Rarity.RARE, mage.cards.s.SquirrelMob.class));
        cards.add(new SetCardInfo("Squirrel Wrangler", 198, Rarity.RARE, mage.cards.s.SquirrelWrangler.class));
        cards.add(new SetCardInfo("Swarmyard", 199, Rarity.RARE, mage.cards.s.Swarmyard.class));
        cards.add(new SetCardInfo("Arcane Signet", 201, Rarity.RARE, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chromatic Lantern", 202, Rarity.RARE, mage.cards.c.ChromaticLantern.class));
        cards.add(new SetCardInfo("Commander's Sphere", 203, Rarity.RARE, mage.cards.c.CommandersSphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Darksteel Ingot", 204, Rarity.RARE, mage.cards.d.DarksteelIngot.class));
        cards.add(new SetCardInfo("Gilded Lotus", 205, Rarity.RARE, mage.cards.g.GildedLotus.class));
        cards.add(new SetCardInfo("Exquisite Blood", 206, Rarity.RARE, mage.cards.e.ExquisiteBlood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Night's Whisper", 207, Rarity.RARE, mage.cards.n.NightsWhisper.class));
        cards.add(new SetCardInfo("Phyrexian Tower", 208, Rarity.RARE, mage.cards.p.PhyrexianTower.class));
        cards.add(new SetCardInfo("Elesh Norn, Grand Cenobite", 209, Rarity.MYTHIC, mage.cards.e.EleshNornGrandCenobite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jin-Gitaxias, Core Augur", 210, Rarity.MYTHIC, mage.cards.j.JinGitaxiasCoreAugur.class));
        cards.add(new SetCardInfo("Sheoldred, Whispering One", 211, Rarity.MYTHIC, mage.cards.s.SheoldredWhisperingOne.class));
        cards.add(new SetCardInfo("Urabrask the Hidden", 212, Rarity.MYTHIC, mage.cards.u.UrabraskTheHidden.class));
        cards.add(new SetCardInfo("Vorinclex, Voice of Hunger", 213, Rarity.MYTHIC, mage.cards.v.VorinclexVoiceOfHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Heliod, Sun-Crowned", 214, Rarity.MYTHIC, mage.cards.h.HeliodSunCrowned.class));
        cards.add(new SetCardInfo("Goblin Rabblemaster", 215, Rarity.RARE, mage.cards.g.GoblinRabblemaster.class));
        cards.add(new SetCardInfo("Monastery Swiftspear", 216, Rarity.RARE, mage.cards.m.MonasterySwiftspear.class));
        cards.add(new SetCardInfo("Boros Charm", 217, Rarity.RARE, mage.cards.b.BorosCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gisela, Blade of Goldnight", 218, Rarity.MYTHIC, mage.cards.g.GiselaBladeOfGoldnight.class));
        cards.add(new SetCardInfo("Frost Titan", 220, Rarity.MYTHIC, mage.cards.f.FrostTitan.class));
        cards.add(new SetCardInfo("Primeval Titan", 221, Rarity.MYTHIC, mage.cards.p.PrimevalTitan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Uro, Titan of Nature's Wrath", 222, Rarity.MYTHIC, mage.cards.u.UroTitanOfNaturesWrath.class));
        cards.add(new SetCardInfo("Grave Titan", 223, Rarity.MYTHIC, mage.cards.g.GraveTitan.class));
        cards.add(new SetCardInfo("Inferno Titan", 224, Rarity.MYTHIC, mage.cards.i.InfernoTitan.class));
        cards.add(new SetCardInfo("Kroxa, Titan of Death's Hunger", 225, Rarity.MYTHIC, mage.cards.k.KroxaTitanOfDeathsHunger.class));
        cards.add(new SetCardInfo("Path to Exile", 226, Rarity.RARE, mage.cards.p.PathToExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Well of Lost Dreams", 227, Rarity.RARE, mage.cards.w.WellOfLostDreams.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frantic Search", 228, Rarity.RARE, mage.cards.f.FranticSearch.class));
        cards.add(new SetCardInfo("Intruder Alarm", 229, Rarity.RARE, mage.cards.i.IntruderAlarm.class));
        cards.add(new SetCardInfo("Shelldock Isle", 230, Rarity.RARE, mage.cards.s.ShelldockIsle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gravecrawler", 231, Rarity.RARE, mage.cards.g.Gravecrawler.class));
        cards.add(new SetCardInfo("Liliana, Death's Majesty", 232, Rarity.MYTHIC, mage.cards.l.LilianaDeathsMajesty.class));
        cards.add(new SetCardInfo("Rise of the Dark Realms", 233, Rarity.MYTHIC, mage.cards.r.RiseOfTheDarkRealms.class));
        cards.add(new SetCardInfo("Brazen Borrower", 234, Rarity.MYTHIC, mage.cards.b.BrazenBorrower.class));
        cards.add(new SetCardInfo("Vindictive Lich", 235, Rarity.RARE, mage.cards.v.VindictiveLich.class));
        cards.add(new SetCardInfo("Meandering Towershell", 236, Rarity.RARE, mage.cards.m.MeanderingTowershell.class));
        cards.add(new SetCardInfo("Ohran Frostfang", 237, Rarity.RARE, mage.cards.o.OhranFrostfang.class));
        cards.add(new SetCardInfo("Thragtusk", 238, Rarity.RARE, mage.cards.t.Thragtusk.class));
        cards.add(new SetCardInfo("Plains", 239, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 240, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 241, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 242, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 243, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Shalai, Voice of Plenty", 244, Rarity.RARE, mage.cards.s.ShalaiVoiceOfPlenty.class));
        cards.add(new SetCardInfo("Ponder", 245, Rarity.RARE, mage.cards.p.Ponder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cultivate", 246, Rarity.RARE, mage.cards.c.Cultivate.class));
        cards.add(new SetCardInfo("Kaya, Ghost Assassin", 247, Rarity.MYTHIC, mage.cards.k.KayaGhostAssassin.class));
        cards.add(new SetCardInfo("Teferi, Hero of Dominaria", 248, Rarity.MYTHIC, mage.cards.t.TeferiHeroOfDominaria.class));
        cards.add(new SetCardInfo("Sol Ring", 249, Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Path of Ancestry", 250, Rarity.RARE, mage.cards.p.PathOfAncestry.class));
        cards.add(new SetCardInfo("Dack Fayden", 251, Rarity.MYTHIC, mage.cards.d.DackFayden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi, Time Raveler", 252, Rarity.RARE, mage.cards.t.TeferiTimeRaveler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, the Great Creator", 253, Rarity.RARE, mage.cards.k.KarnTheGreatCreator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 254, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 255, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 256, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 257, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 258, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Michiko Konda, Truth Seeker", 259, Rarity.RARE, mage.cards.m.MichikoKondaTruthSeeker.class));
        cards.add(new SetCardInfo("Kami of the Crescent Moon", 260, Rarity.RARE, mage.cards.k.KamiOfTheCrescentMoon.class));
        cards.add(new SetCardInfo("Toshiro Umezawa", 261, Rarity.RARE, mage.cards.t.ToshiroUmezawa.class));
        cards.add(new SetCardInfo("Heartless Hidetsugu", 262, Rarity.RARE, mage.cards.h.HeartlessHidetsugu.class));
        cards.add(new SetCardInfo("Reki, the History of Kamigawa", 263, Rarity.RARE, mage.cards.r.RekiTheHistoryOfKamigawa.class));
        cards.add(new SetCardInfo("All Is Dust", 268, Rarity.RARE, mage.cards.a.AllIsDust.class));
        cards.add(new SetCardInfo("Artifact Mutation", 269, Rarity.RARE, mage.cards.a.ArtifactMutation.class));
        cards.add(new SetCardInfo("Drown in the Loch", 270, Rarity.RARE, mage.cards.d.DrownInTheLoch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fire Covenant", 271, Rarity.RARE, mage.cards.f.FireCovenant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fractured Identity", 272, Rarity.RARE, mage.cards.f.FracturedIdentity.class));
        cards.add(new SetCardInfo("Fracturing Gust", 273, Rarity.RARE, mage.cards.f.FracturingGust.class));
        cards.add(new SetCardInfo("Ob Nixilis Reignited", 274, Rarity.MYTHIC, mage.cards.o.ObNixilisReignited.class));
        cards.add(new SetCardInfo("Sire of Insanity", 275, Rarity.RARE, mage.cards.s.SireOfInsanity.class));
        cards.add(new SetCardInfo("Sliver Hivelord", 276, Rarity.MYTHIC, mage.cards.s.SliverHivelord.class));
        cards.add(new SetCardInfo("Spellskite", 277, Rarity.RARE, mage.cards.s.Spellskite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sanctum Prelate", 278, Rarity.MYTHIC, mage.cards.s.SanctumPrelate.class));
        cards.add(new SetCardInfo("Carpet of Flowers", 279, Rarity.RARE, mage.cards.c.CarpetOfFlowers.class));
        cards.add(new SetCardInfo("Sphere of Safety", 280, Rarity.RARE, mage.cards.s.SphereOfSafety.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karmic Guide", 281, Rarity.RARE, mage.cards.k.KarmicGuide.class));
        cards.add(new SetCardInfo("Mesa Enchantress", 282, Rarity.RARE, mage.cards.m.MesaEnchantress.class));
        cards.add(new SetCardInfo("Archaeomancer", 283, Rarity.RARE, mage.cards.a.Archaeomancer.class));
        cards.add(new SetCardInfo("Bloom Tender", 284, Rarity.RARE, mage.cards.b.BloomTender.class));
        cards.add(new SetCardInfo("Meteor Golem", 285, Rarity.RARE, mage.cards.m.MeteorGolem.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azorius Signet", 286, Rarity.RARE, mage.cards.a.AzoriusSignet.class));
        cards.add(new SetCardInfo("Dimir Signet", 287, Rarity.RARE, mage.cards.d.DimirSignet.class));
        cards.add(new SetCardInfo("Gruul Signet", 288, Rarity.RARE, mage.cards.g.GruulSignet.class));
        cards.add(new SetCardInfo("Rakdos Signet", 289, Rarity.RARE, mage.cards.r.RakdosSignet.class));
        cards.add(new SetCardInfo("Selesnya Signet", 290, Rarity.RARE, mage.cards.s.SelesnyaSignet.class));
        cards.add(new SetCardInfo("Boros Signet", 291, Rarity.RARE, mage.cards.b.BorosSignet.class));
        cards.add(new SetCardInfo("Golgari Signet", 292, Rarity.RARE, mage.cards.g.GolgariSignet.class));
        cards.add(new SetCardInfo("Izzet Signet", 293, Rarity.RARE, mage.cards.i.IzzetSignet.class));
        cards.add(new SetCardInfo("Orzhov Signet", 294, Rarity.RARE, mage.cards.o.OrzhovSignet.class));
        cards.add(new SetCardInfo("Simic Signet", 295, Rarity.RARE, mage.cards.s.SimicSignet.class));
        cards.add(new SetCardInfo("Mother of Runes", 296, Rarity.RARE, mage.cards.m.MotherOfRunes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mother of Runes", 297, Rarity.RARE, mage.cards.m.MotherOfRunes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mother of Runes", 298, Rarity.RARE, mage.cards.m.MotherOfRunes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mother of Runes", 299, Rarity.RARE, mage.cards.m.MotherOfRunes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ancient Den", 300, Rarity.RARE, mage.cards.a.AncientDen.class));
        cards.add(new SetCardInfo("Seat of the Synod", 301, Rarity.RARE, mage.cards.s.SeatOfTheSynod.class));
        cards.add(new SetCardInfo("Vault of Whispers", 302, Rarity.RARE, mage.cards.v.VaultOfWhispers.class));
        cards.add(new SetCardInfo("Great Furnace", 303, Rarity.RARE, mage.cards.g.GreatFurnace.class));
        cards.add(new SetCardInfo("Tree of Tales", 304, Rarity.RARE, mage.cards.t.TreeOfTales.class));
        cards.add(new SetCardInfo("Ravenous Chupacabra", 305, Rarity.RARE, mage.cards.r.RavenousChupacabra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Managorger Hydra", 306, Rarity.RARE, mage.cards.m.ManagorgerHydra.class));
        cards.add(new SetCardInfo("Pathbreaker Ibex", 307, Rarity.RARE, mage.cards.p.PathbreakerIbex.class));
        cards.add(new SetCardInfo("Temur Sabertooth", 308, Rarity.RARE, mage.cards.t.TemurSabertooth.class));
        cards.add(new SetCardInfo("Winding Constrictor", 309, Rarity.RARE, mage.cards.w.WindingConstrictor.class));
        cards.add(new SetCardInfo("Unbreakable Formation", 310, Rarity.RARE, mage.cards.u.UnbreakableFormation.class));
        cards.add(new SetCardInfo("Whir of Invention", 311, Rarity.RARE, mage.cards.w.WhirOfInvention.class));
        cards.add(new SetCardInfo("Hero's Downfall", 312, Rarity.RARE, mage.cards.h.HerosDownfall.class));
        cards.add(new SetCardInfo("Impact Tremors", 313, Rarity.RARE, mage.cards.i.ImpactTremors.class));
        cards.add(new SetCardInfo("Primal Vigor", 314, Rarity.RARE, mage.cards.p.PrimalVigor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commander's Sphere", 315, Rarity.RARE, mage.cards.c.CommandersSphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fleet Swallower", 316, Rarity.RARE, mage.cards.f.FleetSwallower.class));
        cards.add(new SetCardInfo("Goblin Trashmaster", 317, Rarity.RARE, mage.cards.g.GoblinTrashmaster.class));
        cards.add(new SetCardInfo("Ilharg, the Raze-Boar", 318, Rarity.MYTHIC, mage.cards.i.IlhargTheRazeBoar.class));
        cards.add(new SetCardInfo("Protean Hulk", 319, Rarity.RARE, mage.cards.p.ProteanHulk.class));
        cards.add(new SetCardInfo("Gishath, Sun's Avatar", 320, Rarity.MYTHIC, mage.cards.g.GishathSunsAvatar.class));
        cards.add(new SetCardInfo("Dismember", 321, Rarity.RARE, mage.cards.d.Dismember.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blasphemous Act", 322, Rarity.RARE, mage.cards.b.BlasphemousAct.class));
        cards.add(new SetCardInfo("Beast Within", 323, Rarity.RARE, mage.cards.b.BeastWithin.class));
        cards.add(new SetCardInfo("Grafdigger's Cage", 324, Rarity.RARE, mage.cards.g.GrafdiggersCage.class));
        cards.add(new SetCardInfo("Snow-Covered Plains", 325, Rarity.LAND, mage.cards.s.SnowCoveredPlains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Island", 326, Rarity.LAND, mage.cards.s.SnowCoveredIsland.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Swamp", 327, Rarity.LAND, mage.cards.s.SnowCoveredSwamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Mountain", 328, Rarity.LAND, mage.cards.s.SnowCoveredMountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Forest", 329, Rarity.LAND, mage.cards.s.SnowCoveredForest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Aether Gust", 330, Rarity.RARE, mage.cards.a.AetherGust.class));
        cards.add(new SetCardInfo("Counterspell", 331, Rarity.RARE, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fabricate", 332, Rarity.RARE, mage.cards.f.Fabricate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fact or Fiction", 333, Rarity.RARE, mage.cards.f.FactOrFiction.class));
        cards.add(new SetCardInfo("Mystical Tutor", 334, Rarity.RARE, mage.cards.m.MysticalTutor.class));
        cards.add(new SetCardInfo("Arvinox, the Mind Flail", 340, Rarity.MYTHIC, mage.cards.a.ArvinoxTheMindFlail.class));
        cards.add(new SetCardInfo("Sophina, Spearsage Deserter", 341, Rarity.RARE, mage.cards.s.SophinaSpearsageDeserter.class));
        cards.add(new SetCardInfo("Hargilde, Kindly Runechanter", 342, Rarity.RARE, mage.cards.h.HargildeKindlyRunechanter.class));
        cards.add(new SetCardInfo("Cecily, Haunted Mage", 343, Rarity.RARE, mage.cards.c.CecilyHauntedMage.class));
        cards.add(new SetCardInfo("Bjorna, Nightfall Alchemist", 344, Rarity.RARE, mage.cards.b.BjornaNightfallAlchemist.class));
        cards.add(new SetCardInfo("Elmar, Ulvenwald Informant", 345, Rarity.RARE, mage.cards.e.ElmarUlvenwaldInformant.class));
        cards.add(new SetCardInfo("Othelm, Sigardian Outcast", 346, Rarity.RARE, mage.cards.o.OthelmSigardianOutcast.class));
        cards.add(new SetCardInfo("Wernog, Rider's Chaplain", 347, Rarity.RARE, mage.cards.w.WernogRidersChaplain.class));
        cards.add(new SetCardInfo("Moorland Haunt", 349, Rarity.RARE, mage.cards.m.MoorlandHaunt.class));
        cards.add(new SetCardInfo("Vault of the Archangel", 350, Rarity.RARE, mage.cards.v.VaultOfTheArchangel.class));
        cards.add(new SetCardInfo("Nephalia Drownyard", 351, Rarity.RARE, mage.cards.n.NephaliaDrownyard.class));
        cards.add(new SetCardInfo("Desolate Lighthouse", 352, Rarity.RARE, mage.cards.d.DesolateLighthouse.class));
        cards.add(new SetCardInfo("Stensia Bloodhall", 353, Rarity.RARE, mage.cards.s.StensiaBloodhall.class));
        cards.add(new SetCardInfo("Grim Backwoods", 354, Rarity.RARE, mage.cards.g.GrimBackwoods.class));
        cards.add(new SetCardInfo("Kessig Wolf Run", 355, Rarity.RARE, mage.cards.k.KessigWolfRun.class));
        cards.add(new SetCardInfo("Slayers' Stronghold", 356, Rarity.RARE, mage.cards.s.SlayersStronghold.class));
        cards.add(new SetCardInfo("Gavony Township", 357, Rarity.RARE, mage.cards.g.GavonyTownship.class));
        cards.add(new SetCardInfo("Alchemist's Refuge", 358, Rarity.RARE, mage.cards.a.AlchemistsRefuge.class));
        cards.add(new SetCardInfo("Plains", 359, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 360, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 361, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 362, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 363, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 364, Rarity.RARE, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grim Tutor", 365, Rarity.RARE, mage.cards.g.GrimTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blood Moon", 366, Rarity.RARE, mage.cards.b.BloodMoon.class));
        cards.add(new SetCardInfo("Cut // Ribbons", 367, Rarity.RARE, mage.cards.c.CutRibbons.class));
        cards.add(new SetCardInfo("Teferi's Puzzle Box", 368, Rarity.RARE, mage.cards.t.TeferisPuzzleBox.class));
        cards.add(new SetCardInfo("Generous Gift", 369, Rarity.RARE, mage.cards.g.GenerousGift.class));
        cards.add(new SetCardInfo("Chain Lightning", 370, Rarity.RARE, mage.cards.c.ChainLightning.class));
        cards.add(new SetCardInfo("Kodama's Reach", 371, Rarity.RARE, mage.cards.k.KodamasReach.class));
        cards.add(new SetCardInfo("Heirloom Blade", 372, Rarity.RARE, mage.cards.h.HeirloomBlade.class));
        cards.add(new SetCardInfo("Mulldrifter", 373, Rarity.RARE, mage.cards.m.Mulldrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mulldrifter", 374, Rarity.RARE, mage.cards.m.Mulldrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Craterhoof Behemoth", 375, Rarity.MYTHIC, mage.cards.c.CraterhoofBehemoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Craterhoof Behemoth", 376, Rarity.MYTHIC, mage.cards.c.CraterhoofBehemoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Metalwork Colossus", 377, Rarity.RARE, mage.cards.m.MetalworkColossus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Metalwork Colossus", 378, Rarity.RARE, mage.cards.m.MetalworkColossus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zndrsplt, Eye of Wisdom", 379, Rarity.RARE, mage.cards.z.ZndrspltEyeOfWisdom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zndrsplt, Eye of Wisdom", "379b", Rarity.RARE, mage.cards.z.ZndrspltEyeOfWisdom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zndrsplt, Eye of Wisdom", "379*", Rarity.RARE, mage.cards.z.ZndrspltEyeOfWisdom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zndrsplt, Eye of Wisdom", "379*b", Rarity.RARE, mage.cards.z.ZndrspltEyeOfWisdom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Okaun, Eye of Chaos", 380, Rarity.RARE, mage.cards.o.OkaunEyeOfChaos.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Okaun, Eye of Chaos", "380b", Rarity.RARE, mage.cards.o.OkaunEyeOfChaos.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Okaun, Eye of Chaos", "380*", Rarity.RARE, mage.cards.o.OkaunEyeOfChaos.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Okaun, Eye of Chaos", "380*b", Rarity.RARE, mage.cards.o.OkaunEyeOfChaos.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Propaganda", 381, Rarity.RARE, mage.cards.p.Propaganda.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Propaganda", "381b", Rarity.RARE, mage.cards.p.Propaganda.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stitch in Time", 382, Rarity.RARE, mage.cards.s.StitchInTime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stitch in Time", "382b", Rarity.RARE, mage.cards.s.StitchInTime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krark's Thumb", 383, Rarity.RARE, mage.cards.k.KrarksThumb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krark's Thumb", "383b", Rarity.RARE, mage.cards.k.KrarksThumb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 384, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 385, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 386, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 387, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 388, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 389, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Plains", 390, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Plains", 391, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 392, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Plains", 393, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 394, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 395, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Tamiyo, the Moon Sage", 396, Rarity.MYTHIC, mage.cards.t.TamiyoTheMoonSage.class));
        cards.add(new SetCardInfo("Ajani, Mentor of Heroes", 397, Rarity.MYTHIC, mage.cards.a.AjaniMentorOfHeroes.class));
        cards.add(new SetCardInfo("Angrath, the Flame-Chained", 398, Rarity.MYTHIC, mage.cards.a.AngrathTheFlameChained.class));
        cards.add(new SetCardInfo("Ashiok, Dream Render", 399, Rarity.RARE, mage.cards.a.AshiokDreamRender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sorin, Grim Nemesis", 400, Rarity.MYTHIC, mage.cards.s.SorinGrimNemesis.class));
        cards.add(new SetCardInfo("Peek", 401, Rarity.RARE, mage.cards.p.Peek.class));
        cards.add(new SetCardInfo("Greed", 402, Rarity.RARE, mage.cards.g.Greed.class));
        cards.add(new SetCardInfo("Curiosity", 403, Rarity.RARE, mage.cards.c.Curiosity.class));
        cards.add(new SetCardInfo("Vandalblast", 404, Rarity.RARE, mage.cards.v.Vandalblast.class));
        cards.add(new SetCardInfo("Last Chance", 405, Rarity.RARE, mage.cards.l.LastChance.class));
        cards.add(new SetCardInfo("Mystic Remora", 406, Rarity.RARE, mage.cards.m.MysticRemora.class));
        cards.add(new SetCardInfo("Retreat to Coralhelm", 407, Rarity.RARE, mage.cards.r.RetreatToCoralhelm.class));
        cards.add(new SetCardInfo("Burgeoning", 408, Rarity.RARE, mage.cards.b.Burgeoning.class));
        cards.add(new SetCardInfo("Utopia Sprawl", 409, Rarity.RARE, mage.cards.u.UtopiaSprawl.class));
        cards.add(new SetCardInfo("Brain Freeze", 410, Rarity.RARE, mage.cards.b.BrainFreeze.class));
        cards.add(new SetCardInfo("Bribery", 411, Rarity.RARE, mage.cards.b.Bribery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snap", 412, Rarity.RARE, mage.cards.s.Snap.class));
        cards.add(new SetCardInfo("Unmask", 413, Rarity.RARE, mage.cards.u.Unmask.class));
        cards.add(new SetCardInfo("Shadow of Doubt", 414, Rarity.RARE, mage.cards.s.ShadowOfDoubt.class));
        cards.add(new SetCardInfo("Plains", 415, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 416, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 417, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 418, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 419, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Hokori, Dust Drinker", 420, Rarity.RARE, mage.cards.h.HokoriDustDrinker.class));
        cards.add(new SetCardInfo("Kira, Great Glass-Spinner", 421, Rarity.RARE, mage.cards.k.KiraGreatGlassSpinner.class));
        cards.add(new SetCardInfo("Eidolon of the Great Revel", 422, Rarity.RARE, mage.cards.e.EidolonOfTheGreatRevel.class));
        cards.add(new SetCardInfo("Elvish Spirit Guide", 423, Rarity.RARE, mage.cards.e.ElvishSpiritGuide.class));
        cards.add(new SetCardInfo("Ghostly Prison", 424, Rarity.RARE, mage.cards.g.GhostlyPrison.class));
        cards.add(new SetCardInfo("Freed from the Real", 425, Rarity.RARE, mage.cards.f.FreedFromTheReal.class));
        cards.add(new SetCardInfo("Boseiju, Who Shelters All", 426, Rarity.RARE, mage.cards.b.BoseijuWhoSheltersAll.class));
        cards.add(new SetCardInfo("Hall of the Bandit Lord", 427, Rarity.RARE, mage.cards.h.HallOfTheBanditLord.class));
        cards.add(new SetCardInfo("Baldin, Century Herdmaster", 428, Rarity.RARE, mage.cards.b.BaldinCenturyHerdmaster.class));
        cards.add(new SetCardInfo("Vikya, Scorching Stalwart", 429, Rarity.RARE, mage.cards.v.VikyaScorchingStalwart.class));
        cards.add(new SetCardInfo("Aisha of Sparks and Smoke", 430, Rarity.RARE, mage.cards.a.AishaOfSparksAndSmoke.class));
        cards.add(new SetCardInfo("The Howling Abomination", 431, Rarity.RARE, mage.cards.t.TheHowlingAbomination.class));
        cards.add(new SetCardInfo("Zethi, Arcane Blademaster", 432, Rarity.RARE, mage.cards.z.ZethiArcaneBlademaster.class));
        cards.add(new SetCardInfo("Tadeas, Juniper Ascendant", 433, Rarity.RARE, mage.cards.t.TadeasJuniperAscendant.class));
        cards.add(new SetCardInfo("Immard, the Stormcleaver", 434, Rarity.RARE, mage.cards.i.ImmardTheStormcleaver.class));
        cards.add(new SetCardInfo("Maarika, Brutal Gladiator", 435, Rarity.RARE, mage.cards.m.MaarikaBrutalGladiator.class));
        cards.add(new SetCardInfo("Windbrisk Heights", 436, Rarity.RARE, mage.cards.w.WindbriskHeights.class));
        cards.add(new SetCardInfo("Shelldock Isle", 437, Rarity.RARE, mage.cards.s.ShelldockIsle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Howltooth Hollow", 438, Rarity.RARE, mage.cards.h.HowltoothHollow.class));
        cards.add(new SetCardInfo("Spinerock Knoll", 439, Rarity.RARE, mage.cards.s.SpinerockKnoll.class));
        cards.add(new SetCardInfo("Mosswort Bridge", 440, Rarity.RARE, mage.cards.m.MosswortBridge.class));
        cards.add(new SetCardInfo("Wrath of God", 441, Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dance of Many", 442, Rarity.RARE, mage.cards.d.DanceOfMany.class));
        cards.add(new SetCardInfo("Etherium Sculptor", 443, Rarity.RARE, mage.cards.e.EtheriumSculptor.class));
        cards.add(new SetCardInfo("Grim Tutor", 444, Rarity.MYTHIC, mage.cards.g.GrimTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Triumph of the Hordes", 445, Rarity.RARE, mage.cards.t.TriumphOfTheHordes.class));
        cards.add(new SetCardInfo("Smuggler's Copter", 446, Rarity.RARE, mage.cards.s.SmugglersCopter.class));
        cards.add(new SetCardInfo("Planar Bridge", 447, Rarity.MYTHIC, mage.cards.p.PlanarBridge.class));
        cards.add(new SetCardInfo("Plains", 448, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 449, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 450, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 451, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 452, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Atraxa, Praetors' Voice", 453, Rarity.MYTHIC, mage.cards.a.AtraxaPraetorsVoice.class));
        cards.add(new SetCardInfo("Breya, Etherium Shaper", 454, Rarity.MYTHIC, mage.cards.b.BreyaEtheriumShaper.class));
        cards.add(new SetCardInfo("Yidris, Maelstrom Wielder", 455, Rarity.MYTHIC, mage.cards.y.YidrisMaelstromWielder.class));
        cards.add(new SetCardInfo("Glacial Fortress", 456, Rarity.RARE, mage.cards.g.GlacialFortress.class));
        cards.add(new SetCardInfo("Drowned Catacomb", 457, Rarity.RARE, mage.cards.d.DrownedCatacomb.class));
        cards.add(new SetCardInfo("Dragonskull Summit", 458, Rarity.RARE, mage.cards.d.DragonskullSummit.class));
        cards.add(new SetCardInfo("Rootbound Crag", 459, Rarity.RARE, mage.cards.r.RootboundCrag.class));
        cards.add(new SetCardInfo("Sunpetal Grove", 460, Rarity.RARE, mage.cards.s.SunpetalGrove.class));
        cards.add(new SetCardInfo("Sram, Senior Edificer", 461, Rarity.RARE, mage.cards.s.SramSeniorEdificer.class));
        cards.add(new SetCardInfo("Balthor the Defiled", 462, Rarity.RARE, mage.cards.b.BalthorTheDefiled.class));
        cards.add(new SetCardInfo("Torbran, Thane of Red Fell", 463, Rarity.RARE, mage.cards.t.TorbranThaneOfRedFell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Depala, Pilot Exemplar", 464, Rarity.RARE, mage.cards.d.DepalaPilotExemplar.class));
        cards.add(new SetCardInfo("Nomad Outpost", 465, Rarity.RARE, mage.cards.n.NomadOutpost.class));
        cards.add(new SetCardInfo("Island", 466, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Concordant Crossroads", 467, Rarity.RARE, mage.cards.c.ConcordantCrossroads.class));
        cards.add(new SetCardInfo("Ghost Quarter", 468, Rarity.RARE, mage.cards.g.GhostQuarter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ash Barrens", 469, Rarity.RARE, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Command Beacon", 470, Rarity.RARE, mage.cards.c.CommandBeacon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fabled Passage", 471, Rarity.RARE, mage.cards.f.FabledPassage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Strip Mine", 472, Rarity.RARE, mage.cards.s.StripMine.class));
        cards.add(new SetCardInfo("Mother of Runes", 473, Rarity.RARE, mage.cards.m.MotherOfRunes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Death's Shadow", 474, Rarity.RARE, mage.cards.d.DeathsShadow.class));
        cards.add(new SetCardInfo("Elvish Mystic", 475, Rarity.RARE, mage.cards.e.ElvishMystic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 476, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Path to Exile", 477, Rarity.RARE, mage.cards.p.PathToExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rhystic Study", 478, Rarity.RARE, mage.cards.r.RhysticStudy.class));
        cards.add(new SetCardInfo("Duress", 479, Rarity.RARE, mage.cards.d.Duress.class));
        cards.add(new SetCardInfo("Seize the Day", 480, Rarity.RARE, mage.cards.s.SeizeTheDay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krosan Grip", 481, Rarity.RARE, mage.cards.k.KrosanGrip.class));
        cards.add(new SetCardInfo("Counterflux", 482, Rarity.RARE, mage.cards.c.Counterflux.class));
        cards.add(new SetCardInfo("Thran Dynamo", 483, Rarity.RARE, mage.cards.t.ThranDynamo.class));
        cards.add(new SetCardInfo("Plains", 484, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 485, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 486, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 487, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 488, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Akroma, Angel of Wrath", 489, Rarity.MYTHIC, mage.cards.a.AkromaAngelOfWrath.class));
        cards.add(new SetCardInfo("Mikaeus, the Unhallowed", 490, Rarity.MYTHIC, mage.cards.m.MikaeusTheUnhallowed.class));
        cards.add(new SetCardInfo("Glissa Sunseeker", 491, Rarity.RARE, mage.cards.g.GlissaSunseeker.class));
        cards.add(new SetCardInfo("Olivia, Mobilized for War", 492, Rarity.MYTHIC, mage.cards.o.OliviaMobilizedForWar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kozilek, the Great Distortion", 493, Rarity.MYTHIC, mage.cards.k.KozilekTheGreatDistortion.class));
        cards.add(new SetCardInfo("Primeval Titan", 494, Rarity.MYTHIC, mage.cards.p.PrimevalTitan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Huntmaster of the Fells", 495, Rarity.MYTHIC, mage.cards.h.HuntmasterOfTheFells.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ravager of the Fells", 495, Rarity.MYTHIC, mage.cards.r.RavagerOfTheFells.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Platinum Angel", 496, Rarity.RARE, mage.cards.p.PlatinumAngel.class));
        cards.add(new SetCardInfo("Brimaz, King of Oreskos", 497, Rarity.MYTHIC, mage.cards.b.BrimazKingOfOreskos.class));
        cards.add(new SetCardInfo("Arcanis the Omnipotent", 498, Rarity.RARE, mage.cards.a.ArcanisTheOmnipotent.class));
        cards.add(new SetCardInfo("Queen Marchesa", 499, Rarity.MYTHIC, mage.cards.q.QueenMarchesa.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savra, Queen of the Golgari", 500, Rarity.RARE, mage.cards.s.SavraQueenOfTheGolgari.class));
        cards.add(new SetCardInfo("Karn, the Great Creator", 501, Rarity.RARE, mage.cards.k.KarnTheGreatCreator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ugin, the Ineffable", 502, Rarity.RARE, mage.cards.u.UginTheIneffable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gideon Blackblade", 503, Rarity.MYTHIC, mage.cards.g.GideonBlackblade.class));
        cards.add(new SetCardInfo("Teyo, the Shieldmage", 504, Rarity.UNCOMMON, mage.cards.t.TeyoTheShieldmage.class));
        cards.add(new SetCardInfo("The Wanderer", 505, Rarity.UNCOMMON, mage.cards.t.TheWanderer.class));
        cards.add(new SetCardInfo("Jace, Wielder of Mysteries", 506, Rarity.RARE, mage.cards.j.JaceWielderOfMysteries.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kasmina, Enigmatic Mentor", 507, Rarity.UNCOMMON, mage.cards.k.KasminaEnigmaticMentor.class));
        cards.add(new SetCardInfo("Narset, Parter of Veils", 508, Rarity.UNCOMMON, mage.cards.n.NarsetParterOfVeils.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Davriel, Rogue Shadowmage", 509, Rarity.UNCOMMON, mage.cards.d.DavrielRogueShadowmage.class));
        cards.add(new SetCardInfo("Liliana, Dreadhorde General", 510, Rarity.MYTHIC, mage.cards.l.LilianaDreadhordeGeneral.class));
        cards.add(new SetCardInfo("Ob Nixilis, the Hate-Twisted", 511, Rarity.UNCOMMON, mage.cards.o.ObNixilisTheHateTwisted.class));
        cards.add(new SetCardInfo("Chandra, Fire Artisan", 512, Rarity.RARE, mage.cards.c.ChandraFireArtisan.class));
        cards.add(new SetCardInfo("Jaya, Venerated Firemage", 513, Rarity.UNCOMMON, mage.cards.j.JayaVeneratedFiremage.class));
        cards.add(new SetCardInfo("Sarkhan the Masterless", 514, Rarity.RARE, mage.cards.s.SarkhanTheMasterless.class));
        cards.add(new SetCardInfo("Tibalt, Rakish Instigator", 515, Rarity.UNCOMMON, mage.cards.t.TibaltRakishInstigator.class));
        cards.add(new SetCardInfo("Arlinn, Voice of the Pack", 516, Rarity.UNCOMMON, mage.cards.a.ArlinnVoiceOfThePack.class));
        cards.add(new SetCardInfo("Jiang Yanggu, Wildcrafter", 517, Rarity.UNCOMMON, mage.cards.j.JiangYangguWildcrafter.class));
        cards.add(new SetCardInfo("Nissa, Who Shakes the World", 518, Rarity.RARE, mage.cards.n.NissaWhoShakesTheWorld.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vivien, Champion of the Wilds", 519, Rarity.RARE, mage.cards.v.VivienChampionOfTheWilds.class));
        cards.add(new SetCardInfo("Ajani, the Greathearted", 520, Rarity.RARE, mage.cards.a.AjaniTheGreathearted.class));
        cards.add(new SetCardInfo("Domri, Anarch of Bolas", 521, Rarity.RARE, mage.cards.d.DomriAnarchOfBolas.class));
        cards.add(new SetCardInfo("Nicol Bolas, Dragon-God", 522, Rarity.MYTHIC, mage.cards.n.NicolBolasDragonGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ral, Storm Conduit", 523, Rarity.RARE, mage.cards.r.RalStormConduit.class));
        cards.add(new SetCardInfo("Sorin, Vengeful Bloodlord", 524, Rarity.RARE, mage.cards.s.SorinVengefulBloodlord.class));
        cards.add(new SetCardInfo("Tamiyo, Collector of Tales", 525, Rarity.RARE, mage.cards.t.TamiyoCollectorOfTales.class));
        cards.add(new SetCardInfo("Teferi, Time Raveler", 526, Rarity.RARE, mage.cards.t.TeferiTimeRaveler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angrath, Captain of Chaos", 527, Rarity.UNCOMMON, mage.cards.a.AngrathCaptainOfChaos.class));
        cards.add(new SetCardInfo("Ashiok, Dream Render", 528, Rarity.UNCOMMON, mage.cards.a.AshiokDreamRender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dovin, Hand of Control", 529, Rarity.UNCOMMON, mage.cards.d.DovinHandOfControl.class));
        cards.add(new SetCardInfo("Huatli, the Sun's Heart", 530, Rarity.UNCOMMON, mage.cards.h.HuatliTheSunsHeart.class));
        cards.add(new SetCardInfo("Kaya, Bane of the Dead", 531, Rarity.UNCOMMON, mage.cards.k.KayaBaneOfTheDead.class));
        cards.add(new SetCardInfo("Kiora, Behemoth Beckoner", 532, Rarity.UNCOMMON, mage.cards.k.KioraBehemothBeckoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, Storm of Stone", 533, Rarity.UNCOMMON, mage.cards.n.NahiriStormOfStone.class));
        cards.add(new SetCardInfo("Saheeli, Sublime Artificer", 534, Rarity.UNCOMMON, mage.cards.s.SaheeliSublimeArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samut, Tyrant Smasher", 535, Rarity.UNCOMMON, mage.cards.s.SamutTyrantSmasher.class));
        cards.add(new SetCardInfo("Vraska, Swarm's Eminence", 536, Rarity.UNCOMMON, mage.cards.v.VraskaSwarmsEminence.class));
        cards.add(new SetCardInfo("Tibalt, the Fiend-Blooded", 537, Rarity.MYTHIC, mage.cards.t.TibaltTheFiendBlooded.class));
        cards.add(new SetCardInfo("Evolving Wilds", 538, Rarity.RARE, mage.cards.e.EvolvingWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 539, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Plains", 540, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 541, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 542, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 543, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 544, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 545, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 546, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 547, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 548, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 549, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 550, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 551, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 552, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 553, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 554, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 555, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 556, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 557, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 558, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 559, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 560, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 561, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 562, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 563, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 564, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 565, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 566, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 567, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 568, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 569, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 570, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 571, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 572, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 573, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 574, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 575, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 576, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 577, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 578, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 579, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gisa's Favorite Shovel", 581, Rarity.MYTHIC, mage.cards.g.GisasFavoriteShovel.class));
        cards.add(new SetCardInfo("Brainstorm", 582, Rarity.RARE, mage.cards.b.Brainstorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fblthp, the Lost", 583, Rarity.RARE, mage.cards.f.FblthpTheLost.class));
        cards.add(new SetCardInfo("Wrexial, the Risen Deep", 584, Rarity.MYTHIC, mage.cards.w.WrexialTheRisenDeep.class));
        cards.add(new SetCardInfo("Terramorphic Expanse", 585, Rarity.RARE, mage.cards.t.TerramorphicExpanse.class));
        cards.add(new SetCardInfo("Spellskite", 587, Rarity.RARE, mage.cards.s.Spellskite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sphere of Safety", 588, Rarity.RARE, mage.cards.s.SphereOfSafety.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", 589, Rarity.RARE, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lurking Crocodile", 590, Rarity.RARE, mage.cards.l.LurkingCrocodile.class));
        cards.add(new SetCardInfo("Crash Through", 591, Rarity.RARE, mage.cards.c.CrashThrough.class));
        cards.add(new SetCardInfo("Persistent Petitioners", 593, Rarity.RARE, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Persistent Petitioners", 595, Rarity.RARE, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Persistent Petitioners", 596, Rarity.RARE, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Persistent Petitioners", 597, Rarity.RARE, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Persistent Petitioners", 598, Rarity.RARE, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Persistent Petitioners", 599, Rarity.RARE, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Persistent Petitioners", 600, Rarity.RARE, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Persistent Petitioners", 601, Rarity.RARE, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eldrazi Monument", 603, Rarity.MYTHIC, mage.cards.e.EldraziMonument.class));
        cards.add(new SetCardInfo("Ornithopter", 604, Rarity.RARE, mage.cards.o.Ornithopter.class));
        cards.add(new SetCardInfo("Panharmonicon", 605, Rarity.RARE, mage.cards.p.Panharmonicon.class));
        cards.add(new SetCardInfo("Swiftfoot Boots", 606, Rarity.RARE, mage.cards.s.SwiftfootBoots.class));
        cards.add(new SetCardInfo("Rogue's Passage", 607, Rarity.RARE, mage.cards.r.RoguesPassage.class));
        cards.add(new SetCardInfo("Darksteel Citadel", 608, Rarity.RARE, mage.cards.d.DarksteelCitadel.class));
        cards.add(new SetCardInfo("Havengul Laboratory", 609, Rarity.RARE, mage.cards.h.HavengulLaboratory.class));
        cards.add(new SetCardInfo("Havengul Mystery", 609, Rarity.RARE, mage.cards.h.HavengulMystery.class));
        cards.add(new SetCardInfo("Bonescythe Sliver", 610, Rarity.RARE, mage.cards.b.BonescytheSliver.class));
        cards.add(new SetCardInfo("Constricting Sliver", 611, Rarity.RARE, mage.cards.c.ConstrictingSliver.class));
        cards.add(new SetCardInfo("Essence Sliver", 612, Rarity.RARE, mage.cards.e.EssenceSliver.class));
        cards.add(new SetCardInfo("Pulmonic Sliver", 613, Rarity.RARE, mage.cards.p.PulmonicSliver.class));
        cards.add(new SetCardInfo("Sidewinder Sliver", 615, Rarity.RARE, mage.cards.s.SidewinderSliver.class));
        cards.add(new SetCardInfo("Ward Sliver", 617, Rarity.RARE, mage.cards.w.WardSliver.class));
        cards.add(new SetCardInfo("Diffusion Sliver", 618, Rarity.RARE, mage.cards.d.DiffusionSliver.class));
        cards.add(new SetCardInfo("Galerider Sliver", 619, Rarity.RARE, mage.cards.g.GaleriderSliver.class));
        cards.add(new SetCardInfo("Mesmeric Sliver", 620, Rarity.RARE, mage.cards.m.MesmericSliver.class));
        cards.add(new SetCardInfo("Psionic Sliver", 621, Rarity.RARE, mage.cards.p.PsionicSliver.class));
        cards.add(new SetCardInfo("Screeching Sliver", 622, Rarity.RARE, mage.cards.s.ScreechingSliver.class));
        cards.add(new SetCardInfo("Scuttling Sliver", 623, Rarity.RARE, mage.cards.s.ScuttlingSliver.class));
        cards.add(new SetCardInfo("Shadow Sliver", 624, Rarity.RARE, mage.cards.s.ShadowSliver.class));
        cards.add(new SetCardInfo("Synapse Sliver", 626, Rarity.RARE, mage.cards.s.SynapseSliver.class));
        cards.add(new SetCardInfo("Telekinetic Sliver", 627, Rarity.RARE, mage.cards.t.TelekineticSliver.class));
        cards.add(new SetCardInfo("Winged Sliver", 628, Rarity.RARE, mage.cards.w.WingedSliver.class));
        cards.add(new SetCardInfo("Basal Sliver", 629, Rarity.RARE, mage.cards.b.BasalSliver.class));
        cards.add(new SetCardInfo("Dregscape Sliver", 631, Rarity.RARE, mage.cards.d.DregscapeSliver.class));
        cards.add(new SetCardInfo("Leeching Sliver", 632, Rarity.RARE, mage.cards.l.LeechingSliver.class));
        cards.add(new SetCardInfo("Plague Sliver", "633Ph", Rarity.RARE, mage.cards.p.PlagueSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plague Sliver", 633, Rarity.RARE, mage.cards.p.PlagueSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Syphon Sliver", 634, Rarity.RARE, mage.cards.s.SyphonSliver.class));
        cards.add(new SetCardInfo("Toxin Sliver", "635Ph", Rarity.RARE, mage.cards.t.ToxinSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Toxin Sliver", 635, Rarity.RARE, mage.cards.t.ToxinSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Belligerent Sliver", 636, Rarity.RARE, mage.cards.b.BelligerentSliver.class));
        cards.add(new SetCardInfo("Blur Sliver", 637, Rarity.RARE, mage.cards.b.BlurSliver.class));
        cards.add(new SetCardInfo("Fury Sliver", 638, Rarity.RARE, mage.cards.f.FurySliver.class));
        cards.add(new SetCardInfo("Homing Sliver", 640, Rarity.RARE, mage.cards.h.HomingSliver.class));
        cards.add(new SetCardInfo("Magma Sliver", 641, Rarity.RARE, mage.cards.m.MagmaSliver.class));
        cards.add(new SetCardInfo("Sedge Sliver", 642, Rarity.RARE, mage.cards.s.SedgeSliver.class));
        cards.add(new SetCardInfo("Spiteful Sliver", 643, Rarity.RARE, mage.cards.s.SpitefulSliver.class));
        cards.add(new SetCardInfo("Striking Sliver", 644, Rarity.RARE, mage.cards.s.StrikingSliver.class));
        cards.add(new SetCardInfo("Thorncaster Sliver", 645, Rarity.RARE, mage.cards.t.ThorncasterSliver.class));
        cards.add(new SetCardInfo("Two-Headed Sliver", 646, Rarity.RARE, mage.cards.t.TwoHeadedSliver.class));
        cards.add(new SetCardInfo("Brood Sliver", 647, Rarity.RARE, mage.cards.b.BroodSliver.class));
        cards.add(new SetCardInfo("Gemhide Sliver", 648, Rarity.RARE, mage.cards.g.GemhideSliver.class));
        cards.add(new SetCardInfo("Horned Sliver", 649, Rarity.RARE, mage.cards.h.HornedSliver.class));
        cards.add(new SetCardInfo("Manaweft Sliver", 650, Rarity.RARE, mage.cards.m.ManaweftSliver.class));
        cards.add(new SetCardInfo("Megantic Sliver", 651, Rarity.RARE, mage.cards.m.MeganticSliver.class));
        cards.add(new SetCardInfo("Might Sliver", 652, Rarity.RARE, mage.cards.m.MightSliver.class));
        cards.add(new SetCardInfo("Muscle Sliver", 653, Rarity.RARE, mage.cards.m.MuscleSliver.class));
        cards.add(new SetCardInfo("Predatory Sliver", 654, Rarity.RARE, mage.cards.p.PredatorySliver.class));
        cards.add(new SetCardInfo("Quick Sliver", 655, Rarity.RARE, mage.cards.q.QuickSliver.class));
        cards.add(new SetCardInfo("Root Sliver", 656, Rarity.RARE, mage.cards.r.RootSliver.class));
        cards.add(new SetCardInfo("Tempered Sliver", 657, Rarity.RARE, mage.cards.t.TemperedSliver.class));
        cards.add(new SetCardInfo("Virulent Sliver", "659Ph", Rarity.RARE, mage.cards.v.VirulentSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Virulent Sliver", 659, Rarity.RARE, mage.cards.v.VirulentSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cloudshredder Sliver", 660, Rarity.RARE, mage.cards.c.CloudshredderSliver.class));
        cards.add(new SetCardInfo("Crystalline Sliver", 661, Rarity.RARE, mage.cards.c.CrystallineSliver.class));
        cards.add(new SetCardInfo("Frenetic Sliver", 662, Rarity.RARE, mage.cards.f.FreneticSliver.class));
        cards.add(new SetCardInfo("Harmonic Sliver", 663, Rarity.RARE, mage.cards.h.HarmonicSliver.class));
        cards.add(new SetCardInfo("Hibernation Sliver", 664, Rarity.RARE, mage.cards.h.HibernationSliver.class));
        cards.add(new SetCardInfo("Lavabelly Sliver", 665, Rarity.RARE, mage.cards.l.LavabellySliver.class));
        cards.add(new SetCardInfo("Necrotic Sliver", 666, Rarity.RARE, mage.cards.n.NecroticSliver.class));
        cards.add(new SetCardInfo("Opaline Sliver", 667, Rarity.RARE, mage.cards.o.OpalineSliver.class));
        cards.add(new SetCardInfo("Sliver Hive", 668, Rarity.RARE, mage.cards.s.SliverHive.class));
        cards.add(new SetCardInfo("Battlefield Forge", 669, Rarity.RARE, mage.cards.b.BattlefieldForge.class));
        cards.add(new SetCardInfo("Plains", 670, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Questing Phelddagrif", 671, Rarity.RARE, mage.cards.q.QuestingPhelddagrif.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Questing Phelddagrif", 672, Rarity.RARE, mage.cards.q.QuestingPhelddagrif.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 673, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 674, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 675, Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pyrite Spellbomb", 676, Rarity.RARE, mage.cards.p.PyriteSpellbomb.class));
        cards.add(new SetCardInfo("Command Tower", 677, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Torbran, Thane of Red Fell", 678, Rarity.RARE, mage.cards.t.TorbranThaneOfRedFell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghost Quarter", 679, Rarity.RARE, mage.cards.g.GhostQuarter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", 680, Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", "681Ph", Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", 681, Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", 682, Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", 683, Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", 684, Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", 685, Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", 686, Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", 687, Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shadowborn Apostle", 688, Rarity.RARE, mage.cards.s.ShadowbornApostle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 690, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Hedron Archive", 691, Rarity.RARE, mage.cards.h.HedronArchive.class));
        cards.add(new SetCardInfo("Pilgrim's Eye", 692, Rarity.RARE, mage.cards.p.PilgrimsEye.class));
        cards.add(new SetCardInfo("Sorcerous Spyglass", 693, Rarity.RARE, mage.cards.s.SorcerousSpyglass.class));
        cards.add(new SetCardInfo("Tangle Wire", 694, Rarity.RARE, mage.cards.t.TangleWire.class));
        cards.add(new SetCardInfo("Reliquary Tower", 695, Rarity.RARE, mage.cards.r.ReliquaryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spore Frog", 696, Rarity.RARE, mage.cards.s.SporeFrog.class));
        cards.add(new SetCardInfo("Command Tower", 697, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dakkon Blackblade", 698, Rarity.RARE, mage.cards.d.DakkonBlackblade.class));
        cards.add(new SetCardInfo("Olivia, Mobilized for War", 699, Rarity.MYTHIC, mage.cards.o.OliviaMobilizedForWar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Huntmaster of the Fells", 700, Rarity.MYTHIC, mage.cards.h.HuntmasterOfTheFells.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ravager of the Fells", 700, Rarity.MYTHIC, mage.cards.r.RavagerOfTheFells.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elspeth, Knight-Errant", 701, Rarity.MYTHIC, mage.cards.e.ElspethKnightErrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wastes", 704, Rarity.RARE, mage.cards.w.Wastes.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Wastes", 705, Rarity.RARE, mage.cards.w.Wastes.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Wastes", 706, Rarity.RARE, mage.cards.w.Wastes.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Knight Exemplar", 707, Rarity.RARE, mage.cards.k.KnightExemplar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fellwar Stone", 708, Rarity.RARE, mage.cards.f.FellwarStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragon's Hoard", 709, Rarity.RARE, mage.cards.d.DragonsHoard.class));
        cards.add(new SetCardInfo("Command Tower", 710, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tireless Tracker", 711, Rarity.RARE, mage.cards.t.TirelessTracker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 713, Rarity.RARE, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Merfolk of the Pearl Trident", 714, Rarity.RARE, mage.cards.m.MerfolkOfThePearlTrident.class));
        cards.add(new SetCardInfo("Lord of the Pit", 715, Rarity.RARE, mage.cards.l.LordOfThePit.class));
        cards.add(new SetCardInfo("Shivan Dragon", 716, Rarity.RARE, mage.cards.s.ShivanDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giant Growth", 717, Rarity.RARE, mage.cards.g.GiantGrowth.class));
        cards.add(new SetCardInfo("Maro", 718, Rarity.RARE, mage.cards.m.Maro.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maro", 719, Rarity.RARE, mage.cards.m.Maro.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thought-Knot Seer", 720, Rarity.RARE, mage.cards.t.ThoughtKnotSeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Diabolic Tutor", 721, Rarity.RARE, mage.cards.d.DiabolicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Delver of Secrets", 722, Rarity.RARE, mage.cards.d.DelverOfSecrets.class));
        cards.add(new SetCardInfo("Insectile Aberration", 722, Rarity.RARE, mage.cards.i.InsectileAberration.class));
        cards.add(new SetCardInfo("Brainstorm", 723, Rarity.RARE, mage.cards.b.Brainstorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Strike", 724, Rarity.RARE, mage.cards.l.LightningStrike.class));
        cards.add(new SetCardInfo("Fleshbag Marauder", 725, Rarity.RARE, mage.cards.f.FleshbagMarauder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zur the Enchanter", 726, Rarity.RARE, mage.cards.z.ZurTheEnchanter.class));
        cards.add(new SetCardInfo("Fabled Passage", 727, Rarity.RARE, mage.cards.f.FabledPassage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Themberchaud", 728, Rarity.RARE, mage.cards.t.Themberchaud.class));
        cards.add(new SetCardInfo("Braid of Fire", 729, Rarity.RARE, mage.cards.b.BraidOfFire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cleansing Nova", 730, Rarity.RARE, mage.cards.c.CleansingNova.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sigarda's Aid", 731, Rarity.RARE, mage.cards.s.SigardasAid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selfless Savior", 732, Rarity.RARE, mage.cards.s.SelflessSavior.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seraph Sanctuary", 733, Rarity.RARE, mage.cards.s.SeraphSanctuary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grima Wormtongue", 734, Rarity.RARE, mage.cards.g.GrimaWormtongue.class));
        cards.add(new SetCardInfo("Gaea's Blessing", 735, Rarity.RARE, mage.cards.g.GaeasBlessing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Colossus Hammer", 736, Rarity.RARE, mage.cards.c.ColossusHammer.class));
        cards.add(new SetCardInfo("Mountain Goat", 737, Rarity.RARE, mage.cards.m.MountainGoat.class));
        cards.add(new SetCardInfo("Woodland Cemetery", 738, Rarity.RARE, mage.cards.w.WoodlandCemetery.class));
        cards.add(new SetCardInfo("Isolated Chapel", 739, Rarity.RARE, mage.cards.i.IsolatedChapel.class));
        cards.add(new SetCardInfo("Colossal Dreadmaw", 740, Rarity.RARE, mage.cards.c.ColossalDreadmaw.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Colossal Dreadmaw", "740*", Rarity.RARE, mage.cards.c.ColossalDreadmaw.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chaos Warp", 741, Rarity.RARE, mage.cards.c.ChaosWarp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chaos Warp", "741*", Rarity.RARE, mage.cards.c.ChaosWarp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 744, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ajani Goldmane", 745, Rarity.MYTHIC, mage.cards.a.AjaniGoldmane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ajani Goldmane", "745b", Rarity.MYTHIC, mage.cards.a.AjaniGoldmane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace Beleren", 746, Rarity.MYTHIC, mage.cards.j.JaceBeleren.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace Beleren", "746b", Rarity.MYTHIC, mage.cards.j.JaceBeleren.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana Vess", 747, Rarity.MYTHIC, mage.cards.l.LilianaVess.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana Vess", "747b", Rarity.MYTHIC, mage.cards.l.LilianaVess.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra Nalaar", 748, Rarity.MYTHIC, mage.cards.c.ChandraNalaar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra Nalaar", "748b", Rarity.MYTHIC, mage.cards.c.ChandraNalaar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Garruk Wildspeaker", 749, Rarity.MYTHIC, mage.cards.g.GarrukWildspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Garruk Wildspeaker", "749b", Rarity.MYTHIC, mage.cards.g.GarrukWildspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terror", 750, Rarity.RARE, mage.cards.t.Terror.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terror", "750b", Rarity.RARE, mage.cards.t.Terror.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Relentless Rats", 752, Rarity.RARE, mage.cards.r.RelentlessRats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Relentless Rats", 754, Rarity.RARE, mage.cards.r.RelentlessRats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Relentless Rats", 755, Rarity.RARE, mage.cards.r.RelentlessRats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Relentless Rats", 756, Rarity.RARE, mage.cards.r.RelentlessRats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Relentless Rats", 757, Rarity.RARE, mage.cards.r.RelentlessRats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 758, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skemfar Shadowsage", 759, Rarity.RARE, mage.cards.s.SkemfarShadowsage.class));
        cards.add(new SetCardInfo("Elvish Vanguard", 762, Rarity.RARE, mage.cards.e.ElvishVanguard.class));
        cards.add(new SetCardInfo("Elvish Visionary", 763, Rarity.RARE, mage.cards.e.ElvishVisionary.class));
        cards.add(new SetCardInfo("Evolution Sage", 765, Rarity.RARE, mage.cards.e.EvolutionSage.class));
        cards.add(new SetCardInfo("Farhaven Elf", 766, Rarity.RARE, mage.cards.f.FarhavenElf.class));
        cards.add(new SetCardInfo("Fierce Empath", 767, Rarity.RARE, mage.cards.f.FierceEmpath.class));
        cards.add(new SetCardInfo("Generous Patron", 768, Rarity.RARE, mage.cards.g.GenerousPatron.class));
        cards.add(new SetCardInfo("Ivy Lane Denizen", 769, Rarity.RARE, mage.cards.i.IvyLaneDenizen.class));
        cards.add(new SetCardInfo("Jaspera Sentinel", 770, Rarity.RARE, mage.cards.j.JasperaSentinel.class));
        cards.add(new SetCardInfo("Llanowar Visionary", 771, Rarity.RARE, mage.cards.l.LlanowarVisionary.class));
        cards.add(new SetCardInfo("Lys Alana Huntmaster", 772, Rarity.RARE, mage.cards.l.LysAlanaHuntmaster.class));
        cards.add(new SetCardInfo("Nettle Sentinel", 773, Rarity.RARE, mage.cards.n.NettleSentinel.class));
        cards.add(new SetCardInfo("Nullmage Shepherd", 774, Rarity.RARE, mage.cards.n.NullmageShepherd.class));
        cards.add(new SetCardInfo("Paradise Druid", 775, Rarity.RARE, mage.cards.p.ParadiseDruid.class));
        cards.add(new SetCardInfo("Pollenbright Druid", 776, Rarity.RARE, mage.cards.p.PollenbrightDruid.class));
        cards.add(new SetCardInfo("Reclamation Sage", 777, Rarity.RARE, mage.cards.r.ReclamationSage.class));
        cards.add(new SetCardInfo("Sylvan Ranger", 779, Rarity.RARE, mage.cards.s.SylvanRanger.class));
        cards.add(new SetCardInfo("Timberwatch Elf", 780, Rarity.RARE, mage.cards.t.TimberwatchElf.class));
        cards.add(new SetCardInfo("Viridian Shaman", 782, Rarity.RARE, mage.cards.v.ViridianShaman.class));
        cards.add(new SetCardInfo("Wellwisher", 783, Rarity.RARE, mage.cards.w.Wellwisher.class));
        cards.add(new SetCardInfo("Wirewood Symbiote", 785, Rarity.RARE, mage.cards.w.WirewoodSymbiote.class));
        cards.add(new SetCardInfo("Frilled Mystic", 786, Rarity.RARE, mage.cards.f.FrilledMystic.class));
        cards.add(new SetCardInfo("Poison-Tip Archer", 788, Rarity.RARE, mage.cards.p.PoisonTipArcher.class));
        cards.add(new SetCardInfo("Shaman of the Pack", 789, Rarity.RARE, mage.cards.s.ShamanOfThePack.class));
        cards.add(new SetCardInfo("Codex Shredder", "790*", Rarity.RARE, mage.cards.c.CodexShredder.class));
        cards.add(new SetCardInfo("Solemn Simulacrum", 791, Rarity.RARE, mage.cards.s.SolemnSimulacrum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Solemn Simulacrum", "791*", Rarity.RARE, mage.cards.s.SolemnSimulacrum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 792, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nine Lives", 793, Rarity.RARE, mage.cards.n.NineLives.class));
        cards.add(new SetCardInfo("Yoshimaru, Ever Faithful", 794, Rarity.MYTHIC, mage.cards.y.YoshimaruEverFaithful.class));
        cards.add(new SetCardInfo("Wastes", "795*", Rarity.RARE, mage.cards.w.Wastes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Vault", "796*", Rarity.MYTHIC, mage.cards.m.ManaVault.class));
        cards.add(new SetCardInfo("Seraph Sanctuary", 797, Rarity.RARE, mage.cards.s.SeraphSanctuary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coveted Jewel", 799, Rarity.RARE, mage.cards.c.CovetedJewel.class));
        cards.add(new SetCardInfo("Spiteful Prankster", 801, Rarity.RARE, mage.cards.s.SpitefulPrankster.class));
        cards.add(new SetCardInfo("Haystack", 802, Rarity.RARE, mage.cards.h.Haystack.class));
        cards.add(new SetCardInfo("Sonic Screwdriver", 803, Rarity.RARE, mage.cards.s.SonicScrewdriver.class));
        cards.add(new SetCardInfo("Elvish Mystic", 805, Rarity.RARE, mage.cards.e.ElvishMystic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 806, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra, Flamecaller", 807, Rarity.MYTHIC, mage.cards.c.ChandraFlamecaller.class));
        cards.add(new SetCardInfo("Snapcaster Mage", 808, Rarity.MYTHIC, mage.cards.s.SnapcasterMage.class));
        cards.add(new SetCardInfo("Immerwolf", 809, Rarity.RARE, mage.cards.i.Immerwolf.class));
        cards.add(new SetCardInfo("Thrun, the Last Troll", 810, Rarity.MYTHIC, mage.cards.t.ThrunTheLastTroll.class));
        cards.add(new SetCardInfo("Elesh Norn, Grand Cenobite", 811, Rarity.MYTHIC, mage.cards.e.EleshNornGrandCenobite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", 820, Rarity.RARE, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", "820*", Rarity.RARE, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Echo of Eons", 821, Rarity.RARE, mage.cards.e.EchoOfEons.class));
        cards.add(new SetCardInfo("Hive Mind", 822, Rarity.RARE, mage.cards.h.HiveMind.class));
        cards.add(new SetCardInfo("Chaos Warp", 823, Rarity.RARE, mage.cards.c.ChaosWarp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evolving Wilds", 824, Rarity.RARE, mage.cards.e.EvolvingWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Bombardment", 825, Rarity.RARE, mage.cards.g.GoblinBombardment.class));
        cards.add(new SetCardInfo("Kezzerdrix", 826, Rarity.RARE, mage.cards.k.Kezzerdrix.class));
        cards.add(new SetCardInfo("Norin the Wary", 827, Rarity.RARE, mage.cards.n.NorinTheWary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Norin the Wary", "827b", Rarity.RARE, mage.cards.n.NorinTheWary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keen Duelist", 828, Rarity.RARE, mage.cards.k.KeenDuelist.class));
        cards.add(new SetCardInfo("Soul-Guide Lantern", 871, Rarity.RARE, mage.cards.s.SoulGuideLantern.class));
        cards.add(new SetCardInfo("Yargle and Multani", 872, Rarity.RARE, mage.cards.y.YargleAndMultani.class));
        cards.add(new SetCardInfo("Dark Deal", 873, Rarity.RARE, mage.cards.d.DarkDeal.class));
        cards.add(new SetCardInfo("Archivist of Oghma", 874, Rarity.RARE, mage.cards.a.ArchivistOfOghma.class));
        cards.add(new SetCardInfo("Battle Angels of Tyr", 875, Rarity.RARE, mage.cards.b.BattleAngelsOfTyr.class));
        cards.add(new SetCardInfo("Xorn", 876, Rarity.RARE, mage.cards.x.Xorn.class));
        cards.add(new SetCardInfo("Druid of Purification", 877, Rarity.RARE, mage.cards.d.DruidOfPurification.class));
        cards.add(new SetCardInfo("Prosperous Innkeeper", 878, Rarity.RARE, mage.cards.p.ProsperousInnkeeper.class));
        cards.add(new SetCardInfo("Minsc & Boo, Timeless Heroes", 879, Rarity.MYTHIC, mage.cards.m.MinscBooTimelessHeroes.class));
        cards.add(new SetCardInfo("Stuffy Doll", 880, Rarity.RARE, mage.cards.s.StuffyDoll.class));
        cards.add(new SetCardInfo("Solve the Equation", 886, Rarity.RARE, mage.cards.s.SolveTheEquation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Scarab God", 900, Rarity.MYTHIC, mage.cards.t.TheScarabGod.class));
        cards.add(new SetCardInfo("Lightning Bolt", 901, Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Locust God", 903, Rarity.MYTHIC, mage.cards.t.TheLocustGod.class));
        cards.add(new SetCardInfo("The Scorpion God", 904, Rarity.MYTHIC, mage.cards.t.TheScorpionGod.class));
        cards.add(new SetCardInfo("Ignoble Hierarch", 906, Rarity.RARE, mage.cards.i.IgnobleHierarch.class));
        cards.add(new SetCardInfo("Seedborn Muse", 907, Rarity.RARE, mage.cards.s.SeedbornMuse.class));
        cards.add(new SetCardInfo("Arcane Signet", 908, Rarity.RARE, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elspeth, Knight-Errant", 1001, Rarity.MYTHIC, mage.cards.e.ElspethKnightErrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Patron Wizard", 1002, Rarity.RARE, mage.cards.p.PatronWizard.class));
        cards.add(new SetCardInfo("Berserk", 1003, Rarity.MYTHIC, mage.cards.b.Berserk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Verduran Enchantress", 1004, Rarity.RARE, mage.cards.v.VerduranEnchantress.class));
        cards.add(new SetCardInfo("Triumphant Reckoning", 1005, Rarity.MYTHIC, mage.cards.t.TriumphantReckoning.class));
        cards.add(new SetCardInfo("Savor the Moment", 1006, Rarity.RARE, mage.cards.s.SavorTheMoment.class));
        cards.add(new SetCardInfo("Alesha, Who Smiles at Death", 1007, Rarity.RARE, mage.cards.a.AleshaWhoSmilesAtDeath.class));
        cards.add(new SetCardInfo("Bearscape", 1008, Rarity.RARE, mage.cards.b.Bearscape.class));
        cards.add(new SetCardInfo("Collective Voyage", 1009, Rarity.RARE, mage.cards.c.CollectiveVoyage.class));
        cards.add(new SetCardInfo("Heartbeat of Spring", 1010, Rarity.RARE, mage.cards.h.HeartbeatOfSpring.class));
        cards.add(new SetCardInfo("Sol Ring", 1011, Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icingdeath, Frost Tyrant", "1012b", Rarity.MYTHIC, mage.cards.i.IcingdeathFrostTyrant.class));
        cards.add(new SetCardInfo("Mana Confluence", "1012a", Rarity.RARE, mage.cards.m.ManaConfluence.class));
        cards.add(new SetCardInfo("Iymrith, Desert Doom", 1013, Rarity.MYTHIC, mage.cards.i.IymrithDesertDoom.class));
        cards.add(new SetCardInfo("Ebondeath, Dracolich", 1014, Rarity.MYTHIC, mage.cards.e.EbondeathDracolich.class));
        cards.add(new SetCardInfo("Inferno of the Star Mounts", 1015, Rarity.MYTHIC, mage.cards.i.InfernoOfTheStarMounts.class));
        cards.add(new SetCardInfo("Old Gnawbone", 1016, Rarity.MYTHIC, mage.cards.o.OldGnawbone.class));
        cards.add(new SetCardInfo("Tiamat", 1017, Rarity.MYTHIC, mage.cards.t.Tiamat.class));
        cards.add(new SetCardInfo("Idyllic Tutor", 1020, Rarity.RARE, mage.cards.i.IdyllicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 1021, Rarity.RARE, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Solve the Equation", 1022, Rarity.RARE, mage.cards.s.SolveTheEquation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Praetor's Grasp", 1023, Rarity.RARE, mage.cards.p.PraetorsGrasp.class));
        cards.add(new SetCardInfo("Veil of Summer", 1024, Rarity.RARE, mage.cards.v.VeilOfSummer.class));
        cards.add(new SetCardInfo("Merciless Executioner", 1025, Rarity.RARE, mage.cards.m.MercilessExecutioner.class));
        cards.add(new SetCardInfo("Aggravated Assault", 1026, Rarity.RARE, mage.cards.a.AggravatedAssault.class));
        cards.add(new SetCardInfo("Krenko, Tin Street Kingpin", 1027, Rarity.RARE, mage.cards.k.KrenkoTinStreetKingpin.class));
        cards.add(new SetCardInfo("Zurgo Helmsmasher", 1028, Rarity.MYTHIC, mage.cards.z.ZurgoHelmsmasher.class));
        cards.add(new SetCardInfo("Skysovereign, Consul Flagship", 1029, Rarity.MYTHIC, mage.cards.s.SkysovereignConsulFlagship.class));
        cards.add(new SetCardInfo("Blind Obedience", 1030, Rarity.RARE, mage.cards.b.BlindObedience.class));
        cards.add(new SetCardInfo("Danitha Capashen, Paragon", 1031, Rarity.RARE, mage.cards.d.DanithaCapashenParagon.class));
        cards.add(new SetCardInfo("Najeela, the Blade-Blossom", 1032, Rarity.MYTHIC, mage.cards.n.NajeelaTheBladeBlossom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scourge of the Throne", 1033, Rarity.MYTHIC, mage.cards.s.ScourgeOfTheThrone.class));
        cards.add(new SetCardInfo("Loxodon Warhammer", 1034, Rarity.RARE, mage.cards.l.LoxodonWarhammer.class));
        cards.add(new SetCardInfo("Approach of the Second Sun", 1035, Rarity.RARE, mage.cards.a.ApproachOfTheSecondSun.class));
        cards.add(new SetCardInfo("Rewind", 1036, Rarity.RARE, mage.cards.r.Rewind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bone Splinters", 1037, Rarity.RARE, mage.cards.b.BoneSplinters.class));
        cards.add(new SetCardInfo("Fling", 1038, Rarity.RARE, mage.cards.f.Fling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Defense of the Heart", 1039, Rarity.RARE, mage.cards.d.DefenseOfTheHeart.class));
        cards.add(new SetCardInfo("Fellwar Stone", 1040, Rarity.RARE, mage.cards.f.FellwarStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset, Parter of Veils", 1041, Rarity.RARE, mage.cards.n.NarsetParterOfVeils.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nissa, Who Shakes the World", 1042, Rarity.RARE, mage.cards.n.NissaWhoShakesTheWorld.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tezzeret, Agent of Bolas", 1043, Rarity.MYTHIC, mage.cards.t.TezzeretAgentOfBolas.class));
        cards.add(new SetCardInfo("Knight Exemplar", 1044, Rarity.RARE, mage.cards.k.KnightExemplar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Knight of the White Orchid", 1045, Rarity.RARE, mage.cards.k.KnightOfTheWhiteOrchid.class));
        cards.add(new SetCardInfo("Lord of the Undead", 1046, Rarity.RARE, mage.cards.l.LordOfTheUndead.class));
        cards.add(new SetCardInfo("Compost", 1047, Rarity.RARE, mage.cards.c.Compost.class));
        cards.add(new SetCardInfo("Matter Reshaper", 1048, Rarity.RARE, mage.cards.m.MatterReshaper.class));
        cards.add(new SetCardInfo("Toothy, Imaginary Friend", 1049, Rarity.RARE, mage.cards.t.ToothyImaginaryFriend.class));
        cards.add(new SetCardInfo("Pir, Imaginative Rascal", 1050, Rarity.RARE, mage.cards.p.PirImaginativeRascal.class));
        cards.add(new SetCardInfo("The Gitrog Monster", 1051, Rarity.MYTHIC, mage.cards.t.TheGitrogMonster.class));
        cards.add(new SetCardInfo("Talisman of Progress", 1052, Rarity.RARE, mage.cards.t.TalismanOfProgress.class));
        cards.add(new SetCardInfo("Talisman of Dominance", 1053, Rarity.RARE, mage.cards.t.TalismanOfDominance.class));
        cards.add(new SetCardInfo("Talisman of Indulgence", 1054, Rarity.RARE, mage.cards.t.TalismanOfIndulgence.class));
        cards.add(new SetCardInfo("Talisman of Impulse", 1055, Rarity.RARE, mage.cards.t.TalismanOfImpulse.class));
        cards.add(new SetCardInfo("Talisman of Unity", 1056, Rarity.RARE, mage.cards.t.TalismanOfUnity.class));
        cards.add(new SetCardInfo("Talisman of Hierarchy", 1057, Rarity.RARE, mage.cards.t.TalismanOfHierarchy.class));
        cards.add(new SetCardInfo("Talisman of Creativity", 1058, Rarity.RARE, mage.cards.t.TalismanOfCreativity.class));
        cards.add(new SetCardInfo("Talisman of Resilience", 1059, Rarity.RARE, mage.cards.t.TalismanOfResilience.class));
        cards.add(new SetCardInfo("Talisman of Conviction", 1060, Rarity.RARE, mage.cards.t.TalismanOfConviction.class));
        cards.add(new SetCardInfo("Talisman of Curiosity", 1061, Rarity.RARE, mage.cards.t.TalismanOfCuriosity.class));
        cards.add(new SetCardInfo("Jaya Ballard", 1062, Rarity.MYTHIC, mage.cards.j.JayaBallard.class));
        cards.add(new SetCardInfo("Jaya's Immolating Inferno", 1063, Rarity.RARE, mage.cards.j.JayasImmolatingInferno.class));
        cards.add(new SetCardInfo("Pyretic Ritual", 1064, Rarity.RARE, mage.cards.p.PyreticRitual.class));
        cards.add(new SetCardInfo("Repercussion", 1065, Rarity.RARE, mage.cards.r.Repercussion.class));
        cards.add(new SetCardInfo("Pyromancer's Goggles", 1066, Rarity.MYTHIC, mage.cards.p.PyromancersGoggles.class));
        cards.add(new SetCardInfo("Arcades Sabboth", 1067, Rarity.RARE, mage.cards.a.ArcadesSabboth.class));
        cards.add(new SetCardInfo("Chromium", 1068, Rarity.RARE, mage.cards.c.Chromium.class));
        cards.add(new SetCardInfo("Nicol Bolas", 1069, Rarity.RARE, mage.cards.n.NicolBolas.class));
        cards.add(new SetCardInfo("Vaevictis Asmadi", 1070, Rarity.RARE, mage.cards.v.VaevictisAsmadi.class));
        cards.add(new SetCardInfo("Palladia-Mors", 1071, Rarity.RARE, mage.cards.p.PalladiaMors.class));
        cards.add(new SetCardInfo("Mox Opal", 1072, Rarity.MYTHIC, mage.cards.m.MoxOpal.class));
        cards.add(new SetCardInfo("Mox Tantalite", 1073, Rarity.MYTHIC, mage.cards.m.MoxTantalite.class));
        cards.add(new SetCardInfo("Sol Ring", 1074, Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Void Winnower", 1075, Rarity.MYTHIC, mage.cards.v.VoidWinnower.class));
        cards.add(new SetCardInfo("Goblin Settler", 1076, Rarity.RARE, mage.cards.g.GoblinSettler.class));
        cards.add(new SetCardInfo("Collector Ouphe", 1077, Rarity.RARE, mage.cards.c.CollectorOuphe.class));
        cards.add(new SetCardInfo("Vengevine", 1078, Rarity.MYTHIC, mage.cards.v.Vengevine.class));
        cards.add(new SetCardInfo("Blightsteel Colossus", 1079, Rarity.MYTHIC, mage.cards.b.BlightsteelColossus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blightsteel Colossus", "1079b", Rarity.MYTHIC, mage.cards.b.BlightsteelColossus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doubling Cube", 1080, Rarity.RARE, mage.cards.d.DoublingCube.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doubling Cube", "1080b", Rarity.RARE, mage.cards.d.DoublingCube.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Darksteel Colossus", 1081, Rarity.MYTHIC, mage.cards.d.DarksteelColossus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Darksteel Colossus", "1081b", Rarity.MYTHIC, mage.cards.d.DarksteelColossus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("True Conviction", 1082, Rarity.RARE, mage.cards.t.TrueConviction.class));
        cards.add(new SetCardInfo("Dramatic Reversal", 1083, Rarity.RARE, mage.cards.d.DramaticReversal.class));
        cards.add(new SetCardInfo("Fabricate", 1084, Rarity.RARE, mage.cards.f.Fabricate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Collective Brutality", 1085, Rarity.RARE, mage.cards.c.CollectiveBrutality.class));
        cards.add(new SetCardInfo("By Force", 1086, Rarity.RARE, mage.cards.b.ByForce.class));
        cards.add(new SetCardInfo("Greater Good", 1087, Rarity.RARE, mage.cards.g.GreaterGood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 1088, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 1089, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 1090, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1091, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 1092, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Deepglow Skate", 1093, Rarity.RARE, mage.cards.d.DeepglowSkate.class));
        cards.add(new SetCardInfo("Tireless Tracker", 1094, Rarity.RARE, mage.cards.t.TirelessTracker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Contagion Engine", 1095, Rarity.RARE, mage.cards.c.ContagionEngine.class));
        cards.add(new SetCardInfo("Sword of Truth and Justice", 1096, Rarity.MYTHIC, mage.cards.s.SwordOfTruthAndJustice.class));
        cards.add(new SetCardInfo("Laboratory Maniac", 1097, Rarity.RARE, mage.cards.l.LaboratoryManiac.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stitcher's Supplier", 1098, Rarity.RARE, mage.cards.s.StitchersSupplier.class));
        cards.add(new SetCardInfo("Beast Whisperer", 1099, Rarity.RARE, mage.cards.b.BeastWhisperer.class));
        cards.add(new SetCardInfo("Vizier of the Menagerie", 1100, Rarity.MYTHIC, mage.cards.v.VizierOfTheMenagerie.class));
        cards.add(new SetCardInfo("Wood Elves", 1101, Rarity.RARE, mage.cards.w.WoodElves.class));
        cards.add(new SetCardInfo("Imprisoned in the Moon", 1102, Rarity.RARE, mage.cards.i.ImprisonedInTheMoon.class));
        cards.add(new SetCardInfo("Stasis", 1103, Rarity.RARE, mage.cards.s.Stasis.class));
        cards.add(new SetCardInfo("Prismatic Omen", 1104, Rarity.RARE, mage.cards.p.PrismaticOmen.class));
        cards.add(new SetCardInfo("Wheel of Sun and Moon", 1105, Rarity.RARE, mage.cards.w.WheelOfSunAndMoon.class));
        cards.add(new SetCardInfo("Azami, Lady of Scrolls", 1106, Rarity.RARE, mage.cards.a.AzamiLadyOfScrolls.class));
        cards.add(new SetCardInfo("Liliana of the Dark Realms", 1107, Rarity.MYTHIC, mage.cards.l.LilianaOfTheDarkRealms.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reflector Mage", 1108, Rarity.RARE, mage.cards.r.ReflectorMage.class));
        cards.add(new SetCardInfo("Adaptive Automaton", 1109, Rarity.RARE, mage.cards.a.AdaptiveAutomaton.class));
        cards.add(new SetCardInfo("Phyrexian Metamorph", 1110, Rarity.RARE, mage.cards.p.PhyrexianMetamorph.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tezzeret the Seeker", 1111, Rarity.MYTHIC, mage.cards.t.TezzeretTheSeeker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skullclamp", 1112, Rarity.RARE, mage.cards.s.Skullclamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Solemn Simulacrum", 1113, Rarity.RARE, mage.cards.s.SolemnSimulacrum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Carrion Feeder", 1114, Rarity.RARE, mage.cards.c.CarrionFeeder.class));
        cards.add(new SetCardInfo("Doomsday", 1115, Rarity.RARE, mage.cards.d.Doomsday.class));
        cards.add(new SetCardInfo("Plaguecrafter", 1116, Rarity.RARE, mage.cards.p.Plaguecrafter.class));
        cards.add(new SetCardInfo("Thoughtseize", 1117, Rarity.RARE, mage.cards.t.Thoughtseize.class));
        cards.add(new SetCardInfo("Ulamog, the Ceaseless Hunger", 1122, Rarity.MYTHIC, mage.cards.u.UlamogTheCeaselessHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulamog, the Ceaseless Hunger", "1122b", Rarity.MYTHIC, mage.cards.u.UlamogTheCeaselessHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Etali, Primal Storm", 1123, Rarity.RARE, mage.cards.e.EtaliPrimalStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Etali, Primal Storm", "1123b", Rarity.RARE, mage.cards.e.EtaliPrimalStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghalta, Primal Hunger", 1124, Rarity.RARE, mage.cards.g.GhaltaPrimalHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghalta, Primal Hunger", "1124b", Rarity.RARE, mage.cards.g.GhaltaPrimalHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serra Ascendant", 1125, Rarity.RARE, mage.cards.s.SerraAscendant.class));
        cards.add(new SetCardInfo("Rapid Hybridization", 1126, Rarity.RARE, mage.cards.r.RapidHybridization.class));
        cards.add(new SetCardInfo("Demonic Consultation", 1127, Rarity.RARE, mage.cards.d.DemonicConsultation.class));
        cards.add(new SetCardInfo("Winds of Change", 1128, Rarity.RARE, mage.cards.w.WindsOfChange.class));
        cards.add(new SetCardInfo("Llanowar Elves", 1129, Rarity.RARE, mage.cards.l.LlanowarElves.class));
        cards.add(new SetCardInfo("Plains", 1130, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 1131, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 1132, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1133, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 1134, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Abundant Growth", 1135, Rarity.RARE, mage.cards.a.AbundantGrowth.class));
        cards.add(new SetCardInfo("Mycoloth", 1136, Rarity.RARE, mage.cards.m.Mycoloth.class));
        cards.add(new SetCardInfo("Ghave, Guru of Spores", 1137, Rarity.MYTHIC, mage.cards.g.GhaveGuruOfSpores.class));
        cards.add(new SetCardInfo("Slimefoot, the Stowaway", 1138, Rarity.RARE, mage.cards.s.SlimefootTheStowaway.class));
        cards.add(new SetCardInfo("Elspeth, Sun's Champion", 1140, Rarity.MYTHIC, mage.cards.e.ElspethSunsChampion.class));
        cards.add(new SetCardInfo("Narset, Parter of Veils", 1141, Rarity.RARE, mage.cards.n.NarsetParterOfVeils.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Garruk Wildspeaker", 1142, Rarity.RARE, mage.cards.g.GarrukWildspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saheeli, Sublime Artificer", 1143, Rarity.RARE, mage.cards.s.SaheeliSublimeArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sarkhan Vol", 1144, Rarity.MYTHIC, mage.cards.s.SarkhanVol.class));
        cards.add(new SetCardInfo("Lathliss, Dragon Queen", 1145, Rarity.RARE, mage.cards.l.LathlissDragonQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lathliss, Dragon Queen", 1146, Rarity.RARE, mage.cards.l.LathlissDragonQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birds of Paradise", 1147, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birds of Paradise", 1148, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sliver Legion", 1149, Rarity.MYTHIC, mage.cards.s.SliverLegion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sliver Legion", 1150, Rarity.MYTHIC, mage.cards.s.SliverLegion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thought-Knot Seer", 1151, Rarity.RARE, mage.cards.t.ThoughtKnotSeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inquisition of Kozilek", 1152, Rarity.RARE, mage.cards.i.InquisitionOfKozilek.class));
        cards.add(new SetCardInfo("Reality Smasher", 1153, Rarity.RARE, mage.cards.r.RealitySmasher.class));
        cards.add(new SetCardInfo("Eldrazi Temple", 1154, Rarity.RARE, mage.cards.e.EldraziTemple.class));
        cards.add(new SetCardInfo("Esika, God of the Tree", 1155, Rarity.MYTHIC, mage.cards.e.EsikaGodOfTheTree.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archangel Avacyn", 1156, Rarity.MYTHIC, mage.cards.a.ArchangelAvacyn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Avacyn, the Purifier", 1156, Rarity.MYTHIC, mage.cards.a.AvacynThePurifier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodline Keeper", 1157, Rarity.RARE, mage.cards.b.BloodlineKeeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of Lineage", 1157, Rarity.RARE, mage.cards.l.LordOfLineage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nicol Bolas, the Ravager", 1158, Rarity.MYTHIC, mage.cards.n.NicolBolasTheRavager.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nicol Bolas, the Arisen", 1158, Rarity.MYTHIC, mage.cards.n.NicolBolasTheArisen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Westvale Abbey", 1159, Rarity.RARE, mage.cards.w.WestvaleAbbey.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ormendahl, Profane Prince", 1159, Rarity.RARE, mage.cards.o.OrmendahlProfanePrince.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emrakul, the Promised End", 1160, Rarity.MYTHIC, mage.cards.e.EmrakulThePromisedEnd.class));
        cards.add(new SetCardInfo("Serra Angel", 1161, Rarity.RARE, mage.cards.s.SerraAngel.class));
        cards.add(new SetCardInfo("Brainstorm", 1162, Rarity.RARE, mage.cards.b.Brainstorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Progenitus", 1163, Rarity.MYTHIC, mage.cards.p.Progenitus.class));
        cards.add(new SetCardInfo("Baral, Chief of Compliance", 1164, Rarity.RARE, mage.cards.b.BaralChiefOfCompliance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spellseeker", 1165, Rarity.RARE, mage.cards.s.Spellseeker.class));
        cards.add(new SetCardInfo("Magus of the Wheel", 1166, Rarity.RARE, mage.cards.m.MagusOfTheWheel.class));
        cards.add(new SetCardInfo("Kess, Dissident Mage", 1167, Rarity.MYTHIC, mage.cards.k.KessDissidentMage.class));
        cards.add(new SetCardInfo("Field Marshal", 1168, Rarity.RARE, mage.cards.f.FieldMarshal.class));
        cards.add(new SetCardInfo("Temporal Manipulation", 1169, Rarity.MYTHIC, mage.cards.t.TemporalManipulation.class));
        cards.add(new SetCardInfo("Dark Ritual", 1170, Rarity.RARE, mage.cards.d.DarkRitual.class));
        cards.add(new SetCardInfo("Midnight Reaper", 1171, Rarity.RARE, mage.cards.m.MidnightReaper.class));
        cards.add(new SetCardInfo("Seize the Day", 1172, Rarity.RARE, mage.cards.s.SeizeTheDay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faeburrow Elder", 1173, Rarity.RARE, mage.cards.f.FaeburrowElder.class));
        cards.add(new SetCardInfo("Carnage Tyrant", 1174, Rarity.MYTHIC, mage.cards.c.CarnageTyrant.class));
        cards.add(new SetCardInfo("Fleshbag Marauder", 1175, Rarity.RARE, mage.cards.f.FleshbagMarauder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("It That Betrays", 1176, Rarity.RARE, mage.cards.i.ItThatBetrays.class));
        cards.add(new SetCardInfo("Forced Fruition", 1177, Rarity.RARE, mage.cards.f.ForcedFruition.class));
        cards.add(new SetCardInfo("Future Sight", 1178, Rarity.RARE, mage.cards.f.FutureSight.class));
        cards.add(new SetCardInfo("Mental Misstep", 1179, Rarity.RARE, mage.cards.m.MentalMisstep.class));
        cards.add(new SetCardInfo("Mind's Dilation", 1180, Rarity.MYTHIC, mage.cards.m.MindsDilation.class));
        cards.add(new SetCardInfo("Well of Lost Dreams", 1181, Rarity.RARE, mage.cards.w.WellOfLostDreams.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Felidar Sovereign", 1182, Rarity.RARE, mage.cards.f.FelidarSovereign.class));
        cards.add(new SetCardInfo("Descendants' Path", 1183, Rarity.RARE, mage.cards.d.DescendantsPath.class));
        cards.add(new SetCardInfo("Lord Windgrace", 1184, Rarity.MYTHIC, mage.cards.l.LordWindgrace.class));
        cards.add(new SetCardInfo("Violent Outburst", 1185, Rarity.RARE, mage.cards.v.ViolentOutburst.class));
        cards.add(new SetCardInfo("K'rrik, Son of Yawgmoth", 1186, Rarity.RARE, mage.cards.k.KrrikSonOfYawgmoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bolas's Citadel", 1187, Rarity.RARE, mage.cards.b.BolassCitadel.class));
        cards.add(new SetCardInfo("Leshrac's Sigil", 1188, Rarity.RARE, mage.cards.l.LeshracsSigil.class));
        cards.add(new SetCardInfo("Jet Medallion", 1189, Rarity.RARE, mage.cards.j.JetMedallion.class));
        cards.add(new SetCardInfo("Plains", 1190, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 1191, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 1192, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1193, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 1194, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phage the Untouchable", 1195, Rarity.MYTHIC, mage.cards.p.PhageTheUntouchable.class));
        cards.add(new SetCardInfo("Yisan, the Wanderer Bard", 1196, Rarity.RARE, mage.cards.y.YisanTheWandererBard.class));
        cards.add(new SetCardInfo("Alela, Artful Provocateur", 1197, Rarity.MYTHIC, mage.cards.a.AlelaArtfulProvocateur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sen Triplets", 1198, Rarity.MYTHIC, mage.cards.s.SenTriplets.class));
        cards.add(new SetCardInfo("Tevesh Szat, Doom of Fools", 1199, Rarity.MYTHIC, mage.cards.t.TeveshSzatDoomOfFools.class));
        cards.add(new SetCardInfo("Godo, Bandit Warlord", 1200, Rarity.RARE, mage.cards.g.GodoBanditWarlord.class));
        cards.add(new SetCardInfo("Jeska, Thrice Reborn", 1201, Rarity.MYTHIC, mage.cards.j.JeskaThriceReborn.class));
        cards.add(new SetCardInfo("Vial Smasher the Fierce", 1202, Rarity.MYTHIC, mage.cards.v.VialSmasherTheFierce.class));
        cards.add(new SetCardInfo("Blighted Agent", 1203, Rarity.RARE, mage.cards.b.BlightedAgent.class));
        cards.add(new SetCardInfo("K'rrik, Son of Yawgmoth", 1204, Rarity.RARE, mage.cards.k.KrrikSonOfYawgmoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glistener Elf", 1205, Rarity.RARE, mage.cards.g.GlistenerElf.class));
        cards.add(new SetCardInfo("Batterskull", 1206, Rarity.MYTHIC, mage.cards.b.Batterskull.class));
        cards.add(new SetCardInfo("Inkmoth Nexus", 1207, Rarity.RARE, mage.cards.i.InkmothNexus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Esika, God of the Tree", 1208, Rarity.MYTHIC, mage.cards.e.EsikaGodOfTheTree.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archangel Avacyn", 1209, Rarity.MYTHIC, mage.cards.a.ArchangelAvacyn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Avacyn, the Purifier", 1209, Rarity.MYTHIC, mage.cards.a.AvacynThePurifier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodline Keeper", 1210, Rarity.RARE, mage.cards.b.BloodlineKeeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of Lineage", 1210, Rarity.RARE, mage.cards.l.LordOfLineage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nicol Bolas, the Ravager", 1211, Rarity.MYTHIC, mage.cards.n.NicolBolasTheRavager.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nicol Bolas, the Arisen", 1211, Rarity.MYTHIC, mage.cards.n.NicolBolasTheArisen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Westvale Abbey", 1212, Rarity.RARE, mage.cards.w.WestvaleAbbey.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ormendahl, Profane Prince", 1212, Rarity.RARE, mage.cards.o.OrmendahlProfanePrince.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phyrexian Unlife", 1213, Rarity.RARE, mage.cards.p.PhyrexianUnlife.class));
        cards.add(new SetCardInfo("Phyrexian Crusader", 1214, Rarity.RARE, mage.cards.p.PhyrexianCrusader.class));
        cards.add(new SetCardInfo("Plague Engineer", 1215, Rarity.RARE, mage.cards.p.PlagueEngineer.class));
        cards.add(new SetCardInfo("Ertai, the Corrupted", 1216, Rarity.RARE, mage.cards.e.ErtaiTheCorrupted.class));
        cards.add(new SetCardInfo("Glissa, the Traitor", 1217, Rarity.MYTHIC, mage.cards.g.GlissaTheTraitor.class));
        cards.add(new SetCardInfo("Eldrazi Conscription", 1218, Rarity.RARE, mage.cards.e.EldraziConscription.class));
        cards.add(new SetCardInfo("Deafening Silence", 1219, Rarity.RARE, mage.cards.d.DeafeningSilence.class));
        cards.add(new SetCardInfo("Counterbalance", 1220, Rarity.RARE, mage.cards.c.Counterbalance.class));
        cards.add(new SetCardInfo("Bruna, Light of Alabaster", 1221, Rarity.MYTHIC, mage.cards.b.BrunaLightOfAlabaster.class));
        cards.add(new SetCardInfo("Hexdrinker", 1222, Rarity.MYTHIC, mage.cards.h.Hexdrinker.class));
        cards.add(new SetCardInfo("Lotus Cobra", 1223, Rarity.RARE, mage.cards.l.LotusCobra.class));
        cards.add(new SetCardInfo("Seshiro the Anointed", 1224, Rarity.RARE, mage.cards.s.SeshiroTheAnointed.class));
        cards.add(new SetCardInfo("Ice-Fang Coatl", 1225, Rarity.RARE, mage.cards.i.IceFangCoatl.class));
        cards.add(new SetCardInfo("Stonecoil Serpent", 1226, Rarity.RARE, mage.cards.s.StonecoilSerpent.class));
        cards.add(new SetCardInfo("Alms Collector", 1227, Rarity.RARE, mage.cards.a.AlmsCollector.class));
        cards.add(new SetCardInfo("Crested Sunmare", 1228, Rarity.MYTHIC, mage.cards.c.CrestedSunmare.class));
        cards.add(new SetCardInfo("Goreclaw, Terror of Qal Sisma", 1229, Rarity.RARE, mage.cards.g.GoreclawTerrorOfQalSisma.class));
        cards.add(new SetCardInfo("Rin and Seri, Inseparable", 1230, Rarity.MYTHIC, mage.cards.r.RinAndSeriInseparable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Exotic Orchard", 1231, Rarity.RARE, mage.cards.e.ExoticOrchard.class));
        cards.add(new SetCardInfo("Sakashima the Impostor", 1232, Rarity.RARE, mage.cards.s.SakashimaTheImpostor.class));
        cards.add(new SetCardInfo("Massacre Girl", 1233, Rarity.RARE, mage.cards.m.MassacreGirl.class));
        cards.add(new SetCardInfo("Azusa, Lost but Seeking", 1234, Rarity.RARE, mage.cards.a.AzusaLostButSeeking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teysa Karlov", 1235, Rarity.RARE, mage.cards.t.TeysaKarlov.class));
        cards.add(new SetCardInfo("Paradise Mantle", 1236, Rarity.RARE, mage.cards.p.ParadiseMantle.class));
        cards.add(new SetCardInfo("Xenk, Paladin Unbroken", 1237, Rarity.RARE, mage.cards.x.XenkPaladinUnbroken.class));
        cards.add(new SetCardInfo("Simon, Wild Magic Sorcerer", 1238, Rarity.RARE, mage.cards.s.SimonWildMagicSorcerer.class));
        cards.add(new SetCardInfo("Forge, Neverwinter Charlatan", 1239, Rarity.RARE, mage.cards.f.ForgeNeverwinterCharlatan.class));
        cards.add(new SetCardInfo("Holga, Relentless Rager", 1240, Rarity.RARE, mage.cards.h.HolgaRelentlessRager.class));
        cards.add(new SetCardInfo("Doric, Nature's Warden", 1241, Rarity.RARE, mage.cards.d.DoricNaturesWarden.class));
        cards.add(new SetCardInfo("Doric, Owlbear Avenger", 1241, Rarity.RARE, mage.cards.d.DoricOwlbearAvenger.class));
        cards.add(new SetCardInfo("Edgin, Larcenous Lutenist", 1242, Rarity.RARE, mage.cards.e.EdginLarcenousLutenist.class));
        cards.add(new SetCardInfo("Ugin, the Ineffable", 1243, Rarity.RARE, mage.cards.u.UginTheIneffable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sorin, Imperious Bloodlord", 1244, Rarity.MYTHIC, mage.cards.s.SorinImperiousBloodlord.class));
        cards.add(new SetCardInfo("Sarkhan, Dragonsoul", 1245, Rarity.MYTHIC, mage.cards.s.SarkhanDragonsoul.class));
        cards.add(new SetCardInfo("Nicol Bolas, Dragon-God", 1246, Rarity.MYTHIC, mage.cards.n.NicolBolasDragonGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Braid of Fire", 1247, Rarity.RARE, mage.cards.b.BraidOfFire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Koth of the Hammer", 1248, Rarity.MYTHIC, mage.cards.k.KothOfTheHammer.class));
        cards.add(new SetCardInfo("Master of the Wild Hunt", 1249, Rarity.MYTHIC, mage.cards.m.MasterOfTheWildHunt.class));
        cards.add(new SetCardInfo("Karrthus, Tyrant of Jund", 1250, Rarity.MYTHIC, mage.cards.k.KarrthusTyrantOfJund.class));
        cards.add(new SetCardInfo("Cleansing Nova", 1251, Rarity.RARE, mage.cards.c.CleansingNova.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serra the Benevolent", 1252, Rarity.MYTHIC, mage.cards.s.SerraTheBenevolent.class));
        cards.add(new SetCardInfo("Stoneforge Mystic", 1253, Rarity.RARE, mage.cards.s.StoneforgeMystic.class));
        cards.add(new SetCardInfo("Muddle the Mixture", 1254, Rarity.RARE, mage.cards.m.MuddleTheMixture.class));
        cards.add(new SetCardInfo("Flamekin Harbinger", 1255, Rarity.RARE, mage.cards.f.FlamekinHarbinger.class));
        cards.add(new SetCardInfo("Omnath, Locus of Rage", 1256, Rarity.MYTHIC, mage.cards.o.OmnathLocusOfRage.class));
        cards.add(new SetCardInfo("Risen Reef", 1257, Rarity.RARE, mage.cards.r.RisenReef.class));
        cards.add(new SetCardInfo("Voice of Resurgence", 1258, Rarity.MYTHIC, mage.cards.v.VoiceOfResurgence.class));
        cards.add(new SetCardInfo("Wheel and Deal", 1262, Rarity.RARE, mage.cards.w.WheelAndDeal.class));
        cards.add(new SetCardInfo("Questing Beast", 1263, Rarity.MYTHIC, mage.cards.q.QuestingBeast.class));
        cards.add(new SetCardInfo("Olivia Voldaren", 1264, Rarity.MYTHIC, mage.cards.o.OliviaVoldaren.class));
        cards.add(new SetCardInfo("Walking Ballista", 1265, Rarity.RARE, mage.cards.w.WalkingBallista.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The World Tree", 1266, Rarity.RARE, mage.cards.t.TheWorldTree.class));
        cards.add(new SetCardInfo("Higure, the Still Wind", 1267, Rarity.RARE, mage.cards.h.HigureTheStillWind.class));
        cards.add(new SetCardInfo("Nezahal, Primal Tide", 1268, Rarity.RARE, mage.cards.n.NezahalPrimalTide.class));
        cards.add(new SetCardInfo("Dragonlord Kolaghan", 1269, Rarity.MYTHIC, mage.cards.d.DragonlordKolaghan.class));
        cards.add(new SetCardInfo("Mina and Denn, Wildborn", 1270, Rarity.RARE, mage.cards.m.MinaAndDennWildborn.class));
        cards.add(new SetCardInfo("Xantcha, Sleeper Agent", 1271, Rarity.RARE, mage.cards.x.XantchaSleeperAgent.class));
        cards.add(new SetCardInfo("Misdirection", 1272, Rarity.RARE, mage.cards.m.Misdirection.class));
        cards.add(new SetCardInfo("Utvara Hellkite", 1273, Rarity.MYTHIC, mage.cards.u.UtvaraHellkite.class));
        cards.add(new SetCardInfo("Kogla, the Titan Ape", 1274, Rarity.RARE, mage.cards.k.KoglaTheTitanApe.class));
        cards.add(new SetCardInfo("Nyxbloom Ancient", 1275, Rarity.MYTHIC, mage.cards.n.NyxbloomAncient.class));
        cards.add(new SetCardInfo("Jhoira, Weatherlight Captain", 1276, Rarity.RARE, mage.cards.j.JhoiraWeatherlightCaptain.class));
        cards.add(new SetCardInfo("Llawan, Cephalid Empress", 1277, Rarity.RARE, mage.cards.l.LlawanCephalidEmpress.class));
        cards.add(new SetCardInfo("Master of Waves", 1278, Rarity.MYTHIC, mage.cards.m.MasterOfWaves.class));
        cards.add(new SetCardInfo("Thassa, Deep-Dwelling", 1279, Rarity.MYTHIC, mage.cards.t.ThassaDeepDwelling.class));
        cards.add(new SetCardInfo("Thassa's Oracle", 1280, Rarity.RARE, mage.cards.t.ThassasOracle.class));
        cards.add(new SetCardInfo("Joraga Treespeaker", 1281, Rarity.RARE, mage.cards.j.JoragaTreespeaker.class));
        cards.add(new SetCardInfo("Nature's Will", 1282, Rarity.RARE, mage.cards.n.NaturesWill.class));
        cards.add(new SetCardInfo("Ulvenwald Tracker", 1283, Rarity.RARE, mage.cards.u.UlvenwaldTracker.class));
        cards.add(new SetCardInfo("Yeva, Nature's Herald", 1284, Rarity.RARE, mage.cards.y.YevaNaturesHerald.class));
        cards.add(new SetCardInfo("Grand Abolisher", 1285, Rarity.RARE, mage.cards.g.GrandAbolisher.class));
        cards.add(new SetCardInfo("Selfless Savior", 1286, Rarity.RARE, mage.cards.s.SelflessSavior.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Akroma, Angel of Fury", 1287, Rarity.MYTHIC, mage.cards.a.AkromaAngelOfFury.class));
        cards.add(new SetCardInfo("Umezawa's Jitte", 1288, Rarity.RARE, mage.cards.u.UmezawasJitte.class));
        cards.add(new SetCardInfo("Linvala, Keeper of Silence", 1289, Rarity.MYTHIC, mage.cards.l.LinvalaKeeperOfSilence.class));
        cards.add(new SetCardInfo("Sunblast Angel", 1290, Rarity.RARE, mage.cards.s.SunblastAngel.class));
        cards.add(new SetCardInfo("Emeria, the Sky Ruin", 1291, Rarity.RARE, mage.cards.e.EmeriaTheSkyRuin.class));
        cards.add(new SetCardInfo("Seraph Sanctuary", 1292, Rarity.RARE, mage.cards.s.SeraphSanctuary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Slip On the Ring", 1293, Rarity.RARE, mage.cards.s.SlipOnTheRing.class));
        cards.add(new SetCardInfo("Gandalf, Friend of the Shire", 1294, Rarity.RARE, mage.cards.g.GandalfFriendOfTheShire.class));
        cards.add(new SetCardInfo("Mirror of Galadriel", 1295, Rarity.RARE, mage.cards.m.MirrorOfGaladriel.class));
        cards.add(new SetCardInfo("Shire Terrace", 1296, Rarity.RARE, mage.cards.s.ShireTerrace.class));
        cards.add(new SetCardInfo("Syr Konrad, the Grim", 1297, Rarity.RARE, mage.cards.s.SyrKonradTheGrim.class));
        cards.add(new SetCardInfo("Underworld Dreams", 1298, Rarity.RARE, mage.cards.u.UnderworldDreams.class));
        cards.add(new SetCardInfo("Waste Not", 1299, Rarity.RARE, mage.cards.w.WasteNot.class));
        cards.add(new SetCardInfo("Wheel of Misfortune", 1300, Rarity.RARE, mage.cards.w.WheelOfMisfortune.class));
        cards.add(new SetCardInfo("Nekusar, the Mindrazer", 1301, Rarity.MYTHIC, mage.cards.n.NekusarTheMindrazer.class));
        cards.add(new SetCardInfo("Nemesis of Reason", 1302, Rarity.RARE, mage.cards.n.NemesisOfReason.class));
        cards.add(new SetCardInfo("Gaea's Blessing", 1303, Rarity.RARE, mage.cards.g.GaeasBlessing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Twilight Prophet", 1304, Rarity.MYTHIC, mage.cards.t.TwilightProphet.class));
        cards.add(new SetCardInfo("Worldspine Wurm", 1305, Rarity.MYTHIC, mage.cards.w.WorldspineWurm.class));
        cards.add(new SetCardInfo("Goblin Lackey", 1311, Rarity.RARE, mage.cards.g.GoblinLackey.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Lackey", "1311*", Rarity.RARE, mage.cards.g.GoblinLackey.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Matron", 1312, Rarity.RARE, mage.cards.g.GoblinMatron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Matron", "1312*", Rarity.RARE, mage.cards.g.GoblinMatron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Recruiter", 1313, Rarity.RARE, mage.cards.g.GoblinRecruiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Recruiter", "1313*", Rarity.RARE, mage.cards.g.GoblinRecruiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Muxus, Goblin Grandee", 1314, Rarity.RARE, mage.cards.m.MuxusGoblinGrandee.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Muxus, Goblin Grandee", "1314*", Rarity.RARE, mage.cards.m.MuxusGoblinGrandee.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shattergang Brothers", 1315, Rarity.MYTHIC, mage.cards.s.ShattergangBrothers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shattergang Brothers", "1315*", Rarity.MYTHIC, mage.cards.s.ShattergangBrothers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nirkana Revenant", 1316, Rarity.MYTHIC, mage.cards.n.NirkanaRevenant.class));
        cards.add(new SetCardInfo("Arbor Elf", 1317, Rarity.RARE, mage.cards.a.ArborElf.class));
        cards.add(new SetCardInfo("Terastodon", 1318, Rarity.RARE, mage.cards.t.Terastodon.class));
        cards.add(new SetCardInfo("Maelstrom Wanderer", 1319, Rarity.MYTHIC, mage.cards.m.MaelstromWanderer.class));
        cards.add(new SetCardInfo("Gargos, Vicious Watcher", 1329, Rarity.RARE, mage.cards.g.GargosViciousWatcher.class));
        cards.add(new SetCardInfo("Primordial Hydra", 1330, Rarity.MYTHIC, mage.cards.p.PrimordialHydra.class));
        cards.add(new SetCardInfo("Unbound Flourishing", 1331, Rarity.MYTHIC, mage.cards.u.UnboundFlourishing.class));
        cards.add(new SetCardInfo("Hydroid Krasis", 1332, Rarity.RARE, mage.cards.h.HydroidKrasis.class));
        cards.add(new SetCardInfo("Zaxara, the Exemplary", 1333, Rarity.MYTHIC, mage.cards.z.ZaxaraTheExemplary.class));
        cards.add(new SetCardInfo("Gisela, the Broken Blade", 1335, Rarity.MYTHIC, mage.cards.g.GiselaTheBrokenBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brisela, Voice of Nightmares", "1336b", Rarity.MYTHIC, mage.cards.b.BriselaVoiceOfNightmares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bruna, the Fading Light", 1336, Rarity.RARE, mage.cards.b.BrunaTheFadingLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archangel of Thune", 1337, Rarity.MYTHIC, mage.cards.a.ArchangelOfThune.class));
        cards.add(new SetCardInfo("Court of Grace", 1338, Rarity.RARE, mage.cards.c.CourtOfGrace.class));
        cards.add(new SetCardInfo("Commander's Plate", 1339, Rarity.MYTHIC, mage.cards.c.CommandersPlate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angel of Finality", 1342, Rarity.RARE, mage.cards.a.AngelOfFinality.class));
        cards.add(new SetCardInfo("Angel of the Ruins", 1343, Rarity.RARE, mage.cards.a.AngelOfTheRuins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arden Angel", 1344, Rarity.RARE, mage.cards.a.ArdenAngel.class));
        cards.add(new SetCardInfo("Breathkeeper Seraph", 1345, Rarity.RARE, mage.cards.b.BreathkeeperSeraph.class));
        cards.add(new SetCardInfo("Dawnbreak Reclaimer", 1346, Rarity.RARE, mage.cards.d.DawnbreakReclaimer.class));
        cards.add(new SetCardInfo("Valkyrie Harbinger", 1347, Rarity.RARE, mage.cards.v.ValkyrieHarbinger.class));
        cards.add(new SetCardInfo("Plains", 1348, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 1349, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 1350, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 1351, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Puresteel Paladin", 1352, Rarity.RARE, mage.cards.p.PuresteelPaladin.class));
        cards.add(new SetCardInfo("Vanquish the Horde", 1353, Rarity.RARE, mage.cards.v.VanquishTheHorde.class));
        cards.add(new SetCardInfo("Zombie Apocalypse", 1354, Rarity.RARE, mage.cards.z.ZombieApocalypse.class));
        cards.add(new SetCardInfo("Varina, Lich Queen", 1355, Rarity.MYTHIC, mage.cards.v.VarinaLichQueen.class));
        cards.add(new SetCardInfo("Field of the Dead", 1356, Rarity.RARE, mage.cards.f.FieldOfTheDead.class));
        cards.add(new SetCardInfo("Mountain", 1358, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1359, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1360, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1361, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1362, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1363, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1364, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1365, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1366, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1367, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rewind", 1368, Rarity.RARE, mage.cards.r.Rewind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Food Chain", 1369, Rarity.MYTHIC, mage.cards.f.FoodChain.class));
        cards.add(new SetCardInfo("Rampant Growth", 1370, Rarity.RARE, mage.cards.r.RampantGrowth.class));
        cards.add(new SetCardInfo("The First Sliver", 1371, Rarity.MYTHIC, mage.cards.t.TheFirstSliver.class));
        cards.add(new SetCardInfo("Concealed Courtyard", 1372, Rarity.RARE, mage.cards.c.ConcealedCourtyard.class));
        cards.add(new SetCardInfo("Spirebluff Canal", 1373, Rarity.RARE, mage.cards.s.SpirebluffCanal.class));
        cards.add(new SetCardInfo("Blooming Marsh", 1374, Rarity.RARE, mage.cards.b.BloomingMarsh.class));
        cards.add(new SetCardInfo("Inspiring Vantage", 1375, Rarity.RARE, mage.cards.i.InspiringVantage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Botanical Sanctum", 1376, Rarity.RARE, mage.cards.b.BotanicalSanctum.class));
        cards.add(new SetCardInfo("Angel of Serenity", 1377, Rarity.MYTHIC, mage.cards.a.AngelOfSerenity.class));
        cards.add(new SetCardInfo("Angel of the Ruins", 1378, Rarity.RARE, mage.cards.a.AngelOfTheRuins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blinding Angel", 1379, Rarity.RARE, mage.cards.b.BlindingAngel.class));
        cards.add(new SetCardInfo("Restoration Angel", 1380, Rarity.RARE, mage.cards.r.RestorationAngel.class));
        cards.add(new SetCardInfo("Sublime Archangel", 1381, Rarity.MYTHIC, mage.cards.s.SublimeArchangel.class));
        cards.add(new SetCardInfo("Plains", 1382, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 1383, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 1384, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1385, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 1386, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Gisela, the Broken Blade", 1387, Rarity.MYTHIC, mage.cards.g.GiselaTheBrokenBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brisela, Voice of Nightmares", "1388b", Rarity.MYTHIC, mage.cards.b.BriselaVoiceOfNightmares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bruna, the Fading Light", 1388, Rarity.RARE, mage.cards.b.BrunaTheFadingLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Etali, Primal Storm", 1389, Rarity.RARE, mage.cards.e.EtaliPrimalStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Etali, Primal Storm", "1389*", Rarity.RARE, mage.cards.e.EtaliPrimalStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rampaging Ferocidon", 1390, Rarity.RARE, mage.cards.r.RampagingFerocidon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rampaging Ferocidon", "1390*", Rarity.RARE, mage.cards.r.RampagingFerocidon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Polyraptor", 1391, Rarity.MYTHIC, mage.cards.p.Polyraptor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Polyraptor", "1391*", Rarity.MYTHIC, mage.cards.p.Polyraptor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wayward Swordtooth", 1392, Rarity.RARE, mage.cards.w.WaywardSwordtooth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wayward Swordtooth", "1392*", Rarity.RARE, mage.cards.w.WaywardSwordtooth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regisaur Alpha", 1393, Rarity.RARE, mage.cards.r.RegisaurAlpha.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regisaur Alpha", "1393*", Rarity.RARE, mage.cards.r.RegisaurAlpha.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Laboratory Maniac", 1394, Rarity.RARE, mage.cards.l.LaboratoryManiac.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Laboratory Maniac", "1394*", Rarity.RARE, mage.cards.l.LaboratoryManiac.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tasha's Hideous Laughter", 1395, Rarity.RARE, mage.cards.t.TashasHideousLaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tasha's Hideous Laughter", "1395*", Rarity.RARE, mage.cards.t.TashasHideousLaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tasigur, the Golden Fang", 1396, Rarity.RARE, mage.cards.t.TasigurTheGoldenFang.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tasigur, the Golden Fang", "1396*", Rarity.RARE, mage.cards.t.TasigurTheGoldenFang.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atla Palani, Nest Tender", 1397, Rarity.MYTHIC, mage.cards.a.AtlaPalaniNestTender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atla Palani, Nest Tender", "1397*", Rarity.MYTHIC, mage.cards.a.AtlaPalaniNestTender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 1399, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 1400, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 1401, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1402, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 1403, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Bottomless Pit", 1404, Rarity.RARE, mage.cards.b.BottomlessPit.class));
        cards.add(new SetCardInfo("Necrogen Mists", 1405, Rarity.RARE, mage.cards.n.NecrogenMists.class));
        cards.add(new SetCardInfo("Reassembling Skeleton", 1406, Rarity.RARE, mage.cards.r.ReassemblingSkeleton.class));
        cards.add(new SetCardInfo("Tinybones, Trinket Thief", 1407, Rarity.MYTHIC, mage.cards.t.TinybonesTrinketThief.class));
        cards.add(new SetCardInfo("Geier Reach Sanitarium", 1408, Rarity.RARE, mage.cards.g.GeierReachSanitarium.class));
        cards.add(new SetCardInfo("Captain Lannery Storm", 1409, Rarity.RARE, mage.cards.c.CaptainLanneryStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Captain Lannery Storm", "1409*", Rarity.RARE, mage.cards.c.CaptainLanneryStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Admiral Beckett Brass", 1410, Rarity.MYTHIC, mage.cards.a.AdmiralBeckettBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Admiral Beckett Brass", "1410*", Rarity.MYTHIC, mage.cards.a.AdmiralBeckettBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elenda, the Dusk Rose", 1411, Rarity.MYTHIC, mage.cards.e.ElendaTheDuskRose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elenda, the Dusk Rose", "1411*", Rarity.MYTHIC, mage.cards.e.ElendaTheDuskRose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kumena, Tyrant of Orazca", 1412, Rarity.MYTHIC, mage.cards.k.KumenaTyrantOfOrazca.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kumena, Tyrant of Orazca", "1412*", Rarity.MYTHIC, mage.cards.k.KumenaTyrantOfOrazca.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vona, Butcher of Magan", 1413, Rarity.MYTHIC, mage.cards.v.VonaButcherOfMagan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vona, Butcher of Magan", "1413*", Rarity.MYTHIC, mage.cards.v.VonaButcherOfMagan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eldritch Evolution", 1414, Rarity.RARE, mage.cards.e.EldritchEvolution.class));
        cards.add(new SetCardInfo("Giant Adephage", 1415, Rarity.MYTHIC, mage.cards.g.GiantAdephage.class));
        cards.add(new SetCardInfo("Noxious Revival", 1416, Rarity.RARE, mage.cards.n.NoxiousRevival.class));
        cards.add(new SetCardInfo("Grist, the Hunger Tide", 1417, Rarity.MYTHIC, mage.cards.g.GristTheHungerTide.class));
        cards.add(new SetCardInfo("Mazirek, Kraul Death Priest", 1418, Rarity.RARE, mage.cards.m.MazirekKraulDeathPriest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, Scion of Urza", 1419, Rarity.MYTHIC, mage.cards.k.KarnScionOfUrza.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, Scion of Urza", "1419*", Rarity.MYTHIC, mage.cards.k.KarnScionOfUrza.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra, Flame's Catalyst", 1420, Rarity.MYTHIC, mage.cards.c.ChandraFlamesCatalyst.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra, Flame's Catalyst", "1420*", Rarity.MYTHIC, mage.cards.c.ChandraFlamesCatalyst.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aminatou, the Fateshifter", 1421, Rarity.MYTHIC, mage.cards.a.AminatouTheFateshifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aminatou, the Fateshifter", "1421*", Rarity.MYTHIC, mage.cards.a.AminatouTheFateshifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Daretti, Ingenious Iconoclast", 1422, Rarity.MYTHIC, mage.cards.d.DarettiIngeniousIconoclast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Daretti, Ingenious Iconoclast", "1422*", Rarity.MYTHIC, mage.cards.d.DarettiIngeniousIconoclast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Venser, the Sojourner", 1423, Rarity.MYTHIC, mage.cards.v.VenserTheSojourner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Venser, the Sojourner", "1423*", Rarity.MYTHIC, mage.cards.v.VenserTheSojourner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oppression", 1424, Rarity.RARE, mage.cards.o.Oppression.class));
        cards.add(new SetCardInfo("Abrade", 1425, Rarity.RARE, mage.cards.a.Abrade.class));
        cards.add(new SetCardInfo("Mass Hysteria", 1426, Rarity.RARE, mage.cards.m.MassHysteria.class));
        cards.add(new SetCardInfo("Terminate", 1427, Rarity.RARE, mage.cards.t.Terminate.class));
        cards.add(new SetCardInfo("Mycosynth Golem", 1433, Rarity.RARE, mage.cards.m.MycosynthGolem.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mycosynth Golem", "1433*", Rarity.RARE, mage.cards.m.MycosynthGolem.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mycosynth Lattice", 1434, Rarity.MYTHIC, mage.cards.m.MycosynthLattice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mycosynth Lattice", "1434*", Rarity.MYTHIC, mage.cards.m.MycosynthLattice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mycosynth Wellspring", 1435, Rarity.RARE, mage.cards.m.MycosynthWellspring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mycosynth Wellspring", "1435*", Rarity.RARE, mage.cards.m.MycosynthWellspring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sisay, Weatherlight Captain", 1444, Rarity.RARE, mage.cards.s.SisayWeatherlightCaptain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Silence", 1445, Rarity.RARE, mage.cards.s.Silence.class));
        cards.add(new SetCardInfo("Battle of Wits", 1446, Rarity.RARE, mage.cards.b.BattleOfWits.class));
        cards.add(new SetCardInfo("Baral, Chief of Compliance", 1447, Rarity.RARE, mage.cards.b.BaralChiefOfCompliance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pack Rat", 1448, Rarity.RARE, mage.cards.p.PackRat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fynn, the Fangbearer", 1449, Rarity.RARE, mage.cards.f.FynnTheFangbearer.class));
        cards.add(new SetCardInfo("Brion Stoutarm", 1450, Rarity.RARE, mage.cards.b.BrionStoutarm.class));
        cards.add(new SetCardInfo("Samut, Voice of Dissent", 1451, Rarity.MYTHIC, mage.cards.s.SamutVoiceOfDissent.class));
        cards.add(new SetCardInfo("Marchesa, the Black Rose", 1452, Rarity.RARE, mage.cards.m.MarchesaTheBlackRose.class));
        cards.add(new SetCardInfo("Ajani Goldmane", 1453, Rarity.MYTHIC, mage.cards.a.AjaniGoldmane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ajani Goldmane", "1453b", Rarity.MYTHIC, mage.cards.a.AjaniGoldmane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace Beleren", 1454, Rarity.MYTHIC, mage.cards.j.JaceBeleren.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace Beleren", "1454b", Rarity.MYTHIC, mage.cards.j.JaceBeleren.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana Vess", 1455, Rarity.MYTHIC, mage.cards.l.LilianaVess.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana Vess", "1455b", Rarity.MYTHIC, mage.cards.l.LilianaVess.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra Nalaar", 1456, Rarity.MYTHIC, mage.cards.c.ChandraNalaar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra Nalaar", "1456b", Rarity.MYTHIC, mage.cards.c.ChandraNalaar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Garruk Wildspeaker", 1457, Rarity.MYTHIC, mage.cards.g.GarrukWildspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Garruk Wildspeaker", "1457b", Rarity.MYTHIC, mage.cards.g.GarrukWildspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Death Baron", 1458, Rarity.RARE, mage.cards.d.DeathBaron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Death Baron", "1458b", Rarity.RARE, mage.cards.d.DeathBaron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Noxious Ghoul", 1459, Rarity.RARE, mage.cards.n.NoxiousGhoul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Noxious Ghoul", "1459b", Rarity.RARE, mage.cards.n.NoxiousGhoul.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zombie Master", 1460, Rarity.RARE, mage.cards.z.ZombieMaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zombie Master", "1460b", Rarity.RARE, mage.cards.z.ZombieMaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grimgrin, Corpse-Born", 1461, Rarity.MYTHIC, mage.cards.g.GrimgrinCorpseBorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grimgrin, Corpse-Born", "1461b", Rarity.MYTHIC, mage.cards.g.GrimgrinCorpseBorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unholy Grotto", 1462, Rarity.RARE, mage.cards.u.UnholyGrotto.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unholy Grotto", "1462b", Rarity.RARE, mage.cards.u.UnholyGrotto.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giver of Runes", 1463, Rarity.RARE, mage.cards.g.GiverOfRunes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giver of Runes", "1463*", Rarity.RARE, mage.cards.g.GiverOfRunes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Distant Melody", 1464, Rarity.RARE, mage.cards.d.DistantMelody.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Distant Melody", "1464*", Rarity.RARE, mage.cards.d.DistantMelody.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cathartic Reunion", 1465, Rarity.RARE, mage.cards.c.CatharticReunion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cathartic Reunion", "1465*", Rarity.RARE, mage.cards.c.CatharticReunion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Moment's Peace", 1466, Rarity.RARE, mage.cards.m.MomentsPeace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Moment's Peace", "1466*", Rarity.RARE, mage.cards.m.MomentsPeace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Homeward Path", 1467, Rarity.RARE, mage.cards.h.HomewardPath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Homeward Path", "1467*", Rarity.RARE, mage.cards.h.HomewardPath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 1468, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Island", 1469, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 1470, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1471, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 1472, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Plains", 1473, Rarity.LAND, mage.cards.s.SnowCoveredPlains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Plains", "1473*", Rarity.LAND, mage.cards.s.SnowCoveredPlains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Island", 1474, Rarity.LAND, mage.cards.s.SnowCoveredIsland.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Island", "1474*", Rarity.LAND, mage.cards.s.SnowCoveredIsland.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Swamp", 1475, Rarity.LAND, mage.cards.s.SnowCoveredSwamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Swamp", "1475*", Rarity.LAND, mage.cards.s.SnowCoveredSwamp.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Mountain", 1476, Rarity.LAND, mage.cards.s.SnowCoveredMountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Mountain", "1476*", Rarity.LAND, mage.cards.s.SnowCoveredMountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Forest", 1477, Rarity.LAND, mage.cards.s.SnowCoveredForest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Forest", "1477*", Rarity.LAND, mage.cards.s.SnowCoveredForest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Grand Arbiter Augustin IV", 1483, Rarity.RARE, mage.cards.g.GrandArbiterAugustinIV.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Arbiter Augustin IV", "1483*", Rarity.RARE, mage.cards.g.GrandArbiterAugustinIV.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sphere of Resistance", 1484, Rarity.RARE, mage.cards.s.SphereOfResistance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sphere of Resistance", "1484*", Rarity.RARE, mage.cards.s.SphereOfResistance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trinisphere", 1485, Rarity.MYTHIC, mage.cards.t.Trinisphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trinisphere", "1485*", Rarity.MYTHIC, mage.cards.t.Trinisphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Winter Orb", 1486, Rarity.RARE, mage.cards.w.WinterOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Winter Orb", "1486*", Rarity.RARE, mage.cards.w.WinterOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Felidar Guardian", 1487, Rarity.RARE, mage.cards.f.FelidarGuardian.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Felidar Guardian", "1487*", Rarity.RARE, mage.cards.f.FelidarGuardian.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Peregrine Drake", 1488, Rarity.RARE, mage.cards.p.PeregrineDrake.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Peregrine Drake", "1488*", Rarity.RARE, mage.cards.p.PeregrineDrake.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serpent of Yawning Depths", 1489, Rarity.RARE, mage.cards.s.SerpentOfYawningDepths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serpent of Yawning Depths", "1489*", Rarity.RARE, mage.cards.s.SerpentOfYawningDepths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scourge of Valkas", 1490, Rarity.MYTHIC, mage.cards.s.ScourgeOfValkas.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scourge of Valkas", "1490*", Rarity.MYTHIC, mage.cards.s.ScourgeOfValkas.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voracious Hydra", 1491, Rarity.RARE, mage.cards.v.VoraciousHydra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voracious Hydra", "1491*", Rarity.RARE, mage.cards.v.VoraciousHydra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", 1492, Rarity.RARE, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", "1492*", Rarity.RARE, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Greaves", 1493, Rarity.RARE, mage.cards.l.LightningGreaves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Greaves", "1493*", Rarity.RARE, mage.cards.l.LightningGreaves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 1494, Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", "1494*", Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thought Vessel", 1495, Rarity.RARE, mage.cards.t.ThoughtVessel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thought Vessel", "1495*", Rarity.RARE, mage.cards.t.ThoughtVessel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 1496, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", "1496*", Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Beacon of Tomorrows", 1497, Rarity.RARE, mage.cards.b.BeaconOfTomorrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Beacon of Tomorrows", "1497*", Rarity.RARE, mage.cards.b.BeaconOfTomorrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nexus of Fate", 1498, Rarity.MYTHIC, mage.cards.n.NexusOfFate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nexus of Fate", "1498*", Rarity.MYTHIC, mage.cards.n.NexusOfFate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Reversal", 1499, Rarity.MYTHIC, mage.cards.t.TimeReversal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Reversal", "1499*", Rarity.MYTHIC, mage.cards.t.TimeReversal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Stop", 1500, Rarity.RARE, mage.cards.t.TimeStop.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Time Stop", "1500*", Rarity.RARE, mage.cards.t.TimeStop.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lara Croft, Tomb Raider", 1501, Rarity.MYTHIC, mage.cards.l.LaraCroftTombRaider.class));
        cards.add(new SetCardInfo("Search for Azcanta", 1502, Rarity.RARE, mage.cards.s.SearchForAzcanta.class));
        cards.add(new SetCardInfo("Azcanta, the Sunken Ruin", 1502, Rarity.RARE, mage.cards.a.AzcantaTheSunkenRuin.class));
        cards.add(new SetCardInfo("Anger of the Gods", 1503, Rarity.RARE, mage.cards.a.AngerOfTheGods.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bow of Nylea", 1504, Rarity.RARE, mage.cards.b.BowOfNylea.class));
        cards.add(new SetCardInfo("Shadowspear", 1505, Rarity.RARE, mage.cards.s.Shadowspear.class));
        cards.add(new SetCardInfo("Academy Ruins", 1506, Rarity.RARE, mage.cards.a.AcademyRuins.class));
        cards.add(new SetCardInfo("Rin and Seri, Inseparable", 1508, Rarity.MYTHIC, mage.cards.r.RinAndSeriInseparable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rin and Seri, Inseparable", "1508b", Rarity.MYTHIC, mage.cards.r.RinAndSeriInseparable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir, Nexus of Revels", 1509, Rarity.MYTHIC, mage.cards.j.JetmirNexusOfRevels.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir, Nexus of Revels", "1509b", Rarity.MYTHIC, mage.cards.j.JetmirNexusOfRevels.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jinnie Fay, Jetmir's Second", 1510, Rarity.RARE, mage.cards.j.JinnieFayJetmirsSecond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jinnie Fay, Jetmir's Second", "1510b", Rarity.RARE, mage.cards.j.JinnieFayJetmirsSecond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anointed Procession", 1511, Rarity.RARE, mage.cards.a.AnointedProcession.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anointed Procession", "1511b", Rarity.RARE, mage.cards.a.AnointedProcession.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 1512, Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", "1512b", Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 1513, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1514, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Forest", 1515, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Wall of Omens", 1518, Rarity.RARE, mage.cards.w.WallOfOmens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Omens", "1518*", Rarity.RARE, mage.cards.w.WallOfOmens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circular Logic", 1519, Rarity.RARE, mage.cards.c.CircularLogic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circular Logic", "1519*", Rarity.RARE, mage.cards.c.CircularLogic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scheming Symmetry", 1520, Rarity.RARE, mage.cards.s.SchemingSymmetry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scheming Symmetry", "1520*", Rarity.RARE, mage.cards.s.SchemingSymmetry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Price of Progress", 1521, Rarity.RARE, mage.cards.p.PriceOfProgress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Price of Progress", "1521*", Rarity.RARE, mage.cards.p.PriceOfProgress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eternal Witness", 1522, Rarity.RARE, mage.cards.e.EternalWitness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eternal Witness", "1522*", Rarity.RARE, mage.cards.e.EternalWitness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inspiring Overseer", 1523, Rarity.RARE, mage.cards.i.InspiringOverseer.class));
        cards.add(new SetCardInfo("Consider", 1524, Rarity.RARE, mage.cards.c.Consider.class));
        cards.add(new SetCardInfo("Price of Glory", 1525, Rarity.RARE, mage.cards.p.PriceOfGlory.class));
        cards.add(new SetCardInfo("Reckless Fireweaver", 1526, Rarity.RARE, mage.cards.r.RecklessFireweaver.class));
        cards.add(new SetCardInfo("Akroma's Memorial", 1527, Rarity.MYTHIC, mage.cards.a.AkromasMemorial.class));
        cards.add(new SetCardInfo("Bojuka Bog", 1532, Rarity.RARE, mage.cards.b.BojukaBog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bojuka Bog", "1532*", Rarity.RARE, mage.cards.b.BojukaBog.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Beacon", 1533, Rarity.RARE, mage.cards.c.CommandBeacon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Beacon", "1533*", Rarity.RARE, mage.cards.c.CommandBeacon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fabled Passage", 1534, Rarity.RARE, mage.cards.f.FabledPassage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fabled Passage", "1534*", Rarity.RARE, mage.cards.f.FabledPassage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reflecting Pool", 1535, Rarity.RARE, mage.cards.r.ReflectingPool.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reflecting Pool", "1535*", Rarity.RARE, mage.cards.r.ReflectingPool.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reliquary Tower", 1536, Rarity.RARE, mage.cards.r.ReliquaryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reliquary Tower", "1536*", Rarity.RARE, mage.cards.r.ReliquaryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakashima of a Thousand Faces", 1541, Rarity.MYTHIC, mage.cards.s.SakashimaOfAThousandFaces.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakashima of a Thousand Faces", "1541b", Rarity.MYTHIC, mage.cards.s.SakashimaOfAThousandFaces.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yargle, Glutton of Urborg", 1542, Rarity.RARE, mage.cards.y.YargleGluttonOfUrborg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yargle, Glutton of Urborg", "1542b", Rarity.RARE, mage.cards.y.YargleGluttonOfUrborg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krark, the Thumbless", 1543, Rarity.RARE, mage.cards.k.KrarkTheThumbless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krark, the Thumbless", "1543b", Rarity.RARE, mage.cards.k.KrarkTheThumbless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Adrix and Nev, Twincasters", 1544, Rarity.MYTHIC, mage.cards.a.AdrixAndNevTwincasters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Adrix and Nev, Twincasters", "1544b", Rarity.MYTHIC, mage.cards.a.AdrixAndNevTwincasters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Denial", 1545, Rarity.RARE, mage.cards.a.ArcaneDenial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Denial", "1545*", Rarity.RARE, mage.cards.a.ArcaneDenial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nightscape Familiar", 1546, Rarity.RARE, mage.cards.n.NightscapeFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nightscape Familiar", "1546*", Rarity.RARE, mage.cards.n.NightscapeFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rain of Filth", 1547, Rarity.RARE, mage.cards.r.RainOfFilth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rain of Filth", "1547*", Rarity.RARE, mage.cards.r.RainOfFilth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simian Spirit Guide", 1548, Rarity.RARE, mage.cards.s.SimianSpiritGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simian Spirit Guide", "1548*", Rarity.RARE, mage.cards.s.SimianSpiritGuide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prince of Thralls", 1549, Rarity.MYTHIC, mage.cards.p.PrinceOfThralls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prince of Thralls", "1549*", Rarity.MYTHIC, mage.cards.p.PrinceOfThralls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rin and Seri, Inseparable", 1554, Rarity.MYTHIC, mage.cards.r.RinAndSeriInseparable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rin and Seri, Inseparable", "1554b", Rarity.MYTHIC, mage.cards.r.RinAndSeriInseparable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir, Nexus of Revels", 1555, Rarity.MYTHIC, mage.cards.j.JetmirNexusOfRevels.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jetmir, Nexus of Revels", "1555b", Rarity.MYTHIC, mage.cards.j.JetmirNexusOfRevels.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jinnie Fay, Jetmir's Second", 1556, Rarity.RARE, mage.cards.j.JinnieFayJetmirsSecond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jinnie Fay, Jetmir's Second", "1556b", Rarity.RARE, mage.cards.j.JinnieFayJetmirsSecond.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Najeela, the Blade-Blossom", 1557, Rarity.MYTHIC, mage.cards.n.NajeelaTheBladeBlossom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kelsien, the Plague", 1558, Rarity.MYTHIC, mage.cards.k.KelsienThePlague.class));
        cards.add(new SetCardInfo("Queen Marchesa", 1559, Rarity.MYTHIC, mage.cards.q.QueenMarchesa.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ramses, Assassin Lord", 1560, Rarity.RARE, mage.cards.r.RamsesAssassinLord.class));
        cards.add(new SetCardInfo("Admiral Beckett Brass", 1561, Rarity.MYTHIC, mage.cards.a.AdmiralBeckettBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gonti, Lord of Luxury", 1566, Rarity.RARE, mage.cards.g.GontiLordOfLuxury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gonti, Lord of Luxury", "1566*", Rarity.RARE, mage.cards.g.GontiLordOfLuxury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vilis, Broker of Blood", 1567, Rarity.RARE, mage.cards.v.VilisBrokerOfBlood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vilis, Broker of Blood", "1567*", Rarity.RARE, mage.cards.v.VilisBrokerOfBlood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anowon, the Ruin Thief", 1568, Rarity.MYTHIC, mage.cards.a.AnowonTheRuinThief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anowon, the Ruin Thief", "1568*", Rarity.MYTHIC, mage.cards.a.AnowonTheRuinThief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grenzo, Dungeon Warden", 1569, Rarity.RARE, mage.cards.g.GrenzoDungeonWarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grenzo, Dungeon Warden", "1569*", Rarity.RARE, mage.cards.g.GrenzoDungeonWarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blade of Selves", 1570, Rarity.RARE, mage.cards.b.BladeOfSelves.class));
        cards.add(new SetCardInfo("Conqueror's Flail", 1571, Rarity.RARE, mage.cards.c.ConquerorsFlail.class));
        cards.add(new SetCardInfo("Darksteel Plate", 1572, Rarity.RARE, mage.cards.d.DarksteelPlate.class));
        cards.add(new SetCardInfo("Deathrender", 1573, Rarity.RARE, mage.cards.d.Deathrender.class));
        cards.add(new SetCardInfo("Whispersilk Cloak", 1574, Rarity.RARE, mage.cards.w.WhispersilkCloak.class));
        cards.add(new SetCardInfo("Reconnaissance", 1575, Rarity.RARE, mage.cards.r.Reconnaissance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reconnaissance", "1575*", Rarity.RARE, mage.cards.r.Reconnaissance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace, Wielder of Mysteries", 1576, Rarity.RARE, mage.cards.j.JaceWielderOfMysteries.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace, Wielder of Mysteries", "1576*", Rarity.RARE, mage.cards.j.JaceWielderOfMysteries.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Market", 1577, Rarity.RARE, mage.cards.b.BlackMarket.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Market", "1577*", Rarity.RARE, mage.cards.b.BlackMarket.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dire Undercurrents", 1578, Rarity.RARE, mage.cards.d.DireUndercurrents.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dire Undercurrents", "1578*", Rarity.RARE, mage.cards.d.DireUndercurrents.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obeka, Brute Chronologist", 1579, Rarity.RARE, mage.cards.o.ObekaBruteChronologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obeka, Brute Chronologist", "1579*", Rarity.RARE, mage.cards.o.ObekaBruteChronologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rose Noble", 1580, Rarity.RARE, mage.cards.r.RoseNoble.class));
        cards.add(new SetCardInfo("The Meep", 1581, Rarity.RARE, mage.cards.t.TheMeep.class));
        cards.add(new SetCardInfo("The Fourteenth Doctor", 1583, Rarity.RARE, mage.cards.t.TheFourteenthDoctor.class));
        cards.add(new SetCardInfo("Elspeth Tirel", 1585, Rarity.MYTHIC, mage.cards.e.ElspethTirel.class));
        cards.add(new SetCardInfo("Shelter", 1587, Rarity.RARE, mage.cards.s.Shelter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shelter", "1587*", Rarity.RARE, mage.cards.s.Shelter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace, Unraveler of Secrets", 1590, Rarity.MYTHIC, mage.cards.j.JaceUnravelerOfSecrets.class));
        cards.add(new SetCardInfo("Diabolic Tutor", 1592, Rarity.RARE, mage.cards.d.DiabolicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana of the Dark Realms", 1593, Rarity.MYTHIC, mage.cards.l.LilianaOfTheDarkRealms.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra's Ignition", 1594, Rarity.RARE, mage.cards.c.ChandrasIgnition.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra's Ignition", "1594*", Rarity.RARE, mage.cards.c.ChandrasIgnition.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chord of Calling", 1595, Rarity.RARE, mage.cards.c.ChordOfCalling.class));
        cards.add(new SetCardInfo("Harmonize", 1596, Rarity.RARE, mage.cards.h.Harmonize.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harmonize", "1596*", Rarity.RARE, mage.cards.h.Harmonize.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azusa, Lost but Seeking", 1597, Rarity.RARE, mage.cards.a.AzusaLostButSeeking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azusa, Lost but Seeking", "1597*", Rarity.RARE, mage.cards.a.AzusaLostButSeeking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Freyalise, Llanowar's Fury", 1598, Rarity.MYTHIC, mage.cards.f.FreyaliseLlanowarsFury.class));
        cards.add(new SetCardInfo("Child of Alara", 1599, Rarity.MYTHIC, mage.cards.c.ChildOfAlara.class));
        cards.add(new SetCardInfo("The Royal Scions", 1600, Rarity.MYTHIC, mage.cards.t.TheRoyalScions.class));
        cards.add(new SetCardInfo("Feather, the Redeemed", 1602, Rarity.RARE, mage.cards.f.FeatherTheRedeemed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feather, the Redeemed", "1602*", Rarity.RARE, mage.cards.f.FeatherTheRedeemed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Song of Creation", 1603, Rarity.RARE, mage.cards.s.SongOfCreation.class));
        cards.add(new SetCardInfo("Sol Ring", 1604, Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inspiring Vantage", 1605, Rarity.RARE, mage.cards.i.InspiringVantage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inspiring Vantage", "1605*", Rarity.RARE, mage.cards.i.InspiringVantage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thespian's Stage", 1607, Rarity.RARE, mage.cards.t.ThespiansStage.class));
        cards.add(new SetCardInfo("Avabruck Caretaker", 1608, Rarity.MYTHIC, mage.cards.a.AvabruckCaretaker.class));
        cards.add(new SetCardInfo("Hollowhenge Huntmaster", 1608, Rarity.MYTHIC, mage.cards.h.HollowhengeHuntmaster.class));
        cards.add(new SetCardInfo("Beastmaster Ascension", 1609, Rarity.RARE, mage.cards.b.BeastmasterAscension.class));
        cards.add(new SetCardInfo("Howl of the Night Pack", 1610, Rarity.RARE, mage.cards.h.HowlOfTheNightPack.class));
        cards.add(new SetCardInfo("Second Harvest", 1611, Rarity.RARE, mage.cards.s.SecondHarvest.class));
        cards.add(new SetCardInfo("Tovolar, Dire Overlord", 1612, Rarity.RARE, mage.cards.t.TovolarDireOverlord.class));
        cards.add(new SetCardInfo("Tovolar, the Midnight Scourge", 1612, Rarity.RARE, mage.cards.t.TovolarTheMidnightScourge.class));
        cards.add(new SetCardInfo("Brash Taunter", 1614, Rarity.RARE, mage.cards.b.BrashTaunter.class));
        cards.add(new SetCardInfo("Goblin Chieftain", 1615, Rarity.RARE, mage.cards.g.GoblinChieftain.class));
        cards.add(new SetCardInfo("Goblin Ringleader", 1616, Rarity.RARE, mage.cards.g.GoblinRingleader.class));
        cards.add(new SetCardInfo("Goblin Welder", 1617, Rarity.RARE, mage.cards.g.GoblinWelder.class));
        cards.add(new SetCardInfo("Mogg War Marshal", 1618, Rarity.RARE, mage.cards.m.MoggWarMarshal.class));
        cards.add(new SetCardInfo("Tezzeret the Seeker", 1619, Rarity.MYTHIC, mage.cards.t.TezzeretTheSeeker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Griselbrand", 1620, Rarity.MYTHIC, mage.cards.g.Griselbrand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grenzo, Havoc Raiser", 1621, Rarity.RARE, mage.cards.g.GrenzoHavocRaiser.class));
        cards.add(new SetCardInfo("Nicol Bolas, Planeswalker", 1622, Rarity.MYTHIC, mage.cards.n.NicolBolasPlaneswalker.class));
        cards.add(new SetCardInfo("Vorinclex, Voice of Hunger", 1623, Rarity.MYTHIC, mage.cards.v.VorinclexVoiceOfHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karona, False God", 1624, Rarity.RARE, mage.cards.k.KaronaFalseGod.class));
        cards.add(new SetCardInfo("Korvold, Fae-Cursed King", 1625, Rarity.MYTHIC, mage.cards.k.KorvoldFaeCursedKing.class));
        cards.add(new SetCardInfo("Memnarch", 1626, Rarity.RARE, mage.cards.m.Memnarch.class));
        cards.add(new SetCardInfo("Swords to Plowshares", 1627, Rarity.RARE, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", "1627*", Rarity.RARE, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faerie Artisans", 1628, Rarity.RARE, mage.cards.f.FaerieArtisans.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faerie Artisans", "1628*", Rarity.RARE, mage.cards.f.FaerieArtisans.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dockside Chef", 1629, Rarity.RARE, mage.cards.d.DocksideChef.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dockside Chef", "1629*", Rarity.RARE, mage.cards.d.DocksideChef.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alela, Artful Provocateur", 1630, Rarity.MYTHIC, mage.cards.a.AlelaArtfulProvocateur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alela, Artful Provocateur", "1630*", Rarity.MYTHIC, mage.cards.a.AlelaArtfulProvocateur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Door of Destinies", 1631, Rarity.RARE, mage.cards.d.DoorOfDestinies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Door of Destinies", "1631*", Rarity.RARE, mage.cards.d.DoorOfDestinies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steelshaper's Gift", 1632, Rarity.RARE, mage.cards.s.SteelshapersGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steelshaper's Gift", "1632*", Rarity.RARE, mage.cards.s.SteelshapersGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Propaganda", 1633, Rarity.RARE, mage.cards.p.Propaganda.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Propaganda", "1633*", Rarity.RARE, mage.cards.p.Propaganda.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elixir of Immortality", 1634, Rarity.RARE, mage.cards.e.ElixirOfImmortality.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elixir of Immortality", "1634*", Rarity.RARE, mage.cards.e.ElixirOfImmortality.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Council's Judgment", 1635, Rarity.RARE, mage.cards.c.CouncilsJudgment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Council's Judgment", "1635*", Rarity.RARE, mage.cards.c.CouncilsJudgment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Idyllic Tutor", 1636, Rarity.RARE, mage.cards.i.IdyllicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Idyllic Tutor", "1636*", Rarity.RARE, mage.cards.i.IdyllicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anger", 1637, Rarity.RARE, mage.cards.a.Anger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anger", "1637*", Rarity.RARE, mage.cards.a.Anger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 1638, Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", "1638*", Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inalla, Archmage Ritualist", 1639, Rarity.MYTHIC, mage.cards.i.InallaArchmageRitualist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inalla, Archmage Ritualist", "1639*", Rarity.MYTHIC, mage.cards.i.InallaArchmageRitualist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aether Vial", 1640, Rarity.RARE, mage.cards.a.AetherVial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aether Vial", "1640*", Rarity.RARE, mage.cards.a.AetherVial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", 1641, Rarity.RARE, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", "1641*", Rarity.RARE, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of the Animist", 1642, Rarity.RARE, mage.cards.s.SwordOfTheAnimist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of the Animist", "1642*", Rarity.RARE, mage.cards.s.SwordOfTheAnimist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gravebreaker Lamia", 1643, Rarity.RARE, mage.cards.g.GravebreakerLamia.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gravebreaker Lamia", "1643*", Rarity.RARE, mage.cards.g.GravebreakerLamia.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aura Shards", 1644, Rarity.RARE, mage.cards.a.AuraShards.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aura Shards", "1644*", Rarity.RARE, mage.cards.a.AuraShards.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiend Artisan", 1645, Rarity.MYTHIC, mage.cards.f.FiendArtisan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiend Artisan", "1645*", Rarity.MYTHIC, mage.cards.f.FiendArtisan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karador, Ghost Chieftain", 1646, Rarity.MYTHIC, mage.cards.k.KaradorGhostChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karador, Ghost Chieftain", "1646*", Rarity.MYTHIC, mage.cards.k.KaradorGhostChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 1647, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 1648, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 1649, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1650, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 1651, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 1652, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 1653, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 1654, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 1655, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 1656, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Consecrated Sphinx", 1657, Rarity.MYTHIC, mage.cards.c.ConsecratedSphinx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chaotic Goo", 1658, Rarity.RARE, mage.cards.c.ChaoticGoo.class));
        cards.add(new SetCardInfo("Kiki-Jiki, Mirror Breaker", 1659, Rarity.MYTHIC, mage.cards.k.KikiJikiMirrorBreaker.class));
        cards.add(new SetCardInfo("Meteor Golem", 1660, Rarity.RARE, mage.cards.m.MeteorGolem.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wurmcoil Engine", 1661, Rarity.MYTHIC, mage.cards.w.WurmcoilEngine.class));
        cards.add(new SetCardInfo("Lightning Greaves", 1662, Rarity.RARE, mage.cards.l.LightningGreaves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skullclamp", 1663, Rarity.RARE, mage.cards.s.Skullclamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 1664, Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thought Vessel", 1665, Rarity.RARE, mage.cards.t.ThoughtVessel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 1666, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aetherize", 1667, Rarity.RARE, mage.cards.a.Aetherize.class));
        cards.add(new SetCardInfo("Drown in Dreams", 1668, Rarity.RARE, mage.cards.d.DrownInDreams.class));
        cards.add(new SetCardInfo("Psychic Corrosion", 1669, Rarity.RARE, mage.cards.p.PsychicCorrosion.class));
        cards.add(new SetCardInfo("Visions of Beyond", 1670, Rarity.RARE, mage.cards.v.VisionsOfBeyond.class));
        cards.add(new SetCardInfo("Time Sieve", 1671, Rarity.RARE, mage.cards.t.TimeSieve.class));
        cards.add(new SetCardInfo("Prodigal Sorcerer", 1672, Rarity.RARE, mage.cards.p.ProdigalSorcerer.class));
        cards.add(new SetCardInfo("Buried Alive", 1673, Rarity.RARE, mage.cards.b.BuriedAlive.class));
        cards.add(new SetCardInfo("Dismember", 1674, Rarity.RARE, mage.cards.d.Dismember.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birds of Paradise", 1675, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birds of Paradise", "1675b", Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Three Visits", 1676, Rarity.RARE, mage.cards.t.ThreeVisits.class));
        cards.add(new SetCardInfo("Door to Nothingness", 1678, Rarity.RARE, mage.cards.d.DoorToNothingness.class));
        cards.add(new SetCardInfo("Ashnod's Altar", 1679, Rarity.RARE, mage.cards.a.AshnodsAltar.class));
        cards.add(new SetCardInfo("Dark Depths", 1680, Rarity.MYTHIC, mage.cards.d.DarkDepths.class));
        cards.add(new SetCardInfo("Reya Dawnbringer", 1682, Rarity.RARE, mage.cards.r.ReyaDawnbringer.class));
        cards.add(new SetCardInfo("Orvar, the All-Form", 1683, Rarity.MYTHIC, mage.cards.o.OrvarTheAllForm.class));
        cards.add(new SetCardInfo("Drana, the Last Bloodchief", 1684, Rarity.MYTHIC, mage.cards.d.DranaTheLastBloodchief.class));
        cards.add(new SetCardInfo("Lavinia, Azorius Renegade", 1685, Rarity.RARE, mage.cards.l.LaviniaAzoriusRenegade.class));
        cards.add(new SetCardInfo("Omnath, Locus of Creation", 1686, Rarity.MYTHIC, mage.cards.o.OmnathLocusOfCreation.class));
        cards.add(new SetCardInfo("Kalitas, Traitor of Ghet", 1687, Rarity.MYTHIC, mage.cards.k.KalitasTraitorOfGhet.class));
        cards.add(new SetCardInfo("Magda, Brazen Outlaw", 1688, Rarity.RARE, mage.cards.m.MagdaBrazenOutlaw.class));
        cards.add(new SetCardInfo("Dack Fayden", 1689, Rarity.MYTHIC, mage.cards.d.DackFayden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Greasefang, Okiba Boss", 1690, Rarity.RARE, mage.cards.g.GreasefangOkibaBoss.class));
        cards.add(new SetCardInfo("Teferi's Protection", 1691, Rarity.RARE, mage.cards.t.TeferisProtection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eladamri's Vineyard", 1692, Rarity.RARE, mage.cards.e.EladamrisVineyard.class));
        cards.add(new SetCardInfo("Greater Good", 1693, Rarity.RARE, mage.cards.g.GreaterGood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inkshield", 1694, Rarity.RARE, mage.cards.i.Inkshield.class));
        cards.add(new SetCardInfo("Ruhan of the Fomori", 1695, Rarity.MYTHIC, mage.cards.r.RuhanOfTheFomori.class));
        cards.add(new SetCardInfo("Sol Ring", 1696, Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 1697, Rarity.RARE, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sorin Markov", 1698, Rarity.RARE, mage.cards.s.SorinMarkov.class));
        cards.add(new SetCardInfo("Huatli, Radiant Champion", 1699, Rarity.MYTHIC, mage.cards.h.HuatliRadiantChampion.class));
        cards.add(new SetCardInfo("Kiora, Behemoth Beckoner", 1700, Rarity.RARE, mage.cards.k.KioraBehemothBeckoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tezzeret, Master of the Bridge", 1701, Rarity.MYTHIC, mage.cards.t.TezzeretMasterOfTheBridge.class));
        cards.add(new SetCardInfo("Vraska, Golgari Queen", 1702, Rarity.MYTHIC, mage.cards.v.VraskaGolgariQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jaxis, the Troublemaker", 1703, Rarity.RARE, mage.cards.j.JaxisTheTroublemaker.class));
        cards.add(new SetCardInfo("Coffin Queen", 1704, Rarity.RARE, mage.cards.c.CoffinQueen.class));
        cards.add(new SetCardInfo("Goblin King", 1705, Rarity.RARE, mage.cards.g.GoblinKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Professional Face-Breaker", 1706, Rarity.RARE, mage.cards.p.ProfessionalFaceBreaker.class));
        cards.add(new SetCardInfo("Rankle, Master of Pranks", 1707, Rarity.MYTHIC, mage.cards.r.RankleMasterOfPranks.class));
        cards.add(new SetCardInfo("Soul Warden", 1708, Rarity.RARE, mage.cards.s.SoulWarden.class));
        cards.add(new SetCardInfo("Shivan Dragon", 1709, Rarity.RARE, mage.cards.s.ShivanDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elves of Deep Shadow", 1710, Rarity.RARE, mage.cards.e.ElvesOfDeepShadow.class));
        cards.add(new SetCardInfo("Good-Fortune Unicorn", 1711, Rarity.RARE, mage.cards.g.GoodFortuneUnicorn.class));
        cards.add(new SetCardInfo("Coat of Arms", 1712, Rarity.RARE, mage.cards.c.CoatOfArms.class));
        cards.add(new SetCardInfo("Dictate of Erebos", 1713, Rarity.RARE, mage.cards.d.DictateOfErebos.class));
        cards.add(new SetCardInfo("Fecundity", 1714, Rarity.RARE, mage.cards.f.Fecundity.class));
        cards.add(new SetCardInfo("Mayhem Devil", 1715, Rarity.RARE, mage.cards.m.MayhemDevil.class));
        cards.add(new SetCardInfo("Moldervine Reclamation", 1716, Rarity.RARE, mage.cards.m.MoldervineReclamation.class));
        cards.add(new SetCardInfo("Prossh, Skyraider of Kher", 1717, Rarity.MYTHIC, mage.cards.p.ProsshSkyraiderOfKher.class));
        cards.add(new SetCardInfo("Back to Basics", 1718, Rarity.RARE, mage.cards.b.BackToBasics.class));
        cards.add(new SetCardInfo("Preordain", 1719, Rarity.RARE, mage.cards.p.Preordain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sphinx of the Second Sun", 1720, Rarity.MYTHIC, mage.cards.s.SphinxOfTheSecondSun.class));
        cards.add(new SetCardInfo("Teferi's Ageless Insight", 1721, Rarity.RARE, mage.cards.t.TeferisAgelessInsight.class));
        cards.add(new SetCardInfo("Captain America, First Avenger", 1726, Rarity.MYTHIC, mage.cards.c.CaptainAmericaFirstAvenger.class));
        cards.add(new SetCardInfo("Sigarda's Aid", 1727, Rarity.RARE, mage.cards.s.SigardasAid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flawless Maneuver", 1728, Rarity.RARE, mage.cards.f.FlawlessManeuver.class));
        cards.add(new SetCardInfo("In the Trenches", 1729, Rarity.MYTHIC, mage.cards.i.InTheTrenches.class));
        cards.add(new SetCardInfo("Sword of War and Peace", 1730, Rarity.MYTHIC, mage.cards.s.SwordOfWarAndPeace.class));
        cards.add(new SetCardInfo("Iron Man, Titan of Innovation", 1731, Rarity.MYTHIC, mage.cards.i.IronManTitanOfInnovation.class));
        cards.add(new SetCardInfo("Galvanic Blast", 1732, Rarity.RARE, mage.cards.g.GalvanicBlast.class));
        cards.add(new SetCardInfo("Commander's Plate", 1733, Rarity.MYTHIC, mage.cards.c.CommandersPlate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 1734, Rarity.RARE, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inventors' Fair", 1735, Rarity.RARE, mage.cards.i.InventorsFair.class));
        cards.add(new SetCardInfo("Wolverine, Best There Is", 1737, Rarity.MYTHIC, mage.cards.w.WolverineBestThereIs.class));
        cards.add(new SetCardInfo("Berserk", 1738, Rarity.MYTHIC, mage.cards.b.Berserk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rite of Passage", 1739, Rarity.RARE, mage.cards.r.RiteOfPassage.class));
        cards.add(new SetCardInfo("Rhythm of the Wild", 1740, Rarity.RARE, mage.cards.r.RhythmOfTheWild.class));
        cards.add(new SetCardInfo("The Ozolith", 1741, Rarity.RARE, mage.cards.t.TheOzolith.class));
        cards.add(new SetCardInfo("Storm, Force of Nature", 1742, Rarity.MYTHIC, mage.cards.s.StormForceOfNature.class));
        cards.add(new SetCardInfo("Lightning Bolt", 1743, Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeska's Will", 1744, Rarity.RARE, mage.cards.j.JeskasWill.class));
        cards.add(new SetCardInfo("Ice Storm", 1745, Rarity.RARE, mage.cards.i.IceStorm.class));
        cards.add(new SetCardInfo("Manamorphose", 1746, Rarity.RARE, mage.cards.m.Manamorphose.class));
        cards.add(new SetCardInfo("Black Panther, Wakandan King", 1747, Rarity.MYTHIC, mage.cards.b.BlackPantherWakandanKing.class));
        cards.add(new SetCardInfo("Secure the Wastes", 1748, Rarity.RARE, mage.cards.s.SecureTheWastes.class));
        cards.add(new SetCardInfo("Primal Vigor", 1749, Rarity.RARE, mage.cards.p.PrimalVigor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Heroic Intervention", 1750, Rarity.RARE, mage.cards.h.HeroicIntervention.class));
        cards.add(new SetCardInfo("Karn's Bastion", 1751, Rarity.RARE, mage.cards.k.KarnsBastion.class));
        cards.add(new SetCardInfo("Phyrexian Metamorph", 1758, Rarity.RARE, mage.cards.p.PhyrexianMetamorph.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cauldron Familiar", 1759, Rarity.RARE, mage.cards.c.CauldronFamiliar.class));
        cards.add(new SetCardInfo("Dauthi Voidwalker", 1760, Rarity.RARE, mage.cards.d.DauthiVoidwalker.class));
        cards.add(new SetCardInfo("Magus of the Moon", 1761, Rarity.RARE, mage.cards.m.MagusOfTheMoon.class));
        cards.add(new SetCardInfo("Witch's Oven", 1762, Rarity.RARE, mage.cards.w.WitchsOven.class));
        cards.add(new SetCardInfo("Doom Whisperer", 1763, Rarity.MYTHIC, mage.cards.d.DoomWhisperer.class));
        cards.add(new SetCardInfo("Ravenous Chupacabra", 1764, Rarity.RARE, mage.cards.r.RavenousChupacabra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Koma, Cosmos Serpent", 1765, Rarity.MYTHIC, mage.cards.k.KomaCosmosSerpent.class));
        cards.add(new SetCardInfo("Mazirek, Kraul Death Priest", 1766, Rarity.MYTHIC, mage.cards.m.MazirekKraulDeathPriest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Uril, the Miststalker", 1767, Rarity.MYTHIC, mage.cards.u.UrilTheMiststalker.class));
        cards.add(new SetCardInfo("Careful Study", 1768, Rarity.RARE, mage.cards.c.CarefulStudy.class));
        cards.add(new SetCardInfo("Living End", 1769, Rarity.MYTHIC, mage.cards.l.LivingEnd.class));
        cards.add(new SetCardInfo("Eladamri's Call", 1770, Rarity.RARE, mage.cards.e.EladamrisCall.class));
        cards.add(new SetCardInfo("Boros Charm", 1771, Rarity.RARE, mage.cards.b.BorosCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unlicensed Hearse", 1772, Rarity.RARE, mage.cards.u.UnlicensedHearse.class));
        cards.add(new SetCardInfo("The Mimeoplasm", 1773, Rarity.RARE, mage.cards.t.TheMimeoplasm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trickbind", 1774, Rarity.RARE, mage.cards.t.Trickbind.class));
        cards.add(new SetCardInfo("Windfall", 1775, Rarity.RARE, mage.cards.w.Windfall.class));
        cards.add(new SetCardInfo("Incarnation Technique", 1776, Rarity.RARE, mage.cards.i.IncarnationTechnique.class));
        cards.add(new SetCardInfo("Pernicious Deed", 1777, Rarity.RARE, mage.cards.p.PerniciousDeed.class));
        cards.add(new SetCardInfo("Fell the Mighty", 1778, Rarity.RARE, mage.cards.f.FellTheMighty.class));
        cards.add(new SetCardInfo("Faithless Looting", 1779, Rarity.RARE, mage.cards.f.FaithlessLooting.class));
        cards.add(new SetCardInfo("Goldspan Dragon", 1780, Rarity.MYTHIC, mage.cards.g.GoldspanDragon.class));
        cards.add(new SetCardInfo("Reality Shift", 1781, Rarity.RARE, mage.cards.r.RealityShift.class));
        cards.add(new SetCardInfo("Monster Manual", 1782, Rarity.RARE, mage.cards.m.MonsterManual.class));
        cards.add(new SetCardInfo("Ponder", 1783, Rarity.RARE, mage.cards.p.Ponder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Acererak the Archlich", 1784, Rarity.MYTHIC, mage.cards.a.AcererakTheArchlich.class));
        cards.add(new SetCardInfo("Xanathar, Guild Kingpin", 1785, Rarity.MYTHIC, mage.cards.x.XanatharGuildKingpin.class));
        cards.add(new SetCardInfo("Bribery", 1786, Rarity.RARE, mage.cards.b.Bribery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stifle", 1787, Rarity.RARE, mage.cards.s.Stifle.class));
        cards.add(new SetCardInfo("Delay", 1788, Rarity.RARE, mage.cards.d.Delay.class));
        cards.add(new SetCardInfo("Blood Money", 1789, Rarity.MYTHIC, mage.cards.b.BloodMoney.class));
        cards.add(new SetCardInfo("Drown in the Loch", 1790, Rarity.RARE, mage.cards.d.DrownInTheLoch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karazikar, the Eye Tyrant", 1791, Rarity.MYTHIC, mage.cards.k.KarazikarTheEyeTyrant.class));
        cards.add(new SetCardInfo("Snuff Out", 1792, Rarity.RARE, mage.cards.s.SnuffOut.class));
        cards.add(new SetCardInfo("Defile", 1793, Rarity.RARE, mage.cards.d.Defile.class));
        cards.add(new SetCardInfo("Oubliette", 1794, Rarity.RARE, mage.cards.o.Oubliette.class));
        cards.add(new SetCardInfo("Fling", 1795, Rarity.RARE, mage.cards.f.Fling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fire Covenant", 1796, Rarity.RARE, mage.cards.f.FireCovenant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Astarion, the Decadent", 1797, Rarity.RARE, mage.cards.a.AstarionTheDecadent.class));
        cards.add(new SetCardInfo("Exquisite Blood", 1798, Rarity.RARE, mage.cards.e.ExquisiteBlood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sanguine Bond", 1799, Rarity.RARE, mage.cards.s.SanguineBond.class));
        cards.add(new SetCardInfo("Anguished Unmaking", 1800, Rarity.RARE, mage.cards.a.AnguishedUnmaking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mortify", 1801, Rarity.RARE, mage.cards.m.Mortify.class));
        cards.add(new SetCardInfo("Karlach, Fury of Avernus", 1802, Rarity.MYTHIC, mage.cards.k.KarlachFuryOfAvernus.class));
        cards.add(new SetCardInfo("City on Fire", 1803, Rarity.RARE, mage.cards.c.CityOnFire.class));
        cards.add(new SetCardInfo("Stranglehold", 1804, Rarity.RARE, mage.cards.s.Stranglehold.class));
        cards.add(new SetCardInfo("Thrill of Possibility", 1805, Rarity.RARE, mage.cards.t.ThrillOfPossibility.class));
        cards.add(new SetCardInfo("Dolmen Gate", 1806, Rarity.RARE, mage.cards.d.DolmenGate.class));
        cards.add(new SetCardInfo("Kardur, Doomscourge", 1807, Rarity.MYTHIC, mage.cards.k.KardurDoomscourge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kardur, Doomscourge", "1807b", Rarity.MYTHIC, mage.cards.k.KardurDoomscourge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phyrexian Reclamation", 1808, Rarity.RARE, mage.cards.p.PhyrexianReclamation.class));
        cards.add(new SetCardInfo("Varragoth, Bloodsky Sire", 1809, Rarity.RARE, mage.cards.v.VarragothBloodskySire.class));
        cards.add(new SetCardInfo("Twinflame", 1810, Rarity.RARE, mage.cards.t.Twinflame.class));
        cards.add(new SetCardInfo("Genesis Chamber", 1811, Rarity.RARE, mage.cards.g.GenesisChamber.class));
        cards.add(new SetCardInfo("Mana Geyser", 1821, Rarity.RARE, mage.cards.m.ManaGeyser.class));
        cards.add(new SetCardInfo("Lightning Bolt", 1822, Rarity.RARE, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fierce Guardianship", 1823, Rarity.RARE, mage.cards.f.FierceGuardianship.class));
        cards.add(new SetCardInfo("Delayed Blast Fireball", 1824, Rarity.RARE, mage.cards.d.DelayedBlastFireball.class));
        cards.add(new SetCardInfo("Jace, the Mind Sculptor", 8001, Rarity.MYTHIC, mage.cards.j.JaceTheMindSculptor.class));
        cards.add(new SetCardInfo("Doom Blade", 9990, Rarity.RARE, mage.cards.d.DoomBlade.class));
        cards.add(new SetCardInfo("Massacre", 9991, Rarity.RARE, mage.cards.m.Massacre.class));
        cards.add(new SetCardInfo("Torment of Hailfire", 9992, Rarity.RARE, mage.cards.t.TormentOfHailfire.class));
        cards.add(new SetCardInfo("Ruination", 9993, Rarity.RARE, mage.cards.r.Ruination.class));
        cards.add(new SetCardInfo("Mogis, God of Slaughter", 9994, Rarity.RARE, mage.cards.m.MogisGodOfSlaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Garruk, Caller of Beasts", 9995, Rarity.MYTHIC, mage.cards.g.GarrukCallerOfBeasts.class));
        cards.add(new SetCardInfo("Rograkh, Son of Rohgahh", 9996, Rarity.RARE, mage.cards.r.RograkhSonOfRohgahh.class));
        cards.add(new SetCardInfo("Geralf's Messenger", 9997, Rarity.RARE, mage.cards.g.GeralfsMessenger.class));
        cards.add(new SetCardInfo("Empress Galina", 9998, Rarity.RARE, mage.cards.e.EmpressGalina.class));
        cards.add(new SetCardInfo("Sisay, Weatherlight Captain", 9999, Rarity.RARE, mage.cards.s.SisayWeatherlightCaptain.class, NON_FULL_USE_VARIOUS));
    }
}
