package mage.sets;

import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.CardType;
import mage.constants.Rarity;
import mage.constants.SetType;
import mage.util.RandomUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @author TheElk801
 */
public class RavnicaRemastered extends ExpansionSet {

    private static final RavnicaRemastered instance = new RavnicaRemastered();

    public static RavnicaRemastered getInstance() {
        return instance;
    }

    private RavnicaRemastered() {
        super("Ravnica Remastered", "RVR", ExpansionSet.buildDate(2024, 1, 12), SetType.SUPPLEMENTAL);
        this.hasBoosters = true;
        this.hasBasicLands = false;
        this.maxCardNumberInBooster = 291;
        this.numBoosterCommon = 10; // Retro frame variants not yet implemented for booster generation
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 7; // 60 rares not including the mana-fixing slot, and 20 mythics
        this.numBoosterSpecial = 1; // mana-fixing slot
        // reference: https://magic.wizards.com/en/news/feature/collecting-ravnica-remastered

        cards.add(new SetCardInfo("Act of Treason", 99, Rarity.COMMON, mage.cards.a.ActOfTreason.class));
        cards.add(new SetCardInfo("Aetherize", 448, Rarity.UNCOMMON, mage.cards.a.Aetherize.class));
        cards.add(new SetCardInfo("Aetherplasm", 34, Rarity.UNCOMMON, mage.cards.a.Aetherplasm.class));
        cards.add(new SetCardInfo("Angelic Exaltation", 2, Rarity.UNCOMMON, mage.cards.a.AngelicExaltation.class));
        cards.add(new SetCardInfo("Arboreal Grazer", 131, Rarity.COMMON, mage.cards.a.ArborealGrazer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arboreal Grazer", 343, Rarity.COMMON, mage.cards.a.ArborealGrazer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arclight Phoenix", 100, Rarity.RARE, mage.cards.a.ArclightPhoenix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arclight Phoenix", 331, Rarity.RARE, mage.cards.a.ArclightPhoenix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arclight Phoenix", 427, Rarity.RARE, mage.cards.a.ArclightPhoenix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armory Guard", 3, Rarity.COMMON, mage.cards.a.ArmoryGuard.class));
        cards.add(new SetCardInfo("Arrester's Zeal", 4, Rarity.COMMON, mage.cards.a.ArrestersZeal.class));
        cards.add(new SetCardInfo("Assemble the Legion", 163, Rarity.RARE, mage.cards.a.AssembleTheLegion.class));
        cards.add(new SetCardInfo("Assure // Assemble", 248, Rarity.RARE, mage.cards.a.AssureAssemble.class));
        cards.add(new SetCardInfo("Aurelia, Exemplar of Justice", 164, Rarity.MYTHIC, mage.cards.a.AureliaExemplarOfJustice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aurelia, Exemplar of Justice", 356, Rarity.MYTHIC, mage.cards.a.AureliaExemplarOfJustice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aurelia, Exemplar of Justice", 436, Rarity.MYTHIC, mage.cards.a.AureliaExemplarOfJustice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azorius Arrester", 5, Rarity.COMMON, mage.cards.a.AzoriusArrester.class));
        cards.add(new SetCardInfo("Azorius Guildgate", 272, Rarity.COMMON, mage.cards.a.AzoriusGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azorius Guildgate", 396, Rarity.COMMON, mage.cards.a.AzoriusGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azorius Guildmage", 165, Rarity.UNCOMMON, mage.cards.a.AzoriusGuildmage.class));
        cards.add(new SetCardInfo("Azorius Justiciar", 6, Rarity.UNCOMMON, mage.cards.a.AzoriusJusticiar.class));
        cards.add(new SetCardInfo("Azorius Signet", 250, Rarity.UNCOMMON, mage.cards.a.AzoriusSignet.class));
        cards.add(new SetCardInfo("Balustrade Spy", 66, Rarity.COMMON, mage.cards.b.BalustradeSpy.class));
        cards.add(new SetCardInfo("Band Together", 132, Rarity.COMMON, mage.cards.b.BandTogether.class));
        cards.add(new SetCardInfo("Basilica Guards", 7, Rarity.COMMON, mage.cards.b.BasilicaGuards.class));
        cards.add(new SetCardInfo("Bedeck // Bedazzle", 244, Rarity.RARE, mage.cards.b.BedeckBedazzle.class));
        cards.add(new SetCardInfo("Birds of Paradise", 133, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birds of Paradise", 344, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Birds of Paradise", 432, Rarity.RARE, mage.cards.b.BirdsOfParadise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blade Juggler", 67, Rarity.COMMON, mage.cards.b.BladeJuggler.class));
        cards.add(new SetCardInfo("Bladebrand", 68, Rarity.COMMON, mage.cards.b.Bladebrand.class));
        cards.add(new SetCardInfo("Blazing Archon", 302, Rarity.RARE, mage.cards.b.BlazingArchon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blazing Archon", 8, Rarity.RARE, mage.cards.b.BlazingArchon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blind Hunter", 166, Rarity.COMMON, mage.cards.b.BlindHunter.class));
        cards.add(new SetCardInfo("Blind Obedience", 303, Rarity.RARE, mage.cards.b.BlindObedience.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blind Obedience", 9, Rarity.RARE, mage.cards.b.BlindObedience.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blood Crypt", 273, Rarity.RARE, mage.cards.b.BloodCrypt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blood Crypt", 292, Rarity.RARE, mage.cards.b.BloodCrypt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blood Crypt", 397, Rarity.RARE, mage.cards.b.BloodCrypt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodfray Giant", 101, Rarity.UNCOMMON, mage.cards.b.BloodfrayGiant.class));
        cards.add(new SetCardInfo("Bomber Corps", 102, Rarity.COMMON, mage.cards.b.BomberCorps.class));
        cards.add(new SetCardInfo("Borborygmos Enraged", 167, Rarity.RARE, mage.cards.b.BorborygmosEnraged.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Borborygmos Enraged", 357, Rarity.RARE, mage.cards.b.BorborygmosEnraged.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boros Elite", 10, Rarity.COMMON, mage.cards.b.BorosElite.class));
        cards.add(new SetCardInfo("Boros Guildgate", 274, Rarity.COMMON, mage.cards.b.BorosGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boros Guildgate", 398, Rarity.COMMON, mage.cards.b.BorosGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boros Guildmage", 168, Rarity.UNCOMMON, mage.cards.b.BorosGuildmage.class));
        cards.add(new SetCardInfo("Boros Signet", 251, Rarity.UNCOMMON, mage.cards.b.BorosSignet.class));
        cards.add(new SetCardInfo("Bottled Cloister", 252, Rarity.RARE, mage.cards.b.BottledCloister.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bottled Cloister", 389, Rarity.RARE, mage.cards.b.BottledCloister.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Breeding Pool", 275, Rarity.RARE, mage.cards.b.BreedingPool.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Breeding Pool", 293, Rarity.RARE, mage.cards.b.BreedingPool.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Breeding Pool", 399, Rarity.RARE, mage.cards.b.BreedingPool.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bruvac the Grandiloquent", 309, Rarity.MYTHIC, mage.cards.b.BruvacTheGrandiloquent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bruvac the Grandiloquent", 35, Rarity.MYTHIC, mage.cards.b.BruvacTheGrandiloquent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bruvac the Grandiloquent", 418, Rarity.MYTHIC, mage.cards.b.BruvacTheGrandiloquent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bulwark Giant", 11, Rarity.COMMON, mage.cards.b.BulwarkGiant.class));
        cards.add(new SetCardInfo("Burglar Rat", 69, Rarity.COMMON, mage.cards.b.BurglarRat.class));
        cards.add(new SetCardInfo("Burn Bright", 103, Rarity.COMMON, mage.cards.b.BurnBright.class));
        cards.add(new SetCardInfo("Burning Prophet", 104, Rarity.COMMON, mage.cards.b.BurningProphet.class));
        cards.add(new SetCardInfo("Burning-Tree Vandal", 105, Rarity.COMMON, mage.cards.b.BurningTreeVandal.class));
        cards.add(new SetCardInfo("Call of the Conclave", 169, Rarity.COMMON, mage.cards.c.CallOfTheConclave.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Call of the Conclave", 358, Rarity.COMMON, mage.cards.c.CallOfTheConclave.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Carom", 12, Rarity.COMMON, mage.cards.c.Carom.class));
        cards.add(new SetCardInfo("Cartel Aristocrat", 170, Rarity.UNCOMMON, mage.cards.c.CartelAristocrat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cartel Aristocrat", 359, Rarity.UNCOMMON, mage.cards.c.CartelAristocrat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cerulean Sphinx", 36, Rarity.UNCOMMON, mage.cards.c.CeruleanSphinx.class));
        cards.add(new SetCardInfo("Chord of Calling", 134, Rarity.RARE, mage.cards.c.ChordOfCalling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chord of Calling", 345, Rarity.RARE, mage.cards.c.ChordOfCalling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chromatic Lantern", 253, Rarity.RARE, mage.cards.c.ChromaticLantern.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chromatic Lantern", 390, Rarity.RARE, mage.cards.c.ChromaticLantern.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chromatic Lantern", 442, Rarity.RARE, mage.cards.c.ChromaticLantern.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cindervines", 171, Rarity.RARE, mage.cards.c.Cindervines.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cindervines", 360, Rarity.RARE, mage.cards.c.Cindervines.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Civic Saber", 254, Rarity.UNCOMMON, mage.cards.c.CivicSaber.class));
        cards.add(new SetCardInfo("Cloudfin Raptor", 310, Rarity.COMMON, mage.cards.c.CloudfinRaptor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cloudfin Raptor", 37, Rarity.COMMON, mage.cards.c.CloudfinRaptor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cloudstone Curio", 255, Rarity.MYTHIC, mage.cards.c.CloudstoneCurio.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cloudstone Curio", 391, Rarity.MYTHIC, mage.cards.c.CloudstoneCurio.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cloudstone Curio", 443, Rarity.MYTHIC, mage.cards.c.CloudstoneCurio.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coiling Oracle", 172, Rarity.COMMON, mage.cards.c.CoilingOracle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coiling Oracle", 361, Rarity.COMMON, mage.cards.c.CoilingOracle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Compulsive Research", 311, Rarity.COMMON, mage.cards.c.CompulsiveResearch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Compulsive Research", 38, Rarity.COMMON, mage.cards.c.CompulsiveResearch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Conclave Cavalier", 173, Rarity.UNCOMMON, mage.cards.c.ConclaveCavalier.class));
        cards.add(new SetCardInfo("Conclave Equenaut", 13, Rarity.COMMON, mage.cards.c.ConclaveEquenaut.class));
        cards.add(new SetCardInfo("Condemn", 14, Rarity.UNCOMMON, mage.cards.c.Condemn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Condemn", 304, Rarity.UNCOMMON, mage.cards.c.Condemn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Connive // Concoct", 242, Rarity.RARE, mage.cards.c.ConniveConcoct.class));
        cards.add(new SetCardInfo("Copy Enchantment", 312, Rarity.RARE, mage.cards.c.CopyEnchantment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Copy Enchantment", 39, Rarity.RARE, mage.cards.c.CopyEnchantment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crackling Drake", 174, Rarity.UNCOMMON, mage.cards.c.CracklingDrake.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crackling Drake", 362, Rarity.UNCOMMON, mage.cards.c.CracklingDrake.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Creeping Chill", 453, Rarity.UNCOMMON, mage.cards.c.CreepingChill.class));
        cards.add(new SetCardInfo("Crocanura", 135, Rarity.COMMON, mage.cards.c.Crocanura.class));
        cards.add(new SetCardInfo("Crypt Ghast", 322, Rarity.RARE, mage.cards.c.CryptGhast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crypt Ghast", 423, Rarity.RARE, mage.cards.c.CryptGhast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crypt Ghast", 70, Rarity.RARE, mage.cards.c.CryptGhast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cyclonic Rift", 313, Rarity.MYTHIC, mage.cards.c.CyclonicRift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cyclonic Rift", 40, Rarity.MYTHIC, mage.cards.c.CyclonicRift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cyclonic Rift", 419, Rarity.MYTHIC, mage.cards.c.CyclonicRift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dark Confidant", 323, Rarity.MYTHIC, mage.cards.d.DarkConfidant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dark Confidant", 71, Rarity.MYTHIC, mage.cards.d.DarkConfidant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Darkblast", 454, Rarity.UNCOMMON, mage.cards.d.Darkblast.class));
        cards.add(new SetCardInfo("Deathrite Shaman", 175, Rarity.RARE, mage.cards.d.DeathriteShaman.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deathrite Shaman", 363, Rarity.RARE, mage.cards.d.DeathriteShaman.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Debt to the Deathless", 176, Rarity.UNCOMMON, mage.cards.d.DebtToTheDeathless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Debt to the Deathless", 364, Rarity.UNCOMMON, mage.cards.d.DebtToTheDeathless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Debtors' Transport", 72, Rarity.COMMON, mage.cards.d.DebtorsTransport.class));
        cards.add(new SetCardInfo("Demolish", 106, Rarity.COMMON, mage.cards.d.Demolish.class));
        cards.add(new SetCardInfo("Demonfire", 107, Rarity.UNCOMMON, mage.cards.d.Demonfire.class));
        cards.add(new SetCardInfo("Deputy of Acquittals", 177, Rarity.COMMON, mage.cards.d.DeputyOfAcquittals.class));
        cards.add(new SetCardInfo("Devouring Light", 15, Rarity.UNCOMMON, mage.cards.d.DevouringLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Devouring Light", 305, Rarity.UNCOMMON, mage.cards.d.DevouringLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dimir Guildgate", 276, Rarity.COMMON, mage.cards.d.DimirGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dimir Guildgate", 400, Rarity.COMMON, mage.cards.d.DimirGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dimir Guildmage", 178, Rarity.UNCOMMON, mage.cards.d.DimirGuildmage.class));
        cards.add(new SetCardInfo("Dimir House Guard", 324, Rarity.COMMON, mage.cards.d.DimirHouseGuard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dimir House Guard", 73, Rarity.COMMON, mage.cards.d.DimirHouseGuard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dimir Signet", 256, Rarity.UNCOMMON, mage.cards.d.DimirSignet.class));
        cards.add(new SetCardInfo("Disembowel", 74, Rarity.COMMON, mage.cards.d.Disembowel.class));
        cards.add(new SetCardInfo("Divine Visitation", 16, Rarity.MYTHIC, mage.cards.d.DivineVisitation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Divine Visitation", 306, Rarity.MYTHIC, mage.cards.d.DivineVisitation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Divine Visitation", 416, Rarity.MYTHIC, mage.cards.d.DivineVisitation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dogpile", 108, Rarity.COMMON, mage.cards.d.Dogpile.class));
        cards.add(new SetCardInfo("Domri Rade", 179, Rarity.MYTHIC, mage.cards.d.DomriRade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Domri Rade", 444, Rarity.MYTHIC, mage.cards.d.DomriRade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Downsize", 41, Rarity.COMMON, mage.cards.d.Downsize.class));
        cards.add(new SetCardInfo("Dreadbore", 180, Rarity.RARE, mage.cards.d.Dreadbore.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadbore", 365, Rarity.RARE, mage.cards.d.Dreadbore.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadmalkin", 75, Rarity.UNCOMMON, mage.cards.d.Dreadmalkin.class));
        cards.add(new SetCardInfo("Drift of Phantasms", 314, Rarity.COMMON, mage.cards.d.DriftOfPhantasms.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drift of Phantasms", 42, Rarity.COMMON, mage.cards.d.DriftOfPhantasms.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drudge Beetle", 136, Rarity.COMMON, mage.cards.d.DrudgeBeetle.class));
        cards.add(new SetCardInfo("Enter the Infinite", 449, Rarity.MYTHIC, mage.cards.e.EnterTheInfinite.class));
        cards.add(new SetCardInfo("Expansion // Explosion", 243, Rarity.RARE, mage.cards.e.ExpansionExplosion.class));
        cards.add(new SetCardInfo("Experiment One", 137, Rarity.UNCOMMON, mage.cards.e.ExperimentOne.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Experiment One", 346, Rarity.UNCOMMON, mage.cards.e.ExperimentOne.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eyes Everywhere", 43, Rarity.UNCOMMON, mage.cards.e.EyesEverywhere.class));
        cards.add(new SetCardInfo("Eyes in the Skies", 17, Rarity.COMMON, mage.cards.e.EyesInTheSkies.class));
        cards.add(new SetCardInfo("Faith's Fetters", 18, Rarity.COMMON, mage.cards.f.FaithsFetters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faith's Fetters", 307, Rarity.COMMON, mage.cards.f.FaithsFetters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Farseek", 138, Rarity.UNCOMMON, mage.cards.f.Farseek.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Farseek", 347, Rarity.UNCOMMON, mage.cards.f.Farseek.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fblthp, the Lost", 420, Rarity.RARE, mage.cards.f.FblthpTheLost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fblthp, the Lost", 44, Rarity.RARE, mage.cards.f.FblthpTheLost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Find // Finality", 245, Rarity.RARE, mage.cards.f.FindFinality.class));
        cards.add(new SetCardInfo("Fists of Ironwood", 139, Rarity.COMMON, mage.cards.f.FistsOfIronwood.class));
        cards.add(new SetCardInfo("Footlight Fiend", 181, Rarity.COMMON, mage.cards.f.FootlightFiend.class));
        cards.add(new SetCardInfo("Forced Adaptation", 140, Rarity.COMMON, mage.cards.f.ForcedAdaptation.class));
        cards.add(new SetCardInfo("Forced Landing", 141, Rarity.COMMON, mage.cards.f.ForcedLanding.class));
        cards.add(new SetCardInfo("Fresh-Faced Recruit", 182, Rarity.COMMON, mage.cards.f.FreshFacedRecruit.class));
        cards.add(new SetCardInfo("Frilled Mystic", 183, Rarity.UNCOMMON, mage.cards.f.FrilledMystic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frilled Mystic", 366, Rarity.UNCOMMON, mage.cards.f.FrilledMystic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fungal Rebirth", 142, Rarity.UNCOMMON, mage.cards.f.FungalRebirth.class));
        cards.add(new SetCardInfo("Gate Colossus", 257, Rarity.UNCOMMON, mage.cards.g.GateColossus.class));
        cards.add(new SetCardInfo("Gather Courage", 143, Rarity.COMMON, mage.cards.g.GatherCourage.class));
        cards.add(new SetCardInfo("Ghostway", 19, Rarity.RARE, mage.cards.g.Ghostway.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghostway", 308, Rarity.RARE, mage.cards.g.Ghostway.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gideon Blackblade", 20, Rarity.MYTHIC, mage.cards.g.GideonBlackblade.class));
        cards.add(new SetCardInfo("Gigantoplasm", 450, Rarity.RARE, mage.cards.g.Gigantoplasm.class));
        cards.add(new SetCardInfo("Glowspore Shaman", 184, Rarity.COMMON, mage.cards.g.GlowsporeShaman.class));
        cards.add(new SetCardInfo("Gobhobbler Rats", 185, Rarity.COMMON, mage.cards.g.GobhobblerRats.class));
        cards.add(new SetCardInfo("Goblin Electromancer", 186, Rarity.COMMON, mage.cards.g.GoblinElectromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Electromancer", 367, Rarity.COMMON, mage.cards.g.GoblinElectromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Godless Shrine", 277, Rarity.RARE, mage.cards.g.GodlessShrine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Godless Shrine", 294, Rarity.RARE, mage.cards.g.GodlessShrine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Godless Shrine", 401, Rarity.RARE, mage.cards.g.GodlessShrine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Golgari Findbroker", 187, Rarity.UNCOMMON, mage.cards.g.GolgariFindbroker.class));
        cards.add(new SetCardInfo("Golgari Grave-Troll", 144, Rarity.RARE, mage.cards.g.GolgariGraveTroll.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Golgari Grave-Troll", 348, Rarity.RARE, mage.cards.g.GolgariGraveTroll.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Golgari Guildgate", 278, Rarity.COMMON, mage.cards.g.GolgariGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Golgari Guildgate", 402, Rarity.COMMON, mage.cards.g.GolgariGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Golgari Guildmage", 188, Rarity.UNCOMMON, mage.cards.g.GolgariGuildmage.class));
        cards.add(new SetCardInfo("Golgari Signet", 258, Rarity.UNCOMMON, mage.cards.g.GolgariSignet.class));
        cards.add(new SetCardInfo("Golgari Thug", 325, Rarity.UNCOMMON, mage.cards.g.GolgariThug.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Golgari Thug", 76, Rarity.UNCOMMON, mage.cards.g.GolgariThug.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Greater Forgeling", 109, Rarity.COMMON, mage.cards.g.GreaterForgeling.class));
        cards.add(new SetCardInfo("Greater Mossdog", 145, Rarity.COMMON, mage.cards.g.GreaterMossdog.class));
        cards.add(new SetCardInfo("Gruul Guildgate", 279, Rarity.COMMON, mage.cards.g.GruulGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gruul Guildgate", 403, Rarity.COMMON, mage.cards.g.GruulGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gruul Guildmage", 189, Rarity.UNCOMMON, mage.cards.g.GruulGuildmage.class));
        cards.add(new SetCardInfo("Gruul Signet", 259, Rarity.UNCOMMON, mage.cards.g.GruulSignet.class));
        cards.add(new SetCardInfo("Guardian Project", 146, Rarity.MYTHIC, mage.cards.g.GuardianProject.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guardian Project", 349, Rarity.MYTHIC, mage.cards.g.GuardianProject.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guardian Project", 433, Rarity.MYTHIC, mage.cards.g.GuardianProject.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guttersnipe", 110, Rarity.UNCOMMON, mage.cards.g.Guttersnipe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guttersnipe", 332, Rarity.UNCOMMON, mage.cards.g.Guttersnipe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hallowed Fountain", 280, Rarity.RARE, mage.cards.h.HallowedFountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hallowed Fountain", 295, Rarity.RARE, mage.cards.h.HallowedFountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hallowed Fountain", 404, Rarity.RARE, mage.cards.h.HallowedFountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Helium Squirter", 45, Rarity.COMMON, mage.cards.h.HeliumSquirter.class));
        cards.add(new SetCardInfo("Hellkite Tyrant", 111, Rarity.RARE, mage.cards.h.HellkiteTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hellkite Tyrant", 333, Rarity.RARE, mage.cards.h.HellkiteTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hellkite Tyrant", 428, Rarity.RARE, mage.cards.h.HellkiteTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Homing Lightning", 112, Rarity.UNCOMMON, mage.cards.h.HomingLightning.class));
        cards.add(new SetCardInfo("Horncaller's Chant", 147, Rarity.COMMON, mage.cards.h.HorncallersChant.class));
        cards.add(new SetCardInfo("Ilharg, the Raze-Boar", 113, Rarity.MYTHIC, mage.cards.i.IlhargTheRazeBoar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ilharg, the Raze-Boar", 334, Rarity.MYTHIC, mage.cards.i.IlhargTheRazeBoar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ilharg, the Raze-Boar", 429, Rarity.MYTHIC, mage.cards.i.IlhargTheRazeBoar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ill-Gotten Inheritance", 77, Rarity.COMMON, mage.cards.i.IllGottenInheritance.class));
        cards.add(new SetCardInfo("Illusionist's Bracers", 260, Rarity.RARE, mage.cards.i.IllusionistsBracers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Illusionist's Bracers", 392, Rarity.RARE, mage.cards.i.IllusionistsBracers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Infernal Tutor", 326, Rarity.RARE, mage.cards.i.InfernalTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Infernal Tutor", 78, Rarity.RARE, mage.cards.i.InfernalTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Charm", 190, Rarity.UNCOMMON, mage.cards.i.IzzetCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Charm", 368, Rarity.UNCOMMON, mage.cards.i.IzzetCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Guildgate", 281, Rarity.COMMON, mage.cards.i.IzzetGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Guildgate", 405, Rarity.COMMON, mage.cards.i.IzzetGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Guildmage", 191, Rarity.UNCOMMON, mage.cards.i.IzzetGuildmage.class));
        cards.add(new SetCardInfo("Izzet Signet", 261, Rarity.UNCOMMON, mage.cards.i.IzzetSignet.class));
        cards.add(new SetCardInfo("Judge's Familiar", 192, Rarity.COMMON, mage.cards.j.JudgesFamiliar.class));
        cards.add(new SetCardInfo("Junktroller", 262, Rarity.UNCOMMON, mage.cards.j.Junktroller.class));
        cards.add(new SetCardInfo("Karlov of the Ghost Council", 193, Rarity.MYTHIC, mage.cards.k.KarlovOfTheGhostCouncil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karlov of the Ghost Council", 369, Rarity.MYTHIC, mage.cards.k.KarlovOfTheGhostCouncil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karlov of the Ghost Council", 437, Rarity.MYTHIC, mage.cards.k.KarlovOfTheGhostCouncil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn's Bastion", 464, Rarity.RARE, mage.cards.k.KarnsBastion.class));
        cards.add(new SetCardInfo("Karn, the Great Creator", 1, Rarity.MYTHIC, mage.cards.k.KarnTheGreatCreator.class));
        cards.add(new SetCardInfo("Kasmina's Transmutation", 46, Rarity.COMMON, mage.cards.k.KasminasTransmutation.class));
        cards.add(new SetCardInfo("Kaya, Orzhov Usurper", 194, Rarity.RARE, mage.cards.k.KayaOrzhovUsurper.class));
        cards.add(new SetCardInfo("Keening Apparition", 21, Rarity.COMMON, mage.cards.k.KeeningApparition.class));
        cards.add(new SetCardInfo("Keymaster Rogue", 47, Rarity.COMMON, mage.cards.k.KeymasterRogue.class));
        cards.add(new SetCardInfo("Kiora's Dambreaker", 48, Rarity.COMMON, mage.cards.k.KiorasDambreaker.class));
        cards.add(new SetCardInfo("Krenko's Command", 115, Rarity.COMMON, mage.cards.k.KrenkosCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krenko's Command", 336, Rarity.COMMON, mage.cards.k.KrenkosCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krenko, Mob Boss", 114, Rarity.RARE, mage.cards.k.KrenkoMobBoss.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krenko, Mob Boss", 335, Rarity.RARE, mage.cards.k.KrenkoMobBoss.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krenko, Mob Boss", 430, Rarity.RARE, mage.cards.k.KrenkoMobBoss.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Last Gasp", 79, Rarity.COMMON, mage.cards.l.LastGasp.class));
        cards.add(new SetCardInfo("Lavinia, Azorius Renegade", 195, Rarity.RARE, mage.cards.l.LaviniaAzoriusRenegade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lavinia, Azorius Renegade", 370, Rarity.RARE, mage.cards.l.LaviniaAzoriusRenegade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lazav, the Multifarious", 196, Rarity.RARE, mage.cards.l.LazavTheMultifarious.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lazav, the Multifarious", 371, Rarity.RARE, mage.cards.l.LazavTheMultifarious.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leapfrog", 49, Rarity.COMMON, mage.cards.l.Leapfrog.class));
        cards.add(new SetCardInfo("Legion Warboss", 116, Rarity.RARE, mage.cards.l.LegionWarboss.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legion Warboss", 337, Rarity.RARE, mage.cards.l.LegionWarboss.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Life from the Loam", 148, Rarity.RARE, mage.cards.l.LifeFromTheLoam.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Life from the Loam", 350, Rarity.RARE, mage.cards.l.LifeFromTheLoam.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Life from the Loam", 434, Rarity.RARE, mage.cards.l.LifeFromTheLoam.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Light Up the Stage", 117, Rarity.UNCOMMON, mage.cards.l.LightUpTheStage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Light Up the Stage", 338, Rarity.UNCOMMON, mage.cards.l.LightUpTheStage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Helix", 197, Rarity.UNCOMMON, mage.cards.l.LightningHelix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Helix", 372, Rarity.UNCOMMON, mage.cards.l.LightningHelix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana, Dreadhorde General", 80, Rarity.MYTHIC, mage.cards.l.LilianaDreadhordeGeneral.class));
        cards.add(new SetCardInfo("Loaming Shaman", 149, Rarity.UNCOMMON, mage.cards.l.LoamingShaman.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Loaming Shaman", 351, Rarity.UNCOMMON, mage.cards.l.LoamingShaman.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of the Void", 327, Rarity.MYTHIC, mage.cards.l.LordOfTheVoid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of the Void", 424, Rarity.MYTHIC, mage.cards.l.LordOfTheVoid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of the Void", 81, Rarity.MYTHIC, mage.cards.l.LordOfTheVoid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Macabre Waltz", 82, Rarity.COMMON, mage.cards.m.MacabreWaltz.class));
        cards.add(new SetCardInfo("Magewright's Stone", 462, Rarity.UNCOMMON, mage.cards.m.MagewrightsStone.class));
        cards.add(new SetCardInfo("Makeshift Battalion", 22, Rarity.COMMON, mage.cards.m.MakeshiftBattalion.class));
        cards.add(new SetCardInfo("Massacre Girl", 328, Rarity.RARE, mage.cards.m.MassacreGirl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Massacre Girl", 425, Rarity.RARE, mage.cards.m.MassacreGirl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Massacre Girl", 83, Rarity.RARE, mage.cards.m.MassacreGirl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Master of Cruelties", 198, Rarity.MYTHIC, mage.cards.m.MasterOfCruelties.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Master of Cruelties", 373, Rarity.MYTHIC, mage.cards.m.MasterOfCruelties.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mausoleum Turnkey", 84, Rarity.UNCOMMON, mage.cards.m.MausoleumTurnkey.class));
        cards.add(new SetCardInfo("Mayhem Devil", 199, Rarity.UNCOMMON, mage.cards.m.MayhemDevil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mayhem Devil", 374, Rarity.UNCOMMON, mage.cards.m.MayhemDevil.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maze's End", 465, Rarity.MYTHIC, mage.cards.m.MazesEnd.class));
        cards.add(new SetCardInfo("Mephitic Vapors", 85, Rarity.COMMON, mage.cards.m.MephiticVapors.class));
        cards.add(new SetCardInfo("Merfolk of the Depths", 200, Rarity.COMMON, mage.cards.m.MerfolkOfTheDepths.class));
        cards.add(new SetCardInfo("Midnight Reaper", 86, Rarity.RARE, mage.cards.m.MidnightReaper.class));
        cards.add(new SetCardInfo("Mindleech Mass", 201, Rarity.RARE, mage.cards.m.MindleechMass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mindleech Mass", 375, Rarity.RARE, mage.cards.m.MindleechMass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ministrant of Obligation", 23, Rarity.UNCOMMON, mage.cards.m.MinistrantOfObligation.class));
        cards.add(new SetCardInfo("Mistral Charger", 24, Rarity.UNCOMMON, mage.cards.m.MistralCharger.class));
        cards.add(new SetCardInfo("Mizzix's Mastery", 118, Rarity.RARE, mage.cards.m.MizzixsMastery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mizzix's Mastery", 339, Rarity.RARE, mage.cards.m.MizzixsMastery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Moldervine Cloak", 150, Rarity.UNCOMMON, mage.cards.m.MoldervineCloak.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Moldervine Cloak", 352, Rarity.UNCOMMON, mage.cards.m.MoldervineCloak.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Moroii", 202, Rarity.UNCOMMON, mage.cards.m.Moroii.class));
        cards.add(new SetCardInfo("Mortus Strider", 203, Rarity.COMMON, mage.cards.m.MortusStrider.class));
        cards.add(new SetCardInfo("Mourning Thrull", 204, Rarity.COMMON, mage.cards.m.MourningThrull.class));
        cards.add(new SetCardInfo("Muddle the Mixture", 315, Rarity.UNCOMMON, mage.cards.m.MuddleTheMixture.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Muddle the Mixture", 50, Rarity.UNCOMMON, mage.cards.m.MuddleTheMixture.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mugging", 119, Rarity.COMMON, mage.cards.m.Mugging.class));
        cards.add(new SetCardInfo("Murmuring Mystic", 51, Rarity.UNCOMMON, mage.cards.m.MurmuringMystic.class));
        cards.add(new SetCardInfo("Narcomoeba", 451, Rarity.UNCOMMON, mage.cards.n.Narcomoeba.class));
        cards.add(new SetCardInfo("Nicol Bolas, Dragon-God", 205, Rarity.MYTHIC, mage.cards.n.NicolBolasDragonGod.class));
        cards.add(new SetCardInfo("Nightveil Predator", 206, Rarity.UNCOMMON, mage.cards.n.NightveilPredator.class));
        cards.add(new SetCardInfo("Nightveil Sprite", 52, Rarity.UNCOMMON, mage.cards.n.NightveilSprite.class));
        cards.add(new SetCardInfo("Niv-Mizzet Reborn", 459, Rarity.MYTHIC, mage.cards.n.NivMizzetReborn.class));
        cards.add(new SetCardInfo("Niv-Mizzet, Parun", 207, Rarity.RARE, mage.cards.n.NivMizzetParun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet, Parun", 376, Rarity.RARE, mage.cards.n.NivMizzetParun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet, Parun", 438, Rarity.RARE, mage.cards.n.NivMizzetParun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet, the Firemind", 467, Rarity.RARE, mage.cards.n.NivMizzetTheFiremind.class));
        cards.add(new SetCardInfo("Open the Gates", 151, Rarity.COMMON, mage.cards.o.OpenTheGates.class));
        cards.add(new SetCardInfo("Orzhov Enforcer", 87, Rarity.UNCOMMON, mage.cards.o.OrzhovEnforcer.class));
        cards.add(new SetCardInfo("Orzhov Euthanist", 88, Rarity.COMMON, mage.cards.o.OrzhovEuthanist.class));
        cards.add(new SetCardInfo("Orzhov Guildgate", 282, Rarity.COMMON, mage.cards.o.OrzhovGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orzhov Guildgate", 406, Rarity.COMMON, mage.cards.o.OrzhovGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orzhov Guildmage", 208, Rarity.UNCOMMON, mage.cards.o.OrzhovGuildmage.class));
        cards.add(new SetCardInfo("Orzhov Signet", 263, Rarity.UNCOMMON, mage.cards.o.OrzhovSignet.class));
        cards.add(new SetCardInfo("Overgrown Tomb", 283, Rarity.RARE, mage.cards.o.OvergrownTomb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Overgrown Tomb", 296, Rarity.RARE, mage.cards.o.OvergrownTomb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Overgrown Tomb", 407, Rarity.RARE, mage.cards.o.OvergrownTomb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Overwhelm", 152, Rarity.UNCOMMON, mage.cards.o.Overwhelm.class));
        cards.add(new SetCardInfo("Pack Rat", 426, Rarity.RARE, mage.cards.p.PackRat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pack Rat", 455, Rarity.RARE, mage.cards.p.PackRat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pariah's Shield", 264, Rarity.RARE, mage.cards.p.PariahsShield.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pariah's Shield", 393, Rarity.RARE, mage.cards.p.PariahsShield.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Perilous Forays", 457, Rarity.UNCOMMON, mage.cards.p.PerilousForays.class));
        cards.add(new SetCardInfo("Persistent Petitioners", 316, Rarity.COMMON, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Persistent Petitioners", 53, Rarity.COMMON, mage.cards.p.PersistentPetitioners.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Petrahydrox", 209, Rarity.COMMON, mage.cards.p.Petrahydrox.class));
        cards.add(new SetCardInfo("Phytohydra", 210, Rarity.RARE, mage.cards.p.Phytohydra.class));
        cards.add(new SetCardInfo("Pithing Needle", 463, Rarity.RARE, mage.cards.p.PithingNeedle.class));
        cards.add(new SetCardInfo("Plaguecrafter", 89, Rarity.UNCOMMON, mage.cards.p.Plaguecrafter.class));
        cards.add(new SetCardInfo("Priest of Forgotten Gods", 90, Rarity.RARE, mage.cards.p.PriestOfForgottenGods.class));
        cards.add(new SetCardInfo("Prime Speaker Zegana", 211, Rarity.RARE, mage.cards.p.PrimeSpeakerZegana.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prime Speaker Zegana", 377, Rarity.RARE, mage.cards.p.PrimeSpeakerZegana.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prime Speaker Zegana", 439, Rarity.RARE, mage.cards.p.PrimeSpeakerZegana.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Protean Hulk", 153, Rarity.MYTHIC, mage.cards.p.ProteanHulk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Protean Hulk", 353, Rarity.MYTHIC, mage.cards.p.ProteanHulk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Protean Hulk", 435, Rarity.MYTHIC, mage.cards.p.ProteanHulk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pteramander", 317, Rarity.UNCOMMON, mage.cards.p.Pteramander.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pteramander", 54, Rarity.UNCOMMON, mage.cards.p.Pteramander.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Putrefy", 212, Rarity.UNCOMMON, mage.cards.p.Putrefy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Putrefy", 378, Rarity.UNCOMMON, mage.cards.p.Putrefy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quasiduplicate", 55, Rarity.RARE, mage.cards.q.Quasiduplicate.class));
        cards.add(new SetCardInfo("Quench", 56, Rarity.COMMON, mage.cards.q.Quench.class));
        cards.add(new SetCardInfo("Quicken", 318, Rarity.UNCOMMON, mage.cards.q.Quicken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quicken", 57, Rarity.UNCOMMON, mage.cards.q.Quicken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radical Idea", 58, Rarity.COMMON, mage.cards.r.RadicalIdea.class));
        cards.add(new SetCardInfo("Rakdos Firewheeler", 213, Rarity.UNCOMMON, mage.cards.r.RakdosFirewheeler.class));
        cards.add(new SetCardInfo("Rakdos Guildgate", 284, Rarity.COMMON, mage.cards.r.RakdosGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakdos Guildgate", 408, Rarity.COMMON, mage.cards.r.RakdosGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakdos Guildmage", 214, Rarity.UNCOMMON, mage.cards.r.RakdosGuildmage.class));
        cards.add(new SetCardInfo("Rakdos Pit Dragon", 120, Rarity.UNCOMMON, mage.cards.r.RakdosPitDragon.class));
        cards.add(new SetCardInfo("Rakdos Signet", 265, Rarity.UNCOMMON, mage.cards.r.RakdosSignet.class));
        cards.add(new SetCardInfo("Rakdos, Lord of Riots", 215, Rarity.RARE, mage.cards.r.RakdosLordOfRiots.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakdos, Lord of Riots", 379, Rarity.RARE, mage.cards.r.RakdosLordOfRiots.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ral Zarek", 216, Rarity.MYTHIC, mage.cards.r.RalZarek.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ral Zarek", 445, Rarity.MYTHIC, mage.cards.r.RalZarek.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rampaging Rendhorn", 154, Rarity.COMMON, mage.cards.r.RampagingRendhorn.class));
        cards.add(new SetCardInfo("Remand", 59, Rarity.UNCOMMON, mage.cards.r.Remand.class));
        cards.add(new SetCardInfo("Repeal", 60, Rarity.COMMON, mage.cards.r.Repeal.class));
        cards.add(new SetCardInfo("Repudiate // Replicate", 249, Rarity.RARE, mage.cards.r.RepudiateReplicate.class));
        cards.add(new SetCardInfo("Response // Resurgence", 247, Rarity.RARE, mage.cards.r.ResponseResurgence.class));
        cards.add(new SetCardInfo("Rest in Peace", 446, Rarity.RARE, mage.cards.r.RestInPeace.class));
        cards.add(new SetCardInfo("Revival // Revenge", 241, Rarity.RARE, mage.cards.r.RevivalRevenge.class));
        cards.add(new SetCardInfo("Rhythm of the Wild", 217, Rarity.UNCOMMON, mage.cards.r.RhythmOfTheWild.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rhythm of the Wild", 380, Rarity.UNCOMMON, mage.cards.r.RhythmOfTheWild.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rising Populace", 25, Rarity.COMMON, mage.cards.r.RisingPopulace.class));
        cards.add(new SetCardInfo("Rootborn Defenses", 26, Rarity.COMMON, mage.cards.r.RootbornDefenses.class));
        cards.add(new SetCardInfo("Rubblebelt Maaka", 121, Rarity.COMMON, mage.cards.r.RubblebeltMaaka.class));
        cards.add(new SetCardInfo("Sacred Foundry", 285, Rarity.RARE, mage.cards.s.SacredFoundry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sacred Foundry", 297, Rarity.RARE, mage.cards.s.SacredFoundry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sacred Foundry", 409, Rarity.RARE, mage.cards.s.SacredFoundry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savra, Queen of the Golgari", 218, Rarity.RARE, mage.cards.s.SavraQueenOfTheGolgari.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savra, Queen of the Golgari", 381, Rarity.RARE, mage.cards.s.SavraQueenOfTheGolgari.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savra, Queen of the Golgari", 440, Rarity.RARE, mage.cards.s.SavraQueenOfTheGolgari.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scab-Clan Mauler", 219, Rarity.COMMON, mage.cards.s.ScabClanMauler.class));
        cards.add(new SetCardInfo("Scorched Rusalka", 122, Rarity.COMMON, mage.cards.s.ScorchedRusalka.class));
        cards.add(new SetCardInfo("Seal of the Guildpact", 266, Rarity.RARE, mage.cards.s.SealOfTheGuildpact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seal of the Guildpact", 394, Rarity.RARE, mage.cards.s.SealOfTheGuildpact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selesnya Evangel", 220, Rarity.UNCOMMON, mage.cards.s.SelesnyaEvangel.class));
        cards.add(new SetCardInfo("Selesnya Guildgate", 286, Rarity.COMMON, mage.cards.s.SelesnyaGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selesnya Guildgate", 410, Rarity.COMMON, mage.cards.s.SelesnyaGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selesnya Guildmage", 221, Rarity.UNCOMMON, mage.cards.s.SelesnyaGuildmage.class));
        cards.add(new SetCardInfo("Selesnya Signet", 267, Rarity.UNCOMMON, mage.cards.s.SelesnyaSignet.class));
        cards.add(new SetCardInfo("Sewer Shambler", 91, Rarity.COMMON, mage.cards.s.SewerShambler.class));
        cards.add(new SetCardInfo("Shadow Alley Denizen", 92, Rarity.COMMON, mage.cards.s.ShadowAlleyDenizen.class));
        cards.add(new SetCardInfo("Shambling Shell", 460, Rarity.COMMON, mage.cards.s.ShamblingShell.class));
        cards.add(new SetCardInfo("Sharktocrab", 222, Rarity.UNCOMMON, mage.cards.s.Sharktocrab.class));
        cards.add(new SetCardInfo("Shattering Spree", 456, Rarity.UNCOMMON, mage.cards.s.ShatteringSpree.class));
        cards.add(new SetCardInfo("Siege Wurm", 155, Rarity.COMMON, mage.cards.s.SiegeWurm.class));
        cards.add(new SetCardInfo("Siege of Towers", 123, Rarity.UNCOMMON, mage.cards.s.SiegeOfTowers.class));
        cards.add(new SetCardInfo("Silent Dart", 268, Rarity.UNCOMMON, mage.cards.s.SilentDart.class));
        cards.add(new SetCardInfo("Silhana Ledgewalker", 156, Rarity.COMMON, mage.cards.s.SilhanaLedgewalker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Silhana Ledgewalker", 354, Rarity.COMMON, mage.cards.s.SilhanaLedgewalker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simic Guildgate", 287, Rarity.COMMON, mage.cards.s.SimicGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simic Guildgate", 411, Rarity.COMMON, mage.cards.s.SimicGuildgate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simic Guildmage", 223, Rarity.UNCOMMON, mage.cards.s.SimicGuildmage.class));
        cards.add(new SetCardInfo("Simic Signet", 269, Rarity.UNCOMMON, mage.cards.s.SimicSignet.class));
        cards.add(new SetCardInfo("Sinister Sabotage", 61, Rarity.COMMON, mage.cards.s.SinisterSabotage.class));
        cards.add(new SetCardInfo("Skewer the Critics", 124, Rarity.COMMON, mage.cards.s.SkewerTheCritics.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skewer the Critics", 340, Rarity.COMMON, mage.cards.s.SkewerTheCritics.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skullcrack", 125, Rarity.UNCOMMON, mage.cards.s.Skullcrack.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skullcrack", 341, Rarity.UNCOMMON, mage.cards.s.Skullcrack.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sky Hussar", 224, Rarity.UNCOMMON, mage.cards.s.SkyHussar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sky Hussar", 382, Rarity.UNCOMMON, mage.cards.s.SkyHussar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skyknight Legionnaire", 225, Rarity.COMMON, mage.cards.s.SkyknightLegionnaire.class));
        cards.add(new SetCardInfo("Slitherhead", 226, Rarity.COMMON, mage.cards.s.Slitherhead.class));
        cards.add(new SetCardInfo("Spark Double", 319, Rarity.RARE, mage.cards.s.SparkDouble.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Double", 421, Rarity.RARE, mage.cards.s.SparkDouble.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Double", 62, Rarity.RARE, mage.cards.s.SparkDouble.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sphere of Safety", 447, Rarity.UNCOMMON, mage.cards.s.SphereOfSafety.class));
        cards.add(new SetCardInfo("Sphinx of New Prahv", 227, Rarity.UNCOMMON, mage.cards.s.SphinxOfNewPrahv.class));
        cards.add(new SetCardInfo("Sphinx's Revelation", 228, Rarity.RARE, mage.cards.s.SphinxsRevelation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sphinx's Revelation", 383, Rarity.RARE, mage.cards.s.SphinxsRevelation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sprouting Renewal", 157, Rarity.COMMON, mage.cards.s.SproutingRenewal.class));
        cards.add(new SetCardInfo("Stab Wound", 93, Rarity.UNCOMMON, mage.cards.s.StabWound.class));
        cards.add(new SetCardInfo("Stalking Vengeance", 126, Rarity.UNCOMMON, mage.cards.s.StalkingVengeance.class));
        cards.add(new SetCardInfo("Steam Vents", 288, Rarity.RARE, mage.cards.s.SteamVents.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steam Vents", 298, Rarity.RARE, mage.cards.s.SteamVents.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steam Vents", 412, Rarity.RARE, mage.cards.s.SteamVents.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stitch in Time", 229, Rarity.RARE, mage.cards.s.StitchInTime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stitch in Time", 384, Rarity.RARE, mage.cards.s.StitchInTime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stomping Ground", 289, Rarity.RARE, mage.cards.s.StompingGround.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stomping Ground", 299, Rarity.RARE, mage.cards.s.StompingGround.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stomping Ground", 413, Rarity.RARE, mage.cards.s.StompingGround.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Summary Judgment", 27, Rarity.COMMON, mage.cards.s.SummaryJudgment.class));
        cards.add(new SetCardInfo("Sunder Shaman", 230, Rarity.UNCOMMON, mage.cards.s.SunderShaman.class));
        cards.add(new SetCardInfo("Sunhome Stalwart", 28, Rarity.UNCOMMON, mage.cards.s.SunhomeStalwart.class));
        cards.add(new SetCardInfo("Supreme Verdict", 461, Rarity.RARE, mage.cards.s.SupremeVerdict.class));
        cards.add(new SetCardInfo("Sword of the Paruns", 270, Rarity.RARE, mage.cards.s.SwordOfTheParuns.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of the Paruns", 395, Rarity.RARE, mage.cards.s.SwordOfTheParuns.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Syndicate Messenger", 29, Rarity.COMMON, mage.cards.s.SyndicateMessenger.class));
        cards.add(new SetCardInfo("Tajic, Legion's Edge", 231, Rarity.RARE, mage.cards.t.TajicLegionsEdge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tajic, Legion's Edge", 385, Rarity.RARE, mage.cards.t.TajicLegionsEdge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Taste for Mayhem", 127, Rarity.COMMON, mage.cards.t.TasteForMayhem.class));
        cards.add(new SetCardInfo("Teferi, Time Raveler", 232, Rarity.MYTHIC, mage.cards.t.TeferiTimeRaveler.class));
        cards.add(new SetCardInfo("Temple Garden", 290, Rarity.RARE, mage.cards.t.TempleGarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Temple Garden", 300, Rarity.RARE, mage.cards.t.TempleGarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Temple Garden", 414, Rarity.RARE, mage.cards.t.TempleGarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teysa, Orzhov Scion", 233, Rarity.RARE, mage.cards.t.TeysaOrzhovScion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teysa, Orzhov Scion", 386, Rarity.RARE, mage.cards.t.TeysaOrzhovScion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teysa, Orzhov Scion", 441, Rarity.RARE, mage.cards.t.TeysaOrzhovScion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thespian's Stage", 466, Rarity.RARE, mage.cards.t.ThespiansStage.class));
        cards.add(new SetCardInfo("Thrash // Threat", 246, Rarity.RARE, mage.cards.t.ThrashThreat.class));
        cards.add(new SetCardInfo("Thrill-Kill Assassin", 94, Rarity.COMMON, mage.cards.t.ThrillKillAssassin.class));
        cards.add(new SetCardInfo("Tidespout Tyrant", 320, Rarity.RARE, mage.cards.t.TidespoutTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tidespout Tyrant", 422, Rarity.RARE, mage.cards.t.TidespoutTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tidespout Tyrant", 63, Rarity.RARE, mage.cards.t.TidespoutTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tin Street Dodger", 128, Rarity.COMMON, mage.cards.t.TinStreetDodger.class));
        cards.add(new SetCardInfo("Titanic Brawl", 158, Rarity.COMMON, mage.cards.t.TitanicBrawl.class));
        cards.add(new SetCardInfo("To Arms!", 30, Rarity.UNCOMMON, mage.cards.t.ToArms.class));
        cards.add(new SetCardInfo("Tolsimir Wolfblood", 234, Rarity.RARE, mage.cards.t.TolsimirWolfblood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tolsimir Wolfblood", 387, Rarity.RARE, mage.cards.t.TolsimirWolfblood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tomik, Distinguished Advokist", 31, Rarity.RARE, mage.cards.t.TomikDistinguishedAdvokist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tomik, Distinguished Advokist", 417, Rarity.RARE, mage.cards.t.TomikDistinguishedAdvokist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Totally Lost", 321, Rarity.COMMON, mage.cards.t.TotallyLost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Totally Lost", 64, Rarity.COMMON, mage.cards.t.TotallyLost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Truefire Captain", 235, Rarity.UNCOMMON, mage.cards.t.TruefireCaptain.class));
        cards.add(new SetCardInfo("Turnabout", 452, Rarity.UNCOMMON, mage.cards.t.Turnabout.class));
        cards.add(new SetCardInfo("Ultimate Price", 329, Rarity.UNCOMMON, mage.cards.u.UltimatePrice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ultimate Price", 95, Rarity.UNCOMMON, mage.cards.u.UltimatePrice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unbreakable Formation", 32, Rarity.RARE, mage.cards.u.UnbreakableFormation.class));
        cards.add(new SetCardInfo("Undercity's Embrace", 96, Rarity.COMMON, mage.cards.u.UndercitysEmbrace.class));
        cards.add(new SetCardInfo("Urbis Protector", 33, Rarity.UNCOMMON, mage.cards.u.UrbisProtector.class));
        cards.add(new SetCardInfo("Utopia Sprawl", 159, Rarity.UNCOMMON, mage.cards.u.UtopiaSprawl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Utopia Sprawl", 355, Rarity.UNCOMMON, mage.cards.u.UtopiaSprawl.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Utvara Hellkite", 129, Rarity.MYTHIC, mage.cards.u.UtvaraHellkite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Utvara Hellkite", 342, Rarity.MYTHIC, mage.cards.u.UtvaraHellkite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Utvara Hellkite", 431, Rarity.MYTHIC, mage.cards.u.UtvaraHellkite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vedalken Mesmerist", 65, Rarity.COMMON, mage.cards.v.VedalkenMesmerist.class));
        cards.add(new SetCardInfo("Vernadi Shieldmate", 236, Rarity.COMMON, mage.cards.v.VernadiShieldmate.class));
        cards.add(new SetCardInfo("Vindictive Vampire", 330, Rarity.UNCOMMON, mage.cards.v.VindictiveVampire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vindictive Vampire", 97, Rarity.UNCOMMON, mage.cards.v.VindictiveVampire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voidslime", 237, Rarity.RARE, mage.cards.v.Voidslime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voidslime", 388, Rarity.RARE, mage.cards.v.Voidslime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Voyager Staff", 271, Rarity.UNCOMMON, mage.cards.v.VoyagerStaff.class));
        cards.add(new SetCardInfo("Warrant // Warden", 240, Rarity.RARE, mage.cards.w.WarrantWarden.class));
        cards.add(new SetCardInfo("Wasteland Viper", 160, Rarity.UNCOMMON, mage.cards.w.WastelandViper.class));
        cards.add(new SetCardInfo("Watery Grave", 291, Rarity.RARE, mage.cards.w.WateryGrave.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Watery Grave", 301, Rarity.RARE, mage.cards.w.WateryGrave.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Watery Grave", 415, Rarity.RARE, mage.cards.w.WateryGrave.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Whisper Agent", 238, Rarity.COMMON, mage.cards.w.WhisperAgent.class));
        cards.add(new SetCardInfo("Wild Cantor", 239, Rarity.COMMON, mage.cards.w.WildCantor.class));
        cards.add(new SetCardInfo("Wilderness Reclamation", 458, Rarity.UNCOMMON, mage.cards.w.WildernessReclamation.class));
        cards.add(new SetCardInfo("Woebringer Demon", 98, Rarity.UNCOMMON, mage.cards.w.WoebringerDemon.class));
        cards.add(new SetCardInfo("Wojek Bodyguard", 130, Rarity.COMMON, mage.cards.w.WojekBodyguard.class));
        cards.add(new SetCardInfo("Wurmweaver Coil", 161, Rarity.UNCOMMON, mage.cards.w.WurmweaverCoil.class));
        cards.add(new SetCardInfo("Yeva, Nature's Herald", 162, Rarity.RARE, mage.cards.y.YevaNaturesHerald.class));
    }

    @Override
    protected List<CardInfo> findSpecialCardsByRarity(Rarity rarity) {
        // Guildgates, shocklands, signets, chromatic lantern
        List<CardInfo> cardInfos = new ArrayList<>();

        cardInfos.addAll(CardRepository.instance.findCards(new CardCriteria()
                .setCodes(this.code)
                .rarities(rarity)
                .types(CardType.LAND) // guildgates + shocklands
                .maxCardNumber(maxCardNumberInBooster)));
        cardInfos.addAll(CardRepository.instance.findCards(new CardCriteria()
                .setCodes(this.code)
                .rarities(rarity)
                .nameContains("Signet")
                .maxCardNumber(maxCardNumberInBooster)));
        cardInfos.addAll(CardRepository.instance.findCards(new CardCriteria()
                .setCodes(this.code)
                .rarities(rarity)
                .name("Chromatic Lantern")
                .maxCardNumber(maxCardNumberInBooster)));

        return cardInfos;
    }

    @Override
    protected void addSpecialCards(List<Card> booster, int number) {
        Rarity rarity;
        int rarityKey = RandomUtil.nextInt(121);
        if (rarityKey <= 11) {
            rarity = Rarity.RARE; // shocklands or chromatic lantern each 1/121
        } else if (rarityKey <= 11+40) {
            rarity = Rarity.UNCOMMON; // signets 40/121
        } else {
            rarity = Rarity.COMMON; // guildgates 70/121
        }
        addToBooster(booster, getSpecialCardsByRarity(rarity));
    }

//    @Override
//    public BoosterCollator createCollator() {
//        return new RavnicaRemasteredCollator();
//    }
}
