package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * https://scryfall.com/sets/ptc
 */
public class ProTourCollectorSet extends ExpansionSet {

    private static final ProTourCollectorSet instance = new ProTourCollectorSet();

    public static ProTourCollectorSet getInstance() {
        return instance;
    }

    private ProTourCollectorSet() {
        super("Pro Tour Collector Set", "PTC", ExpansionSet.buildDate(1996, 5, 1), SetType.PROMOTIONAL);
        this.hasBoosters = false;
        this.hasBasicLands = true;


        cards.add(new SetCardInfo("Abbey Gargoyles", "bl1sb", Rarity.UNCOMMON, mage.cards.a.AbbeyGargoyles.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abbey Gargoyles", "shr1sb", Rarity.UNCOMMON, mage.cards.a.AbbeyGargoyles.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Adarkar Wastes", "ml351", Rarity.RARE, mage.cards.a.AdarkarWastes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Adarkar Wastes", "shr351", Rarity.RARE, mage.cards.a.AdarkarWastes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aeolipile", "ml81sb", Rarity.RARE, mage.cards.a.Aeolipile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aeolipile", "pp81", Rarity.RARE, mage.cards.a.Aeolipile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("An-Zerrin Ruins", "et48sb", Rarity.RARE, mage.cards.a.AnZerrinRuins.class));
        cards.add(new SetCardInfo("Anarchy", "mj49sb", Rarity.UNCOMMON, mage.cards.a.Anarchy.class));
        cards.add(new SetCardInfo("Apocalypse Chime", "et101sb", Rarity.RARE, mage.cards.a.ApocalypseChime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Apocalypse Chime", "ll101sb", Rarity.RARE, mage.cards.a.ApocalypseChime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arenson's Aura", "shr3sb", Rarity.COMMON, mage.cards.a.ArensonsAura.class));
        cards.add(new SetCardInfo("Armageddon", "bl5", Rarity.RARE, mage.cards.a.Armageddon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armageddon", "pp5", Rarity.RARE, mage.cards.a.Armageddon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armageddon", "pp5sb", Rarity.RARE, mage.cards.a.Armageddon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashes to Ashes", "ll33sb", Rarity.UNCOMMON, mage.cards.a.AshesToAshes.class));
        cards.add(new SetCardInfo("Autumn Willow", "bl83", Rarity.RARE, mage.cards.a.AutumnWillow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Autumn Willow", "et83", Rarity.RARE, mage.cards.a.AutumnWillow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Autumn Willow", "et83sb", Rarity.RARE, mage.cards.a.AutumnWillow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Autumn Willow", "pp83", Rarity.RARE, mage.cards.a.AutumnWillow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Autumn Willow", "pp83sb", Rarity.RARE, mage.cards.a.AutumnWillow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balance", "bl6", Rarity.RARE, mage.cards.b.Balance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balance", "et6", Rarity.RARE, mage.cards.b.Balance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balance", "mj6", Rarity.RARE, mage.cards.b.Balance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balance", "ml6", Rarity.RARE, mage.cards.b.Balance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balance", "pp6", Rarity.RARE, mage.cards.b.Balance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balance", "shr6", Rarity.RARE, mage.cards.b.Balance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Barbed Sextant", "gb312", Rarity.COMMON, mage.cards.b.BarbedSextant.class));
        cards.add(new SetCardInfo("Birds of Paradise", "et234", Rarity.RARE, mage.cards.b.BirdsOfParadise.class));
        cards.add(new SetCardInfo("Black Vise", "bl299sb", Rarity.UNCOMMON, mage.cards.b.BlackVise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Black Vise", "mj299", Rarity.UNCOMMON, mage.cards.b.BlackVise.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blinking Spirit", "et8", Rarity.RARE, mage.cards.b.BlinkingSpirit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blinking Spirit", "ml8", Rarity.RARE, mage.cards.b.BlinkingSpirit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brushland", "bl352", Rarity.RARE, mage.cards.b.Brushland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brushland", "et352", Rarity.RARE, mage.cards.b.Brushland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brushland", "pp352", Rarity.RARE, mage.cards.b.Brushland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Black", "shr14sb", Rarity.COMMON, mage.cards.c.CircleOfProtectionBlack.class));
        cards.add(new SetCardInfo("Circle of Protection: Green", "bl14sb", Rarity.COMMON, mage.cards.c.CircleOfProtectionGreen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Green", "bl16sb", Rarity.COMMON, mage.cards.c.CircleOfProtectionGreen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Red", "bl15sb", Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Red", "bl17sb", Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Red", "et17sb", Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Red", "ml15sb", Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Red", "ml17sb", Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Circle of Protection: Red", "shr15sb", Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("City of Brass", "et112", Rarity.RARE, mage.cards.c.CityOfBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("City of Brass", "gb112", Rarity.RARE, mage.cards.c.CityOfBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("City of Brass", "ll112sb", Rarity.RARE, mage.cards.c.CityOfBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("City of Brass", "mj112", Rarity.RARE, mage.cards.c.CityOfBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("City of Brass", "shr112", Rarity.RARE, mage.cards.c.CityOfBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Control Magic", "ml64", Rarity.UNCOMMON, mage.cards.c.ControlMagic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Control Magic", "ml64sb", Rarity.UNCOMMON, mage.cards.c.ControlMagic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Counterspell", "ml65", Rarity.UNCOMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Counterspell", "shr65", Rarity.UNCOMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dance of the Dead", "ll118", Rarity.UNCOMMON, mage.cards.d.DanceOfTheDead.class));
        cards.add(new SetCardInfo("Dark Banishing", "gb119sb", Rarity.COMMON, mage.cards.d.DarkBanishing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dark Banishing", "ll119", Rarity.COMMON, mage.cards.d.DarkBanishing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dark Ritual", "gb129", Rarity.COMMON, mage.cards.d.DarkRitual.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dark Ritual", "ll129", Rarity.COMMON, mage.cards.d.DarkRitual.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deflection", "ml81", Rarity.RARE, mage.cards.d.Deflection.class));
        cards.add(new SetCardInfo("Detonate", "mj184", Rarity.UNCOMMON, mage.cards.d.Detonate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Detonate", "mj184sb", Rarity.UNCOMMON, mage.cards.d.Detonate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disenchant", "bl22", Rarity.COMMON, mage.cards.d.Disenchant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disenchant", "et22", Rarity.COMMON, mage.cards.d.Disenchant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disenchant", "ml22", Rarity.COMMON, mage.cards.d.Disenchant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disenchant", "pp22", Rarity.COMMON, mage.cards.d.Disenchant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disenchant", "pp22sb", Rarity.COMMON, mage.cards.d.Disenchant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disenchant", "shr22", Rarity.COMMON, mage.cards.d.Disenchant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disrupting Scepter", "et316sb", Rarity.RARE, mage.cards.d.DisruptingScepter.class));
        cards.add(new SetCardInfo("Divine Offering", "bl6sb", Rarity.COMMON, mage.cards.d.DivineOffering.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Divine Offering", "et6sb", Rarity.COMMON, mage.cards.d.DivineOffering.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Divine Offering", "ml6sb", Rarity.COMMON, mage.cards.d.DivineOffering.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Divine Offering", "pp6sb", Rarity.COMMON, mage.cards.d.DivineOffering.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Divine Offering", "shr6sb", Rarity.COMMON, mage.cards.d.DivineOffering.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drain Life", "ll132", Rarity.COMMON, mage.cards.d.DrainLife.class));
        cards.add(new SetCardInfo("Dwarven Catapult", "et51sb", Rarity.UNCOMMON, mage.cards.d.DwarvenCatapult.class));
        cards.add(new SetCardInfo("Dwarven Ruins", "mj94", Rarity.UNCOMMON, mage.cards.d.DwarvenRuins.class));
        cards.add(new SetCardInfo("Earthquake", "et189", Rarity.RARE, mage.cards.e.Earthquake.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Earthquake", "mj189", Rarity.RARE, mage.cards.e.Earthquake.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ebon Stronghold", "ll95", Rarity.UNCOMMON, mage.cards.e.EbonStronghold.class));
        cards.add(new SetCardInfo("Elkin Bottle", "mj317", Rarity.RARE, mage.cards.e.ElkinBottle.class));
        cards.add(new SetCardInfo("Elvish Archers", "pp243", Rarity.RARE, mage.cards.e.ElvishArchers.class));
        cards.add(new SetCardInfo("Energy Storm", "et24sb", Rarity.RARE, mage.cards.e.EnergyStorm.class));
        cards.add(new SetCardInfo("Erhnam Djinn", "bl64", Rarity.UNCOMMON, mage.cards.e.ErhnamDjinn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Erhnam Djinn", "et64", Rarity.UNCOMMON, mage.cards.e.ErhnamDjinn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Erhnam Djinn", "gb64", Rarity.UNCOMMON, mage.cards.e.ErhnamDjinn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Erhnam Djinn", "pp64", Rarity.UNCOMMON, mage.cards.e.ErhnamDjinn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eron the Relentless", "mj73sb", Rarity.UNCOMMON, mage.cards.e.EronTheRelentless.class));
        cards.add(new SetCardInfo("Essence Filter", "pp233sb", Rarity.COMMON, mage.cards.e.EssenceFilter.class));
        cards.add(new SetCardInfo("Feldon's Cane", "ll50sb", Rarity.UNCOMMON, mage.cards.f.FeldonsCane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feldon's Cane", "mj50", Rarity.UNCOMMON, mage.cards.f.FeldonsCane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feldon's Cane", "ml50", Rarity.UNCOMMON, mage.cards.f.FeldonsCane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feldon's Cane", "shr50sb", Rarity.UNCOMMON, mage.cards.f.FeldonsCane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fellwar Stone", "bl319", Rarity.UNCOMMON, mage.cards.f.FellwarStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fellwar Stone", "et319", Rarity.UNCOMMON, mage.cards.f.FellwarStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fellwar Stone", "mj319", Rarity.UNCOMMON, mage.cards.f.FellwarStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fellwar Stone", "pp319", Rarity.UNCOMMON, mage.cards.f.FellwarStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fellwar Stone", "pp319sb", Rarity.UNCOMMON, mage.cards.f.FellwarStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fireball", "et192", Rarity.COMMON, mage.cards.f.Fireball.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fireball", "gb192", Rarity.COMMON, mage.cards.f.Fireball.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fireball", "mj192", Rarity.COMMON, mage.cards.f.Fireball.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", "bl376", Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", "bl377", Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", "bl378", Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", "pp376", Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", "pp377", Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", "pp378", Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fountain of Youth", "mj98sb", Rarity.COMMON, mage.cards.f.FountainOfYouth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fountain of Youth", "ml98", Rarity.COMMON, mage.cards.f.FountainOfYouth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fountain of Youth", "shr98sb", Rarity.COMMON, mage.cards.f.FountainOfYouth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fyndhorn Elves", "bl244", Rarity.COMMON, mage.cards.f.FyndhornElves.class));
        cards.add(new SetCardInfo("Hallowed Ground", "ml29", Rarity.UNCOMMON, mage.cards.h.HallowedGround.class));
        cards.add(new SetCardInfo("Havenwood Battleground", "bl96", Rarity.UNCOMMON, mage.cards.h.HavenwoodBattleground.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Havenwood Battleground", "mj96", Rarity.UNCOMMON, mage.cards.h.HavenwoodBattleground.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Havenwood Battleground", "pp96", Rarity.UNCOMMON, mage.cards.h.HavenwoodBattleground.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Howling Mine", "mj325", Rarity.RARE, mage.cards.h.HowlingMine.class));
        cards.add(new SetCardInfo("Hurricane", "pp251", Rarity.UNCOMMON, mage.cards.h.Hurricane.class));
        cards.add(new SetCardInfo("Hydroblast", "ml72sb", Rarity.COMMON, mage.cards.h.Hydroblast.class));
        cards.add(new SetCardInfo("Hymn to Tourach", "gb38a", Rarity.COMMON, mage.cards.h.HymnToTourach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hymn to Tourach", "gb38b", Rarity.COMMON, mage.cards.h.HymnToTourach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hymn to Tourach", "gb38c", Rarity.COMMON, mage.cards.h.HymnToTourach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hymn to Tourach", "gb38d", Rarity.COMMON, mage.cards.h.HymnToTourach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hymn to Tourach", "ll38a", Rarity.COMMON, mage.cards.h.HymnToTourach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hymn to Tourach", "ll38b", Rarity.COMMON, mage.cards.h.HymnToTourach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hymn to Tourach", "ll38c", Rarity.COMMON, mage.cards.h.HymnToTourach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hymn to Tourach", "ll38d", Rarity.COMMON, mage.cards.h.HymnToTourach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hypnotic Specter", "gb142", Rarity.UNCOMMON, mage.cards.h.HypnoticSpecter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hypnotic Specter", "ll142", Rarity.UNCOMMON, mage.cards.h.HypnoticSpecter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icatian Town", "et15", Rarity.RARE, mage.cards.i.IcatianTown.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icatian Town", "et15sb", Rarity.RARE, mage.cards.i.IcatianTown.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icy Manipulator", "bl322", Rarity.UNCOMMON, mage.cards.i.IcyManipulator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icy Manipulator", "et322", Rarity.UNCOMMON, mage.cards.i.IcyManipulator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icy Manipulator", "mj322", Rarity.UNCOMMON, mage.cards.i.IcyManipulator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icy Manipulator", "ml322", Rarity.UNCOMMON, mage.cards.i.IcyManipulator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icy Manipulator", "pp322", Rarity.UNCOMMON, mage.cards.i.IcyManipulator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icy Manipulator", "shr322", Rarity.UNCOMMON, mage.cards.i.IcyManipulator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ihsan's Shade", "gb53", Rarity.UNCOMMON, mage.cards.i.IhsansShade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ihsan's Shade", "gb53sb", Rarity.UNCOMMON, mage.cards.i.IhsansShade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Incinerate", "et194", Rarity.COMMON, mage.cards.i.Incinerate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Incinerate", "mj194", Rarity.COMMON, mage.cards.i.Incinerate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", "ml367", Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", "ml368", Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", "ml369", Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", "shr367", Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", "shr368", Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", "shr369", Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivory Tower", "bl328", Rarity.RARE, mage.cards.i.IvoryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivory Tower", "ll328", Rarity.RARE, mage.cards.i.IvoryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivory Tower", "mj328", Rarity.RARE, mage.cards.i.IvoryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivory Tower", "ml328", Rarity.RARE, mage.cards.i.IvoryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivory Tower", "pp328sb", Rarity.RARE, mage.cards.i.IvoryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivory Tower", "shr328", Rarity.RARE, mage.cards.i.IvoryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jalum Tome", "ll54", Rarity.UNCOMMON, mage.cards.j.JalumTome.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jalum Tome", "ll54sb", Rarity.UNCOMMON, mage.cards.j.JalumTome.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jayemdae Tome", "et331", Rarity.RARE, mage.cards.j.JayemdaeTome.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jayemdae Tome", "ml331", Rarity.RARE, mage.cards.j.JayemdaeTome.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jester's Cap", "mj324", Rarity.RARE, mage.cards.j.JestersCap.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jester's Cap", "ml324sb", Rarity.RARE, mage.cards.j.JestersCap.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karma", "bl32sb", Rarity.UNCOMMON, mage.cards.k.Karma.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karma", "pp32sb", Rarity.UNCOMMON, mage.cards.k.Karma.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karplusan Forest", "et356", Rarity.RARE, mage.cards.k.KarplusanForest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karplusan Forest", "gb356", Rarity.RARE, mage.cards.k.KarplusanForest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karplusan Forest", "mj356", Rarity.RARE, mage.cards.k.KarplusanForest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Knight of Stromgald", "gb138", Rarity.UNCOMMON, mage.cards.k.KnightOfStromgald.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Knight of Stromgald", "ll138", Rarity.UNCOMMON, mage.cards.k.KnightOfStromgald.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Land Tax", "bl34", Rarity.RARE, mage.cards.l.LandTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Land Tax", "et34", Rarity.RARE, mage.cards.l.LandTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Land Tax", "ml34", Rarity.RARE, mage.cards.l.LandTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Land Tax", "pp34", Rarity.RARE, mage.cards.l.LandTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Land Tax", "pp34sb", Rarity.RARE, mage.cards.l.LandTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Land Tax", "shr34", Rarity.RARE, mage.cards.l.LandTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lava Tubes", "gb358", Rarity.RARE, mage.cards.l.LavaTubes.class));
        cards.add(new SetCardInfo("Lightning Bolt", "et208", Rarity.COMMON, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", "gb208", Rarity.COMMON, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", "mj208", Rarity.COMMON, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Llanowar Elves", "bl261", Rarity.COMMON, mage.cards.l.LlanowarElves.class));
        cards.add(new SetCardInfo("Meekstone", "ll335sb", Rarity.RARE, mage.cards.m.Meekstone.class));
        cards.add(new SetCardInfo("Memory Lapse", "shr32asb", Rarity.COMMON, mage.cards.m.MemoryLapse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Memory Lapse", "shr32bsb", Rarity.COMMON, mage.cards.m.MemoryLapse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Millstone", "ml336", Rarity.RARE, mage.cards.m.Millstone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Millstone", "shr336", Rarity.RARE, mage.cards.m.Millstone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra's Factory", "et361", Rarity.UNCOMMON, mage.cards.m.MishrasFactory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra's Factory", "gb361", Rarity.UNCOMMON, mage.cards.m.MishrasFactory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra's Factory", "mj361", Rarity.UNCOMMON, mage.cards.m.MishrasFactory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra's Factory", "ml361", Rarity.UNCOMMON, mage.cards.m.MishrasFactory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra's Factory", "pp361", Rarity.UNCOMMON, mage.cards.m.MishrasFactory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra's Factory", "shr361", Rarity.UNCOMMON, mage.cards.m.MishrasFactory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", "et373", Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", "et374", Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", "et375", Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", "mj373", Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", "mj374", Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", "mj375", Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Necropotence", "ll154", Rarity.RARE, mage.cards.n.Necropotence.class));
        cards.add(new SetCardInfo("Nevinyrral's Disk", "et338sb", Rarity.RARE, mage.cards.n.NevinyrralsDisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral's Disk", "gb338sb", Rarity.RARE, mage.cards.n.NevinyrralsDisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral's Disk", "ll338", Rarity.RARE, mage.cards.n.NevinyrralsDisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral's Disk", "ll338sb", Rarity.RARE, mage.cards.n.NevinyrralsDisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral's Disk", "pp338", Rarity.RARE, mage.cards.n.NevinyrralsDisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Order of Leitbur", "bl16a", Rarity.COMMON, mage.cards.o.OrderOfLeitbur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Order of Leitbur", "bl16b", Rarity.COMMON, mage.cards.o.OrderOfLeitbur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Order of Leitbur", "bl16csb", Rarity.COMMON, mage.cards.o.OrderOfLeitbur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Order of the Ebon Hand", "gb42a", Rarity.COMMON, mage.cards.o.OrderOfTheEbonHand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Order of the Ebon Hand", "gb42b", Rarity.COMMON, mage.cards.o.OrderOfTheEbonHand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Order of the Ebon Hand", "gb42c", Rarity.COMMON, mage.cards.o.OrderOfTheEbonHand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Order of the Ebon Hand", "ll42a", Rarity.COMMON, mage.cards.o.OrderOfTheEbonHand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Order of the Ebon Hand", "ll42b", Rarity.COMMON, mage.cards.o.OrderOfTheEbonHand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Order of the Ebon Hand", "ll42c", Rarity.COMMON, mage.cards.o.OrderOfTheEbonHand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orgg", "et63", Rarity.RARE, mage.cards.o.Orgg.class));
        cards.add(new SetCardInfo("Plains", "bl364", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "bl365", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "bl366", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "et364", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "et365", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "et366", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "mj364", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "mj365", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "mj366", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "ml364", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "ml365", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "ml366", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "pp364", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "pp365", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "pp366", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "shr364", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "shr365", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", "shr366", Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Power Sink", "shr93", Rarity.COMMON, mage.cards.p.PowerSink.class));
        cards.add(new SetCardInfo("Pyroblast", "mj213sb", Rarity.COMMON, mage.cards.p.Pyroblast.class));
        cards.add(new SetCardInfo("Recall", "ml24", Rarity.UNCOMMON, mage.cards.r.Recall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Recall", "shr24", Rarity.UNCOMMON, mage.cards.r.Recall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Red Elemental Blast", "gb218sb", Rarity.COMMON, mage.cards.r.RedElementalBlast.class));
        cards.add(new SetCardInfo("Reverse Damage", "et45sb", Rarity.RARE, mage.cards.r.ReverseDamage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reverse Damage", "pp45sb", Rarity.RARE, mage.cards.r.ReverseDamage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ring of Renewal", "et89sb", Rarity.RARE, mage.cards.r.RingOfRenewal.class));
        cards.add(new SetCardInfo("Ruins of Trokair", "bl100", Rarity.UNCOMMON, mage.cards.r.RuinsOfTrokair.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ruins of Trokair", "ml100", Rarity.UNCOMMON, mage.cards.r.RuinsOfTrokair.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ruins of Trokair", "pp100", Rarity.UNCOMMON, mage.cards.r.RuinsOfTrokair.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ruins of Trokair", "shr100", Rarity.UNCOMMON, mage.cards.r.RuinsOfTrokair.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Safe Haven", "ll118sb", Rarity.RARE, mage.cards.s.SafeHaven.class));
        cards.add(new SetCardInfo("Sea Sprite", "ml38sb", Rarity.UNCOMMON, mage.cards.s.SeaSprite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sea Sprite", "shr38sb", Rarity.UNCOMMON, mage.cards.s.SeaSprite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sengir Vampire", "gb160", Rarity.UNCOMMON, mage.cards.s.SengirVampire.class));
        cards.add(new SetCardInfo("Serra Angel", "bl50", Rarity.UNCOMMON, mage.cards.s.SerraAngel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serra Angel", "et50", Rarity.UNCOMMON, mage.cards.s.SerraAngel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serrated Arrows", "et110sb", Rarity.COMMON, mage.cards.s.SerratedArrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serrated Arrows", "gb110sb", Rarity.COMMON, mage.cards.s.SerratedArrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serrated Arrows", "ll110", Rarity.COMMON, mage.cards.s.SerratedArrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serrated Arrows", "ll110sb", Rarity.COMMON, mage.cards.s.SerratedArrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serrated Arrows", "mj110sb", Rarity.COMMON, mage.cards.s.SerratedArrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serrated Arrows", "ml110sb", Rarity.COMMON, mage.cards.s.SerratedArrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serrated Arrows", "pp110sb", Rarity.COMMON, mage.cards.s.SerratedArrows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shatter", "gb219sb", Rarity.COMMON, mage.cards.s.Shatter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shatter", "mj219", Rarity.COMMON, mage.cards.s.Shatter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shatter", "mj219sb", Rarity.COMMON, mage.cards.s.Shatter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul Burn", "ll161", Rarity.COMMON, mage.cards.s.SoulBurn.class));
        cards.add(new SetCardInfo("Spectral Bears", "bl98", Rarity.UNCOMMON, mage.cards.s.SpectralBears.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spectral Bears", "pp98", Rarity.UNCOMMON, mage.cards.s.SpectralBears.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spell Blast", "shr103", Rarity.COMMON, mage.cards.s.SpellBlast.class));
        cards.add(new SetCardInfo("Steal Artifact", "ml105sb", Rarity.UNCOMMON, mage.cards.s.StealArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steal Artifact", "shr105sb", Rarity.UNCOMMON, mage.cards.s.StealArtifact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stormbind", "et304", Rarity.RARE, mage.cards.s.Stormbind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stormbind", "mj304", Rarity.RARE, mage.cards.s.Stormbind.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Strip Mine", "bl363", Rarity.UNCOMMON, mage.cards.s.StripMine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Strip Mine", "ll363", Rarity.UNCOMMON, mage.cards.s.StripMine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Strip Mine", "ml363", Rarity.UNCOMMON, mage.cards.s.StripMine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Strip Mine", "pp363", Rarity.UNCOMMON, mage.cards.s.StripMine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stromgald Cabal", "ll166sb", Rarity.RARE, mage.cards.s.StromgaldCabal.class));
        cards.add(new SetCardInfo("Sulfurous Springs", "gb360", Rarity.RARE, mage.cards.s.SulfurousSprings.class));
        cards.add(new SetCardInfo("Svyelunite Temple", "ml102", Rarity.UNCOMMON, mage.cards.s.SvyeluniteTemple.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Svyelunite Temple", "shr102", Rarity.UNCOMMON, mage.cards.s.SvyeluniteTemple.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", "gb370", Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", "gb371", Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", "gb372", Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", "ll370", Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", "ll371", Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", "ll372", Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", "bl52", Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", "et52", Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", "et52sb", Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", "mj52", Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", "ml52", Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", "pp52", Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", "shr52", Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sylvan Library", "bl273", Rarity.RARE, mage.cards.s.SylvanLibrary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sylvan Library", "pp273", Rarity.RARE, mage.cards.s.SylvanLibrary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Rack", "ll352sb", Rarity.UNCOMMON, mage.cards.t.TheRack.class));
        cards.add(new SetCardInfo("Torture", "ll59sb", Rarity.COMMON, mage.cards.t.Torture.class));
        cards.add(new SetCardInfo("Tranquility", "gb277sb", Rarity.COMMON, mage.cards.t.Tranquility.class));
        cards.add(new SetCardInfo("Truce", "shr20sb", Rarity.RARE, mage.cards.t.Truce.class));
        cards.add(new SetCardInfo("Whirling Dervish", "bl288sb", Rarity.UNCOMMON, mage.cards.w.WhirlingDervish.class));
        cards.add(new SetCardInfo("Winter Orb", "mj358", Rarity.RARE, mage.cards.w.WinterOrb.class));
        cards.add(new SetCardInfo("Wizards' School", "ml115", Rarity.UNCOMMON, mage.cards.w.WizardsSchool.class));
        cards.add(new SetCardInfo("Wrath of God", "bl58", Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrath of God", "bl58sb", Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrath of God", "et58", Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrath of God", "ml58", Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrath of God", "pp58", Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrath of God", "shr58", Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zur's Weirding", "et110", Rarity.RARE, mage.cards.z.ZursWeirding.class));
        cards.add(new SetCardInfo("Zuran Orb", "bl350", Rarity.UNCOMMON, mage.cards.z.ZuranOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zuran Orb", "et350", Rarity.UNCOMMON, mage.cards.z.ZuranOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zuran Orb", "gb350", Rarity.UNCOMMON, mage.cards.z.ZuranOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zuran Orb", "ll350", Rarity.UNCOMMON, mage.cards.z.ZuranOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zuran Orb", "mj350", Rarity.UNCOMMON, mage.cards.z.ZuranOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zuran Orb", "ml350", Rarity.UNCOMMON, mage.cards.z.ZuranOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zuran Orb", "pp350", Rarity.UNCOMMON, mage.cards.z.ZuranOrb.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zuran Orb", "shr350", Rarity.UNCOMMON, mage.cards.z.ZuranOrb.class, NON_FULL_USE_VARIOUS));
     }
}
