package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class OutlawsOfThunderJunctionCommander extends ExpansionSet {

    private static final OutlawsOfThunderJunctionCommander instance = new OutlawsOfThunderJunctionCommander();

    public static OutlawsOfThunderJunctionCommander getInstance() {
        return instance;
    }

    private OutlawsOfThunderJunctionCommander() {
        super("Outlaws of Thunder Junction Commander", "OTC", ExpansionSet.buildDate(2024, 4, 19), SetType.SUPPLEMENTAL);
        this.hasBasicLands = false;

        cards.add(new SetCardInfo("Academy Manufactor", 251, Rarity.RARE, mage.cards.a.AcademyManufactor.class));
        cards.add(new SetCardInfo("Access Tunnel", 270, Rarity.UNCOMMON, mage.cards.a.AccessTunnel.class));
        cards.add(new SetCardInfo("Aetherborn Marauder", 125, Rarity.UNCOMMON, mage.cards.a.AetherbornMarauder.class));
        cards.add(new SetCardInfo("Ancient Greenwarden", 186, Rarity.MYTHIC, mage.cards.a.AncientGreenwarden.class));
        cards.add(new SetCardInfo("Angel of Indemnity", 9, Rarity.RARE, mage.cards.a.AngelOfIndemnity.class));
        cards.add(new SetCardInfo("Angel of the Ruins", 78, Rarity.UNCOMMON, mage.cards.a.AngelOfTheRuins.class));
        cards.add(new SetCardInfo("Angelic Sell-Sword", 10, Rarity.RARE, mage.cards.a.AngelicSellSword.class));
        cards.add(new SetCardInfo("Angrath's Marauders", 153, Rarity.RARE, mage.cards.a.AngrathsMarauders.class));
        cards.add(new SetCardInfo("Arcane Bombardment", 154, Rarity.MYTHIC, mage.cards.a.ArcaneBombardment.class));
        cards.add(new SetCardInfo("Arcane Denial", 89, Rarity.COMMON, mage.cards.a.ArcaneDenial.class));
        cards.add(new SetCardInfo("Arcane Heist", 13, Rarity.RARE, mage.cards.a.ArcaneHeist.class));
        cards.add(new SetCardInfo("Arcane Signet", 252, Rarity.COMMON, mage.cards.a.ArcaneSignet.class));
        cards.add(new SetCardInfo("Archmage Emeritus", 90, Rarity.RARE, mage.cards.a.ArchmageEmeritus.class));
        cards.add(new SetCardInfo("Avenger of Zendikar", 187, Rarity.MYTHIC, mage.cards.a.AvengerOfZendikar.class));
        cards.add(new SetCardInfo("Back in Town", 18, Rarity.RARE, mage.cards.b.BackInTown.class));
        cards.add(new SetCardInfo("Baleful Mastery", 126, Rarity.RARE, mage.cards.b.BalefulMastery.class));
        cards.add(new SetCardInfo("Baleful Strix", 215, Rarity.RARE, mage.cards.b.BalefulStrix.class));
        cards.add(new SetCardInfo("Baral's Expertise", 91, Rarity.RARE, mage.cards.b.BaralsExpertise.class));
        cards.add(new SetCardInfo("Battlefield Forge", 271, Rarity.RARE, mage.cards.b.BattlefieldForge.class));
        cards.add(new SetCardInfo("Big Score", 155, Rarity.COMMON, mage.cards.b.BigScore.class));
        cards.add(new SetCardInfo("Bitter Reunion", 156, Rarity.COMMON, mage.cards.b.BitterReunion.class));
        cards.add(new SetCardInfo("Blackcleave Cliffs", 272, Rarity.RARE, mage.cards.b.BlackcleaveCliffs.class));
        cards.add(new SetCardInfo("Bladegriff Prototype", 253, Rarity.RARE, mage.cards.b.BladegriffPrototype.class));
        cards.add(new SetCardInfo("Bloodthirsty Adversary", 157, Rarity.MYTHIC, mage.cards.b.BloodthirstyAdversary.class));
        cards.add(new SetCardInfo("Bojuka Bog", 273, Rarity.COMMON, mage.cards.b.BojukaBog.class));
        cards.add(new SetCardInfo("Bonders' Enclave", 274, Rarity.RARE, mage.cards.b.BondersEnclave.class));
        cards.add(new SetCardInfo("Boros Charm", 216, Rarity.UNCOMMON, mage.cards.b.BorosCharm.class));
        cards.add(new SetCardInfo("Bounty Board", 37, Rarity.RARE, mage.cards.b.BountyBoard.class));
        cards.add(new SetCardInfo("Brainstealer Dragon", 127, Rarity.RARE, mage.cards.b.BrainstealerDragon.class));
        cards.add(new SetCardInfo("Breena, the Demagogue", 217, Rarity.MYTHIC, mage.cards.b.BreenaTheDemagogue.class));
        cards.add(new SetCardInfo("Cactus Preserve", 40, Rarity.RARE, mage.cards.c.CactusPreserve.class));
        cards.add(new SetCardInfo("Canyon Slough", 275, Rarity.RARE, mage.cards.c.CanyonSlough.class));
        cards.add(new SetCardInfo("Captain Lannery Storm", 158, Rarity.RARE, mage.cards.c.CaptainLanneryStorm.class));
        cards.add(new SetCardInfo("Captivating Crew", 159, Rarity.RARE, mage.cards.c.CaptivatingCrew.class));
        cards.add(new SetCardInfo("Cascade Bluffs", 276, Rarity.RARE, mage.cards.c.CascadeBluffs.class));
        cards.add(new SetCardInfo("Cataclysmic Prospecting", 24, Rarity.RARE, mage.cards.c.CataclysmicProspecting.class));
        cards.add(new SetCardInfo("Caves of Koilos", 277, Rarity.RARE, mage.cards.c.CavesOfKoilos.class));
        cards.add(new SetCardInfo("Cazur, Ruthless Stalker", 188, Rarity.MYTHIC, mage.cards.c.CazurRuthlessStalker.class));
        cards.add(new SetCardInfo("Changeling Outcast", 128, Rarity.COMMON, mage.cards.c.ChangelingOutcast.class));
        cards.add(new SetCardInfo("Chaos Wand", 254, Rarity.RARE, mage.cards.c.ChaosWand.class));
        cards.add(new SetCardInfo("Chaos Warp", 160, Rarity.RARE, mage.cards.c.ChaosWarp.class));
        cards.add(new SetCardInfo("Charred Graverobber", 19, Rarity.RARE, mage.cards.c.CharredGraverobber.class));
        cards.add(new SetCardInfo("Chromatic Lantern", 255, Rarity.RARE, mage.cards.c.ChromaticLantern.class));
        cards.add(new SetCardInfo("Clifftop Retreat", 278, Rarity.RARE, mage.cards.c.ClifftopRetreat.class));
        cards.add(new SetCardInfo("Cold-Eyed Selkie", 218, Rarity.RARE, mage.cards.c.ColdEyedSelkie.class));
        cards.add(new SetCardInfo("Command Beacon", 279, Rarity.RARE, mage.cards.c.CommandBeacon.class));
        cards.add(new SetCardInfo("Command Tower", 280, Rarity.COMMON, mage.cards.c.CommandTower.class));
        cards.add(new SetCardInfo("Council's Judgment", 79, Rarity.RARE, mage.cards.c.CouncilsJudgment.class));
        cards.add(new SetCardInfo("Crackling Spellslinger", 25, Rarity.RARE, mage.cards.c.CracklingSpellslinger.class));
        cards.add(new SetCardInfo("Crawling Sensation", 189, Rarity.UNCOMMON, mage.cards.c.CrawlingSensation.class));
        cards.add(new SetCardInfo("Culling Ritual", 219, Rarity.RARE, mage.cards.c.CullingRitual.class));
        cards.add(new SetCardInfo("Cunning Rhetoric", 129, Rarity.RARE, mage.cards.c.CunningRhetoric.class));
        cards.add(new SetCardInfo("Curse of the Swine", 92, Rarity.RARE, mage.cards.c.CurseOfTheSwine.class));
        cards.add(new SetCardInfo("Cursed Mirror", 161, Rarity.RARE, mage.cards.c.CursedMirror.class));
        cards.add(new SetCardInfo("Curtains' Call", 130, Rarity.RARE, mage.cards.c.CurtainsCall.class));
        cards.add(new SetCardInfo("Darkslick Shores", 281, Rarity.RARE, mage.cards.d.DarkslickShores.class));
        cards.add(new SetCardInfo("Darksteel Ingot", 256, Rarity.UNCOMMON, mage.cards.d.DarksteelIngot.class));
        cards.add(new SetCardInfo("Darkwater Catacombs", 282, Rarity.RARE, mage.cards.d.DarkwaterCatacombs.class));
        cards.add(new SetCardInfo("Dazzling Sphinx", 93, Rarity.RARE, mage.cards.d.DazzlingSphinx.class));
        cards.add(new SetCardInfo("Dead Before Sunrise", 26, Rarity.RARE, mage.cards.d.DeadBeforeSunrise.class));
        cards.add(new SetCardInfo("Deadly Dispute", 131, Rarity.COMMON, mage.cards.d.DeadlyDispute.class));
        cards.add(new SetCardInfo("Decimate", 220, Rarity.RARE, mage.cards.d.Decimate.class));
        cards.add(new SetCardInfo("Deep Analysis", 94, Rarity.COMMON, mage.cards.d.DeepAnalysis.class));
        cards.add(new SetCardInfo("Demolition Field", 283, Rarity.UNCOMMON, mage.cards.d.DemolitionField.class));
        cards.add(new SetCardInfo("Descend upon the Sinful", 80, Rarity.MYTHIC, mage.cards.d.DescendUponTheSinful.class));
        cards.add(new SetCardInfo("Desert of the Fervent", 284, Rarity.COMMON, mage.cards.d.DesertOfTheFervent.class));
        cards.add(new SetCardInfo("Desert of the Indomitable", 285, Rarity.COMMON, mage.cards.d.DesertOfTheIndomitable.class));
        cards.add(new SetCardInfo("Desert of the True", 286, Rarity.COMMON, mage.cards.d.DesertOfTheTrue.class));
        cards.add(new SetCardInfo("Desolate Mire", 287, Rarity.RARE, mage.cards.d.DesolateMire.class));
        cards.add(new SetCardInfo("Dig Through Time", 95, Rarity.RARE, mage.cards.d.DigThroughTime.class));
        cards.add(new SetCardInfo("Diluvian Primordial", 96, Rarity.RARE, mage.cards.d.DiluvianPrimordial.class));
        cards.add(new SetCardInfo("Dimir Aqueduct", 288, Rarity.UNCOMMON, mage.cards.d.DimirAqueduct.class));
        cards.add(new SetCardInfo("Dire Fleet Daredevil", 162, Rarity.RARE, mage.cards.d.DireFleetDaredevil.class));
        cards.add(new SetCardInfo("Dire Fleet Ravager", 132, Rarity.MYTHIC, mage.cards.d.DireFleetRavager.class));
        cards.add(new SetCardInfo("Discreet Retreat", 20, Rarity.RARE, mage.cards.d.DiscreetRetreat.class));
        cards.add(new SetCardInfo("Dragonskull Summit", 289, Rarity.RARE, mage.cards.d.DragonskullSummit.class));
        cards.add(new SetCardInfo("Dream-Thief's Bandana", 38, Rarity.RARE, mage.cards.d.DreamThiefsBandana.class));
        cards.add(new SetCardInfo("Drowned Catacomb", 290, Rarity.RARE, mage.cards.d.DrownedCatacomb.class));
        cards.add(new SetCardInfo("Dune Chanter", 31, Rarity.RARE, mage.cards.d.DuneChanter.class));
        cards.add(new SetCardInfo("Dunes of the Dead", 291, Rarity.UNCOMMON, mage.cards.d.DunesOfTheDead.class));
        cards.add(new SetCardInfo("Eccentric Farmer", 190, Rarity.COMMON, mage.cards.e.EccentricFarmer.class));
        cards.add(new SetCardInfo("Edric, Spymaster of Trest", 221, Rarity.RARE, mage.cards.e.EdricSpymasterOfTrest.class));
        cards.add(new SetCardInfo("Electric Revelation", 163, Rarity.COMMON, mage.cards.e.ElectricRevelation.class));
        cards.add(new SetCardInfo("Electrostatic Field", 164, Rarity.UNCOMMON, mage.cards.e.ElectrostaticField.class));
        cards.add(new SetCardInfo("Elemental Eruption", 27, Rarity.RARE, mage.cards.e.ElementalEruption.class));
        cards.add(new SetCardInfo("Elvish Rejuvenator", 191, Rarity.COMMON, mage.cards.e.ElvishRejuvenator.class));
        cards.add(new SetCardInfo("Embrace the Unknown", 28, Rarity.RARE, mage.cards.e.EmbraceTheUnknown.class));
        cards.add(new SetCardInfo("Epic Experiment", 222, Rarity.MYTHIC, mage.cards.e.EpicExperiment.class));
        cards.add(new SetCardInfo("Eris, Roar of the Storm", 5, Rarity.MYTHIC, mage.cards.e.ErisRoarOfTheStorm.class));
        cards.add(new SetCardInfo("Escape to the Wilds", 223, Rarity.RARE, mage.cards.e.EscapeToTheWilds.class));
        cards.add(new SetCardInfo("Evolving Wilds", 292, Rarity.COMMON, mage.cards.e.EvolvingWilds.class));
        cards.add(new SetCardInfo("Exotic Orchard", 293, Rarity.RARE, mage.cards.e.ExoticOrchard.class));
        cards.add(new SetCardInfo("Explore", 192, Rarity.COMMON, mage.cards.e.Explore.class));
        cards.add(new SetCardInfo("Expressive Iteration", 224, Rarity.UNCOMMON, mage.cards.e.ExpressiveIteration.class));
        cards.add(new SetCardInfo("Extract Brain", 225, Rarity.RARE, mage.cards.e.ExtractBrain.class));
        cards.add(new SetCardInfo("Fain, the Broker", 133, Rarity.RARE, mage.cards.f.FainTheBroker.class));
        cards.add(new SetCardInfo("Faithless Looting", 165, Rarity.COMMON, mage.cards.f.FaithlessLooting.class));
        cards.add(new SetCardInfo("Fallen Shinobi", 226, Rarity.RARE, mage.cards.f.FallenShinobi.class));
        cards.add(new SetCardInfo("Feed the Swarm", 134, Rarity.COMMON, mage.cards.f.FeedTheSwarm.class));
        cards.add(new SetCardInfo("Felix Five-Boots", 6, Rarity.MYTHIC, mage.cards.f.FelixFiveBoots.class));
        cards.add(new SetCardInfo("Fellwar Stone", 257, Rarity.UNCOMMON, mage.cards.f.FellwarStone.class));
        cards.add(new SetCardInfo("Ferrous Lake", 294, Rarity.RARE, mage.cards.f.FerrousLake.class));
        cards.add(new SetCardInfo("Fetid Heath", 295, Rarity.RARE, mage.cards.f.FetidHeath.class));
        cards.add(new SetCardInfo("Fetid Pools", 296, Rarity.RARE, mage.cards.f.FetidPools.class));
        cards.add(new SetCardInfo("Finale of Promise", 166, Rarity.MYTHIC, mage.cards.f.FinaleOfPromise.class));
        cards.add(new SetCardInfo("Finale of Revelation", 97, Rarity.MYTHIC, mage.cards.f.FinaleOfRevelation.class));
        cards.add(new SetCardInfo("Flooded Grove", 297, Rarity.RARE, mage.cards.f.FloodedGrove.class));
        cards.add(new SetCardInfo("Frostboil Snarl", 298, Rarity.RARE, mage.cards.f.FrostboilSnarl.class));
        cards.add(new SetCardInfo("Galvanic Iteration", 227, Rarity.RARE, mage.cards.g.GalvanicIteration.class));
        cards.add(new SetCardInfo("Genesis Hydra", 193, Rarity.RARE, mage.cards.g.GenesisHydra.class));
        cards.add(new SetCardInfo("Ghostly Pilferer", 98, Rarity.RARE, mage.cards.g.GhostlyPilferer.class));
        cards.add(new SetCardInfo("Glittering Stockpile", 167, Rarity.UNCOMMON, mage.cards.g.GlitteringStockpile.class));
        cards.add(new SetCardInfo("Goblin Electromancer", 228, Rarity.COMMON, mage.cards.g.GoblinElectromancer.class));
        cards.add(new SetCardInfo("Gonti, Canny Acquisitor", 1, Rarity.MYTHIC, mage.cards.g.GontiCannyAcquisitor.class));
        cards.add(new SetCardInfo("Gonti, Lord of Luxury", 135, Rarity.RARE, mage.cards.g.GontiLordOfLuxury.class));
        cards.add(new SetCardInfo("Graywater's Fixer", 36, Rarity.RARE, mage.cards.g.GraywatersFixer.class));
        cards.add(new SetCardInfo("Grenzo, Havoc Raiser", 168, Rarity.RARE, mage.cards.g.GrenzoHavocRaiser.class));
        cards.add(new SetCardInfo("Guttersnipe", 169, Rarity.UNCOMMON, mage.cards.g.Guttersnipe.class));
        cards.add(new SetCardInfo("Harrow", 194, Rarity.COMMON, mage.cards.h.Harrow.class));
        cards.add(new SetCardInfo("Hashep Oasis", 299, Rarity.UNCOMMON, mage.cards.h.HashepOasis.class));
        cards.add(new SetCardInfo("Haughty Djinn", 99, Rarity.RARE, mage.cards.h.HaughtyDjinn.class));
        cards.add(new SetCardInfo("Hazezon, Shaper of Sand", 229, Rarity.RARE, mage.cards.h.HazezonShaperOfSand.class));
        cards.add(new SetCardInfo("Heartless Conscription", 21, Rarity.RARE, mage.cards.h.HeartlessConscription.class));
        cards.add(new SetCardInfo("Heaven // Earth", 230, Rarity.RARE, mage.cards.h.HeavenEarth.class));
        cards.add(new SetCardInfo("Heliod's Intervention", 81, Rarity.RARE, mage.cards.h.HeliodsIntervention.class));
        cards.add(new SetCardInfo("Hex", 136, Rarity.RARE, mage.cards.h.Hex.class));
        cards.add(new SetCardInfo("Hinterland Harbor", 300, Rarity.RARE, mage.cards.h.HinterlandHarbor.class));
        cards.add(new SetCardInfo("Hostage Taker", 231, Rarity.RARE, mage.cards.h.HostageTaker.class));
        cards.add(new SetCardInfo("Hour of Promise", 195, Rarity.RARE, mage.cards.h.HourOfPromise.class));
        cards.add(new SetCardInfo("Humble Defector", 170, Rarity.UNCOMMON, mage.cards.h.HumbleDefector.class));
        cards.add(new SetCardInfo("Idol of Oblivion", 258, Rarity.RARE, mage.cards.i.IdolOfOblivion.class));
        cards.add(new SetCardInfo("Impulsive Pilferer", 171, Rarity.COMMON, mage.cards.i.ImpulsivePilferer.class));
        cards.add(new SetCardInfo("Isolated Chapel", 301, Rarity.RARE, mage.cards.i.IsolatedChapel.class));
        cards.add(new SetCardInfo("Izzet Boilerworks", 302, Rarity.UNCOMMON, mage.cards.i.IzzetBoilerworks.class));
        cards.add(new SetCardInfo("Izzet Signet", 259, Rarity.COMMON, mage.cards.i.IzzetSignet.class));
        cards.add(new SetCardInfo("Jungle Shrine", 303, Rarity.UNCOMMON, mage.cards.j.JungleShrine.class));
        cards.add(new SetCardInfo("Kamber, the Plunderer", 137, Rarity.RARE, mage.cards.k.KamberThePlunderer.class));
        cards.add(new SetCardInfo("Kaza, Roil Chaser", 232, Rarity.RARE, mage.cards.k.KazaRoilChaser.class));
        cards.add(new SetCardInfo("Kirri, Talented Sprout", 7, Rarity.MYTHIC, mage.cards.k.KirriTalentedSprout.class));
        cards.add(new SetCardInfo("Kodama's Reach", 196, Rarity.COMMON, mage.cards.k.KodamasReach.class));
        cards.add(new SetCardInfo("Krosan Verge", 304, Rarity.UNCOMMON, mage.cards.k.KrosanVerge.class));
        cards.add(new SetCardInfo("Laurine, the Diversion", 172, Rarity.RARE, mage.cards.l.LaurineTheDiversion.class));
        cards.add(new SetCardInfo("Leyline Dowser", 39, Rarity.RARE, mage.cards.l.LeylineDowser.class));
        cards.add(new SetCardInfo("Life Insurance", 233, Rarity.RARE, mage.cards.l.LifeInsurance.class));
        cards.add(new SetCardInfo("Lightning Greaves", 260, Rarity.UNCOMMON, mage.cards.l.LightningGreaves.class));
        cards.add(new SetCardInfo("Llanowar Wastes", 305, Rarity.RARE, mage.cards.l.LlanowarWastes.class));
        cards.add(new SetCardInfo("Lock and Load", 15, Rarity.RARE, mage.cards.l.LockAndLoad.class));
        cards.add(new SetCardInfo("Magmatic Insight", 173, Rarity.UNCOMMON, mage.cards.m.MagmaticInsight.class));
        cards.add(new SetCardInfo("Mari, the Killing Quill", 138, Rarity.RARE, mage.cards.m.MariTheKillingQuill.class));
        cards.add(new SetCardInfo("Marshal's Anthem", 82, Rarity.RARE, mage.cards.m.MarshalsAnthem.class));
        cards.add(new SetCardInfo("Marshland Bloodcaster", 139, Rarity.RARE, mage.cards.m.MarshlandBloodcaster.class));
        cards.add(new SetCardInfo("Mass Mutiny", 174, Rarity.RARE, mage.cards.m.MassMutiny.class));
        cards.add(new SetCardInfo("Massacre Girl", 140, Rarity.RARE, mage.cards.m.MassacreGirl.class));
        cards.add(new SetCardInfo("Midnight Clock", 100, Rarity.RARE, mage.cards.m.MidnightClock.class));
        cards.add(new SetCardInfo("Mind's Dilation", 101, Rarity.MYTHIC, mage.cards.m.MindsDilation.class));
        cards.add(new SetCardInfo("Mirror Entity", 83, Rarity.RARE, mage.cards.m.MirrorEntity.class));
        cards.add(new SetCardInfo("Misfortune Teller", 141, Rarity.RARE, mage.cards.m.MisfortuneTeller.class));
        cards.add(new SetCardInfo("Mistmeadow Skulk", 84, Rarity.UNCOMMON, mage.cards.m.MistmeadowSkulk.class));
        cards.add(new SetCardInfo("Mizzix's Mastery", 175, Rarity.RARE, mage.cards.m.MizzixsMastery.class));
        cards.add(new SetCardInfo("Morbid Opportunist", 142, Rarity.UNCOMMON, mage.cards.m.MorbidOpportunist.class));
        cards.add(new SetCardInfo("Murmuring Mystic", 102, Rarity.COMMON, mage.cards.m.MurmuringMystic.class));
        cards.add(new SetCardInfo("Nantuko Cultivator", 198, Rarity.UNCOMMON, mage.cards.n.NantukoCultivator.class));
        cards.add(new SetCardInfo("Nashi, Moon Sage's Scion", 143, Rarity.MYTHIC, mage.cards.n.NashiMoonSagesScion.class));
        cards.add(new SetCardInfo("Nesting Dragon", 176, Rarity.RARE, mage.cards.n.NestingDragon.class));
        cards.add(new SetCardInfo("Nighthawk Scavenger", 144, Rarity.RARE, mage.cards.n.NighthawkScavenger.class));
        cards.add(new SetCardInfo("Niv-Mizzet, Parun", 235, Rarity.RARE, mage.cards.n.NivMizzetParun.class));
        cards.add(new SetCardInfo("Nomad Outpost", 306, Rarity.UNCOMMON, mage.cards.n.NomadOutpost.class));
        cards.add(new SetCardInfo("Oblivion Sower", 77, Rarity.MYTHIC, mage.cards.o.OblivionSower.class));
        cards.add(new SetCardInfo("Octavia, Living Thesis", 103, Rarity.RARE, mage.cards.o.OctaviaLivingThesis.class));
        cards.add(new SetCardInfo("Ogre Slumlord", 145, Rarity.RARE, mage.cards.o.OgreSlumlord.class));
        cards.add(new SetCardInfo("Ohran Frostfang", 199, Rarity.RARE, mage.cards.o.OhranFrostfang.class));
        cards.add(new SetCardInfo("Olivia, Opulent Outlaw", 2, Rarity.MYTHIC, mage.cards.o.OliviaOpulentOutlaw.class));
        cards.add(new SetCardInfo("Omnath, Locus of Rage", 236, Rarity.MYTHIC, mage.cards.o.OmnathLocusOfRage.class));
        cards.add(new SetCardInfo("Opt", 104, Rarity.COMMON, mage.cards.o.Opt.class));
        cards.add(new SetCardInfo("Opulent Palace", 307, Rarity.UNCOMMON, mage.cards.o.OpulentPalace.class));
        cards.add(new SetCardInfo("Oracle of Mul Daya", 200, Rarity.RARE, mage.cards.o.OracleOfMulDaya.class));
        cards.add(new SetCardInfo("Orochi Soul-Reaver", 22, Rarity.RARE, mage.cards.o.OrochiSoulReaver.class));
        cards.add(new SetCardInfo("Orzhov Signet", 261, Rarity.UNCOMMON, mage.cards.o.OrzhovSignet.class));
        cards.add(new SetCardInfo("Overflowing Basin", 308, Rarity.RARE, mage.cards.o.OverflowingBasin.class));
        cards.add(new SetCardInfo("Painful Truths", 146, Rarity.RARE, mage.cards.p.PainfulTruths.class));
        cards.add(new SetCardInfo("Painted Bluffs", 309, Rarity.COMMON, mage.cards.p.PaintedBluffs.class));
        cards.add(new SetCardInfo("Path of Ancestry", 310, Rarity.COMMON, mage.cards.p.PathOfAncestry.class));
        cards.add(new SetCardInfo("Path to Exile", 85, Rarity.UNCOMMON, mage.cards.p.PathToExile.class));
        cards.add(new SetCardInfo("Perennial Behemoth", 262, Rarity.RARE, mage.cards.p.PerennialBehemoth.class));
        cards.add(new SetCardInfo("Perpetual Timepiece", 263, Rarity.UNCOMMON, mage.cards.p.PerpetualTimepiece.class));
        cards.add(new SetCardInfo("Plasm Capture", 237, Rarity.RARE, mage.cards.p.PlasmCapture.class));
        cards.add(new SetCardInfo("Ponder", 105, Rarity.COMMON, mage.cards.p.Ponder.class));
        cards.add(new SetCardInfo("Pongify", 106, Rarity.UNCOMMON, mage.cards.p.Pongify.class));
        cards.add(new SetCardInfo("Predators' Hour", 147, Rarity.RARE, mage.cards.p.PredatorsHour.class));
        cards.add(new SetCardInfo("Preordain", 107, Rarity.COMMON, mage.cards.p.Preordain.class));
        cards.add(new SetCardInfo("Prismatic Lens", 264, Rarity.UNCOMMON, mage.cards.p.PrismaticLens.class));
        cards.add(new SetCardInfo("Propaganda", 108, Rarity.UNCOMMON, mage.cards.p.Propaganda.class));
        cards.add(new SetCardInfo("Pteramander", 109, Rarity.UNCOMMON, mage.cards.p.Pteramander.class));
        cards.add(new SetCardInfo("Putrefy", 238, Rarity.UNCOMMON, mage.cards.p.Putrefy.class));
        cards.add(new SetCardInfo("Pyretic Charge", 29, Rarity.RARE, mage.cards.p.PyreticCharge.class));
        cards.add(new SetCardInfo("Queen Marchesa", 239, Rarity.RARE, mage.cards.q.QueenMarchesa.class));
        cards.add(new SetCardInfo("Radical Idea", 110, Rarity.COMMON, mage.cards.r.RadicalIdea.class));
        cards.add(new SetCardInfo("Rain of Riches", 177, Rarity.RARE, mage.cards.r.RainOfRiches.class));
        cards.add(new SetCardInfo("Rakdos Signet", 265, Rarity.UNCOMMON, mage.cards.r.RakdosSignet.class));
        cards.add(new SetCardInfo("Rampant Growth", 201, Rarity.COMMON, mage.cards.r.RampantGrowth.class));
        cards.add(new SetCardInfo("Ramunap Excavator", 202, Rarity.RARE, mage.cards.r.RamunapExcavator.class));
        cards.add(new SetCardInfo("Ramunap Ruins", 311, Rarity.UNCOMMON, mage.cards.r.RamunapRuins.class));
        cards.add(new SetCardInfo("Rankle, Master of Pranks", 148, Rarity.RARE, mage.cards.r.RankleMasterOfPranks.class));
        cards.add(new SetCardInfo("Reliquary Tower", 312, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class));
        cards.add(new SetCardInfo("Return of the Wildspeaker", 203, Rarity.RARE, mage.cards.r.ReturnOfTheWildspeaker.class));
        cards.add(new SetCardInfo("Rogue's Passage", 313, Rarity.UNCOMMON, mage.cards.r.RoguesPassage.class));
        cards.add(new SetCardInfo("Rousing Refrain", 178, Rarity.RARE, mage.cards.r.RousingRefrain.class));
        cards.add(new SetCardInfo("Rugged Prairie", 314, Rarity.RARE, mage.cards.r.RuggedPrairie.class));
        cards.add(new SetCardInfo("Rumbleweed", 32, Rarity.RARE, mage.cards.r.Rumbleweed.class));
        cards.add(new SetCardInfo("Sage of the Beyond", 111, Rarity.RARE, mage.cards.s.SageOfTheBeyond.class));
        cards.add(new SetCardInfo("Sand Scout", 11, Rarity.RARE, mage.cards.s.SandScout.class));
        cards.add(new SetCardInfo("Satyr Wayfinder", 204, Rarity.COMMON, mage.cards.s.SatyrWayfinder.class));
        cards.add(new SetCardInfo("Savvy Trader", 33, Rarity.RARE, mage.cards.s.SavvyTrader.class));
        cards.add(new SetCardInfo("Scaretiller", 266, Rarity.COMMON, mage.cards.s.Scaretiller.class));
        cards.add(new SetCardInfo("Scattered Groves", 315, Rarity.RARE, mage.cards.s.ScatteredGroves.class));
        cards.add(new SetCardInfo("Scavenger Grounds", 316, Rarity.RARE, mage.cards.s.ScavengerGrounds.class));
        cards.add(new SetCardInfo("Scute Swarm", 205, Rarity.RARE, mage.cards.s.ScuteSwarm.class));
        cards.add(new SetCardInfo("Seize the Spotlight", 179, Rarity.RARE, mage.cards.s.SeizeTheSpotlight.class));
        cards.add(new SetCardInfo("Serum Visions", 112, Rarity.UNCOMMON, mage.cards.s.SerumVisions.class));
        cards.add(new SetCardInfo("Sevinne's Reclamation", 86, Rarity.RARE, mage.cards.s.SevinnesReclamation.class));
        cards.add(new SetCardInfo("Shadowblood Ridge", 317, Rarity.RARE, mage.cards.s.ShadowbloodRidge.class));
        cards.add(new SetCardInfo("Shadowmage Infiltrator", 240, Rarity.RARE, mage.cards.s.ShadowmageInfiltrator.class));
        cards.add(new SetCardInfo("Shark Typhoon", 113, Rarity.RARE, mage.cards.s.SharkTyphoon.class));
        cards.add(new SetCardInfo("Shefet Dunes", 318, Rarity.UNCOMMON, mage.cards.s.ShefetDunes.class));
        cards.add(new SetCardInfo("Sheltered Thicket", 319, Rarity.RARE, mage.cards.s.ShelteredThicket.class));
        cards.add(new SetCardInfo("Shiny Impetus", 180, Rarity.UNCOMMON, mage.cards.s.ShinyImpetus.class));
        cards.add(new SetCardInfo("Shivan Reef", 320, Rarity.RARE, mage.cards.s.ShivanReef.class));
        cards.add(new SetCardInfo("Silent-Blade Oni", 241, Rarity.RARE, mage.cards.s.SilentBladeOni.class));
        cards.add(new SetCardInfo("Silhana Ledgewalker", 206, Rarity.COMMON, mage.cards.s.SilhanaLedgewalker.class));
        cards.add(new SetCardInfo("Siphon Insight", 242, Rarity.RARE, mage.cards.s.SiphonInsight.class));
        cards.add(new SetCardInfo("Skullwinder", 207, Rarity.UNCOMMON, mage.cards.s.Skullwinder.class));
        cards.add(new SetCardInfo("Slither Blade", 114, Rarity.COMMON, mage.cards.s.SlitherBlade.class));
        cards.add(new SetCardInfo("Smirking Spelljacker", 16, Rarity.RARE, mage.cards.s.SmirkingSpelljacker.class));
        cards.add(new SetCardInfo("Smoldering Marsh", 321, Rarity.RARE, mage.cards.s.SmolderingMarsh.class));
        cards.add(new SetCardInfo("Smoldering Stagecoach", 30, Rarity.RARE, mage.cards.s.SmolderingStagecoach.class));
        cards.add(new SetCardInfo("Sol Ring", 267, Rarity.UNCOMMON, mage.cards.s.SolRing.class));
        cards.add(new SetCardInfo("Springbloom Druid", 208, Rarity.COMMON, mage.cards.s.SpringbloomDruid.class));
        cards.add(new SetCardInfo("Stella Lee, Wild Card", 3, Rarity.MYTHIC, mage.cards.s.StellaLeeWildCard.class));
        cards.add(new SetCardInfo("Stolen Goods", 115, Rarity.RARE, mage.cards.s.StolenGoods.class));
        cards.add(new SetCardInfo("Storm-Kiln Artist", 181, Rarity.UNCOMMON, mage.cards.s.StormKilnArtist.class));
        cards.add(new SetCardInfo("Sulfur Falls", 322, Rarity.RARE, mage.cards.s.SulfurFalls.class));
        cards.add(new SetCardInfo("Sulfurous Springs", 323, Rarity.RARE, mage.cards.s.SulfurousSprings.class));
        cards.add(new SetCardInfo("Sun Titan", 87, Rarity.MYTHIC, mage.cards.s.SunTitan.class));
        cards.add(new SetCardInfo("Sunhome, Fortress of the Legion", 324, Rarity.UNCOMMON, mage.cards.s.SunhomeFortressOfTheLegion.class));
        cards.add(new SetCardInfo("Sunken Hollow", 325, Rarity.RARE, mage.cards.s.SunkenHollow.class));
        cards.add(new SetCardInfo("Sunscorched Divide", 326, Rarity.RARE, mage.cards.s.SunscorchedDivide.class));
        cards.add(new SetCardInfo("Swiftfoot Boots", 268, Rarity.UNCOMMON, mage.cards.s.SwiftfootBoots.class));
        cards.add(new SetCardInfo("Tainted Peak", 327, Rarity.UNCOMMON, mage.cards.t.TaintedPeak.class));
        cards.add(new SetCardInfo("Talrand, Sky Summoner", 116, Rarity.RARE, mage.cards.t.TalrandSkySummoner.class));
        cards.add(new SetCardInfo("Temple of Deceit", 328, Rarity.RARE, mage.cards.t.TempleOfDeceit.class));
        cards.add(new SetCardInfo("Temple of Epiphany", 329, Rarity.RARE, mage.cards.t.TempleOfEpiphany.class));
        cards.add(new SetCardInfo("Temple of Malady", 330, Rarity.RARE, mage.cards.t.TempleOfMalady.class));
        cards.add(new SetCardInfo("Temple of Malice", 331, Rarity.RARE, mage.cards.t.TempleOfMalice.class));
        cards.add(new SetCardInfo("Temple of Mystery", 332, Rarity.RARE, mage.cards.t.TempleOfMystery.class));
        cards.add(new SetCardInfo("Temple of Silence", 333, Rarity.RARE, mage.cards.t.TempleOfSilence.class));
        cards.add(new SetCardInfo("Temple of Triumph", 335, Rarity.RARE, mage.cards.t.TempleOfTriumph.class));
        cards.add(new SetCardInfo("Temple of the False God", 334, Rarity.UNCOMMON, mage.cards.t.TempleOfTheFalseGod.class));
        cards.add(new SetCardInfo("Tenured Inkcaster", 149, Rarity.UNCOMMON, mage.cards.t.TenuredInkcaster.class));
        cards.add(new SetCardInfo("Terramorphic Expanse", 336, Rarity.COMMON, mage.cards.t.TerramorphicExpanse.class));
        cards.add(new SetCardInfo("Tezzeret's Gambit", 117, Rarity.RARE, mage.cards.t.TezzeretsGambit.class));
        cards.add(new SetCardInfo("The Mending of Dominaria", 197, Rarity.RARE, mage.cards.t.TheMendingOfDominaria.class));
        cards.add(new SetCardInfo("The Mimeoplasm", 234, Rarity.RARE, mage.cards.t.TheMimeoplasm.class));
        cards.add(new SetCardInfo("Thief of Sanity", 243, Rarity.RARE, mage.cards.t.ThiefOfSanity.class));
        cards.add(new SetCardInfo("Thieving Amalgam", 150, Rarity.RARE, mage.cards.t.ThievingAmalgam.class));
        cards.add(new SetCardInfo("Thieving Skydiver", 118, Rarity.RARE, mage.cards.t.ThievingSkydiver.class));
        cards.add(new SetCardInfo("Thieving Varmint", 23, Rarity.RARE, mage.cards.t.ThievingVarmint.class));
        cards.add(new SetCardInfo("Think Twice", 119, Rarity.COMMON, mage.cards.t.ThinkTwice.class));
        cards.add(new SetCardInfo("Third Path Iconoclast", 244, Rarity.UNCOMMON, mage.cards.t.ThirdPathIconoclast.class));
        cards.add(new SetCardInfo("Three Visits", 209, Rarity.UNCOMMON, mage.cards.t.ThreeVisits.class));
        cards.add(new SetCardInfo("Thrilling Discovery", 245, Rarity.COMMON, mage.cards.t.ThrillingDiscovery.class));
        cards.add(new SetCardInfo("Thunderclap Drake", 17, Rarity.RARE, mage.cards.t.ThunderclapDrake.class));
        cards.add(new SetCardInfo("Titania, Protector of Argoth", 210, Rarity.MYTHIC, mage.cards.t.TitaniaProtectorOfArgoth.class));
        cards.add(new SetCardInfo("Tower Winder", 34, Rarity.RARE, mage.cards.t.TowerWinder.class));
        cards.add(new SetCardInfo("Trailblazer's Boots", 269, Rarity.UNCOMMON, mage.cards.t.TrailblazersBoots.class));
        cards.add(new SetCardInfo("Treasure Cruise", 120, Rarity.COMMON, mage.cards.t.TreasureCruise.class));
        cards.add(new SetCardInfo("Triton Shorestalker", 121, Rarity.COMMON, mage.cards.t.TritonShorestalker.class));
        cards.add(new SetCardInfo("Trygon Predator", 246, Rarity.UNCOMMON, mage.cards.t.TrygonPredator.class));
        cards.add(new SetCardInfo("Turntimber Sower", 211, Rarity.RARE, mage.cards.t.TurntimberSower.class));
        cards.add(new SetCardInfo("Twilight Mire", 337, Rarity.RARE, mage.cards.t.TwilightMire.class));
        cards.add(new SetCardInfo("Ukkima, Stalking Shadow", 247, Rarity.MYTHIC, mage.cards.u.UkkimaStalkingShadow.class));
        cards.add(new SetCardInfo("Underground River", 338, Rarity.RARE, mage.cards.u.UndergroundRiver.class));
        cards.add(new SetCardInfo("Unholy Heat", 182, Rarity.COMMON, mage.cards.u.UnholyHeat.class));
        cards.add(new SetCardInfo("Valorous Stance", 88, Rarity.UNCOMMON, mage.cards.v.ValorousStance.class));
        cards.add(new SetCardInfo("Vandalblast", 183, Rarity.UNCOMMON, mage.cards.v.Vandalblast.class));
        cards.add(new SetCardInfo("Vault of the Archangel", 339, Rarity.RARE, mage.cards.v.VaultOfTheArchangel.class));
        cards.add(new SetCardInfo("Veinwitch Coven", 151, Rarity.RARE, mage.cards.v.VeinwitchCoven.class));
        cards.add(new SetCardInfo("Vengeful Regrowth", 35, Rarity.RARE, mage.cards.v.VengefulRegrowth.class));
        cards.add(new SetCardInfo("Veyran, Voice of Duality", 248, Rarity.MYTHIC, mage.cards.v.VeyranVoiceOfDuality.class));
        cards.add(new SetCardInfo("Vihaan, Goldwaker", 8, Rarity.MYTHIC, mage.cards.v.VihaanGoldwaker.class));
        cards.add(new SetCardInfo("Villainous Wealth", 249, Rarity.RARE, mage.cards.v.VillainousWealth.class));
        cards.add(new SetCardInfo("Viridescent Bog", 340, Rarity.RARE, mage.cards.v.ViridescentBog.class));
        cards.add(new SetCardInfo("Void Attendant", 212, Rarity.UNCOMMON, mage.cards.v.VoidAttendant.class));
        cards.add(new SetCardInfo("Volcanic Torrent", 184, Rarity.UNCOMMON, mage.cards.v.VolcanicTorrent.class));
        cards.add(new SetCardInfo("We Ride at Dawn", 12, Rarity.RARE, mage.cards.w.WeRideAtDawn.class));
        cards.add(new SetCardInfo("Whirler Rogue", 122, Rarity.UNCOMMON, mage.cards.w.WhirlerRogue.class));
        cards.add(new SetCardInfo("Windfall", 123, Rarity.UNCOMMON, mage.cards.w.Windfall.class));
        cards.add(new SetCardInfo("Winding Way", 213, Rarity.COMMON, mage.cards.w.WindingWay.class));
        cards.add(new SetCardInfo("Winged Boots", 124, Rarity.RARE, mage.cards.w.WingedBoots.class));
        cards.add(new SetCardInfo("Witch of the Moors", 152, Rarity.RARE, mage.cards.w.WitchOfTheMoors.class));
        cards.add(new SetCardInfo("Woodland Cemetery", 341, Rarity.RARE, mage.cards.w.WoodlandCemetery.class));
        cards.add(new SetCardInfo("World Shaper", 214, Rarity.RARE, mage.cards.w.WorldShaper.class));
        cards.add(new SetCardInfo("Wreck and Rebuild", 250, Rarity.UNCOMMON, mage.cards.w.WreckAndRebuild.class));
        cards.add(new SetCardInfo("Yavimaya Coast", 342, Rarity.RARE, mage.cards.y.YavimayaCoast.class));
        cards.add(new SetCardInfo("Young Pyromancer", 185, Rarity.UNCOMMON, mage.cards.y.YoungPyromancer.class));
        cards.add(new SetCardInfo("Yuma, Proud Protector", 4, Rarity.MYTHIC, mage.cards.y.YumaProudProtector.class));
    }
}
