package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class NewCapennaCommander extends ExpansionSet {

    private static final NewCapennaCommander instance = new NewCapennaCommander();

    public static NewCapennaCommander getInstance() {
        return instance;
    }

    private NewCapennaCommander() {
        super("New Capenna Commander", "NCC", ExpansionSet.buildDate(2022, 4, 29), SetType.SUPPLEMENTAL);
        this.hasBasicLands = false;

        cards.add(new SetCardInfo("Aerial Extortionist", 11, Rarity.RARE, mage.cards.a.AerialExtortionist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aerial Extortionist", 112, Rarity.RARE, mage.cards.a.AerialExtortionist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aether Snap", 241, Rarity.RARE, mage.cards.a.AetherSnap.class));
        cards.add(new SetCardInfo("Agent's Toolkit", 166, Rarity.RARE, mage.cards.a.AgentsToolkit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Agent's Toolkit", 66, Rarity.RARE, mage.cards.a.AgentsToolkit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Agitator Ant", 263, Rarity.RARE, mage.cards.a.AgitatorAnt.class));
        cards.add(new SetCardInfo("Ajani Unyielding", 324, Rarity.MYTHIC, mage.cards.a.AjaniUnyielding.class));
        cards.add(new SetCardInfo("Alela, Artful Provocateur", 325, Rarity.MYTHIC, mage.cards.a.AlelaArtfulProvocateur.class));
        cards.add(new SetCardInfo("Angelic Sleuth", 113, Rarity.RARE, mage.cards.a.AngelicSleuth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angelic Sleuth", 12, Rarity.RARE, mage.cards.a.AngelicSleuth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anhelo, the Painter", 1, Rarity.MYTHIC, mage.cards.a.AnheloThePainter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anhelo, the Painter", 100, Rarity.MYTHIC, mage.cards.a.AnheloThePainter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anhelo, the Painter", 186, Rarity.MYTHIC, mage.cards.a.AnheloThePainter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arasta of the Endless Web", 279, Rarity.RARE, mage.cards.a.ArastaOfTheEndlessWeb.class));
        cards.add(new SetCardInfo("Arcane Sanctum", 385, Rarity.UNCOMMON, mage.cards.a.ArcaneSanctum.class));
        cards.add(new SetCardInfo("Arcane Signet", 360, Rarity.COMMON, mage.cards.a.ArcaneSignet.class));
        cards.add(new SetCardInfo("Archon of Coronation", 192, Rarity.MYTHIC, mage.cards.a.ArchonOfCoronation.class));
        cards.add(new SetCardInfo("Army of the Damned", 242, Rarity.MYTHIC, mage.cards.a.ArmyOfTheDamned.class));
        cards.add(new SetCardInfo("Artifact Mutation", 326, Rarity.RARE, mage.cards.a.ArtifactMutation.class));
        cards.add(new SetCardInfo("Artisan of Kozilek", 191, Rarity.UNCOMMON, mage.cards.a.ArtisanOfKozilek.class));
        cards.add(new SetCardInfo("Ash Barrens", 386, Rarity.UNCOMMON, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Assemble the Legion", 327, Rarity.RARE, mage.cards.a.AssembleTheLegion.class));
        cards.add(new SetCardInfo("Audacious Swap", 145, Rarity.RARE, mage.cards.a.AudaciousSwap.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Audacious Swap", 44, Rarity.RARE, mage.cards.a.AudaciousSwap.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aura Mutation", 328, Rarity.RARE, mage.cards.a.AuraMutation.class));
        cards.add(new SetCardInfo("Austere Command", 193, Rarity.RARE, mage.cards.a.AustereCommand.class));
        cards.add(new SetCardInfo("Aven Courier", 123, Rarity.RARE, mage.cards.a.AvenCourier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aven Courier", 22, Rarity.RARE, mage.cards.a.AvenCourier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aven Mimeomancer", 329, Rarity.RARE, mage.cards.a.AvenMimeomancer.class));
        cards.add(new SetCardInfo("Avenger of Zendikar", 280, Rarity.MYTHIC, mage.cards.a.AvengerOfZendikar.class));
        cards.add(new SetCardInfo("Avenging Huntbonder", 194, Rarity.RARE, mage.cards.a.AvengingHuntbonder.class));
        cards.add(new SetCardInfo("Awakening Zone", 281, Rarity.RARE, mage.cards.a.AwakeningZone.class));
        cards.add(new SetCardInfo("Azorius Signet", 361, Rarity.UNCOMMON, mage.cards.a.AzoriusSignet.class));
        cards.add(new SetCardInfo("Bant Charm", 330, Rarity.UNCOMMON, mage.cards.b.BantCharm.class));
        cards.add(new SetCardInfo("Bant Panorama", 387, Rarity.COMMON, mage.cards.b.BantPanorama.class));
        cards.add(new SetCardInfo("Beast Within", 282, Rarity.UNCOMMON, mage.cards.b.BeastWithin.class));
        cards.add(new SetCardInfo("Beastmaster Ascension", 283, Rarity.RARE, mage.cards.b.BeastmasterAscension.class));
        cards.add(new SetCardInfo("Bedevil", 331, Rarity.RARE, mage.cards.b.Bedevil.class));
        cards.add(new SetCardInfo("Bellowing Mauler", 134, Rarity.RARE, mage.cards.b.BellowingMauler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bellowing Mauler", 33, Rarity.RARE, mage.cards.b.BellowingMauler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bennie Bracks, Zoologist", 86, Rarity.MYTHIC, mage.cards.b.BennieBracksZoologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bennie Bracks, Zoologist", 94, Rarity.MYTHIC, mage.cards.b.BennieBracksZoologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bess, Soul Nourisher", 167, Rarity.RARE, mage.cards.b.BessSoulNourisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bess, Soul Nourisher", 67, Rarity.RARE, mage.cards.b.BessSoulNourisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blasphemous Act", 264, Rarity.RARE, mage.cards.b.BlasphemousAct.class));
        cards.add(new SetCardInfo("Blighted Woodland", 388, Rarity.UNCOMMON, mage.cards.b.BlightedWoodland.class));
        cards.add(new SetCardInfo("Bloodsoaked Champion", 243, Rarity.RARE, mage.cards.b.BloodsoakedChampion.class));
        cards.add(new SetCardInfo("Bloodthirsty Blade", 362, Rarity.UNCOMMON, mage.cards.b.BloodthirstyBlade.class));
        cards.add(new SetCardInfo("Body Count", 135, Rarity.RARE, mage.cards.b.BodyCount.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Body Count", 34, Rarity.RARE, mage.cards.b.BodyCount.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boros Charm", 332, Rarity.UNCOMMON, mage.cards.b.BorosCharm.class));
        cards.add(new SetCardInfo("Boss's Chauffeur", 114, Rarity.RARE, mage.cards.b.BosssChauffeur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boss's Chauffeur", 13, Rarity.RARE, mage.cards.b.BosssChauffeur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boxing Ring", 91, Rarity.RARE, mage.cards.b.BoxingRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boxing Ring", 99, Rarity.RARE, mage.cards.b.BoxingRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bribe Taker", 155, Rarity.RARE, mage.cards.b.BribeTaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bribe Taker", 55, Rarity.RARE, mage.cards.b.BribeTaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brokers Confluence", 168, Rarity.RARE, mage.cards.b.BrokersConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brokers Confluence", 68, Rarity.RARE, mage.cards.b.BrokersConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cabaretti Confluence", 169, Rarity.RARE, mage.cards.c.CabarettiConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cabaretti Confluence", 69, Rarity.RARE, mage.cards.c.CabarettiConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Caldaia Guardian", 156, Rarity.RARE, mage.cards.c.CaldaiaGuardian.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Caldaia Guardian", 56, Rarity.RARE, mage.cards.c.CaldaiaGuardian.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Call the Coppercoats", 195, Rarity.RARE, mage.cards.c.CallTheCoppercoats.class));
        cards.add(new SetCardInfo("Call the Skybreaker", 333, Rarity.RARE, mage.cards.c.CallTheSkybreaker.class));
        cards.add(new SetCardInfo("Camaraderie", 334, Rarity.RARE, mage.cards.c.Camaraderie.class));
        cards.add(new SetCardInfo("Canopy Vista", 389, Rarity.RARE, mage.cards.c.CanopyVista.class));
        cards.add(new SetCardInfo("Cascade Bluffs", 390, Rarity.RARE, mage.cards.c.CascadeBluffs.class));
        cards.add(new SetCardInfo("Castle Ardenvale", 391, Rarity.RARE, mage.cards.c.CastleArdenvale.class));
        cards.add(new SetCardInfo("Castle Embereth", 392, Rarity.RARE, mage.cards.c.CastleEmbereth.class));
        cards.add(new SetCardInfo("Cephalid Facetaker", 124, Rarity.RARE, mage.cards.c.CephalidFacetaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cephalid Facetaker", 23, Rarity.RARE, mage.cards.c.CephalidFacetaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chain Reaction", 265, Rarity.RARE, mage.cards.c.ChainReaction.class));
        cards.add(new SetCardInfo("Champion of Lambholt", 284, Rarity.RARE, mage.cards.c.ChampionOfLambholt.class));
        cards.add(new SetCardInfo("Champion of Wits", 213, Rarity.RARE, mage.cards.c.ChampionOfWits.class));
        cards.add(new SetCardInfo("Change of Plans", 125, Rarity.RARE, mage.cards.c.ChangeOfPlans.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Change of Plans", 24, Rarity.RARE, mage.cards.c.ChangeOfPlans.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chaos Warp", 266, Rarity.RARE, mage.cards.c.ChaosWarp.class));
        cards.add(new SetCardInfo("Chasm Skulker", 214, Rarity.RARE, mage.cards.c.ChasmSkulker.class));
        cards.add(new SetCardInfo("Choked Estuary", 393, Rarity.RARE, mage.cards.c.ChokedEstuary.class));
        cards.add(new SetCardInfo("Cinder Glade", 394, Rarity.RARE, mage.cards.c.CinderGlade.class));
        cards.add(new SetCardInfo("Clone Legion", 215, Rarity.MYTHIC, mage.cards.c.CloneLegion.class));
        cards.add(new SetCardInfo("Command Tower", 395, Rarity.COMMON, mage.cards.c.CommandTower.class));
        cards.add(new SetCardInfo("Commander's Sphere", 363, Rarity.COMMON, mage.cards.c.CommandersSphere.class));
        cards.add(new SetCardInfo("Commit // Memory", 216, Rarity.RARE, mage.cards.c.CommitMemory.class));
        cards.add(new SetCardInfo("Contractual Safeguard", 115, Rarity.RARE, mage.cards.c.ContractualSafeguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Contractual Safeguard", 14, Rarity.RARE, mage.cards.c.ContractualSafeguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crash the Party", 157, Rarity.RARE, mage.cards.c.CrashTheParty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crash the Party", 57, Rarity.RARE, mage.cards.c.CrashTheParty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Creeping Tar Pit", 396, Rarity.RARE, mage.cards.c.CreepingTarPit.class));
        cards.add(new SetCardInfo("Crumbling Necropolis", 397, Rarity.UNCOMMON, mage.cards.c.CrumblingNecropolis.class));
        cards.add(new SetCardInfo("Cryptic Pursuit", 170, Rarity.RARE, mage.cards.c.CrypticPursuit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cryptic Pursuit", 70, Rarity.RARE, mage.cards.c.CrypticPursuit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crystalline Giant", 364, Rarity.RARE, mage.cards.c.CrystallineGiant.class));
        cards.add(new SetCardInfo("Cultivate", 285, Rarity.COMMON, mage.cards.c.Cultivate.class));
        cards.add(new SetCardInfo("Currency Converter", 181, Rarity.RARE, mage.cards.c.CurrencyConverter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Currency Converter", 81, Rarity.RARE, mage.cards.c.CurrencyConverter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Custodi Lich", 244, Rarity.RARE, mage.cards.c.CustodiLich.class));
        cards.add(new SetCardInfo("Damnable Pact", 245, Rarity.RARE, mage.cards.d.DamnablePact.class));
        cards.add(new SetCardInfo("Damning Verdict", 116, Rarity.RARE, mage.cards.d.DamningVerdict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Damning Verdict", 15, Rarity.RARE, mage.cards.d.DamningVerdict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Daring Saboteur", 217, Rarity.UNCOMMON, mage.cards.d.DaringSaboteur.class));
        cards.add(new SetCardInfo("Darkwater Catacombs", 398, Rarity.RARE, mage.cards.d.DarkwaterCatacombs.class));
        cards.add(new SetCardInfo("Daxos of Meletis", 335, Rarity.RARE, mage.cards.d.DaxosOfMeletis.class));
        cards.add(new SetCardInfo("Deathbringer Regent", 246, Rarity.RARE, mage.cards.d.DeathbringerRegent.class));
        cards.add(new SetCardInfo("Deathreap Ritual", 336, Rarity.UNCOMMON, mage.cards.d.DeathreapRitual.class));
        cards.add(new SetCardInfo("Declaration in Stone", 196, Rarity.RARE, mage.cards.d.DeclarationInStone.class));
        cards.add(new SetCardInfo("Deep Analysis", 218, Rarity.COMMON, mage.cards.d.DeepAnalysis.class));
        cards.add(new SetCardInfo("Denry Klin, Editor in Chief", 171, Rarity.RARE, mage.cards.d.DenryKlinEditorInChief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Denry Klin, Editor in Chief", 71, Rarity.RARE, mage.cards.d.DenryKlinEditorInChief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Determined Iteration", 146, Rarity.RARE, mage.cards.d.DeterminedIteration.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Determined Iteration", 45, Rarity.RARE, mage.cards.d.DeterminedIteration.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Devoted Druid", 286, Rarity.UNCOMMON, mage.cards.d.DevotedDruid.class));
        cards.add(new SetCardInfo("Dig Through Time", 219, Rarity.RARE, mage.cards.d.DigThroughTime.class));
        cards.add(new SetCardInfo("Dimir Signet", 365, Rarity.COMMON, mage.cards.d.DimirSignet.class));
        cards.add(new SetCardInfo("Disciple of Bolas", 247, Rarity.RARE, mage.cards.d.DiscipleOfBolas.class));
        cards.add(new SetCardInfo("Dodgy Jalopy", 158, Rarity.RARE, mage.cards.d.DodgyJalopy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dodgy Jalopy", 58, Rarity.RARE, mage.cards.d.DodgyJalopy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dogged Detective", 136, Rarity.RARE, mage.cards.d.DoggedDetective.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dogged Detective", 35, Rarity.RARE, mage.cards.d.DoggedDetective.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Double Vision", 267, Rarity.RARE, mage.cards.d.DoubleVision.class));
        cards.add(new SetCardInfo("Dragonlord Ojutai", 337, Rarity.MYTHIC, mage.cards.d.DragonlordOjutai.class));
        cards.add(new SetCardInfo("Drana, Liberator of Malakir", 248, Rarity.MYTHIC, mage.cards.d.DranaLiberatorOfMalakir.class));
        cards.add(new SetCardInfo("Drawn from Dreams", 220, Rarity.RARE, mage.cards.d.DrawnFromDreams.class));
        cards.add(new SetCardInfo("Dread Summons", 249, Rarity.RARE, mage.cards.d.DreadSummons.class));
        cards.add(new SetCardInfo("Duelist's Heritage", 197, Rarity.RARE, mage.cards.d.DuelistsHeritage.class));
        cards.add(new SetCardInfo("Dusk // Dawn", 198, Rarity.RARE, mage.cards.d.DuskDawn.class));
        cards.add(new SetCardInfo("Esper Panorama", 399, Rarity.COMMON, mage.cards.e.EsperPanorama.class));
        cards.add(new SetCardInfo("Etali, Primal Storm", 268, Rarity.RARE, mage.cards.e.EtaliPrimalStorm.class));
        cards.add(new SetCardInfo("Everflowing Chalice", 366, Rarity.UNCOMMON, mage.cards.e.EverflowingChalice.class));
        cards.add(new SetCardInfo("Evolution Sage", 287, Rarity.UNCOMMON, mage.cards.e.EvolutionSage.class));
        cards.add(new SetCardInfo("Evolutionary Leap", 288, Rarity.RARE, mage.cards.e.EvolutionaryLeap.class));
        cards.add(new SetCardInfo("Exotic Orchard", 400, Rarity.RARE, mage.cards.e.ExoticOrchard.class));
        cards.add(new SetCardInfo("Explore", 289, Rarity.COMMON, mage.cards.e.Explore.class));
        cards.add(new SetCardInfo("Extravagant Replication", 126, Rarity.RARE, mage.cards.e.ExtravagantReplication.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Extravagant Replication", 25, Rarity.RARE, mage.cards.e.ExtravagantReplication.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fact or Fiction", 221, Rarity.UNCOMMON, mage.cards.f.FactOrFiction.class));
        cards.add(new SetCardInfo("Fallen Shinobi", 338, Rarity.RARE, mage.cards.f.FallenShinobi.class));
        cards.add(new SetCardInfo("False Floor", 182, Rarity.RARE, mage.cards.f.FalseFloor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("False Floor", 82, Rarity.RARE, mage.cards.f.FalseFloor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Family's Favor", 159, Rarity.RARE, mage.cards.f.FamilysFavor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Family's Favor", 59, Rarity.RARE, mage.cards.f.FamilysFavor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Farseek", 290, Rarity.COMMON, mage.cards.f.Farseek.class));
        cards.add(new SetCardInfo("Fathom Mage", 339, Rarity.RARE, mage.cards.f.FathomMage.class));
        cards.add(new SetCardInfo("Feed the Swarm", 250, Rarity.COMMON, mage.cards.f.FeedTheSwarm.class));
        cards.add(new SetCardInfo("Felidar Retreat", 199, Rarity.RARE, mage.cards.f.FelidarRetreat.class));
        cards.add(new SetCardInfo("Fell the Mighty", 200, Rarity.RARE, mage.cards.f.FellTheMighty.class));
        cards.add(new SetCardInfo("Fellwar Stone", 367, Rarity.UNCOMMON, mage.cards.f.FellwarStone.class));
        cards.add(new SetCardInfo("Fetid Heath", 401, Rarity.RARE, mage.cards.f.FetidHeath.class));
        cards.add(new SetCardInfo("First Responder", 160, Rarity.RARE, mage.cards.f.FirstResponder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("First Responder", 60, Rarity.RARE, mage.cards.f.FirstResponder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flawless Forgery", 127, Rarity.RARE, mage.cards.f.FlawlessForgery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flawless Forgery", 26, Rarity.RARE, mage.cards.f.FlawlessForgery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flooded Grove", 402, Rarity.RARE, mage.cards.f.FloodedGrove.class));
        cards.add(new SetCardInfo("Foreboding Ruins", 403, Rarity.RARE, mage.cards.f.ForebodingRuins.class));
        cards.add(new SetCardInfo("Forgotten Ancient", 291, Rarity.RARE, mage.cards.f.ForgottenAncient.class));
        cards.add(new SetCardInfo("Fortified Village", 404, Rarity.RARE, mage.cards.f.FortifiedVillage.class));
        cards.add(new SetCardInfo("Frantic Search", 222, Rarity.COMMON, mage.cards.f.FranticSearch.class));
        cards.add(new SetCardInfo("Gahiji, Honored One", 340, Rarity.MYTHIC, mage.cards.g.GahijiHonoredOne.class));
        cards.add(new SetCardInfo("Game Trail", 405, Rarity.RARE, mage.cards.g.GameTrail.class));
        cards.add(new SetCardInfo("Garruk's Uprising", 292, Rarity.UNCOMMON, mage.cards.g.GarruksUprising.class));
        cards.add(new SetCardInfo("Gavel of the Righteous", 183, Rarity.RARE, mage.cards.g.GavelOfTheRighteous.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gavel of the Righteous", 83, Rarity.RARE, mage.cards.g.GavelOfTheRighteous.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gavony Township", 406, Rarity.RARE, mage.cards.g.GavonyTownship.class));
        cards.add(new SetCardInfo("Generous Gift", 201, Rarity.UNCOMMON, mage.cards.g.GenerousGift.class));
        cards.add(new SetCardInfo("Ghostly Pilferer", 223, Rarity.RARE, mage.cards.g.GhostlyPilferer.class));
        cards.add(new SetCardInfo("Giant Adephage", 293, Rarity.MYTHIC, mage.cards.g.GiantAdephage.class));
        cards.add(new SetCardInfo("Goblin Electromancer", 341, Rarity.COMMON, mage.cards.g.GoblinElectromancer.class));
        cards.add(new SetCardInfo("Grand Crescendo", 117, Rarity.RARE, mage.cards.g.GrandCrescendo.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Crescendo", 16, Rarity.RARE, mage.cards.g.GrandCrescendo.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grateful Apparition", 202, Rarity.UNCOMMON, mage.cards.g.GratefulApparition.class));
        cards.add(new SetCardInfo("Graveblade Marauder", 251, Rarity.RARE, mage.cards.g.GravebladeMarauder.class));
        cards.add(new SetCardInfo("Greenwarden of Murasa", 294, Rarity.MYTHIC, mage.cards.g.GreenwardenOfMurasa.class));
        cards.add(new SetCardInfo("Grime Gorger", 172, Rarity.RARE, mage.cards.g.GrimeGorger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grime Gorger", 72, Rarity.RARE, mage.cards.g.GrimeGorger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grixis Panorama", 407, Rarity.COMMON, mage.cards.g.GrixisPanorama.class));
        cards.add(new SetCardInfo("Harmonize", 295, Rarity.UNCOMMON, mage.cards.h.Harmonize.class));
        cards.add(new SetCardInfo("Henzie \"Toolbox\" Torre", 102, Rarity.MYTHIC, mage.cards.h.HenzieToolboxTorre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Henzie \"Toolbox\" Torre", 187, Rarity.MYTHIC, mage.cards.h.HenzieToolboxTorre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Henzie \"Toolbox\" Torre", 2, Rarity.MYTHIC, mage.cards.h.HenzieToolboxTorre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hex", 252, Rarity.RARE, mage.cards.h.Hex.class));
        cards.add(new SetCardInfo("Hoofprints of the Stag", 203, Rarity.RARE, mage.cards.h.HoofprintsOfTheStag.class));
        cards.add(new SetCardInfo("Identity Thief", 224, Rarity.RARE, mage.cards.i.IdentityThief.class));
        cards.add(new SetCardInfo("Idol of Oblivion", 368, Rarity.RARE, mage.cards.i.IdolOfOblivion.class));
        cards.add(new SetCardInfo("In Too Deep", 128, Rarity.RARE, mage.cards.i.InTooDeep.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("In Too Deep", 27, Rarity.RARE, mage.cards.i.InTooDeep.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Incubation Druid", 296, Rarity.RARE, mage.cards.i.IncubationDruid.class));
        cards.add(new SetCardInfo("Indrik Stomphowler", 297, Rarity.UNCOMMON, mage.cards.i.IndrikStomphowler.class));
        cards.add(new SetCardInfo("Indulge // Excess", 46, Rarity.RARE, mage.cards.i.IndulgeExcess.class));
        cards.add(new SetCardInfo("Industrial Advancement", 147, Rarity.RARE, mage.cards.i.IndustrialAdvancement.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Industrial Advancement", 47, Rarity.RARE, mage.cards.i.IndustrialAdvancement.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inferno Titan", 269, Rarity.MYTHIC, mage.cards.i.InfernoTitan.class));
        cards.add(new SetCardInfo("Inkfathom Witch", 342, Rarity.UNCOMMON, mage.cards.i.InkfathomWitch.class));
        cards.add(new SetCardInfo("Intangible Virtue", 204, Rarity.UNCOMMON, mage.cards.i.IntangibleVirtue.class));
        cards.add(new SetCardInfo("Izzet Signet", 369, Rarity.COMMON, mage.cards.i.IzzetSignet.class));
        cards.add(new SetCardInfo("Jailbreak", 118, Rarity.RARE, mage.cards.j.Jailbreak.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jailbreak", 17, Rarity.RARE, mage.cards.j.Jailbreak.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jenara, Asura of War", 343, Rarity.MYTHIC, mage.cards.j.JenaraAsuraOfWar.class));
        cards.add(new SetCardInfo("Jolene, the Plunder Queen", 173, Rarity.RARE, mage.cards.j.JoleneThePlunderQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jolene, the Plunder Queen", 73, Rarity.RARE, mage.cards.j.JoleneThePlunderQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jund Panorama", 408, Rarity.COMMON, mage.cards.j.JundPanorama.class));
        cards.add(new SetCardInfo("Jungle Shrine", 409, Rarity.UNCOMMON, mage.cards.j.JungleShrine.class));
        cards.add(new SetCardInfo("Kamiz, Obscura Oculus", 103, Rarity.MYTHIC, mage.cards.k.KamizObscuraOculus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kamiz, Obscura Oculus", 188, Rarity.MYTHIC, mage.cards.k.KamizObscuraOculus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kamiz, Obscura Oculus", 3, Rarity.MYTHIC, mage.cards.k.KamizObscuraOculus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn's Bastion", 410, Rarity.RARE, mage.cards.k.KarnsBastion.class));
        cards.add(new SetCardInfo("Kazuul, Tyrant of the Cliffs", 270, Rarity.RARE, mage.cards.k.KazuulTyrantOfTheCliffs.class));
        cards.add(new SetCardInfo("Kess, Dissident Mage", 344, Rarity.MYTHIC, mage.cards.k.KessDissidentMage.class));
        cards.add(new SetCardInfo("Kessig Wolf Run", 411, Rarity.RARE, mage.cards.k.KessigWolfRun.class));
        cards.add(new SetCardInfo("Killer Service", 161, Rarity.RARE, mage.cards.k.KillerService.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Killer Service", 61, Rarity.RARE, mage.cards.k.KillerService.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kitt Kanto, Mayhem Diva", 104, Rarity.MYTHIC, mage.cards.k.KittKantoMayhemDiva.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kitt Kanto, Mayhem Diva", 189, Rarity.MYTHIC, mage.cards.k.KittKantoMayhemDiva.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kitt Kanto, Mayhem Diva", 4, Rarity.MYTHIC, mage.cards.k.KittKantoMayhemDiva.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kodama's Reach", 298, Rarity.COMMON, mage.cards.k.KodamasReach.class));
        cards.add(new SetCardInfo("Kresh the Bloodbraided", 345, Rarity.MYTHIC, mage.cards.k.KreshTheBloodbraided.class));
        cards.add(new SetCardInfo("Kros, Defense Contractor", 105, Rarity.MYTHIC, mage.cards.k.KrosDefenseContractor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kros, Defense Contractor", 7, Rarity.MYTHIC, mage.cards.k.KrosDefenseContractor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leafkin Druid", 299, Rarity.COMMON, mage.cards.l.LeafkinDruid.class));
        cards.add(new SetCardInfo("Lethal Scheme", 137, Rarity.RARE, mage.cards.l.LethalScheme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lethal Scheme", 36, Rarity.RARE, mage.cards.l.LethalScheme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Life Insurance", 174, Rarity.RARE, mage.cards.l.LifeInsurance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Life Insurance", 74, Rarity.RARE, mage.cards.l.LifeInsurance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Life of the Party", 148, Rarity.RARE, mage.cards.l.LifeOfTheParty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Life of the Party", 48, Rarity.RARE, mage.cards.l.LifeOfTheParty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Life's Legacy", 300, Rarity.RARE, mage.cards.l.LifesLegacy.class));
        cards.add(new SetCardInfo("Lifecrafter's Bestiary", 370, Rarity.RARE, mage.cards.l.LifecraftersBestiary.class));
        cards.add(new SetCardInfo("Lightning Greaves", 371, Rarity.UNCOMMON, mage.cards.l.LightningGreaves.class));
        cards.add(new SetCardInfo("Littjara Mirrorlake", 412, Rarity.UNCOMMON, mage.cards.l.LittjaraMirrorlake.class));
        cards.add(new SetCardInfo("Llanowar Reborn", 413, Rarity.UNCOMMON, mage.cards.l.LlanowarReborn.class));
        cards.add(new SetCardInfo("Looter il-Kor", 225, Rarity.COMMON, mage.cards.l.LooterIlKor.class));
        cards.add(new SetCardInfo("Luminarch Aspirant", 205, Rarity.RARE, mage.cards.l.LuminarchAspirant.class));
        cards.add(new SetCardInfo("Maestros Confluence", 175, Rarity.RARE, mage.cards.m.MaestrosConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maestros Confluence", 75, Rarity.RARE, mage.cards.m.MaestrosConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Magus of the Wheel", 271, Rarity.RARE, mage.cards.m.MagusOfTheWheel.class));
        cards.add(new SetCardInfo("Make an Example", 138, Rarity.RARE, mage.cards.m.MakeAnExample.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Make an Example", 37, Rarity.RARE, mage.cards.m.MakeAnExample.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("March of the Multitudes", 346, Rarity.MYTHIC, mage.cards.m.MarchOfTheMultitudes.class));
        cards.add(new SetCardInfo("Mari, the Killing Quill", 89, Rarity.RARE, mage.cards.m.MariTheKillingQuill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mari, the Killing Quill", 97, Rarity.RARE, mage.cards.m.MariTheKillingQuill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Martial Coup", 206, Rarity.RARE, mage.cards.m.MartialCoup.class));
        cards.add(new SetCardInfo("Mask of Riddles", 347, Rarity.UNCOMMON, mage.cards.m.MaskOfRiddles.class));
        cards.add(new SetCardInfo("Mask of the Schemer", 129, Rarity.RARE, mage.cards.m.MaskOfTheSchemer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mask of the Schemer", 28, Rarity.RARE, mage.cards.m.MaskOfTheSchemer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Master of Ceremonies", 119, Rarity.RARE, mage.cards.m.MasterOfCeremonies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Master of Ceremonies", 18, Rarity.RARE, mage.cards.m.MasterOfCeremonies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mezzio Mugger", 149, Rarity.RARE, mage.cards.m.MezzioMugger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mezzio Mugger", 49, Rarity.RARE, mage.cards.m.MezzioMugger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Midnight Clock", 226, Rarity.RARE, mage.cards.m.MidnightClock.class));
        cards.add(new SetCardInfo("Migration Path", 301, Rarity.UNCOMMON, mage.cards.m.MigrationPath.class));
        cards.add(new SetCardInfo("Mimic Vat", 372, Rarity.RARE, mage.cards.m.MimicVat.class));
        cards.add(new SetCardInfo("Misfortune Teller", 139, Rarity.RARE, mage.cards.m.MisfortuneTeller.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Misfortune Teller", 38, Rarity.RARE, mage.cards.m.MisfortuneTeller.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mitotic Slime", 302, Rarity.RARE, mage.cards.m.MitoticSlime.class));
        cards.add(new SetCardInfo("Mossfire Valley", 414, Rarity.RARE, mage.cards.m.MossfireValley.class));
        cards.add(new SetCardInfo("Mosswort Bridge", 415, Rarity.RARE, mage.cards.m.MosswortBridge.class));
        cards.add(new SetCardInfo("Myriad Landscape", 416, Rarity.UNCOMMON, mage.cards.m.MyriadLandscape.class));
        cards.add(new SetCardInfo("Mystic Confluence", 227, Rarity.RARE, mage.cards.m.MysticConfluence.class));
        cards.add(new SetCardInfo("Nadir Kraken", 228, Rarity.RARE, mage.cards.n.NadirKraken.class));
        cards.add(new SetCardInfo("Naya Panorama", 417, Rarity.COMMON, mage.cards.n.NayaPanorama.class));
        cards.add(new SetCardInfo("Nesting Grounds", 418, Rarity.RARE, mage.cards.n.NestingGrounds.class));
        cards.add(new SetCardInfo("Next of Kin", 162, Rarity.RARE, mage.cards.n.NextOfKin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Next of Kin", 62, Rarity.RARE, mage.cards.n.NextOfKin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nightmare Unmaking", 253, Rarity.RARE, mage.cards.n.NightmareUnmaking.class));
        cards.add(new SetCardInfo("Noxious Gearhulk", 254, Rarity.MYTHIC, mage.cards.n.NoxiousGearhulk.class));
        cards.add(new SetCardInfo("Oblivion Stone", 373, Rarity.RARE, mage.cards.o.OblivionStone.class));
        cards.add(new SetCardInfo("Obscura Confluence", 176, Rarity.RARE, mage.cards.o.ObscuraConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscura Confluence", 76, Rarity.RARE, mage.cards.o.ObscuraConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oracle's Vault", 374, Rarity.RARE, mage.cards.o.OraclesVault.class));
        cards.add(new SetCardInfo("Orzhov Advokist", 207, Rarity.UNCOMMON, mage.cards.o.OrzhovAdvokist.class));
        cards.add(new SetCardInfo("Orzhov Signet", 375, Rarity.UNCOMMON, mage.cards.o.OrzhovSignet.class));
        cards.add(new SetCardInfo("Oskar, Rubbish Reclaimer", 177, Rarity.RARE, mage.cards.o.OskarRubbishReclaimer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oskar, Rubbish Reclaimer", 77, Rarity.RARE, mage.cards.o.OskarRubbishReclaimer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Outpost Siege", 272, Rarity.RARE, mage.cards.o.OutpostSiege.class));
        cards.add(new SetCardInfo("Overgrown Battlement", 303, Rarity.UNCOMMON, mage.cards.o.OvergrownBattlement.class));
        cards.add(new SetCardInfo("Painful Truths", 255, Rarity.RARE, mage.cards.p.PainfulTruths.class));
        cards.add(new SetCardInfo("Park Heights Maverick", 163, Rarity.RARE, mage.cards.p.ParkHeightsMaverick.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Park Heights Maverick", 63, Rarity.RARE, mage.cards.p.ParkHeightsMaverick.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Parnesse, the Subtle Brush", 106, Rarity.MYTHIC, mage.cards.p.ParnesseTheSubtleBrush.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Parnesse, the Subtle Brush", 8, Rarity.MYTHIC, mage.cards.p.ParnesseTheSubtleBrush.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Path of Ancestry", 419, Rarity.COMMON, mage.cards.p.PathOfAncestry.class));
        cards.add(new SetCardInfo("Path to Exile", 208, Rarity.UNCOMMON, mage.cards.p.PathToExile.class));
        cards.add(new SetCardInfo("Perrie, the Pulverizer", 107, Rarity.MYTHIC, mage.cards.p.PerrieThePulverizer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Perrie, the Pulverizer", 190, Rarity.MYTHIC, mage.cards.p.PerrieThePulverizer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Perrie, the Pulverizer", 5, Rarity.MYTHIC, mage.cards.p.PerrieThePulverizer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phabine, Boss's Confidant", 108, Rarity.MYTHIC, mage.cards.p.PhabineBosssConfidant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phabine, Boss's Confidant", 9, Rarity.MYTHIC, mage.cards.p.PhabineBosssConfidant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Planar Outburst", 209, Rarity.RARE, mage.cards.p.PlanarOutburst.class));
        cards.add(new SetCardInfo("Ponder", 229, Rarity.COMMON, mage.cards.p.Ponder.class));
        cards.add(new SetCardInfo("Port Town", 420, Rarity.RARE, mage.cards.p.PortTown.class));
        cards.add(new SetCardInfo("Power Conduit", 376, Rarity.UNCOMMON, mage.cards.p.PowerConduit.class));
        cards.add(new SetCardInfo("Prairie Stream", 421, Rarity.RARE, mage.cards.p.PrairieStream.class));
        cards.add(new SetCardInfo("Preordain", 230, Rarity.COMMON, mage.cards.p.Preordain.class));
        cards.add(new SetCardInfo("Primal Empathy", 348, Rarity.UNCOMMON, mage.cards.p.PrimalEmpathy.class));
        cards.add(new SetCardInfo("Profane Command", 256, Rarity.RARE, mage.cards.p.ProfaneCommand.class));
        cards.add(new SetCardInfo("Prosperous Partnership", 178, Rarity.RARE, mage.cards.p.ProsperousPartnership.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prosperous Partnership", 78, Rarity.RARE, mage.cards.p.ProsperousPartnership.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Protection Racket", 140, Rarity.RARE, mage.cards.p.ProtectionRacket.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Protection Racket", 39, Rarity.RARE, mage.cards.p.ProtectionRacket.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Puppeteer Clique", 257, Rarity.RARE, mage.cards.p.PuppeteerClique.class));
        cards.add(new SetCardInfo("Quietus Spike", 377, Rarity.RARE, mage.cards.q.QuietusSpike.class));
        cards.add(new SetCardInfo("Rain of Riches", 150, Rarity.RARE, mage.cards.r.RainOfRiches.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rain of Riches", 50, Rarity.RARE, mage.cards.r.RainOfRiches.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakdos Signet", 378, Rarity.UNCOMMON, mage.cards.r.RakdosSignet.class));
        cards.add(new SetCardInfo("Rampant Growth", 304, Rarity.COMMON, mage.cards.r.RampantGrowth.class));
        cards.add(new SetCardInfo("Reign of the Pit", 258, Rarity.RARE, mage.cards.r.ReignOfThePit.class));
        cards.add(new SetCardInfo("Rekindling Phoenix", 273, Rarity.MYTHIC, mage.cards.r.RekindlingPhoenix.class));
        cards.add(new SetCardInfo("Resourceful Defense", 120, Rarity.RARE, mage.cards.r.ResourcefulDefense.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Resourceful Defense", 19, Rarity.RARE, mage.cards.r.ResourcefulDefense.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rishkar's Expertise", 306, Rarity.RARE, mage.cards.r.RishkarsExpertise.class));
        cards.add(new SetCardInfo("Rishkar, Peema Renegade", 305, Rarity.RARE, mage.cards.r.RishkarPeemaRenegade.class));
        cards.add(new SetCardInfo("Rite of the Raging Storm", 274, Rarity.UNCOMMON, mage.cards.r.RiteOfTheRagingStorm.class));
        cards.add(new SetCardInfo("River's Rebuke", 231, Rarity.RARE, mage.cards.r.RiversRebuke.class));
        cards.add(new SetCardInfo("Riveteers Confluence", 179, Rarity.RARE, mage.cards.r.RiveteersConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Riveteers Confluence", 79, Rarity.RARE, mage.cards.r.RiveteersConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Roalesk, Apex Hybrid", 349, Rarity.MYTHIC, mage.cards.r.RoaleskApexHybrid.class));
        cards.add(new SetCardInfo("Rogue's Passage", 422, Rarity.UNCOMMON, mage.cards.r.RoguesPassage.class));
        cards.add(new SetCardInfo("Rose Room Treasurer", 151, Rarity.RARE, mage.cards.r.RoseRoomTreasurer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rose Room Treasurer", 51, Rarity.RARE, mage.cards.r.RoseRoomTreasurer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rugged Prairie", 423, Rarity.RARE, mage.cards.r.RuggedPrairie.class));
        cards.add(new SetCardInfo("Sakura-Tribe Elder", 307, Rarity.COMMON, mage.cards.s.SakuraTribeElder.class));
        cards.add(new SetCardInfo("Sandwurm Convergence", 308, Rarity.RARE, mage.cards.s.SandwurmConvergence.class));
        cards.add(new SetCardInfo("Savage Lands", 424, Rarity.UNCOMMON, mage.cards.s.SavageLands.class));
        cards.add(new SetCardInfo("Scavenging Ooze", 309, Rarity.RARE, mage.cards.s.ScavengingOoze.class));
        cards.add(new SetCardInfo("Scepter of Celebration", 164, Rarity.RARE, mage.cards.s.ScepterOfCelebration.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scepter of Celebration", 64, Rarity.RARE, mage.cards.s.ScepterOfCelebration.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scute Swarm", 310, Rarity.RARE, mage.cards.s.ScuteSwarm.class));
        cards.add(new SetCardInfo("Seaside Citadel", 425, Rarity.UNCOMMON, mage.cards.s.SeasideCitadel.class));
        cards.add(new SetCardInfo("Seize the Spotlight", 152, Rarity.RARE, mage.cards.s.SeizeTheSpotlight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seize the Spotlight", 52, Rarity.RARE, mage.cards.s.SeizeTheSpotlight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selvala, Explorer Returned", 350, Rarity.RARE, mage.cards.s.SelvalaExplorerReturned.class));
        cards.add(new SetCardInfo("Sever the Bloodline", 259, Rarity.RARE, mage.cards.s.SeverTheBloodline.class));
        cards.add(new SetCardInfo("Shadowblood Ridge", 426, Rarity.RARE, mage.cards.s.ShadowbloodRidge.class));
        cards.add(new SetCardInfo("Shadowmage Infiltrator", 351, Rarity.RARE, mage.cards.s.ShadowmageInfiltrator.class));
        cards.add(new SetCardInfo("Shamanic Revelation", 311, Rarity.RARE, mage.cards.s.ShamanicRevelation.class));
        cards.add(new SetCardInfo("Shield Broker", 130, Rarity.RARE, mage.cards.s.ShieldBroker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shield Broker", 29, Rarity.RARE, mage.cards.s.ShieldBroker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Silent-Blade Oni", 352, Rarity.RARE, mage.cards.s.SilentBladeOni.class));
        cards.add(new SetCardInfo("Sinister Concierge", 131, Rarity.RARE, mage.cards.s.SinisterConcierge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sinister Concierge", 30, Rarity.RARE, mage.cards.s.SinisterConcierge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skyboon Evangelist", 121, Rarity.RARE, mage.cards.s.SkyboonEvangelist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skyboon Evangelist", 20, Rarity.RARE, mage.cards.s.SkyboonEvangelist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skyclave Shade", 260, Rarity.RARE, mage.cards.s.SkyclaveShade.class));
        cards.add(new SetCardInfo("Skycloud Expanse", 427, Rarity.RARE, mage.cards.s.SkycloudExpanse.class));
        cards.add(new SetCardInfo("Skyship Plunderer", 232, Rarity.UNCOMMON, mage.cards.s.SkyshipPlunderer.class));
        cards.add(new SetCardInfo("Skyway Robber", 132, Rarity.RARE, mage.cards.s.SkywayRobber.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skyway Robber", 31, Rarity.RARE, mage.cards.s.SkywayRobber.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Slippery Bogbonder", 312, Rarity.RARE, mage.cards.s.SlipperyBogbonder.class));
        cards.add(new SetCardInfo("Smoldering Marsh", 428, Rarity.RARE, mage.cards.s.SmolderingMarsh.class));
        cards.add(new SetCardInfo("Smuggler's Buggy", 184, Rarity.RARE, mage.cards.s.SmugglersBuggy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smuggler's Buggy", 84, Rarity.RARE, mage.cards.s.SmugglersBuggy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smuggler's Share", 122, Rarity.RARE, mage.cards.s.SmugglersShare.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smuggler's Share", 21, Rarity.RARE, mage.cards.s.SmugglersShare.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 379, Rarity.UNCOMMON, mage.cards.s.SolRing.class));
        cards.add(new SetCardInfo("Solemn Simulacrum", 380, Rarity.RARE, mage.cards.s.SolemnSimulacrum.class));
        cards.add(new SetCardInfo("Spellbinding Soprano", 153, Rarity.RARE, mage.cards.s.SpellbindingSoprano.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spellbinding Soprano", 53, Rarity.RARE, mage.cards.s.SpellbindingSoprano.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spinerock Knoll", 429, Rarity.RARE, mage.cards.s.SpinerockKnoll.class));
        cards.add(new SetCardInfo("Spiteful Repossession", 90, Rarity.RARE, mage.cards.s.SpitefulRepossession.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spiteful Repossession", 98, Rarity.RARE, mage.cards.s.SpitefulRepossession.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Squee, the Immortal", 275, Rarity.RARE, mage.cards.s.SqueeTheImmortal.class));
        cards.add(new SetCardInfo("Stalking Vengeance", 276, Rarity.RARE, mage.cards.s.StalkingVengeance.class));
        cards.add(new SetCardInfo("Steelbane Hydra", 313, Rarity.RARE, mage.cards.s.SteelbaneHydra.class));
        cards.add(new SetCardInfo("Stolen Identity", 233, Rarity.RARE, mage.cards.s.StolenIdentity.class));
        cards.add(new SetCardInfo("Storm of Forms", 133, Rarity.RARE, mage.cards.s.StormOfForms.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Storm of Forms", 32, Rarity.RARE, mage.cards.s.StormOfForms.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Strionic Resonator", 381, Rarity.RARE, mage.cards.s.StrionicResonator.class));
        cards.add(new SetCardInfo("Sun Titan", 210, Rarity.MYTHIC, mage.cards.s.SunTitan.class));
        cards.add(new SetCardInfo("Sungrass Prairie", 430, Rarity.RARE, mage.cards.s.SungrassPrairie.class));
        cards.add(new SetCardInfo("Sunken Hollow", 431, Rarity.RARE, mage.cards.s.SunkenHollow.class));
        cards.add(new SetCardInfo("Swiftfoot Boots", 382, Rarity.UNCOMMON, mage.cards.s.SwiftfootBoots.class));
        cards.add(new SetCardInfo("Swindler's Scheme", 88, Rarity.RARE, mage.cards.s.SwindlersScheme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swindler's Scheme", 96, Rarity.RARE, mage.cards.s.SwindlersScheme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 211, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class));
        cards.add(new SetCardInfo("Sylvan Offering", 314, Rarity.RARE, mage.cards.s.SylvanOffering.class));
        cards.add(new SetCardInfo("Syrix, Carrier of the Flame", 180, Rarity.RARE, mage.cards.s.SyrixCarrierOfTheFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Syrix, Carrier of the Flame", 80, Rarity.RARE, mage.cards.s.SyrixCarrierOfTheFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Talrand's Invocation", 234, Rarity.UNCOMMON, mage.cards.t.TalrandsInvocation.class));
        cards.add(new SetCardInfo("Temple of Epiphany", 432, Rarity.RARE, mage.cards.t.TempleOfEpiphany.class));
        cards.add(new SetCardInfo("Temple of Malady", 433, Rarity.RARE, mage.cards.t.TempleOfMalady.class));
        cards.add(new SetCardInfo("Temple of Mystery", 434, Rarity.RARE, mage.cards.t.TempleOfMystery.class));
        cards.add(new SetCardInfo("Temple of Silence", 435, Rarity.RARE, mage.cards.t.TempleOfSilence.class));
        cards.add(new SetCardInfo("Temple of Triumph", 437, Rarity.RARE, mage.cards.t.TempleOfTriumph.class));
        cards.add(new SetCardInfo("Temple of the False God", 436, Rarity.UNCOMMON, mage.cards.t.TempleOfTheFalseGod.class));
        cards.add(new SetCardInfo("Temur Sabertooth", 315, Rarity.UNCOMMON, mage.cards.t.TemurSabertooth.class));
        cards.add(new SetCardInfo("Tenuous Truce", 87, Rarity.RARE, mage.cards.t.TenuousTruce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tenuous Truce", 95, Rarity.RARE, mage.cards.t.TenuousTruce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terminate", 353, Rarity.UNCOMMON, mage.cards.t.Terminate.class));
        cards.add(new SetCardInfo("Tezzeret's Gambit", 235, Rarity.RARE, mage.cards.t.TezzeretsGambit.class));
        cards.add(new SetCardInfo("The Beamtown Bullies", 101, Rarity.MYTHIC, mage.cards.t.TheBeamtownBullies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Beamtown Bullies", 6, Rarity.MYTHIC, mage.cards.t.TheBeamtownBullies.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thief of Sanity", 354, Rarity.RARE, mage.cards.t.ThiefOfSanity.class));
        cards.add(new SetCardInfo("Thragtusk", 316, Rarity.RARE, mage.cards.t.Thragtusk.class));
        cards.add(new SetCardInfo("Threefold Signal", 111, Rarity.MYTHIC, mage.cards.t.ThreefoldSignal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Threefold Signal", 93, Rarity.MYTHIC, mage.cards.t.ThreefoldSignal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thriving Bluff", 438, Rarity.COMMON, mage.cards.t.ThrivingBluff.class));
        cards.add(new SetCardInfo("Thriving Grove", 439, Rarity.COMMON, mage.cards.t.ThrivingGrove.class));
        cards.add(new SetCardInfo("Thriving Heath", 440, Rarity.COMMON, mage.cards.t.ThrivingHeath.class));
        cards.add(new SetCardInfo("Thriving Isle", 441, Rarity.COMMON, mage.cards.t.ThrivingIsle.class));
        cards.add(new SetCardInfo("Thriving Moor", 442, Rarity.COMMON, mage.cards.t.ThrivingMoor.class));
        cards.add(new SetCardInfo("Thrummingbird", 236, Rarity.UNCOMMON, mage.cards.t.Thrummingbird.class));
        cards.add(new SetCardInfo("Thunderfoot Baloth", 317, Rarity.RARE, mage.cards.t.ThunderfootBaloth.class));
        cards.add(new SetCardInfo("Tivit, Seller of Secrets", 10, Rarity.MYTHIC, mage.cards.t.TivitSellerOfSecrets.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tivit, Seller of Secrets", 109, Rarity.MYTHIC, mage.cards.t.TivitSellerOfSecrets.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Together Forever", 212, Rarity.RARE, mage.cards.t.TogetherForever.class));
        cards.add(new SetCardInfo("Treasure Cruise", 237, Rarity.COMMON, mage.cards.t.TreasureCruise.class));
        cards.add(new SetCardInfo("Treeshaker Chimera", 318, Rarity.RARE, mage.cards.t.TreeshakerChimera.class));
        cards.add(new SetCardInfo("Turf War", 154, Rarity.RARE, mage.cards.t.TurfWar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Turf War", 54, Rarity.RARE, mage.cards.t.TurfWar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Twilight Mire", 443, Rarity.RARE, mage.cards.t.TwilightMire.class));
        cards.add(new SetCardInfo("Twinning Staff", 383, Rarity.RARE, mage.cards.t.TwinningStaff.class));
        cards.add(new SetCardInfo("Urban Evolution", 355, Rarity.UNCOMMON, mage.cards.u.UrbanEvolution.class));
        cards.add(new SetCardInfo("Utter End", 356, Rarity.RARE, mage.cards.u.UtterEnd.class));
        cards.add(new SetCardInfo("Vazi, Keen Negotiator", 110, Rarity.RARE, mage.cards.v.VaziKeenNegotiator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vazi, Keen Negotiator", 92, Rarity.RARE, mage.cards.v.VaziKeenNegotiator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Victimize", 261, Rarity.UNCOMMON, mage.cards.v.Victimize.class));
        cards.add(new SetCardInfo("Vivid Creek", 444, Rarity.UNCOMMON, mage.cards.v.VividCreek.class));
        cards.add(new SetCardInfo("Vivid Grove", 445, Rarity.UNCOMMON, mage.cards.v.VividGrove.class));
        cards.add(new SetCardInfo("Vivid Meadow", 446, Rarity.UNCOMMON, mage.cards.v.VividMeadow.class));
        cards.add(new SetCardInfo("Vivien's Stampede", 165, Rarity.RARE, mage.cards.v.ViviensStampede.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vivien's Stampede", 65, Rarity.RARE, mage.cards.v.ViviensStampede.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vorel of the Hull Clade", 357, Rarity.RARE, mage.cards.v.VorelOfTheHullClade.class));
        cards.add(new SetCardInfo("Wall of Roots", 319, Rarity.COMMON, mage.cards.w.WallOfRoots.class));
        cards.add(new SetCardInfo("Warstorm Surge", 277, Rarity.RARE, mage.cards.w.WarstormSurge.class));
        cards.add(new SetCardInfo("Waste Management", 141, Rarity.RARE, mage.cards.w.WasteManagement.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Waste Management", 40, Rarity.RARE, mage.cards.w.WasteManagement.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wave of Rats", 142, Rarity.RARE, mage.cards.w.WaveOfRats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wave of Rats", 41, Rarity.RARE, mage.cards.w.WaveOfRats.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wayfarer's Bauble", 384, Rarity.COMMON, mage.cards.w.WayfarersBauble.class));
        cards.add(new SetCardInfo("Weathered Sentinels", 185, Rarity.RARE, mage.cards.w.WeatheredSentinels.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Weathered Sentinels", 85, Rarity.RARE, mage.cards.w.WeatheredSentinels.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Whirler Rogue", 238, Rarity.UNCOMMON, mage.cards.w.WhirlerRogue.class));
        cards.add(new SetCardInfo("Wickerbough Elder", 320, Rarity.COMMON, mage.cards.w.WickerboughElder.class));
        cards.add(new SetCardInfo("Windbrisk Heights", 447, Rarity.RARE, mage.cards.w.WindbriskHeights.class));
        cards.add(new SetCardInfo("Windgrace's Judgment", 358, Rarity.RARE, mage.cards.w.WindgracesJudgment.class));
        cards.add(new SetCardInfo("Wingspan Mentor", 239, Rarity.UNCOMMON, mage.cards.w.WingspanMentor.class));
        cards.add(new SetCardInfo("Woe Strider", 262, Rarity.RARE, mage.cards.w.WoeStrider.class));
        cards.add(new SetCardInfo("Wood Elves", 321, Rarity.COMMON, mage.cards.w.WoodElves.class));
        cards.add(new SetCardInfo("Woodfall Primus", 322, Rarity.RARE, mage.cards.w.WoodfallPrimus.class));
        cards.add(new SetCardInfo("World Shaper", 323, Rarity.RARE, mage.cards.w.WorldShaper.class));
        cards.add(new SetCardInfo("Wrexial, the Risen Deep", 359, Rarity.MYTHIC, mage.cards.w.WrexialTheRisenDeep.class));
        cards.add(new SetCardInfo("Writ of Return", 143, Rarity.RARE, mage.cards.w.WritOfReturn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Writ of Return", 42, Rarity.RARE, mage.cards.w.WritOfReturn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Xander's Pact", 144, Rarity.RARE, mage.cards.x.XandersPact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Xander's Pact", 43, Rarity.RARE, mage.cards.x.XandersPact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zndrsplt's Judgment", 240, Rarity.RARE, mage.cards.z.ZndrspltsJudgment.class));
        cards.add(new SetCardInfo("Zurzoth, Chaos Rider", 278, Rarity.RARE, mage.cards.z.ZurzothChaosRider.class));
    }
}
