package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public class MysteryBooster2 extends ExpansionSet {

    private static final MysteryBooster2 instance = new MysteryBooster2();

    public static MysteryBooster2 getInstance() {
        return instance;
    }

    private MysteryBooster2() {
        super("Mystery Booster 2", "MB2", ExpansionSet.buildDate(2024, 8, 2), SetType.REMIX);
        this.hasBoosters = false; // booster generation needs to be implemented
        this.hasBasicLands = true;

        cards.add(new SetCardInfo("Abrupt Decay", 78, Rarity.RARE, mage.cards.a.AbruptDecay.class));
        cards.add(new SetCardInfo("Aether Vial", 216, Rarity.UNCOMMON, mage.cards.a.AetherVial.class));
        cards.add(new SetCardInfo("Ancient Grudge", 53, Rarity.COMMON, mage.cards.a.AncientGrudge.class));
        cards.add(new SetCardInfo("Ancient Stirrings", 202, Rarity.COMMON, mage.cards.a.AncientStirrings.class));
        cards.add(new SetCardInfo("Arcane Lighthouse", 102, Rarity.UNCOMMON, mage.cards.a.ArcaneLighthouse.class));
        cards.add(new SetCardInfo("Arcane Signet", 254, Rarity.COMMON, mage.cards.a.ArcaneSignet.class));
        cards.add(new SetCardInfo("Archon of Emeria", 4, Rarity.RARE, mage.cards.a.ArchonOfEmeria.class));
        cards.add(new SetCardInfo("Arena", 239, Rarity.RARE, mage.cards.a.Arena.class));
        cards.add(new SetCardInfo("Ash Barrens", 103, Rarity.UNCOMMON, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Back to Basics", 154, Rarity.RARE, mage.cards.b.BackToBasics.class));
        cards.add(new SetCardInfo("Ball Lightning", 130, Rarity.RARE, mage.cards.b.BallLightning.class));
        cards.add(new SetCardInfo("Basalt Monolith", 217, Rarity.UNCOMMON, mage.cards.b.BasaltMonolith.class));
        cards.add(new SetCardInfo("Basilisk Gate", 104, Rarity.COMMON, mage.cards.b.BasiliskGate.class));
        cards.add(new SetCardInfo("Basking Rootwalla", 65, Rarity.COMMON, mage.cards.b.BaskingRootwalla.class));
        cards.add(new SetCardInfo("Black Vise", 139, Rarity.UNCOMMON, mage.cards.b.BlackVise.class));
        cards.add(new SetCardInfo("Blazing Rootwalla", 54, Rarity.UNCOMMON, mage.cards.b.BlazingRootwalla.class));
        cards.add(new SetCardInfo("Bojuka Bog", 105, Rarity.COMMON, mage.cards.b.BojukaBog.class));
        cards.add(new SetCardInfo("Bolas's Citadel", 39, Rarity.RARE, mage.cards.b.BolassCitadel.class));
        cards.add(new SetCardInfo("Brain Freeze", 24, Rarity.UNCOMMON, mage.cards.b.BrainFreeze.class));
        cards.add(new SetCardInfo("Brainstorm", 155, Rarity.COMMON, mage.cards.b.Brainstorm.class));
        cards.add(new SetCardInfo("Cabal Coffers", 106, Rarity.UNCOMMON, mage.cards.c.CabalCoffers.class));
        cards.add(new SetCardInfo("Cabal Ritual", 177, Rarity.COMMON, mage.cards.c.CabalRitual.class));
        cards.add(new SetCardInfo("Captain Sisay", 250, Rarity.RARE, mage.cards.c.CaptainSisay.class));
        cards.add(new SetCardInfo("Cathar Commando", 5, Rarity.COMMON, mage.cards.c.CatharCommando.class));
        cards.add(new SetCardInfo("Cathars' Crusade", 6, Rarity.RARE, mage.cards.c.CatharsCrusade.class));
        cards.add(new SetCardInfo("Chain Lightning", 55, Rarity.COMMON, mage.cards.c.ChainLightning.class));
        cards.add(new SetCardInfo("Chain of Vapor", 156, Rarity.UNCOMMON, mage.cards.c.ChainOfVapor.class));
        cards.add(new SetCardInfo("City of Brass", 240, Rarity.RARE, mage.cards.c.CityOfBrass.class));
        cards.add(new SetCardInfo("Collected Company", 203, Rarity.RARE, mage.cards.c.CollectedCompany.class));
        cards.add(new SetCardInfo("Collector Ouphe", 66, Rarity.RARE, mage.cards.c.CollectorOuphe.class));
        cards.add(new SetCardInfo("Colossal Dreadmaw", 67, Rarity.COMMON, mage.cards.c.ColossalDreadmaw.class));
        cards.add(new SetCardInfo("Comet, Stellar Pup", 79, Rarity.MYTHIC, mage.cards.c.CometStellarPup.class));
        cards.add(new SetCardInfo("Command Tower", 256, Rarity.COMMON, mage.cards.c.CommandTower.class));
        cards.add(new SetCardInfo("Consider", 25, Rarity.COMMON, mage.cards.c.Consider.class));
        cards.add(new SetCardInfo("Contagion", 126, Rarity.UNCOMMON, mage.cards.c.Contagion.class));
        cards.add(new SetCardInfo("Containment Priest", 7, Rarity.RARE, mage.cards.c.ContainmentPriest.class));
        cards.add(new SetCardInfo("Contamination", 178, Rarity.RARE, mage.cards.c.Contamination.class));
        cards.add(new SetCardInfo("Control of the Court", 189, Rarity.UNCOMMON, mage.cards.c.ControlOfTheCourt.class));
        cards.add(new SetCardInfo("Counterbalance", 157, Rarity.UNCOMMON, mage.cards.c.Counterbalance.class));
        cards.add(new SetCardInfo("Counterspell", 158, Rarity.COMMON, mage.cards.c.Counterspell.class));
        cards.add(new SetCardInfo("Crackdown", 146, Rarity.RARE, mage.cards.c.Crackdown.class));
        cards.add(new SetCardInfo("Crashing Footfalls", 204, Rarity.RARE, mage.cards.c.CrashingFootfalls.class));
        cards.add(new SetCardInfo("Culling the Weak", 40, Rarity.COMMON, mage.cards.c.CullingTheWeak.class));
        cards.add(new SetCardInfo("Cunning Wish", 159, Rarity.RARE, mage.cards.c.CunningWish.class));
        cards.add(new SetCardInfo("Dack Fayden", 80, Rarity.MYTHIC, mage.cards.d.DackFayden.class));
        cards.add(new SetCardInfo("Dakmor Sorceress", 127, Rarity.RARE, mage.cards.d.DakmorSorceress.class));
        cards.add(new SetCardInfo("Dark Ritual", 179, Rarity.COMMON, mage.cards.d.DarkRitual.class));
        cards.add(new SetCardInfo("Darksteel Citadel", 107, Rarity.COMMON, mage.cards.d.DarksteelCitadel.class));
        cards.add(new SetCardInfo("Day of Judgment", 8, Rarity.RARE, mage.cards.d.DayOfJudgment.class));
        cards.add(new SetCardInfo("Daze", 26, Rarity.UNCOMMON, mage.cards.d.Daze.class));
        cards.add(new SetCardInfo("Dead Ringers", 41, Rarity.COMMON, mage.cards.d.DeadRingers.class));
        cards.add(new SetCardInfo("Deafening Silence", 9, Rarity.UNCOMMON, mage.cards.d.DeafeningSilence.class));
        cards.add(new SetCardInfo("Death's Shadow", 180, Rarity.RARE, mage.cards.d.DeathsShadow.class));
        cards.add(new SetCardInfo("Deathrite Shaman", 81, Rarity.RARE, mage.cards.d.DeathriteShaman.class));
        cards.add(new SetCardInfo("Demonic Consultation", 181, Rarity.UNCOMMON, mage.cards.d.DemonicConsultation.class));
        cards.add(new SetCardInfo("Displacer Kitten", 27, Rarity.RARE, mage.cards.d.DisplacerKitten.class));
        cards.add(new SetCardInfo("Doomsday", 182, Rarity.MYTHIC, mage.cards.d.Doomsday.class));
        cards.add(new SetCardInfo("Dragon's Approach", 246, Rarity.COMMON, mage.cards.d.DragonsApproach.class));
        cards.add(new SetCardInfo("Dragon's Rage Channeler", 56, Rarity.UNCOMMON, mage.cards.d.DragonsRageChanneler.class));
        cards.add(new SetCardInfo("Dryad Arbor", 108, Rarity.UNCOMMON, mage.cards.d.DryadArbor.class));
        cards.add(new SetCardInfo("Eater of the Dead", 183, Rarity.UNCOMMON, mage.cards.e.EaterOfTheDead.class));
        cards.add(new SetCardInfo("Echo of Eons", 160, Rarity.MYTHIC, mage.cards.e.EchoOfEons.class));
        cards.add(new SetCardInfo("Elvish Reclaimer", 205, Rarity.RARE, mage.cards.e.ElvishReclaimer.class));
        cards.add(new SetCardInfo("Elvish Spirit Guide", 68, Rarity.UNCOMMON, mage.cards.e.ElvishSpiritGuide.class));
        cards.add(new SetCardInfo("Energy Flux", 161, Rarity.UNCOMMON, mage.cards.e.EnergyFlux.class));
        cards.add(new SetCardInfo("Engineered Explosives", 218, Rarity.RARE, mage.cards.e.EngineeredExplosives.class));
        cards.add(new SetCardInfo("Ensnaring Bridge", 219, Rarity.RARE, mage.cards.e.EnsnaringBridge.class));
        cards.add(new SetCardInfo("Environmental Sciences", 2, Rarity.COMMON, mage.cards.e.EnvironmentalSciences.class));
        cards.add(new SetCardInfo("Equilibrium", 162, Rarity.RARE, mage.cards.e.Equilibrium.class));
        cards.add(new SetCardInfo("Erhnam Djinn", 133, Rarity.UNCOMMON, mage.cards.e.ErhnamDjinn.class));
        cards.add(new SetCardInfo("Erratic Portal", 220, Rarity.RARE, mage.cards.e.ErraticPortal.class));
        cards.add(new SetCardInfo("Ethersworn Canonist", 10, Rarity.RARE, mage.cards.e.EtherswornCanonist.class));
        cards.add(new SetCardInfo("Expressive Iteration", 82, Rarity.UNCOMMON, mage.cards.e.ExpressiveIteration.class));
        cards.add(new SetCardInfo("Faerie Macabre", 42, Rarity.COMMON, mage.cards.f.FaerieMacabre.class));
        cards.add(new SetCardInfo("Faithless Looting", 57, Rarity.COMMON, mage.cards.f.FaithlessLooting.class));
        cards.add(new SetCardInfo("Final Fortune", 190, Rarity.RARE, mage.cards.f.FinalFortune.class));
        cards.add(new SetCardInfo("Flickering Ward", 11, Rarity.UNCOMMON, mage.cards.f.FlickeringWard.class));
        cards.add(new SetCardInfo("Flusterstorm", 163, Rarity.RARE, mage.cards.f.Flusterstorm.class));
        cards.add(new SetCardInfo("Foil", 243, Rarity.COMMON, mage.cards.f.Foil.class));
        cards.add(new SetCardInfo("Forest Bear", 206, Rarity.COMMON, mage.cards.f.ForestBear.class));
        cards.add(new SetCardInfo("Forsaken Crossroads", 264, Rarity.UNCOMMON, mage.cards.f.ForsakenCrossroads.class));
        cards.add(new SetCardInfo("Future Sight", 122, Rarity.RARE, mage.cards.f.FutureSight.class));
        cards.add(new SetCardInfo("Gerrard, Weatherlight Hero", 251, Rarity.RARE, mage.cards.g.GerrardWeatherlightHero.class));
        cards.add(new SetCardInfo("Ghost Quarter", 109, Rarity.UNCOMMON, mage.cards.g.GhostQuarter.class));
        cards.add(new SetCardInfo("Gitaxian Probe", 28, Rarity.COMMON, mage.cards.g.GitaxianProbe.class));
        cards.add(new SetCardInfo("Giver of Runes", 147, Rarity.RARE, mage.cards.g.GiverOfRunes.class));
        cards.add(new SetCardInfo("Gix, Yawgmoth Praetor", 245, Rarity.MYTHIC, mage.cards.g.GixYawgmothPraetor.class));
        cards.add(new SetCardInfo("Goblin Charbelcher", 221, Rarity.RARE, mage.cards.g.GoblinCharbelcher.class));
        cards.add(new SetCardInfo("Goblin Gang Leader", 144, Rarity.UNCOMMON, mage.cards.g.GoblinGangLeader.class));
        cards.add(new SetCardInfo("Goblin Guide", 58, Rarity.RARE, mage.cards.g.GoblinGuide.class));
        cards.add(new SetCardInfo("Goblin King", 191, Rarity.RARE, mage.cards.g.GoblinKing.class));
        cards.add(new SetCardInfo("Goblin Lackey", 192, Rarity.UNCOMMON, mage.cards.g.GoblinLackey.class));
        cards.add(new SetCardInfo("Goblin Recruiter", 193, Rarity.UNCOMMON, mage.cards.g.GoblinRecruiter.class));
        cards.add(new SetCardInfo("Goblin Settler", 131, Rarity.UNCOMMON, mage.cards.g.GoblinSettler.class));
        cards.add(new SetCardInfo("Grafdigger's Cage", 222, Rarity.RARE, mage.cards.g.GrafdiggersCage.class));
        cards.add(new SetCardInfo("Greater Good", 207, Rarity.RARE, mage.cards.g.GreaterGood.class));
        cards.add(new SetCardInfo("Grinding Station", 223, Rarity.UNCOMMON, mage.cards.g.GrindingStation.class));
        cards.add(new SetCardInfo("Gush", 164, Rarity.COMMON, mage.cards.g.Gush.class));
        cards.add(new SetCardInfo("Hogaak, Arisen Necropolis", 136, Rarity.RARE, mage.cards.h.HogaakArisenNecropolis.class));
        cards.add(new SetCardInfo("Hollow One", 95, Rarity.RARE, mage.cards.h.HollowOne.class));
        cards.add(new SetCardInfo("Hoodwink", 123, Rarity.COMMON, mage.cards.h.Hoodwink.class));
        cards.add(new SetCardInfo("Hostage Taker", 137, Rarity.RARE, mage.cards.h.HostageTaker.class));
        cards.add(new SetCardInfo("Hullbreacher", 124, Rarity.RARE, mage.cards.h.Hullbreacher.class));
        cards.add(new SetCardInfo("Hunting Cheetah", 134, Rarity.COMMON, mage.cards.h.HuntingCheetah.class));
        cards.add(new SetCardInfo("Hydroblast", 165, Rarity.COMMON, mage.cards.h.Hydroblast.class));
        cards.add(new SetCardInfo("Ice-Fang Coatl", 83, Rarity.RARE, mage.cards.i.IceFangCoatl.class));
        cards.add(new SetCardInfo("Iona, Shield of Emeria", 12, Rarity.MYTHIC, mage.cards.i.IonaShieldOfEmeria.class));
        cards.add(new SetCardInfo("Isochron Scepter", 96, Rarity.UNCOMMON, mage.cards.i.IsochronScepter.class));
        cards.add(new SetCardInfo("Jace Beleren", 29, Rarity.MYTHIC, mage.cards.j.JaceBeleren.class));
        cards.add(new SetCardInfo("Karn, Legacy Reforged", 255, Rarity.MYTHIC, mage.cards.k.KarnLegacyReforged.class));
        cards.add(new SetCardInfo("Karn, the Great Creator", 3, Rarity.RARE, mage.cards.k.KarnTheGreatCreator.class));
        cards.add(new SetCardInfo("Kataki, War's Wage", 148, Rarity.RARE, mage.cards.k.KatakiWarsWage.class));
        cards.add(new SetCardInfo("Kenrith, the Returned King", 13, Rarity.MYTHIC, mage.cards.k.KenrithTheReturnedKing.class));
        cards.add(new SetCardInfo("Keruga, the Macrosage", 84, Rarity.RARE, mage.cards.k.KerugaTheMacrosage.class));
        cards.add(new SetCardInfo("King's Assassin", 43, Rarity.RARE, mage.cards.k.KingsAssassin.class));
        cards.add(new SetCardInfo("Kitchen Finks", 85, Rarity.UNCOMMON, mage.cards.k.KitchenFinks.class));
        cards.add(new SetCardInfo("Kobolds of Kher Keep", 194, Rarity.COMMON, mage.cards.k.KoboldsOfKherKeep.class));
        cards.add(new SetCardInfo("Krark-Clan Ironworks", 224, Rarity.UNCOMMON, mage.cards.k.KrarkClanIronworks.class));
        cards.add(new SetCardInfo("Lavinia, Azorius Renegade", 86, Rarity.RARE, mage.cards.l.LaviniaAzoriusRenegade.class));
        cards.add(new SetCardInfo("Leyline of Sanctity", 14, Rarity.RARE, mage.cards.l.LeylineOfSanctity.class));
        cards.add(new SetCardInfo("Leyline of the Void", 44, Rarity.RARE, mage.cards.l.LeylineOfTheVoid.class));
        cards.add(new SetCardInfo("Lifetap", 125, Rarity.UNCOMMON, mage.cards.l.Lifetap.class));
        cards.add(new SetCardInfo("Lightning Greaves", 225, Rarity.UNCOMMON, mage.cards.l.LightningGreaves.class));
        cards.add(new SetCardInfo("Lim-Dul's Vault", 87, Rarity.UNCOMMON, mage.cards.l.LimDulsVault.class));
        cards.add(new SetCardInfo("Lotus Petal", 226, Rarity.COMMON, mage.cards.l.LotusPetal.class));
        cards.add(new SetCardInfo("Maddening Hex", 195, Rarity.RARE, mage.cards.m.MaddeningHex.class));
        cards.add(new SetCardInfo("Mana Flare", 196, Rarity.RARE, mage.cards.m.ManaFlare.class));
        cards.add(new SetCardInfo("Mana Short", 166, Rarity.RARE, mage.cards.m.ManaShort.class));
        cards.add(new SetCardInfo("Manabond", 208, Rarity.RARE, mage.cards.m.Manabond.class));
        cards.add(new SetCardInfo("Mardu Outrider", 1, Rarity.RARE, mage.cards.m.MarduOutrider.class));
        cards.add(new SetCardInfo("Meekstone", 227, Rarity.RARE, mage.cards.m.Meekstone.class));
        cards.add(new SetCardInfo("Memnite", 228, Rarity.UNCOMMON, mage.cards.m.Memnite.class));
        cards.add(new SetCardInfo("Mental Misstep", 30, Rarity.UNCOMMON, mage.cards.m.MentalMisstep.class));
        cards.add(new SetCardInfo("Merchant Scroll", 167, Rarity.COMMON, mage.cards.m.MerchantScroll.class));
        cards.add(new SetCardInfo("Mind Twist", 184, Rarity.RARE, mage.cards.m.MindTwist.class));
        cards.add(new SetCardInfo("Mindbreak Trap", 168, Rarity.MYTHIC, mage.cards.m.MindbreakTrap.class));
        cards.add(new SetCardInfo("Minsc & Boo, Timeless Heroes", 88, Rarity.MYTHIC, mage.cards.m.MinscBooTimelessHeroes.class));
        cards.add(new SetCardInfo("Mirri's Guile", 209, Rarity.RARE, mage.cards.m.MirrisGuile.class));
        cards.add(new SetCardInfo("Mirri, Weatherlight Duelist", 252, Rarity.MYTHIC, mage.cards.m.MirriWeatherlightDuelist.class));
        cards.add(new SetCardInfo("Mishra's Bauble", 97, Rarity.UNCOMMON, mage.cards.m.MishrasBauble.class));
        cards.add(new SetCardInfo("Multani, Yavimaya's Avatar", 248, Rarity.MYTHIC, mage.cards.m.MultaniYavimayasAvatar.class));
        cards.add(new SetCardInfo("Mutilate", 45, Rarity.RARE, mage.cards.m.Mutilate.class));
        cards.add(new SetCardInfo("Mystic Sanctuary", 110, Rarity.COMMON, mage.cards.m.MysticSanctuary.class));
        cards.add(new SetCardInfo("Mystical Dispute", 31, Rarity.UNCOMMON, mage.cards.m.MysticalDispute.class));
        cards.add(new SetCardInfo("Nalathni Dragon", 197, Rarity.RARE, mage.cards.n.NalathniDragon.class));
        cards.add(new SetCardInfo("Narset, Parter of Veils", 32, Rarity.UNCOMMON, mage.cards.n.NarsetParterOfVeils.class));
        cards.add(new SetCardInfo("Natural Order", 210, Rarity.MYTHIC, mage.cards.n.NaturalOrder.class));
        cards.add(new SetCardInfo("Nature's Claim", 69, Rarity.COMMON, mage.cards.n.NaturesClaim.class));
        cards.add(new SetCardInfo("Nomads en-Kor", 149, Rarity.COMMON, mage.cards.n.NomadsEnKor.class));
        cards.add(new SetCardInfo("Norwood Priestess", 211, Rarity.RARE, mage.cards.n.NorwoodPriestess.class));
        cards.add(new SetCardInfo("Noxious Revival", 70, Rarity.UNCOMMON, mage.cards.n.NoxiousRevival.class));
        cards.add(new SetCardInfo("O-Kagachi, Vengeful Kami", 138, Rarity.MYTHIC, mage.cards.o.OKagachiVengefulKami.class));
        cards.add(new SetCardInfo("Oath of Druids", 212, Rarity.MYTHIC, mage.cards.o.OathOfDruids.class));
        cards.add(new SetCardInfo("Once Upon a Time", 71, Rarity.RARE, mage.cards.o.OnceUponATime.class));
        cards.add(new SetCardInfo("Oracle of the Alpha", 259, Rarity.UNCOMMON, mage.cards.o.OracleOfTheAlpha.class));
        cards.add(new SetCardInfo("Pact of Negation", 169, Rarity.RARE, mage.cards.p.PactOfNegation.class));
        cards.add(new SetCardInfo("Paradoxical Outcome", 33, Rarity.RARE, mage.cards.p.ParadoxicalOutcome.class));
        cards.add(new SetCardInfo("Path to Exile", 15, Rarity.UNCOMMON, mage.cards.p.PathToExile.class));
        cards.add(new SetCardInfo("Pitiless Plunderer", 46, Rarity.UNCOMMON, mage.cards.p.PitilessPlunderer.class));
        cards.add(new SetCardInfo("Ponder", 34, Rarity.COMMON, mage.cards.p.Ponder.class));
        cards.add(new SetCardInfo("Power Matrix", 229, Rarity.RARE, mage.cards.p.PowerMatrix.class));
        cards.add(new SetCardInfo("Pox", 185, Rarity.RARE, mage.cards.p.Pox.class));
        cards.add(new SetCardInfo("Preordain", 35, Rarity.COMMON, mage.cards.p.Preordain.class));
        cards.add(new SetCardInfo("Prismatic Ending", 16, Rarity.UNCOMMON, mage.cards.p.PrismaticEnding.class));
        cards.add(new SetCardInfo("Proteus Staff", 140, Rarity.RARE, mage.cards.p.ProteusStaff.class));
        cards.add(new SetCardInfo("Pyroblast", 198, Rarity.COMMON, mage.cards.p.Pyroblast.class));
        cards.add(new SetCardInfo("Rain of Daggers", 186, Rarity.RARE, mage.cards.r.RainOfDaggers.class));
        cards.add(new SetCardInfo("Rat Colony", 47, Rarity.COMMON, mage.cards.r.RatColony.class));
        cards.add(new SetCardInfo("Reflecting Pool", 257, Rarity.RARE, mage.cards.r.ReflectingPool.class));
        cards.add(new SetCardInfo("Relentless Assault", 132, Rarity.RARE, mage.cards.r.RelentlessAssault.class));
        cards.add(new SetCardInfo("Relic of Progenitus", 230, Rarity.COMMON, mage.cards.r.RelicOfProgenitus.class));
        cards.add(new SetCardInfo("Reliquary Tower", 111, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class));
        cards.add(new SetCardInfo("Reset", 170, Rarity.UNCOMMON, mage.cards.r.Reset.class));
        cards.add(new SetCardInfo("Rest in Peace", 150, Rarity.RARE, mage.cards.r.RestInPeace.class));
        cards.add(new SetCardInfo("Rishadan Port", 241, Rarity.RARE, mage.cards.r.RishadanPort.class));
        cards.add(new SetCardInfo("Rite of Flame", 59, Rarity.COMMON, mage.cards.r.RiteOfFlame.class));
        cards.add(new SetCardInfo("Rot Hulk", 128, Rarity.MYTHIC, mage.cards.r.RotHulk.class));
        cards.add(new SetCardInfo("Ruination", 199, Rarity.RARE, mage.cards.r.Ruination.class));
        cards.add(new SetCardInfo("Rusko, Clockmaker", 263, Rarity.UNCOMMON, mage.cards.r.RuskoClockmaker.class));
        cards.add(new SetCardInfo("Sakura-Tribe Elder", 72, Rarity.COMMON, mage.cards.s.SakuraTribeElder.class));
        cards.add(new SetCardInfo("Sanguine Brushstroke", 260, Rarity.UNCOMMON, mage.cards.s.SanguineBrushstroke.class));
        cards.add(new SetCardInfo("Sarkhan, Fireblood", 60, Rarity.MYTHIC, mage.cards.s.SarkhanFireblood.class));
        cards.add(new SetCardInfo("Scalelord Reckoner", 151, Rarity.RARE, mage.cards.s.ScalelordReckoner.class));
        cards.add(new SetCardInfo("Seedtime", 73, Rarity.RARE, mage.cards.s.Seedtime.class));
        cards.add(new SetCardInfo("Seeker of Skybreak", 213, Rarity.COMMON, mage.cards.s.SeekerOfSkybreak.class));
        cards.add(new SetCardInfo("Sengir Vampire", 129, Rarity.UNCOMMON, mage.cards.s.SengirVampire.class));
        cards.add(new SetCardInfo("Sensei's Divining Top", 231, Rarity.UNCOMMON, mage.cards.s.SenseisDiviningTop.class));
        cards.add(new SetCardInfo("Serenity", 152, Rarity.RARE, mage.cards.s.Serenity.class));
        cards.add(new SetCardInfo("Serra the Benevolent", 17, Rarity.MYTHIC, mage.cards.s.SerraTheBenevolent.class));
        cards.add(new SetCardInfo("Serum Powder", 142, Rarity.RARE, mage.cards.s.SerumPowder.class));
        cards.add(new SetCardInfo("Show and Tell", 171, Rarity.MYTHIC, mage.cards.s.ShowAndTell.class));
        cards.add(new SetCardInfo("Simian Spirit Guide", 61, Rarity.COMMON, mage.cards.s.SimianSpiritGuide.class));
        cards.add(new SetCardInfo("Skyclave Apparition", 18, Rarity.RARE, mage.cards.s.SkyclaveApparition.class));
        cards.add(new SetCardInfo("Smokestack", 232, Rarity.RARE, mage.cards.s.Smokestack.class));
        cards.add(new SetCardInfo("Snow-Covered Forest", 120, Rarity.LAND, mage.cards.s.SnowCoveredForest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Island", 117, Rarity.LAND, mage.cards.s.SnowCoveredIsland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Mountain", 119, Rarity.LAND, mage.cards.s.SnowCoveredMountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Plains", 116, Rarity.LAND, mage.cards.s.SnowCoveredPlains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Swamp", 118, Rarity.LAND, mage.cards.s.SnowCoveredSwamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snow-Covered Wastes", 121, Rarity.UNCOMMON, mage.cards.s.SnowCoveredWastes.class, FULL_ART_BFZ_VARIOUS));
        cards.add(new SetCardInfo("Snuff Out", 187, Rarity.COMMON, mage.cards.s.SnuffOut.class));
        cards.add(new SetCardInfo("Sol Ring", 233, Rarity.UNCOMMON, mage.cards.s.SolRing.class));
        cards.add(new SetCardInfo("Soul of Theros", 19, Rarity.MYTHIC, mage.cards.s.SoulOfTheros.class));
        cards.add(new SetCardInfo("Spell Pierce", 36, Rarity.COMMON, mage.cards.s.SpellPierce.class));
        cards.add(new SetCardInfo("Sphinx of the Steel Wind", 89, Rarity.MYTHIC, mage.cards.s.SphinxOfTheSteelWind.class));
        cards.add(new SetCardInfo("Spike Weaver", 214, Rarity.RARE, mage.cards.s.SpikeWeaver.class));
        cards.add(new SetCardInfo("Spirit of the Labyrinth", 20, Rarity.RARE, mage.cards.s.SpiritOfTheLabyrinth.class));
        cards.add(new SetCardInfo("Squee, Goblin Nabob", 247, Rarity.RARE, mage.cards.s.SqueeGoblinNabob.class));
        cards.add(new SetCardInfo("Standstill", 172, Rarity.UNCOMMON, mage.cards.s.Standstill.class));
        cards.add(new SetCardInfo("Static Orb", 234, Rarity.RARE, mage.cards.s.StaticOrb.class));
        cards.add(new SetCardInfo("Stifle", 173, Rarity.RARE, mage.cards.s.Stifle.class));
        cards.add(new SetCardInfo("Stitcher's Supplier", 48, Rarity.UNCOMMON, mage.cards.s.StitchersSupplier.class));
        cards.add(new SetCardInfo("Stone Drake", 363, Rarity.RARE, mage.cards.s.StoneDrake.class));
        cards.add(new SetCardInfo("Stony Silence", 21, Rarity.RARE, mage.cards.s.StonySilence.class));
        cards.add(new SetCardInfo("Street Wraith", 49, Rarity.COMMON, mage.cards.s.StreetWraith.class));
        cards.add(new SetCardInfo("Summoner's Pact", 74, Rarity.RARE, mage.cards.s.SummonersPact.class));
        cards.add(new SetCardInfo("Sword of the Meek", 98, Rarity.UNCOMMON, mage.cards.s.SwordOfTheMeek.class));
        cards.add(new SetCardInfo("Swords to Plowshares", 153, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class));
        cards.add(new SetCardInfo("Tarnished Citadel", 112, Rarity.RARE, mage.cards.t.TarnishedCitadel.class));
        cards.add(new SetCardInfo("Teferi, Hero of Dominaria", 90, Rarity.MYTHIC, mage.cards.t.TeferiHeroOfDominaria.class));
        cards.add(new SetCardInfo("Teferi, Time Raveler", 91, Rarity.RARE, mage.cards.t.TeferiTimeRaveler.class));
        cards.add(new SetCardInfo("Temporal Manipulation", 174, Rarity.MYTHIC, mage.cards.t.TemporalManipulation.class));
        cards.add(new SetCardInfo("Temporary Truce", 22, Rarity.RARE, mage.cards.t.TemporaryTruce.class));
        cards.add(new SetCardInfo("Tendrils of Agony", 50, Rarity.UNCOMMON, mage.cards.t.TendrilsOfAgony.class));
        cards.add(new SetCardInfo("Thassa's Oracle", 175, Rarity.RARE, mage.cards.t.ThassasOracle.class));
        cards.add(new SetCardInfo("The Rack", 141, Rarity.UNCOMMON, mage.cards.t.TheRack.class));
        cards.add(new SetCardInfo("Thespian's Stage", 113, Rarity.RARE, mage.cards.t.ThespiansStage.class));
        cards.add(new SetCardInfo("Thopter Foundry", 92, Rarity.UNCOMMON, mage.cards.t.ThopterFoundry.class));
        cards.add(new SetCardInfo("Thornbite Staff", 99, Rarity.UNCOMMON, mage.cards.t.ThornbiteStaff.class));
        cards.add(new SetCardInfo("Thought Vessel", 100, Rarity.COMMON, mage.cards.t.ThoughtVessel.class));
        cards.add(new SetCardInfo("Throes of Chaos", 62, Rarity.UNCOMMON, mage.cards.t.ThroesOfChaos.class));
        cards.add(new SetCardInfo("Tinder Wall", 215, Rarity.COMMON, mage.cards.t.TinderWall.class));
        cards.add(new SetCardInfo("Tinker", 176, Rarity.UNCOMMON, mage.cards.t.Tinker.class));
        cards.add(new SetCardInfo("Titania, Protector of Argoth", 249, Rarity.MYTHIC, mage.cards.t.TitaniaProtectorOfArgoth.class));
        cards.add(new SetCardInfo("Toralf's Disciple", 261, Rarity.UNCOMMON, mage.cards.t.ToralfsDisciple.class));
        cards.add(new SetCardInfo("Tormod's Crypt", 235, Rarity.UNCOMMON, mage.cards.t.TormodsCrypt.class));
        cards.add(new SetCardInfo("Torpor Orb", 236, Rarity.RARE, mage.cards.t.TorporOrb.class));
        cards.add(new SetCardInfo("Tower of the Magistrate", 242, Rarity.RARE, mage.cards.t.TowerOfTheMagistrate.class));
        cards.add(new SetCardInfo("Transcendent Master", 23, Rarity.MYTHIC, mage.cards.t.TranscendentMaster.class));
        cards.add(new SetCardInfo("Treasure Cruise", 37, Rarity.COMMON, mage.cards.t.TreasureCruise.class));
        cards.add(new SetCardInfo("Triumph of Ferocity", 135, Rarity.UNCOMMON, mage.cards.t.TriumphOfFerocity.class));
        cards.add(new SetCardInfo("Tsabo's Web", 143, Rarity.RARE, mage.cards.t.TsabosWeb.class));
        cards.add(new SetCardInfo("Umbral Mantle", 101, Rarity.UNCOMMON, mage.cards.u.UmbralMantle.class));
        cards.add(new SetCardInfo("Underworld Breach", 200, Rarity.RARE, mage.cards.u.UnderworldBreach.class));
        cards.add(new SetCardInfo("Unholy Heat", 63, Rarity.COMMON, mage.cards.u.UnholyHeat.class));
        cards.add(new SetCardInfo("Unnatural Selection", 38, Rarity.RARE, mage.cards.u.UnnaturalSelection.class));
        cards.add(new SetCardInfo("Uro, Titan of Nature's Wrath", 93, Rarity.MYTHIC, mage.cards.u.UroTitanOfNaturesWrath.class));
        cards.add(new SetCardInfo("Urza's Bauble", 237, Rarity.UNCOMMON, mage.cards.u.UrzasBauble.class));
        cards.add(new SetCardInfo("Urza's Saga", 114, Rarity.RARE, mage.cards.u.UrzasSaga.class));
        cards.add(new SetCardInfo("Urza, Lord High Artificer", 244, Rarity.MYTHIC, mage.cards.u.UrzaLordHighArtificer.class));
        cards.add(new SetCardInfo("Veil of Summer", 75, Rarity.UNCOMMON, mage.cards.v.VeilOfSummer.class));
        cards.add(new SetCardInfo("Velukan Dragon", 145, Rarity.RARE, mage.cards.v.VelukanDragon.class));
        cards.add(new SetCardInfo("Veteran Explorer", 76, Rarity.UNCOMMON, mage.cards.v.VeteranExplorer.class));
        cards.add(new SetCardInfo("Walking Ballista", 238, Rarity.RARE, mage.cards.w.WalkingBallista.class));
        cards.add(new SetCardInfo("Wasteland", 115, Rarity.UNCOMMON, mage.cards.w.Wasteland.class));
        cards.add(new SetCardInfo("Whiteout", 77, Rarity.COMMON, mage.cards.w.Whiteout.class));
        cards.add(new SetCardInfo("Winds of Change", 201, Rarity.UNCOMMON, mage.cards.w.WindsOfChange.class));
        cards.add(new SetCardInfo("Wish", 64, Rarity.RARE, mage.cards.w.Wish.class));
        cards.add(new SetCardInfo("Wishclaw Talisman", 51, Rarity.RARE, mage.cards.w.WishclawTalisman.class));
        cards.add(new SetCardInfo("Worst Fears", 52, Rarity.MYTHIC, mage.cards.w.WorstFears.class));
        cards.add(new SetCardInfo("Wowzer, the Aspirational", 365, Rarity.RARE, mage.cards.w.WowzerTheAspirational.class));
        cards.add(new SetCardInfo("Xantcha, Sleeper Agent", 253, Rarity.RARE, mage.cards.x.XantchaSleeperAgent.class));
        cards.add(new SetCardInfo("Yorion, Sky Nomad", 94, Rarity.RARE, mage.cards.y.YorionSkyNomad.class));
        cards.add(new SetCardInfo("Zombie Master", 188, Rarity.RARE, mage.cards.z.ZombieMaster.class));
    }
}
