package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class MultiverseLegends extends ExpansionSet {

    private static final MultiverseLegends instance = new MultiverseLegends();

    public static MultiverseLegends getInstance() {
        return instance;
    }

    private MultiverseLegends() {
        super("Multiverse Legends", "MUL", ExpansionSet.buildDate(2023, 4, 21), SetType.SUPPLEMENTAL);
        this.hasBoosters = false;
        this.hasBasicLands = false;

        cards.add(new SetCardInfo("Aegar, the Freezing Flame", 161, Rarity.UNCOMMON, mage.cards.a.AegarTheFreezingFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aegar, the Freezing Flame", 31, Rarity.UNCOMMON, mage.cards.a.AegarTheFreezingFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aegar, the Freezing Flame", 96, Rarity.UNCOMMON, mage.cards.a.AegarTheFreezingFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anafenza, Kin-Tree Spirit", 1, Rarity.RARE, mage.cards.a.AnafenzaKinTreeSpirit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anafenza, Kin-Tree Spirit", 131, Rarity.RARE, mage.cards.a.AnafenzaKinTreeSpirit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anafenza, Kin-Tree Spirit", 66, Rarity.RARE, mage.cards.a.AnafenzaKinTreeSpirit.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arixmethes, Slumbering Isle", 162, Rarity.RARE, mage.cards.a.ArixmethesSlumberingIsle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arixmethes, Slumbering Isle", 32, Rarity.RARE, mage.cards.a.ArixmethesSlumberingIsle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arixmethes, Slumbering Isle", 97, Rarity.RARE, mage.cards.a.ArixmethesSlumberingIsle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atraxa, Praetors' Voice", 163, Rarity.MYTHIC, mage.cards.a.AtraxaPraetorsVoice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atraxa, Praetors' Voice", 33, Rarity.MYTHIC, mage.cards.a.AtraxaPraetorsVoice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atraxa, Praetors' Voice", 98, Rarity.MYTHIC, mage.cards.a.AtraxaPraetorsVoice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atris, Oracle of Half-Truths", 164, Rarity.RARE, mage.cards.a.AtrisOracleOfHalfTruths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atris, Oracle of Half-Truths", 34, Rarity.RARE, mage.cards.a.AtrisOracleOfHalfTruths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atris, Oracle of Half-Truths", 99, Rarity.RARE, mage.cards.a.AtrisOracleOfHalfTruths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aurelia, the Warleader", 100, Rarity.MYTHIC, mage.cards.a.AureliaTheWarleader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aurelia, the Warleader", 165, Rarity.MYTHIC, mage.cards.a.AureliaTheWarleader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aurelia, the Warleader", 35, Rarity.MYTHIC, mage.cards.a.AureliaTheWarleader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ayara, First of Locthwain", 13, Rarity.RARE, mage.cards.a.AyaraFirstOfLocthwain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ayara, First of Locthwain", 143, Rarity.RARE, mage.cards.a.AyaraFirstOfLocthwain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ayara, First of Locthwain", 78, Rarity.RARE, mage.cards.a.AyaraFirstOfLocthwain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Baral, Chief of Compliance", 138, Rarity.RARE, mage.cards.b.BaralChiefOfCompliance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Baral, Chief of Compliance", 73, Rarity.RARE, mage.cards.b.BaralChiefOfCompliance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Baral, Chief of Compliance", 8, Rarity.RARE, mage.cards.b.BaralChiefOfCompliance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brudiclad, Telchor Engineer", 101, Rarity.RARE, mage.cards.b.BrudicladTelchorEngineer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brudiclad, Telchor Engineer", 166, Rarity.RARE, mage.cards.b.BrudicladTelchorEngineer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brudiclad, Telchor Engineer", 36, Rarity.RARE, mage.cards.b.BrudicladTelchorEngineer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Captain Lannery Storm", 150, Rarity.RARE, mage.cards.c.CaptainLanneryStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Captain Lannery Storm", 20, Rarity.RARE, mage.cards.c.CaptainLanneryStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Captain Lannery Storm", 85, Rarity.RARE, mage.cards.c.CaptainLanneryStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Daxos, Blessed by the Sun", 132, Rarity.UNCOMMON, mage.cards.d.DaxosBlessedByTheSun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Daxos, Blessed by the Sun", 2, Rarity.UNCOMMON, mage.cards.d.DaxosBlessedByTheSun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Daxos, Blessed by the Sun", 67, Rarity.UNCOMMON, mage.cards.d.DaxosBlessedByTheSun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dina, Soul Steeper", 102, Rarity.UNCOMMON, mage.cards.d.DinaSoulSteeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dina, Soul Steeper", 167, Rarity.UNCOMMON, mage.cards.d.DinaSoulSteeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dina, Soul Steeper", 37, Rarity.UNCOMMON, mage.cards.d.DinaSoulSteeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elesh Norn, Grand Cenobite", 133, Rarity.MYTHIC, mage.cards.e.EleshNornGrandCenobite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elesh Norn, Grand Cenobite", 3, Rarity.MYTHIC, mage.cards.e.EleshNornGrandCenobite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elesh Norn, Grand Cenobite", 68, Rarity.MYTHIC, mage.cards.e.EleshNornGrandCenobite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emry, Lurker of the Loch", 139, Rarity.RARE, mage.cards.e.EmryLurkerOfTheLoch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emry, Lurker of the Loch", 74, Rarity.RARE, mage.cards.e.EmryLurkerOfTheLoch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emry, Lurker of the Loch", 9, Rarity.RARE, mage.cards.e.EmryLurkerOfTheLoch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ezuri, Claw of Progress", 103, Rarity.MYTHIC, mage.cards.e.EzuriClawOfProgress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ezuri, Claw of Progress", 168, Rarity.MYTHIC, mage.cards.e.EzuriClawOfProgress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ezuri, Claw of Progress", 38, Rarity.MYTHIC, mage.cards.e.EzuriClawOfProgress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firesong and Sunspeaker", 104, Rarity.RARE, mage.cards.f.FiresongAndSunspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firesong and Sunspeaker", 169, Rarity.RARE, mage.cards.f.FiresongAndSunspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firesong and Sunspeaker", 39, Rarity.RARE, mage.cards.f.FiresongAndSunspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firja, Judge of Valor", 105, Rarity.UNCOMMON, mage.cards.f.FirjaJudgeOfValor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firja, Judge of Valor", 170, Rarity.UNCOMMON, mage.cards.f.FirjaJudgeOfValor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firja, Judge of Valor", 40, Rarity.UNCOMMON, mage.cards.f.FirjaJudgeOfValor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fynn, the Fangbearer", 156, Rarity.UNCOMMON, mage.cards.f.FynnTheFangbearer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fynn, the Fangbearer", 26, Rarity.UNCOMMON, mage.cards.f.FynnTheFangbearer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fynn, the Fangbearer", 91, Rarity.UNCOMMON, mage.cards.f.FynnTheFangbearer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goreclaw, Terror of Qal Sisma", 157, Rarity.RARE, mage.cards.g.GoreclawTerrorOfQalSisma.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goreclaw, Terror of Qal Sisma", 27, Rarity.RARE, mage.cards.g.GoreclawTerrorOfQalSisma.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goreclaw, Terror of Qal Sisma", 92, Rarity.RARE, mage.cards.g.GoreclawTerrorOfQalSisma.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grimgrin, Corpse-Born", 106, Rarity.MYTHIC, mage.cards.g.GrimgrinCorpseBorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grimgrin, Corpse-Born", 171, Rarity.MYTHIC, mage.cards.g.GrimgrinCorpseBorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grimgrin, Corpse-Born", 41, Rarity.MYTHIC, mage.cards.g.GrimgrinCorpseBorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gyruda, Doom of Depths", 107, Rarity.RARE, mage.cards.g.GyrudaDoomOfDepths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gyruda, Doom of Depths", 172, Rarity.RARE, mage.cards.g.GyrudaDoomOfDepths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gyruda, Doom of Depths", 42, Rarity.RARE, mage.cards.g.GyrudaDoomOfDepths.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horobi, Death's Wail", 14, Rarity.RARE, mage.cards.h.HorobiDeathsWail.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horobi, Death's Wail", 144, Rarity.RARE, mage.cards.h.HorobiDeathsWail.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horobi, Death's Wail", 79, Rarity.RARE, mage.cards.h.HorobiDeathsWail.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Imoti, Celebrant of Bounty", 108, Rarity.UNCOMMON, mage.cards.i.ImotiCelebrantOfBounty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Imoti, Celebrant of Bounty", 173, Rarity.UNCOMMON, mage.cards.i.ImotiCelebrantOfBounty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Imoti, Celebrant of Bounty", 43, Rarity.UNCOMMON, mage.cards.i.ImotiCelebrantOfBounty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inga Rune-Eyes", 10, Rarity.UNCOMMON, mage.cards.i.IngaRuneEyes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inga Rune-Eyes", 140, Rarity.UNCOMMON, mage.cards.i.IngaRuneEyes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inga Rune-Eyes", 75, Rarity.UNCOMMON, mage.cards.i.IngaRuneEyes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jegantha, the Wellspring", 109, Rarity.RARE, mage.cards.j.JeganthaTheWellspring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jegantha, the Wellspring", 174, Rarity.RARE, mage.cards.j.JeganthaTheWellspring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jegantha, the Wellspring", 44, Rarity.RARE, mage.cards.j.JeganthaTheWellspring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jin-Gitaxias, Core Augur", 11, Rarity.MYTHIC, mage.cards.j.JinGitaxiasCoreAugur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jin-Gitaxias, Core Augur", 141, Rarity.MYTHIC, mage.cards.j.JinGitaxiasCoreAugur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jin-Gitaxias, Core Augur", 76, Rarity.MYTHIC, mage.cards.j.JinGitaxiasCoreAugur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Judith, the Scourge Diva", 110, Rarity.RARE, mage.cards.j.JudithTheScourgeDiva.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Judith, the Scourge Diva", 175, Rarity.RARE, mage.cards.j.JudithTheScourgeDiva.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Judith, the Scourge Diva", 45, Rarity.RARE, mage.cards.j.JudithTheScourgeDiva.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Juri, Master of the Revue", 111, Rarity.UNCOMMON, mage.cards.j.JuriMasterOfTheRevue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Juri, Master of the Revue", 176, Rarity.UNCOMMON, mage.cards.j.JuriMasterOfTheRevue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Juri, Master of the Revue", 46, Rarity.UNCOMMON, mage.cards.j.JuriMasterOfTheRevue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kaheera, the Orphanguard", 112, Rarity.RARE, mage.cards.k.KaheeraTheOrphanguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kaheera, the Orphanguard", 177, Rarity.RARE, mage.cards.k.KaheeraTheOrphanguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kaheera, the Orphanguard", 47, Rarity.RARE, mage.cards.k.KaheeraTheOrphanguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kenrith, the Returned King", 134, Rarity.MYTHIC, mage.cards.k.KenrithTheReturnedKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kenrith, the Returned King", 4, Rarity.MYTHIC, mage.cards.k.KenrithTheReturnedKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kenrith, the Returned King", 69, Rarity.MYTHIC, mage.cards.k.KenrithTheReturnedKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keruga, the Macrosage", 113, Rarity.RARE, mage.cards.k.KerugaTheMacrosage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keruga, the Macrosage", 178, Rarity.RARE, mage.cards.k.KerugaTheMacrosage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keruga, the Macrosage", 48, Rarity.RARE, mage.cards.k.KerugaTheMacrosage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kroxa, Titan of Death's Hunger", 114, Rarity.MYTHIC, mage.cards.k.KroxaTitanOfDeathsHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kroxa, Titan of Death's Hunger", 179, Rarity.MYTHIC, mage.cards.k.KroxaTitanOfDeathsHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kroxa, Titan of Death's Hunger", 49, Rarity.MYTHIC, mage.cards.k.KroxaTitanOfDeathsHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kwende, Pride of Femeref", 135, Rarity.UNCOMMON, mage.cards.k.KwendePrideOfFemeref.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kwende, Pride of Femeref", 5, Rarity.UNCOMMON, mage.cards.k.KwendePrideOfFemeref.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kwende, Pride of Femeref", 70, Rarity.UNCOMMON, mage.cards.k.KwendePrideOfFemeref.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lathiel, the Bounteous Dawn", 115, Rarity.RARE, mage.cards.l.LathielTheBounteousDawn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lathiel, the Bounteous Dawn", 180, Rarity.RARE, mage.cards.l.LathielTheBounteousDawn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lathiel, the Bounteous Dawn", 50, Rarity.RARE, mage.cards.l.LathielTheBounteousDawn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lurrus of the Dream-Den", 116, Rarity.RARE, mage.cards.l.LurrusOfTheDreamDen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lurrus of the Dream-Den", 181, Rarity.RARE, mage.cards.l.LurrusOfTheDreamDen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lurrus of the Dream-Den", 51, Rarity.RARE, mage.cards.l.LurrusOfTheDreamDen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lutri, the Spellchaser", 117, Rarity.RARE, mage.cards.l.LutriTheSpellchaser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lutri, the Spellchaser", 182, Rarity.RARE, mage.cards.l.LutriTheSpellchaser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lutri, the Spellchaser", 52, Rarity.RARE, mage.cards.l.LutriTheSpellchaser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet Reborn", 118, Rarity.MYTHIC, mage.cards.n.NivMizzetReborn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet Reborn", 183, Rarity.MYTHIC, mage.cards.n.NivMizzetReborn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet Reborn", 53, Rarity.MYTHIC, mage.cards.n.NivMizzetReborn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obosh, the Preypiercer", 119, Rarity.RARE, mage.cards.o.OboshThePreypiercer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obosh, the Preypiercer", 184, Rarity.RARE, mage.cards.o.OboshThePreypiercer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obosh, the Preypiercer", 54, Rarity.RARE, mage.cards.o.OboshThePreypiercer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radha, Coalition Warlord", 120, Rarity.UNCOMMON, mage.cards.r.RadhaCoalitionWarlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radha, Coalition Warlord", 185, Rarity.UNCOMMON, mage.cards.r.RadhaCoalitionWarlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radha, Coalition Warlord", 55, Rarity.UNCOMMON, mage.cards.r.RadhaCoalitionWarlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raff, Weatherlight Stalwart", 121, Rarity.UNCOMMON, mage.cards.r.RaffWeatherlightStalwart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raff, Weatherlight Stalwart", 186, Rarity.UNCOMMON, mage.cards.r.RaffWeatherlightStalwart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raff, Weatherlight Stalwart", 56, Rarity.UNCOMMON, mage.cards.r.RaffWeatherlightStalwart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ragavan, Nimble Pilferer", 151, Rarity.MYTHIC, mage.cards.r.RagavanNimblePilferer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ragavan, Nimble Pilferer", 21, Rarity.MYTHIC, mage.cards.r.RagavanNimblePilferer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ragavan, Nimble Pilferer", 86, Rarity.MYTHIC, mage.cards.r.RagavanNimblePilferer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Renata, Called to the Hunt", 158, Rarity.UNCOMMON, mage.cards.r.RenataCalledToTheHunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Renata, Called to the Hunt", 28, Rarity.UNCOMMON, mage.cards.r.RenataCalledToTheHunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Renata, Called to the Hunt", 93, Rarity.UNCOMMON, mage.cards.r.RenataCalledToTheHunt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reyav, Master Smith", 122, Rarity.UNCOMMON, mage.cards.r.ReyavMasterSmith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reyav, Master Smith", 187, Rarity.UNCOMMON, mage.cards.r.ReyavMasterSmith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reyav, Master Smith", 57, Rarity.UNCOMMON, mage.cards.r.ReyavMasterSmith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rona, Sheoldred's Faithful", 123, Rarity.UNCOMMON, mage.cards.r.RonaSheoldredsFaithful.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rona, Sheoldred's Faithful", 188, Rarity.UNCOMMON, mage.cards.r.RonaSheoldredsFaithful.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rona, Sheoldred's Faithful", 58, Rarity.UNCOMMON, mage.cards.r.RonaSheoldredsFaithful.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seizan, Perverter of Truth", 145, Rarity.RARE, mage.cards.s.SeizanPerverterOfTruth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seizan, Perverter of Truth", 15, Rarity.RARE, mage.cards.s.SeizanPerverterOfTruth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seizan, Perverter of Truth", 80, Rarity.RARE, mage.cards.s.SeizanPerverterOfTruth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shanna, Sisay's Legacy", 124, Rarity.UNCOMMON, mage.cards.s.ShannaSisaysLegacy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shanna, Sisay's Legacy", 189, Rarity.UNCOMMON, mage.cards.s.ShannaSisaysLegacy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shanna, Sisay's Legacy", 59, Rarity.UNCOMMON, mage.cards.s.ShannaSisaysLegacy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sheoldred, Whispering One", 146, Rarity.MYTHIC, mage.cards.s.SheoldredWhisperingOne.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sheoldred, Whispering One", 16, Rarity.MYTHIC, mage.cards.s.SheoldredWhisperingOne.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sheoldred, Whispering One", 81, Rarity.MYTHIC, mage.cards.s.SheoldredWhisperingOne.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skithiryx, the Blight Dragon", 147, Rarity.MYTHIC, mage.cards.s.SkithiryxTheBlightDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skithiryx, the Blight Dragon", 17, Rarity.MYTHIC, mage.cards.s.SkithiryxTheBlightDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skithiryx, the Blight Dragon", 82, Rarity.MYTHIC, mage.cards.s.SkithiryxTheBlightDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Squee, the Immortal", 152, Rarity.RARE, mage.cards.s.SqueeTheImmortal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Squee, the Immortal", 22, Rarity.RARE, mage.cards.s.SqueeTheImmortal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Squee, the Immortal", 87, Rarity.RARE, mage.cards.s.SqueeTheImmortal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sram, Senior Edificer", 136, Rarity.RARE, mage.cards.s.SramSeniorEdificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sram, Senior Edificer", 6, Rarity.RARE, mage.cards.s.SramSeniorEdificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sram, Senior Edificer", 71, Rarity.RARE, mage.cards.s.SramSeniorEdificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Taigam, Ojutai Master", 125, Rarity.RARE, mage.cards.t.TaigamOjutaiMaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Taigam, Ojutai Master", 190, Rarity.RARE, mage.cards.t.TaigamOjutaiMaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Taigam, Ojutai Master", 60, Rarity.RARE, mage.cards.t.TaigamOjutaiMaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tetsuko Umezawa, Fugitive", 12, Rarity.UNCOMMON, mage.cards.t.TetsukoUmezawaFugitive.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tetsuko Umezawa, Fugitive", 142, Rarity.UNCOMMON, mage.cards.t.TetsukoUmezawaFugitive.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tetsuko Umezawa, Fugitive", 77, Rarity.UNCOMMON, mage.cards.t.TetsukoUmezawaFugitive.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teysa Karlov", 126, Rarity.RARE, mage.cards.t.TeysaKarlov.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teysa Karlov", 191, Rarity.RARE, mage.cards.t.TeysaKarlov.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teysa Karlov", 61, Rarity.RARE, mage.cards.t.TeysaKarlov.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thalia, Guardian of Thraben", 137, Rarity.RARE, mage.cards.t.ThaliaGuardianOfThraben.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thalia, Guardian of Thraben", 7, Rarity.RARE, mage.cards.t.ThaliaGuardianOfThraben.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thalia, Guardian of Thraben", 72, Rarity.RARE, mage.cards.t.ThaliaGuardianOfThraben.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tymaret, Chosen from Death", 148, Rarity.UNCOMMON, mage.cards.t.TymaretChosenFromDeath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tymaret, Chosen from Death", 18, Rarity.UNCOMMON, mage.cards.t.TymaretChosenFromDeath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tymaret, Chosen from Death", 83, Rarity.UNCOMMON, mage.cards.t.TymaretChosenFromDeath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Umori, the Collector", 127, Rarity.RARE, mage.cards.u.UmoriTheCollector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Umori, the Collector", 192, Rarity.RARE, mage.cards.u.UmoriTheCollector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Umori, the Collector", 62, Rarity.RARE, mage.cards.u.UmoriTheCollector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urabrask the Hidden", 153, Rarity.MYTHIC, mage.cards.u.UrabraskTheHidden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urabrask the Hidden", 23, Rarity.MYTHIC, mage.cards.u.UrabraskTheHidden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urabrask the Hidden", 88, Rarity.MYTHIC, mage.cards.u.UrabraskTheHidden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Valduk, Keeper of the Flame", 154, Rarity.UNCOMMON, mage.cards.v.ValdukKeeperOfTheFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Valduk, Keeper of the Flame", 24, Rarity.UNCOMMON, mage.cards.v.ValdukKeeperOfTheFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Valduk, Keeper of the Flame", 89, Rarity.UNCOMMON, mage.cards.v.ValdukKeeperOfTheFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vorinclex, Voice of Hunger", 159, Rarity.MYTHIC, mage.cards.v.VorinclexVoiceOfHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vorinclex, Voice of Hunger", 29, Rarity.MYTHIC, mage.cards.v.VorinclexVoiceOfHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vorinclex, Voice of Hunger", 94, Rarity.MYTHIC, mage.cards.v.VorinclexVoiceOfHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yargle, Glutton of Urborg", 149, Rarity.UNCOMMON, mage.cards.y.YargleGluttonOfUrborg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yargle, Glutton of Urborg", 19, Rarity.UNCOMMON, mage.cards.y.YargleGluttonOfUrborg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yargle, Glutton of Urborg", 84, Rarity.UNCOMMON, mage.cards.y.YargleGluttonOfUrborg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yarok, the Desecrated", 128, Rarity.MYTHIC, mage.cards.y.YarokTheDesecrated.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yarok, the Desecrated", 193, Rarity.MYTHIC, mage.cards.y.YarokTheDesecrated.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yarok, the Desecrated", 63, Rarity.MYTHIC, mage.cards.y.YarokTheDesecrated.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yedora, Grave Gardener", 160, Rarity.RARE, mage.cards.y.YedoraGraveGardener.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yedora, Grave Gardener", 30, Rarity.RARE, mage.cards.y.YedoraGraveGardener.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yedora, Grave Gardener", 95, Rarity.RARE, mage.cards.y.YedoraGraveGardener.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yorion, Sky Nomad", 129, Rarity.RARE, mage.cards.y.YorionSkyNomad.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yorion, Sky Nomad", 194, Rarity.RARE, mage.cards.y.YorionSkyNomad.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yorion, Sky Nomad", 64, Rarity.RARE, mage.cards.y.YorionSkyNomad.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zada, Hedron Grinder", 155, Rarity.UNCOMMON, mage.cards.z.ZadaHedronGrinder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zada, Hedron Grinder", 25, Rarity.UNCOMMON, mage.cards.z.ZadaHedronGrinder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zada, Hedron Grinder", 90, Rarity.UNCOMMON, mage.cards.z.ZadaHedronGrinder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zirda, the Dawnwaker", 130, Rarity.RARE, mage.cards.z.ZirdaTheDawnwaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zirda, the Dawnwaker", 195, Rarity.RARE, mage.cards.z.ZirdaTheDawnwaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zirda, the Dawnwaker", 65, Rarity.RARE, mage.cards.z.ZirdaTheDawnwaker.class, NON_FULL_USE_VARIOUS));
    }
}
