package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class MarchOfTheMachineTheAftermath extends ExpansionSet {

    private static final MarchOfTheMachineTheAftermath instance = new MarchOfTheMachineTheAftermath();

    public static MarchOfTheMachineTheAftermath getInstance() {
        return instance;
    }

    private MarchOfTheMachineTheAftermath() {
        super("March of the Machine: The Aftermath", "MAT", ExpansionSet.buildDate(2023, 5, 12), SetType.SUPPLEMENTAL_STANDARD_LEGAL);
        this.blockName = "March of the Machine";
        this.hasBasicLands = false;
        this.hasBoosters = false; // temporary

        cards.add(new SetCardInfo("Animist's Might", 120, Rarity.UNCOMMON, mage.cards.a.AnimistsMight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animist's Might", 20, Rarity.UNCOMMON, mage.cards.a.AnimistsMight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animist's Might", 70, Rarity.UNCOMMON, mage.cards.a.AnimistsMight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arni Metalbrow", 116, Rarity.RARE, mage.cards.a.ArniMetalbrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arni Metalbrow", 159, Rarity.RARE, mage.cards.a.ArniMetalbrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arni Metalbrow", 16, Rarity.RARE, mage.cards.a.ArniMetalbrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arni Metalbrow", 200, Rarity.RARE, mage.cards.a.ArniMetalbrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arni Metalbrow", 66, Rarity.RARE, mage.cards.a.ArniMetalbrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ayara's Oathsworn", 11, Rarity.RARE, mage.cards.a.AyarasOathsworn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ayara's Oathsworn", 111, Rarity.RARE, mage.cards.a.AyarasOathsworn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ayara's Oathsworn", 157, Rarity.RARE, mage.cards.a.AyarasOathsworn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ayara's Oathsworn", 195, Rarity.RARE, mage.cards.a.AyarasOathsworn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ayara's Oathsworn", 61, Rarity.RARE, mage.cards.a.AyarasOathsworn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blot Out", 112, Rarity.UNCOMMON, mage.cards.b.BlotOut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blot Out", 12, Rarity.UNCOMMON, mage.cards.b.BlotOut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blot Out", 196, Rarity.UNCOMMON, mage.cards.b.BlotOut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blot Out", 62, Rarity.UNCOMMON, mage.cards.b.BlotOut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Calix, Guided by Fate", 126, Rarity.MYTHIC, mage.cards.c.CalixGuidedByFate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Calix, Guided by Fate", 165, Rarity.MYTHIC, mage.cards.c.CalixGuidedByFate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Calix, Guided by Fate", 206, Rarity.MYTHIC, mage.cards.c.CalixGuidedByFate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Calix, Guided by Fate", 26, Rarity.MYTHIC, mage.cards.c.CalixGuidedByFate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Calix, Guided by Fate", 76, Rarity.MYTHIC, mage.cards.c.CalixGuidedByFate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Campus Renovation", 127, Rarity.UNCOMMON, mage.cards.c.CampusRenovation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Campus Renovation", 207, Rarity.UNCOMMON, mage.cards.c.CampusRenovation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Campus Renovation", 27, Rarity.UNCOMMON, mage.cards.c.CampusRenovation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Campus Renovation", 77, Rarity.UNCOMMON, mage.cards.c.CampusRenovation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coppercoat Vanguard", 1, Rarity.UNCOMMON, mage.cards.c.CoppercoatVanguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coppercoat Vanguard", 101, Rarity.UNCOMMON, mage.cards.c.CoppercoatVanguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coppercoat Vanguard", 186, Rarity.UNCOMMON, mage.cards.c.CoppercoatVanguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coppercoat Vanguard", 51, Rarity.UNCOMMON, mage.cards.c.CoppercoatVanguard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cosmic Rebirth", 128, Rarity.UNCOMMON, mage.cards.c.CosmicRebirth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cosmic Rebirth", 208, Rarity.UNCOMMON, mage.cards.c.CosmicRebirth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cosmic Rebirth", 28, Rarity.UNCOMMON, mage.cards.c.CosmicRebirth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cosmic Rebirth", 78, Rarity.UNCOMMON, mage.cards.c.CosmicRebirth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Danitha, New Benalia's Light", 129, Rarity.RARE, mage.cards.d.DanithaNewBenaliasLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Danitha, New Benalia's Light", 166, Rarity.RARE, mage.cards.d.DanithaNewBenaliasLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Danitha, New Benalia's Light", 209, Rarity.RARE, mage.cards.d.DanithaNewBenaliasLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Danitha, New Benalia's Light", 29, Rarity.RARE, mage.cards.d.DanithaNewBenaliasLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Danitha, New Benalia's Light", 79, Rarity.RARE, mage.cards.d.DanithaNewBenaliasLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Death-Rattle Oni", 113, Rarity.UNCOMMON, mage.cards.d.DeathRattleOni.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Death-Rattle Oni", 13, Rarity.UNCOMMON, mage.cards.d.DeathRattleOni.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Death-Rattle Oni", 197, Rarity.UNCOMMON, mage.cards.d.DeathRattleOni.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Death-Rattle Oni", 63, Rarity.UNCOMMON, mage.cards.d.DeathRattleOni.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deification", 102, Rarity.RARE, mage.cards.d.Deification.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deification", 151, Rarity.RARE, mage.cards.d.Deification.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deification", 187, Rarity.RARE, mage.cards.d.Deification.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deification", 2, Rarity.RARE, mage.cards.d.Deification.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deification", 52, Rarity.RARE, mage.cards.d.Deification.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drannith Ruins", 100, Rarity.RARE, mage.cards.d.DrannithRuins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drannith Ruins", 150, Rarity.RARE, mage.cards.d.DrannithRuins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drannith Ruins", 185, Rarity.RARE, mage.cards.d.DrannithRuins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drannith Ruins", 228, Rarity.RARE, mage.cards.d.DrannithRuins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drannith Ruins", 50, Rarity.RARE, mage.cards.d.DrannithRuins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feast of the Victorious Dead", 130, Rarity.UNCOMMON, mage.cards.f.FeastOfTheVictoriousDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feast of the Victorious Dead", 210, Rarity.UNCOMMON, mage.cards.f.FeastOfTheVictoriousDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feast of the Victorious Dead", 30, Rarity.UNCOMMON, mage.cards.f.FeastOfTheVictoriousDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Feast of the Victorious Dead", 80, Rarity.UNCOMMON, mage.cards.f.FeastOfTheVictoriousDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Filter Out", 107, Rarity.UNCOMMON, mage.cards.f.FilterOut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Filter Out", 191, Rarity.UNCOMMON, mage.cards.f.FilterOut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Filter Out", 57, Rarity.UNCOMMON, mage.cards.f.FilterOut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Filter Out", 7, Rarity.UNCOMMON, mage.cards.f.FilterOut.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gold-Forged Thopteryx", 131, Rarity.UNCOMMON, mage.cards.g.GoldForgedThopteryx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gold-Forged Thopteryx", 211, Rarity.UNCOMMON, mage.cards.g.GoldForgedThopteryx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gold-Forged Thopteryx", 31, Rarity.UNCOMMON, mage.cards.g.GoldForgedThopteryx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gold-Forged Thopteryx", 81, Rarity.UNCOMMON, mage.cards.g.GoldForgedThopteryx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harnessed Snubhorn", 103, Rarity.UNCOMMON, mage.cards.h.HarnessedSnubhorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harnessed Snubhorn", 188, Rarity.UNCOMMON, mage.cards.h.HarnessedSnubhorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harnessed Snubhorn", 3, Rarity.UNCOMMON, mage.cards.h.HarnessedSnubhorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harnessed Snubhorn", 53, Rarity.UNCOMMON, mage.cards.h.HarnessedSnubhorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jirina, Dauntless General", 132, Rarity.RARE, mage.cards.j.JirinaDauntlessGeneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jirina, Dauntless General", 167, Rarity.RARE, mage.cards.j.JirinaDauntlessGeneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jirina, Dauntless General", 212, Rarity.RARE, mage.cards.j.JirinaDauntlessGeneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jirina, Dauntless General", 32, Rarity.RARE, mage.cards.j.JirinaDauntlessGeneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jirina, Dauntless General", 82, Rarity.RARE, mage.cards.j.JirinaDauntlessGeneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jolrael, Voice of Zhalfir", 133, Rarity.RARE, mage.cards.j.JolraelVoiceOfZhalfir.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jolrael, Voice of Zhalfir", 168, Rarity.RARE, mage.cards.j.JolraelVoiceOfZhalfir.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jolrael, Voice of Zhalfir", 230, Rarity.RARE, mage.cards.j.JolraelVoiceOfZhalfir.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jolrael, Voice of Zhalfir", 33, Rarity.RARE, mage.cards.j.JolraelVoiceOfZhalfir.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jolrael, Voice of Zhalfir", 83, Rarity.RARE, mage.cards.j.JolraelVoiceOfZhalfir.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, Legacy Reforged", 149, Rarity.MYTHIC, mage.cards.k.KarnLegacyReforged.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, Legacy Reforged", 184, Rarity.MYTHIC, mage.cards.k.KarnLegacyReforged.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, Legacy Reforged", 49, Rarity.MYTHIC, mage.cards.k.KarnLegacyReforged.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn, Legacy Reforged", 99, Rarity.MYTHIC, mage.cards.k.KarnLegacyReforged.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kiora, Sovereign of the Deep", 135, Rarity.MYTHIC, mage.cards.k.KioraSovereignOfTheDeep.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kiora, Sovereign of the Deep", 170, Rarity.MYTHIC, mage.cards.k.KioraSovereignOfTheDeep.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kiora, Sovereign of the Deep", 214, Rarity.MYTHIC, mage.cards.k.KioraSovereignOfTheDeep.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kiora, Sovereign of the Deep", 35, Rarity.MYTHIC, mage.cards.k.KioraSovereignOfTheDeep.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kiora, Sovereign of the Deep", 85, Rarity.MYTHIC, mage.cards.k.KioraSovereignOfTheDeep.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kolaghan Warmonger", 117, Rarity.UNCOMMON, mage.cards.k.KolaghanWarmonger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kolaghan Warmonger", 17, Rarity.UNCOMMON, mage.cards.k.KolaghanWarmonger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kolaghan Warmonger", 201, Rarity.UNCOMMON, mage.cards.k.KolaghanWarmonger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kolaghan Warmonger", 67, Rarity.UNCOMMON, mage.cards.k.KolaghanWarmonger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leyline Immersion", 121, Rarity.RARE, mage.cards.l.LeylineImmersion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leyline Immersion", 161, Rarity.RARE, mage.cards.l.LeylineImmersion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leyline Immersion", 21, Rarity.RARE, mage.cards.l.LeylineImmersion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leyline Immersion", 71, Rarity.RARE, mage.cards.l.LeylineImmersion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Markov Baron", 114, Rarity.UNCOMMON, mage.cards.m.MarkovBaron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Markov Baron", 14, Rarity.UNCOMMON, mage.cards.m.MarkovBaron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Markov Baron", 198, Rarity.UNCOMMON, mage.cards.m.MarkovBaron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Markov Baron", 64, Rarity.UNCOMMON, mage.cards.m.MarkovBaron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Metropolis Reformer", 104, Rarity.RARE, mage.cards.m.MetropolisReformer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Metropolis Reformer", 152, Rarity.RARE, mage.cards.m.MetropolisReformer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Metropolis Reformer", 189, Rarity.RARE, mage.cards.m.MetropolisReformer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Metropolis Reformer", 4, Rarity.RARE, mage.cards.m.MetropolisReformer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Metropolis Reformer", 54, Rarity.RARE, mage.cards.m.MetropolisReformer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri's Resolve", 137, Rarity.RARE, mage.cards.n.NahirisResolve.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri's Resolve", 172, Rarity.RARE, mage.cards.n.NahirisResolve.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri's Resolve", 216, Rarity.RARE, mage.cards.n.NahirisResolve.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri's Resolve", 37, Rarity.RARE, mage.cards.n.NahirisResolve.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri's Resolve", 87, Rarity.RARE, mage.cards.n.NahirisResolve.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, Forged in Fury", 136, Rarity.MYTHIC, mage.cards.n.NahiriForgedInFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, Forged in Fury", 171, Rarity.MYTHIC, mage.cards.n.NahiriForgedInFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, Forged in Fury", 215, Rarity.MYTHIC, mage.cards.n.NahiriForgedInFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, Forged in Fury", 36, Rarity.MYTHIC, mage.cards.n.NahiriForgedInFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, Forged in Fury", 86, Rarity.MYTHIC, mage.cards.n.NahiriForgedInFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset, Enlightened Exile", 138, Rarity.MYTHIC, mage.cards.n.NarsetEnlightenedExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset, Enlightened Exile", 173, Rarity.MYTHIC, mage.cards.n.NarsetEnlightenedExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset, Enlightened Exile", 217, Rarity.MYTHIC, mage.cards.n.NarsetEnlightenedExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset, Enlightened Exile", 38, Rarity.MYTHIC, mage.cards.n.NarsetEnlightenedExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset, Enlightened Exile", 88, Rarity.MYTHIC, mage.cards.n.NarsetEnlightenedExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nashi, Moon's Legacy", 139, Rarity.RARE, mage.cards.n.NashiMoonsLegacy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nashi, Moon's Legacy", 174, Rarity.RARE, mage.cards.n.NashiMoonsLegacy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nashi, Moon's Legacy", 218, Rarity.RARE, mage.cards.n.NashiMoonsLegacy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nashi, Moon's Legacy", 39, Rarity.RARE, mage.cards.n.NashiMoonsLegacy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nashi, Moon's Legacy", 89, Rarity.RARE, mage.cards.n.NashiMoonsLegacy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nissa, Resurgent Animist", 122, Rarity.MYTHIC, mage.cards.n.NissaResurgentAnimist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nissa, Resurgent Animist", 162, Rarity.MYTHIC, mage.cards.n.NissaResurgentAnimist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nissa, Resurgent Animist", 22, Rarity.MYTHIC, mage.cards.n.NissaResurgentAnimist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nissa, Resurgent Animist", 72, Rarity.MYTHIC, mage.cards.n.NissaResurgentAnimist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet, Supreme", 140, Rarity.RARE, mage.cards.n.NivMizzetSupreme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet, Supreme", 175, Rarity.RARE, mage.cards.n.NivMizzetSupreme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet, Supreme", 219, Rarity.RARE, mage.cards.n.NivMizzetSupreme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet, Supreme", 40, Rarity.RARE, mage.cards.n.NivMizzetSupreme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Niv-Mizzet, Supreme", 90, Rarity.RARE, mage.cards.n.NivMizzetSupreme.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, Captive Kingpin", 141, Rarity.MYTHIC, mage.cards.o.ObNixilisCaptiveKingpin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, Captive Kingpin", 176, Rarity.MYTHIC, mage.cards.o.ObNixilisCaptiveKingpin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, Captive Kingpin", 220, Rarity.MYTHIC, mage.cards.o.ObNixilisCaptiveKingpin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, Captive Kingpin", 41, Rarity.MYTHIC, mage.cards.o.ObNixilisCaptiveKingpin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, Captive Kingpin", 91, Rarity.MYTHIC, mage.cards.o.ObNixilisCaptiveKingpin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Open the Way", 123, Rarity.RARE, mage.cards.o.OpenTheWay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Open the Way", 163, Rarity.RARE, mage.cards.o.OpenTheWay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Open the Way", 23, Rarity.RARE, mage.cards.o.OpenTheWay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Open the Way", 73, Rarity.RARE, mage.cards.o.OpenTheWay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pia Nalaar, Consul of Revival", 142, Rarity.RARE, mage.cards.p.PiaNalaarConsulOfRevival.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pia Nalaar, Consul of Revival", 177, Rarity.RARE, mage.cards.p.PiaNalaarConsulOfRevival.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pia Nalaar, Consul of Revival", 221, Rarity.RARE, mage.cards.p.PiaNalaarConsulOfRevival.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pia Nalaar, Consul of Revival", 42, Rarity.RARE, mage.cards.p.PiaNalaarConsulOfRevival.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pia Nalaar, Consul of Revival", 92, Rarity.RARE, mage.cards.p.PiaNalaarConsulOfRevival.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plargg and Nassari", 118, Rarity.RARE, mage.cards.p.PlarggAndNassari.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plargg and Nassari", 160, Rarity.RARE, mage.cards.p.PlarggAndNassari.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plargg and Nassari", 18, Rarity.RARE, mage.cards.p.PlarggAndNassari.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plargg and Nassari", 202, Rarity.RARE, mage.cards.p.PlarggAndNassari.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plargg and Nassari", 68, Rarity.RARE, mage.cards.p.PlarggAndNassari.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rebuild the City", 143, Rarity.RARE, mage.cards.r.RebuildTheCity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rebuild the City", 178, Rarity.RARE, mage.cards.r.RebuildTheCity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rebuild the City", 222, Rarity.RARE, mage.cards.r.RebuildTheCity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rebuild the City", 43, Rarity.RARE, mage.cards.r.RebuildTheCity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rebuild the City", 93, Rarity.RARE, mage.cards.r.RebuildTheCity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reckless Handling", 119, Rarity.UNCOMMON, mage.cards.r.RecklessHandling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reckless Handling", 19, Rarity.UNCOMMON, mage.cards.r.RecklessHandling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reckless Handling", 203, Rarity.UNCOMMON, mage.cards.r.RecklessHandling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reckless Handling", 69, Rarity.UNCOMMON, mage.cards.r.RecklessHandling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rocco, Street Chef", 144, Rarity.RARE, mage.cards.r.RoccoStreetChef.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rocco, Street Chef", 179, Rarity.RARE, mage.cards.r.RoccoStreetChef.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rocco, Street Chef", 223, Rarity.RARE, mage.cards.r.RoccoStreetChef.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rocco, Street Chef", 44, Rarity.RARE, mage.cards.r.RoccoStreetChef.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rocco, Street Chef", 94, Rarity.RARE, mage.cards.r.RoccoStreetChef.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samut, Vizier of Naktamun", 145, Rarity.MYTHIC, mage.cards.s.SamutVizierOfNaktamun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samut, Vizier of Naktamun", 180, Rarity.MYTHIC, mage.cards.s.SamutVizierOfNaktamun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samut, Vizier of Naktamun", 224, Rarity.MYTHIC, mage.cards.s.SamutVizierOfNaktamun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samut, Vizier of Naktamun", 45, Rarity.MYTHIC, mage.cards.s.SamutVizierOfNaktamun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samut, Vizier of Naktamun", 95, Rarity.MYTHIC, mage.cards.s.SamutVizierOfNaktamun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sarkhan, Soul Aflame", 146, Rarity.MYTHIC, mage.cards.s.SarkhanSoulAflame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sarkhan, Soul Aflame", 181, Rarity.MYTHIC, mage.cards.s.SarkhanSoulAflame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sarkhan, Soul Aflame", 225, Rarity.MYTHIC, mage.cards.s.SarkhanSoulAflame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sarkhan, Soul Aflame", 46, Rarity.MYTHIC, mage.cards.s.SarkhanSoulAflame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sarkhan, Soul Aflame", 96, Rarity.MYTHIC, mage.cards.s.SarkhanSoulAflame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sigarda, Font of Blessings", 147, Rarity.RARE, mage.cards.s.SigardaFontOfBlessings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sigarda, Font of Blessings", 182, Rarity.RARE, mage.cards.s.SigardaFontOfBlessings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sigarda, Font of Blessings", 226, Rarity.RARE, mage.cards.s.SigardaFontOfBlessings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sigarda, Font of Blessings", 47, Rarity.RARE, mage.cards.s.SigardaFontOfBlessings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sigarda, Font of Blessings", 97, Rarity.RARE, mage.cards.s.SigardaFontOfBlessings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Rupture", 105, Rarity.RARE, mage.cards.s.SparkRupture.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Rupture", 153, Rarity.RARE, mage.cards.s.SparkRupture.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Rupture", 229, Rarity.RARE, mage.cards.s.SparkRupture.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Rupture", 5, Rarity.RARE, mage.cards.s.SparkRupture.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Rupture", 55, Rarity.RARE, mage.cards.s.SparkRupture.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tazri, Stalwart Survivor", 106, Rarity.RARE, mage.cards.t.TazriStalwartSurvivor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tazri, Stalwart Survivor", 154, Rarity.RARE, mage.cards.t.TazriStalwartSurvivor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tazri, Stalwart Survivor", 190, Rarity.RARE, mage.cards.t.TazriStalwartSurvivor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tazri, Stalwart Survivor", 56, Rarity.RARE, mage.cards.t.TazriStalwartSurvivor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tazri, Stalwart Survivor", 6, Rarity.RARE, mage.cards.t.TazriStalwartSurvivor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Kenriths' Royal Funeral", 134, Rarity.RARE, mage.cards.t.TheKenrithsRoyalFuneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Kenriths' Royal Funeral", 169, Rarity.RARE, mage.cards.t.TheKenrithsRoyalFuneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Kenriths' Royal Funeral", 213, Rarity.RARE, mage.cards.t.TheKenrithsRoyalFuneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Kenriths' Royal Funeral", 34, Rarity.RARE, mage.cards.t.TheKenrithsRoyalFuneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Kenriths' Royal Funeral", 84, Rarity.RARE, mage.cards.t.TheKenrithsRoyalFuneral.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tolarian Contempt", 108, Rarity.UNCOMMON, mage.cards.t.TolarianContempt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tolarian Contempt", 192, Rarity.UNCOMMON, mage.cards.t.TolarianContempt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tolarian Contempt", 58, Rarity.UNCOMMON, mage.cards.t.TolarianContempt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tolarian Contempt", 8, Rarity.UNCOMMON, mage.cards.t.TolarianContempt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Training Grounds", 109, Rarity.RARE, mage.cards.t.TrainingGrounds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Training Grounds", 155, Rarity.RARE, mage.cards.t.TrainingGrounds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Training Grounds", 193, Rarity.RARE, mage.cards.t.TrainingGrounds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Training Grounds", 59, Rarity.RARE, mage.cards.t.TrainingGrounds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Training Grounds", 9, Rarity.RARE, mage.cards.t.TrainingGrounds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tranquil Frillback", 124, Rarity.RARE, mage.cards.t.TranquilFrillback.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tranquil Frillback", 164, Rarity.RARE, mage.cards.t.TranquilFrillback.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tranquil Frillback", 204, Rarity.RARE, mage.cards.t.TranquilFrillback.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tranquil Frillback", 24, Rarity.RARE, mage.cards.t.TranquilFrillback.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tranquil Frillback", 74, Rarity.RARE, mage.cards.t.TranquilFrillback.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tyvar the Bellicose", 148, Rarity.MYTHIC, mage.cards.t.TyvarTheBellicose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tyvar the Bellicose", 183, Rarity.MYTHIC, mage.cards.t.TyvarTheBellicose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tyvar the Bellicose", 227, Rarity.MYTHIC, mage.cards.t.TyvarTheBellicose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tyvar the Bellicose", 48, Rarity.MYTHIC, mage.cards.t.TyvarTheBellicose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tyvar the Bellicose", 98, Rarity.MYTHIC, mage.cards.t.TyvarTheBellicose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undercity Upheaval", 125, Rarity.UNCOMMON, mage.cards.u.UndercityUpheaval.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undercity Upheaval", 205, Rarity.UNCOMMON, mage.cards.u.UndercityUpheaval.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undercity Upheaval", 25, Rarity.UNCOMMON, mage.cards.u.UndercityUpheaval.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undercity Upheaval", 75, Rarity.UNCOMMON, mage.cards.u.UndercityUpheaval.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urborg Scavengers", 115, Rarity.RARE, mage.cards.u.UrborgScavengers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urborg Scavengers", 15, Rarity.RARE, mage.cards.u.UrborgScavengers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urborg Scavengers", 158, Rarity.RARE, mage.cards.u.UrborgScavengers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urborg Scavengers", 199, Rarity.RARE, mage.cards.u.UrborgScavengers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urborg Scavengers", 65, Rarity.RARE, mage.cards.u.UrborgScavengers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vesuvan Drifter", 10, Rarity.RARE, mage.cards.v.VesuvanDrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vesuvan Drifter", 110, Rarity.RARE, mage.cards.v.VesuvanDrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vesuvan Drifter", 156, Rarity.RARE, mage.cards.v.VesuvanDrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vesuvan Drifter", 194, Rarity.RARE, mage.cards.v.VesuvanDrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vesuvan Drifter", 60, Rarity.RARE, mage.cards.v.VesuvanDrifter.class, NON_FULL_USE_VARIOUS));
    }
}
