package mage.sets;

import mage.cards.CardGraphicInfo;
import mage.cards.ExpansionSet;
import mage.cards.FrameStyle;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * https://scryfall.com/sets/prm
 */
public class MagicOnlinePromos extends ExpansionSet {

    private static final MagicOnlinePromos instance = new MagicOnlinePromos();

    public static MagicOnlinePromos getInstance() {
        return instance;
    }

    private MagicOnlinePromos() {
        super("Magic Online Promos", "PRM", ExpansionSet.buildDate(2002, 6, 24), SetType.PROMOTIONAL);
        this.hasBoosters = false;
        this.hasBasicLands = true;

        final CardGraphicInfo FULL_ART = new CardGraphicInfo(FrameStyle.MPOP_FULL_ART_BASIC, true);

        cards.add(new SetCardInfo("Abbot of Keral Keep", 62501, Rarity.RARE, mage.cards.a.AbbotOfKeralKeep.class));
        cards.add(new SetCardInfo("Abhorrent Overlord", 50126, Rarity.RARE, mage.cards.a.AbhorrentOverlord.class));
        cards.add(new SetCardInfo("Abrade", 65001, Rarity.UNCOMMON, mage.cards.a.Abrade.class, FULL_ART));
        cards.add(new SetCardInfo("Abrupt Decay", 59681, Rarity.RARE, mage.cards.a.AbruptDecay.class));
        cards.add(new SetCardInfo("Abu Ja'far", 62479, Rarity.UNCOMMON, mage.cards.a.AbuJafar.class));
        cards.add(new SetCardInfo("Abzan Beastmaster", 55888, Rarity.UNCOMMON, mage.cards.a.AbzanBeastmaster.class));
        cards.add(new SetCardInfo("Accumulated Knowledge", 36182, Rarity.COMMON, mage.cards.a.AccumulatedKnowledge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Accumulated Knowledge", 59641, Rarity.COMMON, mage.cards.a.AccumulatedKnowledge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Acidic Slime", 45199, Rarity.UNCOMMON, mage.cards.a.AcidicSlime.class));
        cards.add(new SetCardInfo("Adorned Pouncer", 64993, Rarity.RARE, mage.cards.a.AdornedPouncer.class, FULL_ART));
        cards.add(new SetCardInfo("Aether Hub", 64432, Rarity.UNCOMMON, mage.cards.a.AetherHub.class));
        cards.add(new SetCardInfo("Aether Storm", 62453, Rarity.UNCOMMON, mage.cards.a.AetherStorm.class));
        cards.add(new SetCardInfo("Ainok Tracker", 55779, Rarity.COMMON, mage.cards.a.AinokTracker.class));
        cards.add(new SetCardInfo("Aisling Leprechaun", 35050, Rarity.COMMON, mage.cards.a.AislingLeprechaun.class));
        cards.add(new SetCardInfo("Ajani Goldmane", 37847, Rarity.MYTHIC, mage.cards.a.AjaniGoldmane.class));
        cards.add(new SetCardInfo("Ajani Vengeant", 31969, Rarity.MYTHIC, mage.cards.a.AjaniVengeant.class));
        cards.add(new SetCardInfo("Ajani, the Greathearted", 72295, Rarity.RARE, mage.cards.a.AjaniTheGreathearted.class));
        cards.add(new SetCardInfo("Albino Troll", 36122, Rarity.UNCOMMON, mage.cards.a.AlbinoTroll.class));
        cards.add(new SetCardInfo("Alhammarret, High Arbiter", 57588, Rarity.RARE, mage.cards.a.AlhammarretHighArbiter.class));
        cards.add(new SetCardInfo("Allosaurus Rider", 32033, Rarity.RARE, mage.cards.a.AllosaurusRider.class));
        cards.add(new SetCardInfo("Altar of the Brood", 55787, Rarity.RARE, mage.cards.a.AltarOfTheBrood.class));
        cards.add(new SetCardInfo("Ambition's Cost", 62523, Rarity.UNCOMMON, mage.cards.a.AmbitionsCost.class));
        cards.add(new SetCardInfo("Anathemancer", 37606, Rarity.UNCOMMON, mage.cards.a.Anathemancer.class));
        cards.add(new SetCardInfo("Ancestral Recall", 46954, Rarity.RARE, mage.cards.a.AncestralRecall.class));
        cards.add(new SetCardInfo("Ancient Grudge", 43590, Rarity.COMMON, mage.cards.a.AncientGrudge.class));
        cards.add(new SetCardInfo("Ancient Hellkite", 37594, Rarity.RARE, mage.cards.a.AncientHellkite.class));
        cards.add(new SetCardInfo("Ancient Stirrings", 70944, Rarity.COMMON, mage.cards.a.AncientStirrings.class));
        cards.add(new SetCardInfo("Ancient Ziggurat", 43562, Rarity.UNCOMMON, mage.cards.a.AncientZiggurat.class));
        cards.add(new SetCardInfo("Angel of Deliverance", 60474, Rarity.RARE, mage.cards.a.AngelOfDeliverance.class));
        cards.add(new SetCardInfo("Angrath, Captain of Chaos", 72237, Rarity.UNCOMMON, mage.cards.a.AngrathCaptainOfChaos.class));
        cards.add(new SetCardInfo("Anguished Unmaking", 60462, Rarity.RARE, mage.cards.a.AnguishedUnmaking.class, FULL_ART));
        cards.add(new SetCardInfo("Animating Faerie", 78746, Rarity.UNCOMMON, mage.cards.a.AnimatingFaerie.class));
        cards.add(new SetCardInfo("Ankle Shanker", 54512, Rarity.RARE, mage.cards.a.AnkleShanker.class));
        cards.add(new SetCardInfo("Ant Queen", 33103, Rarity.RARE, mage.cards.a.AntQueen.class));
        cards.add(new SetCardInfo("Anthousa, Setessan Hero", 50124, Rarity.RARE, mage.cards.a.AnthousaSetessanHero.class));
        cards.add(new SetCardInfo("Anticipate", 58267, Rarity.COMMON, mage.cards.a.Anticipate.class));
        cards.add(new SetCardInfo("Arashin Sovereign", 56996, Rarity.RARE, mage.cards.a.ArashinSovereign.class));
        cards.add(new SetCardInfo("Arashin War Beast", 55741, Rarity.UNCOMMON, mage.cards.a.ArashinWarBeast.class));
        cards.add(new SetCardInfo("Arbiter of the Ideal", 51912, Rarity.RARE, mage.cards.a.ArbiterOfTheIdeal.class));
        cards.add(new SetCardInfo("Arc Lightning", 36116, Rarity.COMMON, mage.cards.a.ArcLightning.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arc Lightning", 55791, Rarity.UNCOMMON, mage.cards.a.ArcLightning.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcanis the Omnipotent", 54547, Rarity.MYTHIC, mage.cards.a.ArcanisTheOmnipotent.class));
        cards.add(new SetCardInfo("Archdemon of Greed", 43503, Rarity.RARE, mage.cards.a.ArchdemonOfGreed.class));
        cards.add(new SetCardInfo("Archfiend of Depravity", 55711, Rarity.RARE, mage.cards.a.ArchfiendOfDepravity.class));
        cards.add(new SetCardInfo("Archfiend of Ifnir", 64422, Rarity.RARE, mage.cards.a.ArchfiendOfIfnir.class));
        cards.add(new SetCardInfo("Archon of the Triumvirate", 46877, Rarity.RARE, mage.cards.a.ArchonOfTheTriumvirate.class));
        cards.add(new SetCardInfo("Ardenvale Tactician", 78790, Rarity.COMMON, mage.cards.a.ArdenvaleTactician.class));
        cards.add(new SetCardInfo("Arena", 35958, Rarity.RARE, mage.cards.a.Arena.class));
        cards.add(new SetCardInfo("Argivian Archaeologist", 219, Rarity.RARE, mage.cards.a.ArgivianArchaeologist.class));
        cards.add(new SetCardInfo("Argothian Enchantress", 36104, Rarity.RARE, mage.cards.a.ArgothianEnchantress.class));
        cards.add(new SetCardInfo("Arlinn, Voice of the Pack", 72239, Rarity.UNCOMMON, mage.cards.a.ArlinnVoiceOfThePack.class));
        cards.add(new SetCardInfo("Armadillo Cloak", 31455, Rarity.COMMON, mage.cards.a.ArmadilloCloak.class));
        cards.add(new SetCardInfo("Armageddon", 31413, Rarity.RARE, mage.cards.a.Armageddon.class));
        cards.add(new SetCardInfo("Arrogant Wurm", 36246, Rarity.UNCOMMON, mage.cards.a.ArrogantWurm.class));
        cards.add(new SetCardInfo("Artisan of Kozilek", 39673, Rarity.UNCOMMON, mage.cards.a.ArtisanOfKozilek.class));
        cards.add(new SetCardInfo("Ash Barrens", 69983, Rarity.COMMON, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Ashiok, Dream Render", 72259, Rarity.UNCOMMON, mage.cards.a.AshiokDreamRender.class));
        cards.add(new SetCardInfo("Assembled Alphas", 61551, Rarity.RARE, mage.cards.a.AssembledAlphas.class));
        cards.add(new SetCardInfo("Astral Slide", 32567, Rarity.UNCOMMON, mage.cards.a.AstralSlide.class));
        cards.add(new SetCardInfo("Aura of Silence", 36030, Rarity.UNCOMMON, mage.cards.a.AuraOfSilence.class));
        cards.add(new SetCardInfo("Auramancer", 41644, Rarity.COMMON, mage.cards.a.Auramancer.class));
        cards.add(new SetCardInfo("Avacyn's Pilgrim", 45209, Rarity.COMMON, mage.cards.a.AvacynsPilgrim.class));
        cards.add(new SetCardInfo("Avacyn, Angel of Hope", 64436, Rarity.RARE, mage.cards.a.AvacynAngelOfHope.class));
        cards.add(new SetCardInfo("Avalanche Riders", 36134, Rarity.UNCOMMON, mage.cards.a.AvalancheRiders.class));
        cards.add(new SetCardInfo("Avalanche Tusker", 54514, Rarity.RARE, mage.cards.a.AvalancheTusker.class));
        cards.add(new SetCardInfo("Avatar of Discord", 32031, Rarity.RARE, mage.cards.a.AvatarOfDiscord.class));
        cards.add(new SetCardInfo("Avatar of Hope", 32206, Rarity.RARE, mage.cards.a.AvatarOfHope.class));
        cards.add(new SetCardInfo("Avatar of Woe", 36208, Rarity.RARE, mage.cards.a.AvatarOfWoe.class));
        cards.add(new SetCardInfo("Avenger of Zendikar", 58895, Rarity.MYTHIC, mage.cards.a.AvengerOfZendikar.class));
        cards.add(new SetCardInfo("Azorius Guildmage", 32585, Rarity.UNCOMMON, mage.cards.a.AzoriusGuildmage.class));
        cards.add(new SetCardInfo("Azorius Signet", 46906, Rarity.UNCOMMON, mage.cards.a.AzoriusSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azorius Signet", 62395, Rarity.COMMON, mage.cards.a.AzoriusSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azusa, Lost but Seeking", 62505, Rarity.RARE, mage.cards.a.AzusaLostButSeeking.class));
        cards.add(new SetCardInfo("Badlands", 43600, Rarity.RARE, mage.cards.b.Badlands.class));
        cards.add(new SetCardInfo("Balance", 36278, Rarity.RARE, mage.cards.b.Balance.class));
        cards.add(new SetCardInfo("Balduvian Horde", 35992, Rarity.RARE, mage.cards.b.BalduvianHorde.class));
        cards.add(new SetCardInfo("Ball Lightning", 35972, Rarity.RARE, mage.cards.b.BallLightning.class));
        cards.add(new SetCardInfo("Banisher Priest", 51908, Rarity.UNCOMMON, mage.cards.b.BanisherPriest.class));
        cards.add(new SetCardInfo("Banishing Light", 53840, Rarity.UNCOMMON, mage.cards.b.BanishingLight.class));
        cards.add(new SetCardInfo("Baron Sengir", 227, Rarity.RARE, mage.cards.b.BaronSengir.class));
        cards.add(new SetCardInfo("Barrage Tyrant", 58249, Rarity.RARE, mage.cards.b.BarrageTyrant.class));
        cards.add(new SetCardInfo("Basalt Monolith", 43602, Rarity.UNCOMMON, mage.cards.b.BasaltMonolith.class));
        cards.add(new SetCardInfo("Basking Rootwalla", 35152, Rarity.COMMON, mage.cards.b.BaskingRootwalla.class));
        cards.add(new SetCardInfo("Batterskull", 51930, Rarity.MYTHIC, mage.cards.b.Batterskull.class));
        cards.add(new SetCardInfo("Bayou", 43604, Rarity.RARE, mage.cards.b.Bayou.class));
        cards.add(new SetCardInfo("Beacon of Unrest", 62519, Rarity.RARE, mage.cards.b.BeaconOfUnrest.class));
        cards.add(new SetCardInfo("Beanstalk Giant", 78786, Rarity.UNCOMMON, mage.cards.b.BeanstalkGiant.class));
        cards.add(new SetCardInfo("Beast of Burden", 32198, Rarity.RARE, mage.cards.b.BeastOfBurden.class));
        cards.add(new SetCardInfo("Bident of Thassa", 50114, Rarity.RARE, mage.cards.b.BidentOfThassa.class));
        cards.add(new SetCardInfo("Bile Blight", 53838, Rarity.UNCOMMON, mage.cards.b.BileBlight.class));
        cards.add(new SetCardInfo("Birds of Paradise", 37598, Rarity.RARE, mage.cards.b.BirdsOfParadise.class));
        cards.add(new SetCardInfo("Bishop of Rebirth", 65662, Rarity.RARE, mage.cards.b.BishopOfRebirth.class));
        cards.add(new SetCardInfo("Bitterblossom", 39626, Rarity.RARE, mage.cards.b.Bitterblossom.class));
        cards.add(new SetCardInfo("Bituminous Blast", 36857, Rarity.UNCOMMON, mage.cards.b.BituminousBlast.class, FULL_ART));
        cards.add(new SetCardInfo("Black Knight", 35922, Rarity.UNCOMMON, mage.cards.b.BlackKnight.class));
        cards.add(new SetCardInfo("Black Lotus", 46932, Rarity.RARE, mage.cards.b.BlackLotus.class));
        cards.add(new SetCardInfo("Black Sun's Zenith", 39634, Rarity.RARE, mage.cards.b.BlackSunsZenith.class, FULL_ART));
        cards.add(new SetCardInfo("Blackblade Reforged", 77949, Rarity.RARE, mage.cards.b.BlackbladeReforged.class));
        cards.add(new SetCardInfo("Blasting Station", 62473, Rarity.UNCOMMON, mage.cards.b.BlastingStation.class));
        cards.add(new SetCardInfo("Blastoderm", 35134, Rarity.COMMON, mage.cards.b.Blastoderm.class));
        cards.add(new SetCardInfo("Blight Herder", 58265, Rarity.RARE, mage.cards.b.BlightHerder.class));
        cards.add(new SetCardInfo("Blighted Fen", 60464, Rarity.RARE, mage.cards.b.BlightedFen.class));
        cards.add(new SetCardInfo("Blightning", 35124, Rarity.COMMON, mage.cards.b.Blightning.class, FULL_ART));
        cards.add(new SetCardInfo("Blood Crypt", 72301, Rarity.RARE, mage.cards.b.BloodCrypt.class, FULL_ART));
        cards.add(new SetCardInfo("Blood Knight", 35984, Rarity.UNCOMMON, mage.cards.b.BloodKnight.class, FULL_ART));
        cards.add(new SetCardInfo("Bloodbraid Elf", 36867, Rarity.UNCOMMON, mage.cards.b.BloodbraidElf.class));
        cards.add(new SetCardInfo("Bloodcrazed Neonate", 42862, Rarity.COMMON, mage.cards.b.BloodcrazedNeonate.class));
        cards.add(new SetCardInfo("Bloodlord of Vaasgoth", 41638, Rarity.MYTHIC, mage.cards.b.BloodlordOfVaasgoth.class));
        cards.add(new SetCardInfo("Bloodstained Mire", 36254, Rarity.RARE, mage.cards.b.BloodstainedMire.class));
        cards.add(new SetCardInfo("Blue Elemental Blast", 35924, Rarity.UNCOMMON, mage.cards.b.BlueElementalBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blue Elemental Blast", 43606, Rarity.UNCOMMON, mage.cards.b.BlueElementalBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blue Elemental Blast", 70922, Rarity.RARE, mage.cards.b.BlueElementalBlast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boggart Ram-Gang", 31439, Rarity.UNCOMMON, mage.cards.b.BoggartRamGang.class));
        cards.add(new SetCardInfo("Bolas's Citadel", 72317, Rarity.RARE, mage.cards.b.BolassCitadel.class));
        cards.add(new SetCardInfo("Boltwing Marauder", 56998, Rarity.RARE, mage.cards.b.BoltwingMarauder.class));
        cards.add(new SetCardInfo("Bonecrusher Giant", 78810, Rarity.RARE, mage.cards.b.BonecrusherGiant.class));
        cards.add(new SetCardInfo("Bonesplitter", 36272, Rarity.COMMON, mage.cards.b.Bonesplitter.class));
        cards.add(new SetCardInfo("Boneyard Wurm", 42860, Rarity.UNCOMMON, mage.cards.b.BoneyardWurm.class));
        cards.add(new SetCardInfo("Boomerang", 36228, Rarity.COMMON, mage.cards.b.Boomerang.class));
        cards.add(new SetCardInfo("Boros Challenger", 69953, Rarity.UNCOMMON, mage.cards.b.BorosChallenger.class, FULL_ART));
        cards.add(new SetCardInfo("Boros Signet", 46904, Rarity.UNCOMMON, mage.cards.b.BorosSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boros Signet", 62393, Rarity.UNCOMMON, mage.cards.b.BorosSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bottle Gnomes", 36050, Rarity.UNCOMMON, mage.cards.b.BottleGnomes.class));
        cards.add(new SetCardInfo("Brain Maggot", 54551, Rarity.UNCOMMON, mage.cards.b.BrainMaggot.class));
        cards.add(new SetCardInfo("Braingeyser", 205, Rarity.RARE, mage.cards.b.Braingeyser.class));
        cards.add(new SetCardInfo("Brainstorm", 31453, Rarity.COMMON, mage.cards.b.Brainstorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brainstorm", 70920, Rarity.RARE, mage.cards.b.Brainstorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bramblewood Paragon", 31423, Rarity.UNCOMMON, mage.cards.b.BramblewoodParagon.class, FULL_ART));
        cards.add(new SetCardInfo("Brass's Bounty", 66886, Rarity.RARE, mage.cards.b.BrasssBounty.class));
        cards.add(new SetCardInfo("Brave the Elements", 37857, Rarity.UNCOMMON, mage.cards.b.BraveTheElements.class, FULL_ART));
        cards.add(new SetCardInfo("Brazen Borrower", 78826, Rarity.MYTHIC, mage.cards.b.BrazenBorrower.class));
        cards.add(new SetCardInfo("Breaking // Entering", 48586, Rarity.RARE, mage.cards.b.BreakingEntering.class));
        cards.add(new SetCardInfo("Breeding Pool", 72311, Rarity.RARE, mage.cards.b.BreedingPool.class, FULL_ART));
        cards.add(new SetCardInfo("Briber's Purse", 55781, Rarity.UNCOMMON, mage.cards.b.BribersPurse.class));
        cards.add(new SetCardInfo("Bribery", 46928, Rarity.RARE, mage.cards.b.Bribery.class));
        cards.add(new SetCardInfo("Brion Stoutarm", 36096, Rarity.RARE, mage.cards.b.BrionStoutarm.class));
        cards.add(new SetCardInfo("Broodmate Dragon", 36148, Rarity.RARE, mage.cards.b.BroodmateDragon.class));
        cards.add(new SetCardInfo("Browbeat", 36198, Rarity.UNCOMMON, mage.cards.b.Browbeat.class));
        cards.add(new SetCardInfo("Budoka Pupil", 36288, Rarity.UNCOMMON, mage.cards.b.BudokaPupil.class));
        cards.add(new SetCardInfo("Burgeoning", 62507, Rarity.RARE, mage.cards.b.Burgeoning.class));
        cards.add(new SetCardInfo("Burning Sun's Avatar", 65664, Rarity.RARE, mage.cards.b.BurningSunsAvatar.class));
        cards.add(new SetCardInfo("Burning Wish", 43542, Rarity.RARE, mage.cards.b.BurningWish.class));
        cards.add(new SetCardInfo("Burst Lightning", 37610, Rarity.COMMON, mage.cards.b.BurstLightning.class, FULL_ART));
        cards.add(new SetCardInfo("Cabal Coffers", 31471, Rarity.UNCOMMON, mage.cards.c.CabalCoffers.class));
        cards.add(new SetCardInfo("Cabal Therapy", 31473, Rarity.UNCOMMON, mage.cards.c.CabalTherapy.class));
        cards.add(new SetCardInfo("Calciderm", 35988, Rarity.UNCOMMON, mage.cards.c.Calciderm.class));
        cards.add(new SetCardInfo("Call of the Conclave", 48190, Rarity.UNCOMMON, mage.cards.c.CallOfTheConclave.class));
        cards.add(new SetCardInfo("Call of the Herd", 36108, Rarity.RARE, mage.cards.c.CallOfTheHerd.class));
        cards.add(new SetCardInfo("Call the Bloodline", 62213, Rarity.UNCOMMON, mage.cards.c.CallTheBloodline.class));
        cards.add(new SetCardInfo("Cancel", 36222, Rarity.COMMON, mage.cards.c.Cancel.class, FULL_ART));
        cards.add(new SetCardInfo("Candelabra of Tawnos", 62531, Rarity.RARE, mage.cards.c.CandelabraOfTawnos.class));
        cards.add(new SetCardInfo("Capsize", 36040, Rarity.COMMON, mage.cards.c.Capsize.class));
        cards.add(new SetCardInfo("Captain's Hook", 66884, Rarity.RARE, mage.cards.c.CaptainsHook.class));
        cards.add(new SetCardInfo("Capture of Jingzhou", 64420, Rarity.RARE, mage.cards.c.CaptureOfJingzhou.class));
        cards.add(new SetCardInfo("Carnival Hellsteed", 46885, Rarity.RARE, mage.cards.c.CarnivalHellsteed.class));
        cards.add(new SetCardInfo("Carnophage", 36100, Rarity.COMMON, mage.cards.c.Carnophage.class));
        cards.add(new SetCardInfo("Carrion Feeder", 36264, Rarity.COMMON, mage.cards.c.CarrionFeeder.class));
        cards.add(new SetCardInfo("Cast Down", 68049, Rarity.UNCOMMON, mage.cards.c.CastDown.class));
        cards.add(new SetCardInfo("Castigate", 35176, Rarity.COMMON, mage.cards.c.Castigate.class));
        cards.add(new SetCardInfo("Cathedral of War", 45215, Rarity.RARE, mage.cards.c.CathedralOfWar.class));
        cards.add(new SetCardInfo("Celestial Archon", 50128, Rarity.RARE, mage.cards.c.CelestialArchon.class));
        cards.add(new SetCardInfo("Celestial Colonnade", 43572, Rarity.RARE, mage.cards.c.CelestialColonnade.class));
        cards.add(new SetCardInfo("Celestial Purge", 36859, Rarity.UNCOMMON, mage.cards.c.CelestialPurge.class, FULL_ART));
        cards.add(new SetCardInfo("Cenn's Tactician", 32541, Rarity.UNCOMMON, mage.cards.c.CennsTactician.class));
        cards.add(new SetCardInfo("Chain of Vapor", 62513, Rarity.UNCOMMON, mage.cards.c.ChainOfVapor.class));
        cards.add(new SetCardInfo("Chainer's Edict", 36242, Rarity.UNCOMMON, mage.cards.c.ChainersEdict.class));
        cards.add(new SetCardInfo("Chains of Mephistopheles", 65646, Rarity.RARE, mage.cards.c.ChainsOfMephistopheles.class));
        cards.add(new SetCardInfo("Chalice of the Void", 69993, Rarity.RARE, mage.cards.c.ChaliceOfTheVoid.class));
        cards.add(new SetCardInfo("Chandra's Phoenix", 41646, Rarity.RARE, mage.cards.c.ChandrasPhoenix.class));
        cards.add(new SetCardInfo("Chandra, Fire Artisan", 72263, Rarity.RARE, mage.cards.c.ChandraFireArtisan.class));
        cards.add(new SetCardInfo("Chandra, Pyromaster", 65007, Rarity.MYTHIC, mage.cards.c.ChandraPyromaster.class));
        cards.add(new SetCardInfo("Chandra, Torch of Defiance", 70934, Rarity.MYTHIC, mage.cards.c.ChandraTorchOfDefiance.class));
        cards.add(new SetCardInfo("Char", 36142, Rarity.RARE, mage.cards.c.Char.class));
        cards.add(new SetCardInfo("Chief Engineer", 53824, Rarity.RARE, mage.cards.c.ChiefEngineer.class, FULL_ART));
        cards.add(new SetCardInfo("Chill", 36062, Rarity.UNCOMMON, mage.cards.c.Chill.class));
        cards.add(new SetCardInfo("Chittering Rats", 62445, Rarity.COMMON, mage.cards.c.ChitteringRats.class));
        cards.add(new SetCardInfo("Chrome Mox", 36160, Rarity.RARE, mage.cards.c.ChromeMox.class));
        cards.add(new SetCardInfo("Circle of Flame", 41648, Rarity.UNCOMMON, mage.cards.c.CircleOfFlame.class));
        cards.add(new SetCardInfo("Circle of Protection: Red", 31375, Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class));
        cards.add(new SetCardInfo("Circular Logic", 36244, Rarity.UNCOMMON, mage.cards.c.CircularLogic.class));
        cards.add(new SetCardInfo("City of Brass", 35952, Rarity.RARE, mage.cards.c.CityOfBrass.class));
        cards.add(new SetCardInfo("Clash of Wills", 59671, Rarity.UNCOMMON, mage.cards.c.ClashOfWills.class));
        cards.add(new SetCardInfo("Cloudpost", 36869, Rarity.COMMON, mage.cards.c.Cloudpost.class));
        cards.add(new SetCardInfo("Coiling Oracle", 32587, Rarity.COMMON, mage.cards.c.CoilingOracle.class));
        cards.add(new SetCardInfo("Colossal Whale", 49834, Rarity.RARE, mage.cards.c.ColossalWhale.class));
        cards.add(new SetCardInfo("Comet Storm", 35822, Rarity.MYTHIC, mage.cards.c.CometStorm.class));
        cards.add(new SetCardInfo("Command Tower", 47979, Rarity.COMMON, mage.cards.c.CommandTower.class));
        cards.add(new SetCardInfo("Conclave Naturalists", 57596, Rarity.UNCOMMON, mage.cards.c.ConclaveNaturalists.class, FULL_ART));
        cards.add(new SetCardInfo("Condemn", 31385, Rarity.UNCOMMON, mage.cards.c.Condemn.class, FULL_ART));
        cards.add(new SetCardInfo("Consume the Meek", 62491, Rarity.RARE, mage.cards.c.ConsumeTheMeek.class));
        cards.add(new SetCardInfo("Consuming Aberration", 47997, Rarity.RARE, mage.cards.c.ConsumingAberration.class));
        cards.add(new SetCardInfo("Contagion Clasp", 42258, Rarity.UNCOMMON, mage.cards.c.ContagionClasp.class));
        cards.add(new SetCardInfo("Contagion", 62485, Rarity.RARE, mage.cards.c.Contagion.class));
        cards.add(new SetCardInfo("Control Magic", 43594, Rarity.RARE, mage.cards.c.ControlMagic.class));
        cards.add(new SetCardInfo("Copy Artifact", 65650, Rarity.RARE, mage.cards.c.CopyArtifact.class));
        cards.add(new SetCardInfo("Corpsejack Menace", 46887, Rarity.RARE, mage.cards.c.CorpsejackMenace.class));
        cards.add(new SetCardInfo("Corrupt", 35120, Rarity.UNCOMMON, mage.cards.c.Corrupt.class, FULL_ART));
        cards.add(new SetCardInfo("Counterspell", 31377, Rarity.UNCOMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Counterspell", 36323, Rarity.COMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Courser of Kruphix", 55735, Rarity.RARE, mage.cards.c.CourserOfKruphix.class));
        cards.add(new SetCardInfo("Creeping Mold", 32525, Rarity.UNCOMMON, mage.cards.c.CreepingMold.class));
        cards.add(new SetCardInfo("Crop Rotation", 62521, Rarity.COMMON, mage.cards.c.CropRotation.class));
        cards.add(new SetCardInfo("Crucible of Worlds", 49846, Rarity.RARE, mage.cards.c.CrucibleOfWorlds.class));
        cards.add(new SetCardInfo("Cruel Edict", 35062, Rarity.RARE, mage.cards.c.CruelEdict.class, FULL_ART));
        cards.add(new SetCardInfo("Crumbling Vestige", 61565, Rarity.COMMON, mage.cards.c.CrumblingVestige.class));
        cards.add(new SetCardInfo("Crusade", 35926, Rarity.RARE, mage.cards.c.Crusade.class));
        cards.add(new SetCardInfo("Cryptborn Horror", 46883, Rarity.RARE, mage.cards.c.CryptbornHorror.class, FULL_ART));
        cards.add(new SetCardInfo("Cryptic Command", 31447, Rarity.RARE, mage.cards.c.CrypticCommand.class, FULL_ART));
        cards.add(new SetCardInfo("Crystalline Sliver", 36070, Rarity.UNCOMMON, mage.cards.c.CrystallineSliver.class));
        cards.add(new SetCardInfo("Cultivate", 41640, Rarity.COMMON, mage.cards.c.Cultivate.class));
        cards.add(new SetCardInfo("Cultivator of Blades", 62219, Rarity.RARE, mage.cards.c.CultivatorOfBlades.class, FULL_ART));
        cards.add(new SetCardInfo("Cunning Wish", 31393, Rarity.RARE, mage.cards.c.CunningWish.class));
        cards.add(new SetCardInfo("Cuombajj Witches", 65652, Rarity.COMMON, mage.cards.c.CuombajjWitches.class));
        cards.add(new SetCardInfo("Curious Pair", 78754, Rarity.COMMON, mage.cards.c.CuriousPair.class));
        cards.add(new SetCardInfo("Curse of the Bloody Tome", 42870, Rarity.COMMON, mage.cards.c.CurseOfTheBloodyTome.class));
        cards.add(new SetCardInfo("Curse of Thirst", 43499, Rarity.UNCOMMON, mage.cards.c.CurseOfThirst.class));
        cards.add(new SetCardInfo("Curse of Wizardry", 36863, Rarity.UNCOMMON, mage.cards.c.CurseOfWizardry.class));
        cards.add(new SetCardInfo("Damnation", 31417, Rarity.RARE, mage.cards.d.Damnation.class, FULL_ART));
        cards.add(new SetCardInfo("Damnation", 55862, Rarity.RARE, mage.cards.d.Damnation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dark Ritual", 36168, Rarity.COMMON, mage.cards.d.DarkRitual.class));
        cards.add(new SetCardInfo("Darksteel Ingot", 36276, Rarity.COMMON, mage.cards.d.DarksteelIngot.class));
        cards.add(new SetCardInfo("Darksteel Relic", 41108, Rarity.UNCOMMON, mage.cards.d.DarksteelRelic.class));
        cards.add(new SetCardInfo("Dauntless Dourbark", 36098, Rarity.RARE, mage.cards.d.DauntlessDourbark.class));
        cards.add(new SetCardInfo("Dauthi Slayer", 36032, Rarity.COMMON, mage.cards.d.DauthiSlayer.class));
        cards.add(new SetCardInfo("Davriel, Rogue Shadowmage", 72271, Rarity.UNCOMMON, mage.cards.d.DavrielRogueShadowmage.class));
        cards.add(new SetCardInfo("Dawnbringer Charioteers", 52332, Rarity.RARE, mage.cards.d.DawnbringerCharioteers.class));
        cards.add(new SetCardInfo("Day of Judgment", 36220, Rarity.RARE, mage.cards.d.DayOfJudgment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Day of Judgment", 37873, Rarity.RARE, mage.cards.d.DayOfJudgment.class, FULL_ART));
        cards.add(new SetCardInfo("Deadbridge Goliath", 46875, Rarity.RARE, mage.cards.d.DeadbridgeGoliath.class));
        cards.add(new SetCardInfo("Death Baron", 69254, Rarity.RARE, mage.cards.d.DeathBaron.class, FULL_ART));
        cards.add(new SetCardInfo("Deathbringer Regent", 55894, Rarity.RARE, mage.cards.d.DeathbringerRegent.class));
        cards.add(new SetCardInfo("Deathless Angel", 36853, Rarity.RARE, mage.cards.d.DeathlessAngel.class, FULL_ART));
        cards.add(new SetCardInfo("Debilitating Injury", 55765, Rarity.COMMON, mage.cards.d.DebilitatingInjury.class));
        cards.add(new SetCardInfo("Decimate", 62459, Rarity.RARE, mage.cards.d.Decimate.class));
        cards.add(new SetCardInfo("Decree of Justice", 31399, Rarity.RARE, mage.cards.d.DecreeOfJustice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Decree of Justice", 59645, Rarity.RARE, mage.cards.d.DecreeOfJustice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Decree of Pain", 47985, Rarity.RARE, mage.cards.d.DecreeOfPain.class));
        cards.add(new SetCardInfo("Deep Analysis", 35150, Rarity.COMMON, mage.cards.d.DeepAnalysis.class));
        cards.add(new SetCardInfo("Deepfathom Skulker", 59663, Rarity.RARE, mage.cards.d.DeepfathomSkulker.class));
        cards.add(new SetCardInfo("Defiant Bloodlord", 58247, Rarity.RARE, mage.cards.d.DefiantBloodlord.class));
        cards.add(new SetCardInfo("Demigod of Revenge", 31437, Rarity.RARE, mage.cards.d.DemigodOfRevenge.class));
        cards.add(new SetCardInfo("Demon of Catastrophes", 69246, Rarity.RARE, mage.cards.d.DemonOfCatastrophes.class, FULL_ART));
        cards.add(new SetCardInfo("Demonic Tutor", 35074, Rarity.UNCOMMON, mage.cards.d.DemonicTutor.class));
        cards.add(new SetCardInfo("Deranged Hermit", 36132, Rarity.RARE, mage.cards.d.DerangedHermit.class));
        cards.add(new SetCardInfo("Desecrated Tomb", 69244, Rarity.RARE, mage.cards.d.DesecratedTomb.class));
        cards.add(new SetCardInfo("Desert", 35148, Rarity.RARE, mage.cards.d.Desert.class));
        cards.add(new SetCardInfo("Desertion", 47967, Rarity.RARE, mage.cards.d.Desertion.class));
        cards.add(new SetCardInfo("Despise", 43065, Rarity.UNCOMMON, mage.cards.d.Despise.class));
        cards.add(new SetCardInfo("Devil's Play", 42868, Rarity.RARE, mage.cards.d.DevilsPlay.class));
        cards.add(new SetCardInfo("Diabolic Edict", 32527, Rarity.COMMON, mage.cards.d.DiabolicEdict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Diabolic Edict", 62413, Rarity.COMMON, mage.cards.d.DiabolicEdict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Diaochan, Artful Beauty", 47971, Rarity.RARE, mage.cards.d.DiaochanArtfulBeauty.class));
        cards.add(new SetCardInfo("Dictate of Kruphix", 52326, Rarity.RARE, mage.cards.d.DictateOfKruphix.class, FULL_ART));
        cards.add(new SetCardInfo("Dictate of the Twin Gods", 52334, Rarity.RARE, mage.cards.d.DictateOfTheTwinGods.class));
        cards.add(new SetCardInfo("Dimir Charm", 49840, Rarity.UNCOMMON, mage.cards.d.DimirCharm.class));
        cards.add(new SetCardInfo("Dimir Guildmage", 32579, Rarity.UNCOMMON, mage.cards.d.DimirGuildmage.class));
        cards.add(new SetCardInfo("Dimir Signet", 46924, Rarity.UNCOMMON, mage.cards.d.DimirSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dimir Signet", 62435, Rarity.COMMON, mage.cards.d.DimirSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Diregraf Ghoul", 42882, Rarity.UNCOMMON, mage.cards.d.DiregrafGhoul.class, FULL_ART));
        cards.add(new SetCardInfo("Dirtcowl Wurm", 32190, Rarity.RARE, mage.cards.d.DirtcowlWurm.class));
        cards.add(new SetCardInfo("Disdainful Stroke", 55785, Rarity.COMMON, mage.cards.d.DisdainfulStroke.class));
        cards.add(new SetCardInfo("Disenchant", 31397, Rarity.COMMON, mage.cards.d.Disenchant.class, FULL_ART));
        cards.add(new SetCardInfo("Disenchant", 36184, Rarity.COMMON, mage.cards.d.Disenchant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disintegrate", 62429, Rarity.UNCOMMON, mage.cards.d.Disintegrate.class));
        cards.add(new SetCardInfo("Dismember", 43588, Rarity.UNCOMMON, mage.cards.d.Dismember.class));
        cards.add(new SetCardInfo("Dismiss", 36060, Rarity.UNCOMMON, mage.cards.d.Dismiss.class));
        cards.add(new SetCardInfo("Dissipate", 35996, Rarity.UNCOMMON, mage.cards.d.Dissipate.class));
        cards.add(new SetCardInfo("Dissolve", 52336, Rarity.UNCOMMON, mage.cards.d.Dissolve.class));
        cards.add(new SetCardInfo("Djinn Illuminatus", 32029, Rarity.RARE, mage.cards.d.DjinnIlluminatus.class));
        cards.add(new SetCardInfo("Domri, Anarch of Bolas", 72225, Rarity.RARE, mage.cards.d.DomriAnarchOfBolas.class));
        cards.add(new SetCardInfo("Doom Blade", 37855, Rarity.COMMON, mage.cards.d.DoomBlade.class, FULL_ART));
        cards.add(new SetCardInfo("Doom Blade", 62525, Rarity.UNCOMMON, mage.cards.d.DoomBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doomsday", 61058, Rarity.RARE, mage.cards.d.Doomsday.class));
        cards.add(new SetCardInfo("Doomwake Giant", 52322, Rarity.RARE, mage.cards.d.DoomwakeGiant.class));
        cards.add(new SetCardInfo("Door of Destinies", 31963, Rarity.RARE, mage.cards.d.DoorOfDestinies.class));
        cards.add(new SetCardInfo("Doran, the Siege Tower", 31411, Rarity.RARE, mage.cards.d.DoranTheSiegeTower.class, FULL_ART));
        cards.add(new SetCardInfo("Doran, the Siege Tower", 65658, Rarity.MYTHIC, mage.cards.d.DoranTheSiegeTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dovin, Hand of Control", 72227, Rarity.UNCOMMON, mage.cards.d.DovinHandOfControl.class));
        cards.add(new SetCardInfo("Dragon Broodmother", 32553, Rarity.MYTHIC, mage.cards.d.DragonBroodmother.class));
        cards.add(new SetCardInfo("Dragon Fodder", 55898, Rarity.COMMON, mage.cards.d.DragonFodder.class));
        cards.add(new SetCardInfo("Dragon Throne of Tarkir", 54565, Rarity.RARE, mage.cards.d.DragonThroneOfTarkir.class));
        cards.add(new SetCardInfo("Dragonlord's Servant", 55884, Rarity.UNCOMMON, mage.cards.d.DragonlordsServant.class));
        cards.add(new SetCardInfo("Dragonscale Boon", 55793, Rarity.COMMON, mage.cards.d.DragonscaleBoon.class));
        cards.add(new SetCardInfo("Dragonscale General", 55707, Rarity.RARE, mage.cards.d.DragonscaleGeneral.class));
        cards.add(new SetCardInfo("Drain Life", 35928, Rarity.COMMON, mage.cards.d.DrainLife.class));
        cards.add(new SetCardInfo("Dread Defiler", 59665, Rarity.RARE, mage.cards.d.DreadDefiler.class));
        cards.add(new SetCardInfo("Dread Return", 60482, Rarity.UNCOMMON, mage.cards.d.DreadReturn.class));
        cards.add(new SetCardInfo("Drogskol Cavalry", 60466, Rarity.RARE, mage.cards.d.DrogskolCavalry.class));
        cards.add(new SetCardInfo("Dromoka, the Eternal", 57604, Rarity.RARE, mage.cards.d.DromokaTheEternal.class));
        cards.add(new SetCardInfo("Drowner of Hope", 58245, Rarity.RARE, mage.cards.d.DrownerOfHope.class));
        cards.add(new SetCardInfo("Dryad Militant", 46267, Rarity.UNCOMMON, mage.cards.d.DryadMilitant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dryad Militant", 46873, Rarity.UNCOMMON, mage.cards.d.DryadMilitant.class, FULL_ART));
        cards.add(new SetCardInfo("Dualcaster Mage", 55868, Rarity.RARE, mage.cards.d.DualcasterMage.class));
        cards.add(new SetCardInfo("Duergar Hedge-Mage", 32547, Rarity.UNCOMMON, mage.cards.d.DuergarHedgeMage.class));
        cards.add(new SetCardInfo("Dungrove Elder", 41650, Rarity.RARE, mage.cards.d.DungroveElder.class, FULL_ART));
        cards.add(new SetCardInfo("Duplicant", 47983, Rarity.RARE, mage.cards.d.Duplicant.class));
        cards.add(new SetCardInfo("Duress", 35078, Rarity.COMMON, mage.cards.d.Duress.class));
        cards.add(new SetCardInfo("Dwynen, Gilt-Leaf Daen", 57600, Rarity.RARE, mage.cards.d.DwynenGiltLeafDaen.class));
        cards.add(new SetCardInfo("Earwig Squad", 32539, Rarity.RARE, mage.cards.e.EarwigSquad.class));
        cards.add(new SetCardInfo("Eater of Hope", 51918, Rarity.RARE, mage.cards.e.EaterOfHope.class));
        cards.add(new SetCardInfo("Eidolon of Blossoms", 52318, Rarity.RARE, mage.cards.e.EidolonOfBlossoms.class));
        cards.add(new SetCardInfo("Electrolyze", 32581, Rarity.UNCOMMON, mage.cards.e.Electrolyze.class, FULL_ART));
        cards.add(new SetCardInfo("Elesh Norn, Grand Cenobite", 52306, Rarity.MYTHIC, mage.cards.e.EleshNornGrandCenobite.class));
        cards.add(new SetCardInfo("Elite Inquisitor", 42880, Rarity.RARE, mage.cards.e.EliteInquisitor.class, FULL_ART));
        cards.add(new SetCardInfo("Elspeth, Sun's Champion", 59647, Rarity.MYTHIC, mage.cards.e.ElspethSunsChampion.class));
        cards.add(new SetCardInfo("Elusive Tormentor", 60472, Rarity.RARE, mage.cards.e.ElusiveTormentor.class));
        cards.add(new SetCardInfo("Elves of Deep Shadow", 35974, Rarity.UNCOMMON, mage.cards.e.ElvesOfDeepShadow.class));
        cards.add(new SetCardInfo("Elvish Aberration", 36266, Rarity.UNCOMMON, mage.cards.e.ElvishAberration.class));
        cards.add(new SetCardInfo("Elvish Champion", 31435, Rarity.RARE, mage.cards.e.ElvishChampion.class));
        cards.add(new SetCardInfo("Elvish Lyrist", 36118, Rarity.COMMON, mage.cards.e.ElvishLyrist.class));
        cards.add(new SetCardInfo("Elvish Mystic", 51538, Rarity.COMMON, mage.cards.e.ElvishMystic.class));
        cards.add(new SetCardInfo("Elvish Pioneer", 62481, Rarity.COMMON, mage.cards.e.ElvishPioneer.class));
        cards.add(new SetCardInfo("Elvish Rejuvenator", 69258, Rarity.COMMON, mage.cards.e.ElvishRejuvenator.class));
        cards.add(new SetCardInfo("Elvish Spirit Guide", 65654, Rarity.UNCOMMON, mage.cards.e.ElvishSpiritGuide.class));
        cards.add(new SetCardInfo("Elvish Visionary", 36865, Rarity.COMMON, mage.cards.e.ElvishVisionary.class));
        cards.add(new SetCardInfo("Ember Swallower", 50130, Rarity.RARE, mage.cards.e.EmberSwallower.class));
        cards.add(new SetCardInfo("Embereth Shieldbreaker", 78774, Rarity.UNCOMMON, mage.cards.e.EmberethShieldbreaker.class));
        cards.add(new SetCardInfo("Emeria Angel", 36218, Rarity.RARE, mage.cards.e.EmeriaAngel.class, FULL_ART));
        cards.add(new SetCardInfo("Emmara, Soul of the Accord", 69951, Rarity.RARE, mage.cards.e.EmmaraSoulOfTheAccord.class, FULL_ART));
        cards.add(new SetCardInfo("Empyrial Armor", 36024, Rarity.COMMON, mage.cards.e.EmpyrialArmor.class));
        cards.add(new SetCardInfo("Emrakul, the Aeons Torn", 36873, Rarity.MYTHIC, mage.cards.e.EmrakulTheAeonsTorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emrakul, the Aeons Torn", 63001, Rarity.MYTHIC, mage.cards.e.EmrakulTheAeonsTorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Encroaching Wastes", 51932, Rarity.UNCOMMON, mage.cards.e.EncroachingWastes.class));
        cards.add(new SetCardInfo("Endbringer", 59667, Rarity.RARE, mage.cards.e.Endbringer.class));
        cards.add(new SetCardInfo("Engineered Plague", 32543, Rarity.UNCOMMON, mage.cards.e.EngineeredPlague.class));
        cards.add(new SetCardInfo("Enlightened Tutor", 35998, Rarity.UNCOMMON, mage.cards.e.EnlightenedTutor.class));
        cards.add(new SetCardInfo("Entomb", 51532, Rarity.RARE, mage.cards.e.Entomb.class));
        cards.add(new SetCardInfo("Epic Struggle", 62447, Rarity.RARE, mage.cards.e.EpicStruggle.class));
        cards.add(new SetCardInfo("Erratic Portal", 62421, Rarity.RARE, mage.cards.e.ErraticPortal.class));
        cards.add(new SetCardInfo("Essence Extraction", 62211, Rarity.UNCOMMON, mage.cards.e.EssenceExtraction.class, FULL_ART));
        cards.add(new SetCardInfo("Eternal Dragon", 31387, Rarity.RARE, mage.cards.e.EternalDragon.class));
        cards.add(new SetCardInfo("Eternal Witness", 31431, Rarity.UNCOMMON, mage.cards.e.EternalWitness.class));
        cards.add(new SetCardInfo("Eureka", 46946, Rarity.RARE, mage.cards.e.Eureka.class));
        cards.add(new SetCardInfo("Everflowing Chalice", 39620, Rarity.UNCOMMON, mage.cards.e.EverflowingChalice.class));
        cards.add(new SetCardInfo("Evolving Wilds", 46265, Rarity.COMMON, mage.cards.e.EvolvingWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evolving Wilds", 55880, Rarity.COMMON, mage.cards.e.EvolvingWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Exalted Angel", 31491, Rarity.RARE, mage.cards.e.ExaltedAngel.class));
        cards.add(new SetCardInfo("Exclude", 62477, Rarity.COMMON, mage.cards.e.Exclude.class));
        cards.add(new SetCardInfo("Experiment One", 49838, Rarity.UNCOMMON, mage.cards.e.ExperimentOne.class));
        cards.add(new SetCardInfo("Exploration", 62463, Rarity.RARE, mage.cards.e.Exploration.class));
        cards.add(new SetCardInfo("Explore", 59643, Rarity.COMMON, mage.cards.e.Explore.class));
        cards.add(new SetCardInfo("Exquisite Firecraft", 62503, Rarity.RARE, mage.cards.e.ExquisiteFirecraft.class));
        cards.add(new SetCardInfo("Fact or Fiction", 31457, Rarity.UNCOMMON, mage.cards.f.FactOrFiction.class));
        cards.add(new SetCardInfo("Fae of Wishes", 78734, Rarity.RARE, mage.cards.f.FaeOfWishes.class));
        cards.add(new SetCardInfo("Faerie Conclave", 36090, Rarity.UNCOMMON, mage.cards.f.FaerieConclave.class));
        cards.add(new SetCardInfo("Faerie Guidemother", 78850, Rarity.COMMON, mage.cards.f.FaerieGuidemother.class));
        cards.add(new SetCardInfo("False Prophet", 32200, Rarity.RARE, mage.cards.f.FalseProphet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("False Prophet", 62469, Rarity.RARE, mage.cards.f.FalseProphet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fanatic of Xenagos", 54559, Rarity.UNCOMMON, mage.cards.f.FanaticOfXenagos.class));
        cards.add(new SetCardInfo("Farseek", 48005, Rarity.COMMON, mage.cards.f.Farseek.class));
        cards.add(new SetCardInfo("Fatal Push", 64997, Rarity.UNCOMMON, mage.cards.f.FatalPush.class));
        cards.add(new SetCardInfo("Fated Conflagration", 51922, Rarity.RARE, mage.cards.f.FatedConflagration.class));
        cards.add(new SetCardInfo("Fated Intervention", 53818, Rarity.RARE, mage.cards.f.FatedIntervention.class));
        cards.add(new SetCardInfo("Fathom Mage", 48001, Rarity.RARE, mage.cards.f.FathomMage.class));
        cards.add(new SetCardInfo("Feldon of the Third Path", 55872, Rarity.MYTHIC, mage.cards.f.FeldonOfTheThirdPath.class));
        cards.add(new SetCardInfo("Feral Throwback", 36256, Rarity.RARE, mage.cards.f.FeralThrowback.class));
        cards.add(new SetCardInfo("Fierce Invocation", 55743, Rarity.COMMON, mage.cards.f.FierceInvocation.class));
        cards.add(new SetCardInfo("Fiery Temper", 35978, Rarity.COMMON, mage.cards.f.FieryTemper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Temper", 62217, Rarity.RARE, mage.cards.f.FieryTemper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Figure of Destiny", 32545, Rarity.RARE, mage.cards.f.FigureOfDestiny.class));
        cards.add(new SetCardInfo("Fire // Ice", 31497, Rarity.UNCOMMON, mage.cards.f.FireIce.class));
        cards.add(new SetCardInfo("Fire-Lit Thicket", 62457, Rarity.RARE, mage.cards.f.FireLitThicket.class));
        cards.add(new SetCardInfo("Fireball", 31485, Rarity.UNCOMMON, mage.cards.f.Fireball.class, FULL_ART));
        cards.add(new SetCardInfo("Fireball", 36321, Rarity.UNCOMMON, mage.cards.f.Fireball.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fireblast", 31401, Rarity.COMMON, mage.cards.f.Fireblast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fireblast", 43598, Rarity.COMMON, mage.cards.f.Fireblast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firebolt", 31469, Rarity.COMMON, mage.cards.f.Firebolt.class));
        cards.add(new SetCardInfo("Firemane Avenger", 47991, Rarity.RARE, mage.cards.f.FiremaneAvenger.class, FULL_ART));
        cards.add(new SetCardInfo("Firemind's Research", 69949, Rarity.RARE, mage.cards.f.FiremindsResearch.class));
        cards.add(new SetCardInfo("Fireslinger", 36038, Rarity.COMMON, mage.cards.f.Fireslinger.class));
        cards.add(new SetCardInfo("Flame Javelin", 35122, Rarity.UNCOMMON, mage.cards.f.FlameJavelin.class, FULL_ART));
        cards.add(new SetCardInfo("Flameblade Angel", 60454, Rarity.RARE, mage.cards.f.FlamebladeAngel.class));
        cards.add(new SetCardInfo("Flamerush Rider", 55713, Rarity.RARE, mage.cards.f.FlamerushRider.class));
        cards.add(new SetCardInfo("Flametongue Kavu", 31459, Rarity.UNCOMMON, mage.cards.f.FlametongueKavu.class));
        cards.add(new SetCardInfo("Flaxen Intruder", 78814, Rarity.UNCOMMON, mage.cards.f.FlaxenIntruder.class));
        cards.add(new SetCardInfo("Flaying Tendrils", 61561, Rarity.UNCOMMON, mage.cards.f.FlayingTendrils.class));
        cards.add(new SetCardInfo("Fling", 36074, Rarity.COMMON, mage.cards.f.Fling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fling", 36076, Rarity.COMMON, mage.cards.f.Fling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fling", 37590, Rarity.COMMON, mage.cards.f.Fling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flooded Strand", 43580, Rarity.RARE, mage.cards.f.FloodedStrand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flooded Strand", 69252, Rarity.RARE, mage.cards.f.FloodedStrand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flusterstorm", 69985, Rarity.RARE, mage.cards.f.Flusterstorm.class));
        cards.add(new SetCardInfo("Foe-Razer Regent", 55890, Rarity.RARE, mage.cards.f.FoeRazerRegent.class));
        cards.add(new SetCardInfo("Font of Fertility", 53848, Rarity.COMMON, mage.cards.f.FontOfFertility.class));
        cards.add(new SetCardInfo("Food Chain", 69947, Rarity.RARE, mage.cards.f.FoodChain.class));
        cards.add(new SetCardInfo("Forbid", 36078, Rarity.UNCOMMON, mage.cards.f.Forbid.class));
        cards.add(new SetCardInfo("Forbidden Alchemy", 45203, Rarity.COMMON, mage.cards.f.ForbiddenAlchemy.class));
        cards.add(new SetCardInfo("Forbidden Orchard", 62409, Rarity.RARE, mage.cards.f.ForbiddenOrchard.class));
        cards.add(new SetCardInfo("Force of Nature", 36294, Rarity.RARE, mage.cards.f.ForceOfNature.class));
        cards.add(new SetCardInfo("Force of Will", 43578, Rarity.RARE, mage.cards.f.ForceOfWill.class));
        cards.add(new SetCardInfo("Force Spike", 31395, Rarity.UNCOMMON, mage.cards.f.ForceSpike.class));
        cards.add(new SetCardInfo("Forest", 237, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 251, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 259, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 269, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 279, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 293, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 297, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 31983, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 31991, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 32005, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 32027, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 40040, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 40050, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 40060, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 40094, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 53875, Rarity.LAND, mage.cards.basiclands.Forest.class, FULL_ART));
        cards.add(new SetCardInfo("Forest", 58261, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 73628, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forgestoker Dragon", 51920, Rarity.RARE, mage.cards.f.ForgestokerDragon.class));
        cards.add(new SetCardInfo("Fork", 207, Rarity.RARE, mage.cards.f.Fork.class));
        cards.add(new SetCardInfo("Forked Lightning", 33440, Rarity.UNCOMMON, mage.cards.f.ForkedLightning.class));
        cards.add(new SetCardInfo("Formless Nurturing", 55747, Rarity.COMMON, mage.cards.f.FormlessNurturing.class));
        cards.add(new SetCardInfo("Fortune's Favor", 62987, Rarity.UNCOMMON, mage.cards.f.FortunesFavor.class));
        cards.add(new SetCardInfo("Foulmire Knight", 78806, Rarity.UNCOMMON, mage.cards.f.FoulmireKnight.class));
        cards.add(new SetCardInfo("Foundry Champion", 47993, Rarity.RARE, mage.cards.f.FoundryChampion.class));
        cards.add(new SetCardInfo("Frenzied Goblin", 55703, Rarity.UNCOMMON, mage.cards.f.FrenziedGoblin.class));
        cards.add(new SetCardInfo("Frost Walker", 55886, Rarity.UNCOMMON, mage.cards.f.FrostWalker.class));
        cards.add(new SetCardInfo("Fungal Shambler", 36236, Rarity.RARE, mage.cards.f.FungalShambler.class));
        cards.add(new SetCardInfo("Future Sight", 43596, Rarity.RARE, mage.cards.f.FutureSight.class));
        cards.add(new SetCardInfo("Fyndhorn Elves", 43632, Rarity.COMMON, mage.cards.f.FyndhornElves.class));
        cards.add(new SetCardInfo("Gaddock Teeg", 64418, Rarity.RARE, mage.cards.g.GaddockTeeg.class));
        cards.add(new SetCardInfo("Gaea's Blessing", 36026, Rarity.UNCOMMON, mage.cards.g.GaeasBlessing.class));
        cards.add(new SetCardInfo("Gaea's Cradle", 36112, Rarity.RARE, mage.cards.g.GaeasCradle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gaea's Cradle", 59655, Rarity.MYTHIC, mage.cards.g.GaeasCradle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Garenbrig Carver", 78782, Rarity.COMMON, mage.cards.g.GarenbrigCarver.class));
        cards.add(new SetCardInfo("Garruk Wildspeaker", 36178, Rarity.MYTHIC, mage.cards.g.GarrukWildspeaker.class));
        cards.add(new SetCardInfo("Garruk's Horde", 41636, Rarity.RARE, mage.cards.g.GarruksHorde.class));
        cards.add(new SetCardInfo("Garruk, Cursed Huntsman", 78856, Rarity.MYTHIC, mage.cards.g.GarrukCursedHuntsman.class));
        cards.add(new SetCardInfo("Gate Colossus", 71592, Rarity.UNCOMMON, mage.cards.g.GateColossus.class));
        cards.add(new SetCardInfo("Gatekeeper of Malakir", 37853, Rarity.UNCOMMON, mage.cards.g.GatekeeperOfMalakir.class));
        cards.add(new SetCardInfo("Gather the Townsfolk", 43511, Rarity.COMMON, mage.cards.g.GatherTheTownsfolk.class));
        cards.add(new SetCardInfo("Gauntlet of Might", 65656, Rarity.RARE, mage.cards.g.GauntletOfMight.class));
        cards.add(new SetCardInfo("Geist of Saint Traft", 51928, Rarity.MYTHIC, mage.cards.g.GeistOfSaintTraft.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Geist of Saint Traft", 60484, Rarity.MYTHIC, mage.cards.g.GeistOfSaintTraft.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gemstone Mine", 36028, Rarity.UNCOMMON, mage.cards.g.GemstoneMine.class));
        cards.add(new SetCardInfo("Genesis Hydra", 55870, Rarity.RARE, mage.cards.g.GenesisHydra.class));
        cards.add(new SetCardInfo("Genju of the Spires", 36284, Rarity.UNCOMMON, mage.cards.g.GenjuOfTheSpires.class));
        cards.add(new SetCardInfo("Gerrard's Verdict", 31461, Rarity.UNCOMMON, mage.cards.g.GerrardsVerdict.class));
        cards.add(new SetCardInfo("Ghalta, Primal Hunger", 66896, Rarity.RARE, mage.cards.g.GhaltaPrimalHunger.class));
        cards.add(new SetCardInfo("Ghor-Clan Rampager", 50110, Rarity.UNCOMMON, mage.cards.g.GhorClanRampager.class));
        cards.add(new SetCardInfo("Ghost-Lit Raider", 36292, Rarity.UNCOMMON, mage.cards.g.GhostLitRaider.class));
        cards.add(new SetCardInfo("Ghostfire Blade", 55777, Rarity.RARE, mage.cards.g.GhostfireBlade.class));
        cards.add(new SetCardInfo("Ghostly Prison", 43538, Rarity.UNCOMMON, mage.cards.g.GhostlyPrison.class));
        cards.add(new SetCardInfo("Giant Badger", 35960, Rarity.RARE, mage.cards.g.GiantBadger.class));
        cards.add(new SetCardInfo("Giant Growth", 32557, Rarity.COMMON, mage.cards.g.GiantGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giant Growth", 35824, Rarity.COMMON, mage.cards.g.GiantGrowth.class, FULL_ART));
        cards.add(new SetCardInfo("Giant Growth", 35930, Rarity.COMMON, mage.cards.g.GiantGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Giant Killer", 78794, Rarity.RARE, mage.cards.g.GiantKiller.class));
        cards.add(new SetCardInfo("Gideon Blackblade", 72285, Rarity.MYTHIC, mage.cards.g.GideonBlackblade.class));
        cards.add(new SetCardInfo("Gideon Jura", 65003, Rarity.MYTHIC, mage.cards.g.GideonJura.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gideon Jura", 77947, Rarity.MYTHIC, mage.cards.g.GideonJura.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gideon of the Trials", 70940, Rarity.MYTHIC, mage.cards.g.GideonOfTheTrials.class));
        cards.add(new SetCardInfo("Gifts Ungiven", 70924, Rarity.RARE, mage.cards.g.GiftsUngiven.class));
        cards.add(new SetCardInfo("Gitaxian Probe", 46869, Rarity.COMMON, mage.cards.g.GitaxianProbe.class));
        cards.add(new SetCardInfo("Glacial Ray", 36286, Rarity.COMMON, mage.cards.g.GlacialRay.class));
        cards.add(new SetCardInfo("Gladehart Cavalry", 59661, Rarity.RARE, mage.cards.g.GladehartCavalry.class));
        cards.add(new SetCardInfo("Gleancrawler", 32017, Rarity.RARE, mage.cards.g.Gleancrawler.class));
        cards.add(new SetCardInfo("Glissa, the Traitor", 39618, Rarity.MYTHIC, mage.cards.g.GlissaTheTraitor.class));
        cards.add(new SetCardInfo("Glistener Elf", 43067, Rarity.COMMON, mage.cards.g.GlistenerElf.class));
        cards.add(new SetCardInfo("Glorious Anthem", 35110, Rarity.RARE, mage.cards.g.GloriousAnthem.class));
        cards.add(new SetCardInfo("Glory", 36248, Rarity.RARE, mage.cards.g.Glory.class));
        cards.add(new SetCardInfo("Glorybringer", 64426, Rarity.RARE, mage.cards.g.Glorybringer.class, FULL_ART));
        cards.add(new SetCardInfo("Go for the Throat", 42878, Rarity.UNCOMMON, mage.cards.g.GoForTheThroat.class));
        cards.add(new SetCardInfo("Goblin Bombardment", 36058, Rarity.UNCOMMON, mage.cards.g.GoblinBombardment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Bombardment", 54545, Rarity.UNCOMMON, mage.cards.g.GoblinBombardment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Dark-Dwellers", 59673, Rarity.RARE, mage.cards.g.GoblinDarkDwellers.class));
        cards.add(new SetCardInfo("Goblin Diplomats", 49832, Rarity.RARE, mage.cards.g.GoblinDiplomats.class, FULL_ART));
        cards.add(new SetCardInfo("Goblin Guide", 44309, Rarity.RARE, mage.cards.g.GoblinGuide.class));
        cards.add(new SetCardInfo("Goblin Legionnaire", 35146, Rarity.COMMON, mage.cards.g.GoblinLegionnaire.class));
        cards.add(new SetCardInfo("Goblin Piledriver", 31415, Rarity.RARE, mage.cards.g.GoblinPiledriver.class));
        cards.add(new SetCardInfo("Goblin Rabblemaster", 53832, Rarity.RARE, mage.cards.g.GoblinRabblemaster.class));
        cards.add(new SetCardInfo("Goblin Ringleader", 35144, Rarity.UNCOMMON, mage.cards.g.GoblinRingleader.class));
        cards.add(new SetCardInfo("Goblin Vandal", 46916, Rarity.COMMON, mage.cards.g.GoblinVandal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Vandal", 62383, Rarity.COMMON, mage.cards.g.GoblinVandal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Warchief", 31477, Rarity.UNCOMMON, mage.cards.g.GoblinWarchief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Warchief", 60452, Rarity.RARE, mage.cards.g.GoblinWarchief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Godless Shrine", 72305, Rarity.RARE, mage.cards.g.GodlessShrine.class, FULL_ART));
        cards.add(new SetCardInfo("Golem's Heart", 37869, Rarity.UNCOMMON, mage.cards.g.GolemsHeart.class));
        cards.add(new SetCardInfo("Golgari Signet", 62397, Rarity.UNCOMMON, mage.cards.g.GolgariSignet.class));
        cards.add(new SetCardInfo("Gorilla Shaman", 61060, Rarity.COMMON, mage.cards.g.GorillaShaman.class));
        cards.add(new SetCardInfo("Grafdigger's Cage", 69989, Rarity.RARE, mage.cards.g.GrafdiggersCage.class));
        cards.add(new SetCardInfo("Grave Titan", 62403, Rarity.MYTHIC, mage.cards.g.GraveTitan.class));
        cards.add(new SetCardInfo("Gravecrawler", 43517, Rarity.RARE, mage.cards.g.Gravecrawler.class));
        cards.add(new SetCardInfo("Greater Good", 51542, Rarity.RARE, mage.cards.g.GreaterGood.class));
        cards.add(new SetCardInfo("Grim Haruspex", 55789, Rarity.RARE, mage.cards.g.GrimHaruspex.class));
        cards.add(new SetCardInfo("Grim Lavamancer", 31489, Rarity.RARE, mage.cards.g.GrimLavamancer.class));
        cards.add(new SetCardInfo("Grim Monolith", 61567, Rarity.RARE, mage.cards.g.GrimMonolith.class));
        cards.add(new SetCardInfo("Grindstone", 62423, Rarity.RARE, mage.cards.g.Grindstone.class));
        cards.add(new SetCardInfo("Griselbrand", 55727, Rarity.MYTHIC, mage.cards.g.Griselbrand.class));
        cards.add(new SetCardInfo("Grisly Salvage", 50108, Rarity.COMMON, mage.cards.g.GrislySalvage.class));
        cards.add(new SetCardInfo("Groundbreaker", 36072, Rarity.RARE, mage.cards.g.Groundbreaker.class, FULL_ART));
        cards.add(new SetCardInfo("Grove of the Guardian", 46889, Rarity.RARE, mage.cards.g.GroveOfTheGuardian.class));
        cards.add(new SetCardInfo("Gruul Guildmage", 36302, Rarity.UNCOMMON, mage.cards.g.GruulGuildmage.class));
        cards.add(new SetCardInfo("Gruul Signet", 46914, Rarity.UNCOMMON, mage.cards.g.GruulSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gruul Signet", 62401, Rarity.COMMON, mage.cards.g.GruulSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gush", 61056, Rarity.UNCOMMON, mage.cards.g.Gush.class));
        cards.add(new SetCardInfo("Guttersnipe", 69248, Rarity.UNCOMMON, mage.cards.g.Guttersnipe.class, FULL_ART));
        cards.add(new SetCardInfo("Guul Draz Assassin", 36875, Rarity.RARE, mage.cards.g.GuulDrazAssassin.class));
        cards.add(new SetCardInfo("Hada Freeblade", 43558, Rarity.UNCOMMON, mage.cards.h.HadaFreeblade.class, FULL_ART));
        cards.add(new SetCardInfo("Hall of Triumph", 52340, Rarity.RARE, mage.cards.h.HallOfTriumph.class));
        cards.add(new SetCardInfo("Hallowed Fountain", 72297, Rarity.RARE, mage.cards.h.HallowedFountain.class, FULL_ART));
        cards.add(new SetCardInfo("Hammer of Bogardan", 36000, Rarity.RARE, mage.cards.h.HammerOfBogardan.class));
        cards.add(new SetCardInfo("Hand of Justice", 223, Rarity.RARE, mage.cards.h.HandOfJustice.class));
        cards.add(new SetCardInfo("Hanna, Ship's Navigator", 52308, Rarity.RARE, mage.cards.h.HannaShipsNavigator.class));
        cards.add(new SetCardInfo("Harbinger of the Hunt", 57004, Rarity.RARE, mage.cards.h.HarbingerOfTheHunt.class));
        cards.add(new SetCardInfo("Harmonize", 35106, Rarity.UNCOMMON, mage.cards.h.Harmonize.class, FULL_ART));
        cards.add(new SetCardInfo("Harrow", 37612, Rarity.COMMON, mage.cards.h.Harrow.class, FULL_ART));
        cards.add(new SetCardInfo("Hazezon Tamar", 23956, Rarity.RARE, mage.cards.h.HazezonTamar.class));
        cards.add(new SetCardInfo("Headless Horseman", 35052, Rarity.COMMON, mage.cards.h.HeadlessHorseman.class));
        cards.add(new SetCardInfo("Hedge Troll", 35968, Rarity.UNCOMMON, mage.cards.h.HedgeTroll.class));
        cards.add(new SetCardInfo("Heir of the Wilds", 54555, Rarity.UNCOMMON, mage.cards.h.HeirOfTheWilds.class, FULL_ART));
        cards.add(new SetCardInfo("Hellspark Elemental", 36172, Rarity.UNCOMMON, mage.cards.h.HellsparkElemental.class));
        cards.add(new SetCardInfo("Helm of Kaldra", 31989, Rarity.RARE, mage.cards.h.HelmOfKaldra.class));
        cards.add(new SetCardInfo("Helm of Obedience", 65642, Rarity.RARE, mage.cards.h.HelmOfObedience.class));
        cards.add(new SetCardInfo("Hermit Druid", 36080, Rarity.RARE, mage.cards.h.HermitDruid.class));
        cards.add(new SetCardInfo("Hero of Bladehold", 39646, Rarity.MYTHIC, mage.cards.h.HeroOfBladehold.class));
        cards.add(new SetCardInfo("Hero of Goma Fada", 58243, Rarity.RARE, mage.cards.h.HeroOfGomaFada.class));
        cards.add(new SetCardInfo("Hero's Downfall", 55731, Rarity.RARE, mage.cards.h.HerosDownfall.class));
        cards.add(new SetCardInfo("Heroes' Bane", 52328, Rarity.RARE, mage.cards.h.HeroesBane.class));
        cards.add(new SetCardInfo("Heron's Grace Champion", 61563, Rarity.RARE, mage.cards.h.HeronsGraceChampion.class, FULL_ART));
        cards.add(new SetCardInfo("Hewed Stone Retainers", 55745, Rarity.UNCOMMON, mage.cards.h.HewedStoneRetainers.class));
        cards.add(new SetCardInfo("Hinder", 35172, Rarity.UNCOMMON, mage.cards.h.Hinder.class, FULL_ART));
        cards.add(new SetCardInfo("Hive Stirrings", 49828, Rarity.COMMON, mage.cards.h.HiveStirrings.class, FULL_ART));
        cards.add(new SetCardInfo("Hixus, Prison Warden", 57584, Rarity.RARE, mage.cards.h.HixusPrisonWarden.class));
        cards.add(new SetCardInfo("Honor of the Pure", 43554, Rarity.RARE, mage.cards.h.HonorOfThePure.class));
        cards.add(new SetCardInfo("Honored Hierarch", 57598, Rarity.RARE, mage.cards.h.HonoredHierarch.class));
        cards.add(new SetCardInfo("Hoodwink", 62449, Rarity.COMMON, mage.cards.h.Hoodwink.class));
        cards.add(new SetCardInfo("Hordeling Outburst", 55783, Rarity.UNCOMMON, mage.cards.h.HordelingOutburst.class));
        cards.add(new SetCardInfo("Hostage Taker", 69987, Rarity.RARE, mage.cards.h.HostageTaker.class));
        cards.add(new SetCardInfo("Howlpack Alpha", 42866, Rarity.RARE, mage.cards.h.HowlpackAlpha.class));
        cards.add(new SetCardInfo("Huatli, the Sun's Heart", 72241, Rarity.UNCOMMON, mage.cards.h.HuatliTheSunsHeart.class));
        cards.add(new SetCardInfo("Hydra Broodmaster", 53850, Rarity.RARE, mage.cards.h.HydraBroodmaster.class));
        cards.add(new SetCardInfo("Hydroblast", 69979, Rarity.COMMON, mage.cards.h.Hydroblast.class));
        cards.add(new SetCardInfo("Hymn to Tourach", 43634, Rarity.UNCOMMON, mage.cards.h.HymnToTourach.class));
        cards.add(new SetCardInfo("Hypersonic Dragon", 46881, Rarity.RARE, mage.cards.h.HypersonicDragon.class));
        cards.add(new SetCardInfo("Hypnotic Specter", 35040, Rarity.RARE, mage.cards.h.HypnoticSpecter.class));
        cards.add(new SetCardInfo("Hypnotic Sprite", 78742, Rarity.UNCOMMON, mage.cards.h.HypnoticSprite.class));
        cards.add(new SetCardInfo("Icatian Javelineers", 35980, Rarity.COMMON, mage.cards.i.IcatianJavelineers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icatian Javelineers", 59639, Rarity.COMMON, mage.cards.i.IcatianJavelineers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Icy Manipulator", 35042, Rarity.UNCOMMON, mage.cards.i.IcyManipulator.class));
        cards.add(new SetCardInfo("Identity Thief", 61559, Rarity.RARE, mage.cards.i.IdentityThief.class));
        cards.add(new SetCardInfo("Ifh-Biff Efreet", 213, Rarity.RARE, mage.cards.i.IfhBiffEfreet.class));
        cards.add(new SetCardInfo("Immolating Glare", 59669, Rarity.UNCOMMON, mage.cards.i.ImmolatingGlare.class, FULL_ART));
        cards.add(new SetCardInfo("Imperious Perfect", 31409, Rarity.UNCOMMON, mage.cards.i.ImperiousPerfect.class, FULL_ART));
        cards.add(new SetCardInfo("Impulse", 36006, Rarity.COMMON, mage.cards.i.Impulse.class));
        cards.add(new SetCardInfo("In Garruk's Wake", 53828, Rarity.RARE, mage.cards.i.InGarruksWake.class));
        cards.add(new SetCardInfo("Incendiary Flow", 62991, Rarity.UNCOMMON, mage.cards.i.IncendiaryFlow.class));
        cards.add(new SetCardInfo("Incinerate", 31419, Rarity.COMMON, mage.cards.i.Incinerate.class, FULL_ART));
        cards.add(new SetCardInfo("Incorrigible Youths", 60470, Rarity.UNCOMMON, mage.cards.i.IncorrigibleYouths.class, FULL_ART));
        cards.add(new SetCardInfo("Indulgent Tormentor", 53822, Rarity.RARE, mage.cards.i.IndulgentTormentor.class));
        cards.add(new SetCardInfo("Inferno Titan", 62405, Rarity.MYTHIC, mage.cards.i.InfernoTitan.class));
        cards.add(new SetCardInfo("Inferno", 62439, Rarity.RARE, mage.cards.i.Inferno.class));
        cards.add(new SetCardInfo("Infest", 43568, Rarity.UNCOMMON, mage.cards.i.Infest.class, FULL_ART));
        cards.add(new SetCardInfo("Ink-Eyes, Servant of Oni", 32013, Rarity.RARE, mage.cards.i.InkEyesServantOfOni.class));
        cards.add(new SetCardInfo("Inkmoth Nexus", 62999, Rarity.RARE, mage.cards.i.InkmothNexus.class));
        cards.add(new SetCardInfo("Insidious Mist", 60472, Rarity.RARE, mage.cards.i.InsidiousMist.class));
        cards.add(new SetCardInfo("Intuition", 36046, Rarity.RARE, mage.cards.i.Intuition.class));
        cards.add(new SetCardInfo("Island", 239, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 247, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 249, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 263, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 273, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 283, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 285, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 31979, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 31993, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 32009, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 32023, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 40042, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 40052, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 40062, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 40100, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 53881, Rarity.LAND, mage.cards.basiclands.Island.class, FULL_ART));
        cards.add(new SetCardInfo("Island", 58255, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 73634, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Isochron Scepter", 35064, Rarity.UNCOMMON, mage.cards.i.IsochronScepter.class));
        cards.add(new SetCardInfo("Ivorytusk Fortress", 54510, Rarity.RARE, mage.cards.i.IvorytuskFortress.class));
        cards.add(new SetCardInfo("Izzet Charm", 48192, Rarity.UNCOMMON, mage.cards.i.IzzetCharm.class));
        cards.add(new SetCardInfo("Izzet Signet", 62387, Rarity.UNCOMMON, mage.cards.i.IzzetSignet.class));
        cards.add(new SetCardInfo("Jace Beleren", 36176, Rarity.MYTHIC, mage.cards.j.JaceBeleren.class));
        cards.add(new SetCardInfo("Jace's Ingenuity", 41642, Rarity.UNCOMMON, mage.cards.j.JacesIngenuity.class));
        cards.add(new SetCardInfo("Jace, Cunning Castaway", 70932, Rarity.MYTHIC, mage.cards.j.JaceCunningCastaway.class));
        cards.add(new SetCardInfo("Jace, Wielder of Mysteries", 72265, Rarity.RARE, mage.cards.j.JaceWielderOfMysteries.class));
        cards.add(new SetCardInfo("Jackal Pup", 36056, Rarity.UNCOMMON, mage.cards.j.JackalPup.class));
        cards.add(new SetCardInfo("Jaya Ballard, Task Mage", 36312, Rarity.RARE, mage.cards.j.JayaBallardTaskMage.class));
        cards.add(new SetCardInfo("Jaya, Venerated Firemage", 72243, Rarity.UNCOMMON, mage.cards.j.JayaVeneratedFiremage.class));
        cards.add(new SetCardInfo("Jeering Instigator", 55771, Rarity.RARE, mage.cards.j.JeeringInstigator.class));
        cards.add(new SetCardInfo("Jeskai Infiltrator", 55757, Rarity.RARE, mage.cards.j.JeskaiInfiltrator.class));
        cards.add(new SetCardInfo("Jiang Yanggu, Wildcrafter", 72275, Rarity.UNCOMMON, mage.cards.j.JiangYangguWildcrafter.class));
        cards.add(new SetCardInfo("Jokulhaups", 70942, Rarity.RARE, mage.cards.j.Jokulhaups.class));
        cards.add(new SetCardInfo("Joraga Warcaller", 35820, Rarity.RARE, mage.cards.j.JoragaWarcaller.class));
        cards.add(new SetCardInfo("Jori En, Ruin Diver", 59679, Rarity.RARE, mage.cards.j.JoriEnRuinDiver.class, FULL_ART));
        cards.add(new SetCardInfo("Judge's Familiar", 48194, Rarity.UNCOMMON, mage.cards.j.JudgesFamiliar.class));
        cards.add(new SetCardInfo("Juggernaut", 35044, Rarity.UNCOMMON, mage.cards.j.Juggernaut.class));
        cards.add(new SetCardInfo("Kalastria Highborn", 43552, Rarity.RARE, mage.cards.k.KalastriaHighborn.class, FULL_ART));
        cards.add(new SetCardInfo("Kamahl, Pit Fighter", 36088, Rarity.RARE, mage.cards.k.KamahlPitFighter.class));
        cards.add(new SetCardInfo("Karador, Ghost Chieftain", 51534, Rarity.MYTHIC, mage.cards.k.KaradorGhostChieftain.class));
        cards.add(new SetCardInfo("Karakas", 43592, Rarity.UNCOMMON, mage.cards.k.Karakas.class));
        cards.add(new SetCardInfo("Karametra's Acolyte", 50118, Rarity.UNCOMMON, mage.cards.k.KarametrasAcolyte.class));
        cards.add(new SetCardInfo("Karn's Bastion", 72223, Rarity.RARE, mage.cards.k.KarnsBastion.class));
        cards.add(new SetCardInfo("Karn, Silver Golem", 36106, Rarity.RARE, mage.cards.k.KarnSilverGolem.class));
        cards.add(new SetCardInfo("Karn, the Great Creator", 72245, Rarity.RARE, mage.cards.k.KarnTheGreatCreator.class));
        cards.add(new SetCardInfo("Kasmina, Enigmatic Mentor", 72253, Rarity.UNCOMMON, mage.cards.k.KasminaEnigmaticMentor.class));
        cards.add(new SetCardInfo("Kaya, Bane of the Dead", 72229, Rarity.UNCOMMON, mage.cards.k.KayaBaneOfTheDead.class));
        cards.add(new SetCardInfo("Khabal Ghoul", 215, Rarity.RARE, mage.cards.k.KhabalGhoul.class));
        cards.add(new SetCardInfo("Killing Wave", 44319, Rarity.RARE, mage.cards.k.KillingWave.class, FULL_ART));
        cards.add(new SetCardInfo("Kiora's Follower", 51926, Rarity.UNCOMMON, mage.cards.k.KiorasFollower.class, FULL_ART));
        cards.add(new SetCardInfo("Kiora, Behemoth Beckoner", 72293, Rarity.UNCOMMON, mage.cards.k.KioraBehemothBeckoner.class));
        cards.add(new SetCardInfo("Kiora, the Crashing Wave", 59651, Rarity.MYTHIC, mage.cards.k.KioraTheCrashingWave.class));
        cards.add(new SetCardInfo("Kird Ape", 31383, Rarity.UNCOMMON, mage.cards.k.KirdApe.class));
        cards.add(new SetCardInfo("Kitchen Finks", 36166, Rarity.UNCOMMON, mage.cards.k.KitchenFinks.class));
        cards.add(new SetCardInfo("Kiyomaro, First to Stand", 32015, Rarity.RARE, mage.cards.k.KiyomaroFirstToStand.class));
        cards.add(new SetCardInfo("Kjeldoran Outpost", 23952, Rarity.RARE, mage.cards.k.KjeldoranOutpost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kjeldoran Outpost", 43628, Rarity.RARE, mage.cards.k.KjeldoranOutpost.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Knight of New Alara", 32555, Rarity.RARE, mage.cards.k.KnightOfNewAlara.class));
        cards.add(new SetCardInfo("Kongming, \"Sleeping Dragon\"", 33442, Rarity.RARE, mage.cards.k.KongmingSleepingDragon.class));
        cards.add(new SetCardInfo("Kor Duelist", 36212, Rarity.UNCOMMON, mage.cards.k.KorDuelist.class));
        cards.add(new SetCardInfo("Kor Firewalker", 43574, Rarity.UNCOMMON, mage.cards.k.KorFirewalker.class));
        cards.add(new SetCardInfo("Kor Skyfisher", 43548, Rarity.COMMON, mage.cards.k.KorSkyfisher.class));
        cards.add(new SetCardInfo("Korlash, Heir to Blackblade", 31961, Rarity.RARE, mage.cards.k.KorlashHeirToBlackblade.class));
        cards.add(new SetCardInfo("Kothophed, Soul Hoarder", 57590, Rarity.RARE, mage.cards.k.KothophedSoulHoarder.class));
        cards.add(new SetCardInfo("Kozilek, the Great Distortion", 62493, Rarity.MYTHIC, mage.cards.k.KozilekTheGreatDistortion.class));
        cards.add(new SetCardInfo("Krosan Grip", 37604, Rarity.UNCOMMON, mage.cards.k.KrosanGrip.class));
        cards.add(new SetCardInfo("Krosan Tusker", 32575, Rarity.COMMON, mage.cards.k.KrosanTusker.class));
        cards.add(new SetCardInfo("Krosan Warchief", 32577, Rarity.UNCOMMON, mage.cards.k.KrosanWarchief.class));
        cards.add(new SetCardInfo("Lake of the Dead", 23954, Rarity.RARE, mage.cards.l.LakeOfTheDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lake of the Dead", 43630, Rarity.RARE, mage.cards.l.LakeOfTheDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Land Tax", 36855, Rarity.RARE, mage.cards.l.LandTax.class));
        cards.add(new SetCardInfo("Languish", 57592, Rarity.RARE, mage.cards.l.Languish.class, FULL_ART));
        cards.add(new SetCardInfo("Laquatus's Champion", 37875, Rarity.RARE, mage.cards.l.LaquatussChampion.class));
        cards.add(new SetCardInfo("Latch Seeker", 44315, Rarity.UNCOMMON, mage.cards.l.LatchSeeker.class, FULL_ART));
        cards.add(new SetCardInfo("Lava Axe", 32559, Rarity.COMMON, mage.cards.l.LavaAxe.class));
        cards.add(new SetCardInfo("Lavinia, Azorius Renegade", 71588, Rarity.RARE, mage.cards.l.LaviniaAzoriusRenegade.class, FULL_ART));
        cards.add(new SetCardInfo("Leatherback Baloth", 43576, Rarity.UNCOMMON, mage.cards.l.LeatherbackBaloth.class));
        cards.add(new SetCardInfo("Library of Alexandria", 46940, Rarity.RARE, mage.cards.l.LibraryOfAlexandria.class));
        cards.add(new SetCardInfo("Life // Death", 32591, Rarity.UNCOMMON, mage.cards.l.LifeDeath.class));
        cards.add(new SetCardInfo("Lightning Bolt", 35932, Rarity.COMMON, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 36224, Rarity.COMMON, mage.cards.l.LightningBolt.class, FULL_ART));
        cards.add(new SetCardInfo("Lightning Dragon", 32196, Rarity.RARE, mage.cards.l.LightningDragon.class));
        cards.add(new SetCardInfo("Lightning Greaves", 36194, Rarity.UNCOMMON, mage.cards.l.LightningGreaves.class));
        cards.add(new SetCardInfo("Lightning Helix", 31487, Rarity.UNCOMMON, mage.cards.l.LightningHelix.class, FULL_ART));
        cards.add(new SetCardInfo("Lightning Hounds", 36154, Rarity.COMMON, mage.cards.l.LightningHounds.class));
        cards.add(new SetCardInfo("Lightning Rift", 32571, Rarity.UNCOMMON, mage.cards.l.LightningRift.class));
        cards.add(new SetCardInfo("Liliana of the Veil", 55866, Rarity.MYTHIC, mage.cards.l.LilianaOfTheVeil.class));
        cards.add(new SetCardInfo("Liliana's Specter", 37602, Rarity.COMMON, mage.cards.l.LilianasSpecter.class, FULL_ART));
        cards.add(new SetCardInfo("Liliana's Triumph", 72221, Rarity.UNCOMMON, mage.cards.l.LilianasTriumph.class));
        cards.add(new SetCardInfo("Liliana, Dreadhorde General", 72283, Rarity.MYTHIC, mage.cards.l.LilianaDreadhordeGeneral.class));
        cards.add(new SetCardInfo("Liliana, Untouched by Death", 70938, Rarity.MYTHIC, mage.cards.l.LilianaUntouchedByDeath.class));
        cards.add(new SetCardInfo("Lingering Souls", 45201, Rarity.UNCOMMON, mage.cards.l.LingeringSouls.class));
        cards.add(new SetCardInfo("Lion's Eye Diamond", 51936, Rarity.RARE, mage.cards.l.LionsEyeDiamond.class));
        cards.add(new SetCardInfo("Living Death", 36042, Rarity.RARE, mage.cards.l.LivingDeath.class));
        cards.add(new SetCardInfo("Living Wish", 35068, Rarity.RARE, mage.cards.l.LivingWish.class));
        cards.add(new SetCardInfo("Llanowar Elves", 31379, Rarity.COMMON, mage.cards.l.LlanowarElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Llanowar Elves", 35934, Rarity.COMMON, mage.cards.l.LlanowarElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Llanowar Elves", 68039, Rarity.COMMON, mage.cards.l.LlanowarElves.class, FULL_ART));
        cards.add(new SetCardInfo("Lobotomy", 32529, Rarity.UNCOMMON, mage.cards.l.Lobotomy.class));
        cards.add(new SetCardInfo("Lonesome Unicorn", 78758, Rarity.COMMON, mage.cards.l.LonesomeUnicorn.class));
        cards.add(new SetCardInfo("Longbow Archer", 36008, Rarity.UNCOMMON, mage.cards.l.LongbowArcher.class));
        cards.add(new SetCardInfo("Lord of Atlantis", 35936, Rarity.RARE, mage.cards.l.LordOfAtlantis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of Atlantis", 69945, Rarity.RARE, mage.cards.l.LordOfAtlantis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of Shatterskull Pass", 36871, Rarity.RARE, mage.cards.l.LordOfShatterskullPass.class));
        cards.add(new SetCardInfo("Lotus Bloom", 31495, Rarity.RARE, mage.cards.l.LotusBloom.class));
        cards.add(new SetCardInfo("Lotus Cobra", 44321, Rarity.MYTHIC, mage.cards.l.LotusCobra.class));
        cards.add(new SetCardInfo("Lovestruck Beast", 78830, Rarity.RARE, mage.cards.l.LovestruckBeast.class));
        cards.add(new SetCardInfo("Lowland Oaf", 62415, Rarity.COMMON, mage.cards.l.LowlandOaf.class));
        cards.add(new SetCardInfo("Loyal Retainers", 47973, Rarity.UNCOMMON, mage.cards.l.LoyalRetainers.class));
        cards.add(new SetCardInfo("Lu Bu, Master-at-Arms", 36130, Rarity.RARE, mage.cards.l.LuBuMasterAtArms.class));
        cards.add(new SetCardInfo("Ludevic's Abomination", 42874, Rarity.RARE, mage.cards.l.LudevicsAbomination.class));
        cards.add(new SetCardInfo("Ludevic's Test Subject", 42874, Rarity.RARE, mage.cards.l.LudevicsTestSubject.class));
        cards.add(new SetCardInfo("Mad Auntie", 35066, Rarity.RARE, mage.cards.m.MadAuntie.class));
        cards.add(new SetCardInfo("Maelstrom Pulse", 37845, Rarity.RARE, mage.cards.m.MaelstromPulse.class));
        cards.add(new SetCardInfo("Magister of Worth", 52593, Rarity.RARE, mage.cards.m.MagisterOfWorth.class));
        cards.add(new SetCardInfo("Magma Jet", 36162, Rarity.UNCOMMON, mage.cards.m.MagmaJet.class));
        cards.add(new SetCardInfo("Magma Spray", 52338, Rarity.RARE, mage.cards.m.MagmaSpray.class));
        cards.add(new SetCardInfo("Magmaquake", 45207, Rarity.RARE, mage.cards.m.Magmaquake.class, FULL_ART));
        cards.add(new SetCardInfo("Malfegor", 31971, Rarity.MYTHIC, mage.cards.m.Malfegor.class));
        cards.add(new SetCardInfo("Man-o'-War", 36010, Rarity.COMMON, mage.cards.m.ManOWar.class));
        cards.add(new SetCardInfo("Mana Crypt", 35962, Rarity.RARE, mage.cards.m.ManaCrypt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Crypt", 46908, Rarity.RARE, mage.cards.m.ManaCrypt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Drain", 46934, Rarity.RARE, mage.cards.m.ManaDrain.class));
        cards.add(new SetCardInfo("Mana Flare", 58241, Rarity.RARE, mage.cards.m.ManaFlare.class));
        cards.add(new SetCardInfo("Mana Leak", 31481, Rarity.COMMON, mage.cards.m.ManaLeak.class, FULL_ART));
        cards.add(new SetCardInfo("Mana Tithe", 35108, Rarity.COMMON, mage.cards.m.ManaTithe.class, FULL_ART));
        cards.add(new SetCardInfo("Mana Vault", 46942, Rarity.RARE, mage.cards.m.ManaVault.class));
        cards.add(new SetCardInfo("Mardu Shadowspear", 55717, Rarity.UNCOMMON, mage.cards.m.MarduShadowspear.class, FULL_ART));
        cards.add(new SetCardInfo("Marisi's Twinclaws", 36186, Rarity.UNCOMMON, mage.cards.m.MarisisTwinclaws.class));
        cards.add(new SetCardInfo("Markov Dreadknight", 60456, Rarity.RARE, mage.cards.m.MarkovDreadknight.class));
        cards.add(new SetCardInfo("Martyr's Bond", 77945, Rarity.RARE, mage.cards.m.MartyrsBond.class));
        cards.add(new SetCardInfo("Master's Call", 39644, Rarity.COMMON, mage.cards.m.MastersCall.class));
        cards.add(new SetCardInfo("Mastery of the Unseen", 55705, Rarity.RARE, mage.cards.m.MasteryOfTheUnseen.class));
        cards.add(new SetCardInfo("Maul Splicer", 40084, Rarity.COMMON, mage.cards.m.MaulSplicer.class));
        cards.add(new SetCardInfo("Mayor of Avabruck", 42866, Rarity.RARE, mage.cards.m.MayorOfAvabruck.class));
        cards.add(new SetCardInfo("Maze of Ith", 36170, Rarity.RARE, mage.cards.m.MazeOfIth.class));
        cards.add(new SetCardInfo("Maze's End", 48572, Rarity.MYTHIC, mage.cards.m.MazesEnd.class));
        cards.add(new SetCardInfo("Meddling Mage", 36304, Rarity.RARE, mage.cards.m.MeddlingMage.class));
        cards.add(new SetCardInfo("Megantic Sliver", 49830, Rarity.RARE, mage.cards.m.MeganticSliver.class));
        cards.add(new SetCardInfo("Melek, Izzet Paragon", 48578, Rarity.RARE, mage.cards.m.MelekIzzetParagon.class, FULL_ART));
        cards.add(new SetCardInfo("Memnite", 37871, Rarity.UNCOMMON, mage.cards.m.Memnite.class, FULL_ART));
        cards.add(new SetCardInfo("Memoricide", 37863, Rarity.RARE, mage.cards.m.Memoricide.class));
        cards.add(new SetCardInfo("Memory Lapse", 35986, Rarity.COMMON, mage.cards.m.MemoryLapse.class));
        cards.add(new SetCardInfo("Merchant of the Vale", 78778, Rarity.COMMON, mage.cards.m.MerchantOfTheVale.class));
        cards.add(new SetCardInfo("Merchant Scroll", 68055, Rarity.RARE, mage.cards.m.MerchantScroll.class));
        cards.add(new SetCardInfo("Mercurial Pretender", 53826, Rarity.RARE, mage.cards.m.MercurialPretender.class));
        cards.add(new SetCardInfo("Merfolk Secretkeeper", 78822, Rarity.COMMON, mage.cards.m.MerfolkSecretkeeper.class));
        cards.add(new SetCardInfo("Merrow Reejerey", 36164, Rarity.UNCOMMON, mage.cards.m.MerrowReejerey.class));
        cards.add(new SetCardInfo("Metalworker", 46950, Rarity.RARE, mage.cards.m.Metalworker.class));
        cards.add(new SetCardInfo("Militia Bugler", 69260, Rarity.UNCOMMON, mage.cards.m.MilitiaBugler.class));
        cards.add(new SetCardInfo("Mind Control", 36298, Rarity.UNCOMMON, mage.cards.m.MindControl.class));
        cards.add(new SetCardInfo("Mind Stone", 31405, Rarity.UNCOMMON, mage.cards.m.MindStone.class));
        cards.add(new SetCardInfo("Mind Twist", 46920, Rarity.RARE, mage.cards.m.MindTwist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mind Twist", 62427, Rarity.RARE, mage.cards.m.MindTwist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mind Warp", 35982, Rarity.UNCOMMON, mage.cards.m.MindWarp.class));
        cards.add(new SetCardInfo("Mind's Desire", 35070, Rarity.RARE, mage.cards.m.MindsDesire.class));
        cards.add(new SetCardInfo("Mind's Eye", 47981, Rarity.RARE, mage.cards.m.MindsEye.class));
        cards.add(new SetCardInfo("Mindwrack Demon", 60480, Rarity.MYTHIC, mage.cards.m.MindwrackDemon.class));
        cards.add(new SetCardInfo("Mirari's Wake", 31421, Rarity.RARE, mage.cards.m.MirarisWake.class));
        cards.add(new SetCardInfo("Mirran Crusader", 39636, Rarity.RARE, mage.cards.m.MirranCrusader.class));
        cards.add(new SetCardInfo("Misdirection", 62461, Rarity.RARE, mage.cards.m.Misdirection.class));
        cards.add(new SetCardInfo("Mishra's Factory", 221, Rarity.UNCOMMON, mage.cards.m.MishrasFactory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra's Factory", 35954, Rarity.UNCOMMON, mage.cards.m.MishrasFactory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mishra's Workshop", 46944, Rarity.RARE, mage.cards.m.MishrasWorkshop.class));
        cards.add(new SetCardInfo("Mitotic Slime", 37600, Rarity.RARE, mage.cards.m.MitoticSlime.class, FULL_ART));
        cards.add(new SetCardInfo("Mizzium Meddler", 57608, Rarity.RARE, mage.cards.m.MizziumMeddler.class));
        cards.add(new SetCardInfo("Moat", 46948, Rarity.RARE, mage.cards.m.Moat.class));
        cards.add(new SetCardInfo("Mogg Fanatic", 31407, Rarity.UNCOMMON, mage.cards.m.MoggFanatic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mogg Fanatic", 36036, Rarity.COMMON, mage.cards.m.MoggFanatic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Momentary Blink", 60478, Rarity.COMMON, mage.cards.m.MomentaryBlink.class));
        cards.add(new SetCardInfo("Mondronen Shaman", 43507, Rarity.RARE, mage.cards.m.MondronenShaman.class));
        cards.add(new SetCardInfo("Monstrous Hound", 32194, Rarity.RARE, mage.cards.m.MonstrousHound.class));
        cards.add(new SetCardInfo("Moonsilver Spear", 44311, Rarity.RARE, mage.cards.m.MoonsilverSpear.class));
        cards.add(new SetCardInfo("Morphling", 26982, Rarity.RARE, mage.cards.m.Morphling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Morphling", 36847, Rarity.RARE, mage.cards.m.Morphling.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mortify", 35046, Rarity.UNCOMMON, mage.cards.m.Mortify.class, FULL_ART));
        cards.add(new SetCardInfo("Mother of Runes", 36140, Rarity.UNCOMMON, mage.cards.m.MotherOfRunes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mother of Runes", 59649, Rarity.UNCOMMON, mage.cards.m.MotherOfRunes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 241, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 243, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 245, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 267, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 277, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 289, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 291, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 31981, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 31995, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 32003, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 32025, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 40044, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 40054, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 40064, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 40096, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 53877, Rarity.LAND, mage.cards.basiclands.Mountain.class, FULL_ART));
        cards.add(new SetCardInfo("Mountain", 58259, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 73630, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mox Emerald", 46896, Rarity.RARE, mage.cards.m.MoxEmerald.class));
        cards.add(new SetCardInfo("Mox Jet", 46894, Rarity.RARE, mage.cards.m.MoxJet.class));
        cards.add(new SetCardInfo("Mox Pearl", 46892, Rarity.RARE, mage.cards.m.MoxPearl.class));
        cards.add(new SetCardInfo("Mox Ruby", 46952, Rarity.RARE, mage.cards.m.MoxRuby.class));
        cards.add(new SetCardInfo("Mox Sapphire", 46902, Rarity.RARE, mage.cards.m.MoxSapphire.class));
        cards.add(new SetCardInfo("Mulldrifter", 36190, Rarity.COMMON, mage.cards.m.Mulldrifter.class));
        cards.add(new SetCardInfo("Munda's Vanguard", 59659, Rarity.RARE, mage.cards.m.MundasVanguard.class));
        cards.add(new SetCardInfo("Murder", 69256, Rarity.UNCOMMON, mage.cards.m.Murder.class));
        cards.add(new SetCardInfo("Murderous Redcap", 36192, Rarity.UNCOMMON, mage.cards.m.MurderousRedcap.class));
        cards.add(new SetCardInfo("Murderous Rider", 78846, Rarity.RARE, mage.cards.m.MurderousRider.class));
        cards.add(new SetCardInfo("Muscle Sliver", 36034, Rarity.COMMON, mage.cards.m.MuscleSliver.class));
        cards.add(new SetCardInfo("Mutavault", 31425, Rarity.RARE, mage.cards.m.Mutavault.class, FULL_ART));
        cards.add(new SetCardInfo("Mutavault", 66888, Rarity.RARE, mage.cards.m.Mutavault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mwonvuli Beast Tracker", 45211, Rarity.UNCOMMON, mage.cards.m.MwonvuliBeastTracker.class, FULL_ART));
        cards.add(new SetCardInfo("Mycoid Shepherd", 43556, Rarity.RARE, mage.cards.m.MycoidShepherd.class, FULL_ART));
        cards.add(new SetCardInfo("Myr Enforcer", 36274, Rarity.COMMON, mage.cards.m.MyrEnforcer.class));
        cards.add(new SetCardInfo("Myr Superion", 40078, Rarity.RARE, mage.cards.m.MyrSuperion.class, FULL_ART));
        cards.add(new SetCardInfo("Mystic of the Hidden Way", 55775, Rarity.COMMON, mage.cards.m.MysticOfTheHiddenWay.class));
        cards.add(new SetCardInfo("Mystical Tutor", 70926, Rarity.RARE, mage.cards.m.MysticalTutor.class));
        cards.add(new SetCardInfo("Nahiri, Storm of Stone", 72291, Rarity.UNCOMMON, mage.cards.n.NahiriStormOfStone.class));
        cards.add(new SetCardInfo("Nalathni Dragon", 35956, Rarity.RARE, mage.cards.n.NalathniDragon.class));
        cards.add(new SetCardInfo("Nameless Inversion", 35126, Rarity.COMMON, mage.cards.n.NamelessInversion.class, FULL_ART));
        cards.add(new SetCardInfo("Narset, Parter of Veils", 72269, Rarity.UNCOMMON, mage.cards.n.NarsetParterOfVeils.class));
        cards.add(new SetCardInfo("Natural Order", 43536, Rarity.RARE, mage.cards.n.NaturalOrder.class));
        cards.add(new SetCardInfo("Naya Sojourners", 36188, Rarity.COMMON, mage.cards.n.NayaSojourners.class));
        cards.add(new SetCardInfo("Nearheath Stalker", 43509, Rarity.COMMON, mage.cards.n.NearheathStalker.class));
        cards.add(new SetCardInfo("Necromaster Dragon", 57000, Rarity.RARE, mage.cards.n.NecromasterDragon.class));
        cards.add(new SetCardInfo("Necropolis Fiend", 55729, Rarity.RARE, mage.cards.n.NecropolisFiend.class));
        cards.add(new SetCardInfo("Negate", 35138, Rarity.COMMON, mage.cards.n.Negate.class, FULL_ART));
        cards.add(new SetCardInfo("Negate", 70930, Rarity.RARE, mage.cards.n.Negate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nekusar, the Mindrazer", 52314, Rarity.MYTHIC, mage.cards.n.NekusarTheMindrazer.class));
        cards.add(new SetCardInfo("Nephalia Moondrakes", 60458, Rarity.RARE, mage.cards.n.NephaliaMoondrakes.class));
        cards.add(new SetCardInfo("Nessian Wilds Ravager", 51924, Rarity.RARE, mage.cards.n.NessianWildsRavager.class));
        cards.add(new SetCardInfo("Nether Void", 46936, Rarity.RARE, mage.cards.n.NetherVoid.class));
        cards.add(new SetCardInfo("Niblis of Frost", 61547, Rarity.RARE, mage.cards.n.NiblisOfFrost.class));
        cards.add(new SetCardInfo("Nicol Bolas, Dragon-God", 72281, Rarity.MYTHIC, mage.cards.n.NicolBolasDragonGod.class));
        cards.add(new SetCardInfo("Nicol Bolas, Planeswalker", 65009, Rarity.MYTHIC, mage.cards.n.NicolBolasPlaneswalker.class));
        cards.add(new SetCardInfo("Nighthowler", 50122, Rarity.RARE, mage.cards.n.Nighthowler.class, FULL_ART));
        cards.add(new SetCardInfo("Nightveil Specter", 47995, Rarity.RARE, mage.cards.n.NightveilSpecter.class));
        cards.add(new SetCardInfo("Nissa's Chosen", 36216, Rarity.COMMON, mage.cards.n.NissasChosen.class, FULL_ART));
        cards.add(new SetCardInfo("Nissa's Pilgrimage", 59677, Rarity.COMMON, mage.cards.n.NissasPilgrimage.class));
        cards.add(new SetCardInfo("Nissa, Vital Force", 70936, Rarity.MYTHIC, mage.cards.n.NissaVitalForce.class));
        cards.add(new SetCardInfo("Nissa, Voice of Zendikar", 62511, Rarity.MYTHIC, mage.cards.n.NissaVoiceOfZendikar.class));
        cards.add(new SetCardInfo("Nissa, Who Shakes the World", 72261, Rarity.RARE, mage.cards.n.NissaWhoShakesTheWorld.class));
        cards.add(new SetCardInfo("Nissa, Worldwaker", 65005, Rarity.MYTHIC, mage.cards.n.NissaWorldwaker.class));
        cards.add(new SetCardInfo("Niv-Mizzet, the Firemind", 32583, Rarity.RARE, mage.cards.n.NivMizzetTheFiremind.class, FULL_ART));
        cards.add(new SetCardInfo("Noble Hierarch", 58239, Rarity.RARE, mage.cards.n.NobleHierarch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Noble Hierarch", 66894, Rarity.RARE, mage.cards.n.NobleHierarch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Noose Constrictor", 62995, Rarity.UNCOMMON, mage.cards.n.NooseConstrictor.class));
        cards.add(new SetCardInfo("Noosegraf Mob", 61549, Rarity.RARE, mage.cards.n.NoosegrafMob.class));
        cards.add(new SetCardInfo("Oakhame Ranger", 78738, Rarity.UNCOMMON, mage.cards.o.OakhameRanger.class));
        cards.add(new SetCardInfo("Oath of Druids", 36092, Rarity.RARE, mage.cards.o.OathOfDruids.class));
        cards.add(new SetCardInfo("Ob Nixilis Reignited", 62509, Rarity.MYTHIC, mage.cards.o.ObNixilisReignited.class));
        cards.add(new SetCardInfo("Ob Nixilis, the Hate-Twisted", 72251, Rarity.UNCOMMON, mage.cards.o.ObNixilisTheHateTwisted.class));
        cards.add(new SetCardInfo("Obelisk of Alara", 31973, Rarity.RARE, mage.cards.o.ObeliskOfAlara.class));
        cards.add(new SetCardInfo("Oblivion Ring", 36202, Rarity.COMMON, mage.cards.o.OblivionRing.class));
        cards.add(new SetCardInfo("Oblivion Sower", 58893, Rarity.MYTHIC, mage.cards.o.OblivionSower.class));
        cards.add(new SetCardInfo("Ojutai's Command", 55878, Rarity.RARE, mage.cards.o.OjutaisCommand.class));
        cards.add(new SetCardInfo("Okina Nightwatch", 36290, Rarity.COMMON, mage.cards.o.OkinaNightwatch.class));
        cards.add(new SetCardInfo("Oko, Thief of Crowns", 78858, Rarity.MYTHIC, mage.cards.o.OkoThiefOfCrowns.class));
        cards.add(new SetCardInfo("Old Man of the Sea", 43644, Rarity.RARE, mage.cards.o.OldManOfTheSea.class));
        cards.add(new SetCardInfo("Oloro, Ageless Ascetic", 52316, Rarity.MYTHIC, mage.cards.o.OloroAgelessAscetic.class));
        cards.add(new SetCardInfo("Oona's Blackguard", 32535, Rarity.UNCOMMON, mage.cards.o.OonasBlackguard.class));
        cards.add(new SetCardInfo("Ophidian", 36022, Rarity.COMMON, mage.cards.o.Ophidian.class));
        cards.add(new SetCardInfo("Opt", 68047, Rarity.COMMON, mage.cards.o.Opt.class));
        cards.add(new SetCardInfo("Oracle's Vault", 64434, Rarity.RARE, mage.cards.o.OraclesVault.class));
        cards.add(new SetCardInfo("Oran-Rief Hydra", 58251, Rarity.RARE, mage.cards.o.OranRiefHydra.class));
        cards.add(new SetCardInfo("Orator of Ojutai", 57578, Rarity.UNCOMMON, mage.cards.o.OratorOfOjutai.class));
        cards.add(new SetCardInfo("Orcish Lumberjack", 43638, Rarity.COMMON, mage.cards.o.OrcishLumberjack.class));
        cards.add(new SetCardInfo("Order of Midnight", 78838, Rarity.UNCOMMON, mage.cards.o.OrderOfMidnight.class));
        cards.add(new SetCardInfo("Orim's Chant", 35072, Rarity.RARE, mage.cards.o.OrimsChant.class));
        cards.add(new SetCardInfo("Oros, the Avenger", 31959, Rarity.RARE, mage.cards.o.OrosTheAvenger.class));
        cards.add(new SetCardInfo("Orzhov Signet", 46910, Rarity.UNCOMMON, mage.cards.o.OrzhovSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orzhov Signet", 62399, Rarity.COMMON, mage.cards.o.OrzhovSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Overbeing of Myth", 31967, Rarity.RARE, mage.cards.o.OverbeingOfMyth.class));
        cards.add(new SetCardInfo("Overgrown Tomb", 72315, Rarity.RARE, mage.cards.o.OvergrownTomb.class, FULL_ART));
        cards.add(new SetCardInfo("Overtaker", 32202, Rarity.RARE, mage.cards.o.Overtaker.class));
        cards.add(new SetCardInfo("Oxidize", 35162, Rarity.UNCOMMON, mage.cards.o.Oxidize.class, FULL_ART));
        cards.add(new SetCardInfo("Pain Seer", 51916, Rarity.RARE, mage.cards.p.PainSeer.class, FULL_ART));
        cards.add(new SetCardInfo("Path to Exile", 36174, Rarity.UNCOMMON, mage.cards.p.PathToExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Path to Exile", 57580, Rarity.UNCOMMON, mage.cards.p.PathToExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Path to Exile", 77957, Rarity.RARE, mage.cards.p.PathToExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pathrazer of Ulamog", 36861, Rarity.UNCOMMON, mage.cards.p.PathrazerOfUlamog.class));
        cards.add(new SetCardInfo("Peace Strider", 39019, Rarity.UNCOMMON, mage.cards.p.PeaceStrider.class));
        cards.add(new SetCardInfo("Pendelhaven", 35104, Rarity.UNCOMMON, mage.cards.p.Pendelhaven.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pendelhaven", 65660, Rarity.RARE, mage.cards.p.Pendelhaven.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pernicious Deed", 36306, Rarity.RARE, mage.cards.p.PerniciousDeed.class));
        cards.add(new SetCardInfo("Phalanx Leader", 50116, Rarity.UNCOMMON, mage.cards.p.PhalanxLeader.class, FULL_ART));
        cards.add(new SetCardInfo("Phyrexian Dreadnought", 43534, Rarity.RARE, mage.cards.p.PhyrexianDreadnought.class));
        cards.add(new SetCardInfo("Phyrexian Metamorph", 40082, Rarity.RARE, mage.cards.p.PhyrexianMetamorph.class));
        cards.add(new SetCardInfo("Phyrexian Negator", 36144, Rarity.RARE, mage.cards.p.PhyrexianNegator.class));
        cards.add(new SetCardInfo("Phytotitan", 53830, Rarity.RARE, mage.cards.p.Phytotitan.class));
        cards.add(new SetCardInfo("Pia and Kiran Nalaar", 57594, Rarity.RARE, mage.cards.p.PiaAndKiranNalaar.class));
        cards.add(new SetCardInfo("Pierce Strider", 39017, Rarity.UNCOMMON, mage.cards.p.PierceStrider.class));
        cards.add(new SetCardInfo("Pillage", 35994, Rarity.UNCOMMON, mage.cards.p.Pillage.class));
        cards.add(new SetCardInfo("Pillar of Flame", 46871, Rarity.COMMON, mage.cards.p.PillarOfFlame.class));
        cards.add(new SetCardInfo("Piper of the Swarm", 78862, Rarity.RARE, mage.cards.p.PiperOfTheSwarm.class));
        cards.add(new SetCardInfo("Plague Myr", 39640, Rarity.UNCOMMON, mage.cards.p.PlagueMyr.class));
        cards.add(new SetCardInfo("Plague Stinger", 37867, Rarity.COMMON, mage.cards.p.PlagueStinger.class));
        cards.add(new SetCardInfo("Plains", 231, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 233, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 255, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 261, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 271, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 281, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 295, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 31975, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 31997, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 32011, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 32019, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 40046, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 40056, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 40066, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 40098, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 48582, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 53879, Rarity.LAND, mage.cards.basiclands.Plains.class, FULL_ART));
        cards.add(new SetCardInfo("Plains", 58253, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 73626, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plateau", 43608, Rarity.RARE, mage.cards.p.Plateau.class));
        cards.add(new SetCardInfo("Polluted Delta", 43582, Rarity.RARE, mage.cards.p.PollutedDelta.class));
        cards.add(new SetCardInfo("Ponder", 35118, Rarity.COMMON, mage.cards.p.Ponder.class, FULL_ART));
        cards.add(new SetCardInfo("Pouncing Jaguar", 36110, Rarity.COMMON, mage.cards.p.PouncingJaguar.class));
        cards.add(new SetCardInfo("Powder Keg", 36146, Rarity.RARE, mage.cards.p.PowderKeg.class));
        cards.add(new SetCardInfo("Preacher", 23950, Rarity.RARE, mage.cards.p.Preacher.class));
        cards.add(new SetCardInfo("Priest of Titania", 36120, Rarity.COMMON, mage.cards.p.PriestOfTitania.class));
        cards.add(new SetCardInfo("Priest of Urabrask", 40080, Rarity.UNCOMMON, mage.cards.p.PriestOfUrabrask.class, FULL_ART));
        cards.add(new SetCardInfo("Primal Command", 62489, Rarity.RARE, mage.cards.p.PrimalCommand.class));
        cards.add(new SetCardInfo("Pristine Skywise", 57002, Rarity.RARE, mage.cards.p.PristineSkywise.class));
        cards.add(new SetCardInfo("Pristine Talisman", 40074, Rarity.COMMON, mage.cards.p.PristineTalisman.class));
        cards.add(new SetCardInfo("Prodigal Sorcerer", 35938, Rarity.COMMON, mage.cards.p.ProdigalSorcerer.class));
        cards.add(new SetCardInfo("Prognostic Sphinx", 53842, Rarity.RARE, mage.cards.p.PrognosticSphinx.class));
        cards.add(new SetCardInfo("Prophet of Kruphix", 53844, Rarity.RARE, mage.cards.p.ProphetOfKruphix.class));
        cards.add(new SetCardInfo("Psionic Blast", 35058, Rarity.RARE, mage.cards.p.PsionicBlast.class, FULL_ART));
        cards.add(new SetCardInfo("Psychatog", 31467, Rarity.UNCOMMON, mage.cards.p.Psychatog.class));
        cards.add(new SetCardInfo("Putrefy", 35166, Rarity.UNCOMMON, mage.cards.p.Putrefy.class, FULL_ART));
        cards.add(new SetCardInfo("Pyroblast", 69981, Rarity.COMMON, mage.cards.p.Pyroblast.class));
        cards.add(new SetCardInfo("Pyroclasm", 35168, Rarity.UNCOMMON, mage.cards.p.Pyroclasm.class, FULL_ART));
        cards.add(new SetCardInfo("Pyrokinesis", 43640, Rarity.RARE, mage.cards.p.Pyrokinesis.class));
        cards.add(new SetCardInfo("Qasali Pridemage", 37608, Rarity.COMMON, mage.cards.q.QasaliPridemage.class));
        cards.add(new SetCardInfo("Queen of Ice", 78762, Rarity.COMMON, mage.cards.q.QueenOfIce.class));
        cards.add(new SetCardInfo("Questing Phelddagrif", 36234, Rarity.RARE, mage.cards.q.QuestingPhelddagrif.class));
        cards.add(new SetCardInfo("Quicksmith Rebel", 62993, Rarity.RARE, mage.cards.q.QuicksmithRebel.class));
        cards.add(new SetCardInfo("Quirion Ranger", 36012, Rarity.COMMON, mage.cards.q.QuirionRanger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quirion Ranger", 62443, Rarity.COMMON, mage.cards.q.QuirionRanger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radiant Flames", 58277, Rarity.RARE, mage.cards.r.RadiantFlames.class, FULL_ART));
        cards.add(new SetCardInfo("Raging Kavu", 36206, Rarity.RARE, mage.cards.r.RagingKavu.class));
        cards.add(new SetCardInfo("Rakdos Cackler", 49842, Rarity.UNCOMMON, mage.cards.r.RakdosCackler.class));
        cards.add(new SetCardInfo("Rakdos Firewheeler", 71590, Rarity.UNCOMMON, mage.cards.r.RakdosFirewheeler.class, FULL_ART));
        cards.add(new SetCardInfo("Rakdos Guildmage", 32589, Rarity.UNCOMMON, mage.cards.r.RakdosGuildmage.class, FULL_ART));
        cards.add(new SetCardInfo("Rakdos Signet", 46898, Rarity.UNCOMMON, mage.cards.r.RakdosSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakdos Signet", 62389, Rarity.COMMON, mage.cards.r.RakdosSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakshasa Vizier", 54516, Rarity.RARE, mage.cards.r.RakshasaVizier.class));
        cards.add(new SetCardInfo("Ral, Storm Conduit", 72231, Rarity.RARE, mage.cards.r.RalStormConduit.class));
        cards.add(new SetCardInfo("Rampaging Baloths", 35140, Rarity.MYTHIC, mage.cards.r.RampagingBaloths.class));
        cards.add(new SetCardInfo("Rampant Growth", 35128, Rarity.COMMON, mage.cards.r.RampantGrowth.class, FULL_ART));
        cards.add(new SetCardInfo("Ramunap Excavator", 64991, Rarity.RARE, mage.cards.r.RamunapExcavator.class));
        cards.add(new SetCardInfo("Rancor", 35112, Rarity.COMMON, mage.cards.r.Rancor.class));
        cards.add(new SetCardInfo("Ratchet Bomb", 49836, Rarity.RARE, mage.cards.r.RatchetBomb.class));
        cards.add(new SetCardInfo("Rathi Assassin", 32204, Rarity.RARE, mage.cards.r.RathiAssassin.class));
        cards.add(new SetCardInfo("Rattleclaw Mystic", 54557, Rarity.RARE, mage.cards.r.RattleclawMystic.class));
        cards.add(new SetCardInfo("Ravages of War", 55864, Rarity.RARE, mage.cards.r.RavagesOfWar.class));
        cards.add(new SetCardInfo("Ravenous Baloth", 31389, Rarity.RARE, mage.cards.r.RavenousBaloth.class));
        cards.add(new SetCardInfo("Ravenous Bloodseeker", 60486, Rarity.UNCOMMON, mage.cards.r.RavenousBloodseeker.class));
        cards.add(new SetCardInfo("Ravenous Demon", 43503, Rarity.RARE, mage.cards.r.RavenousDemon.class));
        cards.add(new SetCardInfo("Razorfin Hunter", 62407, Rarity.COMMON, mage.cards.r.RazorfinHunter.class));
        cards.add(new SetCardInfo("Reality Shift", 55759, Rarity.UNCOMMON, mage.cards.r.RealityShift.class));
        cards.add(new SetCardInfo("Realm-Cloaked Giant", 78798, Rarity.MYTHIC, mage.cards.r.RealmCloakedGiant.class));
        cards.add(new SetCardInfo("Reanimate", 36052, Rarity.UNCOMMON, mage.cards.r.Reanimate.class));
        cards.add(new SetCardInfo("Reaper of Night", 78770, Rarity.COMMON, mage.cards.r.ReaperOfNight.class));
        cards.add(new SetCardInfo("Reaper of the Wilds", 55737, Rarity.RARE, mage.cards.r.ReaperOfTheWilds.class));
        cards.add(new SetCardInfo("Reciprocate", 35164, Rarity.UNCOMMON, mage.cards.r.Reciprocate.class, FULL_ART));
        cards.add(new SetCardInfo("Reckless Wurm", 35990, Rarity.UNCOMMON, mage.cards.r.RecklessWurm.class));
        cards.add(new SetCardInfo("Reclamation Sage", 53836, Rarity.UNCOMMON, mage.cards.r.ReclamationSage.class, FULL_ART));
        cards.add(new SetCardInfo("Recollect", 35060, Rarity.UNCOMMON, mage.cards.r.Recollect.class, FULL_ART));
        cards.add(new SetCardInfo("Red Elemental Blast", 43610, Rarity.UNCOMMON, mage.cards.r.RedElementalBlast.class));
        cards.add(new SetCardInfo("Reflecting Pool", 62487, Rarity.RARE, mage.cards.r.ReflectingPool.class));
        cards.add(new SetCardInfo("Regrowth", 35940, Rarity.UNCOMMON, mage.cards.r.Regrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regrowth", 43612, Rarity.RARE, mage.cards.r.Regrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reins of Power", 62517, Rarity.RARE, mage.cards.r.ReinsOfPower.class));
        cards.add(new SetCardInfo("Relic Seeker", 57574, Rarity.RARE, mage.cards.r.RelicSeeker.class));
        cards.add(new SetCardInfo("Reliquary Tower", 48007, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reliquary Tower", 69250, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Remand", 31429, Rarity.UNCOMMON, mage.cards.r.Remand.class));
        cards.add(new SetCardInfo("Remove Soul", 35130, Rarity.COMMON, mage.cards.r.RemoveSoul.class, FULL_ART));
        cards.add(new SetCardInfo("Render Silent", 48576, Rarity.RARE, mage.cards.r.RenderSilent.class));
        cards.add(new SetCardInfo("Renegade Rallier", 64999, Rarity.UNCOMMON, mage.cards.r.RenegadeRallier.class));
        cards.add(new SetCardInfo("Repeal", 54543, Rarity.COMMON, mage.cards.r.Repeal.class));
        cards.add(new SetCardInfo("Resolute Archangel", 53820, Rarity.RARE, mage.cards.r.ResoluteArchangel.class));
        cards.add(new SetCardInfo("Rest in Peace", 77943, Rarity.RARE, mage.cards.r.RestInPeace.class));
        cards.add(new SetCardInfo("Restoration Angel", 44317, Rarity.RARE, mage.cards.r.RestorationAngel.class));
        cards.add(new SetCardInfo("Resurrection", 36136, Rarity.UNCOMMON, mage.cards.r.Resurrection.class));
        cards.add(new SetCardInfo("Retaliator Griffin", 43546, Rarity.RARE, mage.cards.r.RetaliatorGriffin.class));
        cards.add(new SetCardInfo("Revenant", 32192, Rarity.RARE, mage.cards.r.Revenant.class));
        cards.add(new SetCardInfo("Reverse Engineer", 64995, Rarity.UNCOMMON, mage.cards.r.ReverseEngineer.class));
        cards.add(new SetCardInfo("Rewind", 36124, Rarity.COMMON, mage.cards.r.Rewind.class));
        cards.add(new SetCardInfo("Reya Dawnbringer", 36086, Rarity.RARE, mage.cards.r.ReyaDawnbringer.class));
        cards.add(new SetCardInfo("Rhox War Monk", 40088, Rarity.UNCOMMON, mage.cards.r.RhoxWarMonk.class));
        cards.add(new SetCardInfo("Rhox", 36204, Rarity.RARE, mage.cards.r.Rhox.class));
        cards.add(new SetCardInfo("Rhystic Study", 47975, Rarity.COMMON, mage.cards.r.RhysticStudy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rhystic Study", 69943, Rarity.RARE, mage.cards.r.RhysticStudy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rift Bolt", 37849, Rarity.COMMON, mage.cards.r.RiftBolt.class));
        cards.add(new SetCardInfo("Riku of Two Reflections", 51536, Rarity.MYTHIC, mage.cards.r.RikuOfTwoReflections.class));
        cards.add(new SetCardInfo("Rimrock Knight", 78750, Rarity.COMMON, mage.cards.r.RimrockKnight.class));
        cards.add(new SetCardInfo("Rise from the Grave", 36300, Rarity.UNCOMMON, mage.cards.r.RiseFromTheGrave.class));
        cards.add(new SetCardInfo("Rise from the Tides", 62209, Rarity.RARE, mage.cards.r.RiseFromTheTides.class));
        cards.add(new SetCardInfo("Rishadan Port", 55739, Rarity.RARE, mage.cards.r.RishadanPort.class));
        cards.add(new SetCardInfo("River Boa", 36014, Rarity.UNCOMMON, mage.cards.r.RiverBoa.class));
        cards.add(new SetCardInfo("Roar of the Wurm", 32565, Rarity.UNCOMMON, mage.cards.r.RoarOfTheWurm.class));
        cards.add(new SetCardInfo("Roast", 58263, Rarity.UNCOMMON, mage.cards.r.Roast.class));
        cards.add(new SetCardInfo("Rosethorn Acolyte", 78842, Rarity.COMMON, mage.cards.r.RosethornAcolyte.class));
        cards.add(new SetCardInfo("Rout", 62465, Rarity.RARE, mage.cards.r.Rout.class));
        cards.add(new SetCardInfo("Royal Assassin", 35160, Rarity.RARE, mage.cards.r.RoyalAssassin.class));
        cards.add(new SetCardInfo("Rubblehulk", 47977, Rarity.RARE, mage.cards.r.Rubblehulk.class));
        cards.add(new SetCardInfo("Ruinous Path", 58273, Rarity.RARE, mage.cards.r.RuinousPath.class));
        cards.add(new SetCardInfo("Rukh Egg", 36270, Rarity.RARE, mage.cards.r.RukhEgg.class));
        cards.add(new SetCardInfo("Rupture", 62417, Rarity.UNCOMMON, mage.cards.r.Rupture.class));
        cards.add(new SetCardInfo("Ruthless Ripper", 55767, Rarity.UNCOMMON, mage.cards.r.RuthlessRipper.class));
        cards.add(new SetCardInfo("Ryusei, the Falling Star", 32001, Rarity.RARE, mage.cards.r.RyuseiTheFallingStar.class));
        cards.add(new SetCardInfo("Sacred Foundry", 72309, Rarity.RARE, mage.cards.s.SacredFoundry.class, FULL_ART));
        cards.add(new SetCardInfo("Sage of the Inward Eye", 54518, Rarity.RARE, mage.cards.s.SageOfTheInwardEye.class));
        cards.add(new SetCardInfo("Sage-Eye Avengers", 55709, Rarity.RARE, mage.cards.s.SageEyeAvengers.class));
        cards.add(new SetCardInfo("Saheeli's Artistry", 62207, Rarity.RARE, mage.cards.s.SaheelisArtistry.class));
        cards.add(new SetCardInfo("Saheeli, Sublime Artificer", 72287, Rarity.UNCOMMON, mage.cards.s.SaheeliSublimeArtificer.class));
        cards.add(new SetCardInfo("Sakura-Tribe Elder", 36200, Rarity.COMMON, mage.cards.s.SakuraTribeElder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakura-Tribe Elder", 36282, Rarity.COMMON, mage.cards.s.SakuraTribeElder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Samut, Tyrant Smasher", 72255, Rarity.UNCOMMON, mage.cards.s.SamutTyrantSmasher.class));
        cards.add(new SetCardInfo("Sanctifier of Souls", 61543, Rarity.RARE, mage.cards.s.SanctifierOfSouls.class));
        cards.add(new SetCardInfo("Sandsteppe Citadel", 57606, Rarity.UNCOMMON, mage.cards.s.SandsteppeCitadel.class));
        cards.add(new SetCardInfo("Sandsteppe Mastodon", 55721, Rarity.RARE, mage.cards.s.SandsteppeMastodon.class));
        cards.add(new SetCardInfo("Sarkhan the Masterless", 72257, Rarity.RARE, mage.cards.s.SarkhanTheMasterless.class));
        cards.add(new SetCardInfo("Savage Lands", 42876, Rarity.UNCOMMON, mage.cards.s.SavageLands.class));
        cards.add(new SetCardInfo("Savannah", 43614, Rarity.RARE, mage.cards.s.Savannah.class));
        cards.add(new SetCardInfo("Scaleguard Sentinels", 55882, Rarity.UNCOMMON, mage.cards.s.ScaleguardSentinels.class, FULL_ART));
        cards.add(new SetCardInfo("Scapeshift", 66898, Rarity.MYTHIC, mage.cards.s.Scapeshift.class));
        cards.add(new SetCardInfo("Scavenging Ooze", 62451, Rarity.RARE, mage.cards.s.ScavengingOoze.class));
        cards.add(new SetCardInfo("Scent of Cinder", 36150, Rarity.COMMON, mage.cards.s.ScentOfCinder.class));
        cards.add(new SetCardInfo("Scourge of Fleets", 52324, Rarity.RARE, mage.cards.s.ScourgeOfFleets.class));
        cards.add(new SetCardInfo("Scragnoth", 36054, Rarity.UNCOMMON, mage.cards.s.Scragnoth.class));
        cards.add(new SetCardInfo("Scrap Trawler", 62997, Rarity.RARE, mage.cards.s.ScrapTrawler.class));
        cards.add(new SetCardInfo("Scroll Rack", 47969, Rarity.RARE, mage.cards.s.ScrollRack.class));
        cards.add(new SetCardInfo("Scrubland", 43616, Rarity.RARE, mage.cards.s.Scrubland.class));
        cards.add(new SetCardInfo("Scryb Sprites", 62431, Rarity.COMMON, mage.cards.s.ScrybSprites.class));
        cards.add(new SetCardInfo("Scythe Leopard", 58271, Rarity.UNCOMMON, mage.cards.s.ScytheLeopard.class));
        cards.add(new SetCardInfo("Seal of Cleansing", 35132, Rarity.COMMON, mage.cards.s.SealOfCleansing.class));
        cards.add(new SetCardInfo("Searing Blaze", 39630, Rarity.COMMON, mage.cards.s.SearingBlaze.class, FULL_ART));
        cards.add(new SetCardInfo("Searing Spear", 48003, Rarity.COMMON, mage.cards.s.SearingSpear.class));
        cards.add(new SetCardInfo("Sedge Troll", 209, Rarity.RARE, mage.cards.s.SedgeTroll.class));
        cards.add(new SetCardInfo("Seeker of the Way", 57576, Rarity.UNCOMMON, mage.cards.s.SeekerOfTheWay.class));
        cards.add(new SetCardInfo("Selesnya Signet", 46926, Rarity.UNCOMMON, mage.cards.s.SelesnyaSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selesnya Signet", 62437, Rarity.COMMON, mage.cards.s.SelesnyaSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selkie Hedge-Mage", 32549, Rarity.UNCOMMON, mage.cards.s.SelkieHedgeMage.class));
        cards.add(new SetCardInfo("Serendib Efreet", 217, Rarity.RARE, mage.cards.s.SerendibEfreet.class));
        cards.add(new SetCardInfo("Serra Angel", 35942, Rarity.UNCOMMON, mage.cards.s.SerraAngel.class));
        cards.add(new SetCardInfo("Serra Avatar", 26984, Rarity.RARE, mage.cards.s.SerraAvatar.class));
        cards.add(new SetCardInfo("Serra Avenger", 36314, Rarity.RARE, mage.cards.s.SerraAvenger.class, FULL_ART));
        cards.add(new SetCardInfo("Serrated Arrows", 35116, Rarity.UNCOMMON, mage.cards.s.SerratedArrows.class));
        cards.add(new SetCardInfo("Serum Visions", 36280, Rarity.COMMON, mage.cards.s.SerumVisions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serum Visions", 57586, Rarity.COMMON, mage.cards.s.SerumVisions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Servo Exhibition", 64428, Rarity.UNCOMMON, mage.cards.s.ServoExhibition.class));
        cards.add(new SetCardInfo("Shadowmage Infiltrator", 55314, Rarity.RARE, mage.cards.s.ShadowmageInfiltrator.class));
        cards.add(new SetCardInfo("Shamanic Revelation", 55719, Rarity.RARE, mage.cards.s.ShamanicRevelation.class));
        cards.add(new SetCardInfo("Shanna, Sisay's Legacy", 68051, Rarity.UNCOMMON, mage.cards.s.ShannaSisaysLegacy.class));
        cards.add(new SetCardInfo("Shard Phoenix", 36308, Rarity.RARE, mage.cards.s.ShardPhoenix.class));
        cards.add(new SetCardInfo("Shardless Agent", 55697, Rarity.UNCOMMON, mage.cards.s.ShardlessAgent.class));
        cards.add(new SetCardInfo("Sheoldred, Whispering One", 40086, Rarity.MYTHIC, mage.cards.s.SheoldredWhisperingOne.class));
        cards.add(new SetCardInfo("Shepherd of the Flock", 78802, Rarity.UNCOMMON, mage.cards.s.ShepherdOfTheFlock.class));
        cards.add(new SetCardInfo("Shepherd of the Lost", 43550, Rarity.UNCOMMON, mage.cards.s.ShepherdOfTheLost.class));
        cards.add(new SetCardInfo("Shield of Kaldra", 31985, Rarity.RARE, mage.cards.s.ShieldOfKaldra.class));
        cards.add(new SetCardInfo("Shielded by Faith", 77953, Rarity.RARE, mage.cards.s.ShieldedByFaith.class));
        cards.add(new SetCardInfo("Shipbreaker Kraken", 50106, Rarity.RARE, mage.cards.s.ShipbreakerKraken.class));
        cards.add(new SetCardInfo("Shivan Dragon", 36232, Rarity.RARE, mage.cards.s.ShivanDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shivan Dragon", 62535, Rarity.RARE, mage.cards.s.ShivanDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shock", 32531, Rarity.COMMON, mage.cards.s.Shock.class));
        cards.add(new SetCardInfo("Show and Tell", 46930, Rarity.RARE, mage.cards.s.ShowAndTell.class));
        cards.add(new SetCardInfo("Shrapnel Blast", 31443, Rarity.UNCOMMON, mage.cards.s.ShrapnelBlast.class));
        cards.add(new SetCardInfo("Shriekmaw", 32537, Rarity.UNCOMMON, mage.cards.s.Shriekmaw.class));
        cards.add(new SetCardInfo("Shrine of Burning Rage", 40090, Rarity.UNCOMMON, mage.cards.s.ShrineOfBurningRage.class));
        cards.add(new SetCardInfo("Siege Dragon", 53834, Rarity.RARE, mage.cards.s.SiegeDragon.class));
        cards.add(new SetCardInfo("Siege Rhino", 57602, Rarity.RARE, mage.cards.s.SiegeRhino.class));
        cards.add(new SetCardInfo("Sign in Blood", 36226, Rarity.COMMON, mage.cards.s.SignInBlood.class, FULL_ART));
        cards.add(new SetCardInfo("Signal Pest", 39648, Rarity.UNCOMMON, mage.cards.s.SignalPest.class));
        cards.add(new SetCardInfo("Silent Sentinel", 51910, Rarity.RARE, mage.cards.s.SilentSentinel.class));
        cards.add(new SetCardInfo("Silent Specter", 36252, Rarity.RARE, mage.cards.s.SilentSpecter.class));
        cards.add(new SetCardInfo("Silkwrap", 62497, Rarity.UNCOMMON, mage.cards.s.Silkwrap.class));
        cards.add(new SetCardInfo("Silver Knight", 31479, Rarity.UNCOMMON, mage.cards.s.SilverKnight.class));
        cards.add(new SetCardInfo("Silverblade Paladin", 44313, Rarity.RARE, mage.cards.s.SilverbladePaladin.class));
        cards.add(new SetCardInfo("Silverflame Squire", 78834, Rarity.COMMON, mage.cards.s.SilverflameSquire.class));
        cards.add(new SetCardInfo("Silvergill Adept", 66892, Rarity.UNCOMMON, mage.cards.s.SilvergillAdept.class, FULL_ART));
        cards.add(new SetCardInfo("Simic Ascendancy", 71586, Rarity.RARE, mage.cards.s.SimicAscendancy.class));
        cards.add(new SetCardInfo("Simic Signet", 46900, Rarity.UNCOMMON, mage.cards.s.SimicSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simic Signet", 62391, Rarity.COMMON, mage.cards.s.SimicSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sin Collector", 50112, Rarity.UNCOMMON, mage.cards.s.SinCollector.class));
        cards.add(new SetCardInfo("Sinkhole", 43566, Rarity.RARE, mage.cards.s.Sinkhole.class));
        cards.add(new SetCardInfo("Skarrg Goliath", 47989, Rarity.RARE, mage.cards.s.SkarrgGoliath.class));
        cards.add(new SetCardInfo("Skirk Marauder", 36260, Rarity.COMMON, mage.cards.s.SkirkMarauder.class));
        cards.add(new SetCardInfo("Skittering Skirge", 36126, Rarity.COMMON, mage.cards.s.SkitteringSkirge.class));
        cards.add(new SetCardInfo("Skyknight Legionnaire", 36296, Rarity.COMMON, mage.cards.s.SkyknightLegionnaire.class));
        cards.add(new SetCardInfo("Skyship Stalker", 62215, Rarity.RARE, mage.cards.s.SkyshipStalker.class));
        cards.add(new SetCardInfo("Skyship Weatherlight", 62381, Rarity.RARE, mage.cards.s.SkyshipWeatherlight.class));
        cards.add(new SetCardInfo("Slave of Bolas", 36180, Rarity.UNCOMMON, mage.cards.s.SlaveOfBolas.class));
        cards.add(new SetCardInfo("Slice and Dice", 32573, Rarity.UNCOMMON, mage.cards.s.SliceAndDice.class));
        cards.add(new SetCardInfo("Slith Firewalker", 35158, Rarity.UNCOMMON, mage.cards.s.SlithFirewalker.class));
        cards.add(new SetCardInfo("Sliver Queen", 26980, Rarity.RARE, mage.cards.s.SliverQueen.class));
        cards.add(new SetCardInfo("Smash to Smithereens", 59675, Rarity.COMMON, mage.cards.s.SmashToSmithereens.class));
        cards.add(new SetCardInfo("Smite the Monstrous", 55769, Rarity.COMMON, mage.cards.s.SmiteTheMonstrous.class));
        cards.add(new SetCardInfo("Smitten Swordmaster", 78766, Rarity.COMMON, mage.cards.s.SmittenSwordmaster.class));
        cards.add(new SetCardInfo("Smother", 31475, Rarity.UNCOMMON, mage.cards.s.Smother.class));
        cards.add(new SetCardInfo("Snap", 62441, Rarity.COMMON, mage.cards.s.Snap.class));
        cards.add(new SetCardInfo("Snapcaster Mage", 59685, Rarity.MYTHIC, mage.cards.s.SnapcasterMage.class));
        cards.add(new SetCardInfo("Sol Ring", 35944, Rarity.UNCOMMON, mage.cards.s.SolRing.class));
        cards.add(new SetCardInfo("Soltari Priest", 35054, Rarity.UNCOMMON, mage.cards.s.SoltariPriest.class));
        cards.add(new SetCardInfo("Sorin, Vengeful Bloodlord", 72277, Rarity.RARE, mage.cards.s.SorinVengefulBloodlord.class));
        cards.add(new SetCardInfo("Sorrow's Path", 36889, Rarity.RARE, mage.cards.s.SorrowsPath.class));
        cards.add(new SetCardInfo("Soul Collector", 36268, Rarity.RARE, mage.cards.s.SoulCollector.class));
        cards.add(new SetCardInfo("Soul of Theros", 62471, Rarity.MYTHIC, mage.cards.s.SoulOfTheros.class));
        cards.add(new SetCardInfo("Soul Summons", 55751, Rarity.COMMON, mage.cards.s.SoulSummons.class));
        cards.add(new SetCardInfo("Soul Swallower", 60460, Rarity.RARE, mage.cards.s.SoulSwallower.class));
        cards.add(new SetCardInfo("Sparksmith", 32569, Rarity.COMMON, mage.cards.s.Sparksmith.class));
        cards.add(new SetCardInfo("Spatial Contortion", 61555, Rarity.UNCOMMON, mage.cards.s.SpatialContortion.class));
        cards.add(new SetCardInfo("Spawn of Thraxes", 52320, Rarity.RARE, mage.cards.s.SpawnOfThraxes.class));
        cards.add(new SetCardInfo("Spellskite", 62533, Rarity.RARE, mage.cards.s.Spellskite.class));
        cards.add(new SetCardInfo("Spellstutter Sprite", 39622, Rarity.COMMON, mage.cards.s.SpellstutterSprite.class));
        cards.add(new SetCardInfo("Spike Feeder", 36082, Rarity.UNCOMMON, mage.cards.s.SpikeFeeder.class));
        cards.add(new SetCardInfo("Spiritmonger", 35976, Rarity.RARE, mage.cards.s.Spiritmonger.class));
        cards.add(new SetCardInfo("Sprouting Thrinax", 31451, Rarity.UNCOMMON, mage.cards.s.SproutingThrinax.class));
        cards.add(new SetCardInfo("Squadron Hawk", 39675, Rarity.COMMON, mage.cards.s.SquadronHawk.class));
        cards.add(new SetCardInfo("Squelching Leeches", 52330, Rarity.UNCOMMON, mage.cards.s.SquelchingLeeches.class, FULL_ART));
        cards.add(new SetCardInfo("Staff of Nin", 45213, Rarity.RARE, mage.cards.s.StaffOfNin.class));
        cards.add(new SetCardInfo("Staggershock", 36851, Rarity.COMMON, mage.cards.s.Staggershock.class, FULL_ART));
        cards.add(new SetCardInfo("Stasis Snare", 58275, Rarity.UNCOMMON, mage.cards.s.StasisSnare.class, FULL_ART));
        cards.add(new SetCardInfo("Stasis", 65648, Rarity.RARE, mage.cards.s.Stasis.class));
        cards.add(new SetCardInfo("Staunch Defenders", 36064, Rarity.UNCOMMON, mage.cards.s.StaunchDefenders.class));
        cards.add(new SetCardInfo("Stealer of Secrets", 52310, Rarity.COMMON, mage.cards.s.StealerOfSecrets.class));
        cards.add(new SetCardInfo("Steam Vents", 72307, Rarity.RARE, mage.cards.s.SteamVents.class, FULL_ART));
        cards.add(new SetCardInfo("Steel Hellkite", 37859, Rarity.RARE, mage.cards.s.SteelHellkite.class));
        cards.add(new SetCardInfo("Steel Leaf Champion", 68045, Rarity.RARE, mage.cards.s.SteelLeafChampion.class, FULL_ART));
        cards.add(new SetCardInfo("Sterling Grove", 62467, Rarity.UNCOMMON, mage.cards.s.SterlingGrove.class));
        cards.add(new SetCardInfo("Stifle", 43540, Rarity.RARE, mage.cards.s.Stifle.class));
        cards.add(new SetCardInfo("Stoke the Flames", 54553, Rarity.UNCOMMON, mage.cards.s.StokeTheFlames.class));
        cards.add(new SetCardInfo("Stomping Ground", 72313, Rarity.RARE, mage.cards.s.StompingGround.class, FULL_ART));
        cards.add(new SetCardInfo("Stone Haven Outfitter", 62495, Rarity.RARE, mage.cards.s.StoneHavenOutfitter.class));
        cards.add(new SetCardInfo("Stone Rain", 35946, Rarity.COMMON, mage.cards.s.StoneRain.class));
        cards.add(new SetCardInfo("Stone-Tongue Basilisk", 36238, Rarity.RARE, mage.cards.s.StoneTongueBasilisk.class));
        cards.add(new SetCardInfo("Stoneforge Mystic", 62499, Rarity.RARE, mage.cards.s.StoneforgeMystic.class));
        cards.add(new SetCardInfo("Storm Entity", 36020, Rarity.UNCOMMON, mage.cards.s.StormEntity.class));
        cards.add(new SetCardInfo("Strangleroot Geist", 43513, Rarity.UNCOMMON, mage.cards.s.StranglerootGeist.class, FULL_ART));
        cards.add(new SetCardInfo("Stroke of Genius", 36114, Rarity.RARE, mage.cards.s.StrokeOfGenius.class));
        cards.add(new SetCardInfo("Stunted Growth", 43642, Rarity.RARE, mage.cards.s.StuntedGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stunted Growth", 62425, Rarity.RARE, mage.cards.s.StuntedGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stupor", 36002, Rarity.UNCOMMON, mage.cards.s.Stupor.class));
        cards.add(new SetCardInfo("Sudden Shock", 36316, Rarity.UNCOMMON, mage.cards.s.SuddenShock.class));
        cards.add(new SetCardInfo("Sultai Ascendancy", 55701, Rarity.RARE, mage.cards.s.SultaiAscendancy.class));
        cards.add(new SetCardInfo("Sultai Charm", 54561, Rarity.UNCOMMON, mage.cards.s.SultaiCharm.class));
        cards.add(new SetCardInfo("Sultai Emissary", 55753, Rarity.COMMON, mage.cards.s.SultaiEmissary.class));
        cards.add(new SetCardInfo("Sun Titan", 37596, Rarity.MYTHIC, mage.cards.s.SunTitan.class));
        cards.add(new SetCardInfo("Sunscorch Regent", 55896, Rarity.RARE, mage.cards.s.SunscorchRegent.class));
        cards.add(new SetCardInfo("Supplant Form", 55723, Rarity.RARE, mage.cards.s.SupplantForm.class, FULL_ART));
        cards.add(new SetCardInfo("Supreme Verdict", 46879, Rarity.RARE, mage.cards.s.SupremeVerdict.class));
        cards.add(new SetCardInfo("Surgical Extraction", 40072, Rarity.RARE, mage.cards.s.SurgicalExtraction.class));
        cards.add(new SetCardInfo("Surging Flame", 35178, Rarity.COMMON, mage.cards.s.SurgingFlame.class));
        cards.add(new SetCardInfo("Survival of the Fittest", 43544, Rarity.RARE, mage.cards.s.SurvivalOfTheFittest.class));
        cards.add(new SetCardInfo("Suspension Field", 55876, Rarity.UNCOMMON, mage.cards.s.SuspensionField.class));
        cards.add(new SetCardInfo("Suture Priest", 40070, Rarity.COMMON, mage.cards.s.SuturePriest.class));
        cards.add(new SetCardInfo("Swamp", 235, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 253, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 257, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 265, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 275, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 287, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 299, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 31977, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 31999, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 32007, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 32021, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 40048, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 40058, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 40068, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 40092, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 53883, Rarity.LAND, mage.cards.basiclands.Swamp.class, FULL_ART));
        cards.add(new SetCardInfo("Swamp", 58257, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 73632, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of Feast and Famine", 52304, Rarity.MYTHIC, mage.cards.s.SwordOfFeastAndFamine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of Feast and Famine", 59683, Rarity.MYTHIC, mage.cards.s.SwordOfFeastAndFamine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of Fire and Ice", 39650, Rarity.RARE, mage.cards.s.SwordOfFireAndIce.class));
        cards.add(new SetCardInfo("Sword of Kaldra", 31987, Rarity.RARE, mage.cards.s.SwordOfKaldra.class));
        cards.add(new SetCardInfo("Swords to Plowshares", 31381, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class));
        cards.add(new SetCardInfo("Sylvan Caryatid", 50120, Rarity.RARE, mage.cards.s.SylvanCaryatid.class));
        cards.add(new SetCardInfo("Sylvan Library", 23948, Rarity.RARE, mage.cards.s.SylvanLibrary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sylvan Library", 43636, Rarity.RARE, mage.cards.s.SylvanLibrary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sylvan Ranger", 37592, Rarity.COMMON, mage.cards.s.SylvanRanger.class));
        cards.add(new SetCardInfo("Sylvan Scrying", 60476, Rarity.RARE, mage.cards.s.SylvanScrying.class));
        cards.add(new SetCardInfo("Taiga", 43618, Rarity.RARE, mage.cards.t.Taiga.class));
        cards.add(new SetCardInfo("Tamiyo, Collector of Tales", 72273, Rarity.RARE, mage.cards.t.TamiyoCollectorOfTales.class));
        cards.add(new SetCardInfo("Tawnos's Coffin", 23946, Rarity.RARE, mage.cards.t.TawnossCoffin.class));
        cards.add(new SetCardInfo("Tectonic Edge", 43069, Rarity.UNCOMMON, mage.cards.t.TectonicEdge.class));
        cards.add(new SetCardInfo("Teetering Peaks", 41654, Rarity.COMMON, mage.cards.t.TeeteringPeaks.class));
        cards.add(new SetCardInfo("Teferi, Time Raveler", 72233, Rarity.RARE, mage.cards.t.TeferiTimeRaveler.class));
        cards.add(new SetCardInfo("Tempered Steel", 37865, Rarity.RARE, mage.cards.t.TemperedSteel.class, FULL_ART));
        cards.add(new SetCardInfo("Temple Garden", 72303, Rarity.RARE, mage.cards.t.TempleGarden.class, FULL_ART));
        cards.add(new SetCardInfo("Temple of Mystery", 53846, Rarity.RARE, mage.cards.t.TempleOfMystery.class));
        cards.add(new SetCardInfo("Temple of the False God", 59653, Rarity.UNCOMMON, mage.cards.t.TempleOfTheFalseGod.class));
        cards.add(new SetCardInfo("Temporal Manipulation", 55725, Rarity.RARE, mage.cards.t.TemporalManipulation.class));
        cards.add(new SetCardInfo("Temur War Shaman", 55715, Rarity.RARE, mage.cards.t.TemurWarShaman.class));
        cards.add(new SetCardInfo("Tendrils of Agony", 31433, Rarity.UNCOMMON, mage.cards.t.TendrilsOfAgony.class));
        cards.add(new SetCardInfo("Terminate", 35136, Rarity.COMMON, mage.cards.t.Terminate.class, FULL_ART));
        cards.add(new SetCardInfo("Terminate", 36230, Rarity.COMMON, mage.cards.t.Terminate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terra Stomper", 36849, Rarity.RARE, mage.cards.t.TerraStomper.class));
        cards.add(new SetCardInfo("Terror", 31483, Rarity.COMMON, mage.cards.t.Terror.class, FULL_ART));
        cards.add(new SetCardInfo("Terror", 35948, Rarity.COMMON, mage.cards.t.Terror.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teyo, the Shieldmage", 72249, Rarity.UNCOMMON, mage.cards.t.TeyoTheShieldmage.class));
        cards.add(new SetCardInfo("Thalia, Guardian of Thraben", 55699, Rarity.RARE, mage.cards.t.ThaliaGuardianOfThraben.class));
        cards.add(new SetCardInfo("Thalia, Heretic Cathar", 61545, Rarity.RARE, mage.cards.t.ThaliaHereticCathar.class));
        cards.add(new SetCardInfo("Thawing Glaciers", 43564, Rarity.RARE, mage.cards.t.ThawingGlaciers.class));
        cards.add(new SetCardInfo("The Abyss", 46938, Rarity.RARE, mage.cards.t.TheAbyss.class));
        cards.add(new SetCardInfo("The Rack", 62385, Rarity.UNCOMMON, mage.cards.t.TheRack.class));
        cards.add(new SetCardInfo("The Royal Scions", 78854, Rarity.MYTHIC, mage.cards.t.TheRoyalScions.class));
        cards.add(new SetCardInfo("The Tabernacle at Pendrell Vale", 60450, Rarity.RARE, mage.cards.t.TheTabernacleAtPendrellVale.class));
        cards.add(new SetCardInfo("The Wanderer", 72267, Rarity.UNCOMMON, mage.cards.t.TheWanderer.class));
        cards.add(new SetCardInfo("Thirst for Knowledge", 31445, Rarity.UNCOMMON, mage.cards.t.ThirstForKnowledge.class));
        cards.add(new SetCardInfo("Thopter Assembly", 39638, Rarity.RARE, mage.cards.t.ThopterAssembly.class));
        cards.add(new SetCardInfo("Thran Golem", 62433, Rarity.UNCOMMON, mage.cards.t.ThranGolem.class));
        cards.add(new SetCardInfo("Thran Quarry", 36128, Rarity.RARE, mage.cards.t.ThranQuarry.class));
        cards.add(new SetCardInfo("Threads of Disloyalty", 70928, Rarity.RARE, mage.cards.t.ThreadsOfDisloyalty.class));
        cards.add(new SetCardInfo("Thunder Spirit", 229, Rarity.UNCOMMON, mage.cards.t.ThunderSpirit.class));
        cards.add(new SetCardInfo("Thunderbreak Regent", 55892, Rarity.RARE, mage.cards.t.ThunderbreakRegent.class, FULL_ART));
        cards.add(new SetCardInfo("Tibalt, Rakish Instigator", 72247, Rarity.UNCOMMON, mage.cards.t.TibaltRakishInstigator.class));
        cards.add(new SetCardInfo("Tidehollow Sculler", 43560, Rarity.UNCOMMON, mage.cards.t.TidehollowSculler.class));
        cards.add(new SetCardInfo("Tidings", 35076, Rarity.UNCOMMON, mage.cards.t.Tidings.class, FULL_ART));
        cards.add(new SetCardInfo("Time Spiral", 62221, Rarity.RARE, mage.cards.t.TimeSpiral.class));
        cards.add(new SetCardInfo("Time Walk", 46912, Rarity.RARE, mage.cards.t.TimeWalk.class));
        cards.add(new SetCardInfo("Time Warp", 36044, Rarity.RARE, mage.cards.t.TimeWarp.class));
        cards.add(new SetCardInfo("Time Wipe", 72219, Rarity.RARE, mage.cards.t.TimeWipe.class));
        cards.add(new SetCardInfo("Timetwister", 46918, Rarity.RARE, mage.cards.t.Timetwister.class));
        cards.add(new SetCardInfo("Tinder Wall", 62483, Rarity.COMMON, mage.cards.t.TinderWall.class));
        cards.add(new SetCardInfo("Titania's Song", 78860, Rarity.RARE, mage.cards.t.TitaniasSong.class));
        cards.add(new SetCardInfo("Tormented Hero", 51934, Rarity.UNCOMMON, mage.cards.t.TormentedHero.class));
        cards.add(new SetCardInfo("Tormented Soul", 41652, Rarity.COMMON, mage.cards.t.TormentedSoul.class));
        cards.add(new SetCardInfo("Tormod's Crypt", 31427, Rarity.UNCOMMON, mage.cards.t.TormodsCrypt.class));
        cards.add(new SetCardInfo("Tovolar's Magehunter", 43507, Rarity.RARE, mage.cards.t.TovolarsMagehunter.class));
        cards.add(new SetCardInfo("Tradewind Rider", 36048, Rarity.RARE, mage.cards.t.TradewindRider.class));
        cards.add(new SetCardInfo("Transmute Artifact", 65644, Rarity.RARE, mage.cards.t.TransmuteArtifact.class));
        cards.add(new SetCardInfo("Traxos, Scourge of Kroog", 69242, Rarity.RARE, mage.cards.t.TraxosScourgeOfKroog.class));
        cards.add(new SetCardInfo("Treasure Hunt", 39632, Rarity.COMMON, mage.cards.t.TreasureHunt.class, FULL_ART));
        cards.add(new SetCardInfo("Treasure Mage", 39642, Rarity.UNCOMMON, mage.cards.t.TreasureMage.class, FULL_ART));
        cards.add(new SetCardInfo("Treasury Thrull", 47999, Rarity.RARE, mage.cards.t.TreasuryThrull.class));
        cards.add(new SetCardInfo("Treetop Village", 31403, Rarity.UNCOMMON, mage.cards.t.TreetopVillage.class));
        cards.add(new SetCardInfo("Treva, the Renewer", 36158, Rarity.RARE, mage.cards.t.TrevaTheRenewer.class));
        cards.add(new SetCardInfo("Triumph of Ferocity", 62475, Rarity.UNCOMMON, mage.cards.t.TriumphOfFerocity.class));
        cards.add(new SetCardInfo("Tromokratis", 51914, Rarity.RARE, mage.cards.t.Tromokratis.class));
        cards.add(new SetCardInfo("Trophy Mage", 63003, Rarity.UNCOMMON, mage.cards.t.TrophyMage.class, FULL_ART));
        cards.add(new SetCardInfo("Tropical Island", 43620, Rarity.RARE, mage.cards.t.TropicalIsland.class));
        cards.add(new SetCardInfo("Trostani's Summoner", 48574, Rarity.UNCOMMON, mage.cards.t.TrostanisSummoner.class, FULL_ART));
        cards.add(new SetCardInfo("True Conviction", 77951, Rarity.RARE, mage.cards.t.TrueConviction.class));
        cards.add(new SetCardInfo("True-Name Nemesis", 69268, Rarity.RARE, mage.cards.t.TrueNameNemesis.class));
        cards.add(new SetCardInfo("Trueheart Duelist", 64424, Rarity.UNCOMMON, mage.cards.t.TrueheartDuelist.class, FULL_ART));
        cards.add(new SetCardInfo("Tuinvale Treefolk", 78818, Rarity.COMMON, mage.cards.t.TuinvaleTreefolk.class));
        cards.add(new SetCardInfo("Tundra", 43622, Rarity.RARE, mage.cards.t.Tundra.class));
        cards.add(new SetCardInfo("Twilight Mire", 62455, Rarity.RARE, mage.cards.t.TwilightMire.class));
        cards.add(new SetCardInfo("Two-Headed Dragon", 36156, Rarity.RARE, mage.cards.t.TwoHeadedDragon.class));
        cards.add(new SetCardInfo("Two-Headed Giant of Foriys", 211, Rarity.RARE, mage.cards.t.TwoHeadedGiantOfForiys.class));
        cards.add(new SetCardInfo("Tyrant of Valakut", 59657, Rarity.RARE, mage.cards.t.TyrantOfValakut.class));
        cards.add(new SetCardInfo("Ugin's Construct", 55761, Rarity.UNCOMMON, mage.cards.u.UginsConstruct.class));
        cards.add(new SetCardInfo("Ugin, the Ineffable", 72235, Rarity.RARE, mage.cards.u.UginTheIneffable.class));
        cards.add(new SetCardInfo("Ugin, the Spirit Dragon", 55763, Rarity.MYTHIC, mage.cards.u.UginTheSpiritDragon.class));
        cards.add(new SetCardInfo("Uktabi Orangutan", 36016, Rarity.UNCOMMON, mage.cards.u.UktabiOrangutan.class));
        cards.add(new SetCardInfo("Ultimate Price", 58269, Rarity.UNCOMMON, mage.cards.u.UltimatePrice.class));
        cards.add(new SetCardInfo("Ulvenwald Observer", 61553, Rarity.RARE, mage.cards.u.UlvenwaldObserver.class));
        cards.add(new SetCardInfo("Umezawa's Jitte", 36210, Rarity.RARE, mage.cards.u.UmezawasJitte.class));
        cards.add(new SetCardInfo("Underground Sea", 43624, Rarity.RARE, mage.cards.u.UndergroundSea.class));
        cards.add(new SetCardInfo("Underworld Dreams", 35970, Rarity.RARE, mage.cards.u.UnderworldDreams.class));
        cards.add(new SetCardInfo("Undiscovered Paradise", 61062, Rarity.RARE, mage.cards.u.UndiscoveredParadise.class));
        cards.add(new SetCardInfo("Unlicensed Disintegration", 64430, Rarity.UNCOMMON, mage.cards.u.UnlicensedDisintegration.class));
        cards.add(new SetCardInfo("Unmake", 32551, Rarity.COMMON, mage.cards.u.Unmake.class, FULL_ART));
        cards.add(new SetCardInfo("Unsubstantiate", 61557, Rarity.RARE, mage.cards.u.Unsubstantiate.class, FULL_ART));
        cards.add(new SetCardInfo("Urza's Factory", 31493, Rarity.UNCOMMON, mage.cards.u.UrzasFactory.class, FULL_ART));
        cards.add(new SetCardInfo("Urza's Mine", 69262, Rarity.COMMON, mage.cards.u.UrzasMine.class));
        cards.add(new SetCardInfo("Urza's Power Plant", 69264, Rarity.COMMON, mage.cards.u.UrzasPowerPlant.class));
        cards.add(new SetCardInfo("Urza's Tower", 69266, Rarity.COMMON, mage.cards.u.UrzasTower.class));
        cards.add(new SetCardInfo("Utter End", 54563, Rarity.RARE, mage.cards.u.UtterEnd.class, FULL_ART));
        cards.add(new SetCardInfo("Valakut, the Molten Pinnacle", 35142, Rarity.RARE, mage.cards.v.ValakutTheMoltenPinnacle.class));
        cards.add(new SetCardInfo("Valorous Stance", 57582, Rarity.UNCOMMON, mage.cards.v.ValorousStance.class));
        cards.add(new SetCardInfo("Vampire Nighthawk", 36214, Rarity.UNCOMMON, mage.cards.v.VampireNighthawk.class));
        cards.add(new SetCardInfo("Vampire Nocturnus", 33105, Rarity.MYTHIC, mage.cards.v.VampireNocturnus.class));
        cards.add(new SetCardInfo("Vampiric Tutor", 36018, Rarity.RARE, mage.cards.v.VampiricTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vampiric Tutor", 68053, Rarity.RARE, mage.cards.v.VampiricTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vault Skirge", 40076, Rarity.COMMON, mage.cards.v.VaultSkirge.class));
        cards.add(new SetCardInfo("Vendilion Clique", 39628, Rarity.RARE, mage.cards.v.VendilionClique.class));
        cards.add(new SetCardInfo("Vengevine", 49844, Rarity.MYTHIC, mage.cards.v.Vengevine.class));
        cards.add(new SetCardInfo("Vexing Shusher", 32533, Rarity.RARE, mage.cards.v.VexingShusher.class));
        cards.add(new SetCardInfo("Vindicate", 31391, Rarity.RARE, mage.cards.v.Vindicate.class));
        cards.add(new SetCardInfo("Vivien, Champion of the Wilds", 72279, Rarity.RARE, mage.cards.v.VivienChampionOfTheWilds.class));
        cards.add(new SetCardInfo("Voidmage Prodigy", 43646, Rarity.RARE, mage.cards.v.VoidmageProdigy.class));
        cards.add(new SetCardInfo("Voidslime", 36310, Rarity.RARE, mage.cards.v.Voidslime.class, FULL_ART));
        cards.add(new SetCardInfo("Volcanic Fallout", 43570, Rarity.UNCOMMON, mage.cards.v.VolcanicFallout.class, FULL_ART));
        cards.add(new SetCardInfo("Volcanic Geyser", 36004, Rarity.UNCOMMON, mage.cards.v.VolcanicGeyser.class));
        cards.add(new SetCardInfo("Volcanic Hammer", 36102, Rarity.COMMON, mage.cards.v.VolcanicHammer.class));
        cards.add(new SetCardInfo("Volcanic Island", 43626, Rarity.RARE, mage.cards.v.VolcanicIsland.class));
        cards.add(new SetCardInfo("Vraska, Swarm's Eminence", 72289, Rarity.UNCOMMON, mage.cards.v.VraskaSwarmsEminence.class));
        cards.add(new SetCardInfo("Walk the Plank", 65666, Rarity.UNCOMMON, mage.cards.w.WalkThePlank.class, FULL_ART));
        cards.add(new SetCardInfo("Walking Ballista", 69991, Rarity.RARE, mage.cards.w.WalkingBallista.class));
        cards.add(new SetCardInfo("Wall of Blossoms", 36084, Rarity.UNCOMMON, mage.cards.w.WallOfBlossoms.class));
        cards.add(new SetCardInfo("Wall of Omens", 39624, Rarity.UNCOMMON, mage.cards.w.WallOfOmens.class));
        cards.add(new SetCardInfo("Wall of Roots", 35114, Rarity.COMMON, mage.cards.w.WallOfRoots.class));
        cards.add(new SetCardInfo("Warleader's Helix", 51540, Rarity.UNCOMMON, mage.cards.w.WarleadersHelix.class));
        cards.add(new SetCardInfo("Warmonger", 36152, Rarity.UNCOMMON, mage.cards.w.Warmonger.class));
        cards.add(new SetCardInfo("Wasteland", 36877, Rarity.UNCOMMON, mage.cards.w.Wasteland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wasteland", 55874, Rarity.UNCOMMON, mage.cards.w.Wasteland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Watcher of the Roost", 55773, Rarity.UNCOMMON, mage.cards.w.WatcherOfTheRoost.class));
        cards.add(new SetCardInfo("Watchwolf", 36196, Rarity.UNCOMMON, mage.cards.w.Watchwolf.class));
        cards.add(new SetCardInfo("Watery Grave", 72299, Rarity.RARE, mage.cards.w.WateryGrave.class, FULL_ART));
        cards.add(new SetCardInfo("Wave of Reckoning", 62515, Rarity.RARE, mage.cards.w.WaveOfReckoning.class));
        cards.add(new SetCardInfo("Wee Dragonauts", 35174, Rarity.COMMON, mage.cards.w.WeeDragonauts.class));
        cards.add(new SetCardInfo("Wheel and Deal", 62411, Rarity.RARE, mage.cards.w.WheelAndDeal.class));
        cards.add(new SetCardInfo("Wheel of Fortune", 36879, Rarity.RARE, mage.cards.w.WheelOfFortune.class));
        cards.add(new SetCardInfo("Whip of Erebos", 55733, Rarity.RARE, mage.cards.w.WhipOfErebos.class));
        cards.add(new SetCardInfo("Whipcorder", 36250, Rarity.UNCOMMON, mage.cards.w.Whipcorder.class));
        cards.add(new SetCardInfo("Whirling Dervish", 35056, Rarity.UNCOMMON, mage.cards.w.WhirlingDervish.class));
        cards.add(new SetCardInfo("White Knight", 35950, Rarity.UNCOMMON, mage.cards.w.WhiteKnight.class));
        cards.add(new SetCardInfo("Wild Mongrel", 36240, Rarity.COMMON, mage.cards.w.WildMongrel.class));
        cards.add(new SetCardInfo("Wild Nacatl", 37851, Rarity.COMMON, mage.cards.w.WildNacatl.class));
        cards.add(new SetCardInfo("Wild Pair", 62419, Rarity.RARE, mage.cards.w.WildPair.class));
        cards.add(new SetCardInfo("Wildcall", 55749, Rarity.RARE, mage.cards.w.Wildcall.class));
        cards.add(new SetCardInfo("Wildfire Eternal", 64989, Rarity.RARE, mage.cards.w.WildfireEternal.class));
        cards.add(new SetCardInfo("Willbender", 36258, Rarity.UNCOMMON, mage.cards.w.Willbender.class));
        cards.add(new SetCardInfo("Wilt-Leaf Cavaliers", 31441, Rarity.UNCOMMON, mage.cards.w.WiltLeafCavaliers.class));
        cards.add(new SetCardInfo("Windfall", 62529, Rarity.UNCOMMON, mage.cards.w.Windfall.class));
        cards.add(new SetCardInfo("Windseeker Centaur", 35966, Rarity.RARE, mage.cards.w.WindseekerCentaur.class));
        cards.add(new SetCardInfo("Windswept Heath", 43586, Rarity.RARE, mage.cards.w.WindsweptHeath.class));
        cards.add(new SetCardInfo("Wing Shards", 35156, Rarity.UNCOMMON, mage.cards.w.WingShards.class));
        cards.add(new SetCardInfo("Winter Orb", 46922, Rarity.RARE, mage.cards.w.WinterOrb.class));
        cards.add(new SetCardInfo("Withered Wretch", 36262, Rarity.UNCOMMON, mage.cards.w.WitheredWretch.class));
        cards.add(new SetCardInfo("Wonder", 35154, Rarity.UNCOMMON, mage.cards.w.Wonder.class));
        cards.add(new SetCardInfo("Wood Elves", 36094, Rarity.COMMON, mage.cards.w.WoodElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wood Elves", 62527, Rarity.COMMON, mage.cards.w.WoodElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wooded Foothills", 43584, Rarity.RARE, mage.cards.w.WoodedFoothills.class));
        cards.add(new SetCardInfo("Woolly Thoctar", 31449, Rarity.UNCOMMON, mage.cards.w.WoollyThoctar.class));
        cards.add(new SetCardInfo("Worship", 77955, Rarity.RARE, mage.cards.w.Worship.class));
        cards.add(new SetCardInfo("Wrath of God", 35048, Rarity.RARE, mage.cards.w.WrathOfGod.class, FULL_ART));
        cards.add(new SetCardInfo("Wren's Run Packmaster", 31965, Rarity.RARE, mage.cards.w.WrensRunPackmaster.class));
        cards.add(new SetCardInfo("Wren's Run Vanquisher", 36138, Rarity.UNCOMMON, mage.cards.w.WrensRunVanquisher.class));
        cards.add(new SetCardInfo("Write into Being", 55755, Rarity.COMMON, mage.cards.w.WriteIntoBeing.class));
        cards.add(new SetCardInfo("Wurmcoil Engine", 37861, Rarity.MYTHIC, mage.cards.w.WurmcoilEngine.class));
        cards.add(new SetCardInfo("Xathrid Gorgon", 45205, Rarity.RARE, mage.cards.x.XathridGorgon.class));
        cards.add(new SetCardInfo("Xathrid Necromancer", 52312, Rarity.RARE, mage.cards.x.XathridNecromancer.class));
        cards.add(new SetCardInfo("Yahenni's Expertise", 62989, Rarity.RARE, mage.cards.y.YahennisExpertise.class, FULL_ART));
        cards.add(new SetCardInfo("Yawgmoth's Will", 35080, Rarity.RARE, mage.cards.y.YawgmothsWill.class));
        cards.add(new SetCardInfo("Yixlid Jailer", 36068, Rarity.UNCOMMON, mage.cards.y.YixlidJailer.class));
        cards.add(new SetCardInfo("Zahid, Djinn of the Lamp", 68041, Rarity.RARE, mage.cards.z.ZahidDjinnOfTheLamp.class));
        cards.add(new SetCardInfo("Zameck Guildmage", 47987, Rarity.UNCOMMON, mage.cards.z.ZameckGuildmage.class, FULL_ART));
        cards.add(new SetCardInfo("Zhalfirin Void", 68043, Rarity.UNCOMMON, mage.cards.z.ZhalfirinVoid.class));
        cards.add(new SetCardInfo("Zodiac Dog", 35102, Rarity.COMMON, mage.cards.z.ZodiacDog.class));
        cards.add(new SetCardInfo("Zodiac Goat", 35098, Rarity.COMMON, mage.cards.z.ZodiacGoat.class));
        cards.add(new SetCardInfo("Zodiac Horse", 35090, Rarity.UNCOMMON, mage.cards.z.ZodiacHorse.class));
        cards.add(new SetCardInfo("Zodiac Monkey", 35084, Rarity.COMMON, mage.cards.z.ZodiacMonkey.class));
        cards.add(new SetCardInfo("Zodiac Ox", 35092, Rarity.UNCOMMON, mage.cards.z.ZodiacOx.class));
        cards.add(new SetCardInfo("Zodiac Pig", 35100, Rarity.UNCOMMON, mage.cards.z.ZodiacPig.class));
        cards.add(new SetCardInfo("Zodiac Rabbit", 35086, Rarity.COMMON, mage.cards.z.ZodiacRabbit.class));
        cards.add(new SetCardInfo("Zodiac Rat", 35094, Rarity.COMMON, mage.cards.z.ZodiacRat.class));
        cards.add(new SetCardInfo("Zodiac Rooster", 35082, Rarity.COMMON, mage.cards.z.ZodiacRooster.class));
        cards.add(new SetCardInfo("Zodiac Snake", 35096, Rarity.COMMON, mage.cards.z.ZodiacSnake.class));
        cards.add(new SetCardInfo("Zodiac Tiger", 35088, Rarity.UNCOMMON, mage.cards.z.ZodiacTiger.class));
        cards.add(new SetCardInfo("Zoetic Cavern", 36066, Rarity.UNCOMMON, mage.cards.z.ZoeticCavern.class));
        cards.add(new SetCardInfo("Zombie Apocalypse", 43515, Rarity.RARE, mage.cards.z.ZombieApocalypse.class, FULL_ART));
        cards.add(new SetCardInfo("Zombify", 35170, Rarity.UNCOMMON, mage.cards.z.Zombify.class, FULL_ART));
        cards.add(new SetCardInfo("Zuran Orb", 225, Rarity.UNCOMMON, mage.cards.z.ZuranOrb.class));
        cards.add(new SetCardInfo("Zurgo Helmsmasher", 54549, Rarity.MYTHIC, mage.cards.z.ZurgoHelmsmasher.class));
    }
}
