package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

import java.util.List;

/**
 * https://scryfall.com/sets/klr
 */
public class KaladeshRemastered extends ExpansionSet {

    private static final KaladeshRemastered instance = new KaladeshRemastered();

    public static KaladeshRemastered getInstance() {
        return instance;
    }

    private KaladeshRemastered() {
        super("Kaladesh Remastered", "KLR", ExpansionSet.buildDate(2020, 11, 12), SetType.MAGIC_ARENA);
        this.hasBoosters = true;
        this.hasBasicLands = true;
        this.maxCardNumberInBooster = 301;
        this.numBoosterLands = 1;
        this.numBoosterCommon = 10;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 8;

        cards.add(new SetCardInfo("Aerial Responder", 1, Rarity.UNCOMMON, mage.cards.a.AerialResponder.class));
        cards.add(new SetCardInfo("Aeronaut Admiral", 2, Rarity.UNCOMMON, mage.cards.a.AeronautAdmiral.class));
        cards.add(new SetCardInfo("Aether Chaser", 113, Rarity.COMMON, mage.cards.a.AetherChaser.class));
        cards.add(new SetCardInfo("Aether Hub", 279, Rarity.UNCOMMON, mage.cards.a.AetherHub.class));
        cards.add(new SetCardInfo("Aether Inspector", 3, Rarity.COMMON, mage.cards.a.AetherInspector.class));
        cards.add(new SetCardInfo("Aether Meltdown", 38, Rarity.UNCOMMON, mage.cards.a.AetherMeltdown.class));
        cards.add(new SetCardInfo("Aether Poisoner", 75, Rarity.COMMON, mage.cards.a.AetherPoisoner.class));
        cards.add(new SetCardInfo("Aether Swooper", 39, Rarity.COMMON, mage.cards.a.AetherSwooper.class));
        cards.add(new SetCardInfo("Aether Theorist", 40, Rarity.COMMON, mage.cards.a.AetherTheorist.class));
        cards.add(new SetCardInfo("Aether Tradewinds", 41, Rarity.COMMON, mage.cards.a.AetherTradewinds.class));
        cards.add(new SetCardInfo("Aetherborn Marauder", 76, Rarity.UNCOMMON, mage.cards.a.AetherbornMarauder.class));
        cards.add(new SetCardInfo("Aetherflux Reservoir", 217, Rarity.RARE, mage.cards.a.AetherfluxReservoir.class));
        cards.add(new SetCardInfo("Aethersphere Harvester", 218, Rarity.RARE, mage.cards.a.AethersphereHarvester.class));
        cards.add(new SetCardInfo("Aetherstorm Roc", 4, Rarity.RARE, mage.cards.a.AetherstormRoc.class));
        cards.add(new SetCardInfo("Aethertorch Renegade", 114, Rarity.UNCOMMON, mage.cards.a.AethertorchRenegade.class));
        cards.add(new SetCardInfo("Aetherworks Marvel", 219, Rarity.MYTHIC, mage.cards.a.AetherworksMarvel.class));
        cards.add(new SetCardInfo("Airdrop Aeronauts", 5, Rarity.UNCOMMON, mage.cards.a.AirdropAeronauts.class));
        cards.add(new SetCardInfo("Ajani Unyielding", 188, Rarity.MYTHIC, mage.cards.a.AjaniUnyielding.class));
        cards.add(new SetCardInfo("Alley Evasion", 6, Rarity.COMMON, mage.cards.a.AlleyEvasion.class));
        cards.add(new SetCardInfo("Alley Strangler", 77, Rarity.COMMON, mage.cards.a.AlleyStrangler.class));
        cards.add(new SetCardInfo("Angel of Invention", 7, Rarity.MYTHIC, mage.cards.a.AngelOfInvention.class));
        cards.add(new SetCardInfo("Animation Module", 220, Rarity.RARE, mage.cards.a.AnimationModule.class));
        cards.add(new SetCardInfo("Appetite for the Unnatural", 151, Rarity.COMMON, mage.cards.a.AppetiteForTheUnnatural.class));
        cards.add(new SetCardInfo("Arborback Stomper", 152, Rarity.UNCOMMON, mage.cards.a.ArborbackStomper.class));
        cards.add(new SetCardInfo("Armorcraft Judge", 153, Rarity.UNCOMMON, mage.cards.a.ArmorcraftJudge.class));
        cards.add(new SetCardInfo("Attune with Aether", 154, Rarity.COMMON, mage.cards.a.AttuneWithAether.class));
        cards.add(new SetCardInfo("Audacious Infiltrator", 8, Rarity.COMMON, mage.cards.a.AudaciousInfiltrator.class));
        cards.add(new SetCardInfo("Authority of the Consuls", 9, Rarity.RARE, mage.cards.a.AuthorityOfTheConsuls.class));
        cards.add(new SetCardInfo("Aviary Mechanic", 10, Rarity.COMMON, mage.cards.a.AviaryMechanic.class));
        cards.add(new SetCardInfo("Ballista Charger", 221, Rarity.UNCOMMON, mage.cards.b.BallistaCharger.class));
        cards.add(new SetCardInfo("Baral's Expertise", 43, Rarity.RARE, mage.cards.b.BaralsExpertise.class));
        cards.add(new SetCardInfo("Baral, Chief of Compliance", 42, Rarity.RARE, mage.cards.b.BaralChiefOfCompliance.class));
        cards.add(new SetCardInfo("Barricade Breaker", 222, Rarity.UNCOMMON, mage.cards.b.BarricadeBreaker.class));
        cards.add(new SetCardInfo("Bastion Mastodon", 223, Rarity.COMMON, mage.cards.b.BastionMastodon.class));
        cards.add(new SetCardInfo("Blooming Marsh", 280, Rarity.RARE, mage.cards.b.BloomingMarsh.class));
        cards.add(new SetCardInfo("Blossoming Defense", 155, Rarity.UNCOMMON, mage.cards.b.BlossomingDefense.class));
        cards.add(new SetCardInfo("Bomat Bazaar Barge", 224, Rarity.UNCOMMON, mage.cards.b.BomatBazaarBarge.class));
        cards.add(new SetCardInfo("Bomat Courier", 225, Rarity.RARE, mage.cards.b.BomatCourier.class));
        cards.add(new SetCardInfo("Botanical Sanctum", 281, Rarity.RARE, mage.cards.b.BotanicalSanctum.class));
        cards.add(new SetCardInfo("Bristling Hydra", 156, Rarity.RARE, mage.cards.b.BristlingHydra.class));
        cards.add(new SetCardInfo("Built to Last", 11, Rarity.COMMON, mage.cards.b.BuiltToLast.class));
        cards.add(new SetCardInfo("Built to Smash", 115, Rarity.COMMON, mage.cards.b.BuiltToSmash.class));
        cards.add(new SetCardInfo("Cataclysmic Gearhulk", 12, Rarity.MYTHIC, mage.cards.c.CataclysmicGearhulk.class));
        cards.add(new SetCardInfo("Cathartic Reunion", 116, Rarity.COMMON, mage.cards.c.CatharticReunion.class));
        cards.add(new SetCardInfo("Ceremonious Rejection", 44, Rarity.UNCOMMON, mage.cards.c.CeremoniousRejection.class));
        cards.add(new SetCardInfo("Chandra's Pyrohelix", 118, Rarity.COMMON, mage.cards.c.ChandrasPyrohelix.class));
        cards.add(new SetCardInfo("Chandra's Revolution", 119, Rarity.COMMON, mage.cards.c.ChandrasRevolution.class));
        cards.add(new SetCardInfo("Chandra, Torch of Defiance", 117, Rarity.MYTHIC, mage.cards.c.ChandraTorchOfDefiance.class));
        cards.add(new SetCardInfo("Chief of the Foundry", 226, Rarity.UNCOMMON, mage.cards.c.ChiefOfTheFoundry.class));
        cards.add(new SetCardInfo("Cloudblazer", 189, Rarity.UNCOMMON, mage.cards.c.Cloudblazer.class));
        cards.add(new SetCardInfo("Cogworker's Puzzleknot", 227, Rarity.COMMON, mage.cards.c.CogworkersPuzzleknot.class));
        cards.add(new SetCardInfo("Combustible Gearhulk", 120, Rarity.MYTHIC, mage.cards.c.CombustibleGearhulk.class));
        cards.add(new SetCardInfo("Commencement of Festivities", 157, Rarity.COMMON, mage.cards.c.CommencementOfFestivities.class));
        cards.add(new SetCardInfo("Concealed Courtyard", 282, Rarity.RARE, mage.cards.c.ConcealedCourtyard.class));
        cards.add(new SetCardInfo("Confiscation Coup", 45, Rarity.RARE, mage.cards.c.ConfiscationCoup.class));
        cards.add(new SetCardInfo("Consulate Skygate", 228, Rarity.COMMON, mage.cards.c.ConsulateSkygate.class));
        cards.add(new SetCardInfo("Consulate Turret", 229, Rarity.COMMON, mage.cards.c.ConsulateTurret.class));
        cards.add(new SetCardInfo("Contraband Kingpin", 190, Rarity.UNCOMMON, mage.cards.c.ContrabandKingpin.class));
        cards.add(new SetCardInfo("Conviction", 13, Rarity.COMMON, mage.cards.c.Conviction.class));
        cards.add(new SetCardInfo("Countless Gears Renegade", 14, Rarity.COMMON, mage.cards.c.CountlessGearsRenegade.class));
        cards.add(new SetCardInfo("Creeping Mold", 158, Rarity.UNCOMMON, mage.cards.c.CreepingMold.class));
        cards.add(new SetCardInfo("Cultivator's Caravan", 230, Rarity.RARE, mage.cards.c.CultivatorsCaravan.class));
        cards.add(new SetCardInfo("Daredevil Dragster", 231, Rarity.UNCOMMON, mage.cards.d.DaredevilDragster.class));
        cards.add(new SetCardInfo("Daring Demolition", 78, Rarity.COMMON, mage.cards.d.DaringDemolition.class));
        cards.add(new SetCardInfo("Dark Intimations", 191, Rarity.RARE, mage.cards.d.DarkIntimations.class));
        cards.add(new SetCardInfo("Dawnfeather Eagle", 15, Rarity.COMMON, mage.cards.d.DawnfeatherEagle.class));
        cards.add(new SetCardInfo("Decoction Module", 232, Rarity.UNCOMMON, mage.cards.d.DecoctionModule.class));
        cards.add(new SetCardInfo("Defiant Salvager", 79, Rarity.COMMON, mage.cards.d.DefiantSalvager.class));
        cards.add(new SetCardInfo("Demolition Stomper", 233, Rarity.UNCOMMON, mage.cards.d.DemolitionStomper.class));
        cards.add(new SetCardInfo("Demon of Dark Schemes", 80, Rarity.MYTHIC, mage.cards.d.DemonOfDarkSchemes.class));
        cards.add(new SetCardInfo("Depala, Pilot Exemplar", 192, Rarity.RARE, mage.cards.d.DepalaPilotExemplar.class));
        cards.add(new SetCardInfo("Destructive Tampering", 121, Rarity.COMMON, mage.cards.d.DestructiveTampering.class));
        cards.add(new SetCardInfo("Die Young", 81, Rarity.COMMON, mage.cards.d.DieYoung.class));
        cards.add(new SetCardInfo("Disallow", 46, Rarity.RARE, mage.cards.d.Disallow.class));
        cards.add(new SetCardInfo("Dovin Baan", 193, Rarity.MYTHIC, mage.cards.d.DovinBaan.class));
        cards.add(new SetCardInfo("Druid of the Cowl", 159, Rarity.COMMON, mage.cards.d.DruidOfTheCowl.class));
        cards.add(new SetCardInfo("Dukhara Peafowl", 234, Rarity.COMMON, mage.cards.d.DukharaPeafowl.class));
        cards.add(new SetCardInfo("Dynavolt Tower", 235, Rarity.RARE, mage.cards.d.DynavoltTower.class));
        cards.add(new SetCardInfo("Eager Construct", 236, Rarity.COMMON, mage.cards.e.EagerConstruct.class));
        cards.add(new SetCardInfo("Eddytrail Hawk", 16, Rarity.COMMON, mage.cards.e.EddytrailHawk.class));
        cards.add(new SetCardInfo("Electrostatic Pummeler", 237, Rarity.RARE, mage.cards.e.ElectrostaticPummeler.class));
        cards.add(new SetCardInfo("Embraal Bruiser", 82, Rarity.UNCOMMON, mage.cards.e.EmbraalBruiser.class));
        cards.add(new SetCardInfo("Empyreal Voyager", 194, Rarity.UNCOMMON, mage.cards.e.EmpyrealVoyager.class));
        cards.add(new SetCardInfo("Engineered Might", 195, Rarity.UNCOMMON, mage.cards.e.EngineeredMight.class));
        cards.add(new SetCardInfo("Enraged Giant", 122, Rarity.UNCOMMON, mage.cards.e.EnragedGiant.class));
        cards.add(new SetCardInfo("Era of Innovation", 47, Rarity.UNCOMMON, mage.cards.e.EraOfInnovation.class));
        cards.add(new SetCardInfo("Essence Extraction", 83, Rarity.UNCOMMON, mage.cards.e.EssenceExtraction.class));
        cards.add(new SetCardInfo("Fabrication Module", 238, Rarity.UNCOMMON, mage.cards.f.FabricationModule.class));
        cards.add(new SetCardInfo("Fairgrounds Warden", 17, Rarity.UNCOMMON, mage.cards.f.FairgroundsWarden.class));
        cards.add(new SetCardInfo("Fatal Push", 84, Rarity.UNCOMMON, mage.cards.f.FatalPush.class));
        cards.add(new SetCardInfo("Fateful Showdown", 123, Rarity.RARE, mage.cards.f.FatefulShowdown.class));
        cards.add(new SetCardInfo("Fen Hauler", 85, Rarity.COMMON, mage.cards.f.FenHauler.class));
        cards.add(new SetCardInfo("Filigree Familiar", 239, Rarity.UNCOMMON, mage.cards.f.FiligreeFamiliar.class));
        cards.add(new SetCardInfo("Fireforger's Puzzleknot", 240, Rarity.COMMON, mage.cards.f.FireforgersPuzzleknot.class));
        cards.add(new SetCardInfo("Forest", 299, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 300, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 301, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fortuitous Find", 86, Rarity.COMMON, mage.cards.f.FortuitousFind.class));
        cards.add(new SetCardInfo("Foundry Hornet", 87, Rarity.UNCOMMON, mage.cards.f.FoundryHornet.class));
        cards.add(new SetCardInfo("Foundry Inspector", 241, Rarity.UNCOMMON, mage.cards.f.FoundryInspector.class));
        cards.add(new SetCardInfo("Foundry Screecher", 88, Rarity.COMMON, mage.cards.f.FoundryScreecher.class));
        cards.add(new SetCardInfo("Fourth Bridge Prowler", 89, Rarity.COMMON, mage.cards.f.FourthBridgeProwler.class));
        cards.add(new SetCardInfo("Fragmentize", 18, Rarity.COMMON, mage.cards.f.Fragmentize.class));
        cards.add(new SetCardInfo("Freejam Regent", 124, Rarity.RARE, mage.cards.f.FreejamRegent.class));
        cards.add(new SetCardInfo("Fretwork Colony", 90, Rarity.UNCOMMON, mage.cards.f.FretworkColony.class));
        cards.add(new SetCardInfo("Frontline Rebel", 125, Rarity.COMMON, mage.cards.f.FrontlineRebel.class));
        cards.add(new SetCardInfo("Fumigate", 19, Rarity.RARE, mage.cards.f.Fumigate.class));
        cards.add(new SetCardInfo("Furious Reprisal", 126, Rarity.UNCOMMON, mage.cards.f.FuriousReprisal.class));
        cards.add(new SetCardInfo("Gearseeker Serpent", 48, Rarity.COMMON, mage.cards.g.GearseekerSerpent.class));
        cards.add(new SetCardInfo("Gearshift Ace", 20, Rarity.UNCOMMON, mage.cards.g.GearshiftAce.class));
        cards.add(new SetCardInfo("Gifted Aetherborn", 91, Rarity.UNCOMMON, mage.cards.g.GiftedAetherborn.class));
        cards.add(new SetCardInfo("Glimmer of Genius", 49, Rarity.UNCOMMON, mage.cards.g.GlimmerOfGenius.class));
        cards.add(new SetCardInfo("Glint-Nest Crane", 50, Rarity.UNCOMMON, mage.cards.g.GlintNestCrane.class));
        cards.add(new SetCardInfo("Glint-Sleeve Artisan", 21, Rarity.COMMON, mage.cards.g.GlintSleeveArtisan.class));
        cards.add(new SetCardInfo("Glint-Sleeve Siphoner", 92, Rarity.RARE, mage.cards.g.GlintSleeveSiphoner.class));
        cards.add(new SetCardInfo("Gonti, Lord of Luxury", 93, Rarity.RARE, mage.cards.g.GontiLordOfLuxury.class));
        cards.add(new SetCardInfo("Greenbelt Rampager", 160, Rarity.RARE, mage.cards.g.GreenbeltRampager.class));
        cards.add(new SetCardInfo("Harnessed Lightning", 127, Rarity.UNCOMMON, mage.cards.h.HarnessedLightning.class));
        cards.add(new SetCardInfo("Hazardous Conditions", 196, Rarity.UNCOMMON, mage.cards.h.HazardousConditions.class));
        cards.add(new SetCardInfo("Heart of Kiran", 242, Rarity.MYTHIC, mage.cards.h.HeartOfKiran.class));
        cards.add(new SetCardInfo("Herald of Anguish", 94, Rarity.MYTHIC, mage.cards.h.HeraldOfAnguish.class));
        cards.add(new SetCardInfo("Herald of the Fair", 22, Rarity.COMMON, mage.cards.h.HeraldOfTheFair.class));
        cards.add(new SetCardInfo("Heroic Intervention", 161, Rarity.RARE, mage.cards.h.HeroicIntervention.class));
        cards.add(new SetCardInfo("Hidden Stockpile", 197, Rarity.UNCOMMON, mage.cards.h.HiddenStockpile.class));
        cards.add(new SetCardInfo("Highspire Artisan", 162, Rarity.COMMON, mage.cards.h.HighspireArtisan.class));
        cards.add(new SetCardInfo("Highspire Infusion", 163, Rarity.COMMON, mage.cards.h.HighspireInfusion.class));
        cards.add(new SetCardInfo("Hijack", 128, Rarity.COMMON, mage.cards.h.Hijack.class));
        cards.add(new SetCardInfo("Hinterland Drake", 51, Rarity.COMMON, mage.cards.h.HinterlandDrake.class));
        cards.add(new SetCardInfo("Hope of Ghirapur", 243, Rarity.RARE, mage.cards.h.HopeOfGhirapur.class));
        cards.add(new SetCardInfo("Hungry Flames", 129, Rarity.UNCOMMON, mage.cards.h.HungryFlames.class));
        cards.add(new SetCardInfo("Hunt the Weak", 164, Rarity.COMMON, mage.cards.h.HuntTheWeak.class));
        cards.add(new SetCardInfo("Ice Over", 52, Rarity.COMMON, mage.cards.i.IceOver.class));
        cards.add(new SetCardInfo("Illusionist's Stratagem", 53, Rarity.UNCOMMON, mage.cards.i.IllusionistsStratagem.class));
        cards.add(new SetCardInfo("Impeccable Timing", 23, Rarity.COMMON, mage.cards.i.ImpeccableTiming.class));
        cards.add(new SetCardInfo("Implement of Examination", 244, Rarity.COMMON, mage.cards.i.ImplementOfExamination.class));
        cards.add(new SetCardInfo("Implement of Malice", 245, Rarity.COMMON, mage.cards.i.ImplementOfMalice.class));
        cards.add(new SetCardInfo("Indomitable Creativity", 130, Rarity.MYTHIC, mage.cards.i.IndomitableCreativity.class));
        cards.add(new SetCardInfo("Inspired Charge", 24, Rarity.COMMON, mage.cards.i.InspiredCharge.class));
        cards.add(new SetCardInfo("Inspiring Vantage", 283, Rarity.RARE, mage.cards.i.InspiringVantage.class));
        cards.add(new SetCardInfo("Inventor's Apprentice", 131, Rarity.UNCOMMON, mage.cards.i.InventorsApprentice.class));
        cards.add(new SetCardInfo("Inventor's Goggles", 246, Rarity.COMMON, mage.cards.i.InventorsGoggles.class));
        cards.add(new SetCardInfo("Inventors' Fair", 284, Rarity.RARE, mage.cards.i.InventorsFair.class));
        cards.add(new SetCardInfo("Invigorated Rampage", 132, Rarity.UNCOMMON, mage.cards.i.InvigoratedRampage.class));
        cards.add(new SetCardInfo("Irontread Crusher", 247, Rarity.COMMON, mage.cards.i.IrontreadCrusher.class));
        cards.add(new SetCardInfo("Island", 290, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 291, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 292, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kambal, Consul of Allocation", 198, Rarity.RARE, mage.cards.k.KambalConsulOfAllocation.class));
        cards.add(new SetCardInfo("Kari Zev's Expertise", 134, Rarity.RARE, mage.cards.k.KariZevsExpertise.class));
        cards.add(new SetCardInfo("Kari Zev, Skyship Raider", 133, Rarity.RARE, mage.cards.k.KariZevSkyshipRaider.class));
        cards.add(new SetCardInfo("Key to the City", 248, Rarity.RARE, mage.cards.k.KeyToTheCity.class));
        cards.add(new SetCardInfo("Kujar Seedsculptor", 165, Rarity.COMMON, mage.cards.k.KujarSeedsculptor.class));
        cards.add(new SetCardInfo("Lathnu Sailback", 135, Rarity.COMMON, mage.cards.l.LathnuSailback.class));
        cards.add(new SetCardInfo("Leave in the Dust", 54, Rarity.COMMON, mage.cards.l.LeaveInTheDust.class));
        cards.add(new SetCardInfo("Lifecraft Cavalry", 166, Rarity.COMMON, mage.cards.l.LifecraftCavalry.class));
        cards.add(new SetCardInfo("Lifecrafter's Bestiary", 249, Rarity.RARE, mage.cards.l.LifecraftersBestiary.class));
        cards.add(new SetCardInfo("Live Fast", 95, Rarity.COMMON, mage.cards.l.LiveFast.class));
        cards.add(new SetCardInfo("Longtusk Cub", 167, Rarity.UNCOMMON, mage.cards.l.LongtuskCub.class));
        cards.add(new SetCardInfo("Lost Legacy", 96, Rarity.RARE, mage.cards.l.LostLegacy.class));
        cards.add(new SetCardInfo("Make Obsolete", 97, Rarity.UNCOMMON, mage.cards.m.MakeObsolete.class));
        cards.add(new SetCardInfo("Malfunction", 55, Rarity.COMMON, mage.cards.m.Malfunction.class));
        cards.add(new SetCardInfo("Marionette Master", 98, Rarity.RARE, mage.cards.m.MarionetteMaster.class));
        cards.add(new SetCardInfo("Master Trinketeer", 25, Rarity.RARE, mage.cards.m.MasterTrinketeer.class));
        cards.add(new SetCardInfo("Maulfist Revolutionary", 168, Rarity.UNCOMMON, mage.cards.m.MaulfistRevolutionary.class));
        cards.add(new SetCardInfo("Maulfist Squad", 99, Rarity.COMMON, mage.cards.m.MaulfistSquad.class));
        cards.add(new SetCardInfo("Maverick Thopterist", 199, Rarity.UNCOMMON, mage.cards.m.MaverickThopterist.class));
        cards.add(new SetCardInfo("Merchant's Dockhand", 250, Rarity.RARE, mage.cards.m.MerchantsDockhand.class));
        cards.add(new SetCardInfo("Metallic Mimic", 251, Rarity.RARE, mage.cards.m.MetallicMimic.class));
        cards.add(new SetCardInfo("Metallic Rebuke", 56, Rarity.COMMON, mage.cards.m.MetallicRebuke.class));
        cards.add(new SetCardInfo("Metallurgic Summonings", 57, Rarity.MYTHIC, mage.cards.m.MetallurgicSummonings.class));
        cards.add(new SetCardInfo("Metalwork Colossus", 252, Rarity.RARE, mage.cards.m.MetalworkColossus.class));
        cards.add(new SetCardInfo("Midnight Oil", 100, Rarity.RARE, mage.cards.m.MidnightOil.class));
        cards.add(new SetCardInfo("Mind Rot", 101, Rarity.COMMON, mage.cards.m.MindRot.class));
        cards.add(new SetCardInfo("Minister of Inquiries", 58, Rarity.UNCOMMON, mage.cards.m.MinisterOfInquiries.class));
        cards.add(new SetCardInfo("Mobile Garrison", 253, Rarity.COMMON, mage.cards.m.MobileGarrison.class));
        cards.add(new SetCardInfo("Monstrous Onslaught", 169, Rarity.UNCOMMON, mage.cards.m.MonstrousOnslaught.class));
        cards.add(new SetCardInfo("Mountain", 296, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 297, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 298, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narnam Cobra", 254, Rarity.COMMON, mage.cards.n.NarnamCobra.class));
        cards.add(new SetCardInfo("Narnam Renegade", 170, Rarity.UNCOMMON, mage.cards.n.NarnamRenegade.class));
        cards.add(new SetCardInfo("Nature's Way", 171, Rarity.UNCOMMON, mage.cards.n.NaturesWay.class));
        cards.add(new SetCardInfo("Night Market Aeronaut", 102, Rarity.COMMON, mage.cards.n.NightMarketAeronaut.class));
        cards.add(new SetCardInfo("Night Market Lookout", 103, Rarity.COMMON, mage.cards.n.NightMarketLookout.class));
        cards.add(new SetCardInfo("Nimble Innovator", 59, Rarity.COMMON, mage.cards.n.NimbleInnovator.class));
        cards.add(new SetCardInfo("Nissa, Vital Force", 172, Rarity.MYTHIC, mage.cards.n.NissaVitalForce.class));
        cards.add(new SetCardInfo("Noxious Gearhulk", 104, Rarity.MYTHIC, mage.cards.n.NoxiousGearhulk.class));
        cards.add(new SetCardInfo("Oath of Ajani", 200, Rarity.RARE, mage.cards.o.OathOfAjani.class));
        cards.add(new SetCardInfo("Ornamental Courage", 173, Rarity.COMMON, mage.cards.o.OrnamentalCourage.class));
        cards.add(new SetCardInfo("Ornithopter", 255, Rarity.UNCOMMON, mage.cards.o.Ornithopter.class));
        cards.add(new SetCardInfo("Outland Boar", 201, Rarity.UNCOMMON, mage.cards.o.OutlandBoar.class));
        cards.add(new SetCardInfo("Ovalchase Dragster", 256, Rarity.UNCOMMON, mage.cards.o.OvalchaseDragster.class));
        cards.add(new SetCardInfo("Oviya Pashiri, Sage Lifecrafter", 174, Rarity.RARE, mage.cards.o.OviyaPashiriSageLifecrafter.class));
        cards.add(new SetCardInfo("Pacification Array", 257, Rarity.UNCOMMON, mage.cards.p.PacificationArray.class));
        cards.add(new SetCardInfo("Padeem, Consul of Innovation", 60, Rarity.RARE, mage.cards.p.PadeemConsulOfInnovation.class));
        cards.add(new SetCardInfo("Panharmonicon", 258, Rarity.RARE, mage.cards.p.Panharmonicon.class));
        cards.add(new SetCardInfo("Paradox Engine", 259, Rarity.MYTHIC, mage.cards.p.ParadoxEngine.class));
        cards.add(new SetCardInfo("Paradoxical Outcome", 61, Rarity.RARE, mage.cards.p.ParadoxicalOutcome.class));
        cards.add(new SetCardInfo("Peacewalker Colossus", 260, Rarity.RARE, mage.cards.p.PeacewalkerColossus.class));
        cards.add(new SetCardInfo("Peema Aether-Seer", 175, Rarity.UNCOMMON, mage.cards.p.PeemaAetherSeer.class));
        cards.add(new SetCardInfo("Peema Outrider", 176, Rarity.COMMON, mage.cards.p.PeemaOutrider.class));
        cards.add(new SetCardInfo("Pendulum of Patterns", 261, Rarity.COMMON, mage.cards.p.PendulumOfPatterns.class));
        cards.add(new SetCardInfo("Pia Nalaar", 136, Rarity.RARE, mage.cards.p.PiaNalaar.class));
        cards.add(new SetCardInfo("Plains", 287, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 288, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 289, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Planar Bridge", 262, Rarity.MYTHIC, mage.cards.p.PlanarBridge.class));
        cards.add(new SetCardInfo("Prakhata Pillar-Bug", 263, Rarity.COMMON, mage.cards.p.PrakhataPillarBug.class));
        cards.add(new SetCardInfo("Precise Strike", 137, Rarity.COMMON, mage.cards.p.PreciseStrike.class));
        cards.add(new SetCardInfo("Propeller Pioneer", 26, Rarity.COMMON, mage.cards.p.PropellerPioneer.class));
        cards.add(new SetCardInfo("Prophetic Prism", 264, Rarity.COMMON, mage.cards.p.PropheticPrism.class));
        cards.add(new SetCardInfo("Quicksmith Genius", 138, Rarity.UNCOMMON, mage.cards.q.QuicksmithGenius.class));
        cards.add(new SetCardInfo("Quicksmith Rebel", 139, Rarity.RARE, mage.cards.q.QuicksmithRebel.class));
        cards.add(new SetCardInfo("Rashmi, Eternities Crafter", 202, Rarity.MYTHIC, mage.cards.r.RashmiEternitiesCrafter.class));
        cards.add(new SetCardInfo("Ravenous Intruder", 140, Rarity.UNCOMMON, mage.cards.r.RavenousIntruder.class));
        cards.add(new SetCardInfo("Reckless Fireweaver", 141, Rarity.COMMON, mage.cards.r.RecklessFireweaver.class));
        cards.add(new SetCardInfo("Refurbish", 27, Rarity.UNCOMMON, mage.cards.r.Refurbish.class));
        cards.add(new SetCardInfo("Renegade Map", 265, Rarity.COMMON, mage.cards.r.RenegadeMap.class));
        cards.add(new SetCardInfo("Renegade Rallier", 203, Rarity.UNCOMMON, mage.cards.r.RenegadeRallier.class));
        cards.add(new SetCardInfo("Renegade Wheelsmith", 204, Rarity.UNCOMMON, mage.cards.r.RenegadeWheelsmith.class));
        cards.add(new SetCardInfo("Reservoir Walker", 266, Rarity.COMMON, mage.cards.r.ReservoirWalker.class));
        cards.add(new SetCardInfo("Restoration Gearsmith", 205, Rarity.UNCOMMON, mage.cards.r.RestorationGearsmith.class));
        cards.add(new SetCardInfo("Restoration Specialist", 28, Rarity.UNCOMMON, mage.cards.r.RestorationSpecialist.class));
        cards.add(new SetCardInfo("Revoke Privileges", 29, Rarity.COMMON, mage.cards.r.RevokePrivileges.class));
        cards.add(new SetCardInfo("Revolutionary Rebuff", 62, Rarity.COMMON, mage.cards.r.RevolutionaryRebuff.class));
        cards.add(new SetCardInfo("Ridgescale Tusker", 177, Rarity.UNCOMMON, mage.cards.r.RidgescaleTusker.class));
        cards.add(new SetCardInfo("Riparian Tiger", 178, Rarity.COMMON, mage.cards.r.RiparianTiger.class));
        cards.add(new SetCardInfo("Rishkar's Expertise", 180, Rarity.RARE, mage.cards.r.RishkarsExpertise.class));
        cards.add(new SetCardInfo("Rishkar, Peema Renegade", 179, Rarity.RARE, mage.cards.r.RishkarPeemaRenegade.class));
        cards.add(new SetCardInfo("Rogue Refiner", 206, Rarity.UNCOMMON, mage.cards.r.RogueRefiner.class));
        cards.add(new SetCardInfo("Ruinous Gremlin", 142, Rarity.COMMON, mage.cards.r.RuinousGremlin.class));
        cards.add(new SetCardInfo("Rush of Vitality", 105, Rarity.COMMON, mage.cards.r.RushOfVitality.class));
        cards.add(new SetCardInfo("Sage of Shaila's Claim", 181, Rarity.COMMON, mage.cards.s.SageOfShailasClaim.class));
        cards.add(new SetCardInfo("Saheeli Rai", 207, Rarity.MYTHIC, mage.cards.s.SaheeliRai.class));
        cards.add(new SetCardInfo("Salivating Gremlins", 143, Rarity.COMMON, mage.cards.s.SalivatingGremlins.class));
        cards.add(new SetCardInfo("Scrap Trawler", 267, Rarity.RARE, mage.cards.s.ScrapTrawler.class));
        cards.add(new SetCardInfo("Scrapheap Scrounger", 268, Rarity.RARE, mage.cards.s.ScrapheapScrounger.class));
        cards.add(new SetCardInfo("Scrapper Champion", 144, Rarity.UNCOMMON, mage.cards.s.ScrapperChampion.class));
        cards.add(new SetCardInfo("Sculpting Steel", 302, Rarity.MYTHIC, mage.cards.s.SculptingSteel.class));
        cards.add(new SetCardInfo("Select for Inspection", 63, Rarity.COMMON, mage.cards.s.SelectForInspection.class));
        cards.add(new SetCardInfo("Self-Assembler", 269, Rarity.COMMON, mage.cards.s.SelfAssembler.class));
        cards.add(new SetCardInfo("Servant of the Conduit", 182, Rarity.UNCOMMON, mage.cards.s.ServantOfTheConduit.class));
        cards.add(new SetCardInfo("Servo Exhibition", 30, Rarity.UNCOMMON, mage.cards.s.ServoExhibition.class));
        cards.add(new SetCardInfo("Servo Schematic", 270, Rarity.UNCOMMON, mage.cards.s.ServoSchematic.class));
        cards.add(new SetCardInfo("Shielded Aether Thief", 64, Rarity.UNCOMMON, mage.cards.s.ShieldedAetherThief.class));
        cards.add(new SetCardInfo("Shipwreck Moray", 65, Rarity.COMMON, mage.cards.s.ShipwreckMoray.class));
        cards.add(new SetCardInfo("Shrewd Negotiation", 66, Rarity.UNCOMMON, mage.cards.s.ShrewdNegotiation.class));
        cards.add(new SetCardInfo("Siege Modification", 145, Rarity.UNCOMMON, mage.cards.s.SiegeModification.class));
        cards.add(new SetCardInfo("Sky Skiff", 271, Rarity.COMMON, mage.cards.s.SkySkiff.class));
        cards.add(new SetCardInfo("Skyship Plunderer", 67, Rarity.UNCOMMON, mage.cards.s.SkyshipPlunderer.class));
        cards.add(new SetCardInfo("Skyship Stalker", 146, Rarity.RARE, mage.cards.s.SkyshipStalker.class));
        cards.add(new SetCardInfo("Skysovereign, Consul Flagship", 272, Rarity.MYTHIC, mage.cards.s.SkysovereignConsulFlagship.class));
        cards.add(new SetCardInfo("Skywhaler's Shot", 31, Rarity.UNCOMMON, mage.cards.s.SkywhalersShot.class));
        cards.add(new SetCardInfo("Sly Requisitioner", 106, Rarity.UNCOMMON, mage.cards.s.SlyRequisitioner.class));
        cards.add(new SetCardInfo("Speedway Fanatic", 147, Rarity.UNCOMMON, mage.cards.s.SpeedwayFanatic.class));
        cards.add(new SetCardInfo("Spire Patrol", 208, Rarity.UNCOMMON, mage.cards.s.SpirePatrol.class));
        cards.add(new SetCardInfo("Spire of Industry", 285, Rarity.RARE, mage.cards.s.SpireOfIndustry.class));
        cards.add(new SetCardInfo("Spirebluff Canal", 286, Rarity.RARE, mage.cards.s.SpirebluffCanal.class));
        cards.add(new SetCardInfo("Spireside Infiltrator", 148, Rarity.COMMON, mage.cards.s.SpiresideInfiltrator.class));
        cards.add(new SetCardInfo("Sram's Expertise", 33, Rarity.RARE, mage.cards.s.SramsExpertise.class));
        cards.add(new SetCardInfo("Sram, Senior Edificer", 32, Rarity.RARE, mage.cards.s.SramSeniorEdificer.class));
        cards.add(new SetCardInfo("Subtle Strike", 107, Rarity.COMMON, mage.cards.s.SubtleStrike.class));
        cards.add(new SetCardInfo("Swamp", 293, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 294, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 295, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sweatworks Brawler", 149, Rarity.COMMON, mage.cards.s.SweatworksBrawler.class));
        cards.add(new SetCardInfo("Tezzeret the Schemer", 209, Rarity.MYTHIC, mage.cards.t.TezzeretTheSchemer.class));
        cards.add(new SetCardInfo("Tezzeret's Ambition", 68, Rarity.COMMON, mage.cards.t.TezzeretsAmbition.class));
        cards.add(new SetCardInfo("Tezzeret's Touch", 210, Rarity.UNCOMMON, mage.cards.t.TezzeretsTouch.class));
        cards.add(new SetCardInfo("Thopter Arrest", 34, Rarity.UNCOMMON, mage.cards.t.ThopterArrest.class));
        cards.add(new SetCardInfo("Thriving Rhino", 183, Rarity.COMMON, mage.cards.t.ThrivingRhino.class));
        cards.add(new SetCardInfo("Thriving Turtle", 69, Rarity.COMMON, mage.cards.t.ThrivingTurtle.class));
        cards.add(new SetCardInfo("Toolcraft Exemplar", 35, Rarity.RARE, mage.cards.t.ToolcraftExemplar.class));
        cards.add(new SetCardInfo("Torrential Gearhulk", 70, Rarity.MYTHIC, mage.cards.t.TorrentialGearhulk.class));
        cards.add(new SetCardInfo("Trophy Mage", 71, Rarity.UNCOMMON, mage.cards.t.TrophyMage.class));
        cards.add(new SetCardInfo("Unbridled Growth", 184, Rarity.COMMON, mage.cards.u.UnbridledGrowth.class));
        cards.add(new SetCardInfo("Underhanded Designs", 108, Rarity.UNCOMMON, mage.cards.u.UnderhandedDesigns.class));
        cards.add(new SetCardInfo("Universal Solvent", 273, Rarity.COMMON, mage.cards.u.UniversalSolvent.class));
        cards.add(new SetCardInfo("Unlicensed Disintegration", 211, Rarity.UNCOMMON, mage.cards.u.UnlicensedDisintegration.class));
        cards.add(new SetCardInfo("Untethered Express", 274, Rarity.UNCOMMON, mage.cards.u.UntetheredExpress.class));
        cards.add(new SetCardInfo("Vengeful Rebel", 109, Rarity.UNCOMMON, mage.cards.v.VengefulRebel.class));
        cards.add(new SetCardInfo("Verdurous Gearhulk", 185, Rarity.MYTHIC, mage.cards.v.VerdurousGearhulk.class));
        cards.add(new SetCardInfo("Veteran Motorist", 212, Rarity.UNCOMMON, mage.cards.v.VeteranMotorist.class));
        cards.add(new SetCardInfo("Visionary Augmenter", 36, Rarity.UNCOMMON, mage.cards.v.VisionaryAugmenter.class));
        cards.add(new SetCardInfo("Voltaic Brawler", 213, Rarity.UNCOMMON, mage.cards.v.VoltaicBrawler.class));
        cards.add(new SetCardInfo("Weaponcraft Enthusiast", 110, Rarity.UNCOMMON, mage.cards.w.WeaponcraftEnthusiast.class));
        cards.add(new SetCardInfo("Weldfast Engineer", 214, Rarity.UNCOMMON, mage.cards.w.WeldfastEngineer.class));
        cards.add(new SetCardInfo("Weldfast Monitor", 275, Rarity.COMMON, mage.cards.w.WeldfastMonitor.class));
        cards.add(new SetCardInfo("Weldfast Wingsmith", 72, Rarity.COMMON, mage.cards.w.WeldfastWingsmith.class));
        cards.add(new SetCardInfo("Welding Sparks", 150, Rarity.COMMON, mage.cards.w.WeldingSparks.class));
        cards.add(new SetCardInfo("Whir of Invention", 73, Rarity.RARE, mage.cards.w.WhirOfInvention.class));
        cards.add(new SetCardInfo("Whirler Virtuoso", 215, Rarity.UNCOMMON, mage.cards.w.WhirlerVirtuoso.class));
        cards.add(new SetCardInfo("Whirlermaker", 276, Rarity.UNCOMMON, mage.cards.w.Whirlermaker.class));
        cards.add(new SetCardInfo("Wild Wanderer", 186, Rarity.COMMON, mage.cards.w.WildWanderer.class));
        cards.add(new SetCardInfo("Wildest Dreams", 187, Rarity.RARE, mage.cards.w.WildestDreams.class));
        cards.add(new SetCardInfo("Wind-Kin Raiders", 74, Rarity.UNCOMMON, mage.cards.w.WindKinRaiders.class));
        cards.add(new SetCardInfo("Winding Constrictor", 216, Rarity.UNCOMMON, mage.cards.w.WindingConstrictor.class));
        cards.add(new SetCardInfo("Wispweaver Angel", 37, Rarity.UNCOMMON, mage.cards.w.WispweaverAngel.class));
        cards.add(new SetCardInfo("Woodweaver's Puzzleknot", 277, Rarity.COMMON, mage.cards.w.WoodweaversPuzzleknot.class));
        cards.add(new SetCardInfo("Workshop Assistant", 278, Rarity.COMMON, mage.cards.w.WorkshopAssistant.class));
        cards.add(new SetCardInfo("Yahenni's Expertise", 112, Rarity.RARE, mage.cards.y.YahennisExpertise.class));
        cards.add(new SetCardInfo("Yahenni, Undying Partisan", 111, Rarity.RARE, mage.cards.y.YahenniUndyingPartisan.class));
    }
}
