package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class Jumpstart2022 extends ExpansionSet {

    private static final Jumpstart2022 instance = new Jumpstart2022();

    public static Jumpstart2022 getInstance() {
        return instance;
    }

    private Jumpstart2022() {
        super("Jumpstart 2022", "J22", ExpansionSet.buildDate(2020, 12, 2), SetType.SUPPLEMENTAL);
        this.blockName = "Jumpstart";
        this.hasBasicLands = true;

        cards.add(new SetCardInfo("Academy Journeymage", 267, Rarity.COMMON, mage.cards.a.AcademyJourneymage.class));
        cards.add(new SetCardInfo("Acrobatic Maneuver", 138, Rarity.COMMON, mage.cards.a.AcrobaticManeuver.class));
        cards.add(new SetCardInfo("Act on Impulse", 492, Rarity.UNCOMMON, mage.cards.a.ActOnImpulse.class));
        cards.add(new SetCardInfo("Adventuring Gear", 751, Rarity.COMMON, mage.cards.a.AdventuringGear.class));
        cards.add(new SetCardInfo("Adventurous Impulse", 627, Rarity.COMMON, mage.cards.a.AdventurousImpulse.class));
        cards.add(new SetCardInfo("Aerial Modification", 139, Rarity.UNCOMMON, mage.cards.a.AerialModification.class));
        cards.add(new SetCardInfo("Aeronaut Tinkerer", 268, Rarity.COMMON, mage.cards.a.AeronautTinkerer.class));
        cards.add(new SetCardInfo("Aether Spellbomb", 752, Rarity.COMMON, mage.cards.a.AetherSpellbomb.class));
        cards.add(new SetCardInfo("Aethershield Artificer", 140, Rarity.UNCOMMON, mage.cards.a.AethershieldArtificer.class));
        cards.add(new SetCardInfo("Aftershock", 129, Rarity.COMMON, mage.cards.a.Aftershock.class));
        cards.add(new SetCardInfo("Agrus Kos, Eternal Soldier", 1, Rarity.RARE, mage.cards.a.AgrusKosEternalSoldier.class));
        cards.add(new SetCardInfo("Ajani's Pridemate", 142, Rarity.UNCOMMON, mage.cards.a.AjanisPridemate.class));
        cards.add(new SetCardInfo("Ajani, Strength of the Pride", 141, Rarity.MYTHIC, mage.cards.a.AjaniStrengthOfThePride.class));
        cards.add(new SetCardInfo("Alandra, Sky Dreamer", 9, Rarity.RARE, mage.cards.a.AlandraSkyDreamer.class));
        cards.add(new SetCardInfo("Alchemist's Vial", 753, Rarity.COMMON, mage.cards.a.AlchemistsVial.class));
        cards.add(new SetCardInfo("Alley Strangler", 375, Rarity.COMMON, mage.cards.a.AlleyStrangler.class));
        cards.add(new SetCardInfo("Alseid of Life's Bounty", 143, Rarity.UNCOMMON, mage.cards.a.AlseidOfLifesBounty.class));
        cards.add(new SetCardInfo("Amoeboid Changeling", 269, Rarity.COMMON, mage.cards.a.AmoeboidChangeling.class));
        cards.add(new SetCardInfo("Anchor to the Aether", 270, Rarity.UNCOMMON, mage.cards.a.AnchorToTheAether.class));
        cards.add(new SetCardInfo("Ancient Craving", 376, Rarity.UNCOMMON, mage.cards.a.AncientCraving.class));
        cards.add(new SetCardInfo("Ancient Stirrings", 628, Rarity.COMMON, mage.cards.a.AncientStirrings.class));
        cards.add(new SetCardInfo("Angel of Flight Alabaster", 144, Rarity.RARE, mage.cards.a.AngelOfFlightAlabaster.class));
        cards.add(new SetCardInfo("Angelic Cub", 2, Rarity.UNCOMMON, mage.cards.a.AngelicCub.class));
        cards.add(new SetCardInfo("Angelic Edict", 145, Rarity.COMMON, mage.cards.a.AngelicEdict.class));
        cards.add(new SetCardInfo("Angelic Page", 146, Rarity.COMMON, mage.cards.a.AngelicPage.class));
        cards.add(new SetCardInfo("Angelic Protector", 147, Rarity.UNCOMMON, mage.cards.a.AngelicProtector.class));
        cards.add(new SetCardInfo("Anointer of Valor", 148, Rarity.COMMON, mage.cards.a.AnointerOfValor.class));
        cards.add(new SetCardInfo("Apothecary Geist", 149, Rarity.COMMON, mage.cards.a.ApothecaryGeist.class));
        cards.add(new SetCardInfo("Aquatic Incursion", 271, Rarity.UNCOMMON, mage.cards.a.AquaticIncursion.class));
        cards.add(new SetCardInfo("Aradara Express", 754, Rarity.COMMON, mage.cards.a.AradaraExpress.class));
        cards.add(new SetCardInfo("Archon of Justice", 150, Rarity.RARE, mage.cards.a.ArchonOfJustice.class));
        cards.add(new SetCardInfo("Archon of Sun's Grace", 151, Rarity.RARE, mage.cards.a.ArchonOfSunsGrace.class));
        cards.add(new SetCardInfo("Ardoz, Cobbler of War", 29, Rarity.RARE, mage.cards.a.ArdozCobblerOfWar.class));
        cards.add(new SetCardInfo("Arlinn, Voice of the Pack", 85, Rarity.UNCOMMON, mage.cards.a.ArlinnVoiceOfThePack.class));
        cards.add(new SetCardInfo("Arms Dealer", 493, Rarity.UNCOMMON, mage.cards.a.ArmsDealer.class));
        cards.add(new SetCardInfo("Arrest", 52, Rarity.UNCOMMON, mage.cards.a.Arrest.class));
        cards.add(new SetCardInfo("Artificer's Epiphany", 272, Rarity.COMMON, mage.cards.a.ArtificersEpiphany.class));
        cards.add(new SetCardInfo("Ash Barrens", 809, Rarity.COMMON, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Ashcoat of the Shadow Swarm", 19, Rarity.MYTHIC, mage.cards.a.AshcoatOfTheShadowSwarm.class));
        cards.add(new SetCardInfo("Assembly-Worker", 755, Rarity.COMMON, mage.cards.a.AssemblyWorker.class));
        cards.add(new SetCardInfo("Attended Healer", 152, Rarity.UNCOMMON, mage.cards.a.AttendedHealer.class));
        cards.add(new SetCardInfo("Augury Owl", 273, Rarity.COMMON, mage.cards.a.AuguryOwl.class));
        cards.add(new SetCardInfo("Auntie Blyte, Bad Influence", 30, Rarity.MYTHIC, mage.cards.a.AuntieBlyteBadInfluence.class));
        cards.add(new SetCardInfo("Auramancer", 153, Rarity.COMMON, mage.cards.a.Auramancer.class));
        cards.add(new SetCardInfo("Avalanche Caller", 274, Rarity.UNCOMMON, mage.cards.a.AvalancheCaller.class));
        cards.add(new SetCardInfo("Avenger of Zendikar", 629, Rarity.MYTHIC, mage.cards.a.AvengerOfZendikar.class));
        cards.add(new SetCardInfo("Aviation Pioneer", 275, Rarity.COMMON, mage.cards.a.AviationPioneer.class));
        cards.add(new SetCardInfo("Axgard Cavalry", 494, Rarity.COMMON, mage.cards.a.AxgardCavalry.class));
        cards.add(new SetCardInfo("Bag of Holding", 756, Rarity.RARE, mage.cards.b.BagOfHolding.class));
        cards.add(new SetCardInfo("Balan, Wandering Knight", 53, Rarity.RARE, mage.cards.b.BalanWanderingKnight.class));
        cards.add(new SetCardInfo("Baloth Woodcrasher", 630, Rarity.UNCOMMON, mage.cards.b.BalothWoodcrasher.class));
        cards.add(new SetCardInfo("Band Together", 631, Rarity.COMMON, mage.cards.b.BandTogether.class));
        cards.add(new SetCardInfo("Banefire", 495, Rarity.RARE, mage.cards.b.Banefire.class));
        cards.add(new SetCardInfo("Barrage Ogre", 496, Rarity.UNCOMMON, mage.cards.b.BarrageOgre.class));
        cards.add(new SetCardInfo("Barrin, Tolarian Archmage", 276, Rarity.RARE, mage.cards.b.BarrinTolarianArchmage.class));
        cards.add(new SetCardInfo("Basri's Acolyte", 154, Rarity.COMMON, mage.cards.b.BasrisAcolyte.class));
        cards.add(new SetCardInfo("Battle Squadron", 497, Rarity.UNCOMMON, mage.cards.b.BattleSquadron.class));
        cards.add(new SetCardInfo("Benalish Honor Guard", 155, Rarity.COMMON, mage.cards.b.BenalishHonorGuard.class));
        cards.add(new SetCardInfo("Benevolent Hydra", 38, Rarity.RARE, mage.cards.b.BenevolentHydra.class));
        cards.add(new SetCardInfo("Berg Strider", 277, Rarity.COMMON, mage.cards.b.BergStrider.class));
        cards.add(new SetCardInfo("Biblioplex Kraken", 10, Rarity.UNCOMMON, mage.cards.b.BiblioplexKraken.class));
        cards.add(new SetCardInfo("Big Score", 498, Rarity.COMMON, mage.cards.b.BigScore.class));
        cards.add(new SetCardInfo("Black Cat", 377, Rarity.COMMON, mage.cards.b.BlackCat.class));
        cards.add(new SetCardInfo("Blaze", 499, Rarity.UNCOMMON, mage.cards.b.Blaze.class));
        cards.add(new SetCardInfo("Blessed Defiance", 156, Rarity.COMMON, mage.cards.b.BlessedDefiance.class));
        cards.add(new SetCardInfo("Blessed Sanctuary", 157, Rarity.RARE, mage.cards.b.BlessedSanctuary.class));
        cards.add(new SetCardInfo("Blessed Spirits", 158, Rarity.UNCOMMON, mage.cards.b.BlessedSpirits.class));
        cards.add(new SetCardInfo("Blight Keeper", 378, Rarity.COMMON, mage.cards.b.BlightKeeper.class));
        cards.add(new SetCardInfo("Blighted Fen", 810, Rarity.UNCOMMON, mage.cards.b.BlightedFen.class));
        cards.add(new SetCardInfo("Blisterpod", 632, Rarity.COMMON, mage.cards.b.Blisterpod.class));
        cards.add(new SetCardInfo("Blisterspit Gremlin", 500, Rarity.COMMON, mage.cards.b.BlisterspitGremlin.class));
        cards.add(new SetCardInfo("Blood Artist", 117, Rarity.UNCOMMON, mage.cards.b.BloodArtist.class));
        cards.add(new SetCardInfo("Blood Aspirant", 501, Rarity.UNCOMMON, mage.cards.b.BloodAspirant.class));
        cards.add(new SetCardInfo("Blood Price", 379, Rarity.COMMON, mage.cards.b.BloodPrice.class));
        cards.add(new SetCardInfo("Bloodbond Vampire", 380, Rarity.UNCOMMON, mage.cards.b.BloodbondVampire.class));
        cards.add(new SetCardInfo("Bloodhaze Wolverine", 502, Rarity.COMMON, mage.cards.b.BloodhazeWolverine.class));
        cards.add(new SetCardInfo("Bloodline Pretender", 757, Rarity.UNCOMMON, mage.cards.b.BloodlinePretender.class));
        cards.add(new SetCardInfo("Bloodthirsty Aerialist", 381, Rarity.UNCOMMON, mage.cards.b.BloodthirstyAerialist.class));
        cards.add(new SetCardInfo("Bloodtracker", 382, Rarity.RARE, mage.cards.b.Bloodtracker.class));
        cards.add(new SetCardInfo("Bogardan Dragonheart", 503, Rarity.COMMON, mage.cards.b.BogardanDragonheart.class));
        cards.add(new SetCardInfo("Bolt Hound", 504, Rarity.UNCOMMON, mage.cards.b.BoltHound.class));
        cards.add(new SetCardInfo("Bonders' Enclave", 811, Rarity.RARE, mage.cards.b.BondersEnclave.class));
        cards.add(new SetCardInfo("Bone Picker", 383, Rarity.UNCOMMON, mage.cards.b.BonePicker.class));
        cards.add(new SetCardInfo("Borderland Marauder", 505, Rarity.COMMON, mage.cards.b.BorderlandMarauder.class));
        cards.add(new SetCardInfo("Bounding Wolf", 633, Rarity.COMMON, mage.cards.b.BoundingWolf.class));
        cards.add(new SetCardInfo("Brazen Cannonade", 31, Rarity.RARE, mage.cards.b.BrazenCannonade.class));
        cards.add(new SetCardInfo("Brazen Freebooter", 506, Rarity.COMMON, mage.cards.b.BrazenFreebooter.class));
        cards.add(new SetCardInfo("Brazen Wolves", 507, Rarity.COMMON, mage.cards.b.BrazenWolves.class));
        cards.add(new SetCardInfo("Briarpack Alpha", 634, Rarity.UNCOMMON, mage.cards.b.BriarpackAlpha.class));
        cards.add(new SetCardInfo("Brightmare", 159, Rarity.UNCOMMON, mage.cards.b.Brightmare.class));
        cards.add(new SetCardInfo("Brineborn Cutthroat", 278, Rarity.UNCOMMON, mage.cards.b.BrinebornCutthroat.class));
        cards.add(new SetCardInfo("Bring to Trial", 160, Rarity.COMMON, mage.cards.b.BringToTrial.class));
        cards.add(new SetCardInfo("Bristling Boar", 635, Rarity.COMMON, mage.cards.b.BristlingBoar.class));
        cards.add(new SetCardInfo("Broken Bond", 636, Rarity.COMMON, mage.cards.b.BrokenBond.class));
        cards.add(new SetCardInfo("Brood Monitor", 637, Rarity.UNCOMMON, mage.cards.b.BroodMonitor.class));
        cards.add(new SetCardInfo("Built to Last", 161, Rarity.COMMON, mage.cards.b.BuiltToLast.class));
        cards.add(new SetCardInfo("Burglar Rat", 384, Rarity.COMMON, mage.cards.b.BurglarRat.class));
        cards.add(new SetCardInfo("Burn Bright", 508, Rarity.COMMON, mage.cards.b.BurnBright.class));
        cards.add(new SetCardInfo("Bury in Books", 279, Rarity.COMMON, mage.cards.b.BuryInBooks.class));
        cards.add(new SetCardInfo("Cage of Hands", 162, Rarity.COMMON, mage.cards.c.CageOfHands.class));
        cards.add(new SetCardInfo("Campus Guide", 758, Rarity.COMMON, mage.cards.c.CampusGuide.class));
        cards.add(new SetCardInfo("Canopy Baloth", 638, Rarity.COMMON, mage.cards.c.CanopyBaloth.class));
        cards.add(new SetCardInfo("Captain Lannery Storm", 509, Rarity.RARE, mage.cards.c.CaptainLanneryStorm.class));
        cards.add(new SetCardInfo("Captivating Unicorn", 163, Rarity.COMMON, mage.cards.c.CaptivatingUnicorn.class));
        cards.add(new SetCardInfo("Catalyst Elemental", 510, Rarity.COMMON, mage.cards.c.CatalystElemental.class));
        cards.add(new SetCardInfo("Caught in the Brights", 164, Rarity.COMMON, mage.cards.c.CaughtInTheBrights.class));
        cards.add(new SetCardInfo("Caustic Caterpillar", 86, Rarity.COMMON, mage.cards.c.CausticCaterpillar.class));
        cards.add(new SetCardInfo("Cavalry Drillmaster", 165, Rarity.COMMON, mage.cards.c.CavalryDrillmaster.class));
        cards.add(new SetCardInfo("Cellar Door", 759, Rarity.UNCOMMON, mage.cards.c.CellarDoor.class));
        cards.add(new SetCardInfo("Cemetery Recruitment", 385, Rarity.COMMON, mage.cards.c.CemeteryRecruitment.class));
        cards.add(new SetCardInfo("Certain Death", 386, Rarity.COMMON, mage.cards.c.CertainDeath.class));
        cards.add(new SetCardInfo("Chains of Custody", 3, Rarity.COMMON, mage.cards.c.ChainsOfCustody.class));
        cards.add(new SetCardInfo("Challenger Troll", 639, Rarity.UNCOMMON, mage.cards.c.ChallengerTroll.class));
        cards.add(new SetCardInfo("Chandra's Magmutt", 512, Rarity.COMMON, mage.cards.c.ChandrasMagmutt.class));
        cards.add(new SetCardInfo("Chandra's Pyreling", 513, Rarity.UNCOMMON, mage.cards.c.ChandrasPyreling.class));
        cards.add(new SetCardInfo("Chandra's Pyrohelix", 514, Rarity.COMMON, mage.cards.c.ChandrasPyrohelix.class));
        cards.add(new SetCardInfo("Chandra's Spitfire", 515, Rarity.UNCOMMON, mage.cards.c.ChandrasSpitfire.class));
        cards.add(new SetCardInfo("Chandra, Flame's Fury", 511, Rarity.MYTHIC, mage.cards.c.ChandraFlamesFury.class));
        cards.add(new SetCardInfo("Chillerpillar", 280, Rarity.COMMON, mage.cards.c.Chillerpillar.class));
        cards.add(new SetCardInfo("Chilling Trap", 281, Rarity.COMMON, mage.cards.c.ChillingTrap.class));
        cards.add(new SetCardInfo("Chittering Rats", 387, Rarity.COMMON, mage.cards.c.ChitteringRats.class));
        cards.add(new SetCardInfo("Circuit Mender", 760, Rarity.UNCOMMON, mage.cards.c.CircuitMender.class));
        cards.add(new SetCardInfo("Clockwork Hydra", 135, Rarity.UNCOMMON, mage.cards.c.ClockworkHydra.class));
        cards.add(new SetCardInfo("Coalborn Entity", 32, Rarity.UNCOMMON, mage.cards.c.CoalbornEntity.class));
        cards.add(new SetCardInfo("Coalhauler Swine", 516, Rarity.COMMON, mage.cards.c.CoalhaulerSwine.class));
        cards.add(new SetCardInfo("Cogwork Assembler", 761, Rarity.UNCOMMON, mage.cards.c.CogworkAssembler.class));
        cards.add(new SetCardInfo("Coldsteel Heart", 94, Rarity.UNCOMMON, mage.cards.c.ColdsteelHeart.class));
        cards.add(new SetCardInfo("Colossal Dreadmaw", 640, Rarity.COMMON, mage.cards.c.ColossalDreadmaw.class));
        cards.add(new SetCardInfo("Colossal Majesty", 87, Rarity.UNCOMMON, mage.cards.c.ColossalMajesty.class));
        cards.add(new SetCardInfo("Combat Professor", 167, Rarity.COMMON, mage.cards.c.CombatProfessor.class));
        cards.add(new SetCardInfo("Condescend", 282, Rarity.UNCOMMON, mage.cards.c.Condescend.class));
        cards.add(new SetCardInfo("Conductor of Cacophony", 20, Rarity.UNCOMMON, mage.cards.c.ConductorOfCacophony.class));
        cards.add(new SetCardInfo("Cone of Flame", 517, Rarity.UNCOMMON, mage.cards.c.ConeOfFlame.class));
        cards.add(new SetCardInfo("Consign to the Pit", 388, Rarity.COMMON, mage.cards.c.ConsignToThePit.class));
        cards.add(new SetCardInfo("Corpse Churn", 389, Rarity.COMMON, mage.cards.c.CorpseChurn.class));
        cards.add(new SetCardInfo("Courser of Kruphix", 641, Rarity.RARE, mage.cards.c.CourserOfKruphix.class));
        cards.add(new SetCardInfo("Crashing Tide", 283, Rarity.COMMON, mage.cards.c.CrashingTide.class));
        cards.add(new SetCardInfo("Crawling Sensation", 642, Rarity.UNCOMMON, mage.cards.c.CrawlingSensation.class));
        cards.add(new SetCardInfo("Creeperhulk", 643, Rarity.RARE, mage.cards.c.Creeperhulk.class));
        cards.add(new SetCardInfo("Creeping Bloodsucker", 21, Rarity.COMMON, mage.cards.c.CreepingBloodsucker.class));
        cards.add(new SetCardInfo("Crippling Chill", 284, Rarity.COMMON, mage.cards.c.CripplingChill.class));
        cards.add(new SetCardInfo("Crow of Dark Tidings", 390, Rarity.COMMON, mage.cards.c.CrowOfDarkTidings.class));
        cards.add(new SetCardInfo("Cruel Sadist", 391, Rarity.RARE, mage.cards.c.CruelSadist.class));
        cards.add(new SetCardInfo("Crypt Rats", 392, Rarity.UNCOMMON, mage.cards.c.CryptRats.class));
        cards.add(new SetCardInfo("Cryptic Serpent", 285, Rarity.UNCOMMON, mage.cards.c.CrypticSerpent.class));
        cards.add(new SetCardInfo("Cultivate", 644, Rarity.COMMON, mage.cards.c.Cultivate.class));
        cards.add(new SetCardInfo("Cyclops Electromancer", 518, Rarity.UNCOMMON, mage.cards.c.CyclopsElectromancer.class));
        cards.add(new SetCardInfo("Dance with Devils", 519, Rarity.UNCOMMON, mage.cards.d.DanceWithDevils.class));
        cards.add(new SetCardInfo("Danitha Capashen, Paragon", 168, Rarity.UNCOMMON, mage.cards.d.DanithaCapashenParagon.class));
        cards.add(new SetCardInfo("Daring Piracy", 33, Rarity.UNCOMMON, mage.cards.d.DaringPiracy.class));
        cards.add(new SetCardInfo("Dawn of Hope", 169, Rarity.RARE, mage.cards.d.DawnOfHope.class));
        cards.add(new SetCardInfo("Dawning Angel", 170, Rarity.COMMON, mage.cards.d.DawningAngel.class));
        cards.add(new SetCardInfo("Daybreak Chaplain", 171, Rarity.COMMON, mage.cards.d.DaybreakChaplain.class));
        cards.add(new SetCardInfo("Daybreak Charger", 172, Rarity.COMMON, mage.cards.d.DaybreakCharger.class));
        cards.add(new SetCardInfo("Dead Weight", 393, Rarity.COMMON, mage.cards.d.DeadWeight.class));
        cards.add(new SetCardInfo("Deadbridge Goliath", 645, Rarity.RARE, mage.cards.d.DeadbridgeGoliath.class));
        cards.add(new SetCardInfo("Deadly Plot", 22, Rarity.UNCOMMON, mage.cards.d.DeadlyPlot.class));
        cards.add(new SetCardInfo("Death Wind", 394, Rarity.UNCOMMON, mage.cards.d.DeathWind.class));
        cards.add(new SetCardInfo("Deathbloom Thallid", 395, Rarity.COMMON, mage.cards.d.DeathbloomThallid.class));
        cards.add(new SetCardInfo("Deathbringer Regent", 396, Rarity.RARE, mage.cards.d.DeathbringerRegent.class));
        cards.add(new SetCardInfo("Declare Dominance", 646, Rarity.UNCOMMON, mage.cards.d.DeclareDominance.class));
        cards.add(new SetCardInfo("Decree of Justice", 173, Rarity.RARE, mage.cards.d.DecreeOfJustice.class));
        cards.add(new SetCardInfo("Deem Worthy", 520, Rarity.UNCOMMON, mage.cards.d.DeemWorthy.class));
        cards.add(new SetCardInfo("Defy Death", 174, Rarity.UNCOMMON, mage.cards.d.DefyDeath.class));
        cards.add(new SetCardInfo("Demon of Catastrophes", 397, Rarity.RARE, mage.cards.d.DemonOfCatastrophes.class));
        cards.add(new SetCardInfo("Demon's Disciple", 399, Rarity.UNCOMMON, mage.cards.d.DemonsDisciple.class));
        cards.add(new SetCardInfo("Demon's Grasp", 400, Rarity.COMMON, mage.cards.d.DemonsGrasp.class));
        cards.add(new SetCardInfo("Demonic Gifts", 398, Rarity.COMMON, mage.cards.d.DemonicGifts.class));
        cards.add(new SetCardInfo("Desert of the Mindful", 812, Rarity.COMMON, mage.cards.d.DesertOfTheMindful.class));
        cards.add(new SetCardInfo("Destructive Tampering", 521, Rarity.COMMON, mage.cards.d.DestructiveTampering.class));
        cards.add(new SetCardInfo("Devouring Light", 175, Rarity.UNCOMMON, mage.cards.d.DevouringLight.class));
        cards.add(new SetCardInfo("Devouring Swarm", 401, Rarity.COMMON, mage.cards.d.DevouringSwarm.class));
        cards.add(new SetCardInfo("Diabolic Edict", 67, Rarity.COMMON, mage.cards.d.DiabolicEdict.class));
        cards.add(new SetCardInfo("Disciple of Perdition", 23, Rarity.UNCOMMON, mage.cards.d.DiscipleOfPerdition.class));
        cards.add(new SetCardInfo("Dismiss", 286, Rarity.UNCOMMON, mage.cards.d.Dismiss.class));
        cards.add(new SetCardInfo("Distinguished Conjurer", 4, Rarity.UNCOMMON, mage.cards.d.DistinguishedConjurer.class));
        cards.add(new SetCardInfo("Divine Arrow", 176, Rarity.COMMON, mage.cards.d.DivineArrow.class));
        cards.add(new SetCardInfo("Divine Verdict", 177, Rarity.COMMON, mage.cards.d.DivineVerdict.class));
        cards.add(new SetCardInfo("Djinn of Wishes", 287, Rarity.RARE, mage.cards.d.DjinnOfWishes.class));
        cards.add(new SetCardInfo("Domesticated Hydra", 647, Rarity.UNCOMMON, mage.cards.d.DomesticatedHydra.class));
        cards.add(new SetCardInfo("Doomed Dissenter", 402, Rarity.COMMON, mage.cards.d.DoomedDissenter.class));
        cards.add(new SetCardInfo("Doomed Traveler", 178, Rarity.COMMON, mage.cards.d.DoomedTraveler.class));
        cards.add(new SetCardInfo("Drag Under", 288, Rarity.COMMON, mage.cards.d.DragUnder.class));
        cards.add(new SetCardInfo("Dragon Blood", 762, Rarity.UNCOMMON, mage.cards.d.DragonBlood.class));
        cards.add(new SetCardInfo("Dragon Egg", 522, Rarity.UNCOMMON, mage.cards.d.DragonEgg.class));
        cards.add(new SetCardInfo("Dragon Fodder", 523, Rarity.COMMON, mage.cards.d.DragonFodder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragon Fodder", 76, Rarity.COMMON, mage.cards.d.DragonFodder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragon Mage", 77, Rarity.UNCOMMON, mage.cards.d.DragonMage.class));
        cards.add(new SetCardInfo("Dragon's Hoard", 763, Rarity.RARE, mage.cards.d.DragonsHoard.class));
        cards.add(new SetCardInfo("Dragonlord's Servant", 524, Rarity.UNCOMMON, mage.cards.d.DragonlordsServant.class));
        cards.add(new SetCardInfo("Dragonspeaker Shaman", 525, Rarity.UNCOMMON, mage.cards.d.DragonspeakerShaman.class));
        cards.add(new SetCardInfo("Drannith Stinger", 78, Rarity.COMMON, mage.cards.d.DrannithStinger.class));
        cards.add(new SetCardInfo("Dread Presence", 403, Rarity.RARE, mage.cards.d.DreadPresence.class));
        cards.add(new SetCardInfo("Dread Rider", 404, Rarity.COMMON, mage.cards.d.DreadRider.class));
        cards.add(new SetCardInfo("Dread Slaver", 405, Rarity.RARE, mage.cards.d.DreadSlaver.class));
        cards.add(new SetCardInfo("Dreadful Apathy", 179, Rarity.COMMON, mage.cards.d.DreadfulApathy.class));
        cards.add(new SetCardInfo("Dreadhound", 406, Rarity.UNCOMMON, mage.cards.d.Dreadhound.class));
        cards.add(new SetCardInfo("Drownyard Explorers", 289, Rarity.COMMON, mage.cards.d.DrownyardExplorers.class));
        cards.add(new SetCardInfo("Drowsing Tyrannodon", 648, Rarity.COMMON, mage.cards.d.DrowsingTyrannodon.class));
        cards.add(new SetCardInfo("Drudge Beetle", 649, Rarity.COMMON, mage.cards.d.DrudgeBeetle.class));
        cards.add(new SetCardInfo("Dune Beetle", 407, Rarity.COMMON, mage.cards.d.DuneBeetle.class));
        cards.add(new SetCardInfo("Durable Coilbug", 408, Rarity.COMMON, mage.cards.d.DurableCoilbug.class));
        cards.add(new SetCardInfo("Duskshell Crawler", 650, Rarity.COMMON, mage.cards.d.DuskshellCrawler.class));
        cards.add(new SetCardInfo("Dutiful Replicator", 48, Rarity.COMMON, mage.cards.d.DutifulReplicator.class));
        cards.add(new SetCardInfo("Dwynen's Elite", 651, Rarity.UNCOMMON, mage.cards.d.DwynensElite.class));
        cards.add(new SetCardInfo("Eaten Alive", 409, Rarity.COMMON, mage.cards.e.EatenAlive.class));
        cards.add(new SetCardInfo("Edifice of Authority", 764, Rarity.UNCOMMON, mage.cards.e.EdificeOfAuthority.class));
        cards.add(new SetCardInfo("Eidolon of Rhetoric", 54, Rarity.UNCOMMON, mage.cards.e.EidolonOfRhetoric.class));
        cards.add(new SetCardInfo("Elderleaf Mentor", 652, Rarity.COMMON, mage.cards.e.ElderleafMentor.class));
        cards.add(new SetCardInfo("Electric Revelation", 526, Rarity.COMMON, mage.cards.e.ElectricRevelation.class));
        cards.add(new SetCardInfo("Electrify", 527, Rarity.COMMON, mage.cards.e.Electrify.class));
        cards.add(new SetCardInfo("Elite Instructor", 290, Rarity.COMMON, mage.cards.e.EliteInstructor.class));
        cards.add(new SetCardInfo("Elven Bow", 653, Rarity.UNCOMMON, mage.cards.e.ElvenBow.class));
        cards.add(new SetCardInfo("Elvish Rejuvenator", 88, Rarity.COMMON, mage.cards.e.ElvishRejuvenator.class));
        cards.add(new SetCardInfo("Elvish Warmaster", 654, Rarity.RARE, mage.cards.e.ElvishWarmaster.class));
        cards.add(new SetCardInfo("Emancipation Angel", 55, Rarity.UNCOMMON, mage.cards.e.EmancipationAngel.class));
        cards.add(new SetCardInfo("Emiel the Blessed", 180, Rarity.MYTHIC, mage.cards.e.EmielTheBlessed.class));
        cards.add(new SetCardInfo("Endbringer", 748, Rarity.RARE, mage.cards.e.Endbringer.class));
        cards.add(new SetCardInfo("Endless Ranks of the Dead", 410, Rarity.RARE, mage.cards.e.EndlessRanksOfTheDead.class));
        cards.add(new SetCardInfo("Engulfing Slagwurm", 655, Rarity.RARE, mage.cards.e.EngulfingSlagwurm.class));
        cards.add(new SetCardInfo("Enlarge", 656, Rarity.UNCOMMON, mage.cards.e.Enlarge.class));
        cards.add(new SetCardInfo("Epicure of Blood", 411, Rarity.COMMON, mage.cards.e.EpicureOfBlood.class));
        cards.add(new SetCardInfo("Erdwal Illuminator", 291, Rarity.UNCOMMON, mage.cards.e.ErdwalIlluminator.class));
        cards.add(new SetCardInfo("Eternity Snare", 292, Rarity.UNCOMMON, mage.cards.e.EternitySnare.class));
        cards.add(new SetCardInfo("Eviscerate", 412, Rarity.COMMON, mage.cards.e.Eviscerate.class));
        cards.add(new SetCardInfo("Evolving Wilds", 813, Rarity.COMMON, mage.cards.e.EvolvingWilds.class));
        cards.add(new SetCardInfo("Expedition Map", 765, Rarity.COMMON, mage.cards.e.ExpeditionMap.class));
        cards.add(new SetCardInfo("Explorer's Scope", 766, Rarity.COMMON, mage.cards.e.ExplorersScope.class));
        cards.add(new SetCardInfo("Exsanguinate", 413, Rarity.UNCOMMON, mage.cards.e.Exsanguinate.class));
        cards.add(new SetCardInfo("Eyekite", 293, Rarity.COMMON, mage.cards.e.Eyekite.class));
        cards.add(new SetCardInfo("Faerie Formation", 294, Rarity.RARE, mage.cards.f.FaerieFormation.class));
        cards.add(new SetCardInfo("Faerie Seer", 295, Rarity.COMMON, mage.cards.f.FaerieSeer.class));
        cards.add(new SetCardInfo("Faerie Vandal", 296, Rarity.UNCOMMON, mage.cards.f.FaerieVandal.class));
        cards.add(new SetCardInfo("Faith's Fetters", 181, Rarity.UNCOMMON, mage.cards.f.FaithsFetters.class));
        cards.add(new SetCardInfo("Falkenrath Noble", 414, Rarity.UNCOMMON, mage.cards.f.FalkenrathNoble.class));
        cards.add(new SetCardInfo("Fallowsage", 297, Rarity.UNCOMMON, mage.cards.f.Fallowsage.class));
        cards.add(new SetCardInfo("Fanatical Firebrand", 528, Rarity.COMMON, mage.cards.f.FanaticalFirebrand.class));
        cards.add(new SetCardInfo("Favored of Iroas", 182, Rarity.UNCOMMON, mage.cards.f.FavoredOfIroas.class));
        cards.add(new SetCardInfo("Feast of Blood", 118, Rarity.UNCOMMON, mage.cards.f.FeastOfBlood.class));
        cards.add(new SetCardInfo("Feast on the Fallen", 68, Rarity.UNCOMMON, mage.cards.f.FeastOnTheFallen.class));
        cards.add(new SetCardInfo("Feed the Pack", 657, Rarity.RARE, mage.cards.f.FeedThePack.class));
        cards.add(new SetCardInfo("Felidar Cub", 183, Rarity.COMMON, mage.cards.f.FelidarCub.class));
        cards.add(new SetCardInfo("Felidar Retreat", 184, Rarity.RARE, mage.cards.f.FelidarRetreat.class));
        cards.add(new SetCardInfo("Feral Hydra", 658, Rarity.UNCOMMON, mage.cards.f.FeralHydra.class));
        cards.add(new SetCardInfo("Ferocious Pup", 659, Rarity.COMMON, mage.cards.f.FerociousPup.class));
        cards.add(new SetCardInfo("Fertilid", 660, Rarity.COMMON, mage.cards.f.Fertilid.class));
        cards.add(new SetCardInfo("Fervent Strike", 529, Rarity.COMMON, mage.cards.f.FerventStrike.class));
        cards.add(new SetCardInfo("Festering Evil", 119, Rarity.UNCOMMON, mage.cards.f.FesteringEvil.class));
        cards.add(new SetCardInfo("Fetid Imp", 415, Rarity.COMMON, mage.cards.f.FetidImp.class));
        cards.add(new SetCardInfo("Fierce Witchstalker", 661, Rarity.COMMON, mage.cards.f.FierceWitchstalker.class));
        cards.add(new SetCardInfo("Fiery Conclusion", 530, Rarity.UNCOMMON, mage.cards.f.FieryConclusion.class));
        cards.add(new SetCardInfo("Fiery Intervention", 531, Rarity.COMMON, mage.cards.f.FieryIntervention.class));
        cards.add(new SetCardInfo("Filigree Attendant", 298, Rarity.UNCOMMON, mage.cards.f.FiligreeAttendant.class));
        cards.add(new SetCardInfo("Firebolt", 532, Rarity.COMMON, mage.cards.f.Firebolt.class));
        cards.add(new SetCardInfo("Firecannon Blast", 533, Rarity.COMMON, mage.cards.f.FirecannonBlast.class));
        cards.add(new SetCardInfo("Fireslinger", 130, Rarity.COMMON, mage.cards.f.Fireslinger.class));
        cards.add(new SetCardInfo("Flame Lash", 534, Rarity.COMMON, mage.cards.f.FlameLash.class));
        cards.add(new SetCardInfo("Flameblade Adept", 131, Rarity.UNCOMMON, mage.cards.f.FlamebladeAdept.class));
        cards.add(new SetCardInfo("Flames of the Firebrand", 535, Rarity.UNCOMMON, mage.cards.f.FlamesOfTheFirebrand.class));
        cards.add(new SetCardInfo("Fleeting Distraction", 299, Rarity.COMMON, mage.cards.f.FleetingDistraction.class));
        cards.add(new SetCardInfo("Flicker of Fate", 56, Rarity.COMMON, mage.cards.f.FlickerOfFate.class));
        cards.add(new SetCardInfo("Floodhound", 300, Rarity.COMMON, mage.cards.f.Floodhound.class));
        cards.add(new SetCardInfo("Flourishing Hunter", 662, Rarity.COMMON, mage.cards.f.FlourishingHunter.class));
        cards.add(new SetCardInfo("Forced Worship", 185, Rarity.COMMON, mage.cards.f.ForcedWorship.class));
        cards.add(new SetCardInfo("Forest", 110, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 111, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 112, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forgotten Cave", 814, Rarity.COMMON, mage.cards.f.ForgottenCave.class));
        cards.add(new SetCardInfo("Frenzied Goblin", 536, Rarity.COMMON, mage.cards.f.FrenziedGoblin.class));
        cards.add(new SetCardInfo("Frontier Mastodon", 663, Rarity.COMMON, mage.cards.f.FrontierMastodon.class));
        cards.add(new SetCardInfo("Frostpeak Yeti", 301, Rarity.COMMON, mage.cards.f.FrostpeakYeti.class));
        cards.add(new SetCardInfo("Fungal Infection", 416, Rarity.COMMON, mage.cards.f.FungalInfection.class));
        cards.add(new SetCardInfo("Furnace Whelp", 537, Rarity.UNCOMMON, mage.cards.f.FurnaceWhelp.class));
        cards.add(new SetCardInfo("Gadrak, the Crown-Scourge", 538, Rarity.RARE, mage.cards.g.GadrakTheCrownScourge.class));
        cards.add(new SetCardInfo("Gaea's Protector", 664, Rarity.COMMON, mage.cards.g.GaeasProtector.class));
        cards.add(new SetCardInfo("Gallant Cavalry", 186, Rarity.COMMON, mage.cards.g.GallantCavalry.class));
        cards.add(new SetCardInfo("Gallows Warden", 187, Rarity.UNCOMMON, mage.cards.g.GallowsWarden.class));
        cards.add(new SetCardInfo("Gavony Unhallowed", 417, Rarity.COMMON, mage.cards.g.GavonyUnhallowed.class));
        cards.add(new SetCardInfo("Gearseeker Serpent", 302, Rarity.COMMON, mage.cards.g.GearseekerSerpent.class));
        cards.add(new SetCardInfo("Gearsmith Guardian", 767, Rarity.COMMON, mage.cards.g.GearsmithGuardian.class));
        cards.add(new SetCardInfo("Gearsmith Prodigy", 303, Rarity.COMMON, mage.cards.g.GearsmithProdigy.class));
        cards.add(new SetCardInfo("Ghirapur Guide", 665, Rarity.UNCOMMON, mage.cards.g.GhirapurGuide.class));
        cards.add(new SetCardInfo("Ghoul's Feast", 120, Rarity.COMMON, mage.cards.g.GhoulsFeast.class));
        cards.add(new SetCardInfo("Ghoulraiser", 418, Rarity.COMMON, mage.cards.g.Ghoulraiser.class));
        cards.add(new SetCardInfo("Giant Caterpillar", 666, Rarity.COMMON, mage.cards.g.GiantCaterpillar.class));
        cards.add(new SetCardInfo("Giant Ladybug", 39, Rarity.COMMON, mage.cards.g.GiantLadybug.class));
        cards.add(new SetCardInfo("Giant Ox", 188, Rarity.COMMON, mage.cards.g.GiantOx.class));
        cards.add(new SetCardInfo("Gideon's Lawkeeper", 190, Rarity.COMMON, mage.cards.g.GideonsLawkeeper.class));
        cards.add(new SetCardInfo("Gideon, Champion of Justice", 189, Rarity.MYTHIC, mage.cards.g.GideonChampionOfJustice.class));
        cards.add(new SetCardInfo("Gift of the Gargantuan", 667, Rarity.COMMON, mage.cards.g.GiftOfTheGargantuan.class));
        cards.add(new SetCardInfo("Gigantoplasm", 304, Rarity.RARE, mage.cards.g.Gigantoplasm.class));
        cards.add(new SetCardInfo("Gleaming Barrier", 768, Rarity.COMMON, mage.cards.g.GleamingBarrier.class));
        cards.add(new SetCardInfo("Glen Elendra Pranksters", 305, Rarity.UNCOMMON, mage.cards.g.GlenElendraPranksters.class));
        cards.add(new SetCardInfo("Glint-Horn Buccaneer", 539, Rarity.RARE, mage.cards.g.GlintHornBuccaneer.class));
        cards.add(new SetCardInfo("Glory Bearers", 191, Rarity.COMMON, mage.cards.g.GloryBearers.class));
        cards.add(new SetCardInfo("Gnawing Zombie", 419, Rarity.COMMON, mage.cards.g.GnawingZombie.class));
        cards.add(new SetCardInfo("Go for Blood", 540, Rarity.COMMON, mage.cards.g.GoForBlood.class));
        cards.add(new SetCardInfo("Goblin Artillery", 541, Rarity.UNCOMMON, mage.cards.g.GoblinArtillery.class));
        cards.add(new SetCardInfo("Goblin Grenade", 542, Rarity.UNCOMMON, mage.cards.g.GoblinGrenade.class));
        cards.add(new SetCardInfo("Goblin Oriflamme", 543, Rarity.UNCOMMON, mage.cards.g.GoblinOriflamme.class));
        cards.add(new SetCardInfo("Goblin Psychopath", 544, Rarity.UNCOMMON, mage.cards.g.GoblinPsychopath.class));
        cards.add(new SetCardInfo("Goblin Rabblemaster", 545, Rarity.RARE, mage.cards.g.GoblinRabblemaster.class));
        cards.add(new SetCardInfo("Goblin Rally", 546, Rarity.UNCOMMON, mage.cards.g.GoblinRally.class));
        cards.add(new SetCardInfo("Goblin Researcher", 34, Rarity.COMMON, mage.cards.g.GoblinResearcher.class));
        cards.add(new SetCardInfo("Goblin Trailblazer", 547, Rarity.COMMON, mage.cards.g.GoblinTrailblazer.class));
        cards.add(new SetCardInfo("Goblin Warchief", 548, Rarity.UNCOMMON, mage.cards.g.GoblinWarchief.class));
        cards.add(new SetCardInfo("Goldhound", 549, Rarity.COMMON, mage.cards.g.Goldhound.class));
        cards.add(new SetCardInfo("Goldnight Commander", 192, Rarity.UNCOMMON, mage.cards.g.GoldnightCommander.class));
        cards.add(new SetCardInfo("Goldspan Dragon", 550, Rarity.MYTHIC, mage.cards.g.GoldspanDragon.class));
        cards.add(new SetCardInfo("Goldvein Pick", 769, Rarity.COMMON, mage.cards.g.GoldveinPick.class));
        cards.add(new SetCardInfo("Golem Artisan", 770, Rarity.UNCOMMON, mage.cards.g.GolemArtisan.class));
        cards.add(new SetCardInfo("Goreclaw, Terror of Qal Sisma", 668, Rarity.RARE, mage.cards.g.GoreclawTerrorOfQalSisma.class));
        cards.add(new SetCardInfo("Gorging Vulture", 420, Rarity.COMMON, mage.cards.g.GorgingVulture.class));
        cards.add(new SetCardInfo("Graf Harvest", 421, Rarity.UNCOMMON, mage.cards.g.GrafHarvest.class));
        cards.add(new SetCardInfo("Graveblade Marauder", 422, Rarity.RARE, mage.cards.g.GravebladeMarauder.class));
        cards.add(new SetCardInfo("Gravecrawler", 423, Rarity.RARE, mage.cards.g.Gravecrawler.class));
        cards.add(new SetCardInfo("Gravedigger", 424, Rarity.UNCOMMON, mage.cards.g.Gravedigger.class));
        cards.add(new SetCardInfo("Grotag Night-Runner", 551, Rarity.UNCOMMON, mage.cards.g.GrotagNightRunner.class));
        cards.add(new SetCardInfo("Grotesque Mutation", 425, Rarity.COMMON, mage.cards.g.GrotesqueMutation.class));
        cards.add(new SetCardInfo("Groundswell", 669, Rarity.COMMON, mage.cards.g.Groundswell.class));
        cards.add(new SetCardInfo("Hammer of Ruin", 771, Rarity.UNCOMMON, mage.cards.h.HammerOfRuin.class));
        cards.add(new SetCardInfo("Hangarback Walker", 772, Rarity.RARE, mage.cards.h.HangarbackWalker.class));
        cards.add(new SetCardInfo("Harbinger of the Tides", 306, Rarity.RARE, mage.cards.h.HarbingerOfTheTides.class));
        cards.add(new SetCardInfo("Havenwood Wurm", 670, Rarity.COMMON, mage.cards.h.HavenwoodWurm.class));
        cards.add(new SetCardInfo("Heart-Piercer Bow", 773, Rarity.COMMON, mage.cards.h.HeartPiercerBow.class));
        cards.add(new SetCardInfo("Hedron Archive", 774, Rarity.UNCOMMON, mage.cards.h.HedronArchive.class));
        cards.add(new SetCardInfo("Heirloom Blade", 775, Rarity.UNCOMMON, mage.cards.h.HeirloomBlade.class));
        cards.add(new SetCardInfo("Hero's Blade", 776, Rarity.UNCOMMON, mage.cards.h.HerosBlade.class));
        cards.add(new SetCardInfo("Hieroglyphic Illumination", 307, Rarity.COMMON, mage.cards.h.HieroglyphicIllumination.class));
        cards.add(new SetCardInfo("Hold for Questioning", 11, Rarity.UNCOMMON, mage.cards.h.HoldForQuestioning.class));
        cards.add(new SetCardInfo("Hooded Assassin", 426, Rarity.COMMON, mage.cards.h.HoodedAssassin.class));
        cards.add(new SetCardInfo("Hooting Mandrills", 671, Rarity.COMMON, mage.cards.h.HootingMandrills.class));
        cards.add(new SetCardInfo("Hordeling Outburst", 552, Rarity.UNCOMMON, mage.cards.h.HordelingOutburst.class));
        cards.add(new SetCardInfo("Hotshot Mechanic", 193, Rarity.UNCOMMON, mage.cards.h.HotshotMechanic.class));
        cards.add(new SetCardInfo("Hour of Reckoning", 194, Rarity.RARE, mage.cards.h.HourOfReckoning.class));
        cards.add(new SetCardInfo("Howl of the Hunt", 672, Rarity.COMMON, mage.cards.h.HowlOfTheHunt.class));
        cards.add(new SetCardInfo("Howlgeist", 673, Rarity.UNCOMMON, mage.cards.h.Howlgeist.class));
        cards.add(new SetCardInfo("Hunger of the Howlpack", 674, Rarity.COMMON, mage.cards.h.HungerOfTheHowlpack.class));
        cards.add(new SetCardInfo("Hungry Flames", 553, Rarity.COMMON, mage.cards.h.HungryFlames.class));
        cards.add(new SetCardInfo("Hunter's Edge", 675, Rarity.COMMON, mage.cards.h.HuntersEdge.class));
        cards.add(new SetCardInfo("Hydra's Growth", 89, Rarity.UNCOMMON, mage.cards.h.HydrasGrowth.class));
        cards.add(new SetCardInfo("Ib Halfheart, Goblin Tactician", 554, Rarity.RARE, mage.cards.i.IbHalfheartGoblinTactician.class));
        cards.add(new SetCardInfo("Icebind Pillar", 308, Rarity.UNCOMMON, mage.cards.i.IcebindPillar.class));
        cards.add(new SetCardInfo("Ignite the Future", 555, Rarity.RARE, mage.cards.i.IgniteTheFuture.class));
        cards.add(new SetCardInfo("Ill-Gotten Inheritance", 427, Rarity.COMMON, mage.cards.i.IllGottenInheritance.class));
        cards.add(new SetCardInfo("Ilysian Caryatid", 676, Rarity.COMMON, mage.cards.i.IlysianCaryatid.class));
        cards.add(new SetCardInfo("Immersturm Raider", 556, Rarity.COMMON, mage.cards.i.ImmersturmRaider.class));
        cards.add(new SetCardInfo("Impeccable Timing", 195, Rarity.COMMON, mage.cards.i.ImpeccableTiming.class));
        cards.add(new SetCardInfo("Impending Doom", 557, Rarity.UNCOMMON, mage.cards.i.ImpendingDoom.class));
        cards.add(new SetCardInfo("Imperial Aerosaur", 196, Rarity.UNCOMMON, mage.cards.i.ImperialAerosaur.class));
        cards.add(new SetCardInfo("Imperial Recovery Unit", 197, Rarity.UNCOMMON, mage.cards.i.ImperialRecoveryUnit.class));
        cards.add(new SetCardInfo("Imperious Perfect", 677, Rarity.RARE, mage.cards.i.ImperiousPerfect.class));
        cards.add(new SetCardInfo("Improvised Weaponry", 558, Rarity.COMMON, mage.cards.i.ImprovisedWeaponry.class));
        cards.add(new SetCardInfo("Infantry Veteran", 198, Rarity.COMMON, mage.cards.i.InfantryVeteran.class));
        cards.add(new SetCardInfo("Infernal Idol", 49, Rarity.COMMON, mage.cards.i.InfernalIdol.class));
        cards.add(new SetCardInfo("Infiltration Lens", 777, Rarity.UNCOMMON, mage.cards.i.InfiltrationLens.class));
        cards.add(new SetCardInfo("Ingenious Leonin", 5, Rarity.UNCOMMON, mage.cards.i.IngeniousLeonin.class));
        cards.add(new SetCardInfo("Inner Demon", 428, Rarity.UNCOMMON, mage.cards.i.InnerDemon.class));
        cards.add(new SetCardInfo("Inspiring Cleric", 199, Rarity.UNCOMMON, mage.cards.i.InspiringCleric.class));
        cards.add(new SetCardInfo("Inspiring Overseer", 200, Rarity.COMMON, mage.cards.i.InspiringOverseer.class));
        cards.add(new SetCardInfo("Instruments of War", 50, Rarity.UNCOMMON, mage.cards.i.InstrumentsOfWar.class));
        cards.add(new SetCardInfo("Interpret the Signs", 309, Rarity.UNCOMMON, mage.cards.i.InterpretTheSigns.class));
        cards.add(new SetCardInfo("Irencrag Pyromancer", 559, Rarity.RARE, mage.cards.i.IrencragPyromancer.class));
        cards.add(new SetCardInfo("Iridescent Hornbeetle", 678, Rarity.UNCOMMON, mage.cards.i.IridescentHornbeetle.class));
        cards.add(new SetCardInfo("Iron Bully", 778, Rarity.COMMON, mage.cards.i.IronBully.class));
        cards.add(new SetCardInfo("Ironshell Beetle", 679, Rarity.COMMON, mage.cards.i.IronshellBeetle.class));
        cards.add(new SetCardInfo("Irreverent Revelers", 560, Rarity.COMMON, mage.cards.i.IrreverentRevelers.class));
        cards.add(new SetCardInfo("Isamaru, Hound of Konda", 201, Rarity.RARE, mage.cards.i.IsamaruHoundOfKonda.class));
        cards.add(new SetCardInfo("Island", 101, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 102, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 103, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Isu the Abominable", 12, Rarity.MYTHIC, mage.cards.i.IsuTheAbominable.class));
        cards.add(new SetCardInfo("Ivy Lane Denizen", 680, Rarity.COMMON, mage.cards.i.IvyLaneDenizen.class));
        cards.add(new SetCardInfo("Jace's Scrutiny", 311, Rarity.COMMON, mage.cards.j.JacesScrutiny.class));
        cards.add(new SetCardInfo("Jace, Arcane Strategist", 310, Rarity.MYTHIC, mage.cards.j.JaceArcaneStrategist.class));
        cards.add(new SetCardInfo("Jousting Lance", 779, Rarity.COMMON, mage.cards.j.JoustingLance.class));
        cards.add(new SetCardInfo("Juggernaut", 780, Rarity.UNCOMMON, mage.cards.j.Juggernaut.class));
        cards.add(new SetCardInfo("Justiciar's Portal", 202, Rarity.COMMON, mage.cards.j.JusticiarsPortal.class));
        cards.add(new SetCardInfo("Kalastria Nightwatch", 429, Rarity.COMMON, mage.cards.k.KalastriaNightwatch.class));
        cards.add(new SetCardInfo("Kami of Ancient Law", 203, Rarity.COMMON, mage.cards.k.KamiOfAncientLaw.class));
        cards.add(new SetCardInfo("Karfell Kennel-Master", 430, Rarity.COMMON, mage.cards.k.KarfellKennelMaster.class));
        cards.add(new SetCardInfo("Kargan Dragonrider", 561, Rarity.COMMON, mage.cards.k.KarganDragonrider.class));
        cards.add(new SetCardInfo("Kari Zev, Skyship Raider", 562, Rarity.RARE, mage.cards.k.KariZevSkyshipRaider.class));
        cards.add(new SetCardInfo("Karn Liberated", 97, Rarity.MYTHIC, mage.cards.k.KarnLiberated.class));
        cards.add(new SetCardInfo("Kasmina, Enigmatic Mentor", 60, Rarity.UNCOMMON, mage.cards.k.KasminaEnigmaticMentor.class));
        cards.add(new SetCardInfo("Keldon Raider", 563, Rarity.COMMON, mage.cards.k.KeldonRaider.class));
        cards.add(new SetCardInfo("Kenessos, Priest of Thassa", 13, Rarity.RARE, mage.cards.k.KenessosPriestOfThassa.class));
        cards.add(new SetCardInfo("Kessig Cagebreakers", 681, Rarity.RARE, mage.cards.k.KessigCagebreakers.class));
        cards.add(new SetCardInfo("Khalni Heart Expedition", 90, Rarity.COMMON, mage.cards.k.KhalniHeartExpedition.class));
        cards.add(new SetCardInfo("Kibo, Uktabi Prince", 40, Rarity.MYTHIC, mage.cards.k.KiboUktabiPrince.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kibo, Uktabi Prince", 835, Rarity.MYTHIC, mage.cards.k.KiboUktabiPrince.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kiki-Jiki, Mirror Breaker", 79, Rarity.MYTHIC, mage.cards.k.KikiJikiMirrorBreaker.class));
        cards.add(new SetCardInfo("King of the Pride", 57, Rarity.UNCOMMON, mage.cards.k.KingOfThePride.class));
        cards.add(new SetCardInfo("Kitesail", 781, Rarity.COMMON, mage.cards.k.Kitesail.class));
        cards.add(new SetCardInfo("Kitsune Ace", 204, Rarity.COMMON, mage.cards.k.KitsuneAce.class));
        cards.add(new SetCardInfo("Kothophed, Soul Hoarder", 431, Rarity.RARE, mage.cards.k.KothophedSoulHoarder.class));
        cards.add(new SetCardInfo("Kraul Foragers", 682, Rarity.COMMON, mage.cards.k.KraulForagers.class));
        cards.add(new SetCardInfo("Kraul Harpooner", 683, Rarity.UNCOMMON, mage.cards.k.KraulHarpooner.class));
        cards.add(new SetCardInfo("Kraul Swarm", 432, Rarity.UNCOMMON, mage.cards.k.KraulSwarm.class));
        cards.add(new SetCardInfo("Kraul Warrior", 684, Rarity.COMMON, mage.cards.k.KraulWarrior.class));
        cards.add(new SetCardInfo("Krenko, Mob Boss", 564, Rarity.RARE, mage.cards.k.KrenkoMobBoss.class));
        cards.add(new SetCardInfo("Kujar Seedsculptor", 685, Rarity.COMMON, mage.cards.k.KujarSeedsculptor.class));
        cards.add(new SetCardInfo("Kuldotha Flamefiend", 565, Rarity.UNCOMMON, mage.cards.k.KuldothaFlamefiend.class));
        cards.add(new SetCardInfo("Kwende, Pride of Femeref", 205, Rarity.UNCOMMON, mage.cards.k.KwendePrideOfFemeref.class));
        cards.add(new SetCardInfo("Lathliss, Dragon Queen", 566, Rarity.RARE, mage.cards.l.LathlissDragonQueen.class));
        cards.add(new SetCardInfo("Launch Mishap", 14, Rarity.UNCOMMON, mage.cards.l.LaunchMishap.class));
        cards.add(new SetCardInfo("Lava Serpent", 567, Rarity.COMMON, mage.cards.l.LavaSerpent.class));
        cards.add(new SetCardInfo("Lavastep Raider", 568, Rarity.COMMON, mage.cards.l.LavastepRaider.class));
        cards.add(new SetCardInfo("Law-Rune Enforcer", 206, Rarity.COMMON, mage.cards.l.LawRuneEnforcer.class));
        cards.add(new SetCardInfo("Lay Claim", 312, Rarity.UNCOMMON, mage.cards.l.LayClaim.class));
        cards.add(new SetCardInfo("Leave in the Dust", 313, Rarity.COMMON, mage.cards.l.LeaveInTheDust.class));
        cards.add(new SetCardInfo("Leechridden Swamp", 137, Rarity.UNCOMMON, mage.cards.l.LeechriddenSwamp.class));
        cards.add(new SetCardInfo("Leonin Scimitar", 782, Rarity.COMMON, mage.cards.l.LeoninScimitar.class));
        cards.add(new SetCardInfo("Leonin Snarecaster", 207, Rarity.COMMON, mage.cards.l.LeoninSnarecaster.class));
        cards.add(new SetCardInfo("Leonin Warleader", 208, Rarity.RARE, mage.cards.l.LeoninWarleader.class));
        cards.add(new SetCardInfo("Library Larcenist", 314, Rarity.COMMON, mage.cards.l.LibraryLarcenist.class));
        cards.add(new SetCardInfo("Light of Hope", 209, Rarity.COMMON, mage.cards.l.LightOfHope.class));
        cards.add(new SetCardInfo("Lightning Axe", 569, Rarity.UNCOMMON, mage.cards.l.LightningAxe.class));
        cards.add(new SetCardInfo("Liliana's Elite", 434, Rarity.UNCOMMON, mage.cards.l.LilianasElite.class));
        cards.add(new SetCardInfo("Liliana's Mastery", 435, Rarity.RARE, mage.cards.l.LilianasMastery.class));
        cards.add(new SetCardInfo("Liliana's Steward", 436, Rarity.COMMON, mage.cards.l.LilianasSteward.class));
        cards.add(new SetCardInfo("Liliana, Death's Majesty", 433, Rarity.MYTHIC, mage.cards.l.LilianaDeathsMajesty.class));
        cards.add(new SetCardInfo("Lita, Mechanical Engineer", 6, Rarity.MYTHIC, mage.cards.l.LitaMechanicalEngineer.class));
        cards.add(new SetCardInfo("Littjara Kinseekers", 315, Rarity.COMMON, mage.cards.l.LittjaraKinseekers.class));
        cards.add(new SetCardInfo("Locthwain Gargoyle", 783, Rarity.COMMON, mage.cards.l.LocthwainGargoyle.class));
        cards.add(new SetCardInfo("Lookout's Dispersal", 316, Rarity.UNCOMMON, mage.cards.l.LookoutsDispersal.class));
        cards.add(new SetCardInfo("Lord of the Accursed", 69, Rarity.UNCOMMON, mage.cards.l.LordOfTheAccursed.class));
        cards.add(new SetCardInfo("Loxodon Warhammer", 784, Rarity.RARE, mage.cards.l.LoxodonWarhammer.class));
        cards.add(new SetCardInfo("Lumengrid Sentinel", 317, Rarity.UNCOMMON, mage.cards.l.LumengridSentinel.class));
        cards.add(new SetCardInfo("Lurking Deadeye", 437, Rarity.COMMON, mage.cards.l.LurkingDeadeye.class));
        cards.add(new SetCardInfo("Lyra Dawnbringer", 210, Rarity.MYTHIC, mage.cards.l.LyraDawnbringer.class));
        cards.add(new SetCardInfo("Lys Alana Huntmaster", 686, Rarity.COMMON, mage.cards.l.LysAlanaHuntmaster.class));
        cards.add(new SetCardInfo("Maalfeld Twins", 438, Rarity.COMMON, mage.cards.m.MaalfeldTwins.class));
        cards.add(new SetCardInfo("Mad Ratter", 570, Rarity.UNCOMMON, mage.cards.m.MadRatter.class));
        cards.add(new SetCardInfo("Magmatic Channeler", 571, Rarity.RARE, mage.cards.m.MagmaticChanneler.class));
        cards.add(new SetCardInfo("Magnanimous Magistrate", 7, Rarity.UNCOMMON, mage.cards.m.MagnanimousMagistrate.class));
        cards.add(new SetCardInfo("Magnifying Glass", 95, Rarity.UNCOMMON, mage.cards.m.MagnifyingGlass.class));
        cards.add(new SetCardInfo("Make a Stand", 211, Rarity.UNCOMMON, mage.cards.m.MakeAStand.class));
        cards.add(new SetCardInfo("Mammoth Spider", 687, Rarity.COMMON, mage.cards.m.MammothSpider.class));
        cards.add(new SetCardInfo("Manakin", 785, Rarity.COMMON, mage.cards.m.Manakin.class));
        cards.add(new SetCardInfo("Mantle of Tides", 318, Rarity.COMMON, mage.cards.m.MantleOfTides.class));
        cards.add(new SetCardInfo("Marauding Blight-Priest", 439, Rarity.COMMON, mage.cards.m.MaraudingBlightPriest.class));
        cards.add(new SetCardInfo("Marauding Boneslasher", 440, Rarity.COMMON, mage.cards.m.MaraudingBoneslasher.class));
        cards.add(new SetCardInfo("Mardu Heart-Piercer", 572, Rarity.UNCOMMON, mage.cards.m.MarduHeartPiercer.class));
        cards.add(new SetCardInfo("Marit Lage's Slumber", 319, Rarity.RARE, mage.cards.m.MaritLagesSlumber.class));
        cards.add(new SetCardInfo("Markov Warlord", 573, Rarity.UNCOMMON, mage.cards.m.MarkovWarlord.class));
        cards.add(new SetCardInfo("Martyr's Soul", 212, Rarity.COMMON, mage.cards.m.MartyrsSoul.class));
        cards.add(new SetCardInfo("Massacre Wurm", 441, Rarity.MYTHIC, mage.cards.m.MassacreWurm.class));
        cards.add(new SetCardInfo("Master of the Wild Hunt", 688, Rarity.MYTHIC, mage.cards.m.MasterOfTheWildHunt.class));
        cards.add(new SetCardInfo("Master's Rebuke", 689, Rarity.COMMON, mage.cards.m.MastersRebuke.class));
        cards.add(new SetCardInfo("Mausoleum Guard", 213, Rarity.UNCOMMON, mage.cards.m.MausoleumGuard.class));
        cards.add(new SetCardInfo("Mechanized Production", 320, Rarity.MYTHIC, mage.cards.m.MechanizedProduction.class));
        cards.add(new SetCardInfo("Memorial to Genius", 815, Rarity.UNCOMMON, mage.cards.m.MemorialToGenius.class));
        cards.add(new SetCardInfo("Merfolk Pupil", 15, Rarity.COMMON, mage.cards.m.MerfolkPupil.class));
        cards.add(new SetCardInfo("Merfolk Sovereign", 321, Rarity.RARE, mage.cards.m.MerfolkSovereign.class));
        cards.add(new SetCardInfo("Merrow Reejerey", 61, Rarity.UNCOMMON, mage.cards.m.MerrowReejerey.class));
        cards.add(new SetCardInfo("Mesa Lynx", 214, Rarity.COMMON, mage.cards.m.MesaLynx.class));
        cards.add(new SetCardInfo("Meteor Golem", 786, Rarity.UNCOMMON, mage.cards.m.MeteorGolem.class));
        cards.add(new SetCardInfo("Michiko Konda, Truth Seeker", 215, Rarity.RARE, mage.cards.m.MichikoKondaTruthSeeker.class));
        cards.add(new SetCardInfo("Midnight Guard", 216, Rarity.COMMON, mage.cards.m.MidnightGuard.class));
        cards.add(new SetCardInfo("Might of the Masses", 690, Rarity.COMMON, mage.cards.m.MightOfTheMasses.class));
        cards.add(new SetCardInfo("Mild-Mannered Librarian", 41, Rarity.UNCOMMON, mage.cards.m.MildManneredLibrarian.class));
        cards.add(new SetCardInfo("Military Intelligence", 322, Rarity.UNCOMMON, mage.cards.m.MilitaryIntelligence.class));
        cards.add(new SetCardInfo("Miraculous Recovery", 217, Rarity.UNCOMMON, mage.cards.m.MiraculousRecovery.class));
        cards.add(new SetCardInfo("Mire Blight", 442, Rarity.COMMON, mage.cards.m.MireBlight.class));
        cards.add(new SetCardInfo("Mire Triton", 443, Rarity.UNCOMMON, mage.cards.m.MireTriton.class));
        cards.add(new SetCardInfo("Mirror Image", 62, Rarity.UNCOMMON, mage.cards.m.MirrorImage.class));
        cards.add(new SetCardInfo("Mishra's Factory", 816, Rarity.UNCOMMON, mage.cards.m.MishrasFactory.class));
        cards.add(new SetCardInfo("Mistwalker", 323, Rarity.COMMON, mage.cards.m.Mistwalker.class));
        cards.add(new SetCardInfo("Mizzix, Replica Rider", 35, Rarity.RARE, mage.cards.m.MizzixReplicaRider.class));
        cards.add(new SetCardInfo("Moldgraf Millipede", 691, Rarity.COMMON, mage.cards.m.MoldgrafMillipede.class));
        cards.add(new SetCardInfo("Moment of Craving", 444, Rarity.COMMON, mage.cards.m.MomentOfCraving.class));
        cards.add(new SetCardInfo("Moment of Triumph", 218, Rarity.COMMON, mage.cards.m.MomentOfTriumph.class));
        cards.add(new SetCardInfo("Monkey Cage", 787, Rarity.RARE, mage.cards.m.MonkeyCage.class));
        cards.add(new SetCardInfo("Moodmark Painter", 445, Rarity.COMMON, mage.cards.m.MoodmarkPainter.class));
        cards.add(new SetCardInfo("Moonfolk Puzzlemaker", 324, Rarity.COMMON, mage.cards.m.MoonfolkPuzzlemaker.class));
        cards.add(new SetCardInfo("Moonlight Hunt", 692, Rarity.UNCOMMON, mage.cards.m.MoonlightHunt.class));
        cards.add(new SetCardInfo("Morkrut Banshee", 121, Rarity.UNCOMMON, mage.cards.m.MorkrutBanshee.class));
        cards.add(new SetCardInfo("Mortuary Mire", 817, Rarity.COMMON, mage.cards.m.MortuaryMire.class));
        cards.add(new SetCardInfo("Mountain", 107, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 108, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 109, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mudbutton Torchrunner", 574, Rarity.COMMON, mage.cards.m.MudbuttonTorchrunner.class));
        cards.add(new SetCardInfo("Multiple Choice", 325, Rarity.RARE, mage.cards.m.MultipleChoice.class));
        cards.add(new SetCardInfo("Murder Investigation", 219, Rarity.UNCOMMON, mage.cards.m.MurderInvestigation.class));
        cards.add(new SetCardInfo("Muxus, Goblin Grandee", 575, Rarity.RARE, mage.cards.m.MuxusGoblinGrandee.class));
        cards.add(new SetCardInfo("Mystic Skyfish", 326, Rarity.COMMON, mage.cards.m.MysticSkyfish.class));
        cards.add(new SetCardInfo("Naga Vitalist", 693, Rarity.COMMON, mage.cards.n.NagaVitalist.class));
        cards.add(new SetCardInfo("Nantuko Cultivator", 694, Rarity.UNCOMMON, mage.cards.n.NantukoCultivator.class));
        cards.add(new SetCardInfo("Necromancer's Stockpile", 446, Rarity.RARE, mage.cards.n.NecromancersStockpile.class));
        cards.add(new SetCardInfo("Necrotic Wound", 447, Rarity.UNCOMMON, mage.cards.n.NecroticWound.class));
        cards.add(new SetCardInfo("Nessian Hornbeetle", 695, Rarity.UNCOMMON, mage.cards.n.NessianHornbeetle.class));
        cards.add(new SetCardInfo("Nest Robber", 576, Rarity.COMMON, mage.cards.n.NestRobber.class));
        cards.add(new SetCardInfo("Nested Ghoul", 448, Rarity.UNCOMMON, mage.cards.n.NestedGhoul.class));
        cards.add(new SetCardInfo("Neutralize", 327, Rarity.UNCOMMON, mage.cards.n.Neutralize.class));
        cards.add(new SetCardInfo("Nezumi Bone-Reader", 122, Rarity.UNCOMMON, mage.cards.n.NezumiBoneReader.class));
        cards.add(new SetCardInfo("Nightguard Patrol", 220, Rarity.COMMON, mage.cards.n.NightguardPatrol.class));
        cards.add(new SetCardInfo("Nightpack Ambusher", 696, Rarity.RARE, mage.cards.n.NightpackAmbusher.class));
        cards.add(new SetCardInfo("Ninth Bridge Patrol", 221, Rarity.COMMON, mage.cards.n.NinthBridgePatrol.class));
        cards.add(new SetCardInfo("Nirkana Assassin", 449, Rarity.COMMON, mage.cards.n.NirkanaAssassin.class));
        cards.add(new SetCardInfo("No Escape", 328, Rarity.COMMON, mage.cards.n.NoEscape.class));
        cards.add(new SetCardInfo("Not Forgotten", 222, Rarity.UNCOMMON, mage.cards.n.NotForgotten.class));
        cards.add(new SetCardInfo("Oashra Cultivator", 697, Rarity.COMMON, mage.cards.o.OashraCultivator.class));
        cards.add(new SetCardInfo("Oathsworn Vampire", 70, Rarity.UNCOMMON, mage.cards.o.OathswornVampire.class));
        cards.add(new SetCardInfo("Ob Nixilis's Cruelty", 451, Rarity.COMMON, mage.cards.o.ObNixilissCruelty.class));
        cards.add(new SetCardInfo("Ob Nixilis, the Hate-Twisted", 450, Rarity.UNCOMMON, mage.cards.o.ObNixilisTheHateTwisted.class));
        cards.add(new SetCardInfo("Octoprophet", 329, Rarity.COMMON, mage.cards.o.Octoprophet.class));
        cards.add(new SetCardInfo("Ogre Battlecaster", 36, Rarity.RARE, mage.cards.o.OgreBattlecaster.class));
        cards.add(new SetCardInfo("Ogre Slumlord", 71, Rarity.RARE, mage.cards.o.OgreSlumlord.class));
        cards.add(new SetCardInfo("Ondu Giant", 698, Rarity.COMMON, mage.cards.o.OnduGiant.class));
        cards.add(new SetCardInfo("One With the Wind", 330, Rarity.COMMON, mage.cards.o.OneWithTheWind.class));
        cards.add(new SetCardInfo("Oneirophage", 331, Rarity.UNCOMMON, mage.cards.o.Oneirophage.class));
        cards.add(new SetCardInfo("Ophiomancer", 452, Rarity.RARE, mage.cards.o.Ophiomancer.class));
        cards.add(new SetCardInfo("Opt", 332, Rarity.COMMON, mage.cards.o.Opt.class));
        cards.add(new SetCardInfo("Ordeal of Nylea", 699, Rarity.UNCOMMON, mage.cards.o.OrdealOfNylea.class));
        cards.add(new SetCardInfo("Ordeal of Purphoros", 577, Rarity.UNCOMMON, mage.cards.o.OrdealOfPurphoros.class));
        cards.add(new SetCardInfo("Order of the Golden Cricket", 223, Rarity.COMMON, mage.cards.o.OrderOfTheGoldenCricket.class));
        cards.add(new SetCardInfo("Ornery Dilophosaur", 700, Rarity.COMMON, mage.cards.o.OrneryDilophosaur.class));
        cards.add(new SetCardInfo("Ossuary Rats", 24, Rarity.COMMON, mage.cards.o.OssuaryRats.class));
        cards.add(new SetCardInfo("Outnumber", 578, Rarity.COMMON, mage.cards.o.Outnumber.class));
        cards.add(new SetCardInfo("Overcome", 701, Rarity.UNCOMMON, mage.cards.o.Overcome.class));
        cards.add(new SetCardInfo("Overgrowth", 702, Rarity.COMMON, mage.cards.o.Overgrowth.class));
        cards.add(new SetCardInfo("Oversold Cemetery", 453, Rarity.RARE, mage.cards.o.OversoldCemetery.class));
        cards.add(new SetCardInfo("Overwhelmed Apprentice", 333, Rarity.UNCOMMON, mage.cards.o.OverwhelmedApprentice.class));
        cards.add(new SetCardInfo("Packsong Pup", 703, Rarity.UNCOMMON, mage.cards.p.PacksongPup.class));
        cards.add(new SetCardInfo("Panharmonicon", 788, Rarity.RARE, mage.cards.p.Panharmonicon.class));
        cards.add(new SetCardInfo("Paradise Druid", 704, Rarity.UNCOMMON, mage.cards.p.ParadiseDruid.class));
        cards.add(new SetCardInfo("Peacewalker Colossus", 96, Rarity.RARE, mage.cards.p.PeacewalkerColossus.class));
        cards.add(new SetCardInfo("Perilous Voyage", 334, Rarity.UNCOMMON, mage.cards.p.PerilousVoyage.class));
        cards.add(new SetCardInfo("Pestermite", 335, Rarity.COMMON, mage.cards.p.Pestermite.class));
        cards.add(new SetCardInfo("Pestilent Wolf", 705, Rarity.COMMON, mage.cards.p.PestilentWolf.class));
        cards.add(new SetCardInfo("Phalanx Tactics", 224, Rarity.UNCOMMON, mage.cards.p.PhalanxTactics.class));
        cards.add(new SetCardInfo("Phantom Nantuko", 706, Rarity.RARE, mage.cards.p.PhantomNantuko.class));
        cards.add(new SetCardInfo("Phyrexian Debaser", 454, Rarity.COMMON, mage.cards.p.PhyrexianDebaser.class));
        cards.add(new SetCardInfo("Phyrexian Ironfoot", 789, Rarity.UNCOMMON, mage.cards.p.PhyrexianIronfoot.class));
        cards.add(new SetCardInfo("Phyrexian Plaguelord", 123, Rarity.RARE, mage.cards.p.PhyrexianPlaguelord.class));
        cards.add(new SetCardInfo("Phyrexian Reclamation", 124, Rarity.UNCOMMON, mage.cards.p.PhyrexianReclamation.class));
        cards.add(new SetCardInfo("Pierce Strider", 790, Rarity.UNCOMMON, mage.cards.p.PierceStrider.class));
        cards.add(new SetCardInfo("Pilfering Hawk", 336, Rarity.COMMON, mage.cards.p.PilferingHawk.class));
        cards.add(new SetCardInfo("Pilgrim of the Ages", 225, Rarity.COMMON, mage.cards.p.PilgrimOfTheAges.class));
        cards.add(new SetCardInfo("Pilgrim's Eye", 791, Rarity.COMMON, mage.cards.p.PilgrimsEye.class));
        cards.add(new SetCardInfo("Pillar of Flame", 579, Rarity.COMMON, mage.cards.p.PillarOfFlame.class));
        cards.add(new SetCardInfo("Pillardrop Rescuer", 226, Rarity.COMMON, mage.cards.p.PillardropRescuer.class));
        cards.add(new SetCardInfo("Pious Wayfarer", 227, Rarity.COMMON, mage.cards.p.PiousWayfarer.class));
        cards.add(new SetCardInfo("Piranha Marsh", 818, Rarity.COMMON, mage.cards.p.PiranhaMarsh.class));
        cards.add(new SetCardInfo("Pirated Copy", 16, Rarity.MYTHIC, mage.cards.p.PiratedCopy.class));
        cards.add(new SetCardInfo("Pit Keeper", 455, Rarity.COMMON, mage.cards.p.PitKeeper.class));
        cards.add(new SetCardInfo("Plague Spitter", 456, Rarity.UNCOMMON, mage.cards.p.PlagueSpitter.class));
        cards.add(new SetCardInfo("Plaguecrafter", 72, Rarity.UNCOMMON, mage.cards.p.Plaguecrafter.class));
        cards.add(new SetCardInfo("Plains", 100, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 98, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 99, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Planar Atlas", 51, Rarity.UNCOMMON, mage.cards.p.PlanarAtlas.class));
        cards.add(new SetCardInfo("Plundering Predator", 37, Rarity.COMMON, mage.cards.p.PlunderingPredator.class));
        cards.add(new SetCardInfo("Pounce", 707, Rarity.COMMON, mage.cards.p.Pounce.class));
        cards.add(new SetCardInfo("Pouncing Lynx", 228, Rarity.COMMON, mage.cards.p.PouncingLynx.class));
        cards.add(new SetCardInfo("Predator's Howl", 708, Rarity.UNCOMMON, mage.cards.p.PredatorsHowl.class));
        cards.add(new SetCardInfo("Preordain", 63, Rarity.COMMON, mage.cards.p.Preordain.class));
        cards.add(new SetCardInfo("Presence of Gond", 709, Rarity.COMMON, mage.cards.p.PresenceOfGond.class));
        cards.add(new SetCardInfo("Press for Answers", 337, Rarity.COMMON, mage.cards.p.PressForAnswers.class));
        cards.add(new SetCardInfo("Preston, the Vanisher", 8, Rarity.RARE, mage.cards.p.PrestonTheVanisher.class));
        cards.add(new SetCardInfo("Prey Upon", 710, Rarity.COMMON, mage.cards.p.PreyUpon.class));
        cards.add(new SetCardInfo("Prickly Marmoset", 580, Rarity.COMMON, mage.cards.p.PricklyMarmoset.class));
        cards.add(new SetCardInfo("Pridemalkin", 711, Rarity.COMMON, mage.cards.p.Pridemalkin.class));
        cards.add(new SetCardInfo("Priest of the Blood Rite", 457, Rarity.RARE, mage.cards.p.PriestOfTheBloodRite.class));
        cards.add(new SetCardInfo("Primeval Herald", 42, Rarity.UNCOMMON, mage.cards.p.PrimevalHerald.class));
        cards.add(new SetCardInfo("Primordial Hydra", 712, Rarity.MYTHIC, mage.cards.p.PrimordialHydra.class));
        cards.add(new SetCardInfo("Professional Face-Breaker", 581, Rarity.RARE, mage.cards.p.ProfessionalFaceBreaker.class));
        cards.add(new SetCardInfo("Prowling Felidar", 229, Rarity.COMMON, mage.cards.p.ProwlingFelidar.class));
        cards.add(new SetCardInfo("Prowling Serpopard", 713, Rarity.RARE, mage.cards.p.ProwlingSerpopard.class));
        cards.add(new SetCardInfo("Psychosis Crawler", 792, Rarity.RARE, mage.cards.p.PsychosisCrawler.class));
        cards.add(new SetCardInfo("Pyre-Sledge Arsonist", 582, Rarity.UNCOMMON, mage.cards.p.PyreSledgeArsonist.class));
        cards.add(new SetCardInfo("Quakefoot Cyclops", 583, Rarity.COMMON, mage.cards.q.QuakefootCyclops.class));
        cards.add(new SetCardInfo("Quarry Beetle", 714, Rarity.UNCOMMON, mage.cards.q.QuarryBeetle.class));
        cards.add(new SetCardInfo("Radiant's Judgment", 230, Rarity.COMMON, mage.cards.r.RadiantsJudgment.class));
        cards.add(new SetCardInfo("Raiders' Karve", 793, Rarity.COMMON, mage.cards.r.RaidersKarve.class));
        cards.add(new SetCardInfo("Raking Claws", 584, Rarity.COMMON, mage.cards.r.RakingClaws.class));
        cards.add(new SetCardInfo("Ram Through", 91, Rarity.COMMON, mage.cards.r.RamThrough.class));
        cards.add(new SetCardInfo("Rambunctious Mutt", 231, Rarity.COMMON, mage.cards.r.RambunctiousMutt.class));
        cards.add(new SetCardInfo("Rampaging Baloths", 715, Rarity.RARE, mage.cards.r.RampagingBaloths.class));
        cards.add(new SetCardInfo("Rampaging Growth", 43, Rarity.UNCOMMON, mage.cards.r.RampagingGrowth.class));
        cards.add(new SetCardInfo("Rapacious Dragon", 80, Rarity.UNCOMMON, mage.cards.r.RapaciousDragon.class));
        cards.add(new SetCardInfo("Ravenous Giant", 585, Rarity.UNCOMMON, mage.cards.r.RavenousGiant.class));
        cards.add(new SetCardInfo("Raze the Effigy", 586, Rarity.COMMON, mage.cards.r.RazeTheEffigy.class));
        cards.add(new SetCardInfo("Reaper from the Abyss", 458, Rarity.MYTHIC, mage.cards.r.ReaperFromTheAbyss.class));
        cards.add(new SetCardInfo("Reassembling Skeleton", 125, Rarity.UNCOMMON, mage.cards.r.ReassemblingSkeleton.class));
        cards.add(new SetCardInfo("Reave Soul", 459, Rarity.COMMON, mage.cards.r.ReaveSoul.class));
        cards.add(new SetCardInfo("Reckless Amplimancer", 716, Rarity.COMMON, mage.cards.r.RecklessAmplimancer.class));
        cards.add(new SetCardInfo("Reckless Fireweaver", 587, Rarity.COMMON, mage.cards.r.RecklessFireweaver.class));
        cards.add(new SetCardInfo("Reclamation Sage", 717, Rarity.UNCOMMON, mage.cards.r.ReclamationSage.class));
        cards.add(new SetCardInfo("Regal Caracal", 232, Rarity.RARE, mage.cards.r.RegalCaracal.class));
        cards.add(new SetCardInfo("Relentless Pursuit", 718, Rarity.COMMON, mage.cards.r.RelentlessPursuit.class));
        cards.add(new SetCardInfo("Renegade Demon", 126, Rarity.COMMON, mage.cards.r.RenegadeDemon.class));
        cards.add(new SetCardInfo("Renowned Weaponsmith", 338, Rarity.UNCOMMON, mage.cards.r.RenownedWeaponsmith.class));
        cards.add(new SetCardInfo("Reptilian Reflection", 588, Rarity.UNCOMMON, mage.cards.r.ReptilianReflection.class));
        cards.add(new SetCardInfo("Restoration Angel", 233, Rarity.RARE, mage.cards.r.RestorationAngel.class));
        cards.add(new SetCardInfo("Returned Reveler", 460, Rarity.COMMON, mage.cards.r.ReturnedReveler.class));
        cards.add(new SetCardInfo("Revenant", 461, Rarity.UNCOMMON, mage.cards.r.Revenant.class));
        cards.add(new SetCardInfo("Rhonas the Indomitable", 719, Rarity.MYTHIC, mage.cards.r.RhonasTheIndomitable.class));
        cards.add(new SetCardInfo("Rhystic Study", 114, Rarity.RARE, mage.cards.r.RhysticStudy.class));
        cards.add(new SetCardInfo("Rigging Runner", 81, Rarity.UNCOMMON, mage.cards.r.RiggingRunner.class));
        cards.add(new SetCardInfo("Righteous Valkyrie", 234, Rarity.RARE, mage.cards.r.RighteousValkyrie.class));
        cards.add(new SetCardInfo("Righteousness", 235, Rarity.UNCOMMON, mage.cards.r.Righteousness.class));
        cards.add(new SetCardInfo("Ripscale Predator", 589, Rarity.COMMON, mage.cards.r.RipscalePredator.class));
        cards.add(new SetCardInfo("River Sneak", 339, Rarity.UNCOMMON, mage.cards.r.RiverSneak.class));
        cards.add(new SetCardInfo("Roar of Challenge", 720, Rarity.UNCOMMON, mage.cards.r.RoarOfChallenge.class));
        cards.add(new SetCardInfo("Rodolf Duskbringer", 25, Rarity.RARE, mage.cards.r.RodolfDuskbringer.class));
        cards.add(new SetCardInfo("Rooting Moloch", 590, Rarity.UNCOMMON, mage.cards.r.RootingMoloch.class));
        cards.add(new SetCardInfo("Roots of Wisdom", 721, Rarity.COMMON, mage.cards.r.RootsOfWisdom.class));
        cards.add(new SetCardInfo("Rosethorn Halberd", 722, Rarity.COMMON, mage.cards.r.RosethornHalberd.class));
        cards.add(new SetCardInfo("Ruin in Their Wake", 132, Rarity.UNCOMMON, mage.cards.r.RuinInTheirWake.class));
        cards.add(new SetCardInfo("Rummaging Goblin", 591, Rarity.COMMON, mage.cards.r.RummagingGoblin.class));
        cards.add(new SetCardInfo("Runadi, Behemoth Caller", 44, Rarity.RARE, mage.cards.r.RunadiBehemothCaller.class));
        cards.add(new SetCardInfo("Runed Servitor", 794, Rarity.COMMON, mage.cards.r.RunedServitor.class));
        cards.add(new SetCardInfo("Rush of Adrenaline", 592, Rarity.COMMON, mage.cards.r.RushOfAdrenaline.class));
        cards.add(new SetCardInfo("Ruthless Disposal", 462, Rarity.UNCOMMON, mage.cards.r.RuthlessDisposal.class));
        cards.add(new SetCardInfo("Sage of the Falls", 340, Rarity.UNCOMMON, mage.cards.s.SageOfTheFalls.class));
        cards.add(new SetCardInfo("Sage's Reverie", 58, Rarity.UNCOMMON, mage.cards.s.SagesReverie.class));
        cards.add(new SetCardInfo("Sage's Row Savant", 341, Rarity.COMMON, mage.cards.s.SagesRowSavant.class));
        cards.add(new SetCardInfo("Saltwater Stalwart", 342, Rarity.COMMON, mage.cards.s.SaltwaterStalwart.class));
        cards.add(new SetCardInfo("Sanctum Gargoyle", 236, Rarity.COMMON, mage.cards.s.SanctumGargoyle.class));
        cards.add(new SetCardInfo("Sandstone Bridge", 819, Rarity.COMMON, mage.cards.s.SandstoneBridge.class));
        cards.add(new SetCardInfo("Sarkhan's Rage", 594, Rarity.COMMON, mage.cards.s.SarkhansRage.class));
        cards.add(new SetCardInfo("Sarkhan's Whelp", 595, Rarity.UNCOMMON, mage.cards.s.SarkhansWhelp.class));
        cards.add(new SetCardInfo("Sarkhan, the Dragonspeaker", 593, Rarity.MYTHIC, mage.cards.s.SarkhanTheDragonspeaker.class));
        cards.add(new SetCardInfo("Savage Punch", 723, Rarity.COMMON, mage.cards.s.SavagePunch.class));
        cards.add(new SetCardInfo("Savannah Lions", 237, Rarity.UNCOMMON, mage.cards.s.SavannahLions.class));
        cards.add(new SetCardInfo("Savannah Sage", 238, Rarity.COMMON, mage.cards.s.SavannahSage.class));
        cards.add(new SetCardInfo("Scale the Heights", 724, Rarity.COMMON, mage.cards.s.ScaleTheHeights.class));
        cards.add(new SetCardInfo("Scion Summoner", 725, Rarity.COMMON, mage.cards.s.ScionSummoner.class));
        cards.add(new SetCardInfo("Scorching Dragonfire", 596, Rarity.COMMON, mage.cards.s.ScorchingDragonfire.class));
        cards.add(new SetCardInfo("Scrounging Bandar", 726, Rarity.COMMON, mage.cards.s.ScroungingBandar.class));
        cards.add(new SetCardInfo("Seafloor Oracle", 343, Rarity.RARE, mage.cards.s.SeafloorOracle.class));
        cards.add(new SetCardInfo("Searing Spear", 597, Rarity.COMMON, mage.cards.s.SearingSpear.class));
        cards.add(new SetCardInfo("Seat of the Synod", 820, Rarity.COMMON, mage.cards.s.SeatOfTheSynod.class));
        cards.add(new SetCardInfo("Seizan, Perverter of Truth", 463, Rarity.RARE, mage.cards.s.SeizanPerverterOfTruth.class));
        cards.add(new SetCardInfo("Seize the Storm", 598, Rarity.UNCOMMON, mage.cards.s.SeizeTheStorm.class));
        cards.add(new SetCardInfo("Self-Assembler", 795, Rarity.COMMON, mage.cards.s.SelfAssembler.class));
        cards.add(new SetCardInfo("Selfless Spirit", 239, Rarity.RARE, mage.cards.s.SelflessSpirit.class));
        cards.add(new SetCardInfo("Seller of Songbirds", 240, Rarity.COMMON, mage.cards.s.SellerOfSongbirds.class));
        cards.add(new SetCardInfo("Sentinels of Glen Elendra", 344, Rarity.COMMON, mage.cards.s.SentinelsOfGlenElendra.class));
        cards.add(new SetCardInfo("Serene Steward", 241, Rarity.UNCOMMON, mage.cards.s.SereneSteward.class));
        cards.add(new SetCardInfo("Serum Visions", 345, Rarity.UNCOMMON, mage.cards.s.SerumVisions.class));
        cards.add(new SetCardInfo("Servant of the Scale", 727, Rarity.COMMON, mage.cards.s.ServantOfTheScale.class));
        cards.add(new SetCardInfo("Settle Beyond Reality", 242, Rarity.COMMON, mage.cards.s.SettleBeyondReality.class));
        cards.add(new SetCardInfo("Shadowborn Demon", 464, Rarity.MYTHIC, mage.cards.s.ShadowbornDemon.class));
        cards.add(new SetCardInfo("Shambling Ghoul", 465, Rarity.COMMON, mage.cards.s.ShamblingGhoul.class));
        cards.add(new SetCardInfo("Shambling Suit", 796, Rarity.UNCOMMON, mage.cards.s.ShamblingSuit.class));
        cards.add(new SetCardInfo("Shaper Apprentice", 346, Rarity.COMMON, mage.cards.s.ShaperApprentice.class));
        cards.add(new SetCardInfo("Shimmer Dragon", 347, Rarity.RARE, mage.cards.s.ShimmerDragon.class));
        cards.add(new SetCardInfo("Shimmerdrift Vale", 821, Rarity.COMMON, mage.cards.s.ShimmerdriftVale.class));
        cards.add(new SetCardInfo("Shining Armor", 243, Rarity.COMMON, mage.cards.s.ShiningArmor.class));
        cards.add(new SetCardInfo("Shredded Sails", 599, Rarity.COMMON, mage.cards.s.ShreddedSails.class));
        cards.add(new SetCardInfo("Sigil of the Empty Throne", 244, Rarity.RARE, mage.cards.s.SigilOfTheEmptyThrone.class));
        cards.add(new SetCardInfo("Silverback Shaman", 728, Rarity.COMMON, mage.cards.s.SilverbackShaman.class));
        cards.add(new SetCardInfo("Simian Brawler", 729, Rarity.COMMON, mage.cards.s.SimianBrawler.class));
        cards.add(new SetCardInfo("Sinuous Vermin", 466, Rarity.COMMON, mage.cards.s.SinuousVermin.class));
        cards.add(new SetCardInfo("Skilled Animator", 348, Rarity.UNCOMMON, mage.cards.s.SkilledAnimator.class));
        cards.add(new SetCardInfo("Skirsdag High Priest", 467, Rarity.RARE, mage.cards.s.SkirsdagHighPriest.class));
        cards.add(new SetCardInfo("Skirsdag Supplicant", 468, Rarity.COMMON, mage.cards.s.SkirsdagSupplicant.class));
        cards.add(new SetCardInfo("Skullslither Worm", 26, Rarity.UNCOMMON, mage.cards.s.SkullslitherWorm.class));
        cards.add(new SetCardInfo("Skyhunter Patrol", 245, Rarity.COMMON, mage.cards.s.SkyhunterPatrol.class));
        cards.add(new SetCardInfo("Skyhunter Prowler", 246, Rarity.COMMON, mage.cards.s.SkyhunterProwler.class));
        cards.add(new SetCardInfo("Sling-Gang Lieutenant", 469, Rarity.UNCOMMON, mage.cards.s.SlingGangLieutenant.class));
        cards.add(new SetCardInfo("Smoldering Efreet", 600, Rarity.COMMON, mage.cards.s.SmolderingEfreet.class));
        cards.add(new SetCardInfo("Snapping Gnarlid", 730, Rarity.COMMON, mage.cards.s.SnappingGnarlid.class));
        cards.add(new SetCardInfo("Snow-Covered Island", 833, Rarity.LAND, mage.cards.s.SnowCoveredIsland.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("So Tiny", 349, Rarity.COMMON, mage.cards.s.SoTiny.class));
        cards.add(new SetCardInfo("Sokenzan Smelter", 601, Rarity.UNCOMMON, mage.cards.s.SokenzanSmelter.class));
        cards.add(new SetCardInfo("Solemn Simulacrum", 797, Rarity.RARE, mage.cards.s.SolemnSimulacrum.class));
        cards.add(new SetCardInfo("Soul Read", 17, Rarity.COMMON, mage.cards.s.SoulRead.class));
        cards.add(new SetCardInfo("Soul's Might", 731, Rarity.COMMON, mage.cards.s.SoulsMight.class));
        cards.add(new SetCardInfo("Soulcage Fiend", 470, Rarity.COMMON, mage.cards.s.SoulcageFiend.class));
        cards.add(new SetCardInfo("Spark Reaper", 471, Rarity.COMMON, mage.cards.s.SparkReaper.class));
        cards.add(new SetCardInfo("Spark of Creativity", 602, Rarity.UNCOMMON, mage.cards.s.SparkOfCreativity.class));
        cards.add(new SetCardInfo("Sparkmage Apprentice", 603, Rarity.COMMON, mage.cards.s.SparkmageApprentice.class));
        cards.add(new SetCardInfo("Sparktongue Dragon", 604, Rarity.COMMON, mage.cards.s.SparktongueDragon.class));
        cards.add(new SetCardInfo("Spawning Pit", 136, Rarity.UNCOMMON, mage.cards.s.SpawningPit.class));
        cards.add(new SetCardInfo("Spear Spewer", 82, Rarity.COMMON, mage.cards.s.SpearSpewer.class));
        cards.add(new SetCardInfo("Spectral Hunt-Caller", 45, Rarity.COMMON, mage.cards.s.SpectralHuntCaller.class));
        cards.add(new SetCardInfo("Spectral Sailor", 64, Rarity.UNCOMMON, mage.cards.s.SpectralSailor.class));
        cards.add(new SetCardInfo("Spectral Steel", 247, Rarity.UNCOMMON, mage.cards.s.SpectralSteel.class));
        cards.add(new SetCardInfo("Spellgorger Weird", 605, Rarity.COMMON, mage.cards.s.SpellgorgerWeird.class));
        cards.add(new SetCardInfo("Spellstutter Sprite", 65, Rarity.COMMON, mage.cards.s.SpellstutterSprite.class));
        cards.add(new SetCardInfo("Spirited Companion", 248, Rarity.COMMON, mage.cards.s.SpiritedCompanion.class));
        cards.add(new SetCardInfo("Spiteful Prankster", 606, Rarity.UNCOMMON, mage.cards.s.SpitefulPrankster.class));
        cards.add(new SetCardInfo("Sporeback Wolf", 732, Rarity.COMMON, mage.cards.s.SporebackWolf.class));
        cards.add(new SetCardInfo("Stalking Drone", 733, Rarity.COMMON, mage.cards.s.StalkingDrone.class));
        cards.add(new SetCardInfo("Stalwart Valkyrie", 249, Rarity.COMMON, mage.cards.s.StalwartValkyrie.class));
        cards.add(new SetCardInfo("Starnheim Aspirant", 250, Rarity.UNCOMMON, mage.cards.s.StarnheimAspirant.class));
        cards.add(new SetCardInfo("Starstorm", 607, Rarity.RARE, mage.cards.s.Starstorm.class));
        cards.add(new SetCardInfo("Startling Development", 350, Rarity.COMMON, mage.cards.s.StartlingDevelopment.class));
        cards.add(new SetCardInfo("Steel Overseer", 798, Rarity.RARE, mage.cards.s.SteelOverseer.class));
        cards.add(new SetCardInfo("Steelgaze Griffin", 351, Rarity.COMMON, mage.cards.s.SteelgazeGriffin.class));
        cards.add(new SetCardInfo("Steppe Lynx", 251, Rarity.COMMON, mage.cards.s.SteppeLynx.class));
        cards.add(new SetCardInfo("Stinging Lionfish", 352, Rarity.UNCOMMON, mage.cards.s.StingingLionfish.class));
        cards.add(new SetCardInfo("Stitcher's Supplier", 472, Rarity.UNCOMMON, mage.cards.s.StitchersSupplier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stitcher's Supplier", 73, Rarity.UNCOMMON, mage.cards.s.StitchersSupplier.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stolen by the Fae", 353, Rarity.RARE, mage.cards.s.StolenByTheFae.class));
        cards.add(new SetCardInfo("Stonybrook Angler", 354, Rarity.COMMON, mage.cards.s.StonybrookAngler.class));
        cards.add(new SetCardInfo("Storm Fleet Pyromancer", 608, Rarity.COMMON, mage.cards.s.StormFleetPyromancer.class));
        cards.add(new SetCardInfo("Storm Sculptor", 355, Rarity.COMMON, mage.cards.s.StormSculptor.class));
        cards.add(new SetCardInfo("Strangling Spores", 473, Rarity.COMMON, mage.cards.s.StranglingSpores.class));
        cards.add(new SetCardInfo("Subterranean Scout", 609, Rarity.COMMON, mage.cards.s.SubterraneanScout.class));
        cards.add(new SetCardInfo("Sudden Breakthrough", 610, Rarity.COMMON, mage.cards.s.SuddenBreakthrough.class));
        cards.add(new SetCardInfo("Suspicious Shambler", 27, Rarity.COMMON, mage.cards.s.SuspiciousShambler.class));
        cards.add(new SetCardInfo("Svyelun of Sea and Sky", 356, Rarity.MYTHIC, mage.cards.s.SvyelunOfSeaAndSky.class));
        cards.add(new SetCardInfo("Swaggering Corsair", 611, Rarity.COMMON, mage.cards.s.SwaggeringCorsair.class));
        cards.add(new SetCardInfo("Swamp", 104, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 105, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 106, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swarm Shambler", 734, Rarity.RARE, mage.cards.s.SwarmShambler.class));
        cards.add(new SetCardInfo("Swarm of Bloodflies", 127, Rarity.UNCOMMON, mage.cards.s.SwarmOfBloodflies.class));
        cards.add(new SetCardInfo("Swift Kick", 612, Rarity.COMMON, mage.cards.s.SwiftKick.class));
        cards.add(new SetCardInfo("Synchronized Eviction", 18, Rarity.UNCOMMON, mage.cards.s.SynchronizedEviction.class));
        cards.add(new SetCardInfo("Syr Alin, the Lion's Claw", 252, Rarity.UNCOMMON, mage.cards.s.SyrAlinTheLionsClaw.class));
        cards.add(new SetCardInfo("Syr Elenora, the Discerning", 357, Rarity.UNCOMMON, mage.cards.s.SyrElenoraTheDiscerning.class));
        cards.add(new SetCardInfo("Syr Konrad, the Grim", 474, Rarity.UNCOMMON, mage.cards.s.SyrKonradTheGrim.class));
        cards.add(new SetCardInfo("Takenuma Bleeder", 475, Rarity.COMMON, mage.cards.t.TakenumaBleeder.class));
        cards.add(new SetCardInfo("Talon of Pain", 799, Rarity.UNCOMMON, mage.cards.t.TalonOfPain.class));
        cards.add(new SetCardInfo("Tamiyo's Journal", 800, Rarity.RARE, mage.cards.t.TamiyosJournal.class));
        cards.add(new SetCardInfo("Tamiyo, the Moon Sage", 358, Rarity.MYTHIC, mage.cards.t.TamiyoTheMoonSage.class));
        cards.add(new SetCardInfo("Taranika, Akroan Veteran", 253, Rarity.RARE, mage.cards.t.TaranikaAkroanVeteran.class));
        cards.add(new SetCardInfo("Task Force", 113, Rarity.COMMON, mage.cards.t.TaskForce.class));
        cards.add(new SetCardInfo("Teferi's Protege", 359, Rarity.COMMON, mage.cards.t.TeferisProtege.class));
        cards.add(new SetCardInfo("Teferi's Puzzle Box", 801, Rarity.RARE, mage.cards.t.TeferisPuzzleBox.class));
        cards.add(new SetCardInfo("Tempered Veteran", 254, Rarity.UNCOMMON, mage.cards.t.TemperedVeteran.class));
        cards.add(new SetCardInfo("Termination Facilitator", 28, Rarity.RARE, mage.cards.t.TerminationFacilitator.class));
        cards.add(new SetCardInfo("Tezzeret, Artifice Master", 360, Rarity.MYTHIC, mage.cards.t.TezzeretArtificeMaster.class));
        cards.add(new SetCardInfo("Thaumaturge's Familiar", 802, Rarity.COMMON, mage.cards.t.ThaumaturgesFamiliar.class));
        cards.add(new SetCardInfo("The Circle of Loyalty", 166, Rarity.MYTHIC, mage.cards.t.TheCircleOfLoyalty.class));
        cards.add(new SetCardInfo("Thermo-Alchemist", 613, Rarity.COMMON, mage.cards.t.ThermoAlchemist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thermo-Alchemist", 83, Rarity.COMMON, mage.cards.t.ThermoAlchemist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thopter Spy Network", 361, Rarity.RARE, mage.cards.t.ThopterSpyNetwork.class));
        cards.add(new SetCardInfo("Thraben Inspector", 255, Rarity.COMMON, mage.cards.t.ThrabenInspector.class));
        cards.add(new SetCardInfo("Thrashing Brontodon", 92, Rarity.UNCOMMON, mage.cards.t.ThrashingBrontodon.class));
        cards.add(new SetCardInfo("Thrill of Possibility", 84, Rarity.COMMON, mage.cards.t.ThrillOfPossibility.class));
        cards.add(new SetCardInfo("Thriving Bluff", 822, Rarity.COMMON, mage.cards.t.ThrivingBluff.class));
        cards.add(new SetCardInfo("Thriving Grove", 823, Rarity.COMMON, mage.cards.t.ThrivingGrove.class));
        cards.add(new SetCardInfo("Thriving Heath", 824, Rarity.COMMON, mage.cards.t.ThrivingHeath.class));
        cards.add(new SetCardInfo("Thriving Isle", 825, Rarity.COMMON, mage.cards.t.ThrivingIsle.class));
        cards.add(new SetCardInfo("Thriving Moor", 826, Rarity.COMMON, mage.cards.t.ThrivingMoor.class));
        cards.add(new SetCardInfo("Titan's Presence", 749, Rarity.UNCOMMON, mage.cards.t.TitansPresence.class));
        cards.add(new SetCardInfo("Titanic Brawl", 735, Rarity.COMMON, mage.cards.t.TitanicBrawl.class));
        cards.add(new SetCardInfo("Tivash, Gloom Summoner", 476, Rarity.RARE, mage.cards.t.TivashGloomSummoner.class));
        cards.add(new SetCardInfo("Tolarian Kraken", 362, Rarity.UNCOMMON, mage.cards.t.TolarianKraken.class));
        cards.add(new SetCardInfo("Tolarian Sentinel", 363, Rarity.COMMON, mage.cards.t.TolarianSentinel.class));
        cards.add(new SetCardInfo("Tome Anima", 364, Rarity.COMMON, mage.cards.t.TomeAnima.class));
        cards.add(new SetCardInfo("Torch Courier", 614, Rarity.COMMON, mage.cards.t.TorchCourier.class));
        cards.add(new SetCardInfo("Tormented Soul", 477, Rarity.COMMON, mage.cards.t.TormentedSoul.class));
        cards.add(new SetCardInfo("Tormenting Voice", 615, Rarity.COMMON, mage.cards.t.TormentingVoice.class));
        cards.add(new SetCardInfo("Towering Gibbon", 46, Rarity.UNCOMMON, mage.cards.t.ToweringGibbon.class));
        cards.add(new SetCardInfo("Tragic Lesson", 115, Rarity.COMMON, mage.cards.t.TragicLesson.class));
        cards.add(new SetCardInfo("Tragic Slip", 478, Rarity.COMMON, mage.cards.t.TragicSlip.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tragic Slip", 74, Rarity.COMMON, mage.cards.t.TragicSlip.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trained Caracal", 256, Rarity.COMMON, mage.cards.t.TrainedCaracal.class));
        cards.add(new SetCardInfo("Transcendent Envoy", 257, Rarity.COMMON, mage.cards.t.TranscendentEnvoy.class));
        cards.add(new SetCardInfo("Tree of Perdition", 75, Rarity.MYTHIC, mage.cards.t.TreeOfPerdition.class));
        cards.add(new SetCardInfo("Treetop Village", 827, Rarity.UNCOMMON, mage.cards.t.TreetopVillage.class));
        cards.add(new SetCardInfo("Triplicate Spirits", 258, Rarity.COMMON, mage.cards.t.TriplicateSpirits.class));
        cards.add(new SetCardInfo("Triskaidekaphobia", 479, Rarity.RARE, mage.cards.t.Triskaidekaphobia.class));
        cards.add(new SetCardInfo("Triton Shorestalker", 365, Rarity.COMMON, mage.cards.t.TritonShorestalker.class));
        cards.add(new SetCardInfo("Trove Warden", 259, Rarity.RARE, mage.cards.t.TroveWarden.class));
        cards.add(new SetCardInfo("Trove of Temptation", 616, Rarity.UNCOMMON, mage.cards.t.TroveOfTemptation.class));
        cards.add(new SetCardInfo("Turntimber Basilisk", 736, Rarity.UNCOMMON, mage.cards.t.TurntimberBasilisk.class));
        cards.add(new SetCardInfo("Typhoid Rats", 480, Rarity.COMMON, mage.cards.t.TyphoidRats.class));
        cards.add(new SetCardInfo("Uktabi Orangutan", 133, Rarity.UNCOMMON, mage.cards.u.UktabiOrangutan.class));
        cards.add(new SetCardInfo("Ulcerate", 481, Rarity.UNCOMMON, mage.cards.u.Ulcerate.class));
        cards.add(new SetCardInfo("Undead Augur", 482, Rarity.UNCOMMON, mage.cards.u.UndeadAugur.class));
        cards.add(new SetCardInfo("Undersea Invader", 366, Rarity.COMMON, mage.cards.u.UnderseaInvader.class));
        cards.add(new SetCardInfo("Universal Automaton", 803, Rarity.COMMON, mage.cards.u.UniversalAutomaton.class));
        cards.add(new SetCardInfo("Universal Solvent", 804, Rarity.COMMON, mage.cards.u.UniversalSolvent.class));
        cards.add(new SetCardInfo("Unnatural Aggression", 737, Rarity.COMMON, mage.cards.u.UnnaturalAggression.class));
        cards.add(new SetCardInfo("Unquestioned Authority", 260, Rarity.UNCOMMON, mage.cards.u.UnquestionedAuthority.class));
        cards.add(new SetCardInfo("Urza's Factory", 828, Rarity.UNCOMMON, mage.cards.u.UrzasFactory.class));
        cards.add(new SetCardInfo("Urza's Mine", 829, Rarity.COMMON, mage.cards.u.UrzasMine.class));
        cards.add(new SetCardInfo("Urza's Power Plant", 830, Rarity.COMMON, mage.cards.u.UrzasPowerPlant.class));
        cards.add(new SetCardInfo("Urza's Tower", 831, Rarity.COMMON, mage.cards.u.UrzasTower.class));
        cards.add(new SetCardInfo("Valkyrie Harbinger", 261, Rarity.RARE, mage.cards.v.ValkyrieHarbinger.class));
        cards.add(new SetCardInfo("Valor in Akros", 262, Rarity.UNCOMMON, mage.cards.v.ValorInAkros.class));
        cards.add(new SetCardInfo("Valorous Stance", 263, Rarity.UNCOMMON, mage.cards.v.ValorousStance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Valorous Stance", 59, Rarity.UNCOMMON, mage.cards.v.ValorousStance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Valorous Steed", 264, Rarity.COMMON, mage.cards.v.ValorousSteed.class));
        cards.add(new SetCardInfo("Vampire Envoy", 483, Rarity.COMMON, mage.cards.v.VampireEnvoy.class));
        cards.add(new SetCardInfo("Vampiric Rites", 484, Rarity.UNCOMMON, mage.cards.v.VampiricRites.class));
        cards.add(new SetCardInfo("Vault Robber", 617, Rarity.COMMON, mage.cards.v.VaultRobber.class));
        cards.add(new SetCardInfo("Vedalken Engineer", 367, Rarity.COMMON, mage.cards.v.VedalkenEngineer.class));
        cards.add(new SetCardInfo("Vendilion Clique", 368, Rarity.MYTHIC, mage.cards.v.VendilionClique.class));
        cards.add(new SetCardInfo("Vermin Gorger", 485, Rarity.COMMON, mage.cards.v.VerminGorger.class));
        cards.add(new SetCardInfo("Vial of Dragonfire", 805, Rarity.COMMON, mage.cards.v.VialOfDragonfire.class));
        cards.add(new SetCardInfo("Viashino Pyromancer", 618, Rarity.COMMON, mage.cards.v.ViashinoPyromancer.class));
        cards.add(new SetCardInfo("Village Rites", 486, Rarity.COMMON, mage.cards.v.VillageRites.class));
        cards.add(new SetCardInfo("Vito, Thorn of the Dusk Rose", 487, Rarity.RARE, mage.cards.v.VitoThornOfTheDuskRose.class));
        cards.add(new SetCardInfo("Volley Veteran", 619, Rarity.UNCOMMON, mage.cards.v.VolleyVeteran.class));
        cards.add(new SetCardInfo("Wailing Ghoul", 488, Rarity.COMMON, mage.cards.w.WailingGhoul.class));
        cards.add(new SetCardInfo("Wake Thrasher", 369, Rarity.RARE, mage.cards.w.WakeThrasher.class));
        cards.add(new SetCardInfo("Wakedancer", 128, Rarity.COMMON, mage.cards.w.Wakedancer.class));
        cards.add(new SetCardInfo("Walking Ballista", 806, Rarity.RARE, mage.cards.w.WalkingBallista.class));
        cards.add(new SetCardInfo("War-Name Aspirant", 620, Rarity.UNCOMMON, mage.cards.w.WarNameAspirant.class));
        cards.add(new SetCardInfo("Warcry Phoenix", 621, Rarity.UNCOMMON, mage.cards.w.WarcryPhoenix.class));
        cards.add(new SetCardInfo("Warden of Geometries", 750, Rarity.COMMON, mage.cards.w.WardenOfGeometries.class));
        cards.add(new SetCardInfo("Warped Landscape", 832, Rarity.COMMON, mage.cards.w.WarpedLandscape.class));
        cards.add(new SetCardInfo("Wastes", 834, Rarity.COMMON, mage.cards.w.Wastes.class));
        cards.add(new SetCardInfo("Watertrap Weaver", 370, Rarity.COMMON, mage.cards.w.WatertrapWeaver.class));
        cards.add(new SetCardInfo("Wavebreak Hippocamp", 371, Rarity.RARE, mage.cards.w.WavebreakHippocamp.class));
        cards.add(new SetCardInfo("Weapon Rack", 807, Rarity.COMMON, mage.cards.w.WeaponRack.class));
        cards.add(new SetCardInfo("Weaselback Redcap", 622, Rarity.COMMON, mage.cards.w.WeaselbackRedcap.class));
        cards.add(new SetCardInfo("Weight of Conscience", 265, Rarity.COMMON, mage.cards.w.WeightOfConscience.class));
        cards.add(new SetCardInfo("Weldfast Wingsmith", 372, Rarity.COMMON, mage.cards.w.WeldfastWingsmith.class));
        cards.add(new SetCardInfo("Welding Sparks", 623, Rarity.COMMON, mage.cards.w.WeldingSparks.class));
        cards.add(new SetCardInfo("Whirler Rogue", 66, Rarity.UNCOMMON, mage.cards.w.WhirlerRogue.class));
        cards.add(new SetCardInfo("Whirlermaker", 808, Rarity.UNCOMMON, mage.cards.w.Whirlermaker.class));
        cards.add(new SetCardInfo("Wicked Guardian", 489, Rarity.COMMON, mage.cards.w.WickedGuardian.class));
        cards.add(new SetCardInfo("Wicked Wolf", 134, Rarity.RARE, mage.cards.w.WickedWolf.class));
        cards.add(new SetCardInfo("Wildborn Preserver", 738, Rarity.RARE, mage.cards.w.WildbornPreserver.class));
        cards.add(new SetCardInfo("Wildfire Elemental", 624, Rarity.COMMON, mage.cards.w.WildfireElemental.class));
        cards.add(new SetCardInfo("Wily Bandar", 739, Rarity.COMMON, mage.cards.w.WilyBandar.class));
        cards.add(new SetCardInfo("Windrider Patrol", 373, Rarity.UNCOMMON, mage.cards.w.WindriderPatrol.class));
        cards.add(new SetCardInfo("Winter's Rest", 374, Rarity.COMMON, mage.cards.w.WintersRest.class));
        cards.add(new SetCardInfo("Wispweaver Angel", 266, Rarity.UNCOMMON, mage.cards.w.WispweaverAngel.class));
        cards.add(new SetCardInfo("Witch's Cauldron", 490, Rarity.UNCOMMON, mage.cards.w.WitchsCauldron.class));
        cards.add(new SetCardInfo("Wizard Mentor", 116, Rarity.COMMON, mage.cards.w.WizardMentor.class));
        cards.add(new SetCardInfo("Wolf's Quarry", 740, Rarity.COMMON, mage.cards.w.WolfsQuarry.class));
        cards.add(new SetCardInfo("Wolfkin Bond", 741, Rarity.COMMON, mage.cards.w.WolfkinBond.class));
        cards.add(new SetCardInfo("Wolfwillow Haven", 742, Rarity.UNCOMMON, mage.cards.w.WolfwillowHaven.class));
        cards.add(new SetCardInfo("Wolverine Riders", 743, Rarity.RARE, mage.cards.w.WolverineRiders.class));
        cards.add(new SetCardInfo("Woodborn Behemoth", 744, Rarity.UNCOMMON, mage.cards.w.WoodbornBehemoth.class));
        cards.add(new SetCardInfo("Woodland Champion", 745, Rarity.UNCOMMON, mage.cards.w.WoodlandChampion.class));
        cards.add(new SetCardInfo("World Breaker", 93, Rarity.MYTHIC, mage.cards.w.WorldBreaker.class));
        cards.add(new SetCardInfo("Yargle, Glutton of Urborg", 491, Rarity.UNCOMMON, mage.cards.y.YargleGluttonOfUrborg.class));
        cards.add(new SetCardInfo("Yidaro, Wandering Monster", 625, Rarity.RARE, mage.cards.y.YidaroWanderingMonster.class));
        cards.add(new SetCardInfo("Young Pyromancer", 626, Rarity.UNCOMMON, mage.cards.y.YoungPyromancer.class));
        cards.add(new SetCardInfo("Young Wolf", 746, Rarity.COMMON, mage.cards.y.YoungWolf.class));
        cards.add(new SetCardInfo("Zask, Skittering Swarmlord", 47, Rarity.RARE, mage.cards.z.ZaskSkitteringSwarmlord.class));
        cards.add(new SetCardInfo("Zendikar's Roil", 747, Rarity.UNCOMMON, mage.cards.z.ZendikarsRoil.class));
    }
}
