package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class Jumpstart extends ExpansionSet {

    private static final Jumpstart instance = new Jumpstart();

    public static Jumpstart getInstance() {
        return instance;
    }

    private Jumpstart() {
        super("Jumpstart", "JMP", ExpansionSet.buildDate(2020, 7, 17), SetType.SUPPLEMENTAL);
        this.blockName = "Jumpstart";
        this.hasBasicLands = true;

        cards.add(new SetCardInfo("Act of Treason", 289, Rarity.COMMON, mage.cards.a.ActOfTreason.class));
        cards.add(new SetCardInfo("Aegis Turtle", 138, Rarity.COMMON, mage.cards.a.AegisTurtle.class));
        cards.add(new SetCardInfo("Aegis of the Heavens", 79, Rarity.UNCOMMON, mage.cards.a.AegisOfTheHeavens.class));
        cards.add(new SetCardInfo("Aerial Assault", 80, Rarity.COMMON, mage.cards.a.AerialAssault.class));
        cards.add(new SetCardInfo("Aether Spellbomb", 456, Rarity.COMMON, mage.cards.a.AetherSpellbomb.class));
        cards.add(new SetCardInfo("Affa Guard Hound", 81, Rarity.UNCOMMON, mage.cards.a.AffaGuardHound.class));
        cards.add(new SetCardInfo("Affectionate Indrik", 373, Rarity.UNCOMMON, mage.cards.a.AffectionateIndrik.class));
        cards.add(new SetCardInfo("Aggressive Urge", 374, Rarity.COMMON, mage.cards.a.AggressiveUrge.class));
        cards.add(new SetCardInfo("Agonizing Syphon", 199, Rarity.COMMON, mage.cards.a.AgonizingSyphon.class));
        cards.add(new SetCardInfo("Ajani's Chosen", 82, Rarity.RARE, mage.cards.a.AjanisChosen.class));
        cards.add(new SetCardInfo("Alabaster Mage", 83, Rarity.UNCOMMON, mage.cards.a.AlabasterMage.class));
        cards.add(new SetCardInfo("Allosaurus Shepherd", 28, Rarity.MYTHIC, mage.cards.a.AllosaurusShepherd.class));
        cards.add(new SetCardInfo("Alloy Myr", 457, Rarity.COMMON, mage.cards.a.AlloyMyr.class));
        cards.add(new SetCardInfo("Ambassador Oak", 375, Rarity.COMMON, mage.cards.a.AmbassadorOak.class));
        cards.add(new SetCardInfo("Ancestral Statue", 458, Rarity.COMMON, mage.cards.a.AncestralStatue.class));
        cards.add(new SetCardInfo("Angel of Mercy", 84, Rarity.COMMON, mage.cards.a.AngelOfMercy.class));
        cards.add(new SetCardInfo("Angel of the Dire Hour", 85, Rarity.RARE, mage.cards.a.AngelOfTheDireHour.class));
        cards.add(new SetCardInfo("Angelic Arbiter", 86, Rarity.RARE, mage.cards.a.AngelicArbiter.class));
        cards.add(new SetCardInfo("Angelic Edict", 87, Rarity.COMMON, mage.cards.a.AngelicEdict.class));
        cards.add(new SetCardInfo("Angelic Page", 88, Rarity.COMMON, mage.cards.a.AngelicPage.class));
        cards.add(new SetCardInfo("Arbor Armament", 376, Rarity.COMMON, mage.cards.a.ArborArmament.class));
        cards.add(new SetCardInfo("Arcane Encyclopedia", 459, Rarity.UNCOMMON, mage.cards.a.ArcaneEncyclopedia.class));
        cards.add(new SetCardInfo("Archaeomender", 9, Rarity.COMMON, mage.cards.a.Archaeomender.class));
        cards.add(new SetCardInfo("Archon of Justice", 89, Rarity.RARE, mage.cards.a.ArchonOfJustice.class));
        cards.add(new SetCardInfo("Archon of Redemption", 90, Rarity.RARE, mage.cards.a.ArchonOfRedemption.class));
        cards.add(new SetCardInfo("Armorcraft Judge", 377, Rarity.UNCOMMON, mage.cards.a.ArmorcraftJudge.class));
        cards.add(new SetCardInfo("Ashmouth Hound", 290, Rarity.COMMON, mage.cards.a.AshmouthHound.class));
        cards.add(new SetCardInfo("Assassin's Strike", 200, Rarity.UNCOMMON, mage.cards.a.AssassinsStrike.class));
        cards.add(new SetCardInfo("Assault Formation", 378, Rarity.RARE, mage.cards.a.AssaultFormation.class));
        cards.add(new SetCardInfo("Auger Spree", 449, Rarity.COMMON, mage.cards.a.AugerSpree.class));
        cards.add(new SetCardInfo("Awakener Druid", 379, Rarity.UNCOMMON, mage.cards.a.AwakenerDruid.class));
        cards.add(new SetCardInfo("Bake into a Pie", 201, Rarity.COMMON, mage.cards.b.BakeIntoAPie.class));
        cards.add(new SetCardInfo("Ball Lightning", 291, Rarity.RARE, mage.cards.b.BallLightning.class));
        cards.add(new SetCardInfo("Barrage of Expendables", 292, Rarity.UNCOMMON, mage.cards.b.BarrageOfExpendables.class));
        cards.add(new SetCardInfo("Barter in Blood", 202, Rarity.UNCOMMON, mage.cards.b.BarterInBlood.class));
        cards.add(new SetCardInfo("Bathe in Dragonfire", 293, Rarity.COMMON, mage.cards.b.BatheInDragonfire.class));
        cards.add(new SetCardInfo("Battlefield Promotion", 91, Rarity.COMMON, mage.cards.b.BattlefieldPromotion.class));
        cards.add(new SetCardInfo("Battleground Geist", 139, Rarity.UNCOMMON, mage.cards.b.BattlegroundGeist.class));
        cards.add(new SetCardInfo("Beetleback Chief", 294, Rarity.UNCOMMON, mage.cards.b.BeetlebackChief.class));
        cards.add(new SetCardInfo("Befuddle", 140, Rarity.COMMON, mage.cards.b.Befuddle.class));
        cards.add(new SetCardInfo("Belltower Sphinx", 141, Rarity.UNCOMMON, mage.cards.b.BelltowerSphinx.class));
        cards.add(new SetCardInfo("Black Cat", 203, Rarity.COMMON, mage.cards.b.BlackCat.class));
        cards.add(new SetCardInfo("Black Market", 204, Rarity.RARE, mage.cards.b.BlackMarket.class));
        cards.add(new SetCardInfo("Blessed Sanctuary", 1, Rarity.RARE, mage.cards.b.BlessedSanctuary.class));
        cards.add(new SetCardInfo("Blessed Spirits", 92, Rarity.UNCOMMON, mage.cards.b.BlessedSpirits.class));
        cards.add(new SetCardInfo("Blighted Bat", 205, Rarity.COMMON, mage.cards.b.BlightedBat.class));
        cards.add(new SetCardInfo("Blindblast", 295, Rarity.COMMON, mage.cards.b.Blindblast.class));
        cards.add(new SetCardInfo("Blood Artist", 206, Rarity.UNCOMMON, mage.cards.b.BloodArtist.class));
        cards.add(new SetCardInfo("Blood Divination", 207, Rarity.UNCOMMON, mage.cards.b.BloodDivination.class));
        cards.add(new SetCardInfo("Blood Host", 208, Rarity.UNCOMMON, mage.cards.b.BloodHost.class));
        cards.add(new SetCardInfo("Bloodbond Vampire", 209, Rarity.UNCOMMON, mage.cards.b.BloodbondVampire.class));
        cards.add(new SetCardInfo("Bloodhunter Bat", 210, Rarity.COMMON, mage.cards.b.BloodhunterBat.class));
        cards.add(new SetCardInfo("Bloodrage Brawler", 296, Rarity.UNCOMMON, mage.cards.b.BloodrageBrawler.class));
        cards.add(new SetCardInfo("Bloodrock Cyclops", 297, Rarity.COMMON, mage.cards.b.BloodrockCyclops.class));
        cards.add(new SetCardInfo("Bloodshot Trainee", 298, Rarity.UNCOMMON, mage.cards.b.BloodshotTrainee.class));
        cards.add(new SetCardInfo("Bogbrew Witch", 211, Rarity.RARE, mage.cards.b.BogbrewWitch.class));
        cards.add(new SetCardInfo("Boggart Brute", 299, Rarity.COMMON, mage.cards.b.BoggartBrute.class));
        cards.add(new SetCardInfo("Bone Picker", 212, Rarity.UNCOMMON, mage.cards.b.BonePicker.class));
        cards.add(new SetCardInfo("Bone Splinters", 213, Rarity.COMMON, mage.cards.b.BoneSplinters.class));
        cards.add(new SetCardInfo("Borderland Marauder", 300, Rarity.COMMON, mage.cards.b.BorderlandMarauder.class));
        cards.add(new SetCardInfo("Borderland Minotaur", 301, Rarity.COMMON, mage.cards.b.BorderlandMinotaur.class));
        cards.add(new SetCardInfo("Branching Evolution", 29, Rarity.RARE, mage.cards.b.BranchingEvolution.class));
        cards.add(new SetCardInfo("Brightmare", 2, Rarity.UNCOMMON, mage.cards.b.Brightmare.class));
        cards.add(new SetCardInfo("Brindle Shoat", 380, Rarity.UNCOMMON, mage.cards.b.BrindleShoat.class));
        cards.add(new SetCardInfo("Brushstrider", 381, Rarity.UNCOMMON, mage.cards.b.Brushstrider.class));
        cards.add(new SetCardInfo("Bruvac the Grandiloquent", 10, Rarity.MYTHIC, mage.cards.b.BruvacTheGrandiloquent.class));
        cards.add(new SetCardInfo("Bubbling Cauldron", 460, Rarity.UNCOMMON, mage.cards.b.BubblingCauldron.class));
        cards.add(new SetCardInfo("Bulwark Giant", 93, Rarity.COMMON, mage.cards.b.BulwarkGiant.class));
        cards.add(new SetCardInfo("Burglar Rat", 214, Rarity.COMMON, mage.cards.b.BurglarRat.class));
        cards.add(new SetCardInfo("Buried Ruin", 491, Rarity.UNCOMMON, mage.cards.b.BuriedRuin.class));
        cards.add(new SetCardInfo("Cadaver Imp", 215, Rarity.COMMON, mage.cards.c.CadaverImp.class));
        cards.add(new SetCardInfo("Carven Caryatid", 382, Rarity.UNCOMMON, mage.cards.c.CarvenCaryatid.class));
        cards.add(new SetCardInfo("Cathar's Companion", 94, Rarity.COMMON, mage.cards.c.CatharsCompanion.class));
        cards.add(new SetCardInfo("Cathars' Crusade", 95, Rarity.RARE, mage.cards.c.CatharsCrusade.class));
        cards.add(new SetCardInfo("Cauldron Familiar", 216, Rarity.COMMON, mage.cards.c.CauldronFamiliar.class));
        cards.add(new SetCardInfo("Celestial Mantle", 96, Rarity.RARE, mage.cards.c.CelestialMantle.class));
        cards.add(new SetCardInfo("Cemetery Recruitment", 217, Rarity.COMMON, mage.cards.c.CemeteryRecruitment.class));
        cards.add(new SetCardInfo("Chain Lightning", 302, Rarity.UNCOMMON, mage.cards.c.ChainLightning.class));
        cards.add(new SetCardInfo("Chained Brute", 19, Rarity.UNCOMMON, mage.cards.c.ChainedBrute.class));
        cards.add(new SetCardInfo("Chamber Sentry", 461, Rarity.RARE, mage.cards.c.ChamberSentry.class));
        cards.add(new SetCardInfo("Champion of Lambholt", 383, Rarity.RARE, mage.cards.c.ChampionOfLambholt.class));
        cards.add(new SetCardInfo("Charmbreaker Devils", 303, Rarity.RARE, mage.cards.c.CharmbreakerDevils.class));
        cards.add(new SetCardInfo("Chart a Course", 142, Rarity.UNCOMMON, mage.cards.c.ChartACourse.class));
        cards.add(new SetCardInfo("Child of Night", 218, Rarity.COMMON, mage.cards.c.ChildOfNight.class));
        cards.add(new SetCardInfo("Chromatic Sphere", 462, Rarity.COMMON, mage.cards.c.ChromaticSphere.class));
        cards.add(new SetCardInfo("Cinder Elemental", 304, Rarity.UNCOMMON, mage.cards.c.CinderElemental.class));
        cards.add(new SetCardInfo("Cloudreader Sphinx", 143, Rarity.COMMON, mage.cards.c.CloudreaderSphinx.class));
        cards.add(new SetCardInfo("Cloudshift", 97, Rarity.COMMON, mage.cards.c.Cloudshift.class));
        cards.add(new SetCardInfo("Coastal Piracy", 144, Rarity.UNCOMMON, mage.cards.c.CoastalPiracy.class));
        cards.add(new SetCardInfo("Collateral Damage", 305, Rarity.COMMON, mage.cards.c.CollateralDamage.class));
        cards.add(new SetCardInfo("Commune with Dinosaurs", 384, Rarity.COMMON, mage.cards.c.CommuneWithDinosaurs.class));
        cards.add(new SetCardInfo("Corpse Hauler", 219, Rarity.COMMON, mage.cards.c.CorpseHauler.class));
        cards.add(new SetCardInfo("Corpse Traders", 220, Rarity.UNCOMMON, mage.cards.c.CorpseTraders.class));
        cards.add(new SetCardInfo("Corsair Captain", 11, Rarity.RARE, mage.cards.c.CorsairCaptain.class));
        cards.add(new SetCardInfo("Cradle of Vitality", 98, Rarity.RARE, mage.cards.c.CradleOfVitality.class));
        cards.add(new SetCardInfo("Craterhoof Behemoth", 385, Rarity.MYTHIC, mage.cards.c.CraterhoofBehemoth.class));
        cards.add(new SetCardInfo("Crookclaw Transmuter", 145, Rarity.COMMON, mage.cards.c.CrookclawTransmuter.class));
        cards.add(new SetCardInfo("Crow of Dark Tidings", 221, Rarity.COMMON, mage.cards.c.CrowOfDarkTidings.class));
        cards.add(new SetCardInfo("Crushing Canopy", 386, Rarity.COMMON, mage.cards.c.CrushingCanopy.class));
        cards.add(new SetCardInfo("Cryptic Serpent", 146, Rarity.UNCOMMON, mage.cards.c.CrypticSerpent.class));
        cards.add(new SetCardInfo("Curiosity", 147, Rarity.UNCOMMON, mage.cards.c.Curiosity.class));
        cards.add(new SetCardInfo("Curious Obsession", 148, Rarity.UNCOMMON, mage.cards.c.CuriousObsession.class));
        cards.add(new SetCardInfo("Dance with Devils", 306, Rarity.UNCOMMON, mage.cards.d.DanceWithDevils.class));
        cards.add(new SetCardInfo("Dauntless Onslaught", 99, Rarity.UNCOMMON, mage.cards.d.DauntlessOnslaught.class));
        cards.add(new SetCardInfo("Dawntreader Elk", 387, Rarity.COMMON, mage.cards.d.DawntreaderElk.class));
        cards.add(new SetCardInfo("Death's Approach", 222, Rarity.COMMON, mage.cards.d.DeathsApproach.class));
        cards.add(new SetCardInfo("Departed Deckhand", 149, Rarity.UNCOMMON, mage.cards.d.DepartedDeckhand.class));
        cards.add(new SetCardInfo("Dinrova Horror", 450, Rarity.UNCOMMON, mage.cards.d.DinrovaHorror.class));
        cards.add(new SetCardInfo("Divine Arrow", 100, Rarity.COMMON, mage.cards.d.DivineArrow.class));
        cards.add(new SetCardInfo("Doublecast", 307, Rarity.UNCOMMON, mage.cards.d.Doublecast.class));
        cards.add(new SetCardInfo("Douse in Gloom", 223, Rarity.COMMON, mage.cards.d.DouseInGloom.class));
        cards.add(new SetCardInfo("Draconic Roar", 308, Rarity.UNCOMMON, mage.cards.d.DraconicRoar.class));
        cards.add(new SetCardInfo("Dragon Fodder", 309, Rarity.COMMON, mage.cards.d.DragonFodder.class));
        cards.add(new SetCardInfo("Dragon Hatchling", 310, Rarity.COMMON, mage.cards.d.DragonHatchling.class));
        cards.add(new SetCardInfo("Dragonloft Idol", 463, Rarity.UNCOMMON, mage.cards.d.DragonloftIdol.class));
        cards.add(new SetCardInfo("Dragonlord's Servant", 311, Rarity.UNCOMMON, mage.cards.d.DragonlordsServant.class));
        cards.add(new SetCardInfo("Dragonspeaker Shaman", 312, Rarity.UNCOMMON, mage.cards.d.DragonspeakerShaman.class));
        cards.add(new SetCardInfo("Drainpipe Vermin", 224, Rarity.COMMON, mage.cards.d.DrainpipeVermin.class));
        cards.add(new SetCardInfo("Drana, Liberator of Malakir", 225, Rarity.MYTHIC, mage.cards.d.DranaLiberatorOfMalakir.class));
        cards.add(new SetCardInfo("Dreamstone Hedron", 464, Rarity.UNCOMMON, mage.cards.d.DreamstoneHedron.class));
        cards.add(new SetCardInfo("Drover of the Mighty", 388, Rarity.UNCOMMON, mage.cards.d.DroverOfTheMighty.class));
        cards.add(new SetCardInfo("Dualcaster Mage", 313, Rarity.RARE, mage.cards.d.DualcasterMage.class));
        cards.add(new SetCardInfo("Duelist's Heritage", 101, Rarity.RARE, mage.cards.d.DuelistsHeritage.class));
        cards.add(new SetCardInfo("Dutiful Attendant", 226, Rarity.COMMON, mage.cards.d.DutifulAttendant.class));
        cards.add(new SetCardInfo("Dwynen's Elite", 389, Rarity.UNCOMMON, mage.cards.d.DwynensElite.class));
        cards.add(new SetCardInfo("Elemental Uprising", 390, Rarity.COMMON, mage.cards.e.ElementalUprising.class));
        cards.add(new SetCardInfo("Elvish Archdruid", 391, Rarity.RARE, mage.cards.e.ElvishArchdruid.class));
        cards.add(new SetCardInfo("Emancipation Angel", 102, Rarity.UNCOMMON, mage.cards.e.EmancipationAngel.class));
        cards.add(new SetCardInfo("Emiel the Blessed", 3, Rarity.MYTHIC, mage.cards.e.EmielTheBlessed.class));
        cards.add(new SetCardInfo("Enlarge", 392, Rarity.UNCOMMON, mage.cards.e.Enlarge.class));
        cards.add(new SetCardInfo("Entomber Exarch", 227, Rarity.UNCOMMON, mage.cards.e.EntomberExarch.class));
        cards.add(new SetCardInfo("Erratic Visionary", 150, Rarity.COMMON, mage.cards.e.ErraticVisionary.class));
        cards.add(new SetCardInfo("Essence Flux", 151, Rarity.UNCOMMON, mage.cards.e.EssenceFlux.class));
        cards.add(new SetCardInfo("Etali, Primal Storm", 314, Rarity.RARE, mage.cards.e.EtaliPrimalStorm.class));
        cards.add(new SetCardInfo("Eternal Taskmaster", 228, Rarity.UNCOMMON, mage.cards.e.EternalTaskmaster.class));
        cards.add(new SetCardInfo("Eternal Thirst", 229, Rarity.COMMON, mage.cards.e.EternalThirst.class));
        cards.add(new SetCardInfo("Exclude", 152, Rarity.UNCOMMON, mage.cards.e.Exclude.class));
        cards.add(new SetCardInfo("Exclusion Mage", 153, Rarity.UNCOMMON, mage.cards.e.ExclusionMage.class));
        cards.add(new SetCardInfo("Exhume", 230, Rarity.UNCOMMON, mage.cards.e.Exhume.class));
        cards.add(new SetCardInfo("Explore", 393, Rarity.COMMON, mage.cards.e.Explore.class));
        cards.add(new SetCardInfo("Exquisite Blood", 231, Rarity.RARE, mage.cards.e.ExquisiteBlood.class));
        cards.add(new SetCardInfo("Fa'adiyah Seer", 394, Rarity.COMMON, mage.cards.f.FaadiyahSeer.class));
        cards.add(new SetCardInfo("Face of Divinity", 103, Rarity.UNCOMMON, mage.cards.f.FaceOfDivinity.class));
        cards.add(new SetCardInfo("Falkenrath Noble", 232, Rarity.UNCOMMON, mage.cards.f.FalkenrathNoble.class));
        cards.add(new SetCardInfo("Fanatical Firebrand", 315, Rarity.COMMON, mage.cards.f.FanaticalFirebrand.class));
        cards.add(new SetCardInfo("Fell Specter", 233, Rarity.UNCOMMON, mage.cards.f.FellSpecter.class));
        cards.add(new SetCardInfo("Feral Hydra", 395, Rarity.UNCOMMON, mage.cards.f.FeralHydra.class));
        cards.add(new SetCardInfo("Feral Invocation", 396, Rarity.COMMON, mage.cards.f.FeralInvocation.class));
        cards.add(new SetCardInfo("Feral Prowler", 397, Rarity.COMMON, mage.cards.f.FeralProwler.class));
        cards.add(new SetCardInfo("Fertilid", 398, Rarity.COMMON, mage.cards.f.Fertilid.class));
        cards.add(new SetCardInfo("Festering Newt", 234, Rarity.COMMON, mage.cards.f.FesteringNewt.class));
        cards.add(new SetCardInfo("Flame Lash", 316, Rarity.COMMON, mage.cards.f.FlameLash.class));
        cards.add(new SetCardInfo("Flames of the Firebrand", 317, Rarity.UNCOMMON, mage.cards.f.FlamesOfTheFirebrand.class));
        cards.add(new SetCardInfo("Flames of the Raze-Boar", 318, Rarity.UNCOMMON, mage.cards.f.FlamesOfTheRazeBoar.class));
        cards.add(new SetCardInfo("Flametongue Kavu", 319, Rarity.UNCOMMON, mage.cards.f.FlametongueKavu.class));
        cards.add(new SetCardInfo("Fling", 320, Rarity.COMMON, mage.cards.f.Fling.class));
        cards.add(new SetCardInfo("Flurry of Horns", 321, Rarity.COMMON, mage.cards.f.FlurryOfHorns.class));
        cards.add(new SetCardInfo("Forced Worship", 104, Rarity.COMMON, mage.cards.f.ForcedWorship.class));
        cards.add(new SetCardInfo("Forest", 70, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 71, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 72, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 73, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 74, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 75, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 76, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 77, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forge Devil", 322, Rarity.COMMON, mage.cards.f.ForgeDevil.class));
        cards.add(new SetCardInfo("Fortify", 105, Rarity.COMMON, mage.cards.f.Fortify.class));
        cards.add(new SetCardInfo("Funeral Rites", 235, Rarity.COMMON, mage.cards.f.FuneralRites.class));
        cards.add(new SetCardInfo("Furnace Whelp", 323, Rarity.UNCOMMON, mage.cards.f.FurnaceWhelp.class));
        cards.add(new SetCardInfo("Fusion Elemental", 451, Rarity.UNCOMMON, mage.cards.f.FusionElemental.class));
        cards.add(new SetCardInfo("Gargoyle Sentinel", 465, Rarity.UNCOMMON, mage.cards.g.GargoyleSentinel.class));
        cards.add(new SetCardInfo("Ghalta, Primal Hunger", 399, Rarity.RARE, mage.cards.g.GhaltaPrimalHunger.class));
        cards.add(new SetCardInfo("Ghirapur Guide", 400, Rarity.UNCOMMON, mage.cards.g.GhirapurGuide.class));
        cards.add(new SetCardInfo("Ghoulcaller Gisa", 236, Rarity.MYTHIC, mage.cards.g.GhoulcallerGisa.class));
        cards.add(new SetCardInfo("Ghoulcaller's Accomplice", 237, Rarity.COMMON, mage.cards.g.GhoulcallersAccomplice.class));
        cards.add(new SetCardInfo("Ghoulraiser", 238, Rarity.COMMON, mage.cards.g.Ghoulraiser.class));
        cards.add(new SetCardInfo("Gifted Aetherborn", 239, Rarity.UNCOMMON, mage.cards.g.GiftedAetherborn.class));
        cards.add(new SetCardInfo("Gingerbrute", 466, Rarity.COMMON, mage.cards.g.Gingerbrute.class));
        cards.add(new SetCardInfo("Gird for Battle", 106, Rarity.UNCOMMON, mage.cards.g.GirdForBattle.class));
        cards.add(new SetCardInfo("Goblin Chieftain", 324, Rarity.RARE, mage.cards.g.GoblinChieftain.class));
        cards.add(new SetCardInfo("Goblin Commando", 325, Rarity.UNCOMMON, mage.cards.g.GoblinCommando.class));
        cards.add(new SetCardInfo("Goblin Goon", 326, Rarity.RARE, mage.cards.g.GoblinGoon.class));
        cards.add(new SetCardInfo("Goblin Instigator", 327, Rarity.COMMON, mage.cards.g.GoblinInstigator.class));
        cards.add(new SetCardInfo("Goblin Lore", 328, Rarity.UNCOMMON, mage.cards.g.GoblinLore.class));
        cards.add(new SetCardInfo("Goblin Rally", 329, Rarity.UNCOMMON, mage.cards.g.GoblinRally.class));
        cards.add(new SetCardInfo("Goblin Shortcutter", 330, Rarity.COMMON, mage.cards.g.GoblinShortcutter.class));
        cards.add(new SetCardInfo("Gonti, Lord of Luxury", 240, Rarity.RARE, mage.cards.g.GontiLordOfLuxury.class));
        cards.add(new SetCardInfo("Grave Bramble", 401, Rarity.COMMON, mage.cards.g.GraveBramble.class));
        cards.add(new SetCardInfo("Gravewaker", 241, Rarity.RARE, mage.cards.g.Gravewaker.class));
        cards.add(new SetCardInfo("Grim Lavamancer", 331, Rarity.RARE, mage.cards.g.GrimLavamancer.class));
        cards.add(new SetCardInfo("Gristle Grinner", 242, Rarity.UNCOMMON, mage.cards.g.GristleGrinner.class));
        cards.add(new SetCardInfo("Guardian Idol", 467, Rarity.UNCOMMON, mage.cards.g.GuardianIdol.class));
        cards.add(new SetCardInfo("Hamletback Goliath", 332, Rarity.RARE, mage.cards.h.HamletbackGoliath.class));
        cards.add(new SetCardInfo("Harvester of Souls", 243, Rarity.RARE, mage.cards.h.HarvesterOfSouls.class));
        cards.add(new SetCardInfo("Healer's Hawk", 107, Rarity.COMMON, mage.cards.h.HealersHawk.class));
        cards.add(new SetCardInfo("Heartfire", 333, Rarity.COMMON, mage.cards.h.Heartfire.class));
        cards.add(new SetCardInfo("Hedron Archive", 468, Rarity.UNCOMMON, mage.cards.h.HedronArchive.class));
        cards.add(new SetCardInfo("Hellrider", 334, Rarity.RARE, mage.cards.h.Hellrider.class));
        cards.add(new SetCardInfo("Herald's Horn", 469, Rarity.UNCOMMON, mage.cards.h.HeraldsHorn.class));
        cards.add(new SetCardInfo("High Sentinels of Arashin", 108, Rarity.RARE, mage.cards.h.HighSentinelsOfArashin.class));
        cards.add(new SetCardInfo("Homing Lightning", 335, Rarity.UNCOMMON, mage.cards.h.HomingLightning.class));
        cards.add(new SetCardInfo("Hungry Flames", 336, Rarity.COMMON, mage.cards.h.HungryFlames.class));
        cards.add(new SetCardInfo("Hunter's Insight", 402, Rarity.UNCOMMON, mage.cards.h.HuntersInsight.class));
        cards.add(new SetCardInfo("Immolating Gyre", 20, Rarity.MYTHIC, mage.cards.i.ImmolatingGyre.class));
        cards.add(new SetCardInfo("Indomitable Will", 109, Rarity.COMMON, mage.cards.i.IndomitableWill.class));
        cards.add(new SetCardInfo("Inferno Hellion", 337, Rarity.UNCOMMON, mage.cards.i.InfernoHellion.class));
        cards.add(new SetCardInfo("Initiate's Companion", 403, Rarity.COMMON, mage.cards.i.InitiatesCompanion.class));
        cards.add(new SetCardInfo("Inniaz, the Gale Force", 12, Rarity.RARE, mage.cards.i.InniazTheGaleForce.class));
        cards.add(new SetCardInfo("Innocent Blood", 244, Rarity.COMMON, mage.cards.i.InnocentBlood.class));
        cards.add(new SetCardInfo("Inspired Charge", 110, Rarity.COMMON, mage.cards.i.InspiredCharge.class));
        cards.add(new SetCardInfo("Inspiring Call", 404, Rarity.UNCOMMON, mage.cards.i.InspiringCall.class));
        cards.add(new SetCardInfo("Inspiring Captain", 111, Rarity.COMMON, mage.cards.i.InspiringCaptain.class));
        cards.add(new SetCardInfo("Inspiring Unicorn", 112, Rarity.UNCOMMON, mage.cards.i.InspiringUnicorn.class));
        cards.add(new SetCardInfo("Ironroot Warlord", 452, Rarity.UNCOMMON, mage.cards.i.IronrootWarlord.class));
        cards.add(new SetCardInfo("Ironshell Beetle", 405, Rarity.COMMON, mage.cards.i.IronshellBeetle.class));
        cards.add(new SetCardInfo("Irresistible Prey", 406, Rarity.UNCOMMON, mage.cards.i.IrresistiblePrey.class));
        cards.add(new SetCardInfo("Isamaru, Hound of Konda", 113, Rarity.RARE, mage.cards.i.IsamaruHoundOfKonda.class));
        cards.add(new SetCardInfo("Island", 46, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 47, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 48, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 49, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 50, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 51, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 52, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 53, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jousting Dummy", 470, Rarity.COMMON, mage.cards.j.JoustingDummy.class));
        cards.add(new SetCardInfo("Juggernaut", 471, Rarity.UNCOMMON, mage.cards.j.Juggernaut.class));
        cards.add(new SetCardInfo("Kalastria Nightwatch", 245, Rarity.COMMON, mage.cards.k.KalastriaNightwatch.class));
        cards.add(new SetCardInfo("Keeper of Fables", 407, Rarity.UNCOMMON, mage.cards.k.KeeperOfFables.class));
        cards.add(new SetCardInfo("Kels, Fight Fixer", 15, Rarity.RARE, mage.cards.k.KelsFightFixer.class));
        cards.add(new SetCardInfo("Kiln Fiend", 338, Rarity.COMMON, mage.cards.k.KilnFiend.class));
        cards.add(new SetCardInfo("Kira, Great Glass-Spinner", 154, Rarity.RARE, mage.cards.k.KiraGreatGlassSpinner.class));
        cards.add(new SetCardInfo("Kitesail Corsair", 155, Rarity.COMMON, mage.cards.k.KitesailCorsair.class));
        cards.add(new SetCardInfo("Knight of the Tusk", 114, Rarity.COMMON, mage.cards.k.KnightOfTheTusk.class));
        cards.add(new SetCardInfo("Knightly Valor", 115, Rarity.COMMON, mage.cards.k.KnightlyValor.class));
        cards.add(new SetCardInfo("Kor Spiritdancer", 116, Rarity.RARE, mage.cards.k.KorSpiritdancer.class));
        cards.add(new SetCardInfo("Krenko, Mob Boss", 339, Rarity.RARE, mage.cards.k.KrenkoMobBoss.class));
        cards.add(new SetCardInfo("Languish", 246, Rarity.RARE, mage.cards.l.Languish.class));
        cards.add(new SetCardInfo("Last Gasp", 247, Rarity.COMMON, mage.cards.l.LastGasp.class));
        cards.add(new SetCardInfo("Lathliss, Dragon Queen", 340, Rarity.RARE, mage.cards.l.LathlissDragonQueen.class));
        cards.add(new SetCardInfo("Launch Party", 248, Rarity.COMMON, mage.cards.l.LaunchParty.class));
        cards.add(new SetCardInfo("Lawless Broker", 249, Rarity.COMMON, mage.cards.l.LawlessBroker.class));
        cards.add(new SetCardInfo("Lawmage's Binding", 453, Rarity.COMMON, mage.cards.l.LawmagesBinding.class));
        cards.add(new SetCardInfo("Leaf Gilder", 408, Rarity.COMMON, mage.cards.l.LeafGilder.class));
        cards.add(new SetCardInfo("Leave in the Dust", 156, Rarity.COMMON, mage.cards.l.LeaveInTheDust.class));
        cards.add(new SetCardInfo("Lena, Selfless Champion", 117, Rarity.RARE, mage.cards.l.LenaSelflessChampion.class));
        cards.add(new SetCardInfo("Lifecrafter's Gift", 409, Rarity.UNCOMMON, mage.cards.l.LifecraftersGift.class));
        cards.add(new SetCardInfo("Lightning Axe", 341, Rarity.UNCOMMON, mage.cards.l.LightningAxe.class));
        cards.add(new SetCardInfo("Lightning Bolt", 342, Rarity.UNCOMMON, mage.cards.l.LightningBolt.class));
        cards.add(new SetCardInfo("Lightning Diadem", 343, Rarity.COMMON, mage.cards.l.LightningDiadem.class));
        cards.add(new SetCardInfo("Lightning Elemental", 344, Rarity.COMMON, mage.cards.l.LightningElemental.class));
        cards.add(new SetCardInfo("Lightning Phoenix", 21, Rarity.RARE, mage.cards.l.LightningPhoenix.class));
        cards.add(new SetCardInfo("Lightning Shrieker", 345, Rarity.COMMON, mage.cards.l.LightningShrieker.class));
        cards.add(new SetCardInfo("Lightning Visionary", 22, Rarity.COMMON, mage.cards.l.LightningVisionary.class));
        cards.add(new SetCardInfo("Lightning-Core Excavator", 32, Rarity.COMMON, mage.cards.l.LightningCoreExcavator.class));
        cards.add(new SetCardInfo("Lightwalker", 118, Rarity.COMMON, mage.cards.l.Lightwalker.class));
        cards.add(new SetCardInfo("Liliana's Elite", 250, Rarity.UNCOMMON, mage.cards.l.LilianasElite.class));
        cards.add(new SetCardInfo("Liliana's Reaver", 251, Rarity.RARE, mage.cards.l.LilianasReaver.class));
        cards.add(new SetCardInfo("Linvala, Keeper of Silence", 119, Rarity.MYTHIC, mage.cards.l.LinvalaKeeperOfSilence.class));
        cards.add(new SetCardInfo("Living Lightning", 23, Rarity.UNCOMMON, mage.cards.l.LivingLightning.class));
        cards.add(new SetCardInfo("Long Road Home", 120, Rarity.UNCOMMON, mage.cards.l.LongRoadHome.class));
        cards.add(new SetCardInfo("Lurking Predators", 410, Rarity.RARE, mage.cards.l.LurkingPredators.class));
        cards.add(new SetCardInfo("Macabre Waltz", 252, Rarity.COMMON, mage.cards.m.MacabreWaltz.class));
        cards.add(new SetCardInfo("Maelstrom Archangel", 454, Rarity.MYTHIC, mage.cards.m.MaelstromArchangel.class));
        cards.add(new SetCardInfo("Magma Jet", 346, Rarity.UNCOMMON, mage.cards.m.MagmaJet.class));
        cards.add(new SetCardInfo("Magmaquake", 347, Rarity.RARE, mage.cards.m.Magmaquake.class));
        cards.add(new SetCardInfo("Makeshift Munitions", 348, Rarity.UNCOMMON, mage.cards.m.MakeshiftMunitions.class));
        cards.add(new SetCardInfo("Malakir Familiar", 253, Rarity.UNCOMMON, mage.cards.m.MalakirFamiliar.class));
        cards.add(new SetCardInfo("Mana Geode", 472, Rarity.COMMON, mage.cards.m.ManaGeode.class));
        cards.add(new SetCardInfo("Marauder's Axe", 473, Rarity.COMMON, mage.cards.m.MaraudersAxe.class));
        cards.add(new SetCardInfo("Mark of the Vampire", 254, Rarity.COMMON, mage.cards.m.MarkOfTheVampire.class));
        cards.add(new SetCardInfo("Mausoleum Turnkey", 255, Rarity.UNCOMMON, mage.cards.m.MausoleumTurnkey.class));
        cards.add(new SetCardInfo("Mentor of the Meek", 121, Rarity.RARE, mage.cards.m.MentorOfTheMeek.class));
        cards.add(new SetCardInfo("Mesa Unicorn", 122, Rarity.COMMON, mage.cards.m.MesaUnicorn.class));
        cards.add(new SetCardInfo("Meteor Golem", 474, Rarity.UNCOMMON, mage.cards.m.MeteorGolem.class));
        cards.add(new SetCardInfo("Miasmic Mummy", 256, Rarity.COMMON, mage.cards.m.MiasmicMummy.class));
        cards.add(new SetCardInfo("Mikaeus, the Lunarch", 123, Rarity.MYTHIC, mage.cards.m.MikaeusTheLunarch.class));
        cards.add(new SetCardInfo("Minotaur Skullcleaver", 349, Rarity.COMMON, mage.cards.m.MinotaurSkullcleaver.class));
        cards.add(new SetCardInfo("Minotaur Sureshot", 350, Rarity.COMMON, mage.cards.m.MinotaurSureshot.class));
        cards.add(new SetCardInfo("Mire Triton", 257, Rarity.UNCOMMON, mage.cards.m.MireTriton.class));
        cards.add(new SetCardInfo("Mirrodin's Core", 492, Rarity.UNCOMMON, mage.cards.m.MirrodinsCore.class));
        cards.add(new SetCardInfo("Molten Ravager", 351, Rarity.COMMON, mage.cards.m.MoltenRavager.class));
        cards.add(new SetCardInfo("Moment of Heroism", 124, Rarity.COMMON, mage.cards.m.MomentOfHeroism.class));
        cards.add(new SetCardInfo("Momentous Fall", 411, Rarity.RARE, mage.cards.m.MomentousFall.class));
        cards.add(new SetCardInfo("Mountain", 62, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 63, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 64, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 65, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 66, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 67, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 68, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 69, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mugging", 352, Rarity.COMMON, mage.cards.m.Mugging.class));
        cards.add(new SetCardInfo("Murmuring Phantasm", 157, Rarity.COMMON, mage.cards.m.MurmuringPhantasm.class));
        cards.add(new SetCardInfo("Muxus, Goblin Grandee", 24, Rarity.RARE, mage.cards.m.MuxusGoblinGrandee.class));
        cards.add(new SetCardInfo("Myr Sire", 475, Rarity.COMMON, mage.cards.m.MyrSire.class));
        cards.add(new SetCardInfo("Mystic Archaeologist", 158, Rarity.RARE, mage.cards.m.MysticArchaeologist.class));
        cards.add(new SetCardInfo("Narcolepsy", 159, Rarity.COMMON, mage.cards.n.Narcolepsy.class));
        cards.add(new SetCardInfo("Nature's Way", 412, Rarity.UNCOMMON, mage.cards.n.NaturesWay.class));
        cards.add(new SetCardInfo("Nebelgast Herald", 160, Rarity.UNCOMMON, mage.cards.n.NebelgastHerald.class));
        cards.add(new SetCardInfo("Nessian Hornbeetle", 413, Rarity.UNCOMMON, mage.cards.n.NessianHornbeetle.class));
        cards.add(new SetCardInfo("New Horizons", 414, Rarity.COMMON, mage.cards.n.NewHorizons.class));
        cards.add(new SetCardInfo("Neyith of the Dire Hunt", 30, Rarity.RARE, mage.cards.n.NeyithOfTheDireHunt.class));
        cards.add(new SetCardInfo("Nightshade Stinger", 258, Rarity.COMMON, mage.cards.n.NightshadeStinger.class));
        cards.add(new SetCardInfo("Nocturnal Feeder", 16, Rarity.COMMON, mage.cards.n.NocturnalFeeder.class));
        cards.add(new SetCardInfo("Nyxathid", 259, Rarity.RARE, mage.cards.n.Nyxathid.class));
        cards.add(new SetCardInfo("Octoprophet", 161, Rarity.COMMON, mage.cards.o.Octoprophet.class));
        cards.add(new SetCardInfo("Ogre Slumlord", 260, Rarity.RARE, mage.cards.o.OgreSlumlord.class));
        cards.add(new SetCardInfo("Oneirophage", 162, Rarity.UNCOMMON, mage.cards.o.Oneirophage.class));
        cards.add(new SetCardInfo("Oona's Blackguard", 261, Rarity.UNCOMMON, mage.cards.o.OonasBlackguard.class));
        cards.add(new SetCardInfo("Oracle of Mul Daya", 415, Rarity.RARE, mage.cards.o.OracleOfMulDaya.class));
        cards.add(new SetCardInfo("Orazca Frillback", 416, Rarity.COMMON, mage.cards.o.OrazcaFrillback.class));
        cards.add(new SetCardInfo("Ormos, Archive Keeper", 13, Rarity.RARE, mage.cards.o.OrmosArchiveKeeper.class));
        cards.add(new SetCardInfo("Ornery Goblin", 353, Rarity.COMMON, mage.cards.o.OrneryGoblin.class));
        cards.add(new SetCardInfo("Outnumber", 354, Rarity.COMMON, mage.cards.o.Outnumber.class));
        cards.add(new SetCardInfo("Overgrown Battlement", 417, Rarity.UNCOMMON, mage.cards.o.OvergrownBattlement.class));
        cards.add(new SetCardInfo("Pacifism", 125, Rarity.COMMON, mage.cards.p.Pacifism.class));
        cards.add(new SetCardInfo("Parasitic Implant", 262, Rarity.COMMON, mage.cards.p.ParasiticImplant.class));
        cards.add(new SetCardInfo("Path of Bravery", 126, Rarity.RARE, mage.cards.p.PathOfBravery.class));
        cards.add(new SetCardInfo("Path to Exile", 127, Rarity.UNCOMMON, mage.cards.p.PathToExile.class));
        cards.add(new SetCardInfo("Patron of the Valiant", 128, Rarity.UNCOMMON, mage.cards.p.PatronOfTheValiant.class));
        cards.add(new SetCardInfo("Peel from Reality", 163, Rarity.COMMON, mage.cards.p.PeelFromReality.class));
        cards.add(new SetCardInfo("Penumbra Bobcat", 418, Rarity.COMMON, mage.cards.p.PenumbraBobcat.class));
        cards.add(new SetCardInfo("Perilous Myr", 476, Rarity.COMMON, mage.cards.p.PerilousMyr.class));
        cards.add(new SetCardInfo("Phyrexian Broodlings", 263, Rarity.COMMON, mage.cards.p.PhyrexianBroodlings.class));
        cards.add(new SetCardInfo("Phyrexian Debaser", 264, Rarity.COMMON, mage.cards.p.PhyrexianDebaser.class));
        cards.add(new SetCardInfo("Phyrexian Gargantua", 265, Rarity.UNCOMMON, mage.cards.p.PhyrexianGargantua.class));
        cards.add(new SetCardInfo("Phyrexian Rager", 266, Rarity.COMMON, mage.cards.p.PhyrexianRager.class));
        cards.add(new SetCardInfo("Phyrexian Reclamation", 267, Rarity.UNCOMMON, mage.cards.p.PhyrexianReclamation.class));
        cards.add(new SetCardInfo("Phyrexian Tower", 493, Rarity.RARE, mage.cards.p.PhyrexianTower.class));
        cards.add(new SetCardInfo("Pillar of Flame", 355, Rarity.COMMON, mage.cards.p.PillarOfFlame.class));
        cards.add(new SetCardInfo("Pirate's Cutlass", 477, Rarity.COMMON, mage.cards.p.PiratesCutlass.class));
        cards.add(new SetCardInfo("Plagued Rusalka", 268, Rarity.COMMON, mage.cards.p.PlaguedRusalka.class));
        cards.add(new SetCardInfo("Plains", 38, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 39, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 40, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 41, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 42, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 43, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 44, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 45, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pouncing Cheetah", 419, Rarity.COMMON, mage.cards.p.PouncingCheetah.class));
        cards.add(new SetCardInfo("Prescient Chimera", 164, Rarity.COMMON, mage.cards.p.PrescientChimera.class));
        cards.add(new SetCardInfo("Presence of Gond", 420, Rarity.COMMON, mage.cards.p.PresenceOfGond.class));
        cards.add(new SetCardInfo("Primeval Bounty", 421, Rarity.MYTHIC, mage.cards.p.PrimevalBounty.class));
        cards.add(new SetCardInfo("Primordial Sage", 422, Rarity.RARE, mage.cards.p.PrimordialSage.class));
        cards.add(new SetCardInfo("Prophetic Prism", 478, Rarity.COMMON, mage.cards.p.PropheticPrism.class));
        cards.add(new SetCardInfo("Prosperous Pirates", 165, Rarity.COMMON, mage.cards.p.ProsperousPirates.class));
        cards.add(new SetCardInfo("Pyroclastic Elemental", 356, Rarity.UNCOMMON, mage.cards.p.PyroclasticElemental.class));
        cards.add(new SetCardInfo("Rageblood Shaman", 357, Rarity.RARE, mage.cards.r.RagebloodShaman.class));
        cards.add(new SetCardInfo("Raging Regisaur", 455, Rarity.UNCOMMON, mage.cards.r.RagingRegisaur.class));
        cards.add(new SetCardInfo("Raise the Alarm", 129, Rarity.COMMON, mage.cards.r.RaiseTheAlarm.class));
        cards.add(new SetCardInfo("Rampaging Brontodon", 423, Rarity.RARE, mage.cards.r.RampagingBrontodon.class));
        cards.add(new SetCardInfo("Rapacious Dragon", 358, Rarity.UNCOMMON, mage.cards.r.RapaciousDragon.class));
        cards.add(new SetCardInfo("Rattlechains", 166, Rarity.RARE, mage.cards.r.Rattlechains.class));
        cards.add(new SetCardInfo("Ravenous Baloth", 424, Rarity.RARE, mage.cards.r.RavenousBaloth.class));
        cards.add(new SetCardInfo("Ravenous Chupacabra", 269, Rarity.UNCOMMON, mage.cards.r.RavenousChupacabra.class));
        cards.add(new SetCardInfo("Read the Runes", 167, Rarity.RARE, mage.cards.r.ReadTheRunes.class));
        cards.add(new SetCardInfo("Reanimate", 270, Rarity.RARE, mage.cards.r.Reanimate.class));
        cards.add(new SetCardInfo("Reckless Scholar", 168, Rarity.UNCOMMON, mage.cards.r.RecklessScholar.class));
        cards.add(new SetCardInfo("Release the Dogs", 4, Rarity.UNCOMMON, mage.cards.r.ReleaseTheDogs.class));
        cards.add(new SetCardInfo("Rhox Faithmender", 130, Rarity.RARE, mage.cards.r.RhoxFaithmender.class));
        cards.add(new SetCardInfo("Rhystic Study", 169, Rarity.RARE, mage.cards.r.RhysticStudy.class));
        cards.add(new SetCardInfo("Riddle of Lightning", 359, Rarity.UNCOMMON, mage.cards.r.RiddleOfLightning.class));
        cards.add(new SetCardInfo("Riptide Laboratory", 494, Rarity.RARE, mage.cards.r.RiptideLaboratory.class));
        cards.add(new SetCardInfo("Rise of the Dark Realms", 271, Rarity.MYTHIC, mage.cards.r.RiseOfTheDarkRealms.class));
        cards.add(new SetCardInfo("Rishadan Airship", 170, Rarity.COMMON, mage.cards.r.RishadanAirship.class));
        cards.add(new SetCardInfo("Rishkar, Peema Renegade", 425, Rarity.RARE, mage.cards.r.RishkarPeemaRenegade.class));
        cards.add(new SetCardInfo("Rogue's Gloves", 479, Rarity.UNCOMMON, mage.cards.r.RoguesGloves.class));
        cards.add(new SetCardInfo("Ronom Unicorn", 131, Rarity.COMMON, mage.cards.r.RonomUnicorn.class));
        cards.add(new SetCardInfo("Roving Keep", 480, Rarity.COMMON, mage.cards.r.RovingKeep.class));
        cards.add(new SetCardInfo("Rumbling Baloth", 426, Rarity.COMMON, mage.cards.r.RumblingBaloth.class));
        cards.add(new SetCardInfo("Runed Servitor", 481, Rarity.COMMON, mage.cards.r.RunedServitor.class));
        cards.add(new SetCardInfo("Rupture Spire", 495, Rarity.COMMON, mage.cards.r.RuptureSpire.class));
        cards.add(new SetCardInfo("Sage's Row Savant", 171, Rarity.COMMON, mage.cards.s.SagesRowSavant.class));
        cards.add(new SetCardInfo("Sailor of Means", 172, Rarity.COMMON, mage.cards.s.SailorOfMeans.class));
        cards.add(new SetCardInfo("Sangromancer", 272, Rarity.RARE, mage.cards.s.Sangromancer.class));
        cards.add(new SetCardInfo("Sanitarium Skeleton", 273, Rarity.COMMON, mage.cards.s.SanitariumSkeleton.class));
        cards.add(new SetCardInfo("Sarkhan's Rage", 360, Rarity.COMMON, mage.cards.s.SarkhansRage.class));
        cards.add(new SetCardInfo("Sarkhan's Unsealing", 361, Rarity.RARE, mage.cards.s.SarkhansUnsealing.class));
        cards.add(new SetCardInfo("Savage Stomp", 427, Rarity.UNCOMMON, mage.cards.s.SavageStomp.class));
        cards.add(new SetCardInfo("Scarecrone", 482, Rarity.RARE, mage.cards.s.Scarecrone.class));
        cards.add(new SetCardInfo("Scholar of the Lost Trove", 14, Rarity.RARE, mage.cards.s.ScholarOfTheLostTrove.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scholar of the Lost Trove", 496, Rarity.RARE, mage.cards.s.ScholarOfTheLostTrove.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scourge of Nel Toth", 274, Rarity.RARE, mage.cards.s.ScourgeOfNelToth.class));
        cards.add(new SetCardInfo("Scroll of Avacyn", 483, Rarity.COMMON, mage.cards.s.ScrollOfAvacyn.class));
        cards.add(new SetCardInfo("Scrounging Bandar", 428, Rarity.COMMON, mage.cards.s.ScroungingBandar.class));
        cards.add(new SetCardInfo("Scuttlemutt", 484, Rarity.UNCOMMON, mage.cards.s.Scuttlemutt.class));
        cards.add(new SetCardInfo("Sea Gate Oracle", 173, Rarity.COMMON, mage.cards.s.SeaGateOracle.class));
        cards.add(new SetCardInfo("Seismic Elemental", 362, Rarity.UNCOMMON, mage.cards.s.SeismicElemental.class));
        cards.add(new SetCardInfo("Selhoff Occultist", 174, Rarity.COMMON, mage.cards.s.SelhoffOccultist.class));
        cards.add(new SetCardInfo("Selvala, Heart of the Wilds", 429, Rarity.MYTHIC, mage.cards.s.SelvalaHeartOfTheWilds.class));
        cards.add(new SetCardInfo("Sengir Vampire", 275, Rarity.UNCOMMON, mage.cards.s.SengirVampire.class));
        cards.add(new SetCardInfo("Serendib Efreet", 175, Rarity.RARE, mage.cards.s.SerendibEfreet.class));
        cards.add(new SetCardInfo("Serra Angel", 132, Rarity.UNCOMMON, mage.cards.s.SerraAngel.class));
        cards.add(new SetCardInfo("Sethron, Hurloon General", 25, Rarity.RARE, mage.cards.s.SethronHurloonGeneral.class));
        cards.add(new SetCardInfo("Settle the Score", 276, Rarity.UNCOMMON, mage.cards.s.SettleTheScore.class));
        cards.add(new SetCardInfo("Shambling Goblin", 277, Rarity.COMMON, mage.cards.s.ShamblingGoblin.class));
        cards.add(new SetCardInfo("Sharding Sphinx", 176, Rarity.RARE, mage.cards.s.ShardingSphinx.class));
        cards.add(new SetCardInfo("Sheoldred, Whispering One", 278, Rarity.MYTHIC, mage.cards.s.SheoldredWhisperingOne.class));
        cards.add(new SetCardInfo("Sigiled Starfish", 177, Rarity.UNCOMMON, mage.cards.s.SigiledStarfish.class));
        cards.add(new SetCardInfo("Signpost Scarecrow", 485, Rarity.COMMON, mage.cards.s.SignpostScarecrow.class));
        cards.add(new SetCardInfo("Silhana Wayfinder", 430, Rarity.UNCOMMON, mage.cards.s.SilhanaWayfinder.class));
        cards.add(new SetCardInfo("Sin Prodder", 363, Rarity.RARE, mage.cards.s.SinProdder.class));
        cards.add(new SetCardInfo("Skittering Surveyor", 486, Rarity.COMMON, mage.cards.s.SkitteringSurveyor.class));
        cards.add(new SetCardInfo("Sky Tether", 133, Rarity.UNCOMMON, mage.cards.s.SkyTether.class));
        cards.add(new SetCardInfo("Slate Street Ruffian", 279, Rarity.COMMON, mage.cards.s.SlateStreetRuffian.class));
        cards.add(new SetCardInfo("Somberwald Stag", 431, Rarity.UNCOMMON, mage.cards.s.SomberwaldStag.class));
        cards.add(new SetCardInfo("Soul Salvage", 280, Rarity.COMMON, mage.cards.s.SoulSalvage.class));
        cards.add(new SetCardInfo("Soul of the Harvest", 432, Rarity.RARE, mage.cards.s.SoulOfTheHarvest.class));
        cards.add(new SetCardInfo("Spectral Sailor", 178, Rarity.UNCOMMON, mage.cards.s.SpectralSailor.class));
        cards.add(new SetCardInfo("Spiteful Prankster", 26, Rarity.UNCOMMON, mage.cards.s.SpitefulPrankster.class));
        cards.add(new SetCardInfo("Spitting Earth", 364, Rarity.COMMON, mage.cards.s.SpittingEarth.class));
        cards.add(new SetCardInfo("Sporemound", 433, Rarity.COMMON, mage.cards.s.Sporemound.class));
        cards.add(new SetCardInfo("Stab Wound", 281, Rarity.UNCOMMON, mage.cards.s.StabWound.class));
        cards.add(new SetCardInfo("Steel-Plume Marshal", 5, Rarity.RARE, mage.cards.s.SteelPlumeMarshal.class));
        cards.add(new SetCardInfo("Stone Haven Pilgrim", 6, Rarity.UNCOMMON, mage.cards.s.StoneHavenPilgrim.class));
        cards.add(new SetCardInfo("Storm Sculptor", 179, Rarity.COMMON, mage.cards.s.StormSculptor.class));
        cards.add(new SetCardInfo("Supply Runners", 7, Rarity.UNCOMMON, mage.cards.s.SupplyRunners.class));
        cards.add(new SetCardInfo("Suspicious Bookcase", 487, Rarity.UNCOMMON, mage.cards.s.SuspiciousBookcase.class));
        cards.add(new SetCardInfo("Swamp", 54, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 55, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 56, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 57, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 58, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 59, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 60, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 61, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swarm of Bloodflies", 282, Rarity.UNCOMMON, mage.cards.s.SwarmOfBloodflies.class));
        cards.add(new SetCardInfo("Sweep Away", 180, Rarity.COMMON, mage.cards.s.SweepAway.class));
        cards.add(new SetCardInfo("Sylvan Brushstrider", 434, Rarity.COMMON, mage.cards.s.SylvanBrushstrider.class));
        cards.add(new SetCardInfo("Sylvan Ranger", 435, Rarity.COMMON, mage.cards.s.SylvanRanger.class));
        cards.add(new SetCardInfo("Take Heart", 134, Rarity.COMMON, mage.cards.t.TakeHeart.class));
        cards.add(new SetCardInfo("Talrand's Invocation", 182, Rarity.UNCOMMON, mage.cards.t.TalrandsInvocation.class));
        cards.add(new SetCardInfo("Talrand, Sky Summoner", 181, Rarity.RARE, mage.cards.t.TalrandSkySummoner.class));
        cards.add(new SetCardInfo("Tandem Tactics", 135, Rarity.COMMON, mage.cards.t.TandemTactics.class));
        cards.add(new SetCardInfo("Tempting Witch", 283, Rarity.UNCOMMON, mage.cards.t.TemptingWitch.class));
        cards.add(new SetCardInfo("Terramorphic Expanse", 78, Rarity.COMMON, mage.cards.t.TerramorphicExpanse.class));
        cards.add(new SetCardInfo("Terrarion", 488, Rarity.COMMON, mage.cards.t.Terrarion.class));
        cards.add(new SetCardInfo("Thermo-Alchemist", 365, Rarity.COMMON, mage.cards.t.ThermoAlchemist.class));
        cards.add(new SetCardInfo("Thirst for Knowledge", 183, Rarity.UNCOMMON, mage.cards.t.ThirstForKnowledge.class));
        cards.add(new SetCardInfo("Thought Collapse", 184, Rarity.COMMON, mage.cards.t.ThoughtCollapse.class));
        cards.add(new SetCardInfo("Thought Scour", 185, Rarity.COMMON, mage.cards.t.ThoughtScour.class));
        cards.add(new SetCardInfo("Thragtusk", 436, Rarity.RARE, mage.cards.t.Thragtusk.class));
        cards.add(new SetCardInfo("Thriving Bluff", 33, Rarity.COMMON, mage.cards.t.ThrivingBluff.class));
        cards.add(new SetCardInfo("Thriving Grove", 34, Rarity.COMMON, mage.cards.t.ThrivingGrove.class));
        cards.add(new SetCardInfo("Thriving Heath", 35, Rarity.COMMON, mage.cards.t.ThrivingHeath.class));
        cards.add(new SetCardInfo("Thriving Isle", 36, Rarity.COMMON, mage.cards.t.ThrivingIsle.class));
        cards.add(new SetCardInfo("Thriving Moor", 37, Rarity.COMMON, mage.cards.t.ThrivingMoor.class));
        cards.add(new SetCardInfo("Thundering Spineback", 437, Rarity.UNCOMMON, mage.cards.t.ThunderingSpineback.class));
        cards.add(new SetCardInfo("Tibalt's Rager", 366, Rarity.UNCOMMON, mage.cards.t.TibaltsRager.class));
        cards.add(new SetCardInfo("Time to Feed", 438, Rarity.COMMON, mage.cards.t.TimeToFeed.class));
        cards.add(new SetCardInfo("Tinybones, Trinket Thief", 17, Rarity.MYTHIC, mage.cards.t.TinybonesTrinketThief.class));
        cards.add(new SetCardInfo("Tithebearer Giant", 284, Rarity.COMMON, mage.cards.t.TithebearerGiant.class));
        cards.add(new SetCardInfo("Torch Fiend", 367, Rarity.COMMON, mage.cards.t.TorchFiend.class));
        cards.add(new SetCardInfo("Towering Titan", 31, Rarity.MYTHIC, mage.cards.t.ToweringTitan.class));
        cards.add(new SetCardInfo("Towering-Wave Mystic", 186, Rarity.COMMON, mage.cards.t.ToweringWaveMystic.class));
        cards.add(new SetCardInfo("Trusty Retriever", 8, Rarity.COMMON, mage.cards.t.TrustyRetriever.class));
        cards.add(new SetCardInfo("Ulvenwald Hydra", 439, Rarity.MYTHIC, mage.cards.u.UlvenwaldHydra.class));
        cards.add(new SetCardInfo("Unstable Obelisk", 489, Rarity.UNCOMMON, mage.cards.u.UnstableObelisk.class));
        cards.add(new SetCardInfo("Valorous Stance", 136, Rarity.UNCOMMON, mage.cards.v.ValorousStance.class));
        cards.add(new SetCardInfo("Vampire Neonate", 285, Rarity.COMMON, mage.cards.v.VampireNeonate.class));
        cards.add(new SetCardInfo("Vastwood Zendikon", 440, Rarity.COMMON, mage.cards.v.VastwoodZendikon.class));
        cards.add(new SetCardInfo("Vedalken Archmage", 187, Rarity.RARE, mage.cards.v.VedalkenArchmage.class));
        cards.add(new SetCardInfo("Vedalken Entrancer", 188, Rarity.COMMON, mage.cards.v.VedalkenEntrancer.class));
        cards.add(new SetCardInfo("Verdant Embrace", 441, Rarity.RARE, mage.cards.v.VerdantEmbrace.class));
        cards.add(new SetCardInfo("Voice of the Provinces", 137, Rarity.COMMON, mage.cards.v.VoiceOfTheProvinces.class));
        cards.add(new SetCardInfo("Volcanic Fallout", 368, Rarity.UNCOMMON, mage.cards.v.VolcanicFallout.class));
        cards.add(new SetCardInfo("Volley Veteran", 369, Rarity.UNCOMMON, mage.cards.v.VolleyVeteran.class));
        cards.add(new SetCardInfo("Voyage's End", 189, Rarity.COMMON, mage.cards.v.VoyagesEnd.class));
        cards.add(new SetCardInfo("Wailing Ghoul", 286, Rarity.COMMON, mage.cards.w.WailingGhoul.class));
        cards.add(new SetCardInfo("Wall of Blossoms", 442, Rarity.UNCOMMON, mage.cards.w.WallOfBlossoms.class));
        cards.add(new SetCardInfo("Wall of Lost Thoughts", 190, Rarity.UNCOMMON, mage.cards.w.WallOfLostThoughts.class));
        cards.add(new SetCardInfo("Wall of Vines", 443, Rarity.COMMON, mage.cards.w.WallOfVines.class));
        cards.add(new SetCardInfo("Warden of Evos Isle", 191, Rarity.UNCOMMON, mage.cards.w.WardenOfEvosIsle.class));
        cards.add(new SetCardInfo("Warfire Javelineer", 370, Rarity.UNCOMMON, mage.cards.w.WarfireJavelineer.class));
        cards.add(new SetCardInfo("Warmonger's Chariot", 490, Rarity.UNCOMMON, mage.cards.w.WarmongersChariot.class));
        cards.add(new SetCardInfo("Waterknot", 192, Rarity.COMMON, mage.cards.w.Waterknot.class));
        cards.add(new SetCardInfo("Weaver of Lightning", 371, Rarity.UNCOMMON, mage.cards.w.WeaverOfLightning.class));
        cards.add(new SetCardInfo("Whelming Wave", 193, Rarity.RARE, mage.cards.w.WhelmingWave.class));
        cards.add(new SetCardInfo("Wight of Precinct Six", 287, Rarity.COMMON, mage.cards.w.WightOfPrecinctSix.class));
        cards.add(new SetCardInfo("Wildheart Invoker", 444, Rarity.COMMON, mage.cards.w.WildheartInvoker.class));
        cards.add(new SetCardInfo("Wildsize", 445, Rarity.COMMON, mage.cards.w.Wildsize.class));
        cards.add(new SetCardInfo("Windreader Sphinx", 194, Rarity.RARE, mage.cards.w.WindreaderSphinx.class));
        cards.add(new SetCardInfo("Windstorm Drake", 195, Rarity.UNCOMMON, mage.cards.w.WindstormDrake.class));
        cards.add(new SetCardInfo("Winged Words", 196, Rarity.COMMON, mage.cards.w.WingedWords.class));
        cards.add(new SetCardInfo("Wishful Merfolk", 197, Rarity.COMMON, mage.cards.w.WishfulMerfolk.class));
        cards.add(new SetCardInfo("Witch of the Moors", 18, Rarity.RARE, mage.cards.w.WitchOfTheMoors.class));
        cards.add(new SetCardInfo("Wizard's Retort", 198, Rarity.UNCOMMON, mage.cards.w.WizardsRetort.class));
        cards.add(new SetCardInfo("Woodborn Behemoth", 446, Rarity.UNCOMMON, mage.cards.w.WoodbornBehemoth.class));
        cards.add(new SetCardInfo("Wren's Run Vanquisher", 447, Rarity.UNCOMMON, mage.cards.w.WrensRunVanquisher.class));
        cards.add(new SetCardInfo("Young Pyromancer", 372, Rarity.UNCOMMON, mage.cards.y.YoungPyromancer.class));
        cards.add(new SetCardInfo("Zendikar's Roil", 448, Rarity.UNCOMMON, mage.cards.z.ZendikarsRoil.class));
        cards.add(new SetCardInfo("Zombie Infestation", 288, Rarity.UNCOMMON, mage.cards.z.ZombieInfestation.class));
        cards.add(new SetCardInfo("Zurzoth, Chaos Rider", 27, Rarity.RARE, mage.cards.z.ZurzothChaosRider.class));
    }
}
