package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class FoundationsJumpstart extends ExpansionSet {

    private static final FoundationsJumpstart instance = new FoundationsJumpstart();

    public static FoundationsJumpstart getInstance() {
        return instance;
    }

    private FoundationsJumpstart() {
        super("Foundations Jumpstart", "J25", ExpansionSet.buildDate(2024, 11, 15), SetType.EXPANSION);
        this.blockName = "Foundations"; // for sorting in GUI
        this.hasBasicLands = true;
        this.hasBoosters = false; // temporary

        cards.add(new SetCardInfo("Abandon Reason", 513, Rarity.UNCOMMON, mage.cards.a.AbandonReason.class));
        cards.add(new SetCardInfo("Academy Journeymage", 281, Rarity.COMMON, mage.cards.a.AcademyJourneymage.class));
        cards.add(new SetCardInfo("Adeline, Resplendent Cathar", 57, Rarity.RARE, mage.cards.a.AdelineResplendentCathar.class));
        cards.add(new SetCardInfo("Adventure Awaits", 620, Rarity.COMMON, mage.cards.a.AdventureAwaits.class));
        cards.add(new SetCardInfo("Adventurous Impulse", 621, Rarity.COMMON, mage.cards.a.AdventurousImpulse.class));
        cards.add(new SetCardInfo("Advocate of the Beast", 622, Rarity.COMMON, mage.cards.a.AdvocateOfTheBeast.class));
        cards.add(new SetCardInfo("Aerial Guide", 282, Rarity.COMMON, mage.cards.a.AerialGuide.class));
        cards.add(new SetCardInfo("Aether Channeler", 283, Rarity.RARE, mage.cards.a.AetherChanneler.class));
        cards.add(new SetCardInfo("Aggressive Instinct", 623, Rarity.COMMON, mage.cards.a.AggressiveInstinct.class));
        cards.add(new SetCardInfo("Agonizing Syphon", 396, Rarity.COMMON, mage.cards.a.AgonizingSyphon.class));
        cards.add(new SetCardInfo("Ahn-Crop Crasher", 514, Rarity.UNCOMMON, mage.cards.a.AhnCropCrasher.class));
        cards.add(new SetCardInfo("Ainok Artillerist", 624, Rarity.COMMON, mage.cards.a.AinokArtillerist.class));
        cards.add(new SetCardInfo("Ainok Guide", 625, Rarity.COMMON, mage.cards.a.AinokGuide.class));
        cards.add(new SetCardInfo("Air Elemental", 284, Rarity.UNCOMMON, mage.cards.a.AirElemental.class));
        cards.add(new SetCardInfo("Ajani's Pridemate", 158, Rarity.UNCOMMON, mage.cards.a.AjanisPridemate.class));
        cards.add(new SetCardInfo("Ajani, Adversary of Tyrants", 157, Rarity.MYTHIC, mage.cards.a.AjaniAdversaryOfTyrants.class));
        cards.add(new SetCardInfo("Akroan Crusader", 515, Rarity.COMMON, mage.cards.a.AkroanCrusader.class));
        cards.add(new SetCardInfo("Akroan Skyguard", 159, Rarity.COMMON, mage.cards.a.AkroanSkyguard.class));
        cards.add(new SetCardInfo("Alchemist's Gift", 397, Rarity.COMMON, mage.cards.a.AlchemistsGift.class));
        cards.add(new SetCardInfo("Ambassador Oak", 626, Rarity.COMMON, mage.cards.a.AmbassadorOak.class));
        cards.add(new SetCardInfo("Ancestral Anger", 516, Rarity.COMMON, mage.cards.a.AncestralAnger.class));
        cards.add(new SetCardInfo("Ancestral Blade", 160, Rarity.COMMON, mage.cards.a.AncestralBlade.class));
        cards.add(new SetCardInfo("Ancient Greenwarden", 627, Rarity.MYTHIC, mage.cards.a.AncientGreenwarden.class));
        cards.add(new SetCardInfo("Anep, Vizier of Hazoret", 46, Rarity.UNCOMMON, mage.cards.a.AnepVizierOfHazoret.class));
        cards.add(new SetCardInfo("Angel of Mercy", 161, Rarity.COMMON, mage.cards.a.AngelOfMercy.class));
        cards.add(new SetCardInfo("Angel of Vitality", 162, Rarity.UNCOMMON, mage.cards.a.AngelOfVitality.class));
        cards.add(new SetCardInfo("Angelic Cub", 163, Rarity.UNCOMMON, mage.cards.a.AngelicCub.class));
        cards.add(new SetCardInfo("Angelic Edict", 164, Rarity.COMMON, mage.cards.a.AngelicEdict.class));
        cards.add(new SetCardInfo("Angelic Gift", 165, Rarity.COMMON, mage.cards.a.AngelicGift.class));
        cards.add(new SetCardInfo("Anje's Ravager", 517, Rarity.RARE, mage.cards.a.AnjesRavager.class));
        cards.add(new SetCardInfo("Arbor Armament", 628, Rarity.COMMON, mage.cards.a.ArborArmament.class));
        cards.add(new SetCardInfo("Archaeomancer", 285, Rarity.COMMON, mage.cards.a.Archaeomancer.class));
        cards.add(new SetCardInfo("Archfiend's Vessel", 398, Rarity.UNCOMMON, mage.cards.a.ArchfiendsVessel.class));
        cards.add(new SetCardInfo("Archon of Falling Stars", 166, Rarity.UNCOMMON, mage.cards.a.ArchonOfFallingStars.class));
        cards.add(new SetCardInfo("Archon of Sun's Grace", 167, Rarity.RARE, mage.cards.a.ArchonOfSunsGrace.class));
        cards.add(new SetCardInfo("Arena Athlete", 518, Rarity.UNCOMMON, mage.cards.a.ArenaAthlete.class));
        cards.add(new SetCardInfo("Argivian Phalanx", 168, Rarity.COMMON, mage.cards.a.ArgivianPhalanx.class));
        cards.add(new SetCardInfo("Armorcraft Judge", 629, Rarity.UNCOMMON, mage.cards.a.ArmorcraftJudge.class));
        cards.add(new SetCardInfo("Armored Kincaller", 630, Rarity.COMMON, mage.cards.a.ArmoredKincaller.class));
        cards.add(new SetCardInfo("Army of the Damned", 399, Rarity.MYTHIC, mage.cards.a.ArmyOfTheDamned.class));
        cards.add(new SetCardInfo("Arrogant Outlaw", 400, Rarity.COMMON, mage.cards.a.ArrogantOutlaw.class));
        cards.add(new SetCardInfo("Ash Barrens", 154, Rarity.COMMON, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Audacious Thief", 401, Rarity.COMMON, mage.cards.a.AudaciousThief.class));
        cards.add(new SetCardInfo("Audacity", 631, Rarity.UNCOMMON, mage.cards.a.Audacity.class));
        cards.add(new SetCardInfo("Augur of Bolas", 286, Rarity.UNCOMMON, mage.cards.a.AugurOfBolas.class));
        cards.add(new SetCardInfo("Aven Reedstalker", 287, Rarity.COMMON, mage.cards.a.AvenReedstalker.class));
        cards.add(new SetCardInfo("Averna, the Chaos Bloom", 80, Rarity.RARE, mage.cards.a.AvernaTheChaosBloom.class));
        cards.add(new SetCardInfo("Azure Drake", 288, Rarity.UNCOMMON, mage.cards.a.AzureDrake.class));
        cards.add(new SetCardInfo("Baloth Gorger", 632, Rarity.COMMON, mage.cards.b.BalothGorger.class));
        cards.add(new SetCardInfo("Baloth Woodcrasher", 633, Rarity.UNCOMMON, mage.cards.b.BalothWoodcrasher.class));
        cards.add(new SetCardInfo("Balustrade Spy", 402, Rarity.COMMON, mage.cards.b.BalustradeSpy.class));
        cards.add(new SetCardInfo("Band Together", 634, Rarity.COMMON, mage.cards.b.BandTogether.class));
        cards.add(new SetCardInfo("Banisher Priest", 169, Rarity.UNCOMMON, mage.cards.b.BanisherPriest.class));
        cards.add(new SetCardInfo("Banishing Light", 96, Rarity.UNCOMMON, mage.cards.b.BanishingLight.class));
        cards.add(new SetCardInfo("Basri's Acolyte", 170, Rarity.COMMON, mage.cards.b.BasrisAcolyte.class));
        cards.add(new SetCardInfo("Basri's Lieutenant", 171, Rarity.RARE, mage.cards.b.BasrisLieutenant.class));
        cards.add(new SetCardInfo("Basri's Solidarity", 172, Rarity.UNCOMMON, mage.cards.b.BasrisSolidarity.class));
        cards.add(new SetCardInfo("Bastion of Remembrance", 403, Rarity.UNCOMMON, mage.cards.b.BastionOfRemembrance.class));
        cards.add(new SetCardInfo("Bathe in Dragonfire", 519, Rarity.COMMON, mage.cards.b.BatheInDragonfire.class));
        cards.add(new SetCardInfo("Battle Cry Goblin", 127, Rarity.UNCOMMON, mage.cards.b.BattleCryGoblin.class));
        cards.add(new SetCardInfo("Battle-Rattle Shaman", 128, Rarity.COMMON, mage.cards.b.BattleRattleShaman.class));
        cards.add(new SetCardInfo("Battlefield Promotion", 173, Rarity.COMMON, mage.cards.b.BattlefieldPromotion.class));
        cards.add(new SetCardInfo("Battlefield Scavenger", 520, Rarity.UNCOMMON, mage.cards.b.BattlefieldScavenger.class));
        cards.add(new SetCardInfo("Beetleback Chief", 129, Rarity.UNCOMMON, mage.cards.b.BeetlebackChief.class));
        cards.add(new SetCardInfo("Belligerent Guest", 521, Rarity.COMMON, mage.cards.b.BelligerentGuest.class));
        cards.add(new SetCardInfo("Big Play", 635, Rarity.COMMON, mage.cards.b.BigPlay.class));
        cards.add(new SetCardInfo("Biogenic Upgrade", 144, Rarity.UNCOMMON, mage.cards.b.BiogenicUpgrade.class));
        cards.add(new SetCardInfo("Bishop's Soldier", 174, Rarity.COMMON, mage.cards.b.BishopsSoldier.class));
        cards.add(new SetCardInfo("Bite Down", 636, Rarity.COMMON, mage.cards.b.BiteDown.class));
        cards.add(new SetCardInfo("Bituminous Blast", 742, Rarity.UNCOMMON, mage.cards.b.BituminousBlast.class));
        cards.add(new SetCardInfo("Bleed Dry", 404, Rarity.COMMON, mage.cards.b.BleedDry.class));
        cards.add(new SetCardInfo("Blink of an Eye", 289, Rarity.COMMON, mage.cards.b.BlinkOfAnEye.class));
        cards.add(new SetCardInfo("Blood Beckoning", 405, Rarity.COMMON, mage.cards.b.BloodBeckoning.class));
        cards.add(new SetCardInfo("Blood Burglar", 406, Rarity.COMMON, mage.cards.b.BloodBurglar.class));
        cards.add(new SetCardInfo("Blood Feud", 130, Rarity.UNCOMMON, mage.cards.b.BloodFeud.class));
        cards.add(new SetCardInfo("Blood Fountain", 407, Rarity.COMMON, mage.cards.b.BloodFountain.class));
        cards.add(new SetCardInfo("Blood Hypnotist", 522, Rarity.UNCOMMON, mage.cards.b.BloodHypnotist.class));
        cards.add(new SetCardInfo("Blood Petal Celebrant", 523, Rarity.COMMON, mage.cards.b.BloodPetalCelebrant.class));
        cards.add(new SetCardInfo("Bloodbraid Elf", 743, Rarity.UNCOMMON, mage.cards.b.BloodbraidElf.class));
        cards.add(new SetCardInfo("Bloodfire Expert", 524, Rarity.COMMON, mage.cards.b.BloodfireExpert.class));
        cards.add(new SetCardInfo("Bloodgift Demon", 408, Rarity.RARE, mage.cards.b.BloodgiftDemon.class));
        cards.add(new SetCardInfo("Bloodlust Inciter", 525, Rarity.COMMON, mage.cards.b.BloodlustInciter.class));
        cards.add(new SetCardInfo("Bloodthirsty Aerialist", 409, Rarity.UNCOMMON, mage.cards.b.BloodthirstyAerialist.class));
        cards.add(new SetCardInfo("Bloodtithe Collector", 410, Rarity.UNCOMMON, mage.cards.b.BloodtitheCollector.class));
        cards.add(new SetCardInfo("Boggart Brute", 526, Rarity.COMMON, mage.cards.b.BoggartBrute.class));
        cards.add(new SetCardInfo("Boldwyr Intimidator", 527, Rarity.UNCOMMON, mage.cards.b.BoldwyrIntimidator.class));
        cards.add(new SetCardInfo("Bond of Flourishing", 637, Rarity.UNCOMMON, mage.cards.b.BondOfFlourishing.class));
        cards.add(new SetCardInfo("Bonecaller Cleric", 112, Rarity.UNCOMMON, mage.cards.b.BonecallerCleric.class));
        cards.add(new SetCardInfo("Boneclad Necromancer", 411, Rarity.COMMON, mage.cards.b.BonecladNecromancer.class));
        cards.add(new SetCardInfo("Bounty of Skemfar", 638, Rarity.UNCOMMON, mage.cards.b.BountyOfSkemfar.class));
        cards.add(new SetCardInfo("Braulios of Pheres Band", 51, Rarity.UNCOMMON, mage.cards.b.BrauliosOfPheresBand.class));
        cards.add(new SetCardInfo("Breaching Hippocamp", 290, Rarity.COMMON, mage.cards.b.BreachingHippocamp.class));
        cards.add(new SetCardInfo("Briarbridge Tracker", 639, Rarity.RARE, mage.cards.b.BriarbridgeTracker.class));
        cards.add(new SetCardInfo("Brightmare", 175, Rarity.UNCOMMON, mage.cards.b.Brightmare.class));
        cards.add(new SetCardInfo("Brigone, Soldier of Meletis", 30, Rarity.RARE, mage.cards.b.BrigoneSoldierOfMeletis.class));
        cards.add(new SetCardInfo("Brimaz, King of Oreskos", 58, Rarity.MYTHIC, mage.cards.b.BrimazKingOfOreskos.class));
        cards.add(new SetCardInfo("Brineborn Cutthroat", 291, Rarity.UNCOMMON, mage.cards.b.BrinebornCutthroat.class));
        cards.add(new SetCardInfo("Brothers Yamazaki", 72, Rarity.UNCOMMON, mage.cards.b.BrothersYamazaki.class));
        cards.add(new SetCardInfo("Brushstrider", 640, Rarity.UNCOMMON, mage.cards.b.Brushstrider.class));
        cards.add(new SetCardInfo("Brute Strength", 528, Rarity.COMMON, mage.cards.b.BruteStrength.class));
        cards.add(new SetCardInfo("Bury in Books", 292, Rarity.COMMON, mage.cards.b.BuryInBooks.class));
        cards.add(new SetCardInfo("Bushwhack", 641, Rarity.UNCOMMON, mage.cards.b.Bushwhack.class));
        cards.add(new SetCardInfo("Byway Courier", 642, Rarity.COMMON, mage.cards.b.BywayCourier.class));
        cards.add(new SetCardInfo("Cackling Counterpart", 293, Rarity.RARE, mage.cards.c.CacklingCounterpart.class));
        cards.add(new SetCardInfo("Cage of Hands", 176, Rarity.COMMON, mage.cards.c.CageOfHands.class));
        cards.add(new SetCardInfo("Canopy Baloth", 643, Rarity.COMMON, mage.cards.c.CanopyBaloth.class));
        cards.add(new SetCardInfo("Captivating Unicorn", 177, Rarity.COMMON, mage.cards.c.CaptivatingUnicorn.class));
        cards.add(new SetCardInfo("Capture Sphere", 294, Rarity.COMMON, mage.cards.c.CaptureSphere.class));
        cards.add(new SetCardInfo("Carnelian Orb of Dragonkind", 131, Rarity.COMMON, mage.cards.c.CarnelianOrbOfDragonkind.class));
        cards.add(new SetCardInfo("Cartouche of Knowledge", 295, Rarity.COMMON, mage.cards.c.CartoucheOfKnowledge.class));
        cards.add(new SetCardInfo("Cartouche of Solidarity", 178, Rarity.COMMON, mage.cards.c.CartoucheOfSolidarity.class));
        cards.add(new SetCardInfo("Cartouche of Zeal", 529, Rarity.COMMON, mage.cards.c.CartoucheOfZeal.class));
        cards.add(new SetCardInfo("Cavalier of Gales", 296, Rarity.MYTHIC, mage.cards.c.CavalierOfGales.class));
        cards.add(new SetCardInfo("Cave of Temptation", 763, Rarity.COMMON, mage.cards.c.CaveOfTemptation.class));
        cards.add(new SetCardInfo("Celestial Enforcer", 179, Rarity.COMMON, mage.cards.c.CelestialEnforcer.class));
        cards.add(new SetCardInfo("Celestial Unicorn", 97, Rarity.COMMON, mage.cards.c.CelestialUnicorn.class));
        cards.add(new SetCardInfo("Chains of Custody", 180, Rarity.COMMON, mage.cards.c.ChainsOfCustody.class));
        cards.add(new SetCardInfo("Chandra's Spitfire", 530, Rarity.UNCOMMON, mage.cards.c.ChandrasSpitfire.class));
        cards.add(new SetCardInfo("Charmbreaker Devils", 132, Rarity.RARE, mage.cards.c.CharmbreakerDevils.class));
        cards.add(new SetCardInfo("Cherished Hatchling", 644, Rarity.UNCOMMON, mage.cards.c.CherishedHatchling.class));
        cards.add(new SetCardInfo("Chief of the Foundry", 747, Rarity.UNCOMMON, mage.cards.c.ChiefOfTheFoundry.class));
        cards.add(new SetCardInfo("Chilling Trap", 297, Rarity.COMMON, mage.cards.c.ChillingTrap.class));
        cards.add(new SetCardInfo("Choking Tethers", 298, Rarity.COMMON, mage.cards.c.ChokingTethers.class));
        cards.add(new SetCardInfo("Chosen by Heliod", 181, Rarity.COMMON, mage.cards.c.ChosenByHeliod.class));
        cards.add(new SetCardInfo("Chromatic Lantern", 151, Rarity.RARE, mage.cards.c.ChromaticLantern.class));
        cards.add(new SetCardInfo("Chrome Prowler", 299, Rarity.COMMON, mage.cards.c.ChromeProwler.class));
        cards.add(new SetCardInfo("Clear Shot", 645, Rarity.UNCOMMON, mage.cards.c.ClearShot.class));
        cards.add(new SetCardInfo("Cleon, Merry Champion", 47, Rarity.UNCOMMON, mage.cards.c.CleonMerryChampion.class));
        cards.add(new SetCardInfo("Cliffhaven Kitesail", 748, Rarity.COMMON, mage.cards.c.CliffhavenKitesail.class));
        cards.add(new SetCardInfo("Cloudkin Seer", 300, Rarity.COMMON, mage.cards.c.CloudkinSeer.class));
        cards.add(new SetCardInfo("Coat with Venom", 412, Rarity.COMMON, mage.cards.c.CoatWithVenom.class));
        cards.add(new SetCardInfo("Colossal Dreadmaw", 646, Rarity.COMMON, mage.cards.c.ColossalDreadmaw.class));
        cards.add(new SetCardInfo("Combat Celebrant", 531, Rarity.MYTHIC, mage.cards.c.CombatCelebrant.class));
        cards.add(new SetCardInfo("Commune with Dinosaurs", 647, Rarity.COMMON, mage.cards.c.CommuneWithDinosaurs.class));
        cards.add(new SetCardInfo("Concentrate", 301, Rarity.UNCOMMON, mage.cards.c.Concentrate.class));
        cards.add(new SetCardInfo("Conclave Tribunal", 182, Rarity.UNCOMMON, mage.cards.c.ConclaveTribunal.class));
        cards.add(new SetCardInfo("Contract Killing", 413, Rarity.COMMON, mage.cards.c.ContractKilling.class));
        cards.add(new SetCardInfo("Coordinated Assault", 532, Rarity.UNCOMMON, mage.cards.c.CoordinatedAssault.class));
        cards.add(new SetCardInfo("Crawl from the Cellar", 414, Rarity.COMMON, mage.cards.c.CrawlFromTheCellar.class));
        cards.add(new SetCardInfo("Creeping Bloodsucker", 415, Rarity.COMMON, mage.cards.c.CreepingBloodsucker.class));
        cards.add(new SetCardInfo("Crimson Wisps", 533, Rarity.COMMON, mage.cards.c.CrimsonWisps.class));
        cards.add(new SetCardInfo("Crooked Custodian", 416, Rarity.COMMON, mage.cards.c.CrookedCustodian.class));
        cards.add(new SetCardInfo("Crossway Troublemakers", 417, Rarity.RARE, mage.cards.c.CrosswayTroublemakers.class));
        cards.add(new SetCardInfo("Cruel Witness", 302, Rarity.COMMON, mage.cards.c.CruelWitness.class));
        cards.add(new SetCardInfo("Crystacean", 303, Rarity.COMMON, mage.cards.c.Crystacean.class));
        cards.add(new SetCardInfo("Cyclops Electromancer", 534, Rarity.COMMON, mage.cards.c.CyclopsElectromancer.class));
        cards.add(new SetCardInfo("Cynette, Jelly Drover", 35, Rarity.UNCOMMON, mage.cards.c.CynetteJellyDrover.class));
        cards.add(new SetCardInfo("Danitha Capashen, Paragon", 59, Rarity.UNCOMMON, mage.cards.d.DanithaCapashenParagon.class));
        cards.add(new SetCardInfo("Dark Bargain", 113, Rarity.COMMON, mage.cards.d.DarkBargain.class));
        cards.add(new SetCardInfo("Dark Confidant", 114, Rarity.MYTHIC, mage.cards.d.DarkConfidant.class));
        cards.add(new SetCardInfo("Dark Supplicant", 418, Rarity.UNCOMMON, mage.cards.d.DarkSupplicant.class));
        cards.add(new SetCardInfo("Dauntless Onslaught", 98, Rarity.UNCOMMON, mage.cards.d.DauntlessOnslaught.class));
        cards.add(new SetCardInfo("Dauntless Unity", 183, Rarity.COMMON, mage.cards.d.DauntlessUnity.class));
        cards.add(new SetCardInfo("Dawnwing Marshal", 1, Rarity.UNCOMMON, mage.cards.d.DawnwingMarshal.class));
        cards.add(new SetCardInfo("Daybreak Chaplain", 184, Rarity.COMMON, mage.cards.d.DaybreakChaplain.class));
        cards.add(new SetCardInfo("Daybreak Combatants", 535, Rarity.COMMON, mage.cards.d.DaybreakCombatants.class));
        cards.add(new SetCardInfo("Deadly Dispute", 115, Rarity.COMMON, mage.cards.d.DeadlyDispute.class));
        cards.add(new SetCardInfo("Deadly Riposte", 185, Rarity.COMMON, mage.cards.d.DeadlyRiposte.class));
        cards.add(new SetCardInfo("Deal Gone Bad", 419, Rarity.COMMON, mage.cards.d.DealGoneBad.class));
        cards.add(new SetCardInfo("Deep Analysis", 304, Rarity.COMMON, mage.cards.d.DeepAnalysis.class));
        cards.add(new SetCardInfo("Deepwood Denizen", 648, Rarity.COMMON, mage.cards.d.DeepwoodDenizen.class));
        cards.add(new SetCardInfo("Defend the Campus", 186, Rarity.COMMON, mage.cards.d.DefendTheCampus.class));
        cards.add(new SetCardInfo("Defend the Celestus", 649, Rarity.UNCOMMON, mage.cards.d.DefendTheCelestus.class));
        cards.add(new SetCardInfo("Defenestrate", 420, Rarity.COMMON, mage.cards.d.Defenestrate.class));
        cards.add(new SetCardInfo("Defiant Strike", 187, Rarity.COMMON, mage.cards.d.DefiantStrike.class));
        cards.add(new SetCardInfo("Delightful Discovery", 6, Rarity.UNCOMMON, mage.cards.d.DelightfulDiscovery.class));
        cards.add(new SetCardInfo("Desert of the Fervent", 764, Rarity.COMMON, mage.cards.d.DesertOfTheFervent.class));
        cards.add(new SetCardInfo("Desperate Lunge", 188, Rarity.COMMON, mage.cards.d.DesperateLunge.class));
        cards.add(new SetCardInfo("Destroy Evil", 189, Rarity.COMMON, mage.cards.d.DestroyEvil.class));
        cards.add(new SetCardInfo("Destructive Digger", 133, Rarity.COMMON, mage.cards.d.DestructiveDigger.class));
        cards.add(new SetCardInfo("Devouring Swarm", 421, Rarity.COMMON, mage.cards.d.DevouringSwarm.class));
        cards.add(new SetCardInfo("Dionus, Elvish Archdruid", 52, Rarity.UNCOMMON, mage.cards.d.DionusElvishArchdruid.class));
        cards.add(new SetCardInfo("Dire Fleet Hoarder", 422, Rarity.COMMON, mage.cards.d.DireFleetHoarder.class));
        cards.add(new SetCardInfo("Diregraf Scavenger", 423, Rarity.COMMON, mage.cards.d.DiregrafScavenger.class));
        cards.add(new SetCardInfo("Disfigure", 424, Rarity.COMMON, mage.cards.d.Disfigure.class));
        cards.add(new SetCardInfo("Divine Arrow", 190, Rarity.COMMON, mage.cards.d.DivineArrow.class));
        cards.add(new SetCardInfo("Divine Favor", 191, Rarity.COMMON, mage.cards.d.DivineFavor.class));
        cards.add(new SetCardInfo("Doomed Dissenter", 425, Rarity.COMMON, mage.cards.d.DoomedDissenter.class));
        cards.add(new SetCardInfo("Doomed Necromancer", 426, Rarity.RARE, mage.cards.d.DoomedNecromancer.class));
        cards.add(new SetCardInfo("Drag Under", 105, Rarity.COMMON, mage.cards.d.DragUnder.class));
        cards.add(new SetCardInfo("Dragon Hatchling", 536, Rarity.COMMON, mage.cards.d.DragonHatchling.class));
        cards.add(new SetCardInfo("Dragon Whelp", 537, Rarity.UNCOMMON, mage.cards.d.DragonWhelp.class));
        cards.add(new SetCardInfo("Dragon's Fire", 134, Rarity.COMMON, mage.cards.d.DragonsFire.class));
        cards.add(new SetCardInfo("Dragonlord's Servant", 538, Rarity.UNCOMMON, mage.cards.d.DragonlordsServant.class));
        cards.add(new SetCardInfo("Draugr Thought-Thief", 305, Rarity.COMMON, mage.cards.d.DraugrThoughtThief.class));
        cards.add(new SetCardInfo("Dreadful Apathy", 192, Rarity.COMMON, mage.cards.d.DreadfulApathy.class));
        cards.add(new SetCardInfo("Dreadhorde Arcanist", 539, Rarity.RARE, mage.cards.d.DreadhordeArcanist.class));
        cards.add(new SetCardInfo("Dreadhound", 427, Rarity.UNCOMMON, mage.cards.d.Dreadhound.class));
        cards.add(new SetCardInfo("Dropkick Bomber", 13, Rarity.RARE, mage.cards.d.DropkickBomber.class));
        cards.add(new SetCardInfo("Dross Hopper", 428, Rarity.COMMON, mage.cards.d.DrossHopper.class));
        cards.add(new SetCardInfo("Drover of the Mighty", 650, Rarity.UNCOMMON, mage.cards.d.DroverOfTheMighty.class));
        cards.add(new SetCardInfo("Drowsing Tyrannodon", 651, Rarity.COMMON, mage.cards.d.DrowsingTyrannodon.class));
        cards.add(new SetCardInfo("Druid of the Anima", 652, Rarity.COMMON, mage.cards.d.DruidOfTheAnima.class));
        cards.add(new SetCardInfo("Durable Coilbug", 429, Rarity.COMMON, mage.cards.d.DurableCoilbug.class));
        cards.add(new SetCardInfo("Dusk Mangler", 430, Rarity.UNCOMMON, mage.cards.d.DuskMangler.class));
        cards.add(new SetCardInfo("Duskshell Crawler", 653, Rarity.COMMON, mage.cards.d.DuskshellCrawler.class));
        cards.add(new SetCardInfo("Dwynen's Elite", 654, Rarity.UNCOMMON, mage.cards.d.DwynensElite.class));
        cards.add(new SetCardInfo("Eager Construct", 749, Rarity.COMMON, mage.cards.e.EagerConstruct.class));
        cards.add(new SetCardInfo("Eaten Alive", 116, Rarity.COMMON, mage.cards.e.EatenAlive.class));
        cards.add(new SetCardInfo("Eerie Soultender", 431, Rarity.COMMON, mage.cards.e.EerieSoultender.class));
        cards.add(new SetCardInfo("Eidolon of Astral Winds", 2, Rarity.RARE, mage.cards.e.EidolonOfAstralWinds.class));
        cards.add(new SetCardInfo("Elderfang Disciple", 432, Rarity.COMMON, mage.cards.e.ElderfangDisciple.class));
        cards.add(new SetCardInfo("Elite Skirmisher", 193, Rarity.COMMON, mage.cards.e.EliteSkirmisher.class));
        cards.add(new SetCardInfo("Elvish Archdruid", 655, Rarity.RARE, mage.cards.e.ElvishArchdruid.class));
        cards.add(new SetCardInfo("Elvish Visionary", 145, Rarity.COMMON, mage.cards.e.ElvishVisionary.class));
        cards.add(new SetCardInfo("Emberhorn Minotaur", 540, Rarity.COMMON, mage.cards.e.EmberhornMinotaur.class));
        cards.add(new SetCardInfo("Endless Cockroaches", 433, Rarity.RARE, mage.cards.e.EndlessCockroaches.class));
        cards.add(new SetCardInfo("Enlisted Wurm", 744, Rarity.UNCOMMON, mage.cards.e.EnlistedWurm.class));
        cards.add(new SetCardInfo("Entomber Exarch", 434, Rarity.UNCOMMON, mage.cards.e.EntomberExarch.class));
        cards.add(new SetCardInfo("Epicure of Blood", 435, Rarity.COMMON, mage.cards.e.EpicureOfBlood.class));
        cards.add(new SetCardInfo("Eternal Taskmaster", 117, Rarity.UNCOMMON, mage.cards.e.EternalTaskmaster.class));
        cards.add(new SetCardInfo("Evolving Wilds", 765, Rarity.COMMON, mage.cards.e.EvolvingWilds.class));
        cards.add(new SetCardInfo("Exclusion Mage", 306, Rarity.UNCOMMON, mage.cards.e.ExclusionMage.class));
        cards.add(new SetCardInfo("Expedition Champion", 541, Rarity.COMMON, mage.cards.e.ExpeditionChampion.class));
        cards.add(new SetCardInfo("Expedition Diviner", 307, Rarity.COMMON, mage.cards.e.ExpeditionDiviner.class));
        cards.add(new SetCardInfo("Expedition Raptor", 194, Rarity.COMMON, mage.cards.e.ExpeditionRaptor.class));
        cards.add(new SetCardInfo("Expedition Skulker", 436, Rarity.COMMON, mage.cards.e.ExpeditionSkulker.class));
        cards.add(new SetCardInfo("Expendable Lackey", 308, Rarity.COMMON, mage.cards.e.ExpendableLackey.class));
        cards.add(new SetCardInfo("Experimental Aviator", 309, Rarity.UNCOMMON, mage.cards.e.ExperimentalAviator.class));
        cards.add(new SetCardInfo("Explore", 146, Rarity.COMMON, mage.cards.e.Explore.class));
        cards.add(new SetCardInfo("Exsanguinate", 437, Rarity.UNCOMMON, mage.cards.e.Exsanguinate.class));
        cards.add(new SetCardInfo("Extinguish the Light", 438, Rarity.COMMON, mage.cards.e.ExtinguishTheLight.class));
        cards.add(new SetCardInfo("Eye Collector", 439, Rarity.COMMON, mage.cards.e.EyeCollector.class));
        cards.add(new SetCardInfo("Fading Hope", 310, Rarity.UNCOMMON, mage.cards.f.FadingHope.class));
        cards.add(new SetCardInfo("Faerie Seer", 106, Rarity.COMMON, mage.cards.f.FaerieSeer.class));
        cards.add(new SetCardInfo("Faerie Vandal", 311, Rarity.UNCOMMON, mage.cards.f.FaerieVandal.class));
        cards.add(new SetCardInfo("Faith's Fetters", 195, Rarity.COMMON, mage.cards.f.FaithsFetters.class));
        cards.add(new SetCardInfo("Faithful Pikemaster", 3, Rarity.COMMON, mage.cards.f.FaithfulPikemaster.class));
        cards.add(new SetCardInfo("Fake Your Own Death", 440, Rarity.COMMON, mage.cards.f.FakeYourOwnDeath.class));
        cards.add(new SetCardInfo("Falkenrath Celebrants", 542, Rarity.COMMON, mage.cards.f.FalkenrathCelebrants.class));
        cards.add(new SetCardInfo("Falkenrath Marauders", 543, Rarity.RARE, mage.cards.f.FalkenrathMarauders.class));
        cards.add(new SetCardInfo("Falkenrath Noble", 441, Rarity.UNCOMMON, mage.cards.f.FalkenrathNoble.class));
        cards.add(new SetCardInfo("Fanatical Firebrand", 544, Rarity.COMMON, mage.cards.f.FanaticalFirebrand.class));
        cards.add(new SetCardInfo("Fathom Fleet Firebrand", 135, Rarity.COMMON, mage.cards.f.FathomFleetFirebrand.class));
        cards.add(new SetCardInfo("Favored Hoplite", 196, Rarity.UNCOMMON, mage.cards.f.FavoredHoplite.class));
        cards.add(new SetCardInfo("Favored of Iroas", 197, Rarity.UNCOMMON, mage.cards.f.FavoredOfIroas.class));
        cards.add(new SetCardInfo("Felidar Sovereign", 198, Rarity.MYTHIC, mage.cards.f.FelidarSovereign.class));
        cards.add(new SetCardInfo("Fencing Ace", 199, Rarity.UNCOMMON, mage.cards.f.FencingAce.class));
        cards.add(new SetCardInfo("Fiendish Duo", 545, Rarity.MYTHIC, mage.cards.f.FiendishDuo.class));
        cards.add(new SetCardInfo("Fierce Witchstalker", 656, Rarity.COMMON, mage.cards.f.FierceWitchstalker.class));
        cards.add(new SetCardInfo("Fiery Fall", 546, Rarity.COMMON, mage.cards.f.FieryFall.class));
        cards.add(new SetCardInfo("Filigree Attendant", 312, Rarity.UNCOMMON, mage.cards.f.FiligreeAttendant.class));
        cards.add(new SetCardInfo("Fire Prophecy", 547, Rarity.COMMON, mage.cards.f.FireProphecy.class));
        cards.add(new SetCardInfo("Firebrand Archer", 548, Rarity.COMMON, mage.cards.f.FirebrandArcher.class));
        cards.add(new SetCardInfo("Fireshrieker", 750, Rarity.UNCOMMON, mage.cards.f.Fireshrieker.class));
        cards.add(new SetCardInfo("Firespitter Whelp", 14, Rarity.UNCOMMON, mage.cards.f.FirespitterWhelp.class));
        cards.add(new SetCardInfo("Fissure Wizard", 549, Rarity.COMMON, mage.cards.f.FissureWizard.class));
        cards.add(new SetCardInfo("Fists of Flame", 550, Rarity.COMMON, mage.cards.f.FistsOfFlame.class));
        cards.add(new SetCardInfo("Flame-Blessed Bolt", 551, Rarity.COMMON, mage.cards.f.FlameBlessedBolt.class));
        cards.add(new SetCardInfo("Flames of the Firebrand", 552, Rarity.UNCOMMON, mage.cards.f.FlamesOfTheFirebrand.class));
        cards.add(new SetCardInfo("Fling", 553, Rarity.COMMON, mage.cards.f.Fling.class));
        cards.add(new SetCardInfo("Flutterfox", 200, Rarity.COMMON, mage.cards.f.Flutterfox.class));
        cards.add(new SetCardInfo("For the Family", 657, Rarity.COMMON, mage.cards.f.ForTheFamily.class));
        cards.add(new SetCardInfo("Forest", 93, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forgotten Ancient", 147, Rarity.RARE, mage.cards.f.ForgottenAncient.class));
        cards.add(new SetCardInfo("Forgotten Cave", 766, Rarity.UNCOMMON, mage.cards.f.ForgottenCave.class));
        cards.add(new SetCardInfo("Foul Play", 442, Rarity.UNCOMMON, mage.cards.f.FoulPlay.class));
        cards.add(new SetCardInfo("Fretwork Colony", 443, Rarity.UNCOMMON, mage.cards.f.FretworkColony.class));
        cards.add(new SetCardInfo("Frontline Heroism", 15, Rarity.RARE, mage.cards.f.FrontlineHeroism.class));
        cards.add(new SetCardInfo("Frost Trickster", 313, Rarity.COMMON, mage.cards.f.FrostTrickster.class));
        cards.add(new SetCardInfo("Fumulus, the Infestation", 42, Rarity.RARE, mage.cards.f.FumulusTheInfestation.class));
        cards.add(new SetCardInfo("Fungal Plots", 658, Rarity.UNCOMMON, mage.cards.f.FungalPlots.class));
        cards.add(new SetCardInfo("Furious Reprisal", 554, Rarity.UNCOMMON, mage.cards.f.FuriousReprisal.class));
        cards.add(new SetCardInfo("Fusion Elemental", 745, Rarity.UNCOMMON, mage.cards.f.FusionElemental.class));
        cards.add(new SetCardInfo("Garruk's Packleader", 660, Rarity.UNCOMMON, mage.cards.g.GarruksPackleader.class));
        cards.add(new SetCardInfo("Garruk, Caller of Beasts", 659, Rarity.MYTHIC, mage.cards.g.GarrukCallerOfBeasts.class));
        cards.add(new SetCardInfo("Gavony Silversmith", 201, Rarity.COMMON, mage.cards.g.GavonySilversmith.class));
        cards.add(new SetCardInfo("Gearseeker Serpent", 314, Rarity.COMMON, mage.cards.g.GearseekerSerpent.class));
        cards.add(new SetCardInfo("General Kreat, the Boltbringer", 48, Rarity.UNCOMMON, mage.cards.g.GeneralKreatTheBoltbringer.class));
        cards.add(new SetCardInfo("Generous Pup", 4, Rarity.RARE, mage.cards.g.GenerousPup.class));
        cards.add(new SetCardInfo("Ghalta, Primal Hunger", 77, Rarity.RARE, mage.cards.g.GhaltaPrimalHunger.class));
        cards.add(new SetCardInfo("Ghirapur Guide", 661, Rarity.UNCOMMON, mage.cards.g.GhirapurGuide.class));
        cards.add(new SetCardInfo("Ghitu Encampment", 155, Rarity.UNCOMMON, mage.cards.g.GhituEncampment.class));
        cards.add(new SetCardInfo("Giada, Font of Hope", 60, Rarity.RARE, mage.cards.g.GiadaFontOfHope.class));
        cards.add(new SetCardInfo("Giant Growth", 662, Rarity.COMMON, mage.cards.g.GiantGrowth.class));
        cards.add(new SetCardInfo("Giant Opportunity", 663, Rarity.UNCOMMON, mage.cards.g.GiantOpportunity.class));
        cards.add(new SetCardInfo("Gift of Fangs", 444, Rarity.COMMON, mage.cards.g.GiftOfFangs.class));
        cards.add(new SetCardInfo("Gift of the Gargantuan", 148, Rarity.COMMON, mage.cards.g.GiftOfTheGargantuan.class));
        cards.add(new SetCardInfo("Gilded Scuttler", 7, Rarity.COMMON, mage.cards.g.GildedScuttler.class));
        cards.add(new SetCardInfo("Gingerbrute", 751, Rarity.COMMON, mage.cards.g.Gingerbrute.class));
        cards.add(new SetCardInfo("Gird for Battle", 202, Rarity.UNCOMMON, mage.cards.g.GirdForBattle.class));
        cards.add(new SetCardInfo("Glimmerbell", 315, Rarity.COMMON, mage.cards.g.Glimmerbell.class));
        cards.add(new SetCardInfo("Glory Bearers", 203, Rarity.COMMON, mage.cards.g.GloryBearers.class));
        cards.add(new SetCardInfo("Gluttonous Guest", 445, Rarity.COMMON, mage.cards.g.GluttonousGuest.class));
        cards.add(new SetCardInfo("Gnarlid Colony", 664, Rarity.COMMON, mage.cards.g.GnarlidColony.class));
        cards.add(new SetCardInfo("Gnawing Zombie", 446, Rarity.COMMON, mage.cards.g.GnawingZombie.class));
        cards.add(new SetCardInfo("Go Forth", 20, Rarity.COMMON, mage.cards.g.GoForth.class));
        cards.add(new SetCardInfo("Go for the Throat", 447, Rarity.UNCOMMON, mage.cards.g.GoForTheThroat.class));
        cards.add(new SetCardInfo("Goblin Arsonist", 555, Rarity.COMMON, mage.cards.g.GoblinArsonist.class));
        cards.add(new SetCardInfo("Goblin Dark-Dwellers", 556, Rarity.RARE, mage.cards.g.GoblinDarkDwellers.class));
        cards.add(new SetCardInfo("Goblin Fireslinger", 136, Rarity.COMMON, mage.cards.g.GoblinFireslinger.class));
        cards.add(new SetCardInfo("Goblin Goliath", 557, Rarity.MYTHIC, mage.cards.g.GoblinGoliath.class));
        cards.add(new SetCardInfo("Goblin Rabblemaster", 558, Rarity.RARE, mage.cards.g.GoblinRabblemaster.class));
        cards.add(new SetCardInfo("Goblin Researcher", 559, Rarity.COMMON, mage.cards.g.GoblinResearcher.class));
        cards.add(new SetCardInfo("Goblin Smuggler", 137, Rarity.COMMON, mage.cards.g.GoblinSmuggler.class));
        cards.add(new SetCardInfo("Goblin Surprise", 16, Rarity.UNCOMMON, mage.cards.g.GoblinSurprise.class));
        cards.add(new SetCardInfo("Goblin Trailblazer", 560, Rarity.COMMON, mage.cards.g.GoblinTrailblazer.class));
        cards.add(new SetCardInfo("Godsend", 204, Rarity.MYTHIC, mage.cards.g.Godsend.class));
        cards.add(new SetCardInfo("Golden-Tail Disciple", 205, Rarity.COMMON, mage.cards.g.GoldenTailDisciple.class));
        cards.add(new SetCardInfo("Goma Fada Vanguard", 561, Rarity.UNCOMMON, mage.cards.g.GomaFadaVanguard.class));
        cards.add(new SetCardInfo("Goremand", 448, Rarity.UNCOMMON, mage.cards.g.Goremand.class));
        cards.add(new SetCardInfo("Gorex, the Tombshell", 67, Rarity.RARE, mage.cards.g.GorexTheTombshell.class));
        cards.add(new SetCardInfo("Gorging Vulture", 449, Rarity.COMMON, mage.cards.g.GorgingVulture.class));
        cards.add(new SetCardInfo("Gorgon Flail", 752, Rarity.UNCOMMON, mage.cards.g.GorgonFlail.class));
        cards.add(new SetCardInfo("Gornog, the Red Reaper", 49, Rarity.RARE, mage.cards.g.GornogTheRedReaper.class));
        cards.add(new SetCardInfo("Grave Strength", 450, Rarity.UNCOMMON, mage.cards.g.GraveStrength.class));
        cards.add(new SetCardInfo("Graveblade Marauder", 451, Rarity.UNCOMMON, mage.cards.g.GravebladeMarauder.class));
        cards.add(new SetCardInfo("Gravedigger", 452, Rarity.COMMON, mage.cards.g.Gravedigger.class));
        cards.add(new SetCardInfo("Grazing Gladehart", 665, Rarity.COMMON, mage.cards.g.GrazingGladehart.class));
        cards.add(new SetCardInfo("Greenwood Sentinel", 666, Rarity.COMMON, mage.cards.g.GreenwoodSentinel.class));
        cards.add(new SetCardInfo("Grim Bounty", 118, Rarity.COMMON, mage.cards.g.GrimBounty.class));
        cards.add(new SetCardInfo("Groundswell", 667, Rarity.COMMON, mage.cards.g.Groundswell.class));
        cards.add(new SetCardInfo("Guardian Idol", 753, Rarity.UNCOMMON, mage.cards.g.GuardianIdol.class));
        cards.add(new SetCardInfo("Gust of Wind", 316, Rarity.COMMON, mage.cards.g.GustOfWind.class));
        cards.add(new SetCardInfo("Guttersnipe", 138, Rarity.UNCOMMON, mage.cards.g.Guttersnipe.class));
        cards.add(new SetCardInfo("Harrow", 668, Rarity.COMMON, mage.cards.h.Harrow.class));
        cards.add(new SetCardInfo("Harvester of Souls", 453, Rarity.RARE, mage.cards.h.HarvesterOfSouls.class));
        cards.add(new SetCardInfo("Haunting Figment", 317, Rarity.COMMON, mage.cards.h.HauntingFigment.class));
        cards.add(new SetCardInfo("Hearts on Fire", 17, Rarity.COMMON, mage.cards.h.HeartsOnFire.class));
        cards.add(new SetCardInfo("Heartstabber Mosquito", 454, Rarity.COMMON, mage.cards.h.HeartstabberMosquito.class));
        cards.add(new SetCardInfo("Heir of the Ancient Fang", 669, Rarity.COMMON, mage.cards.h.HeirOfTheAncientFang.class));
        cards.add(new SetCardInfo("Hellkite Whelp", 562, Rarity.UNCOMMON, mage.cards.h.HellkiteWhelp.class));
        cards.add(new SetCardInfo("Herald of War", 207, Rarity.RARE, mage.cards.h.HeraldOfWar.class));
        cards.add(new SetCardInfo("Herald of the Sun", 206, Rarity.UNCOMMON, mage.cards.h.HeraldOfTheSun.class));
        cards.add(new SetCardInfo("Hero of the Games", 563, Rarity.COMMON, mage.cards.h.HeroOfTheGames.class));
        cards.add(new SetCardInfo("Hexgold Hoverwings", 208, Rarity.UNCOMMON, mage.cards.h.HexgoldHoverwings.class));
        cards.add(new SetCardInfo("High-Rise Sawjack", 670, Rarity.COMMON, mage.cards.h.HighRiseSawjack.class));
        cards.add(new SetCardInfo("Hinterland Sanctifier", 5, Rarity.COMMON, mage.cards.h.HinterlandSanctifier.class));
        cards.add(new SetCardInfo("Hooded Blightfang", 455, Rarity.RARE, mage.cards.h.HoodedBlightfang.class));
        cards.add(new SetCardInfo("Howling Banshee", 119, Rarity.UNCOMMON, mage.cards.h.HowlingBanshee.class));
        cards.add(new SetCardInfo("Hungry Megasloth", 21, Rarity.UNCOMMON, mage.cards.h.HungryMegasloth.class));
        cards.add(new SetCardInfo("Hunter's Edge", 671, Rarity.COMMON, mage.cards.h.HuntersEdge.class));
        cards.add(new SetCardInfo("Hurska Sweet-Tooth", 53, Rarity.MYTHIC, mage.cards.h.HurskaSweetTooth.class));
        cards.add(new SetCardInfo("Impeccable Timing", 209, Rarity.COMMON, mage.cards.i.ImpeccableTiming.class));
        cards.add(new SetCardInfo("Incorrigible Youths", 564, Rarity.UNCOMMON, mage.cards.i.IncorrigibleYouths.class));
        cards.add(new SetCardInfo("Indomitable Will", 210, Rarity.COMMON, mage.cards.i.IndomitableWill.class));
        cards.add(new SetCardInfo("Infernal Grasp", 456, Rarity.UNCOMMON, mage.cards.i.InfernalGrasp.class));
        cards.add(new SetCardInfo("Infuriate", 565, Rarity.COMMON, mage.cards.i.Infuriate.class));
        cards.add(new SetCardInfo("Ingenious Leonin", 211, Rarity.UNCOMMON, mage.cards.i.IngeniousLeonin.class));
        cards.add(new SetCardInfo("Insatiable Appetite", 672, Rarity.COMMON, mage.cards.i.InsatiableAppetite.class));
        cards.add(new SetCardInfo("Insolent Neonate", 566, Rarity.COMMON, mage.cards.i.InsolentNeonate.class));
        cards.add(new SetCardInfo("Inspiring Overseer", 212, Rarity.COMMON, mage.cards.i.InspiringOverseer.class));
        cards.add(new SetCardInfo("Invigorated Rampage", 567, Rarity.UNCOMMON, mage.cards.i.InvigoratedRampage.class));
        cards.add(new SetCardInfo("Invigorating Surge", 673, Rarity.UNCOMMON, mage.cards.i.InvigoratingSurge.class));
        cards.add(new SetCardInfo("Ipnu Rivulet", 767, Rarity.UNCOMMON, mage.cards.i.IpnuRivulet.class));
        cards.add(new SetCardInfo("Isareth the Awakener", 68, Rarity.RARE, mage.cards.i.IsarethTheAwakener.class));
        cards.add(new SetCardInfo("Island", 84, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivora, Insatiable Heir", 50, Rarity.UNCOMMON, mage.cards.i.IvoraInsatiableHeir.class));
        cards.add(new SetCardInfo("Ivy Lane Denizen", 674, Rarity.COMMON, mage.cards.i.IvyLaneDenizen.class));
        cards.add(new SetCardInfo("Ixalli's Diviner", 675, Rarity.COMMON, mage.cards.i.IxallisDiviner.class));
        cards.add(new SetCardInfo("Jadelight Ranger", 676, Rarity.RARE, mage.cards.j.JadelightRanger.class));
        cards.add(new SetCardInfo("Jaya's Firenado", 568, Rarity.COMMON, mage.cards.j.JayasFirenado.class));
        cards.add(new SetCardInfo("Jiang Yanggu, Wildcrafter", 677, Rarity.UNCOMMON, mage.cards.j.JiangYangguWildcrafter.class));
        cards.add(new SetCardInfo("Jubilant Mascot", 213, Rarity.UNCOMMON, mage.cards.j.JubilantMascot.class));
        cards.add(new SetCardInfo("Jungle Delver", 678, Rarity.COMMON, mage.cards.j.JungleDelver.class));
        cards.add(new SetCardInfo("Kabira Crossroads", 768, Rarity.COMMON, mage.cards.k.KabiraCrossroads.class));
        cards.add(new SetCardInfo("Kapsho Kitefins", 318, Rarity.UNCOMMON, mage.cards.k.KapshoKitefins.class));
        cards.add(new SetCardInfo("Kargan Intimidator", 569, Rarity.RARE, mage.cards.k.KarganIntimidator.class));
        cards.add(new SetCardInfo("Kazandu Nectarpot", 679, Rarity.COMMON, mage.cards.k.KazanduNectarpot.class));
        cards.add(new SetCardInfo("Kazandu Stomper", 680, Rarity.COMMON, mage.cards.k.KazanduStomper.class));
        cards.add(new SetCardInfo("Keldon Raider", 570, Rarity.COMMON, mage.cards.k.KeldonRaider.class));
        cards.add(new SetCardInfo("Killing Glare", 120, Rarity.UNCOMMON, mage.cards.k.KillingGlare.class));
        cards.add(new SetCardInfo("Kiln Fiend", 139, Rarity.COMMON, mage.cards.k.KilnFiend.class));
        cards.add(new SetCardInfo("Kindled Fury", 571, Rarity.COMMON, mage.cards.k.KindledFury.class));
        cards.add(new SetCardInfo("King of the Pride", 214, Rarity.UNCOMMON, mage.cards.k.KingOfThePride.class));
        cards.add(new SetCardInfo("Kodama of the West Tree", 78, Rarity.MYTHIC, mage.cards.k.KodamaOfTheWestTree.class));
        cards.add(new SetCardInfo("Koma's Faithful", 457, Rarity.COMMON, mage.cards.k.KomasFaithful.class));
        cards.add(new SetCardInfo("Krenko's Command", 140, Rarity.COMMON, mage.cards.k.KrenkosCommand.class));
        cards.add(new SetCardInfo("Krenko, Tin Street Kingpin", 572, Rarity.RARE, mage.cards.k.KrenkoTinStreetKingpin.class));
        cards.add(new SetCardInfo("Krosan Tusker", 681, Rarity.UNCOMMON, mage.cards.k.KrosanTusker.class));
        cards.add(new SetCardInfo("Krovikan Mist", 319, Rarity.COMMON, mage.cards.k.KrovikanMist.class));
        cards.add(new SetCardInfo("Kruin Striker", 573, Rarity.COMMON, mage.cards.k.KruinStriker.class));
        cards.add(new SetCardInfo("Kujar Seedsculptor", 682, Rarity.COMMON, mage.cards.k.KujarSeedsculptor.class));
        cards.add(new SetCardInfo("Lat-Nam Adept", 320, Rarity.COMMON, mage.cards.l.LatNamAdept.class));
        cards.add(new SetCardInfo("Lathliss, Dragon Queen", 74, Rarity.RARE, mage.cards.l.LathlissDragonQueen.class));
        cards.add(new SetCardInfo("Leaf-Crowned Visionary", 683, Rarity.RARE, mage.cards.l.LeafCrownedVisionary.class));
        cards.add(new SetCardInfo("Leonin Scimitar", 152, Rarity.COMMON, mage.cards.l.LeoninScimitar.class));
        cards.add(new SetCardInfo("Leonin Vanguard", 216, Rarity.UNCOMMON, mage.cards.l.LeoninVanguard.class));
        cards.add(new SetCardInfo("Leonin of the Lost Pride", 215, Rarity.COMMON, mage.cards.l.LeoninOfTheLostPride.class));
        cards.add(new SetCardInfo("Light of Hope", 217, Rarity.COMMON, mage.cards.l.LightOfHope.class));
        cards.add(new SetCardInfo("Light of the Legion", 218, Rarity.RARE, mage.cards.l.LightOfTheLegion.class));
        cards.add(new SetCardInfo("Light the Way", 219, Rarity.COMMON, mage.cards.l.LightTheWay.class));
        cards.add(new SetCardInfo("Lightwalker", 220, Rarity.COMMON, mage.cards.l.Lightwalker.class));
        cards.add(new SetCardInfo("Liliana, Death's Majesty", 458, Rarity.MYTHIC, mage.cards.l.LilianaDeathsMajesty.class));
        cards.add(new SetCardInfo("Llanowar Elves", 149, Rarity.COMMON, mage.cards.l.LlanowarElves.class));
        cards.add(new SetCardInfo("Llanowar Visionary", 684, Rarity.COMMON, mage.cards.l.LlanowarVisionary.class));
        cards.add(new SetCardInfo("Locked in the Cemetery", 321, Rarity.COMMON, mage.cards.l.LockedInTheCemetery.class));
        cards.add(new SetCardInfo("Lonely Sandbar", 769, Rarity.UNCOMMON, mage.cards.l.LonelySandbar.class));
        cards.add(new SetCardInfo("Lord of the Unreal", 322, Rarity.RARE, mage.cards.l.LordOfTheUnreal.class));
        cards.add(new SetCardInfo("Lotus Cobra", 685, Rarity.RARE, mage.cards.l.LotusCobra.class));
        cards.add(new SetCardInfo("Mace of the Valiant", 221, Rarity.RARE, mage.cards.m.MaceOfTheValiant.class));
        cards.add(new SetCardInfo("Maelstrom Colossus", 754, Rarity.COMMON, mage.cards.m.MaelstromColossus.class));
        cards.add(new SetCardInfo("Majestic Metamorphosis", 323, Rarity.COMMON, mage.cards.m.MajesticMetamorphosis.class));
        cards.add(new SetCardInfo("Make a Stand", 222, Rarity.UNCOMMON, mage.cards.m.MakeAStand.class));
        cards.add(new SetCardInfo("Malcator's Watcher", 324, Rarity.COMMON, mage.cards.m.MalcatorsWatcher.class));
        cards.add(new SetCardInfo("Malfunction", 325, Rarity.COMMON, mage.cards.m.Malfunction.class));
        cards.add(new SetCardInfo("Maraleaf Rider", 686, Rarity.COMMON, mage.cards.m.MaraleafRider.class));
        cards.add(new SetCardInfo("Markov Blademaster", 574, Rarity.RARE, mage.cards.m.MarkovBlademaster.class));
        cards.add(new SetCardInfo("Markov Enforcer", 575, Rarity.RARE, mage.cards.m.MarkovEnforcer.class));
        cards.add(new SetCardInfo("Markov Retribution", 576, Rarity.UNCOMMON, mage.cards.m.MarkovRetribution.class));
        cards.add(new SetCardInfo("Markov Warlord", 577, Rarity.UNCOMMON, mage.cards.m.MarkovWarlord.class));
        cards.add(new SetCardInfo("Marwyn, the Nurturer", 687, Rarity.RARE, mage.cards.m.MarwynTheNurturer.class));
        cards.add(new SetCardInfo("Masked Blackguard", 459, Rarity.COMMON, mage.cards.m.MaskedBlackguard.class));
        cards.add(new SetCardInfo("Maul of the Skyclaves", 223, Rarity.RARE, mage.cards.m.MaulOfTheSkyclaves.class));
        cards.add(new SetCardInfo("Memorial to Folly", 770, Rarity.UNCOMMON, mage.cards.m.MemorialToFolly.class));
        cards.add(new SetCardInfo("Memorial to Genius", 771, Rarity.UNCOMMON, mage.cards.m.MemorialToGenius.class));
        cards.add(new SetCardInfo("Memorial to Glory", 772, Rarity.UNCOMMON, mage.cards.m.MemorialToGlory.class));
        cards.add(new SetCardInfo("Mentor of the Meek", 99, Rarity.UNCOMMON, mage.cards.m.MentorOfTheMeek.class));
        cards.add(new SetCardInfo("Merfolk Branchwalker", 688, Rarity.UNCOMMON, mage.cards.m.MerfolkBranchwalker.class));
        cards.add(new SetCardInfo("Merfolk Pupil", 326, Rarity.COMMON, mage.cards.m.MerfolkPupil.class));
        cards.add(new SetCardInfo("Mesa Unicorn", 224, Rarity.COMMON, mage.cards.m.MesaUnicorn.class));
        cards.add(new SetCardInfo("Metalspinner's Puzzleknot", 755, Rarity.COMMON, mage.cards.m.MetalspinnersPuzzleknot.class));
        cards.add(new SetCardInfo("Midnight Assassin", 460, Rarity.COMMON, mage.cards.m.MidnightAssassin.class));
        cards.add(new SetCardInfo("Might of the Masses", 689, Rarity.UNCOMMON, mage.cards.m.MightOfTheMasses.class));
        cards.add(new SetCardInfo("Mikaeus, the Lunarch", 225, Rarity.MYTHIC, mage.cards.m.MikaeusTheLunarch.class));
        cards.add(new SetCardInfo("Militant Inquisitor", 226, Rarity.COMMON, mage.cards.m.MilitantInquisitor.class));
        cards.add(new SetCardInfo("Minotaur Sureshot", 578, Rarity.COMMON, mage.cards.m.MinotaurSureshot.class));
        cards.add(new SetCardInfo("Mirran Bardiche", 227, Rarity.COMMON, mage.cards.m.MirranBardiche.class));
        cards.add(new SetCardInfo("Mirrorwing Dragon", 579, Rarity.MYTHIC, mage.cards.m.MirrorwingDragon.class));
        cards.add(new SetCardInfo("Moan of the Unhallowed", 461, Rarity.UNCOMMON, mage.cards.m.MoanOfTheUnhallowed.class));
        cards.add(new SetCardInfo("Mogg Flunkies", 580, Rarity.COMMON, mage.cards.m.MoggFlunkies.class));
        cards.add(new SetCardInfo("Moldgraf Millipede", 690, Rarity.COMMON, mage.cards.m.MoldgrafMillipede.class));
        cards.add(new SetCardInfo("Moment of Craving", 462, Rarity.COMMON, mage.cards.m.MomentOfCraving.class));
        cards.add(new SetCardInfo("Moment of Heroism", 228, Rarity.COMMON, mage.cards.m.MomentOfHeroism.class));
        cards.add(new SetCardInfo("Moment of Triumph", 229, Rarity.COMMON, mage.cards.m.MomentOfTriumph.class));
        cards.add(new SetCardInfo("Moodmark Painter", 463, Rarity.COMMON, mage.cards.m.MoodmarkPainter.class));
        cards.add(new SetCardInfo("Moon-Circuit Hacker", 327, Rarity.COMMON, mage.cards.m.MoonCircuitHacker.class));
        cards.add(new SetCardInfo("Moonsnare Specialist", 328, Rarity.COMMON, mage.cards.m.MoonsnareSpecialist.class));
        cards.add(new SetCardInfo("Morbid Opportunist", 464, Rarity.UNCOMMON, mage.cards.m.MorbidOpportunist.class));
        cards.add(new SetCardInfo("Morkrut Behemoth", 465, Rarity.COMMON, mage.cards.m.MorkrutBehemoth.class));
        cards.add(new SetCardInfo("Morkrut Necropod", 466, Rarity.UNCOMMON, mage.cards.m.MorkrutNecropod.class));
        cards.add(new SetCardInfo("Mountain", 90, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mowu, Loyal Companion", 79, Rarity.UNCOMMON, mage.cards.m.MowuLoyalCompanion.class));
        cards.add(new SetCardInfo("Mu Yanling, Sky Dancer", 329, Rarity.MYTHIC, mage.cards.m.MuYanlingSkyDancer.class));
        cards.add(new SetCardInfo("Murasa Ranger", 691, Rarity.UNCOMMON, mage.cards.m.MurasaRanger.class));
        cards.add(new SetCardInfo("Murder", 467, Rarity.COMMON, mage.cards.m.Murder.class));
        cards.add(new SetCardInfo("Murmuring Mystic", 107, Rarity.UNCOMMON, mage.cards.m.MurmuringMystic.class));
        cards.add(new SetCardInfo("Muse Drake", 330, Rarity.COMMON, mage.cards.m.MuseDrake.class));
        cards.add(new SetCardInfo("Myr Enforcer", 756, Rarity.COMMON, mage.cards.m.MyrEnforcer.class));
        cards.add(new SetCardInfo("Mystic Skyfish", 331, Rarity.COMMON, mage.cards.m.MysticSkyfish.class));
        cards.add(new SetCardInfo("Naban, Dean of Iteration", 61, Rarity.RARE, mage.cards.n.NabanDeanOfIteration.class));
        cards.add(new SetCardInfo("Nadir Kraken", 332, Rarity.RARE, mage.cards.n.NadirKraken.class));
        cards.add(new SetCardInfo("Naiad of Hidden Coves", 333, Rarity.COMMON, mage.cards.n.NaiadOfHiddenCoves.class));
        cards.add(new SetCardInfo("Nantuko Husk", 468, Rarity.COMMON, mage.cards.n.NantukoHusk.class));
        cards.add(new SetCardInfo("Nazar, the Velvet Fang", 43, Rarity.UNCOMMON, mage.cards.n.NazarTheVelvetFang.class));
        cards.add(new SetCardInfo("Necropolis Regent", 469, Rarity.MYTHIC, mage.cards.n.NecropolisRegent.class));
        cards.add(new SetCardInfo("Necrotic Wound", 470, Rarity.UNCOMMON, mage.cards.n.NecroticWound.class));
        cards.add(new SetCardInfo("Neerdiv, Devious Diver", 36, Rarity.RARE, mage.cards.n.NeerdivDeviousDiver.class));
        cards.add(new SetCardInfo("Nef-Crop Entangler", 581, Rarity.COMMON, mage.cards.n.NefCropEntangler.class));
        cards.add(new SetCardInfo("Neonate's Rush", 582, Rarity.COMMON, mage.cards.n.NeonatesRush.class));
        cards.add(new SetCardInfo("Network Disruptor", 334, Rarity.COMMON, mage.cards.n.NetworkDisruptor.class));
        cards.add(new SetCardInfo("Night's Whisper", 471, Rarity.COMMON, mage.cards.n.NightsWhisper.class));
        cards.add(new SetCardInfo("Nightveil Sprite", 335, Rarity.UNCOMMON, mage.cards.n.NightveilSprite.class));
        cards.add(new SetCardInfo("Ninja of the Deep Hours", 108, Rarity.COMMON, mage.cards.n.NinjaOfTheDeepHours.class));
        cards.add(new SetCardInfo("Nullpriest of Oblivion", 472, Rarity.RARE, mage.cards.n.NullpriestOfOblivion.class));
        cards.add(new SetCardInfo("Nykthos Paragon", 230, Rarity.RARE, mage.cards.n.NykthosParagon.class));
        cards.add(new SetCardInfo("Nyx-Fleece Ram", 231, Rarity.UNCOMMON, mage.cards.n.NyxFleeceRam.class));
        cards.add(new SetCardInfo("Obstinate Baloth", 692, Rarity.UNCOMMON, mage.cards.o.ObstinateBaloth.class));
        cards.add(new SetCardInfo("Ojutai Exemplars", 232, Rarity.MYTHIC, mage.cards.o.OjutaiExemplars.class));
        cards.add(new SetCardInfo("Omen of the Sea", 336, Rarity.COMMON, mage.cards.o.OmenOfTheSea.class));
        cards.add(new SetCardInfo("Oneirophage", 337, Rarity.UNCOMMON, mage.cards.o.Oneirophage.class));
        cards.add(new SetCardInfo("Open Fire", 583, Rarity.COMMON, mage.cards.o.OpenFire.class));
        cards.add(new SetCardInfo("Opportunity", 338, Rarity.UNCOMMON, mage.cards.o.Opportunity.class));
        cards.add(new SetCardInfo("Opt", 339, Rarity.COMMON, mage.cards.o.Opt.class));
        cards.add(new SetCardInfo("Oran-Rief Ooze", 693, Rarity.RARE, mage.cards.o.OranRiefOoze.class));
        cards.add(new SetCardInfo("Orchard Strider", 694, Rarity.COMMON, mage.cards.o.OrchardStrider.class));
        cards.add(new SetCardInfo("Organ Hoarder", 340, Rarity.COMMON, mage.cards.o.OrganHoarder.class));
        cards.add(new SetCardInfo("Ornithopter of Paradise", 153, Rarity.COMMON, mage.cards.o.OrnithopterOfParadise.class));
        cards.add(new SetCardInfo("Orochi Merge-Keeper", 695, Rarity.UNCOMMON, mage.cards.o.OrochiMergeKeeper.class));
        cards.add(new SetCardInfo("Outflank", 233, Rarity.COMMON, mage.cards.o.Outflank.class));
        cards.add(new SetCardInfo("Overcome", 696, Rarity.UNCOMMON, mage.cards.o.Overcome.class));
        cards.add(new SetCardInfo("Overflowing Insight", 341, Rarity.MYTHIC, mage.cards.o.OverflowingInsight.class));
        cards.add(new SetCardInfo("Overwhelm", 697, Rarity.UNCOMMON, mage.cards.o.Overwhelm.class));
        cards.add(new SetCardInfo("Owl Familiar", 342, Rarity.COMMON, mage.cards.o.OwlFamiliar.class));
        cards.add(new SetCardInfo("Ozox, the Clattering King", 44, Rarity.UNCOMMON, mage.cards.o.OzoxTheClatteringKing.class));
        cards.add(new SetCardInfo("Pacifism", 234, Rarity.COMMON, mage.cards.p.Pacifism.class));
        cards.add(new SetCardInfo("Padeem, Consul of Innovation", 62, Rarity.RARE, mage.cards.p.PadeemConsulOfInnovation.class));
        cards.add(new SetCardInfo("Paladin of the Bloodstained", 235, Rarity.COMMON, mage.cards.p.PaladinOfTheBloodstained.class));
        cards.add(new SetCardInfo("Paradise Druid", 698, Rarity.UNCOMMON, mage.cards.p.ParadiseDruid.class));
        cards.add(new SetCardInfo("Parhelion Patrol", 236, Rarity.COMMON, mage.cards.p.ParhelionPatrol.class));
        cards.add(new SetCardInfo("Patchwork Automaton", 757, Rarity.UNCOMMON, mage.cards.p.PatchworkAutomaton.class));
        cards.add(new SetCardInfo("Pathmaker Initiate", 584, Rarity.COMMON, mage.cards.p.PathmakerInitiate.class));
        cards.add(new SetCardInfo("Patron of the Valiant", 237, Rarity.UNCOMMON, mage.cards.p.PatronOfTheValiant.class));
        cards.add(new SetCardInfo("Persistent Specimen", 473, Rarity.COMMON, mage.cards.p.PersistentSpecimen.class));
        cards.add(new SetCardInfo("Pestermite", 343, Rarity.COMMON, mage.cards.p.Pestermite.class));
        cards.add(new SetCardInfo("Phantasmal Form", 344, Rarity.COMMON, mage.cards.p.PhantasmalForm.class));
        cards.add(new SetCardInfo("Phantasmal Shieldback", 8, Rarity.UNCOMMON, mage.cards.p.PhantasmalShieldback.class));
        cards.add(new SetCardInfo("Phantom Ninja", 345, Rarity.COMMON, mage.cards.p.PhantomNinja.class));
        cards.add(new SetCardInfo("Pharika's Chosen", 474, Rarity.COMMON, mage.cards.p.PharikasChosen.class));
        cards.add(new SetCardInfo("Pigment Storm", 585, Rarity.COMMON, mage.cards.p.PigmentStorm.class));
        cards.add(new SetCardInfo("Pilfering Imp", 475, Rarity.UNCOMMON, mage.cards.p.PilferingImp.class));
        cards.add(new SetCardInfo("Pitiless Plunderer", 476, Rarity.UNCOMMON, mage.cards.p.PitilessPlunderer.class));
        cards.add(new SetCardInfo("Plagon, Lord of the Beach", 37, Rarity.RARE, mage.cards.p.PlagonLordOfTheBeach.class));
        cards.add(new SetCardInfo("Plains", 81, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plate Armor", 100, Rarity.UNCOMMON, mage.cards.p.PlateArmor.class));
        cards.add(new SetCardInfo("Play with Fire", 586, Rarity.UNCOMMON, mage.cards.p.PlayWithFire.class));
        cards.add(new SetCardInfo("Pol Jamaar, Illusionist", 38, Rarity.MYTHIC, mage.cards.p.PolJamaarIllusionist.class));
        cards.add(new SetCardInfo("Powerstone Fracture", 477, Rarity.COMMON, mage.cards.p.PowerstoneFracture.class));
        cards.add(new SetCardInfo("Predator's Strike", 699, Rarity.COMMON, mage.cards.p.PredatorsStrike.class));
        cards.add(new SetCardInfo("Pridemalkin", 700, Rarity.COMMON, mage.cards.p.Pridemalkin.class));
        cards.add(new SetCardInfo("Priest of Forgotten Gods", 478, Rarity.RARE, mage.cards.p.PriestOfForgottenGods.class));
        cards.add(new SetCardInfo("Priest of Gix", 121, Rarity.UNCOMMON, mage.cards.p.PriestOfGix.class));
        cards.add(new SetCardInfo("Primeval Bounty", 701, Rarity.MYTHIC, mage.cards.p.PrimevalBounty.class));
        cards.add(new SetCardInfo("Primeval Herald", 702, Rarity.UNCOMMON, mage.cards.p.PrimevalHerald.class));
        cards.add(new SetCardInfo("Prophetic Prism", 758, Rarity.COMMON, mage.cards.p.PropheticPrism.class));
        cards.add(new SetCardInfo("Prosperous Thief", 346, Rarity.UNCOMMON, mage.cards.p.ProsperousThief.class));
        cards.add(new SetCardInfo("Purple-Crystal Crab", 347, Rarity.COMMON, mage.cards.p.PurpleCrystalCrab.class));
        cards.add(new SetCardInfo("Pyrophobia", 587, Rarity.COMMON, mage.cards.p.Pyrophobia.class));
        cards.add(new SetCardInfo("Qala, Ajani's Pridemate", 32, Rarity.UNCOMMON, mage.cards.q.QalaAjanisPridemate.class));
        cards.add(new SetCardInfo("Quirion Beastcaller", 703, Rarity.RARE, mage.cards.q.QuirionBeastcaller.class));
        cards.add(new SetCardInfo("Raise the Alarm", 101, Rarity.COMMON, mage.cards.r.RaiseTheAlarm.class));
        cards.add(new SetCardInfo("Rally of Wings", 238, Rarity.UNCOMMON, mage.cards.r.RallyOfWings.class));
        cards.add(new SetCardInfo("Rampant Growth", 704, Rarity.COMMON, mage.cards.r.RampantGrowth.class));
        cards.add(new SetCardInfo("Rapacious Dragon", 588, Rarity.UNCOMMON, mage.cards.r.RapaciousDragon.class));
        cards.add(new SetCardInfo("Razorgrass Invoker", 22, Rarity.COMMON, mage.cards.r.RazorgrassInvoker.class));
        cards.add(new SetCardInfo("Read the Bones", 479, Rarity.COMMON, mage.cards.r.ReadTheBones.class));
        cards.add(new SetCardInfo("Realm Seekers", 705, Rarity.RARE, mage.cards.r.RealmSeekers.class));
        cards.add(new SetCardInfo("Reaper from the Abyss", 480, Rarity.MYTHIC, mage.cards.r.ReaperFromTheAbyss.class));
        cards.add(new SetCardInfo("Reassembling Skeleton", 481, Rarity.UNCOMMON, mage.cards.r.ReassemblingSkeleton.class));
        cards.add(new SetCardInfo("Reckless Amplimancer", 706, Rarity.COMMON, mage.cards.r.RecklessAmplimancer.class));
        cards.add(new SetCardInfo("Reckless Impulse", 589, Rarity.COMMON, mage.cards.r.RecklessImpulse.class));
        cards.add(new SetCardInfo("Reckless Scholar", 348, Rarity.UNCOMMON, mage.cards.r.RecklessScholar.class));
        cards.add(new SetCardInfo("Recruitment Officer", 239, Rarity.UNCOMMON, mage.cards.r.RecruitmentOfficer.class));
        cards.add(new SetCardInfo("Recumbent Bliss", 240, Rarity.COMMON, mage.cards.r.RecumbentBliss.class));
        cards.add(new SetCardInfo("Relic Axe", 759, Rarity.UNCOMMON, mage.cards.r.RelicAxe.class));
        cards.add(new SetCardInfo("Relief Captain", 241, Rarity.UNCOMMON, mage.cards.r.ReliefCaptain.class));
        cards.add(new SetCardInfo("Remand", 349, Rarity.UNCOMMON, mage.cards.r.Remand.class));
        cards.add(new SetCardInfo("Renegade Tactics", 590, Rarity.COMMON, mage.cards.r.RenegadeTactics.class));
        cards.add(new SetCardInfo("Repel the Darkness", 242, Rarity.COMMON, mage.cards.r.RepelTheDarkness.class));
        cards.add(new SetCardInfo("Resistance Reunited", 243, Rarity.UNCOMMON, mage.cards.r.ResistanceReunited.class));
        cards.add(new SetCardInfo("Resistance Skywarden", 591, Rarity.UNCOMMON, mage.cards.r.ResistanceSkywarden.class));
        cards.add(new SetCardInfo("Retreat to Kazandu", 707, Rarity.UNCOMMON, mage.cards.r.RetreatToKazandu.class));
        cards.add(new SetCardInfo("Revitalize", 244, Rarity.COMMON, mage.cards.r.Revitalize.class));
        cards.add(new SetCardInfo("Revoke Demise", 10, Rarity.COMMON, mage.cards.r.RevokeDemise.class));
        cards.add(new SetCardInfo("Rhox Faithmender", 245, Rarity.RARE, mage.cards.r.RhoxFaithmender.class));
        cards.add(new SetCardInfo("Righteous Valkyrie", 246, Rarity.RARE, mage.cards.r.RighteousValkyrie.class));
        cards.add(new SetCardInfo("Rionya, Fire Dancer", 75, Rarity.RARE, mage.cards.r.RionyaFireDancer.class));
        cards.add(new SetCardInfo("Rishkar, Peema Renegade", 708, Rarity.RARE, mage.cards.r.RishkarPeemaRenegade.class));
        cards.add(new SetCardInfo("Rodolf Duskbringer", 482, Rarity.RARE, mage.cards.r.RodolfDuskbringer.class));
        cards.add(new SetCardInfo("Roil Eruption", 592, Rarity.COMMON, mage.cards.r.RoilEruption.class));
        cards.add(new SetCardInfo("Ronom Unicorn", 247, Rarity.COMMON, mage.cards.r.RonomUnicorn.class));
        cards.add(new SetCardInfo("Run Ashore", 109, Rarity.COMMON, mage.cards.r.RunAshore.class));
        cards.add(new SetCardInfo("Ruthless Knave", 483, Rarity.UNCOMMON, mage.cards.r.RuthlessKnave.class));
        cards.add(new SetCardInfo("Ruthless Technomancer", 484, Rarity.RARE, mage.cards.r.RuthlessTechnomancer.class));
        cards.add(new SetCardInfo("Sai, Master Thopterist", 63, Rarity.RARE, mage.cards.s.SaiMasterThopterist.class));
        cards.add(new SetCardInfo("Sanctum Seeker", 485, Rarity.RARE, mage.cards.s.SanctumSeeker.class));
        cards.add(new SetCardInfo("Sandsteppe Outcast", 248, Rarity.COMMON, mage.cards.s.SandsteppeOutcast.class));
        cards.add(new SetCardInfo("Sandstorm Crasher", 18, Rarity.RARE, mage.cards.s.SandstormCrasher.class));
        cards.add(new SetCardInfo("Sangromancer", 122, Rarity.RARE, mage.cards.s.Sangromancer.class));
        cards.add(new SetCardInfo("Saproling Migration", 709, Rarity.COMMON, mage.cards.s.SaprolingMigration.class));
        cards.add(new SetCardInfo("Sarkhan's Rage", 594, Rarity.COMMON, mage.cards.s.SarkhansRage.class));
        cards.add(new SetCardInfo("Sarkhan, Fireblood", 593, Rarity.MYTHIC, mage.cards.s.SarkhanFireblood.class));
        cards.add(new SetCardInfo("Satyr Hoplite", 595, Rarity.COMMON, mage.cards.s.SatyrHoplite.class));
        cards.add(new SetCardInfo("Saurian Symbiote", 23, Rarity.COMMON, mage.cards.s.SaurianSymbiote.class));
        cards.add(new SetCardInfo("Savage Stomp", 710, Rarity.UNCOMMON, mage.cards.s.SavageStomp.class));
        cards.add(new SetCardInfo("Savannah Lions", 249, Rarity.COMMON, mage.cards.s.SavannahLions.class));
        cards.add(new SetCardInfo("Scavenged Blade", 596, Rarity.COMMON, mage.cards.s.ScavengedBlade.class));
        cards.add(new SetCardInfo("Scholar of Combustion", 19, Rarity.COMMON, mage.cards.s.ScholarOfCombustion.class));
        cards.add(new SetCardInfo("Scion of Darkness", 486, Rarity.UNCOMMON, mage.cards.s.ScionOfDarkness.class));
        cards.add(new SetCardInfo("Scion of Opulence", 597, Rarity.RARE, mage.cards.s.ScionOfOpulence.class));
        cards.add(new SetCardInfo("Scion of the Swarm", 487, Rarity.UNCOMMON, mage.cards.s.ScionOfTheSwarm.class));
        cards.add(new SetCardInfo("Scourge of the Undercity", 11, Rarity.COMMON, mage.cards.s.ScourgeOfTheUndercity.class));
        cards.add(new SetCardInfo("Screaming Swarm", 351, Rarity.UNCOMMON, mage.cards.s.ScreamingSwarm.class));
        cards.add(new SetCardInfo("Scythecat Cub", 24, Rarity.RARE, mage.cards.s.ScythecatCub.class));
        cards.add(new SetCardInfo("Search Party Captain", 250, Rarity.COMMON, mage.cards.s.SearchPartyCaptain.class));
        cards.add(new SetCardInfo("Seat of the Synod", 773, Rarity.COMMON, mage.cards.s.SeatOfTheSynod.class));
        cards.add(new SetCardInfo("Secluded Steppe", 774, Rarity.UNCOMMON, mage.cards.s.SecludedSteppe.class));
        cards.add(new SetCardInfo("Seize the Spoils", 141, Rarity.COMMON, mage.cards.s.SeizeTheSpoils.class));
        cards.add(new SetCardInfo("Serpent Assassin", 123, Rarity.UNCOMMON, mage.cards.s.SerpentAssassin.class));
        cards.add(new SetCardInfo("Serpentine Ambush", 352, Rarity.COMMON, mage.cards.s.SerpentineAmbush.class));
        cards.add(new SetCardInfo("Serra Angel", 251, Rarity.UNCOMMON, mage.cards.s.SerraAngel.class));
        cards.add(new SetCardInfo("Serra's Embrace", 252, Rarity.UNCOMMON, mage.cards.s.SerrasEmbrace.class));
        cards.add(new SetCardInfo("Servant of the Scale", 711, Rarity.COMMON, mage.cards.s.ServantOfTheScale.class));
        cards.add(new SetCardInfo("Severed Strands", 488, Rarity.COMMON, mage.cards.s.SeveredStrands.class));
        cards.add(new SetCardInfo("Shambling Ghast", 124, Rarity.COMMON, mage.cards.s.ShamblingGhast.class));
        cards.add(new SetCardInfo("Shardless Outlander", 28, Rarity.COMMON, mage.cards.s.ShardlessOutlander.class));
        cards.add(new SetCardInfo("Shield Mare", 253, Rarity.UNCOMMON, mage.cards.s.ShieldMare.class));
        cards.add(new SetCardInfo("Shimmer Dragon", 353, Rarity.RARE, mage.cards.s.ShimmerDragon.class));
        cards.add(new SetCardInfo("Shipwreck Dowser", 354, Rarity.COMMON, mage.cards.s.ShipwreckDowser.class));
        cards.add(new SetCardInfo("Shock", 598, Rarity.COMMON, mage.cards.s.Shock.class));
        cards.add(new SetCardInfo("Shore Keeper", 355, Rarity.COMMON, mage.cards.s.ShoreKeeper.class));
        cards.add(new SetCardInfo("Shorecomber Crab", 356, Rarity.COMMON, mage.cards.s.ShorecomberCrab.class));
        cards.add(new SetCardInfo("Shoulder to Shoulder", 254, Rarity.COMMON, mage.cards.s.ShoulderToShoulder.class));
        cards.add(new SetCardInfo("Shroofus Sproutsire", 54, Rarity.RARE, mage.cards.s.ShroofusSproutsire.class));
        cards.add(new SetCardInfo("Sigiled Starfish", 357, Rarity.UNCOMMON, mage.cards.s.SigiledStarfish.class));
        cards.add(new SetCardInfo("Silent Departure", 358, Rarity.COMMON, mage.cards.s.SilentDeparture.class));
        cards.add(new SetCardInfo("Skemfar Shadowsage", 489, Rarity.UNCOMMON, mage.cards.s.SkemfarShadowsage.class));
        cards.add(new SetCardInfo("Sky-Eel School", 359, Rarity.COMMON, mage.cards.s.SkyEelSchool.class));
        cards.add(new SetCardInfo("Skyclave Pick-Axe", 712, Rarity.UNCOMMON, mage.cards.s.SkyclavePickAxe.class));
        cards.add(new SetCardInfo("Skymarch Bloodletter", 125, Rarity.COMMON, mage.cards.s.SkymarchBloodletter.class));
        cards.add(new SetCardInfo("Slimebind", 360, Rarity.COMMON, mage.cards.s.Slimebind.class));
        cards.add(new SetCardInfo("Slimy Piper", 25, Rarity.COMMON, mage.cards.s.SlimyPiper.class));
        cards.add(new SetCardInfo("Slinza, the Spiked Stampede", 55, Rarity.RARE, mage.cards.s.SlinzaTheSpikedStampede.class));
        cards.add(new SetCardInfo("Smoke Shroud", 361, Rarity.COMMON, mage.cards.s.SmokeShroud.class));
        cards.add(new SetCardInfo("Snakeskin Veil", 713, Rarity.COMMON, mage.cards.s.SnakeskinVeil.class));
        cards.add(new SetCardInfo("Snapping Gnarlid", 714, Rarity.COMMON, mage.cards.s.SnappingGnarlid.class));
        cards.add(new SetCardInfo("Somberwald Beastmaster", 715, Rarity.RARE, mage.cards.s.SomberwaldBeastmaster.class));
        cards.add(new SetCardInfo("Soul Read", 362, Rarity.COMMON, mage.cards.s.SoulRead.class));
        cards.add(new SetCardInfo("Soul Sear", 599, Rarity.UNCOMMON, mage.cards.s.SoulSear.class));
        cards.add(new SetCardInfo("Sparktongue Dragon", 600, Rarity.COMMON, mage.cards.s.SparktongueDragon.class));
        cards.add(new SetCardInfo("Speakeasy Server", 255, Rarity.COMMON, mage.cards.s.SpeakeasyServer.class));
        cards.add(new SetCardInfo("Speaker of the Heavens", 102, Rarity.RARE, mage.cards.s.SpeakerOfTheHeavens.class));
        cards.add(new SetCardInfo("Spectral Sailor", 363, Rarity.UNCOMMON, mage.cards.s.SpectralSailor.class));
        cards.add(new SetCardInfo("Spellgorger Weird", 601, Rarity.COMMON, mage.cards.s.SpellgorgerWeird.class));
        cards.add(new SetCardInfo("Sphinx of Enlightenment", 364, Rarity.MYTHIC, mage.cards.s.SphinxOfEnlightenment.class));
        cards.add(new SetCardInfo("Spined Tyrranax", 26, Rarity.UNCOMMON, mage.cards.s.SpinedTyrranax.class));
        cards.add(new SetCardInfo("Spirited Companion", 256, Rarity.COMMON, mage.cards.s.SpiritedCompanion.class));
        cards.add(new SetCardInfo("Spore Crawler", 716, Rarity.COMMON, mage.cards.s.SporeCrawler.class));
        cards.add(new SetCardInfo("Spore Swarm", 717, Rarity.UNCOMMON, mage.cards.s.SporeSwarm.class));
        cards.add(new SetCardInfo("Sporecrown Thallid", 718, Rarity.UNCOMMON, mage.cards.s.SporecrownThallid.class));
        cards.add(new SetCardInfo("Sporemound", 719, Rarity.COMMON, mage.cards.s.Sporemound.class));
        cards.add(new SetCardInfo("Sprite Noble", 365, Rarity.RARE, mage.cards.s.SpriteNoble.class));
        cards.add(new SetCardInfo("Squad Captain", 257, Rarity.COMMON, mage.cards.s.SquadCaptain.class));
        cards.add(new SetCardInfo("Stalwart Valkyrie", 258, Rarity.COMMON, mage.cards.s.StalwartValkyrie.class));
        cards.add(new SetCardInfo("Star Pupil", 259, Rarity.COMMON, mage.cards.s.StarPupil.class));
        cards.add(new SetCardInfo("Starfield Mystic", 260, Rarity.RARE, mage.cards.s.StarfieldMystic.class));
        cards.add(new SetCardInfo("Starlight Snare", 9, Rarity.COMMON, mage.cards.s.StarlightSnare.class));
        cards.add(new SetCardInfo("Starlit Mantle", 366, Rarity.COMMON, mage.cards.s.StarlitMantle.class));
        cards.add(new SetCardInfo("Starnheim Courser", 261, Rarity.COMMON, mage.cards.s.StarnheimCourser.class));
        cards.add(new SetCardInfo("Starnheim Memento", 29, Rarity.UNCOMMON, mage.cards.s.StarnheimMemento.class));
        cards.add(new SetCardInfo("Steadfast Sentry", 262, Rarity.COMMON, mage.cards.s.SteadfastSentry.class));
        cards.add(new SetCardInfo("Steadfast Unicorn", 103, Rarity.COMMON, mage.cards.s.SteadfastUnicorn.class));
        cards.add(new SetCardInfo("Stinging Lionfish", 367, Rarity.UNCOMMON, mage.cards.s.StingingLionfish.class));
        cards.add(new SetCardInfo("Stitched Drake", 368, Rarity.COMMON, mage.cards.s.StitchedDrake.class));
        cards.add(new SetCardInfo("Stolen Vitality", 602, Rarity.COMMON, mage.cards.s.StolenVitality.class));
        cards.add(new SetCardInfo("Stolen by the Fae", 369, Rarity.RARE, mage.cards.s.StolenByTheFae.class));
        cards.add(new SetCardInfo("Stone Haven Outfitter", 263, Rarity.RARE, mage.cards.s.StoneHavenOutfitter.class));
        cards.add(new SetCardInfo("Stony Strength", 720, Rarity.COMMON, mage.cards.s.StonyStrength.class));
        cards.add(new SetCardInfo("Stronghold Confessor", 490, Rarity.COMMON, mage.cards.s.StrongholdConfessor.class));
        cards.add(new SetCardInfo("Subtle Strike", 491, Rarity.COMMON, mage.cards.s.SubtleStrike.class));
        cards.add(new SetCardInfo("Sudden Insight", 110, Rarity.UNCOMMON, mage.cards.s.SuddenInsight.class));
        cards.add(new SetCardInfo("Sunblade Samurai", 264, Rarity.COMMON, mage.cards.s.SunbladeSamurai.class));
        cards.add(new SetCardInfo("Sungrace Pegasus", 265, Rarity.COMMON, mage.cards.s.SungracePegasus.class));
        cards.add(new SetCardInfo("Sunhome Stalwart", 266, Rarity.UNCOMMON, mage.cards.s.SunhomeStalwart.class));
        cards.add(new SetCardInfo("Sunmane Pegasus", 267, Rarity.COMMON, mage.cards.s.SunmanePegasus.class));
        cards.add(new SetCardInfo("Sunspear Shikari", 268, Rarity.COMMON, mage.cards.s.SunspearShikari.class));
        cards.add(new SetCardInfo("Supreme Will", 370, Rarity.UNCOMMON, mage.cards.s.SupremeWill.class));
        cards.add(new SetCardInfo("Sutina, Speaker of the Tajuru", 56, Rarity.UNCOMMON, mage.cards.s.SutinaSpeakerOfTheTajuru.class));
        cards.add(new SetCardInfo("Swamp", 87, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swarm of Bloodflies", 492, Rarity.UNCOMMON, mage.cards.s.SwarmOfBloodflies.class));
        cards.add(new SetCardInfo("Swift Response", 269, Rarity.COMMON, mage.cards.s.SwiftResponse.class));
        cards.add(new SetCardInfo("Syr Elenora, the Discerning", 64, Rarity.UNCOMMON, mage.cards.s.SyrElenoraTheDiscerning.class));
        cards.add(new SetCardInfo("Taborax, Hope's Demise", 69, Rarity.RARE, mage.cards.t.TaboraxHopesDemise.class));
        cards.add(new SetCardInfo("Taeko, the Patient Avalanche", 39, Rarity.MYTHIC, mage.cards.t.TaekoThePatientAvalanche.class));
        cards.add(new SetCardInfo("Tail Swipe", 721, Rarity.UNCOMMON, mage.cards.t.TailSwipe.class));
        cards.add(new SetCardInfo("Tajuru Pathwarden", 722, Rarity.COMMON, mage.cards.t.TajuruPathwarden.class));
        cards.add(new SetCardInfo("Take Up the Shield", 270, Rarity.COMMON, mage.cards.t.TakeUpTheShield.class));
        cards.add(new SetCardInfo("Teferi's Ageless Insight", 371, Rarity.RARE, mage.cards.t.TeferisAgelessInsight.class));
        cards.add(new SetCardInfo("Tenacity", 104, Rarity.UNCOMMON, mage.cards.t.Tenacity.class));
        cards.add(new SetCardInfo("Terramorphic Expanse", 156, Rarity.COMMON, mage.cards.t.TerramorphicExpanse.class));
        cards.add(new SetCardInfo("Territorial Scythecat", 723, Rarity.COMMON, mage.cards.t.TerritorialScythecat.class));
        cards.add(new SetCardInfo("Tethmos High Priest", 271, Rarity.COMMON, mage.cards.t.TethmosHighPriest.class));
        cards.add(new SetCardInfo("Thieves' Guild Enforcer", 493, Rarity.RARE, mage.cards.t.ThievesGuildEnforcer.class));
        cards.add(new SetCardInfo("Thieves' Tools", 126, Rarity.COMMON, mage.cards.t.ThievesTools.class));
        cards.add(new SetCardInfo("Thirsting Bloodlord", 494, Rarity.UNCOMMON, mage.cards.t.ThirstingBloodlord.class));
        cards.add(new SetCardInfo("Thopter Architect", 272, Rarity.UNCOMMON, mage.cards.t.ThopterArchitect.class));
        cards.add(new SetCardInfo("Thopter Mechanic", 372, Rarity.UNCOMMON, mage.cards.t.ThopterMechanic.class));
        cards.add(new SetCardInfo("Thornweald Archer", 724, Rarity.COMMON, mage.cards.t.ThornwealdArcher.class));
        cards.add(new SetCardInfo("Thought Monitor", 373, Rarity.RARE, mage.cards.t.ThoughtMonitor.class));
        cards.add(new SetCardInfo("Thoughtcast", 374, Rarity.COMMON, mage.cards.t.Thoughtcast.class));
        cards.add(new SetCardInfo("Thrashing Brontodon", 725, Rarity.UNCOMMON, mage.cards.t.ThrashingBrontodon.class));
        cards.add(new SetCardInfo("Thriving Bluff", 775, Rarity.COMMON, mage.cards.t.ThrivingBluff.class));
        cards.add(new SetCardInfo("Thriving Grove", 776, Rarity.COMMON, mage.cards.t.ThrivingGrove.class));
        cards.add(new SetCardInfo("Thriving Heath", 777, Rarity.COMMON, mage.cards.t.ThrivingHeath.class));
        cards.add(new SetCardInfo("Thriving Isle", 778, Rarity.COMMON, mage.cards.t.ThrivingIsle.class));
        cards.add(new SetCardInfo("Thriving Moor", 779, Rarity.COMMON, mage.cards.t.ThrivingMoor.class));
        cards.add(new SetCardInfo("Thryx, the Sudden Storm", 65, Rarity.RARE, mage.cards.t.ThryxTheSuddenStorm.class));
        cards.add(new SetCardInfo("Thundering Spineback", 726, Rarity.UNCOMMON, mage.cards.t.ThunderingSpineback.class));
        cards.add(new SetCardInfo("Thurid, Mare of Destiny", 33, Rarity.MYTHIC, mage.cards.t.ThuridMareOfDestiny.class));
        cards.add(new SetCardInfo("Tide Skimmer", 375, Rarity.UNCOMMON, mage.cards.t.TideSkimmer.class));
        cards.add(new SetCardInfo("Tidepool Turtle", 376, Rarity.COMMON, mage.cards.t.TidepoolTurtle.class));
        cards.add(new SetCardInfo("Time to Feed", 727, Rarity.COMMON, mage.cards.t.TimeToFeed.class));
        cards.add(new SetCardInfo("Tireless Provisioner", 728, Rarity.UNCOMMON, mage.cards.t.TirelessProvisioner.class));
        cards.add(new SetCardInfo("Tireless Tracker", 729, Rarity.RARE, mage.cards.t.TirelessTracker.class));
        cards.add(new SetCardInfo("Titan's Strength", 603, Rarity.COMMON, mage.cards.t.TitansStrength.class));
        cards.add(new SetCardInfo("Tolarian Kraken", 377, Rarity.UNCOMMON, mage.cards.t.TolarianKraken.class));
        cards.add(new SetCardInfo("Topiary Stomper", 730, Rarity.RARE, mage.cards.t.TopiaryStomper.class));
        cards.add(new SetCardInfo("Torment of Scarabs", 495, Rarity.UNCOMMON, mage.cards.t.TormentOfScarabs.class));
        cards.add(new SetCardInfo("Tough Cookie", 731, Rarity.UNCOMMON, mage.cards.t.ToughCookie.class));
        cards.add(new SetCardInfo("Towering-Wave Mystic", 378, Rarity.COMMON, mage.cards.t.ToweringWaveMystic.class));
        cards.add(new SetCardInfo("Tragic Slip", 496, Rarity.COMMON, mage.cards.t.TragicSlip.class));
        cards.add(new SetCardInfo("Trail of Crumbs", 732, Rarity.UNCOMMON, mage.cards.t.TrailOfCrumbs.class));
        cards.add(new SetCardInfo("Treasure Keeper", 760, Rarity.UNCOMMON, mage.cards.t.TreasureKeeper.class));
        cards.add(new SetCardInfo("Trial of Knowledge", 379, Rarity.UNCOMMON, mage.cards.t.TrialOfKnowledge.class));
        cards.add(new SetCardInfo("Trial of Zeal", 604, Rarity.UNCOMMON, mage.cards.t.TrialOfZeal.class));
        cards.add(new SetCardInfo("Triplicate Spirits", 273, Rarity.COMMON, mage.cards.t.TriplicateSpirits.class));
        cards.add(new SetCardInfo("Trueheart Twins", 605, Rarity.UNCOMMON, mage.cards.t.TrueheartTwins.class));
        cards.add(new SetCardInfo("Trusty Retriever", 274, Rarity.COMMON, mage.cards.t.TrustyRetriever.class));
        cards.add(new SetCardInfo("Tukatongue Thallid", 733, Rarity.COMMON, mage.cards.t.TukatongueThallid.class));
        cards.add(new SetCardInfo("Twinferno", 606, Rarity.UNCOMMON, mage.cards.t.Twinferno.class));
        cards.add(new SetCardInfo("Typhoid Rats", 497, Rarity.COMMON, mage.cards.t.TyphoidRats.class));
        cards.add(new SetCardInfo("Tyvar Kell", 734, Rarity.MYTHIC, mage.cards.t.TyvarKell.class));
        cards.add(new SetCardInfo("Ukud Cobra", 498, Rarity.UNCOMMON, mage.cards.u.UkudCobra.class));
        cards.add(new SetCardInfo("Ulcerate", 499, Rarity.UNCOMMON, mage.cards.u.Ulcerate.class));
        cards.add(new SetCardInfo("Ulvenwald Mysteries", 735, Rarity.UNCOMMON, mage.cards.u.UlvenwaldMysteries.class));
        cards.add(new SetCardInfo("Uncaged Fury", 607, Rarity.UNCOMMON, mage.cards.u.UncagedFury.class));
        cards.add(new SetCardInfo("Uncomfortable Chill", 111, Rarity.COMMON, mage.cards.u.UncomfortableChill.class));
        cards.add(new SetCardInfo("Undead Butler", 500, Rarity.UNCOMMON, mage.cards.u.UndeadButler.class));
        cards.add(new SetCardInfo("Undercellar Myconid", 150, Rarity.COMMON, mage.cards.u.UndercellarMyconid.class));
        cards.add(new SetCardInfo("Undercity Scrounger", 501, Rarity.COMMON, mage.cards.u.UndercityScrounger.class));
        cards.add(new SetCardInfo("Undergrowth Champion", 736, Rarity.MYTHIC, mage.cards.u.UndergrowthChampion.class));
        cards.add(new SetCardInfo("Undersea Invader", 380, Rarity.COMMON, mage.cards.u.UnderseaInvader.class));
        cards.add(new SetCardInfo("Universal Solvent", 761, Rarity.COMMON, mage.cards.u.UniversalSolvent.class));
        cards.add(new SetCardInfo("Unleash Fury", 608, Rarity.UNCOMMON, mage.cards.u.UnleashFury.class));
        cards.add(new SetCardInfo("Unstoppable Ogre", 609, Rarity.COMMON, mage.cards.u.UnstoppableOgre.class));
        cards.add(new SetCardInfo("Urdnan, Dromoka Warrior", 34, Rarity.UNCOMMON, mage.cards.u.UrdnanDromokaWarrior.class));
        cards.add(new SetCardInfo("Urge to Feed", 502, Rarity.UNCOMMON, mage.cards.u.UrgeToFeed.class));
        cards.add(new SetCardInfo("Valkyrie Harbinger", 275, Rarity.RARE, mage.cards.v.ValkyrieHarbinger.class));
        cards.add(new SetCardInfo("Valkyrie's Sword", 276, Rarity.UNCOMMON, mage.cards.v.ValkyriesSword.class));
        cards.add(new SetCardInfo("Valorous Stance", 277, Rarity.UNCOMMON, mage.cards.v.ValorousStance.class));
        cards.add(new SetCardInfo("Vampire Nighthawk", 503, Rarity.UNCOMMON, mage.cards.v.VampireNighthawk.class));
        cards.add(new SetCardInfo("Vampire Scrivener", 505, Rarity.UNCOMMON, mage.cards.v.VampireScrivener.class));
        cards.add(new SetCardInfo("Vampire of the Dire Moon", 504, Rarity.UNCOMMON, mage.cards.v.VampireOfTheDireMoon.class));
        cards.add(new SetCardInfo("Vampiric Fury", 610, Rarity.COMMON, mage.cards.v.VampiricFury.class));
        cards.add(new SetCardInfo("Vault of Whispers", 780, Rarity.COMMON, mage.cards.v.VaultOfWhispers.class));
        cards.add(new SetCardInfo("Venerated Loxodon", 278, Rarity.RARE, mage.cards.v.VeneratedLoxodon.class));
        cards.add(new SetCardInfo("Venomous Hierophant", 506, Rarity.COMMON, mage.cards.v.VenomousHierophant.class));
        cards.add(new SetCardInfo("Venser, Shaper Savant", 66, Rarity.RARE, mage.cards.v.VenserShaperSavant.class));
        cards.add(new SetCardInfo("Verdeloth the Ancient", 737, Rarity.RARE, mage.cards.v.VerdelothTheAncient.class));
        cards.add(new SetCardInfo("Vexing Gull", 381, Rarity.COMMON, mage.cards.v.VexingGull.class));
        cards.add(new SetCardInfo("Vicious Conquistador", 507, Rarity.UNCOMMON, mage.cards.v.ViciousConquistador.class));
        cards.add(new SetCardInfo("Vilis, Broker of Blood", 70, Rarity.RARE, mage.cards.v.VilisBrokerOfBlood.class));
        cards.add(new SetCardInfo("Village Rites", 508, Rarity.COMMON, mage.cards.v.VillageRites.class));
        cards.add(new SetCardInfo("Violent Outburst", 746, Rarity.COMMON, mage.cards.v.ViolentOutburst.class));
        cards.add(new SetCardInfo("Virus Beetle", 509, Rarity.COMMON, mage.cards.v.VirusBeetle.class));
        cards.add(new SetCardInfo("Vito, Thorn of the Dusk Rose", 71, Rarity.RARE, mage.cards.v.VitoThornOfTheDuskRose.class));
        cards.add(new SetCardInfo("Voice of the Woods", 738, Rarity.RARE, mage.cards.v.VoiceOfTheWoods.class));
        cards.add(new SetCardInfo("Voldaren Ambusher", 611, Rarity.UNCOMMON, mage.cards.v.VoldarenAmbusher.class));
        cards.add(new SetCardInfo("Voldaren Duelist", 612, Rarity.COMMON, mage.cards.v.VoldarenDuelist.class));
        cards.add(new SetCardInfo("Voldaren Epicure", 613, Rarity.COMMON, mage.cards.v.VoldarenEpicure.class));
        cards.add(new SetCardInfo("Volley Veteran", 142, Rarity.UNCOMMON, mage.cards.v.VolleyVeteran.class));
        cards.add(new SetCardInfo("Voracious Greatshark", 382, Rarity.RARE, mage.cards.v.VoraciousGreatshark.class));
        cards.add(new SetCardInfo("Vraska's Finisher", 510, Rarity.COMMON, mage.cards.v.VraskasFinisher.class));
        cards.add(new SetCardInfo("Wailing Ghoul", 511, Rarity.COMMON, mage.cards.w.WailingGhoul.class));
        cards.add(new SetCardInfo("Wakedancer", 512, Rarity.COMMON, mage.cards.w.Wakedancer.class));
        cards.add(new SetCardInfo("Waker of Waves", 383, Rarity.UNCOMMON, mage.cards.w.WakerOfWaves.class));
        cards.add(new SetCardInfo("Wall of Lost Thoughts", 384, Rarity.UNCOMMON, mage.cards.w.WallOfLostThoughts.class));
        cards.add(new SetCardInfo("Warbriar Blessing", 739, Rarity.COMMON, mage.cards.w.WarbriarBlessing.class));
        cards.add(new SetCardInfo("Warden of Evos Isle", 385, Rarity.UNCOMMON, mage.cards.w.WardenOfEvosIsle.class));
        cards.add(new SetCardInfo("Waterkin Shaman", 386, Rarity.COMMON, mage.cards.w.WaterkinShaman.class));
        cards.add(new SetCardInfo("Wavebreak Hippocamp", 387, Rarity.RARE, mage.cards.w.WavebreakHippocamp.class));
        cards.add(new SetCardInfo("Weaselback Redcap", 614, Rarity.COMMON, mage.cards.w.WeaselbackRedcap.class));
        cards.add(new SetCardInfo("Weaver of Lightning", 615, Rarity.UNCOMMON, mage.cards.w.WeaverOfLightning.class));
        cards.add(new SetCardInfo("Whirlermaker", 762, Rarity.UNCOMMON, mage.cards.w.Whirlermaker.class));
        cards.add(new SetCardInfo("Whirlwind Denial", 388, Rarity.UNCOMMON, mage.cards.w.WhirlwindDenial.class));
        cards.add(new SetCardInfo("Wildfire Elemental", 616, Rarity.COMMON, mage.cards.w.WildfireElemental.class));
        cards.add(new SetCardInfo("Wind Strider", 389, Rarity.COMMON, mage.cards.w.WindStrider.class));
        cards.add(new SetCardInfo("Windcaller Aven", 390, Rarity.COMMON, mage.cards.w.WindcallerAven.class));
        cards.add(new SetCardInfo("Windreader Sphinx", 391, Rarity.RARE, mage.cards.w.WindreaderSphinx.class));
        cards.add(new SetCardInfo("Windstorm Drake", 392, Rarity.UNCOMMON, mage.cards.w.WindstormDrake.class));
        cards.add(new SetCardInfo("Winged Words", 393, Rarity.COMMON, mage.cards.w.WingedWords.class));
        cards.add(new SetCardInfo("Wingsteed Rider", 279, Rarity.COMMON, mage.cards.w.WingsteedRider.class));
        cards.add(new SetCardInfo("Witching Well", 394, Rarity.COMMON, mage.cards.w.WitchingWell.class));
        cards.add(new SetCardInfo("Wolfrider's Saddle", 740, Rarity.UNCOMMON, mage.cards.w.WolfridersSaddle.class));
        cards.add(new SetCardInfo("Woodland Champion", 741, Rarity.UNCOMMON, mage.cards.w.WoodlandChampion.class));
        cards.add(new SetCardInfo("Woodland Liege", 27, Rarity.COMMON, mage.cards.w.WoodlandLiege.class));
        cards.add(new SetCardInfo("Wrecking Crew", 617, Rarity.COMMON, mage.cards.w.WreckingCrew.class));
        cards.add(new SetCardInfo("Wriggling Grub", 12, Rarity.UNCOMMON, mage.cards.w.WrigglingGrub.class));
        cards.add(new SetCardInfo("Yarok's Wavecrasher", 395, Rarity.UNCOMMON, mage.cards.y.YaroksWavecrasher.class));
        cards.add(new SetCardInfo("Young Pyromancer", 618, Rarity.UNCOMMON, mage.cards.y.YoungPyromancer.class));
        cards.add(new SetCardInfo("Youthful Valkyrie", 280, Rarity.UNCOMMON, mage.cards.y.YouthfulValkyrie.class));
        cards.add(new SetCardInfo("Zada, Hedron Grinder", 76, Rarity.RARE, mage.cards.z.ZadaHedronGrinder.class));
        cards.add(new SetCardInfo("Zealot of the God-Pharaoh", 619, Rarity.COMMON, mage.cards.z.ZealotOfTheGodPharaoh.class));
        cards.add(new SetCardInfo("Zealous Conscripts", 143, Rarity.RARE, mage.cards.z.ZealousConscripts.class));
    }
}
