package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class DoubleMasters2022 extends ExpansionSet {

    private static final DoubleMasters2022 instance = new DoubleMasters2022();

    public static DoubleMasters2022 getInstance() {
        return instance;
    }

    private DoubleMasters2022() {
        super("Double Masters 2022", "2X2", ExpansionSet.buildDate(2020, 7, 8), SetType.SUPPLEMENTAL);
        this.blockName = "Reprint";
        this.hasBasicLands = false;
        this.hasBoosters = true;
        this.numBoosterLands = 0;
        this.numBoosterCommon = 10;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 2;
        this.ratioBoosterMythic = 8;
        this.maxCardNumberInBooster = 332;

        cards.add(new SetCardInfo("Abbot of Keral Keep", 100, Rarity.RARE, mage.cards.a.AbbotOfKeralKeep.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abbot of Keral Keep", 446, Rarity.RARE, mage.cards.a.AbbotOfKeralKeep.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abzan Ascendancy", 165, Rarity.RARE, mage.cards.a.AbzanAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abzan Ascendancy", 467, Rarity.RARE, mage.cards.a.AbzanAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abzan Charm", 166, Rarity.UNCOMMON, mage.cards.a.AbzanCharm.class));
        cards.add(new SetCardInfo("Abzan Falconer", 4, Rarity.UNCOMMON, mage.cards.a.AbzanFalconer.class));
        cards.add(new SetCardInfo("Advanced Stitchwing", 36, Rarity.COMMON, mage.cards.a.AdvancedStitchwing.class));
        cards.add(new SetCardInfo("Aether Vial", 298, Rarity.RARE, mage.cards.a.AetherVial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aether Vial", 391, Rarity.RARE, mage.cards.a.AetherVial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aether Vial", 555, Rarity.RARE, mage.cards.a.AetherVial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aethermage's Touch", 167, Rarity.UNCOMMON, mage.cards.a.AethermagesTouch.class));
        cards.add(new SetCardInfo("Aethersnipe", 37, Rarity.COMMON, mage.cards.a.Aethersnipe.class));
        cards.add(new SetCardInfo("Agony Warp", 168, Rarity.COMMON, mage.cards.a.AgonyWarp.class));
        cards.add(new SetCardInfo("Ainok Bond-Kin", 5, Rarity.COMMON, mage.cards.a.AinokBondKin.class));
        cards.add(new SetCardInfo("Alesha, Who Smiles at Death", 101, Rarity.RARE, mage.cards.a.AleshaWhoSmilesAtDeath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alesha, Who Smiles at Death", 447, Rarity.RARE, mage.cards.a.AleshaWhoSmilesAtDeath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Allosaurus Shepherd", 132, Rarity.MYTHIC, mage.cards.a.AllosaurusShepherd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Allosaurus Shepherd", 365, Rarity.MYTHIC, mage.cards.a.AllosaurusShepherd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Allosaurus Shepherd", 457, Rarity.MYTHIC, mage.cards.a.AllosaurusShepherd.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ambuscade", 133, Rarity.COMMON, mage.cards.a.Ambuscade.class));
        cards.add(new SetCardInfo("Aminatou, the Fateshifter", 169, Rarity.MYTHIC, mage.cards.a.AminatouTheFateshifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aminatou, the Fateshifter", 468, Rarity.MYTHIC, mage.cards.a.AminatouTheFateshifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anger of the Gods", 102, Rarity.RARE, mage.cards.a.AngerOfTheGods.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anger of the Gods", 358, Rarity.RARE, mage.cards.a.AngerOfTheGods.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anger of the Gods", 448, Rarity.RARE, mage.cards.a.AngerOfTheGods.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anguished Unmaking", 170, Rarity.RARE, mage.cards.a.AnguishedUnmaking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anguished Unmaking", 469, Rarity.RARE, mage.cards.a.AnguishedUnmaking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animar, Soul of Elements", 171, Rarity.MYTHIC, mage.cards.a.AnimarSoulOfElements.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animar, Soul of Elements", 470, Rarity.MYTHIC, mage.cards.a.AnimarSoulOfElements.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Annoyed Altisaur", 134, Rarity.COMMON, mage.cards.a.AnnoyedAltisaur.class));
        cards.add(new SetCardInfo("Anointer of Valor", 6, Rarity.COMMON, mage.cards.a.AnointerOfValor.class));
        cards.add(new SetCardInfo("Arachnus Spinner", 135, Rarity.UNCOMMON, mage.cards.a.ArachnusSpinner.class));
        cards.add(new SetCardInfo("Arachnus Web", 136, Rarity.COMMON, mage.cards.a.ArachnusWeb.class));
        cards.add(new SetCardInfo("Arjun, the Shifting Flame", 172, Rarity.RARE, mage.cards.a.ArjunTheShiftingFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arjun, the Shifting Flame", 471, Rarity.RARE, mage.cards.a.ArjunTheShiftingFlame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("As Foretold", 38, Rarity.MYTHIC, mage.cards.a.AsForetold.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("As Foretold", 426, Rarity.MYTHIC, mage.cards.a.AsForetold.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashen Rider", 173, Rarity.RARE, mage.cards.a.AshenRider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashen Rider", 472, Rarity.RARE, mage.cards.a.AshenRider.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashenmoor Liege", 174, Rarity.RARE, mage.cards.a.AshenmoorLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashenmoor Liege", 473, Rarity.RARE, mage.cards.a.AshenmoorLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Assassin's Trophy", 175, Rarity.RARE, mage.cards.a.AssassinsTrophy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Assassin's Trophy", 372, Rarity.RARE, mage.cards.a.AssassinsTrophy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Assassin's Trophy", 474, Rarity.RARE, mage.cards.a.AssassinsTrophy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atarka's Command", 176, Rarity.RARE, mage.cards.a.AtarkasCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atarka's Command", 475, Rarity.RARE, mage.cards.a.AtarkasCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atla Palani, Nest Tender", 177, Rarity.RARE, mage.cards.a.AtlaPalaniNestTender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Atla Palani, Nest Tender", 476, Rarity.RARE, mage.cards.a.AtlaPalaniNestTender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Auger Spree", 178, Rarity.COMMON, mage.cards.a.AugerSpree.class));
        cards.add(new SetCardInfo("Aurelia, the Warleader", 179, Rarity.MYTHIC, mage.cards.a.AureliaTheWarleader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aurelia, the Warleader", 477, Rarity.MYTHIC, mage.cards.a.AureliaTheWarleader.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aven Initiate", 39, Rarity.COMMON, mage.cards.a.AvenInitiate.class));
        cards.add(new SetCardInfo("Azorius Chancery", 318, Rarity.UNCOMMON, mage.cards.a.AzoriusChancery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azorius Chancery", 400, Rarity.UNCOMMON, mage.cards.a.AzoriusChancery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Backdraft Hellkite", 103, Rarity.RARE, mage.cards.b.BackdraftHellkite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Backdraft Hellkite", 449, Rarity.RARE, mage.cards.b.BackdraftHellkite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balefire Liege", 180, Rarity.RARE, mage.cards.b.BalefireLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balefire Liege", 478, Rarity.RARE, mage.cards.b.BalefireLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balustrade Spy", 68, Rarity.COMMON, mage.cards.b.BalustradeSpy.class));
        cards.add(new SetCardInfo("Bant Charm", 181, Rarity.UNCOMMON, mage.cards.b.BantCharm.class));
        cards.add(new SetCardInfo("Battlefield Promotion", 7, Rarity.COMMON, mage.cards.b.BattlefieldPromotion.class));
        cards.add(new SetCardInfo("Bear's Companion", 182, Rarity.UNCOMMON, mage.cards.b.BearsCompanion.class));
        cards.add(new SetCardInfo("Bedlam Reveler", 104, Rarity.RARE, mage.cards.b.BedlamReveler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bedlam Reveler", 450, Rarity.RARE, mage.cards.b.BedlamReveler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Biogenic Upgrade", 137, Rarity.UNCOMMON, mage.cards.b.BiogenicUpgrade.class));
        cards.add(new SetCardInfo("Bitterblossom", 436, Rarity.MYTHIC, mage.cards.b.Bitterblossom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bitterblossom", 69, Rarity.MYTHIC, mage.cards.b.Bitterblossom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blazing Hellhound", 183, Rarity.UNCOMMON, mage.cards.b.BlazingHellhound.class));
        cards.add(new SetCardInfo("Blood Artist", 352, Rarity.UNCOMMON, mage.cards.b.BloodArtist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blood Artist", 70, Rarity.UNCOMMON, mage.cards.b.BloodArtist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodbraid Elf", 184, Rarity.UNCOMMON, mage.cards.b.BloodbraidElf.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodbraid Elf", 373, Rarity.UNCOMMON, mage.cards.b.BloodbraidElf.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodflow Connoisseur", 71, Rarity.COMMON, mage.cards.b.BloodflowConnoisseur.class));
        cards.add(new SetCardInfo("Bloodforged Battle-Axe", 299, Rarity.RARE, mage.cards.b.BloodforgedBattleAxe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodforged Battle-Axe", 392, Rarity.RARE, mage.cards.b.BloodforgedBattleAxe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodforged Battle-Axe", 556, Rarity.RARE, mage.cards.b.BloodforgedBattleAxe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodwater Entity", 185, Rarity.COMMON, mage.cards.b.BloodwaterEntity.class));
        cards.add(new SetCardInfo("Bloom Tender", 138, Rarity.RARE, mage.cards.b.BloomTender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloom Tender", 366, Rarity.RARE, mage.cards.b.BloomTender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloom Tender", 458, Rarity.RARE, mage.cards.b.BloomTender.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boartusk Liege", 186, Rarity.RARE, mage.cards.b.BoartuskLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boartusk Liege", 479, Rarity.RARE, mage.cards.b.BoartuskLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Body Double", 40, Rarity.UNCOMMON, mage.cards.b.BodyDouble.class));
        cards.add(new SetCardInfo("Boros Garrison", 319, Rarity.UNCOMMON, mage.cards.b.BorosGarrison.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boros Garrison", 401, Rarity.UNCOMMON, mage.cards.b.BorosGarrison.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bounty of the Luxa", 187, Rarity.UNCOMMON, mage.cards.b.BountyOfTheLuxa.class));
        cards.add(new SetCardInfo("Breakthrough", 41, Rarity.UNCOMMON, mage.cards.b.Breakthrough.class));
        cards.add(new SetCardInfo("Brindle Shoat", 139, Rarity.COMMON, mage.cards.b.BrindleShoat.class));
        cards.add(new SetCardInfo("Bring to Light", 188, Rarity.RARE, mage.cards.b.BringToLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bring to Light", 480, Rarity.RARE, mage.cards.b.BringToLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bring to Light", 579, Rarity.RARE, mage.cards.b.BringToLight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Burning-Tree Emissary", 189, Rarity.COMMON, mage.cards.b.BurningTreeEmissary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Burning-Tree Emissary", 374, Rarity.COMMON, mage.cards.b.BurningTreeEmissary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Call to the Feast", 190, Rarity.COMMON, mage.cards.c.CallToTheFeast.class));
        cards.add(new SetCardInfo("Capture Sphere", 42, Rarity.COMMON, mage.cards.c.CaptureSphere.class));
        cards.add(new SetCardInfo("Carrier Thrall", 72, Rarity.COMMON, mage.cards.c.CarrierThrall.class));
        cards.add(new SetCardInfo("Cartel Aristocrat", 191, Rarity.COMMON, mage.cards.c.CartelAristocrat.class));
        cards.add(new SetCardInfo("Cavern of Souls", 320, Rarity.MYTHIC, mage.cards.c.CavernOfSouls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cavern of Souls", 402, Rarity.MYTHIC, mage.cards.c.CavernOfSouls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cavern of Souls", 569, Rarity.MYTHIC, mage.cards.c.CavernOfSouls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Centaur Battlemaster", 140, Rarity.UNCOMMON, mage.cards.c.CentaurBattlemaster.class));
        cards.add(new SetCardInfo("Chaos Warp", 105, Rarity.RARE, mage.cards.c.ChaosWarp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chaos Warp", 359, Rarity.RARE, mage.cards.c.ChaosWarp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chaos Warp", 451, Rarity.RARE, mage.cards.c.ChaosWarp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Child of Alara", 192, Rarity.RARE, mage.cards.c.ChildOfAlara.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Child of Alara", 481, Rarity.RARE, mage.cards.c.ChildOfAlara.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chronicler of Heroes", 193, Rarity.COMMON, mage.cards.c.ChroniclerOfHeroes.class));
        cards.add(new SetCardInfo("City of Brass", 321, Rarity.RARE, mage.cards.c.CityOfBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("City of Brass", 403, Rarity.RARE, mage.cards.c.CityOfBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("City of Brass", 570, Rarity.RARE, mage.cards.c.CityOfBrass.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Civic Saber", 300, Rarity.UNCOMMON, mage.cards.c.CivicSaber.class));
        cards.add(new SetCardInfo("Coiling Oracle", 194, Rarity.COMMON, mage.cards.c.CoilingOracle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coiling Oracle", 375, Rarity.COMMON, mage.cards.c.CoilingOracle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coldsteel Heart", 301, Rarity.UNCOMMON, mage.cards.c.ColdsteelHeart.class));
        cards.add(new SetCardInfo("Conclave Mentor", 195, Rarity.UNCOMMON, mage.cards.c.ConclaveMentor.class));
        cards.add(new SetCardInfo("Concordant Crossroads", 141, Rarity.MYTHIC, mage.cards.c.ConcordantCrossroads.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Concordant Crossroads", 367, Rarity.MYTHIC, mage.cards.c.ConcordantCrossroads.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Concordant Crossroads", 459, Rarity.MYTHIC, mage.cards.c.ConcordantCrossroads.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Conqueror's Flail", 302, Rarity.RARE, mage.cards.c.ConquerorsFlail.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Conqueror's Flail", 557, Rarity.RARE, mage.cards.c.ConquerorsFlail.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Consecrated Sphinx", 345, Rarity.MYTHIC, mage.cards.c.ConsecratedSphinx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Consecrated Sphinx", 427, Rarity.MYTHIC, mage.cards.c.ConsecratedSphinx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Consecrated Sphinx", 43, Rarity.MYTHIC, mage.cards.c.ConsecratedSphinx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crackling Doom", 196, Rarity.UNCOMMON, mage.cards.c.CracklingDoom.class));
        cards.add(new SetCardInfo("Creakwood Liege", 197, Rarity.RARE, mage.cards.c.CreakwoodLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Creakwood Liege", 482, Rarity.RARE, mage.cards.c.CreakwoodLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crucible of Worlds", 303, Rarity.MYTHIC, mage.cards.c.CrucibleOfWorlds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crucible of Worlds", 393, Rarity.MYTHIC, mage.cards.c.CrucibleOfWorlds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crucible of Worlds", 558, Rarity.MYTHIC, mage.cards.c.CrucibleOfWorlds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dack's Duplicate", 198, Rarity.RARE, mage.cards.d.DacksDuplicate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dack's Duplicate", 483, Rarity.RARE, mage.cards.d.DacksDuplicate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Damnation", 353, Rarity.RARE, mage.cards.d.Damnation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Damnation", 437, Rarity.RARE, mage.cards.d.Damnation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Damnation", 73, Rarity.RARE, mage.cards.d.Damnation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dark-Dweller Oracle", 106, Rarity.COMMON, mage.cards.d.DarkDwellerOracle.class));
        cards.add(new SetCardInfo("Darksteel Plate", 304, Rarity.RARE, mage.cards.d.DarksteelPlate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Darksteel Plate", 559, Rarity.RARE, mage.cards.d.DarksteelPlate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dauntless Escort", 199, Rarity.RARE, mage.cards.d.DauntlessEscort.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dauntless Escort", 484, Rarity.RARE, mage.cards.d.DauntlessEscort.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deadly Recluse", 142, Rarity.COMMON, mage.cards.d.DeadlyRecluse.class));
        cards.add(new SetCardInfo("Deathbringer Liege", 200, Rarity.RARE, mage.cards.d.DeathbringerLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deathbringer Liege", 485, Rarity.RARE, mage.cards.d.DeathbringerLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deep Analysis", 44, Rarity.COMMON, mage.cards.d.DeepAnalysis.class));
        cards.add(new SetCardInfo("Deranged Assistant", 45, Rarity.COMMON, mage.cards.d.DerangedAssistant.class));
        cards.add(new SetCardInfo("Devoted Druid", 143, Rarity.UNCOMMON, mage.cards.d.DevotedDruid.class));
        cards.add(new SetCardInfo("Dimir Aqueduct", 322, Rarity.UNCOMMON, mage.cards.d.DimirAqueduct.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dimir Aqueduct", 404, Rarity.UNCOMMON, mage.cards.d.DimirAqueduct.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disciple of the Ring", 428, Rarity.RARE, mage.cards.d.DiscipleOfTheRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disciple of the Ring", 46, Rarity.RARE, mage.cards.d.DiscipleOfTheRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disfigure", 74, Rarity.COMMON, mage.cards.d.Disfigure.class));
        cards.add(new SetCardInfo("Divine Visitation", 416, Rarity.MYTHIC, mage.cards.d.DivineVisitation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Divine Visitation", 8, Rarity.MYTHIC, mage.cards.d.DivineVisitation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dockside Extortionist", 107, Rarity.MYTHIC, mage.cards.d.DocksideExtortionist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dockside Extortionist", 360, Rarity.MYTHIC, mage.cards.d.DocksideExtortionist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dockside Extortionist", 452, Rarity.MYTHIC, mage.cards.d.DocksideExtortionist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Domestication", 47, Rarity.UNCOMMON, mage.cards.d.Domestication.class));
        cards.add(new SetCardInfo("Doomed Traveler", 9, Rarity.COMMON, mage.cards.d.DoomedTraveler.class));
        cards.add(new SetCardInfo("Doran, the Siege Tower", 201, Rarity.RARE, mage.cards.d.DoranTheSiegeTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doran, the Siege Tower", 486, Rarity.RARE, mage.cards.d.DoranTheSiegeTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragon Arch", 305, Rarity.UNCOMMON, mage.cards.d.DragonArch.class));
        cards.add(new SetCardInfo("Dragonlord Dromoka", 202, Rarity.MYTHIC, mage.cards.d.DragonlordDromoka.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragonlord Dromoka", 376, Rarity.MYTHIC, mage.cards.d.DragonlordDromoka.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragonlord Dromoka", 487, Rarity.MYTHIC, mage.cards.d.DragonlordDromoka.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragonlord Silumgar", 203, Rarity.MYTHIC, mage.cards.d.DragonlordSilumgar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragonlord Silumgar", 488, Rarity.MYTHIC, mage.cards.d.DragonlordSilumgar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreamshaper Shaman", 108, Rarity.UNCOMMON, mage.cards.d.DreamshaperShaman.class));
        cards.add(new SetCardInfo("Dreg Mangler", 204, Rarity.COMMON, mage.cards.d.DregMangler.class));
        cards.add(new SetCardInfo("Drogskol Reaver", 205, Rarity.RARE, mage.cards.d.DrogskolReaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drogskol Reaver", 489, Rarity.RARE, mage.cards.d.DrogskolReaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dromoka's Command", 206, Rarity.RARE, mage.cards.d.DromokasCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dromoka's Command", 490, Rarity.RARE, mage.cards.d.DromokasCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eel Umbra", 48, Rarity.COMMON, mage.cards.e.EelUmbra.class));
        cards.add(new SetCardInfo("Elenda, the Dusk Rose", 207, Rarity.MYTHIC, mage.cards.e.ElendaTheDuskRose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elenda, the Dusk Rose", 377, Rarity.MYTHIC, mage.cards.e.ElendaTheDuskRose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elenda, the Dusk Rose", 491, Rarity.MYTHIC, mage.cards.e.ElendaTheDuskRose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elsha of the Infinite", 208, Rarity.RARE, mage.cards.e.ElshaOfTheInfinite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elsha of the Infinite", 492, Rarity.RARE, mage.cards.e.ElshaOfTheInfinite.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elvish Rejuvenator", 144, Rarity.COMMON, mage.cards.e.ElvishRejuvenator.class));
        cards.add(new SetCardInfo("Emiel the Blessed", 10, Rarity.MYTHIC, mage.cards.e.EmielTheBlessed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emiel the Blessed", 338, Rarity.MYTHIC, mage.cards.e.EmielTheBlessed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emiel the Blessed", 417, Rarity.MYTHIC, mage.cards.e.EmielTheBlessed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Empyrial Archangel", 209, Rarity.RARE, mage.cards.e.EmpyrialArchangel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Empyrial Archangel", 493, Rarity.RARE, mage.cards.e.EmpyrialArchangel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emrakul, the Aeons Torn", 1, Rarity.MYTHIC, mage.cards.e.EmrakulTheAeonsTorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emrakul, the Aeons Torn", 335, Rarity.MYTHIC, mage.cards.e.EmrakulTheAeonsTorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emrakul, the Aeons Torn", 413, Rarity.MYTHIC, mage.cards.e.EmrakulTheAeonsTorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emrakul, the Aeons Torn", 575, Rarity.MYTHIC, mage.cards.e.EmrakulTheAeonsTorn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eternal Witness", 145, Rarity.UNCOMMON, mage.cards.e.EternalWitness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eternal Witness", 368, Rarity.UNCOMMON, mage.cards.e.EternalWitness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Experiment One", 146, Rarity.COMMON, mage.cards.e.ExperimentOne.class));
        cards.add(new SetCardInfo("Extract from Darkness", 210, Rarity.UNCOMMON, mage.cards.e.ExtractFromDarkness.class));
        cards.add(new SetCardInfo("Eyeblight's Ending", 75, Rarity.COMMON, mage.cards.e.EyeblightsEnding.class));
        cards.add(new SetCardInfo("Ezuri, Claw of Progress", 211, Rarity.MYTHIC, mage.cards.e.EzuriClawOfProgress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ezuri, Claw of Progress", 494, Rarity.MYTHIC, mage.cards.e.EzuriClawOfProgress.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Fall", 109, Rarity.COMMON, mage.cards.f.FieryFall.class));
        cards.add(new SetCardInfo("Fiery Justice", 212, Rarity.RARE, mage.cards.f.FieryJustice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Justice", 495, Rarity.RARE, mage.cards.f.FieryJustice.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Figure of Destiny", 213, Rarity.RARE, mage.cards.f.FigureOfDestiny.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Figure of Destiny", 496, Rarity.RARE, mage.cards.f.FigureOfDestiny.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fireblade Artist", 214, Rarity.COMMON, mage.cards.f.FirebladeArtist.class));
        cards.add(new SetCardInfo("Firemind Vessel", 306, Rarity.UNCOMMON, mage.cards.f.FiremindVessel.class));
        cards.add(new SetCardInfo("Firesong and Sunspeaker", 215, Rarity.RARE, mage.cards.f.FiresongAndSunspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firesong and Sunspeaker", 497, Rarity.RARE, mage.cards.f.FiresongAndSunspeaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flickerwisp", 11, Rarity.UNCOMMON, mage.cards.f.Flickerwisp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flickerwisp", 339, Rarity.UNCOMMON, mage.cards.f.Flickerwisp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Food Chain", 147, Rarity.MYTHIC, mage.cards.f.FoodChain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Food Chain", 460, Rarity.MYTHIC, mage.cards.f.FoodChain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forbidden Alchemy", 49, Rarity.COMMON, mage.cards.f.ForbiddenAlchemy.class));
        cards.add(new SetCardInfo("Forbidden Orchard", 323, Rarity.RARE, mage.cards.f.ForbiddenOrchard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forbidden Orchard", 405, Rarity.RARE, mage.cards.f.ForbiddenOrchard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forbidden Orchard", 571, Rarity.RARE, mage.cards.f.ForbiddenOrchard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Force of Negation", 346, Rarity.RARE, mage.cards.f.ForceOfNegation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Force of Negation", 429, Rarity.RARE, mage.cards.f.ForceOfNegation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Force of Negation", 50, Rarity.RARE, mage.cards.f.ForceOfNegation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghave, Guru of Spores", 216, Rarity.MYTHIC, mage.cards.g.GhaveGuruOfSpores.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghave, Guru of Spores", 498, Rarity.MYTHIC, mage.cards.g.GhaveGuruOfSpores.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gifts Ungiven", 347, Rarity.RARE, mage.cards.g.GiftsUngiven.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gifts Ungiven", 430, Rarity.RARE, mage.cards.g.GiftsUngiven.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gifts Ungiven", 51, Rarity.RARE, mage.cards.g.GiftsUngiven.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glen Elendra Liege", 217, Rarity.RARE, mage.cards.g.GlenElendraLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glen Elendra Liege", 499, Rarity.RARE, mage.cards.g.GlenElendraLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glimpse the Unthinkable", 218, Rarity.RARE, mage.cards.g.GlimpseTheUnthinkable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glimpse the Unthinkable", 378, Rarity.RARE, mage.cards.g.GlimpseTheUnthinkable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glimpse the Unthinkable", 500, Rarity.RARE, mage.cards.g.GlimpseTheUnthinkable.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gloryscale Viashino", 219, Rarity.UNCOMMON, mage.cards.g.GloryscaleViashino.class));
        cards.add(new SetCardInfo("Glowspore Shaman", 220, Rarity.COMMON, mage.cards.g.GlowsporeShaman.class));
        cards.add(new SetCardInfo("Gnarlback Rhino", 148, Rarity.COMMON, mage.cards.g.GnarlbackRhino.class));
        cards.add(new SetCardInfo("Go for the Throat", 76, Rarity.UNCOMMON, mage.cards.g.GoForTheThroat.class));
        cards.add(new SetCardInfo("Goblin Banneret", 110, Rarity.UNCOMMON, mage.cards.g.GoblinBanneret.class));
        cards.add(new SetCardInfo("Gods Willing", 12, Rarity.COMMON, mage.cards.g.GodsWilling.class));
        cards.add(new SetCardInfo("Golgari Rot Farm", 324, Rarity.UNCOMMON, mage.cards.g.GolgariRotFarm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Golgari Rot Farm", 406, Rarity.UNCOMMON, mage.cards.g.GolgariRotFarm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Arbiter Augustin IV", 221, Rarity.RARE, mage.cards.g.GrandArbiterAugustinIV.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Arbiter Augustin IV", 379, Rarity.RARE, mage.cards.g.GrandArbiterAugustinIV.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Arbiter Augustin IV", 501, Rarity.RARE, mage.cards.g.GrandArbiterAugustinIV.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grapple with the Past", 149, Rarity.COMMON, mage.cards.g.GrappleWithThePast.class));
        cards.add(new SetCardInfo("Graveblade Marauder", 77, Rarity.UNCOMMON, mage.cards.g.GravebladeMarauder.class));
        cards.add(new SetCardInfo("Gravecrawler", 438, Rarity.RARE, mage.cards.g.Gravecrawler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gravecrawler", 78, Rarity.RARE, mage.cards.g.Gravecrawler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Greater Gargadon", 111, Rarity.RARE, mage.cards.g.GreaterGargadon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Greater Gargadon", 453, Rarity.RARE, mage.cards.g.GreaterGargadon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Green Sun's Zenith", 150, Rarity.RARE, mage.cards.g.GreenSunsZenith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Green Sun's Zenith", 461, Rarity.RARE, mage.cards.g.GreenSunsZenith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grim Flayer", 222, Rarity.RARE, mage.cards.g.GrimFlayer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grim Flayer", 380, Rarity.RARE, mage.cards.g.GrimFlayer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grim Flayer", 502, Rarity.RARE, mage.cards.g.GrimFlayer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ground Assault", 223, Rarity.COMMON, mage.cards.g.GroundAssault.class));
        cards.add(new SetCardInfo("Gruul Turf", 325, Rarity.UNCOMMON, mage.cards.g.GruulTurf.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gruul Turf", 407, Rarity.UNCOMMON, mage.cards.g.GruulTurf.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guided Passage", 224, Rarity.RARE, mage.cards.g.GuidedPassage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guided Passage", 503, Rarity.RARE, mage.cards.g.GuidedPassage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hardened Scales", 151, Rarity.RARE, mage.cards.h.HardenedScales.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hardened Scales", 369, Rarity.RARE, mage.cards.h.HardenedScales.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hardened Scales", 462, Rarity.RARE, mage.cards.h.HardenedScales.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hellkite Overlord", 225, Rarity.MYTHIC, mage.cards.h.HellkiteOverlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hellkite Overlord", 504, Rarity.MYTHIC, mage.cards.h.HellkiteOverlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hero of the Games", 112, Rarity.COMMON, mage.cards.h.HeroOfTheGames.class));
        cards.add(new SetCardInfo("Heroic Reinforcements", 226, Rarity.UNCOMMON, mage.cards.h.HeroicReinforcements.class));
        cards.add(new SetCardInfo("Hissing Iguanar", 113, Rarity.COMMON, mage.cards.h.HissingIguanar.class));
        cards.add(new SetCardInfo("Hostage Taker", 227, Rarity.RARE, mage.cards.h.HostageTaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hostage Taker", 505, Rarity.RARE, mage.cards.h.HostageTaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hydroid Krasis", 228, Rarity.RARE, mage.cards.h.HydroidKrasis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hydroid Krasis", 506, Rarity.RARE, mage.cards.h.HydroidKrasis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hyena Umbra", 13, Rarity.COMMON, mage.cards.h.HyenaUmbra.class));
        cards.add(new SetCardInfo("Imperial Seal", 354, Rarity.MYTHIC, mage.cards.i.ImperialSeal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Imperial Seal", 439, Rarity.MYTHIC, mage.cards.i.ImperialSeal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Imperial Seal", 79, Rarity.MYTHIC, mage.cards.i.ImperialSeal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Impervious Greatwurm", 152, Rarity.RARE, mage.cards.i.ImperviousGreatwurm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Impervious Greatwurm", 463, Rarity.RARE, mage.cards.i.ImperviousGreatwurm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ingenious Skaab", 52, Rarity.COMMON, mage.cards.i.IngeniousSkaab.class));
        cards.add(new SetCardInfo("Inquisition of Kozilek", 355, Rarity.UNCOMMON, mage.cards.i.InquisitionOfKozilek.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inquisition of Kozilek", 80, Rarity.UNCOMMON, mage.cards.i.InquisitionOfKozilek.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Intet, the Dreamer", 229, Rarity.RARE, mage.cards.i.IntetTheDreamer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Intet, the Dreamer", 507, Rarity.RARE, mage.cards.i.IntetTheDreamer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Boilerworks", 326, Rarity.UNCOMMON, mage.cards.i.IzzetBoilerworks.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Boilerworks", 408, Rarity.UNCOMMON, mage.cards.i.IzzetBoilerworks.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Charm", 230, Rarity.COMMON, mage.cards.i.IzzetCharm.class));
        cards.add(new SetCardInfo("Jeskai Ascendancy", 231, Rarity.RARE, mage.cards.j.JeskaiAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeskai Ascendancy", 508, Rarity.RARE, mage.cards.j.JeskaiAscendancy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeskai Charm", 232, Rarity.UNCOMMON, mage.cards.j.JeskaiCharm.class));
        cards.add(new SetCardInfo("Jeskai Elder", 53, Rarity.COMMON, mage.cards.j.JeskaiElder.class));
        cards.add(new SetCardInfo("Jodah, Archmage Eternal", 233, Rarity.RARE, mage.cards.j.JodahArchmageEternal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jodah, Archmage Eternal", 509, Rarity.RARE, mage.cards.j.JodahArchmageEternal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Judith, the Scourge Diva", 234, Rarity.RARE, mage.cards.j.JudithTheScourgeDiva.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Judith, the Scourge Diva", 510, Rarity.RARE, mage.cards.j.JudithTheScourgeDiva.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kaalia of the Vast", 235, Rarity.MYTHIC, mage.cards.k.KaaliaOfTheVast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kaalia of the Vast", 511, Rarity.MYTHIC, mage.cards.k.KaaliaOfTheVast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kaervek the Merciless", 236, Rarity.RARE, mage.cards.k.KaervekTheMerciless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kaervek the Merciless", 512, Rarity.RARE, mage.cards.k.KaervekTheMerciless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kambal, Consul of Allocation", 237, Rarity.RARE, mage.cards.k.KambalConsulOfAllocation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kambal, Consul of Allocation", 513, Rarity.RARE, mage.cards.k.KambalConsulOfAllocation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karador, Ghost Chieftain", 238, Rarity.MYTHIC, mage.cards.k.KaradorGhostChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karador, Ghost Chieftain", 514, Rarity.MYTHIC, mage.cards.k.KaradorGhostChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kasmina's Transmutation", 54, Rarity.COMMON, mage.cards.k.KasminasTransmutation.class));
        cards.add(new SetCardInfo("Kederekt Leviathan", 431, Rarity.RARE, mage.cards.k.KederektLeviathan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kederekt Leviathan", 55, Rarity.RARE, mage.cards.k.KederektLeviathan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Knightly Valor", 14, Rarity.COMMON, mage.cards.k.KnightlyValor.class));
        cards.add(new SetCardInfo("Kolaghan's Command", 239, Rarity.RARE, mage.cards.k.KolaghansCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kolaghan's Command", 381, Rarity.RARE, mage.cards.k.KolaghansCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kolaghan's Command", 515, Rarity.RARE, mage.cards.k.KolaghansCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kozilek, Butcher of Truth", 2, Rarity.MYTHIC, mage.cards.k.KozilekButcherOfTruth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kozilek, Butcher of Truth", 336, Rarity.MYTHIC, mage.cards.k.KozilekButcherOfTruth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kozilek, Butcher of Truth", 414, Rarity.MYTHIC, mage.cards.k.KozilekButcherOfTruth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kozilek, Butcher of Truth", 576, Rarity.MYTHIC, mage.cards.k.KozilekButcherOfTruth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kruin Striker", 114, Rarity.COMMON, mage.cards.k.KruinStriker.class));
        cards.add(new SetCardInfo("Labyrinth Champion", 115, Rarity.UNCOMMON, mage.cards.l.LabyrinthChampion.class));
        cards.add(new SetCardInfo("Last Breath", 15, Rarity.COMMON, mage.cards.l.LastBreath.class));
        cards.add(new SetCardInfo("Lava Coil", 116, Rarity.COMMON, mage.cards.l.LavaCoil.class));
        cards.add(new SetCardInfo("Lavalanche", 240, Rarity.RARE, mage.cards.l.Lavalanche.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lavalanche", 516, Rarity.RARE, mage.cards.l.Lavalanche.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("League Guildmage", 241, Rarity.UNCOMMON, mage.cards.l.LeagueGuildmage.class));
        cards.add(new SetCardInfo("Legion's Initiative", 242, Rarity.RARE, mage.cards.l.LegionsInitiative.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legion's Initiative", 517, Rarity.RARE, mage.cards.l.LegionsInitiative.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leonin Arbiter", 16, Rarity.RARE, mage.cards.l.LeoninArbiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leonin Arbiter", 418, Rarity.RARE, mage.cards.l.LeoninArbiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 117, Rarity.UNCOMMON, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Bolt", 361, Rarity.UNCOMMON, mage.cards.l.LightningBolt.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Helix", 243, Rarity.UNCOMMON, mage.cards.l.LightningHelix.class));
        cards.add(new SetCardInfo("Liliana's Elite", 82, Rarity.COMMON, mage.cards.l.LilianasElite.class));
        cards.add(new SetCardInfo("Liliana, the Last Hope", 333, Rarity.MYTHIC, mage.cards.l.LilianaTheLastHope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana, the Last Hope", 440, Rarity.MYTHIC, mage.cards.l.LilianaTheLastHope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana, the Last Hope", 573, Rarity.MYTHIC, mage.cards.l.LilianaTheLastHope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liliana, the Last Hope", 81, Rarity.MYTHIC, mage.cards.l.LilianaTheLastHope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Livewire Lash", 307, Rarity.UNCOMMON, mage.cards.l.LivewireLash.class));
        cards.add(new SetCardInfo("Living Lightning", 118, Rarity.COMMON, mage.cards.l.LivingLightning.class));
        cards.add(new SetCardInfo("Lord of Extinction", 244, Rarity.MYTHIC, mage.cards.l.LordOfExtinction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lord of Extinction", 518, Rarity.MYTHIC, mage.cards.l.LordOfExtinction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lotleth Troll", 245, Rarity.UNCOMMON, mage.cards.l.LotlethTroll.class));
        cards.add(new SetCardInfo("Lyev Skyknight", 246, Rarity.COMMON, mage.cards.l.LyevSkyknight.class));
        cards.add(new SetCardInfo("Magister Sphinx", 247, Rarity.RARE, mage.cards.m.MagisterSphinx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Magister Sphinx", 519, Rarity.RARE, mage.cards.m.MagisterSphinx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Makeshift Mauler", 56, Rarity.COMMON, mage.cards.m.MakeshiftMauler.class));
        cards.add(new SetCardInfo("Mana Drain", 348, Rarity.MYTHIC, mage.cards.m.ManaDrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Drain", 432, Rarity.MYTHIC, mage.cards.m.ManaDrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Drain", 57, Rarity.MYTHIC, mage.cards.m.ManaDrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Leak", 58, Rarity.COMMON, mage.cards.m.ManaLeak.class));
        cards.add(new SetCardInfo("Mana Vault", 308, Rarity.MYTHIC, mage.cards.m.ManaVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Vault", 394, Rarity.MYTHIC, mage.cards.m.ManaVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Vault", 560, Rarity.MYTHIC, mage.cards.m.ManaVault.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Marchesa, the Black Rose", 248, Rarity.RARE, mage.cards.m.MarchesaTheBlackRose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Marchesa, the Black Rose", 382, Rarity.RARE, mage.cards.m.MarchesaTheBlackRose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Marchesa, the Black Rose", 520, Rarity.RARE, mage.cards.m.MarchesaTheBlackRose.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Martial Glory", 249, Rarity.COMMON, mage.cards.m.MartialGlory.class));
        cards.add(new SetCardInfo("Master Biomancer", 250, Rarity.RARE, mage.cards.m.MasterBiomancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Master Biomancer", 521, Rarity.RARE, mage.cards.m.MasterBiomancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Master of Cruelties", 251, Rarity.MYTHIC, mage.cards.m.MasterOfCruelties.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Master of Cruelties", 522, Rarity.MYTHIC, mage.cards.m.MasterOfCruelties.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mathas, Fiend Seeker", 252, Rarity.RARE, mage.cards.m.MathasFiendSeeker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mathas, Fiend Seeker", 523, Rarity.RARE, mage.cards.m.MathasFiendSeeker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mayael's Aria", 253, Rarity.RARE, mage.cards.m.MayaelsAria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mayael's Aria", 524, Rarity.RARE, mage.cards.m.MayaelsAria.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mentor of the Meek", 17, Rarity.UNCOMMON, mage.cards.m.MentorOfTheMeek.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mentor of the Meek", 340, Rarity.UNCOMMON, mage.cards.m.MentorOfTheMeek.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Might of Old Krosa", 153, Rarity.COMMON, mage.cards.m.MightOfOldKrosa.class));
        cards.add(new SetCardInfo("Mikaeus, the Lunarch", 18, Rarity.RARE, mage.cards.m.MikaeusTheLunarch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mikaeus, the Lunarch", 419, Rarity.RARE, mage.cards.m.MikaeusTheLunarch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Militia Bugler", 19, Rarity.COMMON, mage.cards.m.MilitiaBugler.class));
        cards.add(new SetCardInfo("Mindwrack Liege", 255, Rarity.RARE, mage.cards.m.MindwrackLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mindwrack Liege", 526, Rarity.RARE, mage.cards.m.MindwrackLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mistfire Adept", 59, Rarity.UNCOMMON, mage.cards.m.MistfireAdept.class));
        cards.add(new SetCardInfo("Mistmeadow Witch", 256, Rarity.UNCOMMON, mage.cards.m.MistmeadowWitch.class));
        cards.add(new SetCardInfo("Mizzix of the Izmagnus", 257, Rarity.MYTHIC, mage.cards.m.MizzixOfTheIzmagnus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mizzix of the Izmagnus", 527, Rarity.MYTHIC, mage.cards.m.MizzixOfTheIzmagnus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Momentary Blink", 20, Rarity.COMMON, mage.cards.m.MomentaryBlink.class));
        cards.add(new SetCardInfo("Monastery Mentor", 21, Rarity.MYTHIC, mage.cards.m.MonasteryMentor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Monastery Mentor", 420, Rarity.MYTHIC, mage.cards.m.MonasteryMentor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Monastery Swiftspear", 119, Rarity.COMMON, mage.cards.m.MonasterySwiftspear.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Monastery Swiftspear", 362, Rarity.COMMON, mage.cards.m.MonasterySwiftspear.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Muldrotha, the Gravetide", 258, Rarity.MYTHIC, mage.cards.m.MuldrothaTheGravetide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Muldrotha, the Gravetide", 384, Rarity.MYTHIC, mage.cards.m.MuldrothaTheGravetide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Muldrotha, the Gravetide", 528, Rarity.MYTHIC, mage.cards.m.MuldrothaTheGravetide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mulldrifter", 349, Rarity.UNCOMMON, mage.cards.m.Mulldrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mulldrifter", 60, Rarity.UNCOMMON, mage.cards.m.Mulldrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Murkfiend Liege", 259, Rarity.RARE, mage.cards.m.MurkfiendLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Murkfiend Liege", 529, Rarity.RARE, mage.cards.m.MurkfiendLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Myth Realized", 22, Rarity.UNCOMMON, mage.cards.m.MythRealized.class));
        cards.add(new SetCardInfo("Necrotic Ooze", 441, Rarity.RARE, mage.cards.n.NecroticOoze.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Necrotic Ooze", 83, Rarity.RARE, mage.cards.n.NecroticOoze.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nephalia Smuggler", 61, Rarity.UNCOMMON, mage.cards.n.NephaliaSmuggler.class));
        cards.add(new SetCardInfo("Nicol Bolas, God-Pharaoh", 260, Rarity.MYTHIC, mage.cards.n.NicolBolasGodPharaoh.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nicol Bolas, God-Pharaoh", 530, Rarity.MYTHIC, mage.cards.n.NicolBolasGodPharaoh.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nim Deathmantle", 309, Rarity.RARE, mage.cards.n.NimDeathmantle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nim Deathmantle", 561, Rarity.RARE, mage.cards.n.NimDeathmantle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, Unshackled", 442, Rarity.RARE, mage.cards.o.ObNixilisUnshackled.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis, Unshackled", 84, Rarity.RARE, mage.cards.o.ObNixilisUnshackled.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oona's Prowler", 443, Rarity.RARE, mage.cards.o.OonasProwler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oona's Prowler", 85, Rarity.RARE, mage.cards.o.OonasProwler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oracle of Mul Daya", 154, Rarity.RARE, mage.cards.o.OracleOfMulDaya.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oracle of Mul Daya", 370, Rarity.RARE, mage.cards.o.OracleOfMulDaya.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oracle of Mul Daya", 464, Rarity.RARE, mage.cards.o.OracleOfMulDaya.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orzhov Basilica", 327, Rarity.UNCOMMON, mage.cards.o.OrzhovBasilica.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orzhov Basilica", 409, Rarity.UNCOMMON, mage.cards.o.OrzhovBasilica.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Orzhov Pontiff", 261, Rarity.UNCOMMON, mage.cards.o.OrzhovPontiff.class));
        cards.add(new SetCardInfo("Panharmonicon", 310, Rarity.RARE, mage.cards.p.Panharmonicon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Panharmonicon", 395, Rarity.RARE, mage.cards.p.Panharmonicon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Panharmonicon", 562, Rarity.RARE, mage.cards.p.Panharmonicon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Path to Exile", 23, Rarity.UNCOMMON, mage.cards.p.PathToExile.class));
        cards.add(new SetCardInfo("Phyrexian Altar", 311, Rarity.RARE, mage.cards.p.PhyrexianAltar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phyrexian Altar", 396, Rarity.RARE, mage.cards.p.PhyrexianAltar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phyrexian Altar", 563, Rarity.RARE, mage.cards.p.PhyrexianAltar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phyrexian Tyranny", 262, Rarity.RARE, mage.cards.p.PhyrexianTyranny.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phyrexian Tyranny", 531, Rarity.RARE, mage.cards.p.PhyrexianTyranny.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pillar of the Paruns", 328, Rarity.RARE, mage.cards.p.PillarOfTheParuns.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pillar of the Paruns", 572, Rarity.RARE, mage.cards.p.PillarOfTheParuns.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pirate's Pillage", 120, Rarity.COMMON, mage.cards.p.PiratesPillage.class));
        cards.add(new SetCardInfo("Pithing Needle", 312, Rarity.RARE, mage.cards.p.PithingNeedle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pithing Needle", 397, Rarity.RARE, mage.cards.p.PithingNeedle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pithing Needle", 564, Rarity.RARE, mage.cards.p.PithingNeedle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Planar Bridge", 313, Rarity.RARE, mage.cards.p.PlanarBridge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Planar Bridge", 565, Rarity.RARE, mage.cards.p.PlanarBridge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Privileged Position", 263, Rarity.RARE, mage.cards.p.PrivilegedPosition.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Privileged Position", 385, Rarity.RARE, mage.cards.p.PrivilegedPosition.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Privileged Position", 532, Rarity.RARE, mage.cards.p.PrivilegedPosition.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prized Amalgam", 264, Rarity.RARE, mage.cards.p.PrizedAmalgam.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prized Amalgam", 533, Rarity.RARE, mage.cards.p.PrizedAmalgam.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prophetic Bolt", 265, Rarity.UNCOMMON, mage.cards.p.PropheticBolt.class));
        cards.add(new SetCardInfo("Psychic Symbiont", 266, Rarity.UNCOMMON, mage.cards.p.PsychicSymbiont.class));
        cards.add(new SetCardInfo("Pull from Tomorrow", 433, Rarity.RARE, mage.cards.p.PullFromTomorrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pull from Tomorrow", 62, Rarity.RARE, mage.cards.p.PullFromTomorrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Purphoros's Emissary", 121, Rarity.COMMON, mage.cards.p.PurphorossEmissary.class));
        cards.add(new SetCardInfo("Qasali Pridemage", 267, Rarity.COMMON, mage.cards.q.QasaliPridemage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Qasali Pridemage", 386, Rarity.COMMON, mage.cards.q.QasaliPridemage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rafiq of the Many", 268, Rarity.RARE, mage.cards.r.RafiqOfTheMany.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rafiq of the Many", 534, Rarity.RARE, mage.cards.r.RafiqOfTheMany.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakdos Carnarium", 329, Rarity.UNCOMMON, mage.cards.r.RakdosCarnarium.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakdos Carnarium", 410, Rarity.UNCOMMON, mage.cards.r.RakdosCarnarium.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rampant Growth", 155, Rarity.COMMON, mage.cards.r.RampantGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rampant Growth", 371, Rarity.COMMON, mage.cards.r.RampantGrowth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rancor", 156, Rarity.UNCOMMON, mage.cards.r.Rancor.class));
        cards.add(new SetCardInfo("Relief Captain", 24, Rarity.COMMON, mage.cards.r.ReliefCaptain.class));
        cards.add(new SetCardInfo("Restoration Angel", 25, Rarity.RARE, mage.cards.r.RestorationAngel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Restoration Angel", 421, Rarity.RARE, mage.cards.r.RestorationAngel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reveillark", 26, Rarity.RARE, mage.cards.r.Reveillark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reveillark", 422, Rarity.RARE, mage.cards.r.Reveillark.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rift Bolt", 122, Rarity.COMMON, mage.cards.r.RiftBolt.class));
        cards.add(new SetCardInfo("Rishkar, Peema Renegade", 157, Rarity.RARE, mage.cards.r.RishkarPeemaRenegade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rishkar, Peema Renegade", 465, Rarity.RARE, mage.cards.r.RishkarPeemaRenegade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("River Hoopoe", 269, Rarity.UNCOMMON, mage.cards.r.RiverHoopoe.class));
        cards.add(new SetCardInfo("Roon of the Hidden Realm", 270, Rarity.RARE, mage.cards.r.RoonOfTheHiddenRealm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Roon of the Hidden Realm", 535, Rarity.RARE, mage.cards.r.RoonOfTheHiddenRealm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ruric Thar, the Unbowed", 271, Rarity.RARE, mage.cards.r.RuricTharTheUnbowed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ruric Thar, the Unbowed", 536, Rarity.RARE, mage.cards.r.RuricTharTheUnbowed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scab-Clan Giant", 272, Rarity.UNCOMMON, mage.cards.s.ScabClanGiant.class));
        cards.add(new SetCardInfo("Scale Blessing", 27, Rarity.UNCOMMON, mage.cards.s.ScaleBlessing.class));
        cards.add(new SetCardInfo("Scion of Darkness", 86, Rarity.UNCOMMON, mage.cards.s.ScionOfDarkness.class));
        cards.add(new SetCardInfo("Seasoned Pyromancer", 123, Rarity.MYTHIC, mage.cards.s.SeasonedPyromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seasoned Pyromancer", 363, Rarity.MYTHIC, mage.cards.s.SeasonedPyromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seasoned Pyromancer", 454, Rarity.MYTHIC, mage.cards.s.SeasonedPyromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sedraxis Specter", 273, Rarity.UNCOMMON, mage.cards.s.SedraxisSpecter.class));
        cards.add(new SetCardInfo("Sedris, the Traitor King", 274, Rarity.MYTHIC, mage.cards.s.SedrisTheTraitorKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sedris, the Traitor King", 387, Rarity.MYTHIC, mage.cards.s.SedrisTheTraitorKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sedris, the Traitor King", 537, Rarity.MYTHIC, mage.cards.s.SedrisTheTraitorKing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seeker of the Way", 28, Rarity.COMMON, mage.cards.s.SeekerOfTheWay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seeker of the Way", 341, Rarity.COMMON, mage.cards.s.SeekerOfTheWay.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seekers' Squire", 87, Rarity.COMMON, mage.cards.s.SeekersSquire.class));
        cards.add(new SetCardInfo("Selesnya Sanctuary", 330, Rarity.UNCOMMON, mage.cards.s.SelesnyaSanctuary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selesnya Sanctuary", 411, Rarity.UNCOMMON, mage.cards.s.SelesnyaSanctuary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sensei's Divining Top", 314, Rarity.RARE, mage.cards.s.SenseisDiviningTop.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sensei's Divining Top", 398, Rarity.RARE, mage.cards.s.SenseisDiviningTop.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sensei's Divining Top", 566, Rarity.RARE, mage.cards.s.SenseisDiviningTop.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sensor Splicer", 29, Rarity.COMMON, mage.cards.s.SensorSplicer.class));
        cards.add(new SetCardInfo("Settle Beyond Reality", 30, Rarity.COMMON, mage.cards.s.SettleBeyondReality.class));
        cards.add(new SetCardInfo("Severed Strands", 88, Rarity.COMMON, mage.cards.s.SeveredStrands.class));
        cards.add(new SetCardInfo("Shadowborn Apostle", 89, Rarity.COMMON, mage.cards.s.ShadowbornApostle.class));
        cards.add(new SetCardInfo("Shattergang Brothers", 275, Rarity.RARE, mage.cards.s.ShattergangBrothers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shattergang Brothers", 538, Rarity.RARE, mage.cards.s.ShattergangBrothers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sidisi, Brood Tyrant", 276, Rarity.RARE, mage.cards.s.SidisiBroodTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sidisi, Brood Tyrant", 539, Rarity.RARE, mage.cards.s.SidisiBroodTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simic Growth Chamber", 331, Rarity.UNCOMMON, mage.cards.s.SimicGrowthChamber.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Simic Growth Chamber", 412, Rarity.UNCOMMON, mage.cards.s.SimicGrowthChamber.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skeleton Archer", 90, Rarity.COMMON, mage.cards.s.SkeletonArcher.class));
        cards.add(new SetCardInfo("Skinrender", 91, Rarity.UNCOMMON, mage.cards.s.Skinrender.class));
        cards.add(new SetCardInfo("Skullbriar, the Walking Grave", 277, Rarity.RARE, mage.cards.s.SkullbriarTheWalkingGrave.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skullbriar, the Walking Grave", 540, Rarity.RARE, mage.cards.s.SkullbriarTheWalkingGrave.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smothering Tithe", 31, Rarity.RARE, mage.cards.s.SmotheringTithe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smothering Tithe", 342, Rarity.RARE, mage.cards.s.SmotheringTithe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smothering Tithe", 423, Rarity.RARE, mage.cards.s.SmotheringTithe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sparkmage's Gambit", 124, Rarity.COMMON, mage.cards.s.SparkmagesGambit.class));
        cards.add(new SetCardInfo("Spell Pierce", 350, Rarity.COMMON, mage.cards.s.SpellPierce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spell Pierce", 63, Rarity.COMMON, mage.cards.s.SpellPierce.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spider Spawning", 158, Rarity.UNCOMMON, mage.cards.s.SpiderSpawning.class));
        cards.add(new SetCardInfo("Splinterfright", 159, Rarity.RARE, mage.cards.s.Splinterfright.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Splinterfright", 466, Rarity.RARE, mage.cards.s.Splinterfright.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sprouting Thrinax", 278, Rarity.UNCOMMON, mage.cards.s.SproutingThrinax.class));
        cards.add(new SetCardInfo("Staggershock", 125, Rarity.UNCOMMON, mage.cards.s.Staggershock.class));
        cards.add(new SetCardInfo("Storm Fleet Pyromancer", 126, Rarity.COMMON, mage.cards.s.StormFleetPyromancer.class));
        cards.add(new SetCardInfo("Strands of Undeath", 92, Rarity.COMMON, mage.cards.s.StrandsOfUndeath.class));
        cards.add(new SetCardInfo("Sultai Soothsayer", 279, Rarity.UNCOMMON, mage.cards.s.SultaiSoothsayer.class));
        cards.add(new SetCardInfo("Summer Bloom", 160, Rarity.UNCOMMON, mage.cards.s.SummerBloom.class));
        cards.add(new SetCardInfo("Supernatural Stamina", 93, Rarity.COMMON, mage.cards.s.SupernaturalStamina.class));
        cards.add(new SetCardInfo("Supreme Verdict", 280, Rarity.RARE, mage.cards.s.SupremeVerdict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Supreme Verdict", 388, Rarity.RARE, mage.cards.s.SupremeVerdict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Supreme Verdict", 541, Rarity.RARE, mage.cards.s.SupremeVerdict.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Surgical Extraction", 356, Rarity.RARE, mage.cards.s.SurgicalExtraction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Surgical Extraction", 444, Rarity.RARE, mage.cards.s.SurgicalExtraction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Surgical Extraction", 94, Rarity.RARE, mage.cards.s.SurgicalExtraction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Surreal Memoir", 127, Rarity.UNCOMMON, mage.cards.s.SurrealMemoir.class));
        cards.add(new SetCardInfo("Talrand, Sky Summoner", 434, Rarity.RARE, mage.cards.t.TalrandSkySummoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Talrand, Sky Summoner", 64, Rarity.RARE, mage.cards.t.TalrandSkySummoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tariel, Reckoner of Souls", 281, Rarity.RARE, mage.cards.t.TarielReckonerOfSouls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tariel, Reckoner of Souls", 542, Rarity.RARE, mage.cards.t.TarielReckonerOfSouls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi's Protection", 32, Rarity.RARE, mage.cards.t.TeferisProtection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi's Protection", 343, Rarity.RARE, mage.cards.t.TeferisProtection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi's Protection", 424, Rarity.RARE, mage.cards.t.TeferisProtection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teneb, the Harvester", 282, Rarity.RARE, mage.cards.t.TenebTheHarvester.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teneb, the Harvester", 543, Rarity.RARE, mage.cards.t.TenebTheHarvester.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tenth District Legionnaire", 283, Rarity.COMMON, mage.cards.t.TenthDistrictLegionnaire.class));
        cards.add(new SetCardInfo("Terminate", 284, Rarity.UNCOMMON, mage.cards.t.Terminate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terminate", 389, Rarity.UNCOMMON, mage.cards.t.Terminate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Mimeoplasm", 254, Rarity.RARE, mage.cards.t.TheMimeoplasm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Mimeoplasm", 383, Rarity.RARE, mage.cards.t.TheMimeoplasm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Mimeoplasm", 525, Rarity.RARE, mage.cards.t.TheMimeoplasm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thistledown Liege", 285, Rarity.RARE, mage.cards.t.ThistledownLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thistledown Liege", 544, Rarity.RARE, mage.cards.t.ThistledownLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thought Scour", 351, Rarity.COMMON, mage.cards.t.ThoughtScour.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thought Scour", 65, Rarity.COMMON, mage.cards.t.ThoughtScour.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thousand-Year Storm", 286, Rarity.RARE, mage.cards.t.ThousandYearStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thousand-Year Storm", 390, Rarity.RARE, mage.cards.t.ThousandYearStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thousand-Year Storm", 545, Rarity.RARE, mage.cards.t.ThousandYearStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thraximundar", 287, Rarity.RARE, mage.cards.t.Thraximundar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thraximundar", 546, Rarity.RARE, mage.cards.t.Thraximundar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thrive", 161, Rarity.COMMON, mage.cards.t.Thrive.class));
        cards.add(new SetCardInfo("Thrumming Stone", 315, Rarity.RARE, mage.cards.t.ThrummingStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thrumming Stone", 567, Rarity.RARE, mage.cards.t.ThrummingStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Titan's Strength", 128, Rarity.COMMON, mage.cards.t.TitansStrength.class));
        cards.add(new SetCardInfo("Tower Gargoyle", 288, Rarity.UNCOMMON, mage.cards.t.TowerGargoyle.class));
        cards.add(new SetCardInfo("Travel Preparations", 162, Rarity.UNCOMMON, mage.cards.t.TravelPreparations.class));
        cards.add(new SetCardInfo("Traveler's Amulet", 316, Rarity.COMMON, mage.cards.t.TravelersAmulet.class));
        cards.add(new SetCardInfo("Tuskguard Captain", 163, Rarity.COMMON, mage.cards.t.TuskguardCaptain.class));
        cards.add(new SetCardInfo("Twinflame", 129, Rarity.RARE, mage.cards.t.Twinflame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Twinflame", 455, Rarity.RARE, mage.cards.t.Twinflame.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulamog, the Infinite Gyre", 3, Rarity.MYTHIC, mage.cards.u.UlamogTheInfiniteGyre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulamog, the Infinite Gyre", 337, Rarity.MYTHIC, mage.cards.u.UlamogTheInfiniteGyre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulamog, the Infinite Gyre", 415, Rarity.MYTHIC, mage.cards.u.UlamogTheInfiniteGyre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulamog, the Infinite Gyre", 577, Rarity.MYTHIC, mage.cards.u.UlamogTheInfiniteGyre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulasht, the Hate Seed", 289, Rarity.RARE, mage.cards.u.UlashtTheHateSeed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulasht, the Hate Seed", 547, Rarity.RARE, mage.cards.u.UlashtTheHateSeed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unburial Rites", 95, Rarity.UNCOMMON, mage.cards.u.UnburialRites.class));
        cards.add(new SetCardInfo("Unearth", 357, Rarity.COMMON, mage.cards.u.Unearth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unearth", 96, Rarity.COMMON, mage.cards.u.Unearth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Uril, the Miststalker", 290, Rarity.MYTHIC, mage.cards.u.UrilTheMiststalker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Uril, the Miststalker", 548, Rarity.MYTHIC, mage.cards.u.UrilTheMiststalker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vampire Sovereign", 97, Rarity.COMMON, mage.cards.v.VampireSovereign.class));
        cards.add(new SetCardInfo("Vampiric Rites", 98, Rarity.UNCOMMON, mage.cards.v.VampiricRites.class));
        cards.add(new SetCardInfo("Varina, Lich Queen", 291, Rarity.RARE, mage.cards.v.VarinaLichQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Varina, Lich Queen", 549, Rarity.RARE, mage.cards.v.VarinaLichQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vedalken Orrery", 317, Rarity.RARE, mage.cards.v.VedalkenOrrery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vedalken Orrery", 399, Rarity.RARE, mage.cards.v.VedalkenOrrery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vedalken Orrery", 568, Rarity.RARE, mage.cards.v.VedalkenOrrery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Venser, Shaper Savant", 435, Rarity.RARE, mage.cards.v.VenserShaperSavant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Venser, Shaper Savant", 66, Rarity.RARE, mage.cards.v.VenserShaperSavant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Villainous Wealth", 292, Rarity.RARE, mage.cards.v.VillainousWealth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Villainous Wealth", 550, Rarity.RARE, mage.cards.v.VillainousWealth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Omens", 33, Rarity.UNCOMMON, mage.cards.w.WallOfOmens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Omens", 344, Rarity.UNCOMMON, mage.cards.w.WallOfOmens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warrior's Oath", 130, Rarity.MYTHIC, mage.cards.w.WarriorsOath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warrior's Oath", 456, Rarity.MYTHIC, mage.cards.w.WarriorsOath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wash Out", 67, Rarity.UNCOMMON, mage.cards.w.WashOut.class));
        cards.add(new SetCardInfo("Wasitora, Nekoru Queen", 293, Rarity.RARE, mage.cards.w.WasitoraNekoruQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wasitora, Nekoru Queen", 551, Rarity.RARE, mage.cards.w.WasitoraNekoruQueen.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Weathered Wayfarer", 34, Rarity.RARE, mage.cards.w.WeatheredWayfarer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Weathered Wayfarer", 425, Rarity.RARE, mage.cards.w.WeatheredWayfarer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Weathered Wayfarer", 578, Rarity.RARE, mage.cards.w.WeatheredWayfarer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Webweaver Changeling", 164, Rarity.COMMON, mage.cards.w.WebweaverChangeling.class));
        cards.add(new SetCardInfo("Wilt-Leaf Liege", 294, Rarity.RARE, mage.cards.w.WiltLeafLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wilt-Leaf Liege", 552, Rarity.RARE, mage.cards.w.WiltLeafLiege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Winged Coatl", 295, Rarity.COMMON, mage.cards.w.WingedCoatl.class));
        cards.add(new SetCardInfo("Wingsteed Rider", 35, Rarity.COMMON, mage.cards.w.WingsteedRider.class));
        cards.add(new SetCardInfo("Wrenn and Six", 296, Rarity.MYTHIC, mage.cards.w.WrennAndSix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrenn and Six", 334, Rarity.MYTHIC, mage.cards.w.WrennAndSix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrenn and Six", 553, Rarity.MYTHIC, mage.cards.w.WrennAndSix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrenn and Six", 574, Rarity.MYTHIC, mage.cards.w.WrennAndSix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yahenni, Undying Partisan", 445, Rarity.RARE, mage.cards.y.YahenniUndyingPartisan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yahenni, Undying Partisan", 99, Rarity.RARE, mage.cards.y.YahenniUndyingPartisan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Young Pyromancer", 131, Rarity.UNCOMMON, mage.cards.y.YoungPyromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Young Pyromancer", 364, Rarity.UNCOMMON, mage.cards.y.YoungPyromancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zur the Enchanter", 297, Rarity.RARE, mage.cards.z.ZurTheEnchanter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zur the Enchanter", 554, Rarity.RARE, mage.cards.z.ZurTheEnchanter.class, NON_FULL_USE_VARIOUS));
    }
}
