package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class DoctorWho extends ExpansionSet {

    private static final DoctorWho instance = new DoctorWho();

    public static DoctorWho getInstance() {
        return instance;
    }

    private DoctorWho() {
        super("Doctor Who", "WHO", ExpansionSet.buildDate(2023, 10, 13), SetType.SUPPLEMENTAL);

        cards.add(new SetCardInfo("Ace, Fearless Rebel", 98, Rarity.RARE, mage.cards.a.AceFearlessRebel.class));
        cards.add(new SetCardInfo("Ace's Baseball Bat", 170, Rarity.RARE, mage.cards.a.AcesBaseballBat.class));
        cards.add(new SetCardInfo("Adipose Offspring", 10, Rarity.RARE, mage.cards.a.AdiposeOffspring.class));
        cards.add(new SetCardInfo("Adric, Mathematical Genius", 33, Rarity.RARE, mage.cards.a.AdricMathematicalGenius.class));
        cards.add(new SetCardInfo("Alistair, the Brigadier", 112, Rarity.RARE, mage.cards.a.AlistairTheBrigadier.class));
        cards.add(new SetCardInfo("All of History, All at Once", 34, Rarity.RARE, mage.cards.a.AllOfHistoryAllAtOnce.class));
        cards.add(new SetCardInfo("Amy Pond", 75, Rarity.RARE, mage.cards.a.AmyPond.class));
        cards.add(new SetCardInfo("An Unearthly Child", 35, Rarity.RARE, mage.cards.a.AnUnearthlyChild.class));
        cards.add(new SetCardInfo("Arcane Signet", 239, Rarity.COMMON, mage.cards.a.ArcaneSignet.class));
        cards.add(new SetCardInfo("As Foretold", 214, Rarity.RARE, mage.cards.a.AsForetold.class));
        cards.add(new SetCardInfo("Ash Barrens", 257, Rarity.UNCOMMON, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Astrid Peth", 11, Rarity.RARE, mage.cards.a.AstridPeth.class));
        cards.add(new SetCardInfo("Atraxi Warden", 12, Rarity.UNCOMMON, mage.cards.a.AtraxiWarden.class));
        cards.add(new SetCardInfo("Auton Soldier", 36, Rarity.RARE, mage.cards.a.AutonSoldier.class));
        cards.add(new SetCardInfo("Banish to Another Universe", 13, Rarity.UNCOMMON, mage.cards.b.BanishToAnotherUniverse.class));
        cards.add(new SetCardInfo("Beast Within", 228, Rarity.UNCOMMON, mage.cards.b.BeastWithin.class));
        cards.add(new SetCardInfo("Become the Pilot", 37, Rarity.RARE, mage.cards.b.BecomeThePilot.class));
        cards.add(new SetCardInfo("Bessie, the Doctor's Roadster", 171, Rarity.RARE, mage.cards.b.BessieTheDoctorsRoadster.class));
        cards.add(new SetCardInfo("Bigger on the Inside", 115, Rarity.UNCOMMON, mage.cards.b.BiggerOnTheInside.class));
        cards.add(new SetCardInfo("Blasphemous Act", 224, Rarity.RARE, mage.cards.b.BlasphemousAct.class));
        cards.add(new SetCardInfo("Canopy Vista", 258, Rarity.RARE, mage.cards.c.CanopyVista.class));
        cards.add(new SetCardInfo("Canyon Slough", 259, Rarity.RARE, mage.cards.c.CanyonSlough.class));
        cards.add(new SetCardInfo("Carpet of Flowers", 229, Rarity.RARE, mage.cards.c.CarpetOfFlowers.class));
        cards.add(new SetCardInfo("Celestial Colonnade", 260, Rarity.RARE, mage.cards.c.CelestialColonnade.class));
        cards.add(new SetCardInfo("Chaos Warp", 225, Rarity.RARE, mage.cards.c.ChaosWarp.class));
        cards.add(new SetCardInfo("Choked Estuary", 261, Rarity.RARE, mage.cards.c.ChokedEstuary.class));
        cards.add(new SetCardInfo("Cinder Glade", 262, Rarity.RARE, mage.cards.c.CinderGlade.class));
        cards.add(new SetCardInfo("City of Death", 99, Rarity.RARE, mage.cards.c.CityOfDeath.class));
        cards.add(new SetCardInfo("Clara Oswald", 9, Rarity.RARE, mage.cards.c.ClaraOswald.class));
        cards.add(new SetCardInfo("Clockspinning", 215, Rarity.COMMON, mage.cards.c.Clockspinning.class));
        cards.add(new SetCardInfo("Clockwork Droid", 172, Rarity.UNCOMMON, mage.cards.c.ClockworkDroid.class));
        cards.add(new SetCardInfo("Command Tower", 263, Rarity.COMMON, mage.cards.c.CommandTower.class));
        cards.add(new SetCardInfo("Commander's Sphere", 240, Rarity.COMMON, mage.cards.c.CommandersSphere.class));
        cards.add(new SetCardInfo("Confession Dial", 173, Rarity.RARE, mage.cards.c.ConfessionDial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Confession Dial", 456, Rarity.RARE, mage.cards.c.ConfessionDial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Confession Dial", 778, Rarity.RARE, mage.cards.c.ConfessionDial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Confession Dial", 1047, Rarity.RARE, mage.cards.c.ConfessionDial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coward // Killer", 77, Rarity.RARE, mage.cards.c.CowardKiller.class));
        cards.add(new SetCardInfo("Crack in Time", 16, Rarity.RARE, mage.cards.c.CrackInTime.class));
        cards.add(new SetCardInfo("Creeping Tar Pit", 267, Rarity.RARE, mage.cards.c.CreepingTarPit.class));
        cards.add(new SetCardInfo("Crisis of Conscience", 17, Rarity.RARE, mage.cards.c.CrisisOfConscience.class));
        cards.add(new SetCardInfo("Crumbling Necropolis", 268, Rarity.UNCOMMON, mage.cards.c.CrumblingNecropolis.class));
        cards.add(new SetCardInfo("Cult of Skaro", 117, Rarity.RARE, mage.cards.c.CultOfSkaro.class));
        cards.add(new SetCardInfo("Cultivate", 230, Rarity.COMMON, mage.cards.c.Cultivate.class));
        cards.add(new SetCardInfo("Cursed Mirror", 226, Rarity.RARE, mage.cards.c.CursedMirror.class));
        cards.add(new SetCardInfo("Cyberman Patrol", 174, Rarity.UNCOMMON, mage.cards.c.CybermanPatrol.class));
        cards.add(new SetCardInfo("Cybermat", 175, Rarity.UNCOMMON, mage.cards.c.Cybermat.class));
        cards.add(new SetCardInfo("Cybermen Squadron", 176, Rarity.RARE, mage.cards.c.CybermenSquadron.class));
        cards.add(new SetCardInfo("Dalek Drone", 64, Rarity.RARE, mage.cards.d.DalekDrone.class));
        cards.add(new SetCardInfo("Dalek Squadron", 65, Rarity.UNCOMMON, mage.cards.d.DalekSquadron.class));
        cards.add(new SetCardInfo("Dan Lewis", 78, Rarity.RARE, mage.cards.d.DanLewis.class));
        cards.add(new SetCardInfo("Darkwater Catacombs", 269, Rarity.RARE, mage.cards.d.DarkwaterCatacombs.class));
        cards.add(new SetCardInfo("Davros, Dalek Creator", 1, Rarity.MYTHIC, mage.cards.d.DavrosDalekCreator.class));
        cards.add(new SetCardInfo("Day of Destiny", 206, Rarity.RARE, mage.cards.d.DayOfDestiny.class));
        cards.add(new SetCardInfo("Decaying Time Loop", 80, Rarity.UNCOMMON, mage.cards.d.DecayingTimeLoop.class));
        cards.add(new SetCardInfo("Delete", 81, Rarity.RARE, mage.cards.d.Delete.class));
        cards.add(new SetCardInfo("Deserted Beach", 270, Rarity.RARE, mage.cards.d.DesertedBeach.class));
        cards.add(new SetCardInfo("Desolate Lighthouse", 271, Rarity.RARE, mage.cards.d.DesolateLighthouse.class));
        cards.add(new SetCardInfo("Dinosaurs on a Spaceship", 122, Rarity.RARE, mage.cards.d.DinosaursOnASpaceship.class));
        cards.add(new SetCardInfo("Displaced Dinosaurs", 100, Rarity.UNCOMMON, mage.cards.d.DisplacedDinosaurs.class));
        cards.add(new SetCardInfo("Donna Noble", 82, Rarity.RARE, mage.cards.d.DonnaNoble.class));
        cards.add(new SetCardInfo("Dragonskull Summit", 272, Rarity.RARE, mage.cards.d.DragonskullSummit.class));
        cards.add(new SetCardInfo("Dreamroot Cascade", 273, Rarity.RARE, mage.cards.d.DreamrootCascade.class));
        cards.add(new SetCardInfo("Drowned Catacomb", 274, Rarity.RARE, mage.cards.d.DrownedCatacomb.class));
        cards.add(new SetCardInfo("Duggan, Private Detective", 123, Rarity.RARE, mage.cards.d.DugganPrivateDetective.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Duggan, Private Detective", 409, Rarity.RARE, mage.cards.d.DugganPrivateDetective.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Duggan, Private Detective", 728, Rarity.RARE, mage.cards.d.DugganPrivateDetective.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Duggan, Private Detective", 1000, Rarity.RARE, mage.cards.d.DugganPrivateDetective.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ecstatic Beauty", 83, Rarity.RARE, mage.cards.e.EcstaticBeauty.class));
        cards.add(new SetCardInfo("Everything Comes to Dust", 19, Rarity.RARE, mage.cards.e.EverythingComesToDust.class));
        cards.add(new SetCardInfo("Evolving Wilds", 275, Rarity.COMMON, mage.cards.e.EvolvingWilds.class));
        cards.add(new SetCardInfo("Exotic Orchard", 276, Rarity.RARE, mage.cards.e.ExoticOrchard.class));
        cards.add(new SetCardInfo("Explore", 231, Rarity.COMMON, mage.cards.e.Explore.class));
        cards.add(new SetCardInfo("Exterminate!", 68, Rarity.UNCOMMON, mage.cards.e.Exterminate.class));
        cards.add(new SetCardInfo("Farewell", 207, Rarity.RARE, mage.cards.f.Farewell.class));
        cards.add(new SetCardInfo("Farseek", 232, Rarity.COMMON, mage.cards.f.Farseek.class));
        cards.add(new SetCardInfo("Feed the Swarm", 221, Rarity.COMMON, mage.cards.f.FeedTheSwarm.class));
        cards.add(new SetCardInfo("Fetid Pools", 277, Rarity.RARE, mage.cards.f.FetidPools.class));
        cards.add(new SetCardInfo("Fiery Islet", 278, Rarity.RARE, mage.cards.f.FieryIslet.class));
        cards.add(new SetCardInfo("Five Hundred Year Diary", 42, Rarity.RARE, mage.cards.f.FiveHundredYearDiary.class));
        cards.add(new SetCardInfo("Flaming Tyrannosaurus", 85, Rarity.RARE, mage.cards.f.FlamingTyrannosaurus.class));
        cards.add(new SetCardInfo("Flatline", 43, Rarity.RARE, mage.cards.f.Flatline.class));
        cards.add(new SetCardInfo("Flesh Duplicate", 44, Rarity.RARE, mage.cards.f.FleshDuplicate.class));
        cards.add(new SetCardInfo("Foreboding Ruins", 279, Rarity.RARE, mage.cards.f.ForebodingRuins.class));
        cards.add(new SetCardInfo("Forest", 204, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fortified Village", 280, Rarity.RARE, mage.cards.f.FortifiedVillage.class));
        cards.add(new SetCardInfo("Four Knocks", 20, Rarity.RARE, mage.cards.f.FourKnocks.class));
        cards.add(new SetCardInfo("Fractured Identity", 236, Rarity.RARE, mage.cards.f.FracturedIdentity.class));
        cards.add(new SetCardInfo("Frontier Bivouac", 281, Rarity.UNCOMMON, mage.cards.f.FrontierBivouac.class));
        cards.add(new SetCardInfo("Frost Fair Lure Fish", 129, Rarity.RARE, mage.cards.f.FrostFairLureFish.class));
        cards.add(new SetCardInfo("Frostboil Snarl", 282, Rarity.RARE, mage.cards.f.FrostboilSnarl.class));
        cards.add(new SetCardInfo("Furycalm Snarl", 283, Rarity.RARE, mage.cards.f.FurycalmSnarl.class));
        cards.add(new SetCardInfo("Gallifrey Council Chamber", 188, Rarity.RARE, mage.cards.g.GallifreyCouncilChamber.class));
        cards.add(new SetCardInfo("Gallifrey Falls // No More", 131, Rarity.RARE, mage.cards.g.GallifreyFallsNoMore.class));
        cards.add(new SetCardInfo("Gallifrey Stands", 132, Rarity.RARE, mage.cards.g.GallifreyStands.class));
        cards.add(new SetCardInfo("Game Trail", 284, Rarity.RARE, mage.cards.g.GameTrail.class));
        cards.add(new SetCardInfo("Glacial Fortress", 285, Rarity.RARE, mage.cards.g.GlacialFortress.class));
        cards.add(new SetCardInfo("Graham O'Brien", 104, Rarity.RARE, mage.cards.g.GrahamOBrien.class));
        cards.add(new SetCardInfo("Grasp of Fate", 208, Rarity.RARE, mage.cards.g.GraspOfFate.class));
        cards.add(new SetCardInfo("Great Intelligence's Plan", 133, Rarity.UNCOMMON, mage.cards.g.GreatIntelligencesPlan.class));
        cards.add(new SetCardInfo("Growth Spiral", 237, Rarity.COMMON, mage.cards.g.GrowthSpiral.class));
        cards.add(new SetCardInfo("Haunted Ridge", 286, Rarity.RARE, mage.cards.h.HauntedRidge.class));
        cards.add(new SetCardInfo("Heaven Sent", 134, Rarity.RARE, mage.cards.h.HeavenSent.class));
        cards.add(new SetCardInfo("Hero's Blade", 241, Rarity.UNCOMMON, mage.cards.h.HerosBlade.class));
        cards.add(new SetCardInfo("Heroes' Podium", 242, Rarity.RARE, mage.cards.h.HeroesPodium.class));
        cards.add(new SetCardInfo("Heroic Intervention", 233, Rarity.RARE, mage.cards.h.HeroicIntervention.class));
        cards.add(new SetCardInfo("Horizon Canopy", 287, Rarity.RARE, mage.cards.h.HorizonCanopy.class));
        cards.add(new SetCardInfo("Ian Chesterton", 22, Rarity.RARE, mage.cards.i.IanChesterton.class));
        cards.add(new SetCardInfo("Impending Flux", 87, Rarity.RARE, mage.cards.i.ImpendingFlux.class));
        cards.add(new SetCardInfo("Inspiring Refrain", 216, Rarity.RARE, mage.cards.i.InspiringRefrain.class));
        cards.add(new SetCardInfo("Into the Time Vortex", 88, Rarity.RARE, mage.cards.i.IntoTheTimeVortex.class));
        cards.add(new SetCardInfo("Iraxxa, Empress of Mars", 89, Rarity.UNCOMMON, mage.cards.i.IraxxaEmpressOfMars.class));
        cards.add(new SetCardInfo("Irrigated Farmland", 288, Rarity.RARE, mage.cards.i.IrrigatedFarmland.class));
        cards.add(new SetCardInfo("Island", 198, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jamie McCrimmon", 105, Rarity.RARE, mage.cards.j.JamieMcCrimmon.class));
        cards.add(new SetCardInfo("Jenny Flint", 136, Rarity.RARE, mage.cards.j.JennyFlint.class));
        cards.add(new SetCardInfo("Jenny, Generated Anomaly", 137, Rarity.RARE, mage.cards.j.JennyGeneratedAnomaly.class));
        cards.add(new SetCardInfo("Jo Grant", 23, Rarity.RARE, mage.cards.j.JoGrant.class));
        cards.add(new SetCardInfo("Judoon Enforcers", 138, Rarity.UNCOMMON, mage.cards.j.JudoonEnforcers.class));
        cards.add(new SetCardInfo("K-9, Mark I", 47, Rarity.RARE, mage.cards.k.K9MarkI.class));
        cards.add(new SetCardInfo("Karvanista, Loyal Lupari", 106, Rarity.RARE, mage.cards.k.KarvanistaLoyalLupari.class));
        cards.add(new SetCardInfo("Kate Stewart", 139, Rarity.RARE, mage.cards.k.KateStewart.class));
        cards.add(new SetCardInfo("Laser Screwdriver", 178, Rarity.UNCOMMON, mage.cards.l.LaserScrewdriver.class));
        cards.add(new SetCardInfo("Last Night Together", 140, Rarity.RARE, mage.cards.l.LastNightTogether.class));
        cards.add(new SetCardInfo("Lavaclaw Reaches", 289, Rarity.RARE, mage.cards.l.LavaclawReaches.class));
        cards.add(new SetCardInfo("Leela, Sevateem Warrior", 107, Rarity.RARE, mage.cards.l.LeelaSevateemWarrior.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leela, Sevateem Warrior", 398, Rarity.RARE, mage.cards.l.LeelaSevateemWarrior.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leela, Sevateem Warrior", 712, Rarity.RARE, mage.cards.l.LeelaSevateemWarrior.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leela, Sevateem Warrior", 989, Rarity.RARE, mage.cards.l.LeelaSevateemWarrior.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Greaves", 243, Rarity.UNCOMMON, mage.cards.l.LightningGreaves.class));
        cards.add(new SetCardInfo("Lunar Hatchling", 141, Rarity.RARE, mage.cards.l.LunarHatchling.class));
        cards.add(new SetCardInfo("Madame Vastra", 142, Rarity.RARE, mage.cards.m.MadameVastra.class));
        cards.add(new SetCardInfo("Martha Jones", 48, Rarity.RARE, mage.cards.m.MarthaJones.class));
        cards.add(new SetCardInfo("Me, the Immortal", 147, Rarity.RARE, mage.cards.m.MeTheImmortal.class));
        cards.add(new SetCardInfo("Memory Worm", 90, Rarity.UNCOMMON, mage.cards.m.MemoryWorm.class));
        cards.add(new SetCardInfo("Mind Stone", 244, Rarity.UNCOMMON, mage.cards.m.MindStone.class));
        cards.add(new SetCardInfo("Mountain", 202, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Myriad Landscape", 290, Rarity.UNCOMMON, mage.cards.m.MyriadLandscape.class));
        cards.add(new SetCardInfo("Mystic Monastery", 291, Rarity.UNCOMMON, mage.cards.m.MysticMonastery.class));
        cards.add(new SetCardInfo("Nanogene Conversion", 49, Rarity.RARE, mage.cards.n.NanogeneConversion.class));
        cards.add(new SetCardInfo("Nardole, Resourceful Cyborg", 50, Rarity.RARE, mage.cards.n.NardoleResourcefulCyborg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nardole, Resourceful Cyborg", 365, Rarity.RARE, mage.cards.n.NardoleResourcefulCyborg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nardole, Resourceful Cyborg", 655, Rarity.RARE, mage.cards.n.NardoleResourcefulCyborg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nardole, Resourceful Cyborg", 956, Rarity.RARE, mage.cards.n.NardoleResourcefulCyborg.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ominous Cemetery", 189, Rarity.UNCOMMON, mage.cards.o.OminousCemetery.class));
        cards.add(new SetCardInfo("Out of Time", 209, Rarity.RARE, mage.cards.o.OutOfTime.class));
        cards.add(new SetCardInfo("Overgrown Farmland", 292, Rarity.RARE, mage.cards.o.OvergrownFarmland.class));
        cards.add(new SetCardInfo("Past in Flames", 565, Rarity.RARE, mage.cards.p.PastInFlames.class));
        cards.add(new SetCardInfo("Path of Ancestry", 293, Rarity.COMMON, mage.cards.p.PathOfAncestry.class));
        cards.add(new SetCardInfo("Path to Exile", 210, Rarity.UNCOMMON, mage.cards.p.PathToExile.class));
        cards.add(new SetCardInfo("Plains", 196, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ponder", 217, Rarity.COMMON, mage.cards.p.Ponder.class));
        cards.add(new SetCardInfo("Port Town", 294, Rarity.RARE, mage.cards.p.PortTown.class));
        cards.add(new SetCardInfo("Prairie Stream", 295, Rarity.RARE, mage.cards.p.PrairieStream.class));
        cards.add(new SetCardInfo("Preordain", 218, Rarity.COMMON, mage.cards.p.Preordain.class));
        cards.add(new SetCardInfo("Propaganda", 219, Rarity.UNCOMMON, mage.cards.p.Propaganda.class));
        cards.add(new SetCardInfo("Quantum Misalignment", 52, Rarity.RARE, mage.cards.q.QuantumMisalignment.class));
        cards.add(new SetCardInfo("RMS Titanic", 93, Rarity.RARE, mage.cards.r.RMSTitanic.class));
        cards.add(new SetCardInfo("Regenerations Restored", 151, Rarity.RARE, mage.cards.r.RegenerationsRestored.class));
        cards.add(new SetCardInfo("Reliquary Tower", 296, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class));
        cards.add(new SetCardInfo("Renegade Silent", 53, Rarity.UNCOMMON, mage.cards.r.RenegadeSilent.class));
        cards.add(new SetCardInfo("Return the Past", 92, Rarity.RARE, mage.cards.r.ReturnThePast.class));
        cards.add(new SetCardInfo("Return to Dust", 211, Rarity.UNCOMMON, mage.cards.r.ReturnToDust.class));
        cards.add(new SetCardInfo("Reverse the Polarity", 54, Rarity.RARE, mage.cards.r.ReverseThePolarity.class));
        cards.add(new SetCardInfo("River Song", 152, Rarity.RARE, mage.cards.r.RiverSong.class));
        cards.add(new SetCardInfo("River of Tears", 297, Rarity.RARE, mage.cards.r.RiverOfTears.class));
        cards.add(new SetCardInfo("Rockfall Vale", 298, Rarity.RARE, mage.cards.r.RockfallVale.class));
        cards.add(new SetCardInfo("Rogue's Passage", 299, Rarity.UNCOMMON, mage.cards.r.RoguesPassage.class));
        cards.add(new SetCardInfo("Romana II", 27, Rarity.RARE, mage.cards.r.RomanaII.class));
        cards.add(new SetCardInfo("Rootbound Crag", 300, Rarity.RARE, mage.cards.r.RootboundCrag.class));
        cards.add(new SetCardInfo("Rory Williams", 153, Rarity.RARE, mage.cards.r.RoryWilliams.class));
        cards.add(new SetCardInfo("Rose Tyler", 5, Rarity.RARE, mage.cards.r.RoseTyler.class));
        cards.add(new SetCardInfo("Rotating Fireplace", 183, Rarity.RARE, mage.cards.r.RotatingFireplace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rotating Fireplace", 461, Rarity.RARE, mage.cards.r.RotatingFireplace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Run for Your Life", 154, Rarity.RARE, mage.cards.r.RunForYourLife.class));
        cards.add(new SetCardInfo("Sally Sparrow", 155, Rarity.RARE, mage.cards.s.SallySparrow.class));
        cards.add(new SetCardInfo("Sarah Jane Smith", 6, Rarity.RARE, mage.cards.s.SarahJaneSmith.class));
        cards.add(new SetCardInfo("Scattered Groves", 301, Rarity.RARE, mage.cards.s.ScatteredGroves.class));
        cards.add(new SetCardInfo("Search for Tomorrow", 234, Rarity.COMMON, mage.cards.s.SearchForTomorrow.class));
        cards.add(new SetCardInfo("Seaside Citadel", 302, Rarity.UNCOMMON, mage.cards.s.SeasideCitadel.class));
        cards.add(new SetCardInfo("Sergeant John Benton", 157, Rarity.RARE, mage.cards.s.SergeantJohnBenton.class));
        cards.add(new SetCardInfo("Shadowblood Ridge", 303, Rarity.RARE, mage.cards.s.ShadowbloodRidge.class));
        cards.add(new SetCardInfo("Sheltered Thicket", 304, Rarity.RARE, mage.cards.s.ShelteredThicket.class));
        cards.add(new SetCardInfo("Shipwreck Marsh", 305, Rarity.RARE, mage.cards.s.ShipwreckMarsh.class));
        cards.add(new SetCardInfo("Sibylline Soothsayer", 95, Rarity.UNCOMMON, mage.cards.s.SibyllineSoothsayer.class));
        cards.add(new SetCardInfo("Sisterhood of Karn", 109, Rarity.RARE, mage.cards.s.SisterhoodOfKarn.class));
        cards.add(new SetCardInfo("Skycloud Expanse", 306, Rarity.RARE, mage.cards.s.SkycloudExpanse.class));
        cards.add(new SetCardInfo("Smoldering Marsh", 307, Rarity.RARE, mage.cards.s.SmolderingMarsh.class));
        cards.add(new SetCardInfo("Snuff Out", 222, Rarity.UNCOMMON, mage.cards.s.SnuffOut.class));
        cards.add(new SetCardInfo("Sol Ring", 245, Rarity.UNCOMMON, mage.cards.s.SolRing.class));
        cards.add(new SetCardInfo("Solemn Simulacrum", 246, Rarity.RARE, mage.cards.s.SolemnSimulacrum.class));
        cards.add(new SetCardInfo("Sonic Screwdriver", 184, Rarity.UNCOMMON, mage.cards.s.SonicScrewdriver.class));
        cards.add(new SetCardInfo("Sontaran General", 96, Rarity.UNCOMMON, mage.cards.s.SontaranGeneral.class));
        cards.add(new SetCardInfo("Star Whale", 55, Rarity.UNCOMMON, mage.cards.s.StarWhale.class));
        cards.add(new SetCardInfo("Start the TARDIS", 56, Rarity.UNCOMMON, mage.cards.s.StartTheTARDIS.class));
        cards.add(new SetCardInfo("Stormcarved Coast", 308, Rarity.RARE, mage.cards.s.StormcarvedCoast.class));
        cards.add(new SetCardInfo("Sunbaked Canyon", 309, Rarity.RARE, mage.cards.s.SunbakedCanyon.class));
        cards.add(new SetCardInfo("Sundown Pass", 310, Rarity.RARE, mage.cards.s.SundownPass.class));
        cards.add(new SetCardInfo("Sungrass Prairie", 311, Rarity.RARE, mage.cards.s.SungrassPrairie.class));
        cards.add(new SetCardInfo("Sunken Hollow", 312, Rarity.RARE, mage.cards.s.SunkenHollow.class));
        cards.add(new SetCardInfo("Surge of Brilliance", 57, Rarity.UNCOMMON, mage.cards.s.SurgeOfBrilliance.class));
        cards.add(new SetCardInfo("Swamp", 200, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 212, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class));
        cards.add(new SetCardInfo("TARDIS", 187, Rarity.UNCOMMON, mage.cards.t.TARDIS.class));
        cards.add(new SetCardInfo("Talisman of Conviction", 247, Rarity.UNCOMMON, mage.cards.t.TalismanOfConviction.class));
        cards.add(new SetCardInfo("Talisman of Creativity", 248, Rarity.UNCOMMON, mage.cards.t.TalismanOfCreativity.class));
        cards.add(new SetCardInfo("Talisman of Curiosity", 249, Rarity.UNCOMMON, mage.cards.t.TalismanOfCuriosity.class));
        cards.add(new SetCardInfo("Talisman of Dominance", 250, Rarity.UNCOMMON, mage.cards.t.TalismanOfDominance.class));
        cards.add(new SetCardInfo("Talisman of Impulse", 251, Rarity.UNCOMMON, mage.cards.t.TalismanOfImpulse.class));
        cards.add(new SetCardInfo("Talisman of Indulgence", 252, Rarity.UNCOMMON, mage.cards.t.TalismanOfIndulgence.class));
        cards.add(new SetCardInfo("Talisman of Progress", 253, Rarity.UNCOMMON, mage.cards.t.TalismanOfProgress.class));
        cards.add(new SetCardInfo("Talisman of Unity", 254, Rarity.UNCOMMON, mage.cards.t.TalismanOfUnity.class));
        cards.add(new SetCardInfo("Tegan Jovanka", 28, Rarity.RARE, mage.cards.t.TeganJovanka.class));
        cards.add(new SetCardInfo("Temple of Abandon", 313, Rarity.RARE, mage.cards.t.TempleOfAbandon.class));
        cards.add(new SetCardInfo("Temple of Deceit", 314, Rarity.RARE, mage.cards.t.TempleOfDeceit.class));
        cards.add(new SetCardInfo("Temple of Enlightenment", 315, Rarity.RARE, mage.cards.t.TempleOfEnlightenment.class));
        cards.add(new SetCardInfo("Temple of Epiphany", 316, Rarity.RARE, mage.cards.t.TempleOfEpiphany.class));
        cards.add(new SetCardInfo("Temple of Malice", 317, Rarity.RARE, mage.cards.t.TempleOfMalice.class));
        cards.add(new SetCardInfo("Temple of Mystery", 318, Rarity.RARE, mage.cards.t.TempleOfMystery.class));
        cards.add(new SetCardInfo("Temple of Plenty", 319, Rarity.RARE, mage.cards.t.TempleOfPlenty.class));
        cards.add(new SetCardInfo("Temple of Triumph", 321, Rarity.RARE, mage.cards.t.TempleOfTriumph.class));
        cards.add(new SetCardInfo("Temple of the False God", 320, Rarity.UNCOMMON, mage.cards.t.TempleOfTheFalseGod.class));
        cards.add(new SetCardInfo("Terramorphic Expanse", 322, Rarity.COMMON, mage.cards.t.TerramorphicExpanse.class));
        cards.add(new SetCardInfo("The Beast, Deathless Prince", 114, Rarity.RARE, mage.cards.t.TheBeastDeathlessPrince.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Beast, Deathless Prince", 403, Rarity.RARE, mage.cards.t.TheBeastDeathlessPrince.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Beast, Deathless Prince", 719, Rarity.RARE, mage.cards.t.TheBeastDeathlessPrince.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Beast, Deathless Prince", 994, Rarity.RARE, mage.cards.t.TheBeastDeathlessPrince.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Dalek Emperor", 120, Rarity.RARE, mage.cards.t.TheDalekEmperor.class));
        cards.add(new SetCardInfo("The Eleventh Hour", 41, Rarity.RARE, mage.cards.t.TheEleventhHour.class));
        cards.add(new SetCardInfo("The Fifth Doctor", 127, Rarity.RARE, mage.cards.t.TheFifthDoctor.class));
        cards.add(new SetCardInfo("The Flood of Mars", 45, Rarity.RARE, mage.cards.t.TheFloodOfMars.class));
        cards.add(new SetCardInfo("The Flux", 86, Rarity.RARE, mage.cards.t.TheFlux.class));
        cards.add(new SetCardInfo("The Fugitive Doctor", 130, Rarity.RARE, mage.cards.t.TheFugitiveDoctor.class));
        cards.add(new SetCardInfo("The Master, Multiplied", 146, Rarity.RARE, mage.cards.t.TheMasterMultiplied.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Master, Multiplied", 429, Rarity.RARE, mage.cards.t.TheMasterMultiplied.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Master, Multiplied", 545, Rarity.RARE, mage.cards.t.TheMasterMultiplied.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ninth Doctor", 148, Rarity.RARE, mage.cards.t.TheNinthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ninth Doctor", 432, Rarity.RARE, mage.cards.t.TheNinthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ninth Doctor", 560, Rarity.RARE, mage.cards.t.TheNinthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Rani", 149, Rarity.RARE, mage.cards.t.TheRani.class));
        cards.add(new SetCardInfo("The Sea Devils", 108, Rarity.RARE, mage.cards.t.TheSeaDevils.class));
        cards.add(new SetCardInfo("The Sixth Doctor", 159, Rarity.RARE, mage.cards.t.TheSixthDoctor.class));
        cards.add(new SetCardInfo("The Thirteenth Doctor", 4, Rarity.MYTHIC, mage.cards.t.TheThirteenthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Thirteenth Doctor", 564, Rarity.MYTHIC, mage.cards.t.TheThirteenthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Thirteenth Doctor", "564z", Rarity.MYTHIC, mage.cards.t.TheThirteenthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Valeyard", 165, Rarity.RARE, mage.cards.t.TheValeyard.class));
        cards.add(new SetCardInfo("Thespian's Stage", 323, Rarity.RARE, mage.cards.t.ThespiansStage.class));
        cards.add(new SetCardInfo("The Tenth Doctor", 3, Rarity.MYTHIC, mage.cards.t.TheTenthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Tenth Doctor", 194, Rarity.MYTHIC, mage.cards.t.TheTenthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Tenth Doctor", 446, Rarity.MYTHIC, mage.cards.t.TheTenthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Tenth Doctor", 561, Rarity.MYTHIC, mage.cards.t.TheTenthDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Third Doctor", 162, Rarity.RARE, mage.cards.t.TheThirdDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Third Doctor", 447, Rarity.RARE, mage.cards.t.TheThirdDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Third Doctor", 554, Rarity.RARE, mage.cards.t.TheThirdDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Third Doctor", "554z", Rarity.RARE, mage.cards.t.TheThirdDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Third Doctor", 767, Rarity.RARE, mage.cards.t.TheThirdDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Third Doctor", 1038, Rarity.RARE, mage.cards.t.TheThirdDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Third Doctor", 1145, Rarity.RARE, mage.cards.t.TheThirdDoctor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Twelfth Doctor", 164, Rarity.RARE, mage.cards.t.TheTwelfthDoctor.class));
        cards.add(new SetCardInfo("Thijarian Witness", 111, Rarity.UNCOMMON, mage.cards.t.ThijarianWitness.class));
        cards.add(new SetCardInfo("Think Twice", 220, Rarity.COMMON, mage.cards.t.ThinkTwice.class));
        cards.add(new SetCardInfo("Thought Vessel", 255, Rarity.UNCOMMON, mage.cards.t.ThoughtVessel.class));
        cards.add(new SetCardInfo("Three Visits", 235, Rarity.UNCOMMON, mage.cards.t.ThreeVisits.class));
        cards.add(new SetCardInfo("Thriving Bluff", 324, Rarity.COMMON, mage.cards.t.ThrivingBluff.class));
        cards.add(new SetCardInfo("Thriving Grove", 325, Rarity.COMMON, mage.cards.t.ThrivingGrove.class));
        cards.add(new SetCardInfo("Thriving Heath", 326, Rarity.COMMON, mage.cards.t.ThrivingHeath.class));
        cards.add(new SetCardInfo("Thriving Isle", 327, Rarity.COMMON, mage.cards.t.ThrivingIsle.class));
        cards.add(new SetCardInfo("Thriving Moor", 328, Rarity.COMMON, mage.cards.t.ThrivingMoor.class));
        cards.add(new SetCardInfo("Throes of Chaos", 227, Rarity.UNCOMMON, mage.cards.t.ThroesOfChaos.class));
        cards.add(new SetCardInfo("Time Beetle", 58, Rarity.UNCOMMON, mage.cards.t.TimeBeetle.class));
        cards.add(new SetCardInfo("Time Lord Regeneration", 59, Rarity.UNCOMMON, mage.cards.t.TimeLordRegeneration.class));
        cards.add(new SetCardInfo("Time Reaper", 71, Rarity.RARE, mage.cards.t.TimeReaper.class));
        cards.add(new SetCardInfo("Time Wipe", 238, Rarity.RARE, mage.cards.t.TimeWipe.class));
        cards.add(new SetCardInfo("Traverse Eternity", 60, Rarity.RARE, mage.cards.t.TraverseEternity.class));
        cards.add(new SetCardInfo("Trenzalore Clocktower", 190, Rarity.RARE, mage.cards.t.TrenzaloreClocktower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trenzalore Clocktower", 463, Rarity.RARE, mage.cards.t.TrenzaloreClocktower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trenzalore Clocktower", 795, Rarity.RARE, mage.cards.t.TrenzaloreClocktower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trenzalore Clocktower", 1054, Rarity.RARE, mage.cards.t.TrenzaloreClocktower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Truth or Consequences", 163, Rarity.UNCOMMON, mage.cards.t.TruthOrConsequences.class));
        cards.add(new SetCardInfo("Twice Upon a Time", 61, Rarity.RARE, mage.cards.t.TwiceUponATime.class));
        cards.add(new SetCardInfo("Vashta Nerada", 73, Rarity.RARE, mage.cards.v.VashtaNerada.class));
        cards.add(new SetCardInfo("Vineglimmer Snarl", 329, Rarity.RARE, mage.cards.v.VineglimmerSnarl.class));
        cards.add(new SetCardInfo("Vrestin, Menoptra Leader", 451, Rarity.RARE, mage.cards.v.VrestinMenoptraLeader.class));
        cards.add(new SetCardInfo("War Room", 330, Rarity.RARE, mage.cards.w.WarRoom.class));
        cards.add(new SetCardInfo("Waterlogged Grove", 331, Rarity.RARE, mage.cards.w.WaterloggedGrove.class));
        cards.add(new SetCardInfo("Wayfarer's Bauble", 256, Rarity.COMMON, mage.cards.w.WayfarersBauble.class));
        cards.add(new SetCardInfo("Wedding Ring", 213, Rarity.MYTHIC, mage.cards.w.WeddingRing.class));
        cards.add(new SetCardInfo("Weeping Angel", 168, Rarity.RARE, mage.cards.w.WeepingAngel.class));
        cards.add(new SetCardInfo("Wibbly-wobbly, Timey-wimey", 62, Rarity.COMMON, mage.cards.w.WibblyWobblyTimeyWimey.class));
        cards.add(new SetCardInfo("Wound Reflection", 223, Rarity.RARE, mage.cards.w.WoundReflection.class));
        cards.add(new SetCardInfo("Wreck and Rebuild", 169, Rarity.UNCOMMON, mage.cards.w.WreckAndRebuild.class));
        cards.add(new SetCardInfo("Yasmin Khan", 7, Rarity.RARE, mage.cards.y.YasminKhan.class));
        cards.add(new SetCardInfo("Zygon Infiltrator", 63, Rarity.UNCOMMON, mage.cards.z.ZygonInfiltrator.class));
    }
}
