package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

public final class CommanderMasters extends ExpansionSet {

    private static final CommanderMasters instance = new CommanderMasters();

    public static CommanderMasters getInstance() {
        return instance;
    }

    private CommanderMasters() {
        super("Commander Masters", "CMM", ExpansionSet.buildDate(2023, 8, 4), SetType.SUPPLEMENTAL);
        this.blockName = "Commander Masters";
        this.hasBasicLands = true;
        this.hasBoosters = false; //temporary

        cards.add(new SetCardInfo("Abrade", 203, Rarity.COMMON, mage.cards.a.Abrade.class));
        cards.add(new SetCardInfo("Abstruse Archaic", 712, Rarity.RARE, mage.cards.a.AbstruseArchaic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abstruse Archaic", 744, Rarity.RARE, mage.cards.a.AbstruseArchaic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abundance", 884, Rarity.RARE, mage.cards.a.Abundance.class));
        cards.add(new SetCardInfo("Abundant Harvest", 269, Rarity.COMMON, mage.cards.a.AbundantHarvest.class));
        cards.add(new SetCardInfo("Acidic Slime", 270, Rarity.UNCOMMON, mage.cards.a.AcidicSlime.class));
        cards.add(new SetCardInfo("Aether Gale", 72, Rarity.UNCOMMON, mage.cards.a.AetherGale.class));
        cards.add(new SetCardInfo("Ainok Bond-Kin", 7, Rarity.COMMON, mage.cards.a.AinokBondKin.class));
        cards.add(new SetCardInfo("Ajani Steadfast", 813, Rarity.MYTHIC, mage.cards.a.AjaniSteadfast.class));
        cards.add(new SetCardInfo("Akiri, Fearless Voyager", 335, Rarity.UNCOMMON, mage.cards.a.AkiriFearlessVoyager.class));
        cards.add(new SetCardInfo("Alharu, Solemn Ritualist", 8, Rarity.UNCOMMON, mage.cards.a.AlharuSolemnRitualist.class));
        cards.add(new SetCardInfo("All Is Dust", 800, Rarity.MYTHIC, mage.cards.a.AllIsDust.class));
        cards.add(new SetCardInfo("All That Glitters", 622, Rarity.COMMON, mage.cards.a.AllThatGlitters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("All That Glitters", 9, Rarity.COMMON, mage.cards.a.AllThatGlitters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alms Collector", 10, Rarity.RARE, mage.cards.a.AlmsCollector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alms Collector", 455, Rarity.RARE, mage.cards.a.AlmsCollector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aminatou's Augury", 479, Rarity.RARE, mage.cards.a.AminatousAugury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aminatou's Augury", 73, Rarity.RARE, mage.cards.a.AminatousAugury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anafenza, Kin-Tree Spirit", 11, Rarity.UNCOMMON, mage.cards.a.AnafenzaKinTreeSpirit.class));
        cards.add(new SetCardInfo("Anax, Hardened in the Forge", 204, Rarity.UNCOMMON, mage.cards.a.AnaxHardenedInTheForge.class));
        cards.add(new SetCardInfo("Ancestral Blade", 12, Rarity.COMMON, mage.cards.a.AncestralBlade.class));
        cards.add(new SetCardInfo("Ancient Stone Idol", 940, Rarity.RARE, mage.cards.a.AncientStoneIdol.class));
        cards.add(new SetCardInfo("Angelic Field Marshal", 13, Rarity.RARE, mage.cards.a.AngelicFieldMarshal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angelic Field Marshal", 456, Rarity.RARE, mage.cards.a.AngelicFieldMarshal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anikthea, Hand of Erebos", 705, Rarity.MYTHIC, mage.cards.a.AniktheaHandOfErebos.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anikthea, Hand of Erebos", 773, Rarity.MYTHIC, mage.cards.a.AniktheaHandOfErebos.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anikthea, Hand of Erebos", 780, Rarity.MYTHIC, mage.cards.a.AniktheaHandOfErebos.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Animal Magnetism", 271, Rarity.UNCOMMON, mage.cards.a.AnimalMagnetism.class));
        cards.add(new SetCardInfo("Arachnogenesis", 272, Rarity.RARE, mage.cards.a.Arachnogenesis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arachnogenesis", 553, Rarity.RARE, mage.cards.a.Arachnogenesis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arachnogenesis", 647, Rarity.RARE, mage.cards.a.Arachnogenesis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arasta of the Endless Web", 885, Rarity.RARE, mage.cards.a.ArastaOfTheEndlessWeb.class));
        cards.add(new SetCardInfo("Arcane Lighthouse", 985, Rarity.UNCOMMON, mage.cards.a.ArcaneLighthouse.class));
        cards.add(new SetCardInfo("Arcane Signet", 367, Rarity.UNCOMMON, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", 653, Rarity.UNCOMMON, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arch of Orazca", 986, Rarity.RARE, mage.cards.a.ArchOfOrazca.class));
        cards.add(new SetCardInfo("Archfiend of Despair", 137, Rarity.MYTHIC, mage.cards.a.ArchfiendOfDespair.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archfiend of Despair", 503, Rarity.MYTHIC, mage.cards.a.ArchfiendOfDespair.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archon of Sun's Grace", 814, Rarity.RARE, mage.cards.a.ArchonOfSunsGrace.class));
        cards.add(new SetCardInfo("Armorcraft Judge", 273, Rarity.UNCOMMON, mage.cards.a.ArmorcraftJudge.class));
        cards.add(new SetCardInfo("Artisan of Kozilek", 801, Rarity.UNCOMMON, mage.cards.a.ArtisanOfKozilek.class));
        cards.add(new SetCardInfo("Aryel, Knight of Windgrace", 336, Rarity.UNCOMMON, mage.cards.a.AryelKnightOfWindgrace.class));
        cards.add(new SetCardInfo("Ash Barrens", 419, Rarity.COMMON, mage.cards.a.AshBarrens.class));
        cards.add(new SetCardInfo("Ashling the Pilgrim", 205, Rarity.RARE, mage.cards.a.AshlingThePilgrim.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashling the Pilgrim", 528, Rarity.RARE, mage.cards.a.AshlingThePilgrim.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ashnod's Altar", 368, Rarity.UNCOMMON, mage.cards.a.AshnodsAltar.class));
        cards.add(new SetCardInfo("Assault Suit", 369, Rarity.UNCOMMON, mage.cards.a.AssaultSuit.class));
        cards.add(new SetCardInfo("Avacyn, Angel of Hope", 14, Rarity.MYTHIC, mage.cards.a.AvacynAngelOfHope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Avacyn, Angel of Hope", 457, Rarity.MYTHIC, mage.cards.a.AvacynAngelOfHope.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Avatar of Slaughter", 206, Rarity.RARE, mage.cards.a.AvatarOfSlaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Avatar of Slaughter", 529, Rarity.RARE, mage.cards.a.AvatarOfSlaughter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azami, Lady of Scrolls", 480, Rarity.RARE, mage.cards.a.AzamiLadyOfScrolls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azami, Lady of Scrolls", 672, Rarity.RARE, mage.cards.a.AzamiLadyOfScrolls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azami, Lady of Scrolls", 74, Rarity.RARE, mage.cards.a.AzamiLadyOfScrolls.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azorius Signet", 941, Rarity.UNCOMMON, mage.cards.a.AzoriusSignet.class));
        cards.add(new SetCardInfo("Azusa, Lost but Seeking", 274, Rarity.RARE, mage.cards.a.AzusaLostButSeeking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azusa, Lost but Seeking", 554, Rarity.RARE, mage.cards.a.AzusaLostButSeeking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azusa, Lost but Seeking", 679, Rarity.RARE, mage.cards.a.AzusaLostButSeeking.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Baird, Steward of Argive", 15, Rarity.UNCOMMON, mage.cards.b.BairdStewardOfArgive.class));
        cards.add(new SetCardInfo("Balan, Wandering Knight", 16, Rarity.RARE, mage.cards.b.BalanWanderingKnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balan, Wandering Knight", 458, Rarity.RARE, mage.cards.b.BalanWanderingKnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balefire Dragon", 207, Rarity.MYTHIC, mage.cards.b.BalefireDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balefire Dragon", 530, Rarity.MYTHIC, mage.cards.b.BalefireDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Balefire Dragon", 697, Rarity.MYTHIC, mage.cards.b.BalefireDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bane of Bala Ged", 802, Rarity.UNCOMMON, mage.cards.b.BaneOfBalaGed.class));
        cards.add(new SetCardInfo("Bastion of Remembrance", 138, Rarity.UNCOMMON, mage.cards.b.BastionOfRemembrance.class));
        cards.add(new SetCardInfo("Battle Screech", 17, Rarity.COMMON, mage.cards.b.BattleScreech.class));
        cards.add(new SetCardInfo("Battle at the Helvault", 719, Rarity.RARE, mage.cards.b.BattleAtTheHelvault.class));
        cards.add(new SetCardInfo("Battle for Bretagard", 916, Rarity.RARE, mage.cards.b.BattleForBretagard.class));
        cards.add(new SetCardInfo("Beanstalk Giant", 275, Rarity.UNCOMMON, mage.cards.b.BeanstalkGiant.class));
        cards.add(new SetCardInfo("Binding the Old Gods", 917, Rarity.UNCOMMON, mage.cards.b.BindingTheOldGods.class));
        cards.add(new SetCardInfo("Blade Sliver", 871, Rarity.UNCOMMON, mage.cards.b.BladeSliver.class));
        cards.add(new SetCardInfo("Blasphemous Act", 872, Rarity.RARE, mage.cards.b.BlasphemousAct.class));
        cards.add(new SetCardInfo("Blast Zone", 987, Rarity.RARE, mage.cards.b.BlastZone.class));
        cards.add(new SetCardInfo("Blood Aspirant", 208, Rarity.COMMON, mage.cards.b.BloodAspirant.class));
        cards.add(new SetCardInfo("Bloodchief Ascension", 139, Rarity.RARE, mage.cards.b.BloodchiefAscension.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodchief Ascension", 504, Rarity.RARE, mage.cards.b.BloodchiefAscension.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodchief Ascension", 636, Rarity.RARE, mage.cards.b.BloodchiefAscension.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodspore Thrinax", 276, Rarity.RARE, mage.cards.b.BloodsporeThrinax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bloodspore Thrinax", 555, Rarity.RARE, mage.cards.b.BloodsporeThrinax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blur Sliver", 873, Rarity.COMMON, mage.cards.b.BlurSliver.class));
        cards.add(new SetCardInfo("Body Double", 75, Rarity.UNCOMMON, mage.cards.b.BodyDouble.class));
        cards.add(new SetCardInfo("Bonder's Ornament", 370, Rarity.COMMON, mage.cards.b.BondersOrnament.class));
        cards.add(new SetCardInfo("Bonders' Enclave", 988, Rarity.RARE, mage.cards.b.BondersEnclave.class));
        cards.add(new SetCardInfo("Bonescythe Sliver", 815, Rarity.RARE, mage.cards.b.BonescytheSliver.class));
        cards.add(new SetCardInfo("Bonesplitter Sliver", 874, Rarity.COMMON, mage.cards.b.BonesplitterSliver.class));
        cards.add(new SetCardInfo("Boompile", 371, Rarity.RARE, mage.cards.b.Boompile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boompile", 600, Rarity.RARE, mage.cards.b.Boompile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boon of the Spirit Realm", 720, Rarity.RARE, mage.cards.b.BoonOfTheSpiritRealm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boon of the Spirit Realm", 753, Rarity.RARE, mage.cards.b.BoonOfTheSpiritRealm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boros Signet", 942, Rarity.UNCOMMON, mage.cards.b.BorosSignet.class));
        cards.add(new SetCardInfo("Braids, Conjurer Adept", 481, Rarity.RARE, mage.cards.b.BraidsConjurerAdept.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Braids, Conjurer Adept", 76, Rarity.RARE, mage.cards.b.BraidsConjurerAdept.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brass Knuckles", 372, Rarity.COMMON, mage.cards.b.BrassKnuckles.class));
        cards.add(new SetCardInfo("Bribery", 482, Rarity.MYTHIC, mage.cards.b.Bribery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bribery", 77, Rarity.MYTHIC, mage.cards.b.Bribery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brinelin, the Moon Kraken", 78, Rarity.UNCOMMON, mage.cards.b.BrinelinTheMoonKraken.class));
        cards.add(new SetCardInfo("Broken Wings", 277, Rarity.COMMON, mage.cards.b.BrokenWings.class));
        cards.add(new SetCardInfo("Brood Sliver", 887, Rarity.RARE, mage.cards.b.BroodSliver.class));
        cards.add(new SetCardInfo("Burnished Hart", 373, Rarity.UNCOMMON, mage.cards.b.BurnishedHart.class));
        cards.add(new SetCardInfo("Cabal Patriarch", 140, Rarity.UNCOMMON, mage.cards.c.CabalPatriarch.class));
        cards.add(new SetCardInfo("Cacophony Unleashed", 730, Rarity.RARE, mage.cards.c.CacophonyUnleashed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cacophony Unleashed", 761, Rarity.RARE, mage.cards.c.CacophonyUnleashed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cadaver Imp", 141, Rarity.COMMON, mage.cards.c.CadaverImp.class));
        cards.add(new SetCardInfo("Calamity of the Titans", 713, Rarity.RARE, mage.cards.c.CalamityOfTheTitans.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Calamity of the Titans", 745, Rarity.RARE, mage.cards.c.CalamityOfTheTitans.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Calix, Destiny's Hand", 918, Rarity.MYTHIC, mage.cards.c.CalixDestinysHand.class));
        cards.add(new SetCardInfo("Campfire", 374, Rarity.COMMON, mage.cards.c.Campfire.class));
        cards.add(new SetCardInfo("Canopy Vista", 989, Rarity.RARE, mage.cards.c.CanopyVista.class));
        cards.add(new SetCardInfo("Capricious Sliver", 734, Rarity.RARE, mage.cards.c.CapriciousSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Capricious Sliver", 765, Rarity.RARE, mage.cards.c.CapriciousSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Captain Ripley Vance", 209, Rarity.UNCOMMON, mage.cards.c.CaptainRipleyVance.class));
        cards.add(new SetCardInfo("Capture of Jingzhou", 483, Rarity.MYTHIC, mage.cards.c.CaptureOfJingzhou.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Capture of Jingzhou", 79, Rarity.MYTHIC, mage.cards.c.CaptureOfJingzhou.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Carrier Thrall", 142, Rarity.COMMON, mage.cards.c.CarrierThrall.class));
        cards.add(new SetCardInfo("Carrion Grub", 143, Rarity.COMMON, mage.cards.c.CarrionGrub.class));
        cards.add(new SetCardInfo("Cartographer's Hawk", 18, Rarity.UNCOMMON, mage.cards.c.CartographersHawk.class));
        cards.add(new SetCardInfo("Cascade Bluffs", 990, Rarity.RARE, mage.cards.c.CascadeBluffs.class));
        cards.add(new SetCardInfo("Cast Out", 816, Rarity.UNCOMMON, mage.cards.c.CastOut.class));
        cards.add(new SetCardInfo("Chainer, Dementia Master", 144, Rarity.RARE, mage.cards.c.ChainerDementiaMaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chainer, Dementia Master", 505, Rarity.RARE, mage.cards.c.ChainerDementiaMaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Champion of the Flame", 210, Rarity.COMMON, mage.cards.c.ChampionOfTheFlame.class));
        cards.add(new SetCardInfo("Champion's Helm", 375, Rarity.RARE, mage.cards.c.ChampionsHelm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Champion's Helm", 601, Rarity.RARE, mage.cards.c.ChampionsHelm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Champion's Helm", 654, Rarity.RARE, mage.cards.c.ChampionsHelm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chandra, Awakened Inferno", 875, Rarity.MYTHIC, mage.cards.c.ChandraAwakenedInferno.class));
        cards.add(new SetCardInfo("Chandra, Legacy of Fire", 735, Rarity.RARE, mage.cards.c.ChandraLegacyOfFire.class));
        cards.add(new SetCardInfo("Chandra, Torch of Defiance", 876, Rarity.MYTHIC, mage.cards.c.ChandraTorchOfDefiance.class));
        cards.add(new SetCardInfo("Chromatic Lantern", 376, Rarity.RARE, mage.cards.c.ChromaticLantern.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Chromatic Lantern", 602, Rarity.RARE, mage.cards.c.ChromaticLantern.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cinder Glade", 991, Rarity.RARE, mage.cards.c.CinderGlade.class));
        cards.add(new SetCardInfo("Cleansing Nova", 817, Rarity.RARE, mage.cards.c.CleansingNova.class));
        cards.add(new SetCardInfo("Cleaving Sliver", 877, Rarity.COMMON, mage.cards.c.CleavingSliver.class));
        cards.add(new SetCardInfo("Clot Sliver", 861, Rarity.COMMON, mage.cards.c.ClotSliver.class));
        cards.add(new SetCardInfo("Cloudshredder Sliver", 919, Rarity.RARE, mage.cards.c.CloudshredderSliver.class));
        cards.add(new SetCardInfo("Command Tower", 420, Rarity.COMMON, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 659, Rarity.COMMON, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commandeer", 484, Rarity.RARE, mage.cards.c.Commandeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commandeer", 80, Rarity.RARE, mage.cards.c.Commandeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commander's Sphere", 377, Rarity.COMMON, mage.cards.c.CommandersSphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commander's Sphere", 655, Rarity.COMMON, mage.cards.c.CommandersSphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commodore Guff", 706, Rarity.MYTHIC, mage.cards.c.CommodoreGuff.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commodore Guff", 781, Rarity.MYTHIC, mage.cards.c.CommodoreGuff.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Composer of Spring", 739, Rarity.RARE, mage.cards.c.ComposerOfSpring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Composer of Spring", 769, Rarity.RARE, mage.cards.c.ComposerOfSpring.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Constricting Sliver", 818, Rarity.UNCOMMON, mage.cards.c.ConstrictingSliver.class));
        cards.add(new SetCardInfo("Corpse Augur", 145, Rarity.UNCOMMON, mage.cards.c.CorpseAugur.class));
        cards.add(new SetCardInfo("Counterspell", 630, Rarity.COMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Counterspell", 81, Rarity.COMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Courage in Crisis", 278, Rarity.COMMON, mage.cards.c.CourageInCrisis.class));
        cards.add(new SetCardInfo("Courser of Kruphix", 888, Rarity.RARE, mage.cards.c.CourserOfKruphix.class));
        cards.add(new SetCardInfo("Coveted Peacock", 82, Rarity.UNCOMMON, mage.cards.c.CovetedPeacock.class));
        cards.add(new SetCardInfo("Crash of Rhino Beetles", 279, Rarity.COMMON, mage.cards.c.CrashOfRhinoBeetles.class));
        cards.add(new SetCardInfo("Crashing Drawbridge", 944, Rarity.COMMON, mage.cards.c.CrashingDrawbridge.class));
        cards.add(new SetCardInfo("Craterhoof Behemoth", 280, Rarity.MYTHIC, mage.cards.c.CraterhoofBehemoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Craterhoof Behemoth", 556, Rarity.MYTHIC, mage.cards.c.CraterhoofBehemoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crawling Infestation", 281, Rarity.COMMON, mage.cards.c.CrawlingInfestation.class));
        cards.add(new SetCardInfo("Crimson Fleet Commodore", 211, Rarity.COMMON, mage.cards.c.CrimsonFleetCommodore.class));
        cards.add(new SetCardInfo("Crippling Fear", 862, Rarity.RARE, mage.cards.c.CripplingFear.class));
        cards.add(new SetCardInfo("Crypt Sliver", 863, Rarity.COMMON, mage.cards.c.CryptSliver.class));
        cards.add(new SetCardInfo("Cryptic Serpent", 83, Rarity.COMMON, mage.cards.c.CrypticSerpent.class));
        cards.add(new SetCardInfo("Crystalline Sliver", 920, Rarity.UNCOMMON, mage.cards.c.CrystallineSliver.class));
        cards.add(new SetCardInfo("Culling Ritual", 921, Rarity.RARE, mage.cards.c.CullingRitual.class));
        cards.add(new SetCardInfo("Cultivate", 889, Rarity.COMMON, mage.cards.c.Cultivate.class));
        cards.add(new SetCardInfo("Cunning Rhetoric", 864, Rarity.RARE, mage.cards.c.CunningRhetoric.class));
        cards.add(new SetCardInfo("Curtains' Call", 146, Rarity.RARE, mage.cards.c.CurtainsCall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Curtains' Call", 506, Rarity.RARE, mage.cards.c.CurtainsCall.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Custodi Squire", 19, Rarity.COMMON, mage.cards.c.CustodiSquire.class));
        cards.add(new SetCardInfo("Cyclonic Rift", 485, Rarity.RARE, mage.cards.c.CyclonicRift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cyclonic Rift", 84, Rarity.RARE, mage.cards.c.CyclonicRift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cyclops Electromancer", 212, Rarity.COMMON, mage.cards.c.CyclopsElectromancer.class));
        cards.add(new SetCardInfo("Danitha Capashen, Paragon", 20, Rarity.UNCOMMON, mage.cards.d.DanithaCapashenParagon.class));
        cards.add(new SetCardInfo("Daretti, Scrap Savant", 213, Rarity.RARE, mage.cards.d.DarettiScrapSavant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Daretti, Scrap Savant", 531, Rarity.RARE, mage.cards.d.DarettiScrapSavant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Darksteel Ingot", 378, Rarity.COMMON, mage.cards.d.DarksteelIngot.class));
        cards.add(new SetCardInfo("Darksteel Monolith", 743, Rarity.RARE, mage.cards.d.DarksteelMonolith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Darksteel Monolith", 778, Rarity.RARE, mage.cards.d.DarksteelMonolith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Darksteel Mutation", 21, Rarity.UNCOMMON, mage.cards.d.DarksteelMutation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Darksteel Mutation", 623, Rarity.UNCOMMON, mage.cards.d.DarksteelMutation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Day's Undoing", 486, Rarity.RARE, mage.cards.d.DaysUndoing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Day's Undoing", 85, Rarity.RARE, mage.cards.d.DaysUndoing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deadly Recluse", 282, Rarity.COMMON, mage.cards.d.DeadlyRecluse.class));
        cards.add(new SetCardInfo("Deadly Rollick", 147, Rarity.RARE, mage.cards.d.DeadlyRollick.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deadly Rollick", 507, Rarity.RARE, mage.cards.d.DeadlyRollick.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deadly Rollick", 695, Rarity.RARE, mage.cards.d.DeadlyRollick.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Decimate", 922, Rarity.RARE, mage.cards.d.Decimate.class));
        cards.add(new SetCardInfo("Decree of Pain", 148, Rarity.RARE, mage.cards.d.DecreeOfPain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Decree of Pain", 508, Rarity.RARE, mage.cards.d.DecreeOfPain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deep Analysis", 86, Rarity.COMMON, mage.cards.d.DeepAnalysis.class));
        cards.add(new SetCardInfo("Deepglow Skate", 844, Rarity.RARE, mage.cards.d.DeepglowSkate.class));
        cards.add(new SetCardInfo("Deflecting Swat", 214, Rarity.RARE, mage.cards.d.DeflectingSwat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deflecting Swat", 532, Rarity.RARE, mage.cards.d.DeflectingSwat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deflecting Swat", 698, Rarity.RARE, mage.cards.d.DeflectingSwat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demon of Fate's Design", 731, Rarity.RARE, mage.cards.d.DemonOfFatesDesign.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demon of Fate's Design", 762, Rarity.RARE, mage.cards.d.DemonOfFatesDesign.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demon's Disciple", 149, Rarity.COMMON, mage.cards.d.DemonsDisciple.class));
        cards.add(new SetCardInfo("Demonic Tutor", 150, Rarity.MYTHIC, mage.cards.d.DemonicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demonic Tutor", 509, Rarity.MYTHIC, mage.cards.d.DemonicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demonic Tutor", 696, Rarity.MYTHIC, mage.cards.d.DemonicTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demonlord Belzenlok", 151, Rarity.RARE, mage.cards.d.DemonlordBelzenlok.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Demonlord Belzenlok", 510, Rarity.RARE, mage.cards.d.DemonlordBelzenlok.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deploy the Gatewatch", 819, Rarity.MYTHIC, mage.cards.d.DeployTheGatewatch.class));
        cards.add(new SetCardInfo("Deranged Assistant", 87, Rarity.COMMON, mage.cards.d.DerangedAssistant.class));
        cards.add(new SetCardInfo("Descendants' Fury", 736, Rarity.RARE, mage.cards.d.DescendantsFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Descendants' Fury", 766, Rarity.RARE, mage.cards.d.DescendantsFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Desecrate Reality", 714, Rarity.RARE, mage.cards.d.DesecrateReality.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Desecrate Reality", 746, Rarity.RARE, mage.cards.d.DesecrateReality.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Destiny Spinner", 890, Rarity.UNCOMMON, mage.cards.d.DestinySpinner.class));
        cards.add(new SetCardInfo("Diffusion Sliver", 845, Rarity.UNCOMMON, mage.cards.d.DiffusionSliver.class));
        cards.add(new SetCardInfo("Disrupt Decorum", 1067, Rarity.RARE, mage.cards.d.DisruptDecorum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disrupt Decorum", 215, Rarity.RARE, mage.cards.d.DisruptDecorum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Disrupt Decorum", 533, Rarity.RARE, mage.cards.d.DisruptDecorum.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Distant Melody", 846, Rarity.COMMON, mage.cards.d.DistantMelody.class));
        cards.add(new SetCardInfo("Divergent Transformations", 216, Rarity.RARE, mage.cards.d.DivergentTransformations.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Divergent Transformations", 534, Rarity.RARE, mage.cards.d.DivergentTransformations.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doomwake Giant", 865, Rarity.RARE, mage.cards.d.DoomwakeGiant.class));
        cards.add(new SetCardInfo("Doubling Season", 283, Rarity.MYTHIC, mage.cards.d.DoublingSeason.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Doubling Season", 557, Rarity.MYTHIC, mage.cards.d.DoublingSeason.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dragon Fodder", 217, Rarity.COMMON, mage.cards.d.DragonFodder.class));
        cards.add(new SetCardInfo("Drakuseth, Maw of Flames", 218, Rarity.RARE, mage.cards.d.DrakusethMawOfFlames.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Drakuseth, Maw of Flames", 535, Rarity.RARE, mage.cards.d.DrakusethMawOfFlames.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dread Drone", 152, Rarity.COMMON, mage.cards.d.DreadDrone.class));
        cards.add(new SetCardInfo("Dread Return", 153, Rarity.COMMON, mage.cards.d.DreadReturn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dread Return", 637, Rarity.COMMON, mage.cards.d.DreadReturn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dreadhorde Invasion", 866, Rarity.RARE, mage.cards.d.DreadhordeInvasion.class));
        cards.add(new SetCardInfo("Dreamstone Hedron", 945, Rarity.UNCOMMON, mage.cards.d.DreamstoneHedron.class));
        cards.add(new SetCardInfo("Drown in Sorrow", 154, Rarity.COMMON, mage.cards.d.DrownInSorrow.class));
        cards.add(new SetCardInfo("Dryad of the Ilysian Grove", 891, Rarity.RARE, mage.cards.d.DryadOfTheIlysianGrove.class));
        cards.add(new SetCardInfo("Duplicant", 946, Rarity.RARE, mage.cards.d.Duplicant.class));
        cards.add(new SetCardInfo("Dwarven Hammer", 219, Rarity.COMMON, mage.cards.d.DwarvenHammer.class));
        cards.add(new SetCardInfo("Efficient Construction", 88, Rarity.UNCOMMON, mage.cards.e.EfficientConstruction.class));
        cards.add(new SetCardInfo("Eidolon of Blossoms", 892, Rarity.RARE, mage.cards.e.EidolonOfBlossoms.class));
        cards.add(new SetCardInfo("Eldrazi Temple", 992, Rarity.UNCOMMON, mage.cards.e.EldraziTemple.class));
        cards.add(new SetCardInfo("Elite Scaleguard", 22, Rarity.UNCOMMON, mage.cards.e.EliteScaleguard.class));
        cards.add(new SetCardInfo("Elspeth, Sun's Champion", 820, Rarity.MYTHIC, mage.cards.e.ElspethSunsChampion.class));
        cards.add(new SetCardInfo("Elvish Mystic", 284, Rarity.COMMON, mage.cards.e.ElvishMystic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elvish Mystic", 648, Rarity.COMMON, mage.cards.e.ElvishMystic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emerald Medallion", 379, Rarity.RARE, mage.cards.e.EmeraldMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emerald Medallion", 603, Rarity.RARE, mage.cards.e.EmeraldMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Enchantress's Presence", 893, Rarity.RARE, mage.cards.e.EnchantresssPresence.class));
        cards.add(new SetCardInfo("Endbringer", 803, Rarity.RARE, mage.cards.e.Endbringer.class));
        cards.add(new SetCardInfo("Endless Atlas", 947, Rarity.RARE, mage.cards.e.EndlessAtlas.class));
        cards.add(new SetCardInfo("Endless One", 804, Rarity.RARE, mage.cards.e.EndlessOne.class));
        cards.add(new SetCardInfo("Endrek Sahr, Master Breeder", 155, Rarity.RARE, mage.cards.e.EndrekSahrMasterBreeder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Endrek Sahr, Master Breeder", 511, Rarity.RARE, mage.cards.e.EndrekSahrMasterBreeder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Entourage of Trest", 285, Rarity.COMMON, mage.cards.e.EntourageOfTrest.class));
        cards.add(new SetCardInfo("Erebos, Bleak-Hearted", 868, Rarity.MYTHIC, mage.cards.e.ErebosBleakHearted.class));
        cards.add(new SetCardInfo("Eternal Witness", 286, Rarity.UNCOMMON, mage.cards.e.EternalWitness.class));
        cards.add(new SetCardInfo("Evacuation", 487, Rarity.RARE, mage.cards.e.Evacuation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Evacuation", 89, Rarity.RARE, mage.cards.e.Evacuation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Everflowing Chalice", 948, Rarity.UNCOMMON, mage.cards.e.EverflowingChalice.class));
        cards.add(new SetCardInfo("Exclude", 90, Rarity.COMMON, mage.cards.e.Exclude.class));
        cards.add(new SetCardInfo("Exotic Orchard", 993, Rarity.RARE, mage.cards.e.ExoticOrchard.class));
        cards.add(new SetCardInfo("Experiment Kraj", 337, Rarity.RARE, mage.cards.e.ExperimentKraj.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Experiment Kraj", 578, Rarity.RARE, mage.cards.e.ExperimentKraj.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Explorer's Scope", 380, Rarity.COMMON, mage.cards.e.ExplorersScope.class));
        cards.add(new SetCardInfo("Exsanguinate", 156, Rarity.UNCOMMON, mage.cards.e.Exsanguinate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Exsanguinate", 638, Rarity.UNCOMMON, mage.cards.e.Exsanguinate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Extinguish All Hope", 157, Rarity.UNCOMMON, mage.cards.e.ExtinguishAllHope.class));
        cards.add(new SetCardInfo("Extraplanar Lens", 381, Rarity.MYTHIC, mage.cards.e.ExtraplanarLens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Extraplanar Lens", 604, Rarity.MYTHIC, mage.cards.e.ExtraplanarLens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Extraplanar Lens", 656, Rarity.MYTHIC, mage.cards.e.ExtraplanarLens.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ezuri's Predation", 287, Rarity.RARE, mage.cards.e.EzurisPredation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ezuri's Predation", 558, Rarity.RARE, mage.cards.e.EzurisPredation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fact or Fiction", 631, Rarity.UNCOMMON, mage.cards.f.FactOrFiction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fact or Fiction", 91, Rarity.UNCOMMON, mage.cards.f.FactOrFiction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faerie Artisans", 488, Rarity.RARE, mage.cards.f.FaerieArtisans.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faerie Artisans", 92, Rarity.RARE, mage.cards.f.FaerieArtisans.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faithless Looting", 220, Rarity.COMMON, mage.cards.f.FaithlessLooting.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faithless Looting", 642, Rarity.COMMON, mage.cards.f.FaithlessLooting.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fall from Favor", 93, Rarity.COMMON, mage.cards.f.FallFromFavor.class));
        cards.add(new SetCardInfo("Farseek", 894, Rarity.COMMON, mage.cards.f.Farseek.class));
        cards.add(new SetCardInfo("Feast of Succession", 158, Rarity.UNCOMMON, mage.cards.f.FeastOfSuccession.class));
        cards.add(new SetCardInfo("Feed the Swarm", 159, Rarity.COMMON, mage.cards.f.FeedTheSwarm.class));
        cards.add(new SetCardInfo("Felidar Retreat", 821, Rarity.RARE, mage.cards.f.FelidarRetreat.class));
        cards.add(new SetCardInfo("Fellwar Stone", 382, Rarity.UNCOMMON, mage.cards.f.FellwarStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fellwar Stone", 657, Rarity.UNCOMMON, mage.cards.f.FellwarStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fencing Ace", 23, Rarity.UNCOMMON, mage.cards.f.FencingAce.class));
        cards.add(new SetCardInfo("Fiendlash", 221, Rarity.UNCOMMON, mage.cards.f.Fiendlash.class));
        cards.add(new SetCardInfo("Fierce Empath", 288, Rarity.COMMON, mage.cards.f.FierceEmpath.class));
        cards.add(new SetCardInfo("Fierce Guardianship", 489, Rarity.RARE, mage.cards.f.FierceGuardianship.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fierce Guardianship", 694, Rarity.RARE, mage.cards.f.FierceGuardianship.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fierce Guardianship", 94, Rarity.RARE, mage.cards.f.FierceGuardianship.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Confluence", 222, Rarity.RARE, mage.cards.f.FieryConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Confluence", 536, Rarity.RARE, mage.cards.f.FieryConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Filigree Attendant", 95, Rarity.COMMON, mage.cards.f.FiligreeAttendant.class));
        cards.add(new SetCardInfo("Final Parting", 160, Rarity.UNCOMMON, mage.cards.f.FinalParting.class));
        cards.add(new SetCardInfo("Finale of Devastation", 289, Rarity.MYTHIC, mage.cards.f.FinaleOfDevastation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Finale of Devastation", 559, Rarity.MYTHIC, mage.cards.f.FinaleOfDevastation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Finale of Devastation", 700, Rarity.MYTHIC, mage.cards.f.FinaleOfDevastation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Firemind Vessel", 383, Rarity.COMMON, mage.cards.f.FiremindVessel.class));
        cards.add(new SetCardInfo("Fireshrieker", 949, Rarity.UNCOMMON, mage.cards.f.Fireshrieker.class));
        cards.add(new SetCardInfo("Firewake Sliver", 923, Rarity.UNCOMMON, mage.cards.f.FirewakeSliver.class));
        cards.add(new SetCardInfo("Fists of Flame", 223, Rarity.COMMON, mage.cards.f.FistsOfFlame.class));
        cards.add(new SetCardInfo("Flawless Maneuver", 24, Rarity.RARE, mage.cards.f.FlawlessManeuver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flawless Maneuver", 459, Rarity.RARE, mage.cards.f.FlawlessManeuver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flawless Maneuver", 692, Rarity.RARE, mage.cards.f.FlawlessManeuver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flayer of Loyalties", 715, Rarity.RARE, mage.cards.f.FlayerOfLoyalties.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flayer of Loyalties", 747, Rarity.RARE, mage.cards.f.FlayerOfLoyalties.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flood Plain", 994, Rarity.UNCOMMON, mage.cards.f.FloodPlain.class));
        cards.add(new SetCardInfo("Flux Channeler", 847, Rarity.UNCOMMON, mage.cards.f.FluxChanneler.class));
        cards.add(new SetCardInfo("Fog Bank", 848, Rarity.UNCOMMON, mage.cards.f.FogBank.class));
        cards.add(new SetCardInfo("Font of Fertility", 895, Rarity.COMMON, mage.cards.f.FontOfFertility.class));
        cards.add(new SetCardInfo("For the Ancestors", 740, Rarity.RARE, mage.cards.f.ForTheAncestors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("For the Ancestors", 770, Rarity.RARE, mage.cards.f.ForTheAncestors.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forebear's Blade", 384, Rarity.UNCOMMON, mage.cards.f.ForebearsBlade.class));
        cards.add(new SetCardInfo("Forest", 449, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 450, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 451, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 797, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 798, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 799, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forge of Heroes", 995, Rarity.COMMON, mage.cards.f.ForgeOfHeroes.class));
        cards.add(new SetCardInfo("Forsaken Monument", 950, Rarity.MYTHIC, mage.cards.f.ForsakenMonument.class));
        cards.add(new SetCardInfo("Fortified Village", 996, Rarity.RARE, mage.cards.f.FortifiedVillage.class));
        cards.add(new SetCardInfo("Foundry Inspector", 385, Rarity.COMMON, mage.cards.f.FoundryInspector.class));
        cards.add(new SetCardInfo("Frantic Search", 632, Rarity.COMMON, mage.cards.f.FranticSearch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frantic Search", 96, Rarity.COMMON, mage.cards.f.FranticSearch.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Freyalise, Llanowar's Fury", 290, Rarity.RARE, mage.cards.f.FreyaliseLlanowarsFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Freyalise, Llanowar's Fury", 560, Rarity.RARE, mage.cards.f.FreyaliseLlanowarsFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Frontier Bivouac", 997, Rarity.UNCOMMON, mage.cards.f.FrontierBivouac.class));
        cards.add(new SetCardInfo("Frontier Warmonger", 224, Rarity.UNCOMMON, mage.cards.f.FrontierWarmonger.class));
        cards.add(new SetCardInfo("Frostboil Snarl", 998, Rarity.RARE, mage.cards.f.FrostboilSnarl.class));
        cards.add(new SetCardInfo("Fungal Plots", 291, Rarity.UNCOMMON, mage.cards.f.FungalPlots.class));
        cards.add(new SetCardInfo("Furious Rise", 225, Rarity.UNCOMMON, mage.cards.f.FuriousRise.class));
        cards.add(new SetCardInfo("Furycalm Snarl", 999, Rarity.RARE, mage.cards.f.FurycalmSnarl.class));
        cards.add(new SetCardInfo("Galerider Sliver", 849, Rarity.RARE, mage.cards.g.GaleriderSliver.class));
        cards.add(new SetCardInfo("Gargadon", 226, Rarity.COMMON, mage.cards.g.Gargadon.class));
        cards.add(new SetCardInfo("Gatewatch Beacon", 721, Rarity.RARE, mage.cards.g.GatewatchBeacon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gatewatch Beacon", 754, Rarity.RARE, mage.cards.g.GatewatchBeacon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gavony Silversmith", 25, Rarity.COMMON, mage.cards.g.GavonySilversmith.class));
        cards.add(new SetCardInfo("Geier Reach Sanitarium", 1000, Rarity.RARE, mage.cards.g.GeierReachSanitarium.class));
        cards.add(new SetCardInfo("Gemhide Sliver", 896, Rarity.COMMON, mage.cards.g.GemhideSliver.class));
        cards.add(new SetCardInfo("Generous Gift", 26, Rarity.COMMON, mage.cards.g.GenerousGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Generous Gift", 624, Rarity.COMMON, mage.cards.g.GenerousGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Geode Golem", 386, Rarity.UNCOMMON, mage.cards.g.GeodeGolem.class));
        cards.add(new SetCardInfo("Ghalta, Primal Hunger", 292, Rarity.RARE, mage.cards.g.GhaltaPrimalHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghalta, Primal Hunger", 561, Rarity.RARE, mage.cards.g.GhaltaPrimalHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghost of Ramirez DePietro", 97, Rarity.UNCOMMON, mage.cards.g.GhostOfRamirezDePietro.class));
        cards.add(new SetCardInfo("Ghostly Flicker", 98, Rarity.COMMON, mage.cards.g.GhostlyFlicker.class));
        cards.add(new SetCardInfo("Ghoulcaller Gisa", 161, Rarity.RARE, mage.cards.g.GhoulcallerGisa.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghoulcaller Gisa", 512, Rarity.RARE, mage.cards.g.GhoulcallerGisa.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghoulish Impetus", 732, Rarity.RARE, mage.cards.g.GhoulishImpetus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghoulish Impetus", 763, Rarity.RARE, mage.cards.g.GhoulishImpetus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gideon Jura", 822, Rarity.MYTHIC, mage.cards.g.GideonJura.class));
        cards.add(new SetCardInfo("Gilded Lotus", 387, Rarity.RARE, mage.cards.g.GildedLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gilded Lotus", 605, Rarity.RARE, mage.cards.g.GildedLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gisela, Blade of Goldnight", 338, Rarity.RARE, mage.cards.g.GiselaBladeOfGoldnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gisela, Blade of Goldnight", 579, Rarity.RARE, mage.cards.g.GiselaBladeOfGoldnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gisela, Blade of Goldnight", 682, Rarity.RARE, mage.cards.g.GiselaBladeOfGoldnight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Godo, Bandit Warlord", 227, Rarity.RARE, mage.cards.g.GodoBanditWarlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Godo, Bandit Warlord", 537, Rarity.RARE, mage.cards.g.GodoBanditWarlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Golgari Rot Farm", 1001, Rarity.COMMON, mage.cards.g.GolgariRotFarm.class));
        cards.add(new SetCardInfo("Goliath Sphinx", 99, Rarity.COMMON, mage.cards.g.GoliathSphinx.class));
        cards.add(new SetCardInfo("Gonti, Lord of Luxury", 162, Rarity.UNCOMMON, mage.cards.g.GontiLordOfLuxury.class));
        cards.add(new SetCardInfo("Goreclaw, Terror of Qal Sisma", 293, Rarity.UNCOMMON, mage.cards.g.GoreclawTerrorOfQalSisma.class));
        cards.add(new SetCardInfo("Goremand", 163, Rarity.UNCOMMON, mage.cards.g.Goremand.class));
        cards.add(new SetCardInfo("Gorex, the Tombshell", 164, Rarity.UNCOMMON, mage.cards.g.GorexTheTombshell.class));
        cards.add(new SetCardInfo("Grand Abolisher", 27, Rarity.RARE, mage.cards.g.GrandAbolisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Abolisher", 460, Rarity.RARE, mage.cards.g.GrandAbolisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grand Abolisher", 625, Rarity.RARE, mage.cards.g.GrandAbolisher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grasp of Fate", 823, Rarity.RARE, mage.cards.g.GraspOfFate.class));
        cards.add(new SetCardInfo("Grasslands", 1002, Rarity.UNCOMMON, mage.cards.g.Grasslands.class));
        cards.add(new SetCardInfo("Grateful Apparition", 824, Rarity.UNCOMMON, mage.cards.g.GratefulApparition.class));
        cards.add(new SetCardInfo("Grave Pact", 165, Rarity.MYTHIC, mage.cards.g.GravePact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grave Pact", 513, Rarity.MYTHIC, mage.cards.g.GravePact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grave Pact", 639, Rarity.MYTHIC, mage.cards.g.GravePact.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Greater Tanuki", 897, Rarity.COMMON, mage.cards.g.GreaterTanuki.class));
        cards.add(new SetCardInfo("Grenzo, Havoc Raiser", 228, Rarity.RARE, mage.cards.g.GrenzoHavocRaiser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grenzo, Havoc Raiser", 538, Rarity.RARE, mage.cards.g.GrenzoHavocRaiser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grenzo, Havoc Raiser", 677, Rarity.RARE, mage.cards.g.GrenzoHavocRaiser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guff Rewrites History", 737, Rarity.RARE, mage.cards.g.GuffRewritesHistory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guff Rewrites History", 767, Rarity.RARE, mage.cards.g.GuffRewritesHistory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guildless Commons", 1003, Rarity.UNCOMMON, mage.cards.g.GuildlessCommons.class));
        cards.add(new SetCardInfo("Guttersnipe", 229, Rarity.COMMON, mage.cards.g.Guttersnipe.class));
        cards.add(new SetCardInfo("Hammer of Nazahn", 388, Rarity.RARE, mage.cards.h.HammerOfNazahn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hammer of Nazahn", 606, Rarity.RARE, mage.cards.h.HammerOfNazahn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hamza, Guardian of Arashin", 339, Rarity.UNCOMMON, mage.cards.h.HamzaGuardianOfArashin.class));
        cards.add(new SetCardInfo("Hangarback Walker", 951, Rarity.RARE, mage.cards.h.HangarbackWalker.class));
        cards.add(new SetCardInfo("Hanna, Ship's Navigator", 340, Rarity.RARE, mage.cards.h.HannaShipsNavigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hanna, Ship's Navigator", 580, Rarity.RARE, mage.cards.h.HannaShipsNavigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harmonic Sliver", 924, Rarity.UNCOMMON, mage.cards.h.HarmonicSliver.class));
        cards.add(new SetCardInfo("Harsh Mercy", 825, Rarity.RARE, mage.cards.h.HarshMercy.class));
        cards.add(new SetCardInfo("Hatchery Sliver", 741, Rarity.RARE, mage.cards.h.HatcherySliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hatchery Sliver", 771, Rarity.RARE, mage.cards.h.HatcherySliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Haunted Cloak", 389, Rarity.COMMON, mage.cards.h.HauntedCloak.class));
        cards.add(new SetCardInfo("Havoc Jester", 230, Rarity.UNCOMMON, mage.cards.h.HavocJester.class));
        cards.add(new SetCardInfo("Heart-Piercer Bow", 390, Rarity.COMMON, mage.cards.h.HeartPiercerBow.class));
        cards.add(new SetCardInfo("Heartless Act", 166, Rarity.UNCOMMON, mage.cards.h.HeartlessAct.class));
        cards.add(new SetCardInfo("Heartless Hidetsugu", 231, Rarity.RARE, mage.cards.h.HeartlessHidetsugu.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Heartless Hidetsugu", 539, Rarity.RARE, mage.cards.h.HeartlessHidetsugu.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Heavenly Blademaster", 28, Rarity.RARE, mage.cards.h.HeavenlyBlademaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Heavenly Blademaster", 461, Rarity.RARE, mage.cards.h.HeavenlyBlademaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hedron Archive", 952, Rarity.UNCOMMON, mage.cards.h.HedronArchive.class));
        cards.add(new SetCardInfo("Heliod, God of the Sun", 826, Rarity.MYTHIC, mage.cards.h.HeliodGodOfTheSun.class));
        cards.add(new SetCardInfo("Heliod, Sun-Crowned", 29, Rarity.MYTHIC, mage.cards.h.HeliodSunCrowned.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Heliod, Sun-Crowned", 462, Rarity.MYTHIC, mage.cards.h.HeliodSunCrowned.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hellkite Charger", 232, Rarity.RARE, mage.cards.h.HellkiteCharger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hellkite Charger", 540, Rarity.RARE, mage.cards.h.HellkiteCharger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Herald of the Host", 30, Rarity.UNCOMMON, mage.cards.h.HeraldOfTheHost.class));
        cards.add(new SetCardInfo("Herald of the Pantheon", 898, Rarity.RARE, mage.cards.h.HeraldOfThePantheon.class));
        cards.add(new SetCardInfo("Herald's Horn", 953, Rarity.UNCOMMON, mage.cards.h.HeraldsHorn.class));
        cards.add(new SetCardInfo("Hero's Blade", 391, Rarity.UNCOMMON, mage.cards.h.HerosBlade.class));
        cards.add(new SetCardInfo("Heroic Intervention", 295, Rarity.RARE, mage.cards.h.HeroicIntervention.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Heroic Intervention", 563, Rarity.RARE, mage.cards.h.HeroicIntervention.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hibernation Sliver", 925, Rarity.UNCOMMON, mage.cards.h.HibernationSliver.class));
        cards.add(new SetCardInfo("Hoarding Dragon", 233, Rarity.UNCOMMON, mage.cards.h.HoardingDragon.class));
        cards.add(new SetCardInfo("Hollowhead Sliver", 878, Rarity.UNCOMMON, mage.cards.h.HollowheadSliver.class));
        cards.add(new SetCardInfo("Honor-Worn Shaku", 954, Rarity.UNCOMMON, mage.cards.h.HonorWornShaku.class));
        cards.add(new SetCardInfo("Hunter's Insight", 296, Rarity.UNCOMMON, mage.cards.h.HuntersInsight.class));
        cards.add(new SetCardInfo("Icon of Ancestry", 955, Rarity.RARE, mage.cards.i.IconOfAncestry.class));
        cards.add(new SetCardInfo("Idol of Oblivion", 392, Rarity.RARE, mage.cards.i.IdolOfOblivion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Idol of Oblivion", 607, Rarity.RARE, mage.cards.i.IdolOfOblivion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ilysian Caryatid", 297, Rarity.COMMON, mage.cards.i.IlysianCaryatid.class));
        cards.add(new SetCardInfo("Imp's Mischief", 167, Rarity.RARE, mage.cards.i.ImpsMischief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Imp's Mischief", 514, Rarity.RARE, mage.cards.i.ImpsMischief.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Impulsive Pilferer", 234, Rarity.COMMON, mage.cards.i.ImpulsivePilferer.class));
        cards.add(new SetCardInfo("Inferno Titan", 235, Rarity.RARE, mage.cards.i.InfernoTitan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inferno Titan", 541, Rarity.RARE, mage.cards.i.InfernoTitan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inga Rune-Eyes", 100, Rarity.UNCOMMON, mage.cards.i.IngaRuneEyes.class));
        cards.add(new SetCardInfo("Inspiring Statuary", 394, Rarity.RARE, mage.cards.i.InspiringStatuary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inspiring Statuary", 609, Rarity.RARE, mage.cards.i.InspiringStatuary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Insurrection", 236, Rarity.MYTHIC, mage.cards.i.Insurrection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Insurrection", 542, Rarity.MYTHIC, mage.cards.i.Insurrection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Insurrection", 699, Rarity.MYTHIC, mage.cards.i.Insurrection.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Intangible Virtue", 31, Rarity.UNCOMMON, mage.cards.i.IntangibleVirtue.class));
        cards.add(new SetCardInfo("Interplanar Beacon", 1004, Rarity.UNCOMMON, mage.cards.i.InterplanarBeacon.class));
        cards.add(new SetCardInfo("Investigator's Journal", 956, Rarity.RARE, mage.cards.i.InvestigatorsJournal.class));
        cards.add(new SetCardInfo("Irrigated Farmland", 1005, Rarity.RARE, mage.cards.i.IrrigatedFarmland.class));
        cards.add(new SetCardInfo("Isareth the Awakener", 168, Rarity.UNCOMMON, mage.cards.i.IsarethTheAwakener.class));
        cards.add(new SetCardInfo("Island", 440, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 441, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 442, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 788, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 789, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 790, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("It That Betrays", 805, Rarity.RARE, mage.cards.i.ItThatBetrays.class));
        cards.add(new SetCardInfo("Izzet Signet", 957, Rarity.UNCOMMON, mage.cards.i.IzzetSignet.class));
        cards.add(new SetCardInfo("Jace Beleren", 850, Rarity.MYTHIC, mage.cards.j.JaceBeleren.class));
        cards.add(new SetCardInfo("Jace, Architect of Thought", 851, Rarity.MYTHIC, mage.cards.j.JaceArchitectOfThought.class));
        cards.add(new SetCardInfo("Jace, Mirror Mage", 852, Rarity.MYTHIC, mage.cards.j.JaceMirrorMage.class));
        cards.add(new SetCardInfo("Jade Mage", 298, Rarity.UNCOMMON, mage.cards.j.JadeMage.class));
        cards.add(new SetCardInfo("Jaya's Phoenix", 738, Rarity.RARE, mage.cards.j.JayasPhoenix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jaya's Phoenix", 768, Rarity.RARE, mage.cards.j.JayasPhoenix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jazal Goldmane", 32, Rarity.RARE, mage.cards.j.JazalGoldmane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jazal Goldmane", 463, Rarity.RARE, mage.cards.j.JazalGoldmane.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jet Medallion", 395, Rarity.RARE, mage.cards.j.JetMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jet Medallion", 610, Rarity.RARE, mage.cards.j.JetMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeweled Lotus", 1066, Rarity.MYTHIC, mage.cards.j.JeweledLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeweled Lotus", 396, Rarity.MYTHIC, mage.cards.j.JeweledLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeweled Lotus", 611, Rarity.MYTHIC, mage.cards.j.JeweledLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeweled Lotus", 702, Rarity.MYTHIC, mage.cards.j.JeweledLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jolrael, Mwonvuli Recluse", 299, Rarity.RARE, mage.cards.j.JolraelMwonvuliRecluse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jolrael, Mwonvuli Recluse", 564, Rarity.RARE, mage.cards.j.JolraelMwonvuliRecluse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Judith, the Scourge Diva", 341, Rarity.UNCOMMON, mage.cards.j.JudithTheScourgeDiva.class));
        cards.add(new SetCardInfo("Jukai Naturalist", 926, Rarity.UNCOMMON, mage.cards.j.JukaiNaturalist.class));
        cards.add(new SetCardInfo("Jungle Shrine", 1006, Rarity.UNCOMMON, mage.cards.j.JungleShrine.class));
        cards.add(new SetCardInfo("Kaho, Minamo Historian", 101, Rarity.UNCOMMON, mage.cards.k.KahoMinamoHistorian.class));
        cards.add(new SetCardInfo("Kaldra Compleat", 958, Rarity.MYTHIC, mage.cards.k.KaldraCompleat.class));
        cards.add(new SetCardInfo("Karador, Ghost Chieftain", 342, Rarity.RARE, mage.cards.k.KaradorGhostChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karador, Ghost Chieftain", 581, Rarity.RARE, mage.cards.k.KaradorGhostChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karn's Bastion", 1007, Rarity.RARE, mage.cards.k.KarnsBastion.class));
        cards.add(new SetCardInfo("Kazuul, Tyrant of the Cliffs", 237, Rarity.UNCOMMON, mage.cards.k.KazuulTyrantOfTheCliffs.class));
        cards.add(new SetCardInfo("Keleth, Sunmane Familiar", 33, Rarity.UNCOMMON, mage.cards.k.KelethSunmaneFamiliar.class));
        cards.add(new SetCardInfo("Kemba, Kha Regent", 34, Rarity.UNCOMMON, mage.cards.k.KembaKhaRegent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kemba, Kha Regent", 671, Rarity.UNCOMMON, mage.cards.k.KembaKhaRegent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Khalni Heart Expedition", 899, Rarity.COMMON, mage.cards.k.KhalniHeartExpedition.class));
        cards.add(new SetCardInfo("Kindred Dominance", 169, Rarity.RARE, mage.cards.k.KindredDominance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kindred Dominance", 515, Rarity.RARE, mage.cards.k.KindredDominance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kindred Dominance", 640, Rarity.RARE, mage.cards.k.KindredDominance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kirtar's Wrath", 35, Rarity.UNCOMMON, mage.cards.k.KirtarsWrath.class));
        cards.add(new SetCardInfo("Knighted Myr", 36, Rarity.COMMON, mage.cards.k.KnightedMyr.class));
        cards.add(new SetCardInfo("Kodama's Reach", 300, Rarity.COMMON, mage.cards.k.KodamasReach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kodama's Reach", 649, Rarity.COMMON, mage.cards.k.KodamasReach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kozilek's Predator", 301, Rarity.COMMON, mage.cards.k.KozileksPredator.class));
        cards.add(new SetCardInfo("Kozilek, the Great Distortion", 1057, Rarity.MYTHIC, mage.cards.k.KozilekTheGreatDistortion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kozilek, the Great Distortion", 2, Rarity.MYTHIC, mage.cards.k.KozilekTheGreatDistortion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kozilek, the Great Distortion", 452, Rarity.MYTHIC, mage.cards.k.KozilekTheGreatDistortion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kozilek, the Great Distortion", 668, Rarity.MYTHIC, mage.cards.k.KozilekTheGreatDistortion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krenko, Mob Boss", 238, Rarity.RARE, mage.cards.k.KrenkoMobBoss.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krenko, Mob Boss", 543, Rarity.RARE, mage.cards.k.KrenkoMobBoss.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krosan Tusker", 302, Rarity.COMMON, mage.cards.k.KrosanTusker.class));
        cards.add(new SetCardInfo("Krosan Verge", 1008, Rarity.UNCOMMON, mage.cards.k.KrosanVerge.class));
        cards.add(new SetCardInfo("Kykar, Wind's Fury", 343, Rarity.RARE, mage.cards.k.KykarWindsFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kykar, Wind's Fury", 582, Rarity.RARE, mage.cards.k.KykarWindsFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kykar, Wind's Fury", 683, Rarity.RARE, mage.cards.k.KykarWindsFury.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Land Tax", 37, Rarity.MYTHIC, mage.cards.l.LandTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Land Tax", 464, Rarity.MYTHIC, mage.cards.l.LandTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lavabelly Sliver", 927, Rarity.UNCOMMON, mage.cards.l.LavabellySliver.class));
        cards.add(new SetCardInfo("Lazotep Sliver", 733, Rarity.RARE, mage.cards.l.LazotepSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lazotep Sliver", 764, Rarity.RARE, mage.cards.l.LazotepSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Legion Vanguard", 170, Rarity.COMMON, mage.cards.l.LegionVanguard.class));
        cards.add(new SetCardInfo("Leori, Sparktouched Hunter", 709, Rarity.MYTHIC, mage.cards.l.LeoriSparktouchedHunter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leori, Sparktouched Hunter", 774, Rarity.MYTHIC, mage.cards.l.LeoriSparktouchedHunter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Letter of Acceptance", 397, Rarity.COMMON, mage.cards.l.LetterOfAcceptance.class));
        cards.add(new SetCardInfo("Lifeblood Hydra", 303, Rarity.RARE, mage.cards.l.LifebloodHydra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lifeblood Hydra", 565, Rarity.RARE, mage.cards.l.LifebloodHydra.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lightning Greaves", 398, Rarity.UNCOMMON, mage.cards.l.LightningGreaves.class));
        cards.add(new SetCardInfo("Living Lightning", 239, Rarity.COMMON, mage.cards.l.LivingLightning.class));
        cards.add(new SetCardInfo("Looter il-Kor", 102, Rarity.COMMON, mage.cards.l.LooterIlKor.class));
        cards.add(new SetCardInfo("Lorthos, the Tidemaker", 103, Rarity.RARE, mage.cards.l.LorthosTheTidemaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lorthos, the Tidemaker", 490, Rarity.RARE, mage.cards.l.LorthosTheTidemaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Losheel, Clockwork Scholar", 38, Rarity.UNCOMMON, mage.cards.l.LosheelClockworkScholar.class));
        cards.add(new SetCardInfo("Lotleth Giant", 171, Rarity.COMMON, mage.cards.l.LotlethGiant.class));
        cards.add(new SetCardInfo("Love Song of Night and Day", 827, Rarity.UNCOMMON, mage.cards.l.LoveSongOfNightAndDay.class));
        cards.add(new SetCardInfo("Loyal Apprentice", 240, Rarity.UNCOMMON, mage.cards.l.LoyalApprentice.class));
        cards.add(new SetCardInfo("Loyal Drake", 104, Rarity.UNCOMMON, mage.cards.l.LoyalDrake.class));
        cards.add(new SetCardInfo("Loyal Guardian", 304, Rarity.UNCOMMON, mage.cards.l.LoyalGuardian.class));
        cards.add(new SetCardInfo("Loyal Retainers", 39, Rarity.MYTHIC, mage.cards.l.LoyalRetainers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Loyal Retainers", 465, Rarity.MYTHIC, mage.cards.l.LoyalRetainers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Loyal Subordinate", 172, Rarity.UNCOMMON, mage.cards.l.LoyalSubordinate.class));
        cards.add(new SetCardInfo("Loyal Unicorn", 40, Rarity.UNCOMMON, mage.cards.l.LoyalUnicorn.class));
        cards.add(new SetCardInfo("Mace of the Valiant", 41, Rarity.UNCOMMON, mage.cards.m.MaceOfTheValiant.class));
        cards.add(new SetCardInfo("Maelstrom Wanderer", 344, Rarity.RARE, mage.cards.m.MaelstromWanderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maelstrom Wanderer", 583, Rarity.RARE, mage.cards.m.MaelstromWanderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Maelstrom Wanderer", 684, Rarity.RARE, mage.cards.m.MaelstromWanderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mage-Ring Network", 1009, Rarity.UNCOMMON, mage.cards.m.MageRingNetwork.class));
        cards.add(new SetCardInfo("Magus of the Wheel", 241, Rarity.RARE, mage.cards.m.MagusOfTheWheel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Magus of the Wheel", 544, Rarity.RARE, mage.cards.m.MagusOfTheWheel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Magus of the Wheel", 643, Rarity.RARE, mage.cards.m.MagusOfTheWheel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Makeshift Munitions", 242, Rarity.COMMON, mage.cards.m.MakeshiftMunitions.class));
        cards.add(new SetCardInfo("Manaweft Sliver", 900, Rarity.UNCOMMON, mage.cards.m.ManaweftSliver.class));
        cards.add(new SetCardInfo("Mangara, the Diplomat", 42, Rarity.RARE, mage.cards.m.MangaraTheDiplomat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mangara, the Diplomat", 466, Rarity.RARE, mage.cards.m.MangaraTheDiplomat.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Matter Reshaper", 806, Rarity.RARE, mage.cards.m.MatterReshaper.class));
        cards.add(new SetCardInfo("Mazemind Tome", 959, Rarity.RARE, mage.cards.m.MazemindTome.class));
        cards.add(new SetCardInfo("Megantic Sliver", 901, Rarity.RARE, mage.cards.m.MeganticSliver.class));
        cards.add(new SetCardInfo("Melek, Izzet Paragon", 345, Rarity.UNCOMMON, mage.cards.m.MelekIzzetParagon.class));
        cards.add(new SetCardInfo("Meren of Clan Nel Toth", 346, Rarity.RARE, mage.cards.m.MerenOfClanNelToth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meren of Clan Nel Toth", 584, Rarity.RARE, mage.cards.m.MerenOfClanNelToth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meren of Clan Nel Toth", 685, Rarity.RARE, mage.cards.m.MerenOfClanNelToth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mesa Enchantress", 828, Rarity.RARE, mage.cards.m.MesaEnchantress.class));
        cards.add(new SetCardInfo("Metalwork Colossus", 960, Rarity.RARE, mage.cards.m.MetalworkColossus.class));
        cards.add(new SetCardInfo("Meteor Golem", 399, Rarity.UNCOMMON, mage.cards.m.MeteorGolem.class));
        cards.add(new SetCardInfo("Meteoric Mace", 243, Rarity.UNCOMMON, mage.cards.m.MeteoricMace.class));
        cards.add(new SetCardInfo("Might Sliver", 903, Rarity.UNCOMMON, mage.cards.m.MightSliver.class));
        cards.add(new SetCardInfo("Mikaeus, the Unhallowed", 1061, Rarity.MYTHIC, mage.cards.m.MikaeusTheUnhallowed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mikaeus, the Unhallowed", 173, Rarity.MYTHIC, mage.cards.m.MikaeusTheUnhallowed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mikaeus, the Unhallowed", 516, Rarity.MYTHIC, mage.cards.m.MikaeusTheUnhallowed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mikaeus, the Unhallowed", 675, Rarity.MYTHIC, mage.cards.m.MikaeusTheUnhallowed.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mind Stone", 961, Rarity.COMMON, mage.cards.m.MindStone.class));
        cards.add(new SetCardInfo("Minds Aglow", 105, Rarity.RARE, mage.cards.m.MindsAglow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Minds Aglow", 491, Rarity.RARE, mage.cards.m.MindsAglow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mindwrack Harpy", 869, Rarity.COMMON, mage.cards.m.MindwrackHarpy.class));
        cards.add(new SetCardInfo("Ministrant of Obligation", 43, Rarity.COMMON, mage.cards.m.MinistrantOfObligation.class));
        cards.add(new SetCardInfo("Mirage Mirror", 962, Rarity.RARE, mage.cards.m.MirageMirror.class));
        cards.add(new SetCardInfo("Mirari's Wake", 928, Rarity.MYTHIC, mage.cards.m.MirarisWake.class));
        cards.add(new SetCardInfo("Mire Triton", 174, Rarity.COMMON, mage.cards.m.MireTriton.class));
        cards.add(new SetCardInfo("Mirri, Weatherlight Duelist", 347, Rarity.RARE, mage.cards.m.MirriWeatherlightDuelist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirri, Weatherlight Duelist", 585, Rarity.RARE, mage.cards.m.MirriWeatherlightDuelist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mirrorpool", 1010, Rarity.MYTHIC, mage.cards.m.Mirrorpool.class));
        cards.add(new SetCardInfo("Mizzix of the Izmagnus", 348, Rarity.RARE, mage.cards.m.MizzixOfTheIzmagnus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mizzix of the Izmagnus", 586, Rarity.RARE, mage.cards.m.MizzixOfTheIzmagnus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mobilized District", 1011, Rarity.RARE, mage.cards.m.MobilizedDistrict.class));
        cards.add(new SetCardInfo("Molimo, Maro-Sorcerer", 305, Rarity.UNCOMMON, mage.cards.m.MolimoMaroSorcerer.class));
        cards.add(new SetCardInfo("Morophon, the Boundless", 1058, Rarity.MYTHIC, mage.cards.m.MorophonTheBoundless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Morophon, the Boundless", 3, Rarity.MYTHIC, mage.cards.m.MorophonTheBoundless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Morophon, the Boundless", 453, Rarity.MYTHIC, mage.cards.m.MorophonTheBoundless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Morophon, the Boundless", 669, Rarity.MYTHIC, mage.cards.m.MorophonTheBoundless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain Valley", 1012, Rarity.UNCOMMON, mage.cards.m.MountainValley.class));
        cards.add(new SetCardInfo("Mountain", 446, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 447, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 448, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 794, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 795, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 796, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mowu, Loyal Companion", 306, Rarity.UNCOMMON, mage.cards.m.MowuLoyalCompanion.class));
        cards.add(new SetCardInfo("Murder of Crows", 106, Rarity.UNCOMMON, mage.cards.m.MurderOfCrows.class));
        cards.add(new SetCardInfo("Murmuring Mystic", 107, Rarity.COMMON, mage.cards.m.MurmuringMystic.class));
        cards.add(new SetCardInfo("Myr Sire", 400, Rarity.COMMON, mage.cards.m.MyrSire.class));
        cards.add(new SetCardInfo("Myriad Construct", 963, Rarity.RARE, mage.cards.m.MyriadConstruct.class));
        cards.add(new SetCardInfo("Myriad Landscape", 421, Rarity.UNCOMMON, mage.cards.m.MyriadLandscape.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Myriad Landscape", 660, Rarity.UNCOMMON, mage.cards.m.MyriadLandscape.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Myrsmith", 44, Rarity.COMMON, mage.cards.m.Myrsmith.class));
        cards.add(new SetCardInfo("Mystic Confluence", 108, Rarity.RARE, mage.cards.m.MysticConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mystic Confluence", 492, Rarity.RARE, mage.cards.m.MysticConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mystic Forge", 964, Rarity.RARE, mage.cards.m.MysticForge.class));
        cards.add(new SetCardInfo("Mystic Gate", 1013, Rarity.RARE, mage.cards.m.MysticGate.class));
        cards.add(new SetCardInfo("Mystic Monastery", 1014, Rarity.UNCOMMON, mage.cards.m.MysticMonastery.class));
        cards.add(new SetCardInfo("Nadier's Nightblade", 175, Rarity.COMMON, mage.cards.n.NadiersNightblade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nadier's Nightblade", 641, Rarity.COMMON, mage.cards.n.NadiersNightblade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, the Harbinger", 929, Rarity.MYTHIC, mage.cards.n.NahiriTheHarbinger.class));
        cards.add(new SetCardInfo("Nahiri, the Lithomancer", 45, Rarity.RARE, mage.cards.n.NahiriTheLithomancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nahiri, the Lithomancer", 467, Rarity.RARE, mage.cards.n.NahiriTheLithomancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narci, Fable Singer", 710, Rarity.MYTHIC, mage.cards.n.NarciFableSinger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narci, Fable Singer", 775, Rarity.MYTHIC, mage.cards.n.NarciFableSinger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Narset of the Ancient Way", 930, Rarity.MYTHIC, mage.cards.n.NarsetOfTheAncientWay.class));
        cards.add(new SetCardInfo("Narset, Enlightened Master", 931, Rarity.MYTHIC, mage.cards.n.NarsetEnlightenedMaster.class));
        cards.add(new SetCardInfo("Narset, Parter of Veils", 853, Rarity.UNCOMMON, mage.cards.n.NarsetParterOfVeils.class));
        cards.add(new SetCardInfo("Nature's Lore", 904, Rarity.COMMON, mage.cards.n.NaturesLore.class));
        cards.add(new SetCardInfo("Necroblossom Snarl", 1015, Rarity.RARE, mage.cards.n.NecroblossomSnarl.class));
        cards.add(new SetCardInfo("Necrotic Sliver", 932, Rarity.UNCOMMON, mage.cards.n.NecroticSliver.class));
        cards.add(new SetCardInfo("Neheb, the Eternal", 1062, Rarity.MYTHIC, mage.cards.n.NehebTheEternal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Neheb, the Eternal", 244, Rarity.MYTHIC, mage.cards.n.NehebTheEternal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Neheb, the Eternal", 545, Rarity.MYTHIC, mage.cards.n.NehebTheEternal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Neheb, the Eternal", 678, Rarity.MYTHIC, mage.cards.n.NehebTheEternal.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nekusar, the Mindrazer", 349, Rarity.RARE, mage.cards.n.NekusarTheMindrazer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nekusar, the Mindrazer", 587, Rarity.RARE, mage.cards.n.NekusarTheMindrazer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nemata, Grove Guardian", 307, Rarity.UNCOMMON, mage.cards.n.NemataGroveGuardian.class));
        cards.add(new SetCardInfo("Nessian Wanderer", 905, Rarity.UNCOMMON, mage.cards.n.NessianWanderer.class));
        cards.add(new SetCardInfo("Nesting Dragon", 245, Rarity.RARE, mage.cards.n.NestingDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nesting Dragon", 546, Rarity.RARE, mage.cards.n.NestingDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral's Disk", 965, Rarity.RARE, mage.cards.n.NevinyrralsDisk.class));
        cards.add(new SetCardInfo("Nomad Outpost", 1016, Rarity.UNCOMMON, mage.cards.n.NomadOutpost.class));
        cards.add(new SetCardInfo("Norn's Annex", 829, Rarity.RARE, mage.cards.n.NornsAnnex.class));
        cards.add(new SetCardInfo("Not of This World", 807, Rarity.UNCOMMON, mage.cards.n.NotOfThisWorld.class));
        cards.add(new SetCardInfo("Nyx Weaver", 933, Rarity.UNCOMMON, mage.cards.n.NyxWeaver.class));
        cards.add(new SetCardInfo("Nyxborn Behemoth", 742, Rarity.RARE, mage.cards.n.NyxbornBehemoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nyxborn Behemoth", 772, Rarity.RARE, mage.cards.n.NyxbornBehemoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oath of Gideon", 830, Rarity.RARE, mage.cards.o.OathOfGideon.class));
        cards.add(new SetCardInfo("Oath of Jace", 854, Rarity.RARE, mage.cards.o.OathOfJace.class));
        cards.add(new SetCardInfo("Oath of Teferi", 934, Rarity.RARE, mage.cards.o.OathOfTeferi.class));
        cards.add(new SetCardInfo("Ob Nixilis of the Black Oath", 176, Rarity.RARE, mage.cards.o.ObNixilisOfTheBlackOath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ob Nixilis of the Black Oath", 517, Rarity.RARE, mage.cards.o.ObNixilisOfTheBlackOath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oblivion Sower", 808, Rarity.MYTHIC, mage.cards.o.OblivionSower.class));
        cards.add(new SetCardInfo("Obscuring Haze", 308, Rarity.RARE, mage.cards.o.ObscuringHaze.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscuring Haze", 566, Rarity.RARE, mage.cards.o.ObscuringHaze.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obscuring Haze", 701, Rarity.RARE, mage.cards.o.ObscuringHaze.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Odric, Master Tactician", 46, Rarity.RARE, mage.cards.o.OdricMasterTactician.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Odric, Master Tactician", 468, Rarity.RARE, mage.cards.o.OdricMasterTactician.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ogre Slumlord", 177, Rarity.RARE, mage.cards.o.OgreSlumlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ogre Slumlord", 518, Rarity.RARE, mage.cards.o.OgreSlumlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ohran Frostfang", 309, Rarity.RARE, mage.cards.o.OhranFrostfang.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ohran Frostfang", 567, Rarity.RARE, mage.cards.o.OhranFrostfang.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ohran Frostfang", 650, Rarity.RARE, mage.cards.o.OhranFrostfang.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Omarthis, Ghostfire Initiate", 708, Rarity.MYTHIC, mage.cards.o.OmarthisGhostfireInitiate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Omarthis, Ghostfire Initiate", 748, Rarity.MYTHIC, mage.cards.o.OmarthisGhostfireInitiate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Omen of the Hunt", 906, Rarity.COMMON, mage.cards.o.OmenOfTheHunt.class));
        cards.add(new SetCardInfo("Omen of the Sun", 831, Rarity.COMMON, mage.cards.o.OmenOfTheSun.class));
        cards.add(new SetCardInfo("Omnath, Locus of Mana", 1063, Rarity.MYTHIC, mage.cards.o.OmnathLocusOfMana.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Omnath, Locus of Mana", 310, Rarity.MYTHIC, mage.cards.o.OmnathLocusOfMana.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Omnath, Locus of Mana", 568, Rarity.MYTHIC, mage.cards.o.OmnathLocusOfMana.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Omnath, Locus of Mana", 680, Rarity.MYTHIC, mage.cards.o.OmnathLocusOfMana.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Onakke Oathkeeper", 722, Rarity.RARE, mage.cards.o.OnakkeOathkeeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Onakke Oathkeeper", 755, Rarity.RARE, mage.cards.o.OnakkeOathkeeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ondu Spiritdancer", 723, Rarity.RARE, mage.cards.o.OnduSpiritdancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ondu Spiritdancer", 756, Rarity.RARE, mage.cards.o.OnduSpiritdancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Opal Palace", 422, Rarity.COMMON, mage.cards.o.OpalPalace.class));
        cards.add(new SetCardInfo("Opulent Palace", 1017, Rarity.UNCOMMON, mage.cards.o.OpulentPalace.class));
        cards.add(new SetCardInfo("Oreskos Explorer", 832, Rarity.UNCOMMON, mage.cards.o.OreskosExplorer.class));
        cards.add(new SetCardInfo("Ornithopter of Paradise", 966, Rarity.COMMON, mage.cards.o.OrnithopterOfParadise.class));
        cards.add(new SetCardInfo("Orzhov Basilica", 1018, Rarity.UNCOMMON, mage.cards.o.OrzhovBasilica.class));
        cards.add(new SetCardInfo("Oviya Pashiri, Sage Lifecrafter", 311, Rarity.UNCOMMON, mage.cards.o.OviyaPashiriSageLifecrafter.class));
        cards.add(new SetCardInfo("Padeem, Consul of Innovation", 109, Rarity.UNCOMMON, mage.cards.p.PadeemConsulOfInnovation.class));
        cards.add(new SetCardInfo("Palace Jailer", 47, Rarity.UNCOMMON, mage.cards.p.PalaceJailer.class));
        cards.add(new SetCardInfo("Palace Sentinels", 48, Rarity.COMMON, mage.cards.p.PalaceSentinels.class));
        cards.add(new SetCardInfo("Palladium Myr", 967, Rarity.UNCOMMON, mage.cards.p.PalladiumMyr.class));
        cards.add(new SetCardInfo("Path of Ancestry", 423, Rarity.COMMON, mage.cards.p.PathOfAncestry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Path of Ancestry", 661, Rarity.COMMON, mage.cards.p.PathOfAncestry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Path to Exile", 49, Rarity.UNCOMMON, mage.cards.p.PathToExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Path to Exile", 626, Rarity.UNCOMMON, mage.cards.p.PathToExile.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pathrazer of Ulamog", 4, Rarity.UNCOMMON, mage.cards.p.PathrazerOfUlamog.class));
        cards.add(new SetCardInfo("Pearl Medallion", 401, Rarity.RARE, mage.cards.p.PearlMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pearl Medallion", 612, Rarity.RARE, mage.cards.p.PearlMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Perilous Vault", 968, Rarity.MYTHIC, mage.cards.p.PerilousVault.class));
        cards.add(new SetCardInfo("Personal Tutor", 110, Rarity.RARE, mage.cards.p.PersonalTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Personal Tutor", 493, Rarity.RARE, mage.cards.p.PersonalTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Personal Tutor", 633, Rarity.RARE, mage.cards.p.PersonalTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phyrexian Gargantua", 178, Rarity.COMMON, mage.cards.p.PhyrexianGargantua.class));
        cards.add(new SetCardInfo("Phyrexian Ingester", 111, Rarity.UNCOMMON, mage.cards.p.PhyrexianIngester.class));
        cards.add(new SetCardInfo("Phyrexian Triniform", 969, Rarity.MYTHIC, mage.cards.p.PhyrexianTriniform.class));
        cards.add(new SetCardInfo("Pianna, Nomad Captain", 50, Rarity.UNCOMMON, mage.cards.p.PiannaNomadCaptain.class));
        cards.add(new SetCardInfo("Pilgrim's Eye", 402, Rarity.COMMON, mage.cards.p.PilgrimsEye.class));
        cards.add(new SetCardInfo("Pillar of Origins", 970, Rarity.UNCOMMON, mage.cards.p.PillarOfOrigins.class));
        cards.add(new SetCardInfo("Plains", 437, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 438, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 439, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 783, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 784, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 785, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 786, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 787, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pollenbright Druid", 312, Rarity.COMMON, mage.cards.p.PollenbrightDruid.class));
        cards.add(new SetCardInfo("Port Town", 1019, Rarity.RARE, mage.cards.p.PortTown.class));
        cards.add(new SetCardInfo("Portal Mage", 112, Rarity.UNCOMMON, mage.cards.p.PortalMage.class));
        cards.add(new SetCardInfo("Prairie Stream", 1020, Rarity.RARE, mage.cards.p.PrairieStream.class));
        cards.add(new SetCardInfo("Predatory Rampage", 313, Rarity.UNCOMMON, mage.cards.p.PredatoryRampage.class));
        cards.add(new SetCardInfo("Priest of the Blood Rite", 179, Rarity.UNCOMMON, mage.cards.p.PriestOfTheBloodRite.class));
        cards.add(new SetCardInfo("Prismatic Lens", 403, Rarity.COMMON, mage.cards.p.PrismaticLens.class));
        cards.add(new SetCardInfo("Promise of Loyalty", 833, Rarity.RARE, mage.cards.p.PromiseOfLoyalty.class));
        cards.add(new SetCardInfo("Prophetic Prism", 404, Rarity.COMMON, mage.cards.p.PropheticPrism.class));
        cards.add(new SetCardInfo("Puresteel Paladin", 469, Rarity.RARE, mage.cards.p.PuresteelPaladin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Puresteel Paladin", 51, Rarity.RARE, mage.cards.p.PuresteelPaladin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Puresteel Paladin", 627, Rarity.RARE, mage.cards.p.PuresteelPaladin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Purphoros, God of the Forge", 246, Rarity.MYTHIC, mage.cards.p.PurphorosGodOfTheForge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Purphoros, God of the Forge", 547, Rarity.MYTHIC, mage.cards.p.PurphorosGodOfTheForge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Queen Marchesa", 350, Rarity.RARE, mage.cards.q.QueenMarchesa.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Queen Marchesa", 588, Rarity.RARE, mage.cards.q.QueenMarchesa.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Quick Sliver", 907, Rarity.COMMON, mage.cards.q.QuickSliver.class));
        cards.add(new SetCardInfo("Raff Capashen, Ship's Mage", 351, Rarity.UNCOMMON, mage.cards.r.RaffCapashenShipsMage.class));
        cards.add(new SetCardInfo("Rafiq of the Many", 352, Rarity.RARE, mage.cards.r.RafiqOfTheMany.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rafiq of the Many", 589, Rarity.RARE, mage.cards.r.RafiqOfTheMany.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakka Mar", 247, Rarity.UNCOMMON, mage.cards.r.RakkaMar.class));
        cards.add(new SetCardInfo("Ram Through", 314, Rarity.COMMON, mage.cards.r.RamThrough.class));
        cards.add(new SetCardInfo("Rampaging Brontodon", 315, Rarity.UNCOMMON, mage.cards.r.RampagingBrontodon.class));
        cards.add(new SetCardInfo("Rampant Growth", 908, Rarity.COMMON, mage.cards.r.RampantGrowth.class));
        cards.add(new SetCardInfo("Rankle, Master of Pranks", 180, Rarity.RARE, mage.cards.r.RankleMasterOfPranks.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rankle, Master of Pranks", 519, Rarity.RARE, mage.cards.r.RankleMasterOfPranks.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rapacious Dragon", 248, Rarity.COMMON, mage.cards.r.RapaciousDragon.class));
        cards.add(new SetCardInfo("Rapacious One", 249, Rarity.COMMON, mage.cards.r.RapaciousOne.class));
        cards.add(new SetCardInfo("Ravaging Blaze", 250, Rarity.UNCOMMON, mage.cards.r.RavagingBlaze.class));
        cards.add(new SetCardInfo("Razaketh, the Foulblooded", 181, Rarity.MYTHIC, mage.cards.r.RazakethTheFoulblooded.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Razaketh, the Foulblooded", 520, Rarity.MYTHIC, mage.cards.r.RazakethTheFoulblooded.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Read the Bones", 182, Rarity.COMMON, mage.cards.r.ReadTheBones.class));
        cards.add(new SetCardInfo("Reality Shift", 113, Rarity.UNCOMMON, mage.cards.r.RealityShift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reality Shift", 634, Rarity.UNCOMMON, mage.cards.r.RealityShift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Realmwalker", 909, Rarity.RARE, mage.cards.r.Realmwalker.class));
        cards.add(new SetCardInfo("Reassembling Skeleton", 183, Rarity.UNCOMMON, mage.cards.r.ReassemblingSkeleton.class));
        cards.add(new SetCardInfo("Regal Behemoth", 316, Rarity.RARE, mage.cards.r.RegalBehemoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regal Behemoth", 569, Rarity.RARE, mage.cards.r.RegalBehemoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regal Behemoth", 651, Rarity.RARE, mage.cards.r.RegalBehemoth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regal Sliver", 724, Rarity.RARE, mage.cards.r.RegalSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Regal Sliver", 757, Rarity.RARE, mage.cards.r.RegalSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rejuvenating Springs", 424, Rarity.RARE, mage.cards.r.RejuvenatingSprings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rejuvenating Springs", 617, Rarity.RARE, mage.cards.r.RejuvenatingSprings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rejuvenating Springs", 662, Rarity.RARE, mage.cards.r.RejuvenatingSprings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reliquary Tower", 425, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reliquary Tower", 663, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Renowned Weaponsmith", 114, Rarity.COMMON, mage.cards.r.RenownedWeaponsmith.class));
        cards.add(new SetCardInfo("Repeated Reverberation", 879, Rarity.RARE, mage.cards.r.RepeatedReverberation.class));
        cards.add(new SetCardInfo("Resculpt", 115, Rarity.COMMON, mage.cards.r.Resculpt.class));
        cards.add(new SetCardInfo("Return to Dust", 52, Rarity.UNCOMMON, mage.cards.r.ReturnToDust.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Return to Dust", 628, Rarity.UNCOMMON, mage.cards.r.ReturnToDust.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reverse Engineer", 116, Rarity.COMMON, mage.cards.r.ReverseEngineer.class));
        cards.add(new SetCardInfo("Righteous Confluence", 470, Rarity.RARE, mage.cards.r.RighteousConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Righteous Confluence", 53, Rarity.RARE, mage.cards.r.RighteousConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rise from the Tides", 117, Rarity.UNCOMMON, mage.cards.r.RiseFromTheTides.class));
        cards.add(new SetCardInfo("Rise of the Eldrazi", 716, Rarity.RARE, mage.cards.r.RiseOfTheEldrazi.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rise of the Eldrazi", 749, Rarity.RARE, mage.cards.r.RiseOfTheEldrazi.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rishkar, Peema Renegade", 317, Rarity.UNCOMMON, mage.cards.r.RishkarPeemaRenegade.class));
        cards.add(new SetCardInfo("Rocky Tar Pit", 1021, Rarity.UNCOMMON, mage.cards.r.RockyTarPit.class));
        cards.add(new SetCardInfo("Rogue's Passage", 426, Rarity.UNCOMMON, mage.cards.r.RoguesPassage.class));
        cards.add(new SetCardInfo("Rorix Bladewing", 251, Rarity.UNCOMMON, mage.cards.r.RorixBladewing.class));
        cards.add(new SetCardInfo("Rot Shambler", 318, Rarity.COMMON, mage.cards.r.RotShambler.class));
        cards.add(new SetCardInfo("Ruby Medallion", 405, Rarity.RARE, mage.cards.r.RubyMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ruby Medallion", 613, Rarity.RARE, mage.cards.r.RubyMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rugged Prairie", 1022, Rarity.RARE, mage.cards.r.RuggedPrairie.class));
        cards.add(new SetCardInfo("Ruins of Oran-Rief", 1023, Rarity.RARE, mage.cards.r.RuinsOfOranRief.class));
        cards.add(new SetCardInfo("Rukarumel, Biologist", 711, Rarity.MYTHIC, mage.cards.r.RukarumelBiologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rukarumel, Biologist", 776, Rarity.MYTHIC, mage.cards.r.RukarumelBiologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rune-Scarred Demon", 184, Rarity.RARE, mage.cards.r.RuneScarredDemon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rune-Scarred Demon", 521, Rarity.RARE, mage.cards.r.RuneScarredDemon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Saheeli, Sublime Artificer", 935, Rarity.UNCOMMON, mage.cards.s.SaheeliSublimeArtificer.class));
        cards.add(new SetCardInfo("Sai, Master Thopterist", 118, Rarity.RARE, mage.cards.s.SaiMasterThopterist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sai, Master Thopterist", 494, Rarity.RARE, mage.cards.s.SaiMasterThopterist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakiko, Mother of Summer", 319, Rarity.RARE, mage.cards.s.SakikoMotherOfSummer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakiko, Mother of Summer", 570, Rarity.RARE, mage.cards.s.SakikoMotherOfSummer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sanctum Weaver", 910, Rarity.RARE, mage.cards.s.SanctumWeaver.class));
        cards.add(new SetCardInfo("Sandsteppe Citadel", 1024, Rarity.UNCOMMON, mage.cards.s.SandsteppeCitadel.class));
        cards.add(new SetCardInfo("Sandstone Oracle", 406, Rarity.UNCOMMON, mage.cards.s.SandstoneOracle.class));
        cards.add(new SetCardInfo("Sandwurm Convergence", 911, Rarity.RARE, mage.cards.s.SandwurmConvergence.class));
        cards.add(new SetCardInfo("Sapphire Medallion", 407, Rarity.RARE, mage.cards.s.SapphireMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sapphire Medallion", 614, Rarity.RARE, mage.cards.s.SapphireMedallion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sarkhan the Masterless", 880, Rarity.RARE, mage.cards.s.SarkhanTheMasterless.class));
        cards.add(new SetCardInfo("Satyr Enchanter", 936, Rarity.UNCOMMON, mage.cards.s.SatyrEnchanter.class));
        cards.add(new SetCardInfo("Savage Beating", 252, Rarity.MYTHIC, mage.cards.s.SavageBeating.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savage Beating", 548, Rarity.MYTHIC, mage.cards.s.SavageBeating.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Savage Lands", 1025, Rarity.UNCOMMON, mage.cards.s.SavageLands.class));
        cards.add(new SetCardInfo("Scaretiller", 971, Rarity.COMMON, mage.cards.s.Scaretiller.class));
        cards.add(new SetCardInfo("Scattered Groves", 1026, Rarity.RARE, mage.cards.s.ScatteredGroves.class));
        cards.add(new SetCardInfo("Scavenger Grounds", 1027, Rarity.RARE, mage.cards.s.ScavengerGrounds.class));
        cards.add(new SetCardInfo("Scourge of the Throne", 253, Rarity.RARE, mage.cards.s.ScourgeOfTheThrone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scourge of the Throne", 549, Rarity.RARE, mage.cards.s.ScourgeOfTheThrone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scytheclaw", 408, Rarity.RARE, mage.cards.s.Scytheclaw.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scytheclaw", 615, Rarity.RARE, mage.cards.s.Scytheclaw.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sea Gate Wreckage", 1028, Rarity.RARE, mage.cards.s.SeaGateWreckage.class));
        cards.add(new SetCardInfo("Seaside Citadel", 1029, Rarity.UNCOMMON, mage.cards.s.SeasideCitadel.class));
        cards.add(new SetCardInfo("Secluded Courtyard", 1030, Rarity.UNCOMMON, mage.cards.s.SecludedCourtyard.class));
        cards.add(new SetCardInfo("Sek'Kuar, Deathkeeper", 354, Rarity.RARE, mage.cards.s.SekKuarDeathkeeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sek'Kuar, Deathkeeper", 591, Rarity.RARE, mage.cards.s.SekKuarDeathkeeper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selesnya Sanctuary", 1031, Rarity.COMMON, mage.cards.s.SelesnyaSanctuary.class));
        cards.add(new SetCardInfo("Selvala, Heart of the Wilds", 1064, Rarity.MYTHIC, mage.cards.s.SelvalaHeartOfTheWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selvala, Heart of the Wilds", 320, Rarity.MYTHIC, mage.cards.s.SelvalaHeartOfTheWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selvala, Heart of the Wilds", 571, Rarity.MYTHIC, mage.cards.s.SelvalaHeartOfTheWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Selvala, Heart of the Wilds", 681, Rarity.MYTHIC, mage.cards.s.SelvalaHeartOfTheWilds.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Semester's End", 834, Rarity.RARE, mage.cards.s.SemestersEnd.class));
        cards.add(new SetCardInfo("Sentinel Sliver", 835, Rarity.COMMON, mage.cards.s.SentinelSliver.class));
        cards.add(new SetCardInfo("Sephara, Sky's Blade", 471, Rarity.RARE, mage.cards.s.SepharaSkysBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sephara, Sky's Blade", 54, Rarity.RARE, mage.cards.s.SepharaSkysBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serrated Scorpion", 185, Rarity.COMMON, mage.cards.s.SerratedScorpion.class));
        cards.add(new SetCardInfo("Setessan Champion", 912, Rarity.RARE, mage.cards.s.SetessanChampion.class));
        cards.add(new SetCardInfo("Sevinne's Reclamation", 472, Rarity.RARE, mage.cards.s.SevinnesReclamation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sevinne's Reclamation", 55, Rarity.RARE, mage.cards.s.SevinnesReclamation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shelter", 56, Rarity.COMMON, mage.cards.s.Shelter.class));
        cards.add(new SetCardInfo("Sheltered Thicket", 1032, Rarity.RARE, mage.cards.s.ShelteredThicket.class));
        cards.add(new SetCardInfo("Shifting Sliver", 855, Rarity.UNCOMMON, mage.cards.s.ShiftingSliver.class));
        cards.add(new SetCardInfo("Shimmer Myr", 409, Rarity.UNCOMMON, mage.cards.s.ShimmerMyr.class));
        cards.add(new SetCardInfo("Shineshadow Snarl", 1033, Rarity.RARE, mage.cards.s.ShineshadowSnarl.class));
        cards.add(new SetCardInfo("Shipwreck Dowser", 119, Rarity.COMMON, mage.cards.s.ShipwreckDowser.class));
        cards.add(new SetCardInfo("Shirei, Shizo's Caretaker", 186, Rarity.UNCOMMON, mage.cards.s.ShireiShizosCaretaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shirei, Shizo's Caretaker", 676, Rarity.UNCOMMON, mage.cards.s.ShireiShizosCaretaker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Shrine of the Forsaken Gods", 1034, Rarity.RARE, mage.cards.s.ShrineOfTheForsakenGods.class));
        cards.add(new SetCardInfo("Sidisi, Brood Tyrant", 355, Rarity.RARE, mage.cards.s.SidisiBroodTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sidisi, Brood Tyrant", 592, Rarity.RARE, mage.cards.s.SidisiBroodTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sigil of the Empty Throne", 836, Rarity.RARE, mage.cards.s.SigilOfTheEmptyThrone.class));
        cards.add(new SetCardInfo("Silent Arbiter", 972, Rarity.RARE, mage.cards.s.SilentArbiter.class));
        cards.add(new SetCardInfo("Sinew Sliver", 837, Rarity.COMMON, mage.cards.s.SinewSliver.class));
        cards.add(new SetCardInfo("Skittering Cicada", 717, Rarity.RARE, mage.cards.s.SkitteringCicada.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skittering Cicada", 750, Rarity.RARE, mage.cards.s.SkitteringCicada.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Skycloud Expanse", 1035, Rarity.RARE, mage.cards.s.SkycloudExpanse.class));
        cards.add(new SetCardInfo("Skyline Despot", 254, Rarity.UNCOMMON, mage.cards.s.SkylineDespot.class));
        cards.add(new SetCardInfo("Skyshroud Claim", 321, Rarity.COMMON, mage.cards.s.SkyshroudClaim.class));
        cards.add(new SetCardInfo("Skysnare Spider", 322, Rarity.COMMON, mage.cards.s.SkysnareSpider.class));
        cards.add(new SetCardInfo("Slice and Dice", 255, Rarity.UNCOMMON, mage.cards.s.SliceAndDice.class));
        cards.add(new SetCardInfo("Slimefoot, the Stowaway", 356, Rarity.UNCOMMON, mage.cards.s.SlimefootTheStowaway.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Slimefoot, the Stowaway", 686, Rarity.UNCOMMON, mage.cards.s.SlimefootTheStowaway.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sliver Gravemother", 707, Rarity.MYTHIC, mage.cards.s.SliverGravemother.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sliver Gravemother", 777, Rarity.MYTHIC, mage.cards.s.SliverGravemother.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sliver Gravemother", 782, Rarity.MYTHIC, mage.cards.s.SliverGravemother.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sliver Hivelord", 937, Rarity.MYTHIC, mage.cards.s.SliverHivelord.class));
        cards.add(new SetCardInfo("Smoldering Marsh", 1036, Rarity.RARE, mage.cards.s.SmolderingMarsh.class));
        cards.add(new SetCardInfo("Smothering Tithe", 473, Rarity.MYTHIC, mage.cards.s.SmotheringTithe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smothering Tithe", 57, Rarity.MYTHIC, mage.cards.s.SmotheringTithe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Smothering Tithe", 693, Rarity.MYTHIC, mage.cards.s.SmotheringTithe.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Snakeskin Veil", 323, Rarity.COMMON, mage.cards.s.SnakeskinVeil.class));
        cards.add(new SetCardInfo("Sol Ring", 410, Rarity.UNCOMMON, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 703, Rarity.UNCOMMON, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Solemn Simulacrum", 973, Rarity.RARE, mage.cards.s.SolemnSimulacrum.class));
        cards.add(new SetCardInfo("Song of the Dryads", 324, Rarity.RARE, mage.cards.s.SongOfTheDryads.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Song of the Dryads", 572, Rarity.RARE, mage.cards.s.SongOfTheDryads.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul of New Phyrexia", 974, Rarity.MYTHIC, mage.cards.s.SoulOfNewPhyrexia.class));
        cards.add(new SetCardInfo("Sower of Discord", 187, Rarity.RARE, mage.cards.s.SowerOfDiscord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sower of Discord", 522, Rarity.RARE, mage.cards.s.SowerOfDiscord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Double", 856, Rarity.RARE, mage.cards.s.SparkDouble.class));
        cards.add(new SetCardInfo("Sparkshaper Visionary", 726, Rarity.RARE, mage.cards.s.SparkshaperVisionary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sparkshaper Visionary", 758, Rarity.RARE, mage.cards.s.SparkshaperVisionary.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spatial Contortion", 809, Rarity.UNCOMMON, mage.cards.s.SpatialContortion.class));
        cards.add(new SetCardInfo("Spectator Seating", 427, Rarity.RARE, mage.cards.s.SpectatorSeating.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spectator Seating", 618, Rarity.RARE, mage.cards.s.SpectatorSeating.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spectator Seating", 664, Rarity.RARE, mage.cards.s.SpectatorSeating.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spectral Grasp", 58, Rarity.COMMON, mage.cards.s.SpectralGrasp.class));
        cards.add(new SetCardInfo("Spectral Searchlight", 411, Rarity.UNCOMMON, mage.cards.s.SpectralSearchlight.class));
        cards.add(new SetCardInfo("Spellseeker", 120, Rarity.MYTHIC, mage.cards.s.Spellseeker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spellseeker", 495, Rarity.MYTHIC, mage.cards.s.Spellseeker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spellseeker", 635, Rarity.MYTHIC, mage.cards.s.Spellseeker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spikeshot Goblin", 256, Rarity.COMMON, mage.cards.s.SpikeshotGoblin.class));
        cards.add(new SetCardInfo("Spirited Companion", 838, Rarity.COMMON, mage.cards.s.SpiritedCompanion.class));
        cards.add(new SetCardInfo("Spitebellows", 257, Rarity.COMMON, mage.cards.s.Spitebellows.class));
        cards.add(new SetCardInfo("Spiteful Sliver", 881, Rarity.RARE, mage.cards.s.SpitefulSliver.class));
        cards.add(new SetCardInfo("Squee, Goblin Nabob", 258, Rarity.UNCOMMON, mage.cards.s.SqueeGoblinNabob.class));
        cards.add(new SetCardInfo("Star of Extinction", 259, Rarity.RARE, mage.cards.s.StarOfExtinction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Star of Extinction", 550, Rarity.RARE, mage.cards.s.StarOfExtinction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Starfield Mystic", 839, Rarity.RARE, mage.cards.s.StarfieldMystic.class));
        cards.add(new SetCardInfo("Starfield of Nyx", 840, Rarity.MYTHIC, mage.cards.s.StarfieldOfNyx.class));
        cards.add(new SetCardInfo("Staunch Throneguard", 412, Rarity.COMMON, mage.cards.s.StaunchThroneguard.class));
        cards.add(new SetCardInfo("Steel Hellkite", 975, Rarity.RARE, mage.cards.s.SteelHellkite.class));
        cards.add(new SetCardInfo("Steelshaper's Gift", 474, Rarity.RARE, mage.cards.s.SteelshapersGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steelshaper's Gift", 59, Rarity.RARE, mage.cards.s.SteelshapersGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Steelshaper's Gift", 629, Rarity.RARE, mage.cards.s.SteelshapersGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stitcher Geralf", 121, Rarity.RARE, mage.cards.s.StitcherGeralf.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stitcher Geralf", 496, Rarity.RARE, mage.cards.s.StitcherGeralf.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stonecoil Serpent", 976, Rarity.RARE, mage.cards.s.StonecoilSerpent.class));
        cards.add(new SetCardInfo("Stonehoof Chieftain", 325, Rarity.RARE, mage.cards.s.StonehoofChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stonehoof Chieftain", 573, Rarity.RARE, mage.cards.s.StonehoofChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Storm-Kiln Artist", 260, Rarity.UNCOMMON, mage.cards.s.StormKilnArtist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Storm-Kiln Artist", 644, Rarity.UNCOMMON, mage.cards.s.StormKilnArtist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stormsurge Kraken", 122, Rarity.RARE, mage.cards.s.StormsurgeKraken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stormsurge Kraken", 497, Rarity.RARE, mage.cards.s.StormsurgeKraken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Striking Sliver", 882, Rarity.COMMON, mage.cards.s.StrikingSliver.class));
        cards.add(new SetCardInfo("Subira, Tulzidi Caravanner", 261, Rarity.UNCOMMON, mage.cards.s.SubiraTulzidiCaravanner.class));
        cards.add(new SetCardInfo("Sublime Exhalation", 475, Rarity.RARE, mage.cards.s.SublimeExhalation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sublime Exhalation", 60, Rarity.RARE, mage.cards.s.SublimeExhalation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sulfurous Blast", 262, Rarity.COMMON, mage.cards.s.SulfurousBlast.class));
        cards.add(new SetCardInfo("Sun Quan, Lord of Wu", 123, Rarity.MYTHIC, mage.cards.s.SunQuanLordOfWu.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sun Quan, Lord of Wu", 498, Rarity.MYTHIC, mage.cards.s.SunQuanLordOfWu.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sunblade Angel", 61, Rarity.COMMON, mage.cards.s.SunbladeAngel.class));
        cards.add(new SetCardInfo("Sungrass Prairie", 1037, Rarity.RARE, mage.cards.s.SungrassPrairie.class));
        cards.add(new SetCardInfo("Sunken Hollow", 1038, Rarity.RARE, mage.cards.s.SunkenHollow.class));
        cards.add(new SetCardInfo("Sunspear Shikari", 62, Rarity.COMMON, mage.cards.s.SunspearShikari.class));
        cards.add(new SetCardInfo("Supernatural Stamina", 188, Rarity.COMMON, mage.cards.s.SupernaturalStamina.class));
        cards.add(new SetCardInfo("Supply Runners", 63, Rarity.COMMON, mage.cards.s.SupplyRunners.class));
        cards.add(new SetCardInfo("Surrak, the Hunt Caller", 326, Rarity.UNCOMMON, mage.cards.s.SurrakTheHuntCaller.class));
        cards.add(new SetCardInfo("Suspicious Bookcase", 977, Rarity.UNCOMMON, mage.cards.s.SuspiciousBookcase.class));
        cards.add(new SetCardInfo("Swamp", 443, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 444, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 445, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 791, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 792, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 793, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swift Response", 64, Rarity.COMMON, mage.cards.s.SwiftResponse.class));
        cards.add(new SetCardInfo("Sword of the Animist", 413, Rarity.RARE, mage.cards.s.SwordOfTheAnimist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of the Animist", 616, Rarity.RARE, mage.cards.s.SwordOfTheAnimist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 841, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class));
        cards.add(new SetCardInfo("Synapse Sliver", 857, Rarity.RARE, mage.cards.s.SynapseSliver.class));
        cards.add(new SetCardInfo("Syphon Sliver", 870, Rarity.RARE, mage.cards.s.SyphonSliver.class));
        cards.add(new SetCardInfo("Sythis, Harvest's Hand", 938, Rarity.RARE, mage.cards.s.SythisHarvestsHand.class));
        cards.add(new SetCardInfo("Taborax, Hope's Demise", 189, Rarity.UNCOMMON, mage.cards.t.TaboraxHopesDemise.class));
        cards.add(new SetCardInfo("Taigam, Sidisi's Hand", 357, Rarity.UNCOMMON, mage.cards.t.TaigamSidisisHand.class));
        cards.add(new SetCardInfo("Tainted Field", 1039, Rarity.UNCOMMON, mage.cards.t.TaintedField.class));
        cards.add(new SetCardInfo("Tainted Wood", 1040, Rarity.UNCOMMON, mage.cards.t.TaintedWood.class));
        cards.add(new SetCardInfo("Talisman of Conviction", 978, Rarity.UNCOMMON, mage.cards.t.TalismanOfConviction.class));
        cards.add(new SetCardInfo("Talisman of Creativity", 979, Rarity.UNCOMMON, mage.cards.t.TalismanOfCreativity.class));
        cards.add(new SetCardInfo("Talisman of Progress", 980, Rarity.UNCOMMON, mage.cards.t.TalismanOfProgress.class));
        cards.add(new SetCardInfo("Talrand, Sky Summoner", 124, Rarity.RARE, mage.cards.t.TalrandSkySummoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Talrand, Sky Summoner", 499, Rarity.RARE, mage.cards.t.TalrandSkySummoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Talrand, Sky Summoner", 673, Rarity.RARE, mage.cards.t.TalrandSkySummoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tatyova, Benthic Druid", 358, Rarity.UNCOMMON, mage.cards.t.TatyovaBenthicDruid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tatyova, Benthic Druid", 687, Rarity.UNCOMMON, mage.cards.t.TatyovaBenthicDruid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Taunting Sliver", 727, Rarity.RARE, mage.cards.t.TauntingSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Taunting Sliver", 759, Rarity.RARE, mage.cards.t.TauntingSliver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi, Temporal Archmage", 125, Rarity.RARE, mage.cards.t.TeferiTemporalArchmage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teferi, Temporal Archmage", 500, Rarity.RARE, mage.cards.t.TeferiTemporalArchmage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Temple of Enlightenment", 1041, Rarity.RARE, mage.cards.t.TempleOfEnlightenment.class));
        cards.add(new SetCardInfo("Temple of Epiphany", 1042, Rarity.RARE, mage.cards.t.TempleOfEpiphany.class));
        cards.add(new SetCardInfo("Temple of Malady", 1043, Rarity.RARE, mage.cards.t.TempleOfMalady.class));
        cards.add(new SetCardInfo("Temple of Plenty", 1044, Rarity.RARE, mage.cards.t.TempleOfPlenty.class));
        cards.add(new SetCardInfo("Temple of Silence", 1045, Rarity.RARE, mage.cards.t.TempleOfSilence.class));
        cards.add(new SetCardInfo("Temple of Triumph", 1047, Rarity.RARE, mage.cards.t.TempleOfTriumph.class));
        cards.add(new SetCardInfo("Temple of the False God", 1046, Rarity.UNCOMMON, mage.cards.t.TempleOfTheFalseGod.class));
        cards.add(new SetCardInfo("Tempt with Vengeance", 263, Rarity.RARE, mage.cards.t.TemptWithVengeance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tempt with Vengeance", 551, Rarity.RARE, mage.cards.t.TemptWithVengeance.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Temur Battle Rage", 264, Rarity.COMMON, mage.cards.t.TemurBattleRage.class));
        cards.add(new SetCardInfo("Terramorphic Expanse", 428, Rarity.COMMON, mage.cards.t.TerramorphicExpanse.class));
        cards.add(new SetCardInfo("Teshar, Ancestor's Apostle", 65, Rarity.UNCOMMON, mage.cards.t.TesharAncestorsApostle.class));
        cards.add(new SetCardInfo("Tetsuko Umezawa, Fugitive", 126, Rarity.UNCOMMON, mage.cards.t.TetsukoUmezawaFugitive.class));
        cards.add(new SetCardInfo("Teyo, Geometric Tactician", 725, Rarity.RARE, mage.cards.t.TeyoGeometricTactician.class));
        cards.add(new SetCardInfo("Teysa Karlov", 359, Rarity.RARE, mage.cards.t.TeysaKarlov.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teysa Karlov", 593, Rarity.RARE, mage.cards.t.TeysaKarlov.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Teysa Karlov", 688, Rarity.RARE, mage.cards.t.TeysaKarlov.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Binding of the Titans", 886, Rarity.UNCOMMON, mage.cards.t.TheBindingOfTheTitans.class));
        cards.add(new SetCardInfo("The Chain Veil", 943, Rarity.MYTHIC, mage.cards.t.TheChainVeil.class));
        cards.add(new SetCardInfo("The Eldest Reborn", 867, Rarity.UNCOMMON, mage.cards.t.TheEldestReborn.class));
        cards.add(new SetCardInfo("The Great Henge", 294, Rarity.MYTHIC, mage.cards.t.TheGreatHenge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Great Henge", 562, Rarity.MYTHIC, mage.cards.t.TheGreatHenge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Immortal Sun", 393, Rarity.MYTHIC, mage.cards.t.TheImmortalSun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Immortal Sun", 608, Rarity.MYTHIC, mage.cards.t.TheImmortalSun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Mending of Dominaria", 902, Rarity.RARE, mage.cards.t.TheMendingOfDominaria.class));
        cards.add(new SetCardInfo("The Prismatic Piper", 1, Rarity.SPECIAL, mage.cards.t.ThePrismaticPiper.class));
        cards.add(new SetCardInfo("The Scarab God", 353, Rarity.MYTHIC, mage.cards.t.TheScarabGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Scarab God", 590, Rarity.MYTHIC, mage.cards.t.TheScarabGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ur-Dragon", 1065, Rarity.MYTHIC, mage.cards.t.TheUrDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ur-Dragon", 361, Rarity.MYTHIC, mage.cards.t.TheUrDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ur-Dragon", 594, Rarity.MYTHIC, mage.cards.t.TheUrDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Ur-Dragon", 689, Rarity.MYTHIC, mage.cards.t.TheUrDragon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Wanderer", 843, Rarity.UNCOMMON, mage.cards.t.TheWanderer.class));
        cards.add(new SetCardInfo("Thorn of the Black Rose", 190, Rarity.COMMON, mage.cards.t.ThornOfTheBlackRose.class));
        cards.add(new SetCardInfo("Thought Vessel", 414, Rarity.UNCOMMON, mage.cards.t.ThoughtVessel.class));
        cards.add(new SetCardInfo("Thraben Inspector", 66, Rarity.COMMON, mage.cards.t.ThrabenInspector.class));
        cards.add(new SetCardInfo("Thran Dynamo", 415, Rarity.UNCOMMON, mage.cards.t.ThranDynamo.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thran Dynamo", 658, Rarity.UNCOMMON, mage.cards.t.ThranDynamo.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Three Visits", 913, Rarity.UNCOMMON, mage.cards.t.ThreeVisits.class));
        cards.add(new SetCardInfo("Thriving Bluff", 429, Rarity.COMMON, mage.cards.t.ThrivingBluff.class));
        cards.add(new SetCardInfo("Thriving Grove", 430, Rarity.COMMON, mage.cards.t.ThrivingGrove.class));
        cards.add(new SetCardInfo("Thriving Heath", 431, Rarity.COMMON, mage.cards.t.ThrivingHeath.class));
        cards.add(new SetCardInfo("Thriving Isle", 432, Rarity.COMMON, mage.cards.t.ThrivingIsle.class));
        cards.add(new SetCardInfo("Thriving Moor", 433, Rarity.COMMON, mage.cards.t.ThrivingMoor.class));
        cards.add(new SetCardInfo("Thrummingbird", 858, Rarity.UNCOMMON, mage.cards.t.Thrummingbird.class));
        cards.add(new SetCardInfo("Thryx, the Sudden Storm", 127, Rarity.UNCOMMON, mage.cards.t.ThryxTheSuddenStorm.class));
        cards.add(new SetCardInfo("Titan of Littjara", 728, Rarity.RARE, mage.cards.t.TitanOfLittjara.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Titan of Littjara", 760, Rarity.RARE, mage.cards.t.TitanOfLittjara.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Titan's Presence", 810, Rarity.UNCOMMON, mage.cards.t.TitansPresence.class));
        cards.add(new SetCardInfo("Tomb of the Spirit Dragon", 1048, Rarity.UNCOMMON, mage.cards.t.TombOfTheSpiritDragon.class));
        cards.add(new SetCardInfo("Tooth and Nail", 327, Rarity.RARE, mage.cards.t.ToothAndNail.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tooth and Nail", 574, Rarity.RARE, mage.cards.t.ToothAndNail.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tooth and Nail", 652, Rarity.RARE, mage.cards.t.ToothAndNail.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Torrential Gearhulk", 128, Rarity.RARE, mage.cards.t.TorrentialGearhulk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Torrential Gearhulk", 501, Rarity.RARE, mage.cards.t.TorrentialGearhulk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Toxic Deluge", 191, Rarity.RARE, mage.cards.t.ToxicDeluge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Toxic Deluge", 523, Rarity.RARE, mage.cards.t.ToxicDeluge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tragic Slip", 192, Rarity.COMMON, mage.cards.t.TragicSlip.class));
        cards.add(new SetCardInfo("Training Center", 434, Rarity.RARE, mage.cards.t.TrainingCenter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Training Center", 619, Rarity.RARE, mage.cards.t.TrainingCenter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Training Center", 665, Rarity.RARE, mage.cards.t.TrainingCenter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Transmogrifying Wand", 981, Rarity.RARE, mage.cards.t.TransmogrifyingWand.class));
        cards.add(new SetCardInfo("Treasure Nabber", 265, Rarity.RARE, mage.cards.t.TreasureNabber.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Treasure Nabber", 552, Rarity.RARE, mage.cards.t.TreasureNabber.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Treasure Nabber", 645, Rarity.RARE, mage.cards.t.TreasureNabber.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tromokratis", 129, Rarity.UNCOMMON, mage.cards.t.Tromokratis.class));
        cards.add(new SetCardInfo("Tuskguard Captain", 328, Rarity.COMMON, mage.cards.t.TuskguardCaptain.class));
        cards.add(new SetCardInfo("Tuya Bearclaw", 360, Rarity.UNCOMMON, mage.cards.t.TuyaBearclaw.class));
        cards.add(new SetCardInfo("Twilight Prophet", 193, Rarity.MYTHIC, mage.cards.t.TwilightProphet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Twilight Prophet", 524, Rarity.MYTHIC, mage.cards.t.TwilightProphet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Twisted Abomination", 194, Rarity.COMMON, mage.cards.t.TwistedAbomination.class));
        cards.add(new SetCardInfo("Two-Headed Sliver", 883, Rarity.COMMON, mage.cards.t.TwoHeadedSliver.class));
        cards.add(new SetCardInfo("Tyrite Sanctum", 1049, Rarity.RARE, mage.cards.t.TyriteSanctum.class));
        cards.add(new SetCardInfo("Ugin's Mastery", 718, Rarity.RARE, mage.cards.u.UginsMastery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ugin's Mastery", 751, Rarity.RARE, mage.cards.u.UginsMastery.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ugin, the Ineffable", 811, Rarity.RARE, mage.cards.u.UginTheIneffable.class));
        cards.add(new SetCardInfo("Ulamog's Crusher", 6, Rarity.COMMON, mage.cards.u.UlamogsCrusher.class));
        cards.add(new SetCardInfo("Ulamog, the Ceaseless Hunger", 1059, Rarity.MYTHIC, mage.cards.u.UlamogTheCeaselessHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulamog, the Ceaseless Hunger", 454, Rarity.MYTHIC, mage.cards.u.UlamogTheCeaselessHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulamog, the Ceaseless Hunger", 5, Rarity.MYTHIC, mage.cards.u.UlamogTheCeaselessHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ulamog, the Ceaseless Hunger", 670, Rarity.MYTHIC, mage.cards.u.UlamogTheCeaselessHunger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unbounded Potential", 67, Rarity.COMMON, mage.cards.u.UnboundedPotential.class));
        cards.add(new SetCardInfo("Unclaimed Territory", 1050, Rarity.UNCOMMON, mage.cards.u.UnclaimedTerritory.class));
        cards.add(new SetCardInfo("Undergrowth Stadium", 435, Rarity.RARE, mage.cards.u.UndergrowthStadium.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undergrowth Stadium", 620, Rarity.RARE, mage.cards.u.UndergrowthStadium.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undergrowth Stadium", 666, Rarity.RARE, mage.cards.u.UndergrowthStadium.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Unstable Obelisk", 416, Rarity.COMMON, mage.cards.u.UnstableObelisk.class));
        cards.add(new SetCardInfo("Urza's Mine", 1051, Rarity.COMMON, mage.cards.u.UrzasMine.class));
        cards.add(new SetCardInfo("Urza's Power Plant", 1052, Rarity.COMMON, mage.cards.u.UrzasPowerPlant.class));
        cards.add(new SetCardInfo("Urza's Ruinous Blast", 842, Rarity.RARE, mage.cards.u.UrzasRuinousBlast.class));
        cards.add(new SetCardInfo("Urza's Tower", 1053, Rarity.COMMON, mage.cards.u.UrzasTower.class));
        cards.add(new SetCardInfo("Urza, Lord High Artificer", 1060, Rarity.MYTHIC, mage.cards.u.UrzaLordHighArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urza, Lord High Artificer", 130, Rarity.MYTHIC, mage.cards.u.UrzaLordHighArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urza, Lord High Artificer", 502, Rarity.MYTHIC, mage.cards.u.UrzaLordHighArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Urza, Lord High Artificer", 674, Rarity.MYTHIC, mage.cards.u.UrzaLordHighArtificer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Valduk, Keeper of the Flame", 266, Rarity.UNCOMMON, mage.cards.v.ValdukKeeperOfTheFlame.class));
        cards.add(new SetCardInfo("Vandalblast", 267, Rarity.UNCOMMON, mage.cards.v.Vandalblast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vandalblast", 646, Rarity.UNCOMMON, mage.cards.v.Vandalblast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vanquisher's Banner", 982, Rarity.RARE, mage.cards.v.VanquishersBanner.class));
        cards.add(new SetCardInfo("Vault of Champions", 436, Rarity.RARE, mage.cards.v.VaultOfChampions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vault of Champions", 621, Rarity.RARE, mage.cards.v.VaultOfChampions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vault of Champions", 667, Rarity.RARE, mage.cards.v.VaultOfChampions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Venom Sliver", 914, Rarity.UNCOMMON, mage.cards.v.VenomSliver.class));
        cards.add(new SetCardInfo("Verdant Confluence", 329, Rarity.RARE, mage.cards.v.VerdantConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Verdant Confluence", 575, Rarity.RARE, mage.cards.v.VerdantConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Verdeloth the Ancient", 330, Rarity.UNCOMMON, mage.cards.v.VerdelothTheAncient.class));
        cards.add(new SetCardInfo("Verduran Enchantress", 915, Rarity.RARE, mage.cards.v.VerduranEnchantress.class));
        cards.add(new SetCardInfo("Vial of Dragonfire", 417, Rarity.COMMON, mage.cards.v.VialOfDragonfire.class));
        cards.add(new SetCardInfo("Victimize", 195, Rarity.UNCOMMON, mage.cards.v.Victimize.class));
        cards.add(new SetCardInfo("Vindictive Lich", 196, Rarity.RARE, mage.cards.v.VindictiveLich.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vindictive Lich", 525, Rarity.RARE, mage.cards.v.VindictiveLich.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vizier of Tumbling Sands", 131, Rarity.COMMON, mage.cards.v.VizierOfTumblingSands.class));
        cards.add(new SetCardInfo("Vronos, Masked Inquisitor", 729, Rarity.RARE, mage.cards.v.VronosMaskedInquisitor.class));
        cards.add(new SetCardInfo("Vulshok Battlegear", 418, Rarity.COMMON, mage.cards.v.VulshokBattlegear.class));
        cards.add(new SetCardInfo("Wake the Dead", 197, Rarity.RARE, mage.cards.w.WakeTheDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wake the Dead", 526, Rarity.RARE, mage.cards.w.WakeTheDead.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wakening Sun's Avatar", 476, Rarity.RARE, mage.cards.w.WakeningSunsAvatar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wakening Sun's Avatar", 68, Rarity.RARE, mage.cards.w.WakeningSunsAvatar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wall of Denial", 939, Rarity.UNCOMMON, mage.cards.w.WallOfDenial.class));
        cards.add(new SetCardInfo("Wanderer's Strike", 69, Rarity.COMMON, mage.cards.w.WanderersStrike.class));
        cards.add(new SetCardInfo("War Room", 1054, Rarity.RARE, mage.cards.w.WarRoom.class));
        cards.add(new SetCardInfo("Warping Wail", 812, Rarity.UNCOMMON, mage.cards.w.WarpingWail.class));
        cards.add(new SetCardInfo("Wastes", 1055, Rarity.COMMON, mage.cards.w.Wastes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wastes", 1056, Rarity.COMMON, mage.cards.w.Wastes.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wayfarer's Bauble", 983, Rarity.COMMON, mage.cards.w.WayfarersBauble.class));
        cards.add(new SetCardInfo("Wayward Swordtooth", 331, Rarity.RARE, mage.cards.w.WaywardSwordtooth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wayward Swordtooth", 576, Rarity.RARE, mage.cards.w.WaywardSwordtooth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Whirler Rogue", 132, Rarity.UNCOMMON, mage.cards.w.WhirlerRogue.class));
        cards.add(new SetCardInfo("Whisper, Blood Liturgist", 198, Rarity.UNCOMMON, mage.cards.w.WhisperBloodLiturgist.class));
        cards.add(new SetCardInfo("Wildwood Scourge", 332, Rarity.UNCOMMON, mage.cards.w.WildwoodScourge.class));
        cards.add(new SetCardInfo("Windcaller Aven", 133, Rarity.COMMON, mage.cards.w.WindcallerAven.class));
        cards.add(new SetCardInfo("Windfall", 859, Rarity.UNCOMMON, mage.cards.w.Windfall.class));
        cards.add(new SetCardInfo("Windrider Wizard", 134, Rarity.COMMON, mage.cards.w.WindriderWizard.class));
        cards.add(new SetCardInfo("Winged Sliver", 860, Rarity.COMMON, mage.cards.w.WingedSliver.class));
        cards.add(new SetCardInfo("Witch's Cauldron", 199, Rarity.COMMON, mage.cards.w.WitchsCauldron.class));
        cards.add(new SetCardInfo("Witching Well", 135, Rarity.COMMON, mage.cards.w.WitchingWell.class));
        cards.add(new SetCardInfo("Worn Powerstone", 984, Rarity.UNCOMMON, mage.cards.w.WornPowerstone.class));
        cards.add(new SetCardInfo("Wrath of God", 477, Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrath of God", 70, Rarity.RARE, mage.cards.w.WrathOfGod.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wretched Confluence", 200, Rarity.RARE, mage.cards.w.WretchedConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wretched Confluence", 527, Rarity.RARE, mage.cards.w.WretchedConfluence.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Xantcha, Sleeper Agent", 362, Rarity.RARE, mage.cards.x.XantchaSleeperAgent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Xantcha, Sleeper Agent", 595, Rarity.RARE, mage.cards.x.XantchaSleeperAgent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yahenni, Undying Partisan", 201, Rarity.UNCOMMON, mage.cards.y.YahenniUndyingPartisan.class));
        cards.add(new SetCardInfo("Yargle, Glutton of Urborg", 202, Rarity.UNCOMMON, mage.cards.y.YargleGluttonOfUrborg.class));
        cards.add(new SetCardInfo("Yedora, Grave Gardener", 333, Rarity.UNCOMMON, mage.cards.y.YedoraGraveGardener.class));
        cards.add(new SetCardInfo("Yennett, Cryptic Sovereign", 363, Rarity.RARE, mage.cards.y.YennettCrypticSovereign.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yennett, Cryptic Sovereign", 596, Rarity.RARE, mage.cards.y.YennettCrypticSovereign.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yisan, the Wanderer Bard", 334, Rarity.RARE, mage.cards.y.YisanTheWandererBard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yisan, the Wanderer Bard", 577, Rarity.RARE, mage.cards.y.YisanTheWandererBard.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yuriko, the Tiger's Shadow", 364, Rarity.RARE, mage.cards.y.YurikoTheTigersShadow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yuriko, the Tiger's Shadow", 597, Rarity.RARE, mage.cards.y.YurikoTheTigersShadow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yuriko, the Tiger's Shadow", 690, Rarity.RARE, mage.cards.y.YurikoTheTigersShadow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zacama, Primal Calamity", 365, Rarity.RARE, mage.cards.z.ZacamaPrimalCalamity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zacama, Primal Calamity", 598, Rarity.RARE, mage.cards.z.ZacamaPrimalCalamity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zacama, Primal Calamity", 691, Rarity.RARE, mage.cards.z.ZacamaPrimalCalamity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zada, Hedron Grinder", 268, Rarity.UNCOMMON, mage.cards.z.ZadaHedronGrinder.class));
        cards.add(new SetCardInfo("Zahid, Djinn of the Lamp", 136, Rarity.UNCOMMON, mage.cards.z.ZahidDjinnOfTheLamp.class));
        cards.add(new SetCardInfo("Zetalpa, Primal Dawn", 478, Rarity.RARE, mage.cards.z.ZetalpaPrimalDawn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zetalpa, Primal Dawn", 71, Rarity.RARE, mage.cards.z.ZetalpaPrimalDawn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zhulodok, Void Gorger", 704, Rarity.MYTHIC, mage.cards.z.ZhulodokVoidGorger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zhulodok, Void Gorger", 752, Rarity.MYTHIC, mage.cards.z.ZhulodokVoidGorger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zhulodok, Void Gorger", 779, Rarity.MYTHIC, mage.cards.z.ZhulodokVoidGorger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zilortha, Strength Incarnate", 366, Rarity.RARE, mage.cards.z.ZilorthaStrengthIncarnate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zilortha, Strength Incarnate", 599, Rarity.RARE, mage.cards.z.ZilorthaStrengthIncarnate.class, NON_FULL_USE_VARIOUS));
    }
}
