package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class CommanderLegends extends ExpansionSet {

    private static final CommanderLegends instance = new CommanderLegends();

    public static CommanderLegends getInstance() {
        return instance;
    }

    private CommanderLegends() {
        super("Commander Legends", "CMR", ExpansionSet.buildDate(2020, 11, 1), SetType.SUPPLEMENTAL);
        this.blockName = "Commander Legends";
        this.hasBasicLands = true;
        this.hasBoosters = true;
        this.numBoosterLands = 1;
        this.numBoosterCommon = 11;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 8;
        this.maxCardNumberInBooster = 361;

        cards.add(new SetCardInfo("Abomination of Llanowar", 265, Rarity.UNCOMMON, mage.cards.a.AbominationOfLlanowar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abomination of Llanowar", 585, Rarity.UNCOMMON, mage.cards.a.AbominationOfLlanowar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abrade", 410, Rarity.UNCOMMON, mage.cards.a.Abrade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Abrade", 659, Rarity.UNCOMMON, mage.cards.a.Abrade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Acidic Slime", 421, Rarity.UNCOMMON, mage.cards.a.AcidicSlime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Acidic Slime", 673, Rarity.UNCOMMON, mage.cards.a.AcidicSlime.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aesi, Tyrant of Gyre Strait", 365, Rarity.MYTHIC, mage.cards.a.AesiTyrantOfGyreStrait.class));
        cards.add(new SetCardInfo("Akiri, Line-Slinger", 515, Rarity.MYTHIC, mage.cards.a.AkiriLineSlinger.class));
        cards.add(new SetCardInfo("Akroma's Will", 3, Rarity.RARE, mage.cards.a.AkromasWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Akroma's Will", 615, Rarity.RARE, mage.cards.a.AkromasWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Akroma, Vision of Ixidor", 2, Rarity.MYTHIC, mage.cards.a.AkromaVisionOfIxidor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Akroma, Vision of Ixidor", 547, Rarity.MYTHIC, mage.cards.a.AkromaVisionOfIxidor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alena, Kessig Trapper", 160, Rarity.UNCOMMON, mage.cards.a.AlenaKessigTrapper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alena, Kessig Trapper", 570, Rarity.UNCOMMON, mage.cards.a.AlenaKessigTrapper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alharu, Solemn Ritualist", 4, Rarity.UNCOMMON, mage.cards.a.AlharuSolemnRitualist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alharu, Solemn Ritualist", 548, Rarity.UNCOMMON, mage.cards.a.AlharuSolemnRitualist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Amareth, the Lustrous", 266, Rarity.RARE, mage.cards.a.AmarethTheLustrous.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Amareth, the Lustrous", 586, Rarity.RARE, mage.cards.a.AmarethTheLustrous.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ambush Viper", 213, Rarity.COMMON, mage.cards.a.AmbushViper.class));
        cards.add(new SetCardInfo("Amorphous Axe", 295, Rarity.COMMON, mage.cards.a.AmorphousAxe.class));
        cards.add(new SetCardInfo("Amphin Mutineer", 55, Rarity.RARE, mage.cards.a.AmphinMutineer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Amphin Mutineer", 629, Rarity.RARE, mage.cards.a.AmphinMutineer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anara, Wolvid Familiar", 214, Rarity.UNCOMMON, mage.cards.a.AnaraWolvidFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Anara, Wolvid Familiar", 577, Rarity.UNCOMMON, mage.cards.a.AnaraWolvidFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ancestral Blade", 5, Rarity.COMMON, mage.cards.a.AncestralBlade.class));
        cards.add(new SetCardInfo("Ancient Animus", 215, Rarity.COMMON, mage.cards.a.AncientAnimus.class));
        cards.add(new SetCardInfo("Angel of the Dawn", 6, Rarity.COMMON, mage.cards.a.AngelOfTheDawn.class));
        cards.add(new SetCardInfo("Angelic Armaments", 296, Rarity.UNCOMMON, mage.cards.a.AngelicArmaments.class));
        cards.add(new SetCardInfo("Angelic Gift", 7, Rarity.COMMON, mage.cards.a.AngelicGift.class));
        cards.add(new SetCardInfo("Annoyed Altisaur", 216, Rarity.COMMON, mage.cards.a.AnnoyedAltisaur.class));
        cards.add(new SetCardInfo("Anointer of Valor", 8, Rarity.COMMON, mage.cards.a.AnointerOfValor.class));
        cards.add(new SetCardInfo("Apex Devastator", 217, Rarity.MYTHIC, mage.cards.a.ApexDevastator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Apex Devastator", 674, Rarity.MYTHIC, mage.cards.a.ApexDevastator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aqueous Form", 56, Rarity.COMMON, mage.cards.a.AqueousForm.class));
        cards.add(new SetCardInfo("Araumi of the Dead Tide", 267, Rarity.UNCOMMON, mage.cards.a.AraumiOfTheDeadTide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Araumi of the Dead Tide", 587, Rarity.UNCOMMON, mage.cards.a.AraumiOfTheDeadTide.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Denial", 393, Rarity.COMMON, mage.cards.a.ArcaneDenial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Denial", 630, Rarity.COMMON, mage.cards.a.ArcaneDenial.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", 297, Rarity.UNCOMMON, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Arcane Signet", 689, Rarity.UNCOMMON, mage.cards.a.ArcaneSignet.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archelos, Lagoon Mystic", 268, Rarity.RARE, mage.cards.a.ArchelosLagoonMystic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archelos, Lagoon Mystic", 588, Rarity.RARE, mage.cards.a.ArchelosLagoonMystic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archon of Coronation", 616, Rarity.MYTHIC, mage.cards.a.ArchonOfCoronation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archon of Coronation", 9, Rarity.MYTHIC, mage.cards.a.ArchonOfCoronation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ardenn, Intrepid Archaeologist", 10, Rarity.UNCOMMON, mage.cards.a.ArdennIntrepidArchaeologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ardenn, Intrepid Archaeologist", 549, Rarity.UNCOMMON, mage.cards.a.ArdennIntrepidArchaeologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armillary Sphere", 298, Rarity.COMMON, mage.cards.a.ArmillarySphere.class));
        cards.add(new SetCardInfo("Armix, Filigree Thrasher", 108, Rarity.UNCOMMON, mage.cards.a.ArmixFiligreeThrasher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armix, Filigree Thrasher", 563, Rarity.UNCOMMON, mage.cards.a.ArmixFiligreeThrasher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armorcraft Judge", 218, Rarity.UNCOMMON, mage.cards.a.ArmorcraftJudge.class));
        cards.add(new SetCardInfo("Armored Skyhunter", 11, Rarity.RARE, mage.cards.a.ArmoredSkyhunter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armored Skyhunter", 617, Rarity.RARE, mage.cards.a.ArmoredSkyhunter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Armory of Iroas", 299, Rarity.COMMON, mage.cards.a.ArmoryOfIroas.class));
        cards.add(new SetCardInfo("Aurora Phoenix", 161, Rarity.RARE, mage.cards.a.AuroraPhoenix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aurora Phoenix", 660, Rarity.RARE, mage.cards.a.AuroraPhoenix.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Austere Command", 12, Rarity.RARE, mage.cards.a.AustereCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Austere Command", 618, Rarity.RARE, mage.cards.a.AustereCommand.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aven Surveyor", 57, Rarity.COMMON, mage.cards.a.AvenSurveyor.class));
        cards.add(new SetCardInfo("Avenger of Zendikar", 422, Rarity.MYTHIC, mage.cards.a.AvengerOfZendikar.class));
        cards.add(new SetCardInfo("Averna, the Chaos Bloom", 269, Rarity.RARE, mage.cards.a.AvernaTheChaosBloom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Averna, the Chaos Bloom", 589, Rarity.RARE, mage.cards.a.AvernaTheChaosBloom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Azure Fleet Admiral", 58, Rarity.COMMON, mage.cards.a.AzureFleetAdmiral.class));
        cards.add(new SetCardInfo("Beast Within", 423, Rarity.UNCOMMON, mage.cards.b.BeastWithin.class));
        cards.add(new SetCardInfo("Belbe, Corrupted Observer", 270, Rarity.RARE, mage.cards.b.BelbeCorruptedObserver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Belbe, Corrupted Observer", 590, Rarity.RARE, mage.cards.b.BelbeCorruptedObserver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bell Borca, Spectral Sergeant", 271, Rarity.RARE, mage.cards.b.BellBorcaSpectralSergeant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bell Borca, Spectral Sergeant", 591, Rarity.RARE, mage.cards.b.BellBorcaSpectralSergeant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Benevolent Blessing", 13, Rarity.COMMON, mage.cards.b.BenevolentBlessing.class));
        cards.add(new SetCardInfo("Biowaste Blob", 219, Rarity.RARE, mage.cards.b.BiowasteBlob.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Biowaste Blob", 675, Rarity.RARE, mage.cards.b.BiowasteBlob.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bitter Revelation", 109, Rarity.COMMON, mage.cards.b.BitterRevelation.class));
        cards.add(new SetCardInfo("Blackblade Reforged", 457, Rarity.RARE, mage.cards.b.BlackbladeReforged.class));
        cards.add(new SetCardInfo("Bladebrand", 110, Rarity.COMMON, mage.cards.b.Bladebrand.class));
        cards.add(new SetCardInfo("Bladegriff Prototype", 300, Rarity.RARE, mage.cards.b.BladegriffPrototype.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bladegriff Prototype", 690, Rarity.RARE, mage.cards.b.BladegriffPrototype.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blasphemous Act", 162, Rarity.RARE, mage.cards.b.BlasphemousAct.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blasphemous Act", 661, Rarity.RARE, mage.cards.b.BlasphemousAct.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blazing Sunsteel", 364, Rarity.RARE, mage.cards.b.BlazingSunsteel.class));
        cards.add(new SetCardInfo("Blighted Woodland", 476, Rarity.UNCOMMON, mage.cards.b.BlightedWoodland.class));
        cards.add(new SetCardInfo("Blim, Comedic Genius", 272, Rarity.RARE, mage.cards.b.BlimComedicGenius.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blim, Comedic Genius", 592, Rarity.RARE, mage.cards.b.BlimComedicGenius.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boarding Party", 163, Rarity.COMMON, mage.cards.b.BoardingParty.class));
        cards.add(new SetCardInfo("Body of Knowledge", 59, Rarity.RARE, mage.cards.b.BodyOfKnowledge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Body of Knowledge", 631, Rarity.RARE, mage.cards.b.BodyOfKnowledge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bonesplitter", 458, Rarity.COMMON, mage.cards.b.Bonesplitter.class));
        cards.add(new SetCardInfo("Boros Charm", 442, Rarity.UNCOMMON, mage.cards.b.BorosCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boros Charm", 687, Rarity.UNCOMMON, mage.cards.b.BorosCharm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boros Garrison", 477, Rarity.UNCOMMON, mage.cards.b.BorosGarrison.class));
        cards.add(new SetCardInfo("Boros Guildgate", 478, Rarity.COMMON, mage.cards.b.BorosGuildgate.class));
        cards.add(new SetCardInfo("Boros Signet", 459, Rarity.COMMON, mage.cards.b.BorosSignet.class));
        cards.add(new SetCardInfo("Brago, King Eternal", 516, Rarity.MYTHIC, mage.cards.b.BragoKingEternal.class));
        cards.add(new SetCardInfo("Brass Herald", 301, Rarity.UNCOMMON, mage.cards.b.BrassHerald.class));
        cards.add(new SetCardInfo("Brass Squire", 460, Rarity.UNCOMMON, mage.cards.b.BrassSquire.class));
        cards.add(new SetCardInfo("Brazen Freebooter", 164, Rarity.COMMON, mage.cards.b.BrazenFreebooter.class));
        cards.add(new SetCardInfo("Breeches, Brazen Plunderer", 165, Rarity.UNCOMMON, mage.cards.b.BreechesBrazenPlunderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Breeches, Brazen Plunderer", 571, Rarity.UNCOMMON, mage.cards.b.BreechesBrazenPlunderer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Briarblade Adept", 111, Rarity.COMMON, mage.cards.b.BriarbladeAdept.class));
        cards.add(new SetCardInfo("Brinelin, the Moon Kraken", 555, Rarity.UNCOMMON, mage.cards.b.BrinelinTheMoonKraken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Brinelin, the Moon Kraken", 60, Rarity.UNCOMMON, mage.cards.b.BrinelinTheMoonKraken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bruse Tarl, Boorish Herder", 517, Rarity.MYTHIC, mage.cards.b.BruseTarlBoorishHerder.class));
        cards.add(new SetCardInfo("Burning Anger", 166, Rarity.UNCOMMON, mage.cards.b.BurningAnger.class));
        cards.add(new SetCardInfo("Burnished Hart", 302, Rarity.UNCOMMON, mage.cards.b.BurnishedHart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Burnished Hart", 691, Rarity.UNCOMMON, mage.cards.b.BurnishedHart.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cage of Hands", 14, Rarity.COMMON, mage.cards.c.CageOfHands.class));
        cards.add(new SetCardInfo("Captain Vargus Wrath", 273, Rarity.UNCOMMON, mage.cards.c.CaptainVargusWrath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Captain Vargus Wrath", 593, Rarity.UNCOMMON, mage.cards.c.CaptainVargusWrath.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Captain's Call", 15, Rarity.COMMON, mage.cards.c.CaptainsCall.class));
        cards.add(new SetCardInfo("Cast Down", 112, Rarity.UNCOMMON, mage.cards.c.CastDown.class));
        cards.add(new SetCardInfo("Champion of the Flame", 167, Rarity.COMMON, mage.cards.c.ChampionOfTheFlame.class));
        cards.add(new SetCardInfo("Charcoal Diamond", 303, Rarity.COMMON, mage.cards.c.CharcoalDiamond.class));
        cards.add(new SetCardInfo("Coastline Marauders", 168, Rarity.UNCOMMON, mage.cards.c.CoastlineMarauders.class));
        cards.add(new SetCardInfo("Codex Shredder", 304, Rarity.UNCOMMON, mage.cards.c.CodexShredder.class));
        cards.add(new SetCardInfo("Coercive Recruiter", 169, Rarity.RARE, mage.cards.c.CoerciveRecruiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coercive Recruiter", 662, Rarity.RARE, mage.cards.c.CoerciveRecruiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coiling Oracle", 443, Rarity.COMMON, mage.cards.c.CoilingOracle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Coiling Oracle", 688, Rarity.COMMON, mage.cards.c.CoilingOracle.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Colfenor, the Last Yew", 274, Rarity.RARE, mage.cards.c.ColfenorTheLastYew.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Colfenor, the Last Yew", 594, Rarity.RARE, mage.cards.c.ColfenorTheLastYew.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Comet Storm", 411, Rarity.MYTHIC, mage.cards.c.CometStorm.class));
        cards.add(new SetCardInfo("Command Beacon", 349, Rarity.RARE, mage.cards.c.CommandBeacon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Beacon", 704, Rarity.RARE, mage.cards.c.CommandBeacon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 350, Rarity.COMMON, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 479, Rarity.COMMON, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Command Tower", 705, Rarity.COMMON, mage.cards.c.CommandTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commander's Plate", 305, Rarity.MYTHIC, mage.cards.c.CommandersPlate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commander's Plate", 692, Rarity.MYTHIC, mage.cards.c.CommandersPlate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commander's Sphere", 306, Rarity.COMMON, mage.cards.c.CommandersSphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commander's Sphere", 693, Rarity.COMMON, mage.cards.c.CommandersSphere.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Compulsive Research", 394, Rarity.COMMON, mage.cards.c.CompulsiveResearch.class));
        cards.add(new SetCardInfo("Condemn", 369, Rarity.UNCOMMON, mage.cards.c.Condemn.class));
        cards.add(new SetCardInfo("Confiscate", 62, Rarity.UNCOMMON, mage.cards.c.Confiscate.class));
        cards.add(new SetCardInfo("Coral Atoll", 480, Rarity.UNCOMMON, mage.cards.c.CoralAtoll.class));
        cards.add(new SetCardInfo("Corpse Churn", 113, Rarity.COMMON, mage.cards.c.CorpseChurn.class));
        cards.add(new SetCardInfo("Counterspell", 395, Rarity.COMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Counterspell", 632, Rarity.COMMON, mage.cards.c.Counterspell.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court Street Denizen", 17, Rarity.COMMON, mage.cards.c.CourtStreetDenizen.class));
        cards.add(new SetCardInfo("Court of Ambition", 114, Rarity.RARE, mage.cards.c.CourtOfAmbition.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court of Ambition", 645, Rarity.RARE, mage.cards.c.CourtOfAmbition.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court of Bounty", 220, Rarity.RARE, mage.cards.c.CourtOfBounty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court of Bounty", 676, Rarity.RARE, mage.cards.c.CourtOfBounty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court of Cunning", 63, Rarity.RARE, mage.cards.c.CourtOfCunning.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court of Cunning", 633, Rarity.RARE, mage.cards.c.CourtOfCunning.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court of Grace", 16, Rarity.RARE, mage.cards.c.CourtOfGrace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court of Grace", 619, Rarity.RARE, mage.cards.c.CourtOfGrace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court of Ire", 170, Rarity.RARE, mage.cards.c.CourtOfIre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Court of Ire", 663, Rarity.RARE, mage.cards.c.CourtOfIre.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Crimson Fleet Commodore", 171, Rarity.COMMON, mage.cards.c.CrimsonFleetCommodore.class));
        cards.add(new SetCardInfo("Crow of Dark Tidings", 115, Rarity.COMMON, mage.cards.c.CrowOfDarkTidings.class));
        cards.add(new SetCardInfo("Crushing Vines", 221, Rarity.COMMON, mage.cards.c.CrushingVines.class));
        cards.add(new SetCardInfo("Cultivate", 424, Rarity.COMMON, mage.cards.c.Cultivate.class));
        cards.add(new SetCardInfo("Cuombajj Witches", 116, Rarity.UNCOMMON, mage.cards.c.CuombajjWitches.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cuombajj Witches", 646, Rarity.UNCOMMON, mage.cards.c.CuombajjWitches.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Danitha Capashen, Paragon", 370, Rarity.UNCOMMON, mage.cards.d.DanithaCapashenParagon.class));
        cards.add(new SetCardInfo("Dargo, the Shipwrecker", 172, Rarity.UNCOMMON, mage.cards.d.DargoTheShipwrecker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dargo, the Shipwrecker", 572, Rarity.UNCOMMON, mage.cards.d.DargoTheShipwrecker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Daring Saboteur", 64, Rarity.UNCOMMON, mage.cards.d.DaringSaboteur.class));
        cards.add(new SetCardInfo("Dawn Charm", 371, Rarity.UNCOMMON, mage.cards.d.DawnCharm.class));
        cards.add(new SetCardInfo("Dawnglade Regent", 222, Rarity.RARE, mage.cards.d.DawngladeRegent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dawnglade Regent", 677, Rarity.RARE, mage.cards.d.DawngladeRegent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Defiant Salvager", 117, Rarity.COMMON, mage.cards.d.DefiantSalvager.class));
        cards.add(new SetCardInfo("Deflecting Palm", 444, Rarity.RARE, mage.cards.d.DeflectingPalm.class));
        cards.add(new SetCardInfo("Demonic Lore", 118, Rarity.UNCOMMON, mage.cards.d.DemonicLore.class));
        cards.add(new SetCardInfo("Deranged Assistant", 65, Rarity.COMMON, mage.cards.d.DerangedAssistant.class));
        cards.add(new SetCardInfo("Derevi, Empyrial Tactician", 518, Rarity.MYTHIC, mage.cards.d.DereviEmpyrialTactician.class));
        cards.add(new SetCardInfo("Dhund Operative", 119, Rarity.COMMON, mage.cards.d.DhundOperative.class));
        cards.add(new SetCardInfo("Disenchant", 372, Rarity.COMMON, mage.cards.d.Disenchant.class));
        cards.add(new SetCardInfo("Dispeller's Capsule", 18, Rarity.COMMON, mage.cards.d.DispellersCapsule.class));
        cards.add(new SetCardInfo("Doomed Traveler", 19, Rarity.COMMON, mage.cards.d.DoomedTraveler.class));
        cards.add(new SetCardInfo("Dragon Egg", 173, Rarity.COMMON, mage.cards.d.DragonEgg.class));
        cards.add(new SetCardInfo("Dragon Mantle", 174, Rarity.COMMON, mage.cards.d.DragonMantle.class));
        cards.add(new SetCardInfo("Dreamstone Hedron", 307, Rarity.UNCOMMON, mage.cards.d.DreamstoneHedron.class));
        cards.add(new SetCardInfo("Dualcaster Mage", 412, Rarity.RARE, mage.cards.d.DualcasterMage.class));
        cards.add(new SetCardInfo("Elder Deep-Fiend", 368, Rarity.RARE, mage.cards.e.ElderDeepFiend.class));
        cards.add(new SetCardInfo("Eligeth, Crossroads Augur", 556, Rarity.RARE, mage.cards.e.EligethCrossroadsAugur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eligeth, Crossroads Augur", 66, Rarity.RARE, mage.cards.e.EligethCrossroadsAugur.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elvish Doomsayer", 120, Rarity.COMMON, mage.cards.e.ElvishDoomsayer.class));
        cards.add(new SetCardInfo("Elvish Dreadlord", 121, Rarity.RARE, mage.cards.e.ElvishDreadlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elvish Dreadlord", 647, Rarity.RARE, mage.cards.e.ElvishDreadlord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elvish Visionary", 223, Rarity.COMMON, mage.cards.e.ElvishVisionary.class));
        cards.add(new SetCardInfo("Emberwilde Captain", 175, Rarity.RARE, mage.cards.e.EmberwildeCaptain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Emberwilde Captain", 664, Rarity.RARE, mage.cards.e.EmberwildeCaptain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Encroaching Wastes", 481, Rarity.UNCOMMON, mage.cards.e.EncroachingWastes.class));
        cards.add(new SetCardInfo("Entourage of Trest", 224, Rarity.COMMON, mage.cards.e.EntourageOfTrest.class));
        cards.add(new SetCardInfo("Esior, Wardwing Familiar", 557, Rarity.UNCOMMON, mage.cards.e.EsiorWardwingFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Esior, Wardwing Familiar", 67, Rarity.UNCOMMON, mage.cards.e.EsiorWardwingFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Eternal Witness", 425, Rarity.UNCOMMON, mage.cards.e.EternalWitness.class));
        cards.add(new SetCardInfo("Evolving Wilds", 482, Rarity.COMMON, mage.cards.e.EvolvingWilds.class));
        cards.add(new SetCardInfo("Expedite", 413, Rarity.COMMON, mage.cards.e.Expedite.class));
        cards.add(new SetCardInfo("Explore", 426, Rarity.COMMON, mage.cards.e.Explore.class));
        cards.add(new SetCardInfo("Explorer's Scope", 461, Rarity.COMMON, mage.cards.e.ExplorersScope.class));
        cards.add(new SetCardInfo("Explosion of Riches", 176, Rarity.UNCOMMON, mage.cards.e.ExplosionOfRiches.class));
        cards.add(new SetCardInfo("Exquisite Huntmaster", 122, Rarity.COMMON, mage.cards.e.ExquisiteHuntmaster.class));
        cards.add(new SetCardInfo("Eyeblight Assassin", 123, Rarity.COMMON, mage.cards.e.EyeblightAssassin.class));
        cards.add(new SetCardInfo("Eyeblight Cullers", 124, Rarity.COMMON, mage.cards.e.EyeblightCullers.class));
        cards.add(new SetCardInfo("Eyeblight Massacre", 125, Rarity.COMMON, mage.cards.e.EyeblightMassacre.class));
        cards.add(new SetCardInfo("Fact or Fiction", 396, Rarity.UNCOMMON, mage.cards.f.FactOrFiction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fact or Fiction", 634, Rarity.UNCOMMON, mage.cards.f.FactOrFiction.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faith Unbroken", 373, Rarity.UNCOMMON, mage.cards.f.FaithUnbroken.class));
        cards.add(new SetCardInfo("Faith's Fetters", 20, Rarity.UNCOMMON, mage.cards.f.FaithsFetters.class));
        cards.add(new SetCardInfo("Fall from Favor", 68, Rarity.COMMON, mage.cards.f.FallFromFavor.class));
        cards.add(new SetCardInfo("Falthis, Shadowcat Familiar", 126, Rarity.UNCOMMON, mage.cards.f.FalthisShadowcatFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Falthis, Shadowcat Familiar", 564, Rarity.UNCOMMON, mage.cards.f.FalthisShadowcatFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Farhaven Elf", 225, Rarity.COMMON, mage.cards.f.FarhavenElf.class));
        cards.add(new SetCardInfo("Fathom Fleet Swordjack", 177, Rarity.UNCOMMON, mage.cards.f.FathomFleetSwordjack.class));
        cards.add(new SetCardInfo("Fathom Mage", 445, Rarity.RARE, mage.cards.f.FathomMage.class));
        cards.add(new SetCardInfo("Feast of Succession", 127, Rarity.UNCOMMON, mage.cards.f.FeastOfSuccession.class));
        cards.add(new SetCardInfo("Fencing Ace", 21, Rarity.UNCOMMON, mage.cards.f.FencingAce.class));
        cards.add(new SetCardInfo("Fertilid", 226, Rarity.COMMON, mage.cards.f.Fertilid.class));
        cards.add(new SetCardInfo("Fiery Cannonade", 178, Rarity.COMMON, mage.cards.f.FieryCannonade.class));
        cards.add(new SetCardInfo("Filigree Familiar", 308, Rarity.COMMON, mage.cards.f.FiligreeFamiliar.class));
        cards.add(new SetCardInfo("Fin-Clade Fugitives", 227, Rarity.COMMON, mage.cards.f.FinCladeFugitives.class));
        cards.add(new SetCardInfo("Fire Diamond", 309, Rarity.COMMON, mage.cards.f.FireDiamond.class));
        cards.add(new SetCardInfo("Fireshrieker", 462, Rarity.UNCOMMON, mage.cards.f.Fireshrieker.class));
        cards.add(new SetCardInfo("First Response", 22, Rarity.UNCOMMON, mage.cards.f.FirstResponse.class));
        cards.add(new SetCardInfo("Fists of Flame", 414, Rarity.COMMON, mage.cards.f.FistsOfFlame.class));
        cards.add(new SetCardInfo("Flamekin Herald", 179, Rarity.RARE, mage.cards.f.FlamekinHerald.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flamekin Herald", 665, Rarity.RARE, mage.cards.f.FlamekinHerald.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fleshbag Marauder", 128, Rarity.COMMON, mage.cards.f.FleshbagMarauder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fleshbag Marauder", 648, Rarity.COMMON, mage.cards.f.FleshbagMarauder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Flickerwisp", 374, Rarity.UNCOMMON, mage.cards.f.Flickerwisp.class));
        cards.add(new SetCardInfo("Flood of Recollection", 61, Rarity.COMMON, mage.cards.f.FloodOfRecollection.class));
        cards.add(new SetCardInfo("Forceful Denial", 69, Rarity.COMMON, mage.cards.f.ForcefulDenial.class));
        cards.add(new SetCardInfo("Forest", 510, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 511, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forgotten Cave", 483, Rarity.COMMON, mage.cards.f.ForgottenCave.class));
        cards.add(new SetCardInfo("Foundry Inspector", 310, Rarity.COMMON, mage.cards.f.FoundryInspector.class));
        cards.add(new SetCardInfo("Frenzied Saddlebrute", 180, Rarity.UNCOMMON, mage.cards.f.FrenziedSaddlebrute.class));
        cards.add(new SetCardInfo("Furnace Celebration", 181, Rarity.UNCOMMON, mage.cards.f.FurnaceCelebration.class));
        cards.add(new SetCardInfo("Fyndhorn Elves", 228, Rarity.COMMON, mage.cards.f.FyndhornElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fyndhorn Elves", 678, Rarity.COMMON, mage.cards.f.FyndhornElves.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Galestrike", 70, Rarity.COMMON, mage.cards.g.Galestrike.class));
        cards.add(new SetCardInfo("Generous Gift", 375, Rarity.UNCOMMON, mage.cards.g.GenerousGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Generous Gift", 620, Rarity.UNCOMMON, mage.cards.g.GenerousGift.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghastly Demise", 129, Rarity.COMMON, mage.cards.g.GhastlyDemise.class));
        cards.add(new SetCardInfo("Ghen, Arcanum Weaver", 275, Rarity.RARE, mage.cards.g.GhenArcanumWeaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghen, Arcanum Weaver", 595, Rarity.RARE, mage.cards.g.GhenArcanumWeaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghost of Ramirez DePietro", 558, Rarity.UNCOMMON, mage.cards.g.GhostOfRamirezDePietro.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghost of Ramirez DePietro", 71, Rarity.UNCOMMON, mage.cards.g.GhostOfRamirezDePietro.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gift of Paradise", 229, Rarity.COMMON, mage.cards.g.GiftOfParadise.class));
        cards.add(new SetCardInfo("Gilanra, Caller of Wirewood", 230, Rarity.UNCOMMON, mage.cards.g.GilanraCallerOfWirewood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gilanra, Caller of Wirewood", 578, Rarity.UNCOMMON, mage.cards.g.GilanraCallerOfWirewood.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gilt-Leaf Winnower", 130, Rarity.UNCOMMON, mage.cards.g.GiltLeafWinnower.class));
        cards.add(new SetCardInfo("Glacian, Powerstone Engineer", 559, Rarity.UNCOMMON, mage.cards.g.GlacianPowerstoneEngineer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Glacian, Powerstone Engineer", 72, Rarity.UNCOMMON, mage.cards.g.GlacianPowerstoneEngineer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gnostro, Voice of the Crags", 276, Rarity.RARE, mage.cards.g.GnostroVoiceOfTheCrags.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gnostro, Voice of the Crags", 596, Rarity.RARE, mage.cards.g.GnostroVoiceOfTheCrags.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Goblin Trailblazer", 182, Rarity.COMMON, mage.cards.g.GoblinTrailblazer.class));
        cards.add(new SetCardInfo("Golem Artisan", 311, Rarity.UNCOMMON, mage.cards.g.GolemArtisan.class));
        cards.add(new SetCardInfo("Gor Muldrak, Amphinologist", 277, Rarity.RARE, mage.cards.g.GorMuldrakAmphinologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gor Muldrak, Amphinologist", 597, Rarity.RARE, mage.cards.g.GorMuldrakAmphinologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Grafted Wargear", 312, Rarity.UNCOMMON, mage.cards.g.GraftedWargear.class));
        cards.add(new SetCardInfo("Growth Spiral", 446, Rarity.COMMON, mage.cards.g.GrowthSpiral.class));
        cards.add(new SetCardInfo("Guildless Commons", 351, Rarity.UNCOMMON, mage.cards.g.GuildlessCommons.class));
        cards.add(new SetCardInfo("Halana, Kessig Ranger", 231, Rarity.UNCOMMON, mage.cards.h.HalanaKessigRanger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Halana, Kessig Ranger", 579, Rarity.UNCOMMON, mage.cards.h.HalanaKessigRanger.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hamza, Guardian of Arashin", 278, Rarity.UNCOMMON, mage.cards.h.HamzaGuardianOfArashin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hamza, Guardian of Arashin", 598, Rarity.UNCOMMON, mage.cards.h.HamzaGuardianOfArashin.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hans Eriksson", 279, Rarity.RARE, mage.cards.h.HansEriksson.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hans Eriksson", 599, Rarity.RARE, mage.cards.h.HansEriksson.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Harmonize", 427, Rarity.UNCOMMON, mage.cards.h.Harmonize.class));
        cards.add(new SetCardInfo("Haunted Cloak", 313, Rarity.COMMON, mage.cards.h.HauntedCloak.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Haunted Cloak", 463, Rarity.COMMON, mage.cards.h.HauntedCloak.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hellkite Courser", 183, Rarity.MYTHIC, mage.cards.h.HellkiteCourser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hellkite Courser", 666, Rarity.MYTHIC, mage.cards.h.HellkiteCourser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hero's Blade", 314, Rarity.UNCOMMON, mage.cards.h.HerosBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hero's Blade", 464, Rarity.UNCOMMON, mage.cards.h.HerosBlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horizon Scholar", 73, Rarity.UNCOMMON, mage.cards.h.HorizonScholar.class));
        cards.add(new SetCardInfo("Horizon Stone", 315, Rarity.RARE, mage.cards.h.HorizonStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Horizon Stone", 694, Rarity.RARE, mage.cards.h.HorizonStone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Howling Golem", 316, Rarity.COMMON, mage.cards.h.HowlingGolem.class));
        cards.add(new SetCardInfo("Hullbreacher", 635, Rarity.RARE, mage.cards.h.Hullbreacher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hullbreacher", 74, Rarity.RARE, mage.cards.h.Hullbreacher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Humble Defector", 184, Rarity.UNCOMMON, mage.cards.h.HumbleDefector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Humble Defector", 667, Rarity.UNCOMMON, mage.cards.h.HumbleDefector.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hunter's Insight", 232, Rarity.UNCOMMON, mage.cards.h.HuntersInsight.class));
        cards.add(new SetCardInfo("Ich-Tekik, Salvage Splicer", 233, Rarity.UNCOMMON, mage.cards.i.IchTekikSalvageSplicer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ich-Tekik, Salvage Splicer", 580, Rarity.UNCOMMON, mage.cards.i.IchTekikSalvageSplicer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ikra Shidiqi, the Usurper", 519, Rarity.MYTHIC, mage.cards.i.IkraShidiqiTheUsurper.class));
        cards.add(new SetCardInfo("Immaculate Magistrate", 234, Rarity.RARE, mage.cards.i.ImmaculateMagistrate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Immaculate Magistrate", 679, Rarity.RARE, mage.cards.i.ImmaculateMagistrate.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Imoti, Celebrant of Bounty", 280, Rarity.UNCOMMON, mage.cards.i.ImotiCelebrantOfBounty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Imoti, Celebrant of Bounty", 600, Rarity.UNCOMMON, mage.cards.i.ImotiCelebrantOfBounty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Imperious Perfect", 235, Rarity.UNCOMMON, mage.cards.i.ImperiousPerfect.class));
        cards.add(new SetCardInfo("Impulsive Pilferer", 185, Rarity.COMMON, mage.cards.i.ImpulsivePilferer.class));
        cards.add(new SetCardInfo("Ingenuity Engine", 317, Rarity.UNCOMMON, mage.cards.i.IngenuityEngine.class));
        cards.add(new SetCardInfo("Inspiring Roar", 23, Rarity.COMMON, mage.cards.i.InspiringRoar.class));
        cards.add(new SetCardInfo("Intangible Virtue", 24, Rarity.UNCOMMON, mage.cards.i.IntangibleVirtue.class));
        cards.add(new SetCardInfo("Interpret the Signs", 75, Rarity.UNCOMMON, mage.cards.i.InterpretTheSigns.class));
        cards.add(new SetCardInfo("Into the Roil", 397, Rarity.COMMON, mage.cards.i.IntoTheRoil.class));
        cards.add(new SetCardInfo("Iona's Judgment", 25, Rarity.COMMON, mage.cards.i.IonasJudgment.class));
        cards.add(new SetCardInfo("Ior Ruin Expedition", 398, Rarity.COMMON, mage.cards.i.IorRuinExpedition.class));
        cards.add(new SetCardInfo("Ironclad Slayer", 376, Rarity.COMMON, mage.cards.i.IroncladSlayer.class));
        cards.add(new SetCardInfo("Ishai, Ojutai Dragonspeaker", 520, Rarity.MYTHIC, mage.cards.i.IshaiOjutaiDragonspeaker.class));
        cards.add(new SetCardInfo("Island", 506, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 507, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivy Lane Denizen", 236, Rarity.COMMON, mage.cards.i.IvyLaneDenizen.class));
        cards.add(new SetCardInfo("Jalum Tome", 318, Rarity.COMMON, mage.cards.j.JalumTome.class));
        cards.add(new SetCardInfo("Jared Carthalion, True Heir", 281, Rarity.RARE, mage.cards.j.JaredCarthalionTrueHeir.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jared Carthalion, True Heir", 601, Rarity.RARE, mage.cards.j.JaredCarthalionTrueHeir.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jaya's Immolating Inferno", 415, Rarity.RARE, mage.cards.j.JayasImmolatingInferno.class));
        cards.add(new SetCardInfo("Jeska's Will", 187, Rarity.RARE, mage.cards.j.JeskasWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeska's Will", 668, Rarity.RARE, mage.cards.j.JeskasWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeska, Thrice Reborn", 186, Rarity.MYTHIC, mage.cards.j.JeskaThriceReborn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeska, Thrice Reborn", 513, Rarity.MYTHIC, mage.cards.j.JeskaThriceReborn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeweled Lotus", 319, Rarity.MYTHIC, mage.cards.j.JeweledLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jeweled Lotus", 695, Rarity.MYTHIC, mage.cards.j.JeweledLotus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jungle Basin", 484, Rarity.UNCOMMON, mage.cards.j.JungleBasin.class));
        cards.add(new SetCardInfo("Juri, Master of the Revue", 282, Rarity.UNCOMMON, mage.cards.j.JuriMasterOfTheRevue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Juri, Master of the Revue", 602, Rarity.UNCOMMON, mage.cards.j.JuriMasterOfTheRevue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kamahl's Will", 238, Rarity.RARE, mage.cards.k.KamahlsWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kamahl's Will", 680, Rarity.RARE, mage.cards.k.KamahlsWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kamahl, Heart of Krosa", 237, Rarity.MYTHIC, mage.cards.k.KamahlHeartOfKrosa.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kamahl, Heart of Krosa", 581, Rarity.MYTHIC, mage.cards.k.KamahlHeartOfKrosa.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kangee's Lieutenant", 26, Rarity.UNCOMMON, mage.cards.k.KangeesLieutenant.class));
        cards.add(new SetCardInfo("Kangee, Sky Warden", 283, Rarity.UNCOMMON, mage.cards.k.KangeeSkyWarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kangee, Sky Warden", 603, Rarity.UNCOMMON, mage.cards.k.KangeeSkyWarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Karador, Ghost Chieftain", 521, Rarity.MYTHIC, mage.cards.k.KaradorGhostChieftain.class));
        cards.add(new SetCardInfo("Karametra, God of Harvests", 522, Rarity.MYTHIC, mage.cards.k.KarametraGodOfHarvests.class));
        cards.add(new SetCardInfo("Kediss, Emberclaw Familiar", 188, Rarity.UNCOMMON, mage.cards.k.KedissEmberclawFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kediss, Emberclaw Familiar", 573, Rarity.UNCOMMON, mage.cards.k.KedissEmberclawFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keeper of the Accord", 27, Rarity.RARE, mage.cards.k.KeeperOfTheAccord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keeper of the Accord", 621, Rarity.RARE, mage.cards.k.KeeperOfTheAccord.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keleth, Sunmane Familiar", 28, Rarity.UNCOMMON, mage.cards.k.KelethSunmaneFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keleth, Sunmane Familiar", 550, Rarity.UNCOMMON, mage.cards.k.KelethSunmaneFamiliar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keskit, the Flesh Sculptor", 131, Rarity.UNCOMMON, mage.cards.k.KeskitTheFleshSculptor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keskit, the Flesh Sculptor", 565, Rarity.UNCOMMON, mage.cards.k.KeskitTheFleshSculptor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Khalni Heart Expedition", 428, Rarity.COMMON, mage.cards.k.KhalniHeartExpedition.class));
        cards.add(new SetCardInfo("Kinsbaile Courier", 29, Rarity.COMMON, mage.cards.k.KinsbaileCourier.class));
        cards.add(new SetCardInfo("Kitesail Corsair", 76, Rarity.COMMON, mage.cards.k.KitesailCorsair.class));
        cards.add(new SetCardInfo("Kitesail Skirmisher", 77, Rarity.COMMON, mage.cards.k.KitesailSkirmisher.class));
        cards.add(new SetCardInfo("Kodama of the East Tree", 239, Rarity.RARE, mage.cards.k.KodamaOfTheEastTree.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kodama of the East Tree", 582, Rarity.RARE, mage.cards.k.KodamaOfTheEastTree.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kodama's Reach", 429, Rarity.COMMON, mage.cards.k.KodamasReach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kodama's Reach", 681, Rarity.COMMON, mage.cards.k.KodamasReach.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kor Cartographer", 30, Rarity.COMMON, mage.cards.k.KorCartographer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kor Cartographer", 377, Rarity.COMMON, mage.cards.k.KorCartographer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krark, the Thumbless", 189, Rarity.RARE, mage.cards.k.KrarkTheThumbless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Krark, the Thumbless", 574, Rarity.RARE, mage.cards.k.KrarkTheThumbless.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kraum, Ludevic's Opus", 523, Rarity.MYTHIC, mage.cards.k.KraumLudevicsOpus.class));
        cards.add(new SetCardInfo("Kwain, Itinerant Meddler", 284, Rarity.RARE, mage.cards.k.KwainItinerantMeddler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kwain, Itinerant Meddler", 604, Rarity.RARE, mage.cards.k.KwainItinerantMeddler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Kydele, Chosen of Kruphix", 524, Rarity.MYTHIC, mage.cards.k.KydeleChosenOfKruphix.class));
        cards.add(new SetCardInfo("Laboratory Drudge", 636, Rarity.RARE, mage.cards.l.LaboratoryDrudge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Laboratory Drudge", 78, Rarity.RARE, mage.cards.l.LaboratoryDrudge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lathiel, the Bounteous Dawn", 285, Rarity.RARE, mage.cards.l.LathielTheBounteousDawn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lathiel, the Bounteous Dawn", 605, Rarity.RARE, mage.cards.l.LathielTheBounteousDawn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liesa, Shroud of Dusk", 286, Rarity.RARE, mage.cards.l.LiesaShroudOfDusk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Liesa, Shroud of Dusk", 606, Rarity.RARE, mage.cards.l.LiesaShroudOfDusk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Lifecrafter's Gift", 240, Rarity.COMMON, mage.cards.l.LifecraftersGift.class));
        cards.add(new SetCardInfo("Lightning-Rig Crew", 190, Rarity.UNCOMMON, mage.cards.l.LightningRigCrew.class));
        cards.add(new SetCardInfo("Livio, Oathsworn Sentinel", 31, Rarity.RARE, mage.cards.l.LivioOathswornSentinel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Livio, Oathsworn Sentinel", 551, Rarity.RARE, mage.cards.l.LivioOathswornSentinel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Loreseeker's Stone", 320, Rarity.UNCOMMON, mage.cards.l.LoreseekersStone.class));
        cards.add(new SetCardInfo("Loxodon Warhammer", 465, Rarity.RARE, mage.cards.l.LoxodonWarhammer.class));
        cards.add(new SetCardInfo("Ludevic, Necro-Alchemist", 525, Rarity.MYTHIC, mage.cards.l.LudevicNecroAlchemist.class));
        cards.add(new SetCardInfo("Lumengrid Gargoyle", 321, Rarity.COMMON, mage.cards.l.LumengridGargoyle.class));
        cards.add(new SetCardInfo("Lys Alana Bowmaster", 241, Rarity.COMMON, mage.cards.l.LysAlanaBowmaster.class));
        cards.add(new SetCardInfo("Maalfeld Twins", 132, Rarity.COMMON, mage.cards.m.MaalfeldTwins.class));
        cards.add(new SetCardInfo("Maelstrom Colossus", 322, Rarity.COMMON, mage.cards.m.MaelstromColossus.class));
        cards.add(new SetCardInfo("Maelstrom Wanderer", 526, Rarity.MYTHIC, mage.cards.m.MaelstromWanderer.class));
        cards.add(new SetCardInfo("Magus of the Order", 242, Rarity.RARE, mage.cards.m.MagusOfTheOrder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Magus of the Order", 682, Rarity.RARE, mage.cards.m.MagusOfTheOrder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Make a Stand", 32, Rarity.UNCOMMON, mage.cards.m.MakeAStand.class));
        cards.add(new SetCardInfo("Makeshift Munitions", 191, Rarity.COMMON, mage.cards.m.MakeshiftMunitions.class));
        cards.add(new SetCardInfo("Malcolm, Keen-Eyed Navigator", 560, Rarity.UNCOMMON, mage.cards.m.MalcolmKeenEyedNavigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Malcolm, Keen-Eyed Navigator", 79, Rarity.UNCOMMON, mage.cards.m.MalcolmKeenEyedNavigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Confluence", 721, Rarity.MYTHIC, mage.cards.m.ManaConfluence.class));
        cards.add(new SetCardInfo("Mana Drain", 637, Rarity.MYTHIC, mage.cards.m.ManaDrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mana Drain", 80, Rarity.MYTHIC, mage.cards.m.ManaDrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Marath, Will of the Wild", 527, Rarity.MYTHIC, mage.cards.m.MarathWillOfTheWild.class));
        cards.add(new SetCardInfo("Marble Diamond", 323, Rarity.COMMON, mage.cards.m.MarbleDiamond.class));
        cards.add(new SetCardInfo("Martial Coup", 378, Rarity.RARE, mage.cards.m.MartialCoup.class));
        cards.add(new SetCardInfo("Mask of Avacyn", 466, Rarity.UNCOMMON, mage.cards.m.MaskOfAvacyn.class));
        cards.add(new SetCardInfo("Mask of Memory", 324, Rarity.UNCOMMON, mage.cards.m.MaskOfMemory.class));
        cards.add(new SetCardInfo("Master Warcraft", 447, Rarity.RARE, mage.cards.m.MasterWarcraft.class));
        cards.add(new SetCardInfo("Meloku the Clouded Mirror", 399, Rarity.RARE, mage.cards.m.MelokuTheCloudedMirror.class));
        cards.add(new SetCardInfo("Memorial to Genius", 485, Rarity.UNCOMMON, mage.cards.m.MemorialToGenius.class));
        cards.add(new SetCardInfo("Memorial to War", 486, Rarity.UNCOMMON, mage.cards.m.MemorialToWar.class));
        cards.add(new SetCardInfo("Merchant Raiders", 81, Rarity.UNCOMMON, mage.cards.m.MerchantRaiders.class));
        cards.add(new SetCardInfo("Meteor Golem", 325, Rarity.UNCOMMON, mage.cards.m.MeteorGolem.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meteor Golem", 467, Rarity.UNCOMMON, mage.cards.m.MeteorGolem.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Meteoric Mace", 192, Rarity.UNCOMMON, mage.cards.m.MeteoricMace.class));
        cards.add(new SetCardInfo("Miara, Thorn of the Glade", 133, Rarity.UNCOMMON, mage.cards.m.MiaraThornOfTheGlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Miara, Thorn of the Glade", 566, Rarity.UNCOMMON, mage.cards.m.MiaraThornOfTheGlade.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mindless Automaton", 326, Rarity.UNCOMMON, mage.cards.m.MindlessAutomaton.class));
        cards.add(new SetCardInfo("Mnemonic Deluge", 638, Rarity.MYTHIC, mage.cards.m.MnemonicDeluge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mnemonic Deluge", 82, Rarity.MYTHIC, mage.cards.m.MnemonicDeluge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Molder Beast", 243, Rarity.COMMON, mage.cards.m.MolderBeast.class));
        cards.add(new SetCardInfo("Molimo, Maro-Sorcerer", 430, Rarity.RARE, mage.cards.m.MolimoMaroSorcerer.class));
        cards.add(new SetCardInfo("Monstrous Onslaught", 244, Rarity.UNCOMMON, mage.cards.m.MonstrousOnslaught.class));
        cards.add(new SetCardInfo("Moss Diamond", 327, Rarity.COMMON, mage.cards.m.MossDiamond.class));
        cards.add(new SetCardInfo("Mountain", 508, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 509, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Muldrotha, the Gravetide", 528, Rarity.MYTHIC, mage.cards.m.MuldrothaTheGravetide.class));
        cards.add(new SetCardInfo("Mulldrifter", 400, Rarity.UNCOMMON, mage.cards.m.Mulldrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mulldrifter", 639, Rarity.UNCOMMON, mage.cards.m.Mulldrifter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Murder", 134, Rarity.COMMON, mage.cards.m.Murder.class));
        cards.add(new SetCardInfo("Murkfiend Liege", 448, Rarity.RARE, mage.cards.m.MurkfiendLiege.class));
        cards.add(new SetCardInfo("Myriad Landscape", 487, Rarity.UNCOMMON, mage.cards.m.MyriadLandscape.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Myriad Landscape", 706, Rarity.UNCOMMON, mage.cards.m.MyriadLandscape.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nadier's Nightblade", 136, Rarity.UNCOMMON, mage.cards.n.NadiersNightblade.class));
        cards.add(new SetCardInfo("Nadier, Agent of the Duskenel", 135, Rarity.UNCOMMON, mage.cards.n.NadierAgentOfTheDuskenel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nadier, Agent of the Duskenel", 567, Rarity.UNCOMMON, mage.cards.n.NadierAgentOfTheDuskenel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Najeela, the Blade-Blossom", 514, Rarity.MYTHIC, mage.cards.n.NajeelaTheBladeBlossom.class));
        cards.add(new SetCardInfo("Natural Reclamation", 245, Rarity.COMMON, mage.cards.n.NaturalReclamation.class));
        cards.add(new SetCardInfo("Necrotic Hex", 137, Rarity.RARE, mage.cards.n.NecroticHex.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Necrotic Hex", 649, Rarity.RARE, mage.cards.n.NecroticHex.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nekusar, the Mindrazer", 529, Rarity.MYTHIC, mage.cards.n.NekusarTheMindrazer.class));
        cards.add(new SetCardInfo("Nevinyrral's Disk", 328, Rarity.RARE, mage.cards.n.NevinyrralsDisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral's Disk", 696, Rarity.RARE, mage.cards.n.NevinyrralsDisk.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral, Urborg Tyrant", 287, Rarity.RARE, mage.cards.n.NevinyrralUrborgTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nevinyrral, Urborg Tyrant", 607, Rarity.RARE, mage.cards.n.NevinyrralUrborgTyrant.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nezahal, Primal Tide", 401, Rarity.RARE, mage.cards.n.NezahalPrimalTide.class));
        cards.add(new SetCardInfo("Nightshade Harvester", 138, Rarity.RARE, mage.cards.n.NightshadeHarvester.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nightshade Harvester", 650, Rarity.RARE, mage.cards.n.NightshadeHarvester.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ninth Bridge Patrol", 33, Rarity.COMMON, mage.cards.n.NinthBridgePatrol.class));
        cards.add(new SetCardInfo("Noxious Dragon", 139, Rarity.UNCOMMON, mage.cards.n.NoxiousDragon.class));
        cards.add(new SetCardInfo("Null Caller", 140, Rarity.UNCOMMON, mage.cards.n.NullCaller.class));
        cards.add(new SetCardInfo("Numa, Joraga Chieftain", 246, Rarity.UNCOMMON, mage.cards.n.NumaJoragaChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Numa, Joraga Chieftain", 583, Rarity.UNCOMMON, mage.cards.n.NumaJoragaChieftain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nymris, Oona's Trickster", 288, Rarity.RARE, mage.cards.n.NymrisOonasTrickster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nymris, Oona's Trickster", 608, Rarity.RARE, mage.cards.n.NymrisOonasTrickster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obeka, Brute Chronologist", 289, Rarity.RARE, mage.cards.o.ObekaBruteChronologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Obeka, Brute Chronologist", 609, Rarity.RARE, mage.cards.o.ObekaBruteChronologist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Odric, Lunarch Marshal", 379, Rarity.RARE, mage.cards.o.OdricLunarchMarshal.class));
        cards.add(new SetCardInfo("Omenspeaker", 83, Rarity.COMMON, mage.cards.o.Omenspeaker.class));
        cards.add(new SetCardInfo("On Serra's Wings", 380, Rarity.UNCOMMON, mage.cards.o.OnSerrasWings.class));
        cards.add(new SetCardInfo("Opal Palace", 352, Rarity.COMMON, mage.cards.o.OpalPalace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Opal Palace", 707, Rarity.COMMON, mage.cards.o.OpalPalace.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Opposition Agent", 141, Rarity.RARE, mage.cards.o.OppositionAgent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Opposition Agent", 651, Rarity.RARE, mage.cards.o.OppositionAgent.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Open the Armory", 34, Rarity.UNCOMMON, mage.cards.o.OpenTheArmory.class));
        cards.add(new SetCardInfo("Ordeal of Nylea", 247, Rarity.UNCOMMON, mage.cards.o.OrdealOfNylea.class));
        cards.add(new SetCardInfo("Oreskos Explorer", 381, Rarity.UNCOMMON, mage.cards.o.OreskosExplorer.class));
        cards.add(new SetCardInfo("Orzhov Advokist", 35, Rarity.UNCOMMON, mage.cards.o.OrzhovAdvokist.class));
        cards.add(new SetCardInfo("Palace Sentinels", 36, Rarity.COMMON, mage.cards.p.PalaceSentinels.class));
        cards.add(new SetCardInfo("Path of Ancestry", 353, Rarity.COMMON, mage.cards.p.PathOfAncestry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Path of Ancestry", 708, Rarity.COMMON, mage.cards.p.PathOfAncestry.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Patron of the Valiant", 37, Rarity.UNCOMMON, mage.cards.p.PatronOfTheValiant.class));
        cards.add(new SetCardInfo("Peel from Reality", 402, Rarity.COMMON, mage.cards.p.PeelFromReality.class));
        cards.add(new SetCardInfo("Pennon Blade", 329, Rarity.UNCOMMON, mage.cards.p.PennonBlade.class));
        cards.add(new SetCardInfo("Perilous Myr", 330, Rarity.COMMON, mage.cards.p.PerilousMyr.class));
        cards.add(new SetCardInfo("Phyrexian Rager", 142, Rarity.COMMON, mage.cards.p.PhyrexianRager.class));
        cards.add(new SetCardInfo("Phyrexian Triniform", 331, Rarity.MYTHIC, mage.cards.p.PhyrexianTriniform.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phyrexian Triniform", 697, Rarity.MYTHIC, mage.cards.p.PhyrexianTriniform.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pilgrim's Eye", 332, Rarity.COMMON, mage.cards.p.PilgrimsEye.class));
        cards.add(new SetCardInfo("Pirate's Cutlass", 333, Rarity.COMMON, mage.cards.p.PiratesCutlass.class));
        cards.add(new SetCardInfo("Plague Reaver", 143, Rarity.RARE, mage.cards.p.PlagueReaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plague Reaver", 652, Rarity.RARE, mage.cards.p.PlagueReaver.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 504, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 505, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Port Razer", 193, Rarity.MYTHIC, mage.cards.p.PortRazer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Port Razer", 669, Rarity.MYTHIC, mage.cards.p.PortRazer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Portent of Betrayal", 194, Rarity.COMMON, mage.cards.p.PortentOfBetrayal.class));
        cards.add(new SetCardInfo("Prava of the Steel Legion", 38, Rarity.UNCOMMON, mage.cards.p.PravaOfTheSteelLegion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prava of the Steel Legion", 552, Rarity.UNCOMMON, mage.cards.p.PravaOfTheSteelLegion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Preordain", 640, Rarity.COMMON, mage.cards.p.Preordain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Preordain", 84, Rarity.COMMON, mage.cards.p.Preordain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pride of the Perfect", 144, Rarity.UNCOMMON, mage.cards.p.PrideOfThePerfect.class));
        cards.add(new SetCardInfo("Profane Transfusion", 145, Rarity.MYTHIC, mage.cards.p.ProfaneTransfusion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Profane Transfusion", 653, Rarity.MYTHIC, mage.cards.p.ProfaneTransfusion.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Promise of Tomorrow", 39, Rarity.RARE, mage.cards.p.PromiseOfTomorrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Promise of Tomorrow", 622, Rarity.RARE, mage.cards.p.PromiseOfTomorrow.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Prophetic Prism", 334, Rarity.COMMON, mage.cards.p.PropheticPrism.class));
        cards.add(new SetCardInfo("Prosperous Pirates", 85, Rarity.COMMON, mage.cards.p.ProsperousPirates.class));
        cards.add(new SetCardInfo("Prossh, Skyraider of Kher", 530, Rarity.MYTHIC, mage.cards.p.ProsshSkyraiderOfKher.class));
        cards.add(new SetCardInfo("Prying Eyes", 86, Rarity.COMMON, mage.cards.p.PryingEyes.class));
        cards.add(new SetCardInfo("Queen Marchesa", 531, Rarity.MYTHIC, mage.cards.q.QueenMarchesa.class));
        cards.add(new SetCardInfo("Radiant, Serra Archangel", 40, Rarity.UNCOMMON, mage.cards.r.RadiantSerraArchangel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radiant, Serra Archangel", 553, Rarity.UNCOMMON, mage.cards.r.RadiantSerraArchangel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Raise the Alarm", 41, Rarity.COMMON, mage.cards.r.RaiseTheAlarm.class));
        cards.add(new SetCardInfo("Rakdos, Lord of Riots", 532, Rarity.MYTHIC, mage.cards.r.RakdosLordOfRiots.class));
        cards.add(new SetCardInfo("Rakshasa Debaser", 146, Rarity.RARE, mage.cards.r.RakshasaDebaser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rakshasa Debaser", 654, Rarity.RARE, mage.cards.r.RakshasaDebaser.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ramos, Dragon Engine", 545, Rarity.MYTHIC, mage.cards.r.RamosDragonEngine.class));
        cards.add(new SetCardInfo("Rampaging Baloths", 431, Rarity.RARE, mage.cards.r.RampagingBaloths.class));
        cards.add(new SetCardInfo("Rampant Growth", 432, Rarity.COMMON, mage.cards.r.RampantGrowth.class));
        cards.add(new SetCardInfo("Ramunap Excavator", 433, Rarity.RARE, mage.cards.r.RamunapExcavator.class));
        cards.add(new SetCardInfo("Ravos, Soultender", 533, Rarity.MYTHIC, mage.cards.r.RavosSoultender.class));
        cards.add(new SetCardInfo("Rebbec, Architect of Ascension", 42, Rarity.UNCOMMON, mage.cards.r.RebbecArchitectOfAscension.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rebbec, Architect of Ascension", 554, Rarity.UNCOMMON, mage.cards.r.RebbecArchitectOfAscension.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reclamation Sage", 248, Rarity.UNCOMMON, mage.cards.r.ReclamationSage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reclamation Sage", 434, Rarity.UNCOMMON, mage.cards.r.ReclamationSage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rejuvenating Springs", 354, Rarity.RARE, mage.cards.r.RejuvenatingSprings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rejuvenating Springs", 709, Rarity.RARE, mage.cards.r.RejuvenatingSprings.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Relentless Assault", 416, Rarity.RARE, mage.cards.r.RelentlessAssault.class));
        cards.add(new SetCardInfo("Relic Seeker", 382, Rarity.RARE, mage.cards.r.RelicSeeker.class));
        cards.add(new SetCardInfo("Reliquary Tower", 488, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reliquary Tower", 710, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Renegade Tactics", 195, Rarity.COMMON, mage.cards.r.RenegadeTactics.class));
        cards.add(new SetCardInfo("Response // Resurgence", 449, Rarity.RARE, mage.cards.r.ResponseResurgence.class));
        cards.add(new SetCardInfo("Reshape the Earth", 249, Rarity.MYTHIC, mage.cards.r.ReshapeTheEarth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reshape the Earth", 683, Rarity.MYTHIC, mage.cards.r.ReshapeTheEarth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Retreat to Kazandu", 435, Rarity.UNCOMMON, mage.cards.r.RetreatToKazandu.class));
        cards.add(new SetCardInfo("Return to Dust", 383, Rarity.UNCOMMON, mage.cards.r.ReturnToDust.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Return to Dust", 43, Rarity.UNCOMMON, mage.cards.r.ReturnToDust.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Return to Dust", 623, Rarity.UNCOMMON, mage.cards.r.ReturnToDust.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Revenant", 147, Rarity.UNCOMMON, mage.cards.r.Revenant.class));
        cards.add(new SetCardInfo("Reyav, Master Smith", 290, Rarity.UNCOMMON, mage.cards.r.ReyavMasterSmith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reyav, Master Smith", 610, Rarity.UNCOMMON, mage.cards.r.ReyavMasterSmith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reyhan, Last of the Abzan", 534, Rarity.MYTHIC, mage.cards.r.ReyhanLastOfTheAbzan.class));
        cards.add(new SetCardInfo("Ring of Thune", 468, Rarity.UNCOMMON, mage.cards.r.RingOfThune.class));
        cards.add(new SetCardInfo("Ring of Valkas", 469, Rarity.UNCOMMON, mage.cards.r.RingOfValkas.class));
        cards.add(new SetCardInfo("Rings of Brighthearth", 335, Rarity.RARE, mage.cards.r.RingsOfBrighthearth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rings of Brighthearth", 698, Rarity.RARE, mage.cards.r.RingsOfBrighthearth.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ripscale Predator", 196, Rarity.COMMON, mage.cards.r.RipscalePredator.class));
        cards.add(new SetCardInfo("Rograkh, Son of Rohgahh", 197, Rarity.UNCOMMON, mage.cards.r.RograkhSonOfRohgahh.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rograkh, Son of Rohgahh", 575, Rarity.UNCOMMON, mage.cards.r.RograkhSonOfRohgahh.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rogue's Passage", 489, Rarity.UNCOMMON, mage.cards.r.RoguesPassage.class));
        cards.add(new SetCardInfo("Rootweaver Druid", 250, Rarity.RARE, mage.cards.r.RootweaverDruid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rootweaver Druid", 684, Rarity.RARE, mage.cards.r.RootweaverDruid.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rummaging Goblin", 198, Rarity.COMMON, mage.cards.r.RummagingGoblin.class));
        cards.add(new SetCardInfo("Run Away Together", 87, Rarity.COMMON, mage.cards.r.RunAwayTogether.class));
        cards.add(new SetCardInfo("Rupture Spire", 355, Rarity.COMMON, mage.cards.r.RuptureSpire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rupture Spire", 490, Rarity.COMMON, mage.cards.r.RuptureSpire.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sailor of Means", 88, Rarity.COMMON, mage.cards.s.SailorOfMeans.class));
        cards.add(new SetCardInfo("Sakashima of a Thousand Faces", 561, Rarity.MYTHIC, mage.cards.s.SakashimaOfAThousandFaces.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakashima of a Thousand Faces", 89, Rarity.MYTHIC, mage.cards.s.SakashimaOfAThousandFaces.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakashima's Protege", 641, Rarity.RARE, mage.cards.s.SakashimasProtege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakashima's Protege", 90, Rarity.RARE, mage.cards.s.SakashimasProtege.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakashima's Will", 642, Rarity.RARE, mage.cards.s.SakashimasWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sakashima's Will", 91, Rarity.RARE, mage.cards.s.SakashimasWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sandstone Oracle", 336, Rarity.UNCOMMON, mage.cards.s.SandstoneOracle.class));
        cards.add(new SetCardInfo("Sanitarium Skeleton", 148, Rarity.COMMON, mage.cards.s.SanitariumSkeleton.class));
        cards.add(new SetCardInfo("Scaled Behemoth", 251, Rarity.UNCOMMON, mage.cards.s.ScaledBehemoth.class));
        cards.add(new SetCardInfo("Scholar of Stars", 92, Rarity.COMMON, mage.cards.s.ScholarOfStars.class));
        cards.add(new SetCardInfo("Scholar of the Ages", 93, Rarity.UNCOMMON, mage.cards.s.ScholarOfTheAges.class));
        cards.add(new SetCardInfo("Scourge of Fleets", 403, Rarity.RARE, mage.cards.s.ScourgeOfFleets.class));
        cards.add(new SetCardInfo("Scrapdiver Serpent", 94, Rarity.COMMON, mage.cards.s.ScrapdiverSerpent.class));
        cards.add(new SetCardInfo("Scroll Rack", 337, Rarity.MYTHIC, mage.cards.s.ScrollRack.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scroll Rack", 699, Rarity.MYTHIC, mage.cards.s.ScrollRack.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scrounging Bandar", 252, Rarity.COMMON, mage.cards.s.ScroungingBandar.class));
        cards.add(new SetCardInfo("Search for Tomorrow", 436, Rarity.COMMON, mage.cards.s.SearchForTomorrow.class));
        cards.add(new SetCardInfo("Secluded Steppe", 491, Rarity.UNCOMMON, mage.cards.s.SecludedSteppe.class));
        cards.add(new SetCardInfo("Seer's Lantern", 338, Rarity.COMMON, mage.cards.s.SeersLantern.class));
        cards.add(new SetCardInfo("Seer's Sundial", 470, Rarity.RARE, mage.cards.s.SeersSundial.class));
        cards.add(new SetCardInfo("Sengir, the Dark Baron", 149, Rarity.RARE, mage.cards.s.SengirTheDarkBaron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sengir, the Dark Baron", 568, Rarity.RARE, mage.cards.s.SengirTheDarkBaron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sengir, the Dark Baron", 722, Rarity.RARE, mage.cards.s.SengirTheDarkBaron.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sentinel Spider", 253, Rarity.COMMON, mage.cards.s.SentinelSpider.class));
        cards.add(new SetCardInfo("Seraph of Dawn", 44, Rarity.COMMON, mage.cards.s.SeraphOfDawn.class));
        cards.add(new SetCardInfo("Seraphic Greatsword", 45, Rarity.MYTHIC, mage.cards.s.SeraphicGreatsword.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Seraphic Greatsword", 624, Rarity.MYTHIC, mage.cards.s.SeraphicGreatsword.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sharktocrab", 450, Rarity.UNCOMMON, mage.cards.s.Sharktocrab.class));
        cards.add(new SetCardInfo("Shimmer Myr", 339, Rarity.UNCOMMON, mage.cards.s.ShimmerMyr.class));
        cards.add(new SetCardInfo("Shipbreaker Kraken", 404, Rarity.RARE, mage.cards.s.ShipbreakerKraken.class));
        cards.add(new SetCardInfo("Siani, Eye of the Storm", 562, Rarity.UNCOMMON, mage.cards.s.SianiEyeOfTheStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Siani, Eye of the Storm", 95, Rarity.UNCOMMON, mage.cards.s.SianiEyeOfTheStorm.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sidar Kondo of Jamuraa", 535, Rarity.MYTHIC, mage.cards.s.SidarKondoOfJamuraa.class));
        cards.add(new SetCardInfo("Sifter Wurm", 254, Rarity.UNCOMMON, mage.cards.s.SifterWurm.class));
        cards.add(new SetCardInfo("Sigarda's Aid", 384, Rarity.RARE, mage.cards.s.SigardasAid.class));
        cards.add(new SetCardInfo("Silas Renn, Seeker Adept", 536, Rarity.MYTHIC, mage.cards.s.SilasRennSeekerAdept.class));
        cards.add(new SetCardInfo("Silverback Shaman", 255, Rarity.COMMON, mage.cards.s.SilverbackShaman.class));
        cards.add(new SetCardInfo("Simic Charm", 451, Rarity.UNCOMMON, mage.cards.s.SimicCharm.class));
        cards.add(new SetCardInfo("Simic Growth Chamber", 492, Rarity.UNCOMMON, mage.cards.s.SimicGrowthChamber.class));
        cards.add(new SetCardInfo("Simic Guildgate", 493, Rarity.COMMON, mage.cards.s.SimicGuildgate.class));
        cards.add(new SetCardInfo("Simic Signet", 471, Rarity.COMMON, mage.cards.s.SimicSignet.class));
        cards.add(new SetCardInfo("Simic Sky Swallower", 452, Rarity.RARE, mage.cards.s.SimicSkySwallower.class));
        cards.add(new SetCardInfo("Siren Stormtamer", 96, Rarity.UNCOMMON, mage.cards.s.SirenStormtamer.class));
        cards.add(new SetCardInfo("Sisay's Ring", 340, Rarity.COMMON, mage.cards.s.SisaysRing.class));
        cards.add(new SetCardInfo("Skaab Goliath", 97, Rarity.COMMON, mage.cards.s.SkaabGoliath.class));
        cards.add(new SetCardInfo("Skilled Animator", 98, Rarity.UNCOMMON, mage.cards.s.SkilledAnimator.class));
        cards.add(new SetCardInfo("Sky Diamond", 341, Rarity.COMMON, mage.cards.s.SkyDiamond.class));
        cards.add(new SetCardInfo("Skyraker Giant", 199, Rarity.COMMON, mage.cards.s.SkyrakerGiant.class));
        cards.add(new SetCardInfo("Skywhaler's Shot", 46, Rarity.COMMON, mage.cards.s.SkywhalersShot.class));
        cards.add(new SetCardInfo("Slash the Ranks", 47, Rarity.RARE, mage.cards.s.SlashTheRanks.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Slash the Ranks", 625, Rarity.RARE, mage.cards.s.SlashTheRanks.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Slaughter the Strong", 48, Rarity.UNCOMMON, mage.cards.s.SlaughterTheStrong.class));
        cards.add(new SetCardInfo("Slayers' Stronghold", 494, Rarity.RARE, mage.cards.s.SlayersStronghold.class));
        cards.add(new SetCardInfo("Slinn Voda, the Rising Deep", 405, Rarity.UNCOMMON, mage.cards.s.SlinnVodaTheRisingDeep.class));
        cards.add(new SetCardInfo("Slith Ascendant", 49, Rarity.COMMON, mage.cards.s.SlithAscendant.class));
        cards.add(new SetCardInfo("Slurrk, All-Ingesting", 256, Rarity.UNCOMMON, mage.cards.s.SlurrkAllIngesting.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Slurrk, All-Ingesting", 584, Rarity.UNCOMMON, mage.cards.s.SlurrkAllIngesting.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 472, Rarity.UNCOMMON, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 700, Rarity.UNCOMMON, mage.cards.s.SolRing.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul of Eternity", 50, Rarity.RARE, mage.cards.s.SoulOfEternity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul of Eternity", 626, Rarity.RARE, mage.cards.s.SoulOfEternity.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soul's Fire", 200, Rarity.COMMON, mage.cards.s.SoulsFire.class));
        cards.add(new SetCardInfo("Soul's Might", 257, Rarity.COMMON, mage.cards.s.SoulsMight.class));
        cards.add(new SetCardInfo("Soulfire Eruption", 201, Rarity.MYTHIC, mage.cards.s.SoulfireEruption.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Soulfire Eruption", 670, Rarity.MYTHIC, mage.cards.s.SoulfireEruption.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spark Harvest", 150, Rarity.COMMON, mage.cards.s.SparkHarvest.class));
        cards.add(new SetCardInfo("Sparktongue Dragon", 202, Rarity.COMMON, mage.cards.s.SparktongueDragon.class));
        cards.add(new SetCardInfo("Spectator Seating", 356, Rarity.RARE, mage.cards.s.SpectatorSeating.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spectator Seating", 711, Rarity.RARE, mage.cards.s.SpectatorSeating.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spectral Searchlight", 342, Rarity.COMMON, mage.cards.s.SpectralSearchlight.class));
        cards.add(new SetCardInfo("Sphinx of Uthuun", 406, Rarity.RARE, mage.cards.s.SphinxOfUthuun.class));
        cards.add(new SetCardInfo("Sphinx of the Second Sun", 643, Rarity.MYTHIC, mage.cards.s.SphinxOfTheSecondSun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sphinx of the Second Sun", 99, Rarity.MYTHIC, mage.cards.s.SphinxOfTheSecondSun.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spirit Mantle", 385, Rarity.UNCOMMON, mage.cards.s.SpiritMantle.class));
        cards.add(new SetCardInfo("Spitting Image", 453, Rarity.RARE, mage.cards.s.SpittingImage.class));
        cards.add(new SetCardInfo("Spontaneous Mutation", 100, Rarity.COMMON, mage.cards.s.SpontaneousMutation.class));
        cards.add(new SetCardInfo("Sporemound", 437, Rarity.COMMON, mage.cards.s.Sporemound.class));
        cards.add(new SetCardInfo("Squad Captain", 51, Rarity.COMMON, mage.cards.s.SquadCaptain.class));
        cards.add(new SetCardInfo("Sram, Senior Edificer", 386, Rarity.RARE, mage.cards.s.SramSeniorEdificer.class));
        cards.add(new SetCardInfo("Staff of Domination", 343, Rarity.RARE, mage.cards.s.StaffOfDomination.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Staff of Domination", 701, Rarity.RARE, mage.cards.s.StaffOfDomination.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Staunch Throneguard", 344, Rarity.COMMON, mage.cards.s.StaunchThroneguard.class));
        cards.add(new SetCardInfo("Stingerfling Spider", 258, Rarity.UNCOMMON, mage.cards.s.StingerflingSpider.class));
        cards.add(new SetCardInfo("Stone Quarry", 495, Rarity.UNCOMMON, mage.cards.s.StoneQuarry.class));
        cards.add(new SetCardInfo("Stonefury", 203, Rarity.COMMON, mage.cards.s.Stonefury.class));
        cards.add(new SetCardInfo("Stormtide Leviathan", 407, Rarity.RARE, mage.cards.s.StormtideLeviathan.class));
        cards.add(new SetCardInfo("Strategic Planning", 101, Rarity.COMMON, mage.cards.s.StrategicPlanning.class));
        cards.add(new SetCardInfo("Strength of the Pack", 259, Rarity.UNCOMMON, mage.cards.s.StrengthOfThePack.class));
        cards.add(new SetCardInfo("Stumpsquall Hydra", 367, Rarity.RARE, mage.cards.s.StumpsquallHydra.class));
        cards.add(new SetCardInfo("Sunforger", 473, Rarity.RARE, mage.cards.s.Sunforger.class));
        cards.add(new SetCardInfo("Sunhome, Fortress of the Legion", 496, Rarity.UNCOMMON, mage.cards.s.SunhomeFortressOfTheLegion.class));
        cards.add(new SetCardInfo("Sunset Pyramid", 345, Rarity.UNCOMMON, mage.cards.s.SunsetPyramid.class));
        cards.add(new SetCardInfo("Supernatural Stamina", 151, Rarity.COMMON, mage.cards.s.SupernaturalStamina.class));
        cards.add(new SetCardInfo("Supreme Will", 102, Rarity.UNCOMMON, mage.cards.s.SupremeWill.class));
        cards.add(new SetCardInfo("Sweet-Gum Recluse", 260, Rarity.RARE, mage.cards.s.SweetGumRecluse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sweet-Gum Recluse", 685, Rarity.RARE, mage.cards.s.SweetGumRecluse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swiftfoot Boots", 474, Rarity.UNCOMMON, mage.cards.s.SwiftfootBoots.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swiftfoot Boots", 702, Rarity.UNCOMMON, mage.cards.s.SwiftfootBoots.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sword of Vengeance", 475, Rarity.RARE, mage.cards.s.SwordOfVengeance.class));
        cards.add(new SetCardInfo("Swords to Plowshares", 387, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swords to Plowshares", 627, Rarity.UNCOMMON, mage.cards.s.SwordsToPlowshares.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Szat's Will", 152, Rarity.RARE, mage.cards.s.SzatsWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Szat's Will", 655, Rarity.RARE, mage.cards.s.SzatsWill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tana, the Bloodsower", 537, Rarity.MYTHIC, mage.cards.t.TanaTheBloodsower.class));
        cards.add(new SetCardInfo("Temur Battle Rage", 417, Rarity.COMMON, mage.cards.t.TemurBattleRage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Temur Battle Rage", 671, Rarity.COMMON, mage.cards.t.TemurBattleRage.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terastodon", 438, Rarity.RARE, mage.cards.t.Terastodon.class));
        cards.add(new SetCardInfo("Terramorphic Expanse", 357, Rarity.COMMON, mage.cards.t.TerramorphicExpanse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terramorphic Expanse", 497, Rarity.COMMON, mage.cards.t.TerramorphicExpanse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terramorphic Expanse", 712, Rarity.COMMON, mage.cards.t.TerramorphicExpanse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tevesh Szat, Doom of Fools", 153, Rarity.MYTHIC, mage.cards.t.TeveshSzatDoomOfFools.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tevesh Szat, Doom of Fools", 512, Rarity.MYTHIC, mage.cards.t.TeveshSzatDoomOfFools.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thalisse, Reverent Medium", 291, Rarity.UNCOMMON, mage.cards.t.ThalisseReverentMedium.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thalisse, Reverent Medium", 611, Rarity.UNCOMMON, mage.cards.t.ThalisseReverentMedium.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Prismatic Piper", 1, Rarity.COMMON, mage.cards.t.ThePrismaticPiper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("The Prismatic Piper", 546, Rarity.COMMON, mage.cards.t.ThePrismaticPiper.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thirst for Knowledge", 103, Rarity.UNCOMMON, mage.cards.t.ThirstForKnowledge.class));
        cards.add(new SetCardInfo("Thorn of the Black Rose", 154, Rarity.COMMON, mage.cards.t.ThornOfTheBlackRose.class));
        cards.add(new SetCardInfo("Thornwood Falls", 498, Rarity.COMMON, mage.cards.t.ThornwoodFalls.class));
        cards.add(new SetCardInfo("Thought Vessel", 346, Rarity.UNCOMMON, mage.cards.t.ThoughtVessel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thought Vessel", 703, Rarity.UNCOMMON, mage.cards.t.ThoughtVessel.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thrasios, Triton Hero", 538, Rarity.MYTHIC, mage.cards.t.ThrasiosTritonHero.class));
        cards.add(new SetCardInfo("Three Visits", 261, Rarity.UNCOMMON, mage.cards.t.ThreeVisits.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Three Visits", 686, Rarity.UNCOMMON, mage.cards.t.ThreeVisits.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tiana, Ship's Caretaker", 454, Rarity.UNCOMMON, mage.cards.t.TianaShipsCaretaker.class));
        cards.add(new SetCardInfo("Timely Ward", 363, Rarity.RARE, mage.cards.t.TimelyWard.class));
        cards.add(new SetCardInfo("Toggo, Goblin Weaponsmith", 204, Rarity.UNCOMMON, mage.cards.t.ToggoGoblinWeaponsmith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Toggo, Goblin Weaponsmith", 576, Rarity.UNCOMMON, mage.cards.t.ToggoGoblinWeaponsmith.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tormod, the Desecrator", 155, Rarity.UNCOMMON, mage.cards.t.TormodTheDesecrator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tormod, the Desecrator", 569, Rarity.UNCOMMON, mage.cards.t.TormodTheDesecrator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Training Center", 358, Rarity.RARE, mage.cards.t.TrainingCenter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Training Center", 713, Rarity.RARE, mage.cards.t.TrainingCenter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Transguild Promenade", 499, Rarity.COMMON, mage.cards.t.TransguildPromenade.class));
        cards.add(new SetCardInfo("Trench Behemoth", 366, Rarity.RARE, mage.cards.t.TrenchBehemoth.class));
        cards.add(new SetCardInfo("Triumphant Reckoning", 52, Rarity.MYTHIC, mage.cards.t.TriumphantReckoning.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Triumphant Reckoning", 628, Rarity.MYTHIC, mage.cards.t.TriumphantReckoning.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tromokratis", 408, Rarity.RARE, mage.cards.t.Tromokratis.class));
        cards.add(new SetCardInfo("Trove Tracker", 104, Rarity.COMMON, mage.cards.t.TroveTracker.class));
        cards.add(new SetCardInfo("Trusty Packbeast", 53, Rarity.COMMON, mage.cards.t.TrustyPackbeast.class));
        cards.add(new SetCardInfo("Tuya Bearclaw", 292, Rarity.UNCOMMON, mage.cards.t.TuyaBearclaw.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tuya Bearclaw", 612, Rarity.UNCOMMON, mage.cards.t.TuyaBearclaw.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tymna the Weaver", 539, Rarity.MYTHIC, mage.cards.t.TymnaTheWeaver.class));
        cards.add(new SetCardInfo("Unbreakable Formation", 388, Rarity.RARE, mage.cards.u.UnbreakableFormation.class));
        cards.add(new SetCardInfo("Undergrowth Stadium", 359, Rarity.RARE, mage.cards.u.UndergrowthStadium.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undergrowth Stadium", 714, Rarity.RARE, mage.cards.u.UndergrowthStadium.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Undying Rage", 205, Rarity.COMMON, mage.cards.u.UndyingRage.class));
        cards.add(new SetCardInfo("Universal Solvent", 347, Rarity.COMMON, mage.cards.u.UniversalSolvent.class));
        cards.add(new SetCardInfo("Unquestioned Authority", 389, Rarity.UNCOMMON, mage.cards.u.UnquestionedAuthority.class));
        cards.add(new SetCardInfo("Urban Evolution", 455, Rarity.UNCOMMON, mage.cards.u.UrbanEvolution.class));
        cards.add(new SetCardInfo("Valakut Invoker", 206, Rarity.COMMON, mage.cards.v.ValakutInvoker.class));
        cards.add(new SetCardInfo("Valorous Stance", 390, Rarity.UNCOMMON, mage.cards.v.ValorousStance.class));
        cards.add(new SetCardInfo("Vampiric Tutor", 156, Rarity.MYTHIC, mage.cards.v.VampiricTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vampiric Tutor", 656, Rarity.MYTHIC, mage.cards.v.VampiricTutor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vault of Champions", 360, Rarity.RARE, mage.cards.v.VaultOfChampions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vault of Champions", 715, Rarity.RARE, mage.cards.v.VaultOfChampions.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Verdant Sun's Avatar", 439, Rarity.RARE, mage.cards.v.VerdantSunsAvatar.class));
        cards.add(new SetCardInfo("Vial Smasher the Fierce", 540, Rarity.MYTHIC, mage.cards.v.VialSmasherTheFierce.class));
        cards.add(new SetCardInfo("Victimize", 157, Rarity.UNCOMMON, mage.cards.v.Victimize.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Victimize", 657, Rarity.UNCOMMON, mage.cards.v.Victimize.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Viscera Seer", 158, Rarity.COMMON, mage.cards.v.VisceraSeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Viscera Seer", 658, Rarity.COMMON, mage.cards.v.VisceraSeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Vivid Creek", 500, Rarity.UNCOMMON, mage.cards.v.VividCreek.class));
        cards.add(new SetCardInfo("Vivid Grove", 501, Rarity.UNCOMMON, mage.cards.v.VividGrove.class));
        cards.add(new SetCardInfo("Volcanic Dragon", 207, Rarity.UNCOMMON, mage.cards.v.VolcanicDragon.class));
        cards.add(new SetCardInfo("Volcanic Fallout", 418, Rarity.UNCOMMON, mage.cards.v.VolcanicFallout.class));
        cards.add(new SetCardInfo("Volcanic Torrent", 208, Rarity.UNCOMMON, mage.cards.v.VolcanicTorrent.class));
        cards.add(new SetCardInfo("Vow of Duty", 54, Rarity.UNCOMMON, mage.cards.v.VowOfDuty.class));
        cards.add(new SetCardInfo("Vow of Flight", 105, Rarity.UNCOMMON, mage.cards.v.VowOfFlight.class));
        cards.add(new SetCardInfo("Vow of Lightning", 209, Rarity.UNCOMMON, mage.cards.v.VowOfLightning.class));
        cards.add(new SetCardInfo("Vow of Torment", 159, Rarity.UNCOMMON, mage.cards.v.VowOfTorment.class));
        cards.add(new SetCardInfo("Vow of Wildness", 262, Rarity.UNCOMMON, mage.cards.v.VowOfWildness.class));
        cards.add(new SetCardInfo("War Room", 361, Rarity.RARE, mage.cards.w.WarRoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("War Room", 716, Rarity.RARE, mage.cards.w.WarRoom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Warden of Evos Isle", 106, Rarity.UNCOMMON, mage.cards.w.WardenOfEvosIsle.class));
        cards.add(new SetCardInfo("Wear // Tear", 456, Rarity.UNCOMMON, mage.cards.w.WearTear.class));
        cards.add(new SetCardInfo("Welding Sparks", 210, Rarity.COMMON, mage.cards.w.WeldingSparks.class));
        cards.add(new SetCardInfo("Wheel of Misfortune", 211, Rarity.RARE, mage.cards.w.WheelOfMisfortune.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wheel of Misfortune", 672, Rarity.RARE, mage.cards.w.WheelOfMisfortune.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Whelming Wave", 409, Rarity.RARE, mage.cards.w.WhelmingWave.class));
        cards.add(new SetCardInfo("White Sun's Zenith", 391, Rarity.RARE, mage.cards.w.WhiteSunsZenith.class));
        cards.add(new SetCardInfo("Wickerbough Elder", 440, Rarity.COMMON, mage.cards.w.WickerboughElder.class));
        cards.add(new SetCardInfo("Wild Celebrants", 212, Rarity.COMMON, mage.cards.w.WildCelebrants.class));
        cards.add(new SetCardInfo("Wild Ricochet", 419, Rarity.RARE, mage.cards.w.WildRicochet.class));
        cards.add(new SetCardInfo("Wildheart Invoker", 263, Rarity.COMMON, mage.cards.w.WildheartInvoker.class));
        cards.add(new SetCardInfo("Wildsize", 264, Rarity.COMMON, mage.cards.w.Wildsize.class));
        cards.add(new SetCardInfo("Wind-Scarred Crag", 502, Rarity.COMMON, mage.cards.w.WindScarredCrag.class));
        cards.add(new SetCardInfo("Winds of Rath", 392, Rarity.RARE, mage.cards.w.WindsOfRath.class));
        cards.add(new SetCardInfo("Woodland Stream", 503, Rarity.COMMON, mage.cards.w.WoodlandStream.class));
        cards.add(new SetCardInfo("Word of Seizing", 420, Rarity.RARE, mage.cards.w.WordOfSeizing.class));
        cards.add(new SetCardInfo("Workshop Assistant", 348, Rarity.COMMON, mage.cards.w.WorkshopAssistant.class));
        cards.add(new SetCardInfo("Wrong Turn", 107, Rarity.RARE, mage.cards.w.WrongTurn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wrong Turn", 644, Rarity.RARE, mage.cards.w.WrongTurn.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wyleth, Soul of Steel", 362, Rarity.MYTHIC, mage.cards.w.WylethSoulOfSteel.class));
        cards.add(new SetCardInfo("Xenagos, God of Revels", 541, Rarity.MYTHIC, mage.cards.x.XenagosGodOfRevels.class));
        cards.add(new SetCardInfo("Yavimaya Elder", 441, Rarity.COMMON, mage.cards.y.YavimayaElder.class));
        cards.add(new SetCardInfo("Yuriko, the Tiger's Shadow", 542, Rarity.MYTHIC, mage.cards.y.YurikoTheTigersShadow.class));
        cards.add(new SetCardInfo("Yurlok of Scorch Thrash", 293, Rarity.RARE, mage.cards.y.YurlokOfScorchThrash.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yurlok of Scorch Thrash", 613, Rarity.RARE, mage.cards.y.YurlokOfScorchThrash.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zara, Renegade Recruiter", 294, Rarity.RARE, mage.cards.z.ZaraRenegadeRecruiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zara, Renegade Recruiter", 614, Rarity.RARE, mage.cards.z.ZaraRenegadeRecruiter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zedruu the Greathearted", 543, Rarity.MYTHIC, mage.cards.z.ZedruuTheGreathearted.class));
        cards.add(new SetCardInfo("Zur the Enchanter", 544, Rarity.MYTHIC, mage.cards.z.ZurTheEnchanter.class));
    }
}
