package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * @author TheElk801
 */
public final class Commander2021Edition extends ExpansionSet {

    private static final Commander2021Edition instance = new Commander2021Edition();

    public static Commander2021Edition getInstance() {
        return instance;
    }

    private Commander2021Edition() {
        super("Commander 2021 Edition", "C21", ExpansionSet.buildDate(2021, 4, 23), SetType.SUPPLEMENTAL);
        this.blockName = "Command Zone";
        this.hasBasicLands = false;

        cards.add(new SetCardInfo("Adrix and Nev, Twincasters", 336, Rarity.MYTHIC, mage.cards.a.AdrixAndNevTwincasters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Adrix and Nev, Twincasters", 9, Rarity.MYTHIC, mage.cards.a.AdrixAndNevTwincasters.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Aether Gale", 113, Rarity.RARE, mage.cards.a.AetherGale.class));
        cards.add(new SetCardInfo("Aetherspouts", 114, Rarity.RARE, mage.cards.a.Aetherspouts.class));
        cards.add(new SetCardInfo("Ageless Entity", 184, Rarity.RARE, mage.cards.a.AgelessEntity.class));
        cards.add(new SetCardInfo("Alhammarret's Archive", 233, Rarity.MYTHIC, mage.cards.a.AlhammarretsArchive.class));
        cards.add(new SetCardInfo("Alibou, Ancient Witness", 334, Rarity.MYTHIC, mage.cards.a.AlibouAncientWitness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Alibou, Ancient Witness", 7, Rarity.MYTHIC, mage.cards.a.AlibouAncientWitness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ambition's Cost", 134, Rarity.UNCOMMON, mage.cards.a.AmbitionsCost.class));
        cards.add(new SetCardInfo("Ancient Craving", 135, Rarity.UNCOMMON, mage.cards.a.AncientCraving.class));
        cards.add(new SetCardInfo("Ancient Den", 276, Rarity.COMMON, mage.cards.a.AncientDen.class));
        cards.add(new SetCardInfo("Angel of Serenity", 83, Rarity.MYTHIC, mage.cards.a.AngelOfSerenity.class));
        cards.add(new SetCardInfo("Angel of the Ruins", 11, Rarity.RARE, mage.cards.a.AngelOfTheRuins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Angel of the Ruins", 338, Rarity.RARE, mage.cards.a.AngelOfTheRuins.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Apex of Power", 158, Rarity.MYTHIC, mage.cards.a.ApexOfPower.class));
        cards.add(new SetCardInfo("Arashi, the Sky Asunder", 185, Rarity.RARE, mage.cards.a.ArashiTheSkyAsunder.class));
        cards.add(new SetCardInfo("Arcane Signet", 234, Rarity.COMMON, mage.cards.a.ArcaneSignet.class));
        cards.add(new SetCardInfo("Archaeomancer's Map", 12, Rarity.RARE, mage.cards.a.ArchaeomancersMap.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Archaeomancer's Map", 339, Rarity.RARE, mage.cards.a.ArchaeomancersMap.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Audacious Reshapers", 374, Rarity.RARE, mage.cards.a.AudaciousReshapers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Audacious Reshapers", 47, Rarity.RARE, mage.cards.a.AudaciousReshapers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Author of Shadows", 35, Rarity.RARE, mage.cards.a.AuthorOfShadows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Author of Shadows", 362, Rarity.RARE, mage.cards.a.AuthorOfShadows.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Barren Moor", 277, Rarity.UNCOMMON, mage.cards.b.BarrenMoor.class));
        cards.add(new SetCardInfo("Battlefield Forge", 278, Rarity.RARE, mage.cards.b.BattlefieldForge.class));
        cards.add(new SetCardInfo("Battlemage's Bracers", 375, Rarity.RARE, mage.cards.b.BattlemagesBracers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Battlemage's Bracers", 48, Rarity.RARE, mage.cards.b.BattlemagesBracers.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Beast Within", 186, Rarity.UNCOMMON, mage.cards.b.BeastWithin.class));
        cards.add(new SetCardInfo("Biomass Mutation", 209, Rarity.RARE, mage.cards.b.BiomassMutation.class));
        cards.add(new SetCardInfo("Blasphemous Act", 159, Rarity.RARE, mage.cards.b.BlasphemousAct.class));
        cards.add(new SetCardInfo("Blight Mound", 36, Rarity.RARE, mage.cards.b.BlightMound.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blight Mound", 363, Rarity.RARE, mage.cards.b.BlightMound.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blighted Cataract", 279, Rarity.UNCOMMON, mage.cards.b.BlightedCataract.class));
        cards.add(new SetCardInfo("Blighted Woodland", 280, Rarity.UNCOMMON, mage.cards.b.BlightedWoodland.class));
        cards.add(new SetCardInfo("Bloodthirsty Aerialist", 136, Rarity.UNCOMMON, mage.cards.b.BloodthirstyAerialist.class));
        cards.add(new SetCardInfo("Bloodthirsty Blade", 235, Rarity.UNCOMMON, mage.cards.b.BloodthirstyBlade.class));
        cards.add(new SetCardInfo("Bloodtracker", 137, Rarity.RARE, mage.cards.b.Bloodtracker.class));
        cards.add(new SetCardInfo("Blossoming Bogbeast", 386, Rarity.RARE, mage.cards.b.BlossomingBogbeast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Blossoming Bogbeast", 59, Rarity.RARE, mage.cards.b.BlossomingBogbeast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bojuka Bog", 281, Rarity.COMMON, mage.cards.b.BojukaBog.class));
        cards.add(new SetCardInfo("Bold Plagiarist", 364, Rarity.RARE, mage.cards.b.BoldPlagiarist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bold Plagiarist", 37, Rarity.RARE, mage.cards.b.BoldPlagiarist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Boreas Charger", 84, Rarity.RARE, mage.cards.b.BoreasCharger.class));
        cards.add(new SetCardInfo("Boros Charm", 210, Rarity.UNCOMMON, mage.cards.b.BorosCharm.class));
        cards.add(new SetCardInfo("Boros Garrison", 282, Rarity.UNCOMMON, mage.cards.b.BorosGarrison.class));
        cards.add(new SetCardInfo("Boros Locket", 236, Rarity.COMMON, mage.cards.b.BorosLocket.class));
        cards.add(new SetCardInfo("Bosh, Iron Golem", 237, Rarity.RARE, mage.cards.b.BoshIronGolem.class));
        cards.add(new SetCardInfo("Brainstorm", 115, Rarity.COMMON, mage.cards.b.Brainstorm.class));
        cards.add(new SetCardInfo("Brass's Bounty", 160, Rarity.RARE, mage.cards.b.BrasssBounty.class));
        cards.add(new SetCardInfo("Breena, the Demagogue", 1, Rarity.MYTHIC, mage.cards.b.BreenaTheDemagogue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Breena, the Demagogue", 328, Rarity.MYTHIC, mage.cards.b.BreenaTheDemagogue.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bronze Guardian", 13, Rarity.RARE, mage.cards.b.BronzeGuardian.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Bronze Guardian", 340, Rarity.RARE, mage.cards.b.BronzeGuardian.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Burnished Hart", 238, Rarity.UNCOMMON, mage.cards.b.BurnishedHart.class));
        cards.add(new SetCardInfo("Call the Skybreaker", 211, Rarity.RARE, mage.cards.c.CallTheSkybreaker.class));
        cards.add(new SetCardInfo("Caves of Koilos", 283, Rarity.RARE, mage.cards.c.CavesOfKoilos.class));
        cards.add(new SetCardInfo("Chain Reaction", 161, Rarity.RARE, mage.cards.c.ChainReaction.class));
        cards.add(new SetCardInfo("Champion of Wits", 116, Rarity.RARE, mage.cards.c.ChampionOfWits.class));
        cards.add(new SetCardInfo("Charmbreaker Devils", 162, Rarity.RARE, mage.cards.c.CharmbreakerDevils.class));
        cards.add(new SetCardInfo("Citadel Siege", 85, Rarity.RARE, mage.cards.c.CitadelSiege.class));
        cards.add(new SetCardInfo("Cleansing Nova", 86, Rarity.RARE, mage.cards.c.CleansingNova.class));
        cards.add(new SetCardInfo("Coiling Oracle", 212, Rarity.COMMON, mage.cards.c.CoilingOracle.class));
        cards.add(new SetCardInfo("Combat Calligrapher", 14, Rarity.RARE, mage.cards.c.CombatCalligrapher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Combat Calligrapher", 341, Rarity.RARE, mage.cards.c.CombatCalligrapher.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Combustible Gearhulk", 163, Rarity.MYTHIC, mage.cards.c.CombustibleGearhulk.class));
        cards.add(new SetCardInfo("Command Tower", 284, Rarity.COMMON, mage.cards.c.CommandTower.class));
        cards.add(new SetCardInfo("Commander's Insight", 23, Rarity.RARE, mage.cards.c.CommandersInsight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commander's Insight", 350, Rarity.RARE, mage.cards.c.CommandersInsight.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Commander's Sphere", 239, Rarity.COMMON, mage.cards.c.CommandersSphere.class));
        cards.add(new SetCardInfo("Coveted Jewel", 240, Rarity.RARE, mage.cards.c.CovetedJewel.class));
        cards.add(new SetCardInfo("Crackling Drake", 213, Rarity.UNCOMMON, mage.cards.c.CracklingDrake.class));
        cards.add(new SetCardInfo("Crafty Cutpurse", 117, Rarity.RARE, mage.cards.c.CraftyCutpurse.class));
        cards.add(new SetCardInfo("Creative Technique", 376, Rarity.RARE, mage.cards.c.CreativeTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Creative Technique", 49, Rarity.RARE, mage.cards.c.CreativeTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cultivate", 187, Rarity.UNCOMMON, mage.cards.c.Cultivate.class));
        cards.add(new SetCardInfo("Cunning Rhetoric", 365, Rarity.RARE, mage.cards.c.CunningRhetoric.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cunning Rhetoric", 38, Rarity.RARE, mage.cards.c.CunningRhetoric.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Curiosity Crafter", 24, Rarity.RARE, mage.cards.c.CuriosityCrafter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Curiosity Crafter", 351, Rarity.RARE, mage.cards.c.CuriosityCrafter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Curse of Disturbance", 138, Rarity.UNCOMMON, mage.cards.c.CurseOfDisturbance.class));
        cards.add(new SetCardInfo("Curse of the Swine", 118, Rarity.RARE, mage.cards.c.CurseOfTheSwine.class));
        cards.add(new SetCardInfo("Cursed Mirror", 377, Rarity.RARE, mage.cards.c.CursedMirror.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Cursed Mirror", 50, Rarity.RARE, mage.cards.c.CursedMirror.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Damnable Pact", 139, Rarity.RARE, mage.cards.d.DamnablePact.class));
        cards.add(new SetCardInfo("Daretti, Scrap Savant", 164, Rarity.MYTHIC, mage.cards.d.DarettiScrapSavant.class));
        cards.add(new SetCardInfo("Darksteel Citadel", 285, Rarity.UNCOMMON, mage.cards.d.DarksteelCitadel.class));
        cards.add(new SetCardInfo("Darksteel Mutation", 87, Rarity.UNCOMMON, mage.cards.d.DarksteelMutation.class));
        cards.add(new SetCardInfo("Dazzling Sphinx", 25, Rarity.RARE, mage.cards.d.DazzlingSphinx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Dazzling Sphinx", 352, Rarity.RARE, mage.cards.d.DazzlingSphinx.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deadly Tempest", 140, Rarity.RARE, mage.cards.d.DeadlyTempest.class));
        cards.add(new SetCardInfo("Deathbringer Liege", 214, Rarity.RARE, mage.cards.d.DeathbringerLiege.class));
        cards.add(new SetCardInfo("Deathbringer Regent", 141, Rarity.RARE, mage.cards.d.DeathbringerRegent.class));
        cards.add(new SetCardInfo("Debtors' Knell", 215, Rarity.RARE, mage.cards.d.DebtorsKnell.class));
        cards.add(new SetCardInfo("Deekah, Fractal Theorist", 26, Rarity.RARE, mage.cards.d.DeekahFractalTheorist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Deekah, Fractal Theorist", 353, Rarity.RARE, mage.cards.d.DeekahFractalTheorist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Defiant Bloodlord", 142, Rarity.RARE, mage.cards.d.DefiantBloodlord.class));
        cards.add(new SetCardInfo("Desert of the Fervent", 286, Rarity.COMMON, mage.cards.d.DesertOfTheFervent.class));
        cards.add(new SetCardInfo("Desert of the Mindful", 287, Rarity.COMMON, mage.cards.d.DesertOfTheMindful.class));
        cards.add(new SetCardInfo("Desolation Twin", 82, Rarity.RARE, mage.cards.d.DesolationTwin.class));
        cards.add(new SetCardInfo("Dig Through Time", 119, Rarity.RARE, mage.cards.d.DigThroughTime.class));
        cards.add(new SetCardInfo("Digsite Engineer", 15, Rarity.RARE, mage.cards.d.DigsiteEngineer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Digsite Engineer", 342, Rarity.RARE, mage.cards.d.DigsiteEngineer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Diluvian Primordial", 120, Rarity.RARE, mage.cards.d.DiluvianPrimordial.class));
        cards.add(new SetCardInfo("Dispatch", 88, Rarity.UNCOMMON, mage.cards.d.Dispatch.class));
        cards.add(new SetCardInfo("Dispeller's Capsule", 89, Rarity.COMMON, mage.cards.d.DispellersCapsule.class));
        cards.add(new SetCardInfo("Druidic Satchel", 241, Rarity.RARE, mage.cards.d.DruidicSatchel.class));
        cards.add(new SetCardInfo("Dualcaster Mage", 165, Rarity.RARE, mage.cards.d.DualcasterMage.class));
        cards.add(new SetCardInfo("Duelist's Heritage", 90, Rarity.RARE, mage.cards.d.DuelistsHeritage.class));
        cards.add(new SetCardInfo("Duplicant", 242, Rarity.RARE, mage.cards.d.Duplicant.class));
        cards.add(new SetCardInfo("Elementalist's Palette", 403, Rarity.RARE, mage.cards.e.ElementalistsPalette.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elementalist's Palette", 76, Rarity.RARE, mage.cards.e.ElementalistsPalette.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Elite Scaleguard", 91, Rarity.UNCOMMON, mage.cards.e.EliteScaleguard.class));
        cards.add(new SetCardInfo("Elixir of Immortality", 243, Rarity.UNCOMMON, mage.cards.e.ElixirOfImmortality.class));
        cards.add(new SetCardInfo("Epic Experiment", 216, Rarity.MYTHIC, mage.cards.e.EpicExperiment.class));
        cards.add(new SetCardInfo("Epicure of Blood", 143, Rarity.COMMON, mage.cards.e.EpicureOfBlood.class));
        cards.add(new SetCardInfo("Erratic Cyclops", 166, Rarity.RARE, mage.cards.e.ErraticCyclops.class));
        cards.add(new SetCardInfo("Esix, Fractal Bloom", 10, Rarity.MYTHIC, mage.cards.e.EsixFractalBloom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Esix, Fractal Bloom", 337, Rarity.MYTHIC, mage.cards.e.EsixFractalBloom.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Essence Pulse", 366, Rarity.RARE, mage.cards.e.EssencePulse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Essence Pulse", 39, Rarity.RARE, mage.cards.e.EssencePulse.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Etali, Primal Storm", 167, Rarity.RARE, mage.cards.e.EtaliPrimalStorm.class));
        cards.add(new SetCardInfo("Excavation Technique", 16, Rarity.RARE, mage.cards.e.ExcavationTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Excavation Technique", 343, Rarity.RARE, mage.cards.e.ExcavationTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Exotic Orchard", 288, Rarity.RARE, mage.cards.e.ExoticOrchard.class));
        cards.add(new SetCardInfo("Ezuri's Predation", 188, Rarity.RARE, mage.cards.e.EzurisPredation.class));
        cards.add(new SetCardInfo("Ezzaroot Channeler", 387, Rarity.RARE, mage.cards.e.EzzarootChanneler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ezzaroot Channeler", 60, Rarity.RARE, mage.cards.e.EzzarootChanneler.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fain, the Broker", 367, Rarity.RARE, mage.cards.f.FainTheBroker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fain, the Broker", 40, Rarity.RARE, mage.cards.f.FainTheBroker.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Faithless Looting", 168, Rarity.COMMON, mage.cards.f.FaithlessLooting.class));
        cards.add(new SetCardInfo("Feed the Swarm", 144, Rarity.COMMON, mage.cards.f.FeedTheSwarm.class));
        cards.add(new SetCardInfo("Feldon of the Third Path", 169, Rarity.MYTHIC, mage.cards.f.FeldonOfTheThirdPath.class));
        cards.add(new SetCardInfo("Felisa, Fang of Silverquill", 2, Rarity.MYTHIC, mage.cards.f.FelisaFangOfSilverquill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Felisa, Fang of Silverquill", 329, Rarity.MYTHIC, mage.cards.f.FelisaFangOfSilverquill.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Encore", 378, Rarity.RARE, mage.cards.f.FieryEncore.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Encore", 51, Rarity.RARE, mage.cards.f.FieryEncore.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fiery Fall", 170, Rarity.COMMON, mage.cards.f.FieryFall.class));
        cards.add(new SetCardInfo("Forgotten Ancient", 189, Rarity.RARE, mage.cards.f.ForgottenAncient.class));
        cards.add(new SetCardInfo("Forgotten Cave", 289, Rarity.COMMON, mage.cards.f.ForgottenCave.class));
        cards.add(new SetCardInfo("Fractal Harness", 388, Rarity.RARE, mage.cards.f.FractalHarness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Fractal Harness", 61, Rarity.RARE, mage.cards.f.FractalHarness.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Garruk, Primal Hunter", 190, Rarity.MYTHIC, mage.cards.g.GarrukPrimalHunter.class));
        cards.add(new SetCardInfo("Gaze of Granite", 217, Rarity.RARE, mage.cards.g.GazeOfGranite.class));
        cards.add(new SetCardInfo("Geometric Nexus", 404, Rarity.RARE, mage.cards.g.GeometricNexus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Geometric Nexus", 77, Rarity.RARE, mage.cards.g.GeometricNexus.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ghostly Prison", 92, Rarity.UNCOMMON, mage.cards.g.GhostlyPrison.class));
        cards.add(new SetCardInfo("Gideon, Champion of Justice", 93, Rarity.MYTHIC, mage.cards.g.GideonChampionOfJustice.class));
        cards.add(new SetCardInfo("Gift of Paradise", 191, Rarity.COMMON, mage.cards.g.GiftOfParadise.class));
        cards.add(new SetCardInfo("Gingerbread Cabin", 290, Rarity.COMMON, mage.cards.g.GingerbreadCabin.class));
        cards.add(new SetCardInfo("Gluttonous Troll", 218, Rarity.RARE, mage.cards.g.GluttonousTroll.class));
        cards.add(new SetCardInfo("Golgari Rot Farm", 291, Rarity.UNCOMMON, mage.cards.g.GolgariRotFarm.class));
        cards.add(new SetCardInfo("Great Furnace", 292, Rarity.COMMON, mage.cards.g.GreatFurnace.class));
        cards.add(new SetCardInfo("Greed", 145, Rarity.UNCOMMON, mage.cards.g.Greed.class));
        cards.add(new SetCardInfo("Guardian Archon", 17, Rarity.RARE, mage.cards.g.GuardianArchon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guardian Archon", 344, Rarity.RARE, mage.cards.g.GuardianArchon.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guardian Augmenter", 389, Rarity.RARE, mage.cards.g.GuardianAugmenter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Guardian Augmenter", 62, Rarity.RARE, mage.cards.g.GuardianAugmenter.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gyome, Master Chef", 332, Rarity.MYTHIC, mage.cards.g.GyomeMasterChef.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Gyome, Master Chef", 5, Rarity.MYTHIC, mage.cards.g.GyomeMasterChef.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Healing Technique", 390, Rarity.RARE, mage.cards.h.HealingTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Healing Technique", 63, Rarity.RARE, mage.cards.h.HealingTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Hedron Archive", 244, Rarity.UNCOMMON, mage.cards.h.HedronArchive.class));
        cards.add(new SetCardInfo("Hellkite Igniter", 171, Rarity.RARE, mage.cards.h.HellkiteIgniter.class));
        cards.add(new SetCardInfo("Hellkite Tyrant", 172, Rarity.MYTHIC, mage.cards.h.HellkiteTyrant.class));
        cards.add(new SetCardInfo("High Market", 293, Rarity.RARE, mage.cards.h.HighMarket.class));
        cards.add(new SetCardInfo("Hoard-Smelter Dragon", 173, Rarity.RARE, mage.cards.h.HoardSmelterDragon.class));
        cards.add(new SetCardInfo("Hornet Nest", 192, Rarity.RARE, mage.cards.h.HornetNest.class));
        cards.add(new SetCardInfo("Hornet Queen", 193, Rarity.RARE, mage.cards.h.HornetQueen.class));
        cards.add(new SetCardInfo("Humble Defector", 174, Rarity.UNCOMMON, mage.cards.h.HumbleDefector.class));
        cards.add(new SetCardInfo("Hunted Lammasu", 94, Rarity.RARE, mage.cards.h.HuntedLammasu.class));
        cards.add(new SetCardInfo("Hydra Broodmaster", 194, Rarity.RARE, mage.cards.h.HydraBroodmaster.class));
        cards.add(new SetCardInfo("Ichor Wellspring", 245, Rarity.COMMON, mage.cards.i.IchorWellspring.class));
        cards.add(new SetCardInfo("Idol of Oblivion", 246, Rarity.RARE, mage.cards.i.IdolOfOblivion.class));
        cards.add(new SetCardInfo("Incarnation Technique", 368, Rarity.RARE, mage.cards.i.IncarnationTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Incarnation Technique", 41, Rarity.RARE, mage.cards.i.IncarnationTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Incubation // Incongruity", 219, Rarity.UNCOMMON, mage.cards.i.IncubationIncongruity.class));
        cards.add(new SetCardInfo("Incubation Druid", 195, Rarity.RARE, mage.cards.i.IncubationDruid.class));
        cards.add(new SetCardInfo("Infernal Offering", 146, Rarity.RARE, mage.cards.i.InfernalOffering.class));
        cards.add(new SetCardInfo("Inferno Project", 379, Rarity.RARE, mage.cards.i.InfernoProject.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inferno Project", 52, Rarity.RARE, mage.cards.i.InfernoProject.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inkshield", 398, Rarity.RARE, mage.cards.i.Inkshield.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inkshield", 71, Rarity.RARE, mage.cards.i.Inkshield.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inspiring Refrain", 27, Rarity.RARE, mage.cards.i.InspiringRefrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Inspiring Refrain", 354, Rarity.RARE, mage.cards.i.InspiringRefrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Izzet Boilerworks", 294, Rarity.UNCOMMON, mage.cards.i.IzzetBoilerworks.class));
        cards.add(new SetCardInfo("Izzet Signet", 247, Rarity.COMMON, mage.cards.i.IzzetSignet.class));
        cards.add(new SetCardInfo("Jaya Ballard", 175, Rarity.MYTHIC, mage.cards.j.JayaBallard.class));
        cards.add(new SetCardInfo("Jor Kadeen, the Prevailer", 220, Rarity.RARE, mage.cards.j.JorKadeenThePrevailer.class));
        cards.add(new SetCardInfo("Jungle Hollow", 295, Rarity.COMMON, mage.cards.j.JungleHollow.class));
        cards.add(new SetCardInfo("Kaseto, Orochi Archmage", 221, Rarity.MYTHIC, mage.cards.k.KasetoOrochiArchmage.class));
        cards.add(new SetCardInfo("Kazandu Tuskcaller", 196, Rarity.RARE, mage.cards.k.KazanduTuskcaller.class));
        cards.add(new SetCardInfo("Keen Duelist", 369, Rarity.RARE, mage.cards.k.KeenDuelist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Keen Duelist", 42, Rarity.RARE, mage.cards.k.KeenDuelist.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Key to the City", 248, Rarity.RARE, mage.cards.k.KeyToTheCity.class));
        cards.add(new SetCardInfo("Knight of the White Orchid", 95, Rarity.RARE, mage.cards.k.KnightOfTheWhiteOrchid.class));
        cards.add(new SetCardInfo("Kodama's Reach", 197, Rarity.COMMON, mage.cards.k.KodamasReach.class));
        cards.add(new SetCardInfo("Krosan Grip", 198, Rarity.UNCOMMON, mage.cards.k.KrosanGrip.class));
        cards.add(new SetCardInfo("Laelia, the Blade Reforged", 53, Rarity.RARE, mage.cards.l.LaeliaTheBladeReforged.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Laelia, the Blade Reforged", 380, Rarity.RARE, mage.cards.l.LaeliaTheBladeReforged.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Leyline Prowler", 222, Rarity.UNCOMMON, mage.cards.l.LeylineProwler.class));
        cards.add(new SetCardInfo("Living Lore", 121, Rarity.UNCOMMON, mage.cards.l.LivingLore.class));
        cards.add(new SetCardInfo("Llanowar Reborn", 296, Rarity.UNCOMMON, mage.cards.l.LlanowarReborn.class));
        cards.add(new SetCardInfo("Llanowar Wastes", 297, Rarity.RARE, mage.cards.l.LlanowarWastes.class));
        cards.add(new SetCardInfo("Lonely Sandbar", 298, Rarity.UNCOMMON, mage.cards.l.LonelySandbar.class));
        cards.add(new SetCardInfo("Losheel, Clockwork Scholar", 18, Rarity.RARE, mage.cards.l.LosheelClockworkScholar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Losheel, Clockwork Scholar", 345, Rarity.RARE, mage.cards.l.LosheelClockworkScholar.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Loxodon Warhammer", 249, Rarity.RARE, mage.cards.l.LoxodonWarhammer.class));
        cards.add(new SetCardInfo("Lumbering Falls", 299, Rarity.RARE, mage.cards.l.LumberingFalls.class));
        cards.add(new SetCardInfo("Mage-Ring Network", 300, Rarity.UNCOMMON, mage.cards.m.MageRingNetwork.class));
        cards.add(new SetCardInfo("Magister of Worth", 223, Rarity.RARE, mage.cards.m.MagisterOfWorth.class));
        cards.add(new SetCardInfo("Mana Geyser", 176, Rarity.COMMON, mage.cards.m.ManaGeyser.class));
        cards.add(new SetCardInfo("Managorger Hydra", 199, Rarity.RARE, mage.cards.m.ManagorgerHydra.class));
        cards.add(new SetCardInfo("Marshland Bloodcaster", 370, Rarity.RARE, mage.cards.m.MarshlandBloodcaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Marshland Bloodcaster", 43, Rarity.RARE, mage.cards.m.MarshlandBloodcaster.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Martial Impetus", 96, Rarity.UNCOMMON, mage.cards.m.MartialImpetus.class));
        cards.add(new SetCardInfo("Master Biomancer", 224, Rarity.MYTHIC, mage.cards.m.MasterBiomancer.class));
        cards.add(new SetCardInfo("Memorial to Genius", 301, Rarity.UNCOMMON, mage.cards.m.MemorialToGenius.class));
        cards.add(new SetCardInfo("Metallurgic Summonings", 122, Rarity.MYTHIC, mage.cards.m.MetallurgicSummonings.class));
        cards.add(new SetCardInfo("Meteor Golem", 250, Rarity.UNCOMMON, mage.cards.m.MeteorGolem.class));
        cards.add(new SetCardInfo("Mikokoro, Center of the Sea", 302, Rarity.RARE, mage.cards.m.MikokoroCenterOfTheSea.class));
        cards.add(new SetCardInfo("Mind Stone", 251, Rarity.UNCOMMON, mage.cards.m.MindStone.class));
        cards.add(new SetCardInfo("Mind's Desire", 123, Rarity.RARE, mage.cards.m.MindsDesire.class));
        cards.add(new SetCardInfo("Moldervine Reclamation", 225, Rarity.UNCOMMON, mage.cards.m.MoldervineReclamation.class));
        cards.add(new SetCardInfo("Monologue Tax", 19, Rarity.RARE, mage.cards.m.MonologueTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Monologue Tax", 346, Rarity.RARE, mage.cards.m.MonologueTax.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mosswort Bridge", 303, Rarity.RARE, mage.cards.m.MosswortBridge.class));
        cards.add(new SetCardInfo("Muse Vortex", 28, Rarity.RARE, mage.cards.m.MuseVortex.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Muse Vortex", 355, Rarity.RARE, mage.cards.m.MuseVortex.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mycosynth Wellspring", 252, Rarity.COMMON, mage.cards.m.MycosynthWellspring.class));
        cards.add(new SetCardInfo("Myr Battlesphere", 253, Rarity.RARE, mage.cards.m.MyrBattlesphere.class));
        cards.add(new SetCardInfo("Myriad Landscape", 304, Rarity.UNCOMMON, mage.cards.m.MyriadLandscape.class));
        cards.add(new SetCardInfo("Naru Meha, Master Wizard", 124, Rarity.MYTHIC, mage.cards.n.NaruMehaMasterWizard.class));
        cards.add(new SetCardInfo("Necropolis Regent", 147, Rarity.MYTHIC, mage.cards.n.NecropolisRegent.class));
        cards.add(new SetCardInfo("Nils, Discipline Enforcer", 20, Rarity.RARE, mage.cards.n.NilsDisciplineEnforcer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nils, Discipline Enforcer", 347, Rarity.RARE, mage.cards.n.NilsDisciplineEnforcer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Nissa's Expedition", 200, Rarity.UNCOMMON, mage.cards.n.NissasExpedition.class));
        cards.add(new SetCardInfo("Nissa's Renewal", 201, Rarity.RARE, mage.cards.n.NissasRenewal.class));
        cards.add(new SetCardInfo("Novijen, Heart of Progress", 305, Rarity.UNCOMMON, mage.cards.n.NovijenHeartOfProgress.class));
        cards.add(new SetCardInfo("Noxious Gearhulk", 148, Rarity.MYTHIC, mage.cards.n.NoxiousGearhulk.class));
        cards.add(new SetCardInfo("Ob Nixilis Reignited", 149, Rarity.MYTHIC, mage.cards.o.ObNixilisReignited.class));
        cards.add(new SetCardInfo("Oblation", 97, Rarity.RARE, mage.cards.o.Oblation.class));
        cards.add(new SetCardInfo("Octavia, Living Thesis", 29, Rarity.RARE, mage.cards.o.OctaviaLivingThesis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Octavia, Living Thesis", 356, Rarity.RARE, mage.cards.o.OctaviaLivingThesis.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Opal Palace", 306, Rarity.COMMON, mage.cards.o.OpalPalace.class));
        cards.add(new SetCardInfo("Oran-Rief, the Vastwood", 307, Rarity.RARE, mage.cards.o.OranRiefTheVastwood.class));
        cards.add(new SetCardInfo("Oreskos Explorer", 98, Rarity.UNCOMMON, mage.cards.o.OreskosExplorer.class));
        cards.add(new SetCardInfo("Orzhov Advokist", 99, Rarity.UNCOMMON, mage.cards.o.OrzhovAdvokist.class));
        cards.add(new SetCardInfo("Orzhov Basilica", 308, Rarity.UNCOMMON, mage.cards.o.OrzhovBasilica.class));
        cards.add(new SetCardInfo("Orzhov Signet", 254, Rarity.UNCOMMON, mage.cards.o.OrzhovSignet.class));
        cards.add(new SetCardInfo("Osgir, the Reconstructor", 335, Rarity.MYTHIC, mage.cards.o.OsgirTheReconstructor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Osgir, the Reconstructor", 8, Rarity.MYTHIC, mage.cards.o.OsgirTheReconstructor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oversimplify", 399, Rarity.RARE, mage.cards.o.Oversimplify.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Oversimplify", 72, Rarity.RARE, mage.cards.o.Oversimplify.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Paradise Plume", 255, Rarity.UNCOMMON, mage.cards.p.ParadisePlume.class));
        cards.add(new SetCardInfo("Paradox Zone", 391, Rarity.RARE, mage.cards.p.ParadoxZone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Paradox Zone", 64, Rarity.RARE, mage.cards.p.ParadoxZone.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Parasitic Impetus", 150, Rarity.UNCOMMON, mage.cards.p.ParasiticImpetus.class));
        cards.add(new SetCardInfo("Pendant of Prosperity", 256, Rarity.RARE, mage.cards.p.PendantOfProsperity.class));
        cards.add(new SetCardInfo("Perplexing Test", 30, Rarity.RARE, mage.cards.p.PerplexingTest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Perplexing Test", 357, Rarity.RARE, mage.cards.p.PerplexingTest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pest Infestation", 392, Rarity.RARE, mage.cards.p.PestInfestation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pest Infestation", 65, Rarity.RARE, mage.cards.p.PestInfestation.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Phyrexia's Core", 309, Rarity.UNCOMMON, mage.cards.p.PhyrexiasCore.class));
        cards.add(new SetCardInfo("Pia Nalaar", 177, Rarity.RARE, mage.cards.p.PiaNalaar.class));
        cards.add(new SetCardInfo("Pilgrim's Eye", 257, Rarity.COMMON, mage.cards.p.PilgrimsEye.class));
        cards.add(new SetCardInfo("Plaxcaster Frogling", 226, Rarity.UNCOMMON, mage.cards.p.PlaxcasterFrogling.class));
        cards.add(new SetCardInfo("Ponder", 125, Rarity.COMMON, mage.cards.p.Ponder.class));
        cards.add(new SetCardInfo("Primal Empathy", 227, Rarity.UNCOMMON, mage.cards.p.PrimalEmpathy.class));
        cards.add(new SetCardInfo("Pristine Talisman", 258, Rarity.COMMON, mage.cards.p.PristineTalisman.class));
        cards.add(new SetCardInfo("Promise of Loyalty", 21, Rarity.RARE, mage.cards.p.PromiseOfLoyalty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Promise of Loyalty", 348, Rarity.RARE, mage.cards.p.PromiseOfLoyalty.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pulse of Murasa", 202, Rarity.UNCOMMON, mage.cards.p.PulseOfMurasa.class));
        cards.add(new SetCardInfo("Pyromancer's Goggles", 259, Rarity.MYTHIC, mage.cards.p.PyromancersGoggles.class));
        cards.add(new SetCardInfo("Quicksmith Genius", 178, Rarity.UNCOMMON, mage.cards.q.QuicksmithGenius.class));
        cards.add(new SetCardInfo("Radiant Fountain", 310, Rarity.COMMON, mage.cards.r.RadiantFountain.class));
        cards.add(new SetCardInfo("Radiant Performer", 381, Rarity.RARE, mage.cards.r.RadiantPerformer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Radiant Performer", 54, Rarity.RARE, mage.cards.r.RadiantPerformer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rampaging Baloths", 203, Rarity.RARE, mage.cards.r.RampagingBaloths.class));
        cards.add(new SetCardInfo("Rampant Growth", 204, Rarity.COMMON, mage.cards.r.RampantGrowth.class));
        cards.add(new SetCardInfo("Rapid Hybridization", 126, Rarity.UNCOMMON, mage.cards.r.RapidHybridization.class));
        cards.add(new SetCardInfo("Reckless Spite", 151, Rarity.UNCOMMON, mage.cards.r.RecklessSpite.class));
        cards.add(new SetCardInfo("Reef Worm", 127, Rarity.RARE, mage.cards.r.ReefWorm.class));
        cards.add(new SetCardInfo("Reinterpret", 400, Rarity.RARE, mage.cards.r.Reinterpret.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reinterpret", 73, Rarity.RARE, mage.cards.r.Reinterpret.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Reliquary Tower", 311, Rarity.UNCOMMON, mage.cards.r.ReliquaryTower.class));
        cards.add(new SetCardInfo("Replication Technique", 31, Rarity.RARE, mage.cards.r.ReplicationTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Replication Technique", 358, Rarity.RARE, mage.cards.r.ReplicationTechnique.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Return of the Wildspeaker", 205, Rarity.RARE, mage.cards.r.ReturnOfTheWildspeaker.class));
        cards.add(new SetCardInfo("Return to Dust", 100, Rarity.UNCOMMON, mage.cards.r.ReturnToDust.class));
        cards.add(new SetCardInfo("Revival Experiment", 401, Rarity.RARE, mage.cards.r.RevivalExperiment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Revival Experiment", 74, Rarity.RARE, mage.cards.r.RevivalExperiment.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rionya, Fire Dancer", 382, Rarity.RARE, mage.cards.r.RionyaFireDancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rionya, Fire Dancer", 55, Rarity.RARE, mage.cards.r.RionyaFireDancer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rite of Replication", 128, Rarity.RARE, mage.cards.r.RiteOfReplication.class));
        cards.add(new SetCardInfo("Rogue's Passage", 312, Rarity.UNCOMMON, mage.cards.r.RoguesPassage.class));
        cards.add(new SetCardInfo("Rousing Refrain", 383, Rarity.RARE, mage.cards.r.RousingRefrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rousing Refrain", 56, Rarity.RARE, mage.cards.r.RousingRefrain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Rout", 101, Rarity.RARE, mage.cards.r.Rout.class));
        cards.add(new SetCardInfo("Ruin Grinder", 384, Rarity.RARE, mage.cards.r.RuinGrinder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ruin Grinder", 57, Rarity.RARE, mage.cards.r.RuinGrinder.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ruxa, Patient Professor", 393, Rarity.RARE, mage.cards.r.RuxaPatientProfessor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ruxa, Patient Professor", 66, Rarity.RARE, mage.cards.r.RuxaPatientProfessor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sanctum Gargoyle", 102, Rarity.COMMON, mage.cards.s.SanctumGargoyle.class));
        cards.add(new SetCardInfo("Sangromancer", 152, Rarity.RARE, mage.cards.s.Sangromancer.class));
        cards.add(new SetCardInfo("Sanguine Bond", 153, Rarity.RARE, mage.cards.s.SanguineBond.class));
        cards.add(new SetCardInfo("Sapling of Colfenor", 228, Rarity.RARE, mage.cards.s.SaplingOfColfenor.class));
        cards.add(new SetCardInfo("Sapseep Forest", 313, Rarity.UNCOMMON, mage.cards.s.SapseepForest.class));
        cards.add(new SetCardInfo("Scavenger Grounds", 314, Rarity.RARE, mage.cards.s.ScavengerGrounds.class));
        cards.add(new SetCardInfo("Scholarship Sponsor", 22, Rarity.RARE, mage.cards.s.ScholarshipSponsor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scholarship Sponsor", 349, Rarity.RARE, mage.cards.s.ScholarshipSponsor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Scrap Trawler", 260, Rarity.RARE, mage.cards.s.ScrapTrawler.class));
        cards.add(new SetCardInfo("Sculpting Steel", 261, Rarity.RARE, mage.cards.s.SculptingSteel.class));
        cards.add(new SetCardInfo("Secluded Steppe", 315, Rarity.UNCOMMON, mage.cards.s.SecludedSteppe.class));
        cards.add(new SetCardInfo("Seething Song", 179, Rarity.COMMON, mage.cards.s.SeethingSong.class));
        cards.add(new SetCardInfo("Selfless Squire", 103, Rarity.RARE, mage.cards.s.SelflessSquire.class));
        cards.add(new SetCardInfo("Sequence Engine", 394, Rarity.RARE, mage.cards.s.SequenceEngine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sequence Engine", 67, Rarity.RARE, mage.cards.s.SequenceEngine.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Serum Visions", 129, Rarity.UNCOMMON, mage.cards.s.SerumVisions.class));
        cards.add(new SetCardInfo("Shamanic Revelation", 206, Rarity.RARE, mage.cards.s.ShamanicRevelation.class));
        cards.add(new SetCardInfo("Shivan Reef", 316, Rarity.RARE, mage.cards.s.ShivanReef.class));
        cards.add(new SetCardInfo("Silversmote Ghoul", 154, Rarity.UNCOMMON, mage.cards.s.SilversmoteGhoul.class));
        cards.add(new SetCardInfo("Simic Growth Chamber", 317, Rarity.UNCOMMON, mage.cards.s.SimicGrowthChamber.class));
        cards.add(new SetCardInfo("Simic Signet", 262, Rarity.COMMON, mage.cards.s.SimicSignet.class));
        cards.add(new SetCardInfo("Slayers' Stronghold", 318, Rarity.RARE, mage.cards.s.SlayersStronghold.class));
        cards.add(new SetCardInfo("Sly Instigator", 32, Rarity.RARE, mage.cards.s.SlyInstigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sly Instigator", 359, Rarity.RARE, mage.cards.s.SlyInstigator.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sol Ring", 263, Rarity.UNCOMMON, mage.cards.s.SolRing.class));
        cards.add(new SetCardInfo("Solemn Simulacrum", 264, Rarity.RARE, mage.cards.s.SolemnSimulacrum.class));
        cards.add(new SetCardInfo("Soul Snare", 104, Rarity.UNCOMMON, mage.cards.s.SoulSnare.class));
        cards.add(new SetCardInfo("Spawning Kraken", 33, Rarity.RARE, mage.cards.s.SpawningKraken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spawning Kraken", 360, Rarity.RARE, mage.cards.s.SpawningKraken.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Spectral Searchlight", 265, Rarity.UNCOMMON, mage.cards.s.SpectralSearchlight.class));
        cards.add(new SetCardInfo("Spitting Image", 229, Rarity.RARE, mage.cards.s.SpittingImage.class));
        cards.add(new SetCardInfo("Sproutback Trudge", 395, Rarity.RARE, mage.cards.s.SproutbackTrudge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sproutback Trudge", 68, Rarity.RARE, mage.cards.s.SproutbackTrudge.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stalking Leonin", 105, Rarity.RARE, mage.cards.s.StalkingLeonin.class));
        cards.add(new SetCardInfo("Steel Hellkite", 266, Rarity.RARE, mage.cards.s.SteelHellkite.class));
        cards.add(new SetCardInfo("Steel Overseer", 267, Rarity.RARE, mage.cards.s.SteelOverseer.class));
        cards.add(new SetCardInfo("Stinging Study", 371, Rarity.RARE, mage.cards.s.StingingStudy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Stinging Study", 44, Rarity.RARE, mage.cards.s.StingingStudy.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Study Hall", 80, Rarity.COMMON, mage.cards.s.StudyHall.class));
        cards.add(new SetCardInfo("Suffer the Past", 155, Rarity.UNCOMMON, mage.cards.s.SufferThePast.class));
        cards.add(new SetCardInfo("Sun Droplet", 268, Rarity.UNCOMMON, mage.cards.s.SunDroplet.class));
        cards.add(new SetCardInfo("Sun Titan", 106, Rarity.MYTHIC, mage.cards.s.SunTitan.class));
        cards.add(new SetCardInfo("Sunbird's Invocation", 180, Rarity.RARE, mage.cards.s.SunbirdsInvocation.class));
        cards.add(new SetCardInfo("Sunhome, Fortress of the Legion", 319, Rarity.UNCOMMON, mage.cards.s.SunhomeFortressOfTheLegion.class));
        cards.add(new SetCardInfo("Sunscorch Regent", 107, Rarity.RARE, mage.cards.s.SunscorchRegent.class));
        cards.add(new SetCardInfo("Surge to Victory", 385, Rarity.RARE, mage.cards.s.SurgeToVictory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Surge to Victory", 58, Rarity.RARE, mage.cards.s.SurgeToVictory.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swarm Intelligence", 130, Rarity.RARE, mage.cards.s.SwarmIntelligence.class));
        cards.add(new SetCardInfo("Tainted Field", 320, Rarity.UNCOMMON, mage.cards.t.TaintedField.class));
        cards.add(new SetCardInfo("Tainted Wood", 321, Rarity.UNCOMMON, mage.cards.t.TaintedWood.class));
        cards.add(new SetCardInfo("Talisman of Creativity", 269, Rarity.UNCOMMON, mage.cards.t.TalismanOfCreativity.class));
        cards.add(new SetCardInfo("Talisman of Resilience", 270, Rarity.UNCOMMON, mage.cards.t.TalismanOfResilience.class));
        cards.add(new SetCardInfo("Talrand, Sky Summoner", 131, Rarity.RARE, mage.cards.t.TalrandSkySummoner.class));
        cards.add(new SetCardInfo("Taste of Death", 156, Rarity.RARE, mage.cards.t.TasteOfDeath.class));
        cards.add(new SetCardInfo("Temple of Epiphany", 322, Rarity.RARE, mage.cards.t.TempleOfEpiphany.class));
        cards.add(new SetCardInfo("Temple of Malady", 323, Rarity.RARE, mage.cards.t.TempleOfMalady.class));
        cards.add(new SetCardInfo("Temple of Mystery", 324, Rarity.RARE, mage.cards.t.TempleOfMystery.class));
        cards.add(new SetCardInfo("Temple of Silence", 325, Rarity.RARE, mage.cards.t.TempleOfSilence.class));
        cards.add(new SetCardInfo("Temple of Triumph", 327, Rarity.RARE, mage.cards.t.TempleOfTriumph.class));
        cards.add(new SetCardInfo("Temple of the False God", 326, Rarity.UNCOMMON, mage.cards.t.TempleOfTheFalseGod.class));
        cards.add(new SetCardInfo("Tempting Contract", 405, Rarity.RARE, mage.cards.t.TemptingContract.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tempting Contract", 78, Rarity.RARE, mage.cards.t.TemptingContract.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Terastodon", 207, Rarity.RARE, mage.cards.t.Terastodon.class));
        cards.add(new SetCardInfo("Teysa, Envoy of Ghosts", 230, Rarity.RARE, mage.cards.t.TeysaEnvoyOfGhosts.class));
        cards.add(new SetCardInfo("Theoretical Duplication", 34, Rarity.RARE, mage.cards.t.TheoreticalDuplication.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Theoretical Duplication", 361, Rarity.RARE, mage.cards.t.TheoreticalDuplication.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Thopter Engineer", 181, Rarity.UNCOMMON, mage.cards.t.ThopterEngineer.class));
        cards.add(new SetCardInfo("Thousand-Year Elixir", 271, Rarity.RARE, mage.cards.t.ThousandYearElixir.class));
        cards.add(new SetCardInfo("Tivash, Gloom Summoner", 372, Rarity.RARE, mage.cards.t.TivashGloomSummoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Tivash, Gloom Summoner", 45, Rarity.RARE, mage.cards.t.TivashGloomSummoner.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Together Forever", 108, Rarity.RARE, mage.cards.t.TogetherForever.class));
        cards.add(new SetCardInfo("Tragic Arrogance", 109, Rarity.RARE, mage.cards.t.TragicArrogance.class));
        cards.add(new SetCardInfo("Tranquil Thicket", 408, Rarity.COMMON, mage.cards.t.TranquilThicket.class));
        cards.add(new SetCardInfo("Traumatic Visions", 132, Rarity.COMMON, mage.cards.t.TraumaticVisions.class));
        cards.add(new SetCardInfo("Treasure Cruise", 133, Rarity.COMMON, mage.cards.t.TreasureCruise.class));
        cards.add(new SetCardInfo("Triplicate Titan", 406, Rarity.RARE, mage.cards.t.TriplicateTitan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Triplicate Titan", 79, Rarity.RARE, mage.cards.t.TriplicateTitan.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trudge Garden", 396, Rarity.RARE, mage.cards.t.TrudgeGarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trudge Garden", 69, Rarity.RARE, mage.cards.t.TrudgeGarden.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Trygon Predator", 231, Rarity.UNCOMMON, mage.cards.t.TrygonPredator.class));
        cards.add(new SetCardInfo("Unstable Obelisk", 272, Rarity.UNCOMMON, mage.cards.u.UnstableObelisk.class));
        cards.add(new SetCardInfo("Utter End", 232, Rarity.RARE, mage.cards.u.UtterEnd.class));
        cards.add(new SetCardInfo("Vampire Nighthawk", 157, Rarity.UNCOMMON, mage.cards.v.VampireNighthawk.class));
        cards.add(new SetCardInfo("Veinwitch Coven", 373, Rarity.RARE, mage.cards.v.VeinwitchCoven.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Veinwitch Coven", 46, Rarity.RARE, mage.cards.v.VeinwitchCoven.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Venser's Journal", 273, Rarity.RARE, mage.cards.v.VensersJournal.class));
        cards.add(new SetCardInfo("Verdant Sun's Avatar", 208, Rarity.RARE, mage.cards.v.VerdantSunsAvatar.class));
        cards.add(new SetCardInfo("Veyran, Voice of Duality", 3, Rarity.MYTHIC, mage.cards.v.VeyranVoiceOfDuality.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Veyran, Voice of Duality", 330, Rarity.MYTHIC, mage.cards.v.VeyranVoiceOfDuality.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Victory Chimes", 274, Rarity.RARE, mage.cards.v.VictoryChimes.class));
        cards.add(new SetCardInfo("Volcanic Vision", 182, Rarity.RARE, mage.cards.v.VolcanicVision.class));
        cards.add(new SetCardInfo("Vow of Duty", 110, Rarity.UNCOMMON, mage.cards.v.VowOfDuty.class));
        cards.add(new SetCardInfo("Wake the Past", 402, Rarity.RARE, mage.cards.w.WakeThePast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Wake the Past", 75, Rarity.RARE, mage.cards.w.WakeThePast.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Well of Lost Dreams", 275, Rarity.RARE, mage.cards.w.WellOfLostDreams.class));
        cards.add(new SetCardInfo("Wildfire Devils", 183, Rarity.RARE, mage.cards.w.WildfireDevils.class));
        cards.add(new SetCardInfo("Willowdusk, Essence Seer", 333, Rarity.MYTHIC, mage.cards.w.WillowduskEssenceSeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Willowdusk, Essence Seer", 6, Rarity.MYTHIC, mage.cards.w.WillowduskEssenceSeer.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Windborn Muse", 111, Rarity.RARE, mage.cards.w.WindbornMuse.class));
        cards.add(new SetCardInfo("Witch's Clinic", 407, Rarity.RARE, mage.cards.w.WitchsClinic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Witch's Clinic", 81, Rarity.RARE, mage.cards.w.WitchsClinic.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yavimaya Coast", 409, Rarity.RARE, mage.cards.y.YavimayaCoast.class));
        cards.add(new SetCardInfo("Yedora, Grave Gardener", 397, Rarity.RARE, mage.cards.y.YedoraGraveGardener.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Yedora, Grave Gardener", 70, Rarity.RARE, mage.cards.y.YedoraGraveGardener.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zaffai, Thunder Conductor", 331, Rarity.MYTHIC, mage.cards.z.ZaffaiThunderConductor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zaffai, Thunder Conductor", 4, Rarity.MYTHIC, mage.cards.z.ZaffaiThunderConductor.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Zetalpa, Primal Dawn", 112, Rarity.RARE, mage.cards.z.ZetalpaPrimalDawn.class));
    }
}
