package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

/**
 * https://scryfall.com/sets/akr
 */
public class AmonkhetRemastered extends ExpansionSet {

    private static final AmonkhetRemastered instance = new AmonkhetRemastered();

    public static AmonkhetRemastered getInstance() {
        return instance;
    }

    private AmonkhetRemastered() {
        super("Amonkhet Remastered", "AKR", ExpansionSet.buildDate(2020, 8, 13), SetType.MAGIC_ARENA);
        this.hasBoosters = true;
        this.hasBasicLands = true;
        this.maxCardNumberInBooster = 338; // Regal Caracal is top-boxer, not in booster
        this.numBoosterLands = 1;
        this.numBoosterCommon = 10;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 8;

        cards.add(new SetCardInfo("Abandoned Sarcophagus", 268, Rarity.RARE, mage.cards.a.AbandonedSarcophagus.class));
        cards.add(new SetCardInfo("Abrade", 136, Rarity.UNCOMMON, mage.cards.a.Abrade.class));
        cards.add(new SetCardInfo("Aerial Guide", 47, Rarity.COMMON, mage.cards.a.AerialGuide.class));
        cards.add(new SetCardInfo("Ahn-Crop Champion", 226, Rarity.UNCOMMON, mage.cards.a.AhnCropChampion.class));
        cards.add(new SetCardInfo("Ahn-Crop Crasher", 137, Rarity.UNCOMMON, mage.cards.a.AhnCropCrasher.class));
        cards.add(new SetCardInfo("Ancient Crab", 48, Rarity.COMMON, mage.cards.a.AncientCrab.class));
        cards.add(new SetCardInfo("Angel of Sanctions", 1, Rarity.MYTHIC, mage.cards.a.AngelOfSanctions.class));
        cards.add(new SetCardInfo("Anger of the Gods", 138, Rarity.RARE, mage.cards.a.AngerOfTheGods.class));
        cards.add(new SetCardInfo("Anointed Procession", 2, Rarity.RARE, mage.cards.a.AnointedProcession.class));
        cards.add(new SetCardInfo("Anointer Priest", 3, Rarity.COMMON, mage.cards.a.AnointerPriest.class));
        cards.add(new SetCardInfo("Appeal // Authority", 227, Rarity.UNCOMMON, mage.cards.a.AppealAuthority.class));
        cards.add(new SetCardInfo("Approach of the Second Sun", 4, Rarity.RARE, mage.cards.a.ApproachOfTheSecondSun.class));
        cards.add(new SetCardInfo("Archfiend of Ifnir", 91, Rarity.RARE, mage.cards.a.ArchfiendOfIfnir.class));
        cards.add(new SetCardInfo("As Foretold", 49, Rarity.MYTHIC, mage.cards.a.AsForetold.class));
        cards.add(new SetCardInfo("Aven Initiate", 50, Rarity.COMMON, mage.cards.a.AvenInitiate.class));
        cards.add(new SetCardInfo("Aven Mindcensor", 5, Rarity.RARE, mage.cards.a.AvenMindcensor.class));
        cards.add(new SetCardInfo("Aven of Enduring Hope", 6, Rarity.COMMON, mage.cards.a.AvenOfEnduringHope.class));
        cards.add(new SetCardInfo("Aven Wind Guide", 228, Rarity.UNCOMMON, mage.cards.a.AvenWindGuide.class));
        cards.add(new SetCardInfo("Baleful Ammit", 92, Rarity.UNCOMMON, mage.cards.b.BalefulAmmit.class));
        cards.add(new SetCardInfo("Battlefield Scavenger", 139, Rarity.UNCOMMON, mage.cards.b.BattlefieldScavenger.class));
        cards.add(new SetCardInfo("Beneath the Sands", 182, Rarity.COMMON, mage.cards.b.BeneathTheSands.class));
        cards.add(new SetCardInfo("Binding Mummy", 7, Rarity.COMMON, mage.cards.b.BindingMummy.class));
        cards.add(new SetCardInfo("Bitterbow Sharpshooters", 183, Rarity.COMMON, mage.cards.b.BitterbowSharpshooters.class));
        cards.add(new SetCardInfo("Blighted Bat", 93, Rarity.COMMON, mage.cards.b.BlightedBat.class));
        cards.add(new SetCardInfo("Bloodlust Inciter", 140, Rarity.COMMON, mage.cards.b.BloodlustInciter.class));
        cards.add(new SetCardInfo("Blur of Blades", 141, Rarity.COMMON, mage.cards.b.BlurOfBlades.class));
        cards.add(new SetCardInfo("Bone Picker", 94, Rarity.UNCOMMON, mage.cards.b.BonePicker.class));
        cards.add(new SetCardInfo("Bontu the Glorified", 95, Rarity.MYTHIC, mage.cards.b.BontuTheGlorified.class));
        cards.add(new SetCardInfo("Bontu's Last Reckoning", 96, Rarity.RARE, mage.cards.b.BontusLastReckoning.class));
        cards.add(new SetCardInfo("Bontu's Monument", 269, Rarity.UNCOMMON, mage.cards.b.BontusMonument.class));
        cards.add(new SetCardInfo("Brute Strength", 142, Rarity.COMMON, mage.cards.b.BruteStrength.class));
        cards.add(new SetCardInfo("Burning-Fist Minotaur", 143, Rarity.UNCOMMON, mage.cards.b.BurningFistMinotaur.class));
        cards.add(new SetCardInfo("By Force", 144, Rarity.UNCOMMON, mage.cards.b.ByForce.class));
        cards.add(new SetCardInfo("Canyon Slough", 284, Rarity.RARE, mage.cards.c.CanyonSlough.class));
        cards.add(new SetCardInfo("Cartouche of Ambition", 97, Rarity.COMMON, mage.cards.c.CartoucheOfAmbition.class));
        cards.add(new SetCardInfo("Cartouche of Knowledge", 51, Rarity.COMMON, mage.cards.c.CartoucheOfKnowledge.class));
        cards.add(new SetCardInfo("Cartouche of Solidarity", 8, Rarity.COMMON, mage.cards.c.CartoucheOfSolidarity.class));
        cards.add(new SetCardInfo("Cartouche of Strength", 184, Rarity.COMMON, mage.cards.c.CartoucheOfStrength.class));
        cards.add(new SetCardInfo("Cartouche of Zeal", 145, Rarity.COMMON, mage.cards.c.CartoucheOfZeal.class));
        cards.add(new SetCardInfo("Cascading Cataracts", 285, Rarity.RARE, mage.cards.c.CascadingCataracts.class));
        cards.add(new SetCardInfo("Cast Out", 9, Rarity.UNCOMMON, mage.cards.c.CastOut.class));
        cards.add(new SetCardInfo("Censor", 52, Rarity.UNCOMMON, mage.cards.c.Censor.class));
        cards.add(new SetCardInfo("Champion of Rhonas", 185, Rarity.RARE, mage.cards.c.ChampionOfRhonas.class));
        cards.add(new SetCardInfo("Champion of Wits", 53, Rarity.RARE, mage.cards.c.ChampionOfWits.class));
        cards.add(new SetCardInfo("Chandra's Defeat", 147, Rarity.UNCOMMON, mage.cards.c.ChandrasDefeat.class));
        cards.add(new SetCardInfo("Chandra, Pyromaster", 146, Rarity.MYTHIC, mage.cards.c.ChandraPyromaster.class));
        cards.add(new SetCardInfo("Claim // Fame", 229, Rarity.UNCOMMON, mage.cards.c.ClaimFame.class));
        cards.add(new SetCardInfo("Collected Company", 186, Rarity.RARE, mage.cards.c.CollectedCompany.class));
        cards.add(new SetCardInfo("Combat Celebrant", 148, Rarity.MYTHIC, mage.cards.c.CombatCelebrant.class));
        cards.add(new SetCardInfo("Commit // Memory", 54, Rarity.RARE, mage.cards.c.CommitMemory.class));
        cards.add(new SetCardInfo("Compelling Argument", 55, Rarity.COMMON, mage.cards.c.CompellingArgument.class));
        cards.add(new SetCardInfo("Compulsory Rest", 10, Rarity.COMMON, mage.cards.c.CompulsoryRest.class));
        cards.add(new SetCardInfo("Consign // Oblivion", 230, Rarity.UNCOMMON, mage.cards.c.ConsignOblivion.class));
        cards.add(new SetCardInfo("Countervailing Winds", 56, Rarity.COMMON, mage.cards.c.CountervailingWinds.class));
        cards.add(new SetCardInfo("Crash Through", 149, Rarity.COMMON, mage.cards.c.CrashThrough.class));
        cards.add(new SetCardInfo("Crested Sunmare", 11, Rarity.MYTHIC, mage.cards.c.CrestedSunmare.class));
        cards.add(new SetCardInfo("Crocodile of the Crossing", 187, Rarity.UNCOMMON, mage.cards.c.CrocodileOfTheCrossing.class));
        cards.add(new SetCardInfo("Cruel Reality", 98, Rarity.MYTHIC, mage.cards.c.CruelReality.class));
        cards.add(new SetCardInfo("Crypt of the Eternals", 286, Rarity.UNCOMMON, mage.cards.c.CryptOfTheEternals.class));
        cards.add(new SetCardInfo("Cryptic Serpent", 57, Rarity.UNCOMMON, mage.cards.c.CrypticSerpent.class));
        cards.add(new SetCardInfo("Curator of Mysteries", 58, Rarity.RARE, mage.cards.c.CuratorOfMysteries.class));
        cards.add(new SetCardInfo("Cut // Ribbons", 231, Rarity.RARE, mage.cards.c.CutRibbons.class));
        cards.add(new SetCardInfo("Dauntless Aven", 12, Rarity.COMMON, mage.cards.d.DauntlessAven.class));
        cards.add(new SetCardInfo("Deem Worthy", 150, Rarity.UNCOMMON, mage.cards.d.DeemWorthy.class));
        cards.add(new SetCardInfo("Defiant Greatmaw", 188, Rarity.UNCOMMON, mage.cards.d.DefiantGreatmaw.class));
        cards.add(new SetCardInfo("Demonic Pact", 99, Rarity.MYTHIC, mage.cards.d.DemonicPact.class));
        cards.add(new SetCardInfo("Desert Cerodon", 151, Rarity.COMMON, mage.cards.d.DesertCerodon.class));
        cards.add(new SetCardInfo("Desert of the Fervent", 287, Rarity.COMMON, mage.cards.d.DesertOfTheFervent.class));
        cards.add(new SetCardInfo("Desert of the Glorified", 288, Rarity.COMMON, mage.cards.d.DesertOfTheGlorified.class));
        cards.add(new SetCardInfo("Desert of the Indomitable", 289, Rarity.COMMON, mage.cards.d.DesertOfTheIndomitable.class));
        cards.add(new SetCardInfo("Desert of the Mindful", 290, Rarity.COMMON, mage.cards.d.DesertOfTheMindful.class));
        cards.add(new SetCardInfo("Desert of the True", 291, Rarity.COMMON, mage.cards.d.DesertOfTheTrue.class));
        cards.add(new SetCardInfo("Desert's Hold", 13, Rarity.UNCOMMON, mage.cards.d.DesertsHold.class));
        cards.add(new SetCardInfo("Destined // Lead", 232, Rarity.UNCOMMON, mage.cards.d.DestinedLead.class));
        cards.add(new SetCardInfo("Disposal Mummy", 14, Rarity.COMMON, mage.cards.d.DisposalMummy.class));
        cards.add(new SetCardInfo("Dispossess", 100, Rarity.RARE, mage.cards.d.Dispossess.class));
        cards.add(new SetCardInfo("Dissenter's Deliverance", 189, Rarity.COMMON, mage.cards.d.DissentersDeliverance.class));
        cards.add(new SetCardInfo("Djeru's Resolve", 15, Rarity.COMMON, mage.cards.d.DjerusResolve.class));
        cards.add(new SetCardInfo("Doomed Dissenter", 101, Rarity.COMMON, mage.cards.d.DoomedDissenter.class));
        cards.add(new SetCardInfo("Doomfall", 102, Rarity.UNCOMMON, mage.cards.d.Doomfall.class));
        cards.add(new SetCardInfo("Drake Haven", 59, Rarity.RARE, mage.cards.d.DrakeHaven.class));
        cards.add(new SetCardInfo("Dread Wanderer", 103, Rarity.RARE, mage.cards.d.DreadWanderer.class));
        cards.add(new SetCardInfo("Driven // Despair", 233, Rarity.RARE, mage.cards.d.DrivenDespair.class));
        cards.add(new SetCardInfo("Dune Beetle", 104, Rarity.COMMON, mage.cards.d.DuneBeetle.class));
        cards.add(new SetCardInfo("Dusk // Dawn", 16, Rarity.RARE, mage.cards.d.DuskDawn.class));
        cards.add(new SetCardInfo("Earthshaker Khenra", 152, Rarity.RARE, mage.cards.e.EarthshakerKhenra.class));
        cards.add(new SetCardInfo("Edifice of Authority", 270, Rarity.UNCOMMON, mage.cards.e.EdificeOfAuthority.class));
        cards.add(new SetCardInfo("Enigma Drake", 234, Rarity.UNCOMMON, mage.cards.e.EnigmaDrake.class));
        cards.add(new SetCardInfo("Essence Scatter", 60, Rarity.COMMON, mage.cards.e.EssenceScatter.class));
        cards.add(new SetCardInfo("Eternal of Harsh Truths", 61, Rarity.UNCOMMON, mage.cards.e.EternalOfHarshTruths.class));
        cards.add(new SetCardInfo("Evolving Wilds", 292, Rarity.COMMON, mage.cards.e.EvolvingWilds.class));
        cards.add(new SetCardInfo("Exemplar of Strength", 190, Rarity.UNCOMMON, mage.cards.e.ExemplarOfStrength.class));
        cards.add(new SetCardInfo("Failure // Comply", 235, Rarity.RARE, mage.cards.f.FailureComply.class));
        cards.add(new SetCardInfo("Fan Bearer", 17, Rarity.COMMON, mage.cards.f.FanBearer.class));
        cards.add(new SetCardInfo("Farm // Market", 236, Rarity.UNCOMMON, mage.cards.f.FarmMarket.class));
        cards.add(new SetCardInfo("Feral Prowler", 191, Rarity.COMMON, mage.cards.f.FeralProwler.class));
        cards.add(new SetCardInfo("Fervent Paincaster", 153, Rarity.UNCOMMON, mage.cards.f.FerventPaincaster.class));
        cards.add(new SetCardInfo("Festering Mummy", 105, Rarity.COMMON, mage.cards.f.FesteringMummy.class));
        cards.add(new SetCardInfo("Fetid Pools", 293, Rarity.RARE, mage.cards.f.FetidPools.class));
        cards.add(new SetCardInfo("Final Reward", 106, Rarity.COMMON, mage.cards.f.FinalReward.class));
        cards.add(new SetCardInfo("Firebrand Archer", 154, Rarity.COMMON, mage.cards.f.FirebrandArcher.class));
        cards.add(new SetCardInfo("Floodwaters", 62, Rarity.COMMON, mage.cards.f.Floodwaters.class));
        cards.add(new SetCardInfo("Forest", 294, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 295, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 296, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 297, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 298, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 299, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 300, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forsake the Worldly", 18, Rarity.COMMON, mage.cards.f.ForsakeTheWorldly.class));
        cards.add(new SetCardInfo("Gate to the Afterlife", 271, Rarity.UNCOMMON, mage.cards.g.GateToTheAfterlife.class));
        cards.add(new SetCardInfo("Gideon of the Trials", 19, Rarity.MYTHIC, mage.cards.g.GideonOfTheTrials.class));
        cards.add(new SetCardInfo("Gideon's Intervention", 20, Rarity.RARE, mage.cards.g.GideonsIntervention.class));
        cards.add(new SetCardInfo("Gilded Cerodon", 155, Rarity.COMMON, mage.cards.g.GildedCerodon.class));
        cards.add(new SetCardInfo("Glorious End", 156, Rarity.MYTHIC, mage.cards.g.GloriousEnd.class));
        cards.add(new SetCardInfo("Glory-Bound Initiate", 21, Rarity.RARE, mage.cards.g.GloryBoundInitiate.class));
        cards.add(new SetCardInfo("Glorybringer", 157, Rarity.RARE, mage.cards.g.Glorybringer.class));
        cards.add(new SetCardInfo("God-Pharaoh's Gift", 272, Rarity.RARE, mage.cards.g.GodPharaohsGift.class));
        cards.add(new SetCardInfo("Gravedigger", 107, Rarity.UNCOMMON, mage.cards.g.Gravedigger.class));
        cards.add(new SetCardInfo("Greater Sandwurm", 192, Rarity.COMMON, mage.cards.g.GreaterSandwurm.class));
        cards.add(new SetCardInfo("Grind // Dust", 237, Rarity.RARE, mage.cards.g.GrindDust.class));
        cards.add(new SetCardInfo("Gust Walker", 22, Rarity.COMMON, mage.cards.g.GustWalker.class));
        cards.add(new SetCardInfo("Hapatra, Vizier of Poisons", 238, Rarity.RARE, mage.cards.h.HapatraVizierOfPoisons.class));
        cards.add(new SetCardInfo("Harsh Mentor", 158, Rarity.RARE, mage.cards.h.HarshMentor.class));
        cards.add(new SetCardInfo("Hashep Oasis", 301, Rarity.UNCOMMON, mage.cards.h.HashepOasis.class));
        cards.add(new SetCardInfo("Haze of Pollen", 193, Rarity.COMMON, mage.cards.h.HazeOfPollen.class));
        cards.add(new SetCardInfo("Hazoret the Fervent", 159, Rarity.MYTHIC, mage.cards.h.HazoretTheFervent.class));
        cards.add(new SetCardInfo("Hazoret's Monument", 273, Rarity.UNCOMMON, mage.cards.h.HazoretsMonument.class));
        cards.add(new SetCardInfo("Heaven // Earth", 239, Rarity.RARE, mage.cards.h.HeavenEarth.class));
        cards.add(new SetCardInfo("Hekma Sentinels", 63, Rarity.COMMON, mage.cards.h.HekmaSentinels.class));
        cards.add(new SetCardInfo("Hieroglyphic Illumination", 64, Rarity.COMMON, mage.cards.h.HieroglyphicIllumination.class));
        cards.add(new SetCardInfo("Hollow One", 274, Rarity.RARE, mage.cards.h.HollowOne.class));
        cards.add(new SetCardInfo("Honored Crop-Captain", 240, Rarity.UNCOMMON, mage.cards.h.HonoredCropCaptain.class));
        cards.add(new SetCardInfo("Hooded Brawler", 194, Rarity.COMMON, mage.cards.h.HoodedBrawler.class));
        cards.add(new SetCardInfo("Hope Tender", 195, Rarity.UNCOMMON, mage.cards.h.HopeTender.class));
        cards.add(new SetCardInfo("Hornet Queen", 196, Rarity.MYTHIC, mage.cards.h.HornetQueen.class));
        cards.add(new SetCardInfo("Horror of the Broken Lands", 108, Rarity.COMMON, mage.cards.h.HorrorOfTheBrokenLands.class));
        cards.add(new SetCardInfo("Hour of Devastation", 160, Rarity.RARE, mage.cards.h.HourOfDevastation.class));
        cards.add(new SetCardInfo("Hour of Promise", 197, Rarity.RARE, mage.cards.h.HourOfPromise.class));
        cards.add(new SetCardInfo("Hour of Revelation", 23, Rarity.RARE, mage.cards.h.HourOfRevelation.class));
        cards.add(new SetCardInfo("Ifnir Deadlands", 302, Rarity.UNCOMMON, mage.cards.i.IfnirDeadlands.class));
        cards.add(new SetCardInfo("Imminent Doom", 161, Rarity.RARE, mage.cards.i.ImminentDoom.class));
        cards.add(new SetCardInfo("Impeccable Timing", 24, Rarity.COMMON, mage.cards.i.ImpeccableTiming.class));
        cards.add(new SetCardInfo("In Oketra's Name", 25, Rarity.COMMON, mage.cards.i.InOketrasName.class));
        cards.add(new SetCardInfo("Initiate's Companion", 198, Rarity.COMMON, mage.cards.i.InitiatesCompanion.class));
        cards.add(new SetCardInfo("Insult // Injury", 162, Rarity.RARE, mage.cards.i.InsultInjury.class));
        cards.add(new SetCardInfo("Ipnu Rivulet", 303, Rarity.UNCOMMON, mage.cards.i.IpnuRivulet.class));
        cards.add(new SetCardInfo("Irrigated Farmland", 304, Rarity.RARE, mage.cards.i.IrrigatedFarmland.class));
        cards.add(new SetCardInfo("Island", 305, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 306, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 307, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 308, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 309, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 310, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 311, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Jace, Unraveler of Secrets", 65, Rarity.MYTHIC, mage.cards.j.JaceUnravelerOfSecrets.class));
        cards.add(new SetCardInfo("Kefnet the Mindful", 66, Rarity.MYTHIC, mage.cards.k.KefnetTheMindful.class));
        cards.add(new SetCardInfo("Kefnet's Monument", 275, Rarity.UNCOMMON, mage.cards.k.KefnetsMonument.class));
        cards.add(new SetCardInfo("Khenra Charioteer", 241, Rarity.UNCOMMON, mage.cards.k.KhenraCharioteer.class));
        cards.add(new SetCardInfo("Khenra Eternal", 109, Rarity.COMMON, mage.cards.k.KhenraEternal.class));
        cards.add(new SetCardInfo("Khenra Scrapper", 163, Rarity.COMMON, mage.cards.k.KhenraScrapper.class));
        cards.add(new SetCardInfo("Labyrinth Guardian", 67, Rarity.UNCOMMON, mage.cards.l.LabyrinthGuardian.class));
        cards.add(new SetCardInfo("Lay Claim", 68, Rarity.UNCOMMON, mage.cards.l.LayClaim.class));
        cards.add(new SetCardInfo("Leave // Chance", 242, Rarity.RARE, mage.cards.l.LeaveChance.class));
        cards.add(new SetCardInfo("Lethal Sting", 110, Rarity.COMMON, mage.cards.l.LethalSting.class));
        cards.add(new SetCardInfo("Life Goes On", 199, Rarity.COMMON, mage.cards.l.LifeGoesOn.class));
        cards.add(new SetCardInfo("Liliana's Defeat", 112, Rarity.UNCOMMON, mage.cards.l.LilianasDefeat.class));
        cards.add(new SetCardInfo("Liliana's Mastery", 113, Rarity.RARE, mage.cards.l.LilianasMastery.class));
        cards.add(new SetCardInfo("Liliana, Death's Majesty", 111, Rarity.MYTHIC, mage.cards.l.LilianaDeathsMajesty.class));
        cards.add(new SetCardInfo("Lord of Extinction", 244, Rarity.RARE, mage.cards.l.LordOfExtinction.class));
        cards.add(new SetCardInfo("Lord of the Accursed", 114, Rarity.UNCOMMON, mage.cards.l.LordOfTheAccursed.class));
        cards.add(new SetCardInfo("Magma Spray", 164, Rarity.COMMON, mage.cards.m.MagmaSpray.class));
        cards.add(new SetCardInfo("Magmaroth", 165, Rarity.UNCOMMON, mage.cards.m.Magmaroth.class));
        cards.add(new SetCardInfo("Majestic Myriarch", 200, Rarity.MYTHIC, mage.cards.m.MajesticMyriarch.class));
        cards.add(new SetCardInfo("Manglehorn", 201, Rarity.UNCOMMON, mage.cards.m.Manglehorn.class));
        cards.add(new SetCardInfo("Marauding Boneslasher", 115, Rarity.COMMON, mage.cards.m.MaraudingBoneslasher.class));
        cards.add(new SetCardInfo("Merciless Javelineer", 245, Rarity.UNCOMMON, mage.cards.m.MercilessJavelineer.class));
        cards.add(new SetCardInfo("Miasmic Mummy", 116, Rarity.COMMON, mage.cards.m.MiasmicMummy.class));
        cards.add(new SetCardInfo("Mighty Leap", 26, Rarity.COMMON, mage.cards.m.MightyLeap.class));
        cards.add(new SetCardInfo("Mirage Mirror", 276, Rarity.RARE, mage.cards.m.MirageMirror.class));
        cards.add(new SetCardInfo("Mountain", 312, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 313, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 314, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 315, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 316, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 317, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 318, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mouth // Feed", 202, Rarity.RARE, mage.cards.m.MouthFeed.class));
        cards.add(new SetCardInfo("Naga Oracle", 69, Rarity.COMMON, mage.cards.n.NagaOracle.class));
        cards.add(new SetCardInfo("Naga Vitalist", 203, Rarity.COMMON, mage.cards.n.NagaVitalist.class));
        cards.add(new SetCardInfo("Nef-Crop Entangler", 166, Rarity.COMMON, mage.cards.n.NefCropEntangler.class));
        cards.add(new SetCardInfo("Neheb, the Eternal", 167, Rarity.MYTHIC, mage.cards.n.NehebTheEternal.class));
        cards.add(new SetCardInfo("Neheb, the Worthy", 246, Rarity.RARE, mage.cards.n.NehebTheWorthy.class));
        cards.add(new SetCardInfo("Nest of Scarabs", 117, Rarity.UNCOMMON, mage.cards.n.NestOfScarabs.class));
        cards.add(new SetCardInfo("Never // Return", 118, Rarity.RARE, mage.cards.n.NeverReturn.class));
        cards.add(new SetCardInfo("New Perspectives", 70, Rarity.RARE, mage.cards.n.NewPerspectives.class));
        cards.add(new SetCardInfo("Nicol Bolas, God-Pharaoh", 247, Rarity.MYTHIC, mage.cards.n.NicolBolasGodPharaoh.class));
        cards.add(new SetCardInfo("Nimble Obstructionist", 71, Rarity.RARE, mage.cards.n.NimbleObstructionist.class));
        cards.add(new SetCardInfo("Nimble-Blade Khenra", 168, Rarity.COMMON, mage.cards.n.NimbleBladeKhenra.class));
        cards.add(new SetCardInfo("Nissa, Steward of Elements", 248, Rarity.MYTHIC, mage.cards.n.NissaStewardOfElements.class));
        cards.add(new SetCardInfo("Oashra Cultivator", 204, Rarity.COMMON, mage.cards.o.OashraCultivator.class));
        cards.add(new SetCardInfo("Oasis Ritualist", 205, Rarity.COMMON, mage.cards.o.OasisRitualist.class));
        cards.add(new SetCardInfo("Obelisk Spider", 249, Rarity.UNCOMMON, mage.cards.o.ObeliskSpider.class));
        cards.add(new SetCardInfo("Oketra the True", 27, Rarity.MYTHIC, mage.cards.o.OketraTheTrue.class));
        cards.add(new SetCardInfo("Oketra's Attendant", 28, Rarity.UNCOMMON, mage.cards.o.OketrasAttendant.class));
        cards.add(new SetCardInfo("Oketra's Avenger", 29, Rarity.COMMON, mage.cards.o.OketrasAvenger.class));
        cards.add(new SetCardInfo("Oketra's Monument", 277, Rarity.UNCOMMON, mage.cards.o.OketrasMonument.class));
        cards.add(new SetCardInfo("Ominous Sphinx", 72, Rarity.UNCOMMON, mage.cards.o.OminousSphinx.class));
        cards.add(new SetCardInfo("Onward // Victory", 250, Rarity.UNCOMMON, mage.cards.o.OnwardVictory.class));
        cards.add(new SetCardInfo("Open Fire", 169, Rarity.COMMON, mage.cards.o.OpenFire.class));
        cards.add(new SetCardInfo("Ornery Kudu", 206, Rarity.COMMON, mage.cards.o.OrneryKudu.class));
        cards.add(new SetCardInfo("Overwhelming Splendor", 30, Rarity.MYTHIC, mage.cards.o.OverwhelmingSplendor.class));
        cards.add(new SetCardInfo("Pact of Negation", 73, Rarity.RARE, mage.cards.p.PactOfNegation.class));
        cards.add(new SetCardInfo("Pathmaker Initiate", 170, Rarity.COMMON, mage.cards.p.PathmakerInitiate.class));
        cards.add(new SetCardInfo("Perilous Vault", 278, Rarity.RARE, mage.cards.p.PerilousVault.class));
        cards.add(new SetCardInfo("Pitiless Vizier", 119, Rarity.COMMON, mage.cards.p.PitilessVizier.class));
        cards.add(new SetCardInfo("Plains", 319, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 320, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 321, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 322, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 323, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 324, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 325, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Pouncing Cheetah", 207, Rarity.COMMON, mage.cards.p.PouncingCheetah.class));
        cards.add(new SetCardInfo("Prepare // Fight", 251, Rarity.RARE, mage.cards.p.PrepareFight.class));
        cards.add(new SetCardInfo("Pride Sovereign", 208, Rarity.RARE, mage.cards.p.PrideSovereign.class));
        cards.add(new SetCardInfo("Protection of the Hekma", 31, Rarity.UNCOMMON, mage.cards.p.ProtectionOfTheHekma.class));
        cards.add(new SetCardInfo("Prowling Serpopard", 209, Rarity.RARE, mage.cards.p.ProwlingSerpopard.class));
        cards.add(new SetCardInfo("Pull from Tomorrow", 74, Rarity.RARE, mage.cards.p.PullFromTomorrow.class));
        cards.add(new SetCardInfo("Puncturing Blow", 171, Rarity.COMMON, mage.cards.p.PuncturingBlow.class));
        cards.add(new SetCardInfo("Pursue Glory", 172, Rarity.COMMON, mage.cards.p.PursueGlory.class));
        cards.add(new SetCardInfo("Quarry Hauler", 210, Rarity.COMMON, mage.cards.q.QuarryHauler.class));
        cards.add(new SetCardInfo("Rags // Riches", 252, Rarity.RARE, mage.cards.r.RagsRiches.class));
        cards.add(new SetCardInfo("Ramunap Excavator", 211, Rarity.RARE, mage.cards.r.RamunapExcavator.class));
        cards.add(new SetCardInfo("Ramunap Ruins", 326, Rarity.UNCOMMON, mage.cards.r.RamunapRuins.class));
        cards.add(new SetCardInfo("Razaketh, the Foulblooded", 120, Rarity.MYTHIC, mage.cards.r.RazakethTheFoulblooded.class));
        cards.add(new SetCardInfo("Reason // Believe", 253, Rarity.RARE, mage.cards.r.ReasonBelieve.class));
        cards.add(new SetCardInfo("Reduce // Rubble", 254, Rarity.UNCOMMON, mage.cards.r.ReduceRubble.class));
        cards.add(new SetCardInfo("Refuse // Cooperate", 255, Rarity.RARE, mage.cards.r.RefuseCooperate.class));
        cards.add(new SetCardInfo("Regal Caracal", 339, Rarity.RARE, mage.cards.r.RegalCaracal.class));
        cards.add(new SetCardInfo("Renewed Faith", 32, Rarity.UNCOMMON, mage.cards.r.RenewedFaith.class));
        cards.add(new SetCardInfo("Resilient Khenra", 212, Rarity.RARE, mage.cards.r.ResilientKhenra.class));
        cards.add(new SetCardInfo("Rest in Peace", 33, Rarity.RARE, mage.cards.r.RestInPeace.class));
        cards.add(new SetCardInfo("Rhonas the Indomitable", 213, Rarity.MYTHIC, mage.cards.r.RhonasTheIndomitable.class));
        cards.add(new SetCardInfo("Rhonas's Monument", 279, Rarity.UNCOMMON, mage.cards.r.RhonassMonument.class));
        cards.add(new SetCardInfo("Rhonas's Stalwart", 214, Rarity.COMMON, mage.cards.r.RhonassStalwart.class));
        cards.add(new SetCardInfo("Riddleform", 75, Rarity.UNCOMMON, mage.cards.r.Riddleform.class));
        cards.add(new SetCardInfo("River Hoopoe", 256, Rarity.UNCOMMON, mage.cards.r.RiverHoopoe.class));
        cards.add(new SetCardInfo("Ruthless Sniper", 121, Rarity.UNCOMMON, mage.cards.r.RuthlessSniper.class));
        cards.add(new SetCardInfo("Sacred Cat", 34, Rarity.COMMON, mage.cards.s.SacredCat.class));
        cards.add(new SetCardInfo("Samut, the Tested", 257, Rarity.MYTHIC, mage.cards.s.SamutTheTested.class));
        cards.add(new SetCardInfo("Samut, Voice of Dissent", 258, Rarity.MYTHIC, mage.cards.s.SamutVoiceOfDissent.class));
        cards.add(new SetCardInfo("Sand Strangler", 173, Rarity.UNCOMMON, mage.cards.s.SandStrangler.class));
        cards.add(new SetCardInfo("Sandwurm Convergence", 215, Rarity.RARE, mage.cards.s.SandwurmConvergence.class));
        cards.add(new SetCardInfo("Scarab Feast", 122, Rarity.COMMON, mage.cards.s.ScarabFeast.class));
        cards.add(new SetCardInfo("Scattered Groves", 327, Rarity.RARE, mage.cards.s.ScatteredGroves.class));
        cards.add(new SetCardInfo("Scavenger Grounds", 328, Rarity.RARE, mage.cards.s.ScavengerGrounds.class));
        cards.add(new SetCardInfo("Seeker of Insight", 76, Rarity.COMMON, mage.cards.s.SeekerOfInsight.class));
        cards.add(new SetCardInfo("Seer of the Last Tomorrow", 77, Rarity.COMMON, mage.cards.s.SeerOfTheLastTomorrow.class));
        cards.add(new SetCardInfo("Shadow of the Grave", 123, Rarity.RARE, mage.cards.s.ShadowOfTheGrave.class));
        cards.add(new SetCardInfo("Shadowstorm Vizier", 261, Rarity.UNCOMMON, mage.cards.s.ShadowstormVizier.class));
        cards.add(new SetCardInfo("Shatterstorm", 174, Rarity.RARE, mage.cards.s.Shatterstorm.class));
        cards.add(new SetCardInfo("Shed Weakness", 216, Rarity.COMMON, mage.cards.s.ShedWeakness.class));
        cards.add(new SetCardInfo("Shefet Dunes", 329, Rarity.UNCOMMON, mage.cards.s.ShefetDunes.class));
        cards.add(new SetCardInfo("Shefet Monitor", 217, Rarity.UNCOMMON, mage.cards.s.ShefetMonitor.class));
        cards.add(new SetCardInfo("Sheltered Thicket", 330, Rarity.RARE, mage.cards.s.ShelteredThicket.class));
        cards.add(new SetCardInfo("Shimmerscale Drake", 78, Rarity.COMMON, mage.cards.s.ShimmerscaleDrake.class));
        cards.add(new SetCardInfo("Sidewinder Naga", 218, Rarity.COMMON, mage.cards.s.SidewinderNaga.class));
        cards.add(new SetCardInfo("Sifter Wurm", 219, Rarity.UNCOMMON, mage.cards.s.SifterWurm.class));
        cards.add(new SetCardInfo("Sixth Sense", 220, Rarity.UNCOMMON, mage.cards.s.SixthSense.class));
        cards.add(new SetCardInfo("Slither Blade", 79, Rarity.COMMON, mage.cards.s.SlitherBlade.class));
        cards.add(new SetCardInfo("Solemnity", 35, Rarity.RARE, mage.cards.s.Solemnity.class));
        cards.add(new SetCardInfo("Solitary Camel", 36, Rarity.COMMON, mage.cards.s.SolitaryCamel.class));
        cards.add(new SetCardInfo("Soul-Scar Mage", 175, Rarity.RARE, mage.cards.s.SoulScarMage.class));
        cards.add(new SetCardInfo("Soulstinger", 124, Rarity.COMMON, mage.cards.s.Soulstinger.class));
        cards.add(new SetCardInfo("Spellweaver Eternal", 80, Rarity.COMMON, mage.cards.s.SpellweaverEternal.class));
        cards.add(new SetCardInfo("Sphinx's Revelation", 262, Rarity.MYTHIC, mage.cards.s.SphinxsRevelation.class));
        cards.add(new SetCardInfo("Splendid Agony", 125, Rarity.COMMON, mage.cards.s.SplendidAgony.class));
        cards.add(new SetCardInfo("Spring // Mind", 263, Rarity.UNCOMMON, mage.cards.s.SpringMind.class));
        cards.add(new SetCardInfo("Start // Finish", 264, Rarity.UNCOMMON, mage.cards.s.StartFinish.class));
        cards.add(new SetCardInfo("Steward of Solidarity", 37, Rarity.UNCOMMON, mage.cards.s.StewardOfSolidarity.class));
        cards.add(new SetCardInfo("Stinging Shot", 221, Rarity.COMMON, mage.cards.s.StingingShot.class));
        cards.add(new SetCardInfo("Strategic Planning", 81, Rarity.COMMON, mage.cards.s.StrategicPlanning.class));
        cards.add(new SetCardInfo("Striped Riverwinder", 82, Rarity.COMMON, mage.cards.s.StripedRiverwinder.class));
        cards.add(new SetCardInfo("Struggle // Survive", 265, Rarity.UNCOMMON, mage.cards.s.StruggleSurvive.class));
        cards.add(new SetCardInfo("Sunscorched Desert", 331, Rarity.COMMON, mage.cards.s.SunscorchedDesert.class));
        cards.add(new SetCardInfo("Sunscourge Champion", 38, Rarity.UNCOMMON, mage.cards.s.SunscourgeChampion.class));
        cards.add(new SetCardInfo("Sunset Pyramid", 280, Rarity.UNCOMMON, mage.cards.s.SunsetPyramid.class));
        cards.add(new SetCardInfo("Supernatural Stamina", 126, Rarity.COMMON, mage.cards.s.SupernaturalStamina.class));
        cards.add(new SetCardInfo("Supply Caravan", 39, Rarity.COMMON, mage.cards.s.SupplyCaravan.class));
        cards.add(new SetCardInfo("Supreme Will", 83, Rarity.UNCOMMON, mage.cards.s.SupremeWill.class));
        cards.add(new SetCardInfo("Swamp", 332, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 333, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 334, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 335, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 336, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 337, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 338, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sweltering Suns", 176, Rarity.RARE, mage.cards.s.SwelteringSuns.class));
        cards.add(new SetCardInfo("Synchronized Strike", 222, Rarity.UNCOMMON, mage.cards.s.SynchronizedStrike.class));
        cards.add(new SetCardInfo("Tah-Crop Elite", 40, Rarity.COMMON, mage.cards.t.TahCropElite.class));
        cards.add(new SetCardInfo("Temmet, Vizier of Naktamun", 266, Rarity.RARE, mage.cards.t.TemmetVizierOfNaktamun.class));
        cards.add(new SetCardInfo("The Locust God", 243, Rarity.MYTHIC, mage.cards.t.TheLocustGod.class));
        cards.add(new SetCardInfo("The Scarab God", 259, Rarity.MYTHIC, mage.cards.t.TheScarabGod.class));
        cards.add(new SetCardInfo("The Scorpion God", 260, Rarity.MYTHIC, mage.cards.t.TheScorpionGod.class));
        cards.add(new SetCardInfo("Thorned Moloch", 177, Rarity.COMMON, mage.cards.t.ThornedMoloch.class));
        cards.add(new SetCardInfo("Those Who Serve", 41, Rarity.COMMON, mage.cards.t.ThoseWhoServe.class));
        cards.add(new SetCardInfo("Thoughtseize", 127, Rarity.RARE, mage.cards.t.Thoughtseize.class));
        cards.add(new SetCardInfo("Thresher Lizard", 178, Rarity.COMMON, mage.cards.t.ThresherLizard.class));
        cards.add(new SetCardInfo("Throne of the God-Pharaoh", 281, Rarity.RARE, mage.cards.t.ThroneOfTheGodPharaoh.class));
        cards.add(new SetCardInfo("Torment of Hailfire", 128, Rarity.RARE, mage.cards.t.TormentOfHailfire.class));
        cards.add(new SetCardInfo("Tormenting Voice", 179, Rarity.COMMON, mage.cards.t.TormentingVoice.class));
        cards.add(new SetCardInfo("Trespasser's Curse", 129, Rarity.COMMON, mage.cards.t.TrespassersCurse.class));
        cards.add(new SetCardInfo("Trial of Ambition", 130, Rarity.UNCOMMON, mage.cards.t.TrialOfAmbition.class));
        cards.add(new SetCardInfo("Trial of Knowledge", 84, Rarity.UNCOMMON, mage.cards.t.TrialOfKnowledge.class));
        cards.add(new SetCardInfo("Trial of Solidarity", 42, Rarity.UNCOMMON, mage.cards.t.TrialOfSolidarity.class));
        cards.add(new SetCardInfo("Trial of Strength", 223, Rarity.UNCOMMON, mage.cards.t.TrialOfStrength.class));
        cards.add(new SetCardInfo("Trial of Zeal", 180, Rarity.UNCOMMON, mage.cards.t.TrialOfZeal.class));
        cards.add(new SetCardInfo("Unburden", 131, Rarity.COMMON, mage.cards.u.Unburden.class));
        cards.add(new SetCardInfo("Unconventional Tactics", 43, Rarity.UNCOMMON, mage.cards.u.UnconventionalTactics.class));
        cards.add(new SetCardInfo("Unesh, Criosphinx Sovereign", 85, Rarity.MYTHIC, mage.cards.u.UneshCriosphinxSovereign.class));
        cards.add(new SetCardInfo("Unquenchable Thirst", 86, Rarity.COMMON, mage.cards.u.UnquenchableThirst.class));
        cards.add(new SetCardInfo("Vile Manifestation", 132, Rarity.UNCOMMON, mage.cards.v.VileManifestation.class));
        cards.add(new SetCardInfo("Vizier of Deferment", 44, Rarity.UNCOMMON, mage.cards.v.VizierOfDeferment.class));
        cards.add(new SetCardInfo("Vizier of Many Faces", 87, Rarity.RARE, mage.cards.v.VizierOfManyFaces.class));
        cards.add(new SetCardInfo("Vizier of Remedies", 45, Rarity.UNCOMMON, mage.cards.v.VizierOfRemedies.class));
        cards.add(new SetCardInfo("Vizier of the Anointed", 88, Rarity.UNCOMMON, mage.cards.v.VizierOfTheAnointed.class));
        cards.add(new SetCardInfo("Vizier of the Menagerie", 224, Rarity.MYTHIC, mage.cards.v.VizierOfTheMenagerie.class));
        cards.add(new SetCardInfo("Vizier of Tumbling Sands", 89, Rarity.UNCOMMON, mage.cards.v.VizierOfTumblingSands.class));
        cards.add(new SetCardInfo("Wall of Forgotten Pharaohs", 282, Rarity.COMMON, mage.cards.w.WallOfForgottenPharaohs.class));
        cards.add(new SetCardInfo("Wander in Death", 133, Rarity.COMMON, mage.cards.w.WanderInDeath.class));
        cards.add(new SetCardInfo("Wasp of the Bitter End", 134, Rarity.UNCOMMON, mage.cards.w.WaspOfTheBitterEnd.class));
        cards.add(new SetCardInfo("Wasteland Scorpion", 135, Rarity.COMMON, mage.cards.w.WastelandScorpion.class));
        cards.add(new SetCardInfo("Watchers of the Dead", 283, Rarity.UNCOMMON, mage.cards.w.WatchersOfTheDead.class));
        cards.add(new SetCardInfo("Watchful Naga", 225, Rarity.UNCOMMON, mage.cards.w.WatchfulNaga.class));
        cards.add(new SetCardInfo("Wayward Servant", 267, Rarity.UNCOMMON, mage.cards.w.WaywardServant.class));
        cards.add(new SetCardInfo("Winds of Rebuke", 90, Rarity.COMMON, mage.cards.w.WindsOfRebuke.class));
        cards.add(new SetCardInfo("Wrath of God", 46, Rarity.RARE, mage.cards.w.WrathOfGod.class));
        cards.add(new SetCardInfo("Zealot of the God-Pharaoh", 181, Rarity.COMMON, mage.cards.z.ZealotOfTheGodPharaoh.class));
    }
}
