
package mage.cards.z;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.target.common.TargetAnyTarget;

/**
 *
 * @author LoneFox
 */
public final class ZuranSpellcaster extends CardImpl {

    public ZuranSpellcaster(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{U}");
        this.subtype.add(SubType.HUMAN, SubType.WIZARD);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // {T}: Zuran Spellcaster deals 1 damage to any target.
        SimpleActivatedAbility ability = new SimpleActivatedAbility(new DamageTargetEffect(1), new TapSourceCost());                                                                          ability.addTarget(new TargetAnyTarget());
        this.addAbility(ability);
    }

    private ZuranSpellcaster(final ZuranSpellcaster card) {
        super(card);
    }

    @Override
    public ZuranSpellcaster copy() {
        return new ZuranSpellcaster(this);
    }
}
