
package mage.cards.z;

import java.util.UUID;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.target.common.TargetControlledPermanent;

/**
 *
 * @author Plopman
 */
public final class ZuranOrb extends CardImpl {

    public ZuranOrb(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{0}");

        // Sacrifice a land: You gain 2 life.
        this.addAbility(new SimpleActivatedAbility(new GainLifeEffect(2), new SacrificeTargetCost(StaticFilters.FILTER_LAND)));
    }

    private ZuranOrb(final ZuranOrb card) {
        super(card);
    }

    @Override
    public ZuranOrb copy() {
        return new ZuranOrb(this);
    }
}
