
package mage.cards.y;

import java.util.UUID;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.SkipDrawStepEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;

/**
 *
 * @author emerald000
 */
public final class YawgmothsBargain extends CardImpl {

    public YawgmothsBargain(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{4}{B}{B}");


        // Skip your draw step.
        this.addAbility(new SimpleStaticAbility(new SkipDrawStepEffect())); 
         
        // Pay 1 life: Draw a card.
        this.addAbility(new SimpleActivatedAbility(new DrawCardSourceControllerEffect(1), new PayLifeCost(1)));
    }

    private YawgmothsBargain(final YawgmothsBargain card) {
        super(card);
    }

    @Override
    public YawgmothsBargain copy() {
        return new YawgmothsBargain(this);
    }
}
