
package mage.cards.w;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterCreatureCard;
import mage.target.common.TargetCardInYourGraveyard;

/**
 *
 * @author fireshoes
 */
public final class WoodwraithStrangler extends CardImpl {

    public WoodwraithStrangler(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{B}{G}");
        this.subtype.add(SubType.PLANT);
        this.subtype.add(SubType.ZOMBIE);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // Exile a creature card from your graveyard: Regenerate Woodwraith Strangler.
        this.addAbility(new SimpleActivatedAbility(new RegenerateSourceEffect(),
                new ExileFromGraveCost(new TargetCardInYourGraveyard(new FilterCreatureCard("a creature card from your graveyard")))));
    }

    private WoodwraithStrangler(final WoodwraithStrangler card) {
        super(card);
    }

    @Override
    public WoodwraithStrangler copy() {
        return new WoodwraithStrangler(this);
    }
}
